"use strict";

exports.__esModule = true;
exports.evaluate = void 0;
var _ramdaAdjunct = require("ramda-adjunct");
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-1");
var _apidomJsonPointer = require("@swagger-api/apidom-json-pointer");
var url = _interopRequireWildcard(require("../../../../../util/url.cjs"));
var _index = require("./errors/index.cjs");
exports.EvaluationJsonSchemaUriError = _index.EvaluationJsonSchemaUriError;
var _index2 = require("../$anchor/index.cjs");
var _util = require("../../../../../resolve/strategies/openapi-3-1/util.cjs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/**
 * Evaluates JSON Schema $ref containing unknown URI against ApiDOM fragment.
 */
const evaluate = (uri, element) => {
  const {
    cache
  } = evaluate;
  const uriStrippedHash = url.stripHash(uri);
  const isSchemaElementWith$id = e => (0, _apidomNsOpenapi.isSchemaElement)(e) && typeof e.$id !== 'undefined';

  // warm the cache
  if (!cache.has(element)) {
    const schemaObjectElements = (0, _apidomCore.filter)(isSchemaElementWith$id, element);
    cache.set(element, Array.from(schemaObjectElements));
  }

  // search for the matching schema
  const result = cache.get(element).find(e => {
    const $idBaseURI = (0, _util.resolveSchema$idField)(uriStrippedHash, e);
    return $idBaseURI === uriStrippedHash;
  });
  if ((0, _ramdaAdjunct.isUndefined)(result)) {
    throw new _index.EvaluationJsonSchemaUriError(`Evaluation failed on URI: "${uri}"`);
  }
  let fragmentEvaluate;
  let selector;
  if ((0, _index2.isAnchor)((0, _index2.uriToAnchor)(uri))) {
    // we're dealing with JSON Schema $anchor here
    fragmentEvaluate = _index2.evaluate;
    selector = (0, _index2.uriToAnchor)(uri);
  } else {
    // we're assuming here that we're dealing with JSON Pointer here
    fragmentEvaluate = _apidomJsonPointer.evaluate;
    selector = (0, _apidomJsonPointer.uriToPointer)(uri);
  }

  // @ts-ignore
  return fragmentEvaluate(selector, result);
};
exports.evaluate = evaluate;
evaluate.cache = new WeakMap();