"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _Resolver = _interopRequireDefault(require("./Resolver.cjs"));
var url = _interopRequireWildcard(require("../../util/url.cjs"));
var _NotImplementedError = _interopRequireDefault(require("../../util/errors/NotImplementedError.cjs"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const HttpResolver = (0, _stampit.default)(_Resolver.default, {
  props: {
    timeout: 5000,
    redirects: 5,
    withCredentials: false
  },
  init({
    timeout = this.timeout,
    redirects = this.redirects,
    withCredentials = this.withCredentials
  } = {}) {
    this.timeout = timeout;
    this.redirects = redirects;
    this.withCredentials = withCredentials;
  },
  methods: {
    canRead(file) {
      return url.isHttpUrl(file.uri);
    },
    async read() {
      throw new _NotImplementedError.default();
    },
    getHttpClient() {
      throw new _NotImplementedError.default();
    }
  }
});
var _default = HttpResolver;
exports.default = _default;