"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _fs = require("#fs");
var _util = require("#util");
var _stampit = _interopRequireDefault(require("stampit"));
var _minimatch = _interopRequireDefault(require("minimatch"));
var _Resolver = _interopRequireDefault(require("../Resolver.cjs"));
var url = _interopRequireWildcard(require("../../../util/url.cjs"));
var _index = require("../../../util/errors/index.cjs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// eslint-disable-line import/order
// eslint-disable-line import/order

const FileResolver = (0, _stampit.default)(_Resolver.default, {
  props: {
    name: 'file',
    fileAllowList: []
  },
  init({
    fileAllowList = this.fileAllowList
  }) {
    this.fileAllowList = fileAllowList;
  },
  methods: {
    canRead(file) {
      return url.isFileSystemPath(file.uri) && this.fileAllowList.some(pattern => {
        return typeof pattern === 'string' ? (0, _minimatch.default)(file.uri, pattern, {
          matchBase: true
        }) : pattern.test(file.uri);
      });
    },
    async read(file) {
      const fileSystemPath = url.toFileSystemPath(file.uri);
      try {
        return await (0, _util.promisify)(_fs.readFile)(fileSystemPath);
      } catch (error) {
        throw new _index.ResolverError(`Error opening file "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
var _default = FileResolver;
exports.default = _default;