import FileResolver from "../resolve/resolvers/file/index-node.js";
import HttpResolverAxios from "../resolve/resolvers/http-axios/index.js";
import OpenApi3_0ResolveStrategy from "../resolve/strategies/openapi-3-0/index.js";
import OpenApi3_1ResolveStrategy from "../resolve/strategies/openapi-3-1/index.js";
import AsyncApi2ResolveStrategy from "../resolve/strategies/asyncapi-2/index.js";
import ApiDesignSystemsJsonParser from "../parse/parsers/api-design-systems-json/index.js";
import ApiDesignSystemsYamlParser from "../parse/parsers/api-design-systems-yaml/index.js";
import OpenApiJson3_0Parser from "../parse/parsers/openapi-json-3-0/index.js";
import OpenApiYaml3_0Parser from "../parse/parsers/openapi-yaml-3-0/index.js";
import OpenApiJson3_1Parser from "../parse/parsers/openapi-json-3-1/index.js";
import OpenApiYaml3_1Parser from "../parse/parsers/openapi-yaml-3-1/index.js";
import AsyncApiJson2Parser from "../parse/parsers/asyncapi-json-2/index.js";
import AsyncApiYaml2Parser from "../parse/parsers/asyncapi-yaml-2/index.js";
import JsonParser from "../parse/parsers/json/index.js";
import YamlParser from "../parse/parsers/yaml-1-2/index.js";
import BinaryParser from "../parse/parsers/binary/index-node.js";
import OpenApi3_0DereferenceStrategy from "../dereference/strategies/openapi-3-0/index.js";
import OpenApi3_1DereferenceStrategy from "../dereference/strategies/openapi-3-1/index.js";
import AsyncApi2DereferenceStrategy from "../dereference/strategies/asyncapi-2/index.js";
import { options } from "../index.js";
options.parse.parsers = [OpenApiJson3_0Parser({
  allowEmpty: true,
  sourceMap: false
}), OpenApiYaml3_0Parser({
  allowEmpty: true,
  sourceMap: false
}), OpenApiJson3_1Parser({
  allowEmpty: true,
  sourceMap: false
}), OpenApiYaml3_1Parser({
  allowEmpty: true,
  sourceMap: false
}), AsyncApiJson2Parser({
  allowEmpty: true,
  sourceMap: false
}), AsyncApiYaml2Parser({
  allowEmpty: true,
  sourceMap: false
}), ApiDesignSystemsJsonParser({
  allowEmpty: true,
  sourceMap: false
}), ApiDesignSystemsYamlParser({
  allowEmpty: true,
  sourceMap: false
}), JsonParser({
  allowEmpty: true,
  sourceMap: false
}), YamlParser({
  allowEmpty: true,
  sourceMap: false
}), BinaryParser({
  allowEmpty: true
})];
options.resolve.resolvers = [FileResolver(), HttpResolverAxios({
  timeout: 5000,
  redirects: 5,
  withCredentials: false
})];
options.resolve.strategies = [OpenApi3_0ResolveStrategy(), OpenApi3_1ResolveStrategy(), AsyncApi2ResolveStrategy()];
options.dereference.strategies = [OpenApi3_0DereferenceStrategy(), OpenApi3_1DereferenceStrategy(), AsyncApi2DereferenceStrategy()];
export * from "../index.js";