import { trimCharsStart, isUndefined } from 'ramda-adjunct';
import { find } from '@swagger-api/apidom-core';
import { isSchemaElement } from '@swagger-api/apidom-ns-openapi-3-1';
import { getHash } from "../../../../../util/url.js";
import { EvaluationJsonSchema$anchorError, InvalidJsonSchema$anchorError } from "./errors/index.js"; // isAnchor :: String -> Boolean
export const isAnchor = uri => {
  /**
   *  MUST start with a letter ([A-Za-z]) or underscore ("_"), followed by any number of letters,
   *  digits ([0-9]), hyphens ("-"), underscores ("_"), and periods (".").
   *
   *  https://json-schema.org/draft/2020-12/json-schema-core.html#rfc.section.8.2.2
   */
  return /^[A-Za-z_][A-Za-z_0-9.-]*$/.test(uri);
};

// uriToAnchor :: String -> String
export const uriToAnchor = uri => {
  const hash = getHash(uri);
  return trimCharsStart('#', hash);
};

// parse :: String -> String
export const parse = anchor => {
  if (!isAnchor(anchor)) {
    throw new InvalidJsonSchema$anchorError(anchor);
  }
  return anchor;
};

// evaluates JSON Schema $anchor against ApiDOM fragment
export const evaluate = (anchor, element) => {
  const token = parse(anchor);

  // @ts-ignore
  const result = find(e => {
    var _e$$anchor;
    return isSchemaElement(e) && ((_e$$anchor = e.$anchor) === null || _e$$anchor === void 0 ? void 0 : _e$$anchor.toValue()) === token;
  }, element);
  if (isUndefined(result)) {
    throw new EvaluationJsonSchema$anchorError(`Evaluation failed on token: "${token}"`);
  }

  // @ts-ignore
  return result;
};
export { EvaluationJsonSchema$anchorError, InvalidJsonSchema$anchorError };