import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import { isEmpty } from 'ramda';
import * as url from "../util/url.js";
import File from "../util/File.js";
import * as plugins from "../util/plugins.js";
import { ParserError, UnmatchedResolverError } from "../util/errors/index.js";
import { readFile } from "../resolve/util.js";
/**
 * Parses the given file's contents, using the configured parser plugins.
 */
const parseFile = async (file, options) => {
  const optsBoundParsers = options.parse.parsers.map(parser => {
    const clonedParser = Object.create(parser);
    return Object.assign(clonedParser, options.parse.parserOpts);
  });
  const parsers = await plugins.filter('canParse', file, optsBoundParsers);

  // we couldn't find any parser for this File
  if (isEmpty(parsers)) {
    throw new UnmatchedResolverError(file.uri);
  }
  try {
    const {
      plugin,
      result
    } = await plugins.run('parse', [file], parsers);

    // empty files handling
    if (!plugin.allowEmpty && result.isEmpty) {
      return Promise.reject(new ParserError(`Error while parsing file "${file.uri}". File is empty.`));
    }
    return result;
  } catch (error) {
    throw new ParserError(`Error while parsing file "${file.uri}"`, {
      cause: error
    });
  }
};

/**
 * Parses a file into ApiDOM.
 */
const parse = async (uri, options) => {
  /**
   * If the path is a filesystem path, then convert it to a URL.
   *
   * NOTE: According to the JSON Reference spec, these should already be URLs,
   * but, in practice, many people use local filesystem paths instead.
   * So we're being generous here and doing the conversion automatically.
   * This is not intended to be a 100% bulletproof solution.
   * If it doesn't work for your use-case, then use a URL instead.
   */
  const file = File({
    uri: url.sanitize(url.stripHash(uri)),
    mediaType: options.parse.mediaType
  });
  const data = await readFile(file, options);
  return parseFile(File(_objectSpread(_objectSpread({}, file), {}, {
    data
  })), options);
};
export default parse;