import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import stampit from 'stampit';
import { omit, pathOr } from 'ramda';
import { ensureArray } from 'ramda-adjunct';
import axios from 'axios';
import ResolverError from "../../../util/errors/ResolverError.js";
import HttpResolver from "../HttpResolver.js";
const HttpResolverAxios = stampit(HttpResolver).init(function HttpResolverAxios() {
  /**
   * Private Api.
   */
  let axiosInstance;
  let oldAxiosConfig;

  /**
   * Public Api.
   */

  this.name = 'http-axios';
  this.axiosConfig = {};
  this.getHttpClient = function getHttpClient() {
    if (typeof axiosInstance === 'undefined' || oldAxiosConfig !== this.axiosConfig) {
      const config = omit(['interceptors'], this.axiosConfig);
      const interceptors = pathOr({
        request: [],
        response: []
      }, ['axiosConfig', 'interceptors'], this);
      axiosInstance = axios.create(_objectSpread({
        timeout: this.timeout,
        maxRedirects: this.redirects,
        withCredentials: this.withCredentials,
        responseType: 'arraybuffer'
      }, config));

      // settings up request interceptors
      if (Array.isArray(interceptors === null || interceptors === void 0 ? void 0 : interceptors.request)) {
        interceptors.request.forEach(requestInterceptor => {
          axiosInstance.interceptors.request.use(...ensureArray(requestInterceptor));
        });
      }

      // settings up response interceptors
      if (Array.isArray(interceptors === null || interceptors === void 0 ? void 0 : interceptors.response)) {
        interceptors.response.forEach(responseInterceptor => {
          axiosInstance.interceptors.response.use(...ensureArray(responseInterceptor));
        });
      }
      oldAxiosConfig = this.axiosConfig;
    }
    return axiosInstance;
  };
  this.read = async function read(file) {
    const client = this.getHttpClient();
    try {
      const response = await client.get(file.uri);
      return response.data;
    } catch (error) {
      throw new ResolverError(`Error downloading "${file.uri}"`, {
        cause: error
      });
    }
  };
});
export default HttpResolverAxios;