import { isEmpty } from 'ramda';
import * as plugins from "../util/plugins.js";
import { ResolverError, UnmatchedResolverError } from "../util/errors/index.js";
/**
 * Reads the given file, using the configured resolver plugins.
 */
// eslint-disable-next-line import/prefer-default-export
export const readFile = async (file, options) => {
  const optsBoundResolvers = options.resolve.resolvers.map(resolver => {
    const clonedResolver = Object.create(resolver);
    return Object.assign(clonedResolver, options.resolve.resolverOpts);
  });
  const resolvers = await plugins.filter('canRead', file, optsBoundResolvers);

  // we couldn't find any resolver for this File
  if (isEmpty(resolvers)) {
    throw new UnmatchedResolverError(file.uri);
  }
  try {
    const {
      result
    } = await plugins.run('read', [file], resolvers);
    return result;
  } catch (error) {
    throw new ResolverError(`Error while reading file "${file.uri}"`, {
      cause: error
    });
  }
};