/// <reference types="node" />
/// <reference types="@swagger-api/apidom-core/types/minim" />
import { ParseResultElement, Element } from '@swagger-api/apidom-core';
import stampit from 'stampit';
import { ApiDOMError, ApiDOMErrorOptions } from '@swagger-api/apidom-error';

interface File$1 {
    uri: string;
    mediaType: string;
    data: Buffer | DataView | ArrayBuffer | string;
    parseResult: ParseResultElement;
    readonly extension: string;
}
interface Resolver$1 {
    canRead(file: File$1): boolean;
    read(file: File$1): Promise<Buffer>;
}
interface HttpResolver$1 extends Resolver$1 {
    timeout: number;
    redirects: number;
    withCredentials: boolean;
    getHttpClient(): unknown;
}
interface Parser$1 {
    allowEmpty: boolean;
    sourceMap: boolean;
    fileExtensions: string[];
    mediaTypes: string[];
    decoder: TextDecoder;
    canParse(file: File$1): boolean | Promise<boolean>;
    parse(file: File$1): Promise<ParseResultElement>;
}
interface ResolveStrategy$1 {
    canResolve(file: File$1): boolean;
    resolve(file: File$1, options: ReferenceOptions): Promise<ReferenceSet$1>;
}
interface DereferenceStrategy$1 {
    canDereference(file: File$1): boolean;
    dereference(file: File$1, options: ReferenceOptions): Promise<Element>;
}
interface Reference$1 {
    uri: string;
    depth: number;
    value: ParseResultElement;
    refSet: null | ReferenceSet$1;
    errors: Array<Error>;
}
interface ReferenceSet$1 {
    rootRef: Reference$1;
    refs: Array<Reference$1>;
    circular: boolean;
    readonly size: number;
    add(reference: Reference$1): ReferenceSet$1;
    merge(anotherRefSet: ReferenceSet$1): ReferenceSet$1;
    has(uri: string): boolean;
    find(callback: (reference: Reference$1) => boolean): undefined | Reference$1;
    values(): IterableIterator<Reference$1>;
    clean(): void;
}
interface ReferenceParserOptions {
    mediaType: string;
    parsers: Array<Parser$1>;
    parserOpts: Record<string, any>;
}
interface ReferenceResolveOptions {
    baseURI: string;
    resolvers: Array<Resolver$1>;
    resolverOpts: Record<string, any>;
    strategies: Array<ResolveStrategy$1>;
    external: boolean;
    maxDepth: number;
}
interface ReferenceDereferenceOptions {
    strategies: Array<DereferenceStrategy$1>;
    refSet: null | ReferenceSet$1;
    maxDepth: number;
}
interface ReferenceOptions {
    readonly parse: ReferenceParserOptions;
    readonly resolve: ReferenceResolveOptions;
    readonly dereference: ReferenceDereferenceOptions;
}

/**
 * This stamp represents a File object with url and data.
 */
declare const File: stampit.Stamp<File$1>;

/**
 * SPDX-FileCopyrightText: Copyright (c) 2015 James Messinger
 *
 * SPDX-License-Identifier: MIT
 */
type WindowsPredicate = () => boolean;
/**
 * Returns the protocol of the given URL, or `undefined` if it has no protocol.
 */
declare const getProtocol: (url: string) => string | undefined;
/**
 * Returns true if given URL has protocol.
 */
declare const hasProtocol: (url: string) => boolean;
/**
 * Returns the lower-cased file extension of the given URL,
 * or an empty string if it has no extension.
 */
declare const getExtension: (url: string) => string;
/**
 * Determines whether the given path is a filesystem path.
 * This includes "file://" URLs.
 */
declare const isFileSystemPath: (uri: string) => boolean;
/**
 * Determines whether the given URI is an HTTP(S) URL.
 */
declare const isHttpUrl: (url: string) => boolean;
/**
 * Determines whether the given URI
 * @param uri
 */
declare const isURI: (uri: string) => boolean;
interface ToFileSystemPathOptions {
    keepFileProtocol?: boolean;
    isWindows?: WindowsPredicate;
}
/**
 * Converts a URL to a local filesystem path.
 */
declare const toFileSystemPath: (uri: string, options?: ToFileSystemPathOptions) => string;
/**
 * Converts a filesystem path to a properly-encoded URL.
 *
 * This is intended to handle situations where resolver is called
 * with a filesystem path that contains characters which are not allowed in URLs.
 *
 * @example
 * The following filesystem paths would be converted to the following URLs:
 *
 *    <"!@#$%^&*+=?'>.json              ==>   %3C%22!@%23$%25%5E&*+=%3F\'%3E.json
 *    C:\\My Documents\\File (1).json   ==>   C:/My%20Documents/File%20(1).json
 *    file://Project #42/file.json      ==>   file://Project%20%2342/file.json
 */
declare const fromFileSystemPath: (uri: string) => string;
/**
 * Returns the hash (URL fragment), of the given path.
 * If there is no hash, then the root hash ("#") is returned.
 */
declare const getHash: (uri: string) => string;
/**
 * Removes the hash (URL fragment), if any, from the given path.
 */
declare const stripHash: (uri: string) => string;
/**
 * Returns the current working directory (in Node) or the current page URL (in browsers).
 */
declare const cwd: () => string;
/**
 *  Resolves a target URI relative to a base URI in a manner similar to that of a Web browser resolving an anchor tag HREF.
 */
declare const resolve$1: (from: string, to: string) => string;
/**
 * Sanitizes/Encodes URI to it's url encoded form.
 *
 * The functional will compensate with the usecase when
 * already sanitized URI is passed to it,
 * by first unsatizing it and then performing sanitization again.
 */
declare const sanitize: (uri: string) => string;
/**
 * Unsanitizes/Decodes URI to it's url encoded form.
 * This function already assumes that hash part of the URI
 * has been removed prior to transforming it to it's sanitized form.
 */
declare const unsanitize: (uri: string) => string;

declare const url_d_getProtocol: typeof getProtocol;
declare const url_d_hasProtocol: typeof hasProtocol;
declare const url_d_getExtension: typeof getExtension;
declare const url_d_isFileSystemPath: typeof isFileSystemPath;
declare const url_d_isHttpUrl: typeof isHttpUrl;
declare const url_d_isURI: typeof isURI;
declare const url_d_toFileSystemPath: typeof toFileSystemPath;
declare const url_d_fromFileSystemPath: typeof fromFileSystemPath;
declare const url_d_getHash: typeof getHash;
declare const url_d_stripHash: typeof stripHash;
declare const url_d_cwd: typeof cwd;
declare const url_d_sanitize: typeof sanitize;
declare const url_d_unsanitize: typeof unsanitize;
declare namespace url_d {
  export {
    url_d_getProtocol as getProtocol,
    url_d_hasProtocol as hasProtocol,
    url_d_getExtension as getExtension,
    url_d_isFileSystemPath as isFileSystemPath,
    url_d_isHttpUrl as isHttpUrl,
    url_d_isURI as isURI,
    url_d_toFileSystemPath as toFileSystemPath,
    url_d_fromFileSystemPath as fromFileSystemPath,
    url_d_getHash as getHash,
    url_d_stripHash as stripHash,
    url_d_cwd as cwd,
    resolve$1 as resolve,
    url_d_sanitize as sanitize,
    url_d_unsanitize as unsanitize,
  };
}

declare const Parser: stampit.Stamp<Parser$1>;

declare const Resolver: stampit.Stamp<Resolver$1>;

declare const HttpResolver: stampit.Stamp<HttpResolver$1>;

declare const ResolveStrategy: stampit.Stamp<ResolveStrategy$1>;

declare const DereferenceStrategy: stampit.Stamp<DereferenceStrategy$1>;

declare const defaultOptions: ReferenceOptions;

declare const merge: (lObj: ReferenceOptions, rObj: Record<string, any>) => ReferenceOptions;

declare const Reference: stampit.Stamp<Reference$1>;

declare const ReferenceSet: stampit.Stamp<ReferenceSet$1>;

declare class NotImplementedError extends ApiDOMError {
    constructor(message?: string, options?: ApiDOMErrorOptions);
}

declare class ResolverError extends ApiDOMError {
}

declare class UnmatchedResolverError extends ResolverError {
}

declare class ParserError extends ApiDOMError {
}

declare class UnmatchedResolveStrategyError extends ParserError {
}

declare class PluginError extends ApiDOMError {
    plugin: any;
    constructor(message: string, options: {
        cause?: Error;
        plugin: any;
    });
}

declare class InvalidSelectorError extends ApiDOMError {
}

declare class MaximumResolverDepthError extends ResolverError {
}

declare class DereferenceError extends ApiDOMError {
}

declare class UnmatchedDereferenceStrategyError extends ParserError {
}

declare class MaximumDereferenceDepthError extends DereferenceError {
}

declare const readFile: (uri: string, options?: {}) => Promise<Buffer>;
declare const parse: (uri: string, options?: {}) => Promise<ParseResultElement>;
declare const resolve: (uri: string, options?: {}) => Promise<ReferenceSet$1>;
declare const resolveApiDOM: <T extends Element>(element: T, options?: {}) => Promise<ReferenceSet$1>;
declare const dereference: (uri: string, options?: {}) => Promise<ParseResultElement>;
declare const dereferenceApiDOM: <T extends Element>(element: T, options?: {}) => Promise<T>;

export { DereferenceError, DereferenceStrategy, File, HttpResolver, InvalidSelectorError, MaximumDereferenceDepthError, MaximumResolverDepthError, NotImplementedError, Parser, ParserError, PluginError, Reference, ReferenceSet, ResolveStrategy, Resolver, ResolverError, UnmatchedDereferenceStrategyError, UnmatchedResolveStrategyError, UnmatchedResolverError, dereference, dereferenceApiDOM, merge as mergeOptions, defaultOptions as options, parse, readFile, resolve, resolveApiDOM, url_d as url };
