import _Array$isArray from "@babel/runtime-corejs2/core-js/array/is-array";
import _typeof from "@babel/runtime-corejs2/helpers/typeof";
import _Object$keys from "@babel/runtime-corejs2/core-js/object/keys";
// This function runs after the common function,
// `src/execute/index.js#buildRequest`
import assign from 'lodash/assign';
import get from 'lodash/get';
import btoa from 'btoa';
export default function buildRequest(options, req) {
  var operation = options.operation,
      requestBody = options.requestBody,
      securities = options.securities,
      spec = options.spec,
      attachContentTypeForEmptyPayload = options.attachContentTypeForEmptyPayload;
  var requestContentType = options.requestContentType;
  req = applySecurities({
    request: req,
    securities: securities,
    operation: operation,
    spec: spec
  });
  var requestBodyDef = operation.requestBody || {};

  var requestBodyMediaTypes = _Object$keys(requestBodyDef.content || {});

  var isExplicitContentTypeValid = requestContentType && requestBodyMediaTypes.indexOf(requestContentType) > -1; // for OAS3: set the Content-Type

  if (requestBody || attachContentTypeForEmptyPayload) {
    // does the passed requestContentType appear in the requestBody definition?
    if (requestContentType && isExplicitContentTypeValid) {
      req.headers['Content-Type'] = requestContentType;
    } else if (!requestContentType) {
      var firstMediaType = requestBodyMediaTypes[0];

      if (firstMediaType) {
        req.headers['Content-Type'] = firstMediaType;
        requestContentType = firstMediaType;
      }
    }
  } else if (requestContentType && isExplicitContentTypeValid) {
    req.headers['Content-Type'] = requestContentType;
  } // for OAS3: add requestBody to request


  if (requestBody) {
    if (requestContentType) {
      if (requestBodyMediaTypes.indexOf(requestContentType) > -1) {
        // only attach body if the requestBody has a definition for the
        // contentType that has been explicitly set
        if (requestContentType === 'application/x-www-form-urlencoded' || requestContentType === 'multipart/form-data') {
          if (_typeof(requestBody) === 'object') {
            var encoding = (requestBodyDef.content[requestContentType] || {}).encoding || {};
            req.form = {};

            _Object$keys(requestBody).forEach(function (k) {
              req.form[k] = {
                value: requestBody[k],
                encoding: encoding[k] || {}
              };
            });
          } else {
            req.form = requestBody;
          }
        } else {
          req.body = requestBody;
        }
      }
    } else {
      req.body = requestBody;
    }
  }

  return req;
} // Add security values, to operations - that declare their need on them
// Adapted from the Swagger2 implementation

export function applySecurities(_ref) {
  var request = _ref.request,
      _ref$securities = _ref.securities,
      securities = _ref$securities === void 0 ? {} : _ref$securities,
      _ref$operation = _ref.operation,
      operation = _ref$operation === void 0 ? {} : _ref$operation,
      spec = _ref.spec;
  var result = assign({}, request);
  var _securities$authorize = securities.authorized,
      authorized = _securities$authorize === void 0 ? {} : _securities$authorize;
  var security = operation.security || spec.security || [];
  var isAuthorized = authorized && !!_Object$keys(authorized).length;
  var securityDef = get(spec, ['components', 'securitySchemes']) || {};
  result.headers = result.headers || {};
  result.query = result.query || {};

  if (!_Object$keys(securities).length || !isAuthorized || !security || _Array$isArray(operation.security) && !operation.security.length) {
    return request;
  }

  security.forEach(function (securityObj) {
    _Object$keys(securityObj).forEach(function (key) {
      var auth = authorized[key];
      var schema = securityDef[key];

      if (!auth) {
        return;
      }

      var value = auth.value || auth;
      var type = schema.type;

      if (auth) {
        if (type === 'apiKey') {
          if (schema.in === 'query') {
            result.query[schema.name] = value;
          }

          if (schema.in === 'header') {
            result.headers[schema.name] = value;
          }

          if (schema.in === 'cookie') {
            result.cookies[schema.name] = value;
          }
        } else if (type === 'http') {
          if (/^basic$/i.test(schema.scheme)) {
            var username = value.username || '';
            var password = value.password || '';
            var encoded = btoa("".concat(username, ":").concat(password));
            result.headers.Authorization = "Basic ".concat(encoded);
          }

          if (/^bearer$/i.test(schema.scheme)) {
            result.headers.Authorization = "Bearer ".concat(value);
          }
        } else if (type === 'oauth2') {
          var token = auth.token || {};
          var tokenName = schema['x-tokenName'] || 'access_token';
          var tokenValue = token[tokenName];
          var tokenType = token.token_type;

          if (!tokenType || tokenType.toLowerCase() === 'bearer') {
            tokenType = 'Bearer';
          }

          result.headers.Authorization = "".concat(tokenType, " ").concat(tokenValue);
        }
      }
    });
  });
  return result;
}