import _JSON$stringify from "@babel/runtime-corejs2/core-js/json/stringify";

/*
  Serializer that serializes according to a media type instead of OpenAPI's
  `style` + `explode` constructs.
*/
export default function serialize(value, mediaType) {
  if (mediaType.includes('application/json')) {
    if (typeof value === 'string') {
      // Assume the user has a JSON string
      return value;
    }

    return _JSON$stringify(value);
  }

  return value.toString();
}