import _Array$isArray from "@babel/runtime-corejs2/core-js/array/is-array";
import _typeof from "@babel/runtime-corejs2/helpers/typeof";
import _Object$keys from "@babel/runtime-corejs2/core-js/object/keys";
import pick from 'lodash/pick';
import stylize, { encodeDisallowedCharacters } from './style-serializer';
import serialize from './content-serializer';
export function path(_ref) {
  var req = _ref.req,
      value = _ref.value,
      parameter = _ref.parameter;
  var name = parameter.name,
      style = parameter.style,
      explode = parameter.explode,
      content = parameter.content;

  if (content) {
    var effectiveMediaType = _Object$keys(content)[0];

    req.url = req.url.split("{".concat(name, "}")).join(encodeDisallowedCharacters(serialize(value, effectiveMediaType), {
      escape: true
    }));
    return;
  }

  var styledValue = stylize({
    key: parameter.name,
    value: value,
    style: style || 'simple',
    explode: explode || false,
    escape: true
  });
  req.url = req.url.split("{".concat(name, "}")).join(styledValue);
}
export function query(_ref2) {
  var req = _ref2.req,
      value = _ref2.value,
      parameter = _ref2.parameter;
  req.query = req.query || {};

  if (parameter.content) {
    var effectiveMediaType = _Object$keys(parameter.content)[0];

    req.query[parameter.name] = serialize(value, effectiveMediaType);
    return;
  }

  if (value === false) {
    value = 'false';
  }

  if (value === 0) {
    value = '0';
  }

  if (value) {
    req.query[parameter.name] = {
      value: value,
      serializationOption: pick(parameter, ['style', 'explode', 'allowReserved'])
    };
  } else if (parameter.allowEmptyValue && value !== undefined) {
    var paramName = parameter.name;
    req.query[paramName] = req.query[paramName] || {};
    req.query[paramName].allowEmptyValue = true;
  }
}
var PARAMETER_HEADER_BLACKLIST = ['accept', 'authorization', 'content-type'];
export function header(_ref3) {
  var req = _ref3.req,
      parameter = _ref3.parameter,
      value = _ref3.value;
  req.headers = req.headers || {};

  if (PARAMETER_HEADER_BLACKLIST.indexOf(parameter.name.toLowerCase()) > -1) {
    return;
  }

  if (parameter.content) {
    var effectiveMediaType = _Object$keys(parameter.content)[0];

    req.headers[parameter.name] = serialize(value, effectiveMediaType);
    return;
  }

  if (typeof value !== 'undefined') {
    req.headers[parameter.name] = stylize({
      key: parameter.name,
      value: value,
      style: parameter.style || 'simple',
      explode: typeof parameter.explode === 'undefined' ? false : parameter.explode,
      escape: false
    });
  }
}
export function cookie(_ref4) {
  var req = _ref4.req,
      parameter = _ref4.parameter,
      value = _ref4.value;
  req.headers = req.headers || {};

  var type = _typeof(value);

  if (parameter.content) {
    var effectiveMediaType = _Object$keys(parameter.content)[0];

    req.headers.Cookie = "".concat(parameter.name, "=").concat(serialize(value, effectiveMediaType));
    return;
  }

  if (type !== 'undefined') {
    var prefix = type === 'object' && !_Array$isArray(value) && parameter.explode ? '' : "".concat(parameter.name, "=");
    req.headers.Cookie = prefix + stylize({
      key: parameter.name,
      value: value,
      escape: false,
      style: parameter.style || 'form',
      explode: typeof parameter.explode === 'undefined' ? false : parameter.explode
    });
  }
}