import _Object$keys from "@babel/runtime-corejs2/core-js/object/keys";
import _typeof from "@babel/runtime-corejs2/helpers/typeof";
import _Array$isArray from "@babel/runtime-corejs2/core-js/array/is-array";
import _toConsumableArray from "@babel/runtime-corejs2/helpers/toConsumableArray";

var _require = require('buffer'),
    Buffer = _require.Buffer;

var isRfc3986Reserved = function isRfc3986Reserved(char) {
  return ":/?#[]@!$&'()*+,;=".indexOf(char) > -1;
};

var isRrc3986Unreserved = function isRrc3986Unreserved(char) {
  return /^[a-z0-9\-._~]+$/i.test(char);
};

export function encodeDisallowedCharacters(str) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      escape = _ref.escape;

  var parse = arguments.length > 2 ? arguments[2] : undefined;

  if (typeof str === 'number') {
    str = str.toString();
  }

  if (typeof str !== 'string' || !str.length) {
    return str;
  }

  if (!escape) {
    return str;
  }

  if (parse) {
    return JSON.parse(str);
  } // In ES6 you can do this quite easily by using the new ... spread operator.
  // This causes the string iterator (another new ES6 feature) to be used internally,
  // and because that iterator is designed to deal with
  // code points rather than UCS-2/UTF-16 code units.


  return _toConsumableArray(str).map(function (char) {
    if (isRrc3986Unreserved(char)) {
      return char;
    }

    if (isRfc3986Reserved(char) && escape === 'unsafe') {
      return char;
    }

    var encoded = (Buffer.from(char).toJSON().data || []).map(function (byte) {
      return "0".concat(byte.toString(16).toUpperCase()).slice(-2);
    }).map(function (encodedByte) {
      return "%".concat(encodedByte);
    }).join('');
    return encoded;
  }).join('');
}
export default function stylize(config) {
  var value = config.value;

  if (_Array$isArray(value)) {
    return encodeArray(config);
  }

  if (_typeof(value) === 'object') {
    return encodeObject(config);
  }

  return encodePrimitive(config);
}

function encodeArray(_ref2) {
  var key = _ref2.key,
      value = _ref2.value,
      style = _ref2.style,
      explode = _ref2.explode,
      escape = _ref2.escape;

  var valueEncoder = function valueEncoder(str) {
    return encodeDisallowedCharacters(str, {
      escape: escape
    });
  };

  if (style === 'simple') {
    return value.map(function (val) {
      return valueEncoder(val);
    }).join(',');
  }

  if (style === 'label') {
    return ".".concat(value.map(function (val) {
      return valueEncoder(val);
    }).join('.'));
  }

  if (style === 'matrix') {
    return value.map(function (val) {
      return valueEncoder(val);
    }).reduce(function (prev, curr) {
      if (!prev || explode) {
        return "".concat(prev || '', ";").concat(key, "=").concat(curr);
      }

      return "".concat(prev, ",").concat(curr);
    }, '');
  }

  if (style === 'form') {
    var after = explode ? "&".concat(key, "=") : ',';
    return value.map(function (val) {
      return valueEncoder(val);
    }).join(after);
  }

  if (style === 'spaceDelimited') {
    var _after = explode ? "".concat(key, "=") : '';

    return value.map(function (val) {
      return valueEncoder(val);
    }).join(" ".concat(_after));
  }

  if (style === 'pipeDelimited') {
    var _after2 = explode ? "".concat(key, "=") : '';

    return value.map(function (val) {
      return valueEncoder(val);
    }).join("|".concat(_after2));
  }

  return undefined;
}

function encodeObject(_ref3) {
  var key = _ref3.key,
      value = _ref3.value,
      style = _ref3.style,
      explode = _ref3.explode,
      escape = _ref3.escape;

  var valueEncoder = function valueEncoder(str) {
    return encodeDisallowedCharacters(str, {
      escape: escape
    });
  };

  var valueKeys = _Object$keys(value);

  if (style === 'simple') {
    return valueKeys.reduce(function (prev, curr) {
      var val = valueEncoder(value[curr]);
      var middleChar = explode ? '=' : ',';
      var prefix = prev ? "".concat(prev, ",") : '';
      return "".concat(prefix).concat(curr).concat(middleChar).concat(val);
    }, '');
  }

  if (style === 'label') {
    return valueKeys.reduce(function (prev, curr) {
      var val = valueEncoder(value[curr]);
      var middleChar = explode ? '=' : '.';
      var prefix = prev ? "".concat(prev, ".") : '.';
      return "".concat(prefix).concat(curr).concat(middleChar).concat(val);
    }, '');
  }

  if (style === 'matrix' && explode) {
    return valueKeys.reduce(function (prev, curr) {
      var val = valueEncoder(value[curr]);
      var prefix = prev ? "".concat(prev, ";") : ';';
      return "".concat(prefix).concat(curr, "=").concat(val);
    }, '');
  }

  if (style === 'matrix') {
    // no explode
    return valueKeys.reduce(function (prev, curr) {
      var val = valueEncoder(value[curr]);
      var prefix = prev ? "".concat(prev, ",") : ";".concat(key, "=");
      return "".concat(prefix).concat(curr, ",").concat(val);
    }, '');
  }

  if (style === 'form') {
    return valueKeys.reduce(function (prev, curr) {
      var val = valueEncoder(value[curr]);
      var prefix = prev ? "".concat(prev).concat(explode ? '&' : ',') : '';
      var separator = explode ? '=' : ',';
      return "".concat(prefix).concat(curr).concat(separator).concat(val);
    }, '');
  }

  return undefined;
}

function encodePrimitive(_ref4) {
  var key = _ref4.key,
      value = _ref4.value,
      style = _ref4.style,
      escape = _ref4.escape;

  var valueEncoder = function valueEncoder(str) {
    return encodeDisallowedCharacters(str, {
      escape: escape
    });
  };

  if (style === 'simple') {
    return valueEncoder(value);
  }

  if (style === 'label') {
    return ".".concat(valueEncoder(value));
  }

  if (style === 'matrix') {
    return ";".concat(key, "=").concat(valueEncoder(value));
  }

  if (style === 'form') {
    return valueEncoder(value);
  }

  if (style === 'deepObject') {
    return valueEncoder(value, {}, true);
  }

  return undefined;
}