import _Object$keys from "@babel/runtime-corejs2/core-js/object/keys";
import _slicedToArray from "@babel/runtime-corejs2/helpers/slicedToArray";
import _Array$isArray from "@babel/runtime-corejs2/core-js/array/is-array";
import btoa from 'btoa';
import assign from 'lodash/assign'; // This function runs after the common function,
// `src/execute/index.js#buildRequest`

export default function buildRequest(options, req) {
  var spec = options.spec,
      operation = options.operation,
      securities = options.securities,
      requestContentType = options.requestContentType,
      attachContentTypeForEmptyPayload = options.attachContentTypeForEmptyPayload; // Add securities, which are applicable

  req = applySecurities({
    request: req,
    securities: securities,
    operation: operation,
    spec: spec
  });

  if (req.body || req.form || attachContentTypeForEmptyPayload) {
    // all following conditionals are Swagger2 only
    if (requestContentType) {
      req.headers['Content-Type'] = requestContentType;
    } else if (_Array$isArray(operation.consumes)) {
      var _operation$consumes = _slicedToArray(operation.consumes, 1);

      req.headers['Content-Type'] = _operation$consumes[0];
    } else if (_Array$isArray(spec.consumes)) {
      var _spec$consumes = _slicedToArray(spec.consumes, 1);

      req.headers['Content-Type'] = _spec$consumes[0];
    } else if (operation.parameters && operation.parameters.filter(function (p) {
      return p.type === 'file';
    }).length) {
      req.headers['Content-Type'] = 'multipart/form-data';
    } else if (operation.parameters && operation.parameters.filter(function (p) {
      return p.in === 'formData';
    }).length) {
      req.headers['Content-Type'] = 'application/x-www-form-urlencoded';
    }
  } else if (requestContentType) {
    var isBodyParamPresent = operation.parameters && operation.parameters.filter(function (p) {
      return p.in === 'body';
    }).length > 0;
    var isFormDataParamPresent = operation.parameters && operation.parameters.filter(function (p) {
      return p.in === 'formData';
    }).length > 0;

    if (isBodyParamPresent || isFormDataParamPresent) {
      req.headers['Content-Type'] = requestContentType;
    }
  }

  return req;
} // Add security values, to operations - that declare their need on them

export function applySecurities(_ref) {
  var request = _ref.request,
      _ref$securities = _ref.securities,
      securities = _ref$securities === void 0 ? {} : _ref$securities,
      _ref$operation = _ref.operation,
      operation = _ref$operation === void 0 ? {} : _ref$operation,
      spec = _ref.spec;
  var result = assign({}, request);
  var _securities$authorize = securities.authorized,
      authorized = _securities$authorize === void 0 ? {} : _securities$authorize,
      _securities$specSecur = securities.specSecurity,
      specSecurity = _securities$specSecur === void 0 ? [] : _securities$specSecur;
  var security = operation.security || specSecurity;
  var isAuthorized = authorized && !!_Object$keys(authorized).length;
  var securityDef = spec.securityDefinitions;
  result.headers = result.headers || {};
  result.query = result.query || {};

  if (!_Object$keys(securities).length || !isAuthorized || !security || _Array$isArray(operation.security) && !operation.security.length) {
    return request;
  }

  security.forEach(function (securityObj) {
    _Object$keys(securityObj).forEach(function (key) {
      var auth = authorized[key];

      if (!auth) {
        return;
      }

      var token = auth.token;
      var value = auth.value || auth;
      var schema = securityDef[key];
      var type = schema.type;
      var tokenName = schema['x-tokenName'] || 'access_token';
      var oauthToken = token && token[tokenName];
      var tokenType = token && token.token_type;

      if (auth) {
        if (type === 'apiKey') {
          var inType = schema.in === 'query' ? 'query' : 'headers';
          result[inType] = result[inType] || {};
          result[inType][schema.name] = value;
        } else if (type === 'basic') {
          if (value.header) {
            result.headers.authorization = value.header;
          } else {
            var username = value.username || '';
            var password = value.password || '';
            value.base64 = btoa("".concat(username, ":").concat(password));
            result.headers.authorization = "Basic ".concat(value.base64);
          }
        } else if (type === 'oauth2' && oauthToken) {
          tokenType = !tokenType || tokenType.toLowerCase() === 'bearer' ? 'Bearer' : tokenType;
          result.headers.authorization = "".concat(tokenType, " ").concat(oauthToken);
        }
      }
    });
  });
  return result;
}