import _createForOfIteratorHelper from "@babel/runtime-corejs2/helpers/createForOfIteratorHelper";
import _typeof from "@babel/runtime-corejs2/helpers/typeof";
import isObject from 'lodash/isObject';
import startsWith from 'lodash/startsWith';

var toLower = function toLower(str) {
  return String.prototype.toLowerCase.call(str);
};

var escapeString = function escapeString(str) {
  return str.replace(/[^\w]/gi, '_');
}; // Spec version detection


export function isOAS3(spec) {
  var oasVersion = spec.openapi;

  if (!oasVersion) {
    return false;
  }

  return startsWith(oasVersion, '3');
}
export function isSwagger2(spec) {
  var swaggerVersion = spec.swagger;

  if (!swaggerVersion) {
    return false;
  }

  return startsWith(swaggerVersion, '2');
} // Strategy for determining operationId

export function opId(operation, pathName) {
  var method = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

  var _ref = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {},
      v2OperationIdCompatibilityMode = _ref.v2OperationIdCompatibilityMode;

  if (!operation || _typeof(operation) !== 'object') {
    return null;
  }

  var idWithoutWhitespace = (operation.operationId || '').replace(/\s/g, '');

  if (idWithoutWhitespace.length) {
    return escapeString(operation.operationId);
  }

  return idFromPathMethod(pathName, method, {
    v2OperationIdCompatibilityMode: v2OperationIdCompatibilityMode
  });
} // Create a generated operationId from pathName + method

export function idFromPathMethod(pathName, method) {
  var _ref2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
      v2OperationIdCompatibilityMode = _ref2.v2OperationIdCompatibilityMode;

  if (v2OperationIdCompatibilityMode) {
    var res = "".concat(method.toLowerCase(), "_").concat(pathName).replace(/[\s!@#$%^&*()_+=[{\]};:<>|./?,\\'""-]/g, '_');
    res = res || "".concat(pathName.substring(1), "_").concat(method);
    return res.replace(/((_){2,})/g, '_').replace(/^(_)*/g, '').replace(/([_])*$/g, '');
  }

  return "".concat(toLower(method)).concat(escapeString(pathName));
}
export function legacyIdFromPathMethod(pathName, method) {
  return "".concat(toLower(method), "-").concat(pathName);
} // Get the operation, based on operationId ( just return the object, no inheritence )

export function getOperationRaw(spec, id) {
  if (!spec || !spec.paths) {
    return null;
  }

  return findOperation(spec, function (_ref3) {
    var pathName = _ref3.pathName,
        method = _ref3.method,
        operation = _ref3.operation;

    if (!operation || _typeof(operation) !== 'object') {
      return false;
    }

    var rawOperationId = operation.operationId; // straight from the source

    var operationId = opId(operation, pathName, method);
    var legacyOperationId = legacyIdFromPathMethod(pathName, method);
    return [operationId, legacyOperationId, rawOperationId].some(function (val) {
      return val && val === id;
    });
  });
} // Will stop iterating over the operations and return the operationObj
// as soon as predicate returns true

export function findOperation(spec, predicate) {
  return eachOperation(spec, predicate, true) || null;
} // iterate over each operation, and fire a callback with details
// `find=true` will stop iterating, when the cb returns truthy

export function eachOperation(spec, cb, find) {
  if (!spec || _typeof(spec) !== 'object' || !spec.paths || _typeof(spec.paths) !== 'object') {
    return null;
  }

  var paths = spec.paths; // Iterate over the spec, collecting operations
  // eslint-disable-next-line no-restricted-syntax, guard-for-in

  for (var pathName in paths) {
    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (var method in paths[pathName]) {
      if (method.toUpperCase() === 'PARAMETERS') {
        continue; // eslint-disable-line no-continue
      }

      var operation = paths[pathName][method];

      if (!operation || _typeof(operation) !== 'object') {
        continue; // eslint-disable-line no-continue
      }

      var operationObj = {
        spec: spec,
        pathName: pathName,
        method: method.toUpperCase(),
        operation: operation
      };
      var cbValue = cb(operationObj);

      if (find && cbValue) {
        return operationObj;
      }
    }
  }

  return undefined;
} // REVIEW: OAS3: identify normalization steps that need changes
// ...maybe create `normalizeOAS3`?

export function normalizeSwagger(parsedSpec) {
  var spec = parsedSpec.spec;
  var paths = spec.paths;
  var map = {};

  if (!paths || spec.$$normalized) {
    return parsedSpec;
  } // eslint-disable-next-line no-restricted-syntax, guard-for-in


  for (var pathName in paths) {
    var path = paths[pathName];

    if (!isObject(path)) {
      continue; // eslint-disable-line no-continue
    }

    var pathParameters = path.parameters; // eslint-disable-next-line no-restricted-syntax, guard-for-in

    var _loop = function _loop(method) {
      var operation = path[method];

      if (!isObject(operation)) {
        return "continue"; // eslint-disable-line no-continue
      }

      var oid = opId(operation, pathName, method);

      if (oid) {
        if (map[oid]) {
          map[oid].push(operation);
        } else {
          map[oid] = [operation];
        }

        var opList = map[oid];

        if (opList.length > 1) {
          opList.forEach(function (o, i) {
            // eslint-disable-next-line no-underscore-dangle
            o.__originalOperationId = o.__originalOperationId || o.operationId;
            o.operationId = "".concat(oid).concat(i + 1);
          });
        } else if (typeof operation.operationId !== 'undefined') {
          // Ensure we always add the normalized operation ID if one already exists
          // ( potentially different, given that we normalize our IDs)
          // ... _back_ to the spec. Otherwise, they might not line up
          var obj = opList[0]; // eslint-disable-next-line no-underscore-dangle

          obj.__originalOperationId = obj.__originalOperationId || operation.operationId;
          obj.operationId = oid;
        }
      }

      if (method !== 'parameters') {
        // Add inherited consumes, produces, parameters, securities
        var inheritsList = [];
        var toBeInherit = {}; // Global-levels
        // eslint-disable-next-line no-restricted-syntax

        for (var key in spec) {
          if (key === 'produces' || key === 'consumes' || key === 'security') {
            toBeInherit[key] = spec[key];
            inheritsList.push(toBeInherit);
          }
        } // Path-levels


        if (pathParameters) {
          toBeInherit.parameters = pathParameters;
          inheritsList.push(toBeInherit);
        }

        if (inheritsList.length) {
          // eslint-disable-next-line no-restricted-syntax
          var _iterator = _createForOfIteratorHelper(inheritsList),
              _step;

          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              var inherits = _step.value;

              // eslint-disable-next-line no-restricted-syntax
              for (var inheritName in inherits) {
                if (!operation[inheritName]) {
                  operation[inheritName] = inherits[inheritName];
                } else if (inheritName === 'parameters') {
                  // eslint-disable-next-line no-restricted-syntax
                  var _iterator2 = _createForOfIteratorHelper(inherits[inheritName]),
                      _step2;

                  try {
                    var _loop2 = function _loop2() {
                      var param = _step2.value;
                      var exists = operation[inheritName].some(function (opParam) {
                        return opParam.name && opParam.name === param.name || opParam.$ref && opParam.$ref === param.$ref || opParam.$$ref && opParam.$$ref === param.$$ref || opParam === param;
                      });

                      if (!exists) {
                        operation[inheritName].push(param);
                      }
                    };

                    for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                      _loop2();
                    }
                  } catch (err) {
                    _iterator2.e(err);
                  } finally {
                    _iterator2.f();
                  }
                }
              }
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
        }
      }
    };

    for (var method in path) {
      var _ret = _loop(method);

      if (_ret === "continue") continue;
    }
  }

  spec.$$normalized = true;
  return parsedSpec;
}