import _objectSpread from "@babel/runtime-corejs2/helpers/objectSpread2";
import _Object$assign from "@babel/runtime-corejs2/core-js/object/assign";
import _Array$isArray from "@babel/runtime-corejs2/core-js/array/is-array";
import lib from '.';
export default {
  key: 'parameters',
  plugin: function plugin(parameters, key, fullPath, specmap) {
    if (_Array$isArray(parameters) && parameters.length) {
      var val = _Object$assign([], parameters);

      var opPath = fullPath.slice(0, -1);

      var op = _objectSpread({}, lib.getIn(specmap.spec, opPath));

      parameters.forEach(function (param, i) {
        try {
          val[i].default = specmap.parameterMacro(op, param);
        } catch (e) {
          var err = new Error(e);
          err.fullPath = fullPath;
          return err;
        }

        return undefined;
      });
      return lib.replace(fullPath, val);
    }

    return lib.replace(fullPath, parameters);
  }
};