import _sliceInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/slice";
import _spliceInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/splice";
import _objectSpread from "@babel/runtime-corejs3/helpers/objectSpread2";
import _typeof from "@babel/runtime-corejs3/helpers/typeof";
import _forEachInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/for-each";
import _Promise from "@babel/runtime-corejs3/core-js-stable/promise";
import _regeneratorRuntime from "@babel/runtime-corejs3/regenerator";
import _Object$keys2 from "@babel/runtime-corejs3/core-js-stable/object/keys";
import _indexOfInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/index-of";
import _createForOfIteratorHelper from "@babel/runtime-corejs3/helpers/createForOfIteratorHelper";
import _everyInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/every";
import _Array$isArray from "@babel/runtime-corejs3/core-js-stable/array/is-array";
import _concatInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/concat";
import _mapInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/map";
import _filterInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/filter";
import _bindInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/bind";
import _Object$create from "@babel/runtime-corejs3/core-js-stable/object/create";
import _Object$assign from "@babel/runtime-corejs3/core-js-stable/object/assign";
import _classCallCheck from "@babel/runtime-corejs3/helpers/classCallCheck";
import _createClass from "@babel/runtime-corejs3/helpers/createClass";
import find from 'lodash/find';
import noop from 'lodash/noop';
import lib from './lib';
import refs from './lib/refs';
import allOf from './lib/all-of';
import parameters from './lib/parameters';
import properties from './lib/properties';
import ContextTree from './lib/context-tree';
var HARD_LIMIT = 100;

var SpecMap = /*#__PURE__*/function () {
  function SpecMap(opts) {
    var _this = this,
        _context,
        _context2,
        _context3,
        _context4,
        _context5,
        _context6;

    _classCallCheck(this, SpecMap);

    _Object$assign(this, {
      spec: '',
      debugLevel: 'info',
      plugins: [],
      pluginHistory: {},
      errors: [],
      mutations: [],
      promisedPatches: [],
      state: {},
      patches: [],
      context: {},
      contextTree: new ContextTree(),
      showDebug: false,
      allPatches: [],
      // only populated if showDebug is true
      pluginProp: 'specMap',
      libMethods: _Object$assign(_Object$create(this), lib, {
        getInstance: function getInstance() {
          return _this;
        }
      }),
      allowMetaPatches: false
    }, opts); // Lib methods bound


    this.get = _bindInstanceProperty(_context = this._get).call(_context, this); // eslint-disable-line no-underscore-dangle

    this.getContext = _bindInstanceProperty(_context2 = this._getContext).call(_context2, this); // eslint-disable-line no-underscore-dangle

    this.hasRun = _bindInstanceProperty(_context3 = this._hasRun).call(_context3, this); // eslint-disable-line no-underscore-dangle

    this.wrappedPlugins = _filterInstanceProperty(_context4 = _mapInstanceProperty(_context5 = this.plugins).call(_context5, _bindInstanceProperty(_context6 = this.wrapPlugin).call(_context6, this))).call(_context4, lib.isFunction); // Initial patch(s)

    this.patches.push(lib.add([], this.spec));
    this.patches.push(lib.context([], this.context));
    this.updatePatches(this.patches);
  }

  _createClass(SpecMap, [{
    key: "debug",
    value: function debug(level) {
      if (this.debugLevel === level) {
        var _console;

        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        (_console = console).log.apply(_console, args); // eslint-disable-line no-console

      }
    }
  }, {
    key: "verbose",
    value: function verbose(header) {
      if (this.debugLevel === 'verbose') {
        var _console2, _context7;

        for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }

        (_console2 = console).log.apply(_console2, _concatInstanceProperty(_context7 = ["[".concat(header, "]   ")]).call(_context7, args)); // eslint-disable-line no-console

      }
    }
  }, {
    key: "wrapPlugin",
    value: function wrapPlugin(plugin, name) {
      var pathDiscriminator = this.pathDiscriminator;
      var ctx = null;
      var fn;

      if (plugin[this.pluginProp]) {
        ctx = plugin;
        fn = plugin[this.pluginProp];
      } else if (lib.isFunction(plugin)) {
        fn = plugin;
      } else if (lib.isObject(plugin)) {
        fn = createKeyBasedPlugin(plugin);
      }

      return _Object$assign(_bindInstanceProperty(fn).call(fn, ctx), {
        pluginName: plugin.name || name,
        isGenerator: lib.isGenerator(fn)
      }); // Expected plugin interface: {key: string, plugin: fn*}
      // This traverses depth-first and immediately applies yielded patches.
      // This strategy should work well for most plugins (including the built-ins).
      // We might consider making this (traversing & application) configurable later.

      function createKeyBasedPlugin(pluginObj) {
        var isSubPath = function isSubPath(path, tested) {
          if (!_Array$isArray(path)) {
            return true;
          }

          return _everyInstanceProperty(path).call(path, function (val, i) {
            return val === tested[i];
          });
        };

        return /*#__PURE__*/_regeneratorRuntime.mark(function generator(patches, specmap) {
          var _marked, refCache, _iterator, _step, patch, traverse;

          return _regeneratorRuntime.wrap(function generator$(_context9) {
            while (1) {
              switch (_context9.prev = _context9.next) {
                case 0:
                  traverse = function _traverse(obj, path, patch) {
                    var parentIndex, parent, indexOfFirstProperties, isRootProperties, traversed, _i, _Object$keys, key, val, updatedPath, isObj, objRef, isWithinPathDiscriminator;

                    return _regeneratorRuntime.wrap(function traverse$(_context8) {
                      while (1) {
                        switch (_context8.prev = _context8.next) {
                          case 0:
                            if (lib.isObject(obj)) {
                              _context8.next = 6;
                              break;
                            }

                            if (!(pluginObj.key === path[path.length - 1])) {
                              _context8.next = 4;
                              break;
                            }

                            _context8.next = 4;
                            return pluginObj.plugin(obj, pluginObj.key, path, specmap);

                          case 4:
                            _context8.next = 30;
                            break;

                          case 6:
                            parentIndex = path.length - 1;
                            parent = path[parentIndex];
                            indexOfFirstProperties = _indexOfInstanceProperty(path).call(path, 'properties');
                            isRootProperties = parent === 'properties' && parentIndex === indexOfFirstProperties;
                            traversed = specmap.allowMetaPatches && refCache[obj.$$ref]; // eslint-disable-next-line no-restricted-syntax

                            _i = 0, _Object$keys = _Object$keys2(obj);

                          case 12:
                            if (!(_i < _Object$keys.length)) {
                              _context8.next = 30;
                              break;
                            }

                            key = _Object$keys[_i];
                            val = obj[key];
                            updatedPath = _concatInstanceProperty(path).call(path, key);
                            isObj = lib.isObject(val);
                            objRef = obj.$$ref;

                            if (traversed) {
                              _context8.next = 22;
                              break;
                            }

                            if (!isObj) {
                              _context8.next = 22;
                              break;
                            }

                            // Only store the ref if it exists
                            if (specmap.allowMetaPatches && objRef) {
                              refCache[objRef] = true;
                            }

                            return _context8.delegateYield(traverse(val, updatedPath, patch), "t0", 22);

                          case 22:
                            if (!(!isRootProperties && key === pluginObj.key)) {
                              _context8.next = 27;
                              break;
                            }

                            isWithinPathDiscriminator = isSubPath(pathDiscriminator, path);

                            if (!(!pathDiscriminator || isWithinPathDiscriminator)) {
                              _context8.next = 27;
                              break;
                            }

                            _context8.next = 27;
                            return pluginObj.plugin(val, key, updatedPath, specmap, patch);

                          case 27:
                            _i++;
                            _context8.next = 12;
                            break;

                          case 30:
                          case "end":
                            return _context8.stop();
                        }
                      }
                    }, _marked);
                  };

                  _marked = /*#__PURE__*/_regeneratorRuntime.mark(traverse);
                  refCache = {}; // eslint-disable-next-line no-restricted-syntax

                  _iterator = _createForOfIteratorHelper(_filterInstanceProperty(patches).call(patches, lib.isAdditiveMutation));
                  _context9.prev = 4;

                  _iterator.s();

                case 6:
                  if ((_step = _iterator.n()).done) {
                    _context9.next = 11;
                    break;
                  }

                  patch = _step.value;
                  return _context9.delegateYield(traverse(patch.value, patch.path, patch), "t0", 9);

                case 9:
                  _context9.next = 6;
                  break;

                case 11:
                  _context9.next = 16;
                  break;

                case 13:
                  _context9.prev = 13;
                  _context9.t1 = _context9["catch"](4);

                  _iterator.e(_context9.t1);

                case 16:
                  _context9.prev = 16;

                  _iterator.f();

                  return _context9.finish(16);

                case 19:
                case "end":
                  return _context9.stop();
              }
            }
          }, generator, null, [[4, 13, 16, 19]]);
        });
      }
    }
  }, {
    key: "nextPlugin",
    value: function nextPlugin() {
      var _this2 = this;

      // Array.prototype.find doesn't work in IE 11 :(
      return find(this.wrappedPlugins, function (plugin) {
        var mutations = _this2.getMutationsForPlugin(plugin);

        return mutations.length > 0;
      });
    }
  }, {
    key: "nextPromisedPatch",
    value: function nextPromisedPatch() {
      if (this.promisedPatches.length > 0) {
        var _context10;

        return _Promise.race(_mapInstanceProperty(_context10 = this.promisedPatches).call(_context10, function (patch) {
          return patch.value;
        }));
      }

      return undefined;
    }
  }, {
    key: "getPluginHistory",
    value: function getPluginHistory(plugin) {
      var name = this.constructor.getPluginName(plugin);
      return this.pluginHistory[name] || [];
    }
  }, {
    key: "getPluginRunCount",
    value: function getPluginRunCount(plugin) {
      return this.getPluginHistory(plugin).length;
    }
  }, {
    key: "getPluginHistoryTip",
    value: function getPluginHistoryTip(plugin) {
      var history = this.getPluginHistory(plugin);
      var val = history && history[history.length - 1];
      return val || {};
    }
  }, {
    key: "getPluginMutationIndex",
    value: function getPluginMutationIndex(plugin) {
      var mi = this.getPluginHistoryTip(plugin).mutationIndex;
      return typeof mi !== 'number' ? -1 : mi;
    }
  }, {
    key: "updatePluginHistory",
    value: function updatePluginHistory(plugin, val) {
      var name = this.constructor.getPluginName(plugin);
      this.pluginHistory[name] = this.pluginHistory[name] || [];
      this.pluginHistory[name].push(val);
    }
  }, {
    key: "updatePatches",
    value: function updatePatches(patches) {
      var _context11,
          _this3 = this;

      _forEachInstanceProperty(_context11 = lib.normalizeArray(patches)).call(_context11, function (patch) {
        if (patch instanceof Error) {
          _this3.errors.push(patch);

          return;
        }

        try {
          if (!lib.isObject(patch)) {
            _this3.debug('updatePatches', 'Got a non-object patch', patch);

            return;
          }

          if (_this3.showDebug) {
            _this3.allPatches.push(patch);
          }

          if (lib.isPromise(patch.value)) {
            _this3.promisedPatches.push(patch);

            _this3.promisedPatchThen(patch);

            return;
          }

          if (lib.isContextPatch(patch)) {
            _this3.setContext(patch.path, patch.value);

            return;
          }

          if (lib.isMutation(patch)) {
            _this3.updateMutations(patch);

            return;
          }
        } catch (e) {
          console.error(e); // eslint-disable-line no-console

          _this3.errors.push(e);
        }
      });
    }
  }, {
    key: "updateMutations",
    value: function updateMutations(patch) {
      if (_typeof(patch.value) === 'object' && !_Array$isArray(patch.value) && this.allowMetaPatches) {
        patch.value = _objectSpread({}, patch.value);
      }

      var result = lib.applyPatch(this.state, patch, {
        allowMetaPatches: this.allowMetaPatches
      });

      if (result) {
        this.mutations.push(patch);
        this.state = result;
      }
    }
  }, {
    key: "removePromisedPatch",
    value: function removePromisedPatch(patch) {
      var _context12, _context13;

      var index = _indexOfInstanceProperty(_context12 = this.promisedPatches).call(_context12, patch);

      if (index < 0) {
        this.debug("Tried to remove a promisedPatch that isn't there!");
        return;
      }

      _spliceInstanceProperty(_context13 = this.promisedPatches).call(_context13, index, 1);
    }
  }, {
    key: "promisedPatchThen",
    value: function promisedPatchThen(patch) {
      var _this4 = this;

      patch.value = patch.value.then(function (val) {
        var promisedPatch = _objectSpread(_objectSpread({}, patch), {}, {
          value: val
        });

        _this4.removePromisedPatch(patch);

        _this4.updatePatches(promisedPatch);
      }).catch(function (e) {
        _this4.removePromisedPatch(patch);

        _this4.updatePatches(e);
      });
      return patch.value;
    }
  }, {
    key: "getMutations",
    value: function getMutations(from, to) {
      var _context14;

      from = from || 0;

      if (typeof to !== 'number') {
        to = this.mutations.length;
      }

      return _sliceInstanceProperty(_context14 = this.mutations).call(_context14, from, to);
    }
  }, {
    key: "getCurrentMutations",
    value: function getCurrentMutations() {
      return this.getMutationsForPlugin(this.getCurrentPlugin());
    }
  }, {
    key: "getMutationsForPlugin",
    value: function getMutationsForPlugin(plugin) {
      var tip = this.getPluginMutationIndex(plugin);
      return this.getMutations(tip + 1);
    }
  }, {
    key: "getCurrentPlugin",
    value: function getCurrentPlugin() {
      return this.currentPlugin;
    }
  }, {
    key: "getLib",
    value: function getLib() {
      return this.libMethods;
    } // eslint-disable-next-line no-underscore-dangle

  }, {
    key: "_get",
    value: function _get(path) {
      return lib.getIn(this.state, path);
    } // eslint-disable-next-line no-underscore-dangle

  }, {
    key: "_getContext",
    value: function _getContext(path) {
      return this.contextTree.get(path);
    }
  }, {
    key: "setContext",
    value: function setContext(path, value) {
      return this.contextTree.set(path, value);
    } // eslint-disable-next-line no-underscore-dangle

  }, {
    key: "_hasRun",
    value: function _hasRun(count) {
      var times = this.getPluginRunCount(this.getCurrentPlugin());
      return times > (count || 0);
    }
  }, {
    key: "dispatch",
    value: function dispatch() {
      var _this5 = this;

      var that = this;
      var plugin = this.nextPlugin();

      if (!plugin) {
        var nextPromise = this.nextPromisedPatch();

        if (nextPromise) {
          return nextPromise.then(function () {
            return _this5.dispatch();
          }).catch(function () {
            return _this5.dispatch();
          });
        } // We're done!


        var result = {
          spec: this.state,
          errors: this.errors
        };

        if (this.showDebug) {
          result.patches = this.allPatches;
        }

        return _Promise.resolve(result);
      } // Makes sure plugin isn't running an endless loop


      that.pluginCount = that.pluginCount || {};
      that.pluginCount[plugin] = (that.pluginCount[plugin] || 0) + 1;

      if (that.pluginCount[plugin] > HARD_LIMIT) {
        var _context15;

        return _Promise.resolve({
          spec: that.state,
          errors: _concatInstanceProperty(_context15 = that.errors).call(_context15, new Error("We've reached a hard limit of ".concat(HARD_LIMIT, " plugin runs")))
        });
      } // A different plugin runs, wait for all promises to resolve, then retry


      if (plugin !== this.currentPlugin && this.promisedPatches.length) {
        var _context16;

        var promises = _mapInstanceProperty(_context16 = this.promisedPatches).call(_context16, function (p) {
          return p.value;
        }); // Waits for all to settle instead of Promise.all which stops on rejection


        return _Promise.all(_mapInstanceProperty(promises).call(promises, function (promise) {
          return promise.then(noop, noop);
        })).then(function () {
          return _this5.dispatch();
        });
      } // Ok, run the plugin


      return executePlugin();

      function executePlugin() {
        that.currentPlugin = plugin;
        var mutations = that.getCurrentMutations();
        var lastMutationIndex = that.mutations.length - 1;

        try {
          if (plugin.isGenerator) {
            // eslint-disable-next-line no-restricted-syntax
            var _iterator2 = _createForOfIteratorHelper(plugin(mutations, that.getLib())),
                _step2;

            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var yieldedPatches = _step2.value;
                updatePatches(yieldedPatches);
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          } else {
            var newPatches = plugin(mutations, that.getLib());
            updatePatches(newPatches);
          }
        } catch (e) {
          console.error(e); // eslint-disable-line no-console

          updatePatches([_Object$assign(_Object$create(e), {
            plugin: plugin
          })]);
        } finally {
          that.updatePluginHistory(plugin, {
            mutationIndex: lastMutationIndex
          });
        }

        return that.dispatch();
      }

      function updatePatches(patches) {
        if (patches) {
          patches = lib.fullyNormalizeArray(patches);
          that.updatePatches(patches, plugin);
        }
      }
    }
  }], [{
    key: "getPluginName",
    value: function getPluginName(plugin) {
      return plugin.pluginName;
    }
  }, {
    key: "getPatchesOfType",
    value: function getPatchesOfType(patches, fn) {
      return _filterInstanceProperty(patches).call(patches, fn);
    }
  }]);

  return SpecMap;
}();

export default function mapSpec(opts) {
  return new SpecMap(opts).dispatch();
}
var plugins = {
  refs: refs,
  allOf: allOf,
  parameters: parameters,
  properties: properties
};
export { SpecMap, plugins };