import _reduceInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/reduce";
import _indexOfInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/index-of";
import _mapInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/map";
import _typeof from "@babel/runtime-corejs3/helpers/typeof";
import _Object$keys from "@babel/runtime-corejs3/core-js-stable/object/keys";
import _forEachInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/for-each";
import _Promise from "@babel/runtime-corejs3/core-js-stable/promise";
import _concatInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/concat";
import _sliceInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/slice";
import _someInstanceProperty from "@babel/runtime-corejs3/core-js-stable/instance/some";
import _WeakMap from "@babel/runtime-corejs3/core-js-stable/weak-map";
import _Object$assign from "@babel/runtime-corejs3/core-js-stable/object/assign";
import { fetch } from 'cross-fetch';
import jsYaml from 'js-yaml';
import qs from 'querystring-browser';
import url from 'url';
import lib from '.';
import createError from './create-error';
import { isFreelyNamed, absolutifyPointer } from '../helpers';
import { ACCEPT_HEADER_VALUE_FOR_DOCUMENTS } from '../../constants';
var ABSOLUTE_URL_REGEXP = new RegExp('^([a-z]+://|//)', 'i');
var JSONRefError = createError('JSONRefError', function cb(message, extra, oriError) {
  this.originalError = oriError;

  _Object$assign(this, extra || {});
});
var docCache = {};
var specmapRefs = new _WeakMap();
var skipResolutionTestFns = [// OpenAPI 2.0 response examples
function (path) {
  return (// ["paths", *, *, "responses", *, "examples"]
    path[0] === 'paths' && path[3] === 'responses' && path[5] === 'examples'
  );
}, // OpenAPI 3.0 Response Media Type Examples
function (path) {
  return (// ["paths", *, *, "responses", *, "content", *, "example"]
    path[0] === 'paths' && path[3] === 'responses' && path[5] === 'content' && path[7] === 'example'
  );
}, function (path) {
  return (// ["paths", *, *, "responses", *, "content", *, "examples", *, "value"]
    path[0] === 'paths' && path[3] === 'responses' && path[5] === 'content' && path[7] === 'examples' && path[9] === 'value'
  );
}, // OpenAPI 3.0 Request Body Media Type Examples
function (path) {
  return (// ["paths", *, *, "requestBody", "content", *, "example"]
    path[0] === 'paths' && path[3] === 'requestBody' && path[4] === 'content' && path[6] === 'example'
  );
}, function (path) {
  return (// ["paths", *, *, "requestBody", "content", *, "examples", *, "value"]
    path[0] === 'paths' && path[3] === 'requestBody' && path[4] === 'content' && path[6] === 'examples' && path[8] === 'value'
  );
}, // OAS 3.0 Parameter Examples
function (path) {
  return (// ["paths", *, "parameters", *, "example"]
    path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'example'
  );
}, function (path) {
  return (// ["paths", *, *, "parameters", *, "example"]
    path[0] === 'paths' && path[3] === 'parameters' && path[5] === 'example'
  );
}, function (path) {
  return (// ["paths", *, "parameters", *, "examples", *, "value"]
    path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'examples' && path[6] === 'value'
  );
}, function (path) {
  return (// ["paths", *, *, "parameters", *, "examples", *, "value"]
    path[0] === 'paths' && path[3] === 'parameters' && path[5] === 'examples' && path[7] === 'value'
  );
}, function (path) {
  return (// ["paths", *, "parameters", *, "content", *, "example"]
    path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'content' && path[6] === 'example'
  );
}, function (path) {
  return (// ["paths", *, "parameters", *, "content", *, "examples", *, "value"]
    path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'content' && path[6] === 'examples' && path[8] === 'value'
  );
}, function (path) {
  return (// ["paths", *, *, "parameters", *, "content", *, "example"]
    path[0] === 'paths' && path[3] === 'parameters' && path[4] === 'content' && path[7] === 'example'
  );
}, function (path) {
  return (// ["paths", *, *, "parameters", *, "content", *, "examples", *, "value"]
    path[0] === 'paths' && path[3] === 'parameters' && path[5] === 'content' && path[7] === 'examples' && path[9] === 'value'
  );
}];

var shouldSkipResolution = function shouldSkipResolution(path) {
  return _someInstanceProperty(skipResolutionTestFns).call(skipResolutionTestFns, function (fn) {
    return fn(path);
  });
}; // =========================
// Core
// =========================

/**
 * This plugin resolves the JSON pointers.
 * A major part of this plugin deals with cyclic references via 2 mechanisms.
 * 1. If a pointer was already resolved before in this path, halt.
 * 2. If the patch value points to one of the ancestors in this path, halt.
 *
 * Note that either one of these mechanism is sufficient, both must be in place.
 * For examples:
 *
 * Given the following spec, #1 alone is insufficient because after the 2nd
 * application, there will be a cyclic object reference.
 *   a.b.c: $ref-d
 *   d.e.f: $ref-a (per #1, safe to return patch as no immediate cycle)
 *
 * Given the following spec, #2 alone is insufficient because although there will
 * never be any cyclic object reference, the plugin will keep producing patches.
 *   a: $ref-b
 *   b: $ref-a
 */


var plugin = {
  key: '$ref',
  plugin: function plugin(ref, key, fullPath, specmap) {
    var specmapInstance = specmap.getInstance();

    var parent = _sliceInstanceProperty(fullPath).call(fullPath, 0, -1);

    if (isFreelyNamed(parent) || shouldSkipResolution(parent)) {
      return undefined;
    }

    var _specmap$getContext = specmap.getContext(fullPath),
        baseDoc = _specmap$getContext.baseDoc;

    if (typeof ref !== 'string') {
      return new JSONRefError('$ref: must be a string (JSON-Ref)', {
        $ref: ref,
        baseDoc: baseDoc,
        fullPath: fullPath
      });
    }

    var splitString = split(ref);
    var refPath = splitString[0];
    var pointer = splitString[1] || '';
    var basePath;

    try {
      basePath = baseDoc || refPath ? absoluteify(refPath, baseDoc) : null;
    } catch (e) {
      return wrapError(e, {
        pointer: pointer,
        $ref: ref,
        basePath: basePath,
        fullPath: fullPath
      });
    }

    var promOrVal;
    var tokens;

    if (pointerAlreadyInPath(pointer, basePath, parent, specmap)) {
      // Cyclic reference!
      // if `useCircularStructures` is not set, just leave the reference
      // unresolved, but absolutify it so that we don't leave an invalid $ref
      // path in the content
      if (!specmapInstance.useCircularStructures) {
        var _absolutifiedRef = absolutifyPointer(ref, basePath);

        if (ref === _absolutifiedRef) {
          // avoids endless looping
          // without this, the ref plugin never stops seeing this $ref
          return null;
        }

        return lib.replace(fullPath, _absolutifiedRef);
      }
    }

    if (basePath == null) {
      tokens = jsonPointerToArray(pointer);
      promOrVal = specmap.get(tokens);

      if (typeof promOrVal === 'undefined') {
        promOrVal = new JSONRefError("Could not resolve reference: ".concat(ref), {
          pointer: pointer,
          $ref: ref,
          baseDoc: baseDoc,
          fullPath: fullPath
        });
      }
    } else {
      promOrVal = extractFromDoc(basePath, pointer); // eslint-disable-next-line no-underscore-dangle

      if (promOrVal.__value != null) {
        promOrVal = promOrVal.__value; // eslint-disable-line no-underscore-dangle
      } else {
        promOrVal = promOrVal.catch(function (e) {
          throw wrapError(e, {
            pointer: pointer,
            $ref: ref,
            baseDoc: baseDoc,
            fullPath: fullPath
          });
        });
      }
    }

    if (promOrVal instanceof Error) {
      return [lib.remove(fullPath), promOrVal];
    }

    var absolutifiedRef = absolutifyPointer(ref, basePath);
    var patch = lib.replace(parent, promOrVal, {
      $$ref: absolutifiedRef
    });

    if (basePath && basePath !== baseDoc) {
      return [patch, lib.context(parent, {
        baseDoc: basePath
      })];
    }

    try {
      // prevents circular values from being constructed, unless we specifically
      // want that to happen
      if (!patchValueAlreadyInPath(specmap.state, patch) || specmapInstance.useCircularStructures) {
        return patch;
      }
    } catch (e) {
      // if we're catching here, path traversal failed, so we should
      // ditch without sending any patches back up.
      //
      // this is a narrow fix for the larger problem of patches being queued
      // and then having the state they were generated against be modified
      // before they are applied.
      //
      // TODO: re-engineer specmap patch/state management to avoid this
      return null;
    }

    return undefined;
  }
};

var mod = _Object$assign(plugin, {
  docCache: docCache,
  absoluteify: absoluteify,
  clearCache: clearCache,
  JSONRefError: JSONRefError,
  wrapError: wrapError,
  getDoc: getDoc,
  split: split,
  extractFromDoc: extractFromDoc,
  fetchJSON: fetchJSON,
  extract: extract,
  jsonPointerToArray: jsonPointerToArray,
  unescapeJsonPointerToken: unescapeJsonPointerToken
});

export default mod; // =========================
// Utilities
// =========================

/**
 * Resolves a path and its base to an abolute URL.
 * @api public
 */

function absoluteify(path, basePath) {
  if (!ABSOLUTE_URL_REGEXP.test(path)) {
    if (!basePath) {
      var _context;

      throw new JSONRefError(_concatInstanceProperty(_context = "Tried to resolve a relative URL, without having a basePath. path: '".concat(path, "' basePath: '")).call(_context, basePath, "'"));
    }

    return url.resolve(basePath, path);
  }

  return path;
}
/**
 * Wraps an error as JSONRefError.
 * @param  {Error} e      the error.
 * @param  {Object} extra (optional) optional data.
 * @return {Error}        an instance of JSONRefError.
 * @api public
 */


function wrapError(e, extra) {
  var message;

  if (e && e.response && e.response.body) {
    var _context2;

    message = _concatInstanceProperty(_context2 = "".concat(e.response.body.code, " ")).call(_context2, e.response.body.message);
  } else {
    message = e.message;
  }

  return new JSONRefError("Could not resolve reference: ".concat(message), extra, e);
}
/**
 * Splits a pointer by the hash delimiter.
 * @api public
 */


function split(ref) {
  return (ref + '').split('#'); // eslint-disable-line prefer-template
}
/**
 * Extracts a pointer from its document.
 * @param  {String} docPath the absolute document URL.
 * @param  {String} pointer the pointer whose value is to be extracted.
 * @return {Promise}        a promise of the pointer value.
 * @api public
 */


function extractFromDoc(docPath, pointer) {
  var doc = docCache[docPath];

  if (doc && !lib.isPromise(doc)) {
    // If doc is already available, return __value together with the promise.
    // __value is for special handling in cycle check:
    // pointerAlreadyInPath() won't work if patch.value is a promise,
    // thus when that promise is finally resolved, cycle might happen (because
    // `spec` and `docCache[basePath]` refer to the exact same object).
    // See test "should resolve a cyclic spec when baseDoc is specified".
    try {
      var v = extract(pointer, doc);
      return _Object$assign(_Promise.resolve(v), {
        __value: v
      });
    } catch (e) {
      return _Promise.reject(e);
    }
  }

  return getDoc(docPath).then(function (_doc) {
    return extract(pointer, _doc);
  });
}
/**
 * Clears all document caches.
 * @param  {String} item (optional) the name of the cache item to be cleared.
 * @api public
 */


function clearCache(item) {
  if (typeof item !== 'undefined') {
    delete docCache[item];
  } else {
    var _context3;

    _forEachInstanceProperty(_context3 = _Object$keys(docCache)).call(_context3, function (key) {
      delete docCache[key];
    });
  }
}
/**
 * Fetches and caches a document.
 * @param  {String} docPath the absolute URL of the document.
 * @return {Promise}        a promise of the document content.
 * @api public
 */


function getDoc(docPath) {
  var val = docCache[docPath];

  if (val) {
    return lib.isPromise(val) ? val : _Promise.resolve(val);
  } // NOTE: we need to use `mod.fetchJSON` in order to be able to overwrite it.
  // Any tips on how to make this cleaner, please ping!


  docCache[docPath] = mod.fetchJSON(docPath).then(function (doc) {
    docCache[docPath] = doc;
    return doc;
  });
  return docCache[docPath];
}
/**
 * Fetches a document.
 * @param  {String} docPath the absolute URL of the document.
 * @return {Promise}        a promise of the document content.
 * @api public
 */


function fetchJSON(docPath) {
  return fetch(docPath, {
    headers: {
      Accept: ACCEPT_HEADER_VALUE_FOR_DOCUMENTS
    },
    loadSpec: true
  }).then(function (res) {
    return res.text();
  }).then(function (text) {
    return jsYaml.safeLoad(text);
  });
}
/**
 * Extracts a pointer from an object.
 * @param  {String[]} pointer the JSON pointer.
 * @param  {Object} obj       an object whose value is to be extracted.
 * @return {Object}           the value to be extracted.
 * @api public
 */


function extract(pointer, obj) {
  var tokens = jsonPointerToArray(pointer);

  if (tokens.length < 1) {
    return obj;
  }

  var val = lib.getIn(obj, tokens);

  if (typeof val === 'undefined') {
    throw new JSONRefError("Could not resolve pointer: ".concat(pointer, " does not exist in document"), {
      pointer: pointer
    });
  }

  return val;
}
/**
 * Converts a JSON pointer to array.
 * @api public
 */


function jsonPointerToArray(pointer) {
  var _context4;

  if (typeof pointer !== 'string') {
    throw new TypeError("Expected a string, got a ".concat(_typeof(pointer)));
  }

  if (pointer[0] === '/') {
    pointer = pointer.substr(1);
  }

  if (pointer === '') {
    return [];
  }

  return _mapInstanceProperty(_context4 = pointer.split('/')).call(_context4, unescapeJsonPointerToken);
}
/**
 * Unescapes a JSON pointer.
 * @api public
 */


function unescapeJsonPointerToken(token) {
  if (typeof token !== 'string') {
    return token;
  }

  return qs.unescape(token.replace(/~1/g, '/').replace(/~0/g, '~'));
}
/**
 * Escapes a JSON pointer.
 * @api public
 */


function escapeJsonPointerToken(token) {
  return qs.escape(token.replace(/~/g, '~0').replace(/\//g, '~1'));
}

function arrayToJsonPointer(arr) {
  if (arr.length === 0) {
    return '';
  }

  return "/".concat(_mapInstanceProperty(arr).call(arr, escapeJsonPointerToken).join('/'));
}

var pointerBoundaryChar = function pointerBoundaryChar(c) {
  return !c || c === '/' || c === '#';
};

function pointerIsAParent(pointer, parentPointer) {
  if (pointerBoundaryChar(parentPointer)) {
    // This is the root of the document, so its naturally a parent
    return true;
  }

  var nextChar = pointer.charAt(parentPointer.length);

  var lastParentChar = _sliceInstanceProperty(parentPointer).call(parentPointer, -1);

  return _indexOfInstanceProperty(pointer).call(pointer, parentPointer) === 0 && (!nextChar || nextChar === '/' || nextChar === '#') && lastParentChar !== '#';
} // =========================
// Private
// =========================

/**
 * Checks if this pointer points back to one or more pointers along the path.
 */


function pointerAlreadyInPath(pointer, basePath, parent, specmap) {
  var _context5, _context8;

  var refs = specmapRefs.get(specmap);

  if (!refs) {
    // Stores all resolved references of a specmap instance.
    // Schema: path -> pointer (path's $ref value).
    refs = {};
    specmapRefs.set(specmap, refs);
  }

  var parentPointer = arrayToJsonPointer(parent);

  var fullyQualifiedPointer = _concatInstanceProperty(_context5 = "".concat(basePath || '<specmap-base>', "#")).call(_context5, pointer); // dirty hack to strip `allof/[index]` from the path, in order to avoid cases
  // where we get false negatives because:
  // - we resolve a path, then
  // - allOf plugin collapsed `allOf/[index]` out of the path, then
  // - we try to work on a child $ref within that collapsed path.
  //
  // because of the path collapse, we lose track of it in our specmapRefs hash
  // solution: always throw the allOf constructs out of paths we store
  // TODO: solve this with a global register, or by writing more metadata in
  // either allOf or refs plugin


  var safeParentPointer = parentPointer.replace(/allOf\/\d+\/?/g, ''); // Case 1: direct cycle, e.g. a.b.c.$ref: '/a.b'
  // Detect by checking that the parent path doesn't start with pointer.
  // This only applies if the pointer is internal, i.e. basePath === rootPath (could be null)

  var rootDoc = specmap.contextTree.get([]).baseDoc;

  if (basePath == rootDoc && pointerIsAParent(safeParentPointer, pointer)) {
    // eslint-disable-line
    return true;
  } // Case 2: indirect cycle
  //  ex1: a.$ref: '/b'  &  b.c.$ref: '/b/c'
  //  ex2: a.$ref: '/b/c'  &  b.c.$ref: '/b'
  // Detect by retrieving all the $refs along the path of parent
  // and checking if any starts with pointer or vice versa.


  var currPath = '';

  var hasIndirectCycle = _someInstanceProperty(parent).call(parent, function (token) {
    var _context6, _context7;

    currPath = _concatInstanceProperty(_context6 = "".concat(currPath, "/")).call(_context6, escapeJsonPointerToken(token));
    return refs[currPath] && _someInstanceProperty(_context7 = refs[currPath]).call(_context7, function (ref) {
      return pointerIsAParent(ref, fullyQualifiedPointer) || pointerIsAParent(fullyQualifiedPointer, ref);
    });
  });

  if (hasIndirectCycle) {
    return true;
  } // No cycle, this ref will be resolved, so stores it now for future detection.
  // No need to store if has cycle, as parent path is a dead-end and won't be checked again.


  refs[safeParentPointer] = _concatInstanceProperty(_context8 = refs[safeParentPointer] || []).call(_context8, fullyQualifiedPointer);
  return undefined;
}
/**
 * Checks if the value of this patch ends up pointing to an ancestor along the path.
 */


function patchValueAlreadyInPath(root, patch) {
  var _context9;

  var ancestors = [root];

  _reduceInstanceProperty(_context9 = patch.path).call(_context9, function (parent, p) {
    ancestors.push(parent[p]);
    return parent[p];
  }, root);

  return pointToAncestor(patch.value);

  function pointToAncestor(obj) {
    var _context10;

    return lib.isObject(obj) && (_indexOfInstanceProperty(ancestors).call(ancestors, obj) >= 0 || _someInstanceProperty(_context10 = _Object$keys(obj)).call(_context10, function (k) {
      return pointToAncestor(obj[k]);
    }));
  }
}