"use strict";

exports.__esModule = true;
exports.default = void 0;

var _stream = require("stream");

var _formDataEncoder = require("form-data-encoder");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * formdata-node works in node-fetch@2.x via form-data-encoder only.
 * FormData instance is converted to Encoder instance which gets converted
 * to Readable Stream.
 *
 * TODO(vladimir.gorej@gmail.com): this can be removed when migrated to node-fetch@3.x
 */
const foldFormDataToRequest = (formdata, request) => {
  const encoder = new _formDataEncoder.FormDataEncoder(formdata);

  const readableStream = _stream.Readable.from(encoder); // get rid of previous headers


  delete request.headers['content-type'];
  delete request.headers['Content-Type']; // set computed headers

  request.headers = _objectSpread(_objectSpread({}, request.headers), encoder.headers); // set FormData instance to request for debugging purposes

  request.formdata = formdata; // assign readable stream as request body

  request.body = readableStream;
};

var _default = foldFormDataToRequest;
exports.default = _default;