"use strict";

exports.__esModule = true;
exports.helpers = exports.default = void 0;
var _url = _interopRequireDefault(require("url"));
var _index = _interopRequireWildcard(require("./http/index.js"));
var _index2 = require("./resolver/index.js");
var _index3 = require("./subtree-resolver/index.js");
var _index4 = _interopRequireDefault(require("./resolver/strategies/generic/index.js"));
var _index5 = _interopRequireWildcard(require("./resolver/strategies/openapi-2/index.js"));
var _index6 = _interopRequireDefault(require("./resolver/strategies/openapi-3-0/index.js"));
var _index7 = _interopRequireDefault(require("./resolver/strategies/openapi-3-1-apidom/index.js"));
var _interfaces = require("./interfaces.js");
var _index8 = require("./execute/index.js");
var _index9 = require("./helpers/index.js");
var _index10 = _interopRequireDefault(require("./resolver/apidom/reference/resolve/resolvers/http-swagger-client/index.js"));
var _index11 = _interopRequireDefault(require("./resolver/apidom/reference/parse/parsers/json/index.js"));
var _index12 = _interopRequireDefault(require("./resolver/apidom/reference/parse/parsers/yaml-1-2/index.js"));
var _index13 = _interopRequireDefault(require("./resolver/apidom/reference/parse/parsers/openapi-json-3-1/index.js"));
var _index14 = _interopRequireDefault(require("./resolver/apidom/reference/parse/parsers/openapi-yaml-3-1/index.js"));
var _index15 = _interopRequireDefault(require("./resolver/apidom/reference/dereference/strategies/openapi-3-1-swagger-client/index.js"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
Swagger.http = _index.default;
Swagger.makeHttp = _index.makeHttp.bind(null, Swagger.http);
Swagger.resolveStrategies = {
  'openapi-3-1-apidom': _index7.default,
  'openapi-3-0': _index6.default,
  'openapi-2-0': _index5.default,
  generic: _index4.default
};
Swagger.resolve = (0, _index2.makeResolve)({
  strategies: [Swagger.resolveStrategies['openapi-3-1-apidom'], Swagger.resolveStrategies['openapi-3-0'], Swagger.resolveStrategies['openapi-2-0'], Swagger.resolveStrategies.generic]
});
Swagger.resolveSubtree = (0, _index3.makeResolveSubtree)({
  strategies: [Swagger.resolveStrategies['openapi-3-1-apidom'], Swagger.resolveStrategies['openapi-3-0'], Swagger.resolveStrategies['openapi-2-0'], Swagger.resolveStrategies.generic]
});
Swagger.execute = _index8.execute;
Swagger.serializeRes = _index.serializeRes;
Swagger.serializeHeaders = _index.serializeHeaders;
Swagger.clearCache = _index5.clearCache;
Swagger.makeApisTagOperation = _interfaces.makeApisTagOperation;
Swagger.buildRequest = _index8.buildRequest;
Swagger.helpers = {
  opId: _index9.opId
};
Swagger.getBaseUrl = _index8.baseUrl;
Swagger.apidom = {
  resolve: {
    resolvers: {
      HttpResolverSwaggerClient: _index10.default
    }
  },
  parse: {
    parsers: {
      JsonParser: _index11.default,
      YamlParser: _index12.default,
      OpenApiJson3_1Parser: _index13.default,
      OpenApiYaml3_1Parser: _index14.default
    }
  },
  dereference: {
    strategies: {
      OpenApi3_1SwaggerClientDereferenceStrategy: _index15.default
    }
  }
};
function Swagger(url, opts = {}) {
  // Allow url as a separate argument
  if (typeof url === 'string') {
    opts.url = url;
  } else {
    opts = url;
  }
  if (!(this instanceof Swagger)) {
    return new Swagger(opts);
  }
  Object.assign(this, opts);
  const prom = this.resolve().then(() => {
    if (!this.disableInterfaces) {
      Object.assign(this, Swagger.makeApisTagOperation(this));
    }
    return this;
  });

  // Expose this instance on the promise that gets returned
  prom.client = this;
  return prom;
}
Swagger.prototype = {
  http: _index.default,
  execute(options) {
    this.applyDefaults();
    return Swagger.execute(_objectSpread({
      spec: this.spec,
      http: this.http,
      securities: {
        authorized: this.authorizations
      },
      contextUrl: typeof this.url === 'string' ? this.url : undefined,
      requestInterceptor: this.requestInterceptor || null,
      responseInterceptor: this.responseInterceptor || null
    }, options));
  },
  resolve(options = {}) {
    return Swagger.resolve(_objectSpread({
      spec: this.spec,
      url: this.url,
      http: this.http || this.fetch,
      allowMetaPatches: this.allowMetaPatches,
      useCircularStructures: this.useCircularStructures,
      requestInterceptor: this.requestInterceptor || null,
      responseInterceptor: this.responseInterceptor || null,
      skipNormalization: this.skipNormalization || false
    }, options)).then(obj => {
      this.originalSpec = this.spec;
      this.spec = obj.spec;
      this.errors = obj.errors;
      return this;
    });
  }
};
Swagger.prototype.applyDefaults = function applyDefaults() {
  const {
    spec
  } = this;
  const specUrl = this.url;
  // TODO: OAS3: support servers here
  if (specUrl && specUrl.startsWith('http')) {
    const parsed = _url.default.parse(specUrl);
    if (!spec.host) {
      spec.host = parsed.host;
    }
    if (!spec.schemes) {
      spec.schemes = [parsed.protocol.replace(':', '')];
    }
    if (!spec.basePath) {
      spec.basePath = '/';
    }
  }
};

// add backwards compatibility with older versions of swagger-ui
// Refs https://github.com/swagger-api/swagger-ui/issues/6210
const {
  helpers
} = Swagger;
exports.helpers = helpers;
var _default = Swagger;
/* eslint-enable camelcase */
exports.default = _default;