"use strict";

exports.__esModule = true;
exports.default = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _compose = _interopRequireDefault(require("../utils/compose.js"));
var _toPath = _interopRequireDefault(require("../utils/to-path.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const ModelPropertyMacroVisitor = (0, _compose.default)({
  init({
    modelPropertyMacro,
    options
  }) {
    this.modelPropertyMacro = modelPropertyMacro;
    this.options = options;
  },
  props: {
    modelPropertyMacro: null,
    options: null,
    SchemaElement: {
      leave(schemaElement, key, parent, path, ancestors) {
        if (typeof schemaElement.properties === 'undefined') return;
        if (!(0, _apidomCore.isObjectElement)(schemaElement.properties)) return;
        schemaElement.properties.forEach(property => {
          if (!(0, _apidomCore.isObjectElement)(property)) return;
          try {
            const macroValue = this.modelPropertyMacro((0, _apidomCore.toValue)(property));
            property.set('default', macroValue);
          } catch (error) {
            var _this$options$derefer, _this$options$derefer2, _this$options$derefer3;
            const macroError = new Error(error, {
              cause: error
            });
            macroError.fullPath = [...(0, _toPath.default)([...ancestors, parent, schemaElement]), 'properties'];
            (_this$options$derefer = this.options.dereference.dereferenceOpts) === null || _this$options$derefer === void 0 ? void 0 : (_this$options$derefer2 = _this$options$derefer.errors) === null || _this$options$derefer2 === void 0 ? void 0 : (_this$options$derefer3 = _this$options$derefer2.push) === null || _this$options$derefer3 === void 0 ? void 0 : _this$options$derefer3.call(_this$options$derefer2, macroError);
          }
        });
      }
    }
  }
});
var _default = ModelPropertyMacroVisitor;
exports.default = _default;