"use strict";

exports.__esModule = true;
exports.default = void 0;
require("cross-fetch/polyfill");
var _empty = require("@swagger-api/apidom-reference/configuration/empty");
var _index = _interopRequireDefault(require("../../../../../../http/index.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
const HttpResolverSwaggerClient = _empty.HttpResolver.compose({
  props: {
    name: 'http-swagger-client',
    swaggerHTTPClient: _index.default,
    swaggerHTTPClientConfig: {}
  },
  init({
    swaggerHTTPClient = this.swaggerHTTPClient
  } = {}) {
    this.swaggerHTTPClient = swaggerHTTPClient;
  },
  methods: {
    getHttpClient() {
      return this.swaggerHTTPClient;
    },
    async read(file) {
      const client = this.getHttpClient();
      const controller = new AbortController();
      const {
        signal
      } = controller;
      const timeoutID = setTimeout(() => {
        controller.abort();
      }, this.timeout);
      const credentials = this.getHttpClient().withCredentials || this.withCredentials ? 'include' : 'same-origin';
      const redirects = this.redirects === 0 ? 'error' : 'follow';
      const follow = this.redirects > 0 ? this.redirects : undefined;
      try {
        const response = await client(_objectSpread({
          url: file.uri,
          signal,
          userFetch: async (resource, options) => {
            const res = await fetch(resource, options);
            res.headers.delete('Content-Type');
            return res;
          },
          credentials,
          redirects,
          follow
        }, this.swaggerHTTPClientConfig));
        return response.text.arrayBuffer();
      } catch (error) {
        throw new _empty.ResolverError(`Error downloading "${file.uri}"`, {
          cause: error
        });
      } finally {
        clearTimeout(timeoutID);
      }
    }
  }
});
var _default = HttpResolverSwaggerClient;
exports.default = _default;