(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["SwaggerClient"] = factory();
	else
		root["SwaggerClient"] = factory();
})(window, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 9559:
/***/ (function() {

(function (self) {
  var irrelevant = function (exports) {
    var support = {
      searchParams: 'URLSearchParams' in self,
      iterable: 'Symbol' in self && 'iterator' in Symbol,
      blob: 'FileReader' in self && 'Blob' in self && function () {
        try {
          new Blob();
          return true;
        } catch (e) {
          return false;
        }
      }(),
      formData: 'FormData' in self,
      arrayBuffer: 'ArrayBuffer' in self
    };
    function isDataView(obj) {
      return obj && DataView.prototype.isPrototypeOf(obj);
    }
    if (support.arrayBuffer) {
      var viewClasses = ['[object Int8Array]', '[object Uint8Array]', '[object Uint8ClampedArray]', '[object Int16Array]', '[object Uint16Array]', '[object Int32Array]', '[object Uint32Array]', '[object Float32Array]', '[object Float64Array]'];
      var isArrayBufferView = ArrayBuffer.isView || function (obj) {
        return obj && viewClasses.indexOf(Object.prototype.toString.call(obj)) > -1;
      };
    }
    function normalizeName(name) {
      if (typeof name !== 'string') {
        name = String(name);
      }
      if (/[^a-z0-9\-#$%&'*+.^_`|~]/i.test(name)) {
        throw new TypeError('Invalid character in header field name');
      }
      return name.toLowerCase();
    }
    function normalizeValue(value) {
      if (typeof value !== 'string') {
        value = String(value);
      }
      return value;
    }

    // Build a destructive iterator for the value list
    function iteratorFor(items) {
      var iterator = {
        next: function () {
          var value = items.shift();
          return {
            done: value === undefined,
            value: value
          };
        }
      };
      if (support.iterable) {
        iterator[Symbol.iterator] = function () {
          return iterator;
        };
      }
      return iterator;
    }
    function Headers(headers) {
      this.map = {};
      if (headers instanceof Headers) {
        headers.forEach(function (value, name) {
          this.append(name, value);
        }, this);
      } else if (Array.isArray(headers)) {
        headers.forEach(function (header) {
          this.append(header[0], header[1]);
        }, this);
      } else if (headers) {
        Object.getOwnPropertyNames(headers).forEach(function (name) {
          this.append(name, headers[name]);
        }, this);
      }
    }
    Headers.prototype.append = function (name, value) {
      name = normalizeName(name);
      value = normalizeValue(value);
      var oldValue = this.map[name];
      this.map[name] = oldValue ? oldValue + ', ' + value : value;
    };
    Headers.prototype['delete'] = function (name) {
      delete this.map[normalizeName(name)];
    };
    Headers.prototype.get = function (name) {
      name = normalizeName(name);
      return this.has(name) ? this.map[name] : null;
    };
    Headers.prototype.has = function (name) {
      return this.map.hasOwnProperty(normalizeName(name));
    };
    Headers.prototype.set = function (name, value) {
      this.map[normalizeName(name)] = normalizeValue(value);
    };
    Headers.prototype.forEach = function (callback, thisArg) {
      for (var name in this.map) {
        if (this.map.hasOwnProperty(name)) {
          callback.call(thisArg, this.map[name], name, this);
        }
      }
    };
    Headers.prototype.keys = function () {
      var items = [];
      this.forEach(function (value, name) {
        items.push(name);
      });
      return iteratorFor(items);
    };
    Headers.prototype.values = function () {
      var items = [];
      this.forEach(function (value) {
        items.push(value);
      });
      return iteratorFor(items);
    };
    Headers.prototype.entries = function () {
      var items = [];
      this.forEach(function (value, name) {
        items.push([name, value]);
      });
      return iteratorFor(items);
    };
    if (support.iterable) {
      Headers.prototype[Symbol.iterator] = Headers.prototype.entries;
    }
    function consumed(body) {
      if (body.bodyUsed) {
        return Promise.reject(new TypeError('Already read'));
      }
      body.bodyUsed = true;
    }
    function fileReaderReady(reader) {
      return new Promise(function (resolve, reject) {
        reader.onload = function () {
          resolve(reader.result);
        };
        reader.onerror = function () {
          reject(reader.error);
        };
      });
    }
    function readBlobAsArrayBuffer(blob) {
      var reader = new FileReader();
      var promise = fileReaderReady(reader);
      reader.readAsArrayBuffer(blob);
      return promise;
    }
    function readBlobAsText(blob) {
      var reader = new FileReader();
      var promise = fileReaderReady(reader);
      reader.readAsText(blob);
      return promise;
    }
    function readArrayBufferAsText(buf) {
      var view = new Uint8Array(buf);
      var chars = new Array(view.length);
      for (var i = 0; i < view.length; i++) {
        chars[i] = String.fromCharCode(view[i]);
      }
      return chars.join('');
    }
    function bufferClone(buf) {
      if (buf.slice) {
        return buf.slice(0);
      } else {
        var view = new Uint8Array(buf.byteLength);
        view.set(new Uint8Array(buf));
        return view.buffer;
      }
    }
    function Body() {
      this.bodyUsed = false;
      this._initBody = function (body) {
        this._bodyInit = body;
        if (!body) {
          this._bodyText = '';
        } else if (typeof body === 'string') {
          this._bodyText = body;
        } else if (support.blob && Blob.prototype.isPrototypeOf(body)) {
          this._bodyBlob = body;
        } else if (support.formData && FormData.prototype.isPrototypeOf(body)) {
          this._bodyFormData = body;
        } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
          this._bodyText = body.toString();
        } else if (support.arrayBuffer && support.blob && isDataView(body)) {
          this._bodyArrayBuffer = bufferClone(body.buffer);
          // IE 10-11 can't handle a DataView body.
          this._bodyInit = new Blob([this._bodyArrayBuffer]);
        } else if (support.arrayBuffer && (ArrayBuffer.prototype.isPrototypeOf(body) || isArrayBufferView(body))) {
          this._bodyArrayBuffer = bufferClone(body);
        } else {
          this._bodyText = body = Object.prototype.toString.call(body);
        }
        if (!this.headers.get('content-type')) {
          if (typeof body === 'string') {
            this.headers.set('content-type', 'text/plain;charset=UTF-8');
          } else if (this._bodyBlob && this._bodyBlob.type) {
            this.headers.set('content-type', this._bodyBlob.type);
          } else if (support.searchParams && URLSearchParams.prototype.isPrototypeOf(body)) {
            this.headers.set('content-type', 'application/x-www-form-urlencoded;charset=UTF-8');
          }
        }
      };
      if (support.blob) {
        this.blob = function () {
          var rejected = consumed(this);
          if (rejected) {
            return rejected;
          }
          if (this._bodyBlob) {
            return Promise.resolve(this._bodyBlob);
          } else if (this._bodyArrayBuffer) {
            return Promise.resolve(new Blob([this._bodyArrayBuffer]));
          } else if (this._bodyFormData) {
            throw new Error('could not read FormData body as blob');
          } else {
            return Promise.resolve(new Blob([this._bodyText]));
          }
        };
        this.arrayBuffer = function () {
          if (this._bodyArrayBuffer) {
            return consumed(this) || Promise.resolve(this._bodyArrayBuffer);
          } else {
            return this.blob().then(readBlobAsArrayBuffer);
          }
        };
      }
      this.text = function () {
        var rejected = consumed(this);
        if (rejected) {
          return rejected;
        }
        if (this._bodyBlob) {
          return readBlobAsText(this._bodyBlob);
        } else if (this._bodyArrayBuffer) {
          return Promise.resolve(readArrayBufferAsText(this._bodyArrayBuffer));
        } else if (this._bodyFormData) {
          throw new Error('could not read FormData body as text');
        } else {
          return Promise.resolve(this._bodyText);
        }
      };
      if (support.formData) {
        this.formData = function () {
          return this.text().then(decode);
        };
      }
      this.json = function () {
        return this.text().then(JSON.parse);
      };
      return this;
    }

    // HTTP methods whose capitalization should be normalized
    var methods = ['DELETE', 'GET', 'HEAD', 'OPTIONS', 'POST', 'PUT'];
    function normalizeMethod(method) {
      var upcased = method.toUpperCase();
      return methods.indexOf(upcased) > -1 ? upcased : method;
    }
    function Request(input, options) {
      options = options || {};
      var body = options.body;
      if (input instanceof Request) {
        if (input.bodyUsed) {
          throw new TypeError('Already read');
        }
        this.url = input.url;
        this.credentials = input.credentials;
        if (!options.headers) {
          this.headers = new Headers(input.headers);
        }
        this.method = input.method;
        this.mode = input.mode;
        this.signal = input.signal;
        if (!body && input._bodyInit != null) {
          body = input._bodyInit;
          input.bodyUsed = true;
        }
      } else {
        this.url = String(input);
      }
      this.credentials = options.credentials || this.credentials || 'same-origin';
      if (options.headers || !this.headers) {
        this.headers = new Headers(options.headers);
      }
      this.method = normalizeMethod(options.method || this.method || 'GET');
      this.mode = options.mode || this.mode || null;
      this.signal = options.signal || this.signal;
      this.referrer = null;
      if ((this.method === 'GET' || this.method === 'HEAD') && body) {
        throw new TypeError('Body not allowed for GET or HEAD requests');
      }
      this._initBody(body);
    }
    Request.prototype.clone = function () {
      return new Request(this, {
        body: this._bodyInit
      });
    };
    function decode(body) {
      var form = new FormData();
      body.trim().split('&').forEach(function (bytes) {
        if (bytes) {
          var split = bytes.split('=');
          var name = split.shift().replace(/\+/g, ' ');
          var value = split.join('=').replace(/\+/g, ' ');
          form.append(decodeURIComponent(name), decodeURIComponent(value));
        }
      });
      return form;
    }
    function parseHeaders(rawHeaders) {
      var headers = new Headers();
      // Replace instances of \r\n and \n followed by at least one space or horizontal tab with a space
      // https://tools.ietf.org/html/rfc7230#section-3.2
      var preProcessedHeaders = rawHeaders.replace(/\r?\n[\t ]+/g, ' ');
      preProcessedHeaders.split(/\r?\n/).forEach(function (line) {
        var parts = line.split(':');
        var key = parts.shift().trim();
        if (key) {
          var value = parts.join(':').trim();
          headers.append(key, value);
        }
      });
      return headers;
    }
    Body.call(Request.prototype);
    function Response(bodyInit, options) {
      if (!options) {
        options = {};
      }
      this.type = 'default';
      this.status = options.status === undefined ? 200 : options.status;
      this.ok = this.status >= 200 && this.status < 300;
      this.statusText = 'statusText' in options ? options.statusText : 'OK';
      this.headers = new Headers(options.headers);
      this.url = options.url || '';
      this._initBody(bodyInit);
    }
    Body.call(Response.prototype);
    Response.prototype.clone = function () {
      return new Response(this._bodyInit, {
        status: this.status,
        statusText: this.statusText,
        headers: new Headers(this.headers),
        url: this.url
      });
    };
    Response.error = function () {
      var response = new Response(null, {
        status: 0,
        statusText: ''
      });
      response.type = 'error';
      return response;
    };
    var redirectStatuses = [301, 302, 303, 307, 308];
    Response.redirect = function (url, status) {
      if (redirectStatuses.indexOf(status) === -1) {
        throw new RangeError('Invalid status code');
      }
      return new Response(null, {
        status: status,
        headers: {
          location: url
        }
      });
    };
    exports.DOMException = self.DOMException;
    try {
      new exports.DOMException();
    } catch (err) {
      exports.DOMException = function (message, name) {
        this.message = message;
        this.name = name;
        var error = Error(message);
        this.stack = error.stack;
      };
      exports.DOMException.prototype = Object.create(Error.prototype);
      exports.DOMException.prototype.constructor = exports.DOMException;
    }
    function fetch(input, init) {
      return new Promise(function (resolve, reject) {
        var request = new Request(input, init);
        if (request.signal && request.signal.aborted) {
          return reject(new exports.DOMException('Aborted', 'AbortError'));
        }
        var xhr = new XMLHttpRequest();
        function abortXhr() {
          xhr.abort();
        }
        xhr.onload = function () {
          var options = {
            status: xhr.status,
            statusText: xhr.statusText,
            headers: parseHeaders(xhr.getAllResponseHeaders() || '')
          };
          options.url = 'responseURL' in xhr ? xhr.responseURL : options.headers.get('X-Request-URL');
          var body = 'response' in xhr ? xhr.response : xhr.responseText;
          resolve(new Response(body, options));
        };
        xhr.onerror = function () {
          reject(new TypeError('Network request failed'));
        };
        xhr.ontimeout = function () {
          reject(new TypeError('Network request failed'));
        };
        xhr.onabort = function () {
          reject(new exports.DOMException('Aborted', 'AbortError'));
        };
        xhr.open(request.method, request.url, true);
        if (request.credentials === 'include') {
          xhr.withCredentials = true;
        } else if (request.credentials === 'omit') {
          xhr.withCredentials = false;
        }
        if ('responseType' in xhr && support.blob) {
          xhr.responseType = 'blob';
        }
        request.headers.forEach(function (value, name) {
          xhr.setRequestHeader(name, value);
        });
        if (request.signal) {
          request.signal.addEventListener('abort', abortXhr);
          xhr.onreadystatechange = function () {
            // DONE (success or failure)
            if (xhr.readyState === 4) {
              request.signal.removeEventListener('abort', abortXhr);
            }
          };
        }
        xhr.send(typeof request._bodyInit === 'undefined' ? null : request._bodyInit);
      });
    }
    fetch.polyfill = true;
    if (!self.fetch) {
      self.fetch = fetch;
      self.Headers = Headers;
      self.Request = Request;
      self.Response = Response;
    }
    exports.Headers = Headers;
    exports.Request = Request;
    exports.Response = Response;
    exports.fetch = fetch;
    Object.defineProperty(exports, '__esModule', {
      value: true
    });
    return exports;
  }({});
})(typeof self !== 'undefined' ? self : this);

/***/ }),

/***/ 58061:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ACCEPT_HEADER_VALUE_FOR_DOCUMENTS": () => (/* binding */ ACCEPT_HEADER_VALUE_FOR_DOCUMENTS)
/* harmony export */ });
// eslint-disable-next-line import/prefer-default-export
const ACCEPT_HEADER_VALUE_FOR_DOCUMENTS = 'application/json, application/yaml';

/***/ }),

/***/ 93860:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "baseUrl": () => (/* binding */ baseUrl),
/* harmony export */   "buildRequest": () => (/* binding */ buildRequest),
/* harmony export */   "execute": () => (/* binding */ execute),
/* harmony export */   "self": () => (/* binding */ self)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var _babel_runtime_corejs3_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2562);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27361);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var url__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8575);
/* harmony import */ var cookie__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(76489);
/* harmony import */ var is_plain_object__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(90111);
/* harmony import */ var _http_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28288);
/* harmony import */ var _specmap_lib_create_error_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(83393);
/* harmony import */ var _swagger2_parameter_builders_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(1382);
/* harmony import */ var _oas3_parameter_builders_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(43655);
/* harmony import */ var _oas3_build_request_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80025);
/* harmony import */ var _swagger2_build_request_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(23077);
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(80486);
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(57656);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(59809);


const _excluded = ["http", "fetch", "spec", "operationId", "pathName", "method", "parameters", "securities"];












const arrayOrEmpty = ar => Array.isArray(ar) ? ar : [];
const OperationNotFoundError = (0,_specmap_lib_create_error_js__WEBPACK_IMPORTED_MODULE_9__["default"])('OperationNotFoundError', function cb(message, extra, oriError) {
  this.originalError = oriError;
  Object.assign(this, extra || {});
});
const findParametersWithName = (name, parameters) => parameters.filter(p => p.name === name);

// removes parameters that have duplicate 'in' and 'name' properties
const deduplicateParameters = parameters => {
  const paramsMap = {};
  parameters.forEach(p => {
    if (!paramsMap[p.in]) {
      paramsMap[p.in] = {};
    }
    paramsMap[p.in][p.name] = p;
  });
  const dedupedParameters = [];
  Object.keys(paramsMap).forEach(i => {
    Object.keys(paramsMap[i]).forEach(p => {
      dedupedParameters.push(paramsMap[i][p]);
    });
  });
  return dedupedParameters;
};

// For stubbing in tests
const self = {
  buildRequest
};

// Execute request, with the given operationId and parameters
// pathName/method or operationId is optional
function execute(_ref) {
  let {
      http: userHttp,
      fetch,
      // This is legacy
      spec,
      operationId,
      pathName,
      method,
      parameters,
      securities
    } = _ref,
    extras = (0,_babel_runtime_corejs3_helpers_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded);
  // Provide default fetch implementation
  const http = userHttp || fetch || _http_index_js__WEBPACK_IMPORTED_MODULE_5__["default"]; // Default to _our_ http

  if (pathName && method && !operationId) {
    operationId = (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_10__["default"])(pathName, method);
  }
  const request = self.buildRequest((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({
    spec,
    operationId,
    parameters,
    securities,
    http
  }, extras));
  if (request.body && ((0,is_plain_object__WEBPACK_IMPORTED_MODULE_11__.isPlainObject)(request.body) || Array.isArray(request.body))) {
    request.body = JSON.stringify(request.body);
  }

  // Build request and execute it
  return http(request);
}

// Build a request, which can be handled by the `http.js` implementation.
function buildRequest(options) {
  const {
    spec,
    operationId,
    responseContentType,
    scheme,
    requestInterceptor,
    responseInterceptor,
    contextUrl,
    userFetch,
    server,
    serverVariables,
    http,
    signal
  } = options;
  let {
    parameters,
    parameterBuilders
  } = options;
  const specIsOAS3 = (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_12__.isOpenAPI3)(spec);
  if (!parameterBuilders) {
    // user did not provide custom parameter builders
    if (specIsOAS3) {
      parameterBuilders = _oas3_parameter_builders_js__WEBPACK_IMPORTED_MODULE_13__;
    } else {
      parameterBuilders = _swagger2_parameter_builders_js__WEBPACK_IMPORTED_MODULE_6__["default"];
    }
  }

  // Set credentials with 'http.withCredentials' value
  const credentials = http && http.withCredentials ? 'include' : 'same-origin';

  // Base Template
  let req = {
    url: '',
    credentials,
    headers: {},
    cookies: {}
  };
  if (signal) {
    req.signal = signal;
  }
  if (requestInterceptor) {
    req.requestInterceptor = requestInterceptor;
  }
  if (responseInterceptor) {
    req.responseInterceptor = responseInterceptor;
  }
  if (userFetch) {
    req.userFetch = userFetch;
  }
  const operationRaw = (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_14__["default"])(spec, operationId);
  if (!operationRaw) {
    throw new OperationNotFoundError(`Operation ${operationId} not found`);
  }
  const {
    operation = {},
    method,
    pathName
  } = operationRaw;
  req.url += baseUrl({
    spec,
    scheme,
    contextUrl,
    server,
    serverVariables,
    pathName,
    method
  });

  // Mostly for testing
  if (!operationId) {
    // Not removing req.cookies causes testing issues and would
    // change our interface, so we're always sure to remove it.
    // See the same statement lower down in this function for
    // more context.
    delete req.cookies;
    return req;
  }
  req.url += pathName; // Have not yet replaced the path parameters
  req.method = `${method}`.toUpperCase();
  parameters = parameters || {};
  const path = spec.paths[pathName] || {};
  if (responseContentType) {
    req.headers.accept = responseContentType;
  }
  const combinedParameters = deduplicateParameters([].concat(arrayOrEmpty(operation.parameters)) // operation parameters
  .concat(arrayOrEmpty(path.parameters))); // path parameters

  // REVIEW: OAS3: have any key names or parameter shapes changed?
  // Any new features that need to be plugged in here?

  // Add values to request
  combinedParameters.forEach(parameter => {
    const builder = parameterBuilders[parameter.in];
    let value;
    if (parameter.in === 'body' && parameter.schema && parameter.schema.properties) {
      value = parameters;
    }
    value = parameter && parameter.name && parameters[parameter.name];
    if (typeof value === 'undefined') {
      // check for `name-in` formatted key
      value = parameter && parameter.name && parameters[`${parameter.in}.${parameter.name}`];
    } else if (findParametersWithName(parameter.name, combinedParameters).length > 1) {
      // value came from `parameters[parameter.name]`
      // check to see if this is an ambiguous parameter
      // eslint-disable-next-line no-console
      console.warn(`Parameter '${parameter.name}' is ambiguous because the defined spec has more than one parameter with the name: '${parameter.name}' and the passed-in parameter values did not define an 'in' value.`);
    }
    if (value === null) {
      return;
    }
    if (typeof parameter.default !== 'undefined' && typeof value === 'undefined') {
      value = parameter.default;
    }
    if (typeof value === 'undefined' && parameter.required && !parameter.allowEmptyValue) {
      throw new Error(`Required parameter ${parameter.name} is not provided`);
    }
    if (specIsOAS3 && parameter.schema && parameter.schema.type === 'object' && typeof value === 'string') {
      try {
        value = JSON.parse(value);
      } catch (e) {
        throw new Error('Could not parse object parameter value string as JSON');
      }
    }
    if (builder) {
      builder({
        req,
        parameter,
        value,
        operation,
        spec
      });
    }
  });

  // Do version-specific tasks, then return those results.
  const versionSpecificOptions = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, options), {}, {
    operation
  });
  if (specIsOAS3) {
    req = (0,_oas3_build_request_js__WEBPACK_IMPORTED_MODULE_7__["default"])(versionSpecificOptions, req);
  } else {
    // If not OAS3, then treat as Swagger2.
    req = (0,_swagger2_build_request_js__WEBPACK_IMPORTED_MODULE_8__["default"])(versionSpecificOptions, req);
  }

  // If the cookie convenience object exists in our request,
  // serialize its content and then delete the cookie object.
  if (req.cookies && Object.keys(req.cookies).length) {
    const cookieString = Object.keys(req.cookies).reduce((prev, cookieName) => {
      const cookieValue = req.cookies[cookieName];
      const prefix = prev ? '&' : '';
      const stringified = cookie__WEBPACK_IMPORTED_MODULE_4__.serialize(cookieName, cookieValue);
      return prev + prefix + stringified;
    }, '');
    req.headers.Cookie = cookieString;
  }
  if (req.cookies) {
    // even if no cookies were defined, we need to remove
    // the cookies key from our request, or many many legacy
    // tests will break.
    delete req.cookies;
  }

  // Will add the query object into the URL, if it exists
  // ... will also create a FormData instance, if multipart/form-data (eg: a file)
  (0,_http_index_js__WEBPACK_IMPORTED_MODULE_5__.mergeInQueryOrForm)(req);
  return req;
}
const stripNonAlpha = str => str ? str.replace(/\W/g, '') : null;

// be careful when modifying this! it is a publicly-exposed method.
function baseUrl(obj) {
  const specIsOAS3 = (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_12__.isOpenAPI3)(obj.spec);
  return specIsOAS3 ? oas3BaseUrl(obj) : swagger2BaseUrl(obj);
}
function oas3BaseUrl(_ref2) {
  let {
    spec,
    pathName,
    method,
    server,
    contextUrl,
    serverVariables = {}
  } = _ref2;
  const servers = lodash_get__WEBPACK_IMPORTED_MODULE_2___default()(spec, ['paths', pathName, (method || '').toLowerCase(), 'servers']) || lodash_get__WEBPACK_IMPORTED_MODULE_2___default()(spec, ['paths', pathName, 'servers']) || lodash_get__WEBPACK_IMPORTED_MODULE_2___default()(spec, ['servers']);
  let selectedServerUrl = '';
  let selectedServerObj = null;
  if (server && servers && servers.length) {
    const serverUrls = servers.map(srv => srv.url);
    if (serverUrls.indexOf(server) > -1) {
      selectedServerUrl = server;
      selectedServerObj = servers[serverUrls.indexOf(server)];
    }
  }
  if (!selectedServerUrl && servers && servers.length) {
    // default to the first server if we don't have one by now
    selectedServerUrl = servers[0].url; // eslint-disable-line semi
    [selectedServerObj] = servers;
  }
  if (selectedServerUrl.indexOf('{') > -1) {
    // do variable substitution
    const varNames = getVariableTemplateNames(selectedServerUrl);
    varNames.forEach(vari => {
      if (selectedServerObj.variables && selectedServerObj.variables[vari]) {
        // variable is defined in server
        const variableDefinition = selectedServerObj.variables[vari];
        const variableValue = serverVariables[vari] || variableDefinition.default;
        const re = new RegExp(`{${vari}}`, 'g');
        selectedServerUrl = selectedServerUrl.replace(re, variableValue);
      }
    });
  }
  return buildOas3UrlWithContext(selectedServerUrl, contextUrl);
}
function buildOas3UrlWithContext() {
  let ourUrl = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  let contextUrl = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  // relative server url should be resolved against contextUrl
  const parsedUrl = ourUrl && contextUrl ? url__WEBPACK_IMPORTED_MODULE_3__.parse(url__WEBPACK_IMPORTED_MODULE_3__.resolve(contextUrl, ourUrl)) : url__WEBPACK_IMPORTED_MODULE_3__.parse(ourUrl);
  const parsedContextUrl = url__WEBPACK_IMPORTED_MODULE_3__.parse(contextUrl);
  const computedScheme = stripNonAlpha(parsedUrl.protocol) || stripNonAlpha(parsedContextUrl.protocol) || '';
  const computedHost = parsedUrl.host || parsedContextUrl.host;
  const computedPath = parsedUrl.pathname || '';
  let res;
  if (computedScheme && computedHost) {
    res = `${computedScheme}://${computedHost + computedPath}`;

    // If last character is '/', trim it off
  } else {
    res = computedPath;
  }
  return res[res.length - 1] === '/' ? res.slice(0, -1) : res;
}
function getVariableTemplateNames(str) {
  const results = [];
  const re = /{([^}]+)}/g;
  let text;

  // eslint-disable-next-line no-cond-assign
  while (text = re.exec(str)) {
    results.push(text[1]);
  }
  return results;
}

// Compose the baseUrl ( scheme + host + basePath )
function swagger2BaseUrl(_ref3) {
  let {
    spec,
    scheme,
    contextUrl = ''
  } = _ref3;
  const parsedContextUrl = url__WEBPACK_IMPORTED_MODULE_3__.parse(contextUrl);
  const firstSchemeInSpec = Array.isArray(spec.schemes) ? spec.schemes[0] : null;
  const computedScheme = scheme || firstSchemeInSpec || stripNonAlpha(parsedContextUrl.protocol) || 'http';
  const computedHost = spec.host || parsedContextUrl.host || '';
  const computedPath = spec.basePath || '';
  let res;
  if (computedScheme && computedHost) {
    // we have what we need for an absolute URL
    res = `${computedScheme}://${computedHost + computedPath}`;
  } else {
    // if not, a relative URL will have to do
    res = computedPath;
  }

  // If last character is '/', trim it off
  return res[res.length - 1] === '/' ? res.slice(0, -1) : res;
}

/***/ }),

/***/ 80025:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "applySecurities": () => (/* binding */ applySecurities),
/* harmony export */   "default": () => (/* binding */ buildRequest)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var is_plain_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(90111);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27361);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _helpers_btoa_node_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(602);

// This function runs after the common function,
// `src/execute/index.js#buildRequest`



function buildRequest(options, req) {
  const {
    operation,
    requestBody,
    securities,
    spec,
    attachContentTypeForEmptyPayload
  } = options;
  let {
    requestContentType
  } = options;
  req = applySecurities({
    request: req,
    securities,
    operation,
    spec
  });
  const requestBodyDef = operation.requestBody || {};
  const requestBodyMediaTypes = Object.keys(requestBodyDef.content || {});
  const isExplicitContentTypeValid = requestContentType && requestBodyMediaTypes.indexOf(requestContentType) > -1;

  // for OAS3: set the Content-Type
  if (requestBody || attachContentTypeForEmptyPayload) {
    // does the passed requestContentType appear in the requestBody definition?

    if (requestContentType && isExplicitContentTypeValid) {
      req.headers['Content-Type'] = requestContentType;
    } else if (!requestContentType) {
      const firstMediaType = requestBodyMediaTypes[0];
      if (firstMediaType) {
        req.headers['Content-Type'] = firstMediaType;
        requestContentType = firstMediaType;
      }
    }
  } else if (requestContentType && isExplicitContentTypeValid) {
    req.headers['Content-Type'] = requestContentType;
  }
  if (!options.responseContentType && operation.responses) {
    const mediaTypes = Object.entries(operation.responses).filter(_ref => {
      let [key, value] = _ref;
      const code = parseInt(key, 10);
      return code >= 200 && code < 300 && (0,is_plain_object__WEBPACK_IMPORTED_MODULE_3__.isPlainObject)(value.content);
    }).reduce((acc, _ref2) => {
      let [, value] = _ref2;
      return acc.concat(Object.keys(value.content));
    }, []);
    if (mediaTypes.length > 0) {
      req.headers.accept = mediaTypes.join(', ');
    }
  }

  // for OAS3: add requestBody to request
  if (requestBody) {
    if (requestContentType) {
      if (requestBodyMediaTypes.indexOf(requestContentType) > -1) {
        // only attach body if the requestBody has a definition for the
        // contentType that has been explicitly set
        if (requestContentType === 'application/x-www-form-urlencoded' || requestContentType === 'multipart/form-data') {
          if (typeof requestBody === 'object') {
            const encoding = (requestBodyDef.content[requestContentType] || {}).encoding || {};
            req.form = {};
            Object.keys(requestBody).forEach(k => {
              req.form[k] = {
                value: requestBody[k],
                encoding: encoding[k] || {}
              };
            });
          } else {
            req.form = requestBody;
          }
        } else {
          req.body = requestBody;
        }
      }
    } else {
      req.body = requestBody;
    }
  }
  return req;
}

// Add security values, to operations - that declare their need on them
// Adapted from the Swagger2 implementation
function applySecurities(_ref3) {
  let {
    request,
    securities = {},
    operation = {},
    spec
  } = _ref3;
  const result = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, request);
  const {
    authorized = {}
  } = securities;
  const security = operation.security || spec.security || [];
  const isAuthorized = authorized && !!Object.keys(authorized).length;
  const securityDef = lodash_get__WEBPACK_IMPORTED_MODULE_1___default()(spec, ['components', 'securitySchemes']) || {};
  result.headers = result.headers || {};
  result.query = result.query || {};
  if (!Object.keys(securities).length || !isAuthorized || !security || Array.isArray(operation.security) && !operation.security.length) {
    return request;
  }
  security.forEach(securityObj => {
    Object.keys(securityObj).forEach(key => {
      const auth = authorized[key];
      const schema = securityDef[key];
      if (!auth) {
        return;
      }
      const value = auth.value || auth;
      const {
        type
      } = schema;
      if (auth) {
        if (type === 'apiKey') {
          if (schema.in === 'query') {
            result.query[schema.name] = value;
          }
          if (schema.in === 'header') {
            result.headers[schema.name] = value;
          }
          if (schema.in === 'cookie') {
            result.cookies[schema.name] = value;
          }
        } else if (type === 'http') {
          if (/^basic$/i.test(schema.scheme)) {
            const username = value.username || '';
            const password = value.password || '';
            const encoded = (0,_helpers_btoa_node_js__WEBPACK_IMPORTED_MODULE_2__["default"])(`${username}:${password}`);
            result.headers.Authorization = `Basic ${encoded}`;
          }
          if (/^bearer$/i.test(schema.scheme)) {
            result.headers.Authorization = `Bearer ${value}`;
          }
        } else if (type === 'oauth2' || type === 'openIdConnect') {
          const token = auth.token || {};
          const tokenName = schema['x-tokenName'] || 'access_token';
          const tokenValue = token[tokenName];
          let tokenType = token.token_type;
          if (!tokenType || tokenType.toLowerCase() === 'bearer') {
            tokenType = 'Bearer';
          }
          result.headers.Authorization = `${tokenType} ${tokenValue}`;
        }
      }
    });
  });
  return result;
}

/***/ }),

/***/ 58922:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ serialize)
/* harmony export */ });
/*
  Serializer that serializes according to a media type instead of OpenAPI's
  `style` + `explode` constructs.
*/

function serialize(value, mediaType) {
  if (mediaType.includes('application/json')) {
    if (typeof value === 'string') {
      // Assume the user has a JSON string
      return value;
    }
    return JSON.stringify(value);
  }
  return value.toString();
}

/***/ }),

/***/ 43655:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cookie": () => (/* binding */ cookie),
/* harmony export */   "header": () => (/* binding */ header),
/* harmony export */   "path": () => (/* binding */ path),
/* harmony export */   "query": () => (/* binding */ query)
/* harmony export */ });
/* harmony import */ var _style_serializer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(56262);
/* harmony import */ var _content_serializer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58922);


function path(_ref) {
  let {
    req,
    value,
    parameter
  } = _ref;
  const {
    name,
    style,
    explode,
    content
  } = parameter;
  if (content) {
    const effectiveMediaType = Object.keys(content)[0];
    req.url = req.url.split(`{${name}}`).join((0,_style_serializer_js__WEBPACK_IMPORTED_MODULE_0__.encodeDisallowedCharacters)((0,_content_serializer_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value, effectiveMediaType), {
      escape: true
    }));
    return;
  }
  const styledValue = (0,_style_serializer_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    key: parameter.name,
    value,
    style: style || 'simple',
    explode: explode || false,
    escape: true
  });
  req.url = req.url.split(`{${name}}`).join(styledValue);
}
function query(_ref2) {
  let {
    req,
    value,
    parameter
  } = _ref2;
  req.query = req.query || {};
  if (parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    const serializedValue = (0,_content_serializer_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value, effectiveMediaType);
    if (serializedValue) {
      req.query[parameter.name] = serializedValue;
    } else if (parameter.allowEmptyValue && value !== undefined) {
      const paramName = parameter.name;
      req.query[paramName] = req.query[paramName] || {};
      req.query[paramName].allowEmptyValue = true;
    }
    return;
  }
  if (value === false) {
    value = 'false';
  }
  if (value === 0) {
    value = '0';
  }
  if (value) {
    const {
      style,
      explode,
      allowReserved
    } = parameter;
    req.query[parameter.name] = {
      value,
      serializationOption: {
        style,
        explode,
        allowReserved
      }
    };
  } else if (parameter.allowEmptyValue && value !== undefined) {
    const paramName = parameter.name;
    req.query[paramName] = req.query[paramName] || {};
    req.query[paramName].allowEmptyValue = true;
  }
}
const PARAMETER_HEADER_BLACKLIST = ['accept', 'authorization', 'content-type'];
function header(_ref3) {
  let {
    req,
    parameter,
    value
  } = _ref3;
  req.headers = req.headers || {};
  if (PARAMETER_HEADER_BLACKLIST.indexOf(parameter.name.toLowerCase()) > -1) {
    return;
  }
  if (parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    req.headers[parameter.name] = (0,_content_serializer_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value, effectiveMediaType);
    return;
  }
  if (typeof value !== 'undefined') {
    req.headers[parameter.name] = (0,_style_serializer_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
      key: parameter.name,
      value,
      style: parameter.style || 'simple',
      explode: typeof parameter.explode === 'undefined' ? false : parameter.explode,
      escape: false
    });
  }
}
function cookie(_ref4) {
  let {
    req,
    parameter,
    value
  } = _ref4;
  req.headers = req.headers || {};
  const type = typeof value;
  if (parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    req.headers.Cookie = `${parameter.name}=${(0,_content_serializer_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value, effectiveMediaType)}`;
    return;
  }
  if (type !== 'undefined') {
    const prefix = type === 'object' && !Array.isArray(value) && parameter.explode ? '' : `${parameter.name}=`;
    req.headers.Cookie = prefix + (0,_style_serializer_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
      key: parameter.name,
      value,
      escape: false,
      style: parameter.style || 'form',
      explode: typeof parameter.explode === 'undefined' ? false : parameter.explode
    });
  }
}

/***/ }),

/***/ 56262:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ stylize),
/* harmony export */   "encodeDisallowedCharacters": () => (/* binding */ encodeDisallowedCharacters)
/* harmony export */ });
const isRfc3986Reserved = char => ":/?#[]@!$&'()*+,;=".indexOf(char) > -1;
const isRrc3986Unreserved = char => /^[a-z0-9\-._~]+$/i.test(char);

// eslint-disable-next-line default-param-last
function encodeDisallowedCharacters(str) {
  let {
    escape
  } = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  let parse = arguments.length > 2 ? arguments[2] : undefined;
  if (typeof str === 'number') {
    str = str.toString();
  }
  if (typeof str !== 'string' || !str.length) {
    return str;
  }
  if (!escape) {
    return str;
  }
  if (parse) {
    return JSON.parse(str);
  }

  // In ES6 you can do this quite easily by using the new ... spread operator.
  // This causes the string iterator (another new ES6 feature) to be used internally,
  // and because that iterator is designed to deal with
  // code points rather than UCS-2/UTF-16 code units.
  return [...str].map(char => {
    if (isRrc3986Unreserved(char)) {
      return char;
    }
    if (isRfc3986Reserved(char) && escape === 'unsafe') {
      return char;
    }
    const encoder = new TextEncoder();
    const encoded = Array.from(encoder.encode(char)).map(byte => `0${byte.toString(16).toUpperCase()}`.slice(-2)).map(encodedByte => `%${encodedByte}`).join('');
    return encoded;
  }).join('');
}
function stylize(config) {
  const {
    value
  } = config;
  if (Array.isArray(value)) {
    return encodeArray(config);
  }
  if (typeof value === 'object') {
    return encodeObject(config);
  }
  return encodePrimitive(config);
}
function encodeArray(_ref) {
  let {
    key,
    value,
    style,
    explode,
    escape
  } = _ref;
  const valueEncoder = str => encodeDisallowedCharacters(str, {
    escape
  });
  if (style === 'simple') {
    return value.map(val => valueEncoder(val)).join(',');
  }
  if (style === 'label') {
    return `.${value.map(val => valueEncoder(val)).join('.')}`;
  }
  if (style === 'matrix') {
    return value.map(val => valueEncoder(val)).reduce((prev, curr) => {
      if (!prev || explode) {
        return `${prev || ''};${key}=${curr}`;
      }
      return `${prev},${curr}`;
    }, '');
  }
  if (style === 'form') {
    const after = explode ? `&${key}=` : ',';
    return value.map(val => valueEncoder(val)).join(after);
  }
  if (style === 'spaceDelimited') {
    const after = explode ? `${key}=` : '';
    return value.map(val => valueEncoder(val)).join(` ${after}`);
  }
  if (style === 'pipeDelimited') {
    const after = explode ? `${key}=` : '';
    return value.map(val => valueEncoder(val)).join(`|${after}`);
  }
  return undefined;
}
function encodeObject(_ref2) {
  let {
    key,
    value,
    style,
    explode,
    escape
  } = _ref2;
  const valueEncoder = str => encodeDisallowedCharacters(str, {
    escape
  });
  const valueKeys = Object.keys(value);
  if (style === 'simple') {
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr]);
      const middleChar = explode ? '=' : ',';
      const prefix = prev ? `${prev},` : '';
      return `${prefix}${curr}${middleChar}${val}`;
    }, '');
  }
  if (style === 'label') {
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr]);
      const middleChar = explode ? '=' : '.';
      const prefix = prev ? `${prev}.` : '.';
      return `${prefix}${curr}${middleChar}${val}`;
    }, '');
  }
  if (style === 'matrix' && explode) {
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr]);
      const prefix = prev ? `${prev};` : ';';
      return `${prefix}${curr}=${val}`;
    }, '');
  }
  if (style === 'matrix') {
    // no explode
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr]);
      const prefix = prev ? `${prev},` : `;${key}=`;
      return `${prefix}${curr},${val}`;
    }, '');
  }
  if (style === 'form') {
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr]);
      const prefix = prev ? `${prev}${explode ? '&' : ','}` : '';
      const separator = explode ? '=' : ',';
      return `${prefix}${curr}${separator}${val}`;
    }, '');
  }
  return undefined;
}
function encodePrimitive(_ref3) {
  let {
    key,
    value,
    style,
    escape
  } = _ref3;
  const valueEncoder = str => encodeDisallowedCharacters(str, {
    escape
  });
  if (style === 'simple') {
    return valueEncoder(value);
  }
  if (style === 'label') {
    return `.${valueEncoder(value)}`;
  }
  if (style === 'matrix') {
    return `;${key}=${valueEncoder(value)}`;
  }
  if (style === 'form') {
    return valueEncoder(value);
  }
  if (style === 'deepObject') {
    return valueEncoder(value, {}, true);
  }
  return undefined;
}

/***/ }),

/***/ 23077:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "applySecurities": () => (/* binding */ applySecurities),
/* harmony export */   "default": () => (/* binding */ buildRequest)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var _helpers_btoa_node_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(602);



// This function runs after the common function,
// `src/execute/index.js#buildRequest`
function buildRequest(options, req) {
  const {
    spec,
    operation,
    securities,
    requestContentType,
    responseContentType,
    attachContentTypeForEmptyPayload
  } = options;
  // Add securities, which are applicable
  req = applySecurities({
    request: req,
    securities,
    operation,
    spec
  });
  if (req.body || req.form || attachContentTypeForEmptyPayload) {
    // all following conditionals are Swagger2 only
    if (requestContentType) {
      req.headers['Content-Type'] = requestContentType;
    } else if (Array.isArray(operation.consumes)) {
      [req.headers['Content-Type']] = operation.consumes;
    } else if (Array.isArray(spec.consumes)) {
      [req.headers['Content-Type']] = spec.consumes;
    } else if (operation.parameters && operation.parameters.filter(p => p.type === 'file').length) {
      req.headers['Content-Type'] = 'multipart/form-data';
    } else if (operation.parameters && operation.parameters.filter(p => p.in === 'formData').length) {
      req.headers['Content-Type'] = 'application/x-www-form-urlencoded';
    }
  } else if (requestContentType) {
    const isBodyParamPresent = operation.parameters && operation.parameters.filter(p => p.in === 'body').length > 0;
    const isFormDataParamPresent = operation.parameters && operation.parameters.filter(p => p.in === 'formData').length > 0;
    if (isBodyParamPresent || isFormDataParamPresent) {
      req.headers['Content-Type'] = requestContentType;
    }
  }
  if (!responseContentType && Array.isArray(operation.produces) && operation.produces.length > 0) {
    req.headers.accept = operation.produces.join(', ');
  }
  return req;
}

// Add security values, to operations - that declare their need on them
function applySecurities(_ref) {
  let {
    request,
    securities = {},
    operation = {},
    spec
  } = _ref;
  const result = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, request);
  const {
    authorized = {},
    specSecurity = []
  } = securities;
  const security = operation.security || specSecurity;
  const isAuthorized = authorized && !!Object.keys(authorized).length;
  const securityDef = spec.securityDefinitions;
  result.headers = result.headers || {};
  result.query = result.query || {};
  if (!Object.keys(securities).length || !isAuthorized || !security || Array.isArray(operation.security) && !operation.security.length) {
    return request;
  }
  security.forEach(securityObj => {
    Object.keys(securityObj).forEach(key => {
      const auth = authorized[key];
      if (!auth) {
        return;
      }
      const {
        token
      } = auth;
      const value = auth.value || auth;
      const schema = securityDef[key];
      const {
        type
      } = schema;
      const tokenName = schema['x-tokenName'] || 'access_token';
      const oauthToken = token && token[tokenName];
      let tokenType = token && token.token_type;
      if (auth) {
        if (type === 'apiKey') {
          const inType = schema.in === 'query' ? 'query' : 'headers';
          result[inType] = result[inType] || {};
          result[inType][schema.name] = value;
        } else if (type === 'basic') {
          if (value.header) {
            result.headers.authorization = value.header;
          } else {
            const username = value.username || '';
            const password = value.password || '';
            value.base64 = (0,_helpers_btoa_node_js__WEBPACK_IMPORTED_MODULE_1__["default"])(`${username}:${password}`);
            result.headers.authorization = `Basic ${value.base64}`;
          }
        } else if (type === 'oauth2' && oauthToken) {
          tokenType = !tokenType || tokenType.toLowerCase() === 'bearer' ? 'Bearer' : tokenType;
          result.headers.authorization = `${tokenType} ${oauthToken}`;
        }
      }
    });
  });
  return result;
}

/***/ }),

/***/ 1382:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// These functions will update the request.
// They'll be given {req, value, paramter, spec, operation}.

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  body: bodyBuilder,
  header: headerBuilder,
  query: queryBuilder,
  path: pathBuilder,
  formData: formDataBuilder
});

// Add the body to the request
function bodyBuilder(_ref) {
  let {
    req,
    value
  } = _ref;
  req.body = value;
}

// Add a form data object.
function formDataBuilder(_ref2) {
  let {
    req,
    value,
    parameter
  } = _ref2;
  if (value || parameter.allowEmptyValue) {
    req.form = req.form || {};
    req.form[parameter.name] = {
      value,
      allowEmptyValue: parameter.allowEmptyValue,
      collectionFormat: parameter.collectionFormat
    };
  }
}

// Add a header to the request
function headerBuilder(_ref3) {
  let {
    req,
    parameter,
    value
  } = _ref3;
  req.headers = req.headers || {};
  if (typeof value !== 'undefined') {
    req.headers[parameter.name] = value;
  }
}

// Replace path paramters, with values ( ie: the URL )
function pathBuilder(_ref4) {
  let {
    req,
    value,
    parameter
  } = _ref4;
  req.url = req.url.split(`{${parameter.name}}`).join(encodeURIComponent(value));
}

// Add a query to the `query` object, which will later be stringified into the URL's search
function queryBuilder(_ref5) {
  let {
    req,
    value,
    parameter
  } = _ref5;
  req.query = req.query || {};
  if (value === false && parameter.type === 'boolean') {
    value = 'false';
  }
  if (value === 0 && ['number', 'integer'].indexOf(parameter.type) > -1) {
    value = '0';
  }
  if (value) {
    req.query[parameter.name] = {
      collectionFormat: parameter.collectionFormat,
      value
    };
  } else if (parameter.allowEmptyValue && value !== undefined) {
    const paramName = parameter.name;
    req.query[paramName] = req.query[paramName] || {};
    req.query[paramName].allowEmptyValue = true;
  }
}

/***/ }),

/***/ 602:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* eslint-disable no-undef, no-restricted-globals */

const globalObject = (() => {
  // new standardized access to the global object
  if (typeof globalThis !== 'undefined') {
    return globalThis;
  }

  // WebWorker specific access
  if (typeof self !== 'undefined') {
    return self;
  }
  return window;
})();
const {
  btoa
} = globalObject;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (btoa);

/***/ }),

/***/ 87191:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ eachOperation)
/* harmony export */ });
// iterate over each operation, and fire a callback with details
// `find=true` will stop iterating, when the cb returns truthy
function eachOperation(spec, cb, find) {
  if (!spec || typeof spec !== 'object' || !spec.paths || typeof spec.paths !== 'object') {
    return null;
  }
  const {
    paths
  } = spec;

  // Iterate over the spec, collecting operations
  // eslint-disable-next-line no-restricted-syntax, guard-for-in
  for (const pathName in paths) {
    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const method in paths[pathName]) {
      if (method.toUpperCase() === 'PARAMETERS') {
        continue; // eslint-disable-line no-continue
      }

      const operation = paths[pathName][method];
      if (!operation || typeof operation !== 'object') {
        continue; // eslint-disable-line no-continue
      }

      const operationObj = {
        spec,
        pathName,
        method: method.toUpperCase(),
        operation
      };
      const cbValue = cb(operationObj);
      if (find && cbValue) {
        return operationObj;
      }
    }
  }
  return undefined;
}

/***/ }),

/***/ 82293:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ findOperation)
/* harmony export */ });
/* harmony import */ var _each_operation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(87191);


// Will stop iterating over the operations and return the operationObj
// as soon as predicate returns true
function findOperation(spec, predicate) {
  return (0,_each_operation_js__WEBPACK_IMPORTED_MODULE_0__["default"])(spec, predicate, true) || null;
}

/***/ }),

/***/ 57656:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOperationRaw)
/* harmony export */ });
/* harmony import */ var _find_operation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82293);
/* harmony import */ var _op_id_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63959);
/* harmony import */ var _id_from_path_method_legacy_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(80486);



function getOperationRaw(spec, id) {
  if (!spec || !spec.paths) {
    return null;
  }
  return (0,_find_operation_js__WEBPACK_IMPORTED_MODULE_0__["default"])(spec, _ref => {
    let {
      pathName,
      method,
      operation
    } = _ref;
    if (!operation || typeof operation !== 'object') {
      return false;
    }
    const rawOperationId = operation.operationId; // straight from the source
    const operationId = (0,_op_id_js__WEBPACK_IMPORTED_MODULE_1__["default"])(operation, pathName, method);
    const legacyOperationId = (0,_id_from_path_method_legacy_js__WEBPACK_IMPORTED_MODULE_2__["default"])(pathName, method);
    return [operationId, legacyOperationId, rawOperationId].some(val => val && val === id);
  });
}

/***/ }),

/***/ 51481:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ idFromPathMethod)
/* harmony export */ });
/* harmony import */ var _replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(87541);

function idFromPathMethod(pathName, method) {
  let {
    v2OperationIdCompatibilityMode
  } = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (v2OperationIdCompatibilityMode) {
    let res = `${method.toLowerCase()}_${pathName}`.replace(/[\s!@#$%^&*()_+=[{\]};:<>|./?,\\'""-]/g, '_');
    res = res || `${pathName.substring(1)}_${method}`;
    return res.replace(/((_){2,})/g, '_').replace(/^(_)*/g, '').replace(/([_])*$/g, '');
  }
  return `${method.toLowerCase()}${(0,_replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__["default"])(pathName)}`;
}

/***/ }),

/***/ 80486:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ idFromPathMethodLegacy)
/* harmony export */ });
function idFromPathMethodLegacy(pathName, method) {
  return `${method.toLowerCase()}-${pathName}`;
}

/***/ }),

/***/ 63959:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ opId)
/* harmony export */ });
/* harmony import */ var _id_from_path_method_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(51481);
/* harmony import */ var _replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(87541);


function opId(operation, pathName) {
  let method = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  let {
    v2OperationIdCompatibilityMode
  } = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  if (!operation || typeof operation !== 'object') {
    return null;
  }
  const idWithoutWhitespace = (operation.operationId || '').replace(/\s/g, '');
  if (idWithoutWhitespace.length) {
    return (0,_replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__["default"])(operation.operationId);
  }
  return (0,_id_from_path_method_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])(pathName, method, {
    v2OperationIdCompatibilityMode
  });
}

/***/ }),

/***/ 59809:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isOpenAPI2": () => (/* binding */ isOpenAPI2),
/* harmony export */   "isOpenAPI3": () => (/* binding */ isOpenAPI3),
/* harmony export */   "isOpenAPI30": () => (/* binding */ isOpenAPI30),
/* harmony export */   "isOpenAPI31": () => (/* binding */ isOpenAPI31),
/* harmony export */   "isSwagger2": () => (/* binding */ isOpenAPI2)
/* harmony export */ });
const isOpenAPI2 = spec => {
  try {
    const {
      swagger
    } = spec;
    return swagger === '2.0';
  } catch {
    return false;
  }
};
const isOpenAPI30 = spec => {
  try {
    const {
      openapi
    } = spec;
    return typeof openapi === 'string' && /^3\.0\.([0123])(?:-rc[012])?$/.test(openapi);
  } catch {
    return false;
  }
};
const isOpenAPI31 = spec => {
  try {
    const {
      openapi
    } = spec;
    return typeof openapi === 'string' && /^3\.1\.(?:[1-9]\d*|0)$/.test(openapi);
  } catch {
    return false;
  }
};
const isOpenAPI3 = spec => isOpenAPI30(spec) || isOpenAPI31(spec);

// backward compatibility export


/***/ }),

/***/ 87541:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const replaceSpecialCharsWithUnderscore = operationId => operationId.replace(/\W/gi, '_');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (replaceSpecialCharsWithUnderscore);

/***/ }),

/***/ 47489:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const foldFormDataToRequest = (formdata, request) => {
  request.body = formdata;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (foldFormDataToRequest);

/***/ }),

/***/ 28288:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ http),
/* harmony export */   "encodeFormOrQuery": () => (/* binding */ encodeFormOrQuery),
/* harmony export */   "isFile": () => (/* binding */ isFile),
/* harmony export */   "makeHttp": () => (/* binding */ makeHttp),
/* harmony export */   "mergeInQueryOrForm": () => (/* binding */ mergeInQueryOrForm),
/* harmony export */   "self": () => (/* binding */ self),
/* harmony export */   "serializeHeaders": () => (/* binding */ serializeHeaders),
/* harmony export */   "serializeRes": () => (/* binding */ serializeRes),
/* harmony export */   "shouldDownloadAsText": () => (/* binding */ shouldDownloadAsText)
/* harmony export */ });
/* harmony import */ var cross_fetch_polyfill__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9559);
/* harmony import */ var cross_fetch_polyfill__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(cross_fetch_polyfill__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80129);
/* harmony import */ var qs__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(qs__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1272);
/* harmony import */ var formdata_node__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37824);
/* harmony import */ var _execute_oas3_style_serializer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(56262);
/* harmony import */ var _fold_formdata_to_request_node_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47489);







// For testing
const self = {
  serializeRes,
  mergeInQueryOrForm
};

// Handles fetch-like syntax and the case where there is only one object passed-in
// (which will have the URL as a property). Also serilizes the response.
async function http(url) {
  let request = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  if (typeof url === 'object') {
    request = url;
    url = request.url;
  }
  request.headers = request.headers || {};

  // Serializes query, for convenience
  // Should be the last thing we do, as its hard to mutate the URL with
  // the search string, but much easier to manipulate the req.query object
  self.mergeInQueryOrForm(request);

  // Newlines in header values cause weird error messages from `window.fetch`,
  // so let's massage them out.
  // Context: https://stackoverflow.com/a/50709178
  if (request.headers) {
    Object.keys(request.headers).forEach(headerName => {
      const value = request.headers[headerName];
      if (typeof value === 'string') {
        request.headers[headerName] = value.replace(/\n+/g, ' ');
      }
    });
  }

  // Wait for the request interceptor, if it was provided
  // WARNING: don't put anything between this and the request firing unless
  // you have a good reason!
  if (request.requestInterceptor) {
    request = (await request.requestInterceptor(request)) || request;
  }

  // for content-type=multipart\/form-data remove content-type from request before fetch
  // so that correct one with `boundary` is set when request body is different than boundary encoded string
  const contentType = request.headers['content-type'] || request.headers['Content-Type'];
  // TODO(vladimir.gorej@gmail.com): assertion of FormData instance can be removed when migrated to node-fetch@2.x
  if (/multipart\/form-data/i.test(contentType) && request.body instanceof formdata_node__WEBPACK_IMPORTED_MODULE_3__.FormData) {
    delete request.headers['content-type'];
    delete request.headers['Content-Type'];
  }

  // eslint-disable-next-line no-undef
  let res;
  try {
    res = await (request.userFetch || fetch)(request.url, request);
    res = await self.serializeRes(res, url, request);
    if (request.responseInterceptor) {
      res = (await request.responseInterceptor(res)) || res;
    }
  } catch (resError) {
    if (!res) {
      // res is completely absent, so we can't construct our own error
      // so we'll just throw the error we got
      throw resError;
    }
    const error = new Error(res.statusText || `response status is ${res.status}`);
    error.status = res.status;
    error.statusCode = res.status;
    error.responseError = resError;
    throw error;
  }
  if (!res.ok) {
    const error = new Error(res.statusText || `response status is ${res.status}`);
    error.status = res.status;
    error.statusCode = res.status;
    error.response = res;
    throw error;
  }
  return res;
}

// exported for testing
const shouldDownloadAsText = function () {
  let contentType = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  return /(json|xml|yaml|text)\b/.test(contentType);
};
function parseBody(body, contentType) {
  if (contentType && (contentType.indexOf('application/json') === 0 || contentType.indexOf('+json') > 0)) {
    return JSON.parse(body);
  }
  return js_yaml__WEBPACK_IMPORTED_MODULE_2__["default"].load(body);
}

// Serialize the response, returns a promise with headers and the body part of the hash
function serializeRes(oriRes, url) {
  let {
    loadSpec = false
  } = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const res = {
    ok: oriRes.ok,
    url: oriRes.url || url,
    status: oriRes.status,
    statusText: oriRes.statusText,
    headers: serializeHeaders(oriRes.headers)
  };
  const contentType = res.headers['content-type'];
  const useText = loadSpec || shouldDownloadAsText(contentType);
  const getBody = useText ? oriRes.text : oriRes.blob || oriRes.buffer;
  return getBody.call(oriRes).then(body => {
    res.text = body;
    res.data = body;
    if (useText) {
      try {
        const obj = parseBody(body, contentType);
        res.body = obj;
        res.obj = obj;
      } catch (e) {
        res.parseError = e;
      }
    }
    return res;
  });
}
function serializeHeaderValue(value) {
  const isMulti = value.includes(', ');
  return isMulti ? value.split(', ') : value;
}

// Serialize headers into a hash, where mutliple-headers result in an array.
//
// eg: Cookie: one
//     Cookie: two
//  =  { Cookie: [ "one", "two" ]
function serializeHeaders() {
  let headers = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  if (typeof headers.entries !== 'function') return {};
  return Array.from(headers.entries()).reduce((acc, _ref) => {
    let [header, value] = _ref;
    acc[header] = serializeHeaderValue(value);
    return acc;
  }, {});
}
function isFile(obj, navigatorObj) {
  if (!navigatorObj && typeof navigator !== 'undefined') {
    // eslint-disable-next-line no-undef
    navigatorObj = navigator;
  }
  if (navigatorObj && navigatorObj.product === 'ReactNative') {
    if (obj && typeof obj === 'object' && typeof obj.uri === 'string') {
      return true;
    }
    return false;
  }
  if (typeof formdata_node__WEBPACK_IMPORTED_MODULE_3__.File !== 'undefined' && obj instanceof formdata_node__WEBPACK_IMPORTED_MODULE_3__.File) {
    return true;
  }
  if (typeof formdata_node__WEBPACK_IMPORTED_MODULE_3__.Blob !== 'undefined' && obj instanceof formdata_node__WEBPACK_IMPORTED_MODULE_3__.Blob) {
    return true;
  }
  if (ArrayBuffer.isView(obj)) {
    return true;
  }
  return obj !== null && typeof obj === 'object' && typeof obj.pipe === 'function';
}
function isArrayOfFile(obj, navigatorObj) {
  return Array.isArray(obj) && obj.some(v => isFile(v, navigatorObj));
}
const STYLE_SEPARATORS = {
  form: ',',
  spaceDelimited: '%20',
  pipeDelimited: '|'
};
const SEPARATORS = {
  csv: ',',
  ssv: '%20',
  tsv: '%09',
  pipes: '|'
};

// Formats a key-value and returns an array of key-value pairs.
//
// Return value example 1: [['color', 'blue']]
// Return value example 2: [['color', 'blue,black,brown']]
// Return value example 3: [['color', ['blue', 'black', 'brown']]]
// Return value example 4: [['color', 'R,100,G,200,B,150']]
// Return value example 5: [['R', '100'], ['G', '200'], ['B', '150']]
// Return value example 6: [['color[R]', '100'], ['color[G]', '200'], ['color[B]', '150']]
function formatKeyValue(key, input) {
  let skipEncoding = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  const {
    collectionFormat,
    allowEmptyValue,
    serializationOption,
    encoding
  } = input;
  // `input` can be string
  const value = typeof input === 'object' && !Array.isArray(input) ? input.value : input;
  const encodeFn = skipEncoding ? k => k.toString() : k => encodeURIComponent(k);
  const encodedKey = encodeFn(key);
  if (typeof value === 'undefined' && allowEmptyValue) {
    return [[encodedKey, '']];
  }

  // file
  if (isFile(value) || isArrayOfFile(value)) {
    return [[encodedKey, value]];
  }

  // for OAS 3 Parameter Object for serialization
  if (serializationOption) {
    return formatKeyValueBySerializationOption(key, value, skipEncoding, serializationOption);
  }

  // for OAS 3 Encoding Object
  if (encoding) {
    if ([typeof encoding.style, typeof encoding.explode, typeof encoding.allowReserved].some(type => type !== 'undefined')) {
      const {
        style,
        explode,
        allowReserved
      } = encoding;
      return formatKeyValueBySerializationOption(key, value, skipEncoding, {
        style,
        explode,
        allowReserved
      });
    }
    if (encoding.contentType) {
      if (encoding.contentType === 'application/json') {
        // If value is a string, assume value is already a JSON string
        const json = typeof value === 'string' ? value : JSON.stringify(value);
        return [[encodedKey, encodeFn(json)]];
      }
      return [[encodedKey, encodeFn(value.toString())]];
    }

    // Primitive
    if (typeof value !== 'object') {
      return [[encodedKey, encodeFn(value)]];
    }

    // Array of primitives
    if (Array.isArray(value) && value.every(v => typeof v !== 'object')) {
      return [[encodedKey, value.map(encodeFn).join(',')]];
    }

    // Array or object
    return [[encodedKey, encodeFn(JSON.stringify(value))]];
  }

  // for OAS 2 Parameter Object
  // Primitive
  if (typeof value !== 'object') {
    return [[encodedKey, encodeFn(value)]];
  }

  // Array
  if (Array.isArray(value)) {
    if (collectionFormat === 'multi') {
      // In case of multipart/formdata, it is used as array.
      // Otherwise, the caller will convert it to a query by qs.stringify.
      return [[encodedKey, value.map(encodeFn)]];
    }
    return [[encodedKey, value.map(encodeFn).join(SEPARATORS[collectionFormat || 'csv'])]];
  }

  // Object
  return [[encodedKey, '']];
}
function formatKeyValueBySerializationOption(key, value, skipEncoding, serializationOption) {
  const style = serializationOption.style || 'form';
  const explode = typeof serializationOption.explode === 'undefined' ? style === 'form' : serializationOption.explode;
  // eslint-disable-next-line no-nested-ternary
  const escape = skipEncoding ? false : serializationOption && serializationOption.allowReserved ? 'unsafe' : 'reserved';
  const encodeFn = v => (0,_execute_oas3_style_serializer_js__WEBPACK_IMPORTED_MODULE_4__.encodeDisallowedCharacters)(v, {
    escape
  });
  const encodeKeyFn = skipEncoding ? k => k : k => (0,_execute_oas3_style_serializer_js__WEBPACK_IMPORTED_MODULE_4__.encodeDisallowedCharacters)(k, {
    escape
  });

  // Primitive
  if (typeof value !== 'object') {
    return [[encodeKeyFn(key), encodeFn(value)]];
  }

  // Array
  if (Array.isArray(value)) {
    if (explode) {
      // In case of multipart/formdata, it is used as array.
      // Otherwise, the caller will convert it to a query by qs.stringify.
      return [[encodeKeyFn(key), value.map(encodeFn)]];
    }
    return [[encodeKeyFn(key), value.map(encodeFn).join(STYLE_SEPARATORS[style])]];
  }

  // Object
  if (style === 'deepObject') {
    return Object.keys(value).map(valueKey => [encodeKeyFn(`${key}[${valueKey}]`), encodeFn(value[valueKey])]);
  }
  if (explode) {
    return Object.keys(value).map(valueKey => [encodeKeyFn(valueKey), encodeFn(value[valueKey])]);
  }
  return [[encodeKeyFn(key), Object.keys(value).map(valueKey => [`${encodeKeyFn(valueKey)},${encodeFn(value[valueKey])}`]).join(',')]];
}
function buildFormData(reqForm) {
  /**
   * Build a new FormData instance, support array as field value
   * OAS2.0 - when collectionFormat is multi
   * OAS3.0 - when explode of Encoding Object is true
   *
   * This function explicitly handles Buffers (for backward compatibility)
   * if provided as a values to FormData. FormData can only handle USVString
   * or Blob.
   *
   * @param {Object} reqForm - ori req.form
   * @return {FormData} - new FormData instance
   */
  return Object.entries(reqForm).reduce((formData, _ref2) => {
    let [name, input] = _ref2;
    // eslint-disable-next-line no-restricted-syntax
    for (const [key, value] of formatKeyValue(name, input, true)) {
      if (Array.isArray(value)) {
        // eslint-disable-next-line no-restricted-syntax
        for (const v of value) {
          if (ArrayBuffer.isView(v)) {
            const blob = new formdata_node__WEBPACK_IMPORTED_MODULE_3__.Blob([v]);
            formData.append(key, blob);
          } else {
            formData.append(key, v);
          }
        }
      } else if (ArrayBuffer.isView(value)) {
        const blob = new formdata_node__WEBPACK_IMPORTED_MODULE_3__.Blob([value]);
        formData.append(key, blob);
      } else {
        formData.append(key, value);
      }
    }
    return formData;
  }, new formdata_node__WEBPACK_IMPORTED_MODULE_3__.FormData());
}

// Encodes an object using appropriate serializer.
function encodeFormOrQuery(data) {
  /**
   * Encode parameter names and values
   * @param {Object} result - parameter names and values
   * @param {string} parameterName - Parameter name
   * @return {object} encoded parameter names and values
   */
  const encodedQuery = Object.keys(data).reduce((result, parameterName) => {
    // eslint-disable-next-line no-restricted-syntax
    for (const [key, value] of formatKeyValue(parameterName, data[parameterName])) {
      result[key] = value;
    }
    return result;
  }, {});
  return qs__WEBPACK_IMPORTED_MODULE_1___default().stringify(encodedQuery, {
    encode: false,
    indices: false
  }) || '';
}

// If the request has a `query` object, merge it into the request.url, and delete the object
// If file and/or multipart, also create FormData instance
function mergeInQueryOrForm() {
  let req = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const {
    url = '',
    query,
    form
  } = req;
  const joinSearch = function () {
    for (var _len = arguments.length, strs = new Array(_len), _key = 0; _key < _len; _key++) {
      strs[_key] = arguments[_key];
    }
    const search = strs.filter(a => a).join('&'); // Only truthy value
    return search ? `?${search}` : ''; // Only add '?' if there is a str
  };

  if (form) {
    const hasFile = Object.keys(form).some(key => {
      const {
        value
      } = form[key];
      return isFile(value) || isArrayOfFile(value);
    });
    const contentType = req.headers['content-type'] || req.headers['Content-Type'];
    if (hasFile || /multipart\/form-data/i.test(contentType)) {
      const formdata = buildFormData(req.form);
      (0,_fold_formdata_to_request_node_js__WEBPACK_IMPORTED_MODULE_5__["default"])(formdata, req);
    } else {
      req.body = encodeFormOrQuery(form);
    }
    delete req.form;
  }
  if (query) {
    const [baseUrl, oriSearch] = url.split('?');
    let newStr = '';
    if (oriSearch) {
      const oriQuery = qs__WEBPACK_IMPORTED_MODULE_1___default().parse(oriSearch);
      const keysToRemove = Object.keys(query);
      keysToRemove.forEach(key => delete oriQuery[key]);
      newStr = qs__WEBPACK_IMPORTED_MODULE_1___default().stringify(oriQuery, {
        encode: true
      });
    }
    const finalStr = joinSearch(newStr, encodeFormOrQuery(query));
    req.url = baseUrl + finalStr;
    delete req.query;
  }
  return req;
}

// Wrap a http function ( there are otherways to do this, consider this deprecated )
function makeHttp(httpFn, preFetch, postFetch) {
  postFetch = postFetch || (a => a);
  preFetch = preFetch || (a => a);
  return req => {
    if (typeof req === 'string') {
      req = {
        url: req
      };
    }
    self.mergeInQueryOrForm(req);
    req = preFetch(req);
    return postFetch(httpFn(req));
  };
}

/***/ }),

/***/ 62138:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "makeApisTagOperation": () => (/* binding */ makeApisTagOperation),
/* harmony export */   "makeApisTagOperationsOperationExecute": () => (/* binding */ makeApisTagOperationsOperationExecute),
/* harmony export */   "makeExecute": () => (/* binding */ makeExecute),
/* harmony export */   "mapTagOperations": () => (/* binding */ mapTagOperations),
/* harmony export */   "self": () => (/* binding */ self)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87191);
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63959);


const nullFn = () => null;
const normalizeArray = arg => Array.isArray(arg) ? arg : [arg];

// To allow stubbing of functions
const self = {
  mapTagOperations,
  makeExecute
};

// Make an execute, bound to arguments defined in mapTagOperation's callback (cb)
function makeExecute() {
  let swaggerJs = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return _ref => {
    let {
      pathName,
      method,
      operationId
    } = _ref;
    return function (parameters) {
      let opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      const {
        requestInterceptor,
        responseInterceptor,
        userFetch
      } = swaggerJs;
      return swaggerJs.execute((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({
        spec: swaggerJs.spec,
        requestInterceptor,
        responseInterceptor,
        userFetch,
        pathName,
        method,
        parameters,
        operationId
      }, opts));
    };
  };
}

// Creates an interface with tags+operations = execute
// The shape
// { apis: { [tag]: { operations: [operation]: { execute }}}}
// NOTE: this is mostly for compatibility
function makeApisTagOperationsOperationExecute() {
  let swaggerJs = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  // { apis: tag: operations: execute }
  const cb = self.makeExecute(swaggerJs);
  const tagOperations = self.mapTagOperations({
    v2OperationIdCompatibilityMode: swaggerJs.v2OperationIdCompatibilityMode,
    spec: swaggerJs.spec,
    cb
  });
  const apis = {};
  // eslint-disable-next-line no-restricted-syntax, guard-for-in
  for (const tag in tagOperations) {
    apis[tag] = {
      operations: {}
    };
    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const op in tagOperations[tag]) {
      apis[tag].operations[op] = {
        execute: tagOperations[tag][op]
      };
    }
  }
  return {
    apis
  };
}

// .apis[tag][operationId]:ExecuteFunction interface
function makeApisTagOperation() {
  let swaggerJs = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const cb = self.makeExecute(swaggerJs);
  return {
    apis: self.mapTagOperations({
      v2OperationIdCompatibilityMode: swaggerJs.v2OperationIdCompatibilityMode,
      spec: swaggerJs.spec,
      cb
    })
  };
}

/**
 * Iterates over a spec, creating a hash of {[tag]: { [operationId], ... }, ...}
 * with the value of calling `cb`.
 *
 * `spec` is a OAI v2.0 compliant specification object
 * `cb` is called with ({ spec, operation, path, method })
 * `defaultTag` will house all non-tagged operations
 *
 */
function mapTagOperations(_ref2) {
  let {
    spec,
    cb = nullFn,
    defaultTag = 'default',
    v2OperationIdCompatibilityMode
  } = _ref2;
  const operationIdCounter = {};
  const tagOperations = {}; // Will house all tags + operations
  (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])(spec, _ref3 => {
    let {
      pathName,
      method,
      operation
    } = _ref3;
    const tags = operation.tags ? normalizeArray(operation.tags) : [defaultTag];
    tags.forEach(tag => {
      if (typeof tag !== 'string') {
        return;
      }
      tagOperations[tag] = tagOperations[tag] || {};
      const tagObj = tagOperations[tag];
      const id = (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_2__["default"])(operation, pathName, method, {
        v2OperationIdCompatibilityMode
      });
      const cbResult = cb({
        spec,
        pathName,
        method,
        operation,
        operationId: id
      });
      if (operationIdCounter[id]) {
        operationIdCounter[id] += 1;
        tagObj[`${id}${operationIdCounter[id]}`] = cbResult;
      } else if (typeof tagObj[id] !== 'undefined') {
        // Bump counter ( for this operationId )
        const originalCounterValue = operationIdCounter[id] || 1;
        operationIdCounter[id] = originalCounterValue + 1;
        // Append _x to the operationId
        tagObj[`${id}${operationIdCounter[id]}`] = cbResult;

        // Rename the first operationId
        const temp = tagObj[id];
        delete tagObj[id];
        tagObj[`${id}${originalCounterValue}`] = temp;
      } else {
        // Assign callback result ( usually a bound function )
        tagObj[id] = cbResult;
      }
    });
  });
  return tagOperations;
}

/***/ }),

/***/ 75754:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SchemaRefError": () => (/* binding */ SchemaRefError)
/* harmony export */ });
/* harmony import */ var _specmap_lib_create_error_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83393);


// eslint-disable-next-line import/prefer-default-export
const SchemaRefError = (0,_specmap_lib_create_error_js__WEBPACK_IMPORTED_MODULE_0__["default"])('SchemaRefError', function cb(message, extra, oriError) {
  this.originalError = oriError;
  Object.assign(this, extra || {});
});

/***/ }),

/***/ 7662:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(66175);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(75757);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(32674);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(63595);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(39816);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(93193);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(29540);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(37988);
/* harmony import */ var _visitors_dereference_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(49154);
/* harmony import */ var _visitors_parameters_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(62042);
/* harmony import */ var _visitors_properties_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58618);
/* harmony import */ var _visitors_all_of_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59284);
/* eslint-disable camelcase */








const visitAsync = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.visit[Symbol.for('nodejs.util.promisify.custom')];
const OpenApi3_1SwaggerClientDereferenceStrategy = _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__["default"].compose({
  props: {
    useCircularStructures: true,
    allowMetaPatches: false,
    parameterMacro: null,
    modelPropertyMacro: null,
    mode: 'non-strict'
  },
  init() {
    let {
      useCircularStructures = this.useCircularStructures,
      allowMetaPatches = this.allowMetaPatches,
      parameterMacro = this.parameterMacro,
      modelPropertyMacro = this.modelPropertyMacro,
      mode = this.mode
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    this.name = 'openapi-3-1-swagger-client';
    this.useCircularStructures = useCircularStructures;
    this.allowMetaPatches = allowMetaPatches;
    this.parameterMacro = parameterMacro;
    this.modelPropertyMacro = modelPropertyMacro;
    this.mode = mode;
  },
  methods: {
    async dereference(file, options) {
      const visitors = [];
      const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.createNamespace)(_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_7__["default"]);
      const refSet = options.dereference.refSet ?? (0,_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_8__["default"])();
      let reference;
      if (!refSet.has(file.uri)) {
        reference = (0,_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_9__["default"])({
          uri: file.uri,
          value: file.parseResult
        });
        refSet.add(reference);
      } else {
        // pre-computed refSet was provided as configuration option
        reference = refSet.find(ref => ref.uri === file.uri);
      }

      // create main dereference visitor
      const dereferenceVisitor = (0,_visitors_dereference_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
        reference,
        namespace,
        options,
        useCircularStructures: this.useCircularStructures,
        allowMetaPatches: this.allowMetaPatches
      });
      visitors.push(dereferenceVisitor);

      // create parameter macro visitor (if necessary)
      if (typeof this.parameterMacro === 'function') {
        const parameterMacroVisitor = (0,_visitors_parameters_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
          parameterMacro: this.parameterMacro,
          options
        });
        visitors.push(parameterMacroVisitor);
      }

      // create model property macro visitor (if necessary)
      if (typeof this.modelPropertyMacro === 'function') {
        const modelPropertyMacroVisitor = (0,_visitors_properties_js__WEBPACK_IMPORTED_MODULE_2__["default"])({
          modelPropertyMacro: this.modelPropertyMacro,
          options
        });
        visitors.push(modelPropertyMacroVisitor);
      }

      // create allOf visitor (if necessary)
      if (this.mode !== 'strict') {
        const allOfVisitor = (0,_visitors_all_of_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
          options
        });
        visitors.push(allOfVisitor);
      }

      // establish root visitor by visitor merging
      const rootVisitor = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__.mergeAll)(visitors, {
        nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__.getNodeType
      });
      const dereferencedElement = await visitAsync(refSet.rootRef.value, rootVisitor, {
        keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__.keyMap,
        nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__.getNodeType
      });

      /**
       * Release all memory if this refSet was not provided as a configuration option.
       * If provided as configuration option, then provider is responsible for cleanup.
       */
      if (options.dereference.refSet === null) {
        refSet.clean();
      }
      return dereferencedElement;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenApi3_1SwaggerClientDereferenceStrategy);
/* eslint-enable camelcase */

/***/ }),

/***/ 58384:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(93193);
/* eslint-disable camelcase */

const compose = _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_0__["default"].compose.bind();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (compose);
/* eslint-enable camelcase */

/***/ }),

/***/ 28495:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Retrieves the root cause of ApiDOM error hierarchy.
 * ApiDOM error hierarchies are modeled similar to Java.
 * Every error can have cause attribute which references
 * cause of this error.
 */
const getRootCause = error => {
  if (error.cause == null) return error;
  let {
    cause
  } = error;
  while (cause.cause != null) {
    cause = cause.cause;
  }
  return cause;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getRootCause);

/***/ }),

/***/ 21352:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67277);

const trimParseResult = elementPath => elementPath.slice(2);

/**
 * Transforms ApiDOM traversal meta information into
 * SwaggerClient compatible path.
 *
 * SwaggerClient path is a list of JSON Pointer tokens.
 */
const toPath = elementPath => {
  const elementPathSanitized = trimParseResult(elementPath);
  return elementPathSanitized.reduce((path, element, index) => {
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isMemberElement)(element)) {
      const token = String(element.key.toValue());
      path.push(token);
    } else if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isArrayElement)(elementPathSanitized[index - 2])) {
      const token = elementPathSanitized[index - 2].content.indexOf(element);
      path.push(token);
    }
    return path;
  }, []);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toPath);

/***/ }),

/***/ 59284:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67277);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(91145);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(64614);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(94022);
/* harmony import */ var _utils_compose_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58384);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(21352);




const AllOfVisitor = (0,_utils_compose_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
  init(_ref) {
    let {
      options
    } = _ref;
    this.options = options;
  },
  props: {
    options: null,
    SchemaElement: {
      leave(schemaElement, key, parent, path, ancestors) {
        // do nothing
        if (typeof schemaElement.allOf === 'undefined') return undefined;

        // collect error and return if allOf keyword is not an array
        if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isArrayElement)(schemaElement.allOf)) {
          const error = new TypeError('allOf must be an array');
          error.fullPath = [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_2__["default"])([...ancestors, parent, schemaElement]), 'allOf'];
          this.options.dereference.dereferenceOpts?.errors?.push?.(error);
          return undefined;
        }

        // remove allOf keyword if empty
        if (schemaElement.allOf.isEmpty) {
          return new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_3__.SchemaElement(schemaElement.content.filter(memberElement => memberElement.key.toValue() !== 'allOf'), schemaElement.meta.clone(), schemaElement.attributes.clone());
        }

        // collect errors if allOf keyword contains anything else than Schema Object
        const includesSchemaElementOnly = schemaElement.allOf.content.every(_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__.isSchemaElement);
        if (!includesSchemaElementOnly) {
          const error = new TypeError('Elements in allOf must be objects');
          error.fullPath = [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_2__["default"])([...ancestors, parent, schemaElement]), 'allOf'];
          this.options.dereference.dereferenceOpts?.errors?.push?.(error);
          return undefined;
        }
        const mergedSchemaElement = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"].all([...schemaElement.allOf.content, schemaElement]);

        /**
         * If there was not an original $$ref value, make sure to remove
         * any $$ref value that may exist from the result of `allOf` merges.
         */
        if (!schemaElement.hasKey('$$ref')) {
          mergedSchemaElement.remove('$$ref');
        }

        /**
         * If there was an example keyword in the original definition,
         * keep it instead of merging with example from other schema.
         */
        if (schemaElement.hasKey('example')) {
          const member = mergedSchemaElement.getMember('example');
          member.value = schemaElement.get('example');
        }

        /**
         * If there was an examples keyword in the original definition,
         * keep it instead of merging with examples from other schema.
         */
        if (schemaElement.hasKey('examples')) {
          const member = mergedSchemaElement.getMember('examples');
          member.value = schemaElement.get('examples');
        }

        // remove allOf keyword after the merge
        mergedSchemaElement.remove('allOf');
        return mergedSchemaElement;
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AllOfVisitor);

/***/ }),

/***/ 49154:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66175);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(67277);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(94022);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(21066);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(64614);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(37988);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(77782);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8549);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(86144);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(49512);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82144);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(49021);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(24634);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(96930);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(51454);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(21352);
/* harmony import */ var _utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(28495);
/* harmony import */ var _specmap_lib_refs_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58569);
/* harmony import */ var _errors_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75754);
/* eslint-disable camelcase */











const {
  wrapError
} = _specmap_lib_refs_js__WEBPACK_IMPORTED_MODULE_0__["default"];
const visitAsync = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.visit[Symbol.for('nodejs.util.promisify.custom')];
const OpenApi3_1SwaggerClientDereferenceVisitor = _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_3__["default"].compose({
  props: {
    useCircularStructures: true,
    allowMetaPatches: false,
    basePath: null
  },
  init(_ref) {
    let {
      allowMetaPatches = this.allowMetaPatches,
      useCircularStructures = this.useCircularStructures,
      basePath = this.basePath
    } = _ref;
    this.allowMetaPatches = allowMetaPatches;
    this.useCircularStructures = useCircularStructures;
    this.basePath = basePath;
  },
  methods: {
    async ReferenceElement(referenceElement, key, parent, path, ancestors) {
      try {
        const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

        // skip already identified cycled Path Item Objects
        if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.includesClasses)(['cycle'], referenceElement.$ref)) {
          return false;
        }

        // detect possible cycle in traversal and avoid it
        if (ancestorsLineage.some(ancs => ancs.has(referenceElement))) {
          // skip processing this schema and all it's child schemas
          return false;
        }

        // ignore resolving external Reference Objects
        if (!this.options.resolve.external && (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__.isReferenceElementExternal)(referenceElement)) {
          return false;
        }
        const reference = await this.toReference(referenceElement.$ref.toValue());
        const retrievalURI = reference.uri;
        const $refBaseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, referenceElement.$ref.toValue());
        this.indirections.push(referenceElement);
        const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);

        // possibly non-semantic fragment
        let fragment = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.evaluate)(jsonPointer, reference.value.result);

        // applying semantics to a fragment
        if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isPrimitiveElement)(fragment)) {
          const referencedElementType = referenceElement.meta.get('referenced-element').toValue();
          if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__.isReferenceLikeElement)(fragment)) {
            // handling indirect references
            fragment = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__.ReferenceElement.refract(fragment);
            fragment.setMetaProperty('referenced-element', referencedElementType);
          } else {
            // handling direct references
            const ElementClass = this.namespace.getElementClass(referencedElementType);
            fragment = ElementClass.refract(fragment);
          }
        }

        // detect direct or indirect reference
        if (this.indirections.includes(fragment)) {
          throw new Error('Recursive JSON Pointer detected');
        }

        // detect maximum depth of dereferencing
        if (this.indirections.length > this.options.dereference.maxDepth) {
          throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_10__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
        }

        // append referencing schema to ancestors lineage
        directAncestors.add(referenceElement);

        // dive deep into the fragment
        const visitor = OpenApi3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_11__["default"])([...ancestors, parent, referenceElement]), '$ref']
        });
        fragment = await visitAsync(fragment, visitor, {
          keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__.keyMap,
          nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(referenceElement);
        this.indirections.pop();
        if (!this.useCircularStructures) {
          const hasCycles = ancestorsLineage.some(ancs => ancs.has(fragment));
          if (hasCycles) {
            if (_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.isHttpUrl(retrievalURI) || _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.isFileSystemPath(retrievalURI)) {
              // make the referencing URL or file system path absolute
              const cycledReferenceElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__.ReferenceElement({
                $ref: $refBaseURI
              }, referenceElement.meta.clone(), referenceElement.attributes.clone());
              cycledReferenceElement.get('$ref').classes.push('cycle');
              return cycledReferenceElement;
            }
            // skip processing this schema but traverse all it's child schemas
            return false;
          }
        }
        fragment = fragment.clone();
        fragment.setMetaProperty('ref-fields', {
          $ref: referenceElement.$ref?.toValue(),
          description: referenceElement.description?.toValue(),
          summary: referenceElement.summary?.toValue()
        });
        // annotate fragment with info about origin
        fragment.setMetaProperty('ref-origin', reference.uri);

        // override description and summary (outer has higher priority then inner)
        const hasDescription = typeof referenceElement.description !== 'undefined';
        const hasSummary = typeof referenceElement.summary !== 'undefined';
        if (hasDescription && 'description' in fragment) {
          fragment.description = referenceElement.description;
        }
        if (hasSummary && 'summary' in fragment) {
          fragment.summary = referenceElement.summary;
        }

        // apply meta patches
        if (this.allowMetaPatches && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isObjectElement)(fragment)) {
          const objectFragment = fragment;
          // apply meta patch only when not already applied
          if (typeof objectFragment.get('$$ref') === 'undefined') {
            const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
            objectFragment.set('$$ref', baseURI);
          }
        }

        // transclude the element for a fragment
        return fragment;
      } catch (error) {
        const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_13__["default"])(error);
        const wrappedError = wrapError(rootCause, {
          baseDoc: this.reference.uri,
          $ref: referenceElement.$ref.toValue(),
          pointer: (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)(referenceElement.$ref.toValue()),
          fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_11__["default"])([...ancestors, parent, referenceElement]), '$ref']
        });
        this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
        return undefined;
      }
    },
    async PathItemElement(pathItemElement, key, parent, path, ancestors) {
      try {
        const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

        // ignore PathItemElement without $ref field
        if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isStringElement)(pathItemElement.$ref)) {
          return undefined;
        }

        // skip already identified cycled Path Item Objects
        if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.includesClasses)(['cycle'], pathItemElement.$ref)) {
          return false;
        }

        // detect possible cycle in traversal and avoid it
        if (ancestorsLineage.some(ancs => ancs.has(pathItemElement))) {
          // skip processing this schema and all it's child schemas
          return false;
        }

        // ignore resolving external Path Item Elements
        if (!this.options.resolve.external && (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__.isPathItemElementExternal)(pathItemElement)) {
          return undefined;
        }
        const reference = await this.toReference(pathItemElement.$ref.toValue());
        const retrievalURI = reference.uri;
        const $refBaseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, pathItemElement.$ref.toValue());
        this.indirections.push(pathItemElement);
        const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);

        // possibly non-semantic referenced element
        let referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.evaluate)(jsonPointer, reference.value.result);

        // applying semantics to a referenced element
        if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isPrimitiveElement)(referencedElement)) {
          referencedElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__.PathItemElement.refract(referencedElement);
        }

        // detect direct or indirect reference
        if (this.indirections.includes(referencedElement)) {
          throw new Error('Recursive JSON Pointer detected');
        }

        // detect maximum depth of dereferencing
        if (this.indirections.length > this.options.dereference.maxDepth) {
          throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_10__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
        }

        // append referencing schema to ancestors lineage
        directAncestors.add(pathItemElement);

        // dive deep into the referenced element
        const visitor = OpenApi3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_11__["default"])([...ancestors, parent, pathItemElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, visitor, {
          keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__.keyMap,
          nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(pathItemElement);
        this.indirections.pop();
        if (!this.useCircularStructures) {
          const hasCycles = ancestorsLineage.some(ancs => ancs.has(referencedElement));
          if (hasCycles) {
            if (_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.isHttpUrl(retrievalURI) || _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.isFileSystemPath(retrievalURI)) {
              // make the referencing URL or file system path absolute
              const cycledPathItemElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__.PathItemElement({
                $ref: $refBaseURI
              }, pathItemElement.meta.clone(), pathItemElement.attributes.clone());
              cycledPathItemElement.get('$ref').classes.push('cycle');
              return cycledPathItemElement;
            }
            // skip processing this schema but traverse all it's child schemas
            return false;
          }
        }

        // merge fields from referenced Path Item with referencing one
        const mergedPathItemElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__.PathItemElement([...referencedElement.content], referencedElement.meta.clone(), referencedElement.attributes.clone());
        // existing keywords from referencing PathItemElement overrides ones from referenced element
        pathItemElement.forEach((valueElement, keyElement, item) => {
          mergedPathItemElement.remove(keyElement.toValue());
          mergedPathItemElement.content.push(item);
        });
        mergedPathItemElement.remove('$ref');

        // annotate referenced element with info about original referencing element
        mergedPathItemElement.setMetaProperty('ref-fields', {
          $ref: pathItemElement.$ref?.toValue()
        });
        // annotate referenced element with info about origin
        mergedPathItemElement.setMetaProperty('ref-origin', reference.uri);

        // apply meta patches
        if (this.allowMetaPatches) {
          // apply meta patch only when not already applied
          if (typeof mergedPathItemElement.get('$$ref') === 'undefined') {
            const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
            mergedPathItemElement.set('$$ref', baseURI);
          }
        }

        // transclude referencing element with merged referenced element
        return mergedPathItemElement;
      } catch (error) {
        const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_13__["default"])(error);
        const wrappedError = wrapError(rootCause, {
          baseDoc: this.reference.uri,
          $ref: pathItemElement.$ref.toValue(),
          pointer: (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)(pathItemElement.$ref.toValue()),
          fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_11__["default"])([...ancestors, parent, pathItemElement]), '$ref']
        });
        this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
        return undefined;
      }
    },
    async SchemaElement(referencingElement, key, parent, path, ancestors) {
      try {
        const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

        // skip current referencing schema as $ref keyword was not defined
        if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isStringElement)(referencingElement.$ref)) {
          // skip traversing this schema but traverse all it's child schemas
          return undefined;
        }

        // skip already identified cycled schemas
        if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.includesClasses)(['cycle'], referencingElement.$ref)) {
          return false;
        }

        // detect possible cycle in traversal and avoid it
        if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
          // skip processing this schema and all it's child schemas
          return false;
        }

        // compute baseURI using rules around $id and $ref keywords
        let {
          reference
        } = this;
        let {
          uri: retrievalURI
        } = reference;
        const $refBaseURI = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.resolveSchema$refField)(retrievalURI, referencingElement);
        const $refBaseURIStrippedHash = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash($refBaseURI);
        const file = (0,_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_15__["default"])({
          uri: $refBaseURIStrippedHash
        });
        const isUnknownURI = !this.options.resolve.resolvers.some(r => r.canRead(file));
        const isURL = !isUnknownURI;
        const isExternal = isURL && retrievalURI !== $refBaseURIStrippedHash;

        // ignore resolving external Schema Objects
        if (!this.options.resolve.external && isExternal) {
          // skip traversing this schema but traverse all it's child schemas
          return undefined;
        }
        this.indirections.push(referencingElement);

        // determining reference, proper evaluation and selection mechanism
        let referencedElement;
        try {
          if (isUnknownURI || isURL) {
            // we're dealing with canonical URI or URL with possible fragment
            const selector = $refBaseURI;
            referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_16__.evaluate)(selector, (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.maybeRefractToSchemaElement)(reference.value.result));
          } else {
            // we're assuming here that we're dealing with JSON Pointer here
            reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize($refBaseURI));
            retrievalURI = reference.uri;
            const selector = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);
            referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.maybeRefractToSchemaElement)((0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.evaluate)(selector, reference.value.result));
          }
        } catch (error) {
          /**
           * No SchemaElement($id=URL) was not found, so we're going to try to resolve
           * the URL and assume the returned response is a JSON Schema.
           */
          if (isURL && error instanceof _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_17__["default"]) {
            if ((0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_18__.isAnchor)((0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_18__.uriToAnchor)($refBaseURI))) {
              // we're dealing with JSON Schema $anchor here
              reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize($refBaseURI));
              retrievalURI = reference.uri;
              const selector = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_18__.uriToAnchor)($refBaseURI);
              referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_18__.evaluate)(selector, (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.maybeRefractToSchemaElement)(reference.value.result));
            } else {
              // we're assuming here that we're dealing with JSON Pointer here
              reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize($refBaseURI));
              retrievalURI = reference.uri;
              const selector = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);
              referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.maybeRefractToSchemaElement)((0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.evaluate)(selector, reference.value.result));
            }
          } else {
            throw error;
          }
        }

        // detect direct or indirect reference
        if (this.indirections.includes(referencedElement)) {
          throw new Error('Recursive Schema Object reference detected');
        }

        // detect maximum depth of dereferencing
        if (this.indirections.length > this.options.dereference.maxDepth) {
          throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_10__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
        }

        // append referencing schema to ancestors lineage
        directAncestors.add(referencingElement);

        // dive deep into the fragment
        const mergeVisitor = OpenApi3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          useCircularStructures: this.useCircularStructures,
          allowMetaPatches: this.allowMetaPatches,
          ancestors: ancestorsLineage,
          basePath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_11__["default"])([...ancestors, parent, referencingElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, mergeVisitor, {
          keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__.keyMap,
          nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(referencingElement);
        this.indirections.pop();
        if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__.isBooleanJsonSchemaElement)(referencedElement)) {
          // Boolean JSON Schema
          const jsonSchemaBooleanElement = referencedElement.clone();
          // annotate referenced element with info about original referencing element
          jsonSchemaBooleanElement.setMetaProperty('ref-fields', {
            $ref: referencingElement.$ref?.toValue()
          });
          // annotate referenced element with info about origin
          jsonSchemaBooleanElement.setMetaProperty('ref-origin', retrievalURI);
          return jsonSchemaBooleanElement;
        }

        // useCircularStructures option processing
        if (!this.useCircularStructures) {
          const hasCycles = ancestorsLineage.some(ancs => ancs.has(referencedElement));
          if (hasCycles) {
            if (_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.isHttpUrl(retrievalURI) || _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.isFileSystemPath(retrievalURI)) {
              // make the referencing URL or file system path absolute
              const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
              const cycledSchemaElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__.SchemaElement({
                $ref: baseURI
              }, referencingElement.meta.clone(), referencingElement.attributes.clone());
              cycledSchemaElement.get('$ref').classes.push('cycle');
              return cycledSchemaElement;
            }
            // skip processing this schema but traverse all it's child schemas
            return false;
          }
        }

        // Schema Object - merge keywords from referenced schema with referencing schema
        const mergedSchemaElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__.SchemaElement([...referencedElement.content], referencedElement.meta.clone(), referencedElement.attributes.clone());
        // existing keywords from referencing schema overrides ones from referenced schema
        referencingElement.forEach((memberValue, memberKey, member) => {
          mergedSchemaElement.remove(memberKey.toValue());
          mergedSchemaElement.content.push(member);
        });
        mergedSchemaElement.remove('$ref');

        // annotate referenced element with info about original referencing element
        mergedSchemaElement.setMetaProperty('ref-fields', {
          $ref: referencingElement.$ref?.toValue()
        });
        // annotate fragment with info about origin
        mergedSchemaElement.setMetaProperty('ref-origin', retrievalURI);

        // allowMetaPatches option processing
        if (this.allowMetaPatches) {
          // apply meta patch only when not already applied
          if (typeof mergedSchemaElement.get('$$ref') === 'undefined') {
            const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
            mergedSchemaElement.set('$$ref', baseURI);
          }
        }

        // transclude referencing element with merged referenced element
        return mergedSchemaElement;
      } catch (error) {
        const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_13__["default"])(error);
        const wrappedError = new _errors_index_js__WEBPACK_IMPORTED_MODULE_1__.SchemaRefError(`Could not resolve reference: ${rootCause.message}`, {
          baseDoc: this.reference.uri,
          $ref: referencingElement.$ref.toValue(),
          fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_11__["default"])([...ancestors, parent, referencingElement]), '$ref']
        }, rootCause);
        this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
        return undefined;
      }
    },
    async LinkElement() {
      /**
       * OpenApi3_1DereferenceVisitor is doing lookup of Operation Objects
       * and assigns them to Link Object metadata. This is not needed in
       * swagger-client context, so we're disabling it here.
       */
      return undefined;
    },
    async ExampleElement(exampleElement, key, parent, path, ancestors) {
      try {
        return await _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_3__["default"].compose.methods.ExampleElement.call(this, exampleElement, key, parent, path, ancestors);
      } catch (error) {
        const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_13__["default"])(error);
        const wrappedError = wrapError(rootCause, {
          baseDoc: this.reference.uri,
          externalValue: exampleElement.externalValue?.toValue(),
          fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_11__["default"])([...ancestors, parent, exampleElement]), 'externalValue']
        });
        this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
        return undefined;
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenApi3_1SwaggerClientDereferenceVisitor);
/* eslint-enable camelcase */

/***/ }),

/***/ 62042:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17388);
/* harmony import */ var _utils_compose_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58384);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(21352);



const ParameterMacroVisitor = (0,_utils_compose_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
  init(_ref) {
    let {
      parameterMacro,
      options
    } = _ref;
    this.parameterMacro = parameterMacro;
    this.options = options;
  },
  props: {
    parameterMacro: null,
    options: null,
    macroOperation: null,
    OperationElement: {
      enter(operationElement) {
        this.macroOperation = operationElement;
      },
      leave() {
        this.macroOperation = null;
      }
    },
    ParameterElement: {
      leave(parameterElement, key, parent, path, ancestors) {
        const pojoOperation = this.macroOperation === null ? null : (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.toValue)(this.macroOperation);
        const pojoParameter = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.toValue)(parameterElement);
        try {
          const macroValue = this.parameterMacro(pojoOperation, pojoParameter);
          parameterElement.set('default', macroValue);
        } catch (error) {
          const macroError = new Error(error, {
            cause: error
          });
          macroError.fullPath = (0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_2__["default"])([...ancestors, parent]);
          this.options.dereference.dereferenceOpts?.errors?.push?.(macroError);
        }
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParameterMacroVisitor);

/***/ }),

/***/ 58618:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67277);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(17388);
/* harmony import */ var _utils_compose_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58384);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21352);



const ModelPropertyMacroVisitor = (0,_utils_compose_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
  init(_ref) {
    let {
      modelPropertyMacro,
      options
    } = _ref;
    this.modelPropertyMacro = modelPropertyMacro;
    this.options = options;
  },
  props: {
    modelPropertyMacro: null,
    options: null,
    SchemaElement: {
      leave(schemaElement, key, parent, path, ancestors) {
        if (typeof schemaElement.properties === 'undefined') return;
        if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(schemaElement.properties)) return;
        schemaElement.properties.forEach(property => {
          if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(property)) return;
          try {
            const macroValue = this.modelPropertyMacro((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.toValue)(property));
            property.set('default', macroValue);
          } catch (error) {
            const macroError = new Error(error, {
              cause: error
            });
            macroError.fullPath = [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_3__["default"])([...ancestors, parent, schemaElement]), 'properties'];
            this.options.dereference.dereferenceOpts?.errors?.push?.(macroError);
          }
        });
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModelPropertyMacroVisitor);

/***/ }),

/***/ 8445:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(17388);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10138);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88738);


const JsonParser = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__["default"].compose({
  props: {
    name: 'json-swagger-client',
    fileExtensions: ['.json'],
    mediaTypes: ['application/json']
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
      if (!hasSupportedFileExtension) return false;
      if (hasSupportedMediaType) return true;
      if (!hasSupportedMediaType) {
        try {
          JSON.parse(file.toString());
          return true;
        } catch (error) {
          return false;
        }
      }
      return false;
    },
    async parse(file) {
      if (this.sourceMap) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__["default"]("json-swagger-client parser plugin doesn't support sourceMaps option");
      }
      const parseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.ParseResultElement();
      const source = file.toString();

      // allow empty files
      if (this.allowEmpty && source.trim() === '') {
        return parseResultElement;
      }
      try {
        const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.from)(JSON.parse(source));
        element.classes.push('result');
        parseResultElement.push(element);
        return parseResultElement;
      } catch (error) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__["default"](`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JsonParser);

/***/ }),

/***/ 9515:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10138);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88738);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63184);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(64614);
/* eslint-disable camelcase */



const OpenApiJson3_1Parser = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__["default"].compose({
  props: {
    name: 'openapi-json-3-1-swagger-client',
    fileExtensions: ['.json'],
    mediaTypes: new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__.OpenAPIMediaTypes(..._swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__["default"].filterByFormat('generic'), ..._swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__["default"].filterByFormat('json')),
    detectionRegExp: /"openapi"\s*:\s*"(?<version_json>3\.1\.(?:[1-9]\d*|0))"/
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
      if (!hasSupportedFileExtension) return false;
      if (hasSupportedMediaType) return true;
      if (!hasSupportedMediaType) {
        try {
          const source = file.toString();
          JSON.parse(source);
          return this.detectionRegExp.test(source);
        } catch (error) {
          return false;
        }
      }
      return false;
    },
    async parse(file) {
      if (this.sourceMap) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"]("openapi-json-3-1-swagger-client parser plugin doesn't support sourceMaps option");
      }
      const parseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ParseResultElement();
      const source = file.toString();

      // allow empty files
      if (this.allowEmpty && source.trim() === '') {
        return parseResultElement;
      }
      try {
        const pojo = JSON.parse(source);
        const element = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__.OpenApi3_1Element.refract(pojo, this.refractorOpts);
        element.classes.push('result');
        parseResultElement.push(element);
        return parseResultElement;
      } catch (error) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"](`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenApiJson3_1Parser);
/* eslint-enable camelcase */

/***/ }),

/***/ 47779:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1272);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10138);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(88738);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63184);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(64614);
/* eslint-disable camelcase */




const OpenApiYaml3_1Parser = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__["default"].compose({
  props: {
    name: 'openapi-yaml-3-1-swagger-client',
    fileExtensions: ['.yaml', '.yml'],
    mediaTypes: new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__.OpenAPIMediaTypes(..._swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__["default"].filterByFormat('generic'), ..._swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__["default"].filterByFormat('yaml')),
    detectionRegExp: /(?<YAML>^(["']?)openapi\2\s*:\s*(["']?)(?<version_yaml>3\.1\.(?:[1-9]\d*|0))\3(?:\s+|$))|(?<JSON>"openapi"\s*:\s*"(?<version_json>3\.1\.(?:[1-9]\d*|0))")/m
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
      if (!hasSupportedFileExtension) return false;
      if (hasSupportedMediaType) return true;
      if (!hasSupportedMediaType) {
        try {
          const source = file.toString();
          js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(source);
          return this.detectionRegExp.test(source);
        } catch (error) {
          return false;
        }
      }
      return false;
    },
    async parse(file) {
      if (this.sourceMap) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__["default"]("openapi-yaml-3-1-swagger-client parser plugin doesn't support sourceMaps option");
      }
      const parseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ParseResultElement();
      const source = file.toString();
      try {
        const pojo = js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(source, {
          schema: js_yaml__WEBPACK_IMPORTED_MODULE_0__.JSON_SCHEMA
        });
        if (this.allowEmpty && typeof pojo === 'undefined') {
          return parseResultElement;
        }
        const element = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__.OpenApi3_1Element.refract(pojo, this.refractorOpts);
        element.classes.push('result');
        parseResultElement.push(element);
        return parseResultElement;
      } catch (error) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__["default"](`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenApiYaml3_1Parser);
/* eslint-enable camelcase */

/***/ }),

/***/ 57287:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1272);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(17388);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10138);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88738);



const YamlParser = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__["default"].compose({
  props: {
    name: 'yaml-1-2-swagger-client',
    fileExtensions: ['.yaml', '.yml'],
    mediaTypes: ['text/yaml', 'application/yaml']
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
      if (!hasSupportedFileExtension) return false;
      if (hasSupportedMediaType) return true;
      if (!hasSupportedMediaType) {
        try {
          js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(file.toString(), {
            schema: js_yaml__WEBPACK_IMPORTED_MODULE_0__.JSON_SCHEMA
          });
          return true;
        } catch (error) {
          return false;
        }
      }
      return false;
    },
    async parse(file) {
      if (this.sourceMap) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"]("yaml-1-2-swagger-client parser plugin doesn't support sourceMaps option");
      }
      const parseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ParseResultElement();
      const source = file.toString();
      try {
        const pojo = js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(source, {
          schema: js_yaml__WEBPACK_IMPORTED_MODULE_0__.JSON_SCHEMA
        });
        if (this.allowEmpty && typeof pojo === 'undefined') {
          return parseResultElement;
        }
        const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.from)(pojo);
        element.classes.push('result');
        parseResultElement.push(element);
        return parseResultElement;
      } catch (error) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"](`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (YamlParser);

/***/ }),

/***/ 280:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var cross_fetch_polyfill__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9559);
/* harmony import */ var cross_fetch_polyfill__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(cross_fetch_polyfill__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(69102);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59695);
/* harmony import */ var _http_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28288);




const HttpResolverSwaggerClient = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__["default"].compose({
  props: {
    name: 'http-swagger-client',
    swaggerHTTPClient: _http_index_js__WEBPACK_IMPORTED_MODULE_2__["default"],
    swaggerHTTPClientConfig: {}
  },
  init() {
    let {
      swaggerHTTPClient = this.swaggerHTTPClient
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    this.swaggerHTTPClient = swaggerHTTPClient;
  },
  methods: {
    getHttpClient() {
      return this.swaggerHTTPClient;
    },
    async read(file) {
      const client = this.getHttpClient();
      const controller = new AbortController();
      const {
        signal
      } = controller;
      const timeoutID = setTimeout(() => {
        controller.abort();
      }, this.timeout);
      const credentials = this.getHttpClient().withCredentials || this.withCredentials ? 'include' : 'same-origin';
      const redirects = this.redirects === 0 ? 'error' : 'follow';
      const follow = this.redirects > 0 ? this.redirects : undefined;
      try {
        const response = await client((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({
          url: file.uri,
          signal,
          userFetch: async (resource, options) => {
            let res = await fetch(resource, options);
            try {
              // node-fetch supports mutations
              res.headers.delete('Content-Type');
            } catch {
              // Fetch API has guards which prevent mutations
              res = new Response(res.body, (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, res), {}, {
                headers: new Headers(res.headers)
              }));
              res.headers.delete('Content-Type');
            }
            return res;
          },
          credentials,
          redirects,
          follow
        }, this.swaggerHTTPClientConfig));
        return response.text.arrayBuffer();
      } catch (error) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_4__["default"](`Error downloading "${file.uri}"`, {
          cause: error
        });
      } finally {
        clearTimeout(timeoutID);
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HttpResolverSwaggerClient);

/***/ }),

/***/ 82788:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "makeResolve": () => (/* binding */ makeResolve)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var _utils_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68247);
/* harmony import */ var _utils_options_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(73562);
/* harmony import */ var _strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87485);
/* harmony import */ var _strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(48390);
/* harmony import */ var _strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(79018);






const resolve = async options => {
  const {
    spec,
    requestInterceptor,
    responseInterceptor
  } = options;
  const retrievalURI = _utils_options_js__WEBPACK_IMPORTED_MODULE_1__.retrievalURI(options);
  const httpClient = _utils_options_js__WEBPACK_IMPORTED_MODULE_1__.httpClient(options);
  const retrievedSpec = spec || (await (0,_utils_index_js__WEBPACK_IMPORTED_MODULE_5__.makeFetchJSON)(httpClient, {
    requestInterceptor,
    responseInterceptor
  })(retrievalURI));
  const strategyOptions = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, options), {}, {
    spec: retrievedSpec
  });
  const strategy = options.strategies.find(strg => strg.match(strategyOptions));
  return strategy.resolve(strategyOptions);
};
const makeResolve = defaultOptions => async options => {
  const mergedOptions = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, defaultOptions), options);
  return resolve(mergedOptions);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (makeResolve({
  strategies: [_strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_4__["default"], _strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_3__["default"], _strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_2__["default"]]
}));

/***/ }),

/***/ 87485:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "clearCache": () => (/* binding */ clearCache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32529);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16903);
/* harmony import */ var _specmap_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91027);



function clearCache() {
  _specmap_index_js__WEBPACK_IMPORTED_MODULE_1__.plugins.refs.clearCache();
}
const genericStrategy = {
  name: 'generic',
  match() {
    return true;
  },
  normalize(_ref) {
    let {
      spec
    } = _ref;
    const {
      spec: normalized
    } = (0,_normalize_js__WEBPACK_IMPORTED_MODULE_2__["default"])({
      spec
    });
    return normalized;
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (genericStrategy);

/***/ }),

/***/ 16903:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ normalize)
/* harmony export */ });
/* harmony import */ var _helpers_op_id_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(63959);

function normalize(parsedSpec) {
  const {
    spec
  } = parsedSpec;
  const {
    paths
  } = spec;
  const map = {};
  if (!paths || spec.$$normalized) {
    return parsedSpec;
  }

  // eslint-disable-next-line no-restricted-syntax, guard-for-in
  for (const pathName in paths) {
    const path = paths[pathName];
    if (path == null || !['object', 'function'].includes(typeof path)) {
      continue; // eslint-disable-line no-continue
    }

    const pathParameters = path.parameters;

    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const method in path) {
      const operation = path[method];
      if (operation == null || !['object', 'function'].includes(typeof operation)) {
        continue; // eslint-disable-line no-continue
      }

      const oid = (0,_helpers_op_id_js__WEBPACK_IMPORTED_MODULE_0__["default"])(operation, pathName, method);
      if (oid) {
        if (map[oid]) {
          map[oid].push(operation);
        } else {
          map[oid] = [operation];
        }
        const opList = map[oid];
        if (opList.length > 1) {
          opList.forEach((o, i) => {
            // eslint-disable-next-line no-underscore-dangle
            o.__originalOperationId = o.__originalOperationId || o.operationId;
            o.operationId = `${oid}${i + 1}`;
          });
        } else if (typeof operation.operationId !== 'undefined') {
          // Ensure we always add the normalized operation ID if one already exists
          // ( potentially different, given that we normalize our IDs)
          // ... _back_ to the spec. Otherwise, they might not line up
          const obj = opList[0];
          // eslint-disable-next-line no-underscore-dangle
          obj.__originalOperationId = obj.__originalOperationId || operation.operationId;
          obj.operationId = oid;
        }
      }
      if (method !== 'parameters') {
        // Add inherited consumes, produces, parameters, securities
        const inheritsList = [];
        const toBeInherit = {};

        // Global-levels
        // eslint-disable-next-line no-restricted-syntax
        for (const key in spec) {
          if (key === 'produces' || key === 'consumes' || key === 'security') {
            toBeInherit[key] = spec[key];
            inheritsList.push(toBeInherit);
          }
        }

        // Path-levels
        if (pathParameters) {
          toBeInherit.parameters = pathParameters;
          inheritsList.push(toBeInherit);
        }
        if (inheritsList.length) {
          // eslint-disable-next-line no-restricted-syntax
          for (const inherits of inheritsList) {
            // eslint-disable-next-line no-restricted-syntax
            for (const inheritName in inherits) {
              if (!operation[inheritName]) {
                operation[inheritName] = inherits[inheritName];
              } else if (inheritName === 'parameters') {
                // eslint-disable-next-line no-restricted-syntax
                for (const param of inherits[inheritName]) {
                  const exists = operation[inheritName].some(opParam => opParam.name && opParam.name === param.name || opParam.$ref && opParam.$ref === param.$ref || opParam.$$ref && opParam.$$ref === param.$$ref || opParam === param);
                  if (!exists) {
                    operation[inheritName].push(param);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  spec.$$normalized = true;
  return parsedSpec;
}

/***/ }),

/***/ 32529:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ resolveGenericStrategy)
/* harmony export */ });
/* harmony import */ var _specmap_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91027);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16903);
/* harmony import */ var _utils_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(68247);
/* harmony import */ var _utils_options_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(73562);




async function resolveGenericStrategy(options) {
  const {
    spec,
    mode,
    allowMetaPatches = true,
    pathDiscriminator,
    modelPropertyMacro,
    parameterMacro,
    requestInterceptor,
    responseInterceptor,
    skipNormalization,
    useCircularStructures
  } = options;
  const retrievalURI = _utils_options_js__WEBPACK_IMPORTED_MODULE_1__.retrievalURI(options);
  const httpClient = _utils_options_js__WEBPACK_IMPORTED_MODULE_1__.httpClient(options);
  return doResolve(spec);
  function doResolve(_spec) {
    if (retrievalURI) {
      _specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.refs.docCache[retrievalURI] = _spec;
    }

    // Build a json-fetcher ( ie: give it a URL and get json out )
    _specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.refs.fetchJSON = (0,_utils_index_js__WEBPACK_IMPORTED_MODULE_2__.makeFetchJSON)(httpClient, {
      requestInterceptor,
      responseInterceptor
    });
    const plugs = [_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.refs];
    if (typeof parameterMacro === 'function') {
      plugs.push(_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.parameters);
    }
    if (typeof modelPropertyMacro === 'function') {
      plugs.push(_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.properties);
    }
    if (mode !== 'strict') {
      plugs.push(_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.allOf);
    }

    // mapSpec is where the hard work happens
    return (0,_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
      spec: _spec,
      context: {
        baseDoc: retrievalURI
      },
      plugins: plugs,
      allowMetaPatches,
      // allows adding .meta patches, which include adding `$$ref`s to the spec
      pathDiscriminator,
      // for lazy resolution
      parameterMacro,
      modelPropertyMacro,
      useCircularStructures
      // eslint-disable-next-line camelcase
    }).then(skipNormalization ? async a => a : _normalize_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
  }
}

/***/ }),

/***/ 48390:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "clearCache": () => (/* reexport safe */ _generic_index_js__WEBPACK_IMPORTED_MODULE_1__.clearCache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44964);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16903);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59809);
/* harmony import */ var _generic_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87485);




const openApi2Strategy = {
  name: 'openapi-2',
  match(_ref) {
    let {
      spec
    } = _ref;
    return (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__.isOpenAPI2)(spec);
  },
  normalize(_ref2) {
    let {
      spec
    } = _ref2;
    const {
      spec: normalized
    } = (0,_normalize_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      spec
    });
    return normalized;
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi2Strategy);

/***/ }),

/***/ 44964:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ resolveOpenAPI2Strategy)
/* harmony export */ });
/* harmony import */ var _generic_resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32529);

async function resolveOpenAPI2Strategy(options) {
  return (0,_generic_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
}

/***/ }),

/***/ 79018:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "clearCache": () => (/* reexport safe */ _generic_index_js__WEBPACK_IMPORTED_MODULE_1__.clearCache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94822);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16903);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(59809);
/* harmony import */ var _generic_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87485);




const openApi30Strategy = {
  name: 'openapi-3-0',
  match(_ref) {
    let {
      spec
    } = _ref;
    return (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__.isOpenAPI30)(spec);
  },
  normalize(_ref2) {
    let {
      spec
    } = _ref2;
    const {
      spec: normalized
    } = (0,_normalize_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      spec
    });
    return normalized;
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi30Strategy);

/***/ }),

/***/ 94822:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ resolveOpenAPI30Strategy)
/* harmony export */ });
/* harmony import */ var _generic_resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(32529);

async function resolveOpenAPI30Strategy(options) {
  return (0,_generic_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
}

/***/ }),

/***/ 4863:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64549);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97499);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59809);



const openApi31ApiDOMStrategy = {
  name: 'openapi-3-1-apidom',
  match(_ref) {
    let {
      spec
    } = _ref;
    return (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_1__.isOpenAPI31)(spec);
  },
  normalize(_ref2) {
    let {
      spec
    } = _ref2;
    return (0,_normalize_js__WEBPACK_IMPORTED_MODULE_2__.pojoAdapter)(_normalize_js__WEBPACK_IMPORTED_MODULE_2__["default"])(spec);
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi31ApiDOMStrategy);

/***/ }),

/***/ 97499:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "pojoAdapter": () => (/* binding */ pojoAdapter)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67277);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(32240);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(17388);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83098);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(54593);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(33489);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(28746);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(42313);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(28143);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(1693);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(37988);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(64614);
/* harmony import */ var _helpers_op_id_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63959);
/* eslint-disable camelcase */



const normalize = element => {
  if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isObjectElement)(element)) return element;
  if (element.hasKey('$$normalized')) return element;
  const plugins = [(0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__["default"])({
    operationIdNormalizer: (operationId, path, method) => (0,_helpers_op_id_js__WEBPACK_IMPORTED_MODULE_2__["default"])({
      operationId
    }, path, method, {
      v2OperationIdCompatibilityMode: false
    })
  }), (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_3__["default"])(), (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__["default"])(), (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__["default"])(), (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_6__["default"])(), (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_7__["default"])()];
  const normalized = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__.dispatchPlugins)(element, plugins, {
    toolboxCreator: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__["default"],
    visitorOptions: {
      keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.keyMap,
      nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.getNodeType
    }
  });
  normalized.set('$$normalized', true);
  return normalized;
};

/**
 * This adapter allow to perform normalization on Plain Old JavaScript Objects.
 * The function adapts the `normalize` function interface and is able to accept
 * Plain Old JavaScript Objects and returns Plain Old JavaScript Objects.
 */
const pojoAdapter = normalizeFn => spec => {
  if (spec?.$$normalized) return spec;
  const openApiElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__.OpenApi3_1Element.refract(spec);
  const normalized = normalizeFn(openApiElement);
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_12__.toValue)(normalized);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (normalize);
/* eslint-enable camelcase */

/***/ }),

/***/ 64549:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(36340);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(17388);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(77782);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(76451);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(72965);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(64614);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(63184);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8549);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(39816);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(63595);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(69862);
/* harmony import */ var _swagger_api_apidom_reference_parse_parsers_binary__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(2309);
/* harmony import */ var _swagger_api_apidom_reference_resolve_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(52700);
/* harmony import */ var _utils_options_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73562);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(97499);
/* harmony import */ var _apidom_reference_resolve_resolvers_http_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(280);
/* harmony import */ var _apidom_reference_parse_parsers_json_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8445);
/* harmony import */ var _apidom_reference_parse_parsers_yaml_1_2_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(57287);
/* harmony import */ var _apidom_reference_parse_parsers_openapi_json_3_1_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9515);
/* harmony import */ var _apidom_reference_parse_parsers_openapi_yaml_3_1_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(47779);
/* harmony import */ var _apidom_reference_dereference_strategies_openapi_3_1_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(7662);
/* eslint-disable camelcase */














const resolveOpenAPI31Strategy = async options => {
  const {
    spec,
    timeout,
    redirects,
    requestInterceptor,
    responseInterceptor,
    pathDiscriminator = [],
    allowMetaPatches = false,
    useCircularStructures = false,
    skipNormalization = false,
    parameterMacro = null,
    modelPropertyMacro = null,
    mode = 'non-strict'
  } = options;
  try {
    // determining BaseURI
    const cwd = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_7__.isHttpUrl(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_7__.cwd()) ? _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_7__.cwd() : 'https://smartbear.com/';
    const retrievalURI = _utils_options_js__WEBPACK_IMPORTED_MODULE_0__.retrievalURI(options);
    const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_7__.resolve(cwd, retrievalURI);

    // prepare spec for dereferencing
    const openApiElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__.OpenApi3_1Element.refract(spec);
    openApiElement.classes.push('result');
    const openApiParseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.ParseResultElement([openApiElement]);

    // prepare fragment for dereferencing
    const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_10__.compile)(pathDiscriminator);
    const jsonPointerURI = jsonPointer === '' ? '' : `#${jsonPointer}`;
    const fragmentElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_10__.evaluate)(jsonPointer, openApiElement);

    // prepare reference set for dereferencing
    const openApiElementReference = (0,_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__["default"])({
      uri: baseURI,
      value: openApiParseResultElement
    });
    const refSet = (0,_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__["default"])({
      refs: [openApiElementReference]
    });
    if (jsonPointer !== '') refSet.rootRef = null; // reset root reference as we want fragment to become the root reference

    const errors = [];
    const dereferenced = await (0,_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_13__.dereferenceApiDOM)(fragmentElement, {
      resolve: {
        /**
         * swagger-client only supports resolving HTTP(S) URLs or spec objects.
         * If runtime env is detected as non-browser one,
         * and baseURI was not provided as part of resolver options,
         * then below baseURI check will make sure that constant HTTPS URL is used as baseURI.
         */
        baseURI: `${baseURI}${jsonPointerURI}`,
        resolvers: [(0,_apidom_reference_resolve_resolvers_http_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
          timeout: timeout || 10000,
          redirects: redirects || 10
        })],
        resolverOpts: {
          swaggerHTTPClientConfig: {
            requestInterceptor,
            responseInterceptor
          }
        },
        strategies: [(0,_swagger_api_apidom_reference_resolve_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__["default"])()]
      },
      parse: {
        mediaType: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_15__["default"].latest(),
        parsers: [(0,_apidom_reference_parse_parsers_openapi_json_3_1_index_js__WEBPACK_IMPORTED_MODULE_4__["default"])({
          allowEmpty: false,
          sourceMap: false
        }), (0,_apidom_reference_parse_parsers_openapi_yaml_3_1_index_js__WEBPACK_IMPORTED_MODULE_5__["default"])({
          allowEmpty: false,
          sourceMap: false
        }), (0,_apidom_reference_parse_parsers_json_index_js__WEBPACK_IMPORTED_MODULE_2__["default"])({
          allowEmpty: false,
          sourceMap: false
        }), (0,_apidom_reference_parse_parsers_yaml_1_2_index_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
          allowEmpty: false,
          sourceMap: false
        }), (0,_swagger_api_apidom_reference_parse_parsers_binary__WEBPACK_IMPORTED_MODULE_16__["default"])({
          allowEmpty: false,
          sourceMap: false
        })]
      },
      dereference: {
        maxDepth: 100,
        strategies: [(0,_apidom_reference_dereference_strategies_openapi_3_1_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_6__["default"])({
          allowMetaPatches,
          useCircularStructures,
          parameterMacro,
          modelPropertyMacro,
          mode
        })],
        refSet,
        dereferenceOpts: {
          errors
        }
      }
    });
    const transcluded = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.transclude)(fragmentElement, dereferenced, openApiElement);
    const normalized = skipNormalization ? transcluded : (0,_normalize_js__WEBPACK_IMPORTED_MODULE_18__["default"])(transcluded);
    return {
      spec: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_19__.toValue)(normalized),
      errors
    };
  } catch (error) {
    if (error instanceof _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_20__["default"] || error instanceof _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_21__["default"]) {
      return {
        spec: null,
        errors: []
      };
    }
    throw error;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (resolveOpenAPI31Strategy);
/* eslint-enable camelcase */

/***/ }),

/***/ 68247:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "makeFetchJSON": () => (/* binding */ makeFetchJSON)
/* harmony export */ });
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58061);


// eslint-disable-next-line import/prefer-default-export
function makeFetchJSON(http) {
  let opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const {
    requestInterceptor,
    responseInterceptor
  } = opts;
  // Set credentials with 'http.withCredentials' value
  const credentials = http.withCredentials ? 'include' : 'same-origin';
  return docPath => http({
    url: docPath,
    loadSpec: true,
    requestInterceptor,
    responseInterceptor,
    headers: {
      Accept: _constants_js__WEBPACK_IMPORTED_MODULE_0__.ACCEPT_HEADER_VALUE_FOR_DOCUMENTS
    },
    credentials
  }).then(res => res.body);
}

/***/ }),

/***/ 73562:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "httpClient": () => (/* binding */ httpClient),
/* harmony export */   "retrievalURI": () => (/* binding */ retrievalURI)
/* harmony export */ });
/* harmony import */ var _http_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28288);

const retrievalURI = options => {
  const {
    baseDoc,
    url
  } = options;

  // @TODO Swagger-UI uses baseDoc instead of url, this is to allow both
  // need to fix and pick one.
  return baseDoc || url || '';
};
const httpClient = options => {
  const {
    fetch,
    http
  } = options;

  // @TODO fetch should be removed, and http used instead
  // provide a default fetch implementation
  return fetch || http || _http_index_js__WEBPACK_IMPORTED_MODULE_0__["default"];
};

/***/ }),

/***/ 52460:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "absolutifyPointer": () => (/* binding */ absolutifyPointer),
/* harmony export */   "generateAbsoluteRefPatches": () => (/* binding */ generateAbsoluteRefPatches),
/* harmony export */   "isFreelyNamed": () => (/* binding */ isFreelyNamed)
/* harmony export */ });
/* harmony import */ var traverse__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13692);
/* harmony import */ var traverse__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(traverse__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var url__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8575);



// This will match if the direct parent's key exactly matches an item.
const freelyNamedKeyParents = ['properties'];

// This will match if the grandparent's key exactly matches an item.
// NOTE that this is for finding non-free paths!
const nonFreelyNamedKeyGrandparents = ['properties'];

// This will match if the joined parent path exactly matches an item.
//
// This is mostly useful for filtering out root-level reusable item names,
// for example `["definitions", "$ref"]`
const freelyNamedPaths = [
// Swagger 2.0
'definitions', 'parameters', 'responses', 'securityDefinitions',
// OpenAPI 3.0
'components/schemas', 'components/responses', 'components/parameters', 'components/securitySchemes'];

// This will match if any of these items are substrings of the joined
// parent path.
//
// Warning! These are powerful. Beware of edge cases.
const freelyNamedAncestors = ['schema/example', 'items/example'];
function isFreelyNamed(parentPath) {
  const parentKey = parentPath[parentPath.length - 1];
  const grandparentKey = parentPath[parentPath.length - 2];
  const parentStr = parentPath.join('/');
  return (
    // eslint-disable-next-line max-len
    freelyNamedKeyParents.indexOf(parentKey) > -1 && nonFreelyNamedKeyGrandparents.indexOf(grandparentKey) === -1 || freelyNamedPaths.indexOf(parentStr) > -1 || freelyNamedAncestors.some(el => parentStr.indexOf(el) > -1)
  );
}
function generateAbsoluteRefPatches(obj, basePath) {
  let {
    specmap,
    getBaseUrlForNodePath = path => specmap.getContext([...basePath, ...path]).baseDoc,
    targetKeys = ['$ref', '$$ref']
  } = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const patches = [];
  traverse__WEBPACK_IMPORTED_MODULE_0___default()(obj).forEach(function callback() {
    if (targetKeys.includes(this.key) && typeof this.node === 'string') {
      const nodePath = this.path; // this node's path, relative to `obj`
      const fullPath = basePath.concat(this.path);
      const absolutifiedRefValue = absolutifyPointer(this.node, getBaseUrlForNodePath(nodePath));
      patches.push(specmap.replace(fullPath, absolutifiedRefValue));
    }
  });
  return patches;
}
function absolutifyPointer(pointer, baseUrl) {
  const [urlPart, fragmentPart] = pointer.split('#');
  const newRefUrlPart = url__WEBPACK_IMPORTED_MODULE_1__.resolve(urlPart || '', baseUrl || '');
  return fragmentPart ? `${newRefUrlPart}#${fragmentPart}` : newRefUrlPart;
}

/***/ }),

/***/ 91027:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SpecMap": () => (/* binding */ SpecMap),
/* harmony export */   "default": () => (/* binding */ mapSpec),
/* harmony export */   "plugins": () => (/* binding */ plugins)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var _lib_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53275);
/* harmony import */ var _lib_refs_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(58569);
/* harmony import */ var _lib_all_of_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(47133);
/* harmony import */ var _lib_parameters_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12983);
/* harmony import */ var _lib_properties_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(54631);
/* harmony import */ var _lib_context_tree_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(75176);







const HARD_LIMIT = 100;
const noop = () => {};
class SpecMap {
  static getPluginName(plugin) {
    return plugin.pluginName;
  }
  static getPatchesOfType(patches, fn) {
    return patches.filter(fn);
  }
  constructor(opts) {
    Object.assign(this, {
      spec: '',
      debugLevel: 'info',
      plugins: [],
      pluginHistory: {},
      errors: [],
      mutations: [],
      promisedPatches: [],
      state: {},
      patches: [],
      context: {},
      contextTree: new _lib_context_tree_js__WEBPACK_IMPORTED_MODULE_6__["default"](),
      showDebug: false,
      allPatches: [],
      // only populated if showDebug is true
      pluginProp: 'specMap',
      libMethods: Object.assign(Object.create(this), _lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
        getInstance: () => this
      }),
      allowMetaPatches: false
    }, opts);

    // Lib methods bound
    this.get = this._get.bind(this); // eslint-disable-line no-underscore-dangle
    this.getContext = this._getContext.bind(this); // eslint-disable-line no-underscore-dangle
    this.hasRun = this._hasRun.bind(this); // eslint-disable-line no-underscore-dangle

    this.wrappedPlugins = this.plugins.map(this.wrapPlugin.bind(this)).filter(_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isFunction);

    // Initial patch(s)
    this.patches.push(_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].add([], this.spec));
    this.patches.push(_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].context([], this.context));
    this.updatePatches(this.patches);
  }
  debug(level) {
    if (this.debugLevel === level) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      console.log(...args); // eslint-disable-line no-console
    }
  }

  verbose(header) {
    if (this.debugLevel === 'verbose') {
      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }
      console.log(`[${header}]   `, ...args); // eslint-disable-line no-console
    }
  }

  wrapPlugin(plugin, name) {
    const {
      pathDiscriminator
    } = this;
    let ctx = null;
    let fn;
    if (plugin[this.pluginProp]) {
      ctx = plugin;
      fn = plugin[this.pluginProp];
    } else if (_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isFunction(plugin)) {
      fn = plugin;
    } else if (_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isObject(plugin)) {
      fn = createKeyBasedPlugin(plugin);
    }
    return Object.assign(fn.bind(ctx), {
      pluginName: plugin.name || name,
      isGenerator: _lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isGenerator(fn)
    });

    // Expected plugin interface: {key: string, plugin: fn*}
    // This traverses depth-first and immediately applies yielded patches.
    // This strategy should work well for most plugins (including the built-ins).
    // We might consider making this (traversing & application) configurable later.
    function createKeyBasedPlugin(pluginObj) {
      const isSubPath = (path, tested) => {
        if (!Array.isArray(path)) {
          return true;
        }
        return path.every((val, i) => val === tested[i]);
      };
      return function* generator(patches, specmap) {
        const refCache = {};

        // eslint-disable-next-line no-restricted-syntax
        for (const patch of patches.filter(_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isAdditiveMutation)) {
          yield* traverse(patch.value, patch.path, patch);
        }
        function* traverse(obj, path, patch) {
          if (!_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isObject(obj)) {
            if (pluginObj.key === path[path.length - 1]) {
              yield pluginObj.plugin(obj, pluginObj.key, path, specmap);
            }
          } else {
            const parentIndex = path.length - 1;
            const parent = path[parentIndex];
            const indexOfFirstProperties = path.indexOf('properties');
            const isRootProperties = parent === 'properties' && parentIndex === indexOfFirstProperties;
            const traversed = specmap.allowMetaPatches && refCache[obj.$$ref];

            // eslint-disable-next-line no-restricted-syntax
            for (const key of Object.keys(obj)) {
              const val = obj[key];
              const updatedPath = path.concat(key);
              const isObj = _lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isObject(val);
              const objRef = obj.$$ref;
              if (!traversed) {
                if (isObj) {
                  // Only store the ref if it exists
                  if (specmap.allowMetaPatches && objRef) {
                    refCache[objRef] = true;
                  }
                  yield* traverse(val, updatedPath, patch);
                }
              }
              if (!isRootProperties && key === pluginObj.key) {
                const isWithinPathDiscriminator = isSubPath(pathDiscriminator, path);
                if (!pathDiscriminator || isWithinPathDiscriminator) {
                  yield pluginObj.plugin(val, key, updatedPath, specmap, patch);
                }
              }
            }
          }
        }
      };
    }
  }
  nextPlugin() {
    return this.wrappedPlugins.find(plugin => {
      const mutations = this.getMutationsForPlugin(plugin);
      return mutations.length > 0;
    });
  }
  nextPromisedPatch() {
    if (this.promisedPatches.length > 0) {
      return Promise.race(this.promisedPatches.map(patch => patch.value));
    }
    return undefined;
  }
  getPluginHistory(plugin) {
    const name = this.constructor.getPluginName(plugin);
    return this.pluginHistory[name] || [];
  }
  getPluginRunCount(plugin) {
    return this.getPluginHistory(plugin).length;
  }
  getPluginHistoryTip(plugin) {
    const history = this.getPluginHistory(plugin);
    const val = history && history[history.length - 1];
    return val || {};
  }
  getPluginMutationIndex(plugin) {
    const mi = this.getPluginHistoryTip(plugin).mutationIndex;
    return typeof mi !== 'number' ? -1 : mi;
  }
  updatePluginHistory(plugin, val) {
    const name = this.constructor.getPluginName(plugin);
    this.pluginHistory[name] = this.pluginHistory[name] || [];
    this.pluginHistory[name].push(val);
  }
  updatePatches(patches) {
    _lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].normalizeArray(patches).forEach(patch => {
      if (patch instanceof Error) {
        this.errors.push(patch);
        return;
      }
      try {
        if (!_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isObject(patch)) {
          this.debug('updatePatches', 'Got a non-object patch', patch);
          return;
        }
        if (this.showDebug) {
          this.allPatches.push(patch);
        }
        if (_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isPromise(patch.value)) {
          this.promisedPatches.push(patch);
          this.promisedPatchThen(patch);
          return;
        }
        if (_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isContextPatch(patch)) {
          this.setContext(patch.path, patch.value);
          return;
        }
        if (_lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].isMutation(patch)) {
          this.updateMutations(patch);
          return;
        }
      } catch (e) {
        console.error(e); // eslint-disable-line no-console
        this.errors.push(e);
      }
    });
  }
  updateMutations(patch) {
    if (typeof patch.value === 'object' && !Array.isArray(patch.value) && this.allowMetaPatches) {
      patch.value = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, patch.value);
    }
    const result = _lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].applyPatch(this.state, patch, {
      allowMetaPatches: this.allowMetaPatches
    });
    if (result) {
      this.mutations.push(patch);
      this.state = result;
    }
  }
  removePromisedPatch(patch) {
    const index = this.promisedPatches.indexOf(patch);
    if (index < 0) {
      this.debug("Tried to remove a promisedPatch that isn't there!");
      return;
    }
    this.promisedPatches.splice(index, 1);
  }
  promisedPatchThen(patch) {
    patch.value = patch.value.then(val => {
      const promisedPatch = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, patch), {}, {
        value: val
      });
      this.removePromisedPatch(patch);
      this.updatePatches(promisedPatch);
    }).catch(e => {
      this.removePromisedPatch(patch);
      this.updatePatches(e);
    });
    return patch.value;
  }
  getMutations(from, to) {
    from = from || 0;
    if (typeof to !== 'number') {
      to = this.mutations.length;
    }
    return this.mutations.slice(from, to);
  }
  getCurrentMutations() {
    return this.getMutationsForPlugin(this.getCurrentPlugin());
  }
  getMutationsForPlugin(plugin) {
    const tip = this.getPluginMutationIndex(plugin);
    return this.getMutations(tip + 1);
  }
  getCurrentPlugin() {
    return this.currentPlugin;
  }
  getLib() {
    return this.libMethods;
  }

  // eslint-disable-next-line no-underscore-dangle
  _get(path) {
    return _lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].getIn(this.state, path);
  }

  // eslint-disable-next-line no-underscore-dangle
  _getContext(path) {
    return this.contextTree.get(path);
  }
  setContext(path, value) {
    return this.contextTree.set(path, value);
  }

  // eslint-disable-next-line no-underscore-dangle
  _hasRun(count) {
    const times = this.getPluginRunCount(this.getCurrentPlugin());
    return times > (count || 0);
  }
  dispatch() {
    const that = this;
    const plugin = this.nextPlugin();
    if (!plugin) {
      const nextPromise = this.nextPromisedPatch();
      if (nextPromise) {
        return nextPromise.then(() => this.dispatch()).catch(() => this.dispatch());
      }

      // We're done!
      const result = {
        spec: this.state,
        errors: this.errors
      };
      if (this.showDebug) {
        result.patches = this.allPatches;
      }
      return Promise.resolve(result);
    }

    // Makes sure plugin isn't running an endless loop
    that.pluginCount = that.pluginCount || {};
    that.pluginCount[plugin] = (that.pluginCount[plugin] || 0) + 1;
    if (that.pluginCount[plugin] > HARD_LIMIT) {
      return Promise.resolve({
        spec: that.state,
        errors: that.errors.concat(new Error(`We've reached a hard limit of ${HARD_LIMIT} plugin runs`))
      });
    }

    // A different plugin runs, wait for all promises to resolve, then retry
    if (plugin !== this.currentPlugin && this.promisedPatches.length) {
      const promises = this.promisedPatches.map(p => p.value);

      // Waits for all to settle instead of Promise.all which stops on rejection
      return Promise.all(promises.map(promise => promise.then(noop, noop))).then(() => this.dispatch());
    }

    // Ok, run the plugin
    return executePlugin();
    function executePlugin() {
      that.currentPlugin = plugin;
      const mutations = that.getCurrentMutations();
      const lastMutationIndex = that.mutations.length - 1;
      try {
        if (plugin.isGenerator) {
          // eslint-disable-next-line no-restricted-syntax
          for (const yieldedPatches of plugin(mutations, that.getLib())) {
            updatePatches(yieldedPatches);
          }
        } else {
          const newPatches = plugin(mutations, that.getLib());
          updatePatches(newPatches);
        }
      } catch (e) {
        console.error(e); // eslint-disable-line no-console
        updatePatches([Object.assign(Object.create(e), {
          plugin
        })]);
      } finally {
        that.updatePluginHistory(plugin, {
          mutationIndex: lastMutationIndex
        });
      }
      return that.dispatch();
    }
    function updatePatches(patches) {
      if (patches) {
        patches = _lib_index_js__WEBPACK_IMPORTED_MODULE_1__["default"].fullyNormalizeArray(patches);
        that.updatePatches(patches, plugin);
      }
    }
  }
}
function mapSpec(opts) {
  return new SpecMap(opts).dispatch();
}
const plugins = {
  refs: _lib_refs_js__WEBPACK_IMPORTED_MODULE_2__["default"],
  allOf: _lib_all_of_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  parameters: _lib_parameters_js__WEBPACK_IMPORTED_MODULE_4__["default"],
  properties: _lib_properties_js__WEBPACK_IMPORTED_MODULE_5__["default"]
};


/***/ }),

/***/ 47133:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52460);


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  key: 'allOf',
  plugin: (val, key, fullPath, specmap, patch) => {
    // Ignore replace patches created by $ref because the changes will
    // occur in the original "add" patch and we don't want this plugin
    // to redundantly processes those "relace" patches.
    if (patch.meta && patch.meta.$$ref) {
      return undefined;
    }
    const parent = fullPath.slice(0, -1);
    if ((0,_helpers_js__WEBPACK_IMPORTED_MODULE_1__.isFreelyNamed)(parent)) {
      return undefined;
    }
    if (!Array.isArray(val)) {
      const err = new TypeError('allOf must be an array');
      err.fullPath = fullPath; // This is an array
      return err;
    }
    let alreadyAddError = false;

    // Find the original definition from the `patch.value` object
    // Remove the `allOf` property so it doesn't get added to the result of the `allOf` plugin
    let originalDefinitionObj = patch.value;
    parent.forEach(part => {
      if (!originalDefinitionObj) return; // bail out if we've lost sight of our target
      originalDefinitionObj = originalDefinitionObj[part];
    });
    originalDefinitionObj = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, originalDefinitionObj);

    // when we've lost sight, interrupt prematurely
    if (Object.keys(originalDefinitionObj).length === 0) {
      return undefined;
    }
    delete originalDefinitionObj.allOf;
    const patches = [];

    // remove existing content
    patches.push(specmap.replace(parent, {}));
    val.forEach((toMerge, i) => {
      if (!specmap.isObject(toMerge)) {
        if (alreadyAddError) {
          return null;
        }
        alreadyAddError = true;
        const err = new TypeError('Elements in allOf must be objects');
        err.fullPath = fullPath; // This is an array
        return patches.push(err);
      }

      // Deeply merge the member's contents onto the parent location
      patches.push(specmap.mergeDeep(parent, toMerge));

      // Generate patches that migrate $ref values based on ContextTree information

      // remove ["allOf"], which will not be present when these patches are applied
      const collapsedFullPath = fullPath.slice(0, -1);
      const absoluteRefPatches = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_1__.generateAbsoluteRefPatches)(toMerge, collapsedFullPath, {
        getBaseUrlForNodePath: nodePath => specmap.getContext([...fullPath, i, ...nodePath]).baseDoc,
        specmap
      });
      patches.push(...absoluteRefPatches);
      return undefined;
    });

    // If there was an example in the original definition,
    // keep it instead of merging with examples from other schema
    if (originalDefinitionObj.example) {
      // Delete other schema examples
      patches.push(specmap.remove([].concat(parent, 'example')));
    }
    // Merge back the values from the original definition
    patches.push(specmap.mergeDeep(parent, originalDefinitionObj));

    // If there was not an original $$ref value, make sure to remove
    // any $$ref value that may exist from the result of `allOf` merges
    if (!originalDefinitionObj.$$ref) {
      patches.push(specmap.remove([].concat(parent, '$$ref')));
    }
    return patches;
  }
});

/***/ }),

/***/ 75176:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContextTree)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);

class ContextTree {
  constructor(value) {
    this.root = createNode(value || {});
  }
  set(path, value) {
    const parent = this.getParent(path, true);
    if (!parent) {
      updateNode(this.root, value, null);
      return;
    }
    const key = path[path.length - 1];
    const {
      children
    } = parent;
    if (children[key]) {
      updateNode(children[key], value, parent);
      return;
    }
    children[key] = createNode(value, parent);
  }

  // Get the "best" node (node or nearest parent) and return its value.
  get(path) {
    path = path || [];
    if (path.length < 1) {
      return this.root.value;
    }
    let branch = this.root;
    let child;
    let token;
    for (let i = 0; i < path.length; i += 1) {
      token = path[i];
      child = branch.children;
      if (!child[token]) {
        break;
      }
      branch = child[token];
    }
    return branch && branch.protoValue;
  }
  getParent(path, ensureExists) {
    if (!path || path.length < 1) {
      return null;
    }
    if (path.length < 2) {
      return this.root;
    }
    return path.slice(0, -1).reduce((branch, token) => {
      if (!branch) {
        return branch;
      }
      const {
        children
      } = branch;
      if (!children[token] && ensureExists) {
        children[token] = createNode(null, branch);
      }
      return children[token];
    }, this.root);
  }
}

// =========================
// Utilities
// =========================

function createNode(value, parent) {
  return updateNode({
    children: {}
  }, value, parent);
}
function updateNode(node, value, parent) {
  node.value = value || {};
  node.protoValue = parent ? (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, parent.protoValue), node.value) : node.value;
  Object.keys(node.children).forEach(prop => {
    const child = node.children[prop];
    node.children[prop] = updateNode(child, child.value, node);
  });
  return node;
}

/***/ }),

/***/ 83393:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createErrorType)
/* harmony export */ });
function createErrorType(name, init) {
  function E() {
    if (!Error.captureStackTrace) {
      this.stack = new Error().stack;
    } else {
      Error.captureStackTrace(this, this.constructor);
    }
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    [this.message] = args;
    if (init) {
      init.apply(this, args);
    }
  }
  E.prototype = new Error();
  E.prototype.name = name;
  E.prototype.constructor = E;
  return E;
}

/***/ }),

/***/ 53275:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var fast_json_patch__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81303);
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9996);
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_2__);



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  add,
  replace,
  remove,
  merge,
  mergeDeep,
  context,
  getIn,
  applyPatch,
  parentPathMatch,
  flatten,
  fullyNormalizeArray,
  normalizeArray,
  isPromise,
  forEachNew,
  forEachNewPrimitive,
  isJsonPatch,
  isContextPatch,
  isPatch,
  isMutation,
  isAdditiveMutation,
  isGenerator,
  isFunction,
  isObject,
  isError
});
function applyPatch(obj, patch, opts) {
  opts = opts || {};
  patch = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, patch), {}, {
    path: patch.path && normalizeJSONPath(patch.path)
  });
  if (patch.op === 'merge') {
    const newValue = getInByJsonPath(obj, patch.path);
    Object.assign(newValue, patch.value);
    fast_json_patch__WEBPACK_IMPORTED_MODULE_1__.applyPatch(obj, [replace(patch.path, newValue)]);
  } else if (patch.op === 'mergeDeep') {
    const currentValue = getInByJsonPath(obj, patch.path);
    const newValue = deepmerge__WEBPACK_IMPORTED_MODULE_2___default()(currentValue, patch.value);
    obj = fast_json_patch__WEBPACK_IMPORTED_MODULE_1__.applyPatch(obj, [replace(patch.path, newValue)]).newDocument;
  } else if (patch.op === 'add' && patch.path === '' && isObject(patch.value)) {
    // { op: 'add', path: '', value: { a: 1, b: 2 }}
    // has no effect: json patch refuses to do anything.
    // so let's break that patch down into a set of patches,
    // one for each key in the intended root value.

    const patches = Object.keys(patch.value).reduce((arr, key) => {
      arr.push({
        op: 'add',
        path: `/${normalizeJSONPath(key)}`,
        value: patch.value[key]
      });
      return arr;
    }, []);
    fast_json_patch__WEBPACK_IMPORTED_MODULE_1__.applyPatch(obj, patches);
  } else if (patch.op === 'replace' && patch.path === '') {
    let {
      value
    } = patch;
    if (opts.allowMetaPatches && patch.meta && isAdditiveMutation(patch) && (Array.isArray(patch.value) || isObject(patch.value))) {
      value = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, value), patch.meta);
    }
    obj = value;
  } else {
    fast_json_patch__WEBPACK_IMPORTED_MODULE_1__.applyPatch(obj, [patch]);

    // Attach metadata to the resulting value.
    if (opts.allowMetaPatches && patch.meta && isAdditiveMutation(patch) && (Array.isArray(patch.value) || isObject(patch.value))) {
      const currentValue = getInByJsonPath(obj, patch.path);
      const newValue = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, currentValue), patch.meta);
      fast_json_patch__WEBPACK_IMPORTED_MODULE_1__.applyPatch(obj, [replace(patch.path, newValue)]);
    }
  }
  return obj;
}
function normalizeJSONPath(path) {
  if (Array.isArray(path)) {
    if (path.length < 1) {
      return '';
    }
    return `/${path.map(item =>
    // eslint-disable-line prefer-template
    (item + '').replace(/~/g, '~0').replace(/\//g, '~1') // eslint-disable-line prefer-template
    ).join('/')}`;
  }
  return path;
}

// =========================
// JSON-Patch Wrappers
// =========================

function add(path, value) {
  return {
    op: 'add',
    path,
    value
  };
}

// function _get(path) {
//   return { op: '_get', path };
// }

function replace(path, value, meta) {
  return {
    op: 'replace',
    path,
    value,
    meta
  };
}
function remove(path) {
  return {
    op: 'remove',
    path
  };
}

// Custom wrappers
function merge(path, value) {
  return {
    type: 'mutation',
    op: 'merge',
    path,
    value
  };
}

// Custom wrappers
function mergeDeep(path, value) {
  return {
    type: 'mutation',
    op: 'mergeDeep',
    path,
    value
  };
}
function context(path, value) {
  return {
    type: 'context',
    path,
    value
  };
}

// =========================
// Iterators
// =========================

function forEachNew(mutations, fn) {
  try {
    return forEachNewPatch(mutations, forEach, fn);
  } catch (e) {
    return e;
  }
}
function forEachNewPrimitive(mutations, fn) {
  try {
    return forEachNewPatch(mutations, forEachPrimitive, fn);
  } catch (e) {
    return e;
  }
}
function forEachNewPatch(mutations, fn, callback) {
  const res = mutations.filter(isAdditiveMutation).map(mutation => fn(mutation.value, callback, mutation.path)) || [];
  const flat = flatten(res);
  const clean = cleanArray(flat);
  return clean;
}
function forEachPrimitive(obj, fn, basePath) {
  basePath = basePath || [];
  if (Array.isArray(obj)) {
    return obj.map((val, key) => forEachPrimitive(val, fn, basePath.concat(key)));
  }
  if (isObject(obj)) {
    return Object.keys(obj).map(key => forEachPrimitive(obj[key], fn, basePath.concat(key)));
  }
  return fn(obj, basePath[basePath.length - 1], basePath);
}
function forEach(obj, fn, basePath) {
  basePath = basePath || [];
  let results = [];
  if (basePath.length > 0) {
    const newResults = fn(obj, basePath[basePath.length - 1], basePath);
    if (newResults) {
      results = results.concat(newResults);
    }
  }
  if (Array.isArray(obj)) {
    const arrayResults = obj.map((val, key) => forEach(val, fn, basePath.concat(key)));
    if (arrayResults) {
      results = results.concat(arrayResults);
    }
  } else if (isObject(obj)) {
    const moreResults = Object.keys(obj).map(key => forEach(obj[key], fn, basePath.concat(key)));
    if (moreResults) {
      results = results.concat(moreResults);
    }
  }
  results = flatten(results);
  return results;
}

// =========================
// Paths
// =========================

function parentPathMatch(path, arr) {
  if (!Array.isArray(arr)) {
    return false;
  }
  for (let i = 0, len = arr.length; i < len; i += 1) {
    if (arr[i] !== path[i]) {
      return false;
    }
  }
  return true;
}
function getIn(obj, path) {
  return path.reduce((val, token) => {
    if (typeof token !== 'undefined' && val) {
      return val[token];
    }
    return val;
  }, obj);
}

// =========================
// Array
// =========================

function fullyNormalizeArray(arr) {
  return cleanArray(flatten(normalizeArray(arr)));
}
function normalizeArray(arr) {
  return Array.isArray(arr) ? arr : [arr];
}
function flatten(arr) {
  return [].concat(...arr.map(val => Array.isArray(val) ? flatten(val) : val));
}
function cleanArray(arr) {
  return arr.filter(elm => typeof elm !== 'undefined');
}

// =========================
// Is-Thing.
// =========================

function isObject(val) {
  return val && typeof val === 'object';
}
function isPromise(val) {
  return isObject(val) && isFunction(val.then);
}
function isFunction(val) {
  return val && typeof val === 'function';
}
function isError(patch) {
  return patch instanceof Error;
}
function isJsonPatch(patch) {
  if (isPatch(patch)) {
    const {
      op
    } = patch;
    return op === 'add' || op === 'remove' || op === 'replace';
  }
  return false;
}
function isGenerator(thing) {
  return Object.prototype.toString.call(thing) === '[object GeneratorFunction]';
}
function isMutation(patch) {
  return isJsonPatch(patch) || isPatch(patch) && patch.type === 'mutation';
}
function isAdditiveMutation(patch) {
  return isMutation(patch) && (patch.op === 'add' || patch.op === 'replace' || patch.op === 'merge' || patch.op === 'mergeDeep');
}
function isContextPatch(patch) {
  return isPatch(patch) && patch.type === 'context';
}
function isPatch(patch) {
  return patch && typeof patch === 'object';
}
function getInByJsonPath(obj, jsonPath) {
  try {
    return fast_json_patch__WEBPACK_IMPORTED_MODULE_1__.getValueByPointer(obj, jsonPath);
  } catch (e) {
    console.error(e); // eslint-disable-line no-console
    return {};
  }
}

/***/ }),

/***/ 12983:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53275);


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  key: 'parameters',
  plugin: (parameters, key, fullPath, specmap) => {
    if (Array.isArray(parameters) && parameters.length) {
      const val = Object.assign([], parameters);
      const opPath = fullPath.slice(0, -1);
      const op = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, _index_js__WEBPACK_IMPORTED_MODULE_1__["default"].getIn(specmap.spec, opPath));
      for (let i = 0; i < parameters.length; i += 1) {
        const param = parameters[i];
        try {
          val[i].default = specmap.parameterMacro(op, param);
        } catch (e) {
          const err = new Error(e);
          err.fullPath = fullPath;
          return err;
        }
      }
      return _index_js__WEBPACK_IMPORTED_MODULE_1__["default"].replace(fullPath, val);
    }
    return _index_js__WEBPACK_IMPORTED_MODULE_1__["default"].replace(fullPath, parameters);
  }
});

/***/ }),

/***/ 54631:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53275);


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  key: 'properties',
  plugin: (properties, key, fullPath, specmap) => {
    const val = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, properties);

    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const k in properties) {
      try {
        val[k].default = specmap.modelPropertyMacro(val[k]);
      } catch (e) {
        const err = new Error(e);
        err.fullPath = fullPath; // This is an array
        return err;
      }
    }
    const patch = _index_js__WEBPACK_IMPORTED_MODULE_1__["default"].replace(fullPath, val);
    return patch;
  }
});

/***/ }),

/***/ 58569:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var cross_fetch_polyfill__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9559);
/* harmony import */ var cross_fetch_polyfill__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(cross_fetch_polyfill__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1272);
/* harmony import */ var url__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8575);
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53275);
/* harmony import */ var _create_error_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(83393);
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(52460);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(58061);







const ABSOLUTE_URL_REGEXP = /^([a-z]+:\/\/|\/\/)/i;
const JSONRefError = (0,_create_error_js__WEBPACK_IMPORTED_MODULE_5__["default"])('JSONRefError', function cb(message, extra, oriError) {
  this.originalError = oriError;
  Object.assign(this, extra || {});
});
const docCache = {};
const specmapRefs = new WeakMap();
const skipResolutionTestFns = [
// OpenAPI 2.0 response examples
path =>
// ["paths", *, *, "responses", *, "examples"]
path[0] === 'paths' && path[3] === 'responses' && path[5] === 'examples',
// OpenAPI 3.0 Response Media Type Examples
path =>
// ["paths", *, *, "responses", *, "content", *, "example"]
path[0] === 'paths' && path[3] === 'responses' && path[5] === 'content' && path[7] === 'example', path =>
// ["paths", *, *, "responses", *, "content", *, "examples", *, "value"]
path[0] === 'paths' && path[3] === 'responses' && path[5] === 'content' && path[7] === 'examples' && path[9] === 'value',
// OpenAPI 3.0 Request Body Media Type Examples
path =>
// ["paths", *, *, "requestBody", "content", *, "example"]
path[0] === 'paths' && path[3] === 'requestBody' && path[4] === 'content' && path[6] === 'example', path =>
// ["paths", *, *, "requestBody", "content", *, "examples", *, "value"]
path[0] === 'paths' && path[3] === 'requestBody' && path[4] === 'content' && path[6] === 'examples' && path[8] === 'value',
// OAS 3.0 Parameter Examples
path =>
// ["paths", *, "parameters", *, "example"]
path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'example', path =>
// ["paths", *, *, "parameters", *, "example"]
path[0] === 'paths' && path[3] === 'parameters' && path[5] === 'example', path =>
// ["paths", *, "parameters", *, "examples", *, "value"]
path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'examples' && path[6] === 'value', path =>
// ["paths", *, *, "parameters", *, "examples", *, "value"]
path[0] === 'paths' && path[3] === 'parameters' && path[5] === 'examples' && path[7] === 'value', path =>
// ["paths", *, "parameters", *, "content", *, "example"]
path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'content' && path[6] === 'example', path =>
// ["paths", *, "parameters", *, "content", *, "examples", *, "value"]
path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'content' && path[6] === 'examples' && path[8] === 'value', path =>
// ["paths", *, *, "parameters", *, "content", *, "example"]
path[0] === 'paths' && path[3] === 'parameters' && path[4] === 'content' && path[7] === 'example', path =>
// ["paths", *, *, "parameters", *, "content", *, "examples", *, "value"]
path[0] === 'paths' && path[3] === 'parameters' && path[5] === 'content' && path[7] === 'examples' && path[9] === 'value'];
const shouldSkipResolution = path => skipResolutionTestFns.some(fn => fn(path));

// =========================
// Core
// =========================

/**
 * This plugin resolves the JSON pointers.
 * A major part of this plugin deals with cyclic references via 2 mechanisms.
 * 1. If a pointer was already resolved before in this path, halt.
 * 2. If the patch value points to one of the ancestors in this path, halt.
 *
 * Note that either one of these mechanism is sufficient, both must be in place.
 * For examples:
 *
 * Given the following spec, #1 alone is insufficient because after the 2nd
 * application, there will be a cyclic object reference.
 *   a.b.c: $ref-d
 *   d.e.f: $ref-a (per #1, safe to return patch as no immediate cycle)
 *
 * Given the following spec, #2 alone is insufficient because although there will
 * never be any cyclic object reference, the plugin will keep producing patches.
 *   a: $ref-b
 *   b: $ref-a
 */
const plugin = {
  key: '$ref',
  plugin: (ref, key, fullPath, specmap) => {
    const specmapInstance = specmap.getInstance();
    const parent = fullPath.slice(0, -1);
    if ((0,_helpers_js__WEBPACK_IMPORTED_MODULE_4__.isFreelyNamed)(parent) || shouldSkipResolution(parent)) {
      return undefined;
    }
    const {
      baseDoc
    } = specmap.getContext(fullPath);
    if (typeof ref !== 'string') {
      return new JSONRefError('$ref: must be a string (JSON-Ref)', {
        $ref: ref,
        baseDoc,
        fullPath
      });
    }
    const splitString = split(ref);
    const refPath = splitString[0];
    const pointer = splitString[1] || '';
    let basePath;
    try {
      basePath = baseDoc || refPath ? absoluteify(refPath, baseDoc) : null;
    } catch (e) {
      return wrapError(e, {
        pointer,
        $ref: ref,
        basePath,
        fullPath
      });
    }
    let promOrVal;
    let tokens;
    if (pointerAlreadyInPath(pointer, basePath, parent, specmap)) {
      // Cyclic reference!
      // if `useCircularStructures` is not set, just leave the reference
      // unresolved, but absolutify it so that we don't leave an invalid $ref
      // path in the content
      if (!specmapInstance.useCircularStructures) {
        const absolutifiedRef = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_4__.absolutifyPointer)(ref, basePath);
        if (ref === absolutifiedRef) {
          // avoids endless looping
          // without this, the ref plugin never stops seeing this $ref
          return null;
        }
        return _index_js__WEBPACK_IMPORTED_MODULE_3__["default"].replace(fullPath, absolutifiedRef);
      }
    }
    if (basePath == null) {
      tokens = jsonPointerToArray(pointer);
      promOrVal = specmap.get(tokens);
      if (typeof promOrVal === 'undefined') {
        promOrVal = new JSONRefError(`Could not resolve reference: ${ref}`, {
          pointer,
          $ref: ref,
          baseDoc,
          fullPath
        });
      }
    } else {
      promOrVal = extractFromDoc(basePath, pointer);
      // eslint-disable-next-line no-underscore-dangle
      if (promOrVal.__value != null) {
        promOrVal = promOrVal.__value; // eslint-disable-line no-underscore-dangle
      } else {
        promOrVal = promOrVal.catch(e => {
          throw wrapError(e, {
            pointer,
            $ref: ref,
            baseDoc,
            fullPath
          });
        });
      }
    }
    if (promOrVal instanceof Error) {
      return [_index_js__WEBPACK_IMPORTED_MODULE_3__["default"].remove(fullPath), promOrVal];
    }
    const absolutifiedRef = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_4__.absolutifyPointer)(ref, basePath);
    const patch = _index_js__WEBPACK_IMPORTED_MODULE_3__["default"].replace(parent, promOrVal, {
      $$ref: absolutifiedRef
    });
    if (basePath && basePath !== baseDoc) {
      return [patch, _index_js__WEBPACK_IMPORTED_MODULE_3__["default"].context(parent, {
        baseDoc: basePath
      })];
    }
    try {
      // prevents circular values from being constructed, unless we specifically
      // want that to happen
      if (!patchValueAlreadyInPath(specmap.state, patch) || specmapInstance.useCircularStructures) {
        return patch;
      }
    } catch (e) {
      // if we're catching here, path traversal failed, so we should
      // ditch without sending any patches back up.
      //
      // this is a narrow fix for the larger problem of patches being queued
      // and then having the state they were generated against be modified
      // before they are applied.
      //
      // TODO: re-engineer specmap patch/state management to avoid this
      return null;
    }
    return undefined;
  }
};
const mod = Object.assign(plugin, {
  docCache,
  absoluteify,
  clearCache,
  JSONRefError,
  wrapError,
  getDoc,
  split,
  extractFromDoc,
  fetchJSON,
  extract,
  jsonPointerToArray,
  unescapeJsonPointerToken
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mod);

// =========================
// Utilities
// =========================

/**
 * Resolves a path and its base to an abolute URL.
 * @api public
 */
function absoluteify(path, basePath) {
  if (!ABSOLUTE_URL_REGEXP.test(path)) {
    if (!basePath) {
      throw new JSONRefError(`Tried to resolve a relative URL, without having a basePath. path: '${path}' basePath: '${basePath}'`);
    }
    return url__WEBPACK_IMPORTED_MODULE_2__.resolve(basePath, path);
  }
  return path;
}

/**
 * Wraps an error as JSONRefError.
 * @param  {Error} e      the error.
 * @param  {Object} extra (optional) optional data.
 * @return {Error}        an instance of JSONRefError.
 * @api public
 */
function wrapError(e, extra) {
  let message;
  if (e && e.response && e.response.body) {
    message = `${e.response.body.code} ${e.response.body.message}`;
  } else {
    message = e.message;
  }
  return new JSONRefError(`Could not resolve reference: ${message}`, extra, e);
}

/**
 * Splits a pointer by the hash delimiter.
 * @api public
 */
function split(ref) {
  return (ref + '').split('#'); // eslint-disable-line prefer-template
}

/**
 * Extracts a pointer from its document.
 * @param  {String} docPath the absolute document URL.
 * @param  {String} pointer the pointer whose value is to be extracted.
 * @return {Promise}        a promise of the pointer value.
 * @api public
 */
function extractFromDoc(docPath, pointer) {
  const doc = docCache[docPath];
  if (doc && !_index_js__WEBPACK_IMPORTED_MODULE_3__["default"].isPromise(doc)) {
    // If doc is already available, return __value together with the promise.
    // __value is for special handling in cycle check:
    // pointerAlreadyInPath() won't work if patch.value is a promise,
    // thus when that promise is finally resolved, cycle might happen (because
    // `spec` and `docCache[basePath]` refer to the exact same object).
    // See test "should resolve a cyclic spec when baseDoc is specified".
    try {
      const v = extract(pointer, doc);
      return Object.assign(Promise.resolve(v), {
        __value: v
      });
    } catch (e) {
      return Promise.reject(e);
    }
  }
  return getDoc(docPath).then(_doc => extract(pointer, _doc));
}

/**
 * Clears all document caches.
 * @param  {String} item (optional) the name of the cache item to be cleared.
 * @api public
 */
function clearCache(item) {
  if (typeof item !== 'undefined') {
    delete docCache[item];
  } else {
    Object.keys(docCache).forEach(key => {
      delete docCache[key];
    });
  }
}

/**
 * Fetches and caches a document.
 * @param  {String} docPath the absolute URL of the document.
 * @return {Promise}        a promise of the document content.
 * @api public
 */
function getDoc(docPath) {
  const val = docCache[docPath];
  if (val) {
    return _index_js__WEBPACK_IMPORTED_MODULE_3__["default"].isPromise(val) ? val : Promise.resolve(val);
  }

  // NOTE: we need to use `mod.fetchJSON` in order to be able to overwrite it.
  // Any tips on how to make this cleaner, please ping!
  docCache[docPath] = mod.fetchJSON(docPath).then(doc => {
    docCache[docPath] = doc;
    return doc;
  });
  return docCache[docPath];
}

/**
 * Fetches a document.
 * @param  {String} docPath the absolute URL of the document.
 * @return {Promise}        a promise of the document content.
 * @api public
 */
function fetchJSON(docPath) {
  return fetch(docPath, {
    headers: {
      Accept: _constants_js__WEBPACK_IMPORTED_MODULE_6__.ACCEPT_HEADER_VALUE_FOR_DOCUMENTS
    },
    loadSpec: true
  }).then(res => res.text()).then(text => js_yaml__WEBPACK_IMPORTED_MODULE_1__["default"].load(text));
}

/**
 * Extracts a pointer from an object.
 * @param  {String[]} pointer the JSON pointer.
 * @param  {Object} obj       an object whose value is to be extracted.
 * @return {Object}           the value to be extracted.
 * @api public
 */
function extract(pointer, obj) {
  const tokens = jsonPointerToArray(pointer);
  if (tokens.length < 1) {
    return obj;
  }
  const val = _index_js__WEBPACK_IMPORTED_MODULE_3__["default"].getIn(obj, tokens);
  if (typeof val === 'undefined') {
    throw new JSONRefError(`Could not resolve pointer: ${pointer} does not exist in document`, {
      pointer
    });
  }
  return val;
}

/**
 * Converts a JSON pointer to array.
 * @api public
 */
function jsonPointerToArray(pointer) {
  if (typeof pointer !== 'string') {
    throw new TypeError(`Expected a string, got a ${typeof pointer}`);
  }
  if (pointer[0] === '/') {
    pointer = pointer.substr(1);
  }
  if (pointer === '') {
    return [];
  }
  return pointer.split('/').map(unescapeJsonPointerToken);
}

/**
 * Unescapes a JSON pointer.
 * @api public
 */
function unescapeJsonPointerToken(token) {
  if (typeof token !== 'string') {
    return token;
  }
  const params = new URLSearchParams(`=${token.replace(/~1/g, '/').replace(/~0/g, '~')}`);
  return params.get('');
}

/**
 * Escapes a JSON pointer.
 * @api public
 */
function escapeJsonPointerToken(token) {
  const params = new URLSearchParams([['', token.replace(/~/g, '~0').replace(/\//g, '~1')]]);
  return params.toString().slice(1);
}
function arrayToJsonPointer(arr) {
  if (arr.length === 0) {
    return '';
  }
  return `/${arr.map(escapeJsonPointerToken).join('/')}`;
}
const pointerBoundaryChar = c => !c || c === '/' || c === '#';
function pointerIsAParent(pointer, parentPointer) {
  if (pointerBoundaryChar(parentPointer)) {
    // This is the root of the document, so its naturally a parent
    return true;
  }
  const nextChar = pointer.charAt(parentPointer.length);
  const lastParentChar = parentPointer.slice(-1);
  return pointer.indexOf(parentPointer) === 0 && (!nextChar || nextChar === '/' || nextChar === '#') && lastParentChar !== '#';
}

// =========================
// Private
// =========================

/**
 * Checks if this pointer points back to one or more pointers along the path.
 */
function pointerAlreadyInPath(pointer, basePath, parent, specmap) {
  let refs = specmapRefs.get(specmap);
  if (!refs) {
    // Stores all resolved references of a specmap instance.
    // Schema: path -> pointer (path's $ref value).
    refs = {};
    specmapRefs.set(specmap, refs);
  }
  const parentPointer = arrayToJsonPointer(parent);
  const fullyQualifiedPointer = `${basePath || '<specmap-base>'}#${pointer}`;

  // dirty hack to strip `allof/[index]` from the path, in order to avoid cases
  // where we get false negatives because:
  // - we resolve a path, then
  // - allOf plugin collapsed `allOf/[index]` out of the path, then
  // - we try to work on a child $ref within that collapsed path.
  //
  // because of the path collapse, we lose track of it in our specmapRefs hash
  // solution: always throw the allOf constructs out of paths we store
  // TODO: solve this with a global register, or by writing more metadata in
  // either allOf or refs plugin
  const safeParentPointer = parentPointer.replace(/allOf\/\d+\/?/g, '');

  // Case 1: direct cycle, e.g. a.b.c.$ref: '/a.b'
  // Detect by checking that the parent path doesn't start with pointer.
  // This only applies if the pointer is internal, i.e. basePath === rootPath (could be null)
  const rootDoc = specmap.contextTree.get([]).baseDoc;
  if (basePath === rootDoc && pointerIsAParent(safeParentPointer, pointer)) {
    // eslint-disable-line
    return true;
  }

  // Case 2: indirect cycle
  //  ex1: a.$ref: '/b'  &  b.c.$ref: '/b/c'
  //  ex2: a.$ref: '/b/c'  &  b.c.$ref: '/b'
  // Detect by retrieving all the $refs along the path of parent
  // and checking if any starts with pointer or vice versa.
  let currPath = '';
  const hasIndirectCycle = parent.some(token => {
    currPath = `${currPath}/${escapeJsonPointerToken(token)}`;
    return refs[currPath] && refs[currPath].some(ref => pointerIsAParent(ref, fullyQualifiedPointer) || pointerIsAParent(fullyQualifiedPointer, ref));
  });
  if (hasIndirectCycle) {
    return true;
  }

  // No cycle, this ref will be resolved, so stores it now for future detection.
  // No need to store if has cycle, as parent path is a dead-end and won't be checked again.

  refs[safeParentPointer] = (refs[safeParentPointer] || []).concat(fullyQualifiedPointer);
  return undefined;
}

/**
 * Checks if the value of this patch ends up pointing to an ancestor along the path.
 */
function patchValueAlreadyInPath(root, patch) {
  const ancestors = [root];
  patch.path.reduce((parent, p) => {
    ancestors.push(parent[p]);
    return parent[p];
  }, root);
  return pointToAncestor(patch.value);
  function pointToAncestor(obj) {
    return _index_js__WEBPACK_IMPORTED_MODULE_3__["default"].isObject(obj) && (ancestors.indexOf(obj) >= 0 || Object.keys(obj).some(k => pointToAncestor(obj[k])));
  }
}

/***/ }),

/***/ 64499:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "makeResolveSubtree": () => (/* binding */ makeResolveSubtree)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97530);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27361);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _resolver_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82788);
/* harmony import */ var _resolver_strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87485);
/* harmony import */ var _resolver_strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(48390);
/* harmony import */ var _resolver_strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(79018);

// The subtree resolver is a higher-level interface that allows you to
// get the same result that you would from `Swagger.resolve`, but focuses on
// a subtree of your object.
//
// It makes several assumptions that allow you to think less about what resolve,
// specmap, and normalizeSwagger are doing: if this is not suitable for you,
// you can emulate `resolveSubtree`'s behavior by talking to the traditional
// resolver directly.
//
// By providing a top-level `obj` and a `path` to resolve within, the subtree
// at `path` will be resolved and normalized in the context of your top-level
// `obj`. You'll get the resolved subtree you're interest in as a return value
// (or, you can use `returnEntireTree` to get everything back).
//
// This is useful for cases where resolving your entire object is unnecessary
// and/or non-performant; we use this interface for lazily resolving operations
// and models in Swagger-UI, which allows us to handle larger definitions.
//
// It's likely that Swagger-Client will rely entirely on lazy resolving in
// future versions.
//
// TODO: move the remarks above into project documentation





const resolveSubtree = async function (obj, path) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const {
    returnEntireTree,
    baseDoc,
    requestInterceptor,
    responseInterceptor,
    parameterMacro,
    modelPropertyMacro,
    useCircularStructures,
    strategies
  } = options;
  const resolveOptions = {
    spec: obj,
    pathDiscriminator: path,
    baseDoc,
    requestInterceptor,
    responseInterceptor,
    parameterMacro,
    modelPropertyMacro,
    useCircularStructures,
    strategies
  };
  const strategy = strategies.find(strg => strg.match(resolveOptions));
  const normalized = strategy.normalize(resolveOptions);
  const result = await (0,_resolver_index_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, resolveOptions), {}, {
    spec: normalized,
    allowMetaPatches: true,
    skipNormalization: true
  }));
  if (!returnEntireTree && Array.isArray(path) && path.length) {
    result.spec = lodash_get__WEBPACK_IMPORTED_MODULE_1___default()(result.spec, path) || null;
  }
  return result;
};
const makeResolveSubtree = defaultOptions => async function (obj, path) {
  let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  const mergedOptions = (0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_corejs3_helpers_objectSpread2__WEBPACK_IMPORTED_MODULE_0__["default"])({}, defaultOptions), options);
  return resolveSubtree(obj, path, mergedOptions);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (makeResolveSubtree({
  strategies: [_resolver_strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_5__["default"], _resolver_strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_4__["default"], _resolver_strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_3__["default"]]
}));

/***/ }),

/***/ 21924:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var GetIntrinsic = __webpack_require__(40210);

var callBind = __webpack_require__(55559);

var $indexOf = callBind(GetIntrinsic('String.prototype.indexOf'));

module.exports = function callBoundIntrinsic(name, allowMissing) {
	var intrinsic = GetIntrinsic(name, !!allowMissing);
	if (typeof intrinsic === 'function' && $indexOf(name, '.prototype.') > -1) {
		return callBind(intrinsic);
	}
	return intrinsic;
};


/***/ }),

/***/ 55559:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(58612);
var GetIntrinsic = __webpack_require__(40210);

var $apply = GetIntrinsic('%Function.prototype.apply%');
var $call = GetIntrinsic('%Function.prototype.call%');
var $reflectApply = GetIntrinsic('%Reflect.apply%', true) || bind.call($call, $apply);

var $gOPD = GetIntrinsic('%Object.getOwnPropertyDescriptor%', true);
var $defineProperty = GetIntrinsic('%Object.defineProperty%', true);
var $max = GetIntrinsic('%Math.max%');

if ($defineProperty) {
	try {
		$defineProperty({}, 'a', { value: 1 });
	} catch (e) {
		// IE 8 has a broken defineProperty
		$defineProperty = null;
	}
}

module.exports = function callBind(originalFunction) {
	var func = $reflectApply(bind, $call, arguments);
	if ($gOPD && $defineProperty) {
		var desc = $gOPD(func, 'length');
		if (desc.configurable) {
			// original length, plus the receiver, minus any additional arguments (after the receiver)
			$defineProperty(
				func,
				'length',
				{ value: 1 + $max(0, originalFunction.length - (arguments.length - 1)) }
			);
		}
	}
	return func;
};

var applyBind = function applyBind() {
	return $reflectApply(bind, $apply, arguments);
};

if ($defineProperty) {
	$defineProperty(module.exports, 'apply', { value: applyBind });
} else {
	module.exports.apply = applyBind;
}


/***/ }),

/***/ 76489:
/***/ ((__unused_webpack_module, exports) => {

"use strict";
/*!
 * cookie
 * Copyright(c) 2012-2014 Roman Shtylman
 * Copyright(c) 2015 Douglas Christopher Wilson
 * MIT Licensed
 */



/**
 * Module exports.
 * @public
 */

exports.parse = parse;
exports.serialize = serialize;

/**
 * Module variables.
 * @private
 */

var __toString = Object.prototype.toString

/**
 * RegExp to match field-content in RFC 7230 sec 3.2
 *
 * field-content = field-vchar [ 1*( SP / HTAB ) field-vchar ]
 * field-vchar   = VCHAR / obs-text
 * obs-text      = %x80-FF
 */

var fieldContentRegExp = /^[\u0009\u0020-\u007e\u0080-\u00ff]+$/;

/**
 * Parse a cookie header.
 *
 * Parse the given cookie header string into an object
 * The object has the various cookies as keys(names) => values
 *
 * @param {string} str
 * @param {object} [options]
 * @return {object}
 * @public
 */

function parse(str, options) {
  if (typeof str !== 'string') {
    throw new TypeError('argument str must be a string');
  }

  var obj = {}
  var opt = options || {};
  var dec = opt.decode || decode;

  var index = 0
  while (index < str.length) {
    var eqIdx = str.indexOf('=', index)

    // no more cookie pairs
    if (eqIdx === -1) {
      break
    }

    var endIdx = str.indexOf(';', index)

    if (endIdx === -1) {
      endIdx = str.length
    } else if (endIdx < eqIdx) {
      // backtrack on prior semicolon
      index = str.lastIndexOf(';', eqIdx - 1) + 1
      continue
    }

    var key = str.slice(index, eqIdx).trim()

    // only assign once
    if (undefined === obj[key]) {
      var val = str.slice(eqIdx + 1, endIdx).trim()

      // quoted values
      if (val.charCodeAt(0) === 0x22) {
        val = val.slice(1, -1)
      }

      obj[key] = tryDecode(val, dec);
    }

    index = endIdx + 1
  }

  return obj;
}

/**
 * Serialize data into a cookie header.
 *
 * Serialize the a name value pair into a cookie string suitable for
 * http headers. An optional options object specified cookie parameters.
 *
 * serialize('foo', 'bar', { httpOnly: true })
 *   => "foo=bar; httpOnly"
 *
 * @param {string} name
 * @param {string} val
 * @param {object} [options]
 * @return {string}
 * @public
 */

function serialize(name, val, options) {
  var opt = options || {};
  var enc = opt.encode || encode;

  if (typeof enc !== 'function') {
    throw new TypeError('option encode is invalid');
  }

  if (!fieldContentRegExp.test(name)) {
    throw new TypeError('argument name is invalid');
  }

  var value = enc(val);

  if (value && !fieldContentRegExp.test(value)) {
    throw new TypeError('argument val is invalid');
  }

  var str = name + '=' + value;

  if (null != opt.maxAge) {
    var maxAge = opt.maxAge - 0;

    if (isNaN(maxAge) || !isFinite(maxAge)) {
      throw new TypeError('option maxAge is invalid')
    }

    str += '; Max-Age=' + Math.floor(maxAge);
  }

  if (opt.domain) {
    if (!fieldContentRegExp.test(opt.domain)) {
      throw new TypeError('option domain is invalid');
    }

    str += '; Domain=' + opt.domain;
  }

  if (opt.path) {
    if (!fieldContentRegExp.test(opt.path)) {
      throw new TypeError('option path is invalid');
    }

    str += '; Path=' + opt.path;
  }

  if (opt.expires) {
    var expires = opt.expires

    if (!isDate(expires) || isNaN(expires.valueOf())) {
      throw new TypeError('option expires is invalid');
    }

    str += '; Expires=' + expires.toUTCString()
  }

  if (opt.httpOnly) {
    str += '; HttpOnly';
  }

  if (opt.secure) {
    str += '; Secure';
  }

  if (opt.priority) {
    var priority = typeof opt.priority === 'string'
      ? opt.priority.toLowerCase()
      : opt.priority

    switch (priority) {
      case 'low':
        str += '; Priority=Low'
        break
      case 'medium':
        str += '; Priority=Medium'
        break
      case 'high':
        str += '; Priority=High'
        break
      default:
        throw new TypeError('option priority is invalid')
    }
  }

  if (opt.sameSite) {
    var sameSite = typeof opt.sameSite === 'string'
      ? opt.sameSite.toLowerCase() : opt.sameSite;

    switch (sameSite) {
      case true:
        str += '; SameSite=Strict';
        break;
      case 'lax':
        str += '; SameSite=Lax';
        break;
      case 'strict':
        str += '; SameSite=Strict';
        break;
      case 'none':
        str += '; SameSite=None';
        break;
      default:
        throw new TypeError('option sameSite is invalid');
    }
  }

  return str;
}

/**
 * URL-decode string value. Optimized to skip native call when no %.
 *
 * @param {string} str
 * @returns {string}
 */

function decode (str) {
  return str.indexOf('%') !== -1
    ? decodeURIComponent(str)
    : str
}

/**
 * URL-encode value.
 *
 * @param {string} str
 * @returns {string}
 */

function encode (val) {
  return encodeURIComponent(val)
}

/**
 * Determine if value is a Date.
 *
 * @param {*} val
 * @private
 */

function isDate (val) {
  return __toString.call(val) === '[object Date]' ||
    val instanceof Date
}

/**
 * Try decoding a string using a decoding function.
 *
 * @param {string} str
 * @param {function} decode
 * @private
 */

function tryDecode(str, decode) {
  try {
    return decode(str);
  } catch (e) {
    return str;
  }
}


/***/ }),

/***/ 3688:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(11955);

module.exports = parent;


/***/ }),

/***/ 83838:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(46279);

module.exports = parent;


/***/ }),

/***/ 15684:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(19373);

module.exports = parent;


/***/ }),

/***/ 91254:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(57396);

module.exports = parent;


/***/ }),

/***/ 43536:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(41910);

module.exports = parent;


/***/ }),

/***/ 37331:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(79427);

module.exports = parent;


/***/ }),

/***/ 68522:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(62857);

module.exports = parent;


/***/ }),

/***/ 73151:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(9534);

module.exports = parent;


/***/ }),

/***/ 45012:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(23059);

module.exports = parent;


/***/ }),

/***/ 80281:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(92547);

__webpack_require__(43975);

module.exports = parent;


/***/ }),

/***/ 40031:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(46509);

module.exports = parent;


/***/ }),

/***/ 17487:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(35774);

module.exports = parent;


/***/ }),

/***/ 62383:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(21501);
var entryVirtual = __webpack_require__(35703);

module.exports = entryVirtual('Array').filter;


/***/ }),

/***/ 99324:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(2437);
var entryVirtual = __webpack_require__(35703);

module.exports = entryVirtual('Array').forEach;


/***/ }),

/***/ 8700:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(99076);
var entryVirtual = __webpack_require__(35703);

module.exports = entryVirtual('Array').indexOf;


/***/ }),

/***/ 2480:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isPrototypeOf = __webpack_require__(7046);
var method = __webpack_require__(62383);

var ArrayPrototype = Array.prototype;

module.exports = function (it) {
  var own = it.filter;
  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.filter) ? method : own;
};


/***/ }),

/***/ 34570:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isPrototypeOf = __webpack_require__(7046);
var method = __webpack_require__(8700);

var ArrayPrototype = Array.prototype;

module.exports = function (it) {
  var own = it.indexOf;
  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.indexOf) ? method : own;
};


/***/ }),

/***/ 7702:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(74979);
var path = __webpack_require__(54058);

var Object = path.Object;

var defineProperties = module.exports = function defineProperties(T, D) {
  return Object.defineProperties(T, D);
};

if (Object.defineProperties.sham) defineProperties.sham = true;


/***/ }),

/***/ 48171:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(86450);
var path = __webpack_require__(54058);

var Object = path.Object;

var defineProperty = module.exports = function defineProperty(it, key, desc) {
  return Object.defineProperty(it, key, desc);
};

if (Object.defineProperty.sham) defineProperty.sham = true;


/***/ }),

/***/ 286:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(46924);
var path = __webpack_require__(54058);

var Object = path.Object;

var getOwnPropertyDescriptor = module.exports = function getOwnPropertyDescriptor(it, key) {
  return Object.getOwnPropertyDescriptor(it, key);
};

if (Object.getOwnPropertyDescriptor.sham) getOwnPropertyDescriptor.sham = true;


/***/ }),

/***/ 92766:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(88482);
var path = __webpack_require__(54058);

module.exports = path.Object.getOwnPropertyDescriptors;


/***/ }),

/***/ 30498:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(35824);
var path = __webpack_require__(54058);

module.exports = path.Object.getOwnPropertySymbols;


/***/ }),

/***/ 48494:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(21724);
var path = __webpack_require__(54058);

module.exports = path.Object.keys;


/***/ }),

/***/ 57473:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(85906);
__webpack_require__(55967);
__webpack_require__(35824);
__webpack_require__(8555);
__webpack_require__(52615);
__webpack_require__(21732);
__webpack_require__(35903);
__webpack_require__(1825);
__webpack_require__(28394);
__webpack_require__(45915);
__webpack_require__(61766);
__webpack_require__(62737);
__webpack_require__(89911);
__webpack_require__(74315);
__webpack_require__(63131);
__webpack_require__(64714);
__webpack_require__(70659);
__webpack_require__(69120);
__webpack_require__(79413);
__webpack_require__(1502);
var path = __webpack_require__(54058);

module.exports = path.Symbol;


/***/ }),

/***/ 24227:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(66274);
__webpack_require__(55967);
__webpack_require__(77971);
__webpack_require__(1825);
var WrappedWellKnownSymbolModule = __webpack_require__(11477);

module.exports = WrappedWellKnownSymbolModule.f('iterator');


/***/ }),

/***/ 62978:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(18084);
__webpack_require__(63131);
var WrappedWellKnownSymbolModule = __webpack_require__(11477);

module.exports = WrappedWellKnownSymbolModule.f('toPrimitive');


/***/ }),

/***/ 44442:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(51675);


/***/ }),

/***/ 57152:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(82507);


/***/ }),

/***/ 69447:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(628);


/***/ }),

/***/ 70573:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(18180);


/***/ }),

/***/ 73685:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(80621);


/***/ }),

/***/ 27533:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(48403);


/***/ }),

/***/ 39057:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(82108);


/***/ }),

/***/ 84710:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(14058);


/***/ }),

/***/ 93799:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(92093);


/***/ }),

/***/ 86600:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(52201);


/***/ }),

/***/ 9759:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(27398);


/***/ }),

/***/ 71384:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(26189);


/***/ }),

/***/ 51675:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(3688);

module.exports = parent;


/***/ }),

/***/ 82507:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(83838);

module.exports = parent;


/***/ }),

/***/ 628:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(15684);

module.exports = parent;


/***/ }),

/***/ 18180:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(91254);

module.exports = parent;


/***/ }),

/***/ 80621:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(43536);

module.exports = parent;


/***/ }),

/***/ 48403:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(37331);

module.exports = parent;


/***/ }),

/***/ 82108:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(68522);

module.exports = parent;


/***/ }),

/***/ 14058:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(73151);

module.exports = parent;


/***/ }),

/***/ 92093:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(45012);

module.exports = parent;


/***/ }),

/***/ 52201:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(80281);
__webpack_require__(28783);
__webpack_require__(22731);
__webpack_require__(85605);
__webpack_require__(65799);
__webpack_require__(31943);
__webpack_require__(46774);
// TODO: Remove from `core-js@4`
__webpack_require__(45414);
__webpack_require__(80620);
__webpack_require__(36172);

module.exports = parent;


/***/ }),

/***/ 27398:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(40031);

module.exports = parent;


/***/ }),

/***/ 26189:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(17487);

module.exports = parent;


/***/ }),

/***/ 24883:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isCallable = __webpack_require__(57475);
var tryToString = __webpack_require__(69826);

var $TypeError = TypeError;

// `Assert: IsCallable(argument) is true`
module.exports = function (argument) {
  if (isCallable(argument)) return argument;
  throw $TypeError(tryToString(argument) + ' is not a function');
};


/***/ }),

/***/ 11851:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isCallable = __webpack_require__(57475);

var $String = String;
var $TypeError = TypeError;

module.exports = function (argument) {
  if (typeof argument == 'object' || isCallable(argument)) return argument;
  throw $TypeError("Can't set " + $String(argument) + ' as a prototype');
};


/***/ }),

/***/ 18479:
/***/ ((module) => {

module.exports = function () { /* empty */ };


/***/ }),

/***/ 96059:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(10941);

var $String = String;
var $TypeError = TypeError;

// `Assert: Type(argument) is Object`
module.exports = function (argument) {
  if (isObject(argument)) return argument;
  throw $TypeError($String(argument) + ' is not an object');
};


/***/ }),

/***/ 56837:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $forEach = (__webpack_require__(3610).forEach);
var arrayMethodIsStrict = __webpack_require__(34194);

var STRICT_METHOD = arrayMethodIsStrict('forEach');

// `Array.prototype.forEach` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.foreach
module.exports = !STRICT_METHOD ? function forEach(callbackfn /* , thisArg */) {
  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
// eslint-disable-next-line es/no-array-prototype-foreach -- safe
} : [].forEach;


/***/ }),

/***/ 31692:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toIndexedObject = __webpack_require__(74529);
var toAbsoluteIndex = __webpack_require__(59413);
var lengthOfArrayLike = __webpack_require__(10623);

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject($this);
    var length = lengthOfArrayLike(O);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

module.exports = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod(false)
};


/***/ }),

/***/ 3610:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var bind = __webpack_require__(86843);
var uncurryThis = __webpack_require__(95329);
var IndexedObject = __webpack_require__(37026);
var toObject = __webpack_require__(89678);
var lengthOfArrayLike = __webpack_require__(10623);
var arraySpeciesCreate = __webpack_require__(64692);

var push = uncurryThis([].push);

// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation
var createMethod = function (TYPE) {
  var IS_MAP = TYPE == 1;
  var IS_FILTER = TYPE == 2;
  var IS_SOME = TYPE == 3;
  var IS_EVERY = TYPE == 4;
  var IS_FIND_INDEX = TYPE == 6;
  var IS_FILTER_REJECT = TYPE == 7;
  var NO_HOLES = TYPE == 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = toObject($this);
    var self = IndexedObject(O);
    var boundFunction = bind(callbackfn, that);
    var length = lengthOfArrayLike(self);
    var index = 0;
    var create = specificCreate || arraySpeciesCreate;
    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
    var value, result;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (TYPE) {
        if (IS_MAP) target[index] = result; // map
        else if (result) switch (TYPE) {
          case 3: return true;              // some
          case 5: return value;             // find
          case 6: return index;             // findIndex
          case 2: push(target, value);      // filter
        } else switch (TYPE) {
          case 4: return false;             // every
          case 7: push(target, value);      // filterReject
        }
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

module.exports = {
  // `Array.prototype.forEach` method
  // https://tc39.es/ecma262/#sec-array.prototype.foreach
  forEach: createMethod(0),
  // `Array.prototype.map` method
  // https://tc39.es/ecma262/#sec-array.prototype.map
  map: createMethod(1),
  // `Array.prototype.filter` method
  // https://tc39.es/ecma262/#sec-array.prototype.filter
  filter: createMethod(2),
  // `Array.prototype.some` method
  // https://tc39.es/ecma262/#sec-array.prototype.some
  some: createMethod(3),
  // `Array.prototype.every` method
  // https://tc39.es/ecma262/#sec-array.prototype.every
  every: createMethod(4),
  // `Array.prototype.find` method
  // https://tc39.es/ecma262/#sec-array.prototype.find
  find: createMethod(5),
  // `Array.prototype.findIndex` method
  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
  findIndex: createMethod(6),
  // `Array.prototype.filterReject` method
  // https://github.com/tc39/proposal-array-filtering
  filterReject: createMethod(7)
};


/***/ }),

/***/ 50568:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(95981);
var wellKnownSymbol = __webpack_require__(99813);
var V8_VERSION = __webpack_require__(53385);

var SPECIES = wellKnownSymbol('species');

module.exports = function (METHOD_NAME) {
  // We can't use this feature detection in V8 since it causes
  // deoptimization and serious performance degradation
  // https://github.com/zloirock/core-js/issues/677
  return V8_VERSION >= 51 || !fails(function () {
    var array = [];
    var constructor = array.constructor = {};
    constructor[SPECIES] = function () {
      return { foo: 1 };
    };
    return array[METHOD_NAME](Boolean).foo !== 1;
  });
};


/***/ }),

/***/ 34194:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(95981);

module.exports = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && fails(function () {
    // eslint-disable-next-line no-useless-call -- required for testing
    method.call(null, argument || function () { return 1; }, 1);
  });
};


/***/ }),

/***/ 15790:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toAbsoluteIndex = __webpack_require__(59413);
var lengthOfArrayLike = __webpack_require__(10623);
var createProperty = __webpack_require__(55449);

var $Array = Array;
var max = Math.max;

module.exports = function (O, start, end) {
  var length = lengthOfArrayLike(O);
  var k = toAbsoluteIndex(start, length);
  var fin = toAbsoluteIndex(end === undefined ? length : end, length);
  var result = $Array(max(fin - k, 0));
  for (var n = 0; k < fin; k++, n++) createProperty(result, n, O[k]);
  result.length = n;
  return result;
};


/***/ }),

/***/ 93765:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);

module.exports = uncurryThis([].slice);


/***/ }),

/***/ 5693:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArray = __webpack_require__(1052);
var isConstructor = __webpack_require__(24284);
var isObject = __webpack_require__(10941);
var wellKnownSymbol = __webpack_require__(99813);

var SPECIES = wellKnownSymbol('species');
var $Array = Array;

// a part of `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate
module.exports = function (originalArray) {
  var C;
  if (isArray(originalArray)) {
    C = originalArray.constructor;
    // cross-realm fallback
    if (isConstructor(C) && (C === $Array || isArray(C.prototype))) C = undefined;
    else if (isObject(C)) {
      C = C[SPECIES];
      if (C === null) C = undefined;
    }
  } return C === undefined ? $Array : C;
};


/***/ }),

/***/ 64692:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arraySpeciesConstructor = __webpack_require__(5693);

// `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate
module.exports = function (originalArray, length) {
  return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
};


/***/ }),

/***/ 82532:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);

var toString = uncurryThis({}.toString);
var stringSlice = uncurryThis(''.slice);

module.exports = function (it) {
  return stringSlice(toString(it), 8, -1);
};


/***/ }),

/***/ 9697:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var TO_STRING_TAG_SUPPORT = __webpack_require__(22885);
var isCallable = __webpack_require__(57475);
var classofRaw = __webpack_require__(82532);
var wellKnownSymbol = __webpack_require__(99813);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var $Object = Object;

// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw(O)
    // ES3 arguments fallback
    : (result = classofRaw(O)) == 'Object' && isCallable(O.callee) ? 'Arguments' : result;
};


/***/ }),

/***/ 64160:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(95981);

module.exports = !fails(function () {
  function F() { /* empty */ }
  F.prototype.constructor = null;
  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
  return Object.getPrototypeOf(new F()) !== F.prototype;
});


/***/ }),

/***/ 23538:
/***/ ((module) => {

// `CreateIterResultObject` abstract operation
// https://tc39.es/ecma262/#sec-createiterresultobject
module.exports = function (value, done) {
  return { value: value, done: done };
};


/***/ }),

/***/ 32029:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(55746);
var definePropertyModule = __webpack_require__(65988);
var createPropertyDescriptor = __webpack_require__(31887);

module.exports = DESCRIPTORS ? function (object, key, value) {
  return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),

/***/ 31887:
/***/ ((module) => {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),

/***/ 55449:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toPropertyKey = __webpack_require__(83894);
var definePropertyModule = __webpack_require__(65988);
var createPropertyDescriptor = __webpack_require__(31887);

module.exports = function (object, key, value) {
  var propertyKey = toPropertyKey(key);
  if (propertyKey in object) definePropertyModule.f(object, propertyKey, createPropertyDescriptor(0, value));
  else object[propertyKey] = value;
};


/***/ }),

/***/ 29202:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var defineProperty = __webpack_require__(65988);

module.exports = function (target, name, descriptor) {
  return defineProperty.f(target, name, descriptor);
};


/***/ }),

/***/ 95929:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var createNonEnumerableProperty = __webpack_require__(32029);

module.exports = function (target, key, value, options) {
  if (options && options.enumerable) target[key] = value;
  else createNonEnumerableProperty(target, key, value);
  return target;
};


/***/ }),

/***/ 75609:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(21899);

// eslint-disable-next-line es/no-object-defineproperty -- safe
var defineProperty = Object.defineProperty;

module.exports = function (key, value) {
  try {
    defineProperty(global, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    global[key] = value;
  } return value;
};


/***/ }),

/***/ 55746:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(95981);

// Detect IE8's incomplete defineProperty implementation
module.exports = !fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] != 7;
});


/***/ }),

/***/ 76616:
/***/ ((module) => {

var documentAll = typeof document == 'object' && document.all;

// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
// eslint-disable-next-line unicorn/no-typeof-undefined -- required for testing
var IS_HTMLDDA = typeof documentAll == 'undefined' && documentAll !== undefined;

module.exports = {
  all: documentAll,
  IS_HTMLDDA: IS_HTMLDDA
};


/***/ }),

/***/ 61333:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(21899);
var isObject = __webpack_require__(10941);

var document = global.document;
// typeof document.createElement is 'object' in old IE
var EXISTS = isObject(document) && isObject(document.createElement);

module.exports = function (it) {
  return EXISTS ? document.createElement(it) : {};
};


/***/ }),

/***/ 66796:
/***/ ((module) => {

var $TypeError = TypeError;
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF; // 2 ** 53 - 1 == 9007199254740991

module.exports = function (it) {
  if (it > MAX_SAFE_INTEGER) throw $TypeError('Maximum allowed index exceeded');
  return it;
};


/***/ }),

/***/ 63281:
/***/ ((module) => {

// iterable DOM collections
// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
module.exports = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};


/***/ }),

/***/ 2861:
/***/ ((module) => {

module.exports = typeof navigator != 'undefined' && String(navigator.userAgent) || '';


/***/ }),

/***/ 53385:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(21899);
var userAgent = __webpack_require__(2861);

var process = global.process;
var Deno = global.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
  // but their correct versions are not interesting for us
  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}

// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
// so check `userAgent` even if `.v8` exists, but 0
if (!version && userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = +match[1];
  }
}

module.exports = version;


/***/ }),

/***/ 35703:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var path = __webpack_require__(54058);

module.exports = function (CONSTRUCTOR) {
  return path[CONSTRUCTOR + 'Prototype'];
};


/***/ }),

/***/ 56759:
/***/ ((module) => {

// IE8- don't enum bug keys
module.exports = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];


/***/ }),

/***/ 76887:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var global = __webpack_require__(21899);
var apply = __webpack_require__(79730);
var uncurryThis = __webpack_require__(97484);
var isCallable = __webpack_require__(57475);
var getOwnPropertyDescriptor = (__webpack_require__(49677).f);
var isForced = __webpack_require__(37252);
var path = __webpack_require__(54058);
var bind = __webpack_require__(86843);
var createNonEnumerableProperty = __webpack_require__(32029);
var hasOwn = __webpack_require__(90953);

var wrapConstructor = function (NativeConstructor) {
  var Wrapper = function (a, b, c) {
    if (this instanceof Wrapper) {
      switch (arguments.length) {
        case 0: return new NativeConstructor();
        case 1: return new NativeConstructor(a);
        case 2: return new NativeConstructor(a, b);
      } return new NativeConstructor(a, b, c);
    } return apply(NativeConstructor, this, arguments);
  };
  Wrapper.prototype = NativeConstructor.prototype;
  return Wrapper;
};

/*
  options.target         - name of the target object
  options.global         - target is the global object
  options.stat           - export as static methods of target
  options.proto          - export as prototype methods of target
  options.real           - real prototype method for the `pure` version
  options.forced         - export even if the native feature is available
  options.bind           - bind methods to the target, required for the `pure` version
  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
  options.sham           - add a flag to not completely full polyfills
  options.enumerable     - export as enumerable property
  options.dontCallGetSet - prevent calling a getter on target
  options.name           - the .name of the function if it does not match the key
*/
module.exports = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var PROTO = options.proto;

  var nativeSource = GLOBAL ? global : STATIC ? global[TARGET] : (global[TARGET] || {}).prototype;

  var target = GLOBAL ? path : path[TARGET] || createNonEnumerableProperty(path, TARGET, {})[TARGET];
  var targetPrototype = target.prototype;

  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

  for (key in source) {
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contains in native
    USE_NATIVE = !FORCED && nativeSource && hasOwn(nativeSource, key);

    targetProperty = target[key];

    if (USE_NATIVE) if (options.dontCallGetSet) {
      descriptor = getOwnPropertyDescriptor(nativeSource, key);
      nativeProperty = descriptor && descriptor.value;
    } else nativeProperty = nativeSource[key];

    // export native or implementation
    sourceProperty = (USE_NATIVE && nativeProperty) ? nativeProperty : source[key];

    if (USE_NATIVE && typeof targetProperty == typeof sourceProperty) continue;

    // bind methods to global for calling from export context
    if (options.bind && USE_NATIVE) resultProperty = bind(sourceProperty, global);
    // wrap global constructors for prevent changes in this version
    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty);
    // make static versions for prototype methods
    else if (PROTO && isCallable(sourceProperty)) resultProperty = uncurryThis(sourceProperty);
    // default case
    else resultProperty = sourceProperty;

    // add a flag to not completely full polyfills
    if (options.sham || (sourceProperty && sourceProperty.sham) || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty(resultProperty, 'sham', true);
    }

    createNonEnumerableProperty(target, key, resultProperty);

    if (PROTO) {
      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
      if (!hasOwn(path, VIRTUAL_PROTOTYPE)) {
        createNonEnumerableProperty(path, VIRTUAL_PROTOTYPE, {});
      }
      // export virtual prototype methods
      createNonEnumerableProperty(path[VIRTUAL_PROTOTYPE], key, sourceProperty);
      // export real prototype methods
      if (options.real && targetPrototype && (FORCED || !targetPrototype[key])) {
        createNonEnumerableProperty(targetPrototype, key, sourceProperty);
      }
    }
  }
};


/***/ }),

/***/ 95981:
/***/ ((module) => {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};


/***/ }),

/***/ 79730:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var NATIVE_BIND = __webpack_require__(18285);

var FunctionPrototype = Function.prototype;
var apply = FunctionPrototype.apply;
var call = FunctionPrototype.call;

// eslint-disable-next-line es/no-reflect -- safe
module.exports = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND ? call.bind(apply) : function () {
  return call.apply(apply, arguments);
});


/***/ }),

/***/ 86843:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(97484);
var aCallable = __webpack_require__(24883);
var NATIVE_BIND = __webpack_require__(18285);

var bind = uncurryThis(uncurryThis.bind);

// optional / simple context binding
module.exports = function (fn, that) {
  aCallable(fn);
  return that === undefined ? fn : NATIVE_BIND ? bind(fn, that) : function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ 18285:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(95981);

module.exports = !fails(function () {
  // eslint-disable-next-line es/no-function-prototype-bind -- safe
  var test = (function () { /* empty */ }).bind();
  // eslint-disable-next-line no-prototype-builtins -- safe
  return typeof test != 'function' || test.hasOwnProperty('prototype');
});


/***/ }),

/***/ 78834:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var NATIVE_BIND = __webpack_require__(18285);

var call = Function.prototype.call;

module.exports = NATIVE_BIND ? call.bind(call) : function () {
  return call.apply(call, arguments);
};


/***/ }),

/***/ 79417:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(55746);
var hasOwn = __webpack_require__(90953);

var FunctionPrototype = Function.prototype;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getDescriptor = DESCRIPTORS && Object.getOwnPropertyDescriptor;

var EXISTS = hasOwn(FunctionPrototype, 'name');
// additional protection from minified / mangled / dropped function names
var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS || (DESCRIPTORS && getDescriptor(FunctionPrototype, 'name').configurable));

module.exports = {
  EXISTS: EXISTS,
  PROPER: PROPER,
  CONFIGURABLE: CONFIGURABLE
};


/***/ }),

/***/ 45526:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);
var aCallable = __webpack_require__(24883);

module.exports = function (object, key, method) {
  try {
    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
    return uncurryThis(aCallable(Object.getOwnPropertyDescriptor(object, key)[method]));
  } catch (error) { /* empty */ }
};


/***/ }),

/***/ 97484:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classofRaw = __webpack_require__(82532);
var uncurryThis = __webpack_require__(95329);

module.exports = function (fn) {
  // Nashorn bug:
  //   https://github.com/zloirock/core-js/issues/1128
  //   https://github.com/zloirock/core-js/issues/1130
  if (classofRaw(fn) === 'Function') return uncurryThis(fn);
};


/***/ }),

/***/ 95329:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var NATIVE_BIND = __webpack_require__(18285);

var FunctionPrototype = Function.prototype;
var call = FunctionPrototype.call;
var uncurryThisWithBind = NATIVE_BIND && FunctionPrototype.bind.bind(call, call);

module.exports = NATIVE_BIND ? uncurryThisWithBind : function (fn) {
  return function () {
    return call.apply(fn, arguments);
  };
};


/***/ }),

/***/ 626:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var path = __webpack_require__(54058);
var global = __webpack_require__(21899);
var isCallable = __webpack_require__(57475);

var aFunction = function (variable) {
  return isCallable(variable) ? variable : undefined;
};

module.exports = function (namespace, method) {
  return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(global[namespace])
    : path[namespace] && path[namespace][method] || global[namespace] && global[namespace][method];
};


/***/ }),

/***/ 33323:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);
var isArray = __webpack_require__(1052);
var isCallable = __webpack_require__(57475);
var classof = __webpack_require__(82532);
var toString = __webpack_require__(85803);

var push = uncurryThis([].push);

module.exports = function (replacer) {
  if (isCallable(replacer)) return replacer;
  if (!isArray(replacer)) return;
  var rawLength = replacer.length;
  var keys = [];
  for (var i = 0; i < rawLength; i++) {
    var element = replacer[i];
    if (typeof element == 'string') push(keys, element);
    else if (typeof element == 'number' || classof(element) == 'Number' || classof(element) == 'String') push(keys, toString(element));
  }
  var keysLength = keys.length;
  var root = true;
  return function (key, value) {
    if (root) {
      root = false;
      return value;
    }
    if (isArray(this)) return value;
    for (var j = 0; j < keysLength; j++) if (keys[j] === key) return value;
  };
};


/***/ }),

/***/ 14229:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var aCallable = __webpack_require__(24883);
var isNullOrUndefined = __webpack_require__(82119);

// `GetMethod` abstract operation
// https://tc39.es/ecma262/#sec-getmethod
module.exports = function (V, P) {
  var func = V[P];
  return isNullOrUndefined(func) ? undefined : aCallable(func);
};


/***/ }),

/***/ 21899:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var check = function (it) {
  return it && it.Math == Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
module.exports =
  // eslint-disable-next-line es/no-global-this -- safe
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  // eslint-disable-next-line no-restricted-globals -- safe
  check(typeof self == 'object' && self) ||
  check(typeof __webpack_require__.g == 'object' && __webpack_require__.g) ||
  // eslint-disable-next-line no-new-func -- fallback
  (function () { return this; })() || Function('return this')();


/***/ }),

/***/ 90953:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);
var toObject = __webpack_require__(89678);

var hasOwnProperty = uncurryThis({}.hasOwnProperty);

// `HasOwnProperty` abstract operation
// https://tc39.es/ecma262/#sec-hasownproperty
// eslint-disable-next-line es/no-object-hasown -- safe
module.exports = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty(toObject(it), key);
};


/***/ }),

/***/ 27748:
/***/ ((module) => {

module.exports = {};


/***/ }),

/***/ 15463:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getBuiltIn = __webpack_require__(626);

module.exports = getBuiltIn('document', 'documentElement');


/***/ }),

/***/ 2840:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(55746);
var fails = __webpack_require__(95981);
var createElement = __webpack_require__(61333);

// Thanks to IE8 for its funny defineProperty
module.exports = !DESCRIPTORS && !fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a != 7;
});


/***/ }),

/***/ 37026:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);
var fails = __webpack_require__(95981);
var classof = __webpack_require__(82532);

var $Object = Object;
var split = uncurryThis(''.split);

// fallback for non-array-like ES3 and non-enumerable old V8 strings
module.exports = fails(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !$Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof(it) == 'String' ? split(it, '') : $Object(it);
} : $Object;


/***/ }),

/***/ 81302:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);
var isCallable = __webpack_require__(57475);
var store = __webpack_require__(63030);

var functionToString = uncurryThis(Function.toString);

// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
if (!isCallable(store.inspectSource)) {
  store.inspectSource = function (it) {
    return functionToString(it);
  };
}

module.exports = store.inspectSource;


/***/ }),

/***/ 45402:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var NATIVE_WEAK_MAP = __webpack_require__(47093);
var global = __webpack_require__(21899);
var isObject = __webpack_require__(10941);
var createNonEnumerableProperty = __webpack_require__(32029);
var hasOwn = __webpack_require__(90953);
var shared = __webpack_require__(63030);
var sharedKey = __webpack_require__(44262);
var hiddenKeys = __webpack_require__(27748);

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError = global.TypeError;
var WeakMap = global.WeakMap;
var set, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject(it) || (state = get(it)).type !== TYPE) {
      throw TypeError('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP || shared.state) {
  var store = shared.state || (shared.state = new WeakMap());
  /* eslint-disable no-self-assign -- prototype methods protection */
  store.get = store.get;
  store.has = store.has;
  store.set = store.set;
  /* eslint-enable no-self-assign -- prototype methods protection */
  set = function (it, metadata) {
    if (store.has(it)) throw TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    store.set(it, metadata);
    return metadata;
  };
  get = function (it) {
    return store.get(it) || {};
  };
  has = function (it) {
    return store.has(it);
  };
} else {
  var STATE = sharedKey('state');
  hiddenKeys[STATE] = true;
  set = function (it, metadata) {
    if (hasOwn(it, STATE)) throw TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return hasOwn(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return hasOwn(it, STATE);
  };
}

module.exports = {
  set: set,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};


/***/ }),

/***/ 1052:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classof = __webpack_require__(82532);

// `IsArray` abstract operation
// https://tc39.es/ecma262/#sec-isarray
// eslint-disable-next-line es/no-array-isarray -- safe
module.exports = Array.isArray || function isArray(argument) {
  return classof(argument) == 'Array';
};


/***/ }),

/***/ 57475:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var $documentAll = __webpack_require__(76616);

var documentAll = $documentAll.all;

// `IsCallable` abstract operation
// https://tc39.es/ecma262/#sec-iscallable
module.exports = $documentAll.IS_HTMLDDA ? function (argument) {
  return typeof argument == 'function' || argument === documentAll;
} : function (argument) {
  return typeof argument == 'function';
};


/***/ }),

/***/ 24284:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);
var fails = __webpack_require__(95981);
var isCallable = __webpack_require__(57475);
var classof = __webpack_require__(9697);
var getBuiltIn = __webpack_require__(626);
var inspectSource = __webpack_require__(81302);

var noop = function () { /* empty */ };
var empty = [];
var construct = getBuiltIn('Reflect', 'construct');
var constructorRegExp = /^\s*(?:class|function)\b/;
var exec = uncurryThis(constructorRegExp.exec);
var INCORRECT_TO_STRING = !constructorRegExp.exec(noop);

var isConstructorModern = function isConstructor(argument) {
  if (!isCallable(argument)) return false;
  try {
    construct(noop, empty, argument);
    return true;
  } catch (error) {
    return false;
  }
};

var isConstructorLegacy = function isConstructor(argument) {
  if (!isCallable(argument)) return false;
  switch (classof(argument)) {
    case 'AsyncFunction':
    case 'GeneratorFunction':
    case 'AsyncGeneratorFunction': return false;
  }
  try {
    // we can't check .prototype since constructors produced by .bind haven't it
    // `Function#toString` throws on some built-it function in some legacy engines
    // (for example, `DOMQuad` and similar in FF41-)
    return INCORRECT_TO_STRING || !!exec(constructorRegExp, inspectSource(argument));
  } catch (error) {
    return true;
  }
};

isConstructorLegacy.sham = true;

// `IsConstructor` abstract operation
// https://tc39.es/ecma262/#sec-isconstructor
module.exports = !construct || fails(function () {
  var called;
  return isConstructorModern(isConstructorModern.call)
    || !isConstructorModern(Object)
    || !isConstructorModern(function () { called = true; })
    || called;
}) ? isConstructorLegacy : isConstructorModern;


/***/ }),

/***/ 37252:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var fails = __webpack_require__(95981);
var isCallable = __webpack_require__(57475);

var replacement = /#|\.prototype\./;

var isForced = function (feature, detection) {
  var value = data[normalize(feature)];
  return value == POLYFILL ? true
    : value == NATIVE ? false
    : isCallable(detection) ? fails(detection)
    : !!detection;
};

var normalize = isForced.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';

module.exports = isForced;


/***/ }),

/***/ 82119:
/***/ ((module) => {

// we can't use just `it == null` since of `document.all` special case
// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
module.exports = function (it) {
  return it === null || it === undefined;
};


/***/ }),

/***/ 10941:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isCallable = __webpack_require__(57475);
var $documentAll = __webpack_require__(76616);

var documentAll = $documentAll.all;

module.exports = $documentAll.IS_HTMLDDA ? function (it) {
  return typeof it == 'object' ? it !== null : isCallable(it) || it === documentAll;
} : function (it) {
  return typeof it == 'object' ? it !== null : isCallable(it);
};


/***/ }),

/***/ 82529:
/***/ ((module) => {

module.exports = true;


/***/ }),

/***/ 56664:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getBuiltIn = __webpack_require__(626);
var isCallable = __webpack_require__(57475);
var isPrototypeOf = __webpack_require__(7046);
var USE_SYMBOL_AS_UID = __webpack_require__(32302);

var $Object = Object;

module.exports = USE_SYMBOL_AS_UID ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn('Symbol');
  return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, $Object(it));
};


/***/ }),

/***/ 53847:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var IteratorPrototype = (__webpack_require__(35143).IteratorPrototype);
var create = __webpack_require__(29290);
var createPropertyDescriptor = __webpack_require__(31887);
var setToStringTag = __webpack_require__(90904);
var Iterators = __webpack_require__(12077);

var returnThis = function () { return this; };

module.exports = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = create(IteratorPrototype, { next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next) });
  setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
  Iterators[TO_STRING_TAG] = returnThis;
  return IteratorConstructor;
};


/***/ }),

/***/ 75105:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(76887);
var call = __webpack_require__(78834);
var IS_PURE = __webpack_require__(82529);
var FunctionName = __webpack_require__(79417);
var isCallable = __webpack_require__(57475);
var createIteratorConstructor = __webpack_require__(53847);
var getPrototypeOf = __webpack_require__(249);
var setPrototypeOf = __webpack_require__(88929);
var setToStringTag = __webpack_require__(90904);
var createNonEnumerableProperty = __webpack_require__(32029);
var defineBuiltIn = __webpack_require__(95929);
var wellKnownSymbol = __webpack_require__(99813);
var Iterators = __webpack_require__(12077);
var IteratorsCore = __webpack_require__(35143);

var PROPER_FUNCTION_NAME = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR = wellKnownSymbol('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () { return this; };

module.exports = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND in IterablePrototype) return IterablePrototype[KIND];
    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    } return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME == 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  // fix native
  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
      if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
        if (setPrototypeOf) {
          setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
        } else if (!isCallable(CurrentIteratorPrototype[ITERATOR])) {
          defineBuiltIn(CurrentIteratorPrototype, ITERATOR, returnThis);
        }
      }
      // Set @@toStringTag to native iterators
      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
      if (IS_PURE) Iterators[TO_STRING_TAG] = returnThis;
    }
  }

  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
  if (PROPER_FUNCTION_NAME && DEFAULT == VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    if (!IS_PURE && CONFIGURABLE_FUNCTION_NAME) {
      createNonEnumerableProperty(IterablePrototype, 'name', VALUES);
    } else {
      INCORRECT_VALUES_NAME = true;
      defaultIterator = function values() { return call(nativeIterator, this); };
    }
  }

  // export additional methods
  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        defineBuiltIn(IterablePrototype, KEY, methods[KEY]);
      }
    } else $({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
  }

  // define iterator
  if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
    defineBuiltIn(IterablePrototype, ITERATOR, defaultIterator, { name: DEFAULT });
  }
  Iterators[NAME] = defaultIterator;

  return methods;
};


/***/ }),

/***/ 35143:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(95981);
var isCallable = __webpack_require__(57475);
var isObject = __webpack_require__(10941);
var create = __webpack_require__(29290);
var getPrototypeOf = __webpack_require__(249);
var defineBuiltIn = __webpack_require__(95929);
var wellKnownSymbol = __webpack_require__(99813);
var IS_PURE = __webpack_require__(82529);

var ITERATOR = wellKnownSymbol('iterator');
var BUGGY_SAFARI_ITERATORS = false;

// `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

/* eslint-disable es/no-array-prototype-keys -- safe */
if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = !isObject(IteratorPrototype) || fails(function () {
  var test = {};
  // FF44- legacy iterators case
  return IteratorPrototype[ITERATOR].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype = {};
else if (IS_PURE) IteratorPrototype = create(IteratorPrototype);

// `%IteratorPrototype%[@@iterator]()` method
// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
if (!isCallable(IteratorPrototype[ITERATOR])) {
  defineBuiltIn(IteratorPrototype, ITERATOR, function () {
    return this;
  });
}

module.exports = {
  IteratorPrototype: IteratorPrototype,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
};


/***/ }),

/***/ 12077:
/***/ ((module) => {

module.exports = {};


/***/ }),

/***/ 10623:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toLength = __webpack_require__(43057);

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
module.exports = function (obj) {
  return toLength(obj.length);
};


/***/ }),

/***/ 35331:
/***/ ((module) => {

var ceil = Math.ceil;
var floor = Math.floor;

// `Math.trunc` method
// https://tc39.es/ecma262/#sec-math.trunc
// eslint-disable-next-line es/no-math-trunc -- safe
module.exports = Math.trunc || function trunc(x) {
  var n = +x;
  return (n > 0 ? floor : ceil)(n);
};


/***/ }),

/***/ 29290:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* global ActiveXObject -- old IE, WSH */
var anObject = __webpack_require__(96059);
var definePropertiesModule = __webpack_require__(59938);
var enumBugKeys = __webpack_require__(56759);
var hiddenKeys = __webpack_require__(27748);
var html = __webpack_require__(15463);
var documentCreateElement = __webpack_require__(61333);
var sharedKey = __webpack_require__(44262);

var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey('IE_PROTO');

var EmptyConstructor = function () { /* empty */ };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; // avoid memory leak
  return temp;
};

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html.appendChild(iframe);
  // https://github.com/zloirock/core-js/issues/475
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

// Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug
var activeXDocument;
var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) { /* ignore */ }
  NullProtoObject = typeof document != 'undefined'
    ? document.domain && activeXDocument
      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
      : NullProtoObjectViaIFrame()
    : NullProtoObjectViaActiveX(activeXDocument); // WSH
  var length = enumBugKeys.length;
  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
  return NullProtoObject();
};

hiddenKeys[IE_PROTO] = true;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
// eslint-disable-next-line es/no-object-create -- safe
module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE] = anObject(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
};


/***/ }),

/***/ 59938:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(55746);
var V8_PROTOTYPE_DEFINE_BUG = __webpack_require__(83937);
var definePropertyModule = __webpack_require__(65988);
var anObject = __webpack_require__(96059);
var toIndexedObject = __webpack_require__(74529);
var objectKeys = __webpack_require__(14771);

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe
exports.f = DESCRIPTORS && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var props = toIndexedObject(Properties);
  var keys = objectKeys(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) definePropertyModule.f(O, key = keys[index++], props[key]);
  return O;
};


/***/ }),

/***/ 65988:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(55746);
var IE8_DOM_DEFINE = __webpack_require__(2840);
var V8_PROTOTYPE_DEFINE_BUG = __webpack_require__(83937);
var anObject = __webpack_require__(96059);
var toPropertyKey = __webpack_require__(83894);

var $TypeError = TypeError;
// eslint-disable-next-line es/no-object-defineproperty -- safe
var $defineProperty = Object.defineProperty;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE = 'configurable';
var WRITABLE = 'writable';

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
exports.f = DESCRIPTORS ? V8_PROTOTYPE_DEFINE_BUG ? function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPropertyKey(P);
  anObject(Attributes);
  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
    var current = $getOwnPropertyDescriptor(O, P);
    if (current && current[WRITABLE]) {
      O[P] = Attributes.value;
      Attributes = {
        configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
        writable: false
      };
    }
  } return $defineProperty(O, P, Attributes);
} : $defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPropertyKey(P);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw $TypeError('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),

/***/ 49677:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(55746);
var call = __webpack_require__(78834);
var propertyIsEnumerableModule = __webpack_require__(36760);
var createPropertyDescriptor = __webpack_require__(31887);
var toIndexedObject = __webpack_require__(74529);
var toPropertyKey = __webpack_require__(83894);
var hasOwn = __webpack_require__(90953);
var IE8_DOM_DEFINE = __webpack_require__(2840);

// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject(O);
  P = toPropertyKey(P);
  if (IE8_DOM_DEFINE) try {
    return $getOwnPropertyDescriptor(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn(O, P)) return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
};


/***/ }),

/***/ 684:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-disable es/no-object-getownpropertynames -- safe */
var classof = __webpack_require__(82532);
var toIndexedObject = __webpack_require__(74529);
var $getOwnPropertyNames = (__webpack_require__(10946).f);
var arraySlice = __webpack_require__(15790);

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return $getOwnPropertyNames(it);
  } catch (error) {
    return arraySlice(windowNames);
  }
};

// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
module.exports.f = function getOwnPropertyNames(it) {
  return windowNames && classof(it) == 'Window'
    ? getWindowNames(it)
    : $getOwnPropertyNames(toIndexedObject(it));
};


/***/ }),

/***/ 10946:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var internalObjectKeys = __webpack_require__(55629);
var enumBugKeys = __webpack_require__(56759);

var hiddenKeys = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys);
};


/***/ }),

/***/ 87857:
/***/ ((__unused_webpack_module, exports) => {

// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
exports.f = Object.getOwnPropertySymbols;


/***/ }),

/***/ 249:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var hasOwn = __webpack_require__(90953);
var isCallable = __webpack_require__(57475);
var toObject = __webpack_require__(89678);
var sharedKey = __webpack_require__(44262);
var CORRECT_PROTOTYPE_GETTER = __webpack_require__(64160);

var IE_PROTO = sharedKey('IE_PROTO');
var $Object = Object;
var ObjectPrototype = $Object.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es/no-object-getprototypeof -- safe
module.exports = CORRECT_PROTOTYPE_GETTER ? $Object.getPrototypeOf : function (O) {
  var object = toObject(O);
  if (hasOwn(object, IE_PROTO)) return object[IE_PROTO];
  var constructor = object.constructor;
  if (isCallable(constructor) && object instanceof constructor) {
    return constructor.prototype;
  } return object instanceof $Object ? ObjectPrototype : null;
};


/***/ }),

/***/ 7046:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);

module.exports = uncurryThis({}.isPrototypeOf);


/***/ }),

/***/ 55629:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);
var hasOwn = __webpack_require__(90953);
var toIndexedObject = __webpack_require__(74529);
var indexOf = (__webpack_require__(31692).indexOf);
var hiddenKeys = __webpack_require__(27748);

var push = uncurryThis([].push);

module.exports = function (object, names) {
  var O = toIndexedObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !hasOwn(hiddenKeys, key) && hasOwn(O, key) && push(result, key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (hasOwn(O, key = names[i++])) {
    ~indexOf(result, key) || push(result, key);
  }
  return result;
};


/***/ }),

/***/ 14771:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var internalObjectKeys = __webpack_require__(55629);
var enumBugKeys = __webpack_require__(56759);

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es/no-object-keys -- safe
module.exports = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys);
};


/***/ }),

/***/ 36760:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

var $propertyIsEnumerable = {}.propertyIsEnumerable;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;


/***/ }),

/***/ 88929:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-disable no-proto -- safe */
var uncurryThisAccessor = __webpack_require__(45526);
var anObject = __webpack_require__(96059);
var aPossiblePrototype = __webpack_require__(11851);

// `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es/no-object-setprototypeof -- safe
module.exports = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;
  try {
    setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
    setter(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) { /* empty */ }
  return function setPrototypeOf(O, proto) {
    anObject(O);
    aPossiblePrototype(proto);
    if (CORRECT_SETTER) setter(O, proto);
    else O.__proto__ = proto;
    return O;
  };
}() : undefined);


/***/ }),

/***/ 95623:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var TO_STRING_TAG_SUPPORT = __webpack_require__(22885);
var classof = __webpack_require__(9697);

// `Object.prototype.toString` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.tostring
module.exports = TO_STRING_TAG_SUPPORT ? {}.toString : function toString() {
  return '[object ' + classof(this) + ']';
};


/***/ }),

/***/ 39811:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var call = __webpack_require__(78834);
var isCallable = __webpack_require__(57475);
var isObject = __webpack_require__(10941);

var $TypeError = TypeError;

// `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive
module.exports = function (input, pref) {
  var fn, val;
  if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
  if (isCallable(fn = input.valueOf) && !isObject(val = call(fn, input))) return val;
  if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
  throw $TypeError("Can't convert object to primitive value");
};


/***/ }),

/***/ 31136:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getBuiltIn = __webpack_require__(626);
var uncurryThis = __webpack_require__(95329);
var getOwnPropertyNamesModule = __webpack_require__(10946);
var getOwnPropertySymbolsModule = __webpack_require__(87857);
var anObject = __webpack_require__(96059);

var concat = uncurryThis([].concat);

// all object keys, includes non-enumerable and symbols
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
};


/***/ }),

/***/ 54058:
/***/ ((module) => {

module.exports = {};


/***/ }),

/***/ 48219:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isNullOrUndefined = __webpack_require__(82119);

var $TypeError = TypeError;

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
module.exports = function (it) {
  if (isNullOrUndefined(it)) throw $TypeError("Can't call method on " + it);
  return it;
};


/***/ }),

/***/ 90904:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var TO_STRING_TAG_SUPPORT = __webpack_require__(22885);
var defineProperty = (__webpack_require__(65988).f);
var createNonEnumerableProperty = __webpack_require__(32029);
var hasOwn = __webpack_require__(90953);
var toString = __webpack_require__(95623);
var wellKnownSymbol = __webpack_require__(99813);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');

module.exports = function (it, TAG, STATIC, SET_METHOD) {
  if (it) {
    var target = STATIC ? it : it.prototype;
    if (!hasOwn(target, TO_STRING_TAG)) {
      defineProperty(target, TO_STRING_TAG, { configurable: true, value: TAG });
    }
    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
      createNonEnumerableProperty(target, 'toString', toString);
    }
  }
};


/***/ }),

/***/ 44262:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var shared = __webpack_require__(68726);
var uid = __webpack_require__(99418);

var keys = shared('keys');

module.exports = function (key) {
  return keys[key] || (keys[key] = uid(key));
};


/***/ }),

/***/ 63030:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(21899);
var defineGlobalProperty = __webpack_require__(75609);

var SHARED = '__core-js_shared__';
var store = global[SHARED] || defineGlobalProperty(SHARED, {});

module.exports = store;


/***/ }),

/***/ 68726:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var IS_PURE = __webpack_require__(82529);
var store = __webpack_require__(63030);

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.29.0',
  mode: IS_PURE ? 'pure' : 'global',
  copyright: '© 2014-2023 Denis Pushkarev (zloirock.ru)',
  license: 'https://github.com/zloirock/core-js/blob/v3.29.0/LICENSE',
  source: 'https://github.com/zloirock/core-js'
});


/***/ }),

/***/ 64620:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);
var toIntegerOrInfinity = __webpack_require__(62435);
var toString = __webpack_require__(85803);
var requireObjectCoercible = __webpack_require__(48219);

var charAt = uncurryThis(''.charAt);
var charCodeAt = uncurryThis(''.charCodeAt);
var stringSlice = uncurryThis(''.slice);

var createMethod = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = toString(requireObjectCoercible($this));
    var position = toIntegerOrInfinity(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = charCodeAt(S, position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING
          ? charAt(S, position)
          : first
        : CONVERT_TO_STRING
          ? stringSlice(S, position, position + 2)
          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

module.exports = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod(true)
};


/***/ }),

/***/ 63405:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-disable es/no-symbol -- required for testing */
var V8_VERSION = __webpack_require__(53385);
var fails = __webpack_require__(95981);

// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
  var symbol = Symbol();
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  return !String(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});


/***/ }),

/***/ 29630:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var call = __webpack_require__(78834);
var getBuiltIn = __webpack_require__(626);
var wellKnownSymbol = __webpack_require__(99813);
var defineBuiltIn = __webpack_require__(95929);

module.exports = function () {
  var Symbol = getBuiltIn('Symbol');
  var SymbolPrototype = Symbol && Symbol.prototype;
  var valueOf = SymbolPrototype && SymbolPrototype.valueOf;
  var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');

  if (SymbolPrototype && !SymbolPrototype[TO_PRIMITIVE]) {
    // `Symbol.prototype[@@toPrimitive]` method
    // https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
    // eslint-disable-next-line no-unused-vars -- required for .length
    defineBuiltIn(SymbolPrototype, TO_PRIMITIVE, function (hint) {
      return call(valueOf, this);
    }, { arity: 1 });
  }
};


/***/ }),

/***/ 34680:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var NATIVE_SYMBOL = __webpack_require__(63405);

/* eslint-disable es/no-symbol -- safe */
module.exports = NATIVE_SYMBOL && !!Symbol['for'] && !!Symbol.keyFor;


/***/ }),

/***/ 59413:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toIntegerOrInfinity = __webpack_require__(62435);

var max = Math.max;
var min = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
module.exports = function (index, length) {
  var integer = toIntegerOrInfinity(index);
  return integer < 0 ? max(integer + length, 0) : min(integer, length);
};


/***/ }),

/***/ 74529:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// toObject with fallback for non-array-like ES3 strings
var IndexedObject = __webpack_require__(37026);
var requireObjectCoercible = __webpack_require__(48219);

module.exports = function (it) {
  return IndexedObject(requireObjectCoercible(it));
};


/***/ }),

/***/ 62435:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var trunc = __webpack_require__(35331);

// `ToIntegerOrInfinity` abstract operation
// https://tc39.es/ecma262/#sec-tointegerorinfinity
module.exports = function (argument) {
  var number = +argument;
  // eslint-disable-next-line no-self-compare -- NaN check
  return number !== number || number === 0 ? 0 : trunc(number);
};


/***/ }),

/***/ 43057:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toIntegerOrInfinity = __webpack_require__(62435);

var min = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
module.exports = function (argument) {
  return argument > 0 ? min(toIntegerOrInfinity(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};


/***/ }),

/***/ 89678:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var requireObjectCoercible = __webpack_require__(48219);

var $Object = Object;

// `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject
module.exports = function (argument) {
  return $Object(requireObjectCoercible(argument));
};


/***/ }),

/***/ 46935:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var call = __webpack_require__(78834);
var isObject = __webpack_require__(10941);
var isSymbol = __webpack_require__(56664);
var getMethod = __webpack_require__(14229);
var ordinaryToPrimitive = __webpack_require__(39811);
var wellKnownSymbol = __webpack_require__(99813);

var $TypeError = TypeError;
var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');

// `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
module.exports = function (input, pref) {
  if (!isObject(input) || isSymbol(input)) return input;
  var exoticToPrim = getMethod(input, TO_PRIMITIVE);
  var result;
  if (exoticToPrim) {
    if (pref === undefined) pref = 'default';
    result = call(exoticToPrim, input, pref);
    if (!isObject(result) || isSymbol(result)) return result;
    throw $TypeError("Can't convert object to primitive value");
  }
  if (pref === undefined) pref = 'number';
  return ordinaryToPrimitive(input, pref);
};


/***/ }),

/***/ 83894:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toPrimitive = __webpack_require__(46935);
var isSymbol = __webpack_require__(56664);

// `ToPropertyKey` abstract operation
// https://tc39.es/ecma262/#sec-topropertykey
module.exports = function (argument) {
  var key = toPrimitive(argument, 'string');
  return isSymbol(key) ? key : key + '';
};


/***/ }),

/***/ 22885:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var wellKnownSymbol = __webpack_require__(99813);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var test = {};

test[TO_STRING_TAG] = 'z';

module.exports = String(test) === '[object z]';


/***/ }),

/***/ 85803:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classof = __webpack_require__(9697);

var $String = String;

module.exports = function (argument) {
  if (classof(argument) === 'Symbol') throw TypeError('Cannot convert a Symbol value to a string');
  return $String(argument);
};


/***/ }),

/***/ 69826:
/***/ ((module) => {

var $String = String;

module.exports = function (argument) {
  try {
    return $String(argument);
  } catch (error) {
    return 'Object';
  }
};


/***/ }),

/***/ 99418:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var uncurryThis = __webpack_require__(95329);

var id = 0;
var postfix = Math.random();
var toString = uncurryThis(1.0.toString);

module.exports = function (key) {
  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
};


/***/ }),

/***/ 32302:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* eslint-disable es/no-symbol -- required for testing */
var NATIVE_SYMBOL = __webpack_require__(63405);

module.exports = NATIVE_SYMBOL
  && !Symbol.sham
  && typeof Symbol.iterator == 'symbol';


/***/ }),

/***/ 83937:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DESCRIPTORS = __webpack_require__(55746);
var fails = __webpack_require__(95981);

// V8 ~ Chrome 36-
// https://bugs.chromium.org/p/v8/issues/detail?id=3334
module.exports = DESCRIPTORS && fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
    value: 42,
    writable: false
  }).prototype != 42;
});


/***/ }),

/***/ 47093:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(21899);
var isCallable = __webpack_require__(57475);

var WeakMap = global.WeakMap;

module.exports = isCallable(WeakMap) && /native code/.test(String(WeakMap));


/***/ }),

/***/ 73464:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var path = __webpack_require__(54058);
var hasOwn = __webpack_require__(90953);
var wrappedWellKnownSymbolModule = __webpack_require__(11477);
var defineProperty = (__webpack_require__(65988).f);

module.exports = function (NAME) {
  var Symbol = path.Symbol || (path.Symbol = {});
  if (!hasOwn(Symbol, NAME)) defineProperty(Symbol, NAME, {
    value: wrappedWellKnownSymbolModule.f(NAME)
  });
};


/***/ }),

/***/ 11477:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var wellKnownSymbol = __webpack_require__(99813);

exports.f = wellKnownSymbol;


/***/ }),

/***/ 99813:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(21899);
var shared = __webpack_require__(68726);
var hasOwn = __webpack_require__(90953);
var uid = __webpack_require__(99418);
var NATIVE_SYMBOL = __webpack_require__(63405);
var USE_SYMBOL_AS_UID = __webpack_require__(32302);

var Symbol = global.Symbol;
var WellKnownSymbolsStore = shared('wks');
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol['for'] || Symbol : Symbol && Symbol.withoutSetter || uid;

module.exports = function (name) {
  if (!hasOwn(WellKnownSymbolsStore, name)) {
    WellKnownSymbolsStore[name] = NATIVE_SYMBOL && hasOwn(Symbol, name)
      ? Symbol[name]
      : createWellKnownSymbol('Symbol.' + name);
  } return WellKnownSymbolsStore[name];
};


/***/ }),

/***/ 85906:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(76887);
var fails = __webpack_require__(95981);
var isArray = __webpack_require__(1052);
var isObject = __webpack_require__(10941);
var toObject = __webpack_require__(89678);
var lengthOfArrayLike = __webpack_require__(10623);
var doesNotExceedSafeInteger = __webpack_require__(66796);
var createProperty = __webpack_require__(55449);
var arraySpeciesCreate = __webpack_require__(64692);
var arrayMethodHasSpeciesSupport = __webpack_require__(50568);
var wellKnownSymbol = __webpack_require__(99813);
var V8_VERSION = __webpack_require__(53385);

var IS_CONCAT_SPREADABLE = wellKnownSymbol('isConcatSpreadable');

// We can't use this feature detection in V8 since it causes
// deoptimization and serious performance degradation
// https://github.com/zloirock/core-js/issues/679
var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails(function () {
  var array = [];
  array[IS_CONCAT_SPREADABLE] = false;
  return array.concat()[0] !== array;
});

var isConcatSpreadable = function (O) {
  if (!isObject(O)) return false;
  var spreadable = O[IS_CONCAT_SPREADABLE];
  return spreadable !== undefined ? !!spreadable : isArray(O);
};

var FORCED = !IS_CONCAT_SPREADABLE_SUPPORT || !arrayMethodHasSpeciesSupport('concat');

// `Array.prototype.concat` method
// https://tc39.es/ecma262/#sec-array.prototype.concat
// with adding support of @@isConcatSpreadable and @@species
$({ target: 'Array', proto: true, arity: 1, forced: FORCED }, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  concat: function concat(arg) {
    var O = toObject(this);
    var A = arraySpeciesCreate(O, 0);
    var n = 0;
    var i, k, length, len, E;
    for (i = -1, length = arguments.length; i < length; i++) {
      E = i === -1 ? O : arguments[i];
      if (isConcatSpreadable(E)) {
        len = lengthOfArrayLike(E);
        doesNotExceedSafeInteger(n + len);
        for (k = 0; k < len; k++, n++) if (k in E) createProperty(A, n, E[k]);
      } else {
        doesNotExceedSafeInteger(n + 1);
        createProperty(A, n++, E);
      }
    }
    A.length = n;
    return A;
  }
});


/***/ }),

/***/ 21501:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(76887);
var $filter = (__webpack_require__(3610).filter);
var arrayMethodHasSpeciesSupport = __webpack_require__(50568);

var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter');

// `Array.prototype.filter` method
// https://tc39.es/ecma262/#sec-array.prototype.filter
// with adding support of @@species
$({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
  filter: function filter(callbackfn /* , thisArg */) {
    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});


/***/ }),

/***/ 2437:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(76887);
var forEach = __webpack_require__(56837);

// `Array.prototype.forEach` method
// https://tc39.es/ecma262/#sec-array.prototype.foreach
// eslint-disable-next-line es/no-array-prototype-foreach -- safe
$({ target: 'Array', proto: true, forced: [].forEach != forEach }, {
  forEach: forEach
});


/***/ }),

/***/ 99076:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable es/no-array-prototype-indexof -- required for testing */
var $ = __webpack_require__(76887);
var uncurryThis = __webpack_require__(97484);
var $indexOf = (__webpack_require__(31692).indexOf);
var arrayMethodIsStrict = __webpack_require__(34194);

var nativeIndexOf = uncurryThis([].indexOf);

var NEGATIVE_ZERO = !!nativeIndexOf && 1 / nativeIndexOf([1], 1, -0) < 0;
var FORCED = NEGATIVE_ZERO || !arrayMethodIsStrict('indexOf');

// `Array.prototype.indexOf` method
// https://tc39.es/ecma262/#sec-array.prototype.indexof
$({ target: 'Array', proto: true, forced: FORCED }, {
  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
    var fromIndex = arguments.length > 1 ? arguments[1] : undefined;
    return NEGATIVE_ZERO
      // convert -0 to +0
      ? nativeIndexOf(this, searchElement, fromIndex) || 0
      : $indexOf(this, searchElement, fromIndex);
  }
});


/***/ }),

/***/ 66274:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toIndexedObject = __webpack_require__(74529);
var addToUnscopables = __webpack_require__(18479);
var Iterators = __webpack_require__(12077);
var InternalStateModule = __webpack_require__(45402);
var defineProperty = (__webpack_require__(65988).f);
var defineIterator = __webpack_require__(75105);
var createIterResultObject = __webpack_require__(23538);
var IS_PURE = __webpack_require__(82529);
var DESCRIPTORS = __webpack_require__(55746);

var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);

// `Array.prototype.entries` method
// https://tc39.es/ecma262/#sec-array.prototype.entries
// `Array.prototype.keys` method
// https://tc39.es/ecma262/#sec-array.prototype.keys
// `Array.prototype.values` method
// https://tc39.es/ecma262/#sec-array.prototype.values
// `Array.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
// `CreateArrayIterator` internal method
// https://tc39.es/ecma262/#sec-createarrayiterator
module.exports = defineIterator(Array, 'Array', function (iterated, kind) {
  setInternalState(this, {
    type: ARRAY_ITERATOR,
    target: toIndexedObject(iterated), // target
    index: 0,                          // next index
    kind: kind                         // kind
  });
// `%ArrayIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
}, function () {
  var state = getInternalState(this);
  var target = state.target;
  var kind = state.kind;
  var index = state.index++;
  if (!target || index >= target.length) {
    state.target = undefined;
    return createIterResultObject(undefined, true);
  }
  if (kind == 'keys') return createIterResultObject(index, false);
  if (kind == 'values') return createIterResultObject(target[index], false);
  return createIterResultObject([index, target[index]], false);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values%
// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
// https://tc39.es/ecma262/#sec-createmappedargumentsobject
var values = Iterators.Arguments = Iterators.Array;

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');

// V8 ~ Chrome 45- bug
if (!IS_PURE && DESCRIPTORS && values.name !== 'values') try {
  defineProperty(values, 'name', { value: 'values' });
} catch (error) { /* empty */ }


/***/ }),

/***/ 18084:
/***/ (() => {

// empty


/***/ }),

/***/ 32619:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var getBuiltIn = __webpack_require__(626);
var apply = __webpack_require__(79730);
var call = __webpack_require__(78834);
var uncurryThis = __webpack_require__(95329);
var fails = __webpack_require__(95981);
var isCallable = __webpack_require__(57475);
var isSymbol = __webpack_require__(56664);
var arraySlice = __webpack_require__(93765);
var getReplacerFunction = __webpack_require__(33323);
var NATIVE_SYMBOL = __webpack_require__(63405);

var $String = String;
var $stringify = getBuiltIn('JSON', 'stringify');
var exec = uncurryThis(/./.exec);
var charAt = uncurryThis(''.charAt);
var charCodeAt = uncurryThis(''.charCodeAt);
var replace = uncurryThis(''.replace);
var numberToString = uncurryThis(1.0.toString);

var tester = /[\uD800-\uDFFF]/g;
var low = /^[\uD800-\uDBFF]$/;
var hi = /^[\uDC00-\uDFFF]$/;

var WRONG_SYMBOLS_CONVERSION = !NATIVE_SYMBOL || fails(function () {
  var symbol = getBuiltIn('Symbol')();
  // MS Edge converts symbol values to JSON as {}
  return $stringify([symbol]) != '[null]'
    // WebKit converts symbol values to JSON as null
    || $stringify({ a: symbol }) != '{}'
    // V8 throws on boxed symbols
    || $stringify(Object(symbol)) != '{}';
});

// https://github.com/tc39/proposal-well-formed-stringify
var ILL_FORMED_UNICODE = fails(function () {
  return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"'
    || $stringify('\uDEAD') !== '"\\udead"';
});

var stringifyWithSymbolsFix = function (it, replacer) {
  var args = arraySlice(arguments);
  var $replacer = getReplacerFunction(replacer);
  if (!isCallable($replacer) && (it === undefined || isSymbol(it))) return; // IE8 returns string on undefined
  args[1] = function (key, value) {
    // some old implementations (like WebKit) could pass numbers as keys
    if (isCallable($replacer)) value = call($replacer, this, $String(key), value);
    if (!isSymbol(value)) return value;
  };
  return apply($stringify, null, args);
};

var fixIllFormed = function (match, offset, string) {
  var prev = charAt(string, offset - 1);
  var next = charAt(string, offset + 1);
  if ((exec(low, match) && !exec(hi, next)) || (exec(hi, match) && !exec(low, prev))) {
    return '\\u' + numberToString(charCodeAt(match, 0), 16);
  } return match;
};

if ($stringify) {
  // `JSON.stringify` method
  // https://tc39.es/ecma262/#sec-json.stringify
  $({ target: 'JSON', stat: true, arity: 3, forced: WRONG_SYMBOLS_CONVERSION || ILL_FORMED_UNICODE }, {
    // eslint-disable-next-line no-unused-vars -- required for `.length`
    stringify: function stringify(it, replacer, space) {
      var args = arraySlice(arguments);
      var result = apply(WRONG_SYMBOLS_CONVERSION ? stringifyWithSymbolsFix : $stringify, null, args);
      return ILL_FORMED_UNICODE && typeof result == 'string' ? replace(result, tester, fixIllFormed) : result;
    }
  });
}


/***/ }),

/***/ 69120:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(21899);
var setToStringTag = __webpack_require__(90904);

// JSON[@@toStringTag] property
// https://tc39.es/ecma262/#sec-json-@@tostringtag
setToStringTag(global.JSON, 'JSON', true);


/***/ }),

/***/ 79413:
/***/ (() => {

// empty


/***/ }),

/***/ 74979:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var DESCRIPTORS = __webpack_require__(55746);
var defineProperties = (__webpack_require__(59938).f);

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe
$({ target: 'Object', stat: true, forced: Object.defineProperties !== defineProperties, sham: !DESCRIPTORS }, {
  defineProperties: defineProperties
});


/***/ }),

/***/ 86450:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var DESCRIPTORS = __webpack_require__(55746);
var defineProperty = (__webpack_require__(65988).f);

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
// eslint-disable-next-line es/no-object-defineproperty -- safe
$({ target: 'Object', stat: true, forced: Object.defineProperty !== defineProperty, sham: !DESCRIPTORS }, {
  defineProperty: defineProperty
});


/***/ }),

/***/ 46924:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var fails = __webpack_require__(95981);
var toIndexedObject = __webpack_require__(74529);
var nativeGetOwnPropertyDescriptor = (__webpack_require__(49677).f);
var DESCRIPTORS = __webpack_require__(55746);

var FORCED = !DESCRIPTORS || fails(function () { nativeGetOwnPropertyDescriptor(1); });

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
$({ target: 'Object', stat: true, forced: FORCED, sham: !DESCRIPTORS }, {
  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
    return nativeGetOwnPropertyDescriptor(toIndexedObject(it), key);
  }
});


/***/ }),

/***/ 88482:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var DESCRIPTORS = __webpack_require__(55746);
var ownKeys = __webpack_require__(31136);
var toIndexedObject = __webpack_require__(74529);
var getOwnPropertyDescriptorModule = __webpack_require__(49677);
var createProperty = __webpack_require__(55449);

// `Object.getOwnPropertyDescriptors` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
$({ target: 'Object', stat: true, sham: !DESCRIPTORS }, {
  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
    var O = toIndexedObject(object);
    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
    var keys = ownKeys(O);
    var result = {};
    var index = 0;
    var key, descriptor;
    while (keys.length > index) {
      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
      if (descriptor !== undefined) createProperty(result, key, descriptor);
    }
    return result;
  }
});


/***/ }),

/***/ 37144:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var NATIVE_SYMBOL = __webpack_require__(63405);
var fails = __webpack_require__(95981);
var getOwnPropertySymbolsModule = __webpack_require__(87857);
var toObject = __webpack_require__(89678);

// V8 ~ Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
// https://bugs.chromium.org/p/v8/issues/detail?id=3443
var FORCED = !NATIVE_SYMBOL || fails(function () { getOwnPropertySymbolsModule.f(1); });

// `Object.getOwnPropertySymbols` method
// https://tc39.es/ecma262/#sec-object.getownpropertysymbols
$({ target: 'Object', stat: true, forced: FORCED }, {
  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
    var $getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
    return $getOwnPropertySymbols ? $getOwnPropertySymbols(toObject(it)) : [];
  }
});


/***/ }),

/***/ 21724:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var toObject = __webpack_require__(89678);
var nativeKeys = __webpack_require__(14771);
var fails = __webpack_require__(95981);

var FAILS_ON_PRIMITIVES = fails(function () { nativeKeys(1); });

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
$({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
  keys: function keys(it) {
    return nativeKeys(toObject(it));
  }
});


/***/ }),

/***/ 55967:
/***/ (() => {

// empty


/***/ }),

/***/ 1502:
/***/ (() => {

// empty


/***/ }),

/***/ 77971:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var charAt = (__webpack_require__(64620).charAt);
var toString = __webpack_require__(85803);
var InternalStateModule = __webpack_require__(45402);
var defineIterator = __webpack_require__(75105);
var createIterResultObject = __webpack_require__(23538);

var STRING_ITERATOR = 'String Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);

// `String.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
defineIterator(String, 'String', function (iterated) {
  setInternalState(this, {
    type: STRING_ITERATOR,
    string: toString(iterated),
    index: 0
  });
// `%StringIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
}, function next() {
  var state = getInternalState(this);
  var string = state.string;
  var index = state.index;
  var point;
  if (index >= string.length) return createIterResultObject(undefined, true);
  point = charAt(string, index);
  state.index += point.length;
  return createIterResultObject(point, false);
});


/***/ }),

/***/ 8555:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.asyncIterator` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.asynciterator
defineWellKnownSymbol('asyncIterator');


/***/ }),

/***/ 48616:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(76887);
var global = __webpack_require__(21899);
var call = __webpack_require__(78834);
var uncurryThis = __webpack_require__(95329);
var IS_PURE = __webpack_require__(82529);
var DESCRIPTORS = __webpack_require__(55746);
var NATIVE_SYMBOL = __webpack_require__(63405);
var fails = __webpack_require__(95981);
var hasOwn = __webpack_require__(90953);
var isPrototypeOf = __webpack_require__(7046);
var anObject = __webpack_require__(96059);
var toIndexedObject = __webpack_require__(74529);
var toPropertyKey = __webpack_require__(83894);
var $toString = __webpack_require__(85803);
var createPropertyDescriptor = __webpack_require__(31887);
var nativeObjectCreate = __webpack_require__(29290);
var objectKeys = __webpack_require__(14771);
var getOwnPropertyNamesModule = __webpack_require__(10946);
var getOwnPropertyNamesExternal = __webpack_require__(684);
var getOwnPropertySymbolsModule = __webpack_require__(87857);
var getOwnPropertyDescriptorModule = __webpack_require__(49677);
var definePropertyModule = __webpack_require__(65988);
var definePropertiesModule = __webpack_require__(59938);
var propertyIsEnumerableModule = __webpack_require__(36760);
var defineBuiltIn = __webpack_require__(95929);
var defineBuiltInAccessor = __webpack_require__(29202);
var shared = __webpack_require__(68726);
var sharedKey = __webpack_require__(44262);
var hiddenKeys = __webpack_require__(27748);
var uid = __webpack_require__(99418);
var wellKnownSymbol = __webpack_require__(99813);
var wrappedWellKnownSymbolModule = __webpack_require__(11477);
var defineWellKnownSymbol = __webpack_require__(73464);
var defineSymbolToPrimitive = __webpack_require__(29630);
var setToStringTag = __webpack_require__(90904);
var InternalStateModule = __webpack_require__(45402);
var $forEach = (__webpack_require__(3610).forEach);

var HIDDEN = sharedKey('hidden');
var SYMBOL = 'Symbol';
var PROTOTYPE = 'prototype';

var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(SYMBOL);

var ObjectPrototype = Object[PROTOTYPE];
var $Symbol = global.Symbol;
var SymbolPrototype = $Symbol && $Symbol[PROTOTYPE];
var TypeError = global.TypeError;
var QObject = global.QObject;
var nativeGetOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
var nativeDefineProperty = definePropertyModule.f;
var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
var nativePropertyIsEnumerable = propertyIsEnumerableModule.f;
var push = uncurryThis([].push);

var AllSymbols = shared('symbols');
var ObjectPrototypeSymbols = shared('op-symbols');
var WellKnownSymbolsStore = shared('wks');

// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
var setSymbolDescriptor = DESCRIPTORS && fails(function () {
  return nativeObjectCreate(nativeDefineProperty({}, 'a', {
    get: function () { return nativeDefineProperty(this, 'a', { value: 7 }).a; }
  })).a != 7;
}) ? function (O, P, Attributes) {
  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor(ObjectPrototype, P);
  if (ObjectPrototypeDescriptor) delete ObjectPrototype[P];
  nativeDefineProperty(O, P, Attributes);
  if (ObjectPrototypeDescriptor && O !== ObjectPrototype) {
    nativeDefineProperty(ObjectPrototype, P, ObjectPrototypeDescriptor);
  }
} : nativeDefineProperty;

var wrap = function (tag, description) {
  var symbol = AllSymbols[tag] = nativeObjectCreate(SymbolPrototype);
  setInternalState(symbol, {
    type: SYMBOL,
    tag: tag,
    description: description
  });
  if (!DESCRIPTORS) symbol.description = description;
  return symbol;
};

var $defineProperty = function defineProperty(O, P, Attributes) {
  if (O === ObjectPrototype) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
  anObject(O);
  var key = toPropertyKey(P);
  anObject(Attributes);
  if (hasOwn(AllSymbols, key)) {
    if (!Attributes.enumerable) {
      if (!hasOwn(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor(1, {}));
      O[HIDDEN][key] = true;
    } else {
      if (hasOwn(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
      Attributes = nativeObjectCreate(Attributes, { enumerable: createPropertyDescriptor(0, false) });
    } return setSymbolDescriptor(O, key, Attributes);
  } return nativeDefineProperty(O, key, Attributes);
};

var $defineProperties = function defineProperties(O, Properties) {
  anObject(O);
  var properties = toIndexedObject(Properties);
  var keys = objectKeys(properties).concat($getOwnPropertySymbols(properties));
  $forEach(keys, function (key) {
    if (!DESCRIPTORS || call($propertyIsEnumerable, properties, key)) $defineProperty(O, key, properties[key]);
  });
  return O;
};

var $create = function create(O, Properties) {
  return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
};

var $propertyIsEnumerable = function propertyIsEnumerable(V) {
  var P = toPropertyKey(V);
  var enumerable = call(nativePropertyIsEnumerable, this, P);
  if (this === ObjectPrototype && hasOwn(AllSymbols, P) && !hasOwn(ObjectPrototypeSymbols, P)) return false;
  return enumerable || !hasOwn(this, P) || !hasOwn(AllSymbols, P) || hasOwn(this, HIDDEN) && this[HIDDEN][P]
    ? enumerable : true;
};

var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
  var it = toIndexedObject(O);
  var key = toPropertyKey(P);
  if (it === ObjectPrototype && hasOwn(AllSymbols, key) && !hasOwn(ObjectPrototypeSymbols, key)) return;
  var descriptor = nativeGetOwnPropertyDescriptor(it, key);
  if (descriptor && hasOwn(AllSymbols, key) && !(hasOwn(it, HIDDEN) && it[HIDDEN][key])) {
    descriptor.enumerable = true;
  }
  return descriptor;
};

var $getOwnPropertyNames = function getOwnPropertyNames(O) {
  var names = nativeGetOwnPropertyNames(toIndexedObject(O));
  var result = [];
  $forEach(names, function (key) {
    if (!hasOwn(AllSymbols, key) && !hasOwn(hiddenKeys, key)) push(result, key);
  });
  return result;
};

var $getOwnPropertySymbols = function (O) {
  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype;
  var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject(O));
  var result = [];
  $forEach(names, function (key) {
    if (hasOwn(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || hasOwn(ObjectPrototype, key))) {
      push(result, AllSymbols[key]);
    }
  });
  return result;
};

// `Symbol` constructor
// https://tc39.es/ecma262/#sec-symbol-constructor
if (!NATIVE_SYMBOL) {
  $Symbol = function Symbol() {
    if (isPrototypeOf(SymbolPrototype, this)) throw TypeError('Symbol is not a constructor');
    var description = !arguments.length || arguments[0] === undefined ? undefined : $toString(arguments[0]);
    var tag = uid(description);
    var setter = function (value) {
      if (this === ObjectPrototype) call(setter, ObjectPrototypeSymbols, value);
      if (hasOwn(this, HIDDEN) && hasOwn(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
      setSymbolDescriptor(this, tag, createPropertyDescriptor(1, value));
    };
    if (DESCRIPTORS && USE_SETTER) setSymbolDescriptor(ObjectPrototype, tag, { configurable: true, set: setter });
    return wrap(tag, description);
  };

  SymbolPrototype = $Symbol[PROTOTYPE];

  defineBuiltIn(SymbolPrototype, 'toString', function toString() {
    return getInternalState(this).tag;
  });

  defineBuiltIn($Symbol, 'withoutSetter', function (description) {
    return wrap(uid(description), description);
  });

  propertyIsEnumerableModule.f = $propertyIsEnumerable;
  definePropertyModule.f = $defineProperty;
  definePropertiesModule.f = $defineProperties;
  getOwnPropertyDescriptorModule.f = $getOwnPropertyDescriptor;
  getOwnPropertyNamesModule.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
  getOwnPropertySymbolsModule.f = $getOwnPropertySymbols;

  wrappedWellKnownSymbolModule.f = function (name) {
    return wrap(wellKnownSymbol(name), name);
  };

  if (DESCRIPTORS) {
    // https://github.com/tc39/proposal-Symbol-description
    defineBuiltInAccessor(SymbolPrototype, 'description', {
      configurable: true,
      get: function description() {
        return getInternalState(this).description;
      }
    });
    if (!IS_PURE) {
      defineBuiltIn(ObjectPrototype, 'propertyIsEnumerable', $propertyIsEnumerable, { unsafe: true });
    }
  }
}

$({ global: true, constructor: true, wrap: true, forced: !NATIVE_SYMBOL, sham: !NATIVE_SYMBOL }, {
  Symbol: $Symbol
});

$forEach(objectKeys(WellKnownSymbolsStore), function (name) {
  defineWellKnownSymbol(name);
});

$({ target: SYMBOL, stat: true, forced: !NATIVE_SYMBOL }, {
  useSetter: function () { USE_SETTER = true; },
  useSimple: function () { USE_SETTER = false; }
});

$({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL, sham: !DESCRIPTORS }, {
  // `Object.create` method
  // https://tc39.es/ecma262/#sec-object.create
  create: $create,
  // `Object.defineProperty` method
  // https://tc39.es/ecma262/#sec-object.defineproperty
  defineProperty: $defineProperty,
  // `Object.defineProperties` method
  // https://tc39.es/ecma262/#sec-object.defineproperties
  defineProperties: $defineProperties,
  // `Object.getOwnPropertyDescriptor` method
  // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
});

$({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL }, {
  // `Object.getOwnPropertyNames` method
  // https://tc39.es/ecma262/#sec-object.getownpropertynames
  getOwnPropertyNames: $getOwnPropertyNames
});

// `Symbol.prototype[@@toPrimitive]` method
// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
defineSymbolToPrimitive();

// `Symbol.prototype[@@toStringTag]` property
// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
setToStringTag($Symbol, SYMBOL);

hiddenKeys[HIDDEN] = true;


/***/ }),

/***/ 52615:
/***/ (() => {

// empty


/***/ }),

/***/ 64523:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var getBuiltIn = __webpack_require__(626);
var hasOwn = __webpack_require__(90953);
var toString = __webpack_require__(85803);
var shared = __webpack_require__(68726);
var NATIVE_SYMBOL_REGISTRY = __webpack_require__(34680);

var StringToSymbolRegistry = shared('string-to-symbol-registry');
var SymbolToStringRegistry = shared('symbol-to-string-registry');

// `Symbol.for` method
// https://tc39.es/ecma262/#sec-symbol.for
$({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY }, {
  'for': function (key) {
    var string = toString(key);
    if (hasOwn(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
    var symbol = getBuiltIn('Symbol')(string);
    StringToSymbolRegistry[string] = symbol;
    SymbolToStringRegistry[symbol] = string;
    return symbol;
  }
});


/***/ }),

/***/ 21732:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.hasInstance` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.hasinstance
defineWellKnownSymbol('hasInstance');


/***/ }),

/***/ 35903:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.isConcatSpreadable` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.isconcatspreadable
defineWellKnownSymbol('isConcatSpreadable');


/***/ }),

/***/ 1825:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.iterator` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.iterator
defineWellKnownSymbol('iterator');


/***/ }),

/***/ 35824:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// TODO: Remove this module from `core-js@4` since it's split to modules listed below
__webpack_require__(48616);
__webpack_require__(64523);
__webpack_require__(38608);
__webpack_require__(32619);
__webpack_require__(37144);


/***/ }),

/***/ 38608:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var hasOwn = __webpack_require__(90953);
var isSymbol = __webpack_require__(56664);
var tryToString = __webpack_require__(69826);
var shared = __webpack_require__(68726);
var NATIVE_SYMBOL_REGISTRY = __webpack_require__(34680);

var SymbolToStringRegistry = shared('symbol-to-string-registry');

// `Symbol.keyFor` method
// https://tc39.es/ecma262/#sec-symbol.keyfor
$({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY }, {
  keyFor: function keyFor(sym) {
    if (!isSymbol(sym)) throw TypeError(tryToString(sym) + ' is not a symbol');
    if (hasOwn(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
  }
});


/***/ }),

/***/ 45915:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.matchAll` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.matchall
defineWellKnownSymbol('matchAll');


/***/ }),

/***/ 28394:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.match` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.match
defineWellKnownSymbol('match');


/***/ }),

/***/ 61766:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.replace` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.replace
defineWellKnownSymbol('replace');


/***/ }),

/***/ 62737:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.search` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.search
defineWellKnownSymbol('search');


/***/ }),

/***/ 89911:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.species` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.species
defineWellKnownSymbol('species');


/***/ }),

/***/ 74315:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.split` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.split
defineWellKnownSymbol('split');


/***/ }),

/***/ 63131:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);
var defineSymbolToPrimitive = __webpack_require__(29630);

// `Symbol.toPrimitive` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.toprimitive
defineWellKnownSymbol('toPrimitive');

// `Symbol.prototype[@@toPrimitive]` method
// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
defineSymbolToPrimitive();


/***/ }),

/***/ 64714:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var getBuiltIn = __webpack_require__(626);
var defineWellKnownSymbol = __webpack_require__(73464);
var setToStringTag = __webpack_require__(90904);

// `Symbol.toStringTag` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.tostringtag
defineWellKnownSymbol('toStringTag');

// `Symbol.prototype[@@toStringTag]` property
// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
setToStringTag(getBuiltIn('Symbol'), 'Symbol');


/***/ }),

/***/ 70659:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.unscopables` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.unscopables
defineWellKnownSymbol('unscopables');


/***/ }),

/***/ 28783:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.asyncDispose` well-known symbol
// https://github.com/tc39/proposal-async-explicit-resource-management
defineWellKnownSymbol('asyncDispose');


/***/ }),

/***/ 43975:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.dispose` well-known symbol
// https://github.com/tc39/proposal-explicit-resource-management
defineWellKnownSymbol('dispose');


/***/ }),

/***/ 22731:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var getBuiltIn = __webpack_require__(626);
var uncurryThis = __webpack_require__(95329);

var Symbol = getBuiltIn('Symbol');
var keyFor = Symbol.keyFor;
var thisSymbolValue = uncurryThis(Symbol.prototype.valueOf);

// `Symbol.isRegistered` method
// https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregistered
$({ target: 'Symbol', stat: true }, {
  isRegistered: function isRegistered(value) {
    try {
      return keyFor(thisSymbolValue(value)) !== undefined;
    } catch (error) {
      return false;
    }
  }
});


/***/ }),

/***/ 85605:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $ = __webpack_require__(76887);
var shared = __webpack_require__(68726);
var getBuiltIn = __webpack_require__(626);
var uncurryThis = __webpack_require__(95329);
var isSymbol = __webpack_require__(56664);
var wellKnownSymbol = __webpack_require__(99813);

var Symbol = getBuiltIn('Symbol');
var $isWellKnown = Symbol.isWellKnown;
var getOwnPropertyNames = getBuiltIn('Object', 'getOwnPropertyNames');
var thisSymbolValue = uncurryThis(Symbol.prototype.valueOf);
var WellKnownSymbolsStore = shared('wks');

for (var i = 0, symbolKeys = getOwnPropertyNames(Symbol), symbolKeysLength = symbolKeys.length; i < symbolKeysLength; i++) {
  // some old engines throws on access to some keys like `arguments` or `caller`
  try {
    var symbolKey = symbolKeys[i];
    if (isSymbol(Symbol[symbolKey])) wellKnownSymbol(symbolKey);
  } catch (error) { /* empty */ }
}

// `Symbol.isWellKnown` method
// https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknown
// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
$({ target: 'Symbol', stat: true, forced: true }, {
  isWellKnown: function isWellKnown(value) {
    if ($isWellKnown && $isWellKnown(value)) return true;
    try {
      var symbol = thisSymbolValue(value);
      for (var j = 0, keys = getOwnPropertyNames(WellKnownSymbolsStore), keysLength = keys.length; j < keysLength; j++) {
        if (WellKnownSymbolsStore[keys[j]] == symbol) return true;
      }
    } catch (error) { /* empty */ }
    return false;
  }
});


/***/ }),

/***/ 65799:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.matcher` well-known symbol
// https://github.com/tc39/proposal-pattern-matching
defineWellKnownSymbol('matcher');


/***/ }),

/***/ 31943:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.metadataKey` well-known symbol
// https://github.com/tc39/proposal-decorator-metadata
defineWellKnownSymbol('metadataKey');


/***/ }),

/***/ 45414:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// TODO: Remove from `core-js@4`
var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.metadata` well-known symbol
// https://github.com/tc39/proposal-decorators
defineWellKnownSymbol('metadata');


/***/ }),

/***/ 46774:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.observable` well-known symbol
// https://github.com/tc39/proposal-observable
defineWellKnownSymbol('observable');


/***/ }),

/***/ 80620:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// TODO: remove from `core-js@4`
var defineWellKnownSymbol = __webpack_require__(73464);

// `Symbol.patternMatch` well-known symbol
// https://github.com/tc39/proposal-pattern-matching
defineWellKnownSymbol('patternMatch');


/***/ }),

/***/ 36172:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// TODO: remove from `core-js@4`
var defineWellKnownSymbol = __webpack_require__(73464);

defineWellKnownSymbol('replaceAll');


/***/ }),

/***/ 7634:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(66274);
var DOMIterables = __webpack_require__(63281);
var global = __webpack_require__(21899);
var classof = __webpack_require__(9697);
var createNonEnumerableProperty = __webpack_require__(32029);
var Iterators = __webpack_require__(12077);
var wellKnownSymbol = __webpack_require__(99813);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');

for (var COLLECTION_NAME in DOMIterables) {
  var Collection = global[COLLECTION_NAME];
  var CollectionPrototype = Collection && Collection.prototype;
  if (CollectionPrototype && classof(CollectionPrototype) !== TO_STRING_TAG) {
    createNonEnumerableProperty(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
  }
  Iterators[COLLECTION_NAME] = Iterators.Array;
}


/***/ }),

/***/ 49216:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(99324);

module.exports = parent;


/***/ }),

/***/ 11955:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(2480);

module.exports = parent;


/***/ }),

/***/ 46279:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(7634);
var classof = __webpack_require__(9697);
var hasOwn = __webpack_require__(90953);
var isPrototypeOf = __webpack_require__(7046);
var method = __webpack_require__(49216);

var ArrayPrototype = Array.prototype;

var DOMIterables = {
  DOMTokenList: true,
  NodeList: true
};

module.exports = function (it) {
  var own = it.forEach;
  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.forEach)
    || hasOwn(DOMIterables, classof(it)) ? method : own;
};


/***/ }),

/***/ 19373:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(34570);

module.exports = parent;


/***/ }),

/***/ 57396:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(7702);

module.exports = parent;


/***/ }),

/***/ 41910:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(48171);

module.exports = parent;


/***/ }),

/***/ 79427:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(286);

module.exports = parent;


/***/ }),

/***/ 62857:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(92766);

module.exports = parent;


/***/ }),

/***/ 9534:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(30498);

module.exports = parent;


/***/ }),

/***/ 23059:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(48494);

module.exports = parent;


/***/ }),

/***/ 92547:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(57473);
__webpack_require__(7634);

module.exports = parent;


/***/ }),

/***/ 46509:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(24227);
__webpack_require__(7634);

module.exports = parent;


/***/ }),

/***/ 35774:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var parent = __webpack_require__(62978);

module.exports = parent;


/***/ }),

/***/ 9996:
/***/ ((module) => {

"use strict";


var isMergeableObject = function isMergeableObject(value) {
	return isNonNullObject(value)
		&& !isSpecial(value)
};

function isNonNullObject(value) {
	return !!value && typeof value === 'object'
}

function isSpecial(value) {
	var stringValue = Object.prototype.toString.call(value);

	return stringValue === '[object RegExp]'
		|| stringValue === '[object Date]'
		|| isReactElement(value)
}

// see https://github.com/facebook/react/blob/b5ac963fb791d1298e7f396236383bc955f916c1/src/isomorphic/classic/element/ReactElement.js#L21-L25
var canUseSymbol = typeof Symbol === 'function' && Symbol.for;
var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for('react.element') : 0xeac7;

function isReactElement(value) {
	return value.$$typeof === REACT_ELEMENT_TYPE
}

function emptyTarget(val) {
	return Array.isArray(val) ? [] : {}
}

function cloneUnlessOtherwiseSpecified(value, options) {
	return (options.clone !== false && options.isMergeableObject(value))
		? deepmerge(emptyTarget(value), value, options)
		: value
}

function defaultArrayMerge(target, source, options) {
	return target.concat(source).map(function(element) {
		return cloneUnlessOtherwiseSpecified(element, options)
	})
}

function getMergeFunction(key, options) {
	if (!options.customMerge) {
		return deepmerge
	}
	var customMerge = options.customMerge(key);
	return typeof customMerge === 'function' ? customMerge : deepmerge
}

function getEnumerableOwnPropertySymbols(target) {
	return Object.getOwnPropertySymbols
		? Object.getOwnPropertySymbols(target).filter(function(symbol) {
			return Object.propertyIsEnumerable.call(target, symbol)
		})
		: []
}

function getKeys(target) {
	return Object.keys(target).concat(getEnumerableOwnPropertySymbols(target))
}

function propertyIsOnObject(object, property) {
	try {
		return property in object
	} catch(_) {
		return false
	}
}

// Protects from prototype poisoning and unexpected merging up the prototype chain.
function propertyIsUnsafe(target, key) {
	return propertyIsOnObject(target, key) // Properties are safe to merge if they don't exist in the target yet,
		&& !(Object.hasOwnProperty.call(target, key) // unsafe if they exist up the prototype chain,
			&& Object.propertyIsEnumerable.call(target, key)) // and also unsafe if they're nonenumerable.
}

function mergeObject(target, source, options) {
	var destination = {};
	if (options.isMergeableObject(target)) {
		getKeys(target).forEach(function(key) {
			destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
		});
	}
	getKeys(source).forEach(function(key) {
		if (propertyIsUnsafe(target, key)) {
			return
		}

		if (propertyIsOnObject(target, key) && options.isMergeableObject(source[key])) {
			destination[key] = getMergeFunction(key, options)(target[key], source[key], options);
		} else {
			destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
		}
	});
	return destination
}

function deepmerge(target, source, options) {
	options = options || {};
	options.arrayMerge = options.arrayMerge || defaultArrayMerge;
	options.isMergeableObject = options.isMergeableObject || isMergeableObject;
	// cloneUnlessOtherwiseSpecified is added to `options` so that custom arrayMerge()
	// implementations can use it. The caller may not replace it.
	options.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;

	var sourceIsArray = Array.isArray(source);
	var targetIsArray = Array.isArray(target);
	var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;

	if (!sourceAndTargetTypesMatch) {
		return cloneUnlessOtherwiseSpecified(source, options)
	} else if (sourceIsArray) {
		return options.arrayMerge(target, source, options)
	} else {
		return mergeObject(target, source, options)
	}
}

deepmerge.all = function deepmergeAll(array, options) {
	if (!Array.isArray(array)) {
		throw new Error('first argument should be an array')
	}

	return array.reduce(function(prev, next) {
		return deepmerge(prev, next, options)
	}, {})
};

var deepmerge_1 = deepmerge;

module.exports = deepmerge_1;


/***/ }),

/***/ 17648:
/***/ ((module) => {

"use strict";


/* eslint no-invalid-this: 1 */

var ERROR_MESSAGE = 'Function.prototype.bind called on incompatible ';
var slice = Array.prototype.slice;
var toStr = Object.prototype.toString;
var funcType = '[object Function]';

module.exports = function bind(that) {
    var target = this;
    if (typeof target !== 'function' || toStr.call(target) !== funcType) {
        throw new TypeError(ERROR_MESSAGE + target);
    }
    var args = slice.call(arguments, 1);

    var bound;
    var binder = function () {
        if (this instanceof bound) {
            var result = target.apply(
                this,
                args.concat(slice.call(arguments))
            );
            if (Object(result) === result) {
                return result;
            }
            return this;
        } else {
            return target.apply(
                that,
                args.concat(slice.call(arguments))
            );
        }
    };

    var boundLength = Math.max(0, target.length - args.length);
    var boundArgs = [];
    for (var i = 0; i < boundLength; i++) {
        boundArgs.push('$' + i);
    }

    bound = Function('binder', 'return function (' + boundArgs.join(',') + '){ return binder.apply(this,arguments); }')(binder);

    if (target.prototype) {
        var Empty = function Empty() {};
        Empty.prototype = target.prototype;
        bound.prototype = new Empty();
        Empty.prototype = null;
    }

    return bound;
};


/***/ }),

/***/ 58612:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var implementation = __webpack_require__(17648);

module.exports = Function.prototype.bind || implementation;


/***/ }),

/***/ 40210:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var undefined;

var $SyntaxError = SyntaxError;
var $Function = Function;
var $TypeError = TypeError;

// eslint-disable-next-line consistent-return
var getEvalledConstructor = function (expressionSyntax) {
	try {
		return $Function('"use strict"; return (' + expressionSyntax + ').constructor;')();
	} catch (e) {}
};

var $gOPD = Object.getOwnPropertyDescriptor;
if ($gOPD) {
	try {
		$gOPD({}, '');
	} catch (e) {
		$gOPD = null; // this is IE 8, which has a broken gOPD
	}
}

var throwTypeError = function () {
	throw new $TypeError();
};
var ThrowTypeError = $gOPD
	? (function () {
		try {
			// eslint-disable-next-line no-unused-expressions, no-caller, no-restricted-properties
			arguments.callee; // IE 8 does not throw here
			return throwTypeError;
		} catch (calleeThrows) {
			try {
				// IE 8 throws on Object.getOwnPropertyDescriptor(arguments, '')
				return $gOPD(arguments, 'callee').get;
			} catch (gOPDthrows) {
				return throwTypeError;
			}
		}
	}())
	: throwTypeError;

var hasSymbols = __webpack_require__(41405)();

var getProto = Object.getPrototypeOf || function (x) { return x.__proto__; }; // eslint-disable-line no-proto

var needsEval = {};

var TypedArray = typeof Uint8Array === 'undefined' ? undefined : getProto(Uint8Array);

var INTRINSICS = {
	'%AggregateError%': typeof AggregateError === 'undefined' ? undefined : AggregateError,
	'%Array%': Array,
	'%ArrayBuffer%': typeof ArrayBuffer === 'undefined' ? undefined : ArrayBuffer,
	'%ArrayIteratorPrototype%': hasSymbols ? getProto([][Symbol.iterator]()) : undefined,
	'%AsyncFromSyncIteratorPrototype%': undefined,
	'%AsyncFunction%': needsEval,
	'%AsyncGenerator%': needsEval,
	'%AsyncGeneratorFunction%': needsEval,
	'%AsyncIteratorPrototype%': needsEval,
	'%Atomics%': typeof Atomics === 'undefined' ? undefined : Atomics,
	'%BigInt%': typeof BigInt === 'undefined' ? undefined : BigInt,
	'%BigInt64Array%': typeof BigInt64Array === 'undefined' ? undefined : BigInt64Array,
	'%BigUint64Array%': typeof BigUint64Array === 'undefined' ? undefined : BigUint64Array,
	'%Boolean%': Boolean,
	'%DataView%': typeof DataView === 'undefined' ? undefined : DataView,
	'%Date%': Date,
	'%decodeURI%': decodeURI,
	'%decodeURIComponent%': decodeURIComponent,
	'%encodeURI%': encodeURI,
	'%encodeURIComponent%': encodeURIComponent,
	'%Error%': Error,
	'%eval%': eval, // eslint-disable-line no-eval
	'%EvalError%': EvalError,
	'%Float32Array%': typeof Float32Array === 'undefined' ? undefined : Float32Array,
	'%Float64Array%': typeof Float64Array === 'undefined' ? undefined : Float64Array,
	'%FinalizationRegistry%': typeof FinalizationRegistry === 'undefined' ? undefined : FinalizationRegistry,
	'%Function%': $Function,
	'%GeneratorFunction%': needsEval,
	'%Int8Array%': typeof Int8Array === 'undefined' ? undefined : Int8Array,
	'%Int16Array%': typeof Int16Array === 'undefined' ? undefined : Int16Array,
	'%Int32Array%': typeof Int32Array === 'undefined' ? undefined : Int32Array,
	'%isFinite%': isFinite,
	'%isNaN%': isNaN,
	'%IteratorPrototype%': hasSymbols ? getProto(getProto([][Symbol.iterator]())) : undefined,
	'%JSON%': typeof JSON === 'object' ? JSON : undefined,
	'%Map%': typeof Map === 'undefined' ? undefined : Map,
	'%MapIteratorPrototype%': typeof Map === 'undefined' || !hasSymbols ? undefined : getProto(new Map()[Symbol.iterator]()),
	'%Math%': Math,
	'%Number%': Number,
	'%Object%': Object,
	'%parseFloat%': parseFloat,
	'%parseInt%': parseInt,
	'%Promise%': typeof Promise === 'undefined' ? undefined : Promise,
	'%Proxy%': typeof Proxy === 'undefined' ? undefined : Proxy,
	'%RangeError%': RangeError,
	'%ReferenceError%': ReferenceError,
	'%Reflect%': typeof Reflect === 'undefined' ? undefined : Reflect,
	'%RegExp%': RegExp,
	'%Set%': typeof Set === 'undefined' ? undefined : Set,
	'%SetIteratorPrototype%': typeof Set === 'undefined' || !hasSymbols ? undefined : getProto(new Set()[Symbol.iterator]()),
	'%SharedArrayBuffer%': typeof SharedArrayBuffer === 'undefined' ? undefined : SharedArrayBuffer,
	'%String%': String,
	'%StringIteratorPrototype%': hasSymbols ? getProto(''[Symbol.iterator]()) : undefined,
	'%Symbol%': hasSymbols ? Symbol : undefined,
	'%SyntaxError%': $SyntaxError,
	'%ThrowTypeError%': ThrowTypeError,
	'%TypedArray%': TypedArray,
	'%TypeError%': $TypeError,
	'%Uint8Array%': typeof Uint8Array === 'undefined' ? undefined : Uint8Array,
	'%Uint8ClampedArray%': typeof Uint8ClampedArray === 'undefined' ? undefined : Uint8ClampedArray,
	'%Uint16Array%': typeof Uint16Array === 'undefined' ? undefined : Uint16Array,
	'%Uint32Array%': typeof Uint32Array === 'undefined' ? undefined : Uint32Array,
	'%URIError%': URIError,
	'%WeakMap%': typeof WeakMap === 'undefined' ? undefined : WeakMap,
	'%WeakRef%': typeof WeakRef === 'undefined' ? undefined : WeakRef,
	'%WeakSet%': typeof WeakSet === 'undefined' ? undefined : WeakSet
};

try {
	null.error; // eslint-disable-line no-unused-expressions
} catch (e) {
	// https://github.com/tc39/proposal-shadowrealm/pull/384#issuecomment-1364264229
	var errorProto = getProto(getProto(e));
	INTRINSICS['%Error.prototype%'] = errorProto;
}

var doEval = function doEval(name) {
	var value;
	if (name === '%AsyncFunction%') {
		value = getEvalledConstructor('async function () {}');
	} else if (name === '%GeneratorFunction%') {
		value = getEvalledConstructor('function* () {}');
	} else if (name === '%AsyncGeneratorFunction%') {
		value = getEvalledConstructor('async function* () {}');
	} else if (name === '%AsyncGenerator%') {
		var fn = doEval('%AsyncGeneratorFunction%');
		if (fn) {
			value = fn.prototype;
		}
	} else if (name === '%AsyncIteratorPrototype%') {
		var gen = doEval('%AsyncGenerator%');
		if (gen) {
			value = getProto(gen.prototype);
		}
	}

	INTRINSICS[name] = value;

	return value;
};

var LEGACY_ALIASES = {
	'%ArrayBufferPrototype%': ['ArrayBuffer', 'prototype'],
	'%ArrayPrototype%': ['Array', 'prototype'],
	'%ArrayProto_entries%': ['Array', 'prototype', 'entries'],
	'%ArrayProto_forEach%': ['Array', 'prototype', 'forEach'],
	'%ArrayProto_keys%': ['Array', 'prototype', 'keys'],
	'%ArrayProto_values%': ['Array', 'prototype', 'values'],
	'%AsyncFunctionPrototype%': ['AsyncFunction', 'prototype'],
	'%AsyncGenerator%': ['AsyncGeneratorFunction', 'prototype'],
	'%AsyncGeneratorPrototype%': ['AsyncGeneratorFunction', 'prototype', 'prototype'],
	'%BooleanPrototype%': ['Boolean', 'prototype'],
	'%DataViewPrototype%': ['DataView', 'prototype'],
	'%DatePrototype%': ['Date', 'prototype'],
	'%ErrorPrototype%': ['Error', 'prototype'],
	'%EvalErrorPrototype%': ['EvalError', 'prototype'],
	'%Float32ArrayPrototype%': ['Float32Array', 'prototype'],
	'%Float64ArrayPrototype%': ['Float64Array', 'prototype'],
	'%FunctionPrototype%': ['Function', 'prototype'],
	'%Generator%': ['GeneratorFunction', 'prototype'],
	'%GeneratorPrototype%': ['GeneratorFunction', 'prototype', 'prototype'],
	'%Int8ArrayPrototype%': ['Int8Array', 'prototype'],
	'%Int16ArrayPrototype%': ['Int16Array', 'prototype'],
	'%Int32ArrayPrototype%': ['Int32Array', 'prototype'],
	'%JSONParse%': ['JSON', 'parse'],
	'%JSONStringify%': ['JSON', 'stringify'],
	'%MapPrototype%': ['Map', 'prototype'],
	'%NumberPrototype%': ['Number', 'prototype'],
	'%ObjectPrototype%': ['Object', 'prototype'],
	'%ObjProto_toString%': ['Object', 'prototype', 'toString'],
	'%ObjProto_valueOf%': ['Object', 'prototype', 'valueOf'],
	'%PromisePrototype%': ['Promise', 'prototype'],
	'%PromiseProto_then%': ['Promise', 'prototype', 'then'],
	'%Promise_all%': ['Promise', 'all'],
	'%Promise_reject%': ['Promise', 'reject'],
	'%Promise_resolve%': ['Promise', 'resolve'],
	'%RangeErrorPrototype%': ['RangeError', 'prototype'],
	'%ReferenceErrorPrototype%': ['ReferenceError', 'prototype'],
	'%RegExpPrototype%': ['RegExp', 'prototype'],
	'%SetPrototype%': ['Set', 'prototype'],
	'%SharedArrayBufferPrototype%': ['SharedArrayBuffer', 'prototype'],
	'%StringPrototype%': ['String', 'prototype'],
	'%SymbolPrototype%': ['Symbol', 'prototype'],
	'%SyntaxErrorPrototype%': ['SyntaxError', 'prototype'],
	'%TypedArrayPrototype%': ['TypedArray', 'prototype'],
	'%TypeErrorPrototype%': ['TypeError', 'prototype'],
	'%Uint8ArrayPrototype%': ['Uint8Array', 'prototype'],
	'%Uint8ClampedArrayPrototype%': ['Uint8ClampedArray', 'prototype'],
	'%Uint16ArrayPrototype%': ['Uint16Array', 'prototype'],
	'%Uint32ArrayPrototype%': ['Uint32Array', 'prototype'],
	'%URIErrorPrototype%': ['URIError', 'prototype'],
	'%WeakMapPrototype%': ['WeakMap', 'prototype'],
	'%WeakSetPrototype%': ['WeakSet', 'prototype']
};

var bind = __webpack_require__(58612);
var hasOwn = __webpack_require__(17642);
var $concat = bind.call(Function.call, Array.prototype.concat);
var $spliceApply = bind.call(Function.apply, Array.prototype.splice);
var $replace = bind.call(Function.call, String.prototype.replace);
var $strSlice = bind.call(Function.call, String.prototype.slice);
var $exec = bind.call(Function.call, RegExp.prototype.exec);

/* adapted from https://github.com/lodash/lodash/blob/4.17.15/dist/lodash.js#L6735-L6744 */
var rePropName = /[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;
var reEscapeChar = /\\(\\)?/g; /** Used to match backslashes in property paths. */
var stringToPath = function stringToPath(string) {
	var first = $strSlice(string, 0, 1);
	var last = $strSlice(string, -1);
	if (first === '%' && last !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected closing `%`');
	} else if (last === '%' && first !== '%') {
		throw new $SyntaxError('invalid intrinsic syntax, expected opening `%`');
	}
	var result = [];
	$replace(string, rePropName, function (match, number, quote, subString) {
		result[result.length] = quote ? $replace(subString, reEscapeChar, '$1') : number || match;
	});
	return result;
};
/* end adaptation */

var getBaseIntrinsic = function getBaseIntrinsic(name, allowMissing) {
	var intrinsicName = name;
	var alias;
	if (hasOwn(LEGACY_ALIASES, intrinsicName)) {
		alias = LEGACY_ALIASES[intrinsicName];
		intrinsicName = '%' + alias[0] + '%';
	}

	if (hasOwn(INTRINSICS, intrinsicName)) {
		var value = INTRINSICS[intrinsicName];
		if (value === needsEval) {
			value = doEval(intrinsicName);
		}
		if (typeof value === 'undefined' && !allowMissing) {
			throw new $TypeError('intrinsic ' + name + ' exists, but is not available. Please file an issue!');
		}

		return {
			alias: alias,
			name: intrinsicName,
			value: value
		};
	}

	throw new $SyntaxError('intrinsic ' + name + ' does not exist!');
};

module.exports = function GetIntrinsic(name, allowMissing) {
	if (typeof name !== 'string' || name.length === 0) {
		throw new $TypeError('intrinsic name must be a non-empty string');
	}
	if (arguments.length > 1 && typeof allowMissing !== 'boolean') {
		throw new $TypeError('"allowMissing" argument must be a boolean');
	}

	if ($exec(/^%?[^%]*%?$/, name) === null) {
		throw new $SyntaxError('`%` may not be present anywhere but at the beginning and end of the intrinsic name');
	}
	var parts = stringToPath(name);
	var intrinsicBaseName = parts.length > 0 ? parts[0] : '';

	var intrinsic = getBaseIntrinsic('%' + intrinsicBaseName + '%', allowMissing);
	var intrinsicRealName = intrinsic.name;
	var value = intrinsic.value;
	var skipFurtherCaching = false;

	var alias = intrinsic.alias;
	if (alias) {
		intrinsicBaseName = alias[0];
		$spliceApply(parts, $concat([0, 1], alias));
	}

	for (var i = 1, isOwn = true; i < parts.length; i += 1) {
		var part = parts[i];
		var first = $strSlice(part, 0, 1);
		var last = $strSlice(part, -1);
		if (
			(
				(first === '"' || first === "'" || first === '`')
				|| (last === '"' || last === "'" || last === '`')
			)
			&& first !== last
		) {
			throw new $SyntaxError('property names with quotes must have matching quotes');
		}
		if (part === 'constructor' || !isOwn) {
			skipFurtherCaching = true;
		}

		intrinsicBaseName += '.' + part;
		intrinsicRealName = '%' + intrinsicBaseName + '%';

		if (hasOwn(INTRINSICS, intrinsicRealName)) {
			value = INTRINSICS[intrinsicRealName];
		} else if (value != null) {
			if (!(part in value)) {
				if (!allowMissing) {
					throw new $TypeError('base intrinsic for ' + name + ' exists, but the property is not available.');
				}
				return void undefined;
			}
			if ($gOPD && (i + 1) >= parts.length) {
				var desc = $gOPD(value, part);
				isOwn = !!desc;

				// By convention, when a data property is converted to an accessor
				// property to emulate a data property that does not suffer from
				// the override mistake, that accessor's getter is marked with
				// an `originalValue` property. Here, when we detect this, we
				// uphold the illusion by pretending to see that original data
				// property, i.e., returning the value rather than the getter
				// itself.
				if (isOwn && 'get' in desc && !('originalValue' in desc.get)) {
					value = desc.get;
				} else {
					value = value[part];
				}
			} else {
				isOwn = hasOwn(value, part);
				value = value[part];
			}

			if (isOwn && !skipFurtherCaching) {
				INTRINSICS[intrinsicRealName] = value;
			}
		}
	}
	return value;
};


/***/ }),

/***/ 41405:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var origSymbol = typeof Symbol !== 'undefined' && Symbol;
var hasSymbolSham = __webpack_require__(55419);

module.exports = function hasNativeSymbols() {
	if (typeof origSymbol !== 'function') { return false; }
	if (typeof Symbol !== 'function') { return false; }
	if (typeof origSymbol('foo') !== 'symbol') { return false; }
	if (typeof Symbol('bar') !== 'symbol') { return false; }

	return hasSymbolSham();
};


/***/ }),

/***/ 55419:
/***/ ((module) => {

"use strict";


/* eslint complexity: [2, 18], max-statements: [2, 33] */
module.exports = function hasSymbols() {
	if (typeof Symbol !== 'function' || typeof Object.getOwnPropertySymbols !== 'function') { return false; }
	if (typeof Symbol.iterator === 'symbol') { return true; }

	var obj = {};
	var sym = Symbol('test');
	var symObj = Object(sym);
	if (typeof sym === 'string') { return false; }

	if (Object.prototype.toString.call(sym) !== '[object Symbol]') { return false; }
	if (Object.prototype.toString.call(symObj) !== '[object Symbol]') { return false; }

	// temp disabled per https://github.com/ljharb/object.assign/issues/17
	// if (sym instanceof Symbol) { return false; }
	// temp disabled per https://github.com/WebReflection/get-own-property-symbols/issues/4
	// if (!(symObj instanceof Symbol)) { return false; }

	// if (typeof Symbol.prototype.toString !== 'function') { return false; }
	// if (String(sym) !== Symbol.prototype.toString.call(sym)) { return false; }

	var symVal = 42;
	obj[sym] = symVal;
	for (sym in obj) { return false; } // eslint-disable-line no-restricted-syntax, no-unreachable-loop
	if (typeof Object.keys === 'function' && Object.keys(obj).length !== 0) { return false; }

	if (typeof Object.getOwnPropertyNames === 'function' && Object.getOwnPropertyNames(obj).length !== 0) { return false; }

	var syms = Object.getOwnPropertySymbols(obj);
	if (syms.length !== 1 || syms[0] !== sym) { return false; }

	if (!Object.prototype.propertyIsEnumerable.call(obj, sym)) { return false; }

	if (typeof Object.getOwnPropertyDescriptor === 'function') {
		var descriptor = Object.getOwnPropertyDescriptor(obj, sym);
		if (descriptor.value !== symVal || descriptor.enumerable !== true) { return false; }
	}

	return true;
};


/***/ }),

/***/ 17642:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(58612);

module.exports = bind.call(Function.call, Object.prototype.hasOwnProperty);


/***/ }),

/***/ 88668:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isArray = __webpack_require__(1469);

/**
 * Casts `value` as an array if it's not one.
 *
 * @static
 * @memberOf _
 * @since 4.4.0
 * @category Lang
 * @param {*} value The value to inspect.
 * @returns {Array} Returns the cast array.
 * @example
 *
 * _.castArray(1);
 * // => [1]
 *
 * _.castArray({ 'a': 1 });
 * // => [{ 'a': 1 }]
 *
 * _.castArray('abc');
 * // => ['abc']
 *
 * _.castArray(null);
 * // => [null]
 *
 * _.castArray(undefined);
 * // => [undefined]
 *
 * _.castArray();
 * // => []
 *
 * var array = [1, 2, 3];
 * console.log(_.castArray(array) === array);
 * // => true
 */
function castArray() {
  if (!arguments.length) {
    return [];
  }
  var value = arguments[0];
  return isArray(value) ? value : [value];
}

module.exports = castArray;


/***/ }),

/***/ 46384:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var listCacheClear = __webpack_require__(27040),
    listCacheDelete = __webpack_require__(14125),
    listCacheGet = __webpack_require__(82117),
    listCacheHas = __webpack_require__(67518),
    listCacheSet = __webpack_require__(54705);

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

module.exports = ListCache;


/***/ }),

/***/ 82908:
/***/ ((module) => {

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

module.exports = arraySome;


/***/ }),

/***/ 18470:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var eq = __webpack_require__(77813);

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ }),

/***/ 97786:
/***/ ((module) => {

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

module.exports = getValue;


/***/ }),

/***/ 44239:
/***/ ((module) => {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

module.exports = objectToString;


/***/ }),

/***/ 42118:
/***/ ((module) => {

/**
 * A specialized version of `_.indexOf` which performs strict equality
 * comparisons of values, i.e. `===`.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} value The value to search for.
 * @param {number} fromIndex The index to search from.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function strictIndexOf(array, value, fromIndex) {
  var index = fromIndex - 1,
      length = array.length;

  while (++index < length) {
    if (array[index] === value) {
      return index;
    }
  }
  return -1;
}

module.exports = strictIndexOf;


/***/ }),

/***/ 90939:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqualDeep = __webpack_require__(2492),
    isObjectLike = __webpack_require__(37005);

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

module.exports = baseIsEqual;


/***/ }),

/***/ 2492:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(46384),
    equalArrays = __webpack_require__(67114),
    equalByTag = __webpack_require__(18351),
    equalObjects = __webpack_require__(16096),
    getTag = __webpack_require__(98882),
    isArray = __webpack_require__(1469),
    isBuffer = __webpack_require__(44144),
    isTypedArray = __webpack_require__(36719);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    objectTag = '[object Object]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = objIsArr ? arrayTag : getTag(object),
      othTag = othIsArr ? arrayTag : getTag(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && isBuffer(object)) {
    if (!isBuffer(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack);
    return (objIsArr || isTypedArray(object))
      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack);
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

module.exports = baseIsEqualDeep;


/***/ }),

/***/ 74757:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIndexOf = __webpack_require__(42118);

/**
 * A specialized version of `_.includes` for arrays without support for
 * specifying an index to search from.
 *
 * @private
 * @param {Array} [array] The array to inspect.
 * @param {*} target The value to search for.
 * @returns {boolean} Returns `true` if `target` is found, else `false`.
 */
function arrayIncludes(array, value) {
  var length = array == null ? 0 : array.length;
  return !!length && baseIndexOf(array, value, 0) > -1;
}

module.exports = arrayIncludes;


/***/ }),

/***/ 67114:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(88668),
    arraySome = __webpack_require__(82908),
    cacheHas = __webpack_require__(74757);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Check that cyclic values are equal.
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

module.exports = equalArrays;


/***/ }),

/***/ 18351:
/***/ ((module) => {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ }),

/***/ 16096:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getAllKeys = __webpack_require__(58234);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      objProps = getAllKeys(object),
      objLength = objProps.length,
      othProps = getAllKeys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Check that cyclic values are equal.
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

module.exports = equalObjects;


/***/ }),

/***/ 58234:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var overArg = __webpack_require__(5569);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = overArg(Object.keys, Object);

module.exports = nativeKeys;


/***/ }),

/***/ 98882:
/***/ ((module) => {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

module.exports = objectToString;


/***/ }),

/***/ 27040:
/***/ ((module) => {

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

module.exports = listCacheClear;


/***/ }),

/***/ 14125:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(18470);

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

module.exports = listCacheDelete;


/***/ }),

/***/ 82117:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(18470);

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

module.exports = listCacheGet;


/***/ }),

/***/ 67518:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(18470);

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

module.exports = listCacheHas;


/***/ }),

/***/ 54705:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(18470);

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

module.exports = listCacheSet;


/***/ }),

/***/ 5569:
/***/ ((module) => {

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

module.exports = overArg;


/***/ }),

/***/ 77813:
/***/ ((module) => {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ }),

/***/ 27361:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGet = __webpack_require__(97786);

/**
 * Gets the value at `path` of `object`. If the resolved value is
 * `undefined`, the `defaultValue` is returned in its place.
 *
 * @static
 * @memberOf _
 * @since 3.7.0
 * @category Object
 * @param {Object} object The object to query.
 * @param {Array|string} path The path of the property to get.
 * @param {*} [defaultValue] The value returned for `undefined` resolved values.
 * @returns {*} Returns the resolved value.
 * @example
 *
 * var object = { 'a': [{ 'b': { 'c': 3 } }] };
 *
 * _.get(object, 'a[0].b.c');
 * // => 3
 *
 * _.get(object, ['a', '0', 'b', 'c']);
 * // => 3
 *
 * _.get(object, 'a.b.c', 'default');
 * // => 'default'
 */
function get(object, path, defaultValue) {
  var result = object == null ? undefined : baseGet(object, path);
  return result === undefined ? defaultValue : result;
}

module.exports = get;


/***/ }),

/***/ 1469:
/***/ ((module) => {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ }),

/***/ 51584:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(44239),
    isObjectLike = __webpack_require__(37005);

/** `Object#toString` result references. */
var boolTag = '[object Boolean]';

/**
 * Checks if `value` is classified as a boolean primitive or object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a boolean, else `false`.
 * @example
 *
 * _.isBoolean(false);
 * // => true
 *
 * _.isBoolean(null);
 * // => false
 */
function isBoolean(value) {
  return value === true || value === false ||
    (isObjectLike(value) && baseGetTag(value) == boolTag);
}

module.exports = isBoolean;


/***/ }),

/***/ 44144:
/***/ ((module) => {

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = stubFalse;


/***/ }),

/***/ 18446:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqual = __webpack_require__(90939);

/**
 * Performs a deep comparison between two values to determine if they are
 * equivalent.
 *
 * **Note:** This method supports comparing arrays, array buffers, booleans,
 * date objects, error objects, maps, numbers, `Object` objects, regexes,
 * sets, strings, symbols, and typed arrays. `Object` objects are compared
 * by their own, not inherited, enumerable properties. Functions and DOM
 * nodes are compared by strict equality, i.e. `===`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.isEqual(object, other);
 * // => true
 *
 * object === other;
 * // => false
 */
function isEqual(value, other) {
  return baseIsEqual(value, other);
}

module.exports = isEqual;


/***/ }),

/***/ 45220:
/***/ ((module) => {

/**
 * Checks if `value` is `null`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `null`, else `false`.
 * @example
 *
 * _.isNull(null);
 * // => true
 *
 * _.isNull(void 0);
 * // => false
 */
function isNull(value) {
  return value === null;
}

module.exports = isNull;


/***/ }),

/***/ 81763:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(44239),
    isObjectLike = __webpack_require__(37005);

/** `Object#toString` result references. */
var numberTag = '[object Number]';

/**
 * Checks if `value` is classified as a `Number` primitive or object.
 *
 * **Note:** To exclude `Infinity`, `-Infinity`, and `NaN`, which are
 * classified as numbers, use the `_.isFinite` method.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a number, else `false`.
 * @example
 *
 * _.isNumber(3);
 * // => true
 *
 * _.isNumber(Number.MIN_VALUE);
 * // => true
 *
 * _.isNumber(Infinity);
 * // => true
 *
 * _.isNumber('3');
 * // => false
 */
function isNumber(value) {
  return typeof value == 'number' ||
    (isObjectLike(value) && baseGetTag(value) == numberTag);
}

module.exports = isNumber;


/***/ }),

/***/ 13218:
/***/ ((module) => {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),

/***/ 37005:
/***/ ((module) => {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),

/***/ 47037:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(44239),
    isArray = __webpack_require__(1469),
    isObjectLike = __webpack_require__(37005);

/** `Object#toString` result references. */
var stringTag = '[object String]';

/**
 * Checks if `value` is classified as a `String` primitive or object.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a string, else `false`.
 * @example
 *
 * _.isString('abc');
 * // => true
 *
 * _.isString(1);
 * // => false
 */
function isString(value) {
  return typeof value == 'string' ||
    (!isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag);
}

module.exports = isString;


/***/ }),

/***/ 36719:
/***/ ((module) => {

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = stubFalse;


/***/ }),

/***/ 94885:
/***/ ((module) => {

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that negates the result of the predicate `func`. The
 * `func` predicate is invoked with the `this` binding and arguments of the
 * created function.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Function
 * @param {Function} predicate The predicate to negate.
 * @returns {Function} Returns the new negated function.
 * @example
 *
 * function isEven(n) {
 *   return n % 2 == 0;
 * }
 *
 * _.filter([1, 2, 3, 4, 5, 6], _.negate(isEven));
 * // => [1, 3, 5]
 */
function negate(predicate) {
  if (typeof predicate != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  return function() {
    var args = arguments;
    switch (args.length) {
      case 0: return !predicate.call(this);
      case 1: return !predicate.call(this, args[0]);
      case 2: return !predicate.call(this, args[0], args[1]);
      case 3: return !predicate.call(this, args[0], args[1], args[2]);
    }
    return !predicate.apply(this, args);
  };
}

module.exports = negate;


/***/ }),

/***/ 42566:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(94885);

// Coerces an a parameter into a callback for matching elements.
// This accepts an element name, an element type and returns a
// callback to match for those elements.
function coerceElementMatchingCallback(value) {
  // Element Name
  if (typeof value === 'string') {
    return element => element.element === value;
  }

  // Element Type
  if (value.constructor && value.extend) {
    return element => element instanceof value;
  }

  return value;
}

/**
 * @class
 *
 * @param {Element[]} elements
 *
 * @property {Element[]} elements
 */
class ArraySlice {
  constructor(elements) {
    this.elements = elements || [];
  }

  /**
   * @returns {Array}
   */
  toValue() {
    return this.elements.map(element => element.toValue());
  }

  // High Order Functions

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {array} A new array with each element being the result of the callback function
   */
  map(callback, thisArg) {
    return this.elements.map(callback, thisArg);
  }

  /**
   * Maps and then flattens the results.
   * @param callback - Function to execute for each element.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {array}
   */
  flatMap(callback, thisArg) {
    return this
      .map(callback, thisArg)
      .reduce((a, b) => a.concat(b), []);
  }

  /**
   * Returns an array containing the truthy results of calling the given transformation with each element of this sequence
   * @param transform - A closure that accepts an element of this array as its argument and returns an optional value.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArraySlice.prototype
   * @returns An array of the non-undefined results of calling transform with each element of the array
   */
  compactMap(transform, thisArg) {
    const results = [];

    this.forEach((element) => {
      const result = transform.bind(thisArg)(element);

      if (result) {
        results.push(result);
      }
    });

    return results;
  }

  /**
   * @param callback - Function to execute for each element. This may be a callback, an element name or an element class.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   * @memberof ArraySlice.prototype
   */
  filter(callback, thisArg) {
    callback = coerceElementMatchingCallback(callback);
    return new ArraySlice(this.elements.filter(callback, thisArg));
  }

  /**
   * @param callback - Function to execute for each element. This may be a callback, an element name or an element class.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   * @memberof ArraySlice.prototype
   */
  reject(callback, thisArg) {
    callback = coerceElementMatchingCallback(callback);
    return new ArraySlice(this.elements.filter(negate(callback), thisArg));
  }

  /**
   * Returns the first element in the array that satisfies the given value
   * @param callback - Function to execute for each element. This may be a callback, an element name or an element class.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {Element}
   * @memberof ArraySlice.prototype
   */
  find(callback, thisArg) {
    callback = coerceElementMatchingCallback(callback);
    return this.elements.find(callback, thisArg);
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArraySlice.prototype
   */
  forEach(callback, thisArg) {
    this.elements.forEach(callback, thisArg);
  }

  /**
   * @param callback - Function to execute for each element
   * @param initialValue
   * @memberof ArraySlice.prototype
   */
  reduce(callback, initialValue) {
    return this.elements.reduce(callback, initialValue);
  }

  /**
   * @param value
   * @returns {boolean}
   * @memberof ArraySlice.prototype
   */
  includes(value) {
    return this.elements.some(element => element.equals(value));
  }

  // Mutation

  /**
   * Removes the first element from the slice
   * @returns {Element} The removed element or undefined if the slice is empty
   * @memberof ArraySlice.prototype
   */
  shift() {
    return this.elements.shift();
  }

  /**
   * Adds the given element to the begining of the slice
   * @parameter {Element} value
   * @memberof ArraySlice.prototype
   */
  unshift(value) {
    this.elements.unshift(this.refract(value));
  }

  /**
   * Adds the given element to the end of the slice
   * @parameter {Element} value
   * @memberof ArraySlice.prototype
   */
  push(value) {
    this.elements.push(this.refract(value));
    return this;
  }

  /**
   * @parameter {Element} value
   * @memberof ArraySlice.prototype
   */
  add(value) {
    this.push(value);
  }

  // Accessors

  /**
   * @parameter {number} index
   * @returns {Element}
   * @memberof ArraySlice.prototype
   */
  get(index) {
    return this.elements[index];
  }

  /**
   * @parameter {number} index
   * @memberof ArraySlice.prototype
   */
  getValue(index) {
    const element = this.elements[index];

    if (element) {
      return element.toValue();
    }

    return undefined;
  }

  /**
   * Returns the number of elements in the slice
   * @type number
   */
  get length() {
    return this.elements.length;
  }

  /**
   * Returns whether the slice is empty
   * @type boolean
   */
  get isEmpty() {
    return this.elements.length === 0;
  }

  /**
   * Returns the first element in the slice or undefined if the slice is empty
   * @type Element
   */
  get first() {
    return this.elements[0];
  }
}

if (typeof Symbol !== 'undefined') {
  ArraySlice.prototype[Symbol.iterator] = function symbol() {
    return this.elements[Symbol.iterator]();
  };
}

module.exports = ArraySlice;


/***/ }),

/***/ 17645:
/***/ ((module) => {

/**
 * @class
 *
 * @property {Element} key
 * @property {Element} value
 */
class KeyValuePair {
  constructor(key, value) {
    this.key = key;
    this.value = value;
  }

  /**
   * @returns {KeyValuePair}
   */
  clone() {
    const clone = new KeyValuePair();

    if (this.key) {
      clone.key = this.key.clone();
    }

    if (this.value) {
      clone.value = this.value.clone();
    }

    return clone;
  }
}

module.exports = KeyValuePair;


/***/ }),

/***/ 78520:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const isNull = __webpack_require__(45220);
const isString = __webpack_require__(47037);
const isNumber = __webpack_require__(81763);
const isBoolean = __webpack_require__(51584);
const isObject = __webpack_require__(13218);

const JSONSerialiser = __webpack_require__(28219);
const elements = __webpack_require__(99829);

/**
 * @class
 *
 * A refract element implementation with an extensible namespace, able to
 * load other namespaces into it.
 *
 * The namespace allows you to register your own classes to be instantiated
 * when a particular refract element is encountered, and allows you to specify
 * which elements get instantiated for existing Javascript objects.
 */
class Namespace {
  constructor(options) {
    this.elementMap = {};
    this.elementDetection = [];
    this.Element = elements.Element;
    this.KeyValuePair = elements.KeyValuePair;

    if (!options || !options.noDefault) {
      this.useDefault();
    }

    // These provide the defaults for new elements.
    this._attributeElementKeys = [];
    this._attributeElementArrayKeys = [];
  }

  /**
   * Use a namespace plugin or load a generic plugin.
   *
   * @param plugin
   */
  use(plugin) {
    if (plugin.namespace) {
      plugin.namespace({ base: this });
    }
    if (plugin.load) {
      plugin.load({ base: this });
    }
    return this;
  }

  /*
   * Use the default namespace. This preloads all the default elements
   * into this registry instance.
   */
  useDefault() {
    // Set up classes for default elements
    this
      .register('null', elements.NullElement)
      .register('string', elements.StringElement)
      .register('number', elements.NumberElement)
      .register('boolean', elements.BooleanElement)
      .register('array', elements.ArrayElement)
      .register('object', elements.ObjectElement)
      .register('member', elements.MemberElement)
      .register('ref', elements.RefElement)
      .register('link', elements.LinkElement);

    // Add instance detection functions to convert existing objects into
    // the corresponding refract elements.
    this
      .detect(isNull, elements.NullElement, false)
      .detect(isString, elements.StringElement, false)
      .detect(isNumber, elements.NumberElement, false)
      .detect(isBoolean, elements.BooleanElement, false)
      .detect(Array.isArray, elements.ArrayElement, false)
      .detect(isObject, elements.ObjectElement, false);

    return this;
  }

  /**
   * Register a new element class for an element.
   *
   * @param {string} name
   * @param elementClass
   */
  register(name, ElementClass) {
    this._elements = undefined;
    this.elementMap[name] = ElementClass;
    return this;
  }

  /**
   * Unregister a previously registered class for an element.
   *
   * @param {string} name
   */
  unregister(name) {
    this._elements = undefined;
    delete this.elementMap[name];
    return this;
  }

  /*
   * Add a new detection function to determine which element
   * class to use when converting existing js instances into
   * refract element.
   */
  detect(test, ElementClass, givenPrepend) {
    const prepend = givenPrepend === undefined ? true : givenPrepend;

    if (prepend) {
      this.elementDetection.unshift([test, ElementClass]);
    } else {
      this.elementDetection.push([test, ElementClass]);
    }

    return this;
  }

  /*
   * Convert an existing Javascript object into refract element instances, which
   * can be further processed or serialized into refract.
   * If the item passed in is already refracted, then it is returned
   * unmodified.
   */
  toElement(value) {
    if (value instanceof this.Element) { return value; }

    let element;

    for (let i = 0; i < this.elementDetection.length; i += 1) {
      const test = this.elementDetection[i][0];
      const ElementClass = this.elementDetection[i][1];

      if (test(value)) {
        element = new ElementClass(value);
        break;
      }
    }

    return element;
  }

  /*
   * Get an element class given an element name.
   */
  getElementClass(element) {
    const ElementClass = this.elementMap[element];

    if (ElementClass === undefined) {
      // Fall back to the base element. We may not know what
      // to do with the `content`, but downstream software
      // may know.
      return this.Element;
    }

    return ElementClass;
  }

  /*
   * Convert a refract document into refract element instances.
   */
  fromRefract(doc) {
    return this.serialiser.deserialise(doc);
  }

  /*
   * Convert an element to a Refracted JSON object.
   */
  toRefract(element) {
    return this.serialiser.serialise(element);
  }

  /*
   * Get an object that contains all registered element classes, where
   * the key is the PascalCased element name and the value is the class.
   */
  get elements() {
    if (this._elements === undefined) {
      this._elements = {
        Element: this.Element,
      };

      Object.keys(this.elementMap).forEach((name) => {
        // Currently, all registered element types use a camelCaseName.
        // Converting to PascalCase is as simple as upper-casing the first
        // letter.
        const pascal = name[0].toUpperCase() + name.substr(1);
        this._elements[pascal] = this.elementMap[name];
      });
    }

    return this._elements;
  }

  /**
   * Convinience method for getting a JSON Serialiser configured with the
   * current namespace
   *
   * @type JSONSerialiser
   * @readonly
   *
   * @memberof Namespace.prototype
   */
  get serialiser() {
    return new JSONSerialiser(this);
  }
}

JSONSerialiser.prototype.Namespace = Namespace;

module.exports = Namespace;


/***/ }),

/***/ 87526:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(94885);
const ArraySlice = __webpack_require__(42566);

/**
 */
class ObjectSlice extends ArraySlice {
  map(callback, thisArg) {
    return this.elements.map(member => callback.bind(thisArg)(member.value, member.key, member));
  }

  filter(callback, thisArg) {
    return new ObjectSlice(this.elements.filter(member => callback.bind(thisArg)(member.value, member.key, member)));
  }

  reject(callback, thisArg) {
    return this.filter(negate(callback.bind(thisArg)));
  }

  forEach(callback, thisArg) {
    return this.elements.forEach((member, index) => { callback.bind(thisArg)(member.value, member.key, member, index); });
  }

  /**
   * @returns {array}
   */
  keys() {
    return this.map((value, key) => key.toValue());
  }

  /**
   * @returns {array}
   */
  values() {
    return this.map(value => value.toValue());
  }
}

module.exports = ObjectSlice;


/***/ }),

/***/ 99829:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(3079);
const NullElement = __webpack_require__(96295);
const StringElement = __webpack_require__(16036);
const NumberElement = __webpack_require__(91090);
const BooleanElement = __webpack_require__(18866);
const ArrayElement = __webpack_require__(35804);
const MemberElement = __webpack_require__(5946);
const ObjectElement = __webpack_require__(76735);
const LinkElement = __webpack_require__(59964);
const RefElement = __webpack_require__(38588);

const ArraySlice = __webpack_require__(42566);
const ObjectSlice = __webpack_require__(87526);

const KeyValuePair = __webpack_require__(17645);

/**
 * Refracts a JSON type to minim elements
 * @param value
 * @returns {Element}
 */
function refract(value) {
  if (value instanceof Element) {
    return value;
  }

  if (typeof value === 'string') {
    return new StringElement(value);
  }

  if (typeof value === 'number') {
    return new NumberElement(value);
  }

  if (typeof value === 'boolean') {
    return new BooleanElement(value);
  }

  if (value === null) {
    return new NullElement();
  }

  if (Array.isArray(value)) {
    return new ArrayElement(value.map(refract));
  }

  if (typeof value === 'object') {
    const element = new ObjectElement(value);
    return element;
  }

  return value;
}

Element.prototype.ObjectElement = ObjectElement;
Element.prototype.RefElement = RefElement;
Element.prototype.MemberElement = MemberElement;

Element.prototype.refract = refract;
ArraySlice.prototype.refract = refract;

/**
 * Contains all of the element classes, and related structures and methods
 * for handling with element instances.
 */
module.exports = {
  Element,
  NullElement,
  StringElement,
  NumberElement,
  BooleanElement,
  ArrayElement,
  MemberElement,
  ObjectElement,
  LinkElement,
  RefElement,

  refract,

  ArraySlice,
  ObjectSlice,
  KeyValuePair,
};


/***/ }),

/***/ 59964:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(3079);

/** Hyperlinking MAY be used to link to other resources, provide links to
 * instructions on how to process a given element (by way of a profile or
 * other means), and may be used to provide meta data about the element in
 * which it's found. The meaning and purpose of the hyperlink is defined by
 * the link relation according to RFC 5988.
 *
 * @class LinkElement
 *
 * @param content
 * @param meta
 * @param attributes
 */
module.exports = class LinkElement extends Element {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'link';
  }

  /**
   * The relation identifier for the link, as defined in RFC 5988.
   * @type StringElement
   */
  get relation() {
    return this.attributes.get('relation');
  }

  set relation(relation) {
    this.attributes.set('relation', relation);
  }

  /**
   * The URI for the given link.
   * @type StringElement
   */
  get href() {
    return this.attributes.get('href');
  }

  set href(href) {
    this.attributes.set('href', href);
  }
};


/***/ }),

/***/ 38588:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(3079);

/**
 * @class RefElement
 *
 * @param content
 * @param meta
 * @param attributes
 *
 * @extends Element
 */
module.exports = class RefElement extends Element {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'ref';

    if (!this.path) {
      this.path = 'element';
    }
  }

  /**
   * Path of referenced element to transclude instead of element itself.
   * @type StringElement
   * @default element
   */
  get path() {
    return this.attributes.get('path');
  }

  set path(newValue) {
    this.attributes.set('path', newValue);
  }
};


/***/ }),

/***/ 43500:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

const Namespace = __webpack_require__(78520);
const elements = __webpack_require__(99829);

// Direct access to the Namespace class
exports.Namespace = Namespace;

// Special constructor for the Namespace class
exports.namespace = function namespace(options) {
  return new Namespace(options);
};

exports.KeyValuePair = __webpack_require__(17645);

exports.ArraySlice = elements.ArraySlice;
exports.ObjectSlice = elements.ObjectSlice;

exports.Element = elements.Element;
exports.StringElement = elements.StringElement;
exports.NumberElement = elements.NumberElement;
exports.BooleanElement = elements.BooleanElement;
exports.NullElement = elements.NullElement;
exports.ArrayElement = elements.ArrayElement;
exports.ObjectElement = elements.ObjectElement;
exports.MemberElement = elements.MemberElement;
exports.RefElement = elements.RefElement;
exports.LinkElement = elements.LinkElement;

exports.refract = elements.refract;

exports.JSONSerialiser = __webpack_require__(28219);
exports.JSON06Serialiser = __webpack_require__(3414);


/***/ }),

/***/ 35804:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(94885);
const Element = __webpack_require__(3079);
const ArraySlice = __webpack_require__(42566);

/**
 * @class
 *
 * @param {Element[]} content
 * @param meta
 * @param attributes
 */
class ArrayElement extends Element {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'array';
  }

  primitive() {
    return 'array';
  }

  /**
   * @returns {Element}
   */
  get(index) {
    return this.content[index];
  }

  /**
   * Helper for returning the value of an item
   * This works for both ArrayElement and ObjectElement instances
   */
  getValue(indexOrKey) {
    const item = this.get(indexOrKey);

    if (item) {
      return item.toValue();
    }

    return undefined;
  }

  /**
   * @returns {Element}
   */
  getIndex(index) {
    return this.content[index];
  }

  set(index, value) {
    this.content[index] = this.refract(value);
    return this;
  }

  remove(index) {
    const removed = this.content.splice(index, 1);

    if (removed.length) {
      return removed[0];
    }

    return null;
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   */
  map(callback, thisArg) {
    return this.content.map(callback, thisArg);
  }

  /**
   * Maps and then flattens the results.
   * @param callback - Function to execute for each element.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {array}
   */
  flatMap(callback, thisArg) {
    return this
      .map(callback, thisArg)
      .reduce((a, b) => a.concat(b), []);
  }

  /**
   * Returns an array containing the truthy results of calling the given transformation with each element of this sequence
   * @param transform - A closure that accepts an element of this array as its argument and returns an optional value.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArrayElement.prototype
   * @returns An array of the non-undefined results of calling transform with each element of the array
   */
  compactMap(transform, thisArg) {
    const results = [];

    this.forEach((element) => {
      const result = transform.bind(thisArg)(element);

      if (result) {
        results.push(result);
      }
    });

    return results;
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   */
  filter(callback, thisArg) {
    return new ArraySlice(this.content.filter(callback, thisArg));
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   */
  reject(callback, thisArg) {
    return this.filter(negate(callback), thisArg);
  }

  /**
   * This is a reduce function specifically for Minim arrays and objects. It
   * allows for returning normal values or Minim instances, so it converts any
   * primitives on each step.
   */
  reduce(callback, initialValue) {
    let startIndex;
    let memo;

    // Allows for defining a starting value of the reduce
    if (initialValue !== undefined) {
      startIndex = 0;
      memo = this.refract(initialValue);
    } else {
      startIndex = 1;
      // Object Element content items are member elements. Because of this,
      // the memo should start out as the member value rather than the
      // actual member itself.
      memo = this.primitive() === 'object' ? this.first.value : this.first;
    }

    // Sending each function call to the registry allows for passing Minim
    // instances through the function return. This means you can return
    // primitive values or return Minim instances and reduce will still work.
    for (let i = startIndex; i < this.length; i += 1) {
      const item = this.content[i];

      if (this.primitive() === 'object') {
        memo = this.refract(callback(memo, item.value, item.key, item, this));
      } else {
        memo = this.refract(callback(memo, item, i, this));
      }
    }

    return memo;
  }

  /**
   * @callback forEachCallback
   * @param {Element} currentValue
   * @param {NumberElement} index
   */

  /**
   * @param {forEachCallback} callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArrayElement.prototype
   */
  forEach(callback, thisArg) {
    this.content.forEach((item, index) => {
      callback.bind(thisArg)(item, this.refract(index));
    });
  }

  /**
   * @returns {Element}
   */
  shift() {
    return this.content.shift();
  }

  /**
   * @param value
   */
  unshift(value) {
    this.content.unshift(this.refract(value));
  }

  /**
   * @param value
   */
  push(value) {
    this.content.push(this.refract(value));
    return this;
  }

  /**
   * @param value
   */
  add(value) {
    this.push(value);
  }

  /**
   * Recusively search all descendents using a condition function.
   * @returns {Element[]}
   */
  findElements(condition, givenOptions) {
    const options = givenOptions || {};
    const recursive = !!options.recursive;
    const results = options.results === undefined ? [] : options.results;

    // The forEach method for Object Elements returns value, key, and member.
    // This passes those along to the condition function below.
    this.forEach((item, keyOrIndex, member) => {
      // We use duck-typing here to support any registered class that
      // may contain other elements.
      if (recursive && (item.findElements !== undefined)) {
        item.findElements(condition, {
          results,
          recursive,
        });
      }

      if (condition(item, keyOrIndex, member)) {
        results.push(item);
      }
    });

    return results;
  }

  /**
   * Recusively search all descendents using a condition function.
   * @param condition
   * @returns {ArraySlice}
   */
  find(condition) {
    return new ArraySlice(this.findElements(condition, { recursive: true }));
  }

  /**
   * @param {string} element
   * @returns {ArraySlice}
   */
  findByElement(element) {
    return this.find(item => item.element === element);
  }

  /**
   * @param {string} className
   * @returns {ArraySlice}
   * @memberof ArrayElement.prototype
   */
  findByClass(className) {
    return this.find(item => item.classes.includes(className));
  }

  /**
   * Search the tree recursively and find the element with the matching ID
   * @param {string} id
   * @returns {Element}
   * @memberof ArrayElement.prototype
   */
  getById(id) {
    return this.find(item => item.id.toValue() === id).first;
  }

  /**
   * Looks for matching children using deep equality
   * @param value
   * @returns {boolean}
   */
  includes(value) {
    return this.content.some(element => element.equals(value));
  }

  /**
   * Looks for matching children using deep equality
   * @param value
   * @returns {boolean}
   * @see includes
   * @deprecated method was replaced by includes
   */
  contains(value) {
    return this.includes(value);
  }

  // Fantasy Land

  /**
   * @returns {ArrayElement} An empty array element
   */
  empty() {
    return new this.constructor([]);
  }

  ['fantasy-land/empty']() {
    return this.empty();
  }

  /**
   * @param {ArrayElement} other
   * @returns {ArrayElement}
   */
  concat(other) {
    return new this.constructor(this.content.concat(other.content));
  }

  ['fantasy-land/concat'](other) {
    return this.concat(other);
  }

  ['fantasy-land/map'](transform) {
    return new this.constructor(this.map(transform));
  }

  ['fantasy-land/chain'](transform) {
    return this
      .map(element => transform(element), this)
      .reduce((a, b) => a.concat(b), this.empty());
  }

  ['fantasy-land/filter'](callback) {
    return new this.constructor(this.content.filter(callback));
  }

  ['fantasy-land/reduce'](transform, initialValue) {
    return this.content.reduce(transform, initialValue);
  }

  /**
   * Returns the length of the collection
   * @type number
   */
  get length() {
    return this.content.length;
  }

  /**
   * Returns whether the collection is empty
   * @type boolean
   */
  get isEmpty() {
    return this.content.length === 0;
  }

  /**
   * Return the first item in the collection
   * @type Element
   */
  get first() {
    return this.getIndex(0);
  }

  /**
   * Return the second item in the collection
   * @type Element
   */
  get second() {
    return this.getIndex(1);
  }

  /**
   * Return the last item in the collection
   * @type Element
   */
  get last() {
    return this.getIndex(this.length - 1);
  }
}

/**
 * @returns {ArrayElement} An empty array element
 */
ArrayElement.empty = function empty() {
  return new this();
};

ArrayElement['fantasy-land/empty'] = ArrayElement.empty;

if (typeof Symbol !== 'undefined') {
  ArrayElement.prototype[Symbol.iterator] = function symbol() {
    return this.content[Symbol.iterator]();
  };
}

module.exports = ArrayElement;


/***/ }),

/***/ 18866:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(3079);

/**
 * @class BooleanElement
 *
 * @param {boolean} content
 * @param meta
 * @param attributes
 */
module.exports = class BooleanElement extends Element {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'boolean';
  }

  primitive() {
    return 'boolean';
  }
};


/***/ }),

/***/ 3079:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const isEqual = __webpack_require__(18446);
const KeyValuePair = __webpack_require__(17645);
const ArraySlice = __webpack_require__(42566);

/**
 * @class
 *
 * @param content
 * @param meta
 * @param attributes
 *
 * @property {string} element
 */
class Element {
  constructor(content, meta, attributes) {
    // Lazy load this.meta and this.attributes because it's a Minim element
    // Otherwise, we get into circuluar calls
    if (meta) {
      this.meta = meta;
    }

    if (attributes) {
      this.attributes = attributes;
    }

    this.content = content;
  }

  /**
   * Freezes the element to prevent any mutation.
   * A frozen element will add `parent` property to every child element
   * to allow traversing up the element tree.
   */
  freeze() {
    if (Object.isFrozen(this)) {
      return;
    }

    if (this._meta) {
      this.meta.parent = this;
      this.meta.freeze();
    }

    if (this._attributes) {
      this.attributes.parent = this;
      this.attributes.freeze();
    }

    this.children.forEach((element) => {
      element.parent = this;
      element.freeze();
    }, this);

    if (this.content && Array.isArray(this.content)) {
      Object.freeze(this.content);
    }

    Object.freeze(this);
  }

  primitive() {

  }

  /**
   * Creates a deep clone of the instance
   */
  clone() {
    const copy = new this.constructor();

    copy.element = this.element;

    if (this.meta.length) {
      copy._meta = this.meta.clone();
    }

    if (this.attributes.length) {
      copy._attributes = this.attributes.clone();
    }

    if (this.content) {
      if (this.content.clone) {
        copy.content = this.content.clone();
      } else if (Array.isArray(this.content)) {
        copy.content = this.content.map(element => element.clone());
      } else {
        copy.content = this.content;
      }
    } else {
      copy.content = this.content;
    }

    return copy;
  }

  /**
   */
  toValue() {
    if (this.content instanceof Element) {
      return this.content.toValue();
    }

    if (this.content instanceof KeyValuePair) {
      return {
        key: this.content.key.toValue(),
        value: this.content.value ? this.content.value.toValue() : undefined,
      };
    }

    if (this.content && this.content.map) {
      return this.content.map(element => element.toValue(), this);
    }

    return this.content;
  }

  /**
   * Creates a reference pointing at the Element
   * @returns {RefElement}
   * @memberof Element.prototype
   */
  toRef(path) {
    if (this.id.toValue() === '') {
      throw Error('Cannot create reference to an element that does not contain an ID');
    }

    const ref = new this.RefElement(this.id.toValue());

    if (path) {
      ref.path = path;
    }

    return ref;
  }

  /**
   * Finds the given elements in the element tree.
   * When providing multiple element names, you must first freeze the element.
   *
   * @param names {...elementNames}
   * @returns {ArraySlice}
   */
  findRecursive(...elementNames) {
    if (arguments.length > 1 && !this.isFrozen) {
      throw new Error('Cannot find recursive with multiple element names without first freezing the element. Call `element.freeze()`');
    }

    const elementName = elementNames.pop();
    let elements = new ArraySlice();

    const append = (array, element) => {
      array.push(element);
      return array;
    };

    // Checks the given element and appends element/sub-elements
    // that match element name to given array
    const checkElement = (array, element) => {
      if (element.element === elementName) {
        array.push(element);
      }

      const items = element.findRecursive(elementName);
      if (items) {
        items.reduce(append, array);
      }

      if (element.content instanceof KeyValuePair) {
        if (element.content.key) {
          checkElement(array, element.content.key);
        }

        if (element.content.value) {
          checkElement(array, element.content.value);
        }
      }

      return array;
    };

    if (this.content) {
      // Direct Element
      if (this.content.element) {
        checkElement(elements, this.content);
      }

      // Element Array
      if (Array.isArray(this.content)) {
        this.content.reduce(checkElement, elements);
      }
    }

    if (!elementNames.isEmpty) {
      elements = elements.filter((element) => {
        let parentElements = element.parents.map(e => e.element);

        // eslint-disable-next-line no-restricted-syntax
        for (const namesIndex in elementNames) {
          const name = elementNames[namesIndex];
          const index = parentElements.indexOf(name);

          if (index !== -1) {
            parentElements = parentElements.splice(0, index);
          } else {
            return false;
          }
        }

        return true;
      });
    }

    return elements;
  }

  set(content) {
    this.content = content;
    return this;
  }

  equals(value) {
    return isEqual(this.toValue(), value);
  }

  getMetaProperty(name, value) {
    if (!this.meta.hasKey(name)) {
      if (this.isFrozen) {
        const element = this.refract(value);
        element.freeze();
        return element;
      }

      this.meta.set(name, value);
    }

    return this.meta.get(name);
  }

  setMetaProperty(name, value) {
    this.meta.set(name, value);
  }

  /**
   * @type String
   */
  get element() {
    // Returns 'element' so we don't have undefined as element
    return this._storedElement || 'element';
  }

  set element(element) {
    this._storedElement = element;
  }

  get content() {
    return this._content;
  }

  set content(value) {
    if (value instanceof Element) {
      this._content = value;
    } else if (value instanceof ArraySlice) {
      this.content = value.elements;
    } else if (
      typeof value == 'string'
      || typeof value == 'number'
      || typeof value == 'boolean'
      || value === 'null'
      || value == undefined
    ) {
      // Primitive Values
      this._content = value;
    } else if (value instanceof KeyValuePair) {
      this._content = value;
    } else if (Array.isArray(value)) {
      this._content = value.map(this.refract);
    } else if (typeof value === 'object') {
      this._content = Object.keys(value).map(key => new this.MemberElement(key, value[key]));
    } else {
      throw new Error('Cannot set content to given value');
    }
  }

  /**
   * @type ObjectElement
   */
  get meta() {
    if (!this._meta) {
      if (this.isFrozen) {
        const meta = new this.ObjectElement();
        meta.freeze();
        return meta;
      }

      this._meta = new this.ObjectElement();
    }

    return this._meta;
  }

  set meta(value) {
    if (value instanceof this.ObjectElement) {
      this._meta = value;
    } else {
      this.meta.set(value || {});
    }
  }

  /**
   * The attributes property defines attributes about the given instance
   * of the element, as specified by the element property.
   *
   * @type ObjectElement
   */
  get attributes() {
    if (!this._attributes) {
      if (this.isFrozen) {
        const meta = new this.ObjectElement();
        meta.freeze();
        return meta;
      }

      this._attributes = new this.ObjectElement();
    }

    return this._attributes;
  }

  set attributes(value) {
    if (value instanceof this.ObjectElement) {
      this._attributes = value;
    } else {
      this.attributes.set(value || {});
    }
  }

  /**
   * Unique Identifier, MUST be unique throughout an entire element tree.
   * @type StringElement
   */
  get id() {
    return this.getMetaProperty('id', '');
  }

  set id(element) {
    this.setMetaProperty('id', element);
  }

  /**
   * @type ArrayElement
   */
  get classes() {
    return this.getMetaProperty('classes', []);
  }

  set classes(element) {
    this.setMetaProperty('classes', element);
  }

  /**
   * Human-readable title of element
   * @type StringElement
   */
  get title() {
    return this.getMetaProperty('title', '');
  }

  set title(element) {
    this.setMetaProperty('title', element);
  }

  /**
   * Human-readable description of element
   * @type StringElement
   */
  get description() {
    return this.getMetaProperty('description', '');
  }

  set description(element) {
    this.setMetaProperty('description', element);
  }

  /**
   * @type ArrayElement
   */
  get links() {
    return this.getMetaProperty('links', []);
  }

  set links(element) {
    this.setMetaProperty('links', element);
  }

  /**
   * Returns whether the element is frozen.
   * @type boolean
   * @see freeze
   */
  get isFrozen() {
    return Object.isFrozen(this);
  }

  /**
   * Returns all of the parent elements.
   * @type ArraySlice
   */
  get parents() {
    let { parent } = this;
    const parents = new ArraySlice();

    while (parent) {
      parents.push(parent);

      // eslint-disable-next-line prefer-destructuring
      parent = parent.parent;
    }

    return parents;
  }

  /**
   * Returns all of the children elements found within the element.
   * @type ArraySlice
   * @see recursiveChildren
   */
  get children() {
    if (Array.isArray(this.content)) {
      return new ArraySlice(this.content);
    }

    if (this.content instanceof KeyValuePair) {
      const children = new ArraySlice([this.content.key]);

      if (this.content.value) {
        children.push(this.content.value);
      }

      return children;
    }

    if (this.content instanceof Element) {
      return new ArraySlice([this.content]);
    }

    return new ArraySlice();
  }

  /**
  * Returns all of the children elements found within the element recursively.
  * @type ArraySlice
  * @see children
  */
  get recursiveChildren() {
    const children = new ArraySlice();

    this.children.forEach((element) => {
      children.push(element);

      element.recursiveChildren.forEach((child) => {
        children.push(child);
      });
    });

    return children;
  }
}

module.exports = Element;


/***/ }),

/***/ 5946:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const KeyValuePair = __webpack_require__(17645);
const Element = __webpack_require__(3079);

/**
 * @class MemberElement
 *
 * @param {Element} key
 * @param {Element} value
 * @param meta
 * @param attributes
 */
module.exports = class MemberElement extends Element {
  constructor(key, value, meta, attributes) {
    super(new KeyValuePair(), meta, attributes);

    this.element = 'member';
    this.key = key;
    this.value = value;
  }

  /**
   * @type Element
   */
  get key() {
    return this.content.key;
  }

  set key(key) {
    this.content.key = this.refract(key);
  }

  /**
   * @type Element
   */
  get value() {
    return this.content.value;
  }

  set value(value) {
    this.content.value = this.refract(value);
  }
};


/***/ }),

/***/ 96295:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(3079);

/**
 */
class NullElement extends Element {
  constructor(content, meta, attributes) {
    super(content || null, meta, attributes);
    this.element = 'null';
  }

  primitive() {
    return 'null';
  }

  set() {
    return new Error('Cannot set the value of null');
  }
}

module.exports = NullElement;


/***/ }),

/***/ 91090:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(3079);

/**
 * @class NumberElement
 *
 * @param {number} content
 * @param meta
 * @param attributes
 */
module.exports = class NumberElement extends Element {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'number';
  }

  primitive() {
    return 'number';
  }
};


/***/ }),

/***/ 76735:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(94885);
const isObject = __webpack_require__(13218);

const ArrayElement = __webpack_require__(35804);
const MemberElement = __webpack_require__(5946);
const ObjectSlice = __webpack_require__(87526);

/**
 * @class
 *
 * @param content
 * @param meta
 * @param attributes
 */
class ObjectElement extends ArrayElement {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'object';
  }

  primitive() {
    return 'object';
  }

  toValue() {
    return this.content.reduce((results, el) => {
      results[el.key.toValue()] = el.value ? el.value.toValue() : undefined;
      return results;
    }, {});
  }

  /**
   * @param key
   * @returns {Element}
   */
  get(name) {
    const member = this.getMember(name);

    if (member) {
      return member.value;
    }

    return undefined;
  }

  /**
   * @param key
   * @returns {MemberElement}
   */
  getMember(name) {
    if (name === undefined) { return undefined; }

    return this.content.find(element => element.key.toValue() === name);
  }

  /**
   * @param key
   */
  remove(name) {
    let removed = null;

    this.content = this.content.filter((item) => {
      if (item.key.toValue() === name) {
        removed = item;
        return false;
      }

      return true;
    });

    return removed;
  }

  /**
   * @param key
   * @returns {Element}
   */
  getKey(name) {
    const member = this.getMember(name);

    if (member) {
      return member.key;
    }

    return undefined;
  }

  /**
   * Set allows either a key/value pair to be given or an object
   * If an object is given, each key is set to its respective value
   */
  set(keyOrObject, value) {
    if (isObject(keyOrObject)) {
      Object.keys(keyOrObject).forEach((objectKey) => {
        this.set(objectKey, keyOrObject[objectKey]);
      });

      return this;
    }

    // Store as key for clarity
    const key = keyOrObject;
    const member = this.getMember(key);

    if (member) {
      member.value = value;
    } else {
      this.content.push(new MemberElement(key, value));
    }

    return this;
  }

  /**
   */
  keys() {
    return this.content.map(item => item.key.toValue());
  }

  /**
   */
  values() {
    return this.content.map(item => item.value.toValue());
  }

  /**
   * @returns {boolean}
   */
  hasKey(value) {
    return this.content.some(member => member.key.equals(value));
  }

  /**
   * @returns {array}
   */
  items() {
    return this.content.map(item => [item.key.toValue(), item.value.toValue()]);
  }

  /**
   * @param callback
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   */
  map(callback, thisArg) {
    return this.content.map(item => callback.bind(thisArg)(item.value, item.key, item));
  }

  /**
   * Returns an array containing the truthy results of calling the given transformation with each element of this sequence
   * @param transform - A closure that accepts the value, key and member element of this object as its argument and returns an optional value.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns An array of the non-undefined results of calling transform with each element of the array
   */
  compactMap(callback, thisArg) {
    const results = [];

    this.forEach((value, key, member) => {
      const result = callback.bind(thisArg)(value, key, member);

      if (result) {
        results.push(result);
      }
    });

    return results;
  }

  /**
   * @param callback
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   *
   * @returns {ObjectSlice}
   */
  filter(callback, thisArg) {
    return new ObjectSlice(this.content).filter(callback, thisArg);
  }

  /**
   * @param callback
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   *
   * @returns {ObjectSlice}
   *
   * @memberof ObjectElement.prototype
   */
  reject(callback, thisArg) {
    return this.filter(negate(callback), thisArg);
  }

  /**
   * @param callback
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   *
   * @memberof ObjectElement.prototype
   */
  forEach(callback, thisArg) {
    return this.content.forEach(item => callback.bind(thisArg)(item.value, item.key, item));
  }
}

module.exports = ObjectElement;


/***/ }),

/***/ 16036:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(3079);

/**
 * @class StringElement
 *
 * @param {string} content
 * @param meta
 * @param attributes
 */
module.exports = class StringElement extends Element {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'string';
  }

  primitive() {
    return 'string';
  }

  /**
   * The length of the string.
   * @type number
   */
  get length() {
    return this.content.length;
  }
};


/***/ }),

/***/ 3414:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const JSONSerialiser = __webpack_require__(28219);

module.exports = class JSON06Serialiser extends JSONSerialiser {
  serialise(element) {
    if (!(element instanceof this.namespace.elements.Element)) {
      throw new TypeError(`Given element \`${element}\` is not an Element instance`);
    }

    let variable;
    if (element._attributes && element.attributes.get('variable')) {
      variable = element.attributes.get('variable');
    }

    const payload = {
      element: element.element,
    };

    if (element._meta && element._meta.length > 0) {
      payload.meta = this.serialiseObject(element.meta);
    }

    const isEnum = (element.element === 'enum' || element.attributes.keys().indexOf('enumerations') !== -1);

    if (isEnum) {
      const attributes = this.enumSerialiseAttributes(element);

      if (attributes) {
        payload.attributes = attributes;
      }
    } else if (element._attributes && element._attributes.length > 0) {
      let { attributes } = element;

      // Meta attribute was renamed to metadata
      if (attributes.get('metadata')) {
        attributes = attributes.clone();
        attributes.set('meta', attributes.get('metadata'));
        attributes.remove('metadata');
      }

      if (element.element === 'member' && variable) {
        attributes = attributes.clone();
        attributes.remove('variable');
      }

      if (attributes.length > 0) {
        payload.attributes = this.serialiseObject(attributes);
      }
    }

    if (isEnum) {
      payload.content = this.enumSerialiseContent(element, payload);
    } else if (this[`${element.element}SerialiseContent`]) {
      payload.content = this[`${element.element}SerialiseContent`](element, payload);
    } else if (element.content !== undefined) {
      let content;

      if (variable && element.content.key) {
        content = element.content.clone();
        content.key.attributes.set('variable', variable);
        content = this.serialiseContent(content);
      } else {
        content = this.serialiseContent(element.content);
      }

      if (this.shouldSerialiseContent(element, content)) {
        payload.content = content;
      }
    } else if (this.shouldSerialiseContent(element, element.content) && element instanceof this.namespace.elements.Array) {
      payload.content = [];
    }

    return payload;
  }

  shouldSerialiseContent(element, content) {
    if (element.element === 'parseResult' || element.element === 'httpRequest'
        || element.element === 'httpResponse' || element.element === 'category'
        || element.element === 'link') {
      return true;
    }

    if (content === undefined) {
      return false;
    }

    if (Array.isArray(content) && content.length === 0) {
      return false;
    }

    return true;
  }

  refSerialiseContent(element, payload) {
    delete payload.attributes;

    return {
      href: element.toValue(),
      path: element.path.toValue(),
    };
  }

  sourceMapSerialiseContent(element) {
    return element.toValue();
  }

  dataStructureSerialiseContent(element) {
    return [this.serialiseContent(element.content)];
  }

  enumSerialiseAttributes(element) {
    const attributes = element.attributes.clone();

    // Enumerations attribute was is placed inside content (see `enumSerialiseContent` below)
    const enumerations = attributes.remove('enumerations') || new this.namespace.elements.Array([]);

    // Remove fixed type attribute from samples and default
    const defaultValue = attributes.get('default');
    let samples = attributes.get('samples') || new this.namespace.elements.Array([]);

    if (defaultValue && defaultValue.content) {
      if (defaultValue.content.attributes) {
        defaultValue.content.attributes.remove('typeAttributes');
      }
      // Wrap default in array (not sure it is really needed because tests pass without this line)
      attributes.set('default', new this.namespace.elements.Array([defaultValue.content]));
    }

    // Strip typeAttributes from samples, 0.6 doesn't usually contain them in samples
    samples.forEach((sample) => {
      if (sample.content && sample.content.element) {
        sample.content.attributes.remove('typeAttributes');
      }
    });

    // Content -> Samples
    if (element.content && enumerations.length !== 0) {
      // If we don't have enumerations, content should stay in
      // content (enumerations) as per Drafter 3 behaviour.
      samples.unshift(element.content);
    }

    samples = samples.map((sample) => {
      if (sample instanceof this.namespace.elements.Array) {
        return [sample];
      }

      return new this.namespace.elements.Array([sample.content]);
    });

    if (samples.length) {
      attributes.set('samples', samples);
    }

    if (attributes.length > 0) {
      return this.serialiseObject(attributes);
    }

    return undefined;
  }

  enumSerialiseContent(element) {
    // In API Elements < 1.0, the content is the enumerations
    // If we don't have an enumerations, use the value (Drafter 3 behaviour)

    if (element._attributes) {
      const enumerations = element.attributes.get('enumerations');

      if (enumerations && enumerations.length > 0) {
        return enumerations.content.map((enumeration) => {
          const e = enumeration.clone();
          e.attributes.remove('typeAttributes');
          return this.serialise(e);
        });
      }
    }

    if (element.content) {
      const value = element.content.clone();
      value.attributes.remove('typeAttributes');
      return [this.serialise(value)];
    }

    return [];
  }

  deserialise(value) {
    if (typeof value === 'string') {
      return new this.namespace.elements.String(value);
    }

    if (typeof value === 'number') {
      return new this.namespace.elements.Number(value);
    }

    if (typeof value === 'boolean') {
      return new this.namespace.elements.Boolean(value);
    }

    if (value === null) {
      return new this.namespace.elements.Null();
    }

    if (Array.isArray(value)) {
      return new this.namespace.elements.Array(value.map(this.deserialise, this));
    }

    const ElementClass = this.namespace.getElementClass(value.element);
    const element = new ElementClass();

    if (element.element !== value.element) {
      element.element = value.element;
    }

    if (value.meta) {
      this.deserialiseObject(value.meta, element.meta);
    }

    if (value.attributes) {
      this.deserialiseObject(value.attributes, element.attributes);
    }

    const content = this.deserialiseContent(value.content);
    if (content !== undefined || element.content === null) {
      element.content = content;
    }

    if (element.element === 'enum') {
      // Grab enumerations from content
      if (element.content) {
        element.attributes.set('enumerations', element.content);
      }

      // Unwrap the sample value (inside double array)
      let samples = element.attributes.get('samples');
      element.attributes.remove('samples');

      if (samples) {
        // Re-wrap samples from array of array to array of enum's

        const existingSamples = samples;

        samples = new this.namespace.elements.Array();
        existingSamples.forEach((existingSample) => {
          existingSample.forEach((sample) => {
            const enumElement = new ElementClass(sample);
            enumElement.element = element.element;
            samples.push(enumElement);
          });
        });

        const sample = samples.shift();

        if (sample) {
          element.content = sample.content;
        } else {
          element.content = undefined;
        }

        element.attributes.set('samples', samples);
      } else {
        element.content = undefined;
      }

      // Unwrap the default value
      let defaultValue = element.attributes.get('default');
      if (defaultValue && defaultValue.length > 0) {
        defaultValue = defaultValue.get(0);
        const defaultElement = new ElementClass(defaultValue);
        defaultElement.element = element.element;
        element.attributes.set('default', defaultElement);
      }
    } else if (element.element === 'dataStructure' && Array.isArray(element.content)) {
      [element.content] = element.content;
    } else if (element.element === 'category') {
      // "meta" attribute has been renamed to metadata
      const metadata = element.attributes.get('meta');

      if (metadata) {
        element.attributes.set('metadata', metadata);
        element.attributes.remove('meta');
      }
    } else if (element.element === 'member' && element.key && element.key._attributes && element.key._attributes.getValue('variable')) {
      element.attributes.set('variable', element.key.attributes.get('variable'));
      element.key.attributes.remove('variable');
    }

    return element;
  }

  // Private API

  serialiseContent(content) {
    if (content instanceof this.namespace.elements.Element) {
      return this.serialise(content);
    }

    if (content instanceof this.namespace.KeyValuePair) {
      const pair = {
        key: this.serialise(content.key),
      };

      if (content.value) {
        pair.value = this.serialise(content.value);
      }

      return pair;
    }

    if (content && content.map) {
      return content.map(this.serialise, this);
    }

    return content;
  }

  deserialiseContent(content) {
    if (content) {
      if (content.element) {
        return this.deserialise(content);
      }

      if (content.key) {
        const pair = new this.namespace.KeyValuePair(this.deserialise(content.key));

        if (content.value) {
          pair.value = this.deserialise(content.value);
        }

        return pair;
      }

      if (content.map) {
        return content.map(this.deserialise, this);
      }
    }

    return content;
  }

  shouldRefract(element) {
    if ((element._attributes && element.attributes.keys().length) || (element._meta && element.meta.keys().length)) {
      return true;
    }

    if (element.element === 'enum') {
      // enum elements are treated like primitives (array)
      return false;
    }

    if (element.element !== element.primitive() || element.element === 'member') {
      return true;
    }

    return false;
  }

  convertKeyToRefract(key, item) {
    if (this.shouldRefract(item)) {
      return this.serialise(item);
    }

    if (item.element === 'enum') {
      return this.serialiseEnum(item);
    }

    if (item.element === 'array') {
      return item.map((subItem) => {
        if (this.shouldRefract(subItem) || key === 'default') {
          return this.serialise(subItem);
        }

        if (subItem.element === 'array' || subItem.element === 'object' || subItem.element === 'enum') {
          // items for array or enum inside array are always serialised
          return subItem.children.map(subSubItem => this.serialise(subSubItem));
        }

        return subItem.toValue();
      });
    }

    if (item.element === 'object') {
      return (item.content || []).map(this.serialise, this);
    }

    return item.toValue();
  }

  serialiseEnum(element) {
    return element.children.map(item => this.serialise(item));
  }

  serialiseObject(obj) {
    const result = {};

    obj.forEach((value, key) => {
      if (value) {
        const keyValue = key.toValue();
        result[keyValue] = this.convertKeyToRefract(keyValue, value);
      }
    });

    return result;
  }

  deserialiseObject(from, to) {
    Object.keys(from).forEach((key) => {
      to.set(key, this.deserialise(from[key]));
    });
  }
};


/***/ }),

/***/ 28219:
/***/ ((module) => {

/**
 * @class JSONSerialiser
 *
 * @param {Namespace} namespace
 *
 * @property {Namespace} namespace
 */
class JSONSerialiser {
  constructor(namespace) {
    this.namespace = namespace || new this.Namespace();
  }

  /**
   * @param {Element} element
   * @returns {object}
   */
  serialise(element) {
    if (!(element instanceof this.namespace.elements.Element)) {
      throw new TypeError(`Given element \`${element}\` is not an Element instance`);
    }

    const payload = {
      element: element.element,
    };

    if (element._meta && element._meta.length > 0) {
      payload.meta = this.serialiseObject(element.meta);
    }

    if (element._attributes && element._attributes.length > 0) {
      payload.attributes = this.serialiseObject(element.attributes);
    }

    const content = this.serialiseContent(element.content);

    if (content !== undefined) {
      payload.content = content;
    }

    return payload;
  }

  /**
   * @param {object} value
   * @returns {Element}
   */
  deserialise(value) {
    if (!value.element) {
      throw new Error('Given value is not an object containing an element name');
    }

    const ElementClass = this.namespace.getElementClass(value.element);
    const element = new ElementClass();

    if (element.element !== value.element) {
      element.element = value.element;
    }

    if (value.meta) {
      this.deserialiseObject(value.meta, element.meta);
    }

    if (value.attributes) {
      this.deserialiseObject(value.attributes, element.attributes);
    }

    const content = this.deserialiseContent(value.content);
    if (content !== undefined || element.content === null) {
      element.content = content;
    }

    return element;
  }

  // Private API

  serialiseContent(content) {
    if (content instanceof this.namespace.elements.Element) {
      return this.serialise(content);
    }

    if (content instanceof this.namespace.KeyValuePair) {
      const pair = {
        key: this.serialise(content.key),
      };

      if (content.value) {
        pair.value = this.serialise(content.value);
      }

      return pair;
    }

    if (content && content.map) {
      if (content.length === 0) {
        return undefined;
      }

      return content.map(this.serialise, this);
    }

    return content;
  }

  deserialiseContent(content) {
    if (content) {
      if (content.element) {
        return this.deserialise(content);
      }

      if (content.key) {
        const pair = new this.namespace.KeyValuePair(this.deserialise(content.key));

        if (content.value) {
          pair.value = this.deserialise(content.value);
        }

        return pair;
      }

      if (content.map) {
        return content.map(this.deserialise, this);
      }
    }

    return content;
  }

  serialiseObject(obj) {
    const result = {};

    obj.forEach((value, key) => {
      if (value) {
        result[key.toValue()] = this.serialise(value);
      }
    });

    if (Object.keys(result).length === 0) {
      return undefined;
    }

    return result;
  }

  deserialiseObject(from, to) {
    Object.keys(from).forEach((key) => {
      to.set(key, this.deserialise(from[key]));
    });
  }
}


module.exports = JSONSerialiser;


/***/ }),

/***/ 70631:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var hasMap = typeof Map === 'function' && Map.prototype;
var mapSizeDescriptor = Object.getOwnPropertyDescriptor && hasMap ? Object.getOwnPropertyDescriptor(Map.prototype, 'size') : null;
var mapSize = hasMap && mapSizeDescriptor && typeof mapSizeDescriptor.get === 'function' ? mapSizeDescriptor.get : null;
var mapForEach = hasMap && Map.prototype.forEach;
var hasSet = typeof Set === 'function' && Set.prototype;
var setSizeDescriptor = Object.getOwnPropertyDescriptor && hasSet ? Object.getOwnPropertyDescriptor(Set.prototype, 'size') : null;
var setSize = hasSet && setSizeDescriptor && typeof setSizeDescriptor.get === 'function' ? setSizeDescriptor.get : null;
var setForEach = hasSet && Set.prototype.forEach;
var hasWeakMap = typeof WeakMap === 'function' && WeakMap.prototype;
var weakMapHas = hasWeakMap ? WeakMap.prototype.has : null;
var hasWeakSet = typeof WeakSet === 'function' && WeakSet.prototype;
var weakSetHas = hasWeakSet ? WeakSet.prototype.has : null;
var hasWeakRef = typeof WeakRef === 'function' && WeakRef.prototype;
var weakRefDeref = hasWeakRef ? WeakRef.prototype.deref : null;
var booleanValueOf = Boolean.prototype.valueOf;
var objectToString = Object.prototype.toString;
var functionToString = Function.prototype.toString;
var $match = String.prototype.match;
var $slice = String.prototype.slice;
var $replace = String.prototype.replace;
var $toUpperCase = String.prototype.toUpperCase;
var $toLowerCase = String.prototype.toLowerCase;
var $test = RegExp.prototype.test;
var $concat = Array.prototype.concat;
var $join = Array.prototype.join;
var $arrSlice = Array.prototype.slice;
var $floor = Math.floor;
var bigIntValueOf = typeof BigInt === 'function' ? BigInt.prototype.valueOf : null;
var gOPS = Object.getOwnPropertySymbols;
var symToString = typeof Symbol === 'function' && typeof Symbol.iterator === 'symbol' ? Symbol.prototype.toString : null;
var hasShammedSymbols = typeof Symbol === 'function' && typeof Symbol.iterator === 'object';
// ie, `has-tostringtag/shams
var toStringTag = typeof Symbol === 'function' && Symbol.toStringTag && (typeof Symbol.toStringTag === hasShammedSymbols ? 'object' : 'symbol')
    ? Symbol.toStringTag
    : null;
var isEnumerable = Object.prototype.propertyIsEnumerable;

var gPO = (typeof Reflect === 'function' ? Reflect.getPrototypeOf : Object.getPrototypeOf) || (
    [].__proto__ === Array.prototype // eslint-disable-line no-proto
        ? function (O) {
            return O.__proto__; // eslint-disable-line no-proto
        }
        : null
);

function addNumericSeparator(num, str) {
    if (
        num === Infinity
        || num === -Infinity
        || num !== num
        || (num && num > -1000 && num < 1000)
        || $test.call(/e/, str)
    ) {
        return str;
    }
    var sepRegex = /[0-9](?=(?:[0-9]{3})+(?![0-9]))/g;
    if (typeof num === 'number') {
        var int = num < 0 ? -$floor(-num) : $floor(num); // trunc(num)
        if (int !== num) {
            var intStr = String(int);
            var dec = $slice.call(str, intStr.length + 1);
            return $replace.call(intStr, sepRegex, '$&_') + '.' + $replace.call($replace.call(dec, /([0-9]{3})/g, '$&_'), /_$/, '');
        }
    }
    return $replace.call(str, sepRegex, '$&_');
}

var utilInspect = __webpack_require__(24654);
var inspectCustom = utilInspect.custom;
var inspectSymbol = isSymbol(inspectCustom) ? inspectCustom : null;

module.exports = function inspect_(obj, options, depth, seen) {
    var opts = options || {};

    if (has(opts, 'quoteStyle') && (opts.quoteStyle !== 'single' && opts.quoteStyle !== 'double')) {
        throw new TypeError('option "quoteStyle" must be "single" or "double"');
    }
    if (
        has(opts, 'maxStringLength') && (typeof opts.maxStringLength === 'number'
            ? opts.maxStringLength < 0 && opts.maxStringLength !== Infinity
            : opts.maxStringLength !== null
        )
    ) {
        throw new TypeError('option "maxStringLength", if provided, must be a positive integer, Infinity, or `null`');
    }
    var customInspect = has(opts, 'customInspect') ? opts.customInspect : true;
    if (typeof customInspect !== 'boolean' && customInspect !== 'symbol') {
        throw new TypeError('option "customInspect", if provided, must be `true`, `false`, or `\'symbol\'`');
    }

    if (
        has(opts, 'indent')
        && opts.indent !== null
        && opts.indent !== '\t'
        && !(parseInt(opts.indent, 10) === opts.indent && opts.indent > 0)
    ) {
        throw new TypeError('option "indent" must be "\\t", an integer > 0, or `null`');
    }
    if (has(opts, 'numericSeparator') && typeof opts.numericSeparator !== 'boolean') {
        throw new TypeError('option "numericSeparator", if provided, must be `true` or `false`');
    }
    var numericSeparator = opts.numericSeparator;

    if (typeof obj === 'undefined') {
        return 'undefined';
    }
    if (obj === null) {
        return 'null';
    }
    if (typeof obj === 'boolean') {
        return obj ? 'true' : 'false';
    }

    if (typeof obj === 'string') {
        return inspectString(obj, opts);
    }
    if (typeof obj === 'number') {
        if (obj === 0) {
            return Infinity / obj > 0 ? '0' : '-0';
        }
        var str = String(obj);
        return numericSeparator ? addNumericSeparator(obj, str) : str;
    }
    if (typeof obj === 'bigint') {
        var bigIntStr = String(obj) + 'n';
        return numericSeparator ? addNumericSeparator(obj, bigIntStr) : bigIntStr;
    }

    var maxDepth = typeof opts.depth === 'undefined' ? 5 : opts.depth;
    if (typeof depth === 'undefined') { depth = 0; }
    if (depth >= maxDepth && maxDepth > 0 && typeof obj === 'object') {
        return isArray(obj) ? '[Array]' : '[Object]';
    }

    var indent = getIndent(opts, depth);

    if (typeof seen === 'undefined') {
        seen = [];
    } else if (indexOf(seen, obj) >= 0) {
        return '[Circular]';
    }

    function inspect(value, from, noIndent) {
        if (from) {
            seen = $arrSlice.call(seen);
            seen.push(from);
        }
        if (noIndent) {
            var newOpts = {
                depth: opts.depth
            };
            if (has(opts, 'quoteStyle')) {
                newOpts.quoteStyle = opts.quoteStyle;
            }
            return inspect_(value, newOpts, depth + 1, seen);
        }
        return inspect_(value, opts, depth + 1, seen);
    }

    if (typeof obj === 'function' && !isRegExp(obj)) { // in older engines, regexes are callable
        var name = nameOf(obj);
        var keys = arrObjKeys(obj, inspect);
        return '[Function' + (name ? ': ' + name : ' (anonymous)') + ']' + (keys.length > 0 ? ' { ' + $join.call(keys, ', ') + ' }' : '');
    }
    if (isSymbol(obj)) {
        var symString = hasShammedSymbols ? $replace.call(String(obj), /^(Symbol\(.*\))_[^)]*$/, '$1') : symToString.call(obj);
        return typeof obj === 'object' && !hasShammedSymbols ? markBoxed(symString) : symString;
    }
    if (isElement(obj)) {
        var s = '<' + $toLowerCase.call(String(obj.nodeName));
        var attrs = obj.attributes || [];
        for (var i = 0; i < attrs.length; i++) {
            s += ' ' + attrs[i].name + '=' + wrapQuotes(quote(attrs[i].value), 'double', opts);
        }
        s += '>';
        if (obj.childNodes && obj.childNodes.length) { s += '...'; }
        s += '</' + $toLowerCase.call(String(obj.nodeName)) + '>';
        return s;
    }
    if (isArray(obj)) {
        if (obj.length === 0) { return '[]'; }
        var xs = arrObjKeys(obj, inspect);
        if (indent && !singleLineValues(xs)) {
            return '[' + indentedJoin(xs, indent) + ']';
        }
        return '[ ' + $join.call(xs, ', ') + ' ]';
    }
    if (isError(obj)) {
        var parts = arrObjKeys(obj, inspect);
        if (!('cause' in Error.prototype) && 'cause' in obj && !isEnumerable.call(obj, 'cause')) {
            return '{ [' + String(obj) + '] ' + $join.call($concat.call('[cause]: ' + inspect(obj.cause), parts), ', ') + ' }';
        }
        if (parts.length === 0) { return '[' + String(obj) + ']'; }
        return '{ [' + String(obj) + '] ' + $join.call(parts, ', ') + ' }';
    }
    if (typeof obj === 'object' && customInspect) {
        if (inspectSymbol && typeof obj[inspectSymbol] === 'function' && utilInspect) {
            return utilInspect(obj, { depth: maxDepth - depth });
        } else if (customInspect !== 'symbol' && typeof obj.inspect === 'function') {
            return obj.inspect();
        }
    }
    if (isMap(obj)) {
        var mapParts = [];
        if (mapForEach) {
            mapForEach.call(obj, function (value, key) {
                mapParts.push(inspect(key, obj, true) + ' => ' + inspect(value, obj));
            });
        }
        return collectionOf('Map', mapSize.call(obj), mapParts, indent);
    }
    if (isSet(obj)) {
        var setParts = [];
        if (setForEach) {
            setForEach.call(obj, function (value) {
                setParts.push(inspect(value, obj));
            });
        }
        return collectionOf('Set', setSize.call(obj), setParts, indent);
    }
    if (isWeakMap(obj)) {
        return weakCollectionOf('WeakMap');
    }
    if (isWeakSet(obj)) {
        return weakCollectionOf('WeakSet');
    }
    if (isWeakRef(obj)) {
        return weakCollectionOf('WeakRef');
    }
    if (isNumber(obj)) {
        return markBoxed(inspect(Number(obj)));
    }
    if (isBigInt(obj)) {
        return markBoxed(inspect(bigIntValueOf.call(obj)));
    }
    if (isBoolean(obj)) {
        return markBoxed(booleanValueOf.call(obj));
    }
    if (isString(obj)) {
        return markBoxed(inspect(String(obj)));
    }
    if (!isDate(obj) && !isRegExp(obj)) {
        var ys = arrObjKeys(obj, inspect);
        var isPlainObject = gPO ? gPO(obj) === Object.prototype : obj instanceof Object || obj.constructor === Object;
        var protoTag = obj instanceof Object ? '' : 'null prototype';
        var stringTag = !isPlainObject && toStringTag && Object(obj) === obj && toStringTag in obj ? $slice.call(toStr(obj), 8, -1) : protoTag ? 'Object' : '';
        var constructorTag = isPlainObject || typeof obj.constructor !== 'function' ? '' : obj.constructor.name ? obj.constructor.name + ' ' : '';
        var tag = constructorTag + (stringTag || protoTag ? '[' + $join.call($concat.call([], stringTag || [], protoTag || []), ': ') + '] ' : '');
        if (ys.length === 0) { return tag + '{}'; }
        if (indent) {
            return tag + '{' + indentedJoin(ys, indent) + '}';
        }
        return tag + '{ ' + $join.call(ys, ', ') + ' }';
    }
    return String(obj);
};

function wrapQuotes(s, defaultStyle, opts) {
    var quoteChar = (opts.quoteStyle || defaultStyle) === 'double' ? '"' : "'";
    return quoteChar + s + quoteChar;
}

function quote(s) {
    return $replace.call(String(s), /"/g, '&quot;');
}

function isArray(obj) { return toStr(obj) === '[object Array]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isDate(obj) { return toStr(obj) === '[object Date]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isRegExp(obj) { return toStr(obj) === '[object RegExp]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isError(obj) { return toStr(obj) === '[object Error]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isString(obj) { return toStr(obj) === '[object String]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isNumber(obj) { return toStr(obj) === '[object Number]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }
function isBoolean(obj) { return toStr(obj) === '[object Boolean]' && (!toStringTag || !(typeof obj === 'object' && toStringTag in obj)); }

// Symbol and BigInt do have Symbol.toStringTag by spec, so that can't be used to eliminate false positives
function isSymbol(obj) {
    if (hasShammedSymbols) {
        return obj && typeof obj === 'object' && obj instanceof Symbol;
    }
    if (typeof obj === 'symbol') {
        return true;
    }
    if (!obj || typeof obj !== 'object' || !symToString) {
        return false;
    }
    try {
        symToString.call(obj);
        return true;
    } catch (e) {}
    return false;
}

function isBigInt(obj) {
    if (!obj || typeof obj !== 'object' || !bigIntValueOf) {
        return false;
    }
    try {
        bigIntValueOf.call(obj);
        return true;
    } catch (e) {}
    return false;
}

var hasOwn = Object.prototype.hasOwnProperty || function (key) { return key in this; };
function has(obj, key) {
    return hasOwn.call(obj, key);
}

function toStr(obj) {
    return objectToString.call(obj);
}

function nameOf(f) {
    if (f.name) { return f.name; }
    var m = $match.call(functionToString.call(f), /^function\s*([\w$]+)/);
    if (m) { return m[1]; }
    return null;
}

function indexOf(xs, x) {
    if (xs.indexOf) { return xs.indexOf(x); }
    for (var i = 0, l = xs.length; i < l; i++) {
        if (xs[i] === x) { return i; }
    }
    return -1;
}

function isMap(x) {
    if (!mapSize || !x || typeof x !== 'object') {
        return false;
    }
    try {
        mapSize.call(x);
        try {
            setSize.call(x);
        } catch (s) {
            return true;
        }
        return x instanceof Map; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isWeakMap(x) {
    if (!weakMapHas || !x || typeof x !== 'object') {
        return false;
    }
    try {
        weakMapHas.call(x, weakMapHas);
        try {
            weakSetHas.call(x, weakSetHas);
        } catch (s) {
            return true;
        }
        return x instanceof WeakMap; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isWeakRef(x) {
    if (!weakRefDeref || !x || typeof x !== 'object') {
        return false;
    }
    try {
        weakRefDeref.call(x);
        return true;
    } catch (e) {}
    return false;
}

function isSet(x) {
    if (!setSize || !x || typeof x !== 'object') {
        return false;
    }
    try {
        setSize.call(x);
        try {
            mapSize.call(x);
        } catch (m) {
            return true;
        }
        return x instanceof Set; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isWeakSet(x) {
    if (!weakSetHas || !x || typeof x !== 'object') {
        return false;
    }
    try {
        weakSetHas.call(x, weakSetHas);
        try {
            weakMapHas.call(x, weakMapHas);
        } catch (s) {
            return true;
        }
        return x instanceof WeakSet; // core-js workaround, pre-v2.5.0
    } catch (e) {}
    return false;
}

function isElement(x) {
    if (!x || typeof x !== 'object') { return false; }
    if (typeof HTMLElement !== 'undefined' && x instanceof HTMLElement) {
        return true;
    }
    return typeof x.nodeName === 'string' && typeof x.getAttribute === 'function';
}

function inspectString(str, opts) {
    if (str.length > opts.maxStringLength) {
        var remaining = str.length - opts.maxStringLength;
        var trailer = '... ' + remaining + ' more character' + (remaining > 1 ? 's' : '');
        return inspectString($slice.call(str, 0, opts.maxStringLength), opts) + trailer;
    }
    // eslint-disable-next-line no-control-regex
    var s = $replace.call($replace.call(str, /(['\\])/g, '\\$1'), /[\x00-\x1f]/g, lowbyte);
    return wrapQuotes(s, 'single', opts);
}

function lowbyte(c) {
    var n = c.charCodeAt(0);
    var x = {
        8: 'b',
        9: 't',
        10: 'n',
        12: 'f',
        13: 'r'
    }[n];
    if (x) { return '\\' + x; }
    return '\\x' + (n < 0x10 ? '0' : '') + $toUpperCase.call(n.toString(16));
}

function markBoxed(str) {
    return 'Object(' + str + ')';
}

function weakCollectionOf(type) {
    return type + ' { ? }';
}

function collectionOf(type, size, entries, indent) {
    var joinedEntries = indent ? indentedJoin(entries, indent) : $join.call(entries, ', ');
    return type + ' (' + size + ') {' + joinedEntries + '}';
}

function singleLineValues(xs) {
    for (var i = 0; i < xs.length; i++) {
        if (indexOf(xs[i], '\n') >= 0) {
            return false;
        }
    }
    return true;
}

function getIndent(opts, depth) {
    var baseIndent;
    if (opts.indent === '\t') {
        baseIndent = '\t';
    } else if (typeof opts.indent === 'number' && opts.indent > 0) {
        baseIndent = $join.call(Array(opts.indent + 1), ' ');
    } else {
        return null;
    }
    return {
        base: baseIndent,
        prev: $join.call(Array(depth + 1), baseIndent)
    };
}

function indentedJoin(xs, indent) {
    if (xs.length === 0) { return ''; }
    var lineJoiner = '\n' + indent.prev + indent.base;
    return lineJoiner + $join.call(xs, ',' + lineJoiner) + '\n' + indent.prev;
}

function arrObjKeys(obj, inspect) {
    var isArr = isArray(obj);
    var xs = [];
    if (isArr) {
        xs.length = obj.length;
        for (var i = 0; i < obj.length; i++) {
            xs[i] = has(obj, i) ? inspect(obj[i], obj) : '';
        }
    }
    var syms = typeof gOPS === 'function' ? gOPS(obj) : [];
    var symMap;
    if (hasShammedSymbols) {
        symMap = {};
        for (var k = 0; k < syms.length; k++) {
            symMap['$' + syms[k]] = syms[k];
        }
    }

    for (var key in obj) { // eslint-disable-line no-restricted-syntax
        if (!has(obj, key)) { continue; } // eslint-disable-line no-restricted-syntax, no-continue
        if (isArr && String(Number(key)) === key && key < obj.length) { continue; } // eslint-disable-line no-restricted-syntax, no-continue
        if (hasShammedSymbols && symMap['$' + key] instanceof Symbol) {
            // this is to prevent shammed Symbols, which are stored as strings, from being included in the string key section
            continue; // eslint-disable-line no-restricted-syntax, no-continue
        } else if ($test.call(/[^\w$]/, key)) {
            xs.push(inspect(key, obj) + ': ' + inspect(obj[key], obj));
        } else {
            xs.push(key + ': ' + inspect(obj[key], obj));
        }
    }
    if (typeof gOPS === 'function') {
        for (var j = 0; j < syms.length; j++) {
            if (isEnumerable.call(obj, syms[j])) {
                xs.push('[' + inspect(syms[j]) + ']: ' + inspect(obj[syms[j]], obj));
            }
        }
    }
    return xs;
}


/***/ }),

/***/ 34155:
/***/ ((module) => {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),

/***/ 55798:
/***/ ((module) => {

"use strict";


var replace = String.prototype.replace;
var percentTwenties = /%20/g;

var Format = {
    RFC1738: 'RFC1738',
    RFC3986: 'RFC3986'
};

module.exports = {
    'default': Format.RFC3986,
    formatters: {
        RFC1738: function (value) {
            return replace.call(value, percentTwenties, '+');
        },
        RFC3986: function (value) {
            return String(value);
        }
    },
    RFC1738: Format.RFC1738,
    RFC3986: Format.RFC3986
};


/***/ }),

/***/ 80129:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var stringify = __webpack_require__(58261);
var parse = __webpack_require__(55235);
var formats = __webpack_require__(55798);

module.exports = {
    formats: formats,
    parse: parse,
    stringify: stringify
};


/***/ }),

/***/ 55235:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(12769);

var has = Object.prototype.hasOwnProperty;
var isArray = Array.isArray;

var defaults = {
    allowDots: false,
    allowPrototypes: false,
    allowSparse: false,
    arrayLimit: 20,
    charset: 'utf-8',
    charsetSentinel: false,
    comma: false,
    decoder: utils.decode,
    delimiter: '&',
    depth: 5,
    ignoreQueryPrefix: false,
    interpretNumericEntities: false,
    parameterLimit: 1000,
    parseArrays: true,
    plainObjects: false,
    strictNullHandling: false
};

var interpretNumericEntities = function (str) {
    return str.replace(/&#(\d+);/g, function ($0, numberStr) {
        return String.fromCharCode(parseInt(numberStr, 10));
    });
};

var parseArrayValue = function (val, options) {
    if (val && typeof val === 'string' && options.comma && val.indexOf(',') > -1) {
        return val.split(',');
    }

    return val;
};

// This is what browsers will submit when the ✓ character occurs in an
// application/x-www-form-urlencoded body and the encoding of the page containing
// the form is iso-8859-1, or when the submitted form has an accept-charset
// attribute of iso-8859-1. Presumably also with other charsets that do not contain
// the ✓ character, such as us-ascii.
var isoSentinel = 'utf8=%26%2310003%3B'; // encodeURIComponent('&#10003;')

// These are the percent-encoded utf-8 octets representing a checkmark, indicating that the request actually is utf-8 encoded.
var charsetSentinel = 'utf8=%E2%9C%93'; // encodeURIComponent('✓')

var parseValues = function parseQueryStringValues(str, options) {
    var obj = {};
    var cleanStr = options.ignoreQueryPrefix ? str.replace(/^\?/, '') : str;
    var limit = options.parameterLimit === Infinity ? undefined : options.parameterLimit;
    var parts = cleanStr.split(options.delimiter, limit);
    var skipIndex = -1; // Keep track of where the utf8 sentinel was found
    var i;

    var charset = options.charset;
    if (options.charsetSentinel) {
        for (i = 0; i < parts.length; ++i) {
            if (parts[i].indexOf('utf8=') === 0) {
                if (parts[i] === charsetSentinel) {
                    charset = 'utf-8';
                } else if (parts[i] === isoSentinel) {
                    charset = 'iso-8859-1';
                }
                skipIndex = i;
                i = parts.length; // The eslint settings do not allow break;
            }
        }
    }

    for (i = 0; i < parts.length; ++i) {
        if (i === skipIndex) {
            continue;
        }
        var part = parts[i];

        var bracketEqualsPos = part.indexOf(']=');
        var pos = bracketEqualsPos === -1 ? part.indexOf('=') : bracketEqualsPos + 1;

        var key, val;
        if (pos === -1) {
            key = options.decoder(part, defaults.decoder, charset, 'key');
            val = options.strictNullHandling ? null : '';
        } else {
            key = options.decoder(part.slice(0, pos), defaults.decoder, charset, 'key');
            val = utils.maybeMap(
                parseArrayValue(part.slice(pos + 1), options),
                function (encodedVal) {
                    return options.decoder(encodedVal, defaults.decoder, charset, 'value');
                }
            );
        }

        if (val && options.interpretNumericEntities && charset === 'iso-8859-1') {
            val = interpretNumericEntities(val);
        }

        if (part.indexOf('[]=') > -1) {
            val = isArray(val) ? [val] : val;
        }

        if (has.call(obj, key)) {
            obj[key] = utils.combine(obj[key], val);
        } else {
            obj[key] = val;
        }
    }

    return obj;
};

var parseObject = function (chain, val, options, valuesParsed) {
    var leaf = valuesParsed ? val : parseArrayValue(val, options);

    for (var i = chain.length - 1; i >= 0; --i) {
        var obj;
        var root = chain[i];

        if (root === '[]' && options.parseArrays) {
            obj = [].concat(leaf);
        } else {
            obj = options.plainObjects ? Object.create(null) : {};
            var cleanRoot = root.charAt(0) === '[' && root.charAt(root.length - 1) === ']' ? root.slice(1, -1) : root;
            var index = parseInt(cleanRoot, 10);
            if (!options.parseArrays && cleanRoot === '') {
                obj = { 0: leaf };
            } else if (
                !isNaN(index)
                && root !== cleanRoot
                && String(index) === cleanRoot
                && index >= 0
                && (options.parseArrays && index <= options.arrayLimit)
            ) {
                obj = [];
                obj[index] = leaf;
            } else if (cleanRoot !== '__proto__') {
                obj[cleanRoot] = leaf;
            }
        }

        leaf = obj;
    }

    return leaf;
};

var parseKeys = function parseQueryStringKeys(givenKey, val, options, valuesParsed) {
    if (!givenKey) {
        return;
    }

    // Transform dot notation to bracket notation
    var key = options.allowDots ? givenKey.replace(/\.([^.[]+)/g, '[$1]') : givenKey;

    // The regex chunks

    var brackets = /(\[[^[\]]*])/;
    var child = /(\[[^[\]]*])/g;

    // Get the parent

    var segment = options.depth > 0 && brackets.exec(key);
    var parent = segment ? key.slice(0, segment.index) : key;

    // Stash the parent if it exists

    var keys = [];
    if (parent) {
        // If we aren't using plain objects, optionally prefix keys that would overwrite object prototype properties
        if (!options.plainObjects && has.call(Object.prototype, parent)) {
            if (!options.allowPrototypes) {
                return;
            }
        }

        keys.push(parent);
    }

    // Loop through children appending to the array until we hit depth

    var i = 0;
    while (options.depth > 0 && (segment = child.exec(key)) !== null && i < options.depth) {
        i += 1;
        if (!options.plainObjects && has.call(Object.prototype, segment[1].slice(1, -1))) {
            if (!options.allowPrototypes) {
                return;
            }
        }
        keys.push(segment[1]);
    }

    // If there's a remainder, just add whatever is left

    if (segment) {
        keys.push('[' + key.slice(segment.index) + ']');
    }

    return parseObject(keys, val, options, valuesParsed);
};

var normalizeParseOptions = function normalizeParseOptions(opts) {
    if (!opts) {
        return defaults;
    }

    if (opts.decoder !== null && opts.decoder !== undefined && typeof opts.decoder !== 'function') {
        throw new TypeError('Decoder has to be a function.');
    }

    if (typeof opts.charset !== 'undefined' && opts.charset !== 'utf-8' && opts.charset !== 'iso-8859-1') {
        throw new TypeError('The charset option must be either utf-8, iso-8859-1, or undefined');
    }
    var charset = typeof opts.charset === 'undefined' ? defaults.charset : opts.charset;

    return {
        allowDots: typeof opts.allowDots === 'undefined' ? defaults.allowDots : !!opts.allowDots,
        allowPrototypes: typeof opts.allowPrototypes === 'boolean' ? opts.allowPrototypes : defaults.allowPrototypes,
        allowSparse: typeof opts.allowSparse === 'boolean' ? opts.allowSparse : defaults.allowSparse,
        arrayLimit: typeof opts.arrayLimit === 'number' ? opts.arrayLimit : defaults.arrayLimit,
        charset: charset,
        charsetSentinel: typeof opts.charsetSentinel === 'boolean' ? opts.charsetSentinel : defaults.charsetSentinel,
        comma: typeof opts.comma === 'boolean' ? opts.comma : defaults.comma,
        decoder: typeof opts.decoder === 'function' ? opts.decoder : defaults.decoder,
        delimiter: typeof opts.delimiter === 'string' || utils.isRegExp(opts.delimiter) ? opts.delimiter : defaults.delimiter,
        // eslint-disable-next-line no-implicit-coercion, no-extra-parens
        depth: (typeof opts.depth === 'number' || opts.depth === false) ? +opts.depth : defaults.depth,
        ignoreQueryPrefix: opts.ignoreQueryPrefix === true,
        interpretNumericEntities: typeof opts.interpretNumericEntities === 'boolean' ? opts.interpretNumericEntities : defaults.interpretNumericEntities,
        parameterLimit: typeof opts.parameterLimit === 'number' ? opts.parameterLimit : defaults.parameterLimit,
        parseArrays: opts.parseArrays !== false,
        plainObjects: typeof opts.plainObjects === 'boolean' ? opts.plainObjects : defaults.plainObjects,
        strictNullHandling: typeof opts.strictNullHandling === 'boolean' ? opts.strictNullHandling : defaults.strictNullHandling
    };
};

module.exports = function (str, opts) {
    var options = normalizeParseOptions(opts);

    if (str === '' || str === null || typeof str === 'undefined') {
        return options.plainObjects ? Object.create(null) : {};
    }

    var tempObj = typeof str === 'string' ? parseValues(str, options) : str;
    var obj = options.plainObjects ? Object.create(null) : {};

    // Iterate over the keys and setup the new object

    var keys = Object.keys(tempObj);
    for (var i = 0; i < keys.length; ++i) {
        var key = keys[i];
        var newObj = parseKeys(key, tempObj[key], options, typeof str === 'string');
        obj = utils.merge(obj, newObj, options);
    }

    if (options.allowSparse === true) {
        return obj;
    }

    return utils.compact(obj);
};


/***/ }),

/***/ 58261:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var getSideChannel = __webpack_require__(37478);
var utils = __webpack_require__(12769);
var formats = __webpack_require__(55798);
var has = Object.prototype.hasOwnProperty;

var arrayPrefixGenerators = {
    brackets: function brackets(prefix) {
        return prefix + '[]';
    },
    comma: 'comma',
    indices: function indices(prefix, key) {
        return prefix + '[' + key + ']';
    },
    repeat: function repeat(prefix) {
        return prefix;
    }
};

var isArray = Array.isArray;
var push = Array.prototype.push;
var pushToArray = function (arr, valueOrArray) {
    push.apply(arr, isArray(valueOrArray) ? valueOrArray : [valueOrArray]);
};

var toISO = Date.prototype.toISOString;

var defaultFormat = formats['default'];
var defaults = {
    addQueryPrefix: false,
    allowDots: false,
    charset: 'utf-8',
    charsetSentinel: false,
    delimiter: '&',
    encode: true,
    encoder: utils.encode,
    encodeValuesOnly: false,
    format: defaultFormat,
    formatter: formats.formatters[defaultFormat],
    // deprecated
    indices: false,
    serializeDate: function serializeDate(date) {
        return toISO.call(date);
    },
    skipNulls: false,
    strictNullHandling: false
};

var isNonNullishPrimitive = function isNonNullishPrimitive(v) {
    return typeof v === 'string'
        || typeof v === 'number'
        || typeof v === 'boolean'
        || typeof v === 'symbol'
        || typeof v === 'bigint';
};

var sentinel = {};

var stringify = function stringify(
    object,
    prefix,
    generateArrayPrefix,
    commaRoundTrip,
    strictNullHandling,
    skipNulls,
    encoder,
    filter,
    sort,
    allowDots,
    serializeDate,
    format,
    formatter,
    encodeValuesOnly,
    charset,
    sideChannel
) {
    var obj = object;

    var tmpSc = sideChannel;
    var step = 0;
    var findFlag = false;
    while ((tmpSc = tmpSc.get(sentinel)) !== void undefined && !findFlag) {
        // Where object last appeared in the ref tree
        var pos = tmpSc.get(object);
        step += 1;
        if (typeof pos !== 'undefined') {
            if (pos === step) {
                throw new RangeError('Cyclic object value');
            } else {
                findFlag = true; // Break while
            }
        }
        if (typeof tmpSc.get(sentinel) === 'undefined') {
            step = 0;
        }
    }

    if (typeof filter === 'function') {
        obj = filter(prefix, obj);
    } else if (obj instanceof Date) {
        obj = serializeDate(obj);
    } else if (generateArrayPrefix === 'comma' && isArray(obj)) {
        obj = utils.maybeMap(obj, function (value) {
            if (value instanceof Date) {
                return serializeDate(value);
            }
            return value;
        });
    }

    if (obj === null) {
        if (strictNullHandling) {
            return encoder && !encodeValuesOnly ? encoder(prefix, defaults.encoder, charset, 'key', format) : prefix;
        }

        obj = '';
    }

    if (isNonNullishPrimitive(obj) || utils.isBuffer(obj)) {
        if (encoder) {
            var keyValue = encodeValuesOnly ? prefix : encoder(prefix, defaults.encoder, charset, 'key', format);
            return [formatter(keyValue) + '=' + formatter(encoder(obj, defaults.encoder, charset, 'value', format))];
        }
        return [formatter(prefix) + '=' + formatter(String(obj))];
    }

    var values = [];

    if (typeof obj === 'undefined') {
        return values;
    }

    var objKeys;
    if (generateArrayPrefix === 'comma' && isArray(obj)) {
        // we need to join elements in
        if (encodeValuesOnly && encoder) {
            obj = utils.maybeMap(obj, encoder);
        }
        objKeys = [{ value: obj.length > 0 ? obj.join(',') || null : void undefined }];
    } else if (isArray(filter)) {
        objKeys = filter;
    } else {
        var keys = Object.keys(obj);
        objKeys = sort ? keys.sort(sort) : keys;
    }

    var adjustedPrefix = commaRoundTrip && isArray(obj) && obj.length === 1 ? prefix + '[]' : prefix;

    for (var j = 0; j < objKeys.length; ++j) {
        var key = objKeys[j];
        var value = typeof key === 'object' && typeof key.value !== 'undefined' ? key.value : obj[key];

        if (skipNulls && value === null) {
            continue;
        }

        var keyPrefix = isArray(obj)
            ? typeof generateArrayPrefix === 'function' ? generateArrayPrefix(adjustedPrefix, key) : adjustedPrefix
            : adjustedPrefix + (allowDots ? '.' + key : '[' + key + ']');

        sideChannel.set(object, step);
        var valueSideChannel = getSideChannel();
        valueSideChannel.set(sentinel, sideChannel);
        pushToArray(values, stringify(
            value,
            keyPrefix,
            generateArrayPrefix,
            commaRoundTrip,
            strictNullHandling,
            skipNulls,
            generateArrayPrefix === 'comma' && encodeValuesOnly && isArray(obj) ? null : encoder,
            filter,
            sort,
            allowDots,
            serializeDate,
            format,
            formatter,
            encodeValuesOnly,
            charset,
            valueSideChannel
        ));
    }

    return values;
};

var normalizeStringifyOptions = function normalizeStringifyOptions(opts) {
    if (!opts) {
        return defaults;
    }

    if (opts.encoder !== null && typeof opts.encoder !== 'undefined' && typeof opts.encoder !== 'function') {
        throw new TypeError('Encoder has to be a function.');
    }

    var charset = opts.charset || defaults.charset;
    if (typeof opts.charset !== 'undefined' && opts.charset !== 'utf-8' && opts.charset !== 'iso-8859-1') {
        throw new TypeError('The charset option must be either utf-8, iso-8859-1, or undefined');
    }

    var format = formats['default'];
    if (typeof opts.format !== 'undefined') {
        if (!has.call(formats.formatters, opts.format)) {
            throw new TypeError('Unknown format option provided.');
        }
        format = opts.format;
    }
    var formatter = formats.formatters[format];

    var filter = defaults.filter;
    if (typeof opts.filter === 'function' || isArray(opts.filter)) {
        filter = opts.filter;
    }

    return {
        addQueryPrefix: typeof opts.addQueryPrefix === 'boolean' ? opts.addQueryPrefix : defaults.addQueryPrefix,
        allowDots: typeof opts.allowDots === 'undefined' ? defaults.allowDots : !!opts.allowDots,
        charset: charset,
        charsetSentinel: typeof opts.charsetSentinel === 'boolean' ? opts.charsetSentinel : defaults.charsetSentinel,
        delimiter: typeof opts.delimiter === 'undefined' ? defaults.delimiter : opts.delimiter,
        encode: typeof opts.encode === 'boolean' ? opts.encode : defaults.encode,
        encoder: typeof opts.encoder === 'function' ? opts.encoder : defaults.encoder,
        encodeValuesOnly: typeof opts.encodeValuesOnly === 'boolean' ? opts.encodeValuesOnly : defaults.encodeValuesOnly,
        filter: filter,
        format: format,
        formatter: formatter,
        serializeDate: typeof opts.serializeDate === 'function' ? opts.serializeDate : defaults.serializeDate,
        skipNulls: typeof opts.skipNulls === 'boolean' ? opts.skipNulls : defaults.skipNulls,
        sort: typeof opts.sort === 'function' ? opts.sort : null,
        strictNullHandling: typeof opts.strictNullHandling === 'boolean' ? opts.strictNullHandling : defaults.strictNullHandling
    };
};

module.exports = function (object, opts) {
    var obj = object;
    var options = normalizeStringifyOptions(opts);

    var objKeys;
    var filter;

    if (typeof options.filter === 'function') {
        filter = options.filter;
        obj = filter('', obj);
    } else if (isArray(options.filter)) {
        filter = options.filter;
        objKeys = filter;
    }

    var keys = [];

    if (typeof obj !== 'object' || obj === null) {
        return '';
    }

    var arrayFormat;
    if (opts && opts.arrayFormat in arrayPrefixGenerators) {
        arrayFormat = opts.arrayFormat;
    } else if (opts && 'indices' in opts) {
        arrayFormat = opts.indices ? 'indices' : 'repeat';
    } else {
        arrayFormat = 'indices';
    }

    var generateArrayPrefix = arrayPrefixGenerators[arrayFormat];
    if (opts && 'commaRoundTrip' in opts && typeof opts.commaRoundTrip !== 'boolean') {
        throw new TypeError('`commaRoundTrip` must be a boolean, or absent');
    }
    var commaRoundTrip = generateArrayPrefix === 'comma' && opts && opts.commaRoundTrip;

    if (!objKeys) {
        objKeys = Object.keys(obj);
    }

    if (options.sort) {
        objKeys.sort(options.sort);
    }

    var sideChannel = getSideChannel();
    for (var i = 0; i < objKeys.length; ++i) {
        var key = objKeys[i];

        if (options.skipNulls && obj[key] === null) {
            continue;
        }
        pushToArray(keys, stringify(
            obj[key],
            key,
            generateArrayPrefix,
            commaRoundTrip,
            options.strictNullHandling,
            options.skipNulls,
            options.encode ? options.encoder : null,
            options.filter,
            options.sort,
            options.allowDots,
            options.serializeDate,
            options.format,
            options.formatter,
            options.encodeValuesOnly,
            options.charset,
            sideChannel
        ));
    }

    var joined = keys.join(options.delimiter);
    var prefix = options.addQueryPrefix === true ? '?' : '';

    if (options.charsetSentinel) {
        if (options.charset === 'iso-8859-1') {
            // encodeURIComponent('&#10003;'), the "numeric entity" representation of a checkmark
            prefix += 'utf8=%26%2310003%3B&';
        } else {
            // encodeURIComponent('✓')
            prefix += 'utf8=%E2%9C%93&';
        }
    }

    return joined.length > 0 ? prefix + joined : '';
};


/***/ }),

/***/ 12769:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var formats = __webpack_require__(55798);

var has = Object.prototype.hasOwnProperty;
var isArray = Array.isArray;

var hexTable = (function () {
    var array = [];
    for (var i = 0; i < 256; ++i) {
        array.push('%' + ((i < 16 ? '0' : '') + i.toString(16)).toUpperCase());
    }

    return array;
}());

var compactQueue = function compactQueue(queue) {
    while (queue.length > 1) {
        var item = queue.pop();
        var obj = item.obj[item.prop];

        if (isArray(obj)) {
            var compacted = [];

            for (var j = 0; j < obj.length; ++j) {
                if (typeof obj[j] !== 'undefined') {
                    compacted.push(obj[j]);
                }
            }

            item.obj[item.prop] = compacted;
        }
    }
};

var arrayToObject = function arrayToObject(source, options) {
    var obj = options && options.plainObjects ? Object.create(null) : {};
    for (var i = 0; i < source.length; ++i) {
        if (typeof source[i] !== 'undefined') {
            obj[i] = source[i];
        }
    }

    return obj;
};

var merge = function merge(target, source, options) {
    /* eslint no-param-reassign: 0 */
    if (!source) {
        return target;
    }

    if (typeof source !== 'object') {
        if (isArray(target)) {
            target.push(source);
        } else if (target && typeof target === 'object') {
            if ((options && (options.plainObjects || options.allowPrototypes)) || !has.call(Object.prototype, source)) {
                target[source] = true;
            }
        } else {
            return [target, source];
        }

        return target;
    }

    if (!target || typeof target !== 'object') {
        return [target].concat(source);
    }

    var mergeTarget = target;
    if (isArray(target) && !isArray(source)) {
        mergeTarget = arrayToObject(target, options);
    }

    if (isArray(target) && isArray(source)) {
        source.forEach(function (item, i) {
            if (has.call(target, i)) {
                var targetItem = target[i];
                if (targetItem && typeof targetItem === 'object' && item && typeof item === 'object') {
                    target[i] = merge(targetItem, item, options);
                } else {
                    target.push(item);
                }
            } else {
                target[i] = item;
            }
        });
        return target;
    }

    return Object.keys(source).reduce(function (acc, key) {
        var value = source[key];

        if (has.call(acc, key)) {
            acc[key] = merge(acc[key], value, options);
        } else {
            acc[key] = value;
        }
        return acc;
    }, mergeTarget);
};

var assign = function assignSingleSource(target, source) {
    return Object.keys(source).reduce(function (acc, key) {
        acc[key] = source[key];
        return acc;
    }, target);
};

var decode = function (str, decoder, charset) {
    var strWithoutPlus = str.replace(/\+/g, ' ');
    if (charset === 'iso-8859-1') {
        // unescape never throws, no try...catch needed:
        return strWithoutPlus.replace(/%[0-9a-f]{2}/gi, unescape);
    }
    // utf-8
    try {
        return decodeURIComponent(strWithoutPlus);
    } catch (e) {
        return strWithoutPlus;
    }
};

var encode = function encode(str, defaultEncoder, charset, kind, format) {
    // This code was originally written by Brian White (mscdex) for the io.js core querystring library.
    // It has been adapted here for stricter adherence to RFC 3986
    if (str.length === 0) {
        return str;
    }

    var string = str;
    if (typeof str === 'symbol') {
        string = Symbol.prototype.toString.call(str);
    } else if (typeof str !== 'string') {
        string = String(str);
    }

    if (charset === 'iso-8859-1') {
        return escape(string).replace(/%u[0-9a-f]{4}/gi, function ($0) {
            return '%26%23' + parseInt($0.slice(2), 16) + '%3B';
        });
    }

    var out = '';
    for (var i = 0; i < string.length; ++i) {
        var c = string.charCodeAt(i);

        if (
            c === 0x2D // -
            || c === 0x2E // .
            || c === 0x5F // _
            || c === 0x7E // ~
            || (c >= 0x30 && c <= 0x39) // 0-9
            || (c >= 0x41 && c <= 0x5A) // a-z
            || (c >= 0x61 && c <= 0x7A) // A-Z
            || (format === formats.RFC1738 && (c === 0x28 || c === 0x29)) // ( )
        ) {
            out += string.charAt(i);
            continue;
        }

        if (c < 0x80) {
            out = out + hexTable[c];
            continue;
        }

        if (c < 0x800) {
            out = out + (hexTable[0xC0 | (c >> 6)] + hexTable[0x80 | (c & 0x3F)]);
            continue;
        }

        if (c < 0xD800 || c >= 0xE000) {
            out = out + (hexTable[0xE0 | (c >> 12)] + hexTable[0x80 | ((c >> 6) & 0x3F)] + hexTable[0x80 | (c & 0x3F)]);
            continue;
        }

        i += 1;
        c = 0x10000 + (((c & 0x3FF) << 10) | (string.charCodeAt(i) & 0x3FF));
        /* eslint operator-linebreak: [2, "before"] */
        out += hexTable[0xF0 | (c >> 18)]
            + hexTable[0x80 | ((c >> 12) & 0x3F)]
            + hexTable[0x80 | ((c >> 6) & 0x3F)]
            + hexTable[0x80 | (c & 0x3F)];
    }

    return out;
};

var compact = function compact(value) {
    var queue = [{ obj: { o: value }, prop: 'o' }];
    var refs = [];

    for (var i = 0; i < queue.length; ++i) {
        var item = queue[i];
        var obj = item.obj[item.prop];

        var keys = Object.keys(obj);
        for (var j = 0; j < keys.length; ++j) {
            var key = keys[j];
            var val = obj[key];
            if (typeof val === 'object' && val !== null && refs.indexOf(val) === -1) {
                queue.push({ obj: obj, prop: key });
                refs.push(val);
            }
        }
    }

    compactQueue(queue);

    return value;
};

var isRegExp = function isRegExp(obj) {
    return Object.prototype.toString.call(obj) === '[object RegExp]';
};

var isBuffer = function isBuffer(obj) {
    if (!obj || typeof obj !== 'object') {
        return false;
    }

    return !!(obj.constructor && obj.constructor.isBuffer && obj.constructor.isBuffer(obj));
};

var combine = function combine(a, b) {
    return [].concat(a, b);
};

var maybeMap = function maybeMap(val, fn) {
    if (isArray(val)) {
        var mapped = [];
        for (var i = 0; i < val.length; i += 1) {
            mapped.push(fn(val[i]));
        }
        return mapped;
    }
    return fn(val);
};

module.exports = {
    arrayToObject: arrayToObject,
    assign: assign,
    combine: combine,
    compact: compact,
    decode: decode,
    encode: encode,
    isBuffer: isBuffer,
    isRegExp: isRegExp,
    maybeMap: maybeMap,
    merge: merge
};


/***/ }),

/***/ 9671:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Composable shortcut for `Promise.all`.
 *
 * The `allP` method returns a single Promise that resolves when all of the promises
 * in the iterable argument have resolved or when the iterable argument contains no promises.
 * It rejects with the reason of the first promise that rejects.
 *
 * @func allP
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.3.0|v2.3.0}
 * @category Function
 * @sig [Promise a] -> Promise [a]
 * @param {Iterable.<*>} iterable An iterable object such as an Array or String
 * @return {Promise} An already resolved Promise if the iterable passed is empty. An asynchronously resolved Promise if the iterable passed contains no promises. Note, Google Chrome 58 returns an already resolved promise in this case. A pending Promise in all other cases. This returned promise is then resolved/rejected asynchronously (as soon as the stack is empty) when all the promises in the given iterable have resolved, or if any of the promises reject. See the example about "Asynchronicity or synchronicity of allP" below.
 * @see {@link RA.resolveP|resolveP}, {@link RA.rejectP|rejectP}
 * @example
 *
 * RA.allP([1, 2]); //=> Promise([1, 2])
 * RA.allP([1, Promise.resolve(2)]); //=> Promise([1, 2])
 * RA.allP([Promise.resolve(1), Promise.resolve(2)]); //=> Promise([1, 2])
 * RA.allP([1, Promise.reject(2)]); //=> Promise(2)
 */
var allP = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.bind)(Promise.all, Promise));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (allP);

/***/ }),

/***/ 37344:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isNotNil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40476);
/* harmony import */ var _isNonEmptyArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(876);
/* harmony import */ var _stubUndefined__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61643);
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }


/**
 * Can be used as a way to compose multiple invokers together to form polymorphic functions,
 * or functions that exhibit different behaviors based on their argument(s).
 * Consumes dispatching functions and keep trying to invoke each in turn, until a non-nil value is returned.
 *
 * Accepts a list of dispatching functions and returns a new function.
 * When invoked, this new function is applied to some arguments,
 * each dispatching function is applied to those same arguments until one of the
 * dispatching functions returns a non-nil value.
 *
 * @func dispatch
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.6.0|v2.6.0}
 * @category Function
 * @sig [((a, b, ...) -> x1), ((a, b, ...) -> x2), ...] -> x1 | x2 | ...
 * @param {!Array} functions A list of functions
 * @return {*|undefined} Returns the first not-nil value, or undefined if either an empty list is provided or none of the dispatching functions returns a non-nil value
 * @see {@link RA.isNotNil}
 * @example
 *
 * // returns first non-nil value
 * const stubNil = () => null;
 * const stubUndefined = () => undefined;
 * const addOne = v => v + 1;
 * const addTwo = v => v + 2;
 *
 * RA.dispatch([stubNil, stubUndefined, addOne, addTwo])(1); //=> 2
 *
 * // acts as a switch
 * const fnSwitch = RA.dispatch([
 *   R.ifElse(RA.isString, s => `${s}-join`, RA.stubUndefined),
 *   R.ifElse(RA.isNumber, n => n + 1, RA.stubUndefined),
 *   R.ifElse(RA.isDate, R.T, RA.stubUndefined),
 * ]);
 * fnSwitch(1); //=> 2
 */



var byArity = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.comparator)(function (a, b) {
  return a.length > b.length;
});
var getMaxArity = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)((0,ramda__WEBPACK_IMPORTED_MODULE_0__.sort)(byArity), ramda__WEBPACK_IMPORTED_MODULE_0__.head, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.prop)('length'));
var iteratorFn = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curry)(function (args, accumulator, fn) {
  var result = fn.apply(void 0, _toConsumableArray(args));
  return (0,_isNotNil__WEBPACK_IMPORTED_MODULE_1__["default"])(result) ? (0,ramda__WEBPACK_IMPORTED_MODULE_0__.reduced)(result) : accumulator;
});
var dispatchImpl = function dispatchImpl(functions) {
  var arity = getMaxArity(functions);
  return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(arity, function () {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.reduce)(iteratorFn(args), undefined, functions);
  });
};
var dispatch = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.ifElse)(_isNonEmptyArray__WEBPACK_IMPORTED_MODULE_2__["default"], dispatchImpl, _stubUndefined__WEBPACK_IMPORTED_MODULE_3__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dispatch);

/***/ }),

/***/ 86077:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isString__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(314);



/**
 * Escapes the RegExp special characters.
 *
 * @func escapeRegExp
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.21.0|v2.21.0}
 * @category String
 * @sig String -> String
 * @param {string} val the value to escape
 * @return {string}
 * @see {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions#Escaping|MDN Regular Expressions Escaping}
 * @example
 *
 * RA.escapeRegExp('[ramda-adjunct](https://github.com/char0n/ramda-adjunct)'); //=> '\[ramda\-adjunct\]\(https://github\.com/char0n/ramda\-adjunct\)'
 */
var escapeRegExp = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.when)(_isString__WEBPACK_IMPORTED_MODULE_1__["default"], (0,ramda__WEBPACK_IMPORTED_MODULE_0__.replace)(/[.*+?^${}()|[\]\\-]/g, '\\$&'));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (escapeRegExp);

/***/ }),

/***/ 38667:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Returns true if the specified value is equal, in R.equals terms,
 * to at least one element of the given list or false otherwise.
 * Given list can be a string.
 *
 * Like {@link http://ramdajs.com/docs/#includes|R.includes} but with argument order reversed.
 *
 * @func included
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/3.0.0|v3.0.0}
 * @category List
 * @sig [a] -> a -> Boolean
 * @param {Array|String} list The list to consider
 * @param {*} a The item to compare against
 * @return {boolean} Returns Boolean `true` if an equivalent item is in the list or `false` otherwise
 * @see {@link http://ramdajs.com/docs/#includes|R.includes}
 * @example
 *
 * RA.included([1, 2, 3], 3); //=> true
 * RA.included([1, 2, 3], 4); //=> false
 * RA.included([{ name: 'Fred' }], { name: 'Fred' }); //=> true
 * RA.included([[42]], [42]); //=> true
 */
var included = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.flip)(ramda__WEBPACK_IMPORTED_MODULE_0__.includes);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (included);

/***/ }),

/***/ 62562:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
var isOfTypeObject = function isOfTypeObject(val) {
  return _typeof(val) === 'object';
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isOfTypeObject);

/***/ }),

/***/ 49258:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isNumber__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(47034);



// eslint-disable-next-line no-restricted-globals
var isFinitePonyfill = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.both)(_isNumber__WEBPACK_IMPORTED_MODULE_1__["default"], isFinite);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isFinitePonyfill);

/***/ }),

/***/ 29139:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isFinite__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7227);


var isIntegerPonyfill = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.both)(_isFinite__WEBPACK_IMPORTED_MODULE_1__["default"], (0,ramda__WEBPACK_IMPORTED_MODULE_0__.converge)(ramda__WEBPACK_IMPORTED_MODULE_0__.equals, [Math.floor, ramda__WEBPACK_IMPORTED_MODULE_0__.identity]));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isIntegerPonyfill);

/***/ }),

/***/ 85629:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isRegExp__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42342);
/* harmony import */ var _escapeRegExp__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86077);



var checkArguments = function checkArguments(searchValue, replaceValue, str) {
  if (str == null || searchValue == null || replaceValue == null) {
    throw TypeError('Input values must not be `null` or `undefined`');
  }
};
var checkValue = function checkValue(value, valueName) {
  if (typeof value !== 'string') {
    if (!(value instanceof String)) {
      throw TypeError("`".concat(valueName, "` must be a string"));
    }
  }
};
var checkSearchValue = function checkSearchValue(searchValue) {
  if (typeof searchValue !== 'string' && !(searchValue instanceof String) && !(searchValue instanceof RegExp)) {
    throw TypeError('`searchValue` must be a string or an regexp');
  }
};
var replaceAll = function replaceAll(searchValue, replaceValue, str) {
  checkArguments(searchValue, replaceValue, str);
  checkValue(str, 'str');
  checkValue(replaceValue, 'replaceValue');
  checkSearchValue(searchValue);
  var regexp = new RegExp((0,_isRegExp__WEBPACK_IMPORTED_MODULE_1__["default"])(searchValue) ? searchValue : (0,_escapeRegExp__WEBPACK_IMPORTED_MODULE_2__["default"])(searchValue), 'g');
  return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.replace)(regexp, replaceValue, str);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (replaceAll);

/***/ }),

/***/ 54633:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isNotFunction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(73383);
/* harmony import */ var _isEmptyArray__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(90986);




/**
 * Invokes the method at path of object with given arguments.
 *
 * @func invokeArgs
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.27.0|v2.27.0}
 * @category Object
 * @sig Array -> Array -> Object -> *
 * @param {Array.<string|number>} path The path of the method to invoke
 * @param {Array} args The arguments to invoke the method with
 * @param {Object} obj The object to query
 * @return {*}
 * @example
 *
 * RA.invokeArgs(['abs'], [-1], Math); //=> 1
 * RA.invokeArgs(['path', 'to', 'non-existent', 'method'], [-1], Math); //=> undefined
 */

var invokeArgs = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(3, function (mpath, args, obj) {
  var method = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.path)(mpath, obj);
  var context = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.path)((0,ramda__WEBPACK_IMPORTED_MODULE_0__.init)(mpath), obj);
  if ((0,_isNotFunction__WEBPACK_IMPORTED_MODULE_1__["default"])(method)) return undefined;
  if ((0,_isEmptyArray__WEBPACK_IMPORTED_MODULE_2__["default"])(mpath)) return undefined;
  var boundMethod = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.bind)(method, context);
  return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.apply)(boundMethod, args);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (invokeArgs);

/***/ }),

/***/ 88162:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isFunction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60285);



/**
 * Checks if input value is `Array`.
 *
 * @func isArray
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.3.0|v0.3.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotArray|isNotArray}
 * @example
 *
 * RA.isArray([]); //=> true
 * RA.isArray(null); //=> false
 * RA.isArray({}); //=> false
 */
var isArray = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,_isFunction__WEBPACK_IMPORTED_MODULE_1__["default"])(Array.isArray) ? Array.isArray : (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)(ramda__WEBPACK_IMPORTED_MODULE_0__.type, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.identical)('Array')));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isArray);

/***/ }),

/***/ 15754:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Checks if input value is `Async Function`.
 *
 * @func isAsyncFunction
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isFunction|isFunction}, {@link RA.isNotAsyncFunction|isNotAsyncFunction}, {@link RA.isGeneratorFunction|isGeneratorFunction}
 * @example
 *
 * RA.isAsyncFunction(async function test() { }); //=> true
 * RA.isAsyncFunction(null); //=> false
 * RA.isAsyncFunction(function test() { }); //=> false
 * RA.isAsyncFunction(() => {}); //=> false
 */
var isAsyncFunction = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)(ramda__WEBPACK_IMPORTED_MODULE_0__.type, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.identical)('AsyncFunction')));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isAsyncFunction);

/***/ }),

/***/ 90986:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88162);



/**
 * Checks if input value is an empty `Array`.
 *
 * @func isEmptyArray
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.4.0|v2.4.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotEmptyArray|isNotEmptyArray}
 * @example
 *
 * RA.isEmptyArray([]); // => true
 * RA.isEmptyArray([42]); // => false
 * RA.isEmptyArray({}); // => false
 * RA.isEmptyArray(null); // => false
 * RA.isEmptyArray(undefined); // => false
 * RA.isEmptyArray(42); // => false
 * RA.isEmptyArray('42'); // => false
 */
var isEmptyArray = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.both)(_isArray__WEBPACK_IMPORTED_MODULE_1__["default"], ramda__WEBPACK_IMPORTED_MODULE_0__.isEmpty);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isEmptyArray);

/***/ }),

/***/ 77189:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Checks if input value is an empty `String`.
 *
 * @func isEmptyString
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.4.0|v2.4.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotEmptyString|isNotEmptyString}
 * @example
 *
 * RA.isEmptyString(''); // => true
 * RA.isEmptyString('42'); // => false
 * RA.isEmptyString(new String('42')); // => false
 * RA.isEmptyString(new String('')); // => false
 * RA.isEmptyString([42]); // => false
 * RA.isEmptyString({}); // => false
 * RA.isEmptyString(null); // => false
 * RA.isEmptyString(undefined); // => false
 * RA.isEmptyString(42); // => false
 */
var isEmptyString = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.equals)('');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isEmptyString);

/***/ }),

/***/ 7227:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "isFinitePonyfill": () => (/* binding */ isFinitePonyfill)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isFunction__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60285);
/* harmony import */ var _internal_ponyfills_Number_isFinite__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(49258);



var isFinitePonyfill = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, _internal_ponyfills_Number_isFinite__WEBPACK_IMPORTED_MODULE_1__["default"]);

/**
 * Checks whether the passed value is a finite `Number`.
 *
 * @func isFinite
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.7.0|v0.7.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotFinite|isNotFinite}
 * @example
 *
 * RA.isFinite(Infinity); //=> false
 * RA.isFinite(NaN); //=> false
 * RA.isFinite(-Infinity); //=> false
 *
 * RA.isFinite(0); // true
 * RA.isFinite(2e64); // true
 *
 * RA.isFinite('0');  // => false
 *                    // would've been true with global isFinite('0')
 * RA.isFinite(null); // => false
 *                    // would've been true with global isFinite(null)
 */
var _isFinite = (0,_isFunction__WEBPACK_IMPORTED_MODULE_2__["default"])(Number.isFinite) ? (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.bind)(Number.isFinite, Number)) : isFinitePonyfill;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_isFinite);

/***/ }),

/***/ 60285:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isGeneratorFunction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58216);
/* harmony import */ var _isAsyncFunction__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15754);




/**
 * Checks if input value is `Function`.
 *
 * @func isFunction
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotFunction|isNotFunction}, {@link RA.isAsyncFunction|isNotAsyncFunction}, {@link RA.isGeneratorFunction|isGeneratorFunction}
 * @example
 *
 * RA.isFunction(function test() { }); //=> true
 * RA.isFunction(function* test() { }); //=> true
 * RA.isFunction(async function test() { }); //=> true
 * RA.isFunction(() => {}); //=> true
 * RA.isFunction(null); //=> false
 * RA.isFunction('abc'); //=> false
 */
var isFunction = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.anyPass)([(0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)(ramda__WEBPACK_IMPORTED_MODULE_0__.type, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.identical)('Function')), _isGeneratorFunction__WEBPACK_IMPORTED_MODULE_1__["default"], _isAsyncFunction__WEBPACK_IMPORTED_MODULE_2__["default"]]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isFunction);

/***/ }),

/***/ 58216:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Checks if input value is `Generator Function`.
 *
 * @func isGeneratorFunction
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isFunction|isFunction}, {@link RA.isAsyncFunction|isAsyncFunction}, {@link RA.isNotGeneratorFunction|isNotGeneratorFunction}
 * @example
 *
 * RA.isGeneratorFunction(function* test() { }); //=> true
 * RA.isGeneratorFunction(null); //=> false
 * RA.isGeneratorFunction(function test() { }); //=> false
 * RA.isGeneratorFunction(() => {}); //=> false
 */
var isGeneratorFunction = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)(ramda__WEBPACK_IMPORTED_MODULE_0__.type, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.identical)('GeneratorFunction')));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isGeneratorFunction);

/***/ }),

/***/ 22582:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "isIntegerPonyfill": () => (/* binding */ isIntegerPonyfill)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isFunction__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60285);
/* harmony import */ var _internal_ponyfills_Number_isInteger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29139);



var isIntegerPonyfill = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, _internal_ponyfills_Number_isInteger__WEBPACK_IMPORTED_MODULE_1__["default"]);

/**
 * Checks whether the passed value is an `integer`.
 *
 * @func isInteger
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.7.0|v0.7.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotInteger|isNotInteger}
 * @example
 *
 * RA.isInteger(0); //=> true
 * RA.isInteger(1); //=> true
 * RA.isInteger(-100000); //=> true
 *
 * RA.isInteger(0.1);       //=> false
 * RA.isInteger(Math.PI);   //=> false
 *
 * RA.isInteger(NaN);       //=> false
 * RA.isInteger(Infinity);  //=> false
 * RA.isInteger(-Infinity); //=> false
 * RA.isInteger('10');      //=> false
 * RA.isInteger(true);      //=> false
 * RA.isInteger(false);     //=> false
 * RA.isInteger([1]);       //=> false
 */
var isInteger = (0,_isFunction__WEBPACK_IMPORTED_MODULE_2__["default"])(Number.isInteger) ? (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.bind)(Number.isInteger, Number)) : isIntegerPonyfill;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isInteger);

/***/ }),

/***/ 876:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isNotEmpty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(62234);
/* harmony import */ var _isArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88162);




/**
 * Checks if input value is not an empty `Array`.
 *
 * @func isNonEmptyArray
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.4.0|v2.4.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isEmptyArray|isEmptyArray}
 * @example
 *
 * RA.isNonEmptyArray([42]); // => true
 * RA.isNonEmptyArray([]); // => false
 * RA.isNonEmptyArray({}); // => false
 * RA.isNonEmptyArray(null); // => false
 * RA.isNonEmptyArray(undefined); // => false
 * RA.isNonEmptyArray(42); // => false
 * RA.isNonEmptyArray('42'); // => false
 */
var isNonEmptyArray = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.both)(_isArray__WEBPACK_IMPORTED_MODULE_1__["default"], _isNotEmpty__WEBPACK_IMPORTED_MODULE_2__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNonEmptyArray);

/***/ }),

/***/ 25657:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isString__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(314);
/* harmony import */ var _isNotObj__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12504);
/* harmony import */ var _isNotEmpty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62234);





/**
 * Checks if input value is not an empty `String`.
 *
 * @func isNonEmptyString
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.4.0|v2.4.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isEmptyString|isEmptyString}
 * @example
 *
 * RA.isNonEmptyString('42'); // => true
 * RA.isNonEmptyString(''); // => false
 * RA.isNonEmptyString(new String('42')); // => false
 * RA.isNonEmptyString(new String('')); // => false
 * RA.isNonEmptyString([42]); // => false
 * RA.isNonEmptyString({}); // => false
 * RA.isNonEmptyString(null); // => false
 * RA.isNonEmptyString(undefined); // => false
 * RA.isNonEmptyString(42); // => false
 */
var isNonEmptyString = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.allPass)([_isString__WEBPACK_IMPORTED_MODULE_1__["default"], _isNotObj__WEBPACK_IMPORTED_MODULE_2__["default"], _isNotEmpty__WEBPACK_IMPORTED_MODULE_3__["default"]]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNonEmptyString);

/***/ }),

/***/ 62234:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Returns true if the given value is not its type's empty value; `false` otherwise.
 *
 * @func isNotEmpty
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.4.0|v0.4.0}
 * @category Logic
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link http://ramdajs.com/docs/#isEmpty|R.isEmpty}
 * @example
 *
 * RA.isNotEmpty([1, 2, 3]); //=> true
 * RA.isNotEmpty([]); //=> false
 * RA.isNotEmpty(''); //=> false
 * RA.isNotEmpty(null); //=> true
 * RA.isNotEmpty(undefined): //=> true
 * RA.isNotEmpty({}); //=> false
 * RA.isNotEmpty({length: 0}); //=> true
 */
var isNotEmpty = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.complement)(ramda__WEBPACK_IMPORTED_MODULE_0__.isEmpty);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNotEmpty);

/***/ }),

/***/ 73383:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isFunction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60285);



/* eslint-disable max-len */
/**
 * Checks if input value is complement of `Function`.
 *
 * @func isNotFunction
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isFunction|isFunction}, {@link RA.isAsyncFunction|isNotAsyncFunction}, {@link RA.isGeneratorFunction|isGeneratorFunction}
 * @example
 *
 * RA.isNotFunction(function test() { }); //=> false
 * RA.isNotFunction(function* test() { }); //=> false
 * RA.isNotFunction(async function test() { }); //=> false
 * RA.isNotFunction(() => {}); //=> false
 * RA.isNotFunction(null); //=> true
 * RA.isNotFunction('abc'); //=> true
 */
/* eslint-enable max-len */
var isNotFunction = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.complement)(_isFunction__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNotFunction);

/***/ }),

/***/ 40476:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Checks if input value is complement of `null` or `undefined`.
 *
 * @func isNotNil
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.3.0|v0.3.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link http://ramdajs.com/docs/#isNil|R.isNil}
 * @example
 *
 * RA.isNotNil(null); //=> false
 * RA.isNotNil(undefined); //=> false
 * RA.isNotNil(0); //=> true
 * RA.isNotNil([]); //=> true
 */
var isNotNil = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.complement)(ramda__WEBPACK_IMPORTED_MODULE_0__.isNil);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNotNil);

/***/ }),

/***/ 56009:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isNull__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71332);



/**
 * Checks if input value is complement of `null`.
 *
 * @func isNotNull
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.1.0|v0.1.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNull|isNull}
 * @example
 *
 * RA.isNotNull(1); //=> true
 * RA.isNotNull(undefined); //=> true
 * RA.isNotNull(null); //=> false
 */
var isNotNull = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.complement)(_isNull__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNotNull);

/***/ }),

/***/ 12504:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isObj__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50350);



/* eslint-disable max-len */
/**
 * Checks if input value is complement of language type of `Object`.
 *
 * @func isNotObj
 * @aliases isNotObject
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isObj|isObj}, {@link RA.isObjLike|isObjLike}, {@link RA.isPlainObj|isPlainObj}
 * @example
 *
 * RA.isNotObj({}); //=> false
 * RA.isNotObj([]); //=> false
 * RA.isNotObj(() => {}); //=> false
 * RA.isNotObj(null); //=> true
 * RA.isNotObj(undefined); //=> true
 */
/* eslint-enable max-len */
var isNotObj = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.complement)(_isObj__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNotObj);

/***/ }),

/***/ 5413:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isUndefined__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4926);



/**
 * Checks if input value is complement `undefined`.
 *
 * @func isNotUndefined
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.0.1|v0.0.1}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isUndefined|isUndefined}
 * @example
 *
 * RA.isNotUndefined(1); //=> true
 * RA.isNotUndefined(undefined); //=> false
 * RA.isNotUndefined(null); //=> true
 */
var isNotUndefined = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.complement)(_isUndefined__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNotUndefined);

/***/ }),

/***/ 71332:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Checks if input value is `null`.
 *
 * @func isNull
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.1.0|v0.1.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotNull|isNotNull}
 * @example
 *
 * RA.isNull(1); //=> false
 * RA.isNull(undefined); //=> false
 * RA.isNull(null); //=> true
 */
var isNull = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.equals)(null);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNull);

/***/ }),

/***/ 47034:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Checks if value is a `Number` primitive or object.
 *
 * @func isNumber
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.6.0|v0.6.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotNumber|isNotNumber}
 * @example
 *
 * RA.isNumber(5); // => true
 * RA.isNumber(Number.MAX_VALUE); // => true
 * RA.isNumber(-Infinity); // => true
 * RA.isNumber(NaN); // => true
 * RA.isNumber('5'); // => false
 */
var isNumber = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)(ramda__WEBPACK_IMPORTED_MODULE_0__.type, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.identical)('Number')));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNumber);

/***/ }),

/***/ 50350:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isNotNull__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56009);
/* harmony import */ var _isFunction__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60285);
/* harmony import */ var _internal_isOfTypeObject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(62562);





/* eslint-disable max-len */
/**
 * Checks if input value is language type of `Object`.
 *
 * @func isObj
 * @aliases isObject
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotObj|isNotObj}, {@link RA.isObjLike|isObjLike}, {@link RA.isPlainObj|isPlainObj}
 * @example
 *
 * RA.isObj({}); //=> true
 * RA.isObj([]); //=> true
 * RA.isObj(() => {}); //=> true
 * RA.isObj(null); //=> false
 * RA.isObj(undefined); //=> false
 */
/* eslint-enable max-len */
var isObj = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.both)(_isNotNull__WEBPACK_IMPORTED_MODULE_1__["default"], (0,ramda__WEBPACK_IMPORTED_MODULE_0__.either)(_internal_isOfTypeObject__WEBPACK_IMPORTED_MODULE_2__["default"], _isFunction__WEBPACK_IMPORTED_MODULE_3__["default"])));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isObj);

/***/ }),

/***/ 15486:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isNotNull__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56009);
/* harmony import */ var _internal_isOfTypeObject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(62562);




/* eslint-disable max-len */
/**
 * Checks if value is object-like. A value is object-like if it's not null and has a typeof result of "object".
 *
 * @func isObjLike
 * @aliases isObjectLike
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotObjLike|isNotObjLike}, {@link RA.isObj|isObj}, {@link RA.isPlainObj|isPlainObj}
 * @example
 *
 * RA.isObjLike({}); //=> true
 * RA.isObjLike([]); //=> true
 * RA.isObjLike(() => {}); //=> false
 * RA.isObjLike(null); //=> false
 * RA.isObjLike(undefined); //=> false
 */
/* eslint-enable max-len */
var isObjLike = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.both)(_isNotNull__WEBPACK_IMPORTED_MODULE_1__["default"], _internal_isOfTypeObject__WEBPACK_IMPORTED_MODULE_2__["default"]));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isObjLike);

/***/ }),

/***/ 38074:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isNull__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71332);
/* harmony import */ var _isObjLike__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15486);
/* harmony import */ var _isFunction__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60285);




var isObject = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)(ramda__WEBPACK_IMPORTED_MODULE_0__.type, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.identical)('Object'));
var isObjectConstructor = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)(ramda__WEBPACK_IMPORTED_MODULE_0__.toString, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.equals)((0,ramda__WEBPACK_IMPORTED_MODULE_0__.toString)(Object)));
var hasObjectConstructor = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pathSatisfies)((0,ramda__WEBPACK_IMPORTED_MODULE_0__.both)(_isFunction__WEBPACK_IMPORTED_MODULE_1__["default"], isObjectConstructor), ['constructor']);

/* eslint-disable max-len */
/**
 * Check to see if an object is a plain object (created using `{}`, `new Object()` or `Object.create(null)`).
 *
 * @func isPlainObj
 * @aliases isPlainObject
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotPlainObj|isNotPlainObj}, {@link RA.isObjLike|isObjLike}, {@link RA.isObj|isObj}
 * @example
 *
 * class Bar {
 *   constructor() {
 *     this.prop = 'value';
 *   }
 * }
 *
 * RA.isPlainObj(new Bar()); //=> false
 * RA.isPlainObj({ prop: 'value' }); //=> true
 * RA.isPlainObj(['a', 'b', 'c']); //=> false
 * RA.isPlainObj(Object.create(null); //=> true
 * RA.isPlainObj(new Object()); //=> true
 */
/* eslint-enable max-len */
var isPlainObj = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, function (val) {
  if (!(0,_isObjLike__WEBPACK_IMPORTED_MODULE_2__["default"])(val) || !isObject(val)) {
    return false;
  }
  var proto = Object.getPrototypeOf(val);
  if ((0,_isNull__WEBPACK_IMPORTED_MODULE_3__["default"])(proto)) {
    return true;
  }
  return hasObjectConstructor(proto);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isPlainObj);

/***/ }),

/***/ 42342:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Checks if value is `RegExp` object.
 *
 * @func isRegExp
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.5.0|v2.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotRegExp|isNotRegExp}
 * @example
 *
 * RA.isRegExp(new RegExp()); //=> true
 * RA.isRegExp(/(?:)/); //=> true
 * RA.isRegExp(1); //=> false
 */
var isRegExp = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)(ramda__WEBPACK_IMPORTED_MODULE_0__.type, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.identical)('RegExp')));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isRegExp);

/***/ }),

/***/ 314:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * Checks if input value is `String`.
 *
 * @func isString
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.4.0|v0.4.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotString|isNotString}
 * @example
 *
 * RA.isString('abc'); //=> true
 * RA.isString(1); //=> false
 */
var isString = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)(ramda__WEBPACK_IMPORTED_MODULE_0__.type, (0,ramda__WEBPACK_IMPORTED_MODULE_0__.identical)('String')));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isString);

/***/ }),

/***/ 4926:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _stubUndefined__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61643);



/**
 * Checks if input value is `undefined`.
 *
 * @func isUndefined
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.0.1|v0.0.1}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotUndefined|isNotUndefined}
 * @example
 *
 * RA.isUndefined(1); //=> false
 * RA.isUndefined(undefined); //=> true
 * RA.isUndefined(null); //=> false
 */
var isUndefined = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.equals)((0,_stubUndefined__WEBPACK_IMPORTED_MODULE_1__["default"])());
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isUndefined);

/***/ }),

/***/ 88526:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _stubUndefined__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61643);



/**
 * A function that performs no operations.
 *
 * @func noop
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/1.0.0|v1.0.0}
 * @category Function
 * @sig ... -> undefined
 * @return {undefined}
 * @example
 *
 * RA.noop(); //=> undefined
 * RA.noop(1, 2, 3); //=> undefined
 */
var noop = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.always)((0,_stubUndefined__WEBPACK_IMPORTED_MODULE_1__["default"])());
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (noop);

/***/ }),

/***/ 10244:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "replaceAllInvoker": () => (/* binding */ replaceAllInvoker),
/* harmony export */   "replaceAllPonyfill": () => (/* binding */ replaceAllPonyfill)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _isFunction__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60285);
/* harmony import */ var _internal_ponyfills_String_replaceAll__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85629);



var replaceAllPonyfill = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curryN)(3, _internal_ponyfills_String_replaceAll__WEBPACK_IMPORTED_MODULE_1__["default"]);
var replaceAllInvoker = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.invoker)(2, 'replaceAll');

/**
 * Replaces all substring matches in a string with a replacement.
 *
 * @func replaceAll
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.17.0|v2.17.0}
 * @category String
 * @sig String -> String -> String -> String
 * @param {string} searchValue The substring or a global RegExp to match
 * @param {string} replaceValue The string to replace the matches with
 * @param {string} str The String to do the search and replacement in
 * @return {string} A new string containing all the `searchValue` replaced with the `replaceValue`
 * @throws {TypeError} When invalid arguments provided
 * @see {@link http://ramdajs.com/docs/#replace|R.replace}, {@link https://github.com/tc39/proposal-string-replaceall|TC39 proposal}
 * @example
 *
 * RA.replaceAll('ac', 'ef', 'ac ab ac ab'); //=> 'ef ab ef ab'
 * RA.replaceAll('', '_', 'xxx'); //=> '_x_x_x_'
 * RA.replaceAll(/x/g, 'v', 'xxx'); //=> 'vvv'
 * RA.replaceAll(/x/, 'v', 'xxx'); //=> TypeError
 */
var replaceAll = (0,_isFunction__WEBPACK_IMPORTED_MODULE_2__["default"])(String.prototype.replaceAll) ? replaceAllInvoker : replaceAllPonyfill;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (replaceAll);

/***/ }),

/***/ 61643:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);


/**
 * A function that returns `undefined`.
 *
 * @func stubUndefined
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/1.0.0|v1.0.0}
 * @category Function
 * @sig ... -> undefined
 * @return {undefined}
 * @example
 *
 * RA.stubUndefined(); //=> undefined
 * RA.stubUndefined(1, 2, 3); //=> undefined
 */
var stubUndefined = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.always)(void 0); // eslint-disable-line no-void

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (stubUndefined);

/***/ }),

/***/ 58449:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _included__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38667);



/**
 * Removes specified characters from the end of a string.
 *
 * @func trimCharsEnd
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.25.0|v2.25.0}
 * @category String
 * @sig String -> String
 * @param {string} chars The characters to trim
 * @param {string} value The string to trim
 * @return {string} Returns the trimmed string.
 * @example
 *
 * RA.trimCharsEnd('_-', '-_-abc-_-'); //=> '-_-abc'
 */

var trimCharsEnd = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curry)(function (chars, value) {
  return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)((0,ramda__WEBPACK_IMPORTED_MODULE_0__.split)(''), (0,ramda__WEBPACK_IMPORTED_MODULE_0__.dropLastWhile)((0,_included__WEBPACK_IMPORTED_MODULE_1__["default"])(chars)), (0,ramda__WEBPACK_IMPORTED_MODULE_0__.join)(''))(value);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (trimCharsEnd);

/***/ }),

/***/ 16138:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _included__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38667);



/**
 * Removes specified characters from the beginning of a string.
 *
 * @func trimCharsStart
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.24.0|v2.24.0}
 * @category String
 * @sig String -> String
 * @param {string} chars The characters to trim
 * @param {string} value The string to trim
 * @return {string} Returns the trimmed string.
 * @example
 *
 * RA.trimCharsStart('_-', '-_-abc-_-'); //=> 'abc-_-'
 */

var trimCharsStart = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curry)(function (chars, value) {
  return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)((0,ramda__WEBPACK_IMPORTED_MODULE_0__.split)(''), (0,ramda__WEBPACK_IMPORTED_MODULE_0__.dropWhile)((0,_included__WEBPACK_IMPORTED_MODULE_1__["default"])(chars)), (0,ramda__WEBPACK_IMPORTED_MODULE_0__.join)(''))(value);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (trimCharsStart);

/***/ }),

/***/ 77913:
/***/ ((module) => {

var ShortUniqueId = (() => {
  var __defProp = Object.defineProperty;
  var __getOwnPropSymbols = Object.getOwnPropertySymbols;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __propIsEnum = Object.prototype.propertyIsEnumerable;
  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __spreadValues = (a, b) => {
    for (var prop in b || (b = {}))
      if (__hasOwnProp.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    if (__getOwnPropSymbols)
      for (var prop of __getOwnPropSymbols(b)) {
        if (__propIsEnum.call(b, prop))
          __defNormalProp(a, prop, b[prop]);
      }
    return a;
  };
  var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
  var __export = (target, all) => {
    __markAsModule(target);
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    DEFAULT_UUID_LENGTH: () => DEFAULT_UUID_LENGTH,
    default: () => ShortUniqueId
  });

  // package.json
  var version = "4.4.4";

  // src/index.ts
  var DEFAULT_UUID_LENGTH = 6;
  var DEFAULT_OPTIONS = {
    dictionary: "alphanum",
    shuffle: true,
    debug: false,
    length: DEFAULT_UUID_LENGTH
  };
  var _ShortUniqueId = class extends Function {
    constructor(argOptions = {}) {
      super();
      this.dictIndex = 0;
      this.dictRange = [];
      this.lowerBound = 0;
      this.upperBound = 0;
      this.dictLength = 0;
      this._digit_first_ascii = 48;
      this._digit_last_ascii = 58;
      this._alpha_lower_first_ascii = 97;
      this._alpha_lower_last_ascii = 123;
      this._hex_last_ascii = 103;
      this._alpha_upper_first_ascii = 65;
      this._alpha_upper_last_ascii = 91;
      this._number_dict_ranges = {
        digits: [this._digit_first_ascii, this._digit_last_ascii]
      };
      this._alpha_dict_ranges = {
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii],
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      };
      this._alpha_lower_dict_ranges = {
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii]
      };
      this._alpha_upper_dict_ranges = {
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      };
      this._alphanum_dict_ranges = {
        digits: [this._digit_first_ascii, this._digit_last_ascii],
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii],
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      };
      this._alphanum_lower_dict_ranges = {
        digits: [this._digit_first_ascii, this._digit_last_ascii],
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii]
      };
      this._alphanum_upper_dict_ranges = {
        digits: [this._digit_first_ascii, this._digit_last_ascii],
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      };
      this._hex_dict_ranges = {
        decDigits: [this._digit_first_ascii, this._digit_last_ascii],
        alphaDigits: [this._alpha_lower_first_ascii, this._hex_last_ascii]
      };
      this.log = (...args) => {
        const finalArgs = [...args];
        finalArgs[0] = `[short-unique-id] ${args[0]}`;
        if (this.debug === true) {
          if (typeof console !== "undefined" && console !== null) {
            return console.log(...finalArgs);
          }
        }
      };
      this.setDictionary = (dictionary, shuffle) => {
        let finalDict;
        if (dictionary && Array.isArray(dictionary) && dictionary.length > 1) {
          finalDict = dictionary;
        } else {
          finalDict = [];
          let i;
          this.dictIndex = i = 0;
          const rangesName = `_${dictionary}_dict_ranges`;
          const ranges = this[rangesName];
          Object.keys(ranges).forEach((rangeType) => {
            const rangeTypeKey = rangeType;
            this.dictRange = ranges[rangeTypeKey];
            this.lowerBound = this.dictRange[0];
            this.upperBound = this.dictRange[1];
            for (this.dictIndex = i = this.lowerBound; this.lowerBound <= this.upperBound ? i < this.upperBound : i > this.upperBound; this.dictIndex = this.lowerBound <= this.upperBound ? i += 1 : i -= 1) {
              finalDict.push(String.fromCharCode(this.dictIndex));
            }
          });
        }
        if (shuffle) {
          const PROBABILITY = 0.5;
          finalDict = finalDict.sort(() => Math.random() - PROBABILITY);
        }
        this.dict = finalDict;
        this.dictLength = this.dict.length;
        this.counter = 0;
      };
      this.seq = () => {
        return this.sequentialUUID();
      };
      this.sequentialUUID = () => {
        let counterDiv;
        let counterRem;
        let id = "";
        counterDiv = this.counter;
        do {
          counterRem = counterDiv % this.dictLength;
          counterDiv = Math.trunc(counterDiv / this.dictLength);
          id += this.dict[counterRem];
        } while (counterDiv !== 0);
        this.counter += 1;
        return id;
      };
      this.randomUUID = (uuidLength = this.uuidLength || DEFAULT_UUID_LENGTH) => {
        let id;
        let randomPartIdx;
        let j;
        if (uuidLength === null || typeof uuidLength === "undefined" || uuidLength < 1) {
          throw new Error("Invalid UUID Length Provided");
        }
        const isPositive = uuidLength >= 0;
        id = "";
        for (j = 0; j < uuidLength; j += 1) {
          randomPartIdx = parseInt((Math.random() * this.dictLength).toFixed(0), 10) % this.dictLength;
          id += this.dict[randomPartIdx];
        }
        return id;
      };
      this.availableUUIDs = (uuidLength = this.uuidLength) => {
        return parseFloat(Math.pow([...new Set(this.dict)].length, uuidLength).toFixed(0));
      };
      this.approxMaxBeforeCollision = (rounds = this.availableUUIDs(this.uuidLength)) => {
        return parseFloat(Math.sqrt(Math.PI / 2 * rounds).toFixed(20));
      };
      this.collisionProbability = (rounds = this.availableUUIDs(this.uuidLength), uuidLength = this.uuidLength) => {
        return parseFloat((this.approxMaxBeforeCollision(rounds) / this.availableUUIDs(uuidLength)).toFixed(20));
      };
      this.uniqueness = (rounds = this.availableUUIDs(this.uuidLength)) => {
        const score = parseFloat((1 - this.approxMaxBeforeCollision(rounds) / rounds).toFixed(20));
        return score > 1 ? 1 : score < 0 ? 0 : score;
      };
      this.getVersion = () => {
        return this.version;
      };
      this.stamp = (finalLength) => {
        if (typeof finalLength !== "number" || finalLength < 10) {
          throw new Error("Param finalLength must be number greater than 10");
        }
        const hexStamp = Math.floor(+new Date() / 1e3).toString(16);
        const idLength = finalLength - 9;
        const rndIdx = Math.round(Math.random() * (idLength > 15 ? 15 : idLength));
        const id = this.randomUUID(idLength);
        return `${id.substr(0, rndIdx)}${hexStamp}${id.substr(rndIdx)}${rndIdx.toString(16)}`;
      };
      this.parseStamp = (stamp) => {
        if (stamp.length < 10) {
          throw new Error("Stamp length invalid");
        }
        const rndIdx = parseInt(stamp.substr(stamp.length - 1, 1), 16);
        return new Date(parseInt(stamp.substr(rndIdx, 8), 16) * 1e3);
      };
      const options = __spreadValues(__spreadValues({}, DEFAULT_OPTIONS), argOptions);
      this.counter = 0;
      this.debug = false;
      this.dict = [];
      this.version = version;
      const {
        dictionary,
        shuffle,
        length
      } = options;
      this.uuidLength = length;
      this.setDictionary(dictionary, shuffle);
      this.debug = options.debug;
      this.log(this.dict);
      this.log(`Generator instantiated with Dictionary Size ${this.dictLength}`);
      return new Proxy(this, {
        apply: (target, that, args) => this.randomUUID(...args)
      });
    }
  };
  var ShortUniqueId = _ShortUniqueId;
  ShortUniqueId.default = _ShortUniqueId;
  return src_exports;
})();
//# sourceMappingURL=short-unique-id.js.map
 true&&(module.exports=ShortUniqueId.default),'undefined'!=typeof window&&(ShortUniqueId=ShortUniqueId.default);

/***/ }),

/***/ 37478:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var GetIntrinsic = __webpack_require__(40210);
var callBound = __webpack_require__(21924);
var inspect = __webpack_require__(70631);

var $TypeError = GetIntrinsic('%TypeError%');
var $WeakMap = GetIntrinsic('%WeakMap%', true);
var $Map = GetIntrinsic('%Map%', true);

var $weakMapGet = callBound('WeakMap.prototype.get', true);
var $weakMapSet = callBound('WeakMap.prototype.set', true);
var $weakMapHas = callBound('WeakMap.prototype.has', true);
var $mapGet = callBound('Map.prototype.get', true);
var $mapSet = callBound('Map.prototype.set', true);
var $mapHas = callBound('Map.prototype.has', true);

/*
 * This function traverses the list returning the node corresponding to the
 * given key.
 *
 * That node is also moved to the head of the list, so that if it's accessed
 * again we don't need to traverse the whole list. By doing so, all the recently
 * used nodes can be accessed relatively quickly.
 */
var listGetNode = function (list, key) { // eslint-disable-line consistent-return
	for (var prev = list, curr; (curr = prev.next) !== null; prev = curr) {
		if (curr.key === key) {
			prev.next = curr.next;
			curr.next = list.next;
			list.next = curr; // eslint-disable-line no-param-reassign
			return curr;
		}
	}
};

var listGet = function (objects, key) {
	var node = listGetNode(objects, key);
	return node && node.value;
};
var listSet = function (objects, key, value) {
	var node = listGetNode(objects, key);
	if (node) {
		node.value = value;
	} else {
		// Prepend the new node to the beginning of the list
		objects.next = { // eslint-disable-line no-param-reassign
			key: key,
			next: objects.next,
			value: value
		};
	}
};
var listHas = function (objects, key) {
	return !!listGetNode(objects, key);
};

module.exports = function getSideChannel() {
	var $wm;
	var $m;
	var $o;
	var channel = {
		assert: function (key) {
			if (!channel.has(key)) {
				throw new $TypeError('Side channel does not contain ' + inspect(key));
			}
		},
		get: function (key) { // eslint-disable-line consistent-return
			if ($WeakMap && key && (typeof key === 'object' || typeof key === 'function')) {
				if ($wm) {
					return $weakMapGet($wm, key);
				}
			} else if ($Map) {
				if ($m) {
					return $mapGet($m, key);
				}
			} else {
				if ($o) { // eslint-disable-line no-lonely-if
					return listGet($o, key);
				}
			}
		},
		has: function (key) {
			if ($WeakMap && key && (typeof key === 'object' || typeof key === 'function')) {
				if ($wm) {
					return $weakMapHas($wm, key);
				}
			} else if ($Map) {
				if ($m) {
					return $mapHas($m, key);
				}
			} else {
				if ($o) { // eslint-disable-line no-lonely-if
					return listHas($o, key);
				}
			}
			return false;
		},
		set: function (key, value) {
			if ($WeakMap && key && (typeof key === 'object' || typeof key === 'function')) {
				if (!$wm) {
					$wm = new $WeakMap();
				}
				$weakMapSet($wm, key, value);
			} else if ($Map) {
				if (!$m) {
					$m = new $Map();
				}
				$mapSet($m, key, value);
			} else {
				if (!$o) {
					/*
					 * Initialize the linked list as an empty node, so that we don't have
					 * to special-case handling of the first node: we can always refer to
					 * it as (previous node).next, instead of something like (list).head
					 */
					$o = { key: {}, next: null };
				}
				listSet($o, key, value);
			}
		}
	};
	return channel;
};


/***/ }),

/***/ 43992:
/***/ ((module) => {

!function(){"use strict";var u,c,a,s,f,y="properties",l="deepProperties",b="propertyDescriptors",d="staticProperties",O="staticDeepProperties",h="staticPropertyDescriptors",g="configuration",m="deepConfiguration",P="deepProps",A="deepStatics",j="deepConf",v="initializers",_="methods",w="composers",D="compose";function S(r){return Object.getOwnPropertyNames(r).concat(Object.getOwnPropertySymbols?Object.getOwnPropertySymbols(r):[])}function r(r,t){return Array.prototype.slice.call(arguments,2).reduce(r,t)}var x=r.bind(0,function r(t,e){if(e)for(var n=S(e),o=0;o<n.length;o+=1)Object.defineProperty(t,n[o],Object.getOwnPropertyDescriptor(e,n[o]));return t});function C(r){return"function"==typeof r}function N(r){return r&&"object"==typeof r||C(r)}function z(r){return r&&"object"==typeof r&&r.__proto__==Object.prototype}var E=r.bind(0,function r(t,e){if(e===u)return t;if(Array.isArray(e))return(Array.isArray(t)?t:[]).concat(e);if(!z(e))return e;for(var n,o,i=S(e),p=0;p<i.length;)n=i[p++],(o=Object.getOwnPropertyDescriptor(e,n)).hasOwnProperty("value")?o.value!==u&&(t[n]=r(z(t[n])||Array.isArray(e[n])?t[n]:{},e[n])):Object.defineProperty(t,n,o);return t});function I(){return(c=Array.prototype.concat.apply([],arguments).filter(function(r,t,e){return C(r)&&e.indexOf(r)===t})).length?c:u}function t(r){return c=function r(){return function r(t){var e,n,o=r[D]||{},i={__proto__:o[_]},p=o[v],c=Array.prototype.slice.apply(arguments),a=o[l];if(a&&E(i,a),(a=o[y])&&x(i,a),(a=o[b])&&Object.defineProperties(i,a),!p||!p.length)return i;for(t===u&&(t={}),o=0;o<p.length;)C(e=p[o++])&&(i=(n=e.call(i,t,{instance:i,stamp:r,args:c}))===u?i:n);return i}}(),(a=r[O])&&E(c,a),(a=r[d])&&x(c,a),(a=r[h])&&Object.defineProperties(c,a),a=C(c[D])?c[D]:R,x(c[D]=function(){return a.apply(this,arguments)},r),c}function e(e,n){function r(r,t){N(n[r])&&(N(e[r])||(e[r]={}),(t||x)(e[r],n[r]))}function t(r){(c=I(e[r],n[r]))&&(e[r]=c)}return n&&N(n=n[D]||n)&&(r(_),r(y),r(l,E),r(b),r(d),r(O,E),r(h),r(g),r(m,E),t(v),t(w)),e}function R(){return t(Array.prototype.concat.apply([this],arguments).reduce(e,{}))}function V(r){return C(r)&&C(r[D])}var n={};function o(r,t){return function(){return(s={})[r]=t.apply(u,Array.prototype.concat.apply([{}],arguments)),((c=this)&&c[D]||a).call(c,s)}}n[_]=o(_,x),n[y]=n.props=o(y,x),n[v]=n.init=o(v,I),n[w]=o(w,I),n[l]=n[P]=o(l,E),n[d]=n.statics=o(d,x),n[O]=n[A]=o(O,E),n[g]=n.conf=o(g,x),n[m]=n[j]=o(m,E),n[b]=o(b,x),n[h]=o(h,x),a=n[D]=x(function r(){for(var t,e,n=0,o=[],i=arguments,p=this;n<i.length;)N(t=i[n++])&&o.push(V(t)?t:((s={})[_]=(e=t)[_]||u,a=e.props,s[y]=N((c=e[y])||a)?x({},a,c):u,s[v]=I(e.init,e[v]),s[w]=I(e[w]),a=e[P],s[l]=N((c=e[l])||a)?E({},a,c):u,s[b]=e[b],a=e.statics,s[d]=N((c=e[d])||a)?x({},a,c):u,a=e[A],s[O]=N((c=e[O])||a)?E({},a,c):u,c=e[h],s[h]=N((a=e.name&&{name:{value:e.name}})||c)?x({},c,a):u,a=e.conf,s[g]=N((c=e[g])||a)?x({},a,c):u,a=e[j],s[m]=N((c=e[m])||a)?E({},a,c):u,s));if(t=R.apply(p||f,o),p&&o.unshift(p),Array.isArray(i=t[D][w]))for(n=0;n<i.length;)t=V(p=i[n++]({stamp:t,composables:o}))?p:t;return t},n),n.create=function(){return this.apply(u,arguments)},(s={})[d]=n,f=R(s),a[D]=a.bind(),a.version="4.3.2",typeof u!="object"?module.exports=a:self.stampit=a}();

/***/ }),

/***/ 13692:
/***/ ((module) => {

"use strict";


// TODO: use call-bind, is-date, is-regex, is-string, is-boolean-object, is-number-object
function toS(obj) { return Object.prototype.toString.call(obj); }
function isDate(obj) { return toS(obj) === '[object Date]'; }
function isRegExp(obj) { return toS(obj) === '[object RegExp]'; }
function isError(obj) { return toS(obj) === '[object Error]'; }
function isBoolean(obj) { return toS(obj) === '[object Boolean]'; }
function isNumber(obj) { return toS(obj) === '[object Number]'; }
function isString(obj) { return toS(obj) === '[object String]'; }

// TODO: use isarray
var isArray = Array.isArray || function isArray(xs) {
	return Object.prototype.toString.call(xs) === '[object Array]';
};

// TODO: use for-each?
function forEach(xs, fn) {
	if (xs.forEach) { return xs.forEach(fn); }
	for (var i = 0; i < xs.length; i++) {
		fn(xs[i], i, xs);
	}
	return void undefined;
}

// TODO: use object-keys
var objectKeys = Object.keys || function keys(obj) {
	var res = [];
	for (var key in obj) { res.push(key); } // eslint-disable-line no-restricted-syntax
	return res;
};

// TODO: use object.hasown
var hasOwnProperty = Object.prototype.hasOwnProperty || function (obj, key) {
	return key in obj;
};

function copy(src) {
	if (typeof src === 'object' && src !== null) {
		var dst;

		if (isArray(src)) {
			dst = [];
		} else if (isDate(src)) {
			dst = new Date(src.getTime ? src.getTime() : src);
		} else if (isRegExp(src)) {
			dst = new RegExp(src);
		} else if (isError(src)) {
			dst = { message: src.message };
		} else if (isBoolean(src) || isNumber(src) || isString(src)) {
			dst = Object(src);
		} else if (Object.create && Object.getPrototypeOf) {
			dst = Object.create(Object.getPrototypeOf(src));
		} else if (src.constructor === Object) {
			dst = {};
		} else {
			var proto = (src.constructor && src.constructor.prototype)
                || src.__proto__
                || {};
			var T = function T() {}; // eslint-disable-line func-style, func-name-matching
			T.prototype = proto;
			dst = new T();
		}

		forEach(objectKeys(src), function (key) {
			dst[key] = src[key];
		});
		return dst;
	}
	return src;
}

function walk(root, cb, immutable) {
	var path = [];
	var parents = [];
	var alive = true;

	return (function walker(node_) {
		var node = immutable ? copy(node_) : node_;
		var modifiers = {};

		var keepGoing = true;

		var state = {
			node: node,
			node_: node_,
			path: [].concat(path),
			parent: parents[parents.length - 1],
			parents: parents,
			key: path[path.length - 1],
			isRoot: path.length === 0,
			level: path.length,
			circular: null,
			update: function (x, stopHere) {
				if (!state.isRoot) {
					state.parent.node[state.key] = x;
				}
				state.node = x;
				if (stopHere) { keepGoing = false; }
			},
			delete: function (stopHere) {
				delete state.parent.node[state.key];
				if (stopHere) { keepGoing = false; }
			},
			remove: function (stopHere) {
				if (isArray(state.parent.node)) {
					state.parent.node.splice(state.key, 1);
				} else {
					delete state.parent.node[state.key];
				}
				if (stopHere) { keepGoing = false; }
			},
			keys: null,
			before: function (f) { modifiers.before = f; },
			after: function (f) { modifiers.after = f; },
			pre: function (f) { modifiers.pre = f; },
			post: function (f) { modifiers.post = f; },
			stop: function () { alive = false; },
			block: function () { keepGoing = false; },
		};

		if (!alive) { return state; }

		function updateState() {
			if (typeof state.node === 'object' && state.node !== null) {
				if (!state.keys || state.node_ !== state.node) {
					state.keys = objectKeys(state.node);
				}

				state.isLeaf = state.keys.length === 0;

				for (var i = 0; i < parents.length; i++) {
					if (parents[i].node_ === node_) {
						state.circular = parents[i];
						break; // eslint-disable-line no-restricted-syntax
					}
				}
			} else {
				state.isLeaf = true;
				state.keys = null;
			}

			state.notLeaf = !state.isLeaf;
			state.notRoot = !state.isRoot;
		}

		updateState();

		// use return values to update if defined
		var ret = cb.call(state, state.node);
		if (ret !== undefined && state.update) { state.update(ret); }

		if (modifiers.before) { modifiers.before.call(state, state.node); }

		if (!keepGoing) { return state; }

		if (
			typeof state.node === 'object'
			&& state.node !== null
			&& !state.circular
		) {
			parents.push(state);

			updateState();

			forEach(state.keys, function (key, i) {
				path.push(key);

				if (modifiers.pre) { modifiers.pre.call(state, state.node[key], key); }

				var child = walker(state.node[key]);
				if (immutable && hasOwnProperty.call(state.node, key)) {
					state.node[key] = child.node;
				}

				child.isLast = i === state.keys.length - 1;
				child.isFirst = i === 0;

				if (modifiers.post) { modifiers.post.call(state, child); }

				path.pop();
			});
			parents.pop();
		}

		if (modifiers.after) { modifiers.after.call(state, state.node); }

		return state;
	}(root)).node;
}

function Traverse(obj) {
	this.value = obj;
}

Traverse.prototype.get = function (ps) {
	var node = this.value;
	for (var i = 0; i < ps.length; i++) {
		var key = ps[i];
		if (!node || !hasOwnProperty.call(node, key)) {
			return void undefined;
		}
		node = node[key];
	}
	return node;
};

Traverse.prototype.has = function (ps) {
	var node = this.value;
	for (var i = 0; i < ps.length; i++) {
		var key = ps[i];
		if (!node || !hasOwnProperty.call(node, key)) {
			return false;
		}
		node = node[key];
	}
	return true;
};

Traverse.prototype.set = function (ps, value) {
	var node = this.value;
	for (var i = 0; i < ps.length - 1; i++) {
		var key = ps[i];
		if (!hasOwnProperty.call(node, key)) { node[key] = {}; }
		node = node[key];
	}
	node[ps[i]] = value;
	return value;
};

Traverse.prototype.map = function (cb) {
	return walk(this.value, cb, true);
};

Traverse.prototype.forEach = function (cb) {
	this.value = walk(this.value, cb, false);
	return this.value;
};

Traverse.prototype.reduce = function (cb, init) {
	var skip = arguments.length === 1;
	var acc = skip ? this.value : init;
	this.forEach(function (x) {
		if (!this.isRoot || !skip) {
			acc = cb.call(this, acc, x);
		}
	});
	return acc;
};

Traverse.prototype.paths = function () {
	var acc = [];
	this.forEach(function () {
		acc.push(this.path);
	});
	return acc;
};

Traverse.prototype.nodes = function () {
	var acc = [];
	this.forEach(function () {
		acc.push(this.node);
	});
	return acc;
};

Traverse.prototype.clone = function () {
	var parents = [];
	var nodes = [];

	return (function clone(src) {
		for (var i = 0; i < parents.length; i++) {
			if (parents[i] === src) {
				return nodes[i];
			}
		}

		if (typeof src === 'object' && src !== null) {
			var dst = copy(src);

			parents.push(src);
			nodes.push(dst);

			forEach(objectKeys(src), function (key) {
				dst[key] = clone(src[key]);
			});

			parents.pop();
			nodes.pop();
			return dst;
		}

		return src;

	}(this.value));
};

function traverse(obj) {
	return new Traverse(obj);
}

// TODO: replace with object.assign?
forEach(objectKeys(Traverse.prototype), function (key) {
	traverse[key] = function (obj) {
		var args = [].slice.call(arguments, 1);
		var t = new Traverse(obj);
		return t[key].apply(t, args);
	};
});

module.exports = traverse;


/***/ }),

/***/ 52511:
/***/ (function(module, exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
var __WEBPACK_AMD_DEFINE_RESULT__;/*! https://mths.be/punycode v1.3.2 by @mathias */
;(function(root) {

	/** Detect free variables */
	var freeExports =  true && exports &&
		!exports.nodeType && exports;
	var freeModule =  true && module &&
		!module.nodeType && module;
	var freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g;
	if (
		freeGlobal.global === freeGlobal ||
		freeGlobal.window === freeGlobal ||
		freeGlobal.self === freeGlobal
	) {
		root = freeGlobal;
	}

	/**
	 * The `punycode` object.
	 * @name punycode
	 * @type Object
	 */
	var punycode,

	/** Highest positive signed 32-bit float value */
	maxInt = 2147483647, // aka. 0x7FFFFFFF or 2^31-1

	/** Bootstring parameters */
	base = 36,
	tMin = 1,
	tMax = 26,
	skew = 38,
	damp = 700,
	initialBias = 72,
	initialN = 128, // 0x80
	delimiter = '-', // '\x2D'

	/** Regular expressions */
	regexPunycode = /^xn--/,
	regexNonASCII = /[^\x20-\x7E]/, // unprintable ASCII chars + non-ASCII chars
	regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, // RFC 3490 separators

	/** Error messages */
	errors = {
		'overflow': 'Overflow: input needs wider integers to process',
		'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
		'invalid-input': 'Invalid input'
	},

	/** Convenience shortcuts */
	baseMinusTMin = base - tMin,
	floor = Math.floor,
	stringFromCharCode = String.fromCharCode,

	/** Temporary variable */
	key;

	/*--------------------------------------------------------------------------*/

	/**
	 * A generic error utility function.
	 * @private
	 * @param {String} type The error type.
	 * @returns {Error} Throws a `RangeError` with the applicable error message.
	 */
	function error(type) {
		throw RangeError(errors[type]);
	}

	/**
	 * A generic `Array#map` utility function.
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} callback The function that gets called for every array
	 * item.
	 * @returns {Array} A new array of values returned by the callback function.
	 */
	function map(array, fn) {
		var length = array.length;
		var result = [];
		while (length--) {
			result[length] = fn(array[length]);
		}
		return result;
	}

	/**
	 * A simple `Array#map`-like wrapper to work with domain name strings or email
	 * addresses.
	 * @private
	 * @param {String} domain The domain name or email address.
	 * @param {Function} callback The function that gets called for every
	 * character.
	 * @returns {Array} A new string of characters returned by the callback
	 * function.
	 */
	function mapDomain(string, fn) {
		var parts = string.split('@');
		var result = '';
		if (parts.length > 1) {
			// In email addresses, only the domain name should be punycoded. Leave
			// the local part (i.e. everything up to `@`) intact.
			result = parts[0] + '@';
			string = parts[1];
		}
		// Avoid `split(regex)` for IE8 compatibility. See #17.
		string = string.replace(regexSeparators, '\x2E');
		var labels = string.split('.');
		var encoded = map(labels, fn).join('.');
		return result + encoded;
	}

	/**
	 * Creates an array containing the numeric code points of each Unicode
	 * character in the string. While JavaScript uses UCS-2 internally,
	 * this function will convert a pair of surrogate halves (each of which
	 * UCS-2 exposes as separate characters) into a single code point,
	 * matching UTF-16.
	 * @see `punycode.ucs2.encode`
	 * @see <https://mathiasbynens.be/notes/javascript-encoding>
	 * @memberOf punycode.ucs2
	 * @name decode
	 * @param {String} string The Unicode input string (UCS-2).
	 * @returns {Array} The new array of code points.
	 */
	function ucs2decode(string) {
		var output = [],
		    counter = 0,
		    length = string.length,
		    value,
		    extra;
		while (counter < length) {
			value = string.charCodeAt(counter++);
			if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
				// high surrogate, and there is a next character
				extra = string.charCodeAt(counter++);
				if ((extra & 0xFC00) == 0xDC00) { // low surrogate
					output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
				} else {
					// unmatched surrogate; only append this code unit, in case the next
					// code unit is the high surrogate of a surrogate pair
					output.push(value);
					counter--;
				}
			} else {
				output.push(value);
			}
		}
		return output;
	}

	/**
	 * Creates a string based on an array of numeric code points.
	 * @see `punycode.ucs2.decode`
	 * @memberOf punycode.ucs2
	 * @name encode
	 * @param {Array} codePoints The array of numeric code points.
	 * @returns {String} The new Unicode string (UCS-2).
	 */
	function ucs2encode(array) {
		return map(array, function(value) {
			var output = '';
			if (value > 0xFFFF) {
				value -= 0x10000;
				output += stringFromCharCode(value >>> 10 & 0x3FF | 0xD800);
				value = 0xDC00 | value & 0x3FF;
			}
			output += stringFromCharCode(value);
			return output;
		}).join('');
	}

	/**
	 * Converts a basic code point into a digit/integer.
	 * @see `digitToBasic()`
	 * @private
	 * @param {Number} codePoint The basic numeric code point value.
	 * @returns {Number} The numeric value of a basic code point (for use in
	 * representing integers) in the range `0` to `base - 1`, or `base` if
	 * the code point does not represent a value.
	 */
	function basicToDigit(codePoint) {
		if (codePoint - 48 < 10) {
			return codePoint - 22;
		}
		if (codePoint - 65 < 26) {
			return codePoint - 65;
		}
		if (codePoint - 97 < 26) {
			return codePoint - 97;
		}
		return base;
	}

	/**
	 * Converts a digit/integer into a basic code point.
	 * @see `basicToDigit()`
	 * @private
	 * @param {Number} digit The numeric value of a basic code point.
	 * @returns {Number} The basic code point whose value (when used for
	 * representing integers) is `digit`, which needs to be in the range
	 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
	 * used; else, the lowercase form is used. The behavior is undefined
	 * if `flag` is non-zero and `digit` has no uppercase form.
	 */
	function digitToBasic(digit, flag) {
		//  0..25 map to ASCII a..z or A..Z
		// 26..35 map to ASCII 0..9
		return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
	}

	/**
	 * Bias adaptation function as per section 3.4 of RFC 3492.
	 * http://tools.ietf.org/html/rfc3492#section-3.4
	 * @private
	 */
	function adapt(delta, numPoints, firstTime) {
		var k = 0;
		delta = firstTime ? floor(delta / damp) : delta >> 1;
		delta += floor(delta / numPoints);
		for (/* no initialization */; delta > baseMinusTMin * tMax >> 1; k += base) {
			delta = floor(delta / baseMinusTMin);
		}
		return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
	}

	/**
	 * Converts a Punycode string of ASCII-only symbols to a string of Unicode
	 * symbols.
	 * @memberOf punycode
	 * @param {String} input The Punycode string of ASCII-only symbols.
	 * @returns {String} The resulting string of Unicode symbols.
	 */
	function decode(input) {
		// Don't use UCS-2
		var output = [],
		    inputLength = input.length,
		    out,
		    i = 0,
		    n = initialN,
		    bias = initialBias,
		    basic,
		    j,
		    index,
		    oldi,
		    w,
		    k,
		    digit,
		    t,
		    /** Cached calculation results */
		    baseMinusT;

		// Handle the basic code points: let `basic` be the number of input code
		// points before the last delimiter, or `0` if there is none, then copy
		// the first basic code points to the output.

		basic = input.lastIndexOf(delimiter);
		if (basic < 0) {
			basic = 0;
		}

		for (j = 0; j < basic; ++j) {
			// if it's not a basic code point
			if (input.charCodeAt(j) >= 0x80) {
				error('not-basic');
			}
			output.push(input.charCodeAt(j));
		}

		// Main decoding loop: start just after the last delimiter if any basic code
		// points were copied; start at the beginning otherwise.

		for (index = basic > 0 ? basic + 1 : 0; index < inputLength; /* no final expression */) {

			// `index` is the index of the next character to be consumed.
			// Decode a generalized variable-length integer into `delta`,
			// which gets added to `i`. The overflow checking is easier
			// if we increase `i` as we go, then subtract off its starting
			// value at the end to obtain `delta`.
			for (oldi = i, w = 1, k = base; /* no condition */; k += base) {

				if (index >= inputLength) {
					error('invalid-input');
				}

				digit = basicToDigit(input.charCodeAt(index++));

				if (digit >= base || digit > floor((maxInt - i) / w)) {
					error('overflow');
				}

				i += digit * w;
				t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);

				if (digit < t) {
					break;
				}

				baseMinusT = base - t;
				if (w > floor(maxInt / baseMinusT)) {
					error('overflow');
				}

				w *= baseMinusT;

			}

			out = output.length + 1;
			bias = adapt(i - oldi, out, oldi == 0);

			// `i` was supposed to wrap around from `out` to `0`,
			// incrementing `n` each time, so we'll fix that now:
			if (floor(i / out) > maxInt - n) {
				error('overflow');
			}

			n += floor(i / out);
			i %= out;

			// Insert `n` at position `i` of the output
			output.splice(i++, 0, n);

		}

		return ucs2encode(output);
	}

	/**
	 * Converts a string of Unicode symbols (e.g. a domain name label) to a
	 * Punycode string of ASCII-only symbols.
	 * @memberOf punycode
	 * @param {String} input The string of Unicode symbols.
	 * @returns {String} The resulting Punycode string of ASCII-only symbols.
	 */
	function encode(input) {
		var n,
		    delta,
		    handledCPCount,
		    basicLength,
		    bias,
		    j,
		    m,
		    q,
		    k,
		    t,
		    currentValue,
		    output = [],
		    /** `inputLength` will hold the number of code points in `input`. */
		    inputLength,
		    /** Cached calculation results */
		    handledCPCountPlusOne,
		    baseMinusT,
		    qMinusT;

		// Convert the input in UCS-2 to Unicode
		input = ucs2decode(input);

		// Cache the length
		inputLength = input.length;

		// Initialize the state
		n = initialN;
		delta = 0;
		bias = initialBias;

		// Handle the basic code points
		for (j = 0; j < inputLength; ++j) {
			currentValue = input[j];
			if (currentValue < 0x80) {
				output.push(stringFromCharCode(currentValue));
			}
		}

		handledCPCount = basicLength = output.length;

		// `handledCPCount` is the number of code points that have been handled;
		// `basicLength` is the number of basic code points.

		// Finish the basic string - if it is not empty - with a delimiter
		if (basicLength) {
			output.push(delimiter);
		}

		// Main encoding loop:
		while (handledCPCount < inputLength) {

			// All non-basic code points < n have been handled already. Find the next
			// larger one:
			for (m = maxInt, j = 0; j < inputLength; ++j) {
				currentValue = input[j];
				if (currentValue >= n && currentValue < m) {
					m = currentValue;
				}
			}

			// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
			// but guard against overflow
			handledCPCountPlusOne = handledCPCount + 1;
			if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
				error('overflow');
			}

			delta += (m - n) * handledCPCountPlusOne;
			n = m;

			for (j = 0; j < inputLength; ++j) {
				currentValue = input[j];

				if (currentValue < n && ++delta > maxInt) {
					error('overflow');
				}

				if (currentValue == n) {
					// Represent delta as a generalized variable-length integer
					for (q = delta, k = base; /* no condition */; k += base) {
						t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
						if (q < t) {
							break;
						}
						qMinusT = q - t;
						baseMinusT = base - t;
						output.push(
							stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
						);
						q = floor(qMinusT / baseMinusT);
					}

					output.push(stringFromCharCode(digitToBasic(q, 0)));
					bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
					delta = 0;
					++handledCPCount;
				}
			}

			++delta;
			++n;

		}
		return output.join('');
	}

	/**
	 * Converts a Punycode string representing a domain name or an email address
	 * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
	 * it doesn't matter if you call it on a string that has already been
	 * converted to Unicode.
	 * @memberOf punycode
	 * @param {String} input The Punycoded domain name or email address to
	 * convert to Unicode.
	 * @returns {String} The Unicode representation of the given Punycode
	 * string.
	 */
	function toUnicode(input) {
		return mapDomain(input, function(string) {
			return regexPunycode.test(string)
				? decode(string.slice(4).toLowerCase())
				: string;
		});
	}

	/**
	 * Converts a Unicode string representing a domain name or an email address to
	 * Punycode. Only the non-ASCII parts of the domain name will be converted,
	 * i.e. it doesn't matter if you call it with a domain that's already in
	 * ASCII.
	 * @memberOf punycode
	 * @param {String} input The domain name or email address to convert, as a
	 * Unicode string.
	 * @returns {String} The Punycode representation of the given domain name or
	 * email address.
	 */
	function toASCII(input) {
		return mapDomain(input, function(string) {
			return regexNonASCII.test(string)
				? 'xn--' + encode(string)
				: string;
		});
	}

	/*--------------------------------------------------------------------------*/

	/** Define the public API */
	punycode = {
		/**
		 * A string representing the current Punycode.js version number.
		 * @memberOf punycode
		 * @type String
		 */
		'version': '1.3.2',
		/**
		 * An object of methods to convert from JavaScript's internal character
		 * representation (UCS-2) to Unicode code points, and back.
		 * @see <https://mathiasbynens.be/notes/javascript-encoding>
		 * @memberOf punycode
		 * @type Object
		 */
		'ucs2': {
			'decode': ucs2decode,
			'encode': ucs2encode
		},
		'decode': decode,
		'encode': encode,
		'toASCII': toASCII,
		'toUnicode': toUnicode
	};

	/** Expose `punycode` */
	// Some AMD build optimizers, like r.js, check for specific condition patterns
	// like the following:
	if (
		true
	) {
		!(__WEBPACK_AMD_DEFINE_RESULT__ = (function() {
			return punycode;
		}).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}

}(this));


/***/ }),

/***/ 27225:
/***/ ((module) => {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



// If obj.hasOwnProperty has been overridden, then calling
// obj.hasOwnProperty(prop) will break.
// See: https://github.com/joyent/node/issues/1707
function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

module.exports = function(qs, sep, eq, options) {
  sep = sep || '&';
  eq = eq || '=';
  var obj = {};

  if (typeof qs !== 'string' || qs.length === 0) {
    return obj;
  }

  var regexp = /\+/g;
  qs = qs.split(sep);

  var maxKeys = 1000;
  if (options && typeof options.maxKeys === 'number') {
    maxKeys = options.maxKeys;
  }

  var len = qs.length;
  // maxKeys <= 0 means that we should not limit keys count
  if (maxKeys > 0 && len > maxKeys) {
    len = maxKeys;
  }

  for (var i = 0; i < len; ++i) {
    var x = qs[i].replace(regexp, '%20'),
        idx = x.indexOf(eq),
        kstr, vstr, k, v;

    if (idx >= 0) {
      kstr = x.substr(0, idx);
      vstr = x.substr(idx + 1);
    } else {
      kstr = x;
      vstr = '';
    }

    k = decodeURIComponent(kstr);
    v = decodeURIComponent(vstr);

    if (!hasOwnProperty(obj, k)) {
      obj[k] = v;
    } else if (Array.isArray(obj[k])) {
      obj[k].push(v);
    } else {
      obj[k] = [obj[k], v];
    }
  }

  return obj;
};


/***/ }),

/***/ 44066:
/***/ ((module) => {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



var stringifyPrimitive = function(v) {
  switch (typeof v) {
    case 'string':
      return v;

    case 'boolean':
      return v ? 'true' : 'false';

    case 'number':
      return isFinite(v) ? v : '';

    default:
      return '';
  }
};

module.exports = function(obj, sep, eq, name) {
  sep = sep || '&';
  eq = eq || '=';
  if (obj === null) {
    obj = undefined;
  }

  if (typeof obj === 'object') {
    return Object.keys(obj).map(function(k) {
      var ks = encodeURIComponent(stringifyPrimitive(k)) + eq;
      if (Array.isArray(obj[k])) {
        return obj[k].map(function(v) {
          return ks + encodeURIComponent(stringifyPrimitive(v));
        }).join(sep);
      } else {
        return ks + encodeURIComponent(stringifyPrimitive(obj[k]));
      }
    }).join(sep);

  }

  if (!name) return '';
  return encodeURIComponent(stringifyPrimitive(name)) + eq +
         encodeURIComponent(stringifyPrimitive(obj));
};


/***/ }),

/***/ 36254:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.decode = exports.parse = __webpack_require__(27225);
exports.encode = exports.stringify = __webpack_require__(44066);


/***/ }),

/***/ 8575:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



var punycode = __webpack_require__(52511);
var util = __webpack_require__(62502);

exports.parse = urlParse;
exports.resolve = urlResolve;
exports.resolveObject = urlResolveObject;
exports.format = urlFormat;

exports.Url = Url;

function Url() {
  this.protocol = null;
  this.slashes = null;
  this.auth = null;
  this.host = null;
  this.port = null;
  this.hostname = null;
  this.hash = null;
  this.search = null;
  this.query = null;
  this.pathname = null;
  this.path = null;
  this.href = null;
}

// Reference: RFC 3986, RFC 1808, RFC 2396

// define these here so at least they only have to be
// compiled once on the first module load.
var protocolPattern = /^([a-z0-9.+-]+:)/i,
    portPattern = /:[0-9]*$/,

    // Special case for a simple path URL
    simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,

    // RFC 2396: characters reserved for delimiting URLs.
    // We actually just auto-escape these.
    delims = ['<', '>', '"', '`', ' ', '\r', '\n', '\t'],

    // RFC 2396: characters not allowed for various reasons.
    unwise = ['{', '}', '|', '\\', '^', '`'].concat(delims),

    // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
    autoEscape = ['\''].concat(unwise),
    // Characters that are never ever allowed in a hostname.
    // Note that any invalid chars are also handled, but these
    // are the ones that are *expected* to be seen, so we fast-path
    // them.
    nonHostChars = ['%', '/', '?', ';', '#'].concat(autoEscape),
    hostEndingChars = ['/', '?', '#'],
    hostnameMaxLen = 255,
    hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
    hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
    // protocols that can allow "unsafe" and "unwise" chars.
    unsafeProtocol = {
      'javascript': true,
      'javascript:': true
    },
    // protocols that never have a hostname.
    hostlessProtocol = {
      'javascript': true,
      'javascript:': true
    },
    // protocols that always contain a // bit.
    slashedProtocol = {
      'http': true,
      'https': true,
      'ftp': true,
      'gopher': true,
      'file': true,
      'http:': true,
      'https:': true,
      'ftp:': true,
      'gopher:': true,
      'file:': true
    },
    querystring = __webpack_require__(36254);

function urlParse(url, parseQueryString, slashesDenoteHost) {
  if (url && util.isObject(url) && url instanceof Url) return url;

  var u = new Url;
  u.parse(url, parseQueryString, slashesDenoteHost);
  return u;
}

Url.prototype.parse = function(url, parseQueryString, slashesDenoteHost) {
  if (!util.isString(url)) {
    throw new TypeError("Parameter 'url' must be a string, not " + typeof url);
  }

  // Copy chrome, IE, opera backslash-handling behavior.
  // Back slashes before the query string get converted to forward slashes
  // See: https://code.google.com/p/chromium/issues/detail?id=25916
  var queryIndex = url.indexOf('?'),
      splitter =
          (queryIndex !== -1 && queryIndex < url.indexOf('#')) ? '?' : '#',
      uSplit = url.split(splitter),
      slashRegex = /\\/g;
  uSplit[0] = uSplit[0].replace(slashRegex, '/');
  url = uSplit.join(splitter);

  var rest = url;

  // trim before proceeding.
  // This is to support parse stuff like "  http://foo.com  \n"
  rest = rest.trim();

  if (!slashesDenoteHost && url.split('#').length === 1) {
    // Try fast path regexp
    var simplePath = simplePathPattern.exec(rest);
    if (simplePath) {
      this.path = rest;
      this.href = rest;
      this.pathname = simplePath[1];
      if (simplePath[2]) {
        this.search = simplePath[2];
        if (parseQueryString) {
          this.query = querystring.parse(this.search.substr(1));
        } else {
          this.query = this.search.substr(1);
        }
      } else if (parseQueryString) {
        this.search = '';
        this.query = {};
      }
      return this;
    }
  }

  var proto = protocolPattern.exec(rest);
  if (proto) {
    proto = proto[0];
    var lowerProto = proto.toLowerCase();
    this.protocol = lowerProto;
    rest = rest.substr(proto.length);
  }

  // figure out if it's got a host
  // user@server is *always* interpreted as a hostname, and url
  // resolution will treat //foo/bar as host=foo,path=bar because that's
  // how the browser resolves relative URLs.
  if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
    var slashes = rest.substr(0, 2) === '//';
    if (slashes && !(proto && hostlessProtocol[proto])) {
      rest = rest.substr(2);
      this.slashes = true;
    }
  }

  if (!hostlessProtocol[proto] &&
      (slashes || (proto && !slashedProtocol[proto]))) {

    // there's a hostname.
    // the first instance of /, ?, ;, or # ends the host.
    //
    // If there is an @ in the hostname, then non-host chars *are* allowed
    // to the left of the last @ sign, unless some host-ending character
    // comes *before* the @-sign.
    // URLs are obnoxious.
    //
    // ex:
    // http://a@b@c/ => user:a@b host:c
    // http://a@b?@c => user:a host:c path:/?@c

    // v0.12 TODO(isaacs): This is not quite how Chrome does things.
    // Review our test case against browsers more comprehensively.

    // find the first instance of any hostEndingChars
    var hostEnd = -1;
    for (var i = 0; i < hostEndingChars.length; i++) {
      var hec = rest.indexOf(hostEndingChars[i]);
      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
        hostEnd = hec;
    }

    // at this point, either we have an explicit point where the
    // auth portion cannot go past, or the last @ char is the decider.
    var auth, atSign;
    if (hostEnd === -1) {
      // atSign can be anywhere.
      atSign = rest.lastIndexOf('@');
    } else {
      // atSign must be in auth portion.
      // http://a@b/c@d => host:b auth:a path:/c@d
      atSign = rest.lastIndexOf('@', hostEnd);
    }

    // Now we have a portion which is definitely the auth.
    // Pull that off.
    if (atSign !== -1) {
      auth = rest.slice(0, atSign);
      rest = rest.slice(atSign + 1);
      this.auth = decodeURIComponent(auth);
    }

    // the host is the remaining to the left of the first non-host char
    hostEnd = -1;
    for (var i = 0; i < nonHostChars.length; i++) {
      var hec = rest.indexOf(nonHostChars[i]);
      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
        hostEnd = hec;
    }
    // if we still have not hit it, then the entire thing is a host.
    if (hostEnd === -1)
      hostEnd = rest.length;

    this.host = rest.slice(0, hostEnd);
    rest = rest.slice(hostEnd);

    // pull out port.
    this.parseHost();

    // we've indicated that there is a hostname,
    // so even if it's empty, it has to be present.
    this.hostname = this.hostname || '';

    // if hostname begins with [ and ends with ]
    // assume that it's an IPv6 address.
    var ipv6Hostname = this.hostname[0] === '[' &&
        this.hostname[this.hostname.length - 1] === ']';

    // validate a little.
    if (!ipv6Hostname) {
      var hostparts = this.hostname.split(/\./);
      for (var i = 0, l = hostparts.length; i < l; i++) {
        var part = hostparts[i];
        if (!part) continue;
        if (!part.match(hostnamePartPattern)) {
          var newpart = '';
          for (var j = 0, k = part.length; j < k; j++) {
            if (part.charCodeAt(j) > 127) {
              // we replace non-ASCII char with a temporary placeholder
              // we need this to make sure size of hostname is not
              // broken by replacing non-ASCII by nothing
              newpart += 'x';
            } else {
              newpart += part[j];
            }
          }
          // we test again with ASCII char only
          if (!newpart.match(hostnamePartPattern)) {
            var validParts = hostparts.slice(0, i);
            var notHost = hostparts.slice(i + 1);
            var bit = part.match(hostnamePartStart);
            if (bit) {
              validParts.push(bit[1]);
              notHost.unshift(bit[2]);
            }
            if (notHost.length) {
              rest = '/' + notHost.join('.') + rest;
            }
            this.hostname = validParts.join('.');
            break;
          }
        }
      }
    }

    if (this.hostname.length > hostnameMaxLen) {
      this.hostname = '';
    } else {
      // hostnames are always lower case.
      this.hostname = this.hostname.toLowerCase();
    }

    if (!ipv6Hostname) {
      // IDNA Support: Returns a punycoded representation of "domain".
      // It only converts parts of the domain name that
      // have non-ASCII characters, i.e. it doesn't matter if
      // you call it with a domain that already is ASCII-only.
      this.hostname = punycode.toASCII(this.hostname);
    }

    var p = this.port ? ':' + this.port : '';
    var h = this.hostname || '';
    this.host = h + p;
    this.href += this.host;

    // strip [ and ] from the hostname
    // the host field still retains them, though
    if (ipv6Hostname) {
      this.hostname = this.hostname.substr(1, this.hostname.length - 2);
      if (rest[0] !== '/') {
        rest = '/' + rest;
      }
    }
  }

  // now rest is set to the post-host stuff.
  // chop off any delim chars.
  if (!unsafeProtocol[lowerProto]) {

    // First, make 100% sure that any "autoEscape" chars get
    // escaped, even if encodeURIComponent doesn't think they
    // need to be.
    for (var i = 0, l = autoEscape.length; i < l; i++) {
      var ae = autoEscape[i];
      if (rest.indexOf(ae) === -1)
        continue;
      var esc = encodeURIComponent(ae);
      if (esc === ae) {
        esc = escape(ae);
      }
      rest = rest.split(ae).join(esc);
    }
  }


  // chop off from the tail first.
  var hash = rest.indexOf('#');
  if (hash !== -1) {
    // got a fragment string.
    this.hash = rest.substr(hash);
    rest = rest.slice(0, hash);
  }
  var qm = rest.indexOf('?');
  if (qm !== -1) {
    this.search = rest.substr(qm);
    this.query = rest.substr(qm + 1);
    if (parseQueryString) {
      this.query = querystring.parse(this.query);
    }
    rest = rest.slice(0, qm);
  } else if (parseQueryString) {
    // no query string, but parseQueryString still requested
    this.search = '';
    this.query = {};
  }
  if (rest) this.pathname = rest;
  if (slashedProtocol[lowerProto] &&
      this.hostname && !this.pathname) {
    this.pathname = '/';
  }

  //to support http.request
  if (this.pathname || this.search) {
    var p = this.pathname || '';
    var s = this.search || '';
    this.path = p + s;
  }

  // finally, reconstruct the href based on what has been validated.
  this.href = this.format();
  return this;
};

// format a parsed object into a url string
function urlFormat(obj) {
  // ensure it's an object, and not a string url.
  // If it's an obj, this is a no-op.
  // this way, you can call url_format() on strings
  // to clean up potentially wonky urls.
  if (util.isString(obj)) obj = urlParse(obj);
  if (!(obj instanceof Url)) return Url.prototype.format.call(obj);
  return obj.format();
}

Url.prototype.format = function() {
  var auth = this.auth || '';
  if (auth) {
    auth = encodeURIComponent(auth);
    auth = auth.replace(/%3A/i, ':');
    auth += '@';
  }

  var protocol = this.protocol || '',
      pathname = this.pathname || '',
      hash = this.hash || '',
      host = false,
      query = '';

  if (this.host) {
    host = auth + this.host;
  } else if (this.hostname) {
    host = auth + (this.hostname.indexOf(':') === -1 ?
        this.hostname :
        '[' + this.hostname + ']');
    if (this.port) {
      host += ':' + this.port;
    }
  }

  if (this.query &&
      util.isObject(this.query) &&
      Object.keys(this.query).length) {
    query = querystring.stringify(this.query);
  }

  var search = this.search || (query && ('?' + query)) || '';

  if (protocol && protocol.substr(-1) !== ':') protocol += ':';

  // only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
  // unless they had them to begin with.
  if (this.slashes ||
      (!protocol || slashedProtocol[protocol]) && host !== false) {
    host = '//' + (host || '');
    if (pathname && pathname.charAt(0) !== '/') pathname = '/' + pathname;
  } else if (!host) {
    host = '';
  }

  if (hash && hash.charAt(0) !== '#') hash = '#' + hash;
  if (search && search.charAt(0) !== '?') search = '?' + search;

  pathname = pathname.replace(/[?#]/g, function(match) {
    return encodeURIComponent(match);
  });
  search = search.replace('#', '%23');

  return protocol + host + pathname + search + hash;
};

function urlResolve(source, relative) {
  return urlParse(source, false, true).resolve(relative);
}

Url.prototype.resolve = function(relative) {
  return this.resolveObject(urlParse(relative, false, true)).format();
};

function urlResolveObject(source, relative) {
  if (!source) return relative;
  return urlParse(source, false, true).resolveObject(relative);
}

Url.prototype.resolveObject = function(relative) {
  if (util.isString(relative)) {
    var rel = new Url();
    rel.parse(relative, false, true);
    relative = rel;
  }

  var result = new Url();
  var tkeys = Object.keys(this);
  for (var tk = 0; tk < tkeys.length; tk++) {
    var tkey = tkeys[tk];
    result[tkey] = this[tkey];
  }

  // hash is always overridden, no matter what.
  // even href="" will remove it.
  result.hash = relative.hash;

  // if the relative url is empty, then there's nothing left to do here.
  if (relative.href === '') {
    result.href = result.format();
    return result;
  }

  // hrefs like //foo/bar always cut to the protocol.
  if (relative.slashes && !relative.protocol) {
    // take everything except the protocol from relative
    var rkeys = Object.keys(relative);
    for (var rk = 0; rk < rkeys.length; rk++) {
      var rkey = rkeys[rk];
      if (rkey !== 'protocol')
        result[rkey] = relative[rkey];
    }

    //urlParse appends trailing / to urls like http://www.example.com
    if (slashedProtocol[result.protocol] &&
        result.hostname && !result.pathname) {
      result.path = result.pathname = '/';
    }

    result.href = result.format();
    return result;
  }

  if (relative.protocol && relative.protocol !== result.protocol) {
    // if it's a known url protocol, then changing
    // the protocol does weird things
    // first, if it's not file:, then we MUST have a host,
    // and if there was a path
    // to begin with, then we MUST have a path.
    // if it is file:, then the host is dropped,
    // because that's known to be hostless.
    // anything else is assumed to be absolute.
    if (!slashedProtocol[relative.protocol]) {
      var keys = Object.keys(relative);
      for (var v = 0; v < keys.length; v++) {
        var k = keys[v];
        result[k] = relative[k];
      }
      result.href = result.format();
      return result;
    }

    result.protocol = relative.protocol;
    if (!relative.host && !hostlessProtocol[relative.protocol]) {
      var relPath = (relative.pathname || '').split('/');
      while (relPath.length && !(relative.host = relPath.shift()));
      if (!relative.host) relative.host = '';
      if (!relative.hostname) relative.hostname = '';
      if (relPath[0] !== '') relPath.unshift('');
      if (relPath.length < 2) relPath.unshift('');
      result.pathname = relPath.join('/');
    } else {
      result.pathname = relative.pathname;
    }
    result.search = relative.search;
    result.query = relative.query;
    result.host = relative.host || '';
    result.auth = relative.auth;
    result.hostname = relative.hostname || relative.host;
    result.port = relative.port;
    // to support http.request
    if (result.pathname || result.search) {
      var p = result.pathname || '';
      var s = result.search || '';
      result.path = p + s;
    }
    result.slashes = result.slashes || relative.slashes;
    result.href = result.format();
    return result;
  }

  var isSourceAbs = (result.pathname && result.pathname.charAt(0) === '/'),
      isRelAbs = (
          relative.host ||
          relative.pathname && relative.pathname.charAt(0) === '/'
      ),
      mustEndAbs = (isRelAbs || isSourceAbs ||
                    (result.host && relative.pathname)),
      removeAllDots = mustEndAbs,
      srcPath = result.pathname && result.pathname.split('/') || [],
      relPath = relative.pathname && relative.pathname.split('/') || [],
      psychotic = result.protocol && !slashedProtocol[result.protocol];

  // if the url is a non-slashed url, then relative
  // links like ../.. should be able
  // to crawl up to the hostname, as well.  This is strange.
  // result.protocol has already been set by now.
  // Later on, put the first path part into the host field.
  if (psychotic) {
    result.hostname = '';
    result.port = null;
    if (result.host) {
      if (srcPath[0] === '') srcPath[0] = result.host;
      else srcPath.unshift(result.host);
    }
    result.host = '';
    if (relative.protocol) {
      relative.hostname = null;
      relative.port = null;
      if (relative.host) {
        if (relPath[0] === '') relPath[0] = relative.host;
        else relPath.unshift(relative.host);
      }
      relative.host = null;
    }
    mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
  }

  if (isRelAbs) {
    // it's absolute.
    result.host = (relative.host || relative.host === '') ?
                  relative.host : result.host;
    result.hostname = (relative.hostname || relative.hostname === '') ?
                      relative.hostname : result.hostname;
    result.search = relative.search;
    result.query = relative.query;
    srcPath = relPath;
    // fall through to the dot-handling below.
  } else if (relPath.length) {
    // it's relative
    // throw away the existing file, and take the new path instead.
    if (!srcPath) srcPath = [];
    srcPath.pop();
    srcPath = srcPath.concat(relPath);
    result.search = relative.search;
    result.query = relative.query;
  } else if (!util.isNullOrUndefined(relative.search)) {
    // just pull out the search.
    // like href='?foo'.
    // Put this after the other two cases because it simplifies the booleans
    if (psychotic) {
      result.hostname = result.host = srcPath.shift();
      //occationaly the auth can get stuck only in host
      //this especially happens in cases like
      //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
      var authInHost = result.host && result.host.indexOf('@') > 0 ?
                       result.host.split('@') : false;
      if (authInHost) {
        result.auth = authInHost.shift();
        result.host = result.hostname = authInHost.shift();
      }
    }
    result.search = relative.search;
    result.query = relative.query;
    //to support http.request
    if (!util.isNull(result.pathname) || !util.isNull(result.search)) {
      result.path = (result.pathname ? result.pathname : '') +
                    (result.search ? result.search : '');
    }
    result.href = result.format();
    return result;
  }

  if (!srcPath.length) {
    // no path at all.  easy.
    // we've already handled the other stuff above.
    result.pathname = null;
    //to support http.request
    if (result.search) {
      result.path = '/' + result.search;
    } else {
      result.path = null;
    }
    result.href = result.format();
    return result;
  }

  // if a url ENDs in . or .., then it must get a trailing slash.
  // however, if it ends in anything else non-slashy,
  // then it must NOT get a trailing slash.
  var last = srcPath.slice(-1)[0];
  var hasTrailingSlash = (
      (result.host || relative.host || srcPath.length > 1) &&
      (last === '.' || last === '..') || last === '');

  // strip single dots, resolve double dots to parent dir
  // if the path tries to go above the root, `up` ends up > 0
  var up = 0;
  for (var i = srcPath.length; i >= 0; i--) {
    last = srcPath[i];
    if (last === '.') {
      srcPath.splice(i, 1);
    } else if (last === '..') {
      srcPath.splice(i, 1);
      up++;
    } else if (up) {
      srcPath.splice(i, 1);
      up--;
    }
  }

  // if the path is allowed to go above the root, restore leading ..s
  if (!mustEndAbs && !removeAllDots) {
    for (; up--; up) {
      srcPath.unshift('..');
    }
  }

  if (mustEndAbs && srcPath[0] !== '' &&
      (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
    srcPath.unshift('');
  }

  if (hasTrailingSlash && (srcPath.join('/').substr(-1) !== '/')) {
    srcPath.push('');
  }

  var isAbsolute = srcPath[0] === '' ||
      (srcPath[0] && srcPath[0].charAt(0) === '/');

  // put the host back
  if (psychotic) {
    result.hostname = result.host = isAbsolute ? '' :
                                    srcPath.length ? srcPath.shift() : '';
    //occationaly the auth can get stuck only in host
    //this especially happens in cases like
    //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
    var authInHost = result.host && result.host.indexOf('@') > 0 ?
                     result.host.split('@') : false;
    if (authInHost) {
      result.auth = authInHost.shift();
      result.host = result.hostname = authInHost.shift();
    }
  }

  mustEndAbs = mustEndAbs || (result.host && srcPath.length);

  if (mustEndAbs && !isAbsolute) {
    srcPath.unshift('');
  }

  if (!srcPath.length) {
    result.pathname = null;
    result.path = null;
  } else {
    result.pathname = srcPath.join('/');
  }

  //to support request.http
  if (!util.isNull(result.pathname) || !util.isNull(result.search)) {
    result.path = (result.pathname ? result.pathname : '') +
                  (result.search ? result.search : '');
  }
  result.auth = relative.auth || result.auth;
  result.slashes = result.slashes || relative.slashes;
  result.href = result.format();
  return result;
};

Url.prototype.parseHost = function() {
  var host = this.host;
  var port = portPattern.exec(host);
  if (port) {
    port = port[0];
    if (port !== ':') {
      this.port = port.substr(1);
    }
    host = host.substr(0, host.length - port.length);
  }
  if (host) this.hostname = host;
};


/***/ }),

/***/ 62502:
/***/ ((module) => {

"use strict";


module.exports = {
  isString: function(arg) {
    return typeof(arg) === 'string';
  },
  isObject: function(arg) {
    return typeof(arg) === 'object' && arg !== null;
  },
  isNull: function(arg) {
    return arg === null;
  },
  isNullOrUndefined: function(arg) {
    return arg == null;
  }
};


/***/ }),

/***/ 24654:
/***/ (() => {

/* (ignored) */

/***/ }),

/***/ 73324:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(44442);

/***/ }),

/***/ 99595:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(57152);

/***/ }),

/***/ 51791:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(69447);

/***/ }),

/***/ 2201:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(70573);

/***/ }),

/***/ 57445:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(73685);

/***/ }),

/***/ 88546:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(27533);

/***/ }),

/***/ 66775:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(39057);

/***/ }),

/***/ 52020:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(84710);

/***/ }),

/***/ 62079:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(93799);

/***/ }),

/***/ 52472:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(86600);

/***/ }),

/***/ 48994:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(9759);

/***/ }),

/***/ 40024:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(71384);

/***/ }),

/***/ 44845:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _defineProperty)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_core_js_object_define_property__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(57445);
/* harmony import */ var _toPropertyKey_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(768);


function _defineProperty(obj, key, value) {
  key = (0,_toPropertyKey_js__WEBPACK_IMPORTED_MODULE_1__["default"])(key);
  if (key in obj) {
    _babel_runtime_corejs3_core_js_object_define_property__WEBPACK_IMPORTED_MODULE_0__(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

/***/ }),

/***/ 97530:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _objectSpread2)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_core_js_object_keys__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62079);
/* harmony import */ var _babel_runtime_corejs3_core_js_object_get_own_property_symbols__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52020);
/* harmony import */ var _babel_runtime_corejs3_core_js_instance_filter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(73324);
/* harmony import */ var _babel_runtime_corejs3_core_js_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(88546);
/* harmony import */ var _babel_runtime_corejs3_core_js_instance_for_each__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(99595);
/* harmony import */ var _babel_runtime_corejs3_core_js_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(66775);
/* harmony import */ var _babel_runtime_corejs3_core_js_object_define_properties__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2201);
/* harmony import */ var _babel_runtime_corejs3_core_js_object_define_property__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(57445);
/* harmony import */ var _defineProperty_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(44845);









function ownKeys(object, enumerableOnly) {
  var keys = _babel_runtime_corejs3_core_js_object_keys__WEBPACK_IMPORTED_MODULE_0__(object);
  if (_babel_runtime_corejs3_core_js_object_get_own_property_symbols__WEBPACK_IMPORTED_MODULE_1__) {
    var symbols = _babel_runtime_corejs3_core_js_object_get_own_property_symbols__WEBPACK_IMPORTED_MODULE_1__(object);
    enumerableOnly && (symbols = _babel_runtime_corejs3_core_js_instance_filter__WEBPACK_IMPORTED_MODULE_2__(symbols).call(symbols, function (sym) {
      return _babel_runtime_corejs3_core_js_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var _context, _context2;
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? _babel_runtime_corejs3_core_js_instance_for_each__WEBPACK_IMPORTED_MODULE_4__(_context = ownKeys(Object(source), !0)).call(_context, function (key) {
      (0,_defineProperty_js__WEBPACK_IMPORTED_MODULE_8__["default"])(target, key, source[key]);
    }) : _babel_runtime_corejs3_core_js_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5__ ? _babel_runtime_corejs3_core_js_object_define_properties__WEBPACK_IMPORTED_MODULE_6__(target, _babel_runtime_corejs3_core_js_object_get_own_property_descriptors__WEBPACK_IMPORTED_MODULE_5__(source)) : _babel_runtime_corejs3_core_js_instance_for_each__WEBPACK_IMPORTED_MODULE_4__(_context2 = ownKeys(Object(source))).call(_context2, function (key) {
      _babel_runtime_corejs3_core_js_object_define_property__WEBPACK_IMPORTED_MODULE_7__(target, key, _babel_runtime_corejs3_core_js_object_get_own_property_descriptor__WEBPACK_IMPORTED_MODULE_3__(source, key));
    });
  }
  return target;
}

/***/ }),

/***/ 2562:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _objectWithoutProperties)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_core_js_object_get_own_property_symbols__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52020);
/* harmony import */ var _babel_runtime_corejs3_core_js_instance_index_of__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(51791);
/* harmony import */ var _objectWithoutPropertiesLoose_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(70268);



function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};
  var target = (0,_objectWithoutPropertiesLoose_js__WEBPACK_IMPORTED_MODULE_2__["default"])(source, excluded);
  var key, i;
  if (_babel_runtime_corejs3_core_js_object_get_own_property_symbols__WEBPACK_IMPORTED_MODULE_0__) {
    var sourceSymbolKeys = _babel_runtime_corejs3_core_js_object_get_own_property_symbols__WEBPACK_IMPORTED_MODULE_0__(source);
    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (_babel_runtime_corejs3_core_js_instance_index_of__WEBPACK_IMPORTED_MODULE_1__(excluded).call(excluded, key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }
  return target;
}

/***/ }),

/***/ 70268:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _objectWithoutPropertiesLoose)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_core_js_object_keys__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62079);
/* harmony import */ var _babel_runtime_corejs3_core_js_instance_index_of__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(51791);


function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = _babel_runtime_corejs3_core_js_object_keys__WEBPACK_IMPORTED_MODULE_0__(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (_babel_runtime_corejs3_core_js_instance_index_of__WEBPACK_IMPORTED_MODULE_1__(excluded).call(excluded, key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}

/***/ }),

/***/ 88718:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _toPrimitive)
/* harmony export */ });
/* harmony import */ var _typeof_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19623);
/* harmony import */ var _babel_runtime_corejs3_core_js_symbol_to_primitive__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40024);


function _toPrimitive(input, hint) {
  if ((0,_typeof_js__WEBPACK_IMPORTED_MODULE_0__["default"])(input) !== "object" || input === null) return input;
  var prim = input[_babel_runtime_corejs3_core_js_symbol_to_primitive__WEBPACK_IMPORTED_MODULE_1__];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if ((0,_typeof_js__WEBPACK_IMPORTED_MODULE_0__["default"])(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}

/***/ }),

/***/ 768:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _toPropertyKey)
/* harmony export */ });
/* harmony import */ var _typeof_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19623);
/* harmony import */ var _toPrimitive_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88718);


function _toPropertyKey(arg) {
  var key = (0,_toPrimitive_js__WEBPACK_IMPORTED_MODULE_1__["default"])(arg, "string");
  return (0,_typeof_js__WEBPACK_IMPORTED_MODULE_0__["default"])(key) === "symbol" ? key : String(key);
}

/***/ }),

/***/ 19623:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _typeof)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_core_js_symbol__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52472);
/* harmony import */ var _babel_runtime_corejs3_core_js_symbol_iterator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48994);


function _typeof(obj) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof _babel_runtime_corejs3_core_js_symbol__WEBPACK_IMPORTED_MODULE_0__ && "symbol" == typeof _babel_runtime_corejs3_core_js_symbol_iterator__WEBPACK_IMPORTED_MODULE_1__ ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof _babel_runtime_corejs3_core_js_symbol__WEBPACK_IMPORTED_MODULE_0__ && obj.constructor === _babel_runtime_corejs3_core_js_symbol__WEBPACK_IMPORTED_MODULE_0__ && obj !== _babel_runtime_corejs3_core_js_symbol__WEBPACK_IMPORTED_MODULE_0__.prototype ? "symbol" : typeof obj;
  }, _typeof(obj);
}

/***/ }),

/***/ 32674:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BREAK": () => (/* binding */ BREAK),
/* harmony export */   "getNodeType": () => (/* binding */ getNodeType),
/* harmony export */   "getVisitFn": () => (/* binding */ getVisitFn),
/* harmony export */   "isNode": () => (/* binding */ isNode),
/* harmony export */   "mergeAll": () => (/* binding */ mergeAll),
/* harmony export */   "visit": () => (/* binding */ visit)
/* harmony export */ });
/**
 * SPDX-FileCopyrightText: Copyright (c) GraphQL Contributors
 *
 * SPDX-License-Identifier: MIT
 */

// getVisitFn :: (Visitor, String, Boolean) -> Function
const getVisitFn = (visitor, type, isLeaving) => {
  const typeVisitor = visitor[type];
  if (typeVisitor != null) {
    if (!isLeaving && typeof typeVisitor === 'function') {
      // { Type() {} }
      return typeVisitor;
    }
    const typeSpecificVisitor = isLeaving ? typeVisitor.leave : typeVisitor.enter;
    if (typeof typeSpecificVisitor === 'function') {
      // { Type: { enter() {}, leave() {} } }
      return typeSpecificVisitor;
    }
  } else {
    const specificVisitor = isLeaving ? visitor.leave : visitor.enter;
    if (specificVisitor != null) {
      if (typeof specificVisitor === 'function') {
        // { enter() {}, leave() {} }
        return specificVisitor;
      }
      const specificTypeVisitor = specificVisitor[type];
      if (typeof specificTypeVisitor === 'function') {
        // { enter: { Type() {} }, leave: { Type() {} } }
        return specificTypeVisitor;
      }
    }
  }
  return null;
};
const BREAK = {};

// getNodeType :: Node -> String
const getNodeType = node => node === null || node === void 0 ? void 0 : node.type;

// isNode :: Node -> Boolean
const isNode = node => typeof getNodeType(node) === 'string';

/**
 * Creates a new visitor instance which delegates to many visitors to run in
 * parallel. Each visitor will be visited for each node before moving on.
 *
 * If a prior visitor edits a node, no following visitors will see that node.
 */
const mergeAll = (visitors, {
  visitFnGetter = getVisitFn,
  nodeTypeGetter = getNodeType
} = {}) => {
  const skipping = new Array(visitors.length);
  return {
    enter(node, ...rest) {
      for (let i = 0; i < visitors.length; i += 1) {
        if (skipping[i] == null) {
          const fn = visitFnGetter(visitors[i], nodeTypeGetter(node), /* isLeaving */false);
          if (typeof fn === 'function') {
            const result = fn.call(visitors[i], node, ...rest);
            if (result === false) {
              skipping[i] = node;
            } else if (result === BREAK) {
              skipping[i] = BREAK;
            } else if (result !== undefined) {
              return result;
            }
          }
        }
      }
      return undefined;
    },
    leave(node, ...rest) {
      for (let i = 0; i < visitors.length; i += 1) {
        if (skipping[i] == null) {
          const fn = visitFnGetter(visitors[i], nodeTypeGetter(node), /* isLeaving */true);
          if (typeof fn === 'function') {
            const result = fn.call(visitors[i], node, ...rest);
            if (result === BREAK) {
              skipping[i] = BREAK;
            } else if (result !== undefined && result !== false) {
              return result;
            }
          }
        } else if (skipping[i] === node) {
          skipping[i] = null;
        }
      }
      return undefined;
    }
  };
};

/* eslint-disable no-continue, no-nested-ternary, no-param-reassign */
/**
 * visit() will walk through an AST using a preorder depth first traversal, calling
 * the visitor's enter function at each node in the traversal, and calling the
 * leave function after visiting that node and all of its child nodes.
 *
 * By returning different values from the enter and leave functions, the
 * behavior of the visitor can be altered, including skipping over a sub-tree of
 * the AST (by returning false), editing the AST by returning a value or null
 * to remove the value, or to stop the whole traversal by returning BREAK.
 *
 * When using visit() to edit an AST, the original AST will not be modified, and
 * a new version of the AST with the changes applied will be returned from the
 * visit function.
 *
 *     const editedAST = visit(ast, {
 *       enter(node, key, parent, path, ancestors) {
 *         // @return
 *         //   undefined: no action
 *         //   false: skip visiting this node
 *         //   BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       },
 *       leave(node, key, parent, path, ancestors) {
 *         // @return
 *         //   undefined: no action
 *         //   false: no action
 *         //   BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       }
 *     });
 *
 * Alternatively to providing enter() and leave() functions, a visitor can
 * instead provide functions named the same as the kinds of AST nodes, or
 * enter/leave visitors at a named key, leading to four permutations of
 * visitor API:
 *
 * 1) Named visitors triggered when entering a node a specific kind.
 *
 *     visit(ast, {
 *       Kind(node) {
 *         // enter the "Kind" node
 *       }
 *     })
 *
 * 2) Named visitors that trigger upon entering and leaving a node of
 *    a specific kind.
 *
 *     visit(ast, {
 *       Kind: {
 *         enter(node) {
 *           // enter the "Kind" node
 *         }
 *         leave(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 *
 * 3) Generic visitors that trigger upon entering and leaving any node.
 *
 *     visit(ast, {
 *       enter(node) {
 *         // enter any node
 *       },
 *       leave(node) {
 *         // leave any node
 *       }
 *     })
 *
 * 4) Parallel visitors for entering and leaving nodes of a specific kind.
 *
 *     visit(ast, {
 *       enter: {
 *         Kind(node) {
 *           // enter the "Kind" node
 *         }
 *       },
 *       leave: {
 *         Kind(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 *
 *  @sig visit :: (Node, Visitor, Options)
 *  @sig      Options = { keyMap: Object, state: Object }
 */
const visit = (
// @ts-ignore
root,
// @ts-ignore
visitor, {
  keyMap = null,
  state = {},
  breakSymbol = BREAK,
  deleteNodeSymbol = null,
  skipVisitingNodeSymbol = false,
  visitFnGetter = getVisitFn,
  nodeTypeGetter = getNodeType,
  nodePredicate = isNode,
  detectCycles = true
} = {}) => {
  const visitorKeys = keyMap || {};
  let stack;
  let inArray = Array.isArray(root);
  let keys = [root];
  let index = -1;
  let parent;
  let edits = [];
  const path = [];
  // @ts-ignore
  const ancestors = [];
  let newRoot = root;
  do {
    index += 1;
    const isLeaving = index === keys.length;
    let key;
    let node;
    const isEdited = isLeaving && edits.length !== 0;
    if (isLeaving) {
      key = ancestors.length === 0 ? undefined : path.pop();
      node = parent;
      // @ts-ignore
      parent = ancestors.pop();
      if (isEdited) {
        if (inArray) {
          // @ts-ignore
          node = node.slice();
        } else {
          // creating clone
          node = Object.create(Object.getPrototypeOf(node), Object.getOwnPropertyDescriptors(node));
        }
        let editOffset = 0;
        for (let ii = 0; ii < edits.length; ii += 1) {
          let editKey = edits[ii][0];
          const editValue = edits[ii][1];
          if (inArray) {
            editKey -= editOffset;
          }
          if (inArray && editValue === deleteNodeSymbol) {
            node.splice(editKey, 1);
            editOffset += 1;
          } else {
            node[editKey] = editValue;
          }
        }
      }
      index = stack.index;
      keys = stack.keys;
      // @ts-ignore
      edits = stack.edits;
      // @ts-ignore
      inArray = stack.inArray;
      // @ts-ignore
      stack = stack.prev;
    } else {
      key = parent ? inArray ? index : keys[index] : undefined;
      node = parent ? parent[key] : newRoot;
      if (node === deleteNodeSymbol || node === undefined) {
        continue;
      }
      if (parent) {
        path.push(key);
      }
    }
    if (ancestors.includes(node)) {
      continue;
    }
    let result;
    if (!Array.isArray(node)) {
      if (!nodePredicate(node)) {
        throw new Error(`Invalid AST Node:  ${JSON.stringify(node)}`);
      }
      // cycle detected; skipping over a sub-tree to avoid recursion
      if (detectCycles && ancestors.includes(node)) {
        path.pop();
        continue;
      }
      // call appropriate visitor function if available
      const visitFn = visitFnGetter(visitor, nodeTypeGetter(node), isLeaving);
      if (visitFn) {
        // assign state
        for (const [stateKey, stateValue] of Object.entries(state)) {
          visitor[stateKey] = stateValue;
        }
        result = visitFn.call(visitor, node, key, parent, path, ancestors);
        if (result === breakSymbol) {
          break;
        }
        if (result === skipVisitingNodeSymbol) {
          if (!isLeaving) {
            path.pop();
            continue;
          }
        } else if (result !== undefined) {
          edits.push([key, result]);
          if (!isLeaving) {
            if (nodePredicate(result)) {
              node = result;
            } else {
              path.pop();
              continue;
            }
          }
        }
      }
    }
    if (result === undefined && isEdited) {
      edits.push([key, node]);
    }
    if (!isLeaving) {
      stack = {
        inArray,
        index,
        keys,
        edits,
        prev: stack
      };
      inArray = Array.isArray(node);
      // @ts-ignore
      keys = inArray ? node : visitorKeys[nodeTypeGetter(node)] || [];
      index = -1;
      edits = [];
      if (parent) {
        ancestors.push(parent);
      }
      parent = node;
    }
  } while (stack !== undefined);
  if (edits.length !== 0) {
    [, newRoot] = edits[edits.length - 1];
  }
  return newRoot;
};

/**
 * Asynchronous version of visit.
 */
// @ts-ignore
visit[Symbol.for('nodejs.util.promisify.custom')] = async (
// @ts-ignore
root,
// @ts-ignore
visitor, {
  keyMap = null,
  state = {},
  breakSymbol = BREAK,
  deleteNodeSymbol = null,
  skipVisitingNodeSymbol = false,
  visitFnGetter = getVisitFn,
  nodeTypeGetter = getNodeType,
  nodePredicate = isNode,
  detectCycles = true
} = {}) => {
  const visitorKeys = keyMap || {};
  let stack;
  let inArray = Array.isArray(root);
  let keys = [root];
  let index = -1;
  let parent;
  let edits = [];
  const path = [];
  // @ts-ignore
  const ancestors = [];
  let newRoot = root;
  do {
    index += 1;
    const isLeaving = index === keys.length;
    let key;
    let node;
    const isEdited = isLeaving && edits.length !== 0;
    if (isLeaving) {
      key = ancestors.length === 0 ? undefined : path.pop();
      node = parent;
      // @ts-ignore
      parent = ancestors.pop();
      if (isEdited) {
        if (inArray) {
          // @ts-ignore
          node = node.slice();
        } else {
          // creating clone
          node = Object.create(Object.getPrototypeOf(node), Object.getOwnPropertyDescriptors(node));
        }
        let editOffset = 0;
        for (let ii = 0; ii < edits.length; ii += 1) {
          let editKey = edits[ii][0];
          const editValue = edits[ii][1];
          if (inArray) {
            editKey -= editOffset;
          }
          if (inArray && editValue === deleteNodeSymbol) {
            node.splice(editKey, 1);
            editOffset += 1;
          } else {
            node[editKey] = editValue;
          }
        }
      }
      index = stack.index;
      keys = stack.keys;
      // @ts-ignore
      edits = stack.edits;
      // @ts-ignore
      inArray = stack.inArray;
      // @ts-ignore
      stack = stack.prev;
    } else {
      key = parent ? inArray ? index : keys[index] : undefined;
      node = parent ? parent[key] : newRoot;
      if (node === deleteNodeSymbol || node === undefined) {
        continue;
      }
      if (parent) {
        path.push(key);
      }
    }
    let result;
    if (!Array.isArray(node)) {
      if (!nodePredicate(node)) {
        throw new Error(`Invalid AST Node:  ${JSON.stringify(node)}`);
      }
      // cycle detected; skipping over a sub-tree to avoid recursion
      if (detectCycles && ancestors.includes(node)) {
        path.pop();
        continue;
      }
      const visitFn = visitFnGetter(visitor, nodeTypeGetter(node), isLeaving);
      if (visitFn) {
        // assign state
        for (const [stateKey, stateValue] of Object.entries(state)) {
          visitor[stateKey] = stateValue;
        }

        // eslint-disable-next-line no-await-in-loop
        result = await visitFn.call(visitor, node, key, parent, path, ancestors);
        if (result === breakSymbol) {
          break;
        }
        if (result === skipVisitingNodeSymbol) {
          if (!isLeaving) {
            path.pop();
            continue;
          }
        } else if (result !== undefined) {
          edits.push([key, result]);
          if (!isLeaving) {
            if (nodePredicate(result)) {
              node = result;
            } else {
              path.pop();
              continue;
            }
          }
        }
      }
    }
    if (result === undefined && isEdited) {
      edits.push([key, node]);
    }
    if (!isLeaving) {
      stack = {
        inArray,
        index,
        keys,
        edits,
        prev: stack
      };
      inArray = Array.isArray(node);
      // @ts-ignore
      keys = inArray ? node : visitorKeys[nodeTypeGetter(node)] || [];
      index = -1;
      edits = [];
      if (parent) {
        ancestors.push(parent);
      }
      parent = node;
    }
  } while (stack !== undefined);
  if (edits.length !== 0) {
    [, newRoot] = edits[edits.length - 1];
  }
  return newRoot;
};

/* eslint-enable */

/***/ }),

/***/ 91145:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ deepmerge)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43500);
/* harmony import */ var _predicates_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67277);

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }


/* eslint-disable @typescript-eslint/no-use-before-define */
const emptyElement = element => {
  const meta = element.meta.clone();
  const attributes = element.attributes.clone();

  // @ts-ignore
  return new element.constructor(undefined, meta, attributes);
};
const cloneMemberElement = memberElement => new minim__WEBPACK_IMPORTED_MODULE_1__.MemberElement(memberElement.key, memberElement.value, memberElement.meta.clone(), memberElement.attributes.clone());
const cloneUnlessOtherwiseSpecified = (element, options) => options.clone && options.isMergeableElement(element) ? deepmerge(emptyElement(element), element, options) : element;
const getMergeFunction = (keyElement, options) => {
  if (typeof options.customMerge !== 'function') {
    return deepmerge;
  }
  const customMerge = options.customMerge(keyElement, options);
  return typeof customMerge === 'function' ? customMerge : deepmerge;
};
const mergeArrayElement = (targetElement, sourceElement, options) => targetElement.concat(sourceElement)['fantasy-land/map'](item => cloneUnlessOtherwiseSpecified(item, options));
const mergeObjectElement = (targetElement, sourceElement, options) => {
  const destination = (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(targetElement) ? emptyElement(targetElement) : emptyElement(sourceElement);
  if ((0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(targetElement)) {
    targetElement.forEach((value, key, member) => {
      const clonedMember = cloneMemberElement(member);
      clonedMember.value = cloneUnlessOtherwiseSpecified(value, options);
      destination.content.push(clonedMember);
    });
  }
  sourceElement.forEach((value, key, member) => {
    const keyValue = key.toValue();
    let clonedMember;
    if ((0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(targetElement) && targetElement.hasKey(keyValue) && options.isMergeableElement(value)) {
      const targetValue = targetElement.get(keyValue);
      clonedMember = cloneMemberElement(member);
      clonedMember.value = getMergeFunction(key, options)(targetValue, value);
    } else {
      clonedMember = cloneMemberElement(member);
      clonedMember.value = cloneUnlessOtherwiseSpecified(value, options);
    }
    destination.remove(keyValue);
    destination.content.push(clonedMember);
  });
  return destination;
};
function deepmerge(targetElement, sourceElement, options) {
  var _mergedOptions$isMerg, _mergedOptions$arrayE, _mergedOptions$object;
  const defaultOptions = {
    clone: true,
    isMergeableElement: element => (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(element) || (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_2__.isArrayElement)(element),
    arrayElementMerge: mergeArrayElement,
    objectElementMerge: mergeObjectElement,
    customMerge: undefined
  };
  const mergedOptions = _objectSpread(_objectSpread({}, defaultOptions), options);
  mergedOptions.isMergeableElement = (_mergedOptions$isMerg = mergedOptions.isMergeableElement) !== null && _mergedOptions$isMerg !== void 0 ? _mergedOptions$isMerg : defaultOptions.isMergeableElement;
  mergedOptions.arrayElementMerge = (_mergedOptions$arrayE = mergedOptions.arrayElementMerge) !== null && _mergedOptions$arrayE !== void 0 ? _mergedOptions$arrayE : defaultOptions.arrayElementMerge;
  mergedOptions.objectElementMerge = (_mergedOptions$object = mergedOptions.objectElementMerge) !== null && _mergedOptions$object !== void 0 ? _mergedOptions$object : defaultOptions.objectElementMerge;
  const sourceIsArrayElement = (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_2__.isArrayElement)(sourceElement);
  const targetIsArrayElement = (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_2__.isArrayElement)(targetElement);
  const sourceAndTargetTypesMatch = sourceIsArrayElement === targetIsArrayElement;
  if (!sourceAndTargetTypesMatch) {
    return cloneUnlessOtherwiseSpecified(sourceElement, mergedOptions);
  }
  if (sourceIsArrayElement && typeof mergedOptions.arrayElementMerge === 'function') {
    return mergedOptions.arrayElementMerge(targetElement, sourceElement, mergedOptions);
  }
  return mergedOptions.objectElementMerge(targetElement, sourceElement, mergedOptions);
}
deepmerge.all = (list, options) => {
  if (!Array.isArray(list)) {
    throw new Error('first argument should be an array');
  }
  if (list.length === 0) {
    return new minim__WEBPACK_IMPORTED_MODULE_1__.ObjectElement();
  }
  return list.reduce((target, source) => {
    return deepmerge(target, source, options);
  }, emptyElement(list[0]));
};
/* eslint-enable @typescript-eslint/no-use-before-define */

/***/ }),

/***/ 39657:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43500);

class Annotation extends minim__WEBPACK_IMPORTED_MODULE_0__.StringElement {
  // classes: warning | error

  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'annotation';
  }
  get code() {
    return this.attributes.get('code');
  }
  set code(value) {
    this.attributes.set('code', value);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Annotation);

/***/ }),

/***/ 90427:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43500);

class Comment extends minim__WEBPACK_IMPORTED_MODULE_0__.StringElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'comment';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Comment);

/***/ }),

/***/ 55548:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43500);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4926);


class ParseResult extends minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'parseResult';
  }
  get api() {
    return this.children.filter(item => item.classes.contains('api')).first;
  }
  get results() {
    return this.children.filter(item => item.classes.contains('result'));
  }
  get result() {
    return this.results.first;
  }
  get annotations() {
    return this.children.filter(item => item.element === 'annotation');
  }
  get warnings() {
    return this.children.filter(item => item.element === 'annotation' && item.classes.contains('warning'));
  }
  get errors() {
    return this.children.filter(item => item.element === 'annotation' && item.classes.contains('error'));
  }
  get isEmpty() {
    return this.children.reject(item => item.element === 'annotation').isEmpty;
  }
  replaceResult(replacement) {
    const {
      result
    } = this;
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"])(result)) {
      return false;
    }

    // @ts-ignore
    const searchIndex = this.content.findIndex(e => e === result);
    if (searchIndex === -1) {
      return false;
    }
    this.content[searchIndex] = replacement;
    return true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParseResult);

/***/ }),

/***/ 42948:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43500);

class SourceMap extends minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'sourceMap';
  }
  get positionStart() {
    return this.children.filter(item => item.classes.contains('position')).get(0);
  }
  get positionEnd() {
    return this.children.filter(item => item.classes.contains('position')).get(1);
  }
  set position(position) {
    if (position === null) {
      return;
    }
    const start = new minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement([position.start.row, position.start.column, position.start.char]);
    const end = new minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement([position.end.row, position.end.column, position.end.char]);
    start.classes.push('position');
    end.classes.push('position');
    this.push(start).push(end);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SourceMap);

/***/ }),

/***/ 17388:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnnotationElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.AnnotationElement),
/* harmony export */   "ArrayElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.ArrayElement),
/* harmony export */   "ArraySlice": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_5__.ArraySlice),
/* harmony export */   "BREAK": () => (/* reexport safe */ _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_18__.BREAK),
/* harmony export */   "BooleanElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.BooleanElement),
/* harmony export */   "CommentElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.CommentElement),
/* harmony export */   "Element": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_5__.Element),
/* harmony export */   "KeyValuePair": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_5__.KeyValuePair),
/* harmony export */   "LinkElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.LinkElement),
/* harmony export */   "MediaTypes": () => (/* reexport safe */ _media_types_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "MemberElement": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_5__.MemberElement),
/* harmony export */   "Namespace": () => (/* reexport safe */ _namespace_js__WEBPACK_IMPORTED_MODULE_6__.Namespace),
/* harmony export */   "NullElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.NullElement),
/* harmony export */   "NumberElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.NumberElement),
/* harmony export */   "ObjectElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.ObjectElement),
/* harmony export */   "ObjectSlice": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_5__.ObjectSlice),
/* harmony export */   "ParseResultElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.ParseResultElement),
/* harmony export */   "RefElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.RefElement),
/* harmony export */   "SourceMapElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.SourceMapElement),
/* harmony export */   "StringElement": () => (/* reexport safe */ _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__.StringElement),
/* harmony export */   "Transcluder": () => (/* reexport safe */ _transcluder_index_js__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   "createNamespace": () => (/* reexport safe */ _namespace_js__WEBPACK_IMPORTED_MODULE_6__.createNamespace),
/* harmony export */   "createPredicate": () => (/* reexport safe */ _predicates_helpers_js__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   "deepmerge": () => (/* reexport safe */ _deepmerge_js__WEBPACK_IMPORTED_MODULE_27__["default"]),
/* harmony export */   "dehydrate": () => (/* binding */ dehydrate),
/* harmony export */   "dereference": () => (/* reexport safe */ _util_js__WEBPACK_IMPORTED_MODULE_20__.dereference),
/* harmony export */   "dispatchRefractorPlugins": () => (/* reexport safe */ _refractor_plugins_utils_index_js__WEBPACK_IMPORTED_MODULE_1__.dispatchPlugins),
/* harmony export */   "filter": () => (/* reexport safe */ _traversal_index_js__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "find": () => (/* reexport safe */ _traversal_index_js__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   "findAtOffset": () => (/* reexport safe */ _traversal_index_js__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   "from": () => (/* binding */ from),
/* harmony export */   "getNodeType": () => (/* reexport safe */ _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_17__.getNodeType),
/* harmony export */   "hasElementSourceMap": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.hasElementSourceMap),
/* harmony export */   "includesClasses": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.includesClasses),
/* harmony export */   "includesSymbols": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.includesSymbols),
/* harmony export */   "isAnnotationElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isAnnotationElement),
/* harmony export */   "isArrayElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isArrayElement),
/* harmony export */   "isBooleanElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isBooleanElement),
/* harmony export */   "isElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isElement),
/* harmony export */   "isLinkElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isLinkElement),
/* harmony export */   "isMemberElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isMemberElement),
/* harmony export */   "isNullElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isNullElement),
/* harmony export */   "isNumberElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isNumberElement),
/* harmony export */   "isObjectElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isObjectElement),
/* harmony export */   "isParseResultElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isParseResultElement),
/* harmony export */   "isPrimitiveElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isPrimitiveElement),
/* harmony export */   "isRefElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isRefElement),
/* harmony export */   "isSourceMapElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isSourceMapElement),
/* harmony export */   "isStringElement": () => (/* reexport safe */ _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__.isStringElement),
/* harmony export */   "keyMap": () => (/* reexport safe */ _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_17__.keyMapDefault),
/* harmony export */   "mergeAllVisitors": () => (/* reexport safe */ _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_18__.mergeAll),
/* harmony export */   "namespace": () => (/* reexport safe */ _namespace_js__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "parents": () => (/* reexport safe */ _traversal_index_js__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   "refract": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_5__.refract),
/* harmony export */   "refractorPluginElementIdentity": () => (/* reexport safe */ _refractor_plugins_element_identity_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "refractorPluginSemanticElementIdentity": () => (/* reexport safe */ _refractor_plugins_semantic_element_identity_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "reject": () => (/* reexport safe */ _traversal_index_js__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   "sexprs": () => (/* reexport safe */ _sexprs_js__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   "some": () => (/* reexport safe */ _traversal_index_js__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   "toJSON": () => (/* binding */ toJSON),
/* harmony export */   "toString": () => (/* binding */ toString),
/* harmony export */   "toValue": () => (/* binding */ toValue),
/* harmony export */   "toYAML": () => (/* binding */ toYAML),
/* harmony export */   "transclude": () => (/* reexport safe */ _transcluder_index_js__WEBPACK_IMPORTED_MODULE_19__.transclude),
/* harmony export */   "traverse": () => (/* reexport safe */ _traversal_index_js__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   "visit": () => (/* reexport safe */ _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_17__.visit)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(314);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(38074);
/* harmony import */ var _namespace_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(75757);
/* harmony import */ var _serializers_value_index_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(62389);
/* harmony import */ var _serializers_json_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(79124);
/* harmony import */ var _serializers_yaml_1_2_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(76039);
/* harmony import */ var _refractor_plugins_utils_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32240);
/* harmony import */ var _refractor_plugins_element_identity_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(94204);
/* harmony import */ var _refractor_plugins_semantic_element_identity_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24036);
/* harmony import */ var _media_types_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77857);
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(43500);
/* harmony import */ var _refractor_registration_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(38715);
/* harmony import */ var _predicates_index_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(67277);
/* harmony import */ var _predicates_helpers_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(37330);
/* harmony import */ var _traversal_index_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(75532);
/* harmony import */ var _traversal_index_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(85782);
/* harmony import */ var _traversal_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(69346);
/* harmony import */ var _traversal_index_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(58558);
/* harmony import */ var _traversal_index_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(80113);
/* harmony import */ var _traversal_index_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(69785);
/* harmony import */ var _traversal_index_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(501);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(66175);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(32674);
/* harmony import */ var _transcluder_index_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(36340);
/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(19245);
/* harmony import */ var _sexprs_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(15900);
/* harmony import */ var _deepmerge_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(91145);



















/**
 * Transforms data to an Element from a particular namespace.
 */
const from = (data, namespace = _namespace_js__WEBPACK_IMPORTED_MODULE_6__["default"]) => {
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_21__["default"])(data)) {
    // JSON serialized refract
    try {
      return namespace.fromRefract(JSON.parse(data));
    } catch {
      // noop
    }
  }
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_22__["default"])(data) && (0,ramda__WEBPACK_IMPORTED_MODULE_0__.has)('element', data)) {
    // refract javascript structure
    return namespace.fromRefract(data);
  }
  return namespace.toElement(data);
};

/**
 * Transforms the ApiDOM into JavaScript POJO.
 * This POJO would be the result of interpreting the ApiDOM
 * into JavaScript structure.
 */
const toValue = _serializers_value_index_js__WEBPACK_IMPORTED_MODULE_23__["default"];

/**
 * Transforms the ApiDOM into JSON string.
 */
const toJSON = _serializers_json_js__WEBPACK_IMPORTED_MODULE_24__["default"];

/**
 * Transforms the ApiDOM into YAML string.
 */
const toYAML = _serializers_yaml_1_2_js__WEBPACK_IMPORTED_MODULE_25__["default"];

/**
 * Creates a refract representation of an Element.
 * https://github.com/refractproject/refract-spec
 */
const dehydrate = (element, namespace = _namespace_js__WEBPACK_IMPORTED_MODULE_6__["default"]) => {
  return namespace.toRefract(element);
};

/**
 * Create a refracted string representation of an Element.
 */
const toString = (element, namespace = _namespace_js__WEBPACK_IMPORTED_MODULE_6__["default"]) => {
  const refractStructure = dehydrate(element, namespace);
  return JSON.stringify(refractStructure);
};



/***/ }),

/***/ 77857:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);

class MediaTypes extends Array {
  constructor(...args) {
    super(...args);
    (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(this, "unknownMediaType", 'application/octet-stream');
  }
  // eslint-disable-next-line class-methods-use-this
  filterByFormat() {
    throw new Error('Not implemented!');
  }

  // eslint-disable-next-line class-methods-use-this
  findBy() {
    throw new Error('Not implemented');
  }

  // eslint-disable-next-line class-methods-use-this
  latest() {
    throw new Error('Not implemented!');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTypes);

/***/ }),

/***/ 75757:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Namespace": () => (/* binding */ Namespace),
/* harmony export */   "createNamespace": () => (/* binding */ createNamespace),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43500);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(38074);
/* harmony import */ var _elements_Annotation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(39657);
/* harmony import */ var _elements_Comment_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(90427);
/* harmony import */ var _elements_ParseResult_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(55548);
/* harmony import */ var _elements_SourceMap_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(42948);






class Namespace extends minim__WEBPACK_IMPORTED_MODULE_0__.Namespace {
  constructor() {
    super();
    this.register('annotation', _elements_Annotation_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
    this.register('comment', _elements_Comment_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
    this.register('parseResult', _elements_ParseResult_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
    this.register('sourceMap', _elements_SourceMap_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
  }
}
const namespace = new Namespace();
const createNamespace = namespacePlugin => {
  const namespaceInstance = new Namespace();
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(namespacePlugin)) {
    namespaceInstance.use(namespacePlugin);
  }
  return namespaceInstance;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (namespace);

/***/ }),

/***/ 37330:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "isElementType": () => (/* binding */ isElementType)
/* harmony export */ });
const hasMethod = (name, obj) => typeof (obj === null || obj === void 0 ? void 0 : obj[name]) === 'function';
const hasBasicElementProps = element => element != null && Object.prototype.hasOwnProperty.call(element, '_storedElement') && Object.prototype.hasOwnProperty.call(element, '_content');
const primitiveEq = (val, obj) => {
  var _obj$primitive;
  return (obj === null || obj === void 0 ? void 0 : (_obj$primitive = obj.primitive) === null || _obj$primitive === void 0 ? void 0 : _obj$primitive.call(obj)) === val;
};
const hasClass = (cls, obj) => {
  var _obj$classes, _obj$classes$includes;
  return (obj === null || obj === void 0 ? void 0 : (_obj$classes = obj.classes) === null || _obj$classes === void 0 ? void 0 : (_obj$classes$includes = _obj$classes.includes) === null || _obj$classes$includes === void 0 ? void 0 : _obj$classes$includes.call(_obj$classes, cls)) || false;
};
const isElementType = (name, element) => (element === null || element === void 0 ? void 0 : element.element) === name;
const createPredicate = predicateCreator => {
  // @ts-ignore
  return predicateCreator({
    hasMethod,
    hasBasicElementProps,
    primitiveEq,
    isElementType,
    hasClass
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPredicate);

/***/ }),

/***/ 67277:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "hasElementSourceMap": () => (/* binding */ hasElementSourceMap),
/* harmony export */   "includesClasses": () => (/* binding */ includesClasses),
/* harmony export */   "includesSymbols": () => (/* binding */ includesSymbols),
/* harmony export */   "isAnnotationElement": () => (/* binding */ isAnnotationElement),
/* harmony export */   "isArrayElement": () => (/* binding */ isArrayElement),
/* harmony export */   "isBooleanElement": () => (/* binding */ isBooleanElement),
/* harmony export */   "isCommentElement": () => (/* binding */ isCommentElement),
/* harmony export */   "isElement": () => (/* binding */ isElement),
/* harmony export */   "isLinkElement": () => (/* binding */ isLinkElement),
/* harmony export */   "isMemberElement": () => (/* binding */ isMemberElement),
/* harmony export */   "isNullElement": () => (/* binding */ isNullElement),
/* harmony export */   "isNumberElement": () => (/* binding */ isNumberElement),
/* harmony export */   "isObjectElement": () => (/* binding */ isObjectElement),
/* harmony export */   "isParseResultElement": () => (/* binding */ isParseResultElement),
/* harmony export */   "isPrimitiveElement": () => (/* binding */ isPrimitiveElement),
/* harmony export */   "isRefElement": () => (/* binding */ isRefElement),
/* harmony export */   "isSourceMapElement": () => (/* binding */ isSourceMapElement),
/* harmony export */   "isStringElement": () => (/* binding */ isStringElement)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43500);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(38667);
/* harmony import */ var _elements_Annotation_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39657);
/* harmony import */ var _elements_Comment_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(90427);
/* harmony import */ var _elements_ParseResult_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(55548);
/* harmony import */ var _elements_SourceMap_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(42948);
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(37330);








const isElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.Element || hasBasicElementProps(element) && primitiveEq(undefined, element);
});
const isStringElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.StringElement || hasBasicElementProps(element) && primitiveEq('string', element);
});
const isNumberElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement || hasBasicElementProps(element) && primitiveEq('number', element);
});
const isNullElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.NullElement || hasBasicElementProps(element) && primitiveEq('null', element);
});
const isBooleanElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement || hasBasicElementProps(element) && primitiveEq('boolean', element);
});
const isObjectElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  primitiveEq,
  hasMethod
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement || hasBasicElementProps(element) && primitiveEq('object', element) && hasMethod('keys', element) && hasMethod('values', element) && hasMethod('items', element);
});
const isArrayElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  primitiveEq,
  hasMethod
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement && !(element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement) || hasBasicElementProps(element) && primitiveEq('array', element) && hasMethod('push', element) && hasMethod('unshift', element) && hasMethod('map', element) && hasMethod('reduce', element);
});
const isMemberElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.MemberElement || hasBasicElementProps(element) && isElementType('member', element) && primitiveEq(undefined, element);
});
const isLinkElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement || hasBasicElementProps(element) && isElementType('link', element) && primitiveEq(undefined, element);
});
const isRefElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.RefElement || hasBasicElementProps(element) && isElementType('ref', element) && primitiveEq(undefined, element);
});
const isAnnotationElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Annotation_js__WEBPACK_IMPORTED_MODULE_3__["default"] || hasBasicElementProps(element) && isElementType('annotation', element) && primitiveEq('array', element);
});
const isCommentElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Comment_js__WEBPACK_IMPORTED_MODULE_4__["default"] || hasBasicElementProps(element) && isElementType('comment', element) && primitiveEq('string', element);
});
const isParseResultElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_ParseResult_js__WEBPACK_IMPORTED_MODULE_5__["default"] || hasBasicElementProps(element) && isElementType('parseResult', element) && primitiveEq('array', element);
});
const isSourceMapElement = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_SourceMap_js__WEBPACK_IMPORTED_MODULE_6__["default"] || hasBasicElementProps(element) && isElementType('sourceMap', element) && primitiveEq('array', element);
});
const isPrimitiveElement = element => {
  return (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__.isElementType)('object', element) || (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__.isElementType)('array', element) || (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__.isElementType)('boolean', element) || (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__.isElementType)('number', element) || (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__.isElementType)('string', element) || (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__.isElementType)('null', element) || (0,_helpers_js__WEBPACK_IMPORTED_MODULE_2__.isElementType)('member', element);
};
const hasElementSourceMap = element => {
  var _element$meta, _element$meta$get;
  return isSourceMapElement(element === null || element === void 0 ? void 0 : (_element$meta = element.meta) === null || _element$meta === void 0 ? void 0 : (_element$meta$get = _element$meta.get) === null || _element$meta$get === void 0 ? void 0 : _element$meta$get.call(_element$meta, 'sourceMap'));
};
const includesSymbols = (symbols, element) => {
  if (symbols.length === 0) {
    return true;
  }
  const elementSymbols = element.attributes.get('symbols');
  if (!isArrayElement(elementSymbols)) {
    return false;
  }
  return (0,ramda__WEBPACK_IMPORTED_MODULE_1__.all)((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__["default"])(elementSymbols.toValue()), symbols);
};
const includesClasses = (classes, element) => {
  if (classes.length === 0) {
    return true;
  }
  return (0,ramda__WEBPACK_IMPORTED_MODULE_1__.all)((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__["default"])(element.classes.toValue()), classes);
};

/***/ }),

/***/ 97773:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createRefractor": () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _plugins_utils_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32240);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66175);
/* harmony import */ var _toolbox_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55552);

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }



const refract = (value, {
  Type,
  plugins = []
}) => {
  /**
   * This is where values gets refracted into generic ApiDOM.
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const element = new Type(value);

  /**
   * Run plugins only when necessary.
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_plugins_utils_index_js__WEBPACK_IMPORTED_MODULE_1__.dispatchPlugins)(element, plugins, {
    toolboxCreator: _toolbox_js__WEBPACK_IMPORTED_MODULE_2__["default"],
    visitorOptions: {
      nodeTypeGetter: _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_3__.getNodeType
    }
  });
};
const createRefractor = Type => (value, options = {}) => refract(value, _objectSpread(_objectSpread({}, options), {}, {
  Type
}));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 94204:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var short_unique_id__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77913);
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43500);
// @ts-ignore



/**
 * Plugin for decorating every element in ApiDOM tree with UUID.
 */

const plugin = ({
  length = 6
} = {}) => () => {
  let uuid;
  return {
    pre() {
      uuid = new short_unique_id__WEBPACK_IMPORTED_MODULE_0__({
        length
      });
    },
    visitor: {
      enter(element) {
        // eslint-disable-next-line no-param-reassign
        element.id = new minim__WEBPACK_IMPORTED_MODULE_1__.StringElement(uuid());
      }
    },
    post() {
      uuid = null;
    }
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugin);

/***/ }),

/***/ 24036:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var short_unique_id__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77913);
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43500);
// @ts-ignore



/**
 * Plugin for decorating every semantic element in ApiDOM tree with UUID.
 */

const plugin = ({
  length = 6
} = {}) => ({
  predicates
}) => {
  let uuid;
  return {
    pre() {
      uuid = new short_unique_id__WEBPACK_IMPORTED_MODULE_0__({
        length
      });
    },
    visitor: {
      enter(element) {
        if (!predicates.isPrimitiveElement(element)) {
          // eslint-disable-next-line no-param-reassign
          element.id = new minim__WEBPACK_IMPORTED_MODULE_1__.StringElement(uuid());
        }
      }
    },
    post() {
      uuid = null;
    }
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugin);

/***/ }),

/***/ 32240:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "dispatchPlugins": () => (/* binding */ dispatchPlugins)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(54633);
/* harmony import */ var _toolbox_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(55552);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66175);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32674);



 // eslint-disable-next-line import/prefer-default-export
const dispatchPlugins = (element, plugins, options = {}) => {
  if (plugins.length === 0) return element;
  const toolboxCreator = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.propOr)(_toolbox_js__WEBPACK_IMPORTED_MODULE_1__["default"], 'toolboxCreator', options);
  const visitorOptions = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.propOr)({}, 'visitorOptions', options);
  const nodeTypeGetter = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.propOr)(_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_2__.getNodeType, 'nodeTypeGetter', visitorOptions);
  const toolbox = toolboxCreator();
  const pluginsSpecs = plugins.map(plugin => plugin(toolbox));
  const pluginsVisitor = (0,_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_3__.mergeAll)(pluginsSpecs.map((0,ramda__WEBPACK_IMPORTED_MODULE_0__.propOr)({}, 'visitor')), {
    nodeTypeGetter
  });
  pluginsSpecs.forEach((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(['pre'], []));
  const newElement = (0,_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_2__.visit)(element, pluginsVisitor, visitorOptions);
  pluginsSpecs.forEach((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(['post'], []));
  return newElement;
};

/***/ }),

/***/ 38715:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AnnotationElement": () => (/* reexport safe */ _elements_Annotation_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "ArrayElement": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement),
/* harmony export */   "BooleanElement": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement),
/* harmony export */   "CommentElement": () => (/* reexport safe */ _elements_Comment_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "LinkElement": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement),
/* harmony export */   "NullElement": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.NullElement),
/* harmony export */   "NumberElement": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement),
/* harmony export */   "ObjectElement": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement),
/* harmony export */   "ParseResultElement": () => (/* reexport safe */ _elements_ParseResult_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "RefElement": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.RefElement),
/* harmony export */   "SourceMapElement": () => (/* reexport safe */ _elements_SourceMap_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "StringElement": () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.StringElement)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43500);
/* harmony import */ var _elements_Annotation_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39657);
/* harmony import */ var _elements_Comment_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(90427);
/* harmony import */ var _elements_ParseResult_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(55548);
/* harmony import */ var _elements_SourceMap_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(42948);
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(97773);






minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement.refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement);
minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement.refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement);
minim__WEBPACK_IMPORTED_MODULE_0__.StringElement.refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.StringElement);
minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement.refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement);
minim__WEBPACK_IMPORTED_MODULE_0__.NullElement.refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.NullElement);
minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement.refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement);
minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement.refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement);
minim__WEBPACK_IMPORTED_MODULE_0__.RefElement.refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.RefElement);
_elements_Annotation_js__WEBPACK_IMPORTED_MODULE_2__["default"].refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_Annotation_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
_elements_Comment_js__WEBPACK_IMPORTED_MODULE_3__["default"].refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_Comment_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
_elements_ParseResult_js__WEBPACK_IMPORTED_MODULE_4__["default"].refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_ParseResult_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
_elements_SourceMap_js__WEBPACK_IMPORTED_MODULE_5__["default"].refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_SourceMap_js__WEBPACK_IMPORTED_MODULE_5__["default"]);


/***/ }),

/***/ 55552:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _predicates_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67277);
/* harmony import */ var _namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75757);

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }


const createToolbox = () => {
  const predicates = _objectSpread({}, _predicates_index_js__WEBPACK_IMPORTED_MODULE_1__);
  return {
    predicates,
    namespace: _namespace_js__WEBPACK_IMPORTED_MODULE_2__["default"]
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createToolbox);

/***/ }),

/***/ 79124:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _value_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62389);

const serializer = (element, replacer, space) => JSON.stringify((0,_value_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element), replacer, space);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (serializer);

/***/ }),

/***/ 55784:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);

class EphemeralArray {
  constructor(content) {
    (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(this, "type", 'EphemeralArray');
    (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(this, "content", []);
    (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(this, "reference", undefined);
    this.content = content;
    this.reference = [];
  }
  toReference() {
    return this.reference;
  }
  toArray() {
    this.reference.push(...this.content);
    return this.reference;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EphemeralArray);

/***/ }),

/***/ 94053:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);

class EphemeralObject {
  constructor(content) {
    (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(this, "type", 'EphemeralObject');
    (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(this, "content", []);
    (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(this, "reference", undefined);
    this.content = content;
    this.reference = {};
  }
  toReference() {
    return this.reference;
  }
  toObject() {
    return Object.assign(this.reference, Object.fromEntries(this.content));
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EphemeralObject);

/***/ }),

/***/ 62389:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _visitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59044);
/* harmony import */ var _ast_ephemeral_array_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55784);
/* harmony import */ var _ast_ephemeral_object_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94053);




/* eslint-disable @typescript-eslint/naming-convention */
const Visitor = stampit__WEBPACK_IMPORTED_MODULE_0__.init(function _Visitor() {
  const references = new WeakMap();
  this.BooleanElement = function _BooleanElement(element) {
    return element.toValue();
  };
  this.NumberElement = function _NumberElement(element) {
    return element.toValue();
  };
  this.StringElement = function _StringElement(element) {
    return element.toValue();
  };
  this.NullElement = function _NullElement() {
    return null;
  };
  this.ObjectElement = {
    enter(element) {
      if (references.has(element)) {
        return references.get(element).toReference();
      }
      const ephemeral = new _ast_ephemeral_object_js__WEBPACK_IMPORTED_MODULE_1__["default"](element.content);
      references.set(element, ephemeral);
      return ephemeral;
    }
  };
  this.EphemeralObject = {
    leave(ephemeral) {
      return ephemeral.toObject();
    }
  };
  this.MemberElement = {
    enter(element) {
      return [element.key, element.value];
    }
  };
  this.ArrayElement = {
    enter(element) {
      if (references.has(element)) {
        return references.get(element).toReference();
      }
      const ephemeral = new _ast_ephemeral_array_js__WEBPACK_IMPORTED_MODULE_2__["default"](element.content);
      references.set(element, ephemeral);
      return ephemeral;
    }
  };
  this.EphemeralArray = {
    leave(ephemeral) {
      return ephemeral.toArray();
    }
  };
});
/* eslint-enable */

const serializer = element => {
  return (0,_visitor_js__WEBPACK_IMPORTED_MODULE_3__.visit)(element, Visitor());
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (serializer);

/***/ }),

/***/ 59044:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "visit": () => (/* binding */ visit)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2562);
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44845);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(25546);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66175);


const _excluded = ["keyMap"],
  _excluded2 = ["keyMap"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_1__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }


const nodeTypeGetter = node => {
  if (typeof (node === null || node === void 0 ? void 0 : node.type) === 'string') {
    return node.type;
  }
  return (0,_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_3__.getNodeType)(node);
};
const keyMapDefault = _objectSpread({
  EphemeralObject: ['content'],
  EphemeralArray: ['content']
}, _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_3__.keyMapDefault);

// eslint-disable-next-line import/prefer-default-export
const visit = (root,
// @ts-ignore
visitor, _ref = {}) => {
  let {
      keyMap = keyMapDefault
    } = _ref,
    rest = (0,_babel_runtime_corejs3_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref, _excluded);
  return (0,_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_3__.visit)(root, visitor, _objectSpread({
    keyMap,
    // @ts-ignore
    nodeTypeGetter,
    nodePredicate: ramda__WEBPACK_IMPORTED_MODULE_2__.T,
    detectCycles: false,
    deleteNodeSymbol: Symbol.for('delete-node'),
    skipVisitingNodeSymbol: Symbol.for('skip-visiting-node')
  }, rest));
};

// @ts-ignore
visit[Symbol.for('nodejs.util.promisify.custom')] = async (root, _ref2 = {}) => {
  let {
      keyMap = keyMapDefault
    } = _ref2,
    rest = (0,_babel_runtime_corejs3_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref2, _excluded2);
  // @ts-ignore
  return _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_3__.visit[Symbol.for('nodejs.util.promisify.custom')](root, visitor, _objectSpread({
    keyMap,
    nodeTypeGetter,
    nodePredicate: ramda__WEBPACK_IMPORTED_MODULE_2__.T,
    detectCycles: false,
    deleteNodeSymbol: Symbol.for('delete-node'),
    skipVisitingNodeSymbol: Symbol.for('skip-visiting-node')
  }, rest));
};

/***/ }),

/***/ 76039:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66175);
/* harmony import */ var _value_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(62389);



const YamlVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__({
  props: {
    result: '',
    indent: 0,
    indentChar: '  '
  },
  init({
    signature = '',
    indent = 0,
    indentChar = '  '
  } = {}) {
    this.result = signature;
    this.indent = indent;
    this.indentChard = indentChar;
  },
  methods: {
    NumberElement(element) {
      this.result += (0,_value_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);
    },
    BooleanElement(element) {
      const value = (0,_value_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);
      this.result += value ? 'true' : 'false';
    },
    StringElement(element) {
      // for simplicity and avoiding ambiguity we always wrap strings in quotes
      this.result += JSON.stringify((0,_value_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element));
    },
    NullElement() {
      this.result += 'null';
    },
    ArrayElement(element) {
      if (element.length === 0) {
        this.result += '[]';
        return false;
      }
      element.forEach(item => {
        const visitor = YamlVisitor({
          indent: this.indent + 1
        });
        const indent = this.indentChar.repeat(this.indent);
        (0,_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_2__.visit)(item, visitor);
        const {
          result
        } = visitor;
        this.result += result.startsWith('\n') ? `\n${indent}-${visitor.result}` : `\n${indent}- ${visitor.result}`;
      });
      return false;
    },
    ObjectElement(element) {
      if (element.length === 0) {
        this.result += '{}';
        return false;
      }
      element.forEach((value, key) => {
        const keyVisitor = YamlVisitor({
          indent: this.indent + 1
        });
        const valueVisitor = YamlVisitor({
          indent: this.indent + 1
        });
        const indent = this.indentChar.repeat(this.indent);
        (0,_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_2__.visit)(key, keyVisitor);
        (0,_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_2__.visit)(value, valueVisitor);
        const {
          result: keyResult
        } = keyVisitor;
        const {
          result: valueResult
        } = valueVisitor;
        this.result += valueResult.startsWith('\n') ? `\n${indent}${keyResult}:${valueResult}` : `\n${indent}${keyResult}: ${valueResult}`;
      });
      return false;
    }
  }
});
const serializer = element => {
  const signature = '%YAML 1.2\n---\n';
  const visitor = YamlVisitor({
    signature
  });
  (0,_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_2__.visit)(element, visitor);
  return visitor.result;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (serializer);

/***/ }),

/***/ 15900:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66175);


const SymbolicExpressionsVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__({
  props: {
    nestingLevel: 0,
    result: ''
  },
  methods: {
    enter(element) {
      const {
        element: elementName
      } = element;
      const capitalizedElementName = elementName.charAt(0).toUpperCase() + elementName.slice(1);
      const indent = '  '.repeat(this.nestingLevel);
      this.result += this.nestingLevel > 0 ? '\n' : '';
      this.result += `${indent}(${capitalizedElementName}Element`;
      this.nestingLevel += 1;
    },
    leave() {
      this.nestingLevel -= 1;
      this.result += ')';
    }
  }
});

// transforms ApiDOM into S-expressions (Symbolic Expressions)
const sexprs = element => {
  const visitor = SymbolicExpressionsVisitor();
  (0,_traversal_visitor_js__WEBPACK_IMPORTED_MODULE_1__.visit)(element, visitor);
  return visitor.result;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (sexprs);

/***/ }),

/***/ 68578:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4926);
/* harmony import */ var _predicates_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67277);



const computeEdges = (element, edges = new WeakMap()) => {
  if ((0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_1__.isMemberElement)(element)) {
    // @ts-ignore
    edges.set(element.key, element);
    // @ts-ignore
    computeEdges(element.key, edges);
    // @ts-ignore
    edges.set(element.value, element);
    // @ts-ignore
    computeEdges(element.value, edges);
  } else {
    element.children.forEach(childElement => {
      edges.set(childElement, element);
      computeEdges(childElement, edges);
    });
  }
  return edges;
};
const transcludeChildOfMemberElement = (search, replace, edges) => {
  const memberElement = edges.get(search);
  if (!(0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_1__.isMemberElement)(memberElement)) {
    return;
  }
  if (memberElement.key === search) {
    memberElement.key = replace;
    edges.delete(search);
    edges.set(replace, memberElement);
  }
  if (memberElement.value === search) {
    memberElement.value = replace;
    edges.delete(search);
    edges.set(replace, memberElement);
  }
};
const transcludeChildOfObjectElement = (search, replace, edges) => {
  const objectElement = edges.get(search);
  if (!(0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(objectElement)) {
    return;
  }
  objectElement.content = objectElement.map((value, key, member) => {
    if (member === search) {
      edges.delete(search);
      edges.set(replace, objectElement);
      return replace;
    }
    return member;
  });
};
const transcludeChildOfArrayElement = (search, replace, edges) => {
  const arrayElement = edges.get(search);
  if (!(0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_1__.isArrayElement)(arrayElement)) {
    return;
  }
  arrayElement.content = arrayElement.map(element => {
    if (element === search) {
      edges.delete(search);
      edges.set(replace, arrayElement);
      return replace;
    }
    return element;
  });
};

/**
 * This is a mutating stamp. If you don't want your Element to be mutated,
 * clone in before passing it to initializer of this stamp.
 */

const Transcluder = stampit__WEBPACK_IMPORTED_MODULE_0__.init(function TranscluderConstructor({
  element
}) {
  let edges;
  this.transclude = function transclude(search, replace) {
    var _edges;
    // shortcut 1. - replacing entire ApiDOM tree
    if (search === element) return replace;
    // shortcut 2. - replacing nothing
    if (search === replace) return element;
    edges = (_edges = edges) !== null && _edges !== void 0 ? _edges : computeEdges(element);
    const parent = edges.get(search);
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__["default"])(parent)) {
      return undefined;
    }

    /**
     * This predicate must be first because ObjectElement extends ArrayElement.
     * isArrayElement returns true for ObjectElements.
     * (classical problems with polymorphism)
     */
    if ((0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(parent)) {
      // @ts-ignore
      transcludeChildOfObjectElement(search, replace, edges);
    } else if ((0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_1__.isArrayElement)(parent)) {
      transcludeChildOfArrayElement(search, replace, edges);
    } else if ((0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_1__.isMemberElement)(parent)) {
      transcludeChildOfMemberElement(search, replace, edges);
    }
    return element;
  };
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Transcluder);

/***/ }),

/***/ 36340:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "transclude": () => (/* binding */ transclude)
/* harmony export */ });
/* harmony import */ var _Transcluder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68578);

/**
 * This is a mutating function. If you don't want your Element to be mutated,
 * clone in before passing it to this function.
 */
const transclude = (search, replace, element) => {
  const transcluder = (0,_Transcluder_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    element
  });
  return transcluder.transclude(search, replace);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Transcluder_js__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ 75532:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43500);
/* harmony import */ var _visitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66175);


 // finds all elements matching the predicate
// filter :: Pred -> Element -> ArraySlice
const filter = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curry)((predicate, element) => {
  const visitor = (0,_visitor_js__WEBPACK_IMPORTED_MODULE_2__.PredicateVisitor)({
    predicate
  });

  // @ts-ignore
  (0,_visitor_js__WEBPACK_IMPORTED_MODULE_2__.visit)(element, visitor);
  return new minim__WEBPACK_IMPORTED_MODULE_1__.ArraySlice(visitor.result);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (filter);

/***/ }),

/***/ 69346:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _visitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66175);
/* harmony import */ var _visitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32674);

 // find first element that satisfies the provided predicate
// find :: Pred -> Element -> Element | Undefined
const find = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curry)((predicate, element) => {
  const visitor = (0,_visitor_js__WEBPACK_IMPORTED_MODULE_1__.PredicateVisitor)({
    predicate,
    returnOnTrue: _visitor_js__WEBPACK_IMPORTED_MODULE_2__.BREAK
  });

  // @ts-ignore
  (0,_visitor_js__WEBPACK_IMPORTED_MODULE_1__.visit)(element, visitor);
  return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pathOr)(undefined, [0], visitor.result);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (find);

/***/ }),

/***/ 58558:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(47034);
/* harmony import */ var _predicates_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(67277);
/* harmony import */ var _visitor_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(66175);





const Visitor = stampit__WEBPACK_IMPORTED_MODULE_0__({
  props: {
    result: [],
    offset: 0,
    includeRightBound: false
  },
  // @ts-ignore
  init({
    offset = this.offset,
    includeRightBound = this.includeRightBound
  }) {
    this.result = [];
    this.offset = offset;
    this.includeRightBound = includeRightBound;
  },
  methods: {
    enter(element) {
      if (!(0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_2__.hasElementSourceMap)(element)) {
        return undefined; // dive in
      }

      const sourceMapElement = element.getMetaProperty('sourceMap');
      const charStart = sourceMapElement.positionStart.get(2).toValue();
      const charEnd = sourceMapElement.positionEnd.get(2).toValue();
      const isWithinOffsetRange = this.offset >= charStart && (this.offset < charEnd || this.includeRightBound && this.offset <= charEnd);
      if (isWithinOffsetRange) {
        this.result.push(element);
        return undefined; // push to stack and dive in
      }

      return false; // skip entire sub-tree
    }
  }
});

// Finds the most inner node at the given offset.
// If includeRightBound is set, also finds nodes that end at the given offset.
// findAtOffset :: Number -> Element -> Element | Undefined
const findAtOffset = (0,ramda__WEBPACK_IMPORTED_MODULE_1__.curry)((options, element) => {
  let offset;
  let includeRightBound;
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"])(options)) {
    offset = options;
    includeRightBound = false;
  } else {
    offset = (0,ramda__WEBPACK_IMPORTED_MODULE_1__.pathOr)(0, ['offset'], options);
    includeRightBound = (0,ramda__WEBPACK_IMPORTED_MODULE_1__.pathOr)(false, ['includeRightBound'], options);
  }
  const visitor = Visitor({
    offset,
    includeRightBound
  });

  // @ts-ignore
  (0,_visitor_js__WEBPACK_IMPORTED_MODULE_4__.visit)(element, visitor);

  // @ts-ignore
  return (0,ramda__WEBPACK_IMPORTED_MODULE_1__.last)(visitor.result);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (findAtOffset);

/***/ }),

/***/ 501:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _visitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66175);


/* eslint-disable no-param-reassign */
const Visitor = stampit__WEBPACK_IMPORTED_MODULE_0__({
  props: {
    parent: null,
    parentEdges: null
  },
  init() {
    this.parentEdges = new WeakMap();
  },
  methods: {
    ObjectElement(objectElement) {
      this.parentEdges.set(objectElement, this.parent);
      this.parent = objectElement;
    },
    ArrayElement(arrayElement) {
      this.parentEdges.set(arrayElement, this.parent);
      this.parent = arrayElement;
    },
    MemberElement(memberElement) {
      this.parentEdges.set(memberElement, this.parent);
      this.parent = memberElement;
    },
    enter(element) {
      this.parentEdges.set(element, this.parent);
    }
  }
});

/* eslint-enable */

// computes upwards edges from every child to its parent
// find :: Element -> WeakMap<Element, Element>
const parents = element => {
  const visitor = Visitor();
  (0,_visitor_js__WEBPACK_IMPORTED_MODULE_1__.visit)(element, visitor);
  return visitor.parentEdges;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parents);

/***/ }),

/***/ 85782:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var _filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75532);

 // complement of filter
// reject :: Pred -> Element -> ArraySlice
const reject = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curry)((predicate, element) => {
  return (0,_filter_js__WEBPACK_IMPORTED_MODULE_1__["default"])((0,ramda__WEBPACK_IMPORTED_MODULE_0__.complement)(predicate))(element);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (reject);

/***/ }),

/***/ 80113:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5413);
/* harmony import */ var _find_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(69346);


 // tests whether at least one element passes the predicate
// some :: Pred -> Element -> Boolean
const some = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.curry)((predicate, element) => {
  return (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"])((0,_find_js__WEBPACK_IMPORTED_MODULE_2__["default"])(predicate)(element));
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (some);

/***/ }),

/***/ 69785:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CallbackVisitor": () => (/* binding */ CallbackVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(88526);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(60285);
/* harmony import */ var _visitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66175);
/* harmony import */ var _predicates_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(67277);





const CallbackVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_visitor_js__WEBPACK_IMPORTED_MODULE_2__.PredicateVisitor, {
  props: {
    callback: ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"]
  },
  // @ts-ignore
  init({
    callback = this.callback
  } = {}) {
    this.callback = callback;
  },
  methods: {
    enter(element) {
      if (this.predicate(element)) {
        this.callback(element);
        return this.returnOnTrue;
      }
      return this.returnOnFalse;
    }
  }
});

// executes the callback on this element and all descendants
// traverse :: Callback | { predicate: Pred, callback: Callback } -> Element -> Undefined
const traverse = (0,ramda__WEBPACK_IMPORTED_MODULE_1__.curry)((options, element) => {
  let callback;
  let predicate;
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(options)) {
    callback = options;
    predicate = _predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isElement;
  } else {
    callback = (0,ramda__WEBPACK_IMPORTED_MODULE_1__.pathOr)(ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"], ['callback'], options);
    predicate = (0,ramda__WEBPACK_IMPORTED_MODULE_1__.pathOr)(_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isElement, ['predicate'], options);
  }
  const visitor = CallbackVisitor({
    callback,
    predicate
  });

  // @ts-ignore
  (0,_visitor_js__WEBPACK_IMPORTED_MODULE_2__.visit)(element, visitor);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (traverse);

/***/ }),

/***/ 66175:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BREAK": () => (/* reexport safe */ _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_4__.BREAK),
/* harmony export */   "PredicateVisitor": () => (/* binding */ PredicateVisitor),
/* harmony export */   "getNodeType": () => (/* binding */ getNodeType),
/* harmony export */   "isNode": () => (/* binding */ isNode),
/* harmony export */   "keyMapDefault": () => (/* binding */ keyMapDefault),
/* harmony export */   "mergeAllVisitors": () => (/* reexport safe */ _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_4__.mergeAll),
/* harmony export */   "visit": () => (/* binding */ visit)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2562);
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(314);
/* harmony import */ var _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(32674);
/* harmony import */ var _predicates_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(67277);


const _excluded = ["keyMap"],
  _excluded2 = ["keyMap"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }







// getNodeType :: Node -> String
const getNodeType = element => {
  /*
   * We're translating every possible higher element type to primitive minim type here.
   * We're using polymorphism to recognize any higher element type as ObjectElement or ArrayElement.
   * Using polymorphism allows us to assume any namespace.
   *
   * There is a problem with naming visitor methods described here: https://github.com/babel/babel/discussions/12874
   */
  /* eslint-disable no-nested-ternary */
  return (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isObjectElement)(element) ? 'ObjectElement' : (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isArrayElement)(element) ? 'ArrayElement' : (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isMemberElement)(element) ? 'MemberElement' : (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(element) ? 'StringElement' : (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isBooleanElement)(element) ? 'BooleanElement' : (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isNumberElement)(element) ? 'NumberElement' : (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isNullElement)(element) ? 'NullElement' : (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isLinkElement)(element) ? 'LinkElement' : (0,_predicates_index_js__WEBPACK_IMPORTED_MODULE_5__.isRefElement)(element) ? 'RefElement' : undefined;
  /* eslint-enable */
};

// isNode :: Node -> Boolean
const isNode = (0,ramda__WEBPACK_IMPORTED_MODULE_3__.curryN)(1, (0,ramda__WEBPACK_IMPORTED_MODULE_3__.pipe)(getNodeType, ramda_adjunct__WEBPACK_IMPORTED_MODULE_6__["default"]));
const keyMapDefault = {
  ObjectElement: ['content'],
  ArrayElement: ['content'],
  MemberElement: ['key', 'value'],
  StringElement: [],
  BooleanElement: [],
  NumberElement: [],
  NullElement: [],
  RefElement: [],
  LinkElement: [],
  Annotation: [],
  Comment: [],
  ParseResultElement: ['content'],
  SourceMap: ['content']
};
const PredicateVisitor = stampit__WEBPACK_IMPORTED_MODULE_2__({
  props: {
    result: [],
    predicate: ramda__WEBPACK_IMPORTED_MODULE_3__.F,
    returnOnTrue: undefined,
    returnOnFalse: undefined
  },
  init({
    // @ts-ignore
    predicate = this.predicate,
    // @ts-ignore
    returnOnTrue = this.returnOnTrue,
    // @ts-ignore
    returnOnFalse = this.returnOnFalse
  } = {}) {
    this.result = [];
    this.predicate = predicate;
    this.returnOnTrue = returnOnTrue;
    this.returnOnFalse = returnOnFalse;
  },
  methods: {
    enter(element) {
      if (this.predicate(element)) {
        this.result.push(element);
        return this.returnOnTrue;
      }
      return this.returnOnFalse;
    }
  }
});

// @ts-ignore
const visit = (root,
// @ts-ignore
visitor, _ref = {}) => {
  let {
      keyMap = keyMapDefault
    } = _ref,
    rest = (0,_babel_runtime_corejs3_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, _excluded);
  // @ts-ignore
  return (0,_swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_4__.visit)(root, visitor, _objectSpread({
    // @ts-ignore
    keyMap,
    // @ts-ignore
    nodeTypeGetter: getNodeType,
    nodePredicate: isNode
  }, rest));
};

// @ts-ignore
visit[Symbol.for('nodejs.util.promisify.custom')] = async (root,
// @ts-ignore
visitor, _ref2 = {}) => {
  let {
      keyMap = keyMapDefault
    } = _ref2,
    rest = (0,_babel_runtime_corejs3_helpers_esm_objectWithoutProperties__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref2, _excluded2);
  // @ts-ignore
  return _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_4__.visit[Symbol.for('nodejs.util.promisify.custom')](root, visitor, _objectSpread({
    // @ts-ignore
    keyMap,
    // @ts-ignore
    nodeTypeGetter: getNodeType,
    nodePredicate: isNode
  }, rest));
};

/***/ }),

/***/ 19245:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "dereference": () => (/* binding */ dereference)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38074);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(314);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16138);



/**
 * This dereference algorithm is used exclusively for dereferencing specification objects.
 * It doesn't handle circular references of external references and works on objects only (not arrays).
 */
// eslint-disable-next-line import/prefer-default-export
const dereference = (object, root) => {
  const rootObject = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.defaultTo)(object, root);
  return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.mapObjIndexed)(val => {
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"])(val) && (0,ramda__WEBPACK_IMPORTED_MODULE_0__.has)('$ref', val) && (0,ramda__WEBPACK_IMPORTED_MODULE_0__.propSatisfies)(ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__["default"], '$ref', val)) {
      const $ref = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.path)(['$ref'], val);
      // @ts-ignore
      const pointer = (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"])('#/', $ref);
      return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.path)(pointer.split('/'), rootObject);
    }
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"])(val)) {
      return dereference(val, rootObject);
    }
    return val;
  }, object);
};

/***/ }),

/***/ 72965:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EvaluationJsonPointerError)
/* harmony export */ });
class EvaluationJsonPointerError extends Error {
  constructor(message) {
    super(message);
    this.name = this.constructor.name;
    this.message = message;
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(message).stack;
    }
  }
}

/***/ }),

/***/ 76451:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ InvalidJsonPointerError)
/* harmony export */ });
class InvalidJsonPointerError extends Error {
  constructor(pointer) {
    super(`Invalid $ref pointer "${pointer}". Pointers must begin with "/"`);
    this.name = this.constructor.name;
    this.message = `Invalid $ref pointer "${pointer}". Pointers must begin with "/"`;
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(`Invalid $ref pointer "${pointer}". Pointers must begin with "/"`).stack;
    }
  }
}

/***/ }),

/***/ 77782:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EvaluationJsonPointerError": () => (/* reexport safe */ _errors_index_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "InvalidJsonPointerError": () => (/* reexport safe */ _errors_index_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "compile": () => (/* binding */ compile),
/* harmony export */   "escape": () => (/* binding */ escape),
/* harmony export */   "evaluate": () => (/* binding */ evaluate),
/* harmony export */   "parse": () => (/* binding */ parse),
/* harmony export */   "unescape": () => (/* binding */ unescape),
/* harmony export */   "uriToPointer": () => (/* binding */ uriToPointer)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77189);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22582);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(16138);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(67277);
/* harmony import */ var _errors_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76451);
/* harmony import */ var _errors_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(72965);






/**
 * decodeURIComponent can throw URIError in certain cases like 'c%d'.
 * safeDecodeURIComponent is a safe variant of decodeURIComponent that never trows.
 *
 * {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Malformed_URI|More info about URIError}
 */
const safeDecodeURIComponent = encodedURIComponent => {
  try {
    return decodeURIComponent(encodedURIComponent);
  } catch {
    return encodedURIComponent;
  }
};

// escape :: String -> String
const escape = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)((0,ramda__WEBPACK_IMPORTED_MODULE_0__.replace)(/~/g, '~0'), (0,ramda__WEBPACK_IMPORTED_MODULE_0__.replace)(/\//g, '~1'), encodeURIComponent);

// unescape :: String -> String
const unescape = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)((0,ramda__WEBPACK_IMPORTED_MODULE_0__.replace)(/~1/g, '/'), (0,ramda__WEBPACK_IMPORTED_MODULE_0__.replace)(/~0/g, '~'), safeDecodeURIComponent);

// parse :: String -> String[]
const parse = pointer => {
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"])(pointer)) {
    return [];
  }
  if (!(0,ramda__WEBPACK_IMPORTED_MODULE_0__.startsWith)('/', pointer)) {
    throw new _errors_index_js__WEBPACK_IMPORTED_MODULE_1__["default"](pointer);
  }
  const tokens = (0,ramda__WEBPACK_IMPORTED_MODULE_0__.pipe)((0,ramda__WEBPACK_IMPORTED_MODULE_0__.split)('/'), (0,ramda__WEBPACK_IMPORTED_MODULE_0__.map)(unescape))(pointer);
  return (0,ramda__WEBPACK_IMPORTED_MODULE_0__.tail)(tokens);
};

// compile :: String[] -> String
const compile = tokens => {
  if (tokens.length === 0) {
    return '';
  }
  return `/${tokens.map(escape).join('/')}`;
};

// evaluates JSON Pointer against ApiDOM fragment
const evaluate = (pointer, element) => {
  const tokens = parse(pointer);
  return tokens.reduce((acc, token) => {
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isObjectElement)(acc)) {
      // @ts-ignore
      if (!acc.hasKey(token)) {
        throw new _errors_index_js__WEBPACK_IMPORTED_MODULE_2__["default"](`Evaluation failed on token: "${token}"`);
      }
      // @ts-ignore
      return acc.get(token);
    }
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isArrayElement)(acc)) {
      if (!(token in acc.content) || !(0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(Number(token))) {
        throw new _errors_index_js__WEBPACK_IMPORTED_MODULE_2__["default"](`Evaluation failed on token: "${token}"`);
      }
      // @ts-ignore
      return acc.get(Number(token));
    }
    throw new _errors_index_js__WEBPACK_IMPORTED_MODULE_2__["default"](`Evaluation failed on token: "${token}"`);
  }, element);
};

/**
 * Returns the hash (URL fragment), of the given path.
 * If there is no hash, then the root hash ("#") is returned.
 */
const getHash = uri => {
  const hashIndex = uri.indexOf('#');
  if (hashIndex !== -1) {
    return uri.substring(hashIndex);
  }
  return '#';
};

// uriToPointer :: String -> String
const uriToPointer = uri => {
  const hash = getHash(uri);
  return (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_6__["default"])('#', hash);
};

/***/ }),

/***/ 78188:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);


/**
 * In Draft 4, $ref behaves a little differently. When an object contains a $ref property,
 * the object is considered a reference, not a schema. Therefore, any other properties you put in that object will
 * not be treated as JSON Schema keywords and will be ignored by the validator.
 * $ref can only be used where a schema is expected.
 *
 * URI: https://json-schema.org/understanding-json-schema/structuring.html?highlight=ref#id18
 */

class JSONReference extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'JSONReference';
    this.classes.push('json-reference');
  }
  get $ref() {
    return this.get('$ref');
  }
  set $ref($ref) {
    this.set('$ref', $ref);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONReference);

/***/ }),

/***/ 64635:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class JSONSchema extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'JSONSchemaDraft4';
  }

  /**
   * Core vocabulary
   *
   * URI: https://tools.ietf.org/html/draft-wright-json-schema-00
   */

  get idProp() {
    return this.get('id');
  }
  set idProp(idProp) {
    this.set('id', idProp);
  }
  get $schema() {
    return this.get('$schema');
  }
  set $schema($schema) {
    this.set('idProp', $schema);
  }

  /**
   * Validation vocabulary
   *
   * URI: https://tools.ietf.org/html/draft-wright-json-schema-validation-00
   */

  /**
   *  Validation keywords for numeric instances (number and integer)
   */

  get multipleOf() {
    return this.get('multipleOf');
  }
  set multipleOf(multipleOf) {
    this.set('multipleOf', multipleOf);
  }
  get maximum() {
    return this.get('maximum');
  }
  set maximum(maximum) {
    this.set('maximum', maximum);
  }
  get exclusiveMaximum() {
    return this.get('exclusiveMaximum');
  }
  set exclusiveMaximum(exclusiveMaximum) {
    this.set('exclusiveMaximum', exclusiveMaximum);
  }
  get minimum() {
    return this.get('minimum');
  }
  set minimum(minimum) {
    this.set('minimum', minimum);
  }
  get exclusiveMinimum() {
    return this.get('exclusiveMinimum');
  }
  set exclusiveMinimum(exclusiveMinimum) {
    this.set('exclusiveMinimum', exclusiveMinimum);
  }

  /**
   * Validation keywords for strings
   */

  get maxLength() {
    return this.get('maxLength');
  }
  set maxLength(maxLength) {
    this.set('maxLength', maxLength);
  }
  get minLength() {
    return this.get('minLength');
  }
  set minLength(minLength) {
    this.set('minLength', minLength);
  }
  get pattern() {
    return this.get('pattern');
  }
  set pattern(pattern) {
    this.set('pattern', pattern);
  }

  /**
   * Validation keywords for arrays
   */

  get additionalItems() {
    return this.get('additionalItems');
  }
  set additionalItems(additionalItems) {
    this.set('additionalItems', additionalItems);
  }
  get items() {
    return this.get('items');
  }
  set items(items) {
    this.set('items', items);
  }
  get maxItems() {
    return this.get('maxItems');
  }
  set maxItems(maxItems) {
    this.set('maxItems', maxItems);
  }
  get minItems() {
    return this.get('minItems');
  }
  set minItems(minItems) {
    this.set('minItems', minItems);
  }
  get uniqueItems() {
    return this.get('uniqueItems');
  }
  set uniqueItems(uniqueItems) {
    this.set('uniqueItems', uniqueItems);
  }

  /**
   * Validation keywords for objects
   */

  get maxProperties() {
    return this.get('maxProperties');
  }
  set maxProperties(maxProperties) {
    this.set('maxProperties', maxProperties);
  }
  get minProperties() {
    return this.get('minProperties');
  }
  set minProperties(minProperties) {
    this.set('minProperties', minProperties);
  }
  get required() {
    return this.get('required');
  }
  set required(required) {
    this.set('required', required);
  }
  get properties() {
    return this.get('properties');
  }
  set properties(properties) {
    this.set('properties', properties);
  }
  get additionalProperties() {
    return this.get('additionalProperties');
  }
  set additionalProperties(additionalProperties) {
    this.set('additionalProperties', additionalProperties);
  }
  get patternProperties() {
    return this.get('patternProperties');
  }
  set patternProperties(patternProperties) {
    this.set('patternProperties', patternProperties);
  }
  get dependencies() {
    return this.get('dependencies');
  }
  set dependencies(dependencies) {
    this.set('dependencies', dependencies);
  }

  /**
   *  Validation keywords for any instance type
   */

  get enum() {
    return this.get('enum');
  }
  set enum(enumValue) {
    this.set('enum', enumValue);
  }
  get type() {
    return this.get('type');
  }
  set type(type) {
    this.set('type', type);
  }
  get allOf() {
    return this.get('allOf');
  }
  set allOf(allOf) {
    this.set('allOf', allOf);
  }
  get anyOf() {
    return this.get('anyOf');
  }
  set anyOf(anyOf) {
    this.set('anyOf', anyOf);
  }
  get oneOf() {
    return this.get('oneOf');
  }
  set oneOf(oneOf) {
    this.set('oneOf', oneOf);
  }
  get not() {
    return this.get('not');
  }
  set not(not) {
    this.set('not', not);
  }
  get definitions() {
    return this.get('definitions');
  }
  set definitions(definitions) {
    this.set('definitions', definitions);
  }

  /**
   * Metadata keywords
   *
   * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-validation-00#section-6
   */

  get title() {
    return this.get('title');
  }
  set title(title) {
    this.set('title', title);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get default() {
    return this.get('default');
  }
  set default(defaultValue) {
    this.set('default', defaultValue);
  }

  /**
   * Semantic validation with "format"
   *
   * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-validation-00#section-7
   */

  get format() {
    return this.get('format');
  }
  set format(format) {
    this.set('format', format);
  }

  /**
   * JSON Hyper-Schema
   *
   * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-hyperschema-00
   */

  get base() {
    return this.get('base');
  }
  set base(base) {
    this.set('base', base);
  }
  get links() {
    return this.get('links');
  }
  set links(links) {
    this.set('links', links);
  }
  get media() {
    return this.get('media');
  }
  set media(media) {
    this.set('media', media);
  }
  get readOnly() {
    return this.get('readOnly');
  }
  set readOnly(readOnly) {
    this.set('readOnly', readOnly);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONSchema);

/***/ }),

/***/ 4278:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

/**
 * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-hyperschema-00#section-5
 */

class LinkDescription extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'linkDescription';
  }
  get href() {
    return this.get('href');
  }
  set href(href) {
    this.set('href', href);
  }
  get rel() {
    return this.get('rel');
  }
  set rel(rel) {
    this.set('rel', rel);
  }
  get title() {
    return this.get('title');
  }
  set title(title) {
    this.set('title', title);
  }
  get targetSchema() {
    return this.get('targetSchema');
  }
  set targetSchema(targetSchema) {
    this.set('targetSchema', targetSchema);
  }
  get mediaType() {
    return this.get('mediaType');
  }
  set mediaType(mediaType) {
    this.set('mediaType', mediaType);
  }
  get method() {
    return this.get('method');
  }
  set method(method) {
    this.set('method', method);
  }
  get encType() {
    return this.get('encType');
  }
  set encType(encType) {
    this.set('encType', encType);
  }
  get schema() {
    return this.get('schema');
  }
  set schema(schema) {
    this.set('schema', schema);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkDescription);

/***/ }),

/***/ 780:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);


/**
 * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-hyperschema-00#section-4.3
 */

class Media extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'media';
  }
  get binaryEncoding() {
    return this.get('binaryEncoding');
  }
  set binaryEncoding(binaryEncoding) {
    this.set('binaryEncoding', binaryEncoding);
  }
  get type() {
    return this.get('type');
  }
  set type(type) {
    this.set('type', type);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Media);

/***/ }),

/***/ 19036:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_JSONSchema_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64635);
/* harmony import */ var _elements_JSONReference_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(78188);
/* harmony import */ var _elements_Media_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(780);
/* harmony import */ var _elements_LinkDescription_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4278);




const jsonSchemaDraft4 = {
  namespace: options => {
    const {
      base
    } = options;
    base.register('jSONSchemaDraft4', _elements_JSONSchema_js__WEBPACK_IMPORTED_MODULE_0__["default"]);
    base.register('jSONReference', _elements_JSONReference_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
    base.register('media', _elements_Media_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
    base.register('linkDescription', _elements_LinkDescription_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
    return base;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (jsonSchemaDraft4);

/***/ }),

/***/ 35745:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isJSONReferenceElement": () => (/* binding */ isJSONReferenceElement),
/* harmony export */   "isJSONSchemaElement": () => (/* binding */ isJSONSchemaElement),
/* harmony export */   "isLinkDescriptionElement": () => (/* binding */ isLinkDescriptionElement),
/* harmony export */   "isMediaElement": () => (/* binding */ isMediaElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37330);
/* harmony import */ var _elements_JSONSchema_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64635);
/* harmony import */ var _elements_JSONReference_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(78188);
/* harmony import */ var _elements_Media_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(780);
/* harmony import */ var _elements_LinkDescription_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4278);





const isJSONSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_JSONSchema_js__WEBPACK_IMPORTED_MODULE_1__["default"] || hasBasicElementProps(element) && isElementType('JSONSchemaDraft4', element) && primitiveEq('object', element);
});
const isJSONReferenceElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_JSONReference_js__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('JSONReference', element) && primitiveEq('object', element);
});
const isMediaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Media_js__WEBPACK_IMPORTED_MODULE_3__["default"] || hasBasicElementProps(element) && isElementType('media', element) && primitiveEq('object', element);
});
const isLinkDescriptionElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_LinkDescription_js__WEBPACK_IMPORTED_MODULE_4__["default"] || hasBasicElementProps(element) && isElementType('linkDescription', element) && primitiveEq('object', element);
});

/***/ }),

/***/ 56026:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createRefractor": () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(54633);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43500);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19245);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(66175);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(32240);
/* harmony import */ var _specification_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(72659);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(73266);
/* harmony import */ var _toolbox_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35520);

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }





const refract = (value, {
  specPath = ['visitors', 'document', 'objects', 'JSONSchema', '$visitor'],
  plugins = [],
  specificationObj = _specification_js__WEBPACK_IMPORTED_MODULE_1__["default"]
} = {}) => {
  const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.refract)(value);
  const resolvedSpec = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.dereference)(specificationObj);

  /**
   * This is where generic ApiDOM becomes semantic (namespace applied).
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const rootVisitor = (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(specPath, [], resolvedSpec);
  // @ts-ignore
  (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.visit)(element, rootVisitor, {
    state: {
      specObj: resolvedSpec
    }
  });

  /**
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.dispatchPlugins)(rootVisitor.element, plugins, {
    toolboxCreator: _toolbox_js__WEBPACK_IMPORTED_MODULE_7__["default"],
    visitorOptions: {
      keyMap: _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_8__.keyMap,
      nodeTypeGetter: _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_8__.getNodeType
    }
  });
};
const createRefractor = specPath => (value, options = {}) => refract(value, _objectSpread({
  specPath
}, options));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 3085:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isJSONReferenceLikeElement": () => (/* binding */ isJSONReferenceLikeElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67277);


// eslint-disable-next-line import/prefer-default-export
const isJSONReferenceLikeElement = element => {
  // @ts-ignore
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isObjectElement)(element) && element.hasKey('$ref');
};

/***/ }),

/***/ 83801:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "JSONReferenceElement": () => (/* reexport safe */ _elements_JSONReference_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "JSONSchemaElement": () => (/* reexport safe */ _elements_JSONSchema_js__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "LinkDescriptionElement": () => (/* reexport safe */ _elements_LinkDescription_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "MediaElement": () => (/* reexport safe */ _elements_Media_js__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _elements_JSONSchema_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64635);
/* harmony import */ var _elements_JSONReference_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(78188);
/* harmony import */ var _elements_Media_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(780);
/* harmony import */ var _elements_LinkDescription_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4278);
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56026);




 // register refractors specific to element types
_elements_JSONSchema_js__WEBPACK_IMPORTED_MODULE_0__["default"].refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'JSONSchema', '$visitor']);
_elements_JSONReference_js__WEBPACK_IMPORTED_MODULE_2__["default"].refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'JSONReference', '$visitor']);
_elements_Media_js__WEBPACK_IMPORTED_MODULE_3__["default"].refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Media', '$visitor']);
_elements_LinkDescription_js__WEBPACK_IMPORTED_MODULE_4__["default"].refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'LinkDescription', '$visitor']);


/***/ }),

/***/ 72659:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _visitors_FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);
/* harmony import */ var _visitors_json_schema_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(49650);
/* harmony import */ var _visitors_json_schema_IdVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45064);
/* harmony import */ var _visitors_json_schema_$schemaVisitor_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6169);
/* harmony import */ var _visitors_json_schema_MultipleOfVisitor_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12889);
/* harmony import */ var _visitors_json_schema_MaximumVisitor_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(18155);
/* harmony import */ var _visitors_json_schema_ExclusiveMaximumVisitor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(27473);
/* harmony import */ var _visitors_json_schema_MinimumVisitor_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(38838);
/* harmony import */ var _visitors_json_schema_ExclusiveMinimumVisitor_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(74503);
/* harmony import */ var _visitors_json_schema_MaxLengthVisitor_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(43388);
/* harmony import */ var _visitors_json_schema_MinLengthVisitor_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(25226);
/* harmony import */ var _visitors_json_schema_PatternVisitor_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(7926);
/* harmony import */ var _visitors_json_schema_ItemsVisitor_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(42899);
/* harmony import */ var _visitors_json_schema_MaxItemsVisitor_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(14030);
/* harmony import */ var _visitors_json_schema_MinItemsVisitor_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(71155);
/* harmony import */ var _visitors_json_schema_UniqueItemsVisitor_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(94945);
/* harmony import */ var _visitors_json_schema_MaxPropertiesVisitor_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(5602);
/* harmony import */ var _visitors_json_schema_MinPropertiesVisitor_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(78703);
/* harmony import */ var _visitors_json_schema_RequiredVisitor_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(23355);
/* harmony import */ var _visitors_json_schema_PropertiesVisitor_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(80413);
/* harmony import */ var _visitors_json_schema_PatternPropertiesVisitor_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(49295);
/* harmony import */ var _visitors_json_schema_DependenciesVisitor_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(46043);
/* harmony import */ var _visitors_json_schema_EnumVisitor_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(17384);
/* harmony import */ var _visitors_json_schema_TypeVisitor_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(6696);
/* harmony import */ var _visitors_json_schema_AllOfVisitor_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(95855);
/* harmony import */ var _visitors_json_schema_AnyOfVisitor_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(6645);
/* harmony import */ var _visitors_json_schema_OneOfVisitor_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(27235);
/* harmony import */ var _visitors_json_schema_DefinitionsVisitor_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(18575);
/* harmony import */ var _visitors_json_schema_TitleVisitor_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(64538);
/* harmony import */ var _visitors_json_schema_DescriptionVisitor_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(29207);
/* harmony import */ var _visitors_json_schema_DefaultVisitor_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(13047);
/* harmony import */ var _visitors_json_schema_FormatVisitor_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(85014);
/* harmony import */ var _visitors_json_schema_BaseVisitor_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(91577);
/* harmony import */ var _visitors_json_schema_LinksVisitor_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(85200);
/* harmony import */ var _visitors_json_schema_ReadOnlyVisitor_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(76591);
/* harmony import */ var _visitors_json_schema_json_reference_index_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(98821);
/* harmony import */ var _visitors_json_schema_json_reference_$RefVisitor_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(16462);
/* harmony import */ var _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(53796);
/* harmony import */ var _visitors_json_schema_media_index_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(36677);
/* harmony import */ var _visitors_json_schema_media_BinaryEncodingVisitor_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(87094);
/* harmony import */ var _visitors_json_schema_media_TypeVisitor_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(34634);
/* harmony import */ var _visitors_json_schema_link_description_index_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(50104);
/* harmony import */ var _visitors_json_schema_link_description_HrefVisitor_js__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(16979);
/* harmony import */ var _visitors_json_schema_link_description_RelVisitor_js__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(75476);
/* harmony import */ var _visitors_json_schema_link_description_TitleVisitor_js__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(15775);
/* harmony import */ var _visitors_json_schema_link_description_MediaTypeVisitor_js__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(14984);
/* harmony import */ var _visitors_json_schema_link_description_MethodVisitor_js__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(17714);
/* harmony import */ var _visitors_json_schema_link_description_EncTypeVisitor_js__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(78676);
















































/**
 * Specification object allows us to have complete control over visitors
 * when traversing the ApiDOM.
 * Specification also allows us to create amended refractors from
 * existing ones by manipulating it.
 *
 * Note: Specification object allows to use absolute internal JSON pointers.
 */
const specification = {
  visitors: {
    value: _visitors_FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"],
    JSONSchemaOrJSONReferenceVisitor: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"],
    document: {
      objects: {
        JSONSchema: {
          $visitor: _visitors_json_schema_index_js__WEBPACK_IMPORTED_MODULE_2__["default"],
          fixedFields: {
            // core vocabulary
            id: _visitors_json_schema_IdVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"],
            $schema: _visitors_json_schema_$schemaVisitor_js__WEBPACK_IMPORTED_MODULE_4__["default"],
            // validation vocabulary
            // validation keywords for numeric instances (number and integer)
            multipleOf: _visitors_json_schema_MultipleOfVisitor_js__WEBPACK_IMPORTED_MODULE_5__["default"],
            maximum: _visitors_json_schema_MaximumVisitor_js__WEBPACK_IMPORTED_MODULE_6__["default"],
            exclusiveMaximum: _visitors_json_schema_ExclusiveMaximumVisitor_js__WEBPACK_IMPORTED_MODULE_7__["default"],
            minimum: _visitors_json_schema_MinimumVisitor_js__WEBPACK_IMPORTED_MODULE_8__["default"],
            exclusiveMinimum: _visitors_json_schema_ExclusiveMinimumVisitor_js__WEBPACK_IMPORTED_MODULE_9__["default"],
            // validation keywords for strings
            maxLength: _visitors_json_schema_MaxLengthVisitor_js__WEBPACK_IMPORTED_MODULE_10__["default"],
            minLength: _visitors_json_schema_MinLengthVisitor_js__WEBPACK_IMPORTED_MODULE_11__["default"],
            pattern: _visitors_json_schema_PatternVisitor_js__WEBPACK_IMPORTED_MODULE_12__["default"],
            // validation keywords for arrays
            additionalItems: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"],
            items: _visitors_json_schema_ItemsVisitor_js__WEBPACK_IMPORTED_MODULE_13__["default"],
            maxItems: _visitors_json_schema_MaxItemsVisitor_js__WEBPACK_IMPORTED_MODULE_14__["default"],
            minItems: _visitors_json_schema_MinItemsVisitor_js__WEBPACK_IMPORTED_MODULE_15__["default"],
            uniqueItems: _visitors_json_schema_UniqueItemsVisitor_js__WEBPACK_IMPORTED_MODULE_16__["default"],
            // validation keywords for objects
            maxProperties: _visitors_json_schema_MaxPropertiesVisitor_js__WEBPACK_IMPORTED_MODULE_17__["default"],
            minProperties: _visitors_json_schema_MinPropertiesVisitor_js__WEBPACK_IMPORTED_MODULE_18__["default"],
            required: _visitors_json_schema_RequiredVisitor_js__WEBPACK_IMPORTED_MODULE_19__["default"],
            properties: _visitors_json_schema_PropertiesVisitor_js__WEBPACK_IMPORTED_MODULE_20__["default"],
            additionalProperties: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"],
            patternProperties: _visitors_json_schema_PatternPropertiesVisitor_js__WEBPACK_IMPORTED_MODULE_21__["default"],
            dependencies: _visitors_json_schema_DependenciesVisitor_js__WEBPACK_IMPORTED_MODULE_22__["default"],
            // validation keywords for any instance type
            enum: _visitors_json_schema_EnumVisitor_js__WEBPACK_IMPORTED_MODULE_23__["default"],
            type: _visitors_json_schema_TypeVisitor_js__WEBPACK_IMPORTED_MODULE_24__["default"],
            allOf: _visitors_json_schema_AllOfVisitor_js__WEBPACK_IMPORTED_MODULE_25__["default"],
            anyOf: _visitors_json_schema_AnyOfVisitor_js__WEBPACK_IMPORTED_MODULE_26__["default"],
            oneOf: _visitors_json_schema_OneOfVisitor_js__WEBPACK_IMPORTED_MODULE_27__["default"],
            not: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"],
            definitions: _visitors_json_schema_DefinitionsVisitor_js__WEBPACK_IMPORTED_MODULE_28__["default"],
            // metadata keywords
            title: _visitors_json_schema_TitleVisitor_js__WEBPACK_IMPORTED_MODULE_29__["default"],
            description: _visitors_json_schema_DescriptionVisitor_js__WEBPACK_IMPORTED_MODULE_30__["default"],
            default: _visitors_json_schema_DefaultVisitor_js__WEBPACK_IMPORTED_MODULE_31__["default"],
            // semantic validation with "format"
            format: _visitors_json_schema_FormatVisitor_js__WEBPACK_IMPORTED_MODULE_32__["default"],
            // JSON Hyper-Schema
            base: _visitors_json_schema_BaseVisitor_js__WEBPACK_IMPORTED_MODULE_33__["default"],
            links: _visitors_json_schema_LinksVisitor_js__WEBPACK_IMPORTED_MODULE_34__["default"],
            media: {
              $ref: '#/visitors/document/objects/Media'
            },
            readOnly: _visitors_json_schema_ReadOnlyVisitor_js__WEBPACK_IMPORTED_MODULE_35__["default"]
          }
        },
        JSONReference: {
          $visitor: _visitors_json_schema_json_reference_index_js__WEBPACK_IMPORTED_MODULE_36__["default"],
          fixedFields: {
            $ref: _visitors_json_schema_json_reference_$RefVisitor_js__WEBPACK_IMPORTED_MODULE_37__["default"]
          }
        },
        Media: {
          $visitor: _visitors_json_schema_media_index_js__WEBPACK_IMPORTED_MODULE_38__["default"],
          fixedFields: {
            binaryEncoding: _visitors_json_schema_media_BinaryEncodingVisitor_js__WEBPACK_IMPORTED_MODULE_39__["default"],
            type: _visitors_json_schema_media_TypeVisitor_js__WEBPACK_IMPORTED_MODULE_40__["default"]
          }
        },
        LinkDescription: {
          $visitor: _visitors_json_schema_link_description_index_js__WEBPACK_IMPORTED_MODULE_41__["default"],
          fixedFields: {
            href: _visitors_json_schema_link_description_HrefVisitor_js__WEBPACK_IMPORTED_MODULE_42__["default"],
            rel: _visitors_json_schema_link_description_RelVisitor_js__WEBPACK_IMPORTED_MODULE_43__["default"],
            title: _visitors_json_schema_link_description_TitleVisitor_js__WEBPACK_IMPORTED_MODULE_44__["default"],
            targetSchema: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"],
            mediaType: _visitors_json_schema_link_description_MediaTypeVisitor_js__WEBPACK_IMPORTED_MODULE_45__["default"],
            method: _visitors_json_schema_link_description_MethodVisitor_js__WEBPACK_IMPORTED_MODULE_46__["default"],
            encType: _visitors_json_schema_link_description_EncTypeVisitor_js__WEBPACK_IMPORTED_MODULE_47__["default"],
            schema: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"]
          }
        }
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (specification);

/***/ }),

/***/ 35520:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(75757);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(67277);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35745);
/* harmony import */ var _namespace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19036);

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }



const createToolbox = () => {
  const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.createNamespace)(_namespace_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
  const predicates = _objectSpread(_objectSpread({}, _predicates_js__WEBPACK_IMPORTED_MODULE_3__), {}, {
    isStringElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isStringElement
  });
  return {
    predicates,
    namespace
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createToolbox);

/***/ }),

/***/ 46302:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32674);
/* harmony import */ var _Visitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(63706);



/**
 * This visitor is responsible for falling back to current traversed element
 * Given JSONSchemaVisitor expects ObjectElement to be traversed. If
 * different Element is provided FallBackVisitor is responsible to assigning
 * this Element as current element.
 */
const FallbackVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_Visitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
  methods: {
    enter(element) {
      this.element = element.clone();
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FallbackVisitor);

/***/ }),

/***/ 82920:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(60285);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4926);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(66175);
/* harmony import */ var _Visitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(63706);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(73266);

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }






/**
 * This is a base Type for every visitor that does
 * internal look-ups to retrieve other child visitors.
 */
const SpecificationVisitor = stampit__WEBPACK_IMPORTED_MODULE_1__(_Visitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  props: {
    specObj: null,
    passingOptionsNames: ['specObj']
  },
  init({
    // @ts-ignore
    specObj = this.specObj
  }) {
    this.specObj = specObj;
  },
  methods: {
    retrievePassingOptions() {
      return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.pick)(this.passingOptionsNames, this);
    },
    retrieveFixedFields(specPath) {
      return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.pipe)((0,ramda__WEBPACK_IMPORTED_MODULE_2__.path)(['visitors', ...specPath, 'fixedFields']), ramda__WEBPACK_IMPORTED_MODULE_2__.keys)(this.specObj);
    },
    retrieveVisitor(specPath) {
      if ((0,ramda__WEBPACK_IMPORTED_MODULE_2__.pathSatisfies)(ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"], ['visitors', ...specPath], this.specObj)) {
        return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.path)(['visitors', ...specPath], this.specObj);
      }
      return (0,ramda__WEBPACK_IMPORTED_MODULE_2__.path)(['visitors', ...specPath, '$visitor'], this.specObj);
    },
    retrieveVisitorInstance(specPath, options = {}) {
      const passingOpts = this.retrievePassingOptions();
      return this.retrieveVisitor(specPath)(_objectSpread(_objectSpread({}, passingOpts), options));
    },
    toRefractedElement(specPath, element, options = {}) {
      /**
       * This is `Visitor shortcut`: mechanism for short circuiting the traversal and replacing
       * it by basic node cloning.
       *
       * Visiting the element is equivalent to cloning it  if the prototype of a visitor
       * is the same as the prototype of FallbackVisitor. If that's the case, we can avoid
       * bootstrapping the traversal cycle for fields that don't require any special visiting.
       */
      const visitor = this.retrieveVisitorInstance(specPath, options);
      const visitorPrototype = Object.getPrototypeOf(visitor);
      if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(this.fallbackVisitorPrototype)) {
        this.fallbackVisitorPrototype = Object.getPrototypeOf(this.retrieveVisitorInstance(['value']));
      }
      if (this.fallbackVisitorPrototype === visitorPrototype) {
        return element.clone();
      }

      // standard processing continues
      (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.visit)(element, visitor, _objectSpread({
        keyMap: _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_7__.keyMap,
        nodeTypeGetter: _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_7__.getNodeType
      }, options));
      return visitor.element;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SpecificationVisitor);

/***/ }),

/***/ 63706:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67277);


const Visitor = stampit__WEBPACK_IMPORTED_MODULE_0__({
  props: {
    element: null
  },
  // @ts-ignore
  methods: {
    copyMetaAndAttributes(from, to) {
      // copy sourcemaps
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.hasElementSourceMap)(from)) {
        to.meta.set('sourceMap', from.meta.get('sourceMap'));
      }
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Visitor);

/***/ }),

/***/ 50915:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61643);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37344);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32674);
/* harmony import */ var _SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82920);





const AlternatingVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  props: {
    alternator: []
  },
  methods: {
    enter(element) {
      const functions = this.alternator.map(({
        predicate,
        specPath
      }) => (0,ramda__WEBPACK_IMPORTED_MODULE_1__.ifElse)(predicate, (0,ramda__WEBPACK_IMPORTED_MODULE_1__.always)(specPath), ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"]));
      const specPath = (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(functions)(element);
      this.element = this.toRefractedElement(specPath, element);
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AlternatingVisitor);

/***/ }),

/***/ 39922:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88526);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67277);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43500);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32674);
/* harmony import */ var _SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82920);




const FixedFieldsVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
  props: {
    specPath: ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__["default"],
    ignoredFields: []
  },
  init({
    // @ts-ignore
    specPath = this.specPath,
    // @ts-ignore
    ignoredFields = this.ignoredFields
  } = {}) {
    this.specPath = specPath;
    this.ignoredFields = ignoredFields;
  },
  methods: {
    ObjectElement(objectElement) {
      const specPath = this.specPath(objectElement);
      const fields = this.retrieveFixedFields(specPath);
      objectElement.forEach((value, key, memberElement) => {
        if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(key) && fields.includes(key.toValue()) && !this.ignoredFields.includes(key.toValue())) {
          const fixedFieldElement = this.toRefractedElement([...specPath, 'fixedFields', key.toValue()], value);
          const newMemberElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.MemberElement(key.clone(), fixedFieldElement);
          this.copyMetaAndAttributes(memberElement, newMemberElement);
          newMemberElement.classes.push('fixed-field');
          this.element.content.push(newMemberElement);
        } else if (!this.ignoredFields.includes(key.toValue())) {
          this.element.content.push(memberElement.clone());
        }
      });
      this.copyMetaAndAttributes(objectElement, this.element);
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FixedFieldsVisitor);

/***/ }),

/***/ 36307:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(25657);
/* harmony import */ var _PatternedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(806);



const MapVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_PatternedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
  props: {
    fieldPatternPredicate: ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__["default"]
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MapVisitor);

/***/ }),

/***/ 806:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(88526);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43500);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32674);
/* harmony import */ var _SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82920);





const PatternedFieldsJsonObjectVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  props: {
    fieldPatternPredicate: ramda__WEBPACK_IMPORTED_MODULE_1__.F,
    specPath: ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"],
    ignoredFields: []
  },
  init({
    // @ts-ignore
    specPath = this.specPath,
    // @ts-ignore
    ignoredFields = this.ignoredFields
  } = {}) {
    this.specPath = specPath;
    this.ignoredFields = ignoredFields;
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      objectElement.forEach((value, key, memberElement) => {
        if (!this.ignoredFields.includes(key.toValue()) && this.fieldPatternPredicate(key.toValue())) {
          const specPath = this.specPath(value);
          const patternedFieldElement = this.toRefractedElement(specPath, value);
          const newMemberElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.MemberElement(key.clone(), patternedFieldElement);
          this.copyMetaAndAttributes(memberElement, newMemberElement);
          newMemberElement.classes.push('patterned-field');
          this.element.content.push(newMemberElement);
        } else if (!this.ignoredFields.includes(key.toValue())) {
          this.element.content.push(memberElement.clone());
        }
      });
      this.copyMetaAndAttributes(objectElement, this.element);
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternedFieldsJsonObjectVisitor);

/***/ }),

/***/ 6169:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const $schemaVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($schemaVisitor);

/***/ }),

/***/ 95855:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(32674);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82920);
/* harmony import */ var _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52320);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3085);






const AllOfVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  init() {
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-allOf');
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const specPath = (0,_predicates_js__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(item) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
        const element = this.toRefractedElement(specPath, item);
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AllOfVisitor);

/***/ }),

/***/ 6645:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(32674);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82920);
/* harmony import */ var _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52320);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3085);






const AnyOfVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  init() {
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-anyOf');
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const specPath = (0,_predicates_js__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(item) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
        const element = this.toRefractedElement(specPath, item);
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AnyOfVisitor);

/***/ }),

/***/ 91577:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const BaseVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BaseVisitor);

/***/ }),

/***/ 13047:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const DefaultVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DefaultVisitor);

/***/ }),

/***/ 18575:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(38715);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _generics_MapVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36307);
/* harmony import */ var _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52320);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3085);






const DefinitionsVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_generics_MapVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  props: {
    specPath: element => (0,_predicates_js__WEBPACK_IMPORTED_MODULE_4__.isJSONReferenceLikeElement)(element) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema']
  },
  init() {
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.ObjectElement();
    this.element.classes.push('json-schema-definitions');
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DefinitionsVisitor);

/***/ }),

/***/ 46043:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(38715);
/* harmony import */ var _generics_MapVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36307);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52320);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3085);






const DependenciesVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_generics_MapVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  props: {
    specPath: element => (0,_predicates_js__WEBPACK_IMPORTED_MODULE_4__.isJSONReferenceLikeElement)(element) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema']
  },
  init() {
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.ObjectElement();
    this.element.classes.push('json-schema-dependencies');
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DependenciesVisitor);

/***/ }),

/***/ 29207:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const DescriptionVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DescriptionVisitor);

/***/ }),

/***/ 17384:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32674);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46302);



const EnumVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
  methods: {
    ArrayElement(arrayElement) {
      this.element = arrayElement.clone();
      this.element.classes.push('json-schema-enum');
      return _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_2__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EnumVisitor);

/***/ }),

/***/ 27473:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const ExclusiveMaximumVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExclusiveMaximumVisitor);

/***/ }),

/***/ 74503:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const ExclusiveMinimumVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExclusiveMinimumVisitor);

/***/ }),

/***/ 85014:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const FormatVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FormatVisitor);

/***/ }),

/***/ 45064:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const IdVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IdVisitor);

/***/ }),

/***/ 42899:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32674);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(38715);
/* harmony import */ var _SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82920);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52320);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3085);






const ItemsVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  methods: {
    ObjectElement(objectElement) {
      const specPath = (0,_predicates_js__WEBPACK_IMPORTED_MODULE_4__.isJSONReferenceLikeElement)(objectElement) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
      this.element = this.toRefractedElement(specPath, objectElement);
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
    },
    ArrayElement(arrayElement) {
      this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.ArrayElement();
      this.element.classes.push('json-schema-items');
      arrayElement.forEach(item => {
        const specPath = (0,_predicates_js__WEBPACK_IMPORTED_MODULE_4__.isJSONReferenceLikeElement)(item) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
        const element = this.toRefractedElement(specPath, item);
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ItemsVisitor);

/***/ }),

/***/ 53796:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3085);
/* harmony import */ var _generics_AlternatingVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50915);




const SchemaOrReferenceVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_generics_AlternatingVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], {
  props: {
    alternator: [{
      predicate: _predicates_js__WEBPACK_IMPORTED_MODULE_3__.isJSONReferenceLikeElement,
      specPath: ['document', 'objects', 'JSONReference']
    }, {
      predicate: ramda__WEBPACK_IMPORTED_MODULE_1__.T,
      specPath: ['document', 'objects', 'JSONSchema']
    }]
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaOrReferenceVisitor);

/***/ }),

/***/ 85200:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(32674);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82920);
/* harmony import */ var _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52320);





const LinksVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  init() {
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-links');
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const linkDescriptionElement = this.toRefractedElement(['document', 'objects', 'LinkDescription'], item);
        this.element.push(linkDescriptionElement);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinksVisitor);

/***/ }),

/***/ 14030:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MaxItemsVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MaxItemsVisitor);

/***/ }),

/***/ 43388:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MaxLengthVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MaxLengthVisitor);

/***/ }),

/***/ 5602:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MaxPropertiesVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MaxPropertiesVisitor);

/***/ }),

/***/ 18155:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MaximumVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MaximumVisitor);

/***/ }),

/***/ 71155:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MinItemsVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MinItemsVisitor);

/***/ }),

/***/ 25226:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MinLengthVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MinLengthVisitor);

/***/ }),

/***/ 78703:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MinPropertiesVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MinPropertiesVisitor);

/***/ }),

/***/ 38838:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MinimumVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MinimumVisitor);

/***/ }),

/***/ 12889:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MultipleOfVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MultipleOfVisitor);

/***/ }),

/***/ 27235:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(32674);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82920);
/* harmony import */ var _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52320);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3085);






const OneOfVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_SpecificationVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  init() {
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-oneOf');
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const specPath = (0,_predicates_js__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(item) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
        const element = this.toRefractedElement(specPath, item);
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OneOfVisitor);

/***/ }),

/***/ 52320:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);

const ParentSchemaAwareVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__({
  props: {
    parent: null
  },
  // @ts-ignore
  init({
    parent = this.parent
  }) {
    this.parent = parent;
    this.passingOptionsNames = [...this.passingOptionsNames, 'parent'];
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParentSchemaAwareVisitor);

/***/ }),

/***/ 49295:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(38715);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _generics_MapVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36307);
/* harmony import */ var _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52320);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3085);






const PatternPropertiesVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_generics_MapVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  props: {
    specPath: element => (0,_predicates_js__WEBPACK_IMPORTED_MODULE_4__.isJSONReferenceLikeElement)(element) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema']
  },
  init() {
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.ObjectElement();
    this.element.classes.push('json-schema-patternProperties');
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternPropertiesVisitor);

/***/ }),

/***/ 7926:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const PatternVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternVisitor);

/***/ }),

/***/ 80413:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(38715);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _generics_MapVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36307);
/* harmony import */ var _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52320);
/* harmony import */ var _predicates_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3085);






const PropertiesVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_generics_MapVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  props: {
    specPath: element => (0,_predicates_js__WEBPACK_IMPORTED_MODULE_4__.isJSONReferenceLikeElement)(element) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema']
  },
  init() {
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.ObjectElement();
    this.element.classes.push('json-schema-properties');
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PropertiesVisitor);

/***/ }),

/***/ 76591:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const ReadOnlyVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReadOnlyVisitor);

/***/ }),

/***/ 23355:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32674);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46302);



const RequiredVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
  methods: {
    ArrayElement(arrayElement) {
      this.element = arrayElement.clone();
      this.element.classes.push('json-schema-required');
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequiredVisitor);

/***/ }),

/***/ 64538:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const TitleVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TitleVisitor);

/***/ }),

/***/ 6696:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32674);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46302);



const TypeVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
  methods: {
    StringElement(stringElement) {
      this.element = stringElement.clone();
      this.element.classes.push('json-schema-type');
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
    },
    ArrayElement(arrayElement) {
      this.element = arrayElement.clone();
      this.element.classes.push('json-schema-type');
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TypeVisitor);

/***/ }),

/***/ 94945:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const UniqueItemsVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UniqueItemsVisitor);

/***/ }),

/***/ 49650:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var _generics_FixedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39922);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);
/* harmony import */ var _elements_JSONSchema_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(64635);





const JSONSchemaVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_generics_FixedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  props: {
    specPath: (0,ramda__WEBPACK_IMPORTED_MODULE_1__.always)(['document', 'objects', 'JSONSchema'])
  },
  init() {
    this.element = new _elements_JSONSchema_js__WEBPACK_IMPORTED_MODULE_4__["default"]();
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONSchemaVisitor);

/***/ }),

/***/ 16462:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(32674);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46302);



const $RefVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_1__["default"], {
  methods: {
    StringElement(stringElement) {
      this.element = stringElement.clone();
      this.element.classes.push('reference-value');
      return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($RefVisitor);

/***/ }),

/***/ 98821:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(67277);
/* harmony import */ var _elements_JSONReference_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(78188);
/* harmony import */ var _generics_FixedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39922);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);






const JSONReferenceVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_generics_FixedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  props: {
    specPath: (0,ramda__WEBPACK_IMPORTED_MODULE_1__.always)(['document', 'objects', 'JSONReference'])
  },
  init() {
    this.element = new _elements_JSONReference_js__WEBPACK_IMPORTED_MODULE_4__["default"]();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _generics_FixedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"].compose.methods.ObjectElement.call(this, objectElement);

      // mark this JSONReferenceElement with reference metadata
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(this.element.$ref)) {
        this.element.classes.push('reference-element');
      }
      return result;
    }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONReferenceVisitor);

/***/ }),

/***/ 78676:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const EncTypeVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EncTypeVisitor);

/***/ }),

/***/ 16979:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const HrefVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HrefVisitor);

/***/ }),

/***/ 14984:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MediaTypeVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTypeVisitor);

/***/ }),

/***/ 17714:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const MethodVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MethodVisitor);

/***/ }),

/***/ 75476:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const RelVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RelVisitor);

/***/ }),

/***/ 15775:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const TitleVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TitleVisitor);

/***/ }),

/***/ 50104:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var _elements_LinkDescription_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4278);
/* harmony import */ var _generics_FixedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39922);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);





const LinkDescriptionVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_generics_FixedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  props: {
    specPath: (0,ramda__WEBPACK_IMPORTED_MODULE_1__.always)(['document', 'objects', 'LinkDescription'])
  },
  init() {
    this.element = new _elements_LinkDescription_js__WEBPACK_IMPORTED_MODULE_4__["default"]();
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkDescriptionVisitor);

/***/ }),

/***/ 87094:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const BinaryEncodingVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BinaryEncodingVisitor);

/***/ }),

/***/ 34634:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46302);

const TypeVisitor = _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_0__["default"];
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TypeVisitor);

/***/ }),

/***/ 36677:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var stampit__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43992);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25546);
/* harmony import */ var _elements_Media_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(780);
/* harmony import */ var _generics_FixedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39922);
/* harmony import */ var _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46302);





const MediaVisitor = stampit__WEBPACK_IMPORTED_MODULE_0__(_generics_FixedFieldsVisitor_js__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_js__WEBPACK_IMPORTED_MODULE_3__["default"], {
  props: {
    specPath: (0,ramda__WEBPACK_IMPORTED_MODULE_1__.always)(['document', 'objects', 'Media'])
  },
  init() {
    this.element = new _elements_Media_js__WEBPACK_IMPORTED_MODULE_4__["default"]();
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaVisitor);

/***/ }),

/***/ 73266:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getNodeType": () => (/* binding */ getNodeType),
/* harmony export */   "keyMap": () => (/* binding */ keyMap)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67277);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66175);

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }


// getNodeType :: Node -> String
const getNodeType = element => {
  if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isElement)(element)) {
    return undefined;
  }
  return `${element.element.charAt(0).toUpperCase() + element.element.slice(1)}Element`;
};
const keyMap = _objectSpread({
  JSONSchemaDraft4Element: ['content'],
  JSONReferenceElement: ['content'],
  MediaElement: ['content'],
  LinkDescriptionElement: ['content']
}, _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.keyMapDefault);

/***/ }),

/***/ 77807:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Callback extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'callback';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Callback);

/***/ }),

/***/ 94616:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Components extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'components';
  }
  get schemas() {
    return this.get('schemas');
  }
  set schemas(schemas) {
    this.set('schemas', schemas);
  }
  get responses() {
    return this.get('responses');
  }
  set responses(responses) {
    this.set('responses', responses);
  }
  get parameters() {
    return this.get('parameters');
  }
  set parameters(parameters) {
    this.set('parameters', parameters);
  }
  get examples() {
    return this.get('examples');
  }
  set examples(examples) {
    this.set('examples', examples);
  }
  get requestBodies() {
    return this.get('requestBodies');
  }
  set requestBodies(requestBodies) {
    this.set('requestBodies', requestBodies);
  }
  get headers() {
    return this.get('headers');
  }
  set headers(headers) {
    this.set('headers', headers);
  }
  get securitySchemes() {
    return this.get('securitySchemes');
  }
  set securitySchemes(securitySchemes) {
    this.set('securitySchemes', securitySchemes);
  }
  get links() {
    return this.get('links');
  }
  set links(links) {
    this.set('links', links);
  }
  get callbacks() {
    return this.get('callbacks');
  }
  set callbacks(callbacks) {
    this.set('callbacks', callbacks);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Components);

/***/ }),

/***/ 19737:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Contact extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'contact';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get url() {
    return this.get('url');
  }
  set url(url) {
    this.set('url', url);
  }
  get email() {
    return this.get('email');
  }
  set email(email) {
    this.set('email', email);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Contact);

/***/ }),

/***/ 36386:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Discriminator extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'discriminator';
  }
  get propertyName() {
    return this.get('propertyName');
  }
  set propertyName(propertyName) {
    this.set('propertyName', propertyName);
  }
  get mapping() {
    return this.get('mapping');
  }
  set mapping(mapping) {
    this.set('mapping', mapping);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Discriminator);

/***/ }),

/***/ 49467:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Encoding extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'encoding';
  }
  get contentType() {
    return this.get('contentType');
  }
  set contentType(contentType) {
    this.set('contentType', contentType);
  }
  get headers() {
    return this.get('headers');
  }
  set headers(headers) {
    this.set('headers', headers);
  }
  get style() {
    return this.get('style');
  }
  set style(style) {
    this.set('style', style);
  }
  get explode() {
    return this.get('explode');
  }
  set explode(explode) {
    this.set('explode', explode);
  }
  get allowedReserved() {
    return this.get('allowedReserved');
  }
  set allowedReserved(allowedReserved) {
    this.set('allowedReserved', allowedReserved);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Encoding);

/***/ }),

/***/ 48506:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Example extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'example';
  }
  get summary() {
    return this.get('summary');
  }
  set summary(summary) {
    this.set('summary', summary);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get value() {
    return this.get('value');
  }
  set value(value) {
    this.set('value', value);
  }
  get externalValue() {
    return this.get('externalValue');
  }
  set externalValue(externalValue) {
    this.set('externalValue', externalValue);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Example);

/***/ }),

/***/ 34935:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class ExternalDocumentation extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'externalDocumentation';
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get url() {
    return this.get('url');
  }
  set url(url) {
    this.set('url', url);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExternalDocumentation);

/***/ }),

/***/ 63563:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Header extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'header';
  }
  get required() {
    if (this.hasKey('required')) {
      return this.get('required');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set required(required) {
    this.set('required', required);
  }
  get deprecated() {
    if (this.hasKey('deprecated')) {
      return this.get('deprecated');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set deprecated(deprecated) {
    this.set('deprecated', deprecated);
  }
  get allowEmptyValue() {
    return this.get('allowEmptyValue');
  }
  set allowEmptyValue(allowEmptyValue) {
    this.set('allowEmptyValue', allowEmptyValue);
  }
  get style() {
    return this.get('style');
  }
  set style(style) {
    this.set('style', style);
  }
  get explode() {
    return this.get('explode');
  }
  set explode(explode) {
    this.set('explode', explode);
  }
  get allowReserved() {
    return this.get('allowReserved');
  }
  set allowReserved(allowReserved) {
    this.set('allowReserved', allowReserved);
  }
  get schema() {
    return this.get('schema');
  }
  set schema(schema) {
    this.set('schema', schema);
  }
  get example() {
    return this.get('example');
  }
  set example(example) {
    this.set('example', example);
  }
  get examples() {
    return this.get('examples');
  }
  set examples(examples) {
    this.set('examples', examples);
  }
  get contentProp() {
    return this.get('content');
  }
  set contentProp(content) {
    this.set('content', content);
  }
}
Object.defineProperty(Header.prototype, 'description', {
  get() {
    return this.get('description');
  },
  set(description) {
    this.set('description', description);
  },
  enumerable: true
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ 98744:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Info extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'info';
    this.classes.push('info');
  }
  get title() {
    return this.get('title');
  }
  set title(title) {
    this.set('title', title);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get termsOfService() {
    return this.get('termsOfService');
  }
  set termsOfService(tos) {
    this.set('termsOfService', tos);
  }
  get contact() {
    return this.get('contact');
  }
  set contact(contactElement) {
    this.set('contact', contactElement);
  }
  get license() {
    return this.get('license');
  }
  set license(licenseElement) {
    this.set('license', licenseElement);
  }
  get version() {
    return this.get('version');
  }
  set version(version) {
    this.set('version', version);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Info);

/***/ }),

/***/ 27891:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class License extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'license';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get url() {
    return this.get('url');
  }
  set url(url) {
    this.set('url', url);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (License);

/***/ }),

/***/ 73140:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67277);

class Link extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'link';
  }
  get operationRef() {
    return this.get('operationRef');
  }
  set operationRef(operationRef) {
    this.set('operationRef', operationRef);
  }
  get operationId() {
    return this.get('operationId');
  }
  set operationId(operationId) {
    this.set('operationId', operationId);
  }
  get operation() {
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isStringElement)(this.operationRef)) {
      var _this$operationRef;
      return (_this$operationRef = this.operationRef) === null || _this$operationRef === void 0 ? void 0 : _this$operationRef.meta.get('operation');
    }
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isStringElement)(this.operationId)) {
      var _this$operationId;
      return (_this$operationId = this.operationId) === null || _this$operationId === void 0 ? void 0 : _this$operationId.meta.get('operation');
    }
    return undefined;
  }
  set operation(operation) {
    this.set('operation', operation);
  }
  get parameters() {
    return this.get('parameters');
  }
  set parameters(parameters) {
    this.set('parameters', parameters);
  }
  get requestBody() {
    return this.get('requestBody');
  }
  set requestBody(requestBody) {
    this.set('requestBody', requestBody);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get server() {
    return this.get('server');
  }
  set server(server) {
    this.set('server', server);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ 94032:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class MediaType extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'mediaType';
  }
  get schema() {
    return this.get('schema');
  }
  set schema(schema) {
    this.set('schema', schema);
  }
  get example() {
    return this.get('example');
  }
  set example(example) {
    this.set('example', example);
  }
  get examples() {
    return this.get('examples');
  }
  set examples(examples) {
    this.set('examples', examples);
  }
  get encoding() {
    return this.get('encoding');
  }
  set encoding(encoding) {
    this.set('encoding', encoding);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaType);

/***/ }),

/***/ 86281:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class OAuthFlow extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'oAuthFlow';
  }
  get authorizationUrl() {
    return this.get('authorizationUrl');
  }
  set authorizationUrl(authorizationUrl) {
    this.set('authorizationUrl', authorizationUrl);
  }
  get tokenUrl() {
    return this.get('tokenUrl');
  }
  set tokenUrl(tokenUrl) {
    this.set('tokenUrl', tokenUrl);
  }
  get refreshUrl() {
    return this.get('refreshUrl');
  }
  set refreshUrl(refreshUrl) {
    this.set('refreshUrl', refreshUrl);
  }
  get scopes() {
    return this.get('scopes');
  }
  set scopes(scopes) {
    this.set('scopes', scopes);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlow);

/***/ }),

/***/ 13233:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class OAuthFlows extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'oAuthFlows';
  }
  get implicit() {
    return this.get('implicit');
  }
  set implicit(implicit) {
    this.set('implicit', implicit);
  }
  get password() {
    return this.get('password');
  }
  set password(password) {
    this.set('password', password);
  }
  get clientCredentials() {
    return this.get('clientCredentials');
  }
  set clientCredentials(clientCredentials) {
    this.set('clientCredentials', clientCredentials);
  }
  get authorizationCode() {
    return this.get('authorizationCode');
  }
  set authorizationCode(authorizationCode) {
    this.set('authorizationCode', authorizationCode);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlows);

/***/ }),

/***/ 19203:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

// eslint-disable-next-line @typescript-eslint/naming-convention
class OpenApi3_0 extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'openApi3_0';
    this.classes.push('api');
  }
  get openapi() {
    return this.get('openapi');
  }
  set openapi(openapi) {
    this.set('openapi', openapi);
  }
  get info() {
    return this.get('info');
  }
  set info(info) {
    this.set('info', info);
  }
  get servers() {
    return this.get('servers');
  }
  set servers(servers) {
    this.set('servers', servers);
  }
  get paths() {
    return this.get('paths');
  }
  set paths(paths) {
    this.set('paths', paths);
  }
  get components() {
    return this.get('components');
  }
  set components(components) {
    this.set('components', components);
  }
  get security() {
    return this.get('security');
  }
  set security(security) {
    this.set('security', security);
  }
  get tags() {
    return this.get('tags');
  }
  set tags(tags) {
    this.set('tags', tags);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenApi3_0);

/***/ }),

/***/ 10865:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Openapi extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.StringElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'openapi';
    this.classes.push('spec-version');
    this.classes.push('version');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Openapi);

/***/ }),

/***/ 78102:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Operation extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'operation';
  }
  get tags() {
    return this.get('tags');
  }
  set tags(tags) {
    this.set('tags', tags);
  }
  get summary() {
    return this.get('summary');
  }
  set summary(description) {
    this.set('summary', description);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  get operationId() {
    return this.get('operationId');
  }
  set operationId(operationId) {
    this.set('operationId', operationId);
  }
  get parameters() {
    return this.get('parameters');
  }
  set parameters(parameters) {
    this.set('parameters', parameters);
  }
  get requestBody() {
    return this.get('requestBody');
  }
  set requestBody(requestBody) {
    this.set('requestBody', requestBody);
  }
  get responses() {
    return this.get('responses');
  }
  set responses(responses) {
    this.set('responses', responses);
  }
  get callbacks() {
    return this.get('callbacks');
  }
  set callbacks(callbacks) {
    this.set('callbacks', callbacks);
  }
  get deprecated() {
    if (this.hasKey('deprecated')) {
      return this.get('deprecated');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set deprecated(deprecated) {
    this.set('deprecated', deprecated);
  }
  get security() {
    return this.get('security');
  }
  set security(security) {
    this.set('security', security);
  }
  get servers() {
    return this.get('severs');
  }
  set servers(servers) {
    this.set('servers', servers);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Operation);

/***/ }),

/***/ 43654:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Parameter extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'parameter';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get in() {
    return this.get('in');
  }
  set in(val) {
    this.set('in', val);
  }
  get required() {
    if (this.hasKey('required')) {
      return this.get('required');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set required(required) {
    this.set('required', required);
  }
  get deprecated() {
    if (this.hasKey('deprecated')) {
      return this.get('deprecated');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set deprecated(deprecated) {
    this.set('deprecated', deprecated);
  }
  get allowEmptyValue() {
    return this.get('allowEmptyValue');
  }
  set allowEmptyValue(allowEmptyValue) {
    this.set('allowEmptyValue', allowEmptyValue);
  }
  get style() {
    return this.get('style');
  }
  set style(style) {
    this.set('style', style);
  }
  get explode() {
    return this.get('explode');
  }
  set explode(explode) {
    this.set('explode', explode);
  }
  get allowReserved() {
    return this.get('allowReserved');
  }
  set allowReserved(allowReserved) {
    this.set('allowReserved', allowReserved);
  }
  get schema() {
    return this.get('schema');
  }
  set schema(schema) {
    this.set('schema', schema);
  }
  get example() {
    return this.get('example');
  }
  set example(example) {
    this.set('example', example);
  }
  get examples() {
    return this.get('examples');
  }
  set examples(examples) {
    this.set('examples', examples);
  }
  get contentProp() {
    return this.get('content');
  }
  set contentProp(content) {
    this.set('content', content);
  }
}
Object.defineProperty(Parameter.prototype, 'description', {
  get() {
    return this.get('description');
  },
  set(description) {
    this.set('description', description);
  },
  enumerable: true
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Parameter);

/***/ }),

/***/ 61994:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class PathItem extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'pathItem';
  }
  get $ref() {
    return this.get('$ref');
  }
  set $ref($ref) {
    this.set('$ref', $ref);
  }
  get summary() {
    return this.get('summary');
  }
  set summary(summary) {
    this.set('summary', summary);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get GET() {
    return this.get('get');
  }
  set GET(operation) {
    this.set('GET', operation);
  }
  get PUT() {
    return this.get('put');
  }
  set PUT(operation) {
    this.set('PUT', operation);
  }
  get POST() {
    return this.get('post');
  }
  set POST(operation) {
    this.set('POST', operation);
  }
  get DELETE() {
    return this.get('delete');
  }
  set DELETE(operation) {
    this.set('DELETE', operation);
  }
  get OPTIONS() {
    return this.get('options');
  }
  set OPTIONS(operation) {
    this.set('OPTIONS', operation);
  }
  get HEAD() {
    return this.get('head');
  }
  set HEAD(operation) {
    this.set('HEAD', operation);
  }
  get PATCH() {
    return this.get('patch');
  }
  set PATCH(operation) {
    this.set('PATCH', operation);
  }
  get TRACE() {
    return this.get('trace');
  }
  set TRACE(operation) {
    this.set('TRACE', operation);
  }
  get servers() {
    return this.get('servers');
  }
  set servers(servers) {
    this.set('servers', servers);
  }
  get parameters() {
    return this.get('parameters');
  }
  set parameters(parameters) {
    this.set('parameters', parameters);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathItem);

/***/ }),

/***/ 74621:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Paths extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'paths';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Paths);

/***/ }),

/***/ 22096:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Reference extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'reference';
    this.classes.push('openapi-reference');
  }
  get $ref() {
    return this.get('$ref');
  }
  set $ref($ref) {
    this.set('$ref', $ref);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Reference);

/***/ }),

/***/ 96592:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class RequestBody extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'requestBody';
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get contentProp() {
    return this.get('content');
  }
  set contentProp(content) {
    this.set('content', content);
  }
  get required() {
    if (this.hasKey('required')) {
      return this.get('required');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set required(required) {
    this.set('required', required);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBody);

/***/ }),

/***/ 25517:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Response extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'response';
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get headers() {
    return this.get('headers');
  }
  set headers(headers) {
    this.set('headers', headers);
  }
  get contentProp() {
    return this.get('content');
  }
  set contentProp(contentProp) {
    this.set('content', contentProp);
  }
  get links() {
    return this.get('links');
  }
  set links(links) {
    this.set('links', links);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Response);

/***/ }),

/***/ 20561:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Responses extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'responses';
  }
  get default() {
    return this.get('default');
  }
  set default(defaultValue) {
    this.set('default', defaultValue);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Responses);

/***/ }),

/***/ 99082:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83801);

class Schema extends _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__.JSONSchemaElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'schema';
    this.classes.push('json-schema-draft-4');
  }

  /**
   * Validation keywords for arrays
   */

  get additionalItems() {
    return this.get('additionalItems');
  }
  set additionalItems(additionalItems) {
    this.set('additionalItems', additionalItems);
  }
  get items() {
    return this.get('items');
  }
  set items(items) {
    this.set('items', items);
  }

  /**
   * Validation keywords for objects
   */

  get additionalProperties() {
    return this.get('additionalProperties');
  }
  set additionalProperties(additionalProperties) {
    this.set('additionalProperties', additionalProperties);
  }

  /**
   *  Validation keywords for any instance type
   */

  get type() {
    return this.get('type');
  }
  set type(type) {
    this.set('type', type);
  }
  get not() {
    return this.get('not');
  }
  set not(not) {
    this.set('not', not);
  }

  /**
   * OpenAPI vocabulary
   */

  get nullable() {
    return this.get('nullable');
  }
  set nullable(nullable) {
    this.set('nullable', nullable);
  }
  get discriminator() {
    return this.get('discriminator');
  }
  set discriminator(discriminator) {
    this.set('discriminator', discriminator);
  }
  get writeOnly() {
    return this.get('writeOnly');
  }
  set writeOnly(writeOnly) {
    this.set('writeOnly', writeOnly);
  }
  get xml() {
    return this.get('xml');
  }
  set xml(xml) {
    this.set('xml', xml);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
  get example() {
    return this.get('example');
  }
  set example(example) {
    this.set('example', example);
  }
  get deprecated() {
    return this.get('deprecated');
  }
  set deprecated(deprecated) {
    this.set('deprecated', deprecated);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Schema);

/***/ }),

/***/ 8487:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class SecurityRequirement extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'securityRequirement';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecurityRequirement);

/***/ }),

/***/ 19021:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class SecurityScheme extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'securityScheme';
  }
  get type() {
    return this.get('type');
  }
  set type(type) {
    this.set('type', type);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get in() {
    return this.get('in');
  }
  set in(inVal) {
    this.set('in', inVal);
  }
  get scheme() {
    return this.get('scheme');
  }
  set scheme(scheme) {
    this.set('scheme', scheme);
  }
  get bearerFormat() {
    return this.get('bearerFormat');
  }
  set bearerFormat(bearerFormat) {
    this.set('bearerFormat', bearerFormat);
  }
  get flows() {
    return this.get('flows');
  }
  set flows(flows) {
    this.set('flows', flows);
  }
  get openIdConnectUrl() {
    return this.get('openIdConnectUrl');
  }
  set openIdConnectUrl(openIdConnectUrl) {
    this.set('openIdConnectUrl', openIdConnectUrl);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecurityScheme);

/***/ }),

/***/ 11506:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Server extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'server';
  }
  get url() {
    return this.get('url');
  }
  set url(url) {
    this.set('url', url);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get variables() {
    return this.get('variables');
  }
  set variables(variables) {
    this.set('variables', variables);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Server);

/***/ }),

/***/ 24979:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class ServerVariable extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'serverVariable';
  }
  get enum() {
    return this.get('enum');
  }
  set enum(value) {
    this.set('enum', value);
  }
  get default() {
    return this.get('default');
  }
  set default(value) {
    this.set('default', value);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServerVariable);

/***/ }),

/***/ 82483:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Tag extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'tag';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tag);

/***/ }),

/***/ 66061:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38715);

class Xml extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'xml';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get namespace() {
    return this.get('namespace');
  }
  set namespace(namespace) {
    this.set('namespace', namespace);
  }
  get prefix() {
    return this.get('prefix');
  }
  set prefix(prefix) {
    this.set('prefix', prefix);
  }
  get attribute() {
    return this.get('attribute');
  }
  set attribute(attribute) {
    this.set('attribute', attribute);
  }
  get wrapped() {
    return this.get('wrapped');
  }
  set wrapped(wrapped) {
    this.set('wrapped', wrapped);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Xml);

/***/ }),

/***/ 89783:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ComponentsCallbacks extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsCallbacks.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ComponentsCallbacks, "primaryClass", 'components-callbacks');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsCallbacks);

/***/ }),

/***/ 53768:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ComponentsExamples extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsExamples.primaryClass);
    this.classes.push('examples');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ComponentsExamples, "primaryClass", 'components-examples');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsExamples);

/***/ }),

/***/ 83949:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ComponentsHeaders extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsHeaders.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ComponentsHeaders, "primaryClass", 'components-headers');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsHeaders);

/***/ }),

/***/ 92075:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ComponentsLinks extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsLinks.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ComponentsLinks, "primaryClass", 'components-links');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsLinks);

/***/ }),

/***/ 71097:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ComponentsParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsParameters.primaryClass);
    this.classes.push('parameters');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ComponentsParameters, "primaryClass", 'components-parameters');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsParameters);

/***/ }),

/***/ 15407:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ComponentsRequestBodies extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsRequestBodies.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ComponentsRequestBodies, "primaryClass", 'components-request-bodies');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsRequestBodies);

/***/ }),

/***/ 11760:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ComponentsResponses extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsResponses.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ComponentsResponses, "primaryClass", 'components-responses');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsResponses);

/***/ }),

/***/ 56614:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ComponentsSchemas extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsSchemas.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ComponentsSchemas, "primaryClass", 'components-schemas');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsSchemas);

/***/ }),

/***/ 20778:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ComponentsSecuritySchemes extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsSecuritySchemes.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ComponentsSecuritySchemes, "primaryClass", 'components-security-schemes');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsSecuritySchemes);

/***/ }),

/***/ 36198:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class DiscriminatorMapping extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(DiscriminatorMapping.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(DiscriminatorMapping, "primaryClass", 'discriminator-mapping');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscriminatorMapping);

/***/ }),

/***/ 61878:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class EncodingHeaders extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(EncodingHeaders.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(EncodingHeaders, "primaryClass", 'encoding-headers');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EncodingHeaders);

/***/ }),

/***/ 88168:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class HeaderContent extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(HeaderContent.primaryClass);
    this.classes.push('content');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(HeaderContent, "primaryClass", 'header-content');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderContent);

/***/ }),

/***/ 21734:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class HeaderExamples extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(HeaderExamples.primaryClass);
    this.classes.push('examples');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(HeaderExamples, "primaryClass", 'header-examples');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderExamples);

/***/ }),

/***/ 47443:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class LinkParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(LinkParameters.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(LinkParameters, "primaryClass", 'link-parameters');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkParameters);

/***/ }),

/***/ 26977:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class MediaTypeEncoding extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(MediaTypeEncoding.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(MediaTypeEncoding, "primaryClass", 'media-type-encoding');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTypeEncoding);

/***/ }),

/***/ 51551:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class MediaTypeExamples extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(MediaTypeExamples.primaryClass);
    this.classes.push('examples');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(MediaTypeExamples, "primaryClass", 'media-type-examples');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTypeExamples);

/***/ }),

/***/ 3964:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class OAuthFlowScopes extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OAuthFlowScopes.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(OAuthFlowScopes, "primaryClass", 'oauth-flow-scopes');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlowScopes);

/***/ }),

/***/ 59660:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class OperationCallbacks extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationCallbacks.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(OperationCallbacks, "primaryClass", 'operation-callbacks');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationCallbacks);

/***/ }),

/***/ 98715:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class OperationParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationParameters.primaryClass);
    this.classes.push('parameters');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(OperationParameters, "primaryClass", 'operation-parameters');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationParameters);

/***/ }),

/***/ 90058:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class OperationSecurity extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationSecurity.primaryClass);
    this.classes.push('security');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(OperationSecurity, "primaryClass", 'operation-security');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationSecurity);

/***/ }),

/***/ 36654:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class OperationServers extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationServers.primaryClass);
    this.classes.push('servers');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(OperationServers, "primaryClass", 'operation-servers');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationServers);

/***/ }),

/***/ 22131:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class OperationTags extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationTags.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(OperationTags, "primaryClass", 'operation-tags');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationTags);

/***/ }),

/***/ 86032:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ParameterContent extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ParameterContent.primaryClass);
    this.classes.push('content');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ParameterContent, "primaryClass", 'parameter-content');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParameterContent);

/***/ }),

/***/ 50617:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ParameterExamples extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ParameterExamples.primaryClass);
    this.classes.push('examples');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ParameterExamples, "primaryClass", 'parameter-examples');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParameterExamples);

/***/ }),

/***/ 29726:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class PathItemParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(PathItemParameters.primaryClass);
    this.classes.push('parameters');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(PathItemParameters, "primaryClass", 'path-item-parameters');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathItemParameters);

/***/ }),

/***/ 75281:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class PathItemServers extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(PathItemServers.primaryClass);
    this.classes.push('servers');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(PathItemServers, "primaryClass", 'path-item-servers');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathItemServers);

/***/ }),

/***/ 27454:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class RequestBodyContent extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(RequestBodyContent.primaryClass);
    this.classes.push('content');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(RequestBodyContent, "primaryClass", 'request-body-content');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBodyContent);

/***/ }),

/***/ 67651:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ResponseContent extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ResponseContent.primaryClass);
    this.classes.push('content');
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ResponseContent, "primaryClass", 'response-content');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResponseContent);

/***/ }),

/***/ 99248:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ResponseHeaders extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ResponseHeaders.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ResponseHeaders, "primaryClass", 'response-headers');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResponseHeaders);

/***/ }),

/***/ 8117:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ResponseLinks extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ResponseLinks.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ResponseLinks, "primaryClass", 'response-links');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResponseLinks);

/***/ }),

/***/ 30022:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class Security extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(Security.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(Security, "primaryClass", 'security');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Security);

/***/ }),

/***/ 44734:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class ServerVariables extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ServerVariables.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(ServerVariables, "primaryClass", 'server-variables');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServerVariables);

/***/ }),

/***/ 33915:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class Servers extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(Servers.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(Servers, "primaryClass", 'servers');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Servers);

/***/ }),

/***/ 63682:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38715);


class Tags extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(Tags.primaryClass);
  }
}
(0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(Tags, "primaryClass", 'tags');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tags);

/***/ }),

/***/ 48028:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_Callback_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77807);
/* harmony import */ var _elements_Components_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94616);
/* harmony import */ var _elements_Contact_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19737);
/* harmony import */ var _elements_Discriminator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(36386);
/* harmony import */ var _elements_Encoding_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(49467);
/* harmony import */ var _elements_Example_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(48506);
/* harmony import */ var _elements_ExternalDocumentation_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(34935);
/* harmony import */ var _elements_Header_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(63563);
/* harmony import */ var _elements_Info_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(98744);
/* harmony import */ var _elements_License_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(27891);
/* harmony import */ var _elements_Link_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(73140);
/* harmony import */ var _elements_MediaType_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(94032);
/* harmony import */ var _elements_OAuthFlow_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(86281);
/* harmony import */ var _elements_OAuthFlows_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(13233);
/* harmony import */ var _elements_Openapi_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(10865);
/* harmony import */ var _elements_OpenApi3_0_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(19203);
/* harmony import */ var _elements_Operation_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(78102);
/* harmony import */ var _elements_Parameter_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(43654);
/* harmony import */ var _elements_PathItem_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(61994);
/* harmony import */ var _elements_Paths_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(74621);
/* harmony import */ var _elements_Reference_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(22096);
/* harmony import */ var _elements_RequestBody_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(96592);
/* harmony import */ var _elements_Response_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(25517);
/* harmony import */ var _elements_Responses_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(20561);
/* harmony import */ var _elements_Schema_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(99082);
/* harmony import */ var _elements_SecurityRequirement_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(8487);
/* harmony import */ var _elements_SecurityScheme_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(19021);
/* harmony import */ var _elements_Server_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(11506);
/* harmony import */ var _elements_ServerVariable_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(24979);
/* harmony import */ var _elements_Tag_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(82483);
/* harmony import */ var _elements_Xml_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(66061);






























 // eslint-disable-next-line @typescript-eslint/naming-convention
const openApi3_0 = {
  namespace: options => {
    const {
      base
    } = options;
    base.register('callback', _elements_Callback_js__WEBPACK_IMPORTED_MODULE_0__["default"]);
    base.register('components', _elements_Components_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
    base.register('contact', _elements_Contact_js__WEBPACK_IMPORTED_MODULE_2__["default"]);
    base.register('discriminator', _elements_Discriminator_js__WEBPACK_IMPORTED_MODULE_3__["default"]);
    base.register('encoding', _elements_Encoding_js__WEBPACK_IMPORTED_MODULE_4__["default"]);
    base.register('example', _elements_Example_js__WEBPACK_IMPORTED_MODULE_5__["default"]);
    base.register('externalDocumentation', _elements_ExternalDocumentation_js__WEBPACK_IMPORTED_MODULE_6__["default"]);
    base.register('header', _elements_Header_js__WEBPACK_IMPORTED_MODULE_7__["default"]);
    base.register('info', _elements_Info_js__WEBPACK_IMPORTED_MODULE_8__["default"]);
    base.register('license', _elements_License_js__WEBPACK_IMPORTED_MODULE_9__["default"]);
    base.register('link', _elements_Link_js__WEBPACK_IMPORTED_MODULE_10__["default"]);
    base.register('mediaType', _elements_MediaType_js__WEBPACK_IMPORTED_MODULE_11__["default"]);
    base.register('oAuthFlow', _elements_OAuthFlow_js__WEBPACK_IMPORTED_MODULE_12__["default"]);
    base.register('oAuthFlows', _elements_OAuthFlows_js__WEBPACK_IMPORTED_MODULE_13__["default"]);
    base.register('openapi', _elements_Openapi_js__WEBPACK_IMPORTED_MODULE_14__["default"]);
    base.register('openApi3_0', _elements_OpenApi3_0_js__WEBPACK_IMPORTED_MODULE_15__["default"]);
    base.register('operation', _elements_Operation_js__WEBPACK_IMPORTED_MODULE_16__["default"]);
    base.register('parameter', _elements_Parameter_js__WEBPACK_IMPORTED_MODULE_17__["default"]);
    base.register('pathItem', _elements_PathItem_js__WEBPACK_IMPORTED_MODULE_18__["default"]);
    base.register('paths', _elements_Paths_js__WEBPACK_IMPORTED_MODULE_19__["default"]);
    base.register('reference', _elements_Reference_js__WEBPACK_IMPORTED_MODULE_20__["default"]);
    base.register('requestBody', _elements_RequestBody_js__WEBPACK_IMPORTED_MODULE_21__["default"]);
    base.register('response', _elements_Response_js__WEBPACK_IMPORTED_MODULE_22__["default"]);
    base.register('responses', _elements_Responses_js__WEBPACK_IMPORTED_MODULE_23__["default"]);
    base.register('schema', _elements_Schema_js__WEBPACK_IMPORTED_MODULE_24__["default"]);
    base.register('securityRequirement', _elements_SecurityRequirement_js__WEBPACK_IMPORTED_MODULE_25__["default"]);
    base.register('securityScheme', _elements_SecurityScheme_js__WEBPACK_IMPORTED_MODULE_26__["default"]);
    base.register('server', _elements_Server_js__WEBPACK_IMPORTED_MODULE_27__["default"]);
    base.register('serverVariable', _elements_ServerVariable_js__WEBPACK_IMPORTED_MODULE_28__["default"]);
    base.register('tag', _elements_Tag_js__WEBPACK_IMPORTED_MODULE_29__["default"]);
    base.register('xml', _elements_Xml_js__WEBPACK_IMPORTED_MODULE_30__["default"]);
    return base;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi3_0);

/***/ }),

/***/ 40803:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isBooleanJsonSchemaElement": () => (/* binding */ isBooleanJsonSchemaElement),
/* harmony export */   "isCallbackElement": () => (/* binding */ isCallbackElement),
/* harmony export */   "isComponentsElement": () => (/* binding */ isComponentsElement),
/* harmony export */   "isContactElement": () => (/* binding */ isContactElement),
/* harmony export */   "isExampleElement": () => (/* binding */ isExampleElement),
/* harmony export */   "isExternalDocumentationElement": () => (/* binding */ isExternalDocumentationElement),
/* harmony export */   "isHeaderElement": () => (/* binding */ isHeaderElement),
/* harmony export */   "isInfoElement": () => (/* binding */ isInfoElement),
/* harmony export */   "isLicenseElement": () => (/* binding */ isLicenseElement),
/* harmony export */   "isLinkElement": () => (/* binding */ isLinkElement),
/* harmony export */   "isLinkElementExternal": () => (/* binding */ isLinkElementExternal),
/* harmony export */   "isMediaTypeElement": () => (/* binding */ isMediaTypeElement),
/* harmony export */   "isOpenApi3_0Element": () => (/* binding */ isOpenApi3_0Element),
/* harmony export */   "isOpenapiElement": () => (/* binding */ isOpenapiElement),
/* harmony export */   "isOperationElement": () => (/* binding */ isOperationElement),
/* harmony export */   "isParameterElement": () => (/* binding */ isParameterElement),
/* harmony export */   "isPathItemElement": () => (/* binding */ isPathItemElement),
/* harmony export */   "isPathItemElementExternal": () => (/* binding */ isPathItemElementExternal),
/* harmony export */   "isPathsElement": () => (/* binding */ isPathsElement),
/* harmony export */   "isReferenceElement": () => (/* binding */ isReferenceElement),
/* harmony export */   "isReferenceElementExternal": () => (/* binding */ isReferenceElementExternal),
/* harmony export */   "isRequestBodyElement": () => (/* binding */ isRequestBodyElement),
/* harmony export */   "isResponseElement": () => (/* binding */ isResponseElement),
/* harmony export */   "isResponsesElement": () => (/* binding */ isResponsesElement),
/* harmony export */   "isSchemaElement": () => (/* binding */ isSchemaElement),
/* harmony export */   "isSecurityRequirementElement": () => (/* binding */ isSecurityRequirementElement),
/* harmony export */   "isServerElement": () => (/* binding */ isServerElement),
/* harmony export */   "isServerVariableElement": () => (/* binding */ isServerVariableElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37330);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(67277);
/* harmony import */ var _elements_Callback_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(77807);
/* harmony import */ var _elements_Components_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(94616);
/* harmony import */ var _elements_Contact_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19737);
/* harmony import */ var _elements_Example_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(48506);
/* harmony import */ var _elements_ExternalDocumentation_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(34935);
/* harmony import */ var _elements_Header_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(63563);
/* harmony import */ var _elements_Info_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(98744);
/* harmony import */ var _elements_License_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(27891);
/* harmony import */ var _elements_Link_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(73140);
/* harmony import */ var _elements_Openapi_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(10865);
/* harmony import */ var _elements_OpenApi3_0_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(19203);
/* harmony import */ var _elements_Operation_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(78102);
/* harmony import */ var _elements_Parameter_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(43654);
/* harmony import */ var _elements_PathItem_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(61994);
/* harmony import */ var _elements_Paths_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(74621);
/* harmony import */ var _elements_Reference_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(22096);
/* harmony import */ var _elements_RequestBody_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(96592);
/* harmony import */ var _elements_Response_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(25517);
/* harmony import */ var _elements_Responses_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(20561);
/* harmony import */ var _elements_Schema_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(99082);
/* harmony import */ var _elements_SecurityRequirement_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(8487);
/* harmony import */ var _elements_Server_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(11506);
/* harmony import */ var _elements_ServerVariable_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(24979);
/* harmony import */ var _elements_MediaType_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(94032);

























const isCallbackElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Callback_js__WEBPACK_IMPORTED_MODULE_1__["default"] || hasBasicElementProps(element) && isElementType('callback', element) && primitiveEq('object', element);
});
const isComponentsElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Components_js__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('components', element) && primitiveEq('object', element);
});
const isContactElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Contact_js__WEBPACK_IMPORTED_MODULE_3__["default"] || hasBasicElementProps(element) && isElementType('contact', element) && primitiveEq('object', element);
});
const isExampleElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Example_js__WEBPACK_IMPORTED_MODULE_4__["default"] || hasBasicElementProps(element) && isElementType('example', element) && primitiveEq('object', element);
});
const isExternalDocumentationElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_ExternalDocumentation_js__WEBPACK_IMPORTED_MODULE_5__["default"] || hasBasicElementProps(element) && isElementType('externalDocumentation', element) && primitiveEq('object', element);
});
const isHeaderElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Header_js__WEBPACK_IMPORTED_MODULE_6__["default"] || hasBasicElementProps(element) && isElementType('header', element) && primitiveEq('object', element);
});
const isInfoElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Info_js__WEBPACK_IMPORTED_MODULE_7__["default"] || hasBasicElementProps(element) && isElementType('info', element) && primitiveEq('object', element);
});
const isLicenseElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_License_js__WEBPACK_IMPORTED_MODULE_8__["default"] || hasBasicElementProps(element) && isElementType('license', element) && primitiveEq('object', element);
});
const isLinkElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Link_js__WEBPACK_IMPORTED_MODULE_9__["default"] || hasBasicElementProps(element) && isElementType('link', element) && primitiveEq('object', element);
});
const isLinkElementExternal = element => {
  if (!isLinkElement(element)) {
    return false;
  }
  if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__.isStringElement)(element.operationRef)) {
    return false;
  }
  const value = element.operationRef.toValue();
  return typeof value === 'string' && value.length > 0 && !value.startsWith('#');
};
const isOpenapiElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Openapi_js__WEBPACK_IMPORTED_MODULE_11__["default"] || hasBasicElementProps(element) && isElementType('openapi', element) && primitiveEq('string', element);
});

// eslint-disable-next-line @typescript-eslint/naming-convention
const isOpenApi3_0Element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq,
  hasClass
}) => {
  return element => element instanceof _elements_OpenApi3_0_js__WEBPACK_IMPORTED_MODULE_12__["default"] || hasBasicElementProps(element) && isElementType('openApi3_0', element) && primitiveEq('object', element) && hasClass('api', element);
});
const isOperationElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Operation_js__WEBPACK_IMPORTED_MODULE_13__["default"] || hasBasicElementProps(element) && isElementType('operation', element) && primitiveEq('object', element);
});
const isParameterElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Parameter_js__WEBPACK_IMPORTED_MODULE_14__["default"] || hasBasicElementProps(element) && isElementType('parameter', element) && primitiveEq('object', element);
});
const isPathItemElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_PathItem_js__WEBPACK_IMPORTED_MODULE_15__["default"] || hasBasicElementProps(element) && isElementType('pathItem', element) && primitiveEq('object', element);
});
const isPathItemElementExternal = element => {
  if (!isPathItemElement(element)) {
    return false;
  }
  if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__.isStringElement)(element.$ref)) {
    return false;
  }
  const value = element.$ref.toValue();
  return typeof value === 'string' && value.length > 0 && !value.startsWith('#');
};
const isPathsElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Paths_js__WEBPACK_IMPORTED_MODULE_16__["default"] || hasBasicElementProps(element) && isElementType('paths', element) && primitiveEq('object', element);
});
const isReferenceElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Reference_js__WEBPACK_IMPORTED_MODULE_17__["default"] || hasBasicElementProps(element) && isElementType('reference', element) && primitiveEq('object', element);
});
const isReferenceElementExternal = element => {
  if (!isReferenceElement(element)) {
    return false;
  }
  if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__.isStringElement)(element.$ref)) {
    return false;
  }
  const value = element.$ref.toValue();
  return typeof value === 'string' && value.length > 0 && !value.startsWith('#');
};
const isRequestBodyElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_RequestBody_js__WEBPACK_IMPORTED_MODULE_18__["default"] || hasBasicElementProps(element) && isElementType('requestBody', element) && primitiveEq('object', element);
});
const isResponseElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Response_js__WEBPACK_IMPORTED_MODULE_19__["default"] || hasBasicElementProps(element) && isElementType('response', element) && primitiveEq('object', element);
});
const isResponsesElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Responses_js__WEBPACK_IMPORTED_MODULE_20__["default"] || hasBasicElementProps(element) && isElementType('responses', element) && primitiveEq('object', element);
});
const isSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Schema_js__WEBPACK_IMPORTED_MODULE_21__["default"] || hasBasicElementProps(element) && isElementType('schema', element) && primitiveEq('object', element);
});
const isBooleanJsonSchemaElement = element => {
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__.isBooleanElement)(element) && element.classes.includes('boolean-json-schema');
};
const isSecurityRequirementElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_SecurityRequirement_js__WEBPACK_IMPORTED_MODULE_22__["default"] || hasBasicElementProps(element) && isElementType('securityRequirement', element) && primitiveEq('object', element);
});
const isServerElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Server_js__WEBPACK_IMPORTED_MODULE_23__["default"] || hasBasicElementProps(element) && isElementType('server', element) && primitiveEq('object', element);
});
const isServerVariableElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_ServerVariable_js__WEBPACK_IMPORTED_MODULE_24__["default"] || hasBasicElementProps(element) && isElementType('serverVariable', element) && primitiveEq('object', element);
});
const isMediaTypeElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_MediaType_js__WEBPACK_IMPORTED_MODULE_25__["default"] || hasBasicElementProps(element) && isElementType('mediaType', element) && primitiveEq('object', element);
});

/***/ }),

/***/ 81063:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "createRefractor": () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44845);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(54633);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43500);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19245);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(66175);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(32240);
/* harmony import */ var _specification_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15230);
/* harmony import */ var _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(73578);
/* harmony import */ var _toolbox_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(44324);

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0,_babel_runtime_corejs3_helpers_esm_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }





const refract = (value, {
  specPath = ['visitors', 'document', 'objects', 'OpenApi', '$visitor'],
  plugins = []
} = {}) => {
  const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.refract)(value);
  const resolvedSpec = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.dereference)(_specification_js__WEBPACK_IMPORTED_MODULE_3__["default"]);

  /**
   * This is where generic ApiDOM becomes semantic (namespace applied).
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const rootVisitor = (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(specPath, [], resolvedSpec);
  // @ts-ignore
  (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.visit)(element, rootVisitor, {
    state: {
      specObj: resolvedSpec
    }
  });

  /**
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.dispatchPlugins)(rootVisitor.element, plugins, {
    toolboxCreator: _toolbox_js__WEBPACK_IMPORTED_MODULE_7__["default"],
    visitorOptions: {
      keyMap: _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_8__.keyMap,
      nodeTypeGetter: _traversal_visitor_js__WEBPACK_IMPORTED_MODULE_8__.getNodeType
    }
  });
};
const createRefractor = specPath => (value, options = {}) => refract(value, _objectSpread({
  specPath
}, options));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 21066:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isOpenApi3_0LikeElement": () => (/* binding */ isOpenApi3_0LikeElement),
/* harmony export */   "isOpenApiExtension": () => (/* binding */ isOpenApiExtension),
/* harmony export */   "isParameterLikeElement": () => (/* binding */ isParameterLikeElement),
/* harmony export */   "isReferenceLikeElement": () => (/* binding */ isReferenceLikeElement),
/* harmony export */   "isRequestBodyLikeElement": () => (/* binding */ isRequestBodyLikeElement),
/* harmony export */   "isResponseLikeElement": () => (/* binding */ isResponseLikeElement),
/* harmony export */   "isServerLikeElement": () => (/* binding */ isServerLikeElement),
/* harmony export */   "isTagLikeElement": () => (/* binding */ isTagLikeElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67277);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25546);



// eslint-disable-next-line @typescript-eslint/naming-convention
const isOpenApi3_0LikeElement = element => {
  // @ts-ignore
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(element) && element.hasKey('openapi') && element.hasKey('info');
};
const isParameterLikeElement = element => {
  // @ts-ignore
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(element) && element.hasKey('name') && element.hasKey('in');
};
const isReferenceLikeElement = element => {
  // @ts-ignore
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(element) && element.hasKey('$ref');
};
const isRequestBodyLikeElement = element => {
  // @ts-ignore
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(element) && element.hasKey('content');
};
const isResponseLikeElement = element => {
  // @ts-ignore
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(element) && element.hasKey('description');
};
const isServerLikeElement = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement;
const isTagLikeElement = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement;
const isOpenApiExtension = element => {
  // @ts-ignore
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isStringElement)(element.key) && (0,ramda__WEBPACK_IMPORTED_MODULE_0__.startsWith)('x-', element.key.toValue());
};

/***/ }),

/***/ 16120:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CallbackElement": () => (/* reexport safe */ _elements_Callback_js__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "ComponentsElement": () => (/* reexport safe */ _elements_Components_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "ContactElement": () => (/* reexport safe */ _elements_Contact_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "DiscriminatorElement": () => (/* reexport safe */ _elements_Discriminator_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "EncodingElement": () => (/* reexport safe */ _elements_Encoding_js__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "ExampleElement": () => (/* reexport safe */ _elements_Example_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "ExternalDocumentationElement": () => (/* reexport safe */ _elements_ExternalDocumentation_js__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   "HeaderElement": () => (/* reexport safe */ _elements_Header_js__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   "InfoElement": () => (/* reexport safe */ _elements_Info_js__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   "LicenseElement": () => (/* reexport safe */ _elements_License_js__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "LinkElement": () => (/* reexport safe */ _elements_Link_js__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   "MediaTypeElement": () => (/* reexport safe */ _elements_MediaType_js__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   "OAuthFlowElement": () => (/* reexport safe */ _elements_OAuthFlow_js__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   "OAuthFlowsElement": () => (/* reexport safe */ _elements_OAuthFlows_js__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   "OpenApi3_0Element": () => (/* reexport safe */ _elements_OpenApi3_0_js__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   "OpenapiElement": () => (/* reexport safe */ _elements_Openapi_js__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   "OperationElement": () => (/* reexport safe */ _elements_Operation_js__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   "ParameterElement": () => (/* reexport safe */ _elements_Parameter_js__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   "PathItemElement": () => (/* reexport safe */ _elements_PathItem_js__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   "PathsElement": () => (/* reexport safe */ _elements_Paths_js__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   "ReferenceElement": () => (/* reexport safe */ _elements_Reference_js__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   "RequestBodyElement": () => (/* reexport safe */ _elements_RequestBody_js__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   "ResponseElement": () => (/* reexport safe */ _elements_Response_js__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   "ResponsesElement": () => (/* reexport safe */ _elements_Responses_js__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   "SchemaElement": () => (/* reexport safe */ _elements_Schema_js__WEBPACK_IMPORTED_MODULE_25__["default"]),
/* harmony export */   "SecurityRequirementElement": () => (/* reexport safe */ _elements_SecurityRequirement_js__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   "SecuritySchemeElement": () => (/* reexport safe */ _elements_SecurityScheme_js__WEBPACK_IMPORTED_MODULE_27__["default"]),
/* harmony export */   "ServerElement": () => (/* reexport safe */ _elements_Server_js__WEBPACK_IMPORTED_MODULE_28__["default"]),
/* harmony export */   "ServerVariableElement": () => (/* reexport safe */ _elements_ServerVariable_js__WEBPACK_IMPORTED_MODULE_29__["default"]),
/* harmony export */   "TagElement": () => (/* reexport safe */ _elements_Tag_js__WEBPACK_IMPORTED_MODULE_30__["default"]),
/* harmony export */   "XmlElement": () => (/* reexport safe */ _elements_Xml_js__WEBPACK_IMPORTED_MODULE_31__["default"])
/* harmony export */ });
/* harmony import */ var _elements_Callback_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77807);
/* harmony import */ var _elements_Components_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(94616);
/* harmony import */ var _elements_Contact_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19737);
/* harmony import */ var _elements_Discriminator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(36386);
/* harmony import */ var _elements_Encoding_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49467);
/* harmony import */ var _elements_Example_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(48506);
/* harmony import */ var _elements_ExternalDocumentation_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(34935);
/* harmony import */ var _elements_Header_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(63563);
/* harmony import */ var _elements_Info_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(98744);
/* harmony import */ var _elements_License_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(27891);
/* harmony import */ var _elements_Link_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(73140);
/* harmony import */ var _elements_MediaType_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(94032);
/* harmony import */ var _elements_OAuthFlow_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(86281);
/* harmony import */ var _elements_OAuthFlows_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(13233);
/* harmony import */ var _elements_Openapi_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(10865);
/* harmony import */ var _elements_OpenApi3_0_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(19203);
/* harmony import */ var _elements_Operation_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(78102);
/* harmony import */ var _elements_Parameter_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(43654);
/* harmony import */ var _elements_PathItem_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(61994);
/* harmony import */ var _elements_Paths_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(74621);
/* harmony import */ var _elements_Reference_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(22096);
/* harmony import */ var _elements_RequestBody_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(96592);
/* harmony import */ var _elements_Response_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(25517);
/* harmony import */ var _elements_Responses_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(20561);
/* harmony import */ var _elements_Schema_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(99082);
/* harmony import */ var _elements_SecurityRequirement_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(8487);
/* harmony import */ var _elements_SecurityScheme_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(19021);
/* harmony import */ var _elements_Server_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(11506);
/* harmony import */ var _elements_ServerVariable_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(24979);
/* harmony import */ var _elements_Tag_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(82483);
/* harmony import */ var _elements_Xml_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(66061);
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81063);































 // register refractors specific to element types
_elements_Callback_js__WEBPACK_IMPORTED_MODULE_0__["default"].refract = (0,_index_js__WEBPACK_IMPORTED_MODULE_1__.createRe