"use strict";

exports.__esModule = true;
exports.default = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-1");
var _apidomJsonPointer = require("@swagger-api/apidom-json-pointer");
var _empty = require("@swagger-api/apidom-reference/configuration/empty");
var _openapi = require("@swagger-api/apidom-reference/dereference/strategies/openapi-3-1");
var _$anchor = require("@swagger-api/apidom-reference/dereference/strategies/openapi-3-1/selectors/$anchor");
var _uri = require("@swagger-api/apidom-reference/dereference/strategies/openapi-3-1/selectors/uri");
var _toPath = _interopRequireDefault(require("../utils/to-path.js"));
var _getRootCause = _interopRequireDefault(require("../utils/get-root-cause.js"));
var _refs = _interopRequireDefault(require("../../../../../../../specmap/lib/refs.js"));
var _index = require("../errors/index.js");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/* eslint-disable camelcase */

const {
  wrapError
} = _refs.default;
const visitAsync = _apidomCore.visit[Symbol.for('nodejs.util.promisify.custom')];
const OpenApi3_1SwaggerClientDereferenceVisitor = _openapi.OpenApi3_1DereferenceVisitor.compose({
  props: {
    useCircularStructures: true,
    allowMetaPatches: false,
    basePath: null
  },
  init({
    allowMetaPatches = this.allowMetaPatches,
    useCircularStructures = this.useCircularStructures,
    basePath = this.basePath
  }) {
    this.allowMetaPatches = allowMetaPatches;
    this.useCircularStructures = useCircularStructures;
    this.basePath = basePath;
  },
  methods: {
    async ReferenceElement(referenceElement, key, parent, path, ancestors) {
      try {
        var _this$basePath, _referenceElement$$re, _referenceElement$des, _referenceElement$sum;
        const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

        // skip already identified cycled Path Item Objects
        if ((0, _apidomCore.includesClasses)(['cycle'], referenceElement.$ref)) {
          return false;
        }

        // detect possible cycle in traversal and avoid it
        if (ancestorsLineage.some(ancs => ancs.has(referenceElement))) {
          // skip processing this schema and all it's child schemas
          return false;
        }

        // ignore resolving external Reference Objects
        if (!this.options.resolve.external && (0, _apidomNsOpenapi.isReferenceElementExternal)(referenceElement)) {
          return false;
        }
        const reference = await this.toReference(referenceElement.$ref.toValue());
        const retrievalURI = reference.uri;
        const $refBaseURI = _empty.url.resolve(retrievalURI, referenceElement.$ref.toValue());
        this.indirections.push(referenceElement);
        const jsonPointer = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);

        // possibly non-semantic fragment
        let fragment = (0, _apidomJsonPointer.evaluate)(jsonPointer, reference.value.result);

        // applying semantics to a fragment
        if ((0, _apidomCore.isPrimitiveElement)(fragment)) {
          const referencedElementType = referenceElement.meta.get('referenced-element').toValue();
          if ((0, _apidomNsOpenapi.isReferenceLikeElement)(fragment)) {
            // handling indirect references
            fragment = _apidomNsOpenapi.ReferenceElement.refract(fragment);
            fragment.setMetaProperty('referenced-element', referencedElementType);
          } else {
            // handling direct references
            const ElementClass = this.namespace.getElementClass(referencedElementType);
            fragment = ElementClass.refract(fragment);
          }
        }

        // detect direct or indirect reference
        if (this.indirections.includes(fragment)) {
          throw new Error('Recursive JSON Pointer detected');
        }

        // detect maximum depth of dereferencing
        if (this.indirections.length > this.options.dereference.maxDepth) {
          throw new _empty.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
        }

        // append referencing schema to ancestors lineage
        directAncestors.add(referenceElement);

        // dive deep into the fragment
        const visitor = OpenApi3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: (_this$basePath = this.basePath) !== null && _this$basePath !== void 0 ? _this$basePath : [...(0, _toPath.default)([...ancestors, parent, referenceElement]), '$ref']
        });
        fragment = await visitAsync(fragment, visitor, {
          keyMap: _apidomNsOpenapi.keyMap,
          nodeTypeGetter: _apidomNsOpenapi.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(referenceElement);
        this.indirections.pop();
        if (!this.useCircularStructures) {
          const hasCycles = ancestorsLineage.some(ancs => ancs.has(fragment));
          if (hasCycles) {
            if (_empty.url.isHttpUrl(retrievalURI) || _empty.url.isFileSystemPath(retrievalURI)) {
              // make the referencing URL or file system path absolute
              const cycledReferenceElement = new _apidomNsOpenapi.ReferenceElement({
                $ref: $refBaseURI
              }, referenceElement.meta.clone(), referenceElement.attributes.clone());
              cycledReferenceElement.get('$ref').classes.push('cycle');
              return cycledReferenceElement;
            }
            // skip processing this schema but traverse all it's child schemas
            return false;
          }
        }
        fragment = fragment.clone();
        fragment.setMetaProperty('ref-fields', {
          $ref: (_referenceElement$$re = referenceElement.$ref) === null || _referenceElement$$re === void 0 ? void 0 : _referenceElement$$re.toValue(),
          description: (_referenceElement$des = referenceElement.description) === null || _referenceElement$des === void 0 ? void 0 : _referenceElement$des.toValue(),
          summary: (_referenceElement$sum = referenceElement.summary) === null || _referenceElement$sum === void 0 ? void 0 : _referenceElement$sum.toValue()
        });
        // annotate fragment with info about origin
        fragment.setMetaProperty('ref-origin', reference.uri);

        // override description and summary (outer has higher priority then inner)
        const hasDescription = typeof referenceElement.description !== 'undefined';
        const hasSummary = typeof referenceElement.summary !== 'undefined';
        if (hasDescription && 'description' in fragment) {
          fragment.description = referenceElement.description;
        }
        if (hasSummary && 'summary' in fragment) {
          fragment.summary = referenceElement.summary;
        }

        // apply meta patches
        if (this.allowMetaPatches && (0, _apidomCore.isObjectElement)(fragment)) {
          const objectFragment = fragment;
          // apply meta patch only when not already applied
          if (typeof objectFragment.get('$$ref') === 'undefined') {
            const baseURI = _empty.url.resolve(retrievalURI, $refBaseURI);
            objectFragment.set('$$ref', baseURI);
          }
        }

        // transclude the element for a fragment
        return fragment;
      } catch (error) {
        var _this$basePath2, _this$options$derefer, _this$options$derefer2, _this$options$derefer3;
        const rootCause = (0, _getRootCause.default)(error);
        const wrappedError = wrapError(rootCause, {
          baseDoc: this.reference.uri,
          $ref: referenceElement.$ref.toValue(),
          pointer: (0, _apidomJsonPointer.uriToPointer)(referenceElement.$ref.toValue()),
          fullPath: (_this$basePath2 = this.basePath) !== null && _this$basePath2 !== void 0 ? _this$basePath2 : [...(0, _toPath.default)([...ancestors, parent, referenceElement]), '$ref']
        });
        (_this$options$derefer = this.options.dereference.dereferenceOpts) === null || _this$options$derefer === void 0 ? void 0 : (_this$options$derefer2 = _this$options$derefer.errors) === null || _this$options$derefer2 === void 0 ? void 0 : (_this$options$derefer3 = _this$options$derefer2.push) === null || _this$options$derefer3 === void 0 ? void 0 : _this$options$derefer3.call(_this$options$derefer2, wrappedError);
        return undefined;
      }
    },
    async PathItemElement(pathItemElement, key, parent, path, ancestors) {
      try {
        var _this$basePath3, _pathItemElement$$ref;
        const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

        // ignore PathItemElement without $ref field
        if (!(0, _apidomCore.isStringElement)(pathItemElement.$ref)) {
          return undefined;
        }

        // skip already identified cycled Path Item Objects
        if ((0, _apidomCore.includesClasses)(['cycle'], pathItemElement.$ref)) {
          return false;
        }

        // detect possible cycle in traversal and avoid it
        if (ancestorsLineage.some(ancs => ancs.has(pathItemElement))) {
          // skip processing this schema and all it's child schemas
          return false;
        }

        // ignore resolving external Path Item Elements
        if (!this.options.resolve.external && (0, _apidomNsOpenapi.isPathItemElementExternal)(pathItemElement)) {
          return undefined;
        }
        const reference = await this.toReference(pathItemElement.$ref.toValue());
        const retrievalURI = reference.uri;
        const $refBaseURI = _empty.url.resolve(retrievalURI, pathItemElement.$ref.toValue());
        this.indirections.push(pathItemElement);
        const jsonPointer = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);

        // possibly non-semantic referenced element
        let referencedElement = (0, _apidomJsonPointer.evaluate)(jsonPointer, reference.value.result);

        // applying semantics to a referenced element
        if ((0, _apidomCore.isPrimitiveElement)(referencedElement)) {
          referencedElement = _apidomNsOpenapi.PathItemElement.refract(referencedElement);
        }

        // detect direct or indirect reference
        if (this.indirections.includes(referencedElement)) {
          throw new Error('Recursive JSON Pointer detected');
        }

        // detect maximum depth of dereferencing
        if (this.indirections.length > this.options.dereference.maxDepth) {
          throw new _empty.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
        }

        // append referencing schema to ancestors lineage
        directAncestors.add(pathItemElement);

        // dive deep into the referenced element
        const visitor = OpenApi3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: (_this$basePath3 = this.basePath) !== null && _this$basePath3 !== void 0 ? _this$basePath3 : [...(0, _toPath.default)([...ancestors, parent, pathItemElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, visitor, {
          keyMap: _apidomNsOpenapi.keyMap,
          nodeTypeGetter: _apidomNsOpenapi.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(pathItemElement);
        this.indirections.pop();
        if (!this.useCircularStructures) {
          const hasCycles = ancestorsLineage.some(ancs => ancs.has(referencedElement));
          if (hasCycles) {
            if (_empty.url.isHttpUrl(retrievalURI) || _empty.url.isFileSystemPath(retrievalURI)) {
              // make the referencing URL or file system path absolute
              const cycledPathItemElement = new _apidomNsOpenapi.PathItemElement({
                $ref: $refBaseURI
              }, pathItemElement.meta.clone(), pathItemElement.attributes.clone());
              cycledPathItemElement.get('$ref').classes.push('cycle');
              return cycledPathItemElement;
            }
            // skip processing this schema but traverse all it's child schemas
            return false;
          }
        }

        // merge fields from referenced Path Item with referencing one
        const mergedPathItemElement = new _apidomNsOpenapi.PathItemElement([...referencedElement.content], referencedElement.meta.clone(), referencedElement.attributes.clone());
        // existing keywords from referencing PathItemElement overrides ones from referenced element
        pathItemElement.forEach((valueElement, keyElement, item) => {
          mergedPathItemElement.remove(keyElement.toValue());
          mergedPathItemElement.content.push(item);
        });
        mergedPathItemElement.remove('$ref');

        // annotate referenced element with info about original referencing element
        mergedPathItemElement.setMetaProperty('ref-fields', {
          $ref: (_pathItemElement$$ref = pathItemElement.$ref) === null || _pathItemElement$$ref === void 0 ? void 0 : _pathItemElement$$ref.toValue()
        });
        // annotate referenced element with info about origin
        mergedPathItemElement.setMetaProperty('ref-origin', reference.uri);

        // apply meta patches
        if (this.allowMetaPatches) {
          // apply meta patch only when not already applied
          if (typeof mergedPathItemElement.get('$$ref') === 'undefined') {
            const baseURI = _empty.url.resolve(retrievalURI, $refBaseURI);
            mergedPathItemElement.set('$$ref', baseURI);
          }
        }

        // transclude referencing element with merged referenced element
        return mergedPathItemElement;
      } catch (error) {
        var _this$basePath4, _this$options$derefer4, _this$options$derefer5, _this$options$derefer6;
        const rootCause = (0, _getRootCause.default)(error);
        const wrappedError = wrapError(rootCause, {
          baseDoc: this.reference.uri,
          $ref: pathItemElement.$ref.toValue(),
          pointer: (0, _apidomJsonPointer.uriToPointer)(pathItemElement.$ref.toValue()),
          fullPath: (_this$basePath4 = this.basePath) !== null && _this$basePath4 !== void 0 ? _this$basePath4 : [...(0, _toPath.default)([...ancestors, parent, pathItemElement]), '$ref']
        });
        (_this$options$derefer4 = this.options.dereference.dereferenceOpts) === null || _this$options$derefer4 === void 0 ? void 0 : (_this$options$derefer5 = _this$options$derefer4.errors) === null || _this$options$derefer5 === void 0 ? void 0 : (_this$options$derefer6 = _this$options$derefer5.push) === null || _this$options$derefer6 === void 0 ? void 0 : _this$options$derefer6.call(_this$options$derefer5, wrappedError);
        return undefined;
      }
    },
    async SchemaElement(referencingElement, key, parent, path, ancestors) {
      try {
        var _this$basePath5, _referencingElement$$2;
        const [ancestorsLineage, directAncestors] = this.toAncestorLineage(ancestors);

        // skip current referencing schema as $ref keyword was not defined
        if (!(0, _apidomCore.isStringElement)(referencingElement.$ref)) {
          // skip traversing this schema but traverse all it's child schemas
          return undefined;
        }

        // skip already identified cycled schemas
        if ((0, _apidomCore.includesClasses)(['cycle'], referencingElement.$ref)) {
          return false;
        }

        // detect possible cycle in traversal and avoid it
        if (ancestorsLineage.some(ancs => ancs.has(referencingElement))) {
          // skip processing this schema and all it's child schemas
          return false;
        }

        // compute baseURI using rules around $id and $ref keywords
        let {
          reference
        } = this;
        let {
          uri: retrievalURI
        } = reference;
        const $refBaseURI = (0, _openapi.resolveSchema$refField)(retrievalURI, referencingElement);
        const $refBaseURIStrippedHash = _empty.url.stripHash($refBaseURI);
        const file = (0, _empty.File)({
          uri: $refBaseURIStrippedHash
        });
        const isUnknownURI = !this.options.resolve.resolvers.some(r => r.canRead(file));
        const isURL = !isUnknownURI;
        const isExternal = isURL && retrievalURI !== $refBaseURIStrippedHash;

        // ignore resolving external Schema Objects
        if (!this.options.resolve.external && isExternal) {
          // skip traversing this schema but traverse all it's child schemas
          return undefined;
        }
        this.indirections.push(referencingElement);

        // determining reference, proper evaluation and selection mechanism
        let referencedElement;
        try {
          if (isUnknownURI || isURL) {
            // we're dealing with canonical URI or URL with possible fragment
            const selector = $refBaseURI;
            referencedElement = (0, _uri.evaluate)(selector, (0, _openapi.maybeRefractToSchemaElement)(reference.value.result));
          } else {
            // we're assuming here that we're dealing with JSON Pointer here
            reference = await this.toReference(_empty.url.unsanitize($refBaseURI));
            retrievalURI = reference.uri;
            const selector = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);
            referencedElement = (0, _openapi.maybeRefractToSchemaElement)((0, _apidomJsonPointer.evaluate)(selector, reference.value.result));
          }
        } catch (error) {
          /**
           * No SchemaElement($id=URL) was not found, so we're going to try to resolve
           * the URL and assume the returned response is a JSON Schema.
           */
          if (isURL && error instanceof _uri.EvaluationJsonSchemaUriError) {
            if ((0, _$anchor.isAnchor)((0, _$anchor.uriToAnchor)($refBaseURI))) {
              // we're dealing with JSON Schema $anchor here
              reference = await this.toReference(_empty.url.unsanitize($refBaseURI));
              retrievalURI = reference.uri;
              const selector = (0, _$anchor.uriToAnchor)($refBaseURI);
              referencedElement = (0, _$anchor.evaluate)(selector, (0, _openapi.maybeRefractToSchemaElement)(reference.value.result));
            } else {
              // we're assuming here that we're dealing with JSON Pointer here
              reference = await this.toReference(_empty.url.unsanitize($refBaseURI));
              retrievalURI = reference.uri;
              const selector = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);
              referencedElement = (0, _openapi.maybeRefractToSchemaElement)((0, _apidomJsonPointer.evaluate)(selector, reference.value.result));
            }
          } else {
            throw error;
          }
        }

        // detect direct or indirect reference
        if (this.indirections.includes(referencedElement)) {
          throw new Error('Recursive Schema Object reference detected');
        }

        // detect maximum depth of dereferencing
        if (this.indirections.length > this.options.dereference.maxDepth) {
          throw new _empty.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
        }

        // append referencing schema to ancestors lineage
        directAncestors.add(referencingElement);

        // dive deep into the fragment
        const mergeVisitor = OpenApi3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          useCircularStructures: this.useCircularStructures,
          allowMetaPatches: this.allowMetaPatches,
          ancestors: ancestorsLineage,
          basePath: (_this$basePath5 = this.basePath) !== null && _this$basePath5 !== void 0 ? _this$basePath5 : [...(0, _toPath.default)([...ancestors, parent, referencingElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, mergeVisitor, {
          keyMap: _apidomNsOpenapi.keyMap,
          nodeTypeGetter: _apidomNsOpenapi.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(referencingElement);
        this.indirections.pop();
        if ((0, _apidomNsOpenapi.isBooleanJsonSchemaElement)(referencedElement)) {
          var _referencingElement$$;
          // Boolean JSON Schema
          const jsonSchemaBooleanElement = referencedElement.clone();
          // annotate referenced element with info about original referencing element
          jsonSchemaBooleanElement.setMetaProperty('ref-fields', {
            $ref: (_referencingElement$$ = referencingElement.$ref) === null || _referencingElement$$ === void 0 ? void 0 : _referencingElement$$.toValue()
          });
          // annotate referenced element with info about origin
          jsonSchemaBooleanElement.setMetaProperty('ref-origin', retrievalURI);
          return jsonSchemaBooleanElement;
        }

        // useCircularStructures option processing
        if (!this.useCircularStructures) {
          const hasCycles = ancestorsLineage.some(ancs => ancs.has(referencedElement));
          if (hasCycles) {
            if (_empty.url.isHttpUrl(retrievalURI) || _empty.url.isFileSystemPath(retrievalURI)) {
              // make the referencing URL or file system path absolute
              const baseURI = _empty.url.resolve(retrievalURI, $refBaseURI);
              const cycledSchemaElement = new _apidomNsOpenapi.SchemaElement({
                $ref: baseURI
              }, referencingElement.meta.clone(), referencingElement.attributes.clone());
              cycledSchemaElement.get('$ref').classes.push('cycle');
              return cycledSchemaElement;
            }
            // skip processing this schema but traverse all it's child schemas
            return false;
          }
        }

        // Schema Object - merge keywords from referenced schema with referencing schema
        const mergedSchemaElement = new _apidomNsOpenapi.SchemaElement([...referencedElement.content], referencedElement.meta.clone(), referencedElement.attributes.clone());
        // existing keywords from referencing schema overrides ones from referenced schema
        referencingElement.forEach((memberValue, memberKey, member) => {
          mergedSchemaElement.remove(memberKey.toValue());
          mergedSchemaElement.content.push(member);
        });
        mergedSchemaElement.remove('$ref');

        // annotate referenced element with info about original referencing element
        mergedSchemaElement.setMetaProperty('ref-fields', {
          $ref: (_referencingElement$$2 = referencingElement.$ref) === null || _referencingElement$$2 === void 0 ? void 0 : _referencingElement$$2.toValue()
        });
        // annotate fragment with info about origin
        mergedSchemaElement.setMetaProperty('ref-origin', retrievalURI);

        // allowMetaPatches option processing
        if (this.allowMetaPatches) {
          // apply meta patch only when not already applied
          if (typeof mergedSchemaElement.get('$$ref') === 'undefined') {
            const baseURI = _empty.url.resolve(retrievalURI, $refBaseURI);
            mergedSchemaElement.set('$$ref', baseURI);
          }
        }

        // transclude referencing element with merged referenced element
        return mergedSchemaElement;
      } catch (error) {
        var _this$basePath6, _this$options$derefer7, _this$options$derefer8, _this$options$derefer9;
        const rootCause = (0, _getRootCause.default)(error);
        const wrappedError = new _index.SchemaRefError(`Could not resolve reference: ${rootCause.message}`, {
          baseDoc: this.reference.uri,
          $ref: referencingElement.$ref.toValue(),
          fullPath: (_this$basePath6 = this.basePath) !== null && _this$basePath6 !== void 0 ? _this$basePath6 : [...(0, _toPath.default)([...ancestors, parent, referencingElement]), '$ref']
        }, rootCause);
        (_this$options$derefer7 = this.options.dereference.dereferenceOpts) === null || _this$options$derefer7 === void 0 ? void 0 : (_this$options$derefer8 = _this$options$derefer7.errors) === null || _this$options$derefer8 === void 0 ? void 0 : (_this$options$derefer9 = _this$options$derefer8.push) === null || _this$options$derefer9 === void 0 ? void 0 : _this$options$derefer9.call(_this$options$derefer8, wrappedError);
        return undefined;
      }
    },
    async LinkElement() {
      /**
       * OpenApi3_1DereferenceVisitor is doing lookup of Operation Objects
       * and assigns them to Link Object metadata. This is not needed in
       * swagger-client context, so we're disabling it here.
       */
      return undefined;
    },
    async ExampleElement(exampleElement, key, parent, path, ancestors) {
      try {
        return await _openapi.OpenApi3_1DereferenceVisitor.compose.methods.ExampleElement.call(this, exampleElement, key, parent, path, ancestors);
      } catch (error) {
        var _exampleElement$exter, _this$basePath7, _this$options$derefer10, _this$options$derefer11, _this$options$derefer12;
        const rootCause = (0, _getRootCause.default)(error);
        const wrappedError = wrapError(rootCause, {
          baseDoc: this.reference.uri,
          externalValue: (_exampleElement$exter = exampleElement.externalValue) === null || _exampleElement$exter === void 0 ? void 0 : _exampleElement$exter.toValue(),
          fullPath: (_this$basePath7 = this.basePath) !== null && _this$basePath7 !== void 0 ? _this$basePath7 : [...(0, _toPath.default)([...ancestors, parent, exampleElement]), 'externalValue']
        });
        (_this$options$derefer10 = this.options.dereference.dereferenceOpts) === null || _this$options$derefer10 === void 0 ? void 0 : (_this$options$derefer11 = _this$options$derefer10.errors) === null || _this$options$derefer11 === void 0 ? void 0 : (_this$options$derefer12 = _this$options$derefer11.push) === null || _this$options$derefer12 === void 0 ? void 0 : _this$options$derefer12.call(_this$options$derefer11, wrappedError);
        return undefined;
      }
    }
  }
});
var _default = OpenApi3_1SwaggerClientDereferenceVisitor;
/* eslint-enable camelcase */
exports.default = _default;