"use strict";

exports.__esModule = true;
exports.makeResolveSubtree = exports.default = void 0;
var _get = _interopRequireDefault(require("lodash/get"));
var _index = _interopRequireDefault(require("../resolver/index.js"));
var _index2 = _interopRequireDefault(require("../resolver/strategies/generic/index.js"));
var _index3 = _interopRequireDefault(require("../resolver/strategies/openapi-2/index.js"));
var _index4 = _interopRequireDefault(require("../resolver/strategies/openapi-3-0/index.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
const resolveSubtree = async (obj, path, options = {}) => {
  const {
    returnEntireTree,
    baseDoc,
    requestInterceptor,
    responseInterceptor,
    parameterMacro,
    modelPropertyMacro,
    useCircularStructures,
    strategies
  } = options;
  const resolveOptions = {
    spec: obj,
    pathDiscriminator: path,
    baseDoc,
    requestInterceptor,
    responseInterceptor,
    parameterMacro,
    modelPropertyMacro,
    useCircularStructures,
    strategies
  };
  const strategy = strategies.find(strg => strg.match(resolveOptions));
  const normalized = strategy.normalize(resolveOptions);
  const result = await (0, _index.default)(_objectSpread(_objectSpread({}, resolveOptions), {}, {
    spec: normalized,
    allowMetaPatches: true,
    skipNormalization: true
  }));
  if (!returnEntireTree && Array.isArray(path) && path.length) {
    result.spec = (0, _get.default)(result.spec, path) || null;
  }
  return result;
};
const makeResolveSubtree = defaultOptions => async (obj, path, options = {}) => {
  const mergedOptions = _objectSpread(_objectSpread({}, defaultOptions), options);
  return resolveSubtree(obj, path, mergedOptions);
};
exports.makeResolveSubtree = makeResolveSubtree;
var _default = makeResolveSubtree({
  strategies: [_index4.default, _index3.default, _index2.default]
});
exports.default = _default;