"use strict";

exports.__esModule = true;
exports.default = opId;
var _index = _interopRequireDefault(require("./id-from-path-method/index.js"));
var _replaceSpecialCharsWithUnderscore = _interopRequireDefault(require("./replace-special-chars-with-underscore.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function opId(operation, pathName, method = '', {
  v2OperationIdCompatibilityMode
} = {}) {
  if (!operation || typeof operation !== 'object') {
    return null;
  }
  const idWithoutWhitespace = (operation.operationId || '').replace(/\s/g, '');
  if (idWithoutWhitespace.length) {
    return (0, _replaceSpecialCharsWithUnderscore.default)(operation.operationId);
  }
  return (0, _index.default)(pathName, method, {
    v2OperationIdCompatibilityMode
  });
}