"use strict";

exports.__esModule = true;
exports.default = resolveGenericStrategy;
var _index = _interopRequireWildcard(require("../../../specmap/index.js"));
var _normalize = _interopRequireDefault(require("./normalize.js"));
var _index2 = require("../../utils/index.js");
var optionsUtil = _interopRequireWildcard(require("../../utils/options.js"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
async function resolveGenericStrategy(options) {
  const {
    spec,
    mode,
    allowMetaPatches = true,
    pathDiscriminator,
    modelPropertyMacro,
    parameterMacro,
    requestInterceptor,
    responseInterceptor,
    skipNormalization,
    useCircularStructures
  } = options;
  const retrievalURI = optionsUtil.retrievalURI(options);
  const httpClient = optionsUtil.httpClient(options);
  return doResolve(spec);
  function doResolve(_spec) {
    if (retrievalURI) {
      _index.plugins.refs.docCache[retrievalURI] = _spec;
    }

    // Build a json-fetcher ( ie: give it a URL and get json out )
    _index.plugins.refs.fetchJSON = (0, _index2.makeFetchJSON)(httpClient, {
      requestInterceptor,
      responseInterceptor
    });
    const plugs = [_index.plugins.refs];
    if (typeof parameterMacro === 'function') {
      plugs.push(_index.plugins.parameters);
    }
    if (typeof modelPropertyMacro === 'function') {
      plugs.push(_index.plugins.properties);
    }
    if (mode !== 'strict') {
      plugs.push(_index.plugins.allOf);
    }

    // mapSpec is where the hard work happens
    return (0, _index.default)({
      spec: _spec,
      context: {
        baseDoc: retrievalURI
      },
      plugins: plugs,
      allowMetaPatches,
      // allows adding .meta patches, which include adding `$$ref`s to the spec
      pathDiscriminator,
      // for lazy resolution
      parameterMacro,
      modelPropertyMacro,
      useCircularStructures
      // eslint-disable-next-line camelcase
    }).then(skipNormalization ? async a => a : _normalize.default);
  }
}