import resolveOpenAPI2Strategy from './resolve.js';
import normalize from './normalize.js';
import { isOpenAPI2 } from '../../../helpers/openapi-predicates.js';
export { clearCache } from '../generic/index.js';
const openApi2Strategy = {
  name: 'openapi-2',
  match(_ref) {
    let {
      spec
    } = _ref;
    return isOpenAPI2(spec);
  },
  normalize(_ref2) {
    let {
      spec
    } = _ref2;
    const {
      spec: normalized
    } = normalize({
      spec
    });
    return normalized;
  },
  async resolve(options) {
    return resolveOpenAPI2Strategy(options);
  }
};
export default openApi2Strategy;