"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
var _interopRequireWildcard = require("@babel/runtime-corejs3/helpers/interopRequireWildcard").default;
exports.__esModule = true;
exports.cookie = cookie;
exports.header = header;
exports.path = path;
exports.query = query;
var _styleSerializer = _interopRequireWildcard(require("./style-serializer.js"));
var _contentSerializer = _interopRequireDefault(require("./content-serializer.js"));
function path(_ref) {
  let {
    req,
    value,
    parameter
  } = _ref;
  const {
    name,
    style,
    explode,
    content
  } = parameter;
  if (content) {
    const effectiveMediaType = Object.keys(content)[0];
    req.url = req.url.split(`{${name}}`).join((0, _styleSerializer.encodeDisallowedCharacters)((0, _contentSerializer.default)(value, effectiveMediaType), {
      escape: true
    }));
    return;
  }
  const styledValue = (0, _styleSerializer.default)({
    key: parameter.name,
    value,
    style: style || 'simple',
    explode: explode || false,
    escape: true
  });
  req.url = req.url.split(`{${name}}`).join(styledValue);
}
function query(_ref2) {
  let {
    req,
    value,
    parameter
  } = _ref2;
  req.query = req.query || {};
  if (parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    const serializedValue = (0, _contentSerializer.default)(value, effectiveMediaType);
    if (serializedValue) {
      req.query[parameter.name] = serializedValue;
    } else if (parameter.allowEmptyValue && value !== undefined) {
      const paramName = parameter.name;
      req.query[paramName] = req.query[paramName] || {};
      req.query[paramName].allowEmptyValue = true;
    }
    return;
  }
  if (value === false) {
    value = 'false';
  }
  if (value === 0) {
    value = '0';
  }
  if (value) {
    const {
      style,
      explode,
      allowReserved
    } = parameter;
    req.query[parameter.name] = {
      value,
      serializationOption: {
        style,
        explode,
        allowReserved
      }
    };
  } else if (parameter.allowEmptyValue && value !== undefined) {
    const paramName = parameter.name;
    req.query[paramName] = req.query[paramName] || {};
    req.query[paramName].allowEmptyValue = true;
  }
}
const PARAMETER_HEADER_BLACKLIST = ['accept', 'authorization', 'content-type'];
function header(_ref3) {
  let {
    req,
    parameter,
    value
  } = _ref3;
  req.headers = req.headers || {};
  if (PARAMETER_HEADER_BLACKLIST.indexOf(parameter.name.toLowerCase()) > -1) {
    return;
  }
  if (parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    req.headers[parameter.name] = (0, _contentSerializer.default)(value, effectiveMediaType);
    return;
  }
  if (typeof value !== 'undefined') {
    req.headers[parameter.name] = (0, _styleSerializer.default)({
      key: parameter.name,
      value,
      style: parameter.style || 'simple',
      explode: typeof parameter.explode === 'undefined' ? false : parameter.explode,
      escape: false
    });
  }
}
function cookie(_ref4) {
  let {
    req,
    parameter,
    value
  } = _ref4;
  req.headers = req.headers || {};
  const type = typeof value;
  if (parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    req.headers.Cookie = `${parameter.name}=${(0, _contentSerializer.default)(value, effectiveMediaType)}`;
    return;
  }
  if (type !== 'undefined') {
    const prefix = type === 'object' && !Array.isArray(value) && parameter.explode ? '' : `${parameter.name}=`;
    req.headers.Cookie = prefix + (0, _styleSerializer.default)({
      key: parameter.name,
      value,
      escape: false,
      style: parameter.style || 'form',
      explode: typeof parameter.explode === 'undefined' ? false : parameter.explode
    });
  }
}