"use strict";

var _interopRequireWildcard = require("@babel/runtime-corejs3/helpers/interopRequireWildcard").default;
var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
exports.__esModule = true;
exports.default = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _empty = require("@swagger-api/apidom-reference/configuration/empty");
var _openapi = _interopRequireDefault(require("@swagger-api/apidom-reference/dereference/strategies/openapi-3-1"));
var _apidomNsOpenapi = _interopRequireWildcard(require("@swagger-api/apidom-ns-openapi-3-1"));
var _dereference = _interopRequireDefault(require("./visitors/dereference.js"));
var _parameters = _interopRequireDefault(require("./visitors/parameters.js"));
var _properties = _interopRequireDefault(require("./visitors/properties.js"));
var _allOf = _interopRequireDefault(require("./visitors/all-of.js"));
/* eslint-disable camelcase */

const visitAsync = _apidomCore.visit[Symbol.for('nodejs.util.promisify.custom')];
const OpenApi3_1SwaggerClientDereferenceStrategy = _openapi.default.compose({
  props: {
    useCircularStructures: true,
    allowMetaPatches: false,
    parameterMacro: null,
    modelPropertyMacro: null,
    mode: 'non-strict',
    ancestors: null
  },
  init(_temp) {
    let {
      useCircularStructures = this.useCircularStructures,
      allowMetaPatches = this.allowMetaPatches,
      parameterMacro = this.parameterMacro,
      modelPropertyMacro = this.modelPropertyMacro,
      mode = this.mode,
      ancestors = []
    } = _temp === void 0 ? {} : _temp;
    this.name = 'openapi-3-1-swagger-client';
    this.useCircularStructures = useCircularStructures;
    this.allowMetaPatches = allowMetaPatches;
    this.parameterMacro = parameterMacro;
    this.modelPropertyMacro = modelPropertyMacro;
    this.mode = mode;
    this.ancestors = [...ancestors];
  },
  methods: {
    async dereference(file, options) {
      var _options$dereference$;
      const visitors = [];
      const namespace = (0, _apidomCore.createNamespace)(_apidomNsOpenapi.default);
      const refSet = (_options$dereference$ = options.dereference.refSet) != null ? _options$dereference$ : (0, _empty.ReferenceSet)();
      let reference;
      if (!refSet.has(file.uri)) {
        reference = (0, _empty.Reference)({
          uri: file.uri,
          value: file.parseResult
        });
        refSet.add(reference);
      } else {
        // pre-computed refSet was provided as configuration option
        reference = refSet.find(ref => ref.uri === file.uri);
      }

      // create main dereference visitor
      const dereferenceVisitor = (0, _dereference.default)({
        reference,
        namespace,
        options,
        useCircularStructures: this.useCircularStructures,
        allowMetaPatches: this.allowMetaPatches,
        ancestors: this.ancestors
      });
      visitors.push(dereferenceVisitor);

      // create parameter macro visitor (if necessary)
      if (typeof this.parameterMacro === 'function') {
        const parameterMacroVisitor = (0, _parameters.default)({
          parameterMacro: this.parameterMacro,
          options
        });
        visitors.push(parameterMacroVisitor);
      }

      // create model property macro visitor (if necessary)
      if (typeof this.modelPropertyMacro === 'function') {
        const modelPropertyMacroVisitor = (0, _properties.default)({
          modelPropertyMacro: this.modelPropertyMacro,
          options
        });
        visitors.push(modelPropertyMacroVisitor);
      }

      // create allOf visitor (if necessary)
      if (this.mode !== 'strict') {
        const allOfVisitor = (0, _allOf.default)({
          options
        });
        visitors.push(allOfVisitor);
      }

      // establish root visitor by visitor merging
      const rootVisitor = (0, _apidomCore.mergeAllVisitors)(visitors, {
        nodeTypeGetter: _apidomNsOpenapi.getNodeType
      });
      const dereferencedElement = await visitAsync(refSet.rootRef.value, rootVisitor, {
        keyMap: _apidomNsOpenapi.keyMap,
        nodeTypeGetter: _apidomNsOpenapi.getNodeType
      });

      /**
       * Release all memory if this refSet was not provided as a configuration option.
       * If provided as configuration option, then provider is responsible for cleanup.
       */
      if (options.dereference.refSet === null) {
        refSet.clean();
      }
      return dereferencedElement;
    }
  }
});
var _default = exports.default = OpenApi3_1SwaggerClientDereferenceStrategy;
/* eslint-enable camelcase */