"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
exports.__esModule = true;
exports.default = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomError = require("@swagger-api/apidom-error");
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-1");
var _apidomJsonPointer = require("@swagger-api/apidom-json-pointer");
var _empty = require("@swagger-api/apidom-reference/configuration/empty");
var _openapi = require("@swagger-api/apidom-reference/dereference/strategies/openapi-3-1");
var _$anchor = require("@swagger-api/apidom-reference/dereference/strategies/openapi-3-1/selectors/$anchor");
var _uri = require("@swagger-api/apidom-reference/dereference/strategies/openapi-3-1/selectors/uri");
var _toPath = _interopRequireDefault(require("../utils/to-path.js"));
var _getRootCause = _interopRequireDefault(require("../utils/get-root-cause.js"));
var _refs = _interopRequireDefault(require("../../../../../../../specmap/lib/refs.js"));
var _index = require("../errors/index.js");
/* eslint-disable camelcase */

const {
  wrapError
} = _refs.default;
const visitAsync = _apidomCore.visit[Symbol.for('nodejs.util.promisify.custom')];

// initialize element identity manager
const identityManager = (0, _apidomCore.IdentityManager)();

/**
 * Predicate for detecting if element was created by merging referencing
 * element with particular element identity with a referenced element.
 */
const wasReferencedBy = referencingElement => element => element.meta.hasKey('ref-referencing-element-id') && element.meta.get('ref-referencing-element-id').equals((0, _apidomCore.toValue)(identityManager.identify(referencingElement)));
const OpenApi3_1SwaggerClientDereferenceVisitor = _openapi.OpenApi3_1DereferenceVisitor.compose({
  props: {
    useCircularStructures: true,
    allowMetaPatches: false,
    basePath: null
  },
  init(_ref) {
    let {
      allowMetaPatches = this.allowMetaPatches,
      useCircularStructures = this.useCircularStructures,
      basePath = this.basePath
    } = _ref;
    this.allowMetaPatches = allowMetaPatches;
    this.useCircularStructures = useCircularStructures;
    this.basePath = basePath;
  },
  methods: {
    async ReferenceElement(referencingElement, key, parent, path, ancestors) {
      try {
        var _this$basePath;
        const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);

        // skip already identified cycled Path Item Objects
        if ((0, _apidomCore.includesClasses)(['cycle'], referencingElement.$ref)) {
          return false;
        }

        // detect possible cycle in traversal and avoid it
        if (ancestorsLineage.includesCycle(referencingElement)) {
          return false;
        }

        // ignore resolving external Reference Objects
        if (!this.options.resolve.external && (0, _apidomNsOpenapi.isReferenceElementExternal)(referencingElement)) {
          return false;
        }
        const reference = await this.toReference((0, _apidomCore.toValue)(referencingElement.$ref));
        const {
          uri: retrievalURI
        } = reference;
        const $refBaseURI = _empty.url.resolve(retrievalURI, (0, _apidomCore.toValue)(referencingElement.$ref));
        this.indirections.push(referencingElement);
        const jsonPointer = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);

        // possibly non-semantic fragment
        let referencedElement = (0, _apidomJsonPointer.evaluate)(jsonPointer, reference.value.result);

        // applying semantics to a fragment
        if ((0, _apidomCore.isPrimitiveElement)(referencedElement)) {
          const referencedElementType = (0, _apidomCore.toValue)(referencingElement.meta.get('referenced-element'));
          if ((0, _apidomNsOpenapi.isReferenceLikeElement)(referencedElement)) {
            // handling indirect references
            referencedElement = _apidomNsOpenapi.ReferenceElement.refract(referencedElement);
            referencedElement.setMetaProperty('referenced-element', referencedElementType);
          } else {
            // handling direct references
            const ElementClass = this.namespace.getElementClass(referencedElementType);
            referencedElement = ElementClass.refract(referencedElement);
          }
        }

        // detect direct or indirect reference
        if (this.indirections.includes(referencedElement)) {
          throw new _apidomError.ApiDOMError('Recursive JSON Pointer detected');
        }

        // detect maximum depth of dereferencing
        if (this.indirections.length > this.options.dereference.maxDepth) {
          throw new _empty.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
        }
        if (!this.useCircularStructures) {
          const hasCycles = ancestorsLineage.includes(referencedElement);
          if (hasCycles) {
            if (_empty.url.isHttpUrl(retrievalURI) || _empty.url.isFileSystemPath(retrievalURI)) {
              // make the referencing URL or file system path absolute
              const cycledReferenceElement = new _apidomNsOpenapi.ReferenceElement({
                $ref: $refBaseURI
              }, (0, _apidomCore.cloneDeep)(referencingElement.meta), (0, _apidomCore.cloneDeep)(referencingElement.attributes));
              cycledReferenceElement.get('$ref').classes.push('cycle');
              return cycledReferenceElement;
            }
            // skip processing this reference
            return false;
          }
        }

        // append referencing schema to ancestors lineage
        directAncestors.add(referencingElement);

        // dive deep into the fragment
        const visitor = OpenApi3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: (_this$basePath = this.basePath) != null ? _this$basePath : [...(0, _toPath.default)([...ancestors, parent, referencingElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, visitor, {
          keyMap: _apidomNsOpenapi.keyMap,
          nodeTypeGetter: _apidomNsOpenapi.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(referencingElement);
        this.indirections.pop();
        const mergeAndAnnotateReferencedElement = refedElement => {
          const copy = (0, _apidomCore.cloneShallow)(refedElement);

          // annotate fragment with info about original Reference element
          copy.setMetaProperty('ref-fields', {
            $ref: (0, _apidomCore.toValue)(referencingElement.$ref),
            description: (0, _apidomCore.toValue)(referencingElement.description),
            summary: (0, _apidomCore.toValue)(referencingElement.summary)
          });
          // annotate fragment with info about origin
          copy.setMetaProperty('ref-origin', reference.uri);
          // annotate fragment with info about referencing element
          copy.setMetaProperty('ref-referencing-element-id', (0, _apidomCore.cloneDeep)(identityManager.identify(referencingElement)));

          // override description and summary (outer has higher priority then inner)
          if ((0, _apidomCore.isObjectElement)(refedElement)) {
            if (referencingElement.hasKey('description') && 'description' in refedElement) {
              copy.remove('description');
              copy.set('description', referencingElement.get('description'));
            }
            if (referencingElement.hasKey('summary') && 'summary' in refedElement) {
              copy.remove('summary');
              copy.set('summary', referencingElement.get('summary'));
            }
          }

          // apply meta patches
          if (this.allowMetaPatches && (0, _apidomCore.isObjectElement)(copy)) {
            // apply meta patch only when not already applied
            if (!copy.hasKey('$$ref')) {
              const baseURI = _empty.url.resolve(retrievalURI, $refBaseURI);
              copy.set('$$ref', baseURI);
            }
          }
          return copy;
        };

        // attempting to create cycle
        if (ancestorsLineage.includes(referencingElement) || ancestorsLineage.includes(referencedElement)) {
          var _ancestorsLineage$fin;
          const replaceWith = (_ancestorsLineage$fin = ancestorsLineage.findItem(wasReferencedBy(referencingElement))) != null ? _ancestorsLineage$fin : mergeAndAnnotateReferencedElement(referencedElement);
          if ((0, _apidomCore.isMemberElement)(parent)) {
            parent.value = replaceWith; // eslint-disable-line no-param-reassign
          } else if (Array.isArray(parent)) {
            parent[key] = replaceWith; // eslint-disable-line no-param-reassign
          }

          return false;
        }

        // transclude the element for a fragment
        return mergeAndAnnotateReferencedElement(referencedElement);
      } catch (error) {
        var _this$basePath2, _this$options$derefer;
        const rootCause = (0, _getRootCause.default)(error);
        const wrappedError = wrapError(rootCause, {
          baseDoc: this.reference.uri,
          $ref: (0, _apidomCore.toValue)(referencingElement.$ref),
          pointer: (0, _apidomJsonPointer.uriToPointer)((0, _apidomCore.toValue)(referencingElement.$ref)),
          fullPath: (_this$basePath2 = this.basePath) != null ? _this$basePath2 : [...(0, _toPath.default)([...ancestors, parent, referencingElement]), '$ref']
        });
        (_this$options$derefer = this.options.dereference.dereferenceOpts) == null || (_this$options$derefer = _this$options$derefer.errors) == null || _this$options$derefer.push == null || _this$options$derefer.push(wrappedError);
        return undefined;
      }
    },
    async PathItemElement(pathItemElement, key, parent, path, ancestors) {
      try {
        var _this$basePath3;
        const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);

        // ignore PathItemElement without $ref field
        if (!(0, _apidomCore.isStringElement)(pathItemElement.$ref)) {
          return undefined;
        }

        // skip already identified cycled Path Item Objects
        if ((0, _apidomCore.includesClasses)(['cycle'], pathItemElement.$ref)) {
          return false;
        }

        // detect possible cycle in traversal and avoid it
        if (ancestorsLineage.includesCycle(pathItemElement)) {
          return false;
        }

        // ignore resolving external Path Item Elements
        if (!this.options.resolve.external && (0, _apidomNsOpenapi.isPathItemElementExternal)(pathItemElement)) {
          return undefined;
        }
        const reference = await this.toReference((0, _apidomCore.toValue)(pathItemElement.$ref));
        const {
          uri: retrievalURI
        } = reference;
        const $refBaseURI = _empty.url.resolve(retrievalURI, (0, _apidomCore.toValue)(pathItemElement.$ref));
        this.indirections.push(pathItemElement);
        const jsonPointer = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);

        // possibly non-semantic referenced element
        let referencedElement = (0, _apidomJsonPointer.evaluate)(jsonPointer, reference.value.result);

        // applying semantics to a referenced element
        if ((0, _apidomCore.isPrimitiveElement)(referencedElement)) {
          referencedElement = _apidomNsOpenapi.PathItemElement.refract(referencedElement);
        }

        // detect direct or indirect reference
        if (this.indirections.includes(referencedElement)) {
          throw new _apidomError.ApiDOMError('Recursive JSON Pointer detected');
        }

        // detect maximum depth of dereferencing
        if (this.indirections.length > this.options.dereference.maxDepth) {
          throw new _empty.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
        }
        if (!this.useCircularStructures) {
          const hasCycles = ancestorsLineage.includes(referencedElement);
          if (hasCycles) {
            if (_empty.url.isHttpUrl(retrievalURI) || _empty.url.isFileSystemPath(retrievalURI)) {
              // make the referencing URL or file system path absolute
              const cycledPathItemElement = new _apidomNsOpenapi.PathItemElement({
                $ref: $refBaseURI
              }, (0, _apidomCore.cloneDeep)(pathItemElement.meta), (0, _apidomCore.cloneDeep)(pathItemElement.attributes));
              cycledPathItemElement.get('$ref').classes.push('cycle');
              return cycledPathItemElement;
            }
            // skip processing this path item and all it's child elements
            return false;
          }
        }

        // append referencing schema to ancestors lineage
        directAncestors.add(pathItemElement);

        // dive deep into the referenced element
        const visitor = OpenApi3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: (_this$basePath3 = this.basePath) != null ? _this$basePath3 : [...(0, _toPath.default)([...ancestors, parent, pathItemElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, visitor, {
          keyMap: _apidomNsOpenapi.keyMap,
          nodeTypeGetter: _apidomNsOpenapi.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(pathItemElement);
        this.indirections.pop();
        const mergeAndAnnotateReferencedElement = refedElement => {
          // merge fields from referenced Path Item with referencing one
          const mergedElement = new _apidomNsOpenapi.PathItemElement([...refedElement.content], (0, _apidomCore.cloneDeep)(refedElement.meta), (0, _apidomCore.cloneDeep)(refedElement.attributes));
          // existing keywords from referencing PathItemElement overrides ones from referenced element
          pathItemElement.forEach((value, keyElement, item) => {
            mergedElement.remove((0, _apidomCore.toValue)(keyElement));
            mergedElement.content.push(item);
          });
          mergedElement.remove('$ref');

          // annotate referenced element with info about original referencing element
          mergedElement.setMetaProperty('ref-fields', {
            $ref: (0, _apidomCore.toValue)(pathItemElement.$ref)
          });
          // annotate referenced element with info about origin
          mergedElement.setMetaProperty('ref-origin', reference.uri);
          // annotate fragment with info about referencing element
          mergedElement.setMetaProperty('ref-referencing-element-id', (0, _apidomCore.cloneDeep)(identityManager.identify(pathItemElement)));

          // apply meta patches
          if (this.allowMetaPatches) {
            // apply meta patch only when not already applied
            if (typeof mergedElement.get('$$ref') === 'undefined') {
              const baseURI = _empty.url.resolve(retrievalURI, $refBaseURI);
              mergedElement.set('$$ref', baseURI);
            }
          }
          return mergedElement;
        };

        // attempting to create cycle
        if (ancestorsLineage.includes(pathItemElement) || ancestorsLineage.includes(referencedElement)) {
          var _ancestorsLineage$fin2;
          const replaceWith = (_ancestorsLineage$fin2 = ancestorsLineage.findItem(wasReferencedBy(pathItemElement))) != null ? _ancestorsLineage$fin2 : mergeAndAnnotateReferencedElement(referencedElement);
          if ((0, _apidomCore.isMemberElement)(parent)) {
            parent.value = replaceWith; // eslint-disable-line no-param-reassign
          } else if (Array.isArray(parent)) {
            parent[key] = replaceWith; // eslint-disable-line no-param-reassign
          }

          return false;
        }

        // transclude referencing element with merged referenced element
        return mergeAndAnnotateReferencedElement(referencedElement);
      } catch (error) {
        var _this$basePath4, _this$options$derefer2;
        const rootCause = (0, _getRootCause.default)(error);
        const wrappedError = wrapError(rootCause, {
          baseDoc: this.reference.uri,
          $ref: (0, _apidomCore.toValue)(pathItemElement.$ref),
          pointer: (0, _apidomJsonPointer.uriToPointer)((0, _apidomCore.toValue)(pathItemElement.$ref)),
          fullPath: (_this$basePath4 = this.basePath) != null ? _this$basePath4 : [...(0, _toPath.default)([...ancestors, parent, pathItemElement]), '$ref']
        });
        (_this$options$derefer2 = this.options.dereference.dereferenceOpts) == null || (_this$options$derefer2 = _this$options$derefer2.errors) == null || _this$options$derefer2.push == null || _this$options$derefer2.push(wrappedError);
        return undefined;
      }
    },
    async SchemaElement(referencingElement, key, parent, path, ancestors) {
      try {
        var _this$basePath5;
        const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);

        // skip current referencing schema as $ref keyword was not defined
        if (!(0, _apidomCore.isStringElement)(referencingElement.$ref)) {
          // skip traversing this schema but traverse all it's child schemas
          return undefined;
        }

        // skip already identified cycled Path Item Objects
        if ((0, _apidomCore.includesClasses)(['cycle'], referencingElement.$ref)) {
          return false;
        }

        // detect possible cycle in traversal and avoid it
        if (ancestorsLineage.includesCycle(referencingElement)) {
          return false;
        }

        // compute baseURI using rules around $id and $ref keywords
        let reference = await this.toReference(_empty.url.unsanitize(this.reference.uri));
        let {
          uri: retrievalURI
        } = reference;
        const $refBaseURI = (0, _openapi.resolveSchema$refField)(retrievalURI, referencingElement);
        const $refBaseURIStrippedHash = _empty.url.stripHash($refBaseURI);
        const file = (0, _empty.File)({
          uri: $refBaseURIStrippedHash
        });
        const isUnknownURI = !this.options.resolve.resolvers.some(r => r.canRead(file));
        const isURL = !isUnknownURI;
        const isExternal = isURL && retrievalURI !== $refBaseURIStrippedHash;

        // ignore resolving external Schema Objects
        if (!this.options.resolve.external && isExternal) {
          // skip traversing this schema but traverse all it's child schemas
          return undefined;
        }
        this.indirections.push(referencingElement);

        // determining reference, proper evaluation and selection mechanism
        let referencedElement;
        try {
          if (isUnknownURI || isURL) {
            // we're dealing with canonical URI or URL with possible fragment
            const selector = $refBaseURI;
            referencedElement = (0, _uri.evaluate)(selector, (0, _openapi.maybeRefractToSchemaElement)(reference.value.result));
          } else {
            // we're assuming here that we're dealing with JSON Pointer here
            reference = await this.toReference(_empty.url.unsanitize($refBaseURI));
            retrievalURI = reference.uri;
            const selector = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);
            referencedElement = (0, _openapi.maybeRefractToSchemaElement)((0, _apidomJsonPointer.evaluate)(selector, reference.value.result));
          }
        } catch (error) {
          /**
           * No SchemaElement($id=URL) was not found, so we're going to try to resolve
           * the URL and assume the returned response is a JSON Schema.
           */
          if (isURL && error instanceof _uri.EvaluationJsonSchemaUriError) {
            if ((0, _$anchor.isAnchor)((0, _$anchor.uriToAnchor)($refBaseURI))) {
              // we're dealing with JSON Schema $anchor here
              reference = await this.toReference(_empty.url.unsanitize($refBaseURI));
              retrievalURI = reference.uri;
              const selector = (0, _$anchor.uriToAnchor)($refBaseURI);
              referencedElement = (0, _$anchor.evaluate)(selector, (0, _openapi.maybeRefractToSchemaElement)(reference.value.result));
            } else {
              // we're assuming here that we're dealing with JSON Pointer here
              reference = await this.toReference(_empty.url.unsanitize($refBaseURI));
              retrievalURI = reference.uri;
              const selector = (0, _apidomJsonPointer.uriToPointer)($refBaseURI);
              referencedElement = (0, _openapi.maybeRefractToSchemaElement)((0, _apidomJsonPointer.evaluate)(selector, reference.value.result));
            }
          } else {
            throw error;
          }
        }

        // detect direct or indirect reference
        if (this.indirections.includes(referencedElement)) {
          throw new _apidomError.ApiDOMError('Recursive Schema Object reference detected');
        }

        // detect maximum depth of dereferencing
        if (this.indirections.length > this.options.dereference.maxDepth) {
          throw new _empty.MaximumDereferenceDepthError(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
        }

        // useCircularStructures option processing
        if (!this.useCircularStructures) {
          const hasCycles = ancestorsLineage.includes(referencedElement);
          if (hasCycles) {
            if (_empty.url.isHttpUrl(retrievalURI) || _empty.url.isFileSystemPath(retrievalURI)) {
              // make the referencing URL or file system path absolute
              const baseURI = _empty.url.resolve(retrievalURI, $refBaseURI);
              const cycledSchemaElement = new _apidomNsOpenapi.SchemaElement({
                $ref: baseURI
              }, (0, _apidomCore.cloneDeep)(referencingElement.meta), (0, _apidomCore.cloneDeep)(referencingElement.attributes));
              cycledSchemaElement.get('$ref').classes.push('cycle');
              return cycledSchemaElement;
            }
            // skip processing this schema and all it's child schemas
            return false;
          }
        }

        // append referencing schema to ancestors lineage
        directAncestors.add(referencingElement);

        // dive deep into the fragment
        const mergeVisitor = OpenApi3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          useCircularStructures: this.useCircularStructures,
          allowMetaPatches: this.allowMetaPatches,
          ancestors: ancestorsLineage,
          basePath: (_this$basePath5 = this.basePath) != null ? _this$basePath5 : [...(0, _toPath.default)([...ancestors, parent, referencingElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, mergeVisitor, {
          keyMap: _apidomNsOpenapi.keyMap,
          nodeTypeGetter: _apidomNsOpenapi.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(referencingElement);
        this.indirections.pop();
        if ((0, _apidomNsOpenapi.isBooleanJsonSchemaElement)(referencedElement)) {
          const booleanJsonSchemaElement = (0, _apidomCore.cloneDeep)(referencedElement);
          // annotate referenced element with info about original referencing element
          booleanJsonSchemaElement.setMetaProperty('ref-fields', {
            $ref: (0, _apidomCore.toValue)(referencingElement.$ref)
          });
          // annotate referenced element with info about origin
          booleanJsonSchemaElement.setMetaProperty('ref-origin', reference.uri);
          // annotate fragment with info about referencing element
          booleanJsonSchemaElement.setMetaProperty('ref-referencing-element-id', (0, _apidomCore.cloneDeep)(identityManager.identify(referencingElement)));
          return booleanJsonSchemaElement;
        }
        const mergeAndAnnotateReferencedElement = refedElement => {
          // Schema Object - merge keywords from referenced schema with referencing schema
          const mergedElement = new _apidomNsOpenapi.SchemaElement([...refedElement.content], (0, _apidomCore.cloneDeep)(refedElement.meta), (0, _apidomCore.cloneDeep)(refedElement.attributes));
          // existing keywords from referencing schema overrides ones from referenced schema
          referencingElement.forEach((value, keyElement, item) => {
            mergedElement.remove((0, _apidomCore.toValue)(keyElement));
            mergedElement.content.push(item);
          });
          mergedElement.remove('$ref');
          // annotate referenced element with info about original referencing element
          mergedElement.setMetaProperty('ref-fields', {
            $ref: (0, _apidomCore.toValue)(referencingElement.$ref)
          });
          // annotate fragment with info about origin
          mergedElement.setMetaProperty('ref-origin', reference.uri);
          // annotate fragment with info about referencing element
          mergedElement.setMetaProperty('ref-referencing-element-id', (0, _apidomCore.cloneDeep)(identityManager.identify(referencingElement)));

          // allowMetaPatches option processing
          if (this.allowMetaPatches) {
            // apply meta patch only when not already applied
            if (typeof mergedElement.get('$$ref') === 'undefined') {
              const baseURI = _empty.url.resolve(retrievalURI, $refBaseURI);
              mergedElement.set('$$ref', baseURI);
            }
          }
          return mergedElement;
        };

        // attempting to create cycle
        if (ancestorsLineage.includes(referencingElement) || ancestorsLineage.includes(referencedElement)) {
          var _ancestorsLineage$fin3;
          const replaceWith = (_ancestorsLineage$fin3 = ancestorsLineage.findItem(wasReferencedBy(referencingElement))) != null ? _ancestorsLineage$fin3 : mergeAndAnnotateReferencedElement(referencedElement);
          if ((0, _apidomCore.isMemberElement)(parent)) {
            parent.value = replaceWith; // eslint-disable-line no-param-reassign
          } else if (Array.isArray(parent)) {
            parent[key] = replaceWith; // eslint-disable-line no-param-reassign
          }

          return false;
        }

        // transclude referencing element with merged referenced element
        return mergeAndAnnotateReferencedElement(referencedElement);
      } catch (error) {
        var _this$basePath6, _this$options$derefer3;
        const rootCause = (0, _getRootCause.default)(error);
        const wrappedError = new _index.SchemaRefError(`Could not resolve reference: ${rootCause.message}`, {
          baseDoc: this.reference.uri,
          $ref: (0, _apidomCore.toValue)(referencingElement.$ref),
          fullPath: (_this$basePath6 = this.basePath) != null ? _this$basePath6 : [...(0, _toPath.default)([...ancestors, parent, referencingElement]), '$ref']
        }, rootCause);
        (_this$options$derefer3 = this.options.dereference.dereferenceOpts) == null || (_this$options$derefer3 = _this$options$derefer3.errors) == null || _this$options$derefer3.push == null || _this$options$derefer3.push(wrappedError);
        return undefined;
      }
    },
    async LinkElement() {
      /**
       * OpenApi3_1DereferenceVisitor is doing lookup of Operation Objects
       * and assigns them to Link Object metadata. This is not needed in
       * swagger-client context, so we're disabling it here.
       */
      return undefined;
    },
    async ExampleElement(exampleElement, key, parent, path, ancestors) {
      try {
        return await _openapi.OpenApi3_1DereferenceVisitor.compose.methods.ExampleElement.call(this, exampleElement, key, parent, path, ancestors);
      } catch (error) {
        var _this$basePath7, _this$options$derefer4;
        const rootCause = (0, _getRootCause.default)(error);
        const wrappedError = wrapError(rootCause, {
          baseDoc: this.reference.uri,
          externalValue: (0, _apidomCore.toValue)(exampleElement.externalValue),
          fullPath: (_this$basePath7 = this.basePath) != null ? _this$basePath7 : [...(0, _toPath.default)([...ancestors, parent, exampleElement]), 'externalValue']
        });
        (_this$options$derefer4 = this.options.dereference.dereferenceOpts) == null || (_this$options$derefer4 = _this$options$derefer4.errors) == null || _this$options$derefer4.push == null || _this$options$derefer4.push(wrappedError);
        return undefined;
      }
    }
  }
});
var _default = exports.default = OpenApi3_1SwaggerClientDereferenceVisitor;
/* eslint-enable camelcase */