"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
exports.__esModule = true;
exports.default = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _compose = _interopRequireDefault(require("../utils/compose.js"));
var _toPath = _interopRequireDefault(require("../utils/to-path.js"));
const ParameterMacroVisitor = (0, _compose.default)({
  init(_ref) {
    let {
      parameterMacro,
      options
    } = _ref;
    this.parameterMacro = parameterMacro;
    this.options = options;
  },
  props: {
    parameterMacro: null,
    options: null,
    macroOperation: null,
    OperationElement: {
      enter(operationElement) {
        this.macroOperation = operationElement;
      },
      leave() {
        this.macroOperation = null;
      }
    },
    ParameterElement: {
      leave(parameterElement, key, parent, path, ancestors) {
        const pojoOperation = this.macroOperation === null ? null : (0, _apidomCore.toValue)(this.macroOperation);
        const pojoParameter = (0, _apidomCore.toValue)(parameterElement);
        try {
          const macroValue = this.parameterMacro(pojoOperation, pojoParameter);
          parameterElement.set('default', macroValue);
        } catch (error) {
          var _this$options$derefer;
          const macroError = new Error(error, {
            cause: error
          });
          macroError.fullPath = (0, _toPath.default)([...ancestors, parent]);
          (_this$options$derefer = this.options.dereference.dereferenceOpts) == null || (_this$options$derefer = _this$options$derefer.errors) == null || _this$options$derefer.push == null || _this$options$derefer.push(macroError);
        }
      }
    }
  }
});
var _default = exports.default = ParameterMacroVisitor;