"use strict";

exports.__esModule = true;
exports.default = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _empty = require("@swagger-api/apidom-reference/configuration/empty");
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-1");
/* eslint-disable camelcase */

const OpenApiJson3_1Parser = _empty.Parser.compose({
  props: {
    name: 'openapi-json-3-1-swagger-client',
    fileExtensions: ['.json'],
    mediaTypes: new _apidomNsOpenapi.OpenAPIMediaTypes(..._apidomNsOpenapi.mediaTypes.filterByFormat('generic'), ..._apidomNsOpenapi.mediaTypes.filterByFormat('json')),
    detectionRegExp: /"openapi"\s*:\s*"(?<version_json>3\.1\.(?:[1-9]\d*|0))"/
  },
  methods: {
    async canParse(file) {
      const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
      const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
      if (!hasSupportedFileExtension) return false;
      if (hasSupportedMediaType) return true;
      if (!hasSupportedMediaType) {
        try {
          const source = file.toString();
          JSON.parse(source);
          return this.detectionRegExp.test(source);
        } catch (error) {
          return false;
        }
      }
      return false;
    },
    async parse(file) {
      if (this.sourceMap) {
        throw new _empty.ParserError("openapi-json-3-1-swagger-client parser plugin doesn't support sourceMaps option");
      }
      const parseResultElement = new _apidomCore.ParseResultElement();
      const source = file.toString();

      // allow empty files
      if (this.allowEmpty && source.trim() === '') {
        return parseResultElement;
      }
      try {
        const pojo = JSON.parse(source);
        const element = _apidomNsOpenapi.OpenApi3_1Element.refract(pojo, this.refractorOpts);
        element.classes.push('result');
        parseResultElement.push(element);
        return parseResultElement;
      } catch (error) {
        throw new _empty.ParserError(`Error parsing "${file.uri}"`, {
          cause: error
        });
      }
    }
  }
});
var _default = exports.default = OpenApiJson3_1Parser;
/* eslint-enable camelcase */