"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
exports.__esModule = true;
exports.default = void 0;
var _empty = require("@swagger-api/apidom-reference/configuration/empty");
require("../../../../../../helpers/fetch-polyfill.node.js");
require("../../../../../../helpers/abortcontroller-polyfill.node.js");
var _index = _interopRequireDefault(require("../../../../../../http/index.js"));
const HttpResolverSwaggerClient = _empty.HttpResolver.compose({
  props: {
    name: 'http-swagger-client',
    swaggerHTTPClient: _index.default,
    swaggerHTTPClientConfig: {}
  },
  init(_temp) {
    let {
      swaggerHTTPClient = this.swaggerHTTPClient
    } = _temp === void 0 ? {} : _temp;
    this.swaggerHTTPClient = swaggerHTTPClient;
  },
  methods: {
    getHttpClient() {
      return this.swaggerHTTPClient;
    },
    async read(file) {
      const client = this.getHttpClient();
      const controller = new AbortController();
      const {
        signal
      } = controller;
      const timeoutID = setTimeout(() => {
        controller.abort();
      }, this.timeout);
      const credentials = this.getHttpClient().withCredentials || this.withCredentials ? 'include' : 'same-origin';
      const redirect = this.redirects === 0 ? 'error' : 'follow';
      const follow = this.redirects > 0 ? this.redirects : undefined;
      try {
        const response = await client({
          url: file.uri,
          signal,
          userFetch: async (resource, options) => {
            let res = await fetch(resource, options);
            try {
              // undici supports mutations
              res.headers.delete('Content-Type');
            } catch {
              // Fetch API has guards which prevent mutations
              res = new Response(res.body, {
                ...res,
                headers: new Headers(res.headers)
              });
              res.headers.delete('Content-Type');
            }
            return res;
          },
          credentials,
          redirect,
          follow,
          ...this.swaggerHTTPClientConfig
        });
        return response.text.arrayBuffer();
      } catch (error) {
        throw new _empty.ResolverError(`Error downloading "${file.uri}"`, {
          cause: error
        });
      } finally {
        clearTimeout(timeoutID);
      }
    }
  }
});
var _default = exports.default = HttpResolverSwaggerClient;