"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
exports.__esModule = true;
exports.pojoAdapter = exports.default = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomNsOpenapi = require("@swagger-api/apidom-ns-openapi-3-1");
var _opId = _interopRequireDefault(require("../../../helpers/op-id.js"));
/* eslint-disable camelcase */

const normalize = element => {
  if (!(0, _apidomCore.isObjectElement)(element)) return element;
  if (element.hasKey('$$normalized')) return element;
  const plugins = [(0, _apidomNsOpenapi.refractorPluginNormalizeOperationIds)({
    operationIdNormalizer: (operationId, path, method) => (0, _opId.default)({
      operationId
    }, path, method, {
      v2OperationIdCompatibilityMode: false
    })
  }), (0, _apidomNsOpenapi.refractorPluginNormalizeParameters)(), (0, _apidomNsOpenapi.refractorPluginNormalizeSecurityRequirements)(), (0, _apidomNsOpenapi.refractorPluginNormalizeServers)(), (0, _apidomNsOpenapi.refractorPluginNormalizeParameterExamples)(), (0, _apidomNsOpenapi.refractorPluginNormalizeHeaderExamples)()];
  const normalized = (0, _apidomCore.dispatchRefractorPlugins)(element, plugins, {
    toolboxCreator: _apidomNsOpenapi.createToolbox,
    visitorOptions: {
      keyMap: _apidomNsOpenapi.keyMap,
      nodeTypeGetter: _apidomNsOpenapi.getNodeType
    }
  });
  normalized.set('$$normalized', true);
  return normalized;
};

/**
 * This adapter allow to perform normalization on Plain Old JavaScript Objects.
 * The function adapts the `normalize` function interface and is able to accept
 * Plain Old JavaScript Objects and returns Plain Old JavaScript Objects.
 */
const pojoAdapter = normalizeFn => spec => {
  if (spec != null && spec.$$normalized) return spec;
  if (pojoAdapter.cache.has(spec)) return spec;
  const openApiElement = _apidomNsOpenapi.OpenApi3_1Element.refract(spec);
  const normalized = normalizeFn(openApiElement);
  const value = (0, _apidomCore.toValue)(normalized);
  pojoAdapter.cache.set(spec, value);
  return value;
};
exports.pojoAdapter = pojoAdapter;
pojoAdapter.cache = new WeakMap();
var _default = exports.default = normalize;
/* eslint-enable camelcase */