(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["SwaggerClient"] = factory();
	else
		root["SwaggerClient"] = factory();
})(window, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 3832:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCEPT_HEADER_VALUE_FOR_DOCUMENTS: () => (/* binding */ ACCEPT_HEADER_VALUE_FOR_DOCUMENTS),
/* harmony export */   DEFAULT_BASE_URL: () => (/* binding */ DEFAULT_BASE_URL),
/* harmony export */   DEFAULT_OPENAPI_3_SERVER: () => (/* binding */ DEFAULT_OPENAPI_3_SERVER)
/* harmony export */ });
const ACCEPT_HEADER_VALUE_FOR_DOCUMENTS = 'application/json, application/yaml';
const DEFAULT_BASE_URL = 'https://swagger.io';
const DEFAULT_OPENAPI_3_SERVER = Object.freeze({
  url: '/'
});

/***/ }),

/***/ 32729:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   baseUrl: () => (/* binding */ baseUrl),
/* harmony export */   buildRequest: () => (/* binding */ buildRequest),
/* harmony export */   execute: () => (/* binding */ execute),
/* harmony export */   self: () => (/* binding */ self)
/* harmony export */ });
/* harmony import */ var cookie__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(57427);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(43628);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(24955);
/* harmony import */ var openapi_server_url_templating__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29646);
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(19500);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(83748);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3832);
/* harmony import */ var _http_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(51670);
/* harmony import */ var _http_serializers_request_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(29382);
/* harmony import */ var _swagger2_parameter_builders_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(90520);
/* harmony import */ var _oas3_parameter_builders_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(42276);
/* harmony import */ var _oas3_build_request_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(53044);
/* harmony import */ var _swagger2_build_request_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(77768);
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(47555);
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(50324);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(50918);















const arrayOrEmpty = ar => Array.isArray(ar) ? ar : [];

/**
 * `parseURIReference` function simulates the behavior of `node:url` parse function.
 * New WHATWG URL API is not capable of parsing relative references natively,
 * but can be adapter by utilizing the `base` parameter.
 */
const parseURIReference = uriReference => {
  try {
    return new URL(uriReference);
  } catch {
    const parsedURL = new URL(uriReference, _constants_js__WEBPACK_IMPORTED_MODULE_2__.DEFAULT_BASE_URL);
    const pathname = String(uriReference).startsWith('/') ? parsedURL.pathname : parsedURL.pathname.substring(1);
    return {
      hash: parsedURL.hash,
      host: '',
      hostname: '',
      href: '',
      origin: '',
      password: '',
      pathname,
      port: '',
      protocol: '',
      search: parsedURL.search,
      searchParams: parsedURL.searchParams
    };
  }
};
class OperationNotFoundError extends _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_9__["default"] {}
const findParametersWithName = (name, parameters) => parameters.filter(p => p.name === name);

// removes parameters that have duplicate 'in' and 'name' properties
const deduplicateParameters = parameters => {
  const paramsMap = {};
  parameters.forEach(p => {
    if (!paramsMap[p.in]) {
      paramsMap[p.in] = {};
    }
    paramsMap[p.in][p.name] = p;
  });
  const dedupedParameters = [];
  Object.keys(paramsMap).forEach(i => {
    Object.keys(paramsMap[i]).forEach(p => {
      dedupedParameters.push(paramsMap[i][p]);
    });
  });
  return dedupedParameters;
};

// For stubbing in tests
const self = {
  buildRequest
};

// Execute request, with the given operationId and parameters
// pathName/method or operationId is optional
function execute({
  http: userHttp,
  fetch,
  // This is legacy
  spec,
  operationId,
  pathName,
  method,
  parameters,
  securities,
  ...extras
}) {
  // Provide default fetch implementation
  const http = userHttp || fetch || _http_index_js__WEBPACK_IMPORTED_MODULE_3__["default"]; // Default to _our_ http

  if (pathName && method && !operationId) {
    operationId = (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_10__["default"])(pathName, method);
  }
  const request = self.buildRequest({
    spec,
    operationId,
    parameters,
    securities,
    http,
    ...extras
  });
  if (request.body && ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_11__["default"])(request.body) || Array.isArray(request.body))) {
    request.body = JSON.stringify(request.body);
  }

  // Build request and execute it
  return http(request);
}

// Build a request, which can be handled by the `http.js` implementation.
function buildRequest(options) {
  const {
    spec,
    operationId,
    responseContentType,
    scheme,
    requestInterceptor,
    responseInterceptor,
    contextUrl,
    userFetch,
    server,
    serverVariables,
    http,
    signal,
    serverVariableEncoder
  } = options;
  let {
    parameters,
    parameterBuilders
  } = options;
  const specIsOAS3 = (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_12__.isOpenAPI3)(spec);
  if (!parameterBuilders) {
    // user did not provide custom parameter builders
    if (specIsOAS3) {
      parameterBuilders = _oas3_parameter_builders_js__WEBPACK_IMPORTED_MODULE_6__;
    } else {
      parameterBuilders = _swagger2_parameter_builders_js__WEBPACK_IMPORTED_MODULE_5__["default"];
    }
  }

  // Set credentials with 'http.withCredentials' value
  const credentials = http && http.withCredentials ? 'include' : 'same-origin';

  // Base Template
  let req = {
    url: '',
    credentials,
    headers: {},
    cookies: {}
  };
  if (signal) {
    req.signal = signal;
  }
  if (requestInterceptor) {
    req.requestInterceptor = requestInterceptor;
  }
  if (responseInterceptor) {
    req.responseInterceptor = responseInterceptor;
  }
  if (userFetch) {
    req.userFetch = userFetch;
  }
  const operationRaw = (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_13__["default"])(spec, operationId);
  if (!operationRaw) {
    throw new OperationNotFoundError(`Operation ${operationId} not found`);
  }
  const {
    operation = {},
    method,
    pathName
  } = operationRaw;
  const baseURL = baseUrl({
    spec,
    scheme,
    contextUrl,
    server,
    serverVariables,
    pathName,
    method,
    serverVariableEncoder
  });
  req.url += baseURL;

  // Mostly for testing
  if (!operationId) {
    // Not removing req.cookies causes testing issues and would
    // change our interface, so we're always sure to remove it.
    // See the same statement lower down in this function for
    // more context.
    delete req.cookies;
    return req;
  }
  req.url += pathName; // Have not yet replaced the path parameters
  req.method = `${method}`.toUpperCase();
  parameters = parameters || {};
  const path = spec.paths[pathName] || {};
  if (responseContentType) {
    req.headers.accept = responseContentType;
  }
  const combinedParameters = deduplicateParameters([].concat(arrayOrEmpty(operation.parameters)) // operation parameters
  .concat(arrayOrEmpty(path.parameters))); // path parameters

  // REVIEW: OAS3: have any key names or parameter shapes changed?
  // Any new features that need to be plugged in here?

  // Add values to request
  combinedParameters.forEach(parameter => {
    const builder = parameterBuilders[parameter.in];
    let value;
    if (parameter.in === 'body' && parameter.schema && parameter.schema.properties) {
      value = parameters;
    }
    value = parameter && parameter.name && parameters[parameter.name];
    if (typeof value === 'undefined') {
      // check for `name-in` formatted key
      value = parameter && parameter.name && parameters[`${parameter.in}.${parameter.name}`];
    } else if (findParametersWithName(parameter.name, combinedParameters).length > 1) {
      // value came from `parameters[parameter.name]`
      // check to see if this is an ambiguous parameter
      // eslint-disable-next-line no-console
      console.warn(`Parameter '${parameter.name}' is ambiguous because the defined spec has more than one parameter with the name: '${parameter.name}' and the passed-in parameter values did not define an 'in' value.`);
    }
    if (value === null) {
      return;
    }
    if (typeof parameter.default !== 'undefined' && typeof value === 'undefined') {
      value = parameter.default;
    }
    if (typeof value === 'undefined' && parameter.required && !parameter.allowEmptyValue) {
      throw new Error(`Required parameter ${parameter.name} is not provided`);
    }
    if (specIsOAS3 && parameter.schema && parameter.schema.type === 'object' && typeof value === 'string') {
      try {
        value = JSON.parse(value);
      } catch (e) {
        throw new Error('Could not parse object parameter value string as JSON');
      }
    }
    if (builder) {
      builder({
        req,
        parameter,
        value,
        operation,
        spec,
        baseURL
      });
    }
  });

  // Do version-specific tasks, then return those results.
  const versionSpecificOptions = {
    ...options,
    operation
  };
  if (specIsOAS3) {
    req = (0,_oas3_build_request_js__WEBPACK_IMPORTED_MODULE_7__["default"])(versionSpecificOptions, req);
  } else {
    // If not OAS3, then treat as Swagger2.
    req = (0,_swagger2_build_request_js__WEBPACK_IMPORTED_MODULE_8__["default"])(versionSpecificOptions, req);
  }

  // If the cookie convenience object exists in our request,
  // serialize its content and then delete the cookie object.
  if (req.cookies && Object.keys(req.cookies).length) {
    const cookieString = Object.keys(req.cookies).reduce((prev, cookieName) => {
      const cookieValue = req.cookies[cookieName];
      const prefix = prev ? '&' : '';
      const stringified = cookie__WEBPACK_IMPORTED_MODULE_0__.serialize(cookieName, cookieValue);
      return prev + prefix + stringified;
    }, '');
    req.headers.Cookie = cookieString;
  }
  if (req.cookies) {
    // even if no cookies were defined, we need to remove
    // the cookies key from our request, or many legacy
    // tests will break.
    delete req.cookies;
  }

  // Will add the query object into the URL, if it exists
  // ... will also create a FormData instance, if multipart/form-data (eg: a file)
  return (0,_http_serializers_request_index_js__WEBPACK_IMPORTED_MODULE_4__.serializeRequest)(req);
}
const stripNonAlpha = str => str ? str.replace(/\W/g, '') : null;

// be careful when modifying this! it is a publicly-exposed method.
function baseUrl(obj) {
  const specIsOAS3 = (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_12__.isOpenAPI3)(obj.spec);
  return specIsOAS3 ? oas3BaseUrl(obj) : swagger2BaseUrl(obj);
}
const isNonEmptyServerList = value => Array.isArray(value) && value.length > 0;
function oas3BaseUrl({
  spec,
  pathName,
  method,
  server,
  contextUrl,
  serverVariables = {},
  serverVariableEncoder
}) {
  let servers = [];
  let selectedServerUrl = '';
  let selectedServerObj;

  // compute the servers (this will be taken care of by ApiDOM refrator plugins in future
  const operationLevelServers = spec?.paths?.[pathName]?.[(method || '').toLowerCase()]?.servers;
  const pathItemLevelServers = spec?.paths?.[pathName]?.servers;
  const rootLevelServers = spec?.servers;
  servers = isNonEmptyServerList(operationLevelServers) // eslint-disable-line no-nested-ternary
  ? operationLevelServers : isNonEmptyServerList(pathItemLevelServers) // eslint-disable-line no-nested-ternary
  ? pathItemLevelServers : isNonEmptyServerList(rootLevelServers) ? rootLevelServers : [_constants_js__WEBPACK_IMPORTED_MODULE_2__.DEFAULT_OPENAPI_3_SERVER];

  // pick the first server that matches the server url
  if (server) {
    selectedServerObj = servers.find(srv => srv.url === server);
    if (selectedServerObj) selectedServerUrl = server;
  }

  // default to the first server if we don't have one by now
  if (!selectedServerUrl) {
    [selectedServerObj] = servers;
    selectedServerUrl = selectedServerObj.url;
  }
  if ((0,openapi_server_url_templating__WEBPACK_IMPORTED_MODULE_1__.test)(selectedServerUrl, {
    strict: true
  })) {
    const selectedServerVariables = Object.entries({
      ...selectedServerObj.variables
    }).reduce((acc, [serverVariableName, serverVariable]) => {
      acc[serverVariableName] = serverVariable.default;
      return acc;
    }, {});
    selectedServerUrl = (0,openapi_server_url_templating__WEBPACK_IMPORTED_MODULE_1__.substitute)(selectedServerUrl, {
      ...selectedServerVariables,
      ...serverVariables
    }, {
      encoder: typeof serverVariableEncoder === 'function' ? serverVariableEncoder : ramda__WEBPACK_IMPORTED_MODULE_14__["default"]
    });
  }
  return buildOas3UrlWithContext(selectedServerUrl, contextUrl);
}
function buildOas3UrlWithContext(ourUrl = '', contextUrl = '') {
  // relative server url should be resolved against contextUrl
  const parsedUrl = ourUrl && contextUrl ? parseURIReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_15__.resolve(contextUrl, ourUrl)) : parseURIReference(ourUrl);
  const parsedContextUrl = parseURIReference(contextUrl);
  const computedScheme = stripNonAlpha(parsedUrl.protocol) || stripNonAlpha(parsedContextUrl.protocol);
  const computedHost = parsedUrl.host || parsedContextUrl.host;
  const computedPath = parsedUrl.pathname;
  let res;
  if (computedScheme && computedHost) {
    res = `${computedScheme}://${computedHost + computedPath}`;

    // if last character is '/', trim it off
  } else {
    res = computedPath;
  }
  return res[res.length - 1] === '/' ? res.slice(0, -1) : res;
}

// Compose the baseUrl ( scheme + host + basePath )
function swagger2BaseUrl({
  spec,
  scheme,
  contextUrl = ''
}) {
  const parsedContextUrl = parseURIReference(contextUrl);
  const firstSchemeInSpec = Array.isArray(spec.schemes) ? spec.schemes[0] : null;
  const computedScheme = scheme || firstSchemeInSpec || stripNonAlpha(parsedContextUrl.protocol) || 'http';
  const computedHost = spec.host || parsedContextUrl.host || '';
  const computedPath = spec.basePath || '';
  let res;
  if (computedScheme && computedHost) {
    // we have what we need for an absolute URL
    res = `${computedScheme}://${computedHost + computedPath}`;
  } else {
    // if not, a relative URL will have to do
    res = computedPath;
  }

  // If last character is '/', trim it off
  return res[res.length - 1] === '/' ? res.slice(0, -1) : res;
}

/***/ }),

/***/ 53044:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applySecurities: () => (/* binding */ applySecurities),
/* harmony export */   "default": () => (/* binding */ buildRequest)
/* harmony export */ });
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24955);
/* harmony import */ var _helpers_btoa_node_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39687);
// This function runs after the common function,
// `src/execute/index.js#buildRequest`


function buildRequest(options, req) {
  const {
    operation,
    requestBody,
    securities,
    spec,
    attachContentTypeForEmptyPayload
  } = options;
  let {
    requestContentType
  } = options;
  req = applySecurities({
    request: req,
    securities,
    operation,
    spec
  });
  const requestBodyDef = operation.requestBody || {};
  const requestBodyMediaTypes = Object.keys(requestBodyDef.content || {});
  const isExplicitContentTypeValid = requestContentType && requestBodyMediaTypes.indexOf(requestContentType) > -1;

  // for OAS3: set the Content-Type
  if (requestBody || attachContentTypeForEmptyPayload) {
    // does the passed requestContentType appear in the requestBody definition?

    if (requestContentType && isExplicitContentTypeValid) {
      req.headers['Content-Type'] = requestContentType;
    } else if (!requestContentType) {
      const firstMediaType = requestBodyMediaTypes[0];
      if (firstMediaType) {
        req.headers['Content-Type'] = firstMediaType;
        requestContentType = firstMediaType;
      }
    }
  } else if (requestContentType && isExplicitContentTypeValid) {
    req.headers['Content-Type'] = requestContentType;
  }
  if (!options.responseContentType && operation.responses) {
    const mediaTypes = Object.entries(operation.responses).filter(([key, value]) => {
      const code = parseInt(key, 10);
      return code >= 200 && code < 300 && (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"])(value.content);
    }).reduce((acc, [, value]) => acc.concat(Object.keys(value.content)), []);
    if (mediaTypes.length > 0) {
      req.headers.accept = mediaTypes.join(', ');
    }
  }

  // for OAS3: add requestBody to request
  if (requestBody) {
    if (requestContentType) {
      if (requestBodyMediaTypes.indexOf(requestContentType) > -1) {
        // only attach body if the requestBody has a definition for the
        // contentType that has been explicitly set
        if (requestContentType === 'application/x-www-form-urlencoded' || requestContentType === 'multipart/form-data') {
          if (typeof requestBody === 'object') {
            const encoding = requestBodyDef.content[requestContentType]?.encoding ?? {};
            req.form = {};
            Object.keys(requestBody).forEach(k => {
              let value;
              try {
                value = JSON.parse(requestBody[k]);
              } catch {
                value = requestBody[k];
              }
              req.form[k] = {
                value,
                encoding: encoding[k] || {}
              };
            });
          } else if (typeof requestBody === 'string') {
            const encoding = requestBodyDef.content[requestContentType]?.encoding ?? {};
            try {
              req.form = {};
              const form = JSON.parse(requestBody);
              Object.entries(form).forEach(([key, value]) => {
                req.form[key] = {
                  value,
                  encoding: encoding[key] || {}
                };
              });
            } catch {
              req.form = requestBody;
            }
          } else {
            req.form = requestBody;
          }
        } else {
          req.body = requestBody;
        }
      }
    } else {
      req.body = requestBody;
    }
  }
  return req;
}

// Add security values, to operations - that declare their need on them
// Adapted from the Swagger2 implementation
function applySecurities({
  request,
  securities = {},
  operation = {},
  spec
}) {
  const result = {
    ...request
  };
  const {
    authorized = {}
  } = securities;
  const security = operation.security || spec.security || [];
  const isAuthorized = authorized && !!Object.keys(authorized).length;
  const securityDef = spec?.components?.securitySchemes || {};
  result.headers = result.headers || {};
  result.query = result.query || {};
  if (!Object.keys(securities).length || !isAuthorized || !security || Array.isArray(operation.security) && !operation.security.length) {
    return request;
  }
  security.forEach(securityObj => {
    Object.keys(securityObj).forEach(key => {
      const auth = authorized[key];
      const schema = securityDef[key];
      if (!auth) {
        return;
      }
      const value = auth.value || auth;
      const {
        type
      } = schema;
      if (auth) {
        if (type === 'apiKey') {
          if (schema.in === 'query') {
            result.query[schema.name] = value;
          }
          if (schema.in === 'header') {
            result.headers[schema.name] = value;
          }
          if (schema.in === 'cookie') {
            result.cookies[schema.name] = value;
          }
        } else if (type === 'http') {
          if (/^basic$/i.test(schema.scheme)) {
            const username = value.username || '';
            const password = value.password || '';
            const encoded = (0,_helpers_btoa_node_js__WEBPACK_IMPORTED_MODULE_0__["default"])(`${username}:${password}`);
            result.headers.Authorization = `Basic ${encoded}`;
          }
          if (/^bearer$/i.test(schema.scheme)) {
            result.headers.Authorization = `Bearer ${value}`;
          }
        } else if (type === 'oauth2' || type === 'openIdConnect') {
          const token = auth.token || {};
          const tokenName = schema['x-tokenName'] || 'access_token';
          const tokenValue = token[tokenName];
          let tokenType = token.token_type;
          if (!tokenType || tokenType.toLowerCase() === 'bearer') {
            tokenType = 'Bearer';
          }
          result.headers.Authorization = `${tokenType} ${tokenValue}`;
        }
      }
    });
  });
  return result;
}

/***/ }),

/***/ 27986:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ serialize)
/* harmony export */ });
/*
  Serializer that serializes according to a media type instead of OpenAPI's
  `style` + `explode` constructs.
*/

function serialize(value, mediaType) {
  if (mediaType.includes('application/json')) {
    if (typeof value === 'string') {
      // Assume the user has a JSON string
      return value;
    }
    if (Array.isArray(value)) {
      value = value.map(v => {
        try {
          return JSON.parse(v);
        } catch (e) {
          return v;
        }
      });
    }
    return JSON.stringify(value);
  }
  return String(value);
}

/***/ }),

/***/ 42276:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cookie: () => (/* binding */ cookie),
/* harmony export */   header: () => (/* binding */ header),
/* harmony export */   path: () => (/* binding */ path),
/* harmony export */   query: () => (/* binding */ query)
/* harmony export */ });
/* harmony import */ var openapi_path_templating__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61546);
/* harmony import */ var _style_serializer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33838);
/* harmony import */ var _content_serializer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27986);



function path({
  req,
  value,
  parameter,
  baseURL
}) {
  const {
    name,
    style,
    explode,
    content
  } = parameter;
  if (value === undefined) return;
  const pathname = req.url.replace(baseURL, '');
  let resolvedPathname;
  if (content) {
    const effectiveMediaType = Object.keys(content)[0];
    resolvedPathname = (0,openapi_path_templating__WEBPACK_IMPORTED_MODULE_0__.resolve)(pathname, {
      [name]: value
    }, {
      encoder: val => (0,_style_serializer_js__WEBPACK_IMPORTED_MODULE_1__.encodeCharacters)((0,_content_serializer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(val, effectiveMediaType))
    });
  } else {
    resolvedPathname = (0,openapi_path_templating__WEBPACK_IMPORTED_MODULE_0__.resolve)(pathname, {
      [name]: value
    }, {
      encoder: val => (0,_style_serializer_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
        key: parameter.name,
        value: val,
        style: style || 'simple',
        explode: explode || false,
        escape: 'reserved'
      })
    });
  }
  req.url = baseURL + resolvedPathname;
}
function query({
  req,
  value,
  parameter
}) {
  req.query = req.query || {};
  if (value !== undefined && parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    const serializedValue = (0,_content_serializer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value, effectiveMediaType);
    if (serializedValue) {
      req.query[parameter.name] = serializedValue;
    } else if (parameter.allowEmptyValue) {
      const paramName = parameter.name;
      req.query[paramName] = req.query[paramName] || {};
      req.query[paramName].allowEmptyValue = true;
    }
    return;
  }
  if (value === false) {
    value = 'false';
  }
  if (value === 0) {
    value = '0';
  }
  if (value) {
    const {
      style,
      explode,
      allowReserved
    } = parameter;
    req.query[parameter.name] = {
      value,
      serializationOption: {
        style,
        explode,
        allowReserved
      }
    };
  } else if (parameter.allowEmptyValue && value !== undefined) {
    const paramName = parameter.name;
    req.query[paramName] = req.query[paramName] || {};
    req.query[paramName].allowEmptyValue = true;
  }
}
const PARAMETER_HEADER_BLACKLIST = ['accept', 'authorization', 'content-type'];
function header({
  req,
  parameter,
  value
}) {
  req.headers = req.headers || {};
  if (PARAMETER_HEADER_BLACKLIST.indexOf(parameter.name.toLowerCase()) > -1) {
    return;
  }
  if (value !== undefined && parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    req.headers[parameter.name] = (0,_content_serializer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value, effectiveMediaType);
    return;
  }
  if (value !== undefined && !(Array.isArray(value) && value.length === 0)) {
    req.headers[parameter.name] = (0,_style_serializer_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
      key: parameter.name,
      value,
      style: parameter.style || 'simple',
      explode: typeof parameter.explode === 'undefined' ? false : parameter.explode,
      escape: false
    });
  }
}
function cookie({
  req,
  parameter,
  value
}) {
  req.headers = req.headers || {};
  const type = typeof value;
  if (value !== undefined && parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    req.headers.Cookie = `${parameter.name}=${(0,_content_serializer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value, effectiveMediaType)}`;
    return;
  }
  if (value !== undefined && !(Array.isArray(value) && value.length === 0)) {
    const prefix = type === 'object' && !Array.isArray(value) && parameter.explode ? '' : `${parameter.name}=`;
    req.headers.Cookie = prefix + (0,_style_serializer_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
      key: parameter.name,
      value,
      escape: false,
      style: parameter.style || 'form',
      explode: typeof parameter.explode === 'undefined' ? false : parameter.explode
    });
  }
}

/***/ }),

/***/ 33838:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ stylize),
/* harmony export */   encodeCharacters: () => (/* binding */ encodeCharacters),
/* harmony export */   valueEncoder: () => (/* binding */ valueEncoder)
/* harmony export */ });
const isRfc3986Reserved = char => ":/?#[]@!$&'()*+,;=".indexOf(char) > -1;
const isRfc3986Unreserved = char => /^[a-z0-9\-._~]+$/i.test(char);

// eslint-disable-next-line default-param-last
function encodeCharacters(str, characterSet = 'reserved') {
  // In ES6 you can do this quite easily by using the new ... spread operator.
  // This causes the string iterator (another new ES6 feature) to be used internally,
  // and because that iterator is designed to deal with
  // code points rather than UCS-2/UTF-16 code units.
  return [...str].map(char => {
    if (isRfc3986Unreserved(char)) {
      return char;
    }
    if (isRfc3986Reserved(char) && characterSet === 'unsafe') {
      return char;
    }
    const encoder = new TextEncoder();
    const encoded = Array.from(encoder.encode(char)).map(byte => `0${byte.toString(16).toUpperCase()}`.slice(-2)).map(encodedByte => `%${encodedByte}`).join('');
    return encoded;
  }).join('');
}
function stylize(config) {
  const {
    value
  } = config;
  if (Array.isArray(value)) {
    return encodeArray(config);
  }
  if (typeof value === 'object') {
    return encodeObject(config);
  }
  return encodePrimitive(config);
}
function valueEncoder(value, escape = false) {
  if (Array.isArray(value) || value !== null && typeof value === 'object') {
    value = JSON.stringify(value);
  } else if (typeof value === 'number' || typeof value === 'boolean') {
    value = String(value);
  }
  if (escape && value.length > 0) {
    return encodeCharacters(value, escape);
  }
  return value;
}
function encodeArray({
  key,
  value,
  style,
  explode,
  escape
}) {
  if (style === 'simple') {
    return value.map(val => valueEncoder(val, escape)).join(',');
  }
  if (style === 'label') {
    return `.${value.map(val => valueEncoder(val, escape)).join('.')}`;
  }
  if (style === 'matrix') {
    return value.map(val => valueEncoder(val, escape)).reduce((prev, curr) => {
      if (!prev || explode) {
        return `${prev || ''};${key}=${curr}`;
      }
      return `${prev},${curr}`;
    }, '');
  }
  if (style === 'form') {
    const after = explode ? `&${key}=` : ',';
    return value.map(val => valueEncoder(val, escape)).join(after);
  }
  if (style === 'spaceDelimited') {
    const after = explode ? `${key}=` : '';
    return value.map(val => valueEncoder(val, escape)).join(` ${after}`);
  }
  if (style === 'pipeDelimited') {
    const after = explode ? `${key}=` : '';
    return value.map(val => valueEncoder(val, escape)).join(`|${after}`);
  }
  return undefined;
}
function encodeObject({
  key,
  value,
  style,
  explode,
  escape
}) {
  const valueKeys = Object.keys(value);
  if (style === 'simple') {
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr], escape);
      const middleChar = explode ? '=' : ',';
      const prefix = prev ? `${prev},` : '';
      return `${prefix}${curr}${middleChar}${val}`;
    }, '');
  }
  if (style === 'label') {
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr], escape);
      const middleChar = explode ? '=' : '.';
      const prefix = prev ? `${prev}.` : '.';
      return `${prefix}${curr}${middleChar}${val}`;
    }, '');
  }
  if (style === 'matrix' && explode) {
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr], escape);
      const prefix = prev ? `${prev};` : ';';
      return `${prefix}${curr}=${val}`;
    }, '');
  }
  if (style === 'matrix') {
    // no explode
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr], escape);
      const prefix = prev ? `${prev},` : `;${key}=`;
      return `${prefix}${curr},${val}`;
    }, '');
  }
  if (style === 'form') {
    return valueKeys.reduce((prev, curr) => {
      const val = valueEncoder(value[curr], escape);
      const prefix = prev ? `${prev}${explode ? '&' : ','}` : '';
      const separator = explode ? '=' : ',';
      return `${prefix}${curr}${separator}${val}`;
    }, '');
  }
  return undefined;
}
function encodePrimitive({
  key,
  value,
  style,
  escape
}) {
  if (style === 'simple') {
    return valueEncoder(value, escape);
  }
  if (style === 'label') {
    return `.${valueEncoder(value, escape)}`;
  }
  if (style === 'matrix') {
    return `;${key}=${valueEncoder(value, escape)}`;
  }
  if (style === 'form') {
    return valueEncoder(value, escape);
  }
  if (style === 'deepObject') {
    return valueEncoder(value, escape);
  }
  return undefined;
}

/***/ }),

/***/ 77768:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applySecurities: () => (/* binding */ applySecurities),
/* harmony export */   "default": () => (/* binding */ buildRequest)
/* harmony export */ });
/* harmony import */ var _helpers_btoa_node_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39687);


// This function runs after the common function,
// `src/execute/index.js#buildRequest`
function buildRequest(options, req) {
  const {
    spec,
    operation,
    securities,
    requestContentType,
    responseContentType,
    attachContentTypeForEmptyPayload
  } = options;
  // Add securities, which are applicable
  req = applySecurities({
    request: req,
    securities,
    operation,
    spec
  });
  if (req.body || req.form || attachContentTypeForEmptyPayload) {
    // all following conditionals are Swagger2 only
    if (requestContentType) {
      req.headers['Content-Type'] = requestContentType;
    } else if (Array.isArray(operation.consumes)) {
      [req.headers['Content-Type']] = operation.consumes;
    } else if (Array.isArray(spec.consumes)) {
      [req.headers['Content-Type']] = spec.consumes;
    } else if (operation.parameters && operation.parameters.filter(p => p.type === 'file').length) {
      req.headers['Content-Type'] = 'multipart/form-data';
    } else if (operation.parameters && operation.parameters.filter(p => p.in === 'formData').length) {
      req.headers['Content-Type'] = 'application/x-www-form-urlencoded';
    }
  } else if (requestContentType) {
    const isBodyParamPresent = operation.parameters && operation.parameters.filter(p => p.in === 'body').length > 0;
    const isFormDataParamPresent = operation.parameters && operation.parameters.filter(p => p.in === 'formData').length > 0;
    if (isBodyParamPresent || isFormDataParamPresent) {
      req.headers['Content-Type'] = requestContentType;
    }
  }
  if (!responseContentType && Array.isArray(operation.produces) && operation.produces.length > 0) {
    req.headers.accept = operation.produces.join(', ');
  }
  return req;
}

// Add security values, to operations - that declare their need on them
function applySecurities({
  request,
  securities = {},
  operation = {},
  spec
}) {
  const result = {
    ...request
  };
  const {
    authorized = {},
    specSecurity = []
  } = securities;
  const security = operation.security || specSecurity;
  const isAuthorized = authorized && !!Object.keys(authorized).length;
  const securityDef = spec.securityDefinitions;
  result.headers = result.headers || {};
  result.query = result.query || {};
  if (!Object.keys(securities).length || !isAuthorized || !security || Array.isArray(operation.security) && !operation.security.length) {
    return request;
  }
  security.forEach(securityObj => {
    Object.keys(securityObj).forEach(key => {
      const auth = authorized[key];
      if (!auth) {
        return;
      }
      const {
        token
      } = auth;
      const value = auth.value || auth;
      const schema = securityDef[key];
      const {
        type
      } = schema;
      const tokenName = schema['x-tokenName'] || 'access_token';
      const oauthToken = token && token[tokenName];
      let tokenType = token && token.token_type;
      if (auth) {
        if (type === 'apiKey') {
          const inType = schema.in === 'query' ? 'query' : 'headers';
          result[inType] = result[inType] || {};
          result[inType][schema.name] = value;
        } else if (type === 'basic') {
          if (value.header) {
            result.headers.authorization = value.header;
          } else {
            const username = value.username || '';
            const password = value.password || '';
            value.base64 = (0,_helpers_btoa_node_js__WEBPACK_IMPORTED_MODULE_0__["default"])(`${username}:${password}`);
            result.headers.authorization = `Basic ${value.base64}`;
          }
        } else if (type === 'oauth2' && oauthToken) {
          tokenType = !tokenType || tokenType.toLowerCase() === 'bearer' ? 'Bearer' : tokenType;
          result.headers.authorization = `${tokenType} ${oauthToken}`;
        }
      }
    });
  });
  return result;
}

/***/ }),

/***/ 90520:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var openapi_path_templating__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61546);


// These functions will update the request.
// They'll be given {req, value, paramter, spec, operation}.

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  body: bodyBuilder,
  header: headerBuilder,
  query: queryBuilder,
  path: pathBuilder,
  formData: formDataBuilder
});

// Add the body to the request
function bodyBuilder({
  req,
  value
}) {
  if (value !== undefined) {
    req.body = value;
  }
}

// Add a form data object.
function formDataBuilder({
  req,
  value,
  parameter
}) {
  if (value === false && parameter.type === 'boolean') {
    value = 'false';
  }
  if (value === 0 && ['number', 'integer'].indexOf(parameter.type) > -1) {
    value = '0';
  }
  if (value) {
    req.form = req.form || {};
    req.form[parameter.name] = {
      collectionFormat: parameter.collectionFormat,
      value
    };
  } else if (parameter.allowEmptyValue && value !== undefined) {
    req.form = req.form || {};
    const paramName = parameter.name;
    req.form[paramName] = req.form[paramName] || {};
    req.form[paramName].allowEmptyValue = true;
  }
}

// Add a header to the request
function headerBuilder({
  req,
  parameter,
  value
}) {
  req.headers = req.headers || {};
  if (typeof value !== 'undefined') {
    req.headers[parameter.name] = value;
  }
}

// Replace path paramters, with values ( ie: the URL )
function pathBuilder({
  req,
  value,
  parameter,
  baseURL
}) {
  if (value !== undefined) {
    const pathname = req.url.replace(baseURL, '');
    const resolvedPathname = (0,openapi_path_templating__WEBPACK_IMPORTED_MODULE_0__.resolve)(pathname, {
      [parameter.name]: value
    });
    req.url = baseURL + resolvedPathname;
  }
}

// Add a query to the `query` object, which will later be stringified into the URL's search
function queryBuilder({
  req,
  value,
  parameter
}) {
  req.query = req.query || {};
  if (value === false && parameter.type === 'boolean') {
    value = 'false';
  }
  if (value === 0 && ['number', 'integer'].indexOf(parameter.type) > -1) {
    value = '0';
  }
  if (value) {
    req.query[parameter.name] = {
      collectionFormat: parameter.collectionFormat,
      value
    };
  } else if (parameter.allowEmptyValue && value !== undefined) {
    const paramName = parameter.name;
    req.query[paramName] = req.query[paramName] || {};
    req.query[paramName].allowEmptyValue = true;
  }
}

/***/ }),

/***/ 34399:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _abortcontroller_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42701);

if (typeof globalThis.AbortController === 'undefined') {
  globalThis.AbortController = _abortcontroller_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.AbortController;
}
if (typeof globalThis.AbortSignal === 'undefined') {
  globalThis.AbortSignal = _abortcontroller_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.AbortSignal;
}

/***/ }),

/***/ 42701:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AbortController: () => (/* binding */ AbortController),
/* harmony export */   AbortSignal: () => (/* binding */ AbortSignal)
/* harmony export */ });
// we're targeting browsers that already support fetch API
const {
  AbortController,
  AbortSignal
} = globalThis;


/***/ }),

/***/ 39687:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* eslint-disable no-undef, no-restricted-globals */

const globalObject = (() => {
  // new standardized access to the global object
  if (typeof globalThis !== 'undefined') {
    return globalThis;
  }

  // WebWorker specific access
  if (typeof self !== 'undefined') {
    return self;
  }
  return window;
})();
const {
  btoa
} = globalObject;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (btoa);

/***/ }),

/***/ 28686:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ eachOperation)
/* harmony export */ });
// iterate over each operation, and fire a callback with details
// `find=true` will stop iterating, when the cb returns truthy
function eachOperation(spec, cb, find) {
  if (!spec || typeof spec !== 'object' || !spec.paths || typeof spec.paths !== 'object') {
    return null;
  }
  const {
    paths
  } = spec;

  // Iterate over the spec, collecting operations
  // eslint-disable-next-line no-restricted-syntax, guard-for-in
  for (const pathName in paths) {
    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const method in paths[pathName]) {
      if (method.toUpperCase() === 'PARAMETERS') {
        continue; // eslint-disable-line no-continue
      }
      const operation = paths[pathName][method];
      if (!operation || typeof operation !== 'object') {
        continue; // eslint-disable-line no-continue
      }
      const operationObj = {
        spec,
        pathName,
        method: method.toUpperCase(),
        operation
      };
      const cbValue = cb(operationObj);
      if (find && cbValue) {
        return operationObj;
      }
    }
  }
  return undefined;
}

/***/ }),

/***/ 29641:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28683);

if (typeof globalThis.fetch === 'undefined') {
  globalThis.fetch = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.fetch;
}
if (typeof globalThis.Headers === 'undefined') {
  globalThis.Headers = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.Headers;
}
if (typeof globalThis.Request === 'undefined') {
  globalThis.Request = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.Request;
}
if (typeof globalThis.Response === 'undefined') {
  globalThis.Response = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.Response;
}
if (typeof globalThis.FormData === 'undefined') {
  globalThis.FormData = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.FormData;
}
if (typeof globalThis.File === 'undefined') {
  globalThis.File = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.File;
}
if (typeof globalThis.Blob === 'undefined') {
  globalThis.Blob = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.Blob;
}

/***/ }),

/***/ 28683:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Blob: () => (/* binding */ Blob),
/* harmony export */   File: () => (/* binding */ File),
/* harmony export */   FormData: () => (/* binding */ FormData),
/* harmony export */   Headers: () => (/* binding */ Headers),
/* harmony export */   Request: () => (/* binding */ Request),
/* harmony export */   Response: () => (/* binding */ Response),
/* harmony export */   fetch: () => (/* binding */ fetch)
/* harmony export */ });
// we're targeting browsers that already support fetch API
const {
  fetch,
  Response,
  Headers,
  Request,
  FormData,
  File,
  Blob
} = globalThis;


/***/ }),

/***/ 71356:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ findOperation)
/* harmony export */ });
/* harmony import */ var _each_operation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28686);


// Will stop iterating over the operations and return the operationObj
// as soon as predicate returns true
function findOperation(spec, predicate) {
  return (0,_each_operation_js__WEBPACK_IMPORTED_MODULE_0__["default"])(spec, predicate, true) || null;
}

/***/ }),

/***/ 50324:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOperationRaw)
/* harmony export */ });
/* harmony import */ var _find_operation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71356);
/* harmony import */ var _op_id_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37896);
/* harmony import */ var _id_from_path_method_legacy_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47555);



function getOperationRaw(spec, id) {
  if (!spec || !spec.paths) {
    return null;
  }
  return (0,_find_operation_js__WEBPACK_IMPORTED_MODULE_0__["default"])(spec, ({
    pathName,
    method,
    operation
  }) => {
    if (!operation || typeof operation !== 'object') {
      return false;
    }
    const rawOperationId = operation.operationId; // straight from the source
    const operationId = (0,_op_id_js__WEBPACK_IMPORTED_MODULE_1__["default"])(operation, pathName, method);
    const legacyOperationId = (0,_id_from_path_method_legacy_js__WEBPACK_IMPORTED_MODULE_2__["default"])(pathName, method);
    return [operationId, legacyOperationId, rawOperationId].some(val => val && val === id);
  });
}

/***/ }),

/***/ 30658:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ idFromPathMethod)
/* harmony export */ });
/* harmony import */ var _replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(47891);

function idFromPathMethod(pathName, method, {
  v2OperationIdCompatibilityMode
} = {}) {
  if (v2OperationIdCompatibilityMode) {
    let res = `${method.toLowerCase()}_${pathName}`.replace(/[\s!@#$%^&*()_+=[{\]};:<>|./?,\\'""-]/g, '_');
    res = res || `${pathName.substring(1)}_${method}`;
    return res.replace(/((_){2,})/g, '_').replace(/^(_)*/g, '').replace(/([_])*$/g, '');
  }
  return `${method.toLowerCase()}${(0,_replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__["default"])(pathName)}`;
}

/***/ }),

/***/ 47555:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ idFromPathMethodLegacy)
/* harmony export */ });
function idFromPathMethodLegacy(pathName, method) {
  return `${method.toLowerCase()}-${pathName}`;
}

/***/ }),

/***/ 42396:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83748);

const {
  isHttpUrl
} = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isHttpUrl);

/***/ }),

/***/ 37896:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ opId)
/* harmony export */ });
/* harmony import */ var _id_from_path_method_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30658);
/* harmony import */ var _replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(47891);


function opId(operation, pathName, method = '', {
  v2OperationIdCompatibilityMode
} = {}) {
  if (!operation || typeof operation !== 'object') {
    return null;
  }
  const idWithoutWhitespace = (operation.operationId || '').replace(/\s/g, '');
  if (idWithoutWhitespace.length) {
    return (0,_replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__["default"])(operation.operationId);
  }
  return (0,_id_from_path_method_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])(pathName, method, {
    v2OperationIdCompatibilityMode
  });
}

/***/ }),

/***/ 50918:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isOpenAPI2: () => (/* binding */ isOpenAPI2),
/* harmony export */   isOpenAPI3: () => (/* binding */ isOpenAPI3),
/* harmony export */   isOpenAPI30: () => (/* binding */ isOpenAPI30),
/* harmony export */   isOpenAPI31: () => (/* binding */ isOpenAPI31),
/* harmony export */   isSwagger2: () => (/* binding */ isOpenAPI2)
/* harmony export */ });
const isOpenAPI2 = spec => {
  try {
    const {
      swagger
    } = spec;
    return swagger === '2.0';
  } catch {
    return false;
  }
};
const isOpenAPI30 = spec => {
  try {
    const {
      openapi
    } = spec;
    return typeof openapi === 'string' && /^3\.0\.([0123])(?:-rc[012])?$/.test(openapi);
  } catch {
    return false;
  }
};
const isOpenAPI31 = spec => {
  try {
    const {
      openapi
    } = spec;
    return typeof openapi === 'string' && /^3\.1\.(?:[1-9]\d*|0)$/.test(openapi);
  } catch {
    return false;
  }
};
const isOpenAPI3 = spec => isOpenAPI30(spec) || isOpenAPI31(spec);

// backward compatibility export


/***/ }),

/***/ 47891:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const replaceSpecialCharsWithUnderscore = operationId => operationId.replace(/\W/gi, '_');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (replaceSpecialCharsWithUnderscore);

/***/ }),

/***/ 51670:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ http),
/* harmony export */   makeHttp: () => (/* binding */ makeHttp),
/* harmony export */   serializeRes: () => (/* reexport safe */ _serializers_response_index_js__WEBPACK_IMPORTED_MODULE_2__.serializeResponse)
/* harmony export */ });
/* harmony import */ var _helpers_fetch_polyfill_node_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29641);
/* harmony import */ var _serializers_request_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29382);
/* harmony import */ var _serializers_response_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27298);





// Handles fetch-like syntax and the case where there is only one object passed-in
// (which will have the URL as a property). Also serializes the response.
async function http(url, request = {}) {
  if (typeof url === 'object') {
    request = url;
    url = request.url;
  }
  request.headers = request.headers || {};

  // Serializes query, for convenience
  // Should be the last thing we do, as its hard to mutate the URL with
  // the search string, but much easier to manipulate the req.query object
  request = (0,_serializers_request_index_js__WEBPACK_IMPORTED_MODULE_1__.serializeRequest)(request);

  // Newlines in header values cause weird error messages from `window.fetch`,
  // so let's message them out.
  // Context: https://stackoverflow.com/a/50709178
  if (request.headers) {
    Object.keys(request.headers).forEach(headerName => {
      const value = request.headers[headerName];
      if (typeof value === 'string') {
        request.headers[headerName] = value.replace(/\n+/g, ' ');
      }
    });
  }

  // Wait for the request interceptor, if it was provided
  // WARNING: don't put anything between this and the request firing unless
  // you have a good reason!
  if (request.requestInterceptor) {
    request = (await request.requestInterceptor(request)) || request;
  }

  /**
   *  For content-type=multipart/form-data remove content-type from request before fetch,
   *  so that correct one with `boundary` is set when request body is different from boundary encoded string.
   */
  const contentType = request.headers['content-type'] || request.headers['Content-Type'];
  if (/multipart\/form-data/i.test(contentType)) {
    delete request.headers['content-type'];
    delete request.headers['Content-Type'];
  }

  // eslint-disable-next-line no-undef
  let res;
  try {
    res = await (request.userFetch || fetch)(request.url, request);
    res = await (0,_serializers_response_index_js__WEBPACK_IMPORTED_MODULE_2__.serializeResponse)(res, url, request);
    if (request.responseInterceptor) {
      res = (await request.responseInterceptor(res)) || res;
    }
  } catch (resError) {
    if (!res) {
      // res is completely absent, so we can't construct our own error
      // so we'll just throw the error we got
      throw resError;
    }
    const error = new Error(res.statusText || `response status is ${res.status}`);
    error.status = res.status;
    error.statusCode = res.status;
    error.responseError = resError;
    throw error;
  }
  if (!res.ok) {
    const error = new Error(res.statusText || `response status is ${res.status}`);
    error.status = res.status;
    error.statusCode = res.status;
    error.response = res;
    throw error;
  }
  return res;
}

// Wrap a http function ( there are otherways to do this, consider this deprecated )
function makeHttp(httpFn, preFetch, postFetch) {
  postFetch = postFetch || (a => a);
  preFetch = preFetch || (a => a);
  return req => {
    if (typeof req === 'string') {
      req = {
        url: req
      };
    }
    req = (0,_serializers_request_index_js__WEBPACK_IMPORTED_MODULE_1__.serializeRequest)(req);
    req = preFetch(req);
    return postFetch(httpFn(req));
  };
}

/***/ }),

/***/ 3474:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileWithData: () => (/* binding */ FileWithData),
/* harmony export */   isArrayOfFile: () => (/* binding */ isArrayOfFile),
/* harmony export */   isFile: () => (/* binding */ isFile)
/* harmony export */ });
function isFile(obj, navigatorObj) {
  if (!navigatorObj && typeof navigator !== 'undefined') {
    // eslint-disable-next-line no-undef
    navigatorObj = navigator;
  }
  if (navigatorObj && navigatorObj.product === 'ReactNative') {
    if (obj && typeof obj === 'object' && typeof obj.uri === 'string') {
      return true;
    }
    return false;
  }
  if (typeof File !== 'undefined' && obj instanceof File) {
    return true;
  }
  if (typeof Blob !== 'undefined' && obj instanceof Blob) {
    return true;
  }
  if (ArrayBuffer.isView(obj)) {
    return true;
  }
  return obj !== null && typeof obj === 'object' && typeof obj.pipe === 'function';
}
function isArrayOfFile(obj, navigatorObj) {
  return Array.isArray(obj) && obj.some(v => isFile(v, navigatorObj));
}

/**
 * Specialized sub-class of File class, that only
 * accepts string data and retain this data in `data`
 * public property throughout the lifecycle of its instances.
 *
 * This sub-class is exclusively used only when Encoding Object
 * is defined within the Media Type Object (OpenAPI 3.x.y).
 */
class FileWithData extends File {
  constructor(data, name = '', options = {}) {
    super([data], name, options);
    this.data = data;
  }
  valueOf() {
    return this.data;
  }
  toString() {
    return this.valueOf();
  }
}

/***/ }),

/***/ 46439:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ formatKeyValue)
/* harmony export */ });
/* harmony import */ var _file_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3474);
/* harmony import */ var _execute_oas3_style_serializer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33838);


const STYLE_SEPARATORS = {
  form: ',',
  spaceDelimited: '%20',
  pipeDelimited: '|'
};
const SEPARATORS = {
  csv: ',',
  ssv: '%20',
  tsv: '%09',
  pipes: '|'
};

// Formats a key-value and returns an array of key-value pairs.
//
// Return value example 1: [['color', 'blue']]
// Return value example 2: [['color', 'blue,black,brown']]
// Return value example 3: [['color', ['blue', 'black', 'brown']]]
// Return value example 4: [['color', 'R,100,G,200,B,150']]
// Return value example 5: [['R', '100'], ['G', '200'], ['B', '150']]
// Return value example 6: [['color[R]', '100'], ['color[G]', '200'], ['color[B]', '150']]
function formatKeyValue(key, input, skipEncoding = false) {
  const {
    collectionFormat,
    allowEmptyValue,
    serializationOption,
    encoding
  } = input;
  // `input` can be string
  const value = typeof input === 'object' && !Array.isArray(input) ? input.value : input;
  const encodeFn = skipEncoding ? k => k.toString() : k => encodeURIComponent(k);
  const encodedKey = encodeFn(key);
  if (typeof value === 'undefined' && allowEmptyValue) {
    return [[encodedKey, '']];
  }

  // file
  if ((0,_file_js__WEBPACK_IMPORTED_MODULE_0__.isFile)(value) || (0,_file_js__WEBPACK_IMPORTED_MODULE_0__.isArrayOfFile)(value)) {
    return [[encodedKey, value]];
  }

  // for OAS 3 Parameter Object for serialization
  if (serializationOption) {
    return formatKeyValueBySerializationOption(key, value, skipEncoding, serializationOption);
  }

  // for OAS 3 Encoding Object
  if (encoding) {
    if ([typeof encoding.style, typeof encoding.explode, typeof encoding.allowReserved].some(type => type !== 'undefined')) {
      const {
        style,
        explode,
        allowReserved
      } = encoding;
      return formatKeyValueBySerializationOption(key, value, skipEncoding, {
        style,
        explode,
        allowReserved
      });
    }
    if (typeof encoding.contentType === 'string') {
      if (encoding.contentType.startsWith('application/json')) {
        // if value is a string, assume value is already a JSON string
        const json = typeof value === 'string' ? value : JSON.stringify(value);
        const encodedJson = encodeFn(json);
        const file = new _file_js__WEBPACK_IMPORTED_MODULE_0__.FileWithData(encodedJson, 'blob', {
          type: encoding.contentType
        });
        return [[encodedKey, file]];
      }
      const encodedData = encodeFn(String(value));
      const blob = new _file_js__WEBPACK_IMPORTED_MODULE_0__.FileWithData(encodedData, 'blob', {
        type: encoding.contentType
      });
      return [[encodedKey, blob]];
    }

    // Primitive
    if (typeof value !== 'object') {
      return [[encodedKey, encodeFn(value)]];
    }

    // Array of primitives
    if (Array.isArray(value) && value.every(v => typeof v !== 'object')) {
      return [[encodedKey, value.map(encodeFn).join(',')]];
    }

    // Array or object
    return [[encodedKey, encodeFn(JSON.stringify(value))]];
  }

  // for OAS 2 Parameter Object
  // Primitive
  if (typeof value !== 'object') {
    return [[encodedKey, encodeFn(value)]];
  }

  // Array
  if (Array.isArray(value)) {
    if (collectionFormat === 'multi') {
      // In case of multipart/formdata, it is used as array.
      // Otherwise, the caller will convert it to a query by qs.stringify.
      return [[encodedKey, value.map(encodeFn)]];
    }
    return [[encodedKey, value.map(encodeFn).join(SEPARATORS[collectionFormat || 'csv'])]];
  }

  // Object
  return [[encodedKey, '']];
}
function formatKeyValueBySerializationOption(key, value, skipEncoding, serializationOption) {
  const style = serializationOption.style || 'form';
  const explode = typeof serializationOption.explode === 'undefined' ? style === 'form' : serializationOption.explode;
  // eslint-disable-next-line no-nested-ternary
  const escape = skipEncoding ? false : serializationOption && serializationOption.allowReserved ? 'unsafe' : 'reserved';
  const encodeFn = v => (0,_execute_oas3_style_serializer_js__WEBPACK_IMPORTED_MODULE_1__.valueEncoder)(v, escape);
  const encodeKeyFn = skipEncoding ? k => k : k => encodeFn(k);

  // Primitive
  if (typeof value !== 'object') {
    return [[encodeKeyFn(key), encodeFn(value)]];
  }

  // Array
  if (Array.isArray(value)) {
    if (explode) {
      // In case of multipart/formdata, it is used as array.
      // Otherwise, the caller will convert it to a query by qs.stringify.
      return [[encodeKeyFn(key), value.map(encodeFn)]];
    }
    return [[encodeKeyFn(key), value.map(encodeFn).join(STYLE_SEPARATORS[style])]];
  }

  // Object
  if (style === 'deepObject') {
    return Object.keys(value).map(valueKey => [encodeKeyFn(`${key}[${valueKey}]`), encodeFn(value[valueKey])]);
  }
  if (explode) {
    return Object.keys(value).map(valueKey => [encodeKeyFn(valueKey), encodeFn(value[valueKey])]);
  }
  return [[encodeKeyFn(key), Object.keys(value).map(valueKey => [`${encodeKeyFn(valueKey)},${encodeFn(value[valueKey])}`]).join(',')]];
}

/***/ }),

/***/ 29382:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   encodeFormOrQuery: () => (/* binding */ encodeFormOrQuery),
/* harmony export */   serializeRequest: () => (/* binding */ serializeRequest),
/* harmony export */   stringifyQuery: () => (/* binding */ stringifyQuery)
/* harmony export */ });
/* harmony import */ var _format_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46439);
/* harmony import */ var _file_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3474);


function buildFormData(reqForm) {
  /**
   * Build a new FormData instance, support array as field value
   * OAS2.0 - when collectionFormat is multi
   * OAS3.0 - when explode of Encoding Object is true
   *
   * This function explicitly handles Buffers (for backward compatibility)
   * if provided as a values to FormData. FormData can only handle USVString
   * or Blob.
   *
   * @param {Object} reqForm - ori req.form
   * @return {FormData} - new FormData instance
   */
  return Object.entries(reqForm).reduce((formData, [name, input]) => {
    // eslint-disable-next-line no-restricted-syntax
    for (const [key, value] of (0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(name, input, true)) {
      if (Array.isArray(value)) {
        // eslint-disable-next-line no-restricted-syntax
        for (const v of value) {
          if (ArrayBuffer.isView(v)) {
            const blob = new Blob([v]);
            formData.append(key, blob);
          } else {
            formData.append(key, v);
          }
        }
      } else if (ArrayBuffer.isView(value)) {
        const blob = new Blob([value]);
        formData.append(key, blob);
      } else {
        formData.append(key, value);
      }
    }
    return formData;
  }, new FormData());
}
const stringifyQuery = (queryObject, {
  encode = true
} = {}) => {
  const buildNestedParams = (params, key, value) => {
    if (value == null) {
      params.append(key, '');
    } else if (Array.isArray(value)) {
      value.reduce((acc, v) => buildNestedParams(params, key, v), params);
    } else if (value instanceof Date) {
      params.append(key, value.toISOString());
    } else if (typeof value === 'object') {
      Object.entries(value).reduce((acc, [k, v]) => buildNestedParams(params, `${key}[${k}]`, v), params);
    } else {
      params.append(key, value);
    }
    return params;
  };
  const params = Object.entries(queryObject).reduce((acc, [key, value]) => buildNestedParams(acc, key, value), new URLSearchParams());
  const queryString = String(params);
  return encode ? queryString : decodeURIComponent(queryString);
};

// Encodes an object using appropriate serializer.
function encodeFormOrQuery(data) {
  /**
   * Encode parameter names and values
   * @param {Object} result - parameter names and values
   * @param {string} parameterName - Parameter name
   * @return {object} encoded parameter names and values
   */
  const encodedQueryObj = Object.keys(data).reduce((result, parameterName) => {
    // eslint-disable-next-line no-restricted-syntax
    for (const [key, value] of (0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(parameterName, data[parameterName])) {
      if (value instanceof _file_js__WEBPACK_IMPORTED_MODULE_1__.FileWithData) {
        result[key] = value.valueOf();
      } else {
        result[key] = value;
      }
    }
    return result;
  }, {});
  return stringifyQuery(encodedQueryObj, {
    encode: false
  });
}

// If the request has a `query` object, merge it into the request.url, and delete the object
// If file and/or multipart, also create FormData instance
function serializeRequest(req = {}) {
  const {
    url = '',
    query,
    form
  } = req;
  const joinSearch = (...strs) => {
    const search = strs.filter(a => a).join('&'); // Only truthy value
    return search ? `?${search}` : ''; // Only add '?' if there is a str
  };
  if (form) {
    const hasFile = Object.keys(form).some(key => {
      const {
        value
      } = form[key];
      return (0,_file_js__WEBPACK_IMPORTED_MODULE_1__.isFile)(value) || (0,_file_js__WEBPACK_IMPORTED_MODULE_1__.isArrayOfFile)(value);
    });
    const contentType = req.headers['content-type'] || req.headers['Content-Type'];
    if (hasFile || /multipart\/form-data/i.test(contentType)) {
      const formdata = buildFormData(req.form);
      req.formdata = formdata;
      req.body = formdata;
    } else {
      req.body = encodeFormOrQuery(form);
    }
    delete req.form;
  }
  if (query) {
    const [baseUrl, oriSearch] = url.split('?');
    let newStr = '';
    if (oriSearch) {
      const oriQuery = new URLSearchParams(oriSearch);
      const keysToRemove = Object.keys(query);
      keysToRemove.forEach(key => oriQuery.delete(key));
      newStr = String(oriQuery);
    }
    const finalStr = joinSearch(newStr, encodeFormOrQuery(query));
    req.url = baseUrl + finalStr;
    delete req.query;
  }
  return req;
}

/***/ }),

/***/ 27298:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeHeaders: () => (/* binding */ serializeHeaders),
/* harmony export */   serializeResponse: () => (/* binding */ serializeResponse),
/* harmony export */   shouldDownloadAsText: () => (/* binding */ shouldDownloadAsText)
/* harmony export */ });
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20382);

const shouldDownloadAsText = (contentType = '') => /(json|xml|yaml|text)\b/.test(contentType);
function parseBody(body, contentType) {
  if (contentType && (contentType.indexOf('application/json') === 0 || contentType.indexOf('+json') > 0)) {
    return JSON.parse(body);
  }
  return js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(body);
}
function serializeHeaderValue(value) {
  const isMulti = value.includes(', ');
  return isMulti ? value.split(', ') : value;
}

// Serialize headers into a hash, where mutliple-headers result in an array.
//
// eg: Cookie: one
//     Cookie: two
//  =  { Cookie: [ "one", "two" ]
function serializeHeaders(headers = {}) {
  if (typeof headers.entries !== 'function') return {};
  return Array.from(headers.entries()).reduce((acc, [header, value]) => {
    acc[header] = serializeHeaderValue(value);
    return acc;
  }, {});
}

// Serialize the response, returns a promise with headers and the body part of the hash
function serializeResponse(oriRes, url, {
  loadSpec = false
} = {}) {
  const res = {
    ok: oriRes.ok,
    url: oriRes.url || url,
    status: oriRes.status,
    statusText: oriRes.statusText,
    headers: serializeHeaders(oriRes.headers)
  };
  const contentType = res.headers['content-type'];
  const useText = loadSpec || shouldDownloadAsText(contentType);
  const getBody = useText ? oriRes.text : oriRes.blob || oriRes.buffer;
  return getBody.call(oriRes).then(body => {
    res.text = body;
    res.data = body;
    if (useText) {
      try {
        const obj = parseBody(body, contentType);
        res.body = obj;
        res.obj = obj;
      } catch (e) {
        res.parseError = e;
      }
    }
    return res;
  });
}

/***/ }),

/***/ 77281:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   makeApisTagOperation: () => (/* binding */ makeApisTagOperation),
/* harmony export */   makeApisTagOperationsOperationExecute: () => (/* binding */ makeApisTagOperationsOperationExecute),
/* harmony export */   makeExecute: () => (/* binding */ makeExecute),
/* harmony export */   mapTagOperations: () => (/* binding */ mapTagOperations),
/* harmony export */   self: () => (/* binding */ self)
/* harmony export */ });
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28686);
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37896);

const nullFn = () => null;
const normalizeArray = arg => Array.isArray(arg) ? arg : [arg];

// To allow stubbing of functions
const self = {
  mapTagOperations,
  makeExecute
};

// Make an execute, bound to arguments defined in mapTagOperation's callback (cb)
function makeExecute(swaggerJs = {}) {
  return ({
    pathName,
    method,
    operationId
  }) => (parameters, opts = {}) => {
    const {
      requestInterceptor,
      responseInterceptor,
      userFetch
    } = swaggerJs;
    return swaggerJs.execute({
      spec: swaggerJs.spec,
      requestInterceptor,
      responseInterceptor,
      userFetch,
      pathName,
      method,
      parameters,
      operationId,
      ...opts
    });
  };
}

// Creates an interface with tags+operations = execute
// The shape
// { apis: { [tag]: { operations: [operation]: { execute }}}}
// NOTE: this is mostly for compatibility
function makeApisTagOperationsOperationExecute(swaggerJs = {}) {
  // { apis: tag: operations: execute }
  const cb = self.makeExecute(swaggerJs);
  const tagOperations = self.mapTagOperations({
    v2OperationIdCompatibilityMode: swaggerJs.v2OperationIdCompatibilityMode,
    spec: swaggerJs.spec,
    cb
  });
  const apis = {};
  // eslint-disable-next-line no-restricted-syntax, guard-for-in
  for (const tag in tagOperations) {
    apis[tag] = {
      operations: {}
    };
    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const op in tagOperations[tag]) {
      apis[tag].operations[op] = {
        execute: tagOperations[tag][op]
      };
    }
  }
  return {
    apis
  };
}

// .apis[tag][operationId]:ExecuteFunction interface
function makeApisTagOperation(swaggerJs = {}) {
  const cb = self.makeExecute(swaggerJs);
  return {
    apis: self.mapTagOperations({
      v2OperationIdCompatibilityMode: swaggerJs.v2OperationIdCompatibilityMode,
      spec: swaggerJs.spec,
      cb
    })
  };
}

/**
 * Iterates over a spec, creating a hash of {[tag]: { [operationId], ... }, ...}
 * with the value of calling `cb`.
 *
 * `spec` is a OAI v2.0 compliant specification object
 * `cb` is called with ({ spec, operation, path, method })
 * `defaultTag` will house all non-tagged operations
 *
 */
function mapTagOperations({
  spec,
  cb = nullFn,
  defaultTag = 'default',
  v2OperationIdCompatibilityMode
}) {
  const operationIdCounter = {};
  const tagOperations = {}; // Will house all tags + operations
  (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(spec, ({
    pathName,
    method,
    operation
  }) => {
    const tags = operation.tags ? normalizeArray(operation.tags) : [defaultTag];
    tags.forEach(tag => {
      if (typeof tag !== 'string') {
        return;
      }
      tagOperations[tag] = tagOperations[tag] || {};
      const tagObj = tagOperations[tag];
      const id = (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])(operation, pathName, method, {
        v2OperationIdCompatibilityMode
      });
      const cbResult = cb({
        spec,
        pathName,
        method,
        operation,
        operationId: id
      });
      if (operationIdCounter[id]) {
        operationIdCounter[id] += 1;
        tagObj[`${id}${operationIdCounter[id]}`] = cbResult;
      } else if (typeof tagObj[id] !== 'undefined') {
        // Bump counter ( for this operationId )
        const originalCounterValue = operationIdCounter[id] || 1;
        operationIdCounter[id] = originalCounterValue + 1;
        // Append _x to the operationId
        tagObj[`${id}${operationIdCounter[id]}`] = cbResult;

        // Rename the first operationId
        const temp = tagObj[id];
        delete tagObj[id];
        tagObj[`${id}${originalCounterValue}`] = temp;
      } else {
        // Assign callback result ( usually a bound function )
        tagObj[id] = cbResult;
      }
    });
  });
  return tagOperations;
}

/***/ }),

/***/ 36202:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19500);

class SchemaRefError extends _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaRefError);

/***/ }),

/***/ 13764:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46571);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1667);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(31387);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(12349);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(57016);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41544);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(66648);
/* harmony import */ var _visitors_root_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41512);
/* eslint-disable camelcase */





const visitAsync = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.visit[Symbol.for('nodejs.util.promisify.custom')];
class OpenAPI3_1SwaggerClientDereferenceStrategy extends _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__["default"] {
  allowMetaPatches;
  parameterMacro;
  modelPropertyMacro;
  mode;
  ancestors;
  constructor({
    allowMetaPatches = false,
    parameterMacro = null,
    modelPropertyMacro = null,
    mode = 'non-strict',
    ancestors = [],
    ...rest
  } = {}) {
    super({
      ...rest
    });
    this.name = 'openapi-3-1-swagger-client';
    this.allowMetaPatches = allowMetaPatches;
    this.parameterMacro = parameterMacro;
    this.modelPropertyMacro = modelPropertyMacro;
    this.mode = mode;
    this.ancestors = [...ancestors];
  }
  async dereference(file, options) {
    const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.createNamespace)(_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__["default"]);
    const immutableRefSet = options.dereference.refSet ?? new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_5__["default"]();
    const mutableRefsSet = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_5__["default"]();
    let refSet = immutableRefSet;
    let reference;
    if (!immutableRefSet.has(file.uri)) {
      reference = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__["default"]({
        uri: file.uri,
        value: file.parseResult
      });
      immutableRefSet.add(reference);
    } else {
      // pre-computed refSet was provided as configuration option
      reference = immutableRefSet.find(ref => ref.uri === file.uri);
    }

    /**
     * Clone refSet due the dereferencing process being mutable.
     * We don't want to mutate the original refSet and the references.
     */
    if (options.dereference.immutable) {
      immutableRefSet.refs.map(ref => new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__["default"]({
        ...ref,
        value: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__.cloneDeep)(ref.value)
      })).forEach(ref => mutableRefsSet.add(ref));
      reference = mutableRefsSet.find(ref => ref.uri === file.uri);
      refSet = mutableRefsSet;
    }
    const rootVisitor = new _visitors_root_js__WEBPACK_IMPORTED_MODULE_0__["default"]({
      reference,
      namespace,
      options,
      allowMetaPatches: this.allowMetaPatches,
      ancestors: this.ancestors,
      modelPropertyMacro: this.modelPropertyMacro,
      mode: this.mode,
      parameterMacro: this.parameterMacro
    });
    const dereferencedElement = await visitAsync(refSet.rootRef.value, rootVisitor, {
      keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__.keyMap,
      nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__.getNodeType
    });

    /**
     * If immutable option is set, replay refs from the refSet.
     */
    if (options.dereference.immutable) {
      mutableRefsSet.refs.filter(ref => ref.uri.startsWith('immutable://')).map(ref => new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__["default"]({
        ...ref,
        uri: ref.uri.replace(/^immutable:\/\//, '')
      })).forEach(ref => immutableRefSet.add(ref));
    }

    /**
     * Release all memory if this refSet was not provided as an configuration option.
     * If provided as configuration option, then provider is responsible for cleanup.
     */
    if (options.dereference.refSet === null) {
      immutableRefSet.clean();
    }
    mutableRefsSet.clean();
    return dereferencedElement;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenAPI3_1SwaggerClientDereferenceStrategy);
/* eslint-enable camelcase */

/***/ }),

/***/ 17381:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Retrieves the root cause of ApiDOM error hierarchy.
 * ApiDOM error hierarchies are modeled similar to Java.
 * Every error can have cause attribute which references
 * cause of this error.
 */
const getRootCause = error => {
  if (error.cause == null) return error;
  let {
    cause
  } = error;
  while (cause.cause != null) {
    cause = cause.cause;
  }
  return cause;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getRootCause);

/***/ }),

/***/ 12201:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9999);

const trimParseResult = elementPath => elementPath.slice(2);

/**
 * Transforms ApiDOM traversal meta information into
 * SwaggerClient compatible path.
 *
 * SwaggerClient path is a list of JSON Pointer tokens.
 */
const toPath = elementPath => {
  const elementPathSanitized = trimParseResult(elementPath);
  return elementPathSanitized.reduce((path, element, index) => {
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isMemberElement)(element)) {
      const token = String((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__["default"])(element.key));
      path.push(token);
    } else if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isArrayElement)(elementPathSanitized[index - 2])) {
      const token = elementPathSanitized[index - 2].content.indexOf(element);
      path.push(token);
    }
    return path;
  }, []);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toPath);

/***/ }),

/***/ 22519:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15461);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(70281);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12201);



class AllOfVisitor {
  options;
  SchemaElement = {
    leave(schemaElement, key, parent, path, ancestors) {
      // do nothing
      if (typeof schemaElement.allOf === 'undefined') return undefined;

      // collect error and return if allOf keyword is not an array
      if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isArrayElement)(schemaElement.allOf)) {
        const error = new TypeError('allOf must be an array');
        error.fullPath = [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_1__["default"])([...ancestors, parent, schemaElement]), 'allOf'];
        this.options.dereference.dereferenceOpts?.errors?.push?.(error);
        return undefined;
      }

      // remove allOf keyword if empty
      if (schemaElement.allOf.isEmpty) {
        schemaElement.remove('allOf');
        return undefined;
      }

      // collect errors if allOf keyword contains anything else than Schema Object
      const includesSchemaElementOnly = schemaElement.allOf.content.every(_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__.isSchemaElement);
      if (!includesSchemaElementOnly) {
        const error = new TypeError('Elements in allOf must be objects');
        error.fullPath = [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_1__["default"])([...ancestors, parent, schemaElement]), 'allOf'];
        this.options.dereference.dereferenceOpts?.errors?.push?.(error);
        return undefined;
      }
      while (schemaElement.hasKey('allOf')) {
        const {
          allOf
        } = schemaElement;
        schemaElement.remove('allOf');
        const allOfMerged = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"].all([...allOf.content, schemaElement]);

        /**
         * If there was not an original $$ref value, make sure to remove
         * any $$ref value that may exist from the result of `allOf` merges.
         */
        if (!schemaElement.hasKey('$$ref')) {
          allOfMerged.remove('$$ref');
        }

        /**
         * If there was an example keyword in the original schema,
         * keep it instead of merging with example from other schema.
         */
        if (schemaElement.hasKey('example')) {
          const member = allOfMerged.getMember('example');
          if (member) {
            member.value = schemaElement.get('example');
          }
        }

        /**
         * If there was an examples keyword in the original schema,
         * keep it instead of merging with examples from other schema.
         */
        if (schemaElement.hasKey('examples')) {
          const member = allOfMerged.getMember('examples');
          if (member) {
            member.value = schemaElement.get('examples');
          }
        }
        schemaElement.content = allOfMerged.content;
      }
      return undefined;
    }
  };
  constructor({
    options
  }) {
    this.options = options;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AllOfVisitor);

/***/ }),

/***/ 7882:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46571);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42209);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9999);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(98219);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(85013);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(3117);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(70281);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(66648);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(85270);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(18316);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(83748);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(60503);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(21136);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(32346);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(51776);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(46432);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(16129);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(78311);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(12201);
/* harmony import */ var _utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(17381);
/* harmony import */ var _specmap_lib_refs_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65084);
/* harmony import */ var _errors_SchemaRefError_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(36202);
/* eslint-disable camelcase */












const {
  wrapError
} = _specmap_lib_refs_js__WEBPACK_IMPORTED_MODULE_0__["default"];
const visitAsync = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.visit[Symbol.for('nodejs.util.promisify.custom')];

// initialize element identity manager
const identityManager = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.IdentityManager();

// custom mutation replacer
const mutationReplacer = (newElement, oldElement, key, parent) => {
  if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isMemberElement)(parent)) {
    parent.value = newElement; // eslint-disable-line no-param-reassign
  } else if (Array.isArray(parent)) {
    parent[key] = newElement; // eslint-disable-line no-param-reassign
  }
};
class OpenAPI3_1SwaggerClientDereferenceVisitor extends _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__["default"] {
  useCircularStructures;
  allowMetaPatches;
  basePath;
  constructor({
    allowMetaPatches = true,
    useCircularStructures = false,
    basePath = null,
    ...rest
  }) {
    super(rest);
    this.allowMetaPatches = allowMetaPatches;
    this.useCircularStructures = useCircularStructures;
    this.basePath = basePath;
  }
  async ReferenceElement(referencingElement, key, parent, path, ancestors, link) {
    try {
      // skip current referencing element as it's already been access
      if (this.indirections.includes(referencingElement)) {
        return false;
      }
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);
      const retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref));
      const isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
      const isExternalReference = !isInternalReference;

      // ignore resolving internal Reference Objects
      if (!this.options.resolve.internal && isInternalReference) {
        return false;
      }
      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && isExternalReference) {
        return false;
      }
      const reference = await this.toReference((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref));
      const $refBaseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref));
      this.indirections.push(referencingElement);
      const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);

      // possibly non-semantic fragment
      let referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__["default"])(jsonPointer, reference.value.result);
      referencedElement.id = identityManager.identify(referencedElement);

      // applying semantics to a fragment
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isPrimitiveElement)(referencedElement)) {
        const referencedElementType = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.meta.get('referenced-element'));
        const cacheKey = `${referencedElementType}-${(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(identityManager.identify(referencedElement))}`;
        if (this.refractCache.has(cacheKey)) {
          referencedElement = this.refractCache.get(cacheKey);
        } else if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__.isReferenceLikeElement)(referencedElement)) {
          // handling indirect references
          referencedElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.ReferenceElement.refract(referencedElement);
          referencedElement.setMetaProperty('referenced-element', referencedElementType);
          this.refractCache.set(cacheKey, referencedElement);
        } else {
          // handling direct references
          const ElementClass = this.namespace.getElementClass(referencedElementType);
          referencedElement = ElementClass.refract(referencedElement);
          this.refractCache.set(cacheKey, referencedElement);
        }
      }

      // detect direct or indirect reference
      if (referencingElement === referencedElement) {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Recursive Reference Object detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // detect second deep dive into the same fragment and avoid it
      if (ancestorsLineage.includes(referencedElement)) {
        reference.refSet.circular = true;
        if (this.options.dereference.circular === 'error') {
          throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Circular reference detected');
        } else if (this.options.dereference.circular === 'replace') {
          const refElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_13__.RefElement(referencedElement.id, {
            type: 'reference',
            uri: reference.uri,
            $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
            baseURI: $refBaseURI,
            referencingElement
          });
          const replacer = this.options.dereference.strategyOpts['openapi-3-1']?.circularReplacer ?? this.options.dereference.circularReplacer;
          const replacement = replacer(refElement);
          link.replaceWith(refElement, mutationReplacer);
          return !parent ? replacement : false;
        }
      }

      /**
       * Dive deep into the fragment.
       *
       * Cases to consider:
       *  1. We're crossing document boundary
       *  2. Fragment is from non-root document
       *  3. Fragment is a Reference Object. We need to follow it to get the eventual value
       *  4. We are dereferencing the fragment lazily/eagerly depending on circular mode
       */
      const isNonRootDocument = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(reference.refSet.rootRef.uri) !== reference.uri;
      const shouldDetectCircular = ['error', 'replace'].includes(this.options.dereference.circular);
      if ((isExternalReference || isNonRootDocument || (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isReferenceElement)(referencedElement) || shouldDetectCircular) && !ancestorsLineage.includesCycle(referencedElement)) {
        // append referencing reference to ancestors lineage
        directAncestors.add(referencingElement);
        const visitor = new OpenAPI3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          refractCache: this.refractCache,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, referencingElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, visitor, {
          keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.keyMap,
          nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.getNodeType
        });

        // remove referencing reference from ancestors lineage
        directAncestors.delete(referencingElement);
      }
      this.indirections.pop();
      const mergedElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneShallow)(referencedElement);

      // annotate fragment with info about original Reference element
      mergedElement.setMetaProperty('ref-fields', {
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
        description: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.description),
        summary: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.summary)
      });
      // annotate fragment with info about origin
      mergedElement.setMetaProperty('ref-origin', reference.uri);
      // annotate fragment with info about referencing element
      mergedElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(identityManager.identify(referencingElement)));

      // override description and summary (outer has higher priority then inner)
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isObjectElement)(referencedElement)) {
        if (referencingElement.hasKey('description') && 'description' in referencedElement) {
          mergedElement.remove('description');
          mergedElement.set('description', referencingElement.get('description'));
        }
        if (referencingElement.hasKey('summary') && 'summary' in referencedElement) {
          mergedElement.remove('summary');
          mergedElement.set('summary', referencingElement.get('summary'));
        }
      }

      // apply meta patches
      if (this.allowMetaPatches && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isObjectElement)(mergedElement)) {
        // apply meta patch only when not already applied
        if (!mergedElement.hasKey('$$ref')) {
          const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
          mergedElement.set('$$ref', baseURI);
        }
      }

      /**
       * Transclude referencing element with merged referenced element.
       */
      link.replaceWith(mergedElement, mutationReplacer);

      /**
       * We're at the root of the tree, so we're just replacing the entire tree.
       */
      return !parent ? mergedElement : false;
    } catch (error) {
      const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__["default"])(error);
      const wrappedError = wrapError(rootCause, {
        baseDoc: this.reference.uri,
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
        pointer: (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref)),
        fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, referencingElement]), '$ref']
      });
      this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
      return undefined;
    }
  }
  async PathItemElement(pathItemElement, key, parent, path, ancestors, link) {
    try {
      // ignore PathItemElement without $ref field
      if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(pathItemElement.$ref)) {
        return undefined;
      }

      // skip current referencing element as it's already been access
      if (this.indirections.includes(pathItemElement)) {
        return false;
      }

      // skip already identified cycled Path Item Objects
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.includesClasses)(['cycle'], pathItemElement.$ref)) {
        return false;
      }
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);
      const retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref));
      const isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
      const isExternalReference = !isInternalReference;

      // ignore resolving internal Path Item Elements
      if (!this.options.resolve.internal && isInternalReference) {
        return undefined;
      }
      // ignore resolving external Path Item Elements
      if (!this.options.resolve.external && isExternalReference) {
        return undefined;
      }
      const reference = await this.toReference((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref));
      const $refBaseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref));
      this.indirections.push(pathItemElement);
      const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);

      // possibly non-semantic referenced element
      let referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__["default"])(jsonPointer, reference.value.result);
      referencedElement.id = identityManager.identify(referencedElement);

      // applying semantics to a referenced element
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isPrimitiveElement)(referencedElement)) {
        const cacheKey = `path-item-${(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(identityManager.identify(referencedElement))}`;
        if (this.refractCache.has(cacheKey)) {
          referencedElement = this.refractCache.get(cacheKey);
        } else {
          referencedElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.PathItemElement.refract(referencedElement);
          this.refractCache.set(cacheKey, referencedElement);
        }
      }

      // detect direct or indirect reference
      if (pathItemElement === referencedElement) {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Recursive Path Item Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // detect second deep dive into the same fragment and avoid it
      if (ancestorsLineage.includes(referencedElement)) {
        reference.refSet.circular = true;
        if (this.options.dereference.circular === 'error') {
          throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Circular reference detected');
        } else if (this.options.dereference.circular === 'replace') {
          const refElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_13__.RefElement(referencedElement.id, {
            type: 'path-item',
            uri: reference.uri,
            $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref),
            baseURI: $refBaseURI,
            referencingElement: pathItemElement
          });
          const replacer = this.options.dereference.strategyOpts['openapi-3-1']?.circularReplacer ?? this.options.dereference.circularReplacer;
          const replacement = replacer(refElement);
          link.replaceWith(refElement, mutationReplacer);
          return !parent ? replacement : false;
        }
      }

      /**
       * Dive deep into the fragment.
       *
       * Cases to consider:
       *  1. We're crossing document boundary
       *  2. Fragment is from non-root document
       *  3. Fragment is a Path Item Object with $ref field. We need to follow it to get the eventual value
       *  4. We are dereferencing the fragment lazily/eagerly depending on circular mode
       */
      const isNonRootDocument = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(reference.refSet.rootRef.uri) !== reference.uri;
      const shouldDetectCircular = ['error', 'replace'].includes(this.options.dereference.circular);
      if ((isExternalReference || isNonRootDocument || (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isPathItemElement)(referencedElement) && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(referencedElement.$ref) || shouldDetectCircular) && !ancestorsLineage.includesCycle(referencedElement)) {
        // append referencing schema to ancestors lineage
        directAncestors.add(pathItemElement);

        // dive deep into the referenced element
        const visitor = new OpenAPI3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, pathItemElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, visitor, {
          keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.keyMap,
          nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(pathItemElement);
      }
      this.indirections.pop();

      /**
       * Creating a new version of Path Item by merging fields from referenced Path Item with referencing one.
       */
      if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isPathItemElement)(referencedElement)) {
        const mergedElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.PathItemElement([...referencedElement.content], (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement.meta), (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement.attributes));
        // existing keywords from referencing PathItemElement overrides ones from referenced element
        pathItemElement.forEach((value, keyElement, item) => {
          mergedElement.remove((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(keyElement));
          mergedElement.content.push(item);
        });
        mergedElement.remove('$ref');

        // annotate referenced element with info about original referencing element
        mergedElement.setMetaProperty('ref-fields', {
          $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref)
        });
        // annotate referenced element with info about origin
        mergedElement.setMetaProperty('ref-origin', reference.uri);
        // annotate fragment with info about referencing element
        mergedElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(identityManager.identify(pathItemElement)));

        // apply meta patches
        if (this.allowMetaPatches) {
          // apply meta patch only when not already applied
          if (typeof mergedElement.get('$$ref') === 'undefined') {
            const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
            mergedElement.set('$$ref', baseURI);
          }
        }
        referencedElement = mergedElement;
      }

      /**
       * Transclude referencing element with merged referenced element.
       */
      link.replaceWith(referencedElement, mutationReplacer);

      /**
       * We're at the root of the tree, so we're just replacing the entire tree.
       */
      return !parent ? referencedElement : undefined;
    } catch (error) {
      const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__["default"])(error);
      const wrappedError = wrapError(rootCause, {
        baseDoc: this.reference.uri,
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref),
        pointer: (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref)),
        fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, pathItemElement]), '$ref']
      });
      this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
      return undefined;
    }
  }
  async SchemaElement(referencingElement, key, parent, path, ancestors, link) {
    try {
      // skip current referencing schema as $ref keyword was not defined
      if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(referencingElement.$ref)) {
        // skip traversing this schema but traverse all it's child schemas
        return undefined;
      }

      // skip current referencing element as it's already been access
      if (this.indirections.includes(referencingElement)) {
        return false;
      }
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);

      // compute baseURI using rules around $id and $ref keywords
      let reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize(this.reference.uri));
      let {
        uri: retrievalURI
      } = reference;
      const $refBaseURI = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.resolveSchema$refField)(retrievalURI, referencingElement);
      const $refBaseURIStrippedHash = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash($refBaseURI);
      const file = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_20__["default"]({
        uri: $refBaseURIStrippedHash
      });
      const isUnknownURI = !this.options.resolve.resolvers.some(r => r.canRead(file));
      const isURL = !isUnknownURI;
      let isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === $refBaseURI;
      let isExternalReference = !isInternalReference;
      this.indirections.push(referencingElement);

      // determining reference, proper evaluation and selection mechanism
      let referencedElement;
      try {
        if (isUnknownURI || isURL) {
          // we're dealing with canonical URI or URL with possible fragment
          retrievalURI = this.toBaseURI($refBaseURI);
          const selector = $refBaseURI;
          const referenceAsSchema = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(reference.value.result);
          referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_21__.evaluate)(selector, referenceAsSchema);
          referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(referencedElement);
          referencedElement.id = identityManager.identify(referencedElement);

          // ignore resolving internal Schema Objects
          if (!this.options.resolve.internal && isInternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          // ignore resolving external Schema Objects
          if (!this.options.resolve.external && isExternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
        } else {
          // we're assuming here that we're dealing with JSON Pointer here
          retrievalURI = this.toBaseURI($refBaseURI);
          isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
          isExternalReference = !isInternalReference;

          // ignore resolving internal Schema Objects
          if (!this.options.resolve.internal && isInternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          // ignore resolving external Schema Objects
          if (!this.options.resolve.external && isExternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize($refBaseURI));
          const selector = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);
          const referenceAsSchema = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(reference.value.result);
          referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__["default"])(selector, referenceAsSchema);
          referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(referencedElement);
          referencedElement.id = identityManager.identify(referencedElement);
        }
      } catch (error) {
        /**
         * No SchemaElement($id=URL) was not found, so we're going to try to resolve
         * the URL and assume the returned response is a JSON Schema.
         */
        if (isURL && error instanceof _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_22__["default"]) {
          if ((0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__.isAnchor)((0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__.uriToAnchor)($refBaseURI))) {
            // we're dealing with JSON Schema $anchor here
            isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
            isExternalReference = !isInternalReference;

            // ignore resolving internal Schema Objects
            if (!this.options.resolve.internal && isInternalReference) {
              // skip traversing this schema element but traverse all it's child elements
              return undefined;
            }
            // ignore resolving external Schema Objects
            if (!this.options.resolve.external && isExternalReference) {
              // skip traversing this schema element but traverse all it's child elements
              return undefined;
            }
            reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize($refBaseURI));
            const selector = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__.uriToAnchor)($refBaseURI);
            const referenceAsSchema = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(reference.value.result);
            referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__.evaluate)(selector, referenceAsSchema);
            referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(referencedElement);
            referencedElement.id = identityManager.identify(referencedElement);
          } else {
            // we're assuming here that we're dealing with JSON Pointer here
            retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])($refBaseURI));
            isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
            isExternalReference = !isInternalReference;

            // ignore resolving internal Schema Objects
            if (!this.options.resolve.internal && isInternalReference) {
              // skip traversing this schema element but traverse all it's child elements
              return undefined;
            }
            // ignore resolving external Schema Objects
            if (!this.options.resolve.external && isExternalReference) {
              // skip traversing this schema element but traverse all it's child elements
              return undefined;
            }
            reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize($refBaseURI));
            const selector = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);
            const referenceAsSchema = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(reference.value.result);
            referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__["default"])(selector, referenceAsSchema);
            referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(referencedElement);
            referencedElement.id = identityManager.identify(referencedElement);
          }
        } else {
          throw error;
        }
      }

      // detect direct or indirect reference
      if (referencingElement === referencedElement) {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Recursive Schema Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // detect second deep dive into the same fragment and avoid it
      if (ancestorsLineage.includes(referencedElement)) {
        reference.refSet.circular = true;
        if (this.options.dereference.circular === 'error') {
          throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Circular reference detected');
        } else if (this.options.dereference.circular === 'replace') {
          const refElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_13__.RefElement(referencedElement.id, {
            type: 'json-schema',
            uri: reference.uri,
            $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
            baseURI: _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI),
            referencingElement
          });
          const replacer = this.options.dereference.strategyOpts['openapi-3-1']?.circularReplacer ?? this.options.dereference.circularReplacer;
          const replacement = replacer(refElement);
          link.replaceWith(replacement, mutationReplacer);
          return !parent ? replacement : false;
        }
      }

      /**
       * Dive deep into the fragment.
       *
       * Cases to consider:
       *  1. We're crossing document boundary
       *  2. Fragment is from non-root document
       *  3. Fragment is a Schema Object with $ref field. We need to follow it to get the eventual value
       *  4. We are dereferencing the fragment lazily/eagerly depending on circular mode
       */
      const isNonRootDocument = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(reference.refSet.rootRef.uri) !== reference.uri;
      const shouldDetectCircular = ['error', 'replace'].includes(this.options.dereference.circular);
      if ((isExternalReference || isNonRootDocument || (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isSchemaElement)(referencedElement) && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(referencedElement.$ref) || shouldDetectCircular) && !ancestorsLineage.includesCycle(referencedElement)) {
        // append referencing schema to ancestors lineage
        directAncestors.add(referencingElement);

        // dive deep into the fragment
        const mergeVisitor = new OpenAPI3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          useCircularStructures: this.useCircularStructures,
          allowMetaPatches: this.allowMetaPatches,
          ancestors: ancestorsLineage,
          basePath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, referencingElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, mergeVisitor, {
          keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.keyMap,
          nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(referencingElement);
      }
      this.indirections.pop();
      if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isBooleanJsonSchemaElement)(referencedElement)) {
        const booleanJsonSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement);
        // annotate referenced element with info about original referencing element
        booleanJsonSchemaElement.setMetaProperty('ref-fields', {
          $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref)
        });
        // annotate referenced element with info about origin
        booleanJsonSchemaElement.setMetaProperty('ref-origin', reference.uri);
        // annotate fragment with info about referencing element
        booleanJsonSchemaElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(identityManager.identify(referencingElement)));
        link.replaceWith(booleanJsonSchemaElement, mutationReplacer);
        return !parent ? booleanJsonSchemaElement : false;
      }

      /**
       * Creating a new version of Schema Object by merging fields from referenced Schema Object with referencing one.
       */
      if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isSchemaElement)(referencedElement)) {
        // Schema Object - merge keywords from referenced schema with referencing schema
        const mergedElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.SchemaElement([...referencedElement.content], (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement.meta), (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement.attributes));
        // existing keywords from referencing schema overrides ones from referenced schema
        referencingElement.forEach((value, keyElement, item) => {
          mergedElement.remove((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(keyElement));
          mergedElement.content.push(item);
        });
        mergedElement.remove('$ref');
        // annotate referenced element with info about original referencing element
        mergedElement.setMetaProperty('ref-fields', {
          $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref)
        });
        // annotate fragment with info about origin
        mergedElement.setMetaProperty('ref-origin', reference.uri);
        // annotate fragment with info about referencing element
        mergedElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(identityManager.identify(referencingElement)));

        // allowMetaPatches option processing
        if (this.allowMetaPatches) {
          // apply meta patch only when not already applied
          if (typeof mergedElement.get('$$ref') === 'undefined') {
            const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
            mergedElement.set('$$ref', baseURI);
          }
        }
        referencedElement = mergedElement;
      }

      /**
       * Transclude referencing element with merged referenced element.
       */
      link.replaceWith(referencedElement, mutationReplacer);

      /**
       * We're at the root of the tree, so we're just replacing the entire tree.
       */
      return !parent ? referencedElement : undefined;
    } catch (error) {
      const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__["default"])(error);
      const wrappedError = new _errors_SchemaRefError_js__WEBPACK_IMPORTED_MODULE_24__["default"](`Could not resolve reference: ${rootCause.message}`, {
        baseDoc: this.reference.uri,
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
        fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, referencingElement]), '$ref'],
        cause: rootCause
      });
      this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
      return undefined;
    }
  }

  // eslint-disable-next-line class-methods-use-this
  async LinkElement() {
    /**
     * OpenApi3_1DereferenceVisitor is doing lookup of Operation Objects
     * and assigns them to Link Object metadata. This is not needed in
     * swagger-client context, so we're disabling it here.
     */
    return undefined;
  }
  async ExampleElement(exampleElement, key, parent, path, ancestors, link) {
    try {
      return await super.ExampleElement(exampleElement, key, parent, path, ancestors, link);
    } catch (error) {
      const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__["default"])(error);
      const wrappedError = wrapError(rootCause, {
        baseDoc: this.reference.uri,
        externalValue: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(exampleElement.externalValue),
        fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, exampleElement]), 'externalValue']
      });
      this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
      return undefined;
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenAPI3_1SwaggerClientDereferenceVisitor);
/* eslint-enable camelcase */

/***/ }),

/***/ 53628:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9999);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12201);


class ParameterMacroVisitor {
  parameterMacro;
  options;
  #macroOperation;
  OperationElement = {
    enter: operationElement => {
      this.#macroOperation = operationElement;
    },
    leave: () => {
      this.#macroOperation = undefined;
    }
  };
  ParameterElement = {
    leave: (parameterElement, key, parent, path, ancestors) => {
      const pojoOperation = this.#macroOperation ? (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(this.#macroOperation) : null;
      const pojoParameter = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(parameterElement);
      try {
        const macroValue = this.parameterMacro(pojoOperation, pojoParameter);
        parameterElement.set('default', macroValue);
      } catch (error) {
        const macroError = new Error(error, {
          cause: error
        });
        macroError.fullPath = (0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_1__["default"])([...ancestors, parent]);
        this.options.dereference.dereferenceOpts?.errors?.push?.(macroError);
      }
    }
  };
  constructor({
    parameterMacro,
    options
  }) {
    this.parameterMacro = parameterMacro;
    this.options = options;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParameterMacroVisitor);

/***/ }),

/***/ 85001:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9999);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12201);


class ModelPropertyMacroVisitor {
  modelPropertyMacro;
  options;
  SchemaElement = {
    leave: (schemaElement, key, parent, path, ancestors) => {
      if (typeof schemaElement.properties === 'undefined') return;
      if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isObjectElement)(schemaElement.properties)) return;
      schemaElement.properties.forEach(property => {
        if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isObjectElement)(property)) return;
        try {
          const macroValue = this.modelPropertyMacro((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__["default"])(property));
          property.set('default', macroValue);
        } catch (error) {
          const macroError = new Error(error, {
            cause: error
          });
          macroError.fullPath = [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_2__["default"])([...ancestors, parent, schemaElement]), 'properties'];
          this.options.dereference.dereferenceOpts?.errors?.push?.(macroError);
        }
      });
    }
  };
  constructor({
    modelPropertyMacro,
    options
  }) {
    this.modelPropertyMacro = modelPropertyMacro;
    this.options = options;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ModelPropertyMacroVisitor);

/***/ }),

/***/ 41512:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(68618);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(66648);
/* harmony import */ var _properties_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(85001);
/* harmony import */ var _all_of_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22519);
/* harmony import */ var _parameters_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(53628);
/* harmony import */ var _dereference_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7882);





 // eslint-disable-line camelcase

const mergeAllVisitorsAsync = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.mergeAll[Symbol.for('nodejs.util.promisify.custom')];
class RootVisitor {
  constructor({
    parameterMacro,
    modelPropertyMacro,
    mode,
    options,
    ...rest
  }) {
    const visitors = [];
    visitors.push(new _dereference_js__WEBPACK_IMPORTED_MODULE_0__["default"]({
      ...rest,
      options
    }));
    if (typeof modelPropertyMacro === 'function') {
      visitors.push(new _properties_js__WEBPACK_IMPORTED_MODULE_2__["default"]({
        modelPropertyMacro,
        options
      }));
    }
    if (mode !== 'strict') {
      visitors.push(new _all_of_js__WEBPACK_IMPORTED_MODULE_3__["default"]({
        options
      }));
    }
    if (typeof parameterMacro === 'function') {
      visitors.push(new _parameters_js__WEBPACK_IMPORTED_MODULE_4__["default"]({
        parameterMacro,
        options
      }));
    }
    const mergedVisitor = mergeAllVisitorsAsync(visitors, {
      nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__.getNodeType
    });
    Object.assign(this, mergedVisitor);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RootVisitor);

/***/ }),

/***/ 92263:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(32121);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10048);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(57295);


class JSONParser extends _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options = {}) {
    super({
      name: 'json-swagger-client',
      mediaTypes: ['application/json'],
      ...options
    });
  }
  async canParse(file) {
    const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
    const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
    if (!hasSupportedFileExtension) return false;
    if (hasSupportedMediaType) return true;
    if (!hasSupportedMediaType) {
      try {
        JSON.parse(file.toString());
        return true;
      } catch (error) {
        return false;
      }
    }
    return false;
  }
  async parse(file) {
    if (this.sourceMap) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__["default"]("json-swagger-client parser plugin doesn't support sourceMaps option");
    }
    const parseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.ParseResultElement();
    const source = file.toString();

    // allow empty files
    if (this.allowEmpty && source.trim() === '') {
      return parseResultElement;
    }
    try {
      const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"])(JSON.parse(source));
      element.classes.push('result');
      parseResultElement.push(element);
      return parseResultElement;
    } catch (error) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__["default"](`Error parsing "${file.uri}"`, {
        cause: error
      });
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONParser);

/***/ }),

/***/ 89742:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10048);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(57295);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94145);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3117);
/* eslint-disable camelcase */



class OpenAPIJSON3_1Parser extends _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_0__["default"] {
  detectionRegExp = /"openapi"\s*:\s*"(?<version_json>3\.1\.(?:[1-9]\d*|0))"/;
  constructor(options = {}) {
    super({
      name: 'openapi-json-3-1-swagger-client',
      mediaTypes: new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__.OpenAPIMediaTypes(..._swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__["default"].filterByFormat('generic'), ..._swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_1__["default"].filterByFormat('json')),
      ...options
    });
  }
  async canParse(file) {
    const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
    const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
    if (!hasSupportedFileExtension) return false;
    if (hasSupportedMediaType) return true;
    if (!hasSupportedMediaType) {
      try {
        const source = file.toString();
        JSON.parse(source);
        return this.detectionRegExp.test(source);
      } catch (error) {
        return false;
      }
    }
    return false;
  }
  async parse(file) {
    if (this.sourceMap) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"]("openapi-json-3-1-swagger-client parser plugin doesn't support sourceMaps option");
    }
    const parseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ParseResultElement();
    const source = file.toString();

    // allow empty files
    if (this.allowEmpty && source.trim() === '') {
      return parseResultElement;
    }
    try {
      const pojo = JSON.parse(source);
      const element = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__.OpenApi3_1Element.refract(pojo, this.refractorOpts);
      element.classes.push('result');
      parseResultElement.push(element);
      return parseResultElement;
    } catch (error) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"](`Error parsing "${file.uri}"`, {
        cause: error
      });
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenAPIJSON3_1Parser);
/* eslint-enable camelcase */

/***/ }),

/***/ 49575:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20382);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10048);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(57295);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(94145);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3117);
/* eslint-disable camelcase */




class OpenAPIYAML31Parser extends _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__["default"] {
  detectionRegExp = /(?<YAML>^(["']?)openapi\2\s*:\s*(["']?)(?<version_yaml>3\.1\.(?:[1-9]\d*|0))\3(?:\s+|$))|(?<JSON>"openapi"\s*:\s*"(?<version_json>3\.1\.(?:[1-9]\d*|0))")/m;
  constructor(options = {}) {
    super({
      name: 'openapi-yaml-3-1-swagger-client',
      mediaTypes: new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__.OpenAPIMediaTypes(..._swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__["default"].filterByFormat('generic'), ..._swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__["default"].filterByFormat('yaml')),
      ...options
    });
  }
  async canParse(file) {
    const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
    const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
    if (!hasSupportedFileExtension) return false;
    if (hasSupportedMediaType) return true;
    if (!hasSupportedMediaType) {
      try {
        const source = file.toString();
        js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(source);
        return this.detectionRegExp.test(source);
      } catch (error) {
        return false;
      }
    }
    return false;
  }
  async parse(file) {
    if (this.sourceMap) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__["default"]("openapi-yaml-3-1-swagger-client parser plugin doesn't support sourceMaps option");
    }
    const parseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ParseResultElement();
    const source = file.toString();
    try {
      const pojo = js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(source, {
        schema: js_yaml__WEBPACK_IMPORTED_MODULE_0__.JSON_SCHEMA
      });
      if (this.allowEmpty && typeof pojo === 'undefined') {
        return parseResultElement;
      }
      const element = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__.OpenApi3_1Element.refract(pojo, this.refractorOpts);
      element.classes.push('result');
      parseResultElement.push(element);
      return parseResultElement;
    } catch (error) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__["default"](`Error parsing "${file.uri}"`, {
        cause: error
      });
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenAPIYAML31Parser);
/* eslint-enable camelcase */

/***/ }),

/***/ 12787:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20382);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(32121);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10048);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(57295);



class YAMLParser extends _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__["default"] {
  constructor(options = {}) {
    super({
      name: 'yaml-1-2-swagger-client',
      mediaTypes: ['text/yaml', 'application/yaml'],
      ...options
    });
  }
  async canParse(file) {
    const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
    const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
    if (!hasSupportedFileExtension) return false;
    if (hasSupportedMediaType) return true;
    if (!hasSupportedMediaType) {
      try {
        js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(file.toString(), {
          schema: js_yaml__WEBPACK_IMPORTED_MODULE_0__.JSON_SCHEMA
        });
        return true;
      } catch (error) {
        return false;
      }
    }
    return false;
  }
  async parse(file) {
    if (this.sourceMap) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"]("yaml-1-2-swagger-client parser plugin doesn't support sourceMaps option");
    }
    const parseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ParseResultElement();
    const source = file.toString();
    try {
      const pojo = js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(source, {
        schema: js_yaml__WEBPACK_IMPORTED_MODULE_0__.JSON_SCHEMA
      });
      if (this.allowEmpty && typeof pojo === 'undefined') {
        return parseResultElement;
      }
      const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__["default"])(pojo);
      element.classes.push('result');
      parseResultElement.push(element);
      return parseResultElement;
    } catch (error) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"](`Error parsing "${file.uri}"`, {
        cause: error
      });
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (YAMLParser);

/***/ }),

/***/ 636:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35959);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27998);
/* harmony import */ var _helpers_fetch_polyfill_node_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29641);
/* harmony import */ var _helpers_abortcontroller_polyfill_node_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34399);
/* harmony import */ var _http_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(51670);




class HTTPResolverSwaggerClient extends _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__["default"] {
  swaggerHTTPClient = _http_index_js__WEBPACK_IMPORTED_MODULE_2__["default"];
  swaggerHTTPClientConfig;
  constructor({
    swaggerHTTPClient = _http_index_js__WEBPACK_IMPORTED_MODULE_2__["default"],
    swaggerHTTPClientConfig = {},
    ...rest
  } = {}) {
    super({
      ...rest,
      name: 'http-swagger-client'
    });
    this.swaggerHTTPClient = swaggerHTTPClient;
    this.swaggerHTTPClientConfig = swaggerHTTPClientConfig;
  }
  getHttpClient() {
    return this.swaggerHTTPClient;
  }
  async read(file) {
    const client = this.getHttpClient();
    const controller = new AbortController();
    const {
      signal
    } = controller;
    const timeoutID = setTimeout(() => {
      controller.abort();
    }, this.timeout);
    const credentials = this.getHttpClient().withCredentials || this.withCredentials ? 'include' : 'same-origin';
    const redirect = this.redirects === 0 ? 'error' : 'follow';
    const follow = this.redirects > 0 ? this.redirects : undefined;
    try {
      const response = await client({
        url: file.uri,
        signal,
        userFetch: async (resource, options) => {
          let res = await fetch(resource, options);
          try {
            // undici supports mutations
            res.headers.delete('Content-Type');
          } catch {
            // Fetch API has guards which prevent mutations
            res = new Response(res.body, {
              ...res,
              headers: new Headers(res.headers)
            });
            res.headers.delete('Content-Type');
          }
          return res;
        },
        credentials,
        redirect,
        follow,
        ...this.swaggerHTTPClientConfig
      });
      return response.text.arrayBuffer();
    } catch (error) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_4__["default"](`Error downloading "${file.uri}"`, {
        cause: error
      });
    } finally {
      clearTimeout(timeoutID);
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HTTPResolverSwaggerClient);

/***/ }),

/***/ 92272:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   makeResolve: () => (/* binding */ makeResolve)
/* harmony export */ });
/* harmony import */ var _utils_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34242);
/* harmony import */ var _utils_options_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40428);
/* harmony import */ var _strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52398);
/* harmony import */ var _strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19096);
/* harmony import */ var _strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(730);





const resolve = async options => {
  const {
    spec,
    requestInterceptor,
    responseInterceptor
  } = options;
  const retrievalURI = _utils_options_js__WEBPACK_IMPORTED_MODULE_1__.retrievalURI(options);
  const httpClient = _utils_options_js__WEBPACK_IMPORTED_MODULE_1__.httpClient(options);
  const retrievedSpec = spec || (await (0,_utils_index_js__WEBPACK_IMPORTED_MODULE_0__.makeFetchJSON)(httpClient, {
    requestInterceptor,
    responseInterceptor
  })(retrievalURI));
  const strategyOptions = {
    ...options,
    spec: retrievedSpec
  };
  const strategy = options.strategies.find(strg => strg.match(retrievedSpec));
  return strategy.resolve(strategyOptions);
};
const makeResolve = defaultOptions => async options => {
  const mergedOptions = {
    ...defaultOptions,
    ...options
  };
  return resolve(mergedOptions);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (makeResolve({
  strategies: [_strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_4__["default"], _strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_3__["default"], _strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_2__["default"]]
}));

/***/ }),

/***/ 7573:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   absolutifyPointer: () => (/* binding */ absolutifyPointer),
/* harmony export */   generateAbsoluteRefPatches: () => (/* binding */ generateAbsoluteRefPatches),
/* harmony export */   isFreelyNamed: () => (/* binding */ isFreelyNamed)
/* harmony export */ });
/* harmony import */ var neotraverse_legacy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(70909);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(83748);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3832);




// This will match if the direct parent's key exactly matches an item.
const freelyNamedKeyParents = ['properties'];

// This will match if the grandparent's key exactly matches an item.
// NOTE that this is for finding non-free paths!
const nonFreelyNamedKeyGrandparents = ['properties'];

// This will match if the joined parent path exactly matches an item.
//
// This is mostly useful for filtering out root-level reusable item names,
// for example `["definitions", "$ref"]`
const freelyNamedPaths = [
// Swagger 2.0
'definitions', 'parameters', 'responses', 'securityDefinitions',
// OpenAPI 3.0
'components/schemas', 'components/responses', 'components/parameters', 'components/securitySchemes'];

// This will match if any of these items are substrings of the joined
// parent path.
//
// Warning! These are powerful. Beware of edge cases.
const freelyNamedAncestors = ['schema/example', 'items/example'];
function isFreelyNamed(parentPath) {
  const parentKey = parentPath[parentPath.length - 1];
  const grandparentKey = parentPath[parentPath.length - 2];
  const parentStr = parentPath.join('/');
  return (
    // eslint-disable-next-line max-len
    freelyNamedKeyParents.indexOf(parentKey) > -1 && nonFreelyNamedKeyGrandparents.indexOf(grandparentKey) === -1 || freelyNamedPaths.indexOf(parentStr) > -1 || freelyNamedAncestors.some(el => parentStr.indexOf(el) > -1)
  );
}
function generateAbsoluteRefPatches(obj, basePath, {
  specmap,
  getBaseUrlForNodePath = path => specmap.getContext([...basePath, ...path]).baseDoc,
  targetKeys = ['$ref', '$$ref']
} = {}) {
  const patches = [];
  (0,neotraverse_legacy__WEBPACK_IMPORTED_MODULE_0__["default"])(obj).forEach(function callback() {
    if (targetKeys.includes(this.key) && typeof this.node === 'string') {
      const nodePath = this.path; // this node's path, relative to `obj`
      const fullPath = basePath.concat(this.path);
      const absolutifiedRefValue = absolutifyPointer(this.node, getBaseUrlForNodePath(nodePath));
      patches.push(specmap.replace(fullPath, absolutifiedRefValue));
    }
  });
  return patches;
}
function absolutifyPointer(pointer, baseUrl) {
  const [urlPart, fragmentPart] = pointer.split('#');
  const safeBaseUrl = baseUrl ?? '';
  const safeUrlPart = urlPart ?? '';
  let newRefUrlPart;
  if (!_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__.isHttpUrl(safeBaseUrl)) {
    const absoluteBaseUrl = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__.resolve(_constants_js__WEBPACK_IMPORTED_MODULE_1__.DEFAULT_BASE_URL, safeBaseUrl);
    const absoluteRefUrlPart = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__.resolve(absoluteBaseUrl, safeUrlPart);
    const rawRefUrlPart = absoluteRefUrlPart.replace(_constants_js__WEBPACK_IMPORTED_MODULE_1__.DEFAULT_BASE_URL, '');
    newRefUrlPart = safeUrlPart.startsWith('/') ? rawRefUrlPart : rawRefUrlPart.substring(1);
  } else {
    newRefUrlPart = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__.resolve(safeBaseUrl, safeUrlPart);
  }
  return fragmentPart ? `${newRefUrlPart}#${fragmentPart}` : newRefUrlPart;
}

/***/ }),

/***/ 1704:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SpecMap: () => (/* binding */ SpecMap),
/* harmony export */   "default": () => (/* binding */ mapSpec),
/* harmony export */   plugins: () => (/* binding */ plugins)
/* harmony export */ });
/* harmony import */ var _lib_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10692);
/* harmony import */ var _lib_refs_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65084);
/* harmony import */ var _lib_all_of_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(48301);
/* harmony import */ var _lib_parameters_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34438);
/* harmony import */ var _lib_properties_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(67783);
/* harmony import */ var _lib_context_tree_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(21664);






const PLUGIN_DISPATCH_LIMIT = 100;
const TRAVERSE_LIMIT = 3000;
const noop = () => {};
class SpecMap {
  static getPluginName(plugin) {
    return plugin.pluginName;
  }
  static getPatchesOfType(patches, fn) {
    return patches.filter(fn);
  }
  constructor(opts) {
    Object.assign(this, {
      spec: '',
      debugLevel: 'info',
      plugins: [],
      pluginHistory: {},
      errors: [],
      mutations: [],
      promisedPatches: [],
      state: {},
      patches: [],
      context: {},
      contextTree: new _lib_context_tree_js__WEBPACK_IMPORTED_MODULE_5__["default"](),
      showDebug: false,
      allPatches: [],
      // only populated if showDebug is true
      pluginProp: 'specMap',
      libMethods: Object.assign(Object.create(this), _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"], {
        getInstance: () => this
      }),
      allowMetaPatches: false
    }, opts);

    // Lib methods bound
    this.get = this._get.bind(this); // eslint-disable-line no-underscore-dangle
    this.getContext = this._getContext.bind(this); // eslint-disable-line no-underscore-dangle
    this.hasRun = this._hasRun.bind(this); // eslint-disable-line no-underscore-dangle

    this.wrappedPlugins = this.plugins.map(this.wrapPlugin.bind(this)).filter(_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isFunction);

    // Initial patch(s)
    this.patches.push(_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].add([], this.spec));
    this.patches.push(_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].context([], this.context));
    this.updatePatches(this.patches);
  }
  debug(level, ...args) {
    if (this.debugLevel === level) {
      console.log(...args); // eslint-disable-line no-console
    }
  }
  verbose(header, ...args) {
    if (this.debugLevel === 'verbose') {
      console.log(`[${header}]   `, ...args); // eslint-disable-line no-console
    }
  }
  wrapPlugin(plugin, name) {
    const {
      pathDiscriminator
    } = this;
    let ctx = null;
    let fn;
    if (plugin[this.pluginProp]) {
      ctx = plugin;
      fn = plugin[this.pluginProp];
    } else if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isFunction(plugin)) {
      fn = plugin;
    } else if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isObject(plugin)) {
      fn = createKeyBasedPlugin(plugin);
    }
    return Object.assign(fn.bind(ctx), {
      pluginName: plugin.name || name,
      isGenerator: _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isGenerator(fn)
    });

    // Expected plugin interface: {key: string, plugin: fn*}
    // This traverses depth-first and immediately applies yielded patches.
    // This strategy should work well for most plugins (including the built-ins).
    // We might consider making this (traversing & application) configurable later.
    function createKeyBasedPlugin(pluginObj) {
      const isSubPath = (path, tested) => {
        if (!Array.isArray(path)) {
          return true;
        }
        return path.every((val, i) => val === tested[i]);
      };
      return function* generator(patches, specmap) {
        const refCache = {};

        // eslint-disable-next-line no-restricted-syntax
        for (const [i, patch] of patches.filter(_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isAdditiveMutation).entries()) {
          if (i < TRAVERSE_LIMIT) {
            yield* traverse(patch.value, patch.path, patch);
          } else {
            return;
          }
        }
        function* traverse(obj, path, patch) {
          if (!_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isObject(obj)) {
            if (pluginObj.key === path[path.length - 1]) {
              yield pluginObj.plugin(obj, pluginObj.key, path, specmap);
            }
          } else {
            const parentIndex = path.length - 1;
            const parent = path[parentIndex];
            const indexOfFirstProperties = path.indexOf('properties');
            const isRootProperties = parent === 'properties' && parentIndex === indexOfFirstProperties;
            const traversed = specmap.allowMetaPatches && refCache[obj.$$ref];

            // eslint-disable-next-line no-restricted-syntax
            for (const key of Object.keys(obj)) {
              const val = obj[key];
              const updatedPath = path.concat(key);
              const isObj = _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isObject(val);
              const objRef = obj.$$ref;
              if (!traversed) {
                if (isObj) {
                  // Only store the ref if it exists
                  if (specmap.allowMetaPatches && objRef) {
                    refCache[objRef] = true;
                  }
                  yield* traverse(val, updatedPath, patch);
                }
              }
              if (!isRootProperties && key === pluginObj.key) {
                const isWithinPathDiscriminator = isSubPath(pathDiscriminator, path);
                if (!pathDiscriminator || isWithinPathDiscriminator) {
                  yield pluginObj.plugin(val, key, updatedPath, specmap, patch);
                }
              }
            }
          }
        }
      };
    }
  }
  nextPlugin() {
    return this.wrappedPlugins.find(plugin => {
      const mutations = this.getMutationsForPlugin(plugin);
      return mutations.length > 0;
    });
  }
  nextPromisedPatch() {
    if (this.promisedPatches.length > 0) {
      return Promise.race(this.promisedPatches.map(patch => patch.value));
    }
    return undefined;
  }
  getPluginHistory(plugin) {
    const name = this.constructor.getPluginName(plugin);
    return this.pluginHistory[name] || [];
  }
  getPluginRunCount(plugin) {
    return this.getPluginHistory(plugin).length;
  }
  getPluginHistoryTip(plugin) {
    const history = this.getPluginHistory(plugin);
    const val = history && history[history.length - 1];
    return val || {};
  }
  getPluginMutationIndex(plugin) {
    const mi = this.getPluginHistoryTip(plugin).mutationIndex;
    return typeof mi !== 'number' ? -1 : mi;
  }
  updatePluginHistory(plugin, val) {
    const name = this.constructor.getPluginName(plugin);
    this.pluginHistory[name] = this.pluginHistory[name] || [];
    this.pluginHistory[name].push(val);
  }
  updatePatches(patches) {
    _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].normalizeArray(patches).forEach(patch => {
      if (patch instanceof Error) {
        this.errors.push(patch);
        return;
      }
      try {
        if (!_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isObject(patch)) {
          this.debug('updatePatches', 'Got a non-object patch', patch);
          return;
        }
        if (this.showDebug) {
          this.allPatches.push(patch);
        }
        if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isPromise(patch.value)) {
          this.promisedPatches.push(patch);
          this.promisedPatchThen(patch);
          return;
        }
        if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isContextPatch(patch)) {
          this.setContext(patch.path, patch.value);
          return;
        }
        if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isMutation(patch)) {
          this.updateMutations(patch);
        }
      } catch (e) {
        console.error(e); // eslint-disable-line no-console
        this.errors.push(e);
      }
    });
  }
  updateMutations(patch) {
    if (typeof patch.value === 'object' && !Array.isArray(patch.value) && this.allowMetaPatches) {
      patch.value = {
        ...patch.value
      };
    }
    const result = _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].applyPatch(this.state, patch, {
      allowMetaPatches: this.allowMetaPatches
    });
    if (result) {
      this.mutations.push(patch);
      this.state = result;
    }
  }
  removePromisedPatch(patch) {
    const index = this.promisedPatches.indexOf(patch);
    if (index < 0) {
      this.debug("Tried to remove a promisedPatch that isn't there!");
      return;
    }
    this.promisedPatches.splice(index, 1);
  }
  promisedPatchThen(patch) {
    patch.value = patch.value.then(val => {
      const promisedPatch = {
        ...patch,
        value: val
      };
      this.removePromisedPatch(patch);
      this.updatePatches(promisedPatch);
    }).catch(e => {
      this.removePromisedPatch(patch);
      this.updatePatches(e);
    });
    return patch.value;
  }
  getMutations(from, to) {
    from = from || 0;
    if (typeof to !== 'number') {
      to = this.mutations.length;
    }
    return this.mutations.slice(from, to);
  }
  getCurrentMutations() {
    return this.getMutationsForPlugin(this.getCurrentPlugin());
  }
  getMutationsForPlugin(plugin) {
    const tip = this.getPluginMutationIndex(plugin);
    return this.getMutations(tip + 1);
  }
  getCurrentPlugin() {
    return this.currentPlugin;
  }
  getLib() {
    return this.libMethods;
  }

  // eslint-disable-next-line no-underscore-dangle
  _get(path) {
    return _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].getIn(this.state, path);
  }

  // eslint-disable-next-line no-underscore-dangle
  _getContext(path) {
    return this.contextTree.get(path);
  }
  setContext(path, value) {
    return this.contextTree.set(path, value);
  }

  // eslint-disable-next-line no-underscore-dangle
  _hasRun(count) {
    const times = this.getPluginRunCount(this.getCurrentPlugin());
    return times > (count || 0);
  }
  dispatch() {
    const that = this;
    const plugin = this.nextPlugin();
    if (!plugin) {
      const nextPromise = this.nextPromisedPatch();
      if (nextPromise) {
        return nextPromise.then(() => this.dispatch()).catch(() => this.dispatch());
      }

      // We're done!
      const result = {
        spec: this.state,
        errors: this.errors
      };
      if (this.showDebug) {
        result.patches = this.allPatches;
      }
      return Promise.resolve(result);
    }

    // Makes sure plugin isn't running an endless loop
    that.pluginCount = that.pluginCount || new WeakMap();
    that.pluginCount.set(plugin, (that.pluginCount.get(plugin) || 0) + 1);
    if (that.pluginCount[plugin] > PLUGIN_DISPATCH_LIMIT) {
      return Promise.resolve({
        spec: that.state,
        errors: that.errors.concat(new Error(`We've reached a hard limit of ${PLUGIN_DISPATCH_LIMIT} plugin runs`))
      });
    }

    // A different plugin runs, wait for all promises to resolve, then retry
    if (plugin !== this.currentPlugin && this.promisedPatches.length) {
      const promises = this.promisedPatches.map(p => p.value);

      // Waits for all to settle instead of Promise.all which stops on rejection
      return Promise.all(promises.map(promise => promise.then(noop, noop))).then(() => this.dispatch());
    }

    // Ok, run the plugin
    return executePlugin();
    function executePlugin() {
      that.currentPlugin = plugin;
      const mutations = that.getCurrentMutations();
      const lastMutationIndex = that.mutations.length - 1;
      try {
        if (plugin.isGenerator) {
          // eslint-disable-next-line no-restricted-syntax
          for (const yieldedPatches of plugin(mutations, that.getLib())) {
            updatePatches(yieldedPatches);
          }
        } else {
          const newPatches = plugin(mutations, that.getLib());
          updatePatches(newPatches);
        }
      } catch (e) {
        console.error(e); // eslint-disable-line no-console
        updatePatches([Object.assign(Object.create(e), {
          plugin
        })]);
      } finally {
        that.updatePluginHistory(plugin, {
          mutationIndex: lastMutationIndex
        });
      }
      return that.dispatch();
    }
    function updatePatches(patches) {
      if (patches) {
        patches = _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].fullyNormalizeArray(patches);
        that.updatePatches(patches, plugin);
      }
    }
  }
}
function mapSpec(opts) {
  return new SpecMap(opts).dispatch();
}
const plugins = {
  refs: _lib_refs_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  allOf: _lib_all_of_js__WEBPACK_IMPORTED_MODULE_2__["default"],
  parameters: _lib_parameters_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  properties: _lib_properties_js__WEBPACK_IMPORTED_MODULE_4__["default"]
};


/***/ }),

/***/ 48301:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7573);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  key: 'allOf',
  plugin: (val, key, fullPath, specmap, patch) => {
    // Ignore replace patches created by $ref because the changes will
    // occur in the original "add" patch and we don't want this plugin
    // to redundantly processes those "relace" patches.
    if (patch.meta && patch.meta.$$ref) {
      return undefined;
    }
    const parent = fullPath.slice(0, -1);
    if ((0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.isFreelyNamed)(parent)) {
      return undefined;
    }
    if (!Array.isArray(val)) {
      const err = new TypeError('allOf must be an array');
      err.fullPath = fullPath; // This is an array
      return err;
    }
    let alreadyAddError = false;

    // Find the original definition from the `patch.value` object
    // Remove the `allOf` property so it doesn't get added to the result of the `allOf` plugin
    let originalDefinitionObj = patch.value;
    parent.forEach(part => {
      if (!originalDefinitionObj) return; // bail out if we've lost sight of our target
      originalDefinitionObj = originalDefinitionObj[part];
    });
    originalDefinitionObj = {
      ...originalDefinitionObj
    };

    // when we've lost sight, interrupt prematurely
    if (Object.keys(originalDefinitionObj).length === 0) {
      return undefined;
    }
    delete originalDefinitionObj.allOf;
    const patches = [];

    // remove existing content
    patches.push(specmap.replace(parent, {}));
    val.forEach((toMerge, i) => {
      if (!specmap.isObject(toMerge)) {
        if (alreadyAddError) {
          return null;
        }
        alreadyAddError = true;
        const err = new TypeError('Elements in allOf must be objects');
        err.fullPath = fullPath; // This is an array
        return patches.push(err);
      }

      // Deeply merge the member's contents onto the parent location
      patches.push(specmap.mergeDeep(parent, toMerge));

      // Generate patches that migrate $ref values based on ContextTree information

      // remove ["allOf"], which will not be present when these patches are applied
      const collapsedFullPath = fullPath.slice(0, -1);
      const absoluteRefPatches = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_0__.generateAbsoluteRefPatches)(toMerge, collapsedFullPath, {
        getBaseUrlForNodePath: nodePath => specmap.getContext([...fullPath, i, ...nodePath]).baseDoc,
        specmap
      });
      patches.push(...absoluteRefPatches);
      return undefined;
    });

    // If there was an example in the original definition,
    // keep it instead of merging with examples from other schema
    if (originalDefinitionObj.example) {
      // Delete other schema examples
      patches.push(specmap.remove([].concat(parent, 'example')));
    }
    // Merge back the values from the original definition
    patches.push(specmap.mergeDeep(parent, originalDefinitionObj));

    // If there was not an original $$ref value, make sure to remove
    // any $$ref value that may exist from the result of `allOf` merges
    if (!originalDefinitionObj.$$ref) {
      patches.push(specmap.remove([].concat(parent, '$$ref')));
    }
    return patches;
  }
});

/***/ }),

/***/ 21664:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContextTree)
/* harmony export */ });
class ContextTree {
  constructor(value) {
    this.root = createNode(value || {});
  }
  set(path, value) {
    const parent = this.getParent(path, true);
    if (!parent) {
      updateNode(this.root, value, null);
      return;
    }
    const key = path[path.length - 1];
    const {
      children
    } = parent;
    if (children[key]) {
      updateNode(children[key], value, parent);
      return;
    }
    children[key] = createNode(value, parent);
  }

  // Get the "best" node (node or nearest parent) and return its value.
  get(path) {
    path = path || [];
    if (path.length < 1) {
      return this.root.value;
    }
    let branch = this.root;
    let child;
    let token;
    for (let i = 0; i < path.length; i += 1) {
      token = path[i];
      child = branch.children;
      if (!child[token]) {
        break;
      }
      branch = child[token];
    }
    return branch && branch.protoValue;
  }
  getParent(path, ensureExists) {
    if (!path || path.length < 1) {
      return null;
    }
    if (path.length < 2) {
      return this.root;
    }
    return path.slice(0, -1).reduce((branch, token) => {
      if (!branch) {
        return branch;
      }
      const {
        children
      } = branch;
      if (!children[token] && ensureExists) {
        children[token] = createNode(null, branch);
      }
      return children[token];
    }, this.root);
  }
}

// =========================
// Utilities
// =========================

function createNode(value, parent) {
  return updateNode({
    children: {}
  }, value, parent);
}
function updateNode(node, value, parent) {
  node.value = value || {};
  node.protoValue = parent ? {
    ...parent.protoValue,
    ...node.value
  } : node.value;
  Object.keys(node.children).forEach(prop => {
    const child = node.children[prop];
    node.children[prop] = updateNode(child, child.value, node);
  });
  return node;
}

/***/ }),

/***/ 10692:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var fast_json_patch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16111);
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14744);
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  add,
  replace,
  remove,
  merge,
  mergeDeep,
  context,
  getIn,
  applyPatch,
  parentPathMatch,
  flatten,
  fullyNormalizeArray,
  normalizeArray,
  isPromise,
  forEachNew,
  forEachNewPrimitive,
  isJsonPatch,
  isContextPatch,
  isPatch,
  isMutation,
  isAdditiveMutation,
  isGenerator,
  isFunction,
  isObject,
  isError
});
function applyPatch(obj, patch, opts) {
  opts = opts || {};
  patch = {
    ...patch,
    path: patch.path && normalizeJSONPath(patch.path)
  };
  if (patch.op === 'merge') {
    const newValue = getInByJsonPath(obj, patch.path);
    Object.assign(newValue, patch.value);
    fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, [replace(patch.path, newValue)]);
  } else if (patch.op === 'mergeDeep') {
    const currentValue = getInByJsonPath(obj, patch.path);
    const newValue = deepmerge__WEBPACK_IMPORTED_MODULE_1___default()(currentValue, patch.value);
    obj = fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, [replace(patch.path, newValue)]).newDocument;
  } else if (patch.op === 'add' && patch.path === '' && isObject(patch.value)) {
    // { op: 'add', path: '', value: { a: 1, b: 2 }}
    // has no effect: json patch refuses to do anything.
    // so let's break that patch down into a set of patches,
    // one for each key in the intended root value.

    const patches = Object.keys(patch.value).reduce((arr, key) => {
      arr.push({
        op: 'add',
        path: `/${normalizeJSONPath(key)}`,
        value: patch.value[key]
      });
      return arr;
    }, []);
    fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, patches);
  } else if (patch.op === 'replace' && patch.path === '') {
    let {
      value
    } = patch;
    if (opts.allowMetaPatches && patch.meta && isAdditiveMutation(patch) && (Array.isArray(patch.value) || isObject(patch.value))) {
      value = {
        ...value,
        ...patch.meta
      };
    }
    obj = value;
  } else {
    fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, [patch]);

    // Attach metadata to the resulting value.
    if (opts.allowMetaPatches && patch.meta && isAdditiveMutation(patch) && (Array.isArray(patch.value) || isObject(patch.value))) {
      const currentValue = getInByJsonPath(obj, patch.path);
      const newValue = {
        ...currentValue,
        ...patch.meta
      };
      fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, [replace(patch.path, newValue)]);
    }
  }
  return obj;
}
function normalizeJSONPath(path) {
  if (Array.isArray(path)) {
    if (path.length < 1) {
      return '';
    }
    return `/${path.map(item =>
    // eslint-disable-line prefer-template
    (item + '').replace(/~/g, '~0').replace(/\//g, '~1') // eslint-disable-line prefer-template
    ).join('/')}`;
  }
  return path;
}

// =========================
// JSON-Patch Wrappers
// =========================

function add(path, value) {
  return {
    op: 'add',
    path,
    value
  };
}

// function _get(path) {
//   return { op: '_get', path };
// }

function replace(path, value, meta) {
  return {
    op: 'replace',
    path,
    value,
    meta
  };
}
function remove(path) {
  return {
    op: 'remove',
    path
  };
}

// Custom wrappers
function merge(path, value) {
  return {
    type: 'mutation',
    op: 'merge',
    path,
    value
  };
}

// Custom wrappers
function mergeDeep(path, value) {
  return {
    type: 'mutation',
    op: 'mergeDeep',
    path,
    value
  };
}
function context(path, value) {
  return {
    type: 'context',
    path,
    value
  };
}

// =========================
// Iterators
// =========================

function forEachNew(mutations, fn) {
  try {
    return forEachNewPatch(mutations, forEach, fn);
  } catch (e) {
    return e;
  }
}
function forEachNewPrimitive(mutations, fn) {
  try {
    return forEachNewPatch(mutations, forEachPrimitive, fn);
  } catch (e) {
    return e;
  }
}
function forEachNewPatch(mutations, fn, callback) {
  const res = mutations.filter(isAdditiveMutation).map(mutation => fn(mutation.value, callback, mutation.path)) || [];
  const flat = flatten(res);
  const clean = cleanArray(flat);
  return clean;
}
function forEachPrimitive(obj, fn, basePath) {
  basePath = basePath || [];
  if (Array.isArray(obj)) {
    return obj.map((val, key) => forEachPrimitive(val, fn, basePath.concat(key)));
  }
  if (isObject(obj)) {
    return Object.keys(obj).map(key => forEachPrimitive(obj[key], fn, basePath.concat(key)));
  }
  return fn(obj, basePath[basePath.length - 1], basePath);
}
function forEach(obj, fn, basePath) {
  basePath = basePath || [];
  let results = [];
  if (basePath.length > 0) {
    const newResults = fn(obj, basePath[basePath.length - 1], basePath);
    if (newResults) {
      results = results.concat(newResults);
    }
  }
  if (Array.isArray(obj)) {
    const arrayResults = obj.map((val, key) => forEach(val, fn, basePath.concat(key)));
    if (arrayResults) {
      results = results.concat(arrayResults);
    }
  } else if (isObject(obj)) {
    const moreResults = Object.keys(obj).map(key => forEach(obj[key], fn, basePath.concat(key)));
    if (moreResults) {
      results = results.concat(moreResults);
    }
  }
  results = flatten(results);
  return results;
}

// =========================
// Paths
// =========================

function parentPathMatch(path, arr) {
  if (!Array.isArray(arr)) {
    return false;
  }
  for (let i = 0, len = arr.length; i < len; i += 1) {
    if (arr[i] !== path[i]) {
      return false;
    }
  }
  return true;
}
function getIn(obj, path) {
  return path.reduce((val, token) => {
    if (typeof token !== 'undefined' && val) {
      return val[token];
    }
    return val;
  }, obj);
}

// =========================
// Array
// =========================

function fullyNormalizeArray(arr) {
  return cleanArray(flatten(normalizeArray(arr)));
}
function normalizeArray(arr) {
  return Array.isArray(arr) ? arr : [arr];
}
function flatten(arr) {
  return [].concat(...arr.map(val => Array.isArray(val) ? flatten(val) : val));
}
function cleanArray(arr) {
  return arr.filter(elm => typeof elm !== 'undefined');
}

// =========================
// Is-Thing.
// =========================

function isObject(val) {
  return val && typeof val === 'object';
}
function isPromise(val) {
  return isObject(val) && isFunction(val.then);
}
function isFunction(val) {
  return val && typeof val === 'function';
}
function isError(patch) {
  return patch instanceof Error;
}
function isJsonPatch(patch) {
  if (isPatch(patch)) {
    const {
      op
    } = patch;
    return op === 'add' || op === 'remove' || op === 'replace';
  }
  return false;
}
function isGenerator(thing) {
  return Object.prototype.toString.call(thing) === '[object GeneratorFunction]';
}
function isMutation(patch) {
  return isJsonPatch(patch) || isPatch(patch) && patch.type === 'mutation';
}
function isAdditiveMutation(patch) {
  return isMutation(patch) && (patch.op === 'add' || patch.op === 'replace' || patch.op === 'merge' || patch.op === 'mergeDeep');
}
function isContextPatch(patch) {
  return isPatch(patch) && patch.type === 'context';
}
function isPatch(patch) {
  return patch && typeof patch === 'object';
}
function getInByJsonPath(obj, jsonPath) {
  try {
    return fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.getValueByPointer(obj, jsonPath);
  } catch (e) {
    console.error(e); // eslint-disable-line no-console
    return {};
  }
}

/***/ }),

/***/ 34438:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10692);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  key: 'parameters',
  plugin: (parameters, key, fullPath, specmap) => {
    if (Array.isArray(parameters) && parameters.length) {
      const val = Object.assign([], parameters);
      const opPath = fullPath.slice(0, -1);
      const op = {
        ..._index_js__WEBPACK_IMPORTED_MODULE_0__["default"].getIn(specmap.spec, opPath)
      };
      for (let i = 0; i < parameters.length; i += 1) {
        const param = parameters[i];
        try {
          val[i].default = specmap.parameterMacro(op, param);
        } catch (e) {
          const err = new Error(e);
          err.fullPath = fullPath;
          return err;
        }
      }
      return _index_js__WEBPACK_IMPORTED_MODULE_0__["default"].replace(fullPath, val);
    }
    return _index_js__WEBPACK_IMPORTED_MODULE_0__["default"].replace(fullPath, parameters);
  }
});

/***/ }),

/***/ 67783:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10692);

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  key: 'properties',
  plugin: (properties, key, fullPath, specmap) => {
    const val = {
      ...properties
    };

    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const k in properties) {
      try {
        val[k].default = specmap.modelPropertyMacro(val[k]);
      } catch (e) {
        const err = new Error(e);
        err.fullPath = fullPath; // This is an array
        return err;
      }
    }
    const patch = _index_js__WEBPACK_IMPORTED_MODULE_0__["default"].replace(fullPath, val);
    return patch;
  }
});

/***/ }),

/***/ 65084:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20382);
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(19500);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(83748);
/* harmony import */ var _helpers_fetch_polyfill_node_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29641);
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10692);
/* harmony import */ var _helpers_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(7573);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3832);







const ABSOLUTE_URL_REGEXP = /^([a-z]+:\/\/|\/\/)/i;
class JSONRefError extends _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_5__["default"] {}
const docCache = {};
const specmapRefs = new WeakMap();
const skipResolutionTestFns = [
// OpenAPI 2.0 response examples
path =>
// ["paths", *, *, "responses", *, "examples"]
path[0] === 'paths' && path[3] === 'responses' && path[5] === 'examples',
// OpenAPI 3.0 Response Media Type Examples
path =>
// ["paths", *, *, "responses", *, "content", *, "example"]
path[0] === 'paths' && path[3] === 'responses' && path[5] === 'content' && path[7] === 'example', path =>
// ["paths", *, *, "responses", *, "content", *, "examples", *, "value"]
path[0] === 'paths' && path[3] === 'responses' && path[5] === 'content' && path[7] === 'examples' && path[9] === 'value',
// OpenAPI 3.0 Request Body Media Type Examples
path =>
// ["paths", *, *, "requestBody", "content", *, "example"]
path[0] === 'paths' && path[3] === 'requestBody' && path[4] === 'content' && path[6] === 'example', path =>
// ["paths", *, *, "requestBody", "content", *, "examples", *, "value"]
path[0] === 'paths' && path[3] === 'requestBody' && path[4] === 'content' && path[6] === 'examples' && path[8] === 'value',
// OAS 3.0 Parameter Examples
path =>
// ["paths", *, "parameters", *, "example"]
path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'example', path =>
// ["paths", *, *, "parameters", *, "example"]
path[0] === 'paths' && path[3] === 'parameters' && path[5] === 'example', path =>
// ["paths", *, "parameters", *, "examples", *, "value"]
path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'examples' && path[6] === 'value', path =>
// ["paths", *, *, "parameters", *, "examples", *, "value"]
path[0] === 'paths' && path[3] === 'parameters' && path[5] === 'examples' && path[7] === 'value', path =>
// ["paths", *, "parameters", *, "content", *, "example"]
path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'content' && path[6] === 'example', path =>
// ["paths", *, "parameters", *, "content", *, "examples", *, "value"]
path[0] === 'paths' && path[2] === 'parameters' && path[4] === 'content' && path[6] === 'examples' && path[8] === 'value', path =>
// ["paths", *, *, "parameters", *, "content", *, "example"]
path[0] === 'paths' && path[3] === 'parameters' && path[4] === 'content' && path[7] === 'example', path =>
// ["paths", *, *, "parameters", *, "content", *, "examples", *, "value"]
path[0] === 'paths' && path[3] === 'parameters' && path[5] === 'content' && path[7] === 'examples' && path[9] === 'value'];
const shouldSkipResolution = path => skipResolutionTestFns.some(fn => fn(path));

// =========================
// Core
// =========================

/**
 * This plugin resolves the JSON pointers.
 * A major part of this plugin deals with cyclic references via 2 mechanisms.
 * 1. If a pointer was already resolved before in this path, halt.
 * 2. If the patch value points to one of the ancestors in this path, halt.
 *
 * Note that either one of these mechanism is sufficient, both must be in place.
 * For examples:
 *
 * Given the following spec, #1 alone is insufficient because after the 2nd
 * application, there will be a cyclic object reference.
 *   a.b.c: $ref-d
 *   d.e.f: $ref-a (per #1, safe to return patch as no immediate cycle)
 *
 * Given the following spec, #2 alone is insufficient because although there will
 * never be any cyclic object reference, the plugin will keep producing patches.
 *   a: $ref-b
 *   b: $ref-a
 */
const plugin = {
  key: '$ref',
  plugin: (ref, key, fullPath, specmap) => {
    const specmapInstance = specmap.getInstance();
    const parent = fullPath.slice(0, -1);
    if ((0,_helpers_js__WEBPACK_IMPORTED_MODULE_3__.isFreelyNamed)(parent) || shouldSkipResolution(parent)) {
      return undefined;
    }
    const {
      baseDoc
    } = specmap.getContext(fullPath);
    if (typeof ref !== 'string') {
      return new JSONRefError('$ref: must be a string (JSON-Ref)', {
        $ref: ref,
        baseDoc,
        fullPath
      });
    }
    const splitString = split(ref);
    const refPath = splitString[0];
    const pointer = splitString[1] || '';
    let basePath;
    try {
      basePath = baseDoc || refPath ? absoluteify(refPath, baseDoc) : null;
    } catch (e) {
      return wrapError(e, {
        pointer,
        $ref: ref,
        basePath,
        fullPath
      });
    }
    let promOrVal;
    let tokens;
    if (pointerAlreadyInPath(pointer, basePath, parent, specmap)) {
      // Cyclic reference!
      // if `useCircularStructures` is not set, just leave the reference
      // unresolved, but absolutify it so that we don't leave an invalid $ref
      // path in the content
      if (!specmapInstance.useCircularStructures) {
        const absolutifiedRef = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_3__.absolutifyPointer)(ref, basePath);
        if (ref === absolutifiedRef) {
          // avoids endless looping
          // without this, the ref plugin never stops seeing this $ref
          return null;
        }
        return _index_js__WEBPACK_IMPORTED_MODULE_2__["default"].replace(fullPath, absolutifiedRef);
      }
    }
    if (basePath == null) {
      tokens = jsonPointerToArray(pointer);
      promOrVal = specmap.get(tokens);
      if (typeof promOrVal === 'undefined') {
        promOrVal = new JSONRefError(`Could not resolve reference: ${ref}`, {
          pointer,
          $ref: ref,
          baseDoc,
          fullPath
        });
      }
    } else {
      promOrVal = extractFromDoc(basePath, pointer);
      // eslint-disable-next-line no-underscore-dangle
      if (promOrVal.__value != null) {
        promOrVal = promOrVal.__value; // eslint-disable-line no-underscore-dangle
      } else {
        promOrVal = promOrVal.catch(e => {
          throw wrapError(e, {
            pointer,
            $ref: ref,
            baseDoc,
            fullPath
          });
        });
      }
    }
    if (promOrVal instanceof Error) {
      return [_index_js__WEBPACK_IMPORTED_MODULE_2__["default"].remove(fullPath), promOrVal];
    }
    const absolutifiedRef = (0,_helpers_js__WEBPACK_IMPORTED_MODULE_3__.absolutifyPointer)(ref, basePath);
    const patch = _index_js__WEBPACK_IMPORTED_MODULE_2__["default"].replace(parent, promOrVal, {
      $$ref: absolutifiedRef
    });
    if (basePath && basePath !== baseDoc) {
      return [patch, _index_js__WEBPACK_IMPORTED_MODULE_2__["default"].context(parent, {
        baseDoc: basePath
      })];
    }
    try {
      // prevents circular values from being constructed, unless we specifically
      // want that to happen
      if (!patchValueAlreadyInPath(specmap.state, patch) || specmapInstance.useCircularStructures) {
        return patch;
      }
    } catch (e) {
      // if we're catching here, path traversal failed, so we should
      // ditch without sending any patches back up.
      //
      // this is a narrow fix for the larger problem of patches being queued
      // and then having the state they were generated against be modified
      // before they are applied.
      //
      // TODO: re-engineer specmap patch/state management to avoid this
      return null;
    }
    return undefined;
  }
};
const mod = Object.assign(plugin, {
  docCache,
  absoluteify,
  clearCache,
  JSONRefError,
  wrapError,
  getDoc,
  split,
  extractFromDoc,
  fetchJSON,
  extract,
  jsonPointerToArray,
  unescapeJsonPointerToken
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mod);

// =========================
// Utilities
// =========================

/**
 * Resolves a path and its base to an abolute URL.
 * @api public
 */
function absoluteify(path, basePath) {
  if (!ABSOLUTE_URL_REGEXP.test(path)) {
    if (!basePath) {
      throw new JSONRefError(`Tried to resolve a relative URL, without having a basePath. path: '${path}' basePath: '${basePath}'`);
    }
    return _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(basePath, path);
  }
  return path;
}

/**
 * Wraps an error as JSONRefError.
 * @param  {Error} e      the error.
 * @param  {Object} extra (optional) optional data.
 * @return {Error}        an instance of JSONRefError.
 * @api public
 */
function wrapError(e, extra) {
  let message;
  if (e && e.response && e.response.body) {
    message = `${e.response.body.code} ${e.response.body.message}`;
  } else {
    message = e.message;
  }
  return new JSONRefError(`Could not resolve reference: ${message}`, {
    ...extra,
    cause: e
  });
}

/**
 * Splits a pointer by the hash delimiter.
 * @api public
 */
function split(ref) {
  return (ref + '').split('#'); // eslint-disable-line prefer-template
}

/**
 * Extracts a pointer from its document.
 * @param  {String} docPath the absolute document URL.
 * @param  {String} pointer the pointer whose value is to be extracted.
 * @return {Promise}        a promise of the pointer value.
 * @api public
 */
function extractFromDoc(docPath, pointer) {
  const doc = docCache[docPath];
  if (doc && !_index_js__WEBPACK_IMPORTED_MODULE_2__["default"].isPromise(doc)) {
    // If doc is already available, return __value together with the promise.
    // __value is for special handling in cycle check:
    // pointerAlreadyInPath() won't work if patch.value is a promise,
    // thus when that promise is finally resolved, cycle might happen (because
    // `spec` and `docCache[basePath]` refer to the exact same object).
    // See test "should resolve a cyclic spec when baseDoc is specified".
    try {
      const v = extract(pointer, doc);
      return Object.assign(Promise.resolve(v), {
        __value: v
      });
    } catch (e) {
      return Promise.reject(e);
    }
  }
  return getDoc(docPath).then(_doc => extract(pointer, _doc));
}

/**
 * Clears all document caches.
 * @param  {String} item (optional) the name of the cache item to be cleared.
 * @api public
 */
function clearCache(item) {
  if (typeof item !== 'undefined') {
    delete docCache[item];
  } else {
    Object.keys(docCache).forEach(key => {
      delete docCache[key];
    });
  }
}

/**
 * Fetches and caches a document.
 * @param  {String} docPath the absolute URL of the document.
 * @return {Promise}        a promise of the document content.
 * @api public
 */
function getDoc(docPath) {
  const val = docCache[docPath];
  if (val) {
    return _index_js__WEBPACK_IMPORTED_MODULE_2__["default"].isPromise(val) ? val : Promise.resolve(val);
  }

  // NOTE: we need to use `mod.fetchJSON` in order to be able to overwrite it.
  // Any tips on how to make this cleaner, please ping!
  docCache[docPath] = mod.fetchJSON(docPath).then(doc => {
    docCache[docPath] = doc;
    return doc;
  });
  return docCache[docPath];
}

/**
 * Fetches a document.
 * @param  {String} docPath the absolute URL of the document.
 * @return {Promise}        a promise of the document content.
 * @api public
 */
function fetchJSON(docPath) {
  return fetch(docPath, {
    headers: {
      Accept: _constants_js__WEBPACK_IMPORTED_MODULE_4__.ACCEPT_HEADER_VALUE_FOR_DOCUMENTS
    },
    loadSpec: true
  }).then(res => res.text()).then(text => js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(text));
}

/**
 * Extracts a pointer from an object.
 * @param  {String[]} pointer the JSON pointer.
 * @param  {Object} obj       an object whose value is to be extracted.
 * @return {Object}           the value to be extracted.
 * @api public
 */
function extract(pointer, obj) {
  const tokens = jsonPointerToArray(pointer);
  if (tokens.length < 1) {
    return obj;
  }
  const val = _index_js__WEBPACK_IMPORTED_MODULE_2__["default"].getIn(obj, tokens);
  if (typeof val === 'undefined') {
    throw new JSONRefError(`Could not resolve pointer: ${pointer} does not exist in document`, {
      pointer
    });
  }
  return val;
}

/**
 * Converts a JSON pointer to array.
 * @api public
 */
function jsonPointerToArray(pointer) {
  if (typeof pointer !== 'string') {
    throw new TypeError(`Expected a string, got a ${typeof pointer}`);
  }
  if (pointer[0] === '/') {
    pointer = pointer.substr(1);
  }
  if (pointer === '') {
    return [];
  }
  return pointer.split('/').map(unescapeJsonPointerToken);
}

/**
 * Unescapes a JSON pointer.
 * @api public
 */
function unescapeJsonPointerToken(token) {
  if (typeof token !== 'string') {
    return token;
  }
  const params = new URLSearchParams(`=${token.replace(/~1/g, '/').replace(/~0/g, '~')}`);
  return params.get('');
}

/**
 * Escapes a JSON pointer.
 * @api public
 */
function escapeJsonPointerToken(token) {
  const params = new URLSearchParams([['', token.replace(/~/g, '~0').replace(/\//g, '~1')]]);
  return params.toString().slice(1);
}
function arrayToJsonPointer(arr) {
  if (arr.length === 0) {
    return '';
  }
  return `/${arr.map(escapeJsonPointerToken).join('/')}`;
}
const pointerBoundaryChar = c => !c || c === '/' || c === '#';
function pointerIsAParent(pointer, parentPointer) {
  if (pointerBoundaryChar(parentPointer)) {
    // This is the root of the document, so its naturally a parent
    return true;
  }
  const nextChar = pointer.charAt(parentPointer.length);
  const lastParentChar = parentPointer.slice(-1);
  return pointer.indexOf(parentPointer) === 0 && (!nextChar || nextChar === '/' || nextChar === '#') && lastParentChar !== '#';
}

// =========================
// Private
// =========================

/**
 * Checks if this pointer points back to one or more pointers along the path.
 */
function pointerAlreadyInPath(pointer, basePath, parent, specmap) {
  let refs = specmapRefs.get(specmap);
  if (!refs) {
    // Stores all resolved references of a specmap instance.
    // Schema: path -> pointer (path's $ref value).
    refs = {};
    specmapRefs.set(specmap, refs);
  }
  const parentPointer = arrayToJsonPointer(parent);
  const fullyQualifiedPointer = `${basePath || '<specmap-base>'}#${pointer}`;

  // dirty hack to strip `allof/[index]` from the path, in order to avoid cases
  // where we get false negatives because:
  // - we resolve a path, then
  // - allOf plugin collapsed `allOf/[index]` out of the path, then
  // - we try to work on a child $ref within that collapsed path.
  //
  // because of the path collapse, we lose track of it in our specmapRefs hash
  // solution: always throw the allOf constructs out of paths we store
  // TODO: solve this with a global register, or by writing more metadata in
  // either allOf or refs plugin
  const safeParentPointer = parentPointer.replace(/allOf\/\d+\/?/g, '');

  // Case 1: direct cycle, e.g. a.b.c.$ref: '/a.b'
  // Detect by checking that the parent path doesn't start with pointer.
  // This only applies if the pointer is internal, i.e. basePath === rootPath (could be null)
  const rootDoc = specmap.contextTree.get([]).baseDoc;
  if (basePath === rootDoc && pointerIsAParent(safeParentPointer, pointer)) {
    // eslint-disable-line
    return true;
  }

  // Case 2: indirect cycle
  //  ex1: a.$ref: '/b'  &  b.c.$ref: '/b/c'
  //  ex2: a.$ref: '/b/c'  &  b.c.$ref: '/b'
  // Detect by retrieving all the $refs along the path of parent
  // and checking if any starts with pointer or vice versa.
  let currPath = '';
  const hasIndirectCycle = parent.some(token => {
    currPath = `${currPath}/${escapeJsonPointerToken(token)}`;
    return refs[currPath] && refs[currPath].some(ref => pointerIsAParent(ref, fullyQualifiedPointer) || pointerIsAParent(fullyQualifiedPointer, ref));
  });
  if (hasIndirectCycle) {
    return true;
  }

  // No cycle, this ref will be resolved, so stores it now for future detection.
  // No need to store if has cycle, as parent path is a dead-end and won't be checked again.

  refs[safeParentPointer] = (refs[safeParentPointer] || []).concat(fullyQualifiedPointer);
  return undefined;
}

/**
 * Checks if the value of this patch ends up pointing to an ancestor along the path.
 */
function patchValueAlreadyInPath(root, patch) {
  const ancestors = [root];
  patch.path.reduce((parent, p) => {
    ancestors.push(parent[p]);
    return parent[p];
  }, root);
  return pointToAncestor(patch.value);
  function pointToAncestor(obj) {
    return _index_js__WEBPACK_IMPORTED_MODULE_2__["default"].isObject(obj) && (ancestors.indexOf(obj) >= 0 || Object.keys(obj).some(k => pointToAncestor(obj[k])));
  }
}

/***/ }),

/***/ 52398:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   clearCache: () => (/* binding */ clearCache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27562);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12757);
/* harmony import */ var _specmap_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1704);



function clearCache() {
  _specmap_index_js__WEBPACK_IMPORTED_MODULE_1__.plugins.refs.clearCache();
}
const genericStrategy = {
  name: 'generic',
  match() {
    return true;
  },
  normalize(spec) {
    const {
      spec: normalized
    } = (0,_normalize_js__WEBPACK_IMPORTED_MODULE_2__["default"])({
      spec
    });
    return normalized;
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (genericStrategy);

/***/ }),

/***/ 12757:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ normalize)
/* harmony export */ });
/* harmony import */ var _helpers_op_id_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37896);

function normalize(parsedSpec) {
  const {
    spec
  } = parsedSpec;
  const {
    paths
  } = spec;
  const map = {};
  if (!paths || spec.$$normalized) {
    return parsedSpec;
  }

  // eslint-disable-next-line no-restricted-syntax, guard-for-in
  for (const pathName in paths) {
    const path = paths[pathName];
    if (path == null || !['object', 'function'].includes(typeof path)) {
      continue; // eslint-disable-line no-continue
    }
    const pathParameters = path.parameters;

    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const method in path) {
      const operation = path[method];
      if (operation == null || !['object', 'function'].includes(typeof operation)) {
        continue; // eslint-disable-line no-continue
      }
      const oid = (0,_helpers_op_id_js__WEBPACK_IMPORTED_MODULE_0__["default"])(operation, pathName, method);
      if (oid) {
        if (map[oid]) {
          map[oid].push(operation);
        } else {
          map[oid] = [operation];
        }
        const opList = map[oid];
        if (opList.length > 1) {
          opList.forEach((o, i) => {
            // eslint-disable-next-line no-underscore-dangle
            o.__originalOperationId = o.__originalOperationId || o.operationId;
            o.operationId = `${oid}${i + 1}`;
          });
        } else if (typeof operation.operationId !== 'undefined') {
          // Ensure we always add the normalized operation ID if one already exists
          // ( potentially different, given that we normalize our IDs)
          // ... _back_ to the spec. Otherwise, they might not line up
          const obj = opList[0];
          // eslint-disable-next-line no-underscore-dangle
          obj.__originalOperationId = obj.__originalOperationId || operation.operationId;
          obj.operationId = oid;
        }
      }
      if (method !== 'parameters') {
        // Add inherited consumes, produces, parameters, securities
        const inheritsList = [];
        const toBeInherit = {};

        // Global-levels
        // eslint-disable-next-line no-restricted-syntax
        for (const key in spec) {
          if (key === 'produces' || key === 'consumes' || key === 'security') {
            toBeInherit[key] = spec[key];
            inheritsList.push(toBeInherit);
          }
        }

        // Path-levels
        if (pathParameters) {
          toBeInherit.parameters = pathParameters;
          inheritsList.push(toBeInherit);
        }
        if (inheritsList.length) {
          // eslint-disable-next-line no-restricted-syntax
          for (const inherits of inheritsList) {
            // eslint-disable-next-line no-restricted-syntax
            for (const inheritName in inherits) {
              if (!operation[inheritName]) {
                operation[inheritName] = inherits[inheritName];
              } else if (inheritName === 'parameters') {
                // eslint-disable-next-line no-restricted-syntax
                for (const param of inherits[inheritName]) {
                  const exists = operation[inheritName].some(opParam => opParam.name && opParam.name === param.name || opParam.$ref && opParam.$ref === param.$ref || opParam.$$ref && opParam.$$ref === param.$$ref || opParam === param);
                  if (!exists) {
                    operation[inheritName].push(param);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  spec.$$normalized = true;
  return parsedSpec;
}

/***/ }),

/***/ 27562:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ resolveGenericStrategy)
/* harmony export */ });
/* harmony import */ var _specmap_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1704);
/* harmony import */ var _utils_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34242);
/* harmony import */ var _utils_options_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40428);



async function resolveGenericStrategy(options) {
  const {
    spec,
    mode,
    allowMetaPatches = true,
    pathDiscriminator,
    modelPropertyMacro,
    parameterMacro,
    requestInterceptor,
    responseInterceptor,
    skipNormalization = false,
    useCircularStructures,
    strategies
  } = options;
  const retrievalURI = _utils_options_js__WEBPACK_IMPORTED_MODULE_2__.retrievalURI(options);
  const httpClient = _utils_options_js__WEBPACK_IMPORTED_MODULE_2__.httpClient(options);
  const strategy = strategies.find(strg => strg.match(spec));
  return doResolve(spec);
  async function doResolve(_spec) {
    if (retrievalURI) {
      _specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.refs.docCache[retrievalURI] = _spec;
    }

    // Build a json-fetcher ( ie: give it a URL and get json out )
    _specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.refs.fetchJSON = (0,_utils_index_js__WEBPACK_IMPORTED_MODULE_1__.makeFetchJSON)(httpClient, {
      requestInterceptor,
      responseInterceptor
    });
    const plugs = [_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.refs];
    if (typeof parameterMacro === 'function') {
      plugs.push(_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.parameters);
    }
    if (typeof modelPropertyMacro === 'function') {
      plugs.push(_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.properties);
    }
    if (mode !== 'strict') {
      plugs.push(_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.allOf);
    }

    // mapSpec is where the hard work happens
    const result = await (0,_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
      spec: _spec,
      context: {
        baseDoc: retrievalURI
      },
      plugins: plugs,
      allowMetaPatches,
      // allows adding .meta patches, which include adding `$$ref`s to the spec
      pathDiscriminator,
      // for lazy resolution
      parameterMacro,
      modelPropertyMacro,
      useCircularStructures
    });
    if (!skipNormalization) {
      result.spec = strategy.normalize(result.spec);
    }
    return result;
  }
}

/***/ }),

/***/ 19096:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   clearCache: () => (/* reexport safe */ _generic_index_js__WEBPACK_IMPORTED_MODULE_1__.clearCache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(70240);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12757);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50918);
/* harmony import */ var _generic_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52398);




const openApi2Strategy = {
  name: 'openapi-2',
  match(spec) {
    return (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__.isOpenAPI2)(spec);
  },
  normalize(spec) {
    const {
      spec: normalized
    } = (0,_normalize_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      spec
    });
    return normalized;
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi2Strategy);

/***/ }),

/***/ 70240:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ resolveOpenAPI2Strategy)
/* harmony export */ });
/* harmony import */ var _generic_resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27562);

async function resolveOpenAPI2Strategy(options) {
  return (0,_generic_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
}

/***/ }),

/***/ 730:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   clearCache: () => (/* reexport safe */ _generic_index_js__WEBPACK_IMPORTED_MODULE_1__.clearCache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(40278);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12757);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50918);
/* harmony import */ var _generic_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52398);




const openApi30Strategy = {
  name: 'openapi-3-0',
  match(spec) {
    return (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__.isOpenAPI30)(spec);
  },
  normalize(spec) {
    const {
      spec: normalized
    } = (0,_normalize_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      spec
    });
    return normalized;
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi30Strategy);

/***/ }),

/***/ 40278:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ resolveOpenAPI30Strategy)
/* harmony export */ });
/* harmony import */ var _generic_resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27562);

async function resolveOpenAPI30Strategy(options) {
  return (0,_generic_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
}

/***/ }),

/***/ 38592:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(24955);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33501);
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33272);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80947);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50918);





const openApi31ApiDOMStrategy = {
  name: 'openapi-3-1-apidom',
  match(spec) {
    return (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__.isOpenAPI31)(spec);
  },
  normalize(spec) {
    // pre-normalization - happens only once before the first lazy dereferencing and in JavaScript context
    if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isElement)(spec) && (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(spec) && !spec.$$normalized) {
      const preNormalized = (0,_normalize_js__WEBPACK_IMPORTED_MODULE_1__.pojoAdapter)(_normalize_js__WEBPACK_IMPORTED_MODULE_1__["default"])(spec);
      preNormalized.$$normalized = true;
      return preNormalized;
    }
    // post-normalization - happens after each dereferencing and in ApiDOM context
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isElement)(spec)) {
      return (0,_normalize_js__WEBPACK_IMPORTED_MODULE_1__["default"])(spec);
    }
    return spec;
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi31ApiDOMStrategy);

/***/ }),

/***/ 80947:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   pojoAdapter: () => (/* binding */ pojoAdapter)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(15922);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(9999);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3295);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91247);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(59038);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(26876);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(65389);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(89643);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(66648);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(3117);
/* harmony import */ var _helpers_op_id_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37896);
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33272);
/* eslint-disable camelcase */




const normalize = element => {
  if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(element)) return element;
  const plugins = [(0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__["default"])({
    operationIdNormalizer: (operationId, path, method) => (0,_helpers_op_id_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      operationId
    }, path, method, {
      v2OperationIdCompatibilityMode: false
    })
  }), (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__["default"])(), (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__["default"])(), (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_6__["default"])(), (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_7__["default"])()];
  const normalized = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__.dispatchPluginsSync)(element, plugins, {
    toolboxCreator: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__["default"],
    visitorOptions: {
      keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.keyMap,
      nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.getNodeType
    }
  });
  return normalized;
};

/**
 * This adapter allow to perform normalization on Plain Old JavaScript Objects.
 * The function adapts the `normalize` function interface and is able to accept
 * Plain Old JavaScript Objects and returns Plain Old JavaScript Objects.
 */
const pojoAdapter = normalizeFn => spec => {
  const openApiElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__.OpenApi3_1Element.refract(spec);
  openApiElement.classes.push('result');
  const normalized = normalizeFn(openApiElement);
  const value = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_12__["default"])(normalized);

  /**
   * We're setting the cache here to avoid repeated refracting
   * in `openapi-3-1-apidom` strategy resolve method.
   */
  _resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"].cache.set(value, normalized);
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_12__["default"])(normalized);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (normalize);
/* eslint-enable camelcase */

/***/ }),

/***/ 33272:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   circularReplacer: () => (/* binding */ circularReplacer),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(9999);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(65342);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(60672);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(18316);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(60489);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(64884);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(3117);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(94145);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(83748);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(12349);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(31387);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(71614);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(48097);
/* harmony import */ var _swagger_api_apidom_reference_parse_parsers_binary__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(16960);
/* harmony import */ var _swagger_api_apidom_reference_resolve_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(47724);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3832);
/* harmony import */ var _utils_options_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40428);
/* harmony import */ var _apidom_reference_resolve_resolvers_http_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(636);
/* harmony import */ var _apidom_reference_parse_parsers_json_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(92263);
/* harmony import */ var _apidom_reference_parse_parsers_yaml_1_2_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12787);
/* harmony import */ var _apidom_reference_parse_parsers_openapi_json_3_1_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(89742);
/* harmony import */ var _apidom_reference_parse_parsers_openapi_yaml_3_1_index_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49575);
/* harmony import */ var _apidom_reference_dereference_strategies_openapi_3_1_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(13764);
/* eslint-disable camelcase */














const circularReplacer = refElement => {
  const $refBaseURI = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__["default"])(refElement.meta.get('baseURI'));
  const referencingElement = refElement.meta.get('referencingElement');

  /**
   * Removing semantics from the absolutified referencing element by
   * using generic ObjectElement to represent the reference.
   */
  return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.ObjectElement({
    $ref: $refBaseURI
  }, (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__.cloneDeep)(referencingElement.meta), (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__.cloneDeep)(referencingElement.attributes));
};
const resolveOpenAPI31Strategy = async options => {
  const {
    spec,
    timeout,
    redirects,
    requestInterceptor,
    responseInterceptor,
    pathDiscriminator = [],
    allowMetaPatches = false,
    useCircularStructures = false,
    skipNormalization = false,
    parameterMacro = null,
    modelPropertyMacro = null,
    mode = 'non-strict',
    strategies
  } = options;
  try {
    const {
      cache
    } = resolveOpenAPI31Strategy;
    const strategy = strategies.find(strg => strg.match(spec));

    // determining BaseURI
    const cwd = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__.isHttpUrl(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__.cwd()) ? _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__.cwd() : _constants_js__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_BASE_URL;
    const retrievalURI = _utils_options_js__WEBPACK_IMPORTED_MODULE_1__.retrievalURI(options);
    const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__.resolve(cwd, retrievalURI);

    // prepare spec for dereferencing
    let openApiElement;
    if (cache.has(spec)) {
      openApiElement = cache.get(spec);
    } else {
      openApiElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__.OpenApi3_1Element.refract(spec);
      openApiElement.classes.push('result');
      cache.set(spec, openApiElement);
    }
    const openApiParseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.ParseResultElement([openApiElement]);

    // prepare fragment for dereferencing
    const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_13__["default"])(pathDiscriminator);
    const jsonPointerURI = jsonPointer === '' ? '' : `#${jsonPointer}`;
    const fragmentElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_14__["default"])(jsonPointer, openApiElement);

    // prepare reference set for dereferencing
    const openApiElementReference = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_15__["default"]({
      uri: baseURI,
      value: openApiParseResultElement
    });
    const refSet = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_16__["default"]({
      refs: [openApiElementReference]
    });
    if (jsonPointer !== '') refSet.rootRef = undefined; // reset root reference as we want fragment to become the root reference

    // prepare ancestors; needed for cases where fragment is not OpenAPI element
    const ancestors = [new Set([fragmentElement])];
    const errors = [];
    const dereferenced = await (0,_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_17__.dereferenceApiDOM)(fragmentElement, {
      resolve: {
        /**
         * swagger-client only supports resolving HTTP(S) URLs or spec objects.
         * If runtime env is detected as non-browser one,
         * and baseURI was not provided as part of resolver options,
         * then below baseURI check will make sure that constant HTTPS URL is used as baseURI.
         */
        baseURI: `${baseURI}${jsonPointerURI}`,
        resolvers: [new _apidom_reference_resolve_resolvers_http_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_2__["default"]({
          timeout: timeout || 10000,
          redirects: redirects || 10
        })],
        resolverOpts: {
          swaggerHTTPClientConfig: {
            requestInterceptor,
            responseInterceptor
          }
        },
        strategies: [new _swagger_api_apidom_reference_resolve_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__["default"]()]
      },
      parse: {
        mediaType: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__["default"].latest(),
        parsers: [new _apidom_reference_parse_parsers_openapi_json_3_1_index_js__WEBPACK_IMPORTED_MODULE_5__["default"]({
          allowEmpty: false,
          sourceMap: false
        }), new _apidom_reference_parse_parsers_openapi_yaml_3_1_index_js__WEBPACK_IMPORTED_MODULE_6__["default"]({
          allowEmpty: false,
          sourceMap: false
        }), new _apidom_reference_parse_parsers_json_index_js__WEBPACK_IMPORTED_MODULE_3__["default"]({
          allowEmpty: false,
          sourceMap: false
        }), new _apidom_reference_parse_parsers_yaml_1_2_index_js__WEBPACK_IMPORTED_MODULE_4__["default"]({
          allowEmpty: false,
          sourceMap: false
        }), new _swagger_api_apidom_reference_parse_parsers_binary__WEBPACK_IMPORTED_MODULE_20__["default"]({
          allowEmpty: false,
          sourceMap: false
        })]
      },
      dereference: {
        maxDepth: 100,
        strategies: [new _apidom_reference_dereference_strategies_openapi_3_1_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_7__["default"]({
          allowMetaPatches,
          useCircularStructures,
          parameterMacro,
          modelPropertyMacro,
          mode,
          ancestors
        })],
        refSet,
        dereferenceOpts: {
          errors
        },
        immutable: false,
        circular: useCircularStructures ? 'ignore' : 'replace',
        circularReplacer: useCircularStructures ? _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_21__["default"].dereference.circularReplacer : circularReplacer
      }
    });
    const transcluded = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_22__.transclude)(fragmentElement, dereferenced, openApiElement);
    const normalized = skipNormalization ? transcluded : strategy.normalize(transcluded);
    return {
      spec: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__["default"])(normalized),
      errors
    };
  } catch (error) {
    if (error instanceof _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_23__["default"] || error instanceof _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_24__["default"]) {
      return {
        spec: null,
        errors: []
      };
    }
    throw error;
  }
};
resolveOpenAPI31Strategy.cache = new WeakMap();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (resolveOpenAPI31Strategy);
/* eslint-enable camelcase */

/***/ }),

/***/ 34242:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   makeFetchJSON: () => (/* binding */ makeFetchJSON)
/* harmony export */ });
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3832);


// eslint-disable-next-line import/prefer-default-export
function makeFetchJSON(http, opts = {}) {
  const {
    requestInterceptor,
    responseInterceptor
  } = opts;
  // Set credentials with 'http.withCredentials' value
  const credentials = http.withCredentials ? 'include' : 'same-origin';
  return docPath => http({
    url: docPath,
    loadSpec: true,
    requestInterceptor,
    responseInterceptor,
    headers: {
      Accept: _constants_js__WEBPACK_IMPORTED_MODULE_0__.ACCEPT_HEADER_VALUE_FOR_DOCUMENTS
    },
    credentials
  }).then(res => res.body);
}

/***/ }),

/***/ 40428:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   httpClient: () => (/* binding */ httpClient),
/* harmony export */   retrievalURI: () => (/* binding */ retrievalURI)
/* harmony export */ });
/* harmony import */ var _http_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(51670);

const retrievalURI = options => {
  /**
   * Swagger-UI uses baseDoc instead of url, this helper function exists
   * to allow both.
   *
   * In browser environment, we allow to pass a relative URI Reference,
   * and we resolve it against the document's baseURI before passing it deeper
   * to swagger-client code.
   */
  const {
    baseDoc,
    url
  } = options;
  const retrievalURL = baseDoc ?? url ?? '';
  return typeof globalThis.document?.baseURI === 'string' ? String(new URL(retrievalURL, globalThis.document.baseURI)) : retrievalURL;
};
const httpClient = options => {
  const {
    fetch,
    http
  } = options;

  // @TODO fetch should be removed, and http used instead
  // provide a default fetch implementation
  return fetch || http || _http_index_js__WEBPACK_IMPORTED_MODULE_0__["default"];
};

/***/ }),

/***/ 4569:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   makeResolveSubtree: () => (/* binding */ makeResolveSubtree)
/* harmony export */ });
/* harmony import */ var _resolver_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92272);
/* harmony import */ var _resolver_strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52398);
/* harmony import */ var _resolver_strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19096);
/* harmony import */ var _resolver_strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(730);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(50918);
// The subtree resolver is a higher-level interface that allows you to
// get the same result that you would from `Swagger.resolve`, but focuses on
// a subtree of your object.
//
// It makes several assumptions that allow you to think less about what resolve,
// specmap, and normalizeSwagger are doing: if this is not suitable for you,
// you can emulate `resolveSubtree`'s behavior by talking to the traditional
// resolver directly.
//
// By providing a top-level `obj` and a `path` to resolve within, the subtree
// at `path` will be resolved and normalized in the context of your top-level
// `obj`. You'll get the resolved subtree you're interest in as a return value
// (or, you can use `returnEntireTree` to get everything back).
//
// This is useful for cases where resolving your entire object is unnecessary
// and/or non-performant; we use this interface for lazily resolving operations
// and models in Swagger-UI, which allows us to handle larger definitions.
//
// It's likely that Swagger-Client will rely entirely on lazy resolving in
// future versions.
//
// TODO: move the remarks above into project documentation





const resolveSubtree = async (obj, path, options = {}) => {
  const {
    returnEntireTree,
    baseDoc,
    requestInterceptor,
    responseInterceptor,
    parameterMacro,
    modelPropertyMacro,
    useCircularStructures,
    strategies
  } = options;
  const resolveOptions = {
    spec: obj,
    pathDiscriminator: path,
    baseDoc,
    requestInterceptor,
    responseInterceptor,
    parameterMacro,
    modelPropertyMacro,
    useCircularStructures,
    strategies
  };
  const strategy = strategies.find(strg => strg.match(obj));
  const normalized = strategy.normalize(obj);
  const result = await (0,_resolver_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    spec: normalized,
    ...resolveOptions,
    allowMetaPatches: true,
    skipNormalization: !(0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_4__.isOpenAPI31)(obj)
  });
  if (!returnEntireTree && Array.isArray(path) && path.length) {
    result.spec = path.reduce((acc, pathSegment) => acc?.[pathSegment], result.spec) || null;
  }
  return result;
};
const makeResolveSubtree = defaultOptions => async (obj, path, options = {}) => {
  const mergedOptions = {
    ...defaultOptions,
    ...options
  };
  return resolveSubtree(obj, path, mergedOptions);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (makeResolveSubtree({
  strategies: [_resolver_strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_3__["default"], _resolver_strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_2__["default"], _resolver_strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_1__["default"]]
}));

/***/ }),

/***/ 57427:
/***/ ((__unused_webpack_module, exports) => {

"use strict";
/*!
 * cookie
 * Copyright(c) 2012-2014 Roman Shtylman
 * Copyright(c) 2015 Douglas Christopher Wilson
 * MIT Licensed
 */



/**
 * Module exports.
 * @public
 */

exports.parse = parse;
exports.serialize = serialize;

/**
 * Module variables.
 * @private
 */

var __toString = Object.prototype.toString
var __hasOwnProperty = Object.prototype.hasOwnProperty

/**
 * RegExp to match cookie-name in RFC 6265 sec 4.1.1
 * This refers out to the obsoleted definition of token in RFC 2616 sec 2.2
 * which has been replaced by the token definition in RFC 7230 appendix B.
 *
 * cookie-name       = token
 * token             = 1*tchar
 * tchar             = "!" / "#" / "$" / "%" / "&" / "'" /
 *                     "*" / "+" / "-" / "." / "^" / "_" /
 *                     "`" / "|" / "~" / DIGIT / ALPHA
 */

var cookieNameRegExp = /^[!#$%&'*+\-.^_`|~0-9A-Za-z]+$/;

/**
 * RegExp to match cookie-value in RFC 6265 sec 4.1.1
 *
 * cookie-value      = *cookie-octet / ( DQUOTE *cookie-octet DQUOTE )
 * cookie-octet      = %x21 / %x23-2B / %x2D-3A / %x3C-5B / %x5D-7E
 *                     ; US-ASCII characters excluding CTLs,
 *                     ; whitespace DQUOTE, comma, semicolon,
 *                     ; and backslash
 */

var cookieValueRegExp = /^("?)[\u0021\u0023-\u002B\u002D-\u003A\u003C-\u005B\u005D-\u007E]*\1$/;

/**
 * RegExp to match domain-value in RFC 6265 sec 4.1.1
 *
 * domain-value      = <subdomain>
 *                     ; defined in [RFC1034], Section 3.5, as
 *                     ; enhanced by [RFC1123], Section 2.1
 * <subdomain>       = <label> | <subdomain> "." <label>
 * <label>           = <let-dig> [ [ <ldh-str> ] <let-dig> ]
 *                     Labels must be 63 characters or less.
 *                     'let-dig' not 'letter' in the first char, per RFC1123
 * <ldh-str>         = <let-dig-hyp> | <let-dig-hyp> <ldh-str>
 * <let-dig-hyp>     = <let-dig> | "-"
 * <let-dig>         = <letter> | <digit>
 * <letter>          = any one of the 52 alphabetic characters A through Z in
 *                     upper case and a through z in lower case
 * <digit>           = any one of the ten digits 0 through 9
 *
 * Keep support for leading dot: https://github.com/jshttp/cookie/issues/173
 *
 * > (Note that a leading %x2E ("."), if present, is ignored even though that
 * character is not permitted, but a trailing %x2E ("."), if present, will
 * cause the user agent to ignore the attribute.)
 */

var domainValueRegExp = /^([.]?[a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?)([.][a-z0-9]([a-z0-9-]{0,61}[a-z0-9])?)*$/i;

/**
 * RegExp to match path-value in RFC 6265 sec 4.1.1
 *
 * path-value        = <any CHAR except CTLs or ";">
 * CHAR              = %x01-7F
 *                     ; defined in RFC 5234 appendix B.1
 */

var pathValueRegExp = /^[\u0020-\u003A\u003D-\u007E]*$/;

/**
 * Parse a cookie header.
 *
 * Parse the given cookie header string into an object
 * The object has the various cookies as keys(names) => values
 *
 * @param {string} str
 * @param {object} [opt]
 * @return {object}
 * @public
 */

function parse(str, opt) {
  if (typeof str !== 'string') {
    throw new TypeError('argument str must be a string');
  }

  var obj = {};
  var len = str.length;
  // RFC 6265 sec 4.1.1, RFC 2616 2.2 defines a cookie name consists of one char minimum, plus '='.
  if (len < 2) return obj;

  var dec = (opt && opt.decode) || decode;
  var index = 0;
  var eqIdx = 0;
  var endIdx = 0;

  do {
    eqIdx = str.indexOf('=', index);
    if (eqIdx === -1) break; // No more cookie pairs.

    endIdx = str.indexOf(';', index);

    if (endIdx === -1) {
      endIdx = len;
    } else if (eqIdx > endIdx) {
      // backtrack on prior semicolon
      index = str.lastIndexOf(';', eqIdx - 1) + 1;
      continue;
    }

    var keyStartIdx = startIndex(str, index, eqIdx);
    var keyEndIdx = endIndex(str, eqIdx, keyStartIdx);
    var key = str.slice(keyStartIdx, keyEndIdx);

    // only assign once
    if (!__hasOwnProperty.call(obj, key)) {
      var valStartIdx = startIndex(str, eqIdx + 1, endIdx);
      var valEndIdx = endIndex(str, endIdx, valStartIdx);

      if (str.charCodeAt(valStartIdx) === 0x22 /* " */ && str.charCodeAt(valEndIdx - 1) === 0x22 /* " */) {
        valStartIdx++;
        valEndIdx--;
      }

      var val = str.slice(valStartIdx, valEndIdx);
      obj[key] = tryDecode(val, dec);
    }

    index = endIdx + 1
  } while (index < len);

  return obj;
}

function startIndex(str, index, max) {
  do {
    var code = str.charCodeAt(index);
    if (code !== 0x20 /*   */ && code !== 0x09 /* \t */) return index;
  } while (++index < max);
  return max;
}

function endIndex(str, index, min) {
  while (index > min) {
    var code = str.charCodeAt(--index);
    if (code !== 0x20 /*   */ && code !== 0x09 /* \t */) return index + 1;
  }
  return min;
}

/**
 * Serialize data into a cookie header.
 *
 * Serialize a name value pair into a cookie string suitable for
 * http headers. An optional options object specifies cookie parameters.
 *
 * serialize('foo', 'bar', { httpOnly: true })
 *   => "foo=bar; httpOnly"
 *
 * @param {string} name
 * @param {string} val
 * @param {object} [opt]
 * @return {string}
 * @public
 */

function serialize(name, val, opt) {
  var enc = (opt && opt.encode) || encodeURIComponent;

  if (typeof enc !== 'function') {
    throw new TypeError('option encode is invalid');
  }

  if (!cookieNameRegExp.test(name)) {
    throw new TypeError('argument name is invalid');
  }

  var value = enc(val);

  if (!cookieValueRegExp.test(value)) {
    throw new TypeError('argument val is invalid');
  }

  var str = name + '=' + value;
  if (!opt) return str;

  if (null != opt.maxAge) {
    var maxAge = Math.floor(opt.maxAge);

    if (!isFinite(maxAge)) {
      throw new TypeError('option maxAge is invalid')
    }

    str += '; Max-Age=' + maxAge;
  }

  if (opt.domain) {
    if (!domainValueRegExp.test(opt.domain)) {
      throw new TypeError('option domain is invalid');
    }

    str += '; Domain=' + opt.domain;
  }

  if (opt.path) {
    if (!pathValueRegExp.test(opt.path)) {
      throw new TypeError('option path is invalid');
    }

    str += '; Path=' + opt.path;
  }

  if (opt.expires) {
    var expires = opt.expires

    if (!isDate(expires) || isNaN(expires.valueOf())) {
      throw new TypeError('option expires is invalid');
    }

    str += '; Expires=' + expires.toUTCString()
  }

  if (opt.httpOnly) {
    str += '; HttpOnly';
  }

  if (opt.secure) {
    str += '; Secure';
  }

  if (opt.partitioned) {
    str += '; Partitioned'
  }

  if (opt.priority) {
    var priority = typeof opt.priority === 'string'
      ? opt.priority.toLowerCase() : opt.priority;

    switch (priority) {
      case 'low':
        str += '; Priority=Low'
        break
      case 'medium':
        str += '; Priority=Medium'
        break
      case 'high':
        str += '; Priority=High'
        break
      default:
        throw new TypeError('option priority is invalid')
    }
  }

  if (opt.sameSite) {
    var sameSite = typeof opt.sameSite === 'string'
      ? opt.sameSite.toLowerCase() : opt.sameSite;

    switch (sameSite) {
      case true:
        str += '; SameSite=Strict';
        break;
      case 'lax':
        str += '; SameSite=Lax';
        break;
      case 'strict':
        str += '; SameSite=Strict';
        break;
      case 'none':
        str += '; SameSite=None';
        break;
      default:
        throw new TypeError('option sameSite is invalid');
    }
  }

  return str;
}

/**
 * URL-decode string value. Optimized to skip native call when no %.
 *
 * @param {string} str
 * @returns {string}
 */

function decode (str) {
  return str.indexOf('%') !== -1
    ? decodeURIComponent(str)
    : str
}

/**
 * Determine if value is a Date.
 *
 * @param {*} val
 * @private
 */

function isDate (val) {
  return __toString.call(val) === '[object Date]';
}

/**
 * Try decoding a string using a decoding function.
 *
 * @param {string} str
 * @param {function} decode
 * @private
 */

function tryDecode(str, decode) {
  try {
    return decode(str);
  } catch (e) {
    return str;
  }
}


/***/ }),

/***/ 14744:
/***/ ((module) => {

"use strict";


var isMergeableObject = function isMergeableObject(value) {
	return isNonNullObject(value)
		&& !isSpecial(value)
};

function isNonNullObject(value) {
	return !!value && typeof value === 'object'
}

function isSpecial(value) {
	var stringValue = Object.prototype.toString.call(value);

	return stringValue === '[object RegExp]'
		|| stringValue === '[object Date]'
		|| isReactElement(value)
}

// see https://github.com/facebook/react/blob/b5ac963fb791d1298e7f396236383bc955f916c1/src/isomorphic/classic/element/ReactElement.js#L21-L25
var canUseSymbol = typeof Symbol === 'function' && Symbol.for;
var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for('react.element') : 0xeac7;

function isReactElement(value) {
	return value.$$typeof === REACT_ELEMENT_TYPE
}

function emptyTarget(val) {
	return Array.isArray(val) ? [] : {}
}

function cloneUnlessOtherwiseSpecified(value, options) {
	return (options.clone !== false && options.isMergeableObject(value))
		? deepmerge(emptyTarget(value), value, options)
		: value
}

function defaultArrayMerge(target, source, options) {
	return target.concat(source).map(function(element) {
		return cloneUnlessOtherwiseSpecified(element, options)
	})
}

function getMergeFunction(key, options) {
	if (!options.customMerge) {
		return deepmerge
	}
	var customMerge = options.customMerge(key);
	return typeof customMerge === 'function' ? customMerge : deepmerge
}

function getEnumerableOwnPropertySymbols(target) {
	return Object.getOwnPropertySymbols
		? Object.getOwnPropertySymbols(target).filter(function(symbol) {
			return Object.propertyIsEnumerable.call(target, symbol)
		})
		: []
}

function getKeys(target) {
	return Object.keys(target).concat(getEnumerableOwnPropertySymbols(target))
}

function propertyIsOnObject(object, property) {
	try {
		return property in object
	} catch(_) {
		return false
	}
}

// Protects from prototype poisoning and unexpected merging up the prototype chain.
function propertyIsUnsafe(target, key) {
	return propertyIsOnObject(target, key) // Properties are safe to merge if they don't exist in the target yet,
		&& !(Object.hasOwnProperty.call(target, key) // unsafe if they exist up the prototype chain,
			&& Object.propertyIsEnumerable.call(target, key)) // and also unsafe if they're nonenumerable.
}

function mergeObject(target, source, options) {
	var destination = {};
	if (options.isMergeableObject(target)) {
		getKeys(target).forEach(function(key) {
			destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
		});
	}
	getKeys(source).forEach(function(key) {
		if (propertyIsUnsafe(target, key)) {
			return
		}

		if (propertyIsOnObject(target, key) && options.isMergeableObject(source[key])) {
			destination[key] = getMergeFunction(key, options)(target[key], source[key], options);
		} else {
			destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
		}
	});
	return destination
}

function deepmerge(target, source, options) {
	options = options || {};
	options.arrayMerge = options.arrayMerge || defaultArrayMerge;
	options.isMergeableObject = options.isMergeableObject || isMergeableObject;
	// cloneUnlessOtherwiseSpecified is added to `options` so that custom arrayMerge()
	// implementations can use it. The caller may not replace it.
	options.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;

	var sourceIsArray = Array.isArray(source);
	var targetIsArray = Array.isArray(target);
	var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;

	if (!sourceAndTargetTypesMatch) {
		return cloneUnlessOtherwiseSpecified(source, options)
	} else if (sourceIsArray) {
		return options.arrayMerge(target, source, options)
	} else {
		return mergeObject(target, source, options)
	}
}

deepmerge.all = function deepmergeAll(array, options) {
	if (!Array.isArray(array)) {
		throw new Error('first argument should be an array')
	}

	return array.reduce(function(prev, next) {
		return deepmerge(prev, next, options)
	}, {})
};

var deepmerge_1 = deepmerge;

module.exports = deepmerge_1;


/***/ }),

/***/ 55580:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(56110),
    root = __webpack_require__(9325);

/* Built-in method references that are verified to be native. */
var DataView = getNative(root, 'DataView');

module.exports = DataView;


/***/ }),

/***/ 21549:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var hashClear = __webpack_require__(22032),
    hashDelete = __webpack_require__(63862),
    hashGet = __webpack_require__(66721),
    hashHas = __webpack_require__(12749),
    hashSet = __webpack_require__(35749);

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

module.exports = Hash;


/***/ }),

/***/ 80079:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var listCacheClear = __webpack_require__(63702),
    listCacheDelete = __webpack_require__(70080),
    listCacheGet = __webpack_require__(24739),
    listCacheHas = __webpack_require__(48655),
    listCacheSet = __webpack_require__(31175);

/**
 * Creates an list cache object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function ListCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `ListCache`.
ListCache.prototype.clear = listCacheClear;
ListCache.prototype['delete'] = listCacheDelete;
ListCache.prototype.get = listCacheGet;
ListCache.prototype.has = listCacheHas;
ListCache.prototype.set = listCacheSet;

module.exports = ListCache;


/***/ }),

/***/ 68223:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(56110),
    root = __webpack_require__(9325);

/* Built-in method references that are verified to be native. */
var Map = getNative(root, 'Map');

module.exports = Map;


/***/ }),

/***/ 53661:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var mapCacheClear = __webpack_require__(63040),
    mapCacheDelete = __webpack_require__(17670),
    mapCacheGet = __webpack_require__(90289),
    mapCacheHas = __webpack_require__(4509),
    mapCacheSet = __webpack_require__(72949);

/**
 * Creates a map cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function MapCache(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `MapCache`.
MapCache.prototype.clear = mapCacheClear;
MapCache.prototype['delete'] = mapCacheDelete;
MapCache.prototype.get = mapCacheGet;
MapCache.prototype.has = mapCacheHas;
MapCache.prototype.set = mapCacheSet;

module.exports = MapCache;


/***/ }),

/***/ 32804:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(56110),
    root = __webpack_require__(9325);

/* Built-in method references that are verified to be native. */
var Promise = getNative(root, 'Promise');

module.exports = Promise;


/***/ }),

/***/ 76545:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(56110),
    root = __webpack_require__(9325);

/* Built-in method references that are verified to be native. */
var Set = getNative(root, 'Set');

module.exports = Set;


/***/ }),

/***/ 38859:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var MapCache = __webpack_require__(53661),
    setCacheAdd = __webpack_require__(31380),
    setCacheHas = __webpack_require__(51459);

/**
 *
 * Creates an array cache object to store unique values.
 *
 * @private
 * @constructor
 * @param {Array} [values] The values to cache.
 */
function SetCache(values) {
  var index = -1,
      length = values == null ? 0 : values.length;

  this.__data__ = new MapCache;
  while (++index < length) {
    this.add(values[index]);
  }
}

// Add methods to `SetCache`.
SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
SetCache.prototype.has = setCacheHas;

module.exports = SetCache;


/***/ }),

/***/ 37217:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ListCache = __webpack_require__(80079),
    stackClear = __webpack_require__(51420),
    stackDelete = __webpack_require__(90938),
    stackGet = __webpack_require__(63605),
    stackHas = __webpack_require__(29817),
    stackSet = __webpack_require__(80945);

/**
 * Creates a stack cache object to store key-value pairs.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Stack(entries) {
  var data = this.__data__ = new ListCache(entries);
  this.size = data.size;
}

// Add methods to `Stack`.
Stack.prototype.clear = stackClear;
Stack.prototype['delete'] = stackDelete;
Stack.prototype.get = stackGet;
Stack.prototype.has = stackHas;
Stack.prototype.set = stackSet;

module.exports = Stack;


/***/ }),

/***/ 51873:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(9325);

/** Built-in value references. */
var Symbol = root.Symbol;

module.exports = Symbol;


/***/ }),

/***/ 37828:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(9325);

/** Built-in value references. */
var Uint8Array = root.Uint8Array;

module.exports = Uint8Array;


/***/ }),

/***/ 28303:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(56110),
    root = __webpack_require__(9325);

/* Built-in method references that are verified to be native. */
var WeakMap = getNative(root, 'WeakMap');

module.exports = WeakMap;


/***/ }),

/***/ 79770:
/***/ ((module) => {

/**
 * A specialized version of `_.filter` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {Array} Returns the new filtered array.
 */
function arrayFilter(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length,
      resIndex = 0,
      result = [];

  while (++index < length) {
    var value = array[index];
    if (predicate(value, index, array)) {
      result[resIndex++] = value;
    }
  }
  return result;
}

module.exports = arrayFilter;


/***/ }),

/***/ 70695:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseTimes = __webpack_require__(78096),
    isArguments = __webpack_require__(72428),
    isArray = __webpack_require__(56449),
    isBuffer = __webpack_require__(3656),
    isIndex = __webpack_require__(30361),
    isTypedArray = __webpack_require__(37167);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Creates an array of the enumerable property names of the array-like `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @param {boolean} inherited Specify returning inherited property names.
 * @returns {Array} Returns the array of property names.
 */
function arrayLikeKeys(value, inherited) {
  var isArr = isArray(value),
      isArg = !isArr && isArguments(value),
      isBuff = !isArr && !isArg && isBuffer(value),
      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
      skipIndexes = isArr || isArg || isBuff || isType,
      result = skipIndexes ? baseTimes(value.length, String) : [],
      length = result.length;

  for (var key in value) {
    if ((inherited || hasOwnProperty.call(value, key)) &&
        !(skipIndexes && (
           // Safari 9 has enumerable `arguments.length` in strict mode.
           key == 'length' ||
           // Node.js 0.10 has enumerable non-index properties on buffers.
           (isBuff && (key == 'offset' || key == 'parent')) ||
           // PhantomJS 2 has enumerable non-index properties on typed arrays.
           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
           // Skip index properties.
           isIndex(key, length)
        ))) {
      result.push(key);
    }
  }
  return result;
}

module.exports = arrayLikeKeys;


/***/ }),

/***/ 14528:
/***/ ((module) => {

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

module.exports = arrayPush;


/***/ }),

/***/ 14248:
/***/ ((module) => {

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

module.exports = arraySome;


/***/ }),

/***/ 26025:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var eq = __webpack_require__(75288);

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ }),

/***/ 82199:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayPush = __webpack_require__(14528),
    isArray = __webpack_require__(56449);

/**
 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
 * symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {Function} keysFunc The function to get the keys of `object`.
 * @param {Function} symbolsFunc The function to get the symbols of `object`.
 * @returns {Array} Returns the array of property names and symbols.
 */
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  var result = keysFunc(object);
  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
}

module.exports = baseGetAllKeys;


/***/ }),

/***/ 72552:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(51873),
    getRawTag = __webpack_require__(659),
    objectToString = __webpack_require__(59350);

/** `Object#toString` result references. */
var nullTag = '[object Null]',
    undefinedTag = '[object Undefined]';

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * The base implementation of `getTag` without fallbacks for buggy environments.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
function baseGetTag(value) {
  if (value == null) {
    return value === undefined ? undefinedTag : nullTag;
  }
  return (symToStringTag && symToStringTag in Object(value))
    ? getRawTag(value)
    : objectToString(value);
}

module.exports = baseGetTag;


/***/ }),

/***/ 27534:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(72552),
    isObjectLike = __webpack_require__(40346);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

module.exports = baseIsArguments;


/***/ }),

/***/ 60270:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqualDeep = __webpack_require__(87068),
    isObjectLike = __webpack_require__(40346);

/**
 * The base implementation of `_.isEqual` which supports partial comparisons
 * and tracks traversed objects.
 *
 * @private
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @param {boolean} bitmask The bitmask flags.
 *  1 - Unordered comparison
 *  2 - Partial comparison
 * @param {Function} [customizer] The function to customize comparisons.
 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 */
function baseIsEqual(value, other, bitmask, customizer, stack) {
  if (value === other) {
    return true;
  }
  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
    return value !== value && other !== other;
  }
  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
}

module.exports = baseIsEqual;


/***/ }),

/***/ 87068:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Stack = __webpack_require__(37217),
    equalArrays = __webpack_require__(25911),
    equalByTag = __webpack_require__(21986),
    equalObjects = __webpack_require__(50689),
    getTag = __webpack_require__(5861),
    isArray = __webpack_require__(56449),
    isBuffer = __webpack_require__(3656),
    isTypedArray = __webpack_require__(37167);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    objectTag = '[object Object]';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqual` for arrays and objects which performs
 * deep comparisons and tracks traversed objects enabling objects with circular
 * references to be compared.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  var objIsArr = isArray(object),
      othIsArr = isArray(other),
      objTag = objIsArr ? arrayTag : getTag(object),
      othTag = othIsArr ? arrayTag : getTag(other);

  objTag = objTag == argsTag ? objectTag : objTag;
  othTag = othTag == argsTag ? objectTag : othTag;

  var objIsObj = objTag == objectTag,
      othIsObj = othTag == objectTag,
      isSameTag = objTag == othTag;

  if (isSameTag && isBuffer(object)) {
    if (!isBuffer(other)) {
      return false;
    }
    objIsArr = true;
    objIsObj = false;
  }
  if (isSameTag && !objIsObj) {
    stack || (stack = new Stack);
    return (objIsArr || isTypedArray(object))
      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  }
  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

    if (objIsWrapped || othIsWrapped) {
      var objUnwrapped = objIsWrapped ? object.value() : object,
          othUnwrapped = othIsWrapped ? other.value() : other;

      stack || (stack = new Stack);
      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
    }
  }
  if (!isSameTag) {
    return false;
  }
  stack || (stack = new Stack);
  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}

module.exports = baseIsEqualDeep;


/***/ }),

/***/ 45083:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isFunction = __webpack_require__(1882),
    isMasked = __webpack_require__(87296),
    isObject = __webpack_require__(23805),
    toSource = __webpack_require__(47473);

/**
 * Used to match `RegExp`
 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
 */
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

/** Used to detect host constructors (Safari). */
var reIsHostCtor = /^\[object .+?Constructor\]$/;

/** Used for built-in method references. */
var funcProto = Function.prototype,
    objectProto = Object.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Used to detect if a method is native. */
var reIsNative = RegExp('^' +
  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
);

/**
 * The base implementation of `_.isNative` without bad shim checks.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a native function,
 *  else `false`.
 */
function baseIsNative(value) {
  if (!isObject(value) || isMasked(value)) {
    return false;
  }
  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  return pattern.test(toSource(value));
}

module.exports = baseIsNative;


/***/ }),

/***/ 4901:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(72552),
    isLength = __webpack_require__(30294),
    isObjectLike = __webpack_require__(40346);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

module.exports = baseIsTypedArray;


/***/ }),

/***/ 88984:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isPrototype = __webpack_require__(55527),
    nativeKeys = __webpack_require__(3650);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 */
function baseKeys(object) {
  if (!isPrototype(object)) {
    return nativeKeys(object);
  }
  var result = [];
  for (var key in Object(object)) {
    if (hasOwnProperty.call(object, key) && key != 'constructor') {
      result.push(key);
    }
  }
  return result;
}

module.exports = baseKeys;


/***/ }),

/***/ 78096:
/***/ ((module) => {

/**
 * The base implementation of `_.times` without support for iteratee shorthands
 * or max array length checks.
 *
 * @private
 * @param {number} n The number of times to invoke `iteratee`.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the array of results.
 */
function baseTimes(n, iteratee) {
  var index = -1,
      result = Array(n);

  while (++index < n) {
    result[index] = iteratee(index);
  }
  return result;
}

module.exports = baseTimes;


/***/ }),

/***/ 27301:
/***/ ((module) => {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ }),

/***/ 19219:
/***/ ((module) => {

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

module.exports = cacheHas;


/***/ }),

/***/ 55481:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var root = __webpack_require__(9325);

/** Used to detect overreaching core-js shims. */
var coreJsData = root['__core-js_shared__'];

module.exports = coreJsData;


/***/ }),

/***/ 25911:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(38859),
    arraySome = __webpack_require__(14248),
    cacheHas = __webpack_require__(19219);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Check that cyclic values are equal.
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

module.exports = equalArrays;


/***/ }),

/***/ 21986:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(51873),
    Uint8Array = __webpack_require__(37828),
    eq = __webpack_require__(75288),
    equalArrays = __webpack_require__(25911),
    mapToArray = __webpack_require__(20317),
    setToArray = __webpack_require__(84247);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]';

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = mapToArray;

    case setTag:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
      convert || (convert = setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

module.exports = equalByTag;


/***/ }),

/***/ 50689:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getAllKeys = __webpack_require__(50002);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1;

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * A specialized version of `baseIsEqualDeep` for objects with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      objProps = getAllKeys(object),
      objLength = objProps.length,
      othProps = getAllKeys(other),
      othLength = othProps.length;

  if (objLength != othLength && !isPartial) {
    return false;
  }
  var index = objLength;
  while (index--) {
    var key = objProps[index];
    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
      return false;
    }
  }
  // Check that cyclic values are equal.
  var objStacked = stack.get(object);
  var othStacked = stack.get(other);
  if (objStacked && othStacked) {
    return objStacked == other && othStacked == object;
  }
  var result = true;
  stack.set(object, other);
  stack.set(other, object);

  var skipCtor = isPartial;
  while (++index < objLength) {
    key = objProps[index];
    var objValue = object[key],
        othValue = other[key];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, objValue, key, other, object, stack)
        : customizer(objValue, othValue, key, object, other, stack);
    }
    // Recursively compare objects (susceptible to call stack limits).
    if (!(compared === undefined
          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
          : compared
        )) {
      result = false;
      break;
    }
    skipCtor || (skipCtor = key == 'constructor');
  }
  if (result && !skipCtor) {
    var objCtor = object.constructor,
        othCtor = other.constructor;

    // Non `Object` object instances with different constructors are not equal.
    if (objCtor != othCtor &&
        ('constructor' in object && 'constructor' in other) &&
        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
      result = false;
    }
  }
  stack['delete'](object);
  stack['delete'](other);
  return result;
}

module.exports = equalObjects;


/***/ }),

/***/ 34840:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g;

module.exports = freeGlobal;


/***/ }),

/***/ 50002:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetAllKeys = __webpack_require__(82199),
    getSymbols = __webpack_require__(4664),
    keys = __webpack_require__(95950);

/**
 * Creates an array of own enumerable property names and symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names and symbols.
 */
function getAllKeys(object) {
  return baseGetAllKeys(object, keys, getSymbols);
}

module.exports = getAllKeys;


/***/ }),

/***/ 12651:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isKeyable = __webpack_require__(74218);

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ }),

/***/ 56110:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsNative = __webpack_require__(45083),
    getValue = __webpack_require__(10392);

/**
 * Gets the native function at `key` of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @param {string} key The key of the method to get.
 * @returns {*} Returns the function if it's native, else `undefined`.
 */
function getNative(object, key) {
  var value = getValue(object, key);
  return baseIsNative(value) ? value : undefined;
}

module.exports = getNative;


/***/ }),

/***/ 659:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(51873);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

module.exports = getRawTag;


/***/ }),

/***/ 4664:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayFilter = __webpack_require__(79770),
    stubArray = __webpack_require__(63345);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

module.exports = getSymbols;


/***/ }),

/***/ 5861:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DataView = __webpack_require__(55580),
    Map = __webpack_require__(68223),
    Promise = __webpack_require__(32804),
    Set = __webpack_require__(76545),
    WeakMap = __webpack_require__(28303),
    baseGetTag = __webpack_require__(72552),
    toSource = __webpack_require__(47473);

/** `Object#toString` result references. */
var mapTag = '[object Map]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';

var dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = baseGetTag(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

module.exports = getTag;


/***/ }),

/***/ 10392:
/***/ ((module) => {

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

module.exports = getValue;


/***/ }),

/***/ 22032:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(81042);

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

module.exports = hashClear;


/***/ }),

/***/ 63862:
/***/ ((module) => {

/**
 * Removes `key` and its value from the hash.
 *
 * @private
 * @name delete
 * @memberOf Hash
 * @param {Object} hash The hash to modify.
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function hashDelete(key) {
  var result = this.has(key) && delete this.__data__[key];
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = hashDelete;


/***/ }),

/***/ 66721:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(81042);

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Gets the hash value for `key`.
 *
 * @private
 * @name get
 * @memberOf Hash
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function hashGet(key) {
  var data = this.__data__;
  if (nativeCreate) {
    var result = data[key];
    return result === HASH_UNDEFINED ? undefined : result;
  }
  return hasOwnProperty.call(data, key) ? data[key] : undefined;
}

module.exports = hashGet;


/***/ }),

/***/ 12749:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(81042);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

module.exports = hashHas;


/***/ }),

/***/ 35749:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(81042);

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Sets the hash `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Hash
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the hash instance.
 */
function hashSet(key, value) {
  var data = this.__data__;
  this.size += this.has(key) ? 0 : 1;
  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  return this;
}

module.exports = hashSet;


/***/ }),

/***/ 30361:
/***/ ((module) => {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

module.exports = isIndex;


/***/ }),

/***/ 74218:
/***/ ((module) => {

/**
 * Checks if `value` is suitable for use as unique object key.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
 */
function isKeyable(value) {
  var type = typeof value;
  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
    ? (value !== '__proto__')
    : (value === null);
}

module.exports = isKeyable;


/***/ }),

/***/ 87296:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var coreJsData = __webpack_require__(55481);

/** Used to detect methods masquerading as native. */
var maskSrcKey = (function() {
  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  return uid ? ('Symbol(src)_1.' + uid) : '';
}());

/**
 * Checks if `func` has its source masked.
 *
 * @private
 * @param {Function} func The function to check.
 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
 */
function isMasked(func) {
  return !!maskSrcKey && (maskSrcKey in func);
}

module.exports = isMasked;


/***/ }),

/***/ 55527:
/***/ ((module) => {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Checks if `value` is likely a prototype object.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
 */
function isPrototype(value) {
  var Ctor = value && value.constructor,
      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  return value === proto;
}

module.exports = isPrototype;


/***/ }),

/***/ 63702:
/***/ ((module) => {

/**
 * Removes all key-value entries from the list cache.
 *
 * @private
 * @name clear
 * @memberOf ListCache
 */
function listCacheClear() {
  this.__data__ = [];
  this.size = 0;
}

module.exports = listCacheClear;


/***/ }),

/***/ 70080:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(26025);

/** Used for built-in method references. */
var arrayProto = Array.prototype;

/** Built-in value references. */
var splice = arrayProto.splice;

/**
 * Removes `key` and its value from the list cache.
 *
 * @private
 * @name delete
 * @memberOf ListCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function listCacheDelete(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    return false;
  }
  var lastIndex = data.length - 1;
  if (index == lastIndex) {
    data.pop();
  } else {
    splice.call(data, index, 1);
  }
  --this.size;
  return true;
}

module.exports = listCacheDelete;


/***/ }),

/***/ 24739:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(26025);

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

module.exports = listCacheGet;


/***/ }),

/***/ 48655:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(26025);

/**
 * Checks if a list cache value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf ListCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function listCacheHas(key) {
  return assocIndexOf(this.__data__, key) > -1;
}

module.exports = listCacheHas;


/***/ }),

/***/ 31175:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(26025);

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

module.exports = listCacheSet;


/***/ }),

/***/ 63040:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Hash = __webpack_require__(21549),
    ListCache = __webpack_require__(80079),
    Map = __webpack_require__(68223);

/**
 * Removes all key-value entries from the map.
 *
 * @private
 * @name clear
 * @memberOf MapCache
 */
function mapCacheClear() {
  this.size = 0;
  this.__data__ = {
    'hash': new Hash,
    'map': new (Map || ListCache),
    'string': new Hash
  };
}

module.exports = mapCacheClear;


/***/ }),

/***/ 17670:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(12651);

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = mapCacheDelete;


/***/ }),

/***/ 90289:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(12651);

/**
 * Gets the map value for `key`.
 *
 * @private
 * @name get
 * @memberOf MapCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function mapCacheGet(key) {
  return getMapData(this, key).get(key);
}

module.exports = mapCacheGet;


/***/ }),

/***/ 4509:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(12651);

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

module.exports = mapCacheHas;


/***/ }),

/***/ 72949:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(12651);

/**
 * Sets the map `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf MapCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the map cache instance.
 */
function mapCacheSet(key, value) {
  var data = getMapData(this, key),
      size = data.size;

  data.set(key, value);
  this.size += data.size == size ? 0 : 1;
  return this;
}

module.exports = mapCacheSet;


/***/ }),

/***/ 20317:
/***/ ((module) => {

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

module.exports = mapToArray;


/***/ }),

/***/ 81042:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(56110);

/* Built-in method references that are verified to be native. */
var nativeCreate = getNative(Object, 'create');

module.exports = nativeCreate;


/***/ }),

/***/ 3650:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var overArg = __webpack_require__(74335);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = overArg(Object.keys, Object);

module.exports = nativeKeys;


/***/ }),

/***/ 86009:
/***/ ((module, exports, __webpack_require__) => {

/* module decorator */ module = __webpack_require__.nmd(module);
var freeGlobal = __webpack_require__(34840);

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && "object" == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Detect free variable `process` from Node.js. */
var freeProcess = moduleExports && freeGlobal.process;

/** Used to access faster Node.js helpers. */
var nodeUtil = (function() {
  try {
    // Use `util.types` for Node.js 10+.
    var types = freeModule && freeModule.require && freeModule.require('util').types;

    if (types) {
      return types;
    }

    // Legacy `process.binding('util')` for Node.js < 10.
    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  } catch (e) {}
}());

module.exports = nodeUtil;


/***/ }),

/***/ 59350:
/***/ ((module) => {

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/**
 * Converts `value` to a string using `Object.prototype.toString`.
 *
 * @private
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 */
function objectToString(value) {
  return nativeObjectToString.call(value);
}

module.exports = objectToString;


/***/ }),

/***/ 74335:
/***/ ((module) => {

/**
 * Creates a unary function that invokes `func` with its argument transformed.
 *
 * @private
 * @param {Function} func The function to wrap.
 * @param {Function} transform The argument transform.
 * @returns {Function} Returns the new function.
 */
function overArg(func, transform) {
  return function(arg) {
    return func(transform(arg));
  };
}

module.exports = overArg;


/***/ }),

/***/ 9325:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var freeGlobal = __webpack_require__(34840);

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ }),

/***/ 31380:
/***/ ((module) => {

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

module.exports = setCacheAdd;


/***/ }),

/***/ 51459:
/***/ ((module) => {

/**
 * Checks if `value` is in the array cache.
 *
 * @private
 * @name has
 * @memberOf SetCache
 * @param {*} value The value to search for.
 * @returns {number} Returns `true` if `value` is found, else `false`.
 */
function setCacheHas(value) {
  return this.__data__.has(value);
}

module.exports = setCacheHas;


/***/ }),

/***/ 84247:
/***/ ((module) => {

/**
 * Converts `set` to an array of its values.
 *
 * @private
 * @param {Object} set The set to convert.
 * @returns {Array} Returns the values.
 */
function setToArray(set) {
  var index = -1,
      result = Array(set.size);

  set.forEach(function(value) {
    result[++index] = value;
  });
  return result;
}

module.exports = setToArray;


/***/ }),

/***/ 51420:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ListCache = __webpack_require__(80079);

/**
 * Removes all key-value entries from the stack.
 *
 * @private
 * @name clear
 * @memberOf Stack
 */
function stackClear() {
  this.__data__ = new ListCache;
  this.size = 0;
}

module.exports = stackClear;


/***/ }),

/***/ 90938:
/***/ ((module) => {

/**
 * Removes `key` and its value from the stack.
 *
 * @private
 * @name delete
 * @memberOf Stack
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function stackDelete(key) {
  var data = this.__data__,
      result = data['delete'](key);

  this.size = data.size;
  return result;
}

module.exports = stackDelete;


/***/ }),

/***/ 63605:
/***/ ((module) => {

/**
 * Gets the stack value for `key`.
 *
 * @private
 * @name get
 * @memberOf Stack
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function stackGet(key) {
  return this.__data__.get(key);
}

module.exports = stackGet;


/***/ }),

/***/ 29817:
/***/ ((module) => {

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

module.exports = stackHas;


/***/ }),

/***/ 80945:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var ListCache = __webpack_require__(80079),
    Map = __webpack_require__(68223),
    MapCache = __webpack_require__(53661);

/** Used as the size to enable large array optimizations. */
var LARGE_ARRAY_SIZE = 200;

/**
 * Sets the stack `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf Stack
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the stack cache instance.
 */
function stackSet(key, value) {
  var data = this.__data__;
  if (data instanceof ListCache) {
    var pairs = data.__data__;
    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
      pairs.push([key, value]);
      this.size = ++data.size;
      return this;
    }
    data = this.__data__ = new MapCache(pairs);
  }
  data.set(key, value);
  this.size = data.size;
  return this;
}

module.exports = stackSet;


/***/ }),

/***/ 47473:
/***/ ((module) => {

/** Used for built-in method references. */
var funcProto = Function.prototype;

/** Used to resolve the decompiled source of functions. */
var funcToString = funcProto.toString;

/**
 * Converts `func` to its source code.
 *
 * @private
 * @param {Function} func The function to convert.
 * @returns {string} Returns the source code.
 */
function toSource(func) {
  if (func != null) {
    try {
      return funcToString.call(func);
    } catch (e) {}
    try {
      return (func + '');
    } catch (e) {}
  }
  return '';
}

module.exports = toSource;


/***/ }),

/***/ 75288:
/***/ ((module) => {

/**
 * Performs a
 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
 * comparison between two values to determine if they are equivalent.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.eq(object, object);
 * // => true
 *
 * _.eq(object, other);
 * // => false
 *
 * _.eq('a', 'a');
 * // => true
 *
 * _.eq('a', Object('a'));
 * // => false
 *
 * _.eq(NaN, NaN);
 * // => true
 */
function eq(value, other) {
  return value === other || (value !== value && other !== other);
}

module.exports = eq;


/***/ }),

/***/ 72428:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsArguments = __webpack_require__(27534),
    isObjectLike = __webpack_require__(40346);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/**
 * Checks if `value` is likely an `arguments` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 *  else `false`.
 * @example
 *
 * _.isArguments(function() { return arguments; }());
 * // => true
 *
 * _.isArguments([1, 2, 3]);
 * // => false
 */
var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
    !propertyIsEnumerable.call(value, 'callee');
};

module.exports = isArguments;


/***/ }),

/***/ 56449:
/***/ ((module) => {

/**
 * Checks if `value` is classified as an `Array` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
 * @example
 *
 * _.isArray([1, 2, 3]);
 * // => true
 *
 * _.isArray(document.body.children);
 * // => false
 *
 * _.isArray('abc');
 * // => false
 *
 * _.isArray(_.noop);
 * // => false
 */
var isArray = Array.isArray;

module.exports = isArray;


/***/ }),

/***/ 64894:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isFunction = __webpack_require__(1882),
    isLength = __webpack_require__(30294);

/**
 * Checks if `value` is array-like. A value is considered array-like if it's
 * not a function and has a `value.length` that's an integer greater than or
 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
 * @example
 *
 * _.isArrayLike([1, 2, 3]);
 * // => true
 *
 * _.isArrayLike(document.body.children);
 * // => true
 *
 * _.isArrayLike('abc');
 * // => true
 *
 * _.isArrayLike(_.noop);
 * // => false
 */
function isArrayLike(value) {
  return value != null && isLength(value.length) && !isFunction(value);
}

module.exports = isArrayLike;


/***/ }),

/***/ 53812:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(72552),
    isObjectLike = __webpack_require__(40346);

/** `Object#toString` result references. */
var boolTag = '[object Boolean]';

/**
 * Checks if `value` is classified as a boolean primitive or object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a boolean, else `false`.
 * @example
 *
 * _.isBoolean(false);
 * // => true
 *
 * _.isBoolean(null);
 * // => false
 */
function isBoolean(value) {
  return value === true || value === false ||
    (isObjectLike(value) && baseGetTag(value) == boolTag);
}

module.exports = isBoolean;


/***/ }),

/***/ 3656:
/***/ ((module, exports, __webpack_require__) => {

/* module decorator */ module = __webpack_require__.nmd(module);
var root = __webpack_require__(9325),
    stubFalse = __webpack_require__(89935);

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && "object" == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

module.exports = isBuffer;


/***/ }),

/***/ 2404:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqual = __webpack_require__(60270);

/**
 * Performs a deep comparison between two values to determine if they are
 * equivalent.
 *
 * **Note:** This method supports comparing arrays, array buffers, booleans,
 * date objects, error objects, maps, numbers, `Object` objects, regexes,
 * sets, strings, symbols, and typed arrays. `Object` objects are compared
 * by their own, not inherited, enumerable properties. Functions and DOM
 * nodes are compared by strict equality, i.e. `===`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.isEqual(object, other);
 * // => true
 *
 * object === other;
 * // => false
 */
function isEqual(value, other) {
  return baseIsEqual(value, other);
}

module.exports = isEqual;


/***/ }),

/***/ 1882:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(72552),
    isObject = __webpack_require__(23805);

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

module.exports = isFunction;


/***/ }),

/***/ 30294:
/***/ ((module) => {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

module.exports = isLength;


/***/ }),

/***/ 5187:
/***/ ((module) => {

/**
 * Checks if `value` is `null`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `null`, else `false`.
 * @example
 *
 * _.isNull(null);
 * // => true
 *
 * _.isNull(void 0);
 * // => false
 */
function isNull(value) {
  return value === null;
}

module.exports = isNull;


/***/ }),

/***/ 98023:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(72552),
    isObjectLike = __webpack_require__(40346);

/** `Object#toString` result references. */
var numberTag = '[object Number]';

/**
 * Checks if `value` is classified as a `Number` primitive or object.
 *
 * **Note:** To exclude `Infinity`, `-Infinity`, and `NaN`, which are
 * classified as numbers, use the `_.isFinite` method.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a number, else `false`.
 * @example
 *
 * _.isNumber(3);
 * // => true
 *
 * _.isNumber(Number.MIN_VALUE);
 * // => true
 *
 * _.isNumber(Infinity);
 * // => true
 *
 * _.isNumber('3');
 * // => false
 */
function isNumber(value) {
  return typeof value == 'number' ||
    (isObjectLike(value) && baseGetTag(value) == numberTag);
}

module.exports = isNumber;


/***/ }),

/***/ 23805:
/***/ ((module) => {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),

/***/ 40346:
/***/ ((module) => {

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return value != null && typeof value == 'object';
}

module.exports = isObjectLike;


/***/ }),

/***/ 85015:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(72552),
    isArray = __webpack_require__(56449),
    isObjectLike = __webpack_require__(40346);

/** `Object#toString` result references. */
var stringTag = '[object String]';

/**
 * Checks if `value` is classified as a `String` primitive or object.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a string, else `false`.
 * @example
 *
 * _.isString('abc');
 * // => true
 *
 * _.isString(1);
 * // => false
 */
function isString(value) {
  return typeof value == 'string' ||
    (!isArray(value) && isObjectLike(value) && baseGetTag(value) == stringTag);
}

module.exports = isString;


/***/ }),

/***/ 37167:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsTypedArray = __webpack_require__(4901),
    baseUnary = __webpack_require__(27301),
    nodeUtil = __webpack_require__(86009);

/* Node.js helper references. */
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

/**
 * Checks if `value` is classified as a typed array.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 * @example
 *
 * _.isTypedArray(new Uint8Array);
 * // => true
 *
 * _.isTypedArray([]);
 * // => false
 */
var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

module.exports = isTypedArray;


/***/ }),

/***/ 95950:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayLikeKeys = __webpack_require__(70695),
    baseKeys = __webpack_require__(88984),
    isArrayLike = __webpack_require__(64894);

/**
 * Creates an array of the own enumerable property names of `object`.
 *
 * **Note:** Non-object values are coerced to objects. See the
 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
 * for more details.
 *
 * @static
 * @since 0.1.0
 * @memberOf _
 * @category Object
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of property names.
 * @example
 *
 * function Foo() {
 *   this.a = 1;
 *   this.b = 2;
 * }
 *
 * Foo.prototype.c = 3;
 *
 * _.keys(new Foo);
 * // => ['a', 'b'] (iteration order is not guaranteed)
 *
 * _.keys('hi');
 * // => ['0', '1']
 */
function keys(object) {
  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
}

module.exports = keys;


/***/ }),

/***/ 6048:
/***/ ((module) => {

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that negates the result of the predicate `func`. The
 * `func` predicate is invoked with the `this` binding and arguments of the
 * created function.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Function
 * @param {Function} predicate The predicate to negate.
 * @returns {Function} Returns the new negated function.
 * @example
 *
 * function isEven(n) {
 *   return n % 2 == 0;
 * }
 *
 * _.filter([1, 2, 3, 4, 5, 6], _.negate(isEven));
 * // => [1, 3, 5]
 */
function negate(predicate) {
  if (typeof predicate != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  return function() {
    var args = arguments;
    switch (args.length) {
      case 0: return !predicate.call(this);
      case 1: return !predicate.call(this, args[0]);
      case 2: return !predicate.call(this, args[0], args[1]);
      case 3: return !predicate.call(this, args[0], args[1], args[2]);
    }
    return !predicate.apply(this, args);
  };
}

module.exports = negate;


/***/ }),

/***/ 63345:
/***/ ((module) => {

/**
 * This method returns a new empty array.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {Array} Returns the new empty array.
 * @example
 *
 * var arrays = _.times(2, _.stubArray);
 *
 * console.log(arrays);
 * // => [[], []]
 *
 * console.log(arrays[0] === arrays[1]);
 * // => false
 */
function stubArray() {
  return [];
}

module.exports = stubArray;


/***/ }),

/***/ 89935:
/***/ ((module) => {

/**
 * This method returns `false`.
 *
 * @static
 * @memberOf _
 * @since 4.13.0
 * @category Util
 * @returns {boolean} Returns `false`.
 * @example
 *
 * _.times(2, _.stubFalse);
 * // => [false, false]
 */
function stubFalse() {
  return false;
}

module.exports = stubFalse;


/***/ }),

/***/ 92340:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(6048);

// Coerces an a parameter into a callback for matching elements.
// This accepts an element name, an element type and returns a
// callback to match for those elements.
function coerceElementMatchingCallback(value) {
  // Element Name
  if (typeof value === 'string') {
    return element => element.element === value;
  }

  // Element Type
  if (value.constructor && value.extend) {
    return element => element instanceof value;
  }

  return value;
}

/**
 * @class
 *
 * @param {Element[]} elements
 *
 * @property {Element[]} elements
 */
class ArraySlice {
  constructor(elements) {
    this.elements = elements || [];
  }

  /**
   * @returns {Array}
   */
  toValue() {
    return this.elements.map(element => element.toValue());
  }

  // High Order Functions

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {array} A new array with each element being the result of the callback function
   */
  map(callback, thisArg) {
    return this.elements.map(callback, thisArg);
  }

  /**
   * Maps and then flattens the results.
   * @param callback - Function to execute for each element.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {array}
   */
  flatMap(callback, thisArg) {
    return this
      .map(callback, thisArg)
      .reduce((a, b) => a.concat(b), []);
  }

  /**
   * Returns an array containing the truthy results of calling the given transformation with each element of this sequence
   * @param transform - A closure that accepts an element of this array as its argument and returns an optional value.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArraySlice.prototype
   * @returns An array of the non-undefined results of calling transform with each element of the array
   */
  compactMap(transform, thisArg) {
    const results = [];

    this.forEach((element) => {
      const result = transform.bind(thisArg)(element);

      if (result) {
        results.push(result);
      }
    });

    return results;
  }

  /**
   * @param callback - Function to execute for each element. This may be a callback, an element name or an element class.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   * @memberof ArraySlice.prototype
   */
  filter(callback, thisArg) {
    callback = coerceElementMatchingCallback(callback);
    return new ArraySlice(this.elements.filter(callback, thisArg));
  }

  /**
   * @param callback - Function to execute for each element. This may be a callback, an element name or an element class.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   * @memberof ArraySlice.prototype
   */
  reject(callback, thisArg) {
    callback = coerceElementMatchingCallback(callback);
    return new ArraySlice(this.elements.filter(negate(callback), thisArg));
  }

  /**
   * Returns the first element in the array that satisfies the given value
   * @param callback - Function to execute for each element. This may be a callback, an element name or an element class.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {Element}
   * @memberof ArraySlice.prototype
   */
  find(callback, thisArg) {
    callback = coerceElementMatchingCallback(callback);
    return this.elements.find(callback, thisArg);
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArraySlice.prototype
   */
  forEach(callback, thisArg) {
    this.elements.forEach(callback, thisArg);
  }

  /**
   * @param callback - Function to execute for each element
   * @param initialValue
   * @memberof ArraySlice.prototype
   */
  reduce(callback, initialValue) {
    return this.elements.reduce(callback, initialValue);
  }

  /**
   * @param value
   * @returns {boolean}
   * @memberof ArraySlice.prototype
   */
  includes(value) {
    return this.elements.some(element => element.equals(value));
  }

  // Mutation

  /**
   * Removes the first element from the slice
   * @returns {Element} The removed element or undefined if the slice is empty
   * @memberof ArraySlice.prototype
   */
  shift() {
    return this.elements.shift();
  }

  /**
   * Adds the given element to the begining of the slice
   * @parameter {Element} value
   * @memberof ArraySlice.prototype
   */
  unshift(value) {
    this.elements.unshift(this.refract(value));
  }

  /**
   * Adds the given element to the end of the slice
   * @parameter {Element} value
   * @memberof ArraySlice.prototype
   */
  push(value) {
    this.elements.push(this.refract(value));
    return this;
  }

  /**
   * @parameter {Element} value
   * @memberof ArraySlice.prototype
   */
  add(value) {
    this.push(value);
  }

  // Accessors

  /**
   * @parameter {number} index
   * @returns {Element}
   * @memberof ArraySlice.prototype
   */
  get(index) {
    return this.elements[index];
  }

  /**
   * @parameter {number} index
   * @memberof ArraySlice.prototype
   */
  getValue(index) {
    const element = this.elements[index];

    if (element) {
      return element.toValue();
    }

    return undefined;
  }

  /**
   * Returns the number of elements in the slice
   * @type number
   */
  get length() {
    return this.elements.length;
  }

  /**
   * Returns whether the slice is empty
   * @type boolean
   */
  get isEmpty() {
    return this.elements.length === 0;
  }

  /**
   * Returns the first element in the slice or undefined if the slice is empty
   * @type Element
   */
  get first() {
    return this.elements[0];
  }
}

if (typeof Symbol !== 'undefined') {
  ArraySlice.prototype[Symbol.iterator] = function symbol() {
    return this.elements[Symbol.iterator]();
  };
}

module.exports = ArraySlice;


/***/ }),

/***/ 55973:
/***/ ((module) => {

/**
 * @class
 *
 * @property {Element} key
 * @property {Element} value
 */
class KeyValuePair {
  constructor(key, value) {
    this.key = key;
    this.value = value;
  }

  /**
   * @returns {KeyValuePair}
   */
  clone() {
    const clone = new KeyValuePair();

    if (this.key) {
      clone.key = this.key.clone();
    }

    if (this.value) {
      clone.value = this.value.clone();
    }

    return clone;
  }
}

module.exports = KeyValuePair;


/***/ }),

/***/ 3110:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const isNull = __webpack_require__(5187);
const isString = __webpack_require__(85015);
const isNumber = __webpack_require__(98023);
const isBoolean = __webpack_require__(53812);
const isObject = __webpack_require__(23805);

const JSONSerialiser = __webpack_require__(85105);
const elements = __webpack_require__(86804);

/**
 * @class
 *
 * A refract element implementation with an extensible namespace, able to
 * load other namespaces into it.
 *
 * The namespace allows you to register your own classes to be instantiated
 * when a particular refract element is encountered, and allows you to specify
 * which elements get instantiated for existing Javascript objects.
 */
class Namespace {
  constructor(options) {
    this.elementMap = {};
    this.elementDetection = [];
    this.Element = elements.Element;
    this.KeyValuePair = elements.KeyValuePair;

    if (!options || !options.noDefault) {
      this.useDefault();
    }

    // These provide the defaults for new elements.
    this._attributeElementKeys = [];
    this._attributeElementArrayKeys = [];
  }

  /**
   * Use a namespace plugin or load a generic plugin.
   *
   * @param plugin
   */
  use(plugin) {
    if (plugin.namespace) {
      plugin.namespace({ base: this });
    }
    if (plugin.load) {
      plugin.load({ base: this });
    }
    return this;
  }

  /*
   * Use the default namespace. This preloads all the default elements
   * into this registry instance.
   */
  useDefault() {
    // Set up classes for default elements
    this
      .register('null', elements.NullElement)
      .register('string', elements.StringElement)
      .register('number', elements.NumberElement)
      .register('boolean', elements.BooleanElement)
      .register('array', elements.ArrayElement)
      .register('object', elements.ObjectElement)
      .register('member', elements.MemberElement)
      .register('ref', elements.RefElement)
      .register('link', elements.LinkElement);

    // Add instance detection functions to convert existing objects into
    // the corresponding refract elements.
    this
      .detect(isNull, elements.NullElement, false)
      .detect(isString, elements.StringElement, false)
      .detect(isNumber, elements.NumberElement, false)
      .detect(isBoolean, elements.BooleanElement, false)
      .detect(Array.isArray, elements.ArrayElement, false)
      .detect(isObject, elements.ObjectElement, false);

    return this;
  }

  /**
   * Register a new element class for an element.
   *
   * @param {string} name
   * @param elementClass
   */
  register(name, ElementClass) {
    this._elements = undefined;
    this.elementMap[name] = ElementClass;
    return this;
  }

  /**
   * Unregister a previously registered class for an element.
   *
   * @param {string} name
   */
  unregister(name) {
    this._elements = undefined;
    delete this.elementMap[name];
    return this;
  }

  /*
   * Add a new detection function to determine which element
   * class to use when converting existing js instances into
   * refract element.
   */
  detect(test, ElementClass, givenPrepend) {
    const prepend = givenPrepend === undefined ? true : givenPrepend;

    if (prepend) {
      this.elementDetection.unshift([test, ElementClass]);
    } else {
      this.elementDetection.push([test, ElementClass]);
    }

    return this;
  }

  /*
   * Convert an existing Javascript object into refract element instances, which
   * can be further processed or serialized into refract.
   * If the item passed in is already refracted, then it is returned
   * unmodified.
   */
  toElement(value) {
    if (value instanceof this.Element) { return value; }

    let element;

    for (let i = 0; i < this.elementDetection.length; i += 1) {
      const test = this.elementDetection[i][0];
      const ElementClass = this.elementDetection[i][1];

      if (test(value)) {
        element = new ElementClass(value);
        break;
      }
    }

    return element;
  }

  /*
   * Get an element class given an element name.
   */
  getElementClass(element) {
    const ElementClass = this.elementMap[element];

    if (ElementClass === undefined) {
      // Fall back to the base element. We may not know what
      // to do with the `content`, but downstream software
      // may know.
      return this.Element;
    }

    return ElementClass;
  }

  /*
   * Convert a refract document into refract element instances.
   */
  fromRefract(doc) {
    return this.serialiser.deserialise(doc);
  }

  /*
   * Convert an element to a Refracted JSON object.
   */
  toRefract(element) {
    return this.serialiser.serialise(element);
  }

  /*
   * Get an object that contains all registered element classes, where
   * the key is the PascalCased element name and the value is the class.
   */
  get elements() {
    if (this._elements === undefined) {
      this._elements = {
        Element: this.Element,
      };

      Object.keys(this.elementMap).forEach((name) => {
        // Currently, all registered element types use a camelCaseName.
        // Converting to PascalCase is as simple as upper-casing the first
        // letter.
        const pascal = name[0].toUpperCase() + name.substr(1);
        this._elements[pascal] = this.elementMap[name];
      });
    }

    return this._elements;
  }

  /**
   * Convinience method for getting a JSON Serialiser configured with the
   * current namespace
   *
   * @type JSONSerialiser
   * @readonly
   *
   * @memberof Namespace.prototype
   */
  get serialiser() {
    return new JSONSerialiser(this);
  }
}

JSONSerialiser.prototype.Namespace = Namespace;

module.exports = Namespace;


/***/ }),

/***/ 10866:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(6048);
const ArraySlice = __webpack_require__(92340);

/**
 */
class ObjectSlice extends ArraySlice {
  map(callback, thisArg) {
    return this.elements.map(member => callback.bind(thisArg)(member.value, member.key, member));
  }

  filter(callback, thisArg) {
    return new ObjectSlice(this.elements.filter(member => callback.bind(thisArg)(member.value, member.key, member)));
  }

  reject(callback, thisArg) {
    return this.filter(negate(callback.bind(thisArg)));
  }

  forEach(callback, thisArg) {
    return this.elements.forEach((member, index) => { callback.bind(thisArg)(member.value, member.key, member, index); });
  }

  /**
   * @returns {array}
   */
  keys() {
    return this.map((value, key) => key.toValue());
  }

  /**
   * @returns {array}
   */
  values() {
    return this.map(value => value.toValue());
  }
}

module.exports = ObjectSlice;


/***/ }),

/***/ 86804:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(10316);
const NullElement = __webpack_require__(41067);
const StringElement = __webpack_require__(71167);
const NumberElement = __webpack_require__(40239);
const BooleanElement = __webpack_require__(12242);
const ArrayElement = __webpack_require__(6233);
const MemberElement = __webpack_require__(87726);
const ObjectElement = __webpack_require__(61045);
const LinkElement = __webpack_require__(86303);
const RefElement = __webpack_require__(14540);

const ArraySlice = __webpack_require__(92340);
const ObjectSlice = __webpack_require__(10866);

const KeyValuePair = __webpack_require__(55973);

/**
 * Refracts a JSON type to minim elements
 * @param value
 * @returns {Element}
 */
function refract(value) {
  if (value instanceof Element) {
    return value;
  }

  if (typeof value === 'string') {
    return new StringElement(value);
  }

  if (typeof value === 'number') {
    return new NumberElement(value);
  }

  if (typeof value === 'boolean') {
    return new BooleanElement(value);
  }

  if (value === null) {
    return new NullElement();
  }

  if (Array.isArray(value)) {
    return new ArrayElement(value.map(refract));
  }

  if (typeof value === 'object') {
    const element = new ObjectElement(value);
    return element;
  }

  return value;
}

Element.prototype.ObjectElement = ObjectElement;
Element.prototype.RefElement = RefElement;
Element.prototype.MemberElement = MemberElement;

Element.prototype.refract = refract;
ArraySlice.prototype.refract = refract;

/**
 * Contains all of the element classes, and related structures and methods
 * for handling with element instances.
 */
module.exports = {
  Element,
  NullElement,
  StringElement,
  NumberElement,
  BooleanElement,
  ArrayElement,
  MemberElement,
  ObjectElement,
  LinkElement,
  RefElement,

  refract,

  ArraySlice,
  ObjectSlice,
  KeyValuePair,
};


/***/ }),

/***/ 86303:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(10316);

/** Hyperlinking MAY be used to link to other resources, provide links to
 * instructions on how to process a given element (by way of a profile or
 * other means), and may be used to provide meta data about the element in
 * which it's found. The meaning and purpose of the hyperlink is defined by
 * the link relation according to RFC 5988.
 *
 * @class LinkElement
 *
 * @param content
 * @param meta
 * @param attributes
 */
module.exports = class LinkElement extends Element {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'link';
  }

  /**
   * The relation identifier for the link, as defined in RFC 5988.
   * @type StringElement
   */
  get relation() {
    return this.attributes.get('relation');
  }

  set relation(relation) {
    this.attributes.set('relation', relation);
  }

  /**
   * The URI for the given link.
   * @type StringElement
   */
  get href() {
    return this.attributes.get('href');
  }

  set href(href) {
    this.attributes.set('href', href);
  }
};


/***/ }),

/***/ 14540:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(10316);

/**
 * @class RefElement
 *
 * @param content
 * @param meta
 * @param attributes
 *
 * @extends Element
 */
module.exports = class RefElement extends Element {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'ref';

    if (!this.path) {
      this.path = 'element';
    }
  }

  /**
   * Path of referenced element to transclude instead of element itself.
   * @type StringElement
   * @default element
   */
  get path() {
    return this.attributes.get('path');
  }

  set path(newValue) {
    this.attributes.set('path', newValue);
  }
};


/***/ }),

/***/ 34035:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

const Namespace = __webpack_require__(3110);
const elements = __webpack_require__(86804);

// Direct access to the Namespace class
exports.Namespace = Namespace;

// Special constructor for the Namespace class
exports.namespace = function namespace(options) {
  return new Namespace(options);
};

exports.KeyValuePair = __webpack_require__(55973);

exports.ArraySlice = elements.ArraySlice;
exports.ObjectSlice = elements.ObjectSlice;

exports.Element = elements.Element;
exports.StringElement = elements.StringElement;
exports.NumberElement = elements.NumberElement;
exports.BooleanElement = elements.BooleanElement;
exports.NullElement = elements.NullElement;
exports.ArrayElement = elements.ArrayElement;
exports.ObjectElement = elements.ObjectElement;
exports.MemberElement = elements.MemberElement;
exports.RefElement = elements.RefElement;
exports.LinkElement = elements.LinkElement;

exports.refract = elements.refract;

exports.JSONSerialiser = __webpack_require__(85105);
exports.JSON06Serialiser = __webpack_require__(75147);


/***/ }),

/***/ 6233:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(6048);
const Element = __webpack_require__(10316);
const ArraySlice = __webpack_require__(92340);

/**
 * @class
 *
 * @param {Element[]} content
 * @param meta
 * @param attributes
 */
class ArrayElement extends Element {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'array';
  }

  primitive() {
    return 'array';
  }

  /**
   * @returns {Element}
   */
  get(index) {
    return this.content[index];
  }

  /**
   * Helper for returning the value of an item
   * This works for both ArrayElement and ObjectElement instances
   */
  getValue(indexOrKey) {
    const item = this.get(indexOrKey);

    if (item) {
      return item.toValue();
    }

    return undefined;
  }

  /**
   * @returns {Element}
   */
  getIndex(index) {
    return this.content[index];
  }

  set(index, value) {
    this.content[index] = this.refract(value);
    return this;
  }

  remove(index) {
    const removed = this.content.splice(index, 1);

    if (removed.length) {
      return removed[0];
    }

    return null;
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   */
  map(callback, thisArg) {
    return this.content.map(callback, thisArg);
  }

  /**
   * Maps and then flattens the results.
   * @param callback - Function to execute for each element.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {array}
   */
  flatMap(callback, thisArg) {
    return this
      .map(callback, thisArg)
      .reduce((a, b) => a.concat(b), []);
  }

  /**
   * Returns an array containing the truthy results of calling the given transformation with each element of this sequence
   * @param transform - A closure that accepts an element of this array as its argument and returns an optional value.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArrayElement.prototype
   * @returns An array of the non-undefined results of calling transform with each element of the array
   */
  compactMap(transform, thisArg) {
    const results = [];

    this.forEach((element) => {
      const result = transform.bind(thisArg)(element);

      if (result) {
        results.push(result);
      }
    });

    return results;
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   */
  filter(callback, thisArg) {
    return new ArraySlice(this.content.filter(callback, thisArg));
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   */
  reject(callback, thisArg) {
    return this.filter(negate(callback), thisArg);
  }

  /**
   * This is a reduce function specifically for Minim arrays and objects. It
   * allows for returning normal values or Minim instances, so it converts any
   * primitives on each step.
   */
  reduce(callback, initialValue) {
    let startIndex;
    let memo;

    // Allows for defining a starting value of the reduce
    if (initialValue !== undefined) {
      startIndex = 0;
      memo = this.refract(initialValue);
    } else {
      startIndex = 1;
      // Object Element content items are member elements. Because of this,
      // the memo should start out as the member value rather than the
      // actual member itself.
      memo = this.primitive() === 'object' ? this.first.value : this.first;
    }

    // Sending each function call to the registry allows for passing Minim
    // instances through the function return. This means you can return
    // primitive values or return Minim instances and reduce will still work.
    for (let i = startIndex; i < this.length; i += 1) {
      const item = this.content[i];

      if (this.primitive() === 'object') {
        memo = this.refract(callback(memo, item.value, item.key, item, this));
      } else {
        memo = this.refract(callback(memo, item, i, this));
      }
    }

    return memo;
  }

  /**
   * @callback forEachCallback
   * @param {Element} currentValue
   * @param {NumberElement} index
   */

  /**
   * @param {forEachCallback} callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArrayElement.prototype
   */
  forEach(callback, thisArg) {
    this.content.forEach((item, index) => {
      callback.bind(thisArg)(item, this.refract(index));
    });
  }

  /**
   * @returns {Element}
   */
  shift() {
    return this.content.shift();
  }

  /**
   * @param value
   */
  unshift(value) {
    this.content.unshift(this.refract(value));
  }

  /**
   * @param value
   */
  push(value) {
    this.content.push(this.refract(value));
    return this;
  }

  /**
   * @param value
   */
  add(value) {
    this.push(value);
  }

  /**
   * Recusively search all descendents using a condition function.
   * @returns {Element[]}
   */
  findElements(condition, givenOptions) {
    const options = givenOptions || {};
    const recursive = !!options.recursive;
    const results = options.results === undefined ? [] : options.results;

    // The forEach method for Object Elements returns value, key, and member.
    // This passes those along to the condition function below.
    this.forEach((item, keyOrIndex, member) => {
      // We use duck-typing here to support any registered class that
      // may contain other elements.
      if (recursive && (item.findElements !== undefined)) {
        item.findElements(condition, {
          results,
          recursive,
        });
      }

      if (condition(item, keyOrIndex, member)) {
        results.push(item);
      }
    });

    return results;
  }

  /**
   * Recusively search all descendents using a condition function.
   * @param condition
   * @returns {ArraySlice}
   */
  find(condition) {
    return new ArraySlice(this.findElements(condition, { recursive: true }));
  }

  /**
   * @param {string} element
   * @returns {ArraySlice}
   */
  findByElement(element) {
    return this.find(item => item.element === element);
  }

  /**
   * @param {string} className
   * @returns {ArraySlice}
   * @memberof ArrayElement.prototype
   */
  findByClass(className) {
    return this.find(item => item.classes.includes(className));
  }

  /**
   * Search the tree recursively and find the element with the matching ID
   * @param {string} id
   * @returns {Element}
   * @memberof ArrayElement.prototype
   */
  getById(id) {
    return this.find(item => item.id.toValue() === id).first;
  }

  /**
   * Looks for matching children using deep equality
   * @param value
   * @returns {boolean}
   */
  includes(value) {
    return this.content.some(element => element.equals(value));
  }

  /**
   * Looks for matching children using deep equality
   * @param value
   * @returns {boolean}
   * @see includes
   * @deprecated method was replaced by includes
   */
  contains(value) {
    return this.includes(value);
  }

  // Fantasy Land

  /**
   * @returns {ArrayElement} An empty array element
   */
  empty() {
    return new this.constructor([]);
  }

  ['fantasy-land/empty']() {
    return this.empty();
  }

  /**
   * @param {ArrayElement} other
   * @returns {ArrayElement}
   */
  concat(other) {
    return new this.constructor(this.content.concat(other.content));
  }

  ['fantasy-land/concat'](other) {
    return this.concat(other);
  }

  ['fantasy-land/map'](transform) {
    return new this.constructor(this.map(transform));
  }

  ['fantasy-land/chain'](transform) {
    return this
      .map(element => transform(element), this)
      .reduce((a, b) => a.concat(b), this.empty());
  }

  ['fantasy-land/filter'](callback) {
    return new this.constructor(this.content.filter(callback));
  }

  ['fantasy-land/reduce'](transform, initialValue) {
    return this.content.reduce(transform, initialValue);
  }

  /**
   * Returns the length of the collection
   * @type number
   */
  get length() {
    return this.content.length;
  }

  /**
   * Returns whether the collection is empty
   * @type boolean
   */
  get isEmpty() {
    return this.content.length === 0;
  }

  /**
   * Return the first item in the collection
   * @type Element
   */
  get first() {
    return this.getIndex(0);
  }

  /**
   * Return the second item in the collection
   * @type Element
   */
  get second() {
    return this.getIndex(1);
  }

  /**
   * Return the last item in the collection
   * @type Element
   */
  get last() {
    return this.getIndex(this.length - 1);
  }
}

/**
 * @returns {ArrayElement} An empty array element
 */
ArrayElement.empty = function empty() {
  return new this();
};

ArrayElement['fantasy-land/empty'] = ArrayElement.empty;

if (typeof Symbol !== 'undefined') {
  ArrayElement.prototype[Symbol.iterator] = function symbol() {
    return this.content[Symbol.iterator]();
  };
}

module.exports = ArrayElement;


/***/ }),

/***/ 12242:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(10316);

/**
 * @class BooleanElement
 *
 * @param {boolean} content
 * @param meta
 * @param attributes
 */
module.exports = class BooleanElement extends Element {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'boolean';
  }

  primitive() {
    return 'boolean';
  }
};


/***/ }),

/***/ 10316:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const isEqual = __webpack_require__(2404);
const KeyValuePair = __webpack_require__(55973);
const ArraySlice = __webpack_require__(92340);

/**
 * @class
 *
 * @param content
 * @param meta
 * @param attributes
 *
 * @property {string} element
 */
class Element {
  constructor(content, meta, attributes) {
    // Lazy load this.meta and this.attributes because it's a Minim element
    // Otherwise, we get into circuluar calls
    if (meta) {
      this.meta = meta;
    }

    if (attributes) {
      this.attributes = attributes;
    }

    this.content = content;
  }

  /**
   * Freezes the element to prevent any mutation.
   * A frozen element will add `parent` property to every child element
   * to allow traversing up the element tree.
   */
  freeze() {
    if (Object.isFrozen(this)) {
      return;
    }

    if (this._meta) {
      this.meta.parent = this;
      this.meta.freeze();
    }

    if (this._attributes) {
      this.attributes.parent = this;
      this.attributes.freeze();
    }

    this.children.forEach((element) => {
      element.parent = this;
      element.freeze();
    }, this);

    if (this.content && Array.isArray(this.content)) {
      Object.freeze(this.content);
    }

    Object.freeze(this);
  }

  primitive() {

  }

  /**
   * Creates a deep clone of the instance
   */
  clone() {
    const copy = new this.constructor();

    copy.element = this.element;

    if (this.meta.length) {
      copy._meta = this.meta.clone();
    }

    if (this.attributes.length) {
      copy._attributes = this.attributes.clone();
    }

    if (this.content) {
      if (this.content.clone) {
        copy.content = this.content.clone();
      } else if (Array.isArray(this.content)) {
        copy.content = this.content.map(element => element.clone());
      } else {
        copy.content = this.content;
      }
    } else {
      copy.content = this.content;
    }

    return copy;
  }

  /**
   */
  toValue() {
    if (this.content instanceof Element) {
      return this.content.toValue();
    }

    if (this.content instanceof KeyValuePair) {
      return {
        key: this.content.key.toValue(),
        value: this.content.value ? this.content.value.toValue() : undefined,
      };
    }

    if (this.content && this.content.map) {
      return this.content.map(element => element.toValue(), this);
    }

    return this.content;
  }

  /**
   * Creates a reference pointing at the Element
   * @returns {RefElement}
   * @memberof Element.prototype
   */
  toRef(path) {
    if (this.id.toValue() === '') {
      throw Error('Cannot create reference to an element that does not contain an ID');
    }

    const ref = new this.RefElement(this.id.toValue());

    if (path) {
      ref.path = path;
    }

    return ref;
  }

  /**
   * Finds the given elements in the element tree.
   * When providing multiple element names, you must first freeze the element.
   *
   * @param names {...elementNames}
   * @returns {ArraySlice}
   */
  findRecursive(...elementNames) {
    if (arguments.length > 1 && !this.isFrozen) {
      throw new Error('Cannot find recursive with multiple element names without first freezing the element. Call `element.freeze()`');
    }

    const elementName = elementNames.pop();
    let elements = new ArraySlice();

    const append = (array, element) => {
      array.push(element);
      return array;
    };

    // Checks the given element and appends element/sub-elements
    // that match element name to given array
    const checkElement = (array, element) => {
      if (element.element === elementName) {
        array.push(element);
      }

      const items = element.findRecursive(elementName);
      if (items) {
        items.reduce(append, array);
      }

      if (element.content instanceof KeyValuePair) {
        if (element.content.key) {
          checkElement(array, element.content.key);
        }

        if (element.content.value) {
          checkElement(array, element.content.value);
        }
      }

      return array;
    };

    if (this.content) {
      // Direct Element
      if (this.content.element) {
        checkElement(elements, this.content);
      }

      // Element Array
      if (Array.isArray(this.content)) {
        this.content.reduce(checkElement, elements);
      }
    }

    if (!elementNames.isEmpty) {
      elements = elements.filter((element) => {
        let parentElements = element.parents.map(e => e.element);

        // eslint-disable-next-line no-restricted-syntax
        for (const namesIndex in elementNames) {
          const name = elementNames[namesIndex];
          const index = parentElements.indexOf(name);

          if (index !== -1) {
            parentElements = parentElements.splice(0, index);
          } else {
            return false;
          }
        }

        return true;
      });
    }

    return elements;
  }

  set(content) {
    this.content = content;
    return this;
  }

  equals(value) {
    return isEqual(this.toValue(), value);
  }

  getMetaProperty(name, value) {
    if (!this.meta.hasKey(name)) {
      if (this.isFrozen) {
        const element = this.refract(value);
        element.freeze();
        return element;
      }

      this.meta.set(name, value);
    }

    return this.meta.get(name);
  }

  setMetaProperty(name, value) {
    this.meta.set(name, value);
  }

  /**
   * @type String
   */
  get element() {
    // Returns 'element' so we don't have undefined as element
    return this._storedElement || 'element';
  }

  set element(element) {
    this._storedElement = element;
  }

  get content() {
    return this._content;
  }

  set content(value) {
    if (value instanceof Element) {
      this._content = value;
    } else if (value instanceof ArraySlice) {
      this.content = value.elements;
    } else if (
      typeof value == 'string'
      || typeof value == 'number'
      || typeof value == 'boolean'
      || value === 'null'
      || value == undefined
    ) {
      // Primitive Values
      this._content = value;
    } else if (value instanceof KeyValuePair) {
      this._content = value;
    } else if (Array.isArray(value)) {
      this._content = value.map(this.refract);
    } else if (typeof value === 'object') {
      this._content = Object.keys(value).map(key => new this.MemberElement(key, value[key]));
    } else {
      throw new Error('Cannot set content to given value');
    }
  }

  /**
   * @type ObjectElement
   */
  get meta() {
    if (!this._meta) {
      if (this.isFrozen) {
        const meta = new this.ObjectElement();
        meta.freeze();
        return meta;
      }

      this._meta = new this.ObjectElement();
    }

    return this._meta;
  }

  set meta(value) {
    if (value instanceof this.ObjectElement) {
      this._meta = value;
    } else {
      this.meta.set(value || {});
    }
  }

  /**
   * The attributes property defines attributes about the given instance
   * of the element, as specified by the element property.
   *
   * @type ObjectElement
   */
  get attributes() {
    if (!this._attributes) {
      if (this.isFrozen) {
        const meta = new this.ObjectElement();
        meta.freeze();
        return meta;
      }

      this._attributes = new this.ObjectElement();
    }

    return this._attributes;
  }

  set attributes(value) {
    if (value instanceof this.ObjectElement) {
      this._attributes = value;
    } else {
      this.attributes.set(value || {});
    }
  }

  /**
   * Unique Identifier, MUST be unique throughout an entire element tree.
   * @type StringElement
   */
  get id() {
    return this.getMetaProperty('id', '');
  }

  set id(element) {
    this.setMetaProperty('id', element);
  }

  /**
   * @type ArrayElement
   */
  get classes() {
    return this.getMetaProperty('classes', []);
  }

  set classes(element) {
    this.setMetaProperty('classes', element);
  }

  /**
   * Human-readable title of element
   * @type StringElement
   */
  get title() {
    return this.getMetaProperty('title', '');
  }

  set title(element) {
    this.setMetaProperty('title', element);
  }

  /**
   * Human-readable description of element
   * @type StringElement
   */
  get description() {
    return this.getMetaProperty('description', '');
  }

  set description(element) {
    this.setMetaProperty('description', element);
  }

  /**
   * @type ArrayElement
   */
  get links() {
    return this.getMetaProperty('links', []);
  }

  set links(element) {
    this.setMetaProperty('links', element);
  }

  /**
   * Returns whether the element is frozen.
   * @type boolean
   * @see freeze
   */
  get isFrozen() {
    return Object.isFrozen(this);
  }

  /**
   * Returns all of the parent elements.
   * @type ArraySlice
   */
  get parents() {
    let { parent } = this;
    const parents = new ArraySlice();

    while (parent) {
      parents.push(parent);

      // eslint-disable-next-line prefer-destructuring
      parent = parent.parent;
    }

    return parents;
  }

  /**
   * Returns all of the children elements found within the element.
   * @type ArraySlice
   * @see recursiveChildren
   */
  get children() {
    if (Array.isArray(this.content)) {
      return new ArraySlice(this.content);
    }

    if (this.content instanceof KeyValuePair) {
      const children = new ArraySlice([this.content.key]);

      if (this.content.value) {
        children.push(this.content.value);
      }

      return children;
    }

    if (this.content instanceof Element) {
      return new ArraySlice([this.content]);
    }

    return new ArraySlice();
  }

  /**
  * Returns all of the children elements found within the element recursively.
  * @type ArraySlice
  * @see children
  */
  get recursiveChildren() {
    const children = new ArraySlice();

    this.children.forEach((element) => {
      children.push(element);

      element.recursiveChildren.forEach((child) => {
        children.push(child);
      });
    });

    return children;
  }
}

module.exports = Element;


/***/ }),

/***/ 87726:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const KeyValuePair = __webpack_require__(55973);
const Element = __webpack_require__(10316);

/**
 * @class MemberElement
 *
 * @param {Element} key
 * @param {Element} value
 * @param meta
 * @param attributes
 */
module.exports = class MemberElement extends Element {
  constructor(key, value, meta, attributes) {
    super(new KeyValuePair(), meta, attributes);

    this.element = 'member';
    this.key = key;
    this.value = value;
  }

  /**
   * @type Element
   */
  get key() {
    return this.content.key;
  }

  set key(key) {
    this.content.key = this.refract(key);
  }

  /**
   * @type Element
   */
  get value() {
    return this.content.value;
  }

  set value(value) {
    this.content.value = this.refract(value);
  }
};


/***/ }),

/***/ 41067:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(10316);

/**
 */
class NullElement extends Element {
  constructor(content, meta, attributes) {
    super(content || null, meta, attributes);
    this.element = 'null';
  }

  primitive() {
    return 'null';
  }

  set() {
    return new Error('Cannot set the value of null');
  }
}

module.exports = NullElement;


/***/ }),

/***/ 40239:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(10316);

/**
 * @class NumberElement
 *
 * @param {number} content
 * @param meta
 * @param attributes
 */
module.exports = class NumberElement extends Element {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'number';
  }

  primitive() {
    return 'number';
  }
};


/***/ }),

/***/ 61045:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(6048);
const isObject = __webpack_require__(23805);

const ArrayElement = __webpack_require__(6233);
const MemberElement = __webpack_require__(87726);
const ObjectSlice = __webpack_require__(10866);

/**
 * @class
 *
 * @param content
 * @param meta
 * @param attributes
 */
class ObjectElement extends ArrayElement {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'object';
  }

  primitive() {
    return 'object';
  }

  toValue() {
    return this.content.reduce((results, el) => {
      results[el.key.toValue()] = el.value ? el.value.toValue() : undefined;
      return results;
    }, {});
  }

  /**
   * @param key
   * @returns {Element}
   */
  get(name) {
    const member = this.getMember(name);

    if (member) {
      return member.value;
    }

    return undefined;
  }

  /**
   * @param key
   * @returns {MemberElement}
   */
  getMember(name) {
    if (name === undefined) { return undefined; }

    return this.content.find(element => element.key.toValue() === name);
  }

  /**
   * @param key
   */
  remove(name) {
    let removed = null;

    this.content = this.content.filter((item) => {
      if (item.key.toValue() === name) {
        removed = item;
        return false;
      }

      return true;
    });

    return removed;
  }

  /**
   * @param key
   * @returns {Element}
   */
  getKey(name) {
    const member = this.getMember(name);

    if (member) {
      return member.key;
    }

    return undefined;
  }

  /**
   * Set allows either a key/value pair to be given or an object
   * If an object is given, each key is set to its respective value
   */
  set(keyOrObject, value) {
    if (isObject(keyOrObject)) {
      Object.keys(keyOrObject).forEach((objectKey) => {
        this.set(objectKey, keyOrObject[objectKey]);
      });

      return this;
    }

    // Store as key for clarity
    const key = keyOrObject;
    const member = this.getMember(key);

    if (member) {
      member.value = value;
    } else {
      this.content.push(new MemberElement(key, value));
    }

    return this;
  }

  /**
   */
  keys() {
    return this.content.map(item => item.key.toValue());
  }

  /**
   */
  values() {
    return this.content.map(item => item.value.toValue());
  }

  /**
   * @returns {boolean}
   */
  hasKey(value) {
    return this.content.some(member => member.key.equals(value));
  }

  /**
   * @returns {array}
   */
  items() {
    return this.content.map(item => [item.key.toValue(), item.value.toValue()]);
  }

  /**
   * @param callback
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   */
  map(callback, thisArg) {
    return this.content.map(item => callback.bind(thisArg)(item.value, item.key, item));
  }

  /**
   * Returns an array containing the truthy results of calling the given transformation with each element of this sequence
   * @param transform - A closure that accepts the value, key and member element of this object as its argument and returns an optional value.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns An array of the non-undefined results of calling transform with each element of the array
   */
  compactMap(callback, thisArg) {
    const results = [];

    this.forEach((value, key, member) => {
      const result = callback.bind(thisArg)(value, key, member);

      if (result) {
        results.push(result);
      }
    });

    return results;
  }

  /**
   * @param callback
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   *
   * @returns {ObjectSlice}
   */
  filter(callback, thisArg) {
    return new ObjectSlice(this.content).filter(callback, thisArg);
  }

  /**
   * @param callback
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   *
   * @returns {ObjectSlice}
   *
   * @memberof ObjectElement.prototype
   */
  reject(callback, thisArg) {
    return this.filter(negate(callback), thisArg);
  }

  /**
   * @param callback
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   *
   * @memberof ObjectElement.prototype
   */
  forEach(callback, thisArg) {
    return this.content.forEach(item => callback.bind(thisArg)(item.value, item.key, item));
  }
}

module.exports = ObjectElement;


/***/ }),

/***/ 71167:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(10316);

/**
 * @class StringElement
 *
 * @param {string} content
 * @param meta
 * @param attributes
 */
module.exports = class StringElement extends Element {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'string';
  }

  primitive() {
    return 'string';
  }

  /**
   * The length of the string.
   * @type number
   */
  get length() {
    return this.content.length;
  }
};


/***/ }),

/***/ 75147:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const JSONSerialiser = __webpack_require__(85105);

module.exports = class JSON06Serialiser extends JSONSerialiser {
  serialise(element) {
    if (!(element instanceof this.namespace.elements.Element)) {
      throw new TypeError(`Given element \`${element}\` is not an Element instance`);
    }

    let variable;
    if (element._attributes && element.attributes.get('variable')) {
      variable = element.attributes.get('variable');
    }

    const payload = {
      element: element.element,
    };

    if (element._meta && element._meta.length > 0) {
      payload.meta = this.serialiseObject(element.meta);
    }

    const isEnum = (element.element === 'enum' || element.attributes.keys().indexOf('enumerations') !== -1);

    if (isEnum) {
      const attributes = this.enumSerialiseAttributes(element);

      if (attributes) {
        payload.attributes = attributes;
      }
    } else if (element._attributes && element._attributes.length > 0) {
      let { attributes } = element;

      // Meta attribute was renamed to metadata
      if (attributes.get('metadata')) {
        attributes = attributes.clone();
        attributes.set('meta', attributes.get('metadata'));
        attributes.remove('metadata');
      }

      if (element.element === 'member' && variable) {
        attributes = attributes.clone();
        attributes.remove('variable');
      }

      if (attributes.length > 0) {
        payload.attributes = this.serialiseObject(attributes);
      }
    }

    if (isEnum) {
      payload.content = this.enumSerialiseContent(element, payload);
    } else if (this[`${element.element}SerialiseContent`]) {
      payload.content = this[`${element.element}SerialiseContent`](element, payload);
    } else if (element.content !== undefined) {
      let content;

      if (variable && element.content.key) {
        content = element.content.clone();
        content.key.attributes.set('variable', variable);
        content = this.serialiseContent(content);
      } else {
        content = this.serialiseContent(element.content);
      }

      if (this.shouldSerialiseContent(element, content)) {
        payload.content = content;
      }
    } else if (this.shouldSerialiseContent(element, element.content) && element instanceof this.namespace.elements.Array) {
      payload.content = [];
    }

    return payload;
  }

  shouldSerialiseContent(element, content) {
    if (element.element === 'parseResult' || element.element === 'httpRequest'
        || element.element === 'httpResponse' || element.element === 'category'
        || element.element === 'link') {
      return true;
    }

    if (content === undefined) {
      return false;
    }

    if (Array.isArray(content) && content.length === 0) {
      return false;
    }

    return true;
  }

  refSerialiseContent(element, payload) {
    delete payload.attributes;

    return {
      href: element.toValue(),
      path: element.path.toValue(),
    };
  }

  sourceMapSerialiseContent(element) {
    return element.toValue();
  }

  dataStructureSerialiseContent(element) {
    return [this.serialiseContent(element.content)];
  }

  enumSerialiseAttributes(element) {
    const attributes = element.attributes.clone();

    // Enumerations attribute was is placed inside content (see `enumSerialiseContent` below)
    const enumerations = attributes.remove('enumerations') || new this.namespace.elements.Array([]);

    // Remove fixed type attribute from samples and default
    const defaultValue = attributes.get('default');
    let samples = attributes.get('samples') || new this.namespace.elements.Array([]);

    if (defaultValue && defaultValue.content) {
      if (defaultValue.content.attributes) {
        defaultValue.content.attributes.remove('typeAttributes');
      }
      // Wrap default in array (not sure it is really needed because tests pass without this line)
      attributes.set('default', new this.namespace.elements.Array([defaultValue.content]));
    }

    // Strip typeAttributes from samples, 0.6 doesn't usually contain them in samples
    samples.forEach((sample) => {
      if (sample.content && sample.content.element) {
        sample.content.attributes.remove('typeAttributes');
      }
    });

    // Content -> Samples
    if (element.content && enumerations.length !== 0) {
      // If we don't have enumerations, content should stay in
      // content (enumerations) as per Drafter 3 behaviour.
      samples.unshift(element.content);
    }

    samples = samples.map((sample) => {
      if (sample instanceof this.namespace.elements.Array) {
        return [sample];
      }

      return new this.namespace.elements.Array([sample.content]);
    });

    if (samples.length) {
      attributes.set('samples', samples);
    }

    if (attributes.length > 0) {
      return this.serialiseObject(attributes);
    }

    return undefined;
  }

  enumSerialiseContent(element) {
    // In API Elements < 1.0, the content is the enumerations
    // If we don't have an enumerations, use the value (Drafter 3 behaviour)

    if (element._attributes) {
      const enumerations = element.attributes.get('enumerations');

      if (enumerations && enumerations.length > 0) {
        return enumerations.content.map((enumeration) => {
          const e = enumeration.clone();
          e.attributes.remove('typeAttributes');
          return this.serialise(e);
        });
      }
    }

    if (element.content) {
      const value = element.content.clone();
      value.attributes.remove('typeAttributes');
      return [this.serialise(value)];
    }

    return [];
  }

  deserialise(value) {
    if (typeof value === 'string') {
      return new this.namespace.elements.String(value);
    }

    if (typeof value === 'number') {
      return new this.namespace.elements.Number(value);
    }

    if (typeof value === 'boolean') {
      return new this.namespace.elements.Boolean(value);
    }

    if (value === null) {
      return new this.namespace.elements.Null();
    }

    if (Array.isArray(value)) {
      return new this.namespace.elements.Array(value.map(this.deserialise, this));
    }

    const ElementClass = this.namespace.getElementClass(value.element);
    const element = new ElementClass();

    if (element.element !== value.element) {
      element.element = value.element;
    }

    if (value.meta) {
      this.deserialiseObject(value.meta, element.meta);
    }

    if (value.attributes) {
      this.deserialiseObject(value.attributes, element.attributes);
    }

    const content = this.deserialiseContent(value.content);
    if (content !== undefined || element.content === null) {
      element.content = content;
    }

    if (element.element === 'enum') {
      // Grab enumerations from content
      if (element.content) {
        element.attributes.set('enumerations', element.content);
      }

      // Unwrap the sample value (inside double array)
      let samples = element.attributes.get('samples');
      element.attributes.remove('samples');

      if (samples) {
        // Re-wrap samples from array of array to array of enum's

        const existingSamples = samples;

        samples = new this.namespace.elements.Array();
        existingSamples.forEach((existingSample) => {
          existingSample.forEach((sample) => {
            const enumElement = new ElementClass(sample);
            enumElement.element = element.element;
            samples.push(enumElement);
          });
        });

        const sample = samples.shift();

        if (sample) {
          element.content = sample.content;
        } else {
          element.content = undefined;
        }

        element.attributes.set('samples', samples);
      } else {
        element.content = undefined;
      }

      // Unwrap the default value
      let defaultValue = element.attributes.get('default');
      if (defaultValue && defaultValue.length > 0) {
        defaultValue = defaultValue.get(0);
        const defaultElement = new ElementClass(defaultValue);
        defaultElement.element = element.element;
        element.attributes.set('default', defaultElement);
      }
    } else if (element.element === 'dataStructure' && Array.isArray(element.content)) {
      [element.content] = element.content;
    } else if (element.element === 'category') {
      // "meta" attribute has been renamed to metadata
      const metadata = element.attributes.get('meta');

      if (metadata) {
        element.attributes.set('metadata', metadata);
        element.attributes.remove('meta');
      }
    } else if (element.element === 'member' && element.key && element.key._attributes && element.key._attributes.getValue('variable')) {
      element.attributes.set('variable', element.key.attributes.get('variable'));
      element.key.attributes.remove('variable');
    }

    return element;
  }

  // Private API

  serialiseContent(content) {
    if (content instanceof this.namespace.elements.Element) {
      return this.serialise(content);
    }

    if (content instanceof this.namespace.KeyValuePair) {
      const pair = {
        key: this.serialise(content.key),
      };

      if (content.value) {
        pair.value = this.serialise(content.value);
      }

      return pair;
    }

    if (content && content.map) {
      return content.map(this.serialise, this);
    }

    return content;
  }

  deserialiseContent(content) {
    if (content) {
      if (content.element) {
        return this.deserialise(content);
      }

      if (content.key) {
        const pair = new this.namespace.KeyValuePair(this.deserialise(content.key));

        if (content.value) {
          pair.value = this.deserialise(content.value);
        }

        return pair;
      }

      if (content.map) {
        return content.map(this.deserialise, this);
      }
    }

    return content;
  }

  shouldRefract(element) {
    if ((element._attributes && element.attributes.keys().length) || (element._meta && element.meta.keys().length)) {
      return true;
    }

    if (element.element === 'enum') {
      // enum elements are treated like primitives (array)
      return false;
    }

    if (element.element !== element.primitive() || element.element === 'member') {
      return true;
    }

    return false;
  }

  convertKeyToRefract(key, item) {
    if (this.shouldRefract(item)) {
      return this.serialise(item);
    }

    if (item.element === 'enum') {
      return this.serialiseEnum(item);
    }

    if (item.element === 'array') {
      return item.map((subItem) => {
        if (this.shouldRefract(subItem) || key === 'default') {
          return this.serialise(subItem);
        }

        if (subItem.element === 'array' || subItem.element === 'object' || subItem.element === 'enum') {
          // items for array or enum inside array are always serialised
          return subItem.children.map(subSubItem => this.serialise(subSubItem));
        }

        return subItem.toValue();
      });
    }

    if (item.element === 'object') {
      return (item.content || []).map(this.serialise, this);
    }

    return item.toValue();
  }

  serialiseEnum(element) {
    return element.children.map(item => this.serialise(item));
  }

  serialiseObject(obj) {
    const result = {};

    obj.forEach((value, key) => {
      if (value) {
        const keyValue = key.toValue();
        result[keyValue] = this.convertKeyToRefract(keyValue, value);
      }
    });

    return result;
  }

  deserialiseObject(from, to) {
    Object.keys(from).forEach((key) => {
      to.set(key, this.deserialise(from[key]));
    });
  }
};


/***/ }),

/***/ 85105:
/***/ ((module) => {

/**
 * @class JSONSerialiser
 *
 * @param {Namespace} namespace
 *
 * @property {Namespace} namespace
 */
class JSONSerialiser {
  constructor(namespace) {
    this.namespace = namespace || new this.Namespace();
  }

  /**
   * @param {Element} element
   * @returns {object}
   */
  serialise(element) {
    if (!(element instanceof this.namespace.elements.Element)) {
      throw new TypeError(`Given element \`${element}\` is not an Element instance`);
    }

    const payload = {
      element: element.element,
    };

    if (element._meta && element._meta.length > 0) {
      payload.meta = this.serialiseObject(element.meta);
    }

    if (element._attributes && element._attributes.length > 0) {
      payload.attributes = this.serialiseObject(element.attributes);
    }

    const content = this.serialiseContent(element.content);

    if (content !== undefined) {
      payload.content = content;
    }

    return payload;
  }

  /**
   * @param {object} value
   * @returns {Element}
   */
  deserialise(value) {
    if (!value.element) {
      throw new Error('Given value is not an object containing an element name');
    }

    const ElementClass = this.namespace.getElementClass(value.element);
    const element = new ElementClass();

    if (element.element !== value.element) {
      element.element = value.element;
    }

    if (value.meta) {
      this.deserialiseObject(value.meta, element.meta);
    }

    if (value.attributes) {
      this.deserialiseObject(value.attributes, element.attributes);
    }

    const content = this.deserialiseContent(value.content);
    if (content !== undefined || element.content === null) {
      element.content = content;
    }

    return element;
  }

  // Private API

  serialiseContent(content) {
    if (content instanceof this.namespace.elements.Element) {
      return this.serialise(content);
    }

    if (content instanceof this.namespace.KeyValuePair) {
      const pair = {
        key: this.serialise(content.key),
      };

      if (content.value) {
        pair.value = this.serialise(content.value);
      }

      return pair;
    }

    if (content && content.map) {
      if (content.length === 0) {
        return undefined;
      }

      return content.map(this.serialise, this);
    }

    return content;
  }

  deserialiseContent(content) {
    if (content) {
      if (content.element) {
        return this.deserialise(content);
      }

      if (content.key) {
        const pair = new this.namespace.KeyValuePair(this.deserialise(content.key));

        if (content.value) {
          pair.value = this.deserialise(content.value);
        }

        return pair;
      }

      if (content.map) {
        return content.map(this.deserialise, this);
      }
    }

    return content;
  }

  serialiseObject(obj) {
    const result = {};

    obj.forEach((value, key) => {
      if (value) {
        result[key.toValue()] = this.serialise(value);
      }
    });

    if (Object.keys(result).length === 0) {
      return undefined;
    }

    return result;
  }

  deserialiseObject(from, to) {
    Object.keys(from).forEach((key) => {
      to.set(key, this.deserialise(from[key]));
    });
  }
}


module.exports = JSONSerialiser;


/***/ }),

/***/ 65606:
/***/ ((module) => {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),

/***/ 8068:
/***/ ((module) => {

"use strict";

var ShortUniqueId = (() => {
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getOwnPropSymbols = Object.getOwnPropertySymbols;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __propIsEnum = Object.prototype.propertyIsEnumerable;
  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __spreadValues = (a, b) => {
    for (var prop in b || (b = {}))
      if (__hasOwnProp.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    if (__getOwnPropSymbols)
      for (var prop of __getOwnPropSymbols(b)) {
        if (__propIsEnum.call(b, prop))
          __defNormalProp(a, prop, b[prop]);
      }
    return a;
  };
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
  var __publicField = (obj, key, value) => {
    __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
    return value;
  };

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    DEFAULT_OPTIONS: () => DEFAULT_OPTIONS,
    DEFAULT_UUID_LENGTH: () => DEFAULT_UUID_LENGTH,
    default: () => ShortUniqueId
  });

  // package.json
  var version = "5.2.0";

  // src/index.ts
  var DEFAULT_UUID_LENGTH = 6;
  var DEFAULT_OPTIONS = {
    dictionary: "alphanum",
    shuffle: true,
    debug: false,
    length: DEFAULT_UUID_LENGTH,
    counter: 0
  };
  var _ShortUniqueId = class _ShortUniqueId {
    constructor(argOptions = {}) {
      __publicField(this, "counter");
      __publicField(this, "debug");
      __publicField(this, "dict");
      __publicField(this, "version");
      __publicField(this, "dictIndex", 0);
      __publicField(this, "dictRange", []);
      __publicField(this, "lowerBound", 0);
      __publicField(this, "upperBound", 0);
      __publicField(this, "dictLength", 0);
      __publicField(this, "uuidLength");
      __publicField(this, "_digit_first_ascii", 48);
      __publicField(this, "_digit_last_ascii", 58);
      __publicField(this, "_alpha_lower_first_ascii", 97);
      __publicField(this, "_alpha_lower_last_ascii", 123);
      __publicField(this, "_hex_last_ascii", 103);
      __publicField(this, "_alpha_upper_first_ascii", 65);
      __publicField(this, "_alpha_upper_last_ascii", 91);
      __publicField(this, "_number_dict_ranges", {
        digits: [this._digit_first_ascii, this._digit_last_ascii]
      });
      __publicField(this, "_alpha_dict_ranges", {
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii],
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      });
      __publicField(this, "_alpha_lower_dict_ranges", {
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii]
      });
      __publicField(this, "_alpha_upper_dict_ranges", {
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      });
      __publicField(this, "_alphanum_dict_ranges", {
        digits: [this._digit_first_ascii, this._digit_last_ascii],
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii],
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      });
      __publicField(this, "_alphanum_lower_dict_ranges", {
        digits: [this._digit_first_ascii, this._digit_last_ascii],
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii]
      });
      __publicField(this, "_alphanum_upper_dict_ranges", {
        digits: [this._digit_first_ascii, this._digit_last_ascii],
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      });
      __publicField(this, "_hex_dict_ranges", {
        decDigits: [this._digit_first_ascii, this._digit_last_ascii],
        alphaDigits: [this._alpha_lower_first_ascii, this._hex_last_ascii]
      });
      __publicField(this, "_dict_ranges", {
        _number_dict_ranges: this._number_dict_ranges,
        _alpha_dict_ranges: this._alpha_dict_ranges,
        _alpha_lower_dict_ranges: this._alpha_lower_dict_ranges,
        _alpha_upper_dict_ranges: this._alpha_upper_dict_ranges,
        _alphanum_dict_ranges: this._alphanum_dict_ranges,
        _alphanum_lower_dict_ranges: this._alphanum_lower_dict_ranges,
        _alphanum_upper_dict_ranges: this._alphanum_upper_dict_ranges,
        _hex_dict_ranges: this._hex_dict_ranges
      });
      /* tslint:disable consistent-return */
      __publicField(this, "log", (...args) => {
        const finalArgs = [...args];
        finalArgs[0] = `[short-unique-id] ${args[0]}`;
        if (this.debug === true) {
          if (typeof console !== "undefined" && console !== null) {
            return console.log(...finalArgs);
          }
        }
      });
      /* tslint:enable consistent-return */
      __publicField(this, "_normalizeDictionary", (dictionary, shuffle) => {
        let finalDict;
        if (dictionary && Array.isArray(dictionary) && dictionary.length > 1) {
          finalDict = dictionary;
        } else {
          finalDict = [];
          let i;
          this.dictIndex = i = 0;
          const rangesName = `_${dictionary}_dict_ranges`;
          const ranges = this._dict_ranges[rangesName];
          Object.keys(ranges).forEach((rangeType) => {
            const rangeTypeKey = rangeType;
            this.dictRange = ranges[rangeTypeKey];
            this.lowerBound = this.dictRange[0];
            this.upperBound = this.dictRange[1];
            for (this.dictIndex = i = this.lowerBound; this.lowerBound <= this.upperBound ? i < this.upperBound : i > this.upperBound; this.dictIndex = this.lowerBound <= this.upperBound ? i += 1 : i -= 1) {
              finalDict.push(String.fromCharCode(this.dictIndex));
            }
          });
        }
        if (shuffle) {
          const PROBABILITY = 0.5;
          finalDict = finalDict.sort(() => Math.random() - PROBABILITY);
        }
        return finalDict;
      });
      /** Change the dictionary after initialization. */
      __publicField(this, "setDictionary", (dictionary, shuffle) => {
        this.dict = this._normalizeDictionary(dictionary, shuffle);
        this.dictLength = this.dict.length;
        this.setCounter(0);
      });
      __publicField(this, "seq", () => {
        return this.sequentialUUID();
      });
      /**
       * Generates UUID based on internal counter that's incremented after each ID generation.
       * @alias `const uid = new ShortUniqueId(); uid.seq();`
       */
      __publicField(this, "sequentialUUID", () => {
        let counterDiv;
        let counterRem;
        let id = "";
        counterDiv = this.counter;
        do {
          counterRem = counterDiv % this.dictLength;
          counterDiv = Math.trunc(counterDiv / this.dictLength);
          id += this.dict[counterRem];
        } while (counterDiv !== 0);
        this.counter += 1;
        return id;
      });
      __publicField(this, "rnd", (uuidLength = this.uuidLength || DEFAULT_UUID_LENGTH) => {
        return this.randomUUID(uuidLength);
      });
      /**
       * Generates UUID by creating each part randomly.
       * @alias `const uid = new ShortUniqueId(); uid.rnd(uuidLength: number);`
       */
      __publicField(this, "randomUUID", (uuidLength = this.uuidLength || DEFAULT_UUID_LENGTH) => {
        let id;
        let randomPartIdx;
        let j;
        if (uuidLength === null || typeof uuidLength === "undefined" || uuidLength < 1) {
          throw new Error("Invalid UUID Length Provided");
        }
        const isPositive = uuidLength >= 0;
        id = "";
        for (j = 0; j < uuidLength; j += 1) {
          randomPartIdx = parseInt(
            (Math.random() * this.dictLength).toFixed(0),
            10
          ) % this.dictLength;
          id += this.dict[randomPartIdx];
        }
        return id;
      });
      __publicField(this, "fmt", (format, date) => {
        return this.formattedUUID(format, date);
      });
      /**
       * Generates custom UUID with the provided format string.
       * @alias `const uid = new ShortUniqueId(); uid.fmt(format: string);`
       */
      __publicField(this, "formattedUUID", (format, date) => {
        const fnMap = {
          "$r": this.randomUUID,
          "$s": this.sequentialUUID,
          "$t": this.stamp
        };
        const result = format.replace(
          /\$[rs]\d{0,}|\$t0|\$t[1-9]\d{1,}/g,
          (m) => {
            const fn = m.slice(0, 2);
            const len = parseInt(m.slice(2), 10);
            if (fn === "$s") {
              return fnMap[fn]().padStart(len, "0");
            }
            if (fn === "$t" && date) {
              return fnMap[fn](len, date);
            }
            return fnMap[fn](len);
          }
        );
        return result;
      });
      /**
       * Calculates total number of possible UUIDs.
       *
       * Given that:
       *
       * - `H` is the total number of possible UUIDs
       * - `n` is the number of unique characters in the dictionary
       * - `l` is the UUID length
       *
       * Then `H` is defined as `n` to the power of `l`:
       *
       * <div style="background: white; padding: 5px; border-radius: 5px; overflow: hidden;">
       *  <img src="data:image/png;base64,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" />
       * </div>
       *
       * This function returns `H`.
       */
      __publicField(this, "availableUUIDs", (uuidLength = this.uuidLength) => {
        return parseFloat(
          Math.pow([...new Set(this.dict)].length, uuidLength).toFixed(0)
        );
      });
      /**
       * Calculates approximate number of hashes before first collision.
       *
       * Given that:
       *
       * - `H` is the total number of possible UUIDs, or in terms of this library,
       * the result of running `availableUUIDs()`
       * - the expected number of values we have to choose before finding the
       * first collision can be expressed as the quantity `Q(H)`
       *
       * Then `Q(H)` can be approximated as the square root of the product of half
       * of pi times `H`:
       *
       * <div style="background: white; padding: 5px; border-radius: 5px; overflow: hidden;">
       *  <img src="data:image/png;base64,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" />
       * </div>
       *
       * This function returns `Q(H)`.
       * 
       * (see [Poisson distribution](https://en.wikipedia.org/wiki/Poisson_distribution))
       */
      __publicField(this, "approxMaxBeforeCollision", (rounds = this.availableUUIDs(this.uuidLength)) => {
        return parseFloat(
          Math.sqrt(Math.PI / 2 * rounds).toFixed(20)
        );
      });
      /**
       * Calculates probability of generating duplicate UUIDs (a collision) in a
       * given number of UUID generation rounds.
       *
       * Given that:
       *
       * - `r` is the maximum number of times that `randomUUID()` will be called,
       * or better said the number of _rounds_
       * - `H` is the total number of possible UUIDs, or in terms of this library,
       * the result of running `availableUUIDs()`
       *
       * Then the probability of collision `p(r; H)` can be approximated as the result
       * of dividing the square root of the product of half of pi times `r` by `H`:
       *
       * <div style="background: white; padding: 5px; border-radius: 5px; overflow: hidden;">
       *  <img src="data:image/png;base64,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" />
       * </div>
       *
       * This function returns `p(r; H)`.
       * 
       * (see [Poisson distribution](https://en.wikipedia.org/wiki/Poisson_distribution))
       *
       * (Useful if you are wondering _"If I use this lib and expect to perform at most
       * `r` rounds of UUID generations, what is the probability that I will hit a duplicate UUID?"_.)
       */
      __publicField(this, "collisionProbability", (rounds = this.availableUUIDs(this.uuidLength), uuidLength = this.uuidLength) => {
        return parseFloat(
          (this.approxMaxBeforeCollision(rounds) / this.availableUUIDs(uuidLength)).toFixed(20)
        );
      });
      /**
       * Calculate a "uniqueness" score (from 0 to 1) of UUIDs based on size of
       * dictionary and chosen UUID length.
       *
       * Given that:
       *
       * - `H` is the total number of possible UUIDs, or in terms of this library,
       * the result of running `availableUUIDs()`
       * - `Q(H)` is the approximate number of hashes before first collision,
       * or in terms of this library, the result of running `approxMaxBeforeCollision()`
       *
       * Then `uniqueness` can be expressed as the additive inverse of the probability of
       * generating a "word" I had previously generated (a duplicate) at any given iteration
       * up to the the total number of possible UUIDs expressed as the quotiend of `Q(H)` and `H`:
       *
       * <div style="background: white; padding: 5px; border-radius: 5px; overflow: hidden;">
       *  <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIcAAABDCAYAAAC2nhaoAAAJK0lEQVR4Ae2dB+w9RRHHvyCgYgUVxViCBQIRFRQEFVEERVGKggYwJiAkxCgqECkRJQqiCQjSYsEYCyrFggRDSywUpSN/ihXQINUCCigK4vvEmWS5XJm99/+/37t3O8nl3tudLTc7tzM7M7snFZgVBVaSdLikrWfVYEM7x0vaqCGvJAco8BhJW0raV9IRkg6V9B5JawfKNqGcKOljTZkzTH+apEslvXKGbS5EU8+T9FlJv5Z0jKQ3S3qZpNdJ+rikuySdIekFmU/7YUnfC5Z5iqRf2XWFpPT6paTfS9oqqeuxkq6zPqe4/L7G8LdP8Pm5nqTfSHpWJb38raHAKpL2l3SPzRRPrcEh6en21v3FGKYB7VHJm0q6U9IzH5Xa/udxkp4vCRHwiF0flLSWpNVrisIgMPZnEvyDbPCfUINP0n6T2fHHkhB3BRoosOZED7hI0t8kvb4BJ01mkP8sCQZZJ82o+b2yMdMBNXmRpBNssP8YQZZ0pOHTN0RjG6xqs8pubUhjznuOpOsl3SeJNzwK6A680V2iYg8TRXVve6StZdbO1yLIki4x/O8H8feR9CdJTwzijwbtyZJuNGK+K/OpX2zl/ivphS1l0RGObslvy3rGRM+hfphwzzZEy2OA/234Hwrgg0KZv0uCSQoYBZCzvF0Q/ts9qEJ5xBDl399QHqWR/I0b8ruSd7by1BFRgLdN8FGio/AtSZdFkceAx5sC0XnTIoSvowkrGur4Yl3mRBn8wuSNvGMKhS9X33BlFH0DXScK77XneEm0wCLjPckGjYHF9tAXbjGiNukd5PeZlbw/LE/pY1Tf+EVHf7ze6p1VDu2w3B49YK+AGFzr96QGYuVfVsdpNXW4TsJysg/k6hswfK6+kfbrbkmnpwlj/M2g3myDirLYFzAeOYMx/VdhR8t/ezUj+H+XpP6I2Htrgp+jb3h3fjZReqPLZS+zcHdMxj6omMT7wnZJPXUK6cGW39eH4foGff1r4Lrf2sP+kqNv+POfMnERPCxpNU8Y4/0TyaC+cQoCYGJ3JqsTTT64fX0x2F6o/8vBPv7c8L8bxK+iHWXl25bl1TIL9x+5CtF5S/Bh9AV8H9SDnQRRVQWUSPKxpeQCJnK3b+Ds64LUvoGjsA8cZv19RZ/Ci1LmJ0aE26d4IEQFA8/1gYZ6cM6Rj88jFzDIef2sJLoA56Djv7QLuSH/QKsDB+NoAUcThLx2Cgp83eq4tcXs7DMUDrRcYHlNH/G+RuDThp9r30jrPsTq2DxNHNtvlp0QHhtCH3hRsmTctaUCFytrtOA0Zbm+8ZUmhEq6+1P66htU90mjy6gNYT59YvrOBXSLC4yI32nQNbzOzxkebvccSPUNLJddgEPvQWsLl35fONbqiIixvm3MfTneDFf2mAVSwP3O6gBfA6uNqqcS/YJZ5ypJTTESXh8DBe5rPCF4f7eVo2yEsd6U4G8YbKMODTH4z4Cbv67sQqWdZQRlKnV4tkV4uRhY14J+PH+nSYjfQ5Iut4AfT2+6v8XaaBM9dWVPsnIY6iJACCOM1Ne+4W0QNjiNUdDrGfydNxJicrkdAjHw3MqTYRgC9ra3CpkeXZoSQMRymeCbHPAlctSfcrExR5N/J9I2RjPiWaJtRuocNM6rzPl2tYXXsQKpAlPtDwyPoJ1c4E08t6MQAwNTYvJ2fYiZgLZfXeMxBh/xt9kkEg3R5SLybBNhGLHq7C5t3djAGKxEhCVUYtZAxyBo+HcWYU5MxPtscJDBvPl1UVwMXBfgQses3bacfblFb50/Gdy6i5UISqoD4o60OlzSyIvoKl4fd5gMkUl8bBbAqZicI5pzVsVzhIxyCVPsZUYtjFAMAnK4znGGIktkehdQB282+sc8wzmTgKQf5nSQ6OvdTQFjmkuVt5x6hoz7W5tN0mcgSv1HkjZJE1t+Y3Rj2TuvQAwts8Y2kQ5+1aKqb7LlnAeQjJE5UFj/kCiqyHpWOtAkCq81ZZbV0DwC1tUro3oKQSOp29Z9BGNkDhiDWZM3C18MvxETuf6Hb9r+k3ljDgKK7jXltlffxswc7kOBKfz6aA8qovjih0H5nCfg+dg01RvGzBwMKkvE2ybbD4mU2qE3FaUtbFtjl2V1iiayir7DnimVElkVgDxm5sgmVkcBFHwMaawAlxLYKnFhn6VrtdOFOaoUme4/sRfs3l9KQDQ27QXO6ldhjixyjQu5MMe4xjvraQtzZJFrXMiFOcY13llPu7yYAxc2fgo260x79dm0w7KU5Vu54jTo3AC+vJgDZxZb7iIbdLpwzsti7/8jsyPsH+XKogGBR62wvJijtZGSOUwKFOYY5rjNpNeFOWZC5mE2UphjmOM2k17jC8Aj+amZtFYaGQwFCFQlEATm+MZgel06usIowK5uIp8JVuUwD49j4H7DJCKaZSRbCt+wwnpQKp5bCnBcEedxshW/6SIsfl7D3uaRsNCUs8GIdOdwufT60uToqVMr9GSrArvuTq7gejlezshpP/NIi9KnCgXY2sCxk8zKHpNLuCG71d422X9LnCmByw5sZWBmJv7Dj4xg5uY8U6zMBA5NFaTjDZX7fFHgTBPVbHuIAPGnLtIj+AVnoBRAwceFwGAza0TAj7M8LoJccIZLARyGMAYXu+O7AL3C8d/ZhVzyh00BziNnsP8z0R/YAtIFbMsEH/0k3RLZVa7kD5ACftY6O+MjgG0J5pjmiKpIOwVniSlAxDk76BjsqL7hm6qKvrHEg7eim2dDE4zBFdE32Kzt+EXfWNGjs8T1c+g8gx3VNzgwBnz0jeyjEZb4WUvzmRRwfeOBlrM10jM3XKQUfSOT0ENDR9/gjFBmAs4YbXJLpOmOX/SNoY12Zn/TE48jDkuObnJ9g4DoAgtMgY/YYPN9lscHnjO1bxR9I0CwIaO4P+WnwYfwox/K0Y9Bgg0VDX2DrRaIiegBOK6Mfn6oD136HaMAG4Ncf4h83yX1pxR9I0bjwWLxSXCYg/PJ646srD4Y348Fv9g3qpRZwP8c4chgc1hKBPxrC0XfiFBrwDh8S94/THx48DlK/EaQUENGQxF1EzgzB19cIK0JCBNMv9DEBwRhrgILRAE+icFXqLmqG8I5fH5Z5Vn5ymQVz/+Dz0G5q1bKzOzv/wAvzKhnhyEMfQAAAABJRU5ErkJggg==" />
       * </div>
       *
       * (Useful if you need a value to rate the "quality" of the combination of given dictionary
       * and UUID length. The closer to 1, higher the uniqueness and thus better the quality.)
       */
      __publicField(this, "uniqueness", (rounds = this.availableUUIDs(this.uuidLength)) => {
        const score = parseFloat(
          (1 - this.approxMaxBeforeCollision(rounds) / rounds).toFixed(20)
        );
        return score > 1 ? 1 : score < 0 ? 0 : score;
      });
      /**
       * Return the version of this module.
       */
      __publicField(this, "getVersion", () => {
        return this.version;
      });
      /**
       * Generates a UUID with a timestamp that can be extracted using `uid.parseStamp(stampString);`.
       * 
       * ```js
       *  const uidWithTimestamp = uid.stamp(32);
       *  console.log(uidWithTimestamp);
       *  // GDa608f973aRCHLXQYPTbKDbjDeVsSb3
       * 
       *  console.log(uid.parseStamp(uidWithTimestamp));
       *  // 2021-05-03T06:24:58.000Z
       *  ```
       */
      __publicField(this, "stamp", (finalLength, date) => {
        const hexStamp = Math.floor(+(date || /* @__PURE__ */ new Date()) / 1e3).toString(16);
        if (typeof finalLength === "number" && finalLength === 0) {
          return hexStamp;
        }
        if (typeof finalLength !== "number" || finalLength < 10) {
          throw new Error(
            [
              "Param finalLength must be a number greater than or equal to 10,",
              "or 0 if you want the raw hexadecimal timestamp"
            ].join("\n")
          );
        }
        const idLength = finalLength - 9;
        const rndIdx = Math.round(Math.random() * (idLength > 15 ? 15 : idLength));
        const id = this.randomUUID(idLength);
        return `${id.substring(0, rndIdx)}${hexStamp}${id.substring(rndIdx)}${rndIdx.toString(16)}`;
      });
      /**
       * Extracts the date embeded in a UUID generated using the `uid.stamp(finalLength);` method.
       * 
       * ```js
       *  const uidWithTimestamp = uid.stamp(32);
       *  console.log(uidWithTimestamp);
       *  // GDa608f973aRCHLXQYPTbKDbjDeVsSb3
       * 
       *  console.log(uid.parseStamp(uidWithTimestamp));
       *  // 2021-05-03T06:24:58.000Z
       *  ```
       */
      __publicField(this, "parseStamp", (suid, format) => {
        if (format && !/t0|t[1-9]\d{1,}/.test(format)) {
          throw new Error("Cannot extract date from a formated UUID with no timestamp in the format");
        }
        const stamp = format ? format.replace(
          /\$[rs]\d{0,}|\$t0|\$t[1-9]\d{1,}/g,
          (m) => {
            const fnMap = {
              "$r": (len2) => [...Array(len2)].map(() => "r").join(""),
              "$s": (len2) => [...Array(len2)].map(() => "s").join(""),
              "$t": (len2) => [...Array(len2)].map(() => "t").join("")
            };
            const fn = m.slice(0, 2);
            const len = parseInt(m.slice(2), 10);
            return fnMap[fn](len);
          }
        ).replace(
          /^(.*?)(t{8,})(.*)$/g,
          (_m, p1, p2) => {
            return suid.substring(p1.length, p1.length + p2.length);
          }
        ) : suid;
        if (stamp.length === 8) {
          return new Date(parseInt(stamp, 16) * 1e3);
        }
        if (stamp.length < 10) {
          throw new Error("Stamp length invalid");
        }
        const rndIdx = parseInt(stamp.substring(stamp.length - 1), 16);
        return new Date(parseInt(stamp.substring(rndIdx, rndIdx + 8), 16) * 1e3);
      });
      /**
       * Set the counter to a specific value.
       */
      __publicField(this, "setCounter", (counter) => {
        this.counter = counter;
      });
      /**
       * Validate given UID contains only characters from the instanced dictionary or optionally provided dictionary.
       */
      __publicField(this, "validate", (uid, dictionary) => {
        const finalDictionary = dictionary ? this._normalizeDictionary(dictionary) : this.dict;
        return uid.split("").every((c) => finalDictionary.includes(c));
      });
      const options = __spreadValues(__spreadValues({}, DEFAULT_OPTIONS), argOptions);
      this.counter = 0;
      this.debug = false;
      this.dict = [];
      this.version = version;
      const {
        dictionary,
        shuffle,
        length,
        counter
      } = options;
      this.uuidLength = length;
      this.setDictionary(dictionary, shuffle);
      this.setCounter(counter);
      this.debug = options.debug;
      this.log(this.dict);
      this.log(
        `Generator instantiated with Dictionary Size ${this.dictLength} and counter set to ${this.counter}`
      );
      this.log = this.log.bind(this);
      this.setDictionary = this.setDictionary.bind(this);
      this.setCounter = this.setCounter.bind(this);
      this.seq = this.seq.bind(this);
      this.sequentialUUID = this.sequentialUUID.bind(this);
      this.rnd = this.rnd.bind(this);
      this.randomUUID = this.randomUUID.bind(this);
      this.fmt = this.fmt.bind(this);
      this.formattedUUID = this.formattedUUID.bind(this);
      this.availableUUIDs = this.availableUUIDs.bind(this);
      this.approxMaxBeforeCollision = this.approxMaxBeforeCollision.bind(this);
      this.collisionProbability = this.collisionProbability.bind(this);
      this.uniqueness = this.uniqueness.bind(this);
      this.getVersion = this.getVersion.bind(this);
      this.stamp = this.stamp.bind(this);
      this.parseStamp = this.parseStamp.bind(this);
      return this;
    }
  };
  /** @hidden */
  __publicField(_ShortUniqueId, "default", _ShortUniqueId);
  var ShortUniqueId = _ShortUniqueId;
  return __toCommonJS(src_exports);
})();
//# sourceMappingURL=short-unique-id.js.map
 true&&(module.exports=ShortUniqueId.default),'undefined'!=typeof window&&(ShortUniqueId=ShortUniqueId.default);

/***/ }),

/***/ 6993:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mixin: () => (/* binding */ Mixin),
/* harmony export */   decorate: () => (/* binding */ decorate),
/* harmony export */   hasMixin: () => (/* binding */ hasMixin),
/* harmony export */   mix: () => (/* binding */ mix),
/* harmony export */   settings: () => (/* binding */ settings)
/* harmony export */ });
/**
 * Utility function that works like `Object.apply`, but copies getters and setters properly as well.  Additionally gives
 * the option to exclude properties by name.
 */
const copyProps = (dest, src, exclude = []) => {
    const props = Object.getOwnPropertyDescriptors(src);
    for (let prop of exclude)
        delete props[prop];
    Object.defineProperties(dest, props);
};
/**
 * Returns the full chain of prototypes up until Object.prototype given a starting object.  The order of prototypes will
 * be closest to farthest in the chain.
 */
const protoChain = (obj, currentChain = [obj]) => {
    const proto = Object.getPrototypeOf(obj);
    if (proto === null)
        return currentChain;
    return protoChain(proto, [...currentChain, proto]);
};
/**
 * Identifies the nearest ancestor common to all the given objects in their prototype chains.  For most unrelated
 * objects, this function should return Object.prototype.
 */
const nearestCommonProto = (...objs) => {
    if (objs.length === 0)
        return undefined;
    let commonProto = undefined;
    const protoChains = objs.map(obj => protoChain(obj));
    while (protoChains.every(protoChain => protoChain.length > 0)) {
        const protos = protoChains.map(protoChain => protoChain.pop());
        const potentialCommonProto = protos[0];
        if (protos.every(proto => proto === potentialCommonProto))
            commonProto = potentialCommonProto;
        else
            break;
    }
    return commonProto;
};
/**
 * Creates a new prototype object that is a mixture of the given prototypes.  The mixing is achieved by first
 * identifying the nearest common ancestor and using it as the prototype for a new object.  Then all properties/methods
 * downstream of this prototype (ONLY downstream) are copied into the new object.
 *
 * The resulting prototype is more performant than softMixProtos(...), as well as ES5 compatible.  However, it's not as
 * flexible as updates to the source prototypes aren't captured by the mixed result.  See softMixProtos for why you may
 * want to use that instead.
 */
const hardMixProtos = (ingredients, constructor, exclude = []) => {
    var _a;
    const base = (_a = nearestCommonProto(...ingredients)) !== null && _a !== void 0 ? _a : Object.prototype;
    const mixedProto = Object.create(base);
    // Keeps track of prototypes we've already visited to avoid copying the same properties multiple times.  We init the
    // list with the proto chain below the nearest common ancestor because we don't want any of those methods mixed in
    // when they will already be accessible via prototype access.
    const visitedProtos = protoChain(base);
    for (let prototype of ingredients) {
        let protos = protoChain(prototype);
        // Apply the prototype chain in reverse order so that old methods don't override newer ones.
        for (let i = protos.length - 1; i >= 0; i--) {
            let newProto = protos[i];
            if (visitedProtos.indexOf(newProto) === -1) {
                copyProps(mixedProto, newProto, ['constructor', ...exclude]);
                visitedProtos.push(newProto);
            }
        }
    }
    mixedProto.constructor = constructor;
    return mixedProto;
};
const unique = (arr) => arr.filter((e, i) => arr.indexOf(e) == i);

/**
 * Finds the ingredient with the given prop, searching in reverse order and breadth-first if searching ingredient
 * prototypes is required.
 */
const getIngredientWithProp = (prop, ingredients) => {
    const protoChains = ingredients.map(ingredient => protoChain(ingredient));
    // since we search breadth-first, we need to keep track of our depth in the prototype chains
    let protoDepth = 0;
    // not all prototype chains are the same depth, so this remains true as long as at least one of the ingredients'
    // prototype chains has an object at this depth
    let protosAreLeftToSearch = true;
    while (protosAreLeftToSearch) {
        // with the start of each horizontal slice, we assume this is the one that's deeper than any of the proto chains
        protosAreLeftToSearch = false;
        // scan through the ingredients right to left
        for (let i = ingredients.length - 1; i >= 0; i--) {
            const searchTarget = protoChains[i][protoDepth];
            if (searchTarget !== undefined && searchTarget !== null) {
                // if we find something, this is proof that this horizontal slice potentially more objects to search
                protosAreLeftToSearch = true;
                // eureka, we found it
                if (Object.getOwnPropertyDescriptor(searchTarget, prop) != undefined) {
                    return protoChains[i][0];
                }
            }
        }
        protoDepth++;
    }
    return undefined;
};
/**
 * "Mixes" ingredients by wrapping them in a Proxy.  The optional prototype argument allows the mixed object to sit
 * downstream of an existing prototype chain.  Note that "properties" cannot be added, deleted, or modified.
 */
const proxyMix = (ingredients, prototype = Object.prototype) => new Proxy({}, {
    getPrototypeOf() {
        return prototype;
    },
    setPrototypeOf() {
        throw Error('Cannot set prototype of Proxies created by ts-mixer');
    },
    getOwnPropertyDescriptor(_, prop) {
        return Object.getOwnPropertyDescriptor(getIngredientWithProp(prop, ingredients) || {}, prop);
    },
    defineProperty() {
        throw new Error('Cannot define new properties on Proxies created by ts-mixer');
    },
    has(_, prop) {
        return getIngredientWithProp(prop, ingredients) !== undefined || prototype[prop] !== undefined;
    },
    get(_, prop) {
        return (getIngredientWithProp(prop, ingredients) || prototype)[prop];
    },
    set(_, prop, val) {
        const ingredientWithProp = getIngredientWithProp(prop, ingredients);
        if (ingredientWithProp === undefined)
            throw new Error('Cannot set new properties on Proxies created by ts-mixer');
        ingredientWithProp[prop] = val;
        return true;
    },
    deleteProperty() {
        throw new Error('Cannot delete properties on Proxies created by ts-mixer');
    },
    ownKeys() {
        return ingredients
            .map(Object.getOwnPropertyNames)
            .reduce((prev, curr) => curr.concat(prev.filter(key => curr.indexOf(key) < 0)));
    },
});
/**
 * Creates a new proxy-prototype object that is a "soft" mixture of the given prototypes.  The mixing is achieved by
 * proxying all property access to the ingredients.  This is not ES5 compatible and less performant.  However, any
 * changes made to the source prototypes will be reflected in the proxy-prototype, which may be desirable.
 */
const softMixProtos = (ingredients, constructor) => proxyMix([...ingredients, { constructor }]);

const settings = {
    initFunction: null,
    staticsStrategy: 'copy',
    prototypeStrategy: 'copy',
    decoratorInheritance: 'deep',
};

// Keeps track of constituent classes for every mixin class created by ts-mixer.
const mixins = new WeakMap();
const getMixinsForClass = (clazz) => mixins.get(clazz);
const registerMixins = (mixedClass, constituents) => mixins.set(mixedClass, constituents);
const hasMixin = (instance, mixin) => {
    if (instance instanceof mixin)
        return true;
    const constructor = instance.constructor;
    const visited = new Set();
    let frontier = new Set();
    frontier.add(constructor);
    while (frontier.size > 0) {
        // check if the frontier has the mixin we're looking for.  if not, we can say we visited every item in the frontier
        if (frontier.has(mixin))
            return true;
        frontier.forEach((item) => visited.add(item));
        // build a new frontier based on the associated mixin classes and prototype chains of each frontier item
        const newFrontier = new Set();
        frontier.forEach((item) => {
            var _a;
            const itemConstituents = (_a = mixins.get(item)) !== null && _a !== void 0 ? _a : protoChain(item.prototype)
                .map((proto) => proto.constructor)
                .filter((item) => item !== null);
            if (itemConstituents)
                itemConstituents.forEach((constituent) => {
                    if (!visited.has(constituent) && !frontier.has(constituent))
                        newFrontier.add(constituent);
                });
        });
        // we have a new frontier, now search again
        frontier = newFrontier;
    }
    // if we get here, we couldn't find the mixin anywhere in the prototype chain or associated mixin classes
    return false;
};

const mergeObjectsOfDecorators = (o1, o2) => {
    var _a, _b;
    const allKeys = unique([...Object.getOwnPropertyNames(o1), ...Object.getOwnPropertyNames(o2)]);
    const mergedObject = {};
    for (let key of allKeys)
        mergedObject[key] = unique([...((_a = o1 === null || o1 === void 0 ? void 0 : o1[key]) !== null && _a !== void 0 ? _a : []), ...((_b = o2 === null || o2 === void 0 ? void 0 : o2[key]) !== null && _b !== void 0 ? _b : [])]);
    return mergedObject;
};
const mergePropertyAndMethodDecorators = (d1, d2) => {
    var _a, _b, _c, _d;
    return ({
        property: mergeObjectsOfDecorators((_a = d1 === null || d1 === void 0 ? void 0 : d1.property) !== null && _a !== void 0 ? _a : {}, (_b = d2 === null || d2 === void 0 ? void 0 : d2.property) !== null && _b !== void 0 ? _b : {}),
        method: mergeObjectsOfDecorators((_c = d1 === null || d1 === void 0 ? void 0 : d1.method) !== null && _c !== void 0 ? _c : {}, (_d = d2 === null || d2 === void 0 ? void 0 : d2.method) !== null && _d !== void 0 ? _d : {}),
    });
};
const mergeDecorators = (d1, d2) => {
    var _a, _b, _c, _d, _e, _f;
    return ({
        class: unique([...(_a = d1 === null || d1 === void 0 ? void 0 : d1.class) !== null && _a !== void 0 ? _a : [], ...(_b = d2 === null || d2 === void 0 ? void 0 : d2.class) !== null && _b !== void 0 ? _b : []]),
        static: mergePropertyAndMethodDecorators((_c = d1 === null || d1 === void 0 ? void 0 : d1.static) !== null && _c !== void 0 ? _c : {}, (_d = d2 === null || d2 === void 0 ? void 0 : d2.static) !== null && _d !== void 0 ? _d : {}),
        instance: mergePropertyAndMethodDecorators((_e = d1 === null || d1 === void 0 ? void 0 : d1.instance) !== null && _e !== void 0 ? _e : {}, (_f = d2 === null || d2 === void 0 ? void 0 : d2.instance) !== null && _f !== void 0 ? _f : {}),
    });
};
const decorators = new Map();
const findAllConstituentClasses = (...classes) => {
    var _a;
    const allClasses = new Set();
    const frontier = new Set([...classes]);
    while (frontier.size > 0) {
        for (let clazz of frontier) {
            const protoChainClasses = protoChain(clazz.prototype).map(proto => proto.constructor);
            const mixinClasses = (_a = getMixinsForClass(clazz)) !== null && _a !== void 0 ? _a : [];
            const potentiallyNewClasses = [...protoChainClasses, ...mixinClasses];
            const newClasses = potentiallyNewClasses.filter(c => !allClasses.has(c));
            for (let newClass of newClasses)
                frontier.add(newClass);
            allClasses.add(clazz);
            frontier.delete(clazz);
        }
    }
    return [...allClasses];
};
const deepDecoratorSearch = (...classes) => {
    const decoratorsForClassChain = findAllConstituentClasses(...classes)
        .map(clazz => decorators.get(clazz))
        .filter(decorators => !!decorators);
    if (decoratorsForClassChain.length == 0)
        return {};
    if (decoratorsForClassChain.length == 1)
        return decoratorsForClassChain[0];
    return decoratorsForClassChain.reduce((d1, d2) => mergeDecorators(d1, d2));
};
const directDecoratorSearch = (...classes) => {
    const classDecorators = classes.map(clazz => getDecoratorsForClass(clazz));
    if (classDecorators.length === 0)
        return {};
    if (classDecorators.length === 1)
        return classDecorators[0];
    return classDecorators.reduce((d1, d2) => mergeDecorators(d1, d2));
};
const getDecoratorsForClass = (clazz) => {
    let decoratorsForClass = decorators.get(clazz);
    if (!decoratorsForClass) {
        decoratorsForClass = {};
        decorators.set(clazz, decoratorsForClass);
    }
    return decoratorsForClass;
};
const decorateClass = (decorator) => ((clazz) => {
    const decoratorsForClass = getDecoratorsForClass(clazz);
    let classDecorators = decoratorsForClass.class;
    if (!classDecorators) {
        classDecorators = [];
        decoratorsForClass.class = classDecorators;
    }
    classDecorators.push(decorator);
    return decorator(clazz);
});
const decorateMember = (decorator) => ((object, key, ...otherArgs) => {
    var _a, _b, _c;
    const decoratorTargetType = typeof object === 'function' ? 'static' : 'instance';
    const decoratorType = typeof object[key] === 'function' ? 'method' : 'property';
    const clazz = decoratorTargetType === 'static' ? object : object.constructor;
    const decoratorsForClass = getDecoratorsForClass(clazz);
    const decoratorsForTargetType = (_a = decoratorsForClass === null || decoratorsForClass === void 0 ? void 0 : decoratorsForClass[decoratorTargetType]) !== null && _a !== void 0 ? _a : {};
    decoratorsForClass[decoratorTargetType] = decoratorsForTargetType;
    let decoratorsForType = (_b = decoratorsForTargetType === null || decoratorsForTargetType === void 0 ? void 0 : decoratorsForTargetType[decoratorType]) !== null && _b !== void 0 ? _b : {};
    decoratorsForTargetType[decoratorType] = decoratorsForType;
    let decoratorsForKey = (_c = decoratorsForType === null || decoratorsForType === void 0 ? void 0 : decoratorsForType[key]) !== null && _c !== void 0 ? _c : [];
    decoratorsForType[key] = decoratorsForKey;
    // @ts-ignore: array is type `A[] | B[]` and item is type `A | B`, so technically a type error, but it's fine
    decoratorsForKey.push(decorator);
    // @ts-ignore
    return decorator(object, key, ...otherArgs);
});
const decorate = (decorator) => ((...args) => {
    if (args.length === 1)
        return decorateClass(decorator)(args[0]);
    return decorateMember(decorator)(...args);
});

function Mixin(...constructors) {
    var _a, _b, _c;
    const prototypes = constructors.map(constructor => constructor.prototype);
    // Here we gather up the init functions of the ingredient prototypes, combine them into one init function, and
    // attach it to the mixed class prototype.  The reason we do this is because we want the init functions to mix
    // similarly to constructors -- not methods, which simply override each other.
    const initFunctionName = settings.initFunction;
    if (initFunctionName !== null) {
        const initFunctions = prototypes
            .map(proto => proto[initFunctionName])
            .filter(func => typeof func === 'function');
        const combinedInitFunction = function (...args) {
            for (let initFunction of initFunctions)
                initFunction.apply(this, args);
        };
        const extraProto = { [initFunctionName]: combinedInitFunction };
        prototypes.push(extraProto);
    }
    function MixedClass(...args) {
        for (const constructor of constructors)
            // @ts-ignore: potentially abstract class
            copyProps(this, new constructor(...args));
        if (initFunctionName !== null && typeof this[initFunctionName] === 'function')
            this[initFunctionName].apply(this, args);
    }
    MixedClass.prototype = settings.prototypeStrategy === 'copy'
        ? hardMixProtos(prototypes, MixedClass)
        : softMixProtos(prototypes, MixedClass);
    Object.setPrototypeOf(MixedClass, settings.staticsStrategy === 'copy'
        ? hardMixProtos(constructors, null, ['prototype'])
        : proxyMix(constructors, Function.prototype));
    let DecoratedMixedClass = MixedClass;
    if (settings.decoratorInheritance !== 'none') {
        const classDecorators = settings.decoratorInheritance === 'deep'
            ? deepDecoratorSearch(...constructors)
            : directDecoratorSearch(...constructors);
        for (let decorator of (_a = classDecorators === null || classDecorators === void 0 ? void 0 : classDecorators.class) !== null && _a !== void 0 ? _a : []) {
            const result = decorator(DecoratedMixedClass);
            if (result) {
                DecoratedMixedClass = result;
            }
        }
        applyPropAndMethodDecorators((_b = classDecorators === null || classDecorators === void 0 ? void 0 : classDecorators.static) !== null && _b !== void 0 ? _b : {}, DecoratedMixedClass);
        applyPropAndMethodDecorators((_c = classDecorators === null || classDecorators === void 0 ? void 0 : classDecorators.instance) !== null && _c !== void 0 ? _c : {}, DecoratedMixedClass.prototype);
    }
    registerMixins(DecoratedMixedClass, constructors);
    return DecoratedMixedClass;
}
const applyPropAndMethodDecorators = (propAndMethodDecorators, target) => {
    const propDecorators = propAndMethodDecorators.property;
    const methodDecorators = propAndMethodDecorators.method;
    if (propDecorators)
        for (let key in propDecorators)
            for (let decorator of propDecorators[key])
                decorator(target, key);
    if (methodDecorators)
        for (let key in methodDecorators)
            for (let decorator of methodDecorators[key])
                decorator(target, key, Object.getOwnPropertyDescriptor(target, key));
};
/**
 * A decorator version of the `Mixin` function.  You'll want to use this instead of `Mixin` for mixing generic classes.
 */
const mix = (...ingredients) => decoratedClass => {
    // @ts-ignore
    const mixedClass = Mixin(...ingredients.concat([decoratedClass]));
    Object.defineProperty(mixedClass, 'name', {
        value: decoratedClass.name,
        writable: false,
    });
    return mixedClass;
};




/***/ }),

/***/ 48675:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(20850);

/***/ }),

/***/ 68623:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var parent = __webpack_require__(694);

module.exports = parent;


/***/ }),

/***/ 37257:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

__webpack_require__(96605);
__webpack_require__(64502);
__webpack_require__(36371);
__webpack_require__(99363);
__webpack_require__(7057);
var path = __webpack_require__(92046);

module.exports = path.AggregateError;


/***/ }),

/***/ 20850:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

module.exports = __webpack_require__(46076);


/***/ }),

/***/ 46076:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// TODO: remove from `core-js@4`
__webpack_require__(91599);

var parent = __webpack_require__(68623);

module.exports = parent;


/***/ }),

/***/ 82159:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isCallable = __webpack_require__(62250);
var tryToString = __webpack_require__(4640);

var $TypeError = TypeError;

// `Assert: IsCallable(argument) is true`
module.exports = function (argument) {
  if (isCallable(argument)) return argument;
  throw new $TypeError(tryToString(argument) + ' is not a function');
};


/***/ }),

/***/ 10043:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isPossiblePrototype = __webpack_require__(54018);

var $String = String;
var $TypeError = TypeError;

module.exports = function (argument) {
  if (isPossiblePrototype(argument)) return argument;
  throw new $TypeError("Can't set " + $String(argument) + ' as a prototype');
};


/***/ }),

/***/ 42156:
/***/ ((module) => {

"use strict";

module.exports = function () { /* empty */ };


/***/ }),

/***/ 36624:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isObject = __webpack_require__(46285);

var $String = String;
var $TypeError = TypeError;

// `Assert: Type(argument) is Object`
module.exports = function (argument) {
  if (isObject(argument)) return argument;
  throw new $TypeError($String(argument) + ' is not an object');
};


/***/ }),

/***/ 74436:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toIndexedObject = __webpack_require__(27374);
var toAbsoluteIndex = __webpack_require__(34849);
var lengthOfArrayLike = __webpack_require__(20575);

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject($this);
    var length = lengthOfArrayLike(O);
    if (length === 0) return !IS_INCLUDES && -1;
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el !== el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value !== value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

module.exports = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod(false)
};


/***/ }),

/***/ 45807:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);

var toString = uncurryThis({}.toString);
var stringSlice = uncurryThis(''.slice);

module.exports = function (it) {
  return stringSlice(toString(it), 8, -1);
};


/***/ }),

/***/ 73948:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var TO_STRING_TAG_SUPPORT = __webpack_require__(52623);
var isCallable = __webpack_require__(62250);
var classofRaw = __webpack_require__(45807);
var wellKnownSymbol = __webpack_require__(76264);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var $Object = Object;

// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) === 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
module.exports = TO_STRING_TAG_SUPPORT ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = $Object(it), TO_STRING_TAG)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw(O)
    // ES3 arguments fallback
    : (result = classofRaw(O)) === 'Object' && isCallable(O.callee) ? 'Arguments' : result;
};


/***/ }),

/***/ 19595:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var hasOwn = __webpack_require__(49724);
var ownKeys = __webpack_require__(11042);
var getOwnPropertyDescriptorModule = __webpack_require__(13846);
var definePropertyModule = __webpack_require__(74284);

module.exports = function (target, source, exceptions) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!hasOwn(target, key) && !(exceptions && hasOwn(exceptions, key))) {
      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
    }
  }
};


/***/ }),

/***/ 57382:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(98828);

module.exports = !fails(function () {
  function F() { /* empty */ }
  F.prototype.constructor = null;
  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
  return Object.getPrototypeOf(new F()) !== F.prototype;
});


/***/ }),

/***/ 59550:
/***/ ((module) => {

"use strict";

// `CreateIterResultObject` abstract operation
// https://tc39.es/ecma262/#sec-createiterresultobject
module.exports = function (value, done) {
  return { value: value, done: done };
};


/***/ }),

/***/ 61626:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(39447);
var definePropertyModule = __webpack_require__(74284);
var createPropertyDescriptor = __webpack_require__(75817);

module.exports = DESCRIPTORS ? function (object, key, value) {
  return definePropertyModule.f(object, key, createPropertyDescriptor(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),

/***/ 75817:
/***/ ((module) => {

"use strict";

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),

/***/ 68055:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var createNonEnumerableProperty = __webpack_require__(61626);

module.exports = function (target, key, value, options) {
  if (options && options.enumerable) target[key] = value;
  else createNonEnumerableProperty(target, key, value);
  return target;
};


/***/ }),

/***/ 2532:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);

// eslint-disable-next-line es/no-object-defineproperty -- safe
var defineProperty = Object.defineProperty;

module.exports = function (key, value) {
  try {
    defineProperty(globalThis, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    globalThis[key] = value;
  } return value;
};


/***/ }),

/***/ 39447:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(98828);

// Detect IE8's incomplete defineProperty implementation
module.exports = !fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] !== 7;
});


/***/ }),

/***/ 49552:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);
var isObject = __webpack_require__(46285);

var document = globalThis.document;
// typeof document.createElement is 'object' in old IE
var EXISTS = isObject(document) && isObject(document.createElement);

module.exports = function (it) {
  return EXISTS ? document.createElement(it) : {};
};


/***/ }),

/***/ 19287:
/***/ ((module) => {

"use strict";

// iterable DOM collections
// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
module.exports = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};


/***/ }),

/***/ 80376:
/***/ ((module) => {

"use strict";

// IE8- don't enum bug keys
module.exports = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];


/***/ }),

/***/ 96794:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);

var navigator = globalThis.navigator;
var userAgent = navigator && navigator.userAgent;

module.exports = userAgent ? String(userAgent) : '';


/***/ }),

/***/ 20798:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);
var userAgent = __webpack_require__(96794);

var process = globalThis.process;
var Deno = globalThis.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
  // but their correct versions are not interesting for us
  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}

// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
// so check `userAgent` even if `.v8` exists, but 0
if (!version && userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = +match[1];
  }
}

module.exports = version;


/***/ }),

/***/ 85762:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);

var $Error = Error;
var replace = uncurryThis(''.replace);

var TEST = (function (arg) { return String(new $Error(arg).stack); })('zxcasd');
// eslint-disable-next-line redos/no-vulnerable -- safe
var V8_OR_CHAKRA_STACK_ENTRY = /\n\s*at [^:]*:[^\n]*/;
var IS_V8_OR_CHAKRA_STACK = V8_OR_CHAKRA_STACK_ENTRY.test(TEST);

module.exports = function (stack, dropEntries) {
  if (IS_V8_OR_CHAKRA_STACK && typeof stack == 'string' && !$Error.prepareStackTrace) {
    while (dropEntries--) stack = replace(stack, V8_OR_CHAKRA_STACK_ENTRY, '');
  } return stack;
};


/***/ }),

/***/ 85884:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var createNonEnumerableProperty = __webpack_require__(61626);
var clearErrorStack = __webpack_require__(85762);
var ERROR_STACK_INSTALLABLE = __webpack_require__(23888);

// non-standard V8
var captureStackTrace = Error.captureStackTrace;

module.exports = function (error, C, stack, dropEntries) {
  if (ERROR_STACK_INSTALLABLE) {
    if (captureStackTrace) captureStackTrace(error, C);
    else createNonEnumerableProperty(error, 'stack', clearErrorStack(stack, dropEntries));
  }
};


/***/ }),

/***/ 23888:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(98828);
var createPropertyDescriptor = __webpack_require__(75817);

module.exports = !fails(function () {
  var error = new Error('a');
  if (!('stack' in error)) return true;
  // eslint-disable-next-line es/no-object-defineproperty -- safe
  Object.defineProperty(error, 'stack', createPropertyDescriptor(1, 7));
  return error.stack !== 7;
});


/***/ }),

/***/ 11091:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);
var apply = __webpack_require__(76024);
var uncurryThis = __webpack_require__(92361);
var isCallable = __webpack_require__(62250);
var getOwnPropertyDescriptor = (__webpack_require__(13846).f);
var isForced = __webpack_require__(7463);
var path = __webpack_require__(92046);
var bind = __webpack_require__(28311);
var createNonEnumerableProperty = __webpack_require__(61626);
var hasOwn = __webpack_require__(49724);
// add debugging info
__webpack_require__(36128);

var wrapConstructor = function (NativeConstructor) {
  var Wrapper = function (a, b, c) {
    if (this instanceof Wrapper) {
      switch (arguments.length) {
        case 0: return new NativeConstructor();
        case 1: return new NativeConstructor(a);
        case 2: return new NativeConstructor(a, b);
      } return new NativeConstructor(a, b, c);
    } return apply(NativeConstructor, this, arguments);
  };
  Wrapper.prototype = NativeConstructor.prototype;
  return Wrapper;
};

/*
  options.target         - name of the target object
  options.global         - target is the global object
  options.stat           - export as static methods of target
  options.proto          - export as prototype methods of target
  options.real           - real prototype method for the `pure` version
  options.forced         - export even if the native feature is available
  options.bind           - bind methods to the target, required for the `pure` version
  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
  options.sham           - add a flag to not completely full polyfills
  options.enumerable     - export as enumerable property
  options.dontCallGetSet - prevent calling a getter on target
  options.name           - the .name of the function if it does not match the key
*/
module.exports = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var PROTO = options.proto;

  var nativeSource = GLOBAL ? globalThis : STATIC ? globalThis[TARGET] : globalThis[TARGET] && globalThis[TARGET].prototype;

  var target = GLOBAL ? path : path[TARGET] || createNonEnumerableProperty(path, TARGET, {})[TARGET];
  var targetPrototype = target.prototype;

  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

  for (key in source) {
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contains in native
    USE_NATIVE = !FORCED && nativeSource && hasOwn(nativeSource, key);

    targetProperty = target[key];

    if (USE_NATIVE) if (options.dontCallGetSet) {
      descriptor = getOwnPropertyDescriptor(nativeSource, key);
      nativeProperty = descriptor && descriptor.value;
    } else nativeProperty = nativeSource[key];

    // export native or implementation
    sourceProperty = (USE_NATIVE && nativeProperty) ? nativeProperty : source[key];

    if (!FORCED && !PROTO && typeof targetProperty == typeof sourceProperty) continue;

    // bind methods to global for calling from export context
    if (options.bind && USE_NATIVE) resultProperty = bind(sourceProperty, globalThis);
    // wrap global constructors for prevent changes in this version
    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty);
    // make static versions for prototype methods
    else if (PROTO && isCallable(sourceProperty)) resultProperty = uncurryThis(sourceProperty);
    // default case
    else resultProperty = sourceProperty;

    // add a flag to not completely full polyfills
    if (options.sham || (sourceProperty && sourceProperty.sham) || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty(resultProperty, 'sham', true);
    }

    createNonEnumerableProperty(target, key, resultProperty);

    if (PROTO) {
      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
      if (!hasOwn(path, VIRTUAL_PROTOTYPE)) {
        createNonEnumerableProperty(path, VIRTUAL_PROTOTYPE, {});
      }
      // export virtual prototype methods
      createNonEnumerableProperty(path[VIRTUAL_PROTOTYPE], key, sourceProperty);
      // export real prototype methods
      if (options.real && targetPrototype && (FORCED || !targetPrototype[key])) {
        createNonEnumerableProperty(targetPrototype, key, sourceProperty);
      }
    }
  }
};


/***/ }),

/***/ 98828:
/***/ ((module) => {

"use strict";

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};


/***/ }),

/***/ 76024:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var NATIVE_BIND = __webpack_require__(41505);

var FunctionPrototype = Function.prototype;
var apply = FunctionPrototype.apply;
var call = FunctionPrototype.call;

// eslint-disable-next-line es/no-reflect -- safe
module.exports = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND ? call.bind(apply) : function () {
  return call.apply(apply, arguments);
});


/***/ }),

/***/ 28311:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(92361);
var aCallable = __webpack_require__(82159);
var NATIVE_BIND = __webpack_require__(41505);

var bind = uncurryThis(uncurryThis.bind);

// optional / simple context binding
module.exports = function (fn, that) {
  aCallable(fn);
  return that === undefined ? fn : NATIVE_BIND ? bind(fn, that) : function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ 41505:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(98828);

module.exports = !fails(function () {
  // eslint-disable-next-line es/no-function-prototype-bind -- safe
  var test = (function () { /* empty */ }).bind();
  // eslint-disable-next-line no-prototype-builtins -- safe
  return typeof test != 'function' || test.hasOwnProperty('prototype');
});


/***/ }),

/***/ 13930:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var NATIVE_BIND = __webpack_require__(41505);

var call = Function.prototype.call;

module.exports = NATIVE_BIND ? call.bind(call) : function () {
  return call.apply(call, arguments);
};


/***/ }),

/***/ 36833:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(39447);
var hasOwn = __webpack_require__(49724);

var FunctionPrototype = Function.prototype;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getDescriptor = DESCRIPTORS && Object.getOwnPropertyDescriptor;

var EXISTS = hasOwn(FunctionPrototype, 'name');
// additional protection from minified / mangled / dropped function names
var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS || (DESCRIPTORS && getDescriptor(FunctionPrototype, 'name').configurable));

module.exports = {
  EXISTS: EXISTS,
  PROPER: PROPER,
  CONFIGURABLE: CONFIGURABLE
};


/***/ }),

/***/ 51871:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);
var aCallable = __webpack_require__(82159);

module.exports = function (object, key, method) {
  try {
    // eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
    return uncurryThis(aCallable(Object.getOwnPropertyDescriptor(object, key)[method]));
  } catch (error) { /* empty */ }
};


/***/ }),

/***/ 92361:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var classofRaw = __webpack_require__(45807);
var uncurryThis = __webpack_require__(1907);

module.exports = function (fn) {
  // Nashorn bug:
  //   https://github.com/zloirock/core-js/issues/1128
  //   https://github.com/zloirock/core-js/issues/1130
  if (classofRaw(fn) === 'Function') return uncurryThis(fn);
};


/***/ }),

/***/ 1907:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var NATIVE_BIND = __webpack_require__(41505);

var FunctionPrototype = Function.prototype;
var call = FunctionPrototype.call;
var uncurryThisWithBind = NATIVE_BIND && FunctionPrototype.bind.bind(call, call);

module.exports = NATIVE_BIND ? uncurryThisWithBind : function (fn) {
  return function () {
    return call.apply(fn, arguments);
  };
};


/***/ }),

/***/ 63201:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var path = __webpack_require__(92046);
var globalThis = __webpack_require__(45951);
var isCallable = __webpack_require__(62250);

var aFunction = function (variable) {
  return isCallable(variable) ? variable : undefined;
};

module.exports = function (namespace, method) {
  return arguments.length < 2 ? aFunction(path[namespace]) || aFunction(globalThis[namespace])
    : path[namespace] && path[namespace][method] || globalThis[namespace] && globalThis[namespace][method];
};


/***/ }),

/***/ 73448:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var classof = __webpack_require__(73948);
var getMethod = __webpack_require__(29367);
var isNullOrUndefined = __webpack_require__(87136);
var Iterators = __webpack_require__(93742);
var wellKnownSymbol = __webpack_require__(76264);

var ITERATOR = wellKnownSymbol('iterator');

module.exports = function (it) {
  if (!isNullOrUndefined(it)) return getMethod(it, ITERATOR)
    || getMethod(it, '@@iterator')
    || Iterators[classof(it)];
};


/***/ }),

/***/ 10300:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var call = __webpack_require__(13930);
var aCallable = __webpack_require__(82159);
var anObject = __webpack_require__(36624);
var tryToString = __webpack_require__(4640);
var getIteratorMethod = __webpack_require__(73448);

var $TypeError = TypeError;

module.exports = function (argument, usingIterator) {
  var iteratorMethod = arguments.length < 2 ? getIteratorMethod(argument) : usingIterator;
  if (aCallable(iteratorMethod)) return anObject(call(iteratorMethod, argument));
  throw new $TypeError(tryToString(argument) + ' is not iterable');
};


/***/ }),

/***/ 29367:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var aCallable = __webpack_require__(82159);
var isNullOrUndefined = __webpack_require__(87136);

// `GetMethod` abstract operation
// https://tc39.es/ecma262/#sec-getmethod
module.exports = function (V, P) {
  var func = V[P];
  return isNullOrUndefined(func) ? undefined : aCallable(func);
};


/***/ }),

/***/ 45951:
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var check = function (it) {
  return it && it.Math === Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
module.exports =
  // eslint-disable-next-line es/no-global-this -- safe
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  // eslint-disable-next-line no-restricted-globals -- safe
  check(typeof self == 'object' && self) ||
  check(typeof __webpack_require__.g == 'object' && __webpack_require__.g) ||
  check(typeof this == 'object' && this) ||
  // eslint-disable-next-line no-new-func -- fallback
  (function () { return this; })() || Function('return this')();


/***/ }),

/***/ 49724:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);
var toObject = __webpack_require__(39298);

var hasOwnProperty = uncurryThis({}.hasOwnProperty);

// `HasOwnProperty` abstract operation
// https://tc39.es/ecma262/#sec-hasownproperty
// eslint-disable-next-line es/no-object-hasown -- safe
module.exports = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty(toObject(it), key);
};


/***/ }),

/***/ 38530:
/***/ ((module) => {

"use strict";

module.exports = {};


/***/ }),

/***/ 62416:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var getBuiltIn = __webpack_require__(63201);

module.exports = getBuiltIn('document', 'documentElement');


/***/ }),

/***/ 73648:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(39447);
var fails = __webpack_require__(98828);
var createElement = __webpack_require__(49552);

// Thanks to IE8 for its funny defineProperty
module.exports = !DESCRIPTORS && !fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a !== 7;
});


/***/ }),

/***/ 16946:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);
var fails = __webpack_require__(98828);
var classof = __webpack_require__(45807);

var $Object = Object;
var split = uncurryThis(''.split);

// fallback for non-array-like ES3 and non-enumerable old V8 strings
module.exports = fails(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !$Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof(it) === 'String' ? split(it, '') : $Object(it);
} : $Object;


/***/ }),

/***/ 34084:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isCallable = __webpack_require__(62250);
var isObject = __webpack_require__(46285);
var setPrototypeOf = __webpack_require__(79192);

// makes subclassing work correct for wrapped built-ins
module.exports = function ($this, dummy, Wrapper) {
  var NewTarget, NewTargetPrototype;
  if (
    // it can work only with native `setPrototypeOf`
    setPrototypeOf &&
    // we haven't completely correct pre-ES6 way for getting `new.target`, so use this
    isCallable(NewTarget = dummy.constructor) &&
    NewTarget !== Wrapper &&
    isObject(NewTargetPrototype = NewTarget.prototype) &&
    NewTargetPrototype !== Wrapper.prototype
  ) setPrototypeOf($this, NewTargetPrototype);
  return $this;
};


/***/ }),

/***/ 39259:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isObject = __webpack_require__(46285);
var createNonEnumerableProperty = __webpack_require__(61626);

// `InstallErrorCause` abstract operation
// https://tc39.es/proposal-error-cause/#sec-errorobjects-install-error-cause
module.exports = function (O, options) {
  if (isObject(options) && 'cause' in options) {
    createNonEnumerableProperty(O, 'cause', options.cause);
  }
};


/***/ }),

/***/ 64932:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var NATIVE_WEAK_MAP = __webpack_require__(40551);
var globalThis = __webpack_require__(45951);
var isObject = __webpack_require__(46285);
var createNonEnumerableProperty = __webpack_require__(61626);
var hasOwn = __webpack_require__(49724);
var shared = __webpack_require__(36128);
var sharedKey = __webpack_require__(92522);
var hiddenKeys = __webpack_require__(38530);

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError = globalThis.TypeError;
var WeakMap = globalThis.WeakMap;
var set, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject(it) || (state = get(it)).type !== TYPE) {
      throw new TypeError('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP || shared.state) {
  var store = shared.state || (shared.state = new WeakMap());
  /* eslint-disable no-self-assign -- prototype methods protection */
  store.get = store.get;
  store.has = store.has;
  store.set = store.set;
  /* eslint-enable no-self-assign -- prototype methods protection */
  set = function (it, metadata) {
    if (store.has(it)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    store.set(it, metadata);
    return metadata;
  };
  get = function (it) {
    return store.get(it) || {};
  };
  has = function (it) {
    return store.has(it);
  };
} else {
  var STATE = sharedKey('state');
  hiddenKeys[STATE] = true;
  set = function (it, metadata) {
    if (hasOwn(it, STATE)) throw new TypeError(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return hasOwn(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return hasOwn(it, STATE);
  };
}

module.exports = {
  set: set,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};


/***/ }),

/***/ 37812:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var wellKnownSymbol = __webpack_require__(76264);
var Iterators = __webpack_require__(93742);

var ITERATOR = wellKnownSymbol('iterator');
var ArrayPrototype = Array.prototype;

// check on default Array iterator
module.exports = function (it) {
  return it !== undefined && (Iterators.Array === it || ArrayPrototype[ITERATOR] === it);
};


/***/ }),

/***/ 62250:
/***/ ((module) => {

"use strict";

// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
var documentAll = typeof document == 'object' && document.all;

// `IsCallable` abstract operation
// https://tc39.es/ecma262/#sec-iscallable
// eslint-disable-next-line unicorn/no-typeof-undefined -- required for testing
module.exports = typeof documentAll == 'undefined' && documentAll !== undefined ? function (argument) {
  return typeof argument == 'function' || argument === documentAll;
} : function (argument) {
  return typeof argument == 'function';
};


/***/ }),

/***/ 7463:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(98828);
var isCallable = __webpack_require__(62250);

var replacement = /#|\.prototype\./;

var isForced = function (feature, detection) {
  var value = data[normalize(feature)];
  return value === POLYFILL ? true
    : value === NATIVE ? false
    : isCallable(detection) ? fails(detection)
    : !!detection;
};

var normalize = isForced.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';

module.exports = isForced;


/***/ }),

/***/ 87136:
/***/ ((module) => {

"use strict";

// we can't use just `it == null` since of `document.all` special case
// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
module.exports = function (it) {
  return it === null || it === undefined;
};


/***/ }),

/***/ 46285:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isCallable = __webpack_require__(62250);

module.exports = function (it) {
  return typeof it == 'object' ? it !== null : isCallable(it);
};


/***/ }),

/***/ 54018:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isObject = __webpack_require__(46285);

module.exports = function (argument) {
  return isObject(argument) || argument === null;
};


/***/ }),

/***/ 7376:
/***/ ((module) => {

"use strict";

module.exports = true;


/***/ }),

/***/ 25594:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var getBuiltIn = __webpack_require__(63201);
var isCallable = __webpack_require__(62250);
var isPrototypeOf = __webpack_require__(88280);
var USE_SYMBOL_AS_UID = __webpack_require__(51175);

var $Object = Object;

module.exports = USE_SYMBOL_AS_UID ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn('Symbol');
  return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, $Object(it));
};


/***/ }),

/***/ 24823:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var bind = __webpack_require__(28311);
var call = __webpack_require__(13930);
var anObject = __webpack_require__(36624);
var tryToString = __webpack_require__(4640);
var isArrayIteratorMethod = __webpack_require__(37812);
var lengthOfArrayLike = __webpack_require__(20575);
var isPrototypeOf = __webpack_require__(88280);
var getIterator = __webpack_require__(10300);
var getIteratorMethod = __webpack_require__(73448);
var iteratorClose = __webpack_require__(40154);

var $TypeError = TypeError;

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

var ResultPrototype = Result.prototype;

module.exports = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_RECORD = !!(options && options.IS_RECORD);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = bind(unboundFunction, that);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) iteratorClose(iterator, 'normal', condition);
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      anObject(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    } return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_RECORD) {
    iterator = iterable.iterator;
  } else if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = getIteratorMethod(iterable);
    if (!iterFn) throw new $TypeError(tryToString(iterable) + ' is not iterable');
    // optimisation for array iterators
    if (isArrayIteratorMethod(iterFn)) {
      for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && isPrototypeOf(ResultPrototype, result)) return result;
      } return new Result(false);
    }
    iterator = getIterator(iterable, iterFn);
  }

  next = IS_RECORD ? iterable.next : iterator.next;
  while (!(step = call(next, iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      iteratorClose(iterator, 'throw', error);
    }
    if (typeof result == 'object' && result && isPrototypeOf(ResultPrototype, result)) return result;
  } return new Result(false);
};


/***/ }),

/***/ 40154:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var call = __webpack_require__(13930);
var anObject = __webpack_require__(36624);
var getMethod = __webpack_require__(29367);

module.exports = function (iterator, kind, value) {
  var innerResult, innerError;
  anObject(iterator);
  try {
    innerResult = getMethod(iterator, 'return');
    if (!innerResult) {
      if (kind === 'throw') throw value;
      return value;
    }
    innerResult = call(innerResult, iterator);
  } catch (error) {
    innerError = true;
    innerResult = error;
  }
  if (kind === 'throw') throw value;
  if (innerError) throw innerResult;
  anObject(innerResult);
  return value;
};


/***/ }),

/***/ 47181:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var IteratorPrototype = (__webpack_require__(95116).IteratorPrototype);
var create = __webpack_require__(58075);
var createPropertyDescriptor = __webpack_require__(75817);
var setToStringTag = __webpack_require__(14840);
var Iterators = __webpack_require__(93742);

var returnThis = function () { return this; };

module.exports = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = create(IteratorPrototype, { next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next) });
  setToStringTag(IteratorConstructor, TO_STRING_TAG, false, true);
  Iterators[TO_STRING_TAG] = returnThis;
  return IteratorConstructor;
};


/***/ }),

/***/ 60183:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(11091);
var call = __webpack_require__(13930);
var IS_PURE = __webpack_require__(7376);
var FunctionName = __webpack_require__(36833);
var isCallable = __webpack_require__(62250);
var createIteratorConstructor = __webpack_require__(47181);
var getPrototypeOf = __webpack_require__(15972);
var setPrototypeOf = __webpack_require__(79192);
var setToStringTag = __webpack_require__(14840);
var createNonEnumerableProperty = __webpack_require__(61626);
var defineBuiltIn = __webpack_require__(68055);
var wellKnownSymbol = __webpack_require__(76264);
var Iterators = __webpack_require__(93742);
var IteratorsCore = __webpack_require__(95116);

var PROPER_FUNCTION_NAME = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var IteratorPrototype = IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR = wellKnownSymbol('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () { return this; };

module.exports = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND && KIND in IterablePrototype) return IterablePrototype[KIND];

    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    }

    return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME === 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  // fix native
  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf(anyNativeIterator.call(new Iterable()));
    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
      if (!IS_PURE && getPrototypeOf(CurrentIteratorPrototype) !== IteratorPrototype) {
        if (setPrototypeOf) {
          setPrototypeOf(CurrentIteratorPrototype, IteratorPrototype);
        } else if (!isCallable(CurrentIteratorPrototype[ITERATOR])) {
          defineBuiltIn(CurrentIteratorPrototype, ITERATOR, returnThis);
        }
      }
      // Set @@toStringTag to native iterators
      setToStringTag(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
      if (IS_PURE) Iterators[TO_STRING_TAG] = returnThis;
    }
  }

  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
  if (PROPER_FUNCTION_NAME && DEFAULT === VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    if (!IS_PURE && CONFIGURABLE_FUNCTION_NAME) {
      createNonEnumerableProperty(IterablePrototype, 'name', VALUES);
    } else {
      INCORRECT_VALUES_NAME = true;
      defaultIterator = function values() { return call(nativeIterator, this); };
    }
  }

  // export additional methods
  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        defineBuiltIn(IterablePrototype, KEY, methods[KEY]);
      }
    } else $({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
  }

  // define iterator
  if ((!IS_PURE || FORCED) && IterablePrototype[ITERATOR] !== defaultIterator) {
    defineBuiltIn(IterablePrototype, ITERATOR, defaultIterator, { name: DEFAULT });
  }
  Iterators[NAME] = defaultIterator;

  return methods;
};


/***/ }),

/***/ 95116:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(98828);
var isCallable = __webpack_require__(62250);
var isObject = __webpack_require__(46285);
var create = __webpack_require__(58075);
var getPrototypeOf = __webpack_require__(15972);
var defineBuiltIn = __webpack_require__(68055);
var wellKnownSymbol = __webpack_require__(76264);
var IS_PURE = __webpack_require__(7376);

var ITERATOR = wellKnownSymbol('iterator');
var BUGGY_SAFARI_ITERATORS = false;

// `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype, PrototypeOfArrayIteratorPrototype, arrayIterator;

/* eslint-disable es/no-array-prototype-keys -- safe */
if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf(getPrototypeOf(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = !isObject(IteratorPrototype) || fails(function () {
  var test = {};
  // FF44- legacy iterators case
  return IteratorPrototype[ITERATOR].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype = {};
else if (IS_PURE) IteratorPrototype = create(IteratorPrototype);

// `%IteratorPrototype%[@@iterator]()` method
// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
if (!isCallable(IteratorPrototype[ITERATOR])) {
  defineBuiltIn(IteratorPrototype, ITERATOR, function () {
    return this;
  });
}

module.exports = {
  IteratorPrototype: IteratorPrototype,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS
};


/***/ }),

/***/ 93742:
/***/ ((module) => {

"use strict";

module.exports = {};


/***/ }),

/***/ 20575:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toLength = __webpack_require__(3121);

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
module.exports = function (obj) {
  return toLength(obj.length);
};


/***/ }),

/***/ 41176:
/***/ ((module) => {

"use strict";

var ceil = Math.ceil;
var floor = Math.floor;

// `Math.trunc` method
// https://tc39.es/ecma262/#sec-math.trunc
// eslint-disable-next-line es/no-math-trunc -- safe
module.exports = Math.trunc || function trunc(x) {
  var n = +x;
  return (n > 0 ? floor : ceil)(n);
};


/***/ }),

/***/ 32096:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toString = __webpack_require__(90160);

module.exports = function (argument, $default) {
  return argument === undefined ? arguments.length < 2 ? '' : $default : toString(argument);
};


/***/ }),

/***/ 58075:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* global ActiveXObject -- old IE, WSH */
var anObject = __webpack_require__(36624);
var definePropertiesModule = __webpack_require__(42220);
var enumBugKeys = __webpack_require__(80376);
var hiddenKeys = __webpack_require__(38530);
var html = __webpack_require__(62416);
var documentCreateElement = __webpack_require__(49552);
var sharedKey = __webpack_require__(92522);

var GT = '>';
var LT = '<';
var PROTOTYPE = 'prototype';
var SCRIPT = 'script';
var IE_PROTO = sharedKey('IE_PROTO');

var EmptyConstructor = function () { /* empty */ };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  // eslint-disable-next-line no-useless-assignment -- avoid memory leak
  activeXDocument = null;
  return temp;
};

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html.appendChild(iframe);
  // https://github.com/zloirock/core-js/issues/475
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

// Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug
var activeXDocument;
var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) { /* ignore */ }
  NullProtoObject = typeof document != 'undefined'
    ? document.domain && activeXDocument
      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
      : NullProtoObjectViaIFrame()
    : NullProtoObjectViaActiveX(activeXDocument); // WSH
  var length = enumBugKeys.length;
  while (length--) delete NullProtoObject[PROTOTYPE][enumBugKeys[length]];
  return NullProtoObject();
};

hiddenKeys[IE_PROTO] = true;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
// eslint-disable-next-line es/no-object-create -- safe
module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE] = anObject(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : definePropertiesModule.f(result, Properties);
};


/***/ }),

/***/ 42220:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(39447);
var V8_PROTOTYPE_DEFINE_BUG = __webpack_require__(58661);
var definePropertyModule = __webpack_require__(74284);
var anObject = __webpack_require__(36624);
var toIndexedObject = __webpack_require__(27374);
var objectKeys = __webpack_require__(2875);

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe
exports.f = DESCRIPTORS && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var props = toIndexedObject(Properties);
  var keys = objectKeys(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) definePropertyModule.f(O, key = keys[index++], props[key]);
  return O;
};


/***/ }),

/***/ 74284:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(39447);
var IE8_DOM_DEFINE = __webpack_require__(73648);
var V8_PROTOTYPE_DEFINE_BUG = __webpack_require__(58661);
var anObject = __webpack_require__(36624);
var toPropertyKey = __webpack_require__(70470);

var $TypeError = TypeError;
// eslint-disable-next-line es/no-object-defineproperty -- safe
var $defineProperty = Object.defineProperty;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE = 'configurable';
var WRITABLE = 'writable';

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
exports.f = DESCRIPTORS ? V8_PROTOTYPE_DEFINE_BUG ? function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPropertyKey(P);
  anObject(Attributes);
  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
    var current = $getOwnPropertyDescriptor(O, P);
    if (current && current[WRITABLE]) {
      O[P] = Attributes.value;
      Attributes = {
        configurable: CONFIGURABLE in Attributes ? Attributes[CONFIGURABLE] : current[CONFIGURABLE],
        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
        writable: false
      };
    }
  } return $defineProperty(O, P, Attributes);
} : $defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPropertyKey(P);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw new $TypeError('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),

/***/ 13846:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(39447);
var call = __webpack_require__(13930);
var propertyIsEnumerableModule = __webpack_require__(22574);
var createPropertyDescriptor = __webpack_require__(75817);
var toIndexedObject = __webpack_require__(27374);
var toPropertyKey = __webpack_require__(70470);
var hasOwn = __webpack_require__(49724);
var IE8_DOM_DEFINE = __webpack_require__(73648);

// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject(O);
  P = toPropertyKey(P);
  if (IE8_DOM_DEFINE) try {
    return $getOwnPropertyDescriptor(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn(O, P)) return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
};


/***/ }),

/***/ 24443:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var internalObjectKeys = __webpack_require__(23045);
var enumBugKeys = __webpack_require__(80376);

var hiddenKeys = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys);
};


/***/ }),

/***/ 87170:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
exports.f = Object.getOwnPropertySymbols;


/***/ }),

/***/ 15972:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var hasOwn = __webpack_require__(49724);
var isCallable = __webpack_require__(62250);
var toObject = __webpack_require__(39298);
var sharedKey = __webpack_require__(92522);
var CORRECT_PROTOTYPE_GETTER = __webpack_require__(57382);

var IE_PROTO = sharedKey('IE_PROTO');
var $Object = Object;
var ObjectPrototype = $Object.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es/no-object-getprototypeof -- safe
module.exports = CORRECT_PROTOTYPE_GETTER ? $Object.getPrototypeOf : function (O) {
  var object = toObject(O);
  if (hasOwn(object, IE_PROTO)) return object[IE_PROTO];
  var constructor = object.constructor;
  if (isCallable(constructor) && object instanceof constructor) {
    return constructor.prototype;
  } return object instanceof $Object ? ObjectPrototype : null;
};


/***/ }),

/***/ 88280:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);

module.exports = uncurryThis({}.isPrototypeOf);


/***/ }),

/***/ 23045:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);
var hasOwn = __webpack_require__(49724);
var toIndexedObject = __webpack_require__(27374);
var indexOf = (__webpack_require__(74436).indexOf);
var hiddenKeys = __webpack_require__(38530);

var push = uncurryThis([].push);

module.exports = function (object, names) {
  var O = toIndexedObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !hasOwn(hiddenKeys, key) && hasOwn(O, key) && push(result, key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (hasOwn(O, key = names[i++])) {
    ~indexOf(result, key) || push(result, key);
  }
  return result;
};


/***/ }),

/***/ 2875:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var internalObjectKeys = __webpack_require__(23045);
var enumBugKeys = __webpack_require__(80376);

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es/no-object-keys -- safe
module.exports = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys);
};


/***/ }),

/***/ 22574:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

var $propertyIsEnumerable = {}.propertyIsEnumerable;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;


/***/ }),

/***/ 79192:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable no-proto -- safe */
var uncurryThisAccessor = __webpack_require__(51871);
var isObject = __webpack_require__(46285);
var requireObjectCoercible = __webpack_require__(74239);
var aPossiblePrototype = __webpack_require__(10043);

// `Object.setPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.setprototypeof
// Works with __proto__ only. Old v8 can't work with null proto objects.
// eslint-disable-next-line es/no-object-setprototypeof -- safe
module.exports = Object.setPrototypeOf || ('__proto__' in {} ? function () {
  var CORRECT_SETTER = false;
  var test = {};
  var setter;
  try {
    setter = uncurryThisAccessor(Object.prototype, '__proto__', 'set');
    setter(test, []);
    CORRECT_SETTER = test instanceof Array;
  } catch (error) { /* empty */ }
  return function setPrototypeOf(O, proto) {
    requireObjectCoercible(O);
    aPossiblePrototype(proto);
    if (!isObject(O)) return O;
    if (CORRECT_SETTER) setter(O, proto);
    else O.__proto__ = proto;
    return O;
  };
}() : undefined);


/***/ }),

/***/ 54878:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var TO_STRING_TAG_SUPPORT = __webpack_require__(52623);
var classof = __webpack_require__(73948);

// `Object.prototype.toString` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.tostring
module.exports = TO_STRING_TAG_SUPPORT ? {}.toString : function toString() {
  return '[object ' + classof(this) + ']';
};


/***/ }),

/***/ 60581:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var call = __webpack_require__(13930);
var isCallable = __webpack_require__(62250);
var isObject = __webpack_require__(46285);

var $TypeError = TypeError;

// `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive
module.exports = function (input, pref) {
  var fn, val;
  if (pref === 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
  if (isCallable(fn = input.valueOf) && !isObject(val = call(fn, input))) return val;
  if (pref !== 'string' && isCallable(fn = input.toString) && !isObject(val = call(fn, input))) return val;
  throw new $TypeError("Can't convert object to primitive value");
};


/***/ }),

/***/ 11042:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var getBuiltIn = __webpack_require__(63201);
var uncurryThis = __webpack_require__(1907);
var getOwnPropertyNamesModule = __webpack_require__(24443);
var getOwnPropertySymbolsModule = __webpack_require__(87170);
var anObject = __webpack_require__(36624);

var concat = uncurryThis([].concat);

// all object keys, includes non-enumerable and symbols
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
};


/***/ }),

/***/ 92046:
/***/ ((module) => {

"use strict";

module.exports = {};


/***/ }),

/***/ 54829:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var defineProperty = (__webpack_require__(74284).f);

module.exports = function (Target, Source, key) {
  key in Target || defineProperty(Target, key, {
    configurable: true,
    get: function () { return Source[key]; },
    set: function (it) { Source[key] = it; }
  });
};


/***/ }),

/***/ 74239:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isNullOrUndefined = __webpack_require__(87136);

var $TypeError = TypeError;

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
module.exports = function (it) {
  if (isNullOrUndefined(it)) throw new $TypeError("Can't call method on " + it);
  return it;
};


/***/ }),

/***/ 14840:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var TO_STRING_TAG_SUPPORT = __webpack_require__(52623);
var defineProperty = (__webpack_require__(74284).f);
var createNonEnumerableProperty = __webpack_require__(61626);
var hasOwn = __webpack_require__(49724);
var toString = __webpack_require__(54878);
var wellKnownSymbol = __webpack_require__(76264);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');

module.exports = function (it, TAG, STATIC, SET_METHOD) {
  var target = STATIC ? it : it && it.prototype;
  if (target) {
    if (!hasOwn(target, TO_STRING_TAG)) {
      defineProperty(target, TO_STRING_TAG, { configurable: true, value: TAG });
    }
    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
      createNonEnumerableProperty(target, 'toString', toString);
    }
  }
};


/***/ }),

/***/ 92522:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var shared = __webpack_require__(85816);
var uid = __webpack_require__(6499);

var keys = shared('keys');

module.exports = function (key) {
  return keys[key] || (keys[key] = uid(key));
};


/***/ }),

/***/ 36128:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var IS_PURE = __webpack_require__(7376);
var globalThis = __webpack_require__(45951);
var defineGlobalProperty = __webpack_require__(2532);

var SHARED = '__core-js_shared__';
var store = module.exports = globalThis[SHARED] || defineGlobalProperty(SHARED, {});

(store.versions || (store.versions = [])).push({
  version: '3.38.0',
  mode: IS_PURE ? 'pure' : 'global',
  copyright: '© 2014-2024 Denis Pushkarev (zloirock.ru)',
  license: 'https://github.com/zloirock/core-js/blob/v3.38.0/LICENSE',
  source: 'https://github.com/zloirock/core-js'
});


/***/ }),

/***/ 85816:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var store = __webpack_require__(36128);

module.exports = function (key, value) {
  return store[key] || (store[key] = value || {});
};


/***/ }),

/***/ 11470:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);
var toIntegerOrInfinity = __webpack_require__(65482);
var toString = __webpack_require__(90160);
var requireObjectCoercible = __webpack_require__(74239);

var charAt = uncurryThis(''.charAt);
var charCodeAt = uncurryThis(''.charCodeAt);
var stringSlice = uncurryThis(''.slice);

var createMethod = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = toString(requireObjectCoercible($this));
    var position = toIntegerOrInfinity(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = charCodeAt(S, position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING
          ? charAt(S, position)
          : first
        : CONVERT_TO_STRING
          ? stringSlice(S, position, position + 2)
          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

module.exports = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod(true)
};


/***/ }),

/***/ 19846:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable es/no-symbol -- required for testing */
var V8_VERSION = __webpack_require__(20798);
var fails = __webpack_require__(98828);
var globalThis = __webpack_require__(45951);

var $String = globalThis.String;

// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
  var symbol = Symbol('symbol detection');
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  // nb: Do not call `String` directly to avoid this being optimized out to `symbol+''` which will,
  // of course, fail.
  return !$String(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});


/***/ }),

/***/ 34849:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toIntegerOrInfinity = __webpack_require__(65482);

var max = Math.max;
var min = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
module.exports = function (index, length) {
  var integer = toIntegerOrInfinity(index);
  return integer < 0 ? max(integer + length, 0) : min(integer, length);
};


/***/ }),

/***/ 27374:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// toObject with fallback for non-array-like ES3 strings
var IndexedObject = __webpack_require__(16946);
var requireObjectCoercible = __webpack_require__(74239);

module.exports = function (it) {
  return IndexedObject(requireObjectCoercible(it));
};


/***/ }),

/***/ 65482:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var trunc = __webpack_require__(41176);

// `ToIntegerOrInfinity` abstract operation
// https://tc39.es/ecma262/#sec-tointegerorinfinity
module.exports = function (argument) {
  var number = +argument;
  // eslint-disable-next-line no-self-compare -- NaN check
  return number !== number || number === 0 ? 0 : trunc(number);
};


/***/ }),

/***/ 3121:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toIntegerOrInfinity = __webpack_require__(65482);

var min = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
module.exports = function (argument) {
  var len = toIntegerOrInfinity(argument);
  return len > 0 ? min(len, 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};


/***/ }),

/***/ 39298:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var requireObjectCoercible = __webpack_require__(74239);

var $Object = Object;

// `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject
module.exports = function (argument) {
  return $Object(requireObjectCoercible(argument));
};


/***/ }),

/***/ 46028:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var call = __webpack_require__(13930);
var isObject = __webpack_require__(46285);
var isSymbol = __webpack_require__(25594);
var getMethod = __webpack_require__(29367);
var ordinaryToPrimitive = __webpack_require__(60581);
var wellKnownSymbol = __webpack_require__(76264);

var $TypeError = TypeError;
var TO_PRIMITIVE = wellKnownSymbol('toPrimitive');

// `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
module.exports = function (input, pref) {
  if (!isObject(input) || isSymbol(input)) return input;
  var exoticToPrim = getMethod(input, TO_PRIMITIVE);
  var result;
  if (exoticToPrim) {
    if (pref === undefined) pref = 'default';
    result = call(exoticToPrim, input, pref);
    if (!isObject(result) || isSymbol(result)) return result;
    throw new $TypeError("Can't convert object to primitive value");
  }
  if (pref === undefined) pref = 'number';
  return ordinaryToPrimitive(input, pref);
};


/***/ }),

/***/ 70470:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toPrimitive = __webpack_require__(46028);
var isSymbol = __webpack_require__(25594);

// `ToPropertyKey` abstract operation
// https://tc39.es/ecma262/#sec-topropertykey
module.exports = function (argument) {
  var key = toPrimitive(argument, 'string');
  return isSymbol(key) ? key : key + '';
};


/***/ }),

/***/ 52623:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var wellKnownSymbol = __webpack_require__(76264);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var test = {};

test[TO_STRING_TAG] = 'z';

module.exports = String(test) === '[object z]';


/***/ }),

/***/ 90160:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var classof = __webpack_require__(73948);

var $String = String;

module.exports = function (argument) {
  if (classof(argument) === 'Symbol') throw new TypeError('Cannot convert a Symbol value to a string');
  return $String(argument);
};


/***/ }),

/***/ 4640:
/***/ ((module) => {

"use strict";

var $String = String;

module.exports = function (argument) {
  try {
    return $String(argument);
  } catch (error) {
    return 'Object';
  }
};


/***/ }),

/***/ 6499:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);

var id = 0;
var postfix = Math.random();
var toString = uncurryThis(1.0.toString);

module.exports = function (key) {
  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
};


/***/ }),

/***/ 51175:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable es/no-symbol -- required for testing */
var NATIVE_SYMBOL = __webpack_require__(19846);

module.exports = NATIVE_SYMBOL
  && !Symbol.sham
  && typeof Symbol.iterator == 'symbol';


/***/ }),

/***/ 58661:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(39447);
var fails = __webpack_require__(98828);

// V8 ~ Chrome 36-
// https://bugs.chromium.org/p/v8/issues/detail?id=3334
module.exports = DESCRIPTORS && fails(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
    value: 42,
    writable: false
  }).prototype !== 42;
});


/***/ }),

/***/ 40551:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);
var isCallable = __webpack_require__(62250);

var WeakMap = globalThis.WeakMap;

module.exports = isCallable(WeakMap) && /native code/.test(String(WeakMap));


/***/ }),

/***/ 76264:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);
var shared = __webpack_require__(85816);
var hasOwn = __webpack_require__(49724);
var uid = __webpack_require__(6499);
var NATIVE_SYMBOL = __webpack_require__(19846);
var USE_SYMBOL_AS_UID = __webpack_require__(51175);

var Symbol = globalThis.Symbol;
var WellKnownSymbolsStore = shared('wks');
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol['for'] || Symbol : Symbol && Symbol.withoutSetter || uid;

module.exports = function (name) {
  if (!hasOwn(WellKnownSymbolsStore, name)) {
    WellKnownSymbolsStore[name] = NATIVE_SYMBOL && hasOwn(Symbol, name)
      ? Symbol[name]
      : createWellKnownSymbol('Symbol.' + name);
  } return WellKnownSymbolsStore[name];
};


/***/ }),

/***/ 19358:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var getBuiltIn = __webpack_require__(63201);
var hasOwn = __webpack_require__(49724);
var createNonEnumerableProperty = __webpack_require__(61626);
var isPrototypeOf = __webpack_require__(88280);
var setPrototypeOf = __webpack_require__(79192);
var copyConstructorProperties = __webpack_require__(19595);
var proxyAccessor = __webpack_require__(54829);
var inheritIfRequired = __webpack_require__(34084);
var normalizeStringArgument = __webpack_require__(32096);
var installErrorCause = __webpack_require__(39259);
var installErrorStack = __webpack_require__(85884);
var DESCRIPTORS = __webpack_require__(39447);
var IS_PURE = __webpack_require__(7376);

module.exports = function (FULL_NAME, wrapper, FORCED, IS_AGGREGATE_ERROR) {
  var STACK_TRACE_LIMIT = 'stackTraceLimit';
  var OPTIONS_POSITION = IS_AGGREGATE_ERROR ? 2 : 1;
  var path = FULL_NAME.split('.');
  var ERROR_NAME = path[path.length - 1];
  var OriginalError = getBuiltIn.apply(null, path);

  if (!OriginalError) return;

  var OriginalErrorPrototype = OriginalError.prototype;

  // V8 9.3- bug https://bugs.chromium.org/p/v8/issues/detail?id=12006
  if (!IS_PURE && hasOwn(OriginalErrorPrototype, 'cause')) delete OriginalErrorPrototype.cause;

  if (!FORCED) return OriginalError;

  var BaseError = getBuiltIn('Error');

  var WrappedError = wrapper(function (a, b) {
    var message = normalizeStringArgument(IS_AGGREGATE_ERROR ? b : a, undefined);
    var result = IS_AGGREGATE_ERROR ? new OriginalError(a) : new OriginalError();
    if (message !== undefined) createNonEnumerableProperty(result, 'message', message);
    installErrorStack(result, WrappedError, result.stack, 2);
    if (this && isPrototypeOf(OriginalErrorPrototype, this)) inheritIfRequired(result, this, WrappedError);
    if (arguments.length > OPTIONS_POSITION) installErrorCause(result, arguments[OPTIONS_POSITION]);
    return result;
  });

  WrappedError.prototype = OriginalErrorPrototype;

  if (ERROR_NAME !== 'Error') {
    if (setPrototypeOf) setPrototypeOf(WrappedError, BaseError);
    else copyConstructorProperties(WrappedError, BaseError, { name: true });
  } else if (DESCRIPTORS && STACK_TRACE_LIMIT in OriginalError) {
    proxyAccessor(WrappedError, OriginalError, STACK_TRACE_LIMIT);
    proxyAccessor(WrappedError, OriginalError, 'prepareStackTrace');
  }

  copyConstructorProperties(WrappedError, OriginalError);

  if (!IS_PURE) try {
    // Safari 13- bug: WebAssembly errors does not have a proper `.name`
    if (OriginalErrorPrototype.name !== ERROR_NAME) {
      createNonEnumerableProperty(OriginalErrorPrototype, 'name', ERROR_NAME);
    }
    OriginalErrorPrototype.constructor = WrappedError;
  } catch (error) { /* empty */ }

  return WrappedError;
};


/***/ }),

/***/ 36371:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(11091);
var getBuiltIn = __webpack_require__(63201);
var apply = __webpack_require__(76024);
var fails = __webpack_require__(98828);
var wrapErrorConstructorWithCause = __webpack_require__(19358);

var AGGREGATE_ERROR = 'AggregateError';
var $AggregateError = getBuiltIn(AGGREGATE_ERROR);

var FORCED = !fails(function () {
  return $AggregateError([1]).errors[0] !== 1;
}) && fails(function () {
  return $AggregateError([1], AGGREGATE_ERROR, { cause: 7 }).cause !== 7;
});

// https://tc39.es/ecma262/#sec-aggregate-error
$({ global: true, constructor: true, arity: 2, forced: FORCED }, {
  AggregateError: wrapErrorConstructorWithCause(AGGREGATE_ERROR, function (init) {
    // eslint-disable-next-line no-unused-vars -- required for functions `.length`
    return function AggregateError(errors, message) { return apply(init, this, arguments); };
  }, FORCED, true)
});


/***/ }),

/***/ 82048:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $ = __webpack_require__(11091);
var isPrototypeOf = __webpack_require__(88280);
var getPrototypeOf = __webpack_require__(15972);
var setPrototypeOf = __webpack_require__(79192);
var copyConstructorProperties = __webpack_require__(19595);
var create = __webpack_require__(58075);
var createNonEnumerableProperty = __webpack_require__(61626);
var createPropertyDescriptor = __webpack_require__(75817);
var installErrorCause = __webpack_require__(39259);
var installErrorStack = __webpack_require__(85884);
var iterate = __webpack_require__(24823);
var normalizeStringArgument = __webpack_require__(32096);
var wellKnownSymbol = __webpack_require__(76264);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var $Error = Error;
var push = [].push;

var $AggregateError = function AggregateError(errors, message /* , options */) {
  var isInstance = isPrototypeOf(AggregateErrorPrototype, this);
  var that;
  if (setPrototypeOf) {
    that = setPrototypeOf(new $Error(), isInstance ? getPrototypeOf(this) : AggregateErrorPrototype);
  } else {
    that = isInstance ? this : create(AggregateErrorPrototype);
    createNonEnumerableProperty(that, TO_STRING_TAG, 'Error');
  }
  if (message !== undefined) createNonEnumerableProperty(that, 'message', normalizeStringArgument(message));
  installErrorStack(that, $AggregateError, that.stack, 1);
  if (arguments.length > 2) installErrorCause(that, arguments[2]);
  var errorsArray = [];
  iterate(errors, push, { that: errorsArray });
  createNonEnumerableProperty(that, 'errors', errorsArray);
  return that;
};

if (setPrototypeOf) setPrototypeOf($AggregateError, $Error);
else copyConstructorProperties($AggregateError, $Error, { name: true });

var AggregateErrorPrototype = $AggregateError.prototype = create($Error.prototype, {
  constructor: createPropertyDescriptor(1, $AggregateError),
  message: createPropertyDescriptor(1, ''),
  name: createPropertyDescriptor(1, 'AggregateError')
});

// `AggregateError` constructor
// https://tc39.es/ecma262/#sec-aggregate-error-constructor
$({ global: true, constructor: true, arity: 2 }, {
  AggregateError: $AggregateError
});


/***/ }),

/***/ 64502:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// TODO: Remove this module from `core-js@4` since it's replaced to module below
__webpack_require__(82048);


/***/ }),

/***/ 99363:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toIndexedObject = __webpack_require__(27374);
var addToUnscopables = __webpack_require__(42156);
var Iterators = __webpack_require__(93742);
var InternalStateModule = __webpack_require__(64932);
var defineProperty = (__webpack_require__(74284).f);
var defineIterator = __webpack_require__(60183);
var createIterResultObject = __webpack_require__(59550);
var IS_PURE = __webpack_require__(7376);
var DESCRIPTORS = __webpack_require__(39447);

var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(ARRAY_ITERATOR);

// `Array.prototype.entries` method
// https://tc39.es/ecma262/#sec-array.prototype.entries
// `Array.prototype.keys` method
// https://tc39.es/ecma262/#sec-array.prototype.keys
// `Array.prototype.values` method
// https://tc39.es/ecma262/#sec-array.prototype.values
// `Array.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
// `CreateArrayIterator` internal method
// https://tc39.es/ecma262/#sec-createarrayiterator
module.exports = defineIterator(Array, 'Array', function (iterated, kind) {
  setInternalState(this, {
    type: ARRAY_ITERATOR,
    target: toIndexedObject(iterated), // target
    index: 0,                          // next index
    kind: kind                         // kind
  });
// `%ArrayIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
}, function () {
  var state = getInternalState(this);
  var target = state.target;
  var index = state.index++;
  if (!target || index >= target.length) {
    state.target = undefined;
    return createIterResultObject(undefined, true);
  }
  switch (state.kind) {
    case 'keys': return createIterResultObject(index, false);
    case 'values': return createIterResultObject(target[index], false);
  } return createIterResultObject([index, target[index]], false);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values%
// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
// https://tc39.es/ecma262/#sec-createmappedargumentsobject
var values = Iterators.Arguments = Iterators.Array;

// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');

// V8 ~ Chrome 45- bug
if (!IS_PURE && DESCRIPTORS && values.name !== 'values') try {
  defineProperty(values, 'name', { value: 'values' });
} catch (error) { /* empty */ }


/***/ }),

/***/ 96605:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable no-unused-vars -- required for functions `.length` */
var $ = __webpack_require__(11091);
var globalThis = __webpack_require__(45951);
var apply = __webpack_require__(76024);
var wrapErrorConstructorWithCause = __webpack_require__(19358);

var WEB_ASSEMBLY = 'WebAssembly';
var WebAssembly = globalThis[WEB_ASSEMBLY];

// eslint-disable-next-line es/no-error-cause -- feature detection
var FORCED = new Error('e', { cause: 7 }).cause !== 7;

var exportGlobalErrorCauseWrapper = function (ERROR_NAME, wrapper) {
  var O = {};
  O[ERROR_NAME] = wrapErrorConstructorWithCause(ERROR_NAME, wrapper, FORCED);
  $({ global: true, constructor: true, arity: 1, forced: FORCED }, O);
};

var exportWebAssemblyErrorCauseWrapper = function (ERROR_NAME, wrapper) {
  if (WebAssembly && WebAssembly[ERROR_NAME]) {
    var O = {};
    O[ERROR_NAME] = wrapErrorConstructorWithCause(WEB_ASSEMBLY + '.' + ERROR_NAME, wrapper, FORCED);
    $({ target: WEB_ASSEMBLY, stat: true, constructor: true, arity: 1, forced: FORCED }, O);
  }
};

// https://tc39.es/ecma262/#sec-nativeerror
exportGlobalErrorCauseWrapper('Error', function (init) {
  return function Error(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('EvalError', function (init) {
  return function EvalError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('RangeError', function (init) {
  return function RangeError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('ReferenceError', function (init) {
  return function ReferenceError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('SyntaxError', function (init) {
  return function SyntaxError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('TypeError', function (init) {
  return function TypeError(message) { return apply(init, this, arguments); };
});
exportGlobalErrorCauseWrapper('URIError', function (init) {
  return function URIError(message) { return apply(init, this, arguments); };
});
exportWebAssemblyErrorCauseWrapper('CompileError', function (init) {
  return function CompileError(message) { return apply(init, this, arguments); };
});
exportWebAssemblyErrorCauseWrapper('LinkError', function (init) {
  return function LinkError(message) { return apply(init, this, arguments); };
});
exportWebAssemblyErrorCauseWrapper('RuntimeError', function (init) {
  return function RuntimeError(message) { return apply(init, this, arguments); };
});


/***/ }),

/***/ 7057:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var charAt = (__webpack_require__(11470).charAt);
var toString = __webpack_require__(90160);
var InternalStateModule = __webpack_require__(64932);
var defineIterator = __webpack_require__(60183);
var createIterResultObject = __webpack_require__(59550);

var STRING_ITERATOR = 'String Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);

// `String.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
defineIterator(String, 'String', function (iterated) {
  setInternalState(this, {
    type: STRING_ITERATOR,
    string: toString(iterated),
    index: 0
  });
// `%StringIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
}, function next() {
  var state = getInternalState(this);
  var string = state.string;
  var index = state.index;
  var point;
  if (index >= string.length) return createIterResultObject(undefined, true);
  point = charAt(string, index);
  state.index += point.length;
  return createIterResultObject(point, false);
});


/***/ }),

/***/ 91599:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// TODO: Remove from `core-js@4`
__webpack_require__(64502);


/***/ }),

/***/ 12560:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

__webpack_require__(99363);
var DOMIterables = __webpack_require__(19287);
var globalThis = __webpack_require__(45951);
var setToStringTag = __webpack_require__(14840);
var Iterators = __webpack_require__(93742);

for (var COLLECTION_NAME in DOMIterables) {
  setToStringTag(globalThis[COLLECTION_NAME], COLLECTION_NAME);
  Iterators[COLLECTION_NAME] = Iterators.Array;
}


/***/ }),

/***/ 694:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// TODO: remove from `core-js@4`
__webpack_require__(91599);

var parent = __webpack_require__(37257);
__webpack_require__(12560);

module.exports = parent;


/***/ }),

/***/ 68618:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BREAK: () => (/* binding */ BREAK),
/* harmony export */   cloneNode: () => (/* binding */ cloneNode),
/* harmony export */   getNodeType: () => (/* binding */ getNodeType),
/* harmony export */   getVisitFn: () => (/* binding */ getVisitFn),
/* harmony export */   isNode: () => (/* binding */ isNode),
/* harmony export */   mergeAll: () => (/* binding */ mergeAll),
/* harmony export */   visit: () => (/* binding */ visit)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19500);


/**
 * SPDX-FileCopyrightText: Copyright (c) GraphQL Contributors
 *
 * SPDX-License-Identifier: MIT
 */

// getVisitFn :: (Visitor, String, Boolean) -> Function
const getVisitFn = (visitor, type, isLeaving) => {
  const typeVisitor = visitor[type];
  if (typeVisitor != null) {
    if (!isLeaving && typeof typeVisitor === 'function') {
      // { Type() {} }
      return typeVisitor;
    }
    const typeSpecificVisitor = isLeaving ? typeVisitor.leave : typeVisitor.enter;
    if (typeof typeSpecificVisitor === 'function') {
      // { Type: { enter() {}, leave() {} } }
      return typeSpecificVisitor;
    }
  } else {
    const specificVisitor = isLeaving ? visitor.leave : visitor.enter;
    if (specificVisitor != null) {
      if (typeof specificVisitor === 'function') {
        // { enter() {}, leave() {} }
        return specificVisitor;
      }
      const specificTypeVisitor = specificVisitor[type];
      if (typeof specificTypeVisitor === 'function') {
        // { enter: { Type() {} }, leave: { Type() {} } }
        return specificTypeVisitor;
      }
    }
  }
  return null;
};
const BREAK = {};

// getNodeType :: Node -> String
const getNodeType = node => node === null || node === void 0 ? void 0 : node.type;

// isNode :: Node -> Boolean
const isNode = node => typeof getNodeType(node) === 'string';

// cloneNode :: a -> a
const cloneNode = node => Object.create(Object.getPrototypeOf(node), Object.getOwnPropertyDescriptors(node));

/**
 * Creates a new visitor instance which delegates to many visitors to run in
 * parallel. Each visitor will be visited for each node before moving on.
 *
 * If a prior visitor edits a node, no following visitors will see that node.
 * `exposeEdits=true` can be used to expose the edited node from the previous visitors.
 */

const mergeAll = (visitors, {
  visitFnGetter = getVisitFn,
  nodeTypeGetter = getNodeType,
  breakSymbol = BREAK,
  deleteNodeSymbol = null,
  skipVisitingNodeSymbol = false,
  exposeEdits = false
} = {}) => {
  const skipSymbol = Symbol('skip');
  const skipping = new Array(visitors.length).fill(skipSymbol);
  return {
    enter(node, key, parent, path, ancestors, link) {
      let currentNode = node;
      let hasChanged = false;
      const linkProxy = {
        ...link,
        replaceWith(newNode, replacer) {
          link.replaceWith(newNode, replacer);
          currentNode = newNode;
        }
      };
      for (let i = 0; i < visitors.length; i += 1) {
        if (skipping[i] === skipSymbol) {
          const visitFn = visitFnGetter(visitors[i], nodeTypeGetter(currentNode), false);
          if (typeof visitFn === 'function') {
            const result = visitFn.call(visitors[i], currentNode, key, parent, path, ancestors, linkProxy);

            // check if the visitor is async
            if (typeof (result === null || result === void 0 ? void 0 : result.then) === 'function') {
              throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"]('Async visitor not supported in sync mode', {
                visitor: visitors[i],
                visitFn
              });
            }
            if (result === skipVisitingNodeSymbol) {
              skipping[i] = currentNode;
            } else if (result === breakSymbol) {
              skipping[i] = breakSymbol;
            } else if (result === deleteNodeSymbol) {
              return result;
            } else if (result !== undefined) {
              if (exposeEdits) {
                currentNode = result;
                hasChanged = true;
              } else {
                return result;
              }
            }
          }
        }
      }
      return hasChanged ? currentNode : undefined;
    },
    leave(node, key, parent, path, ancestors, link) {
      let currentNode = node;
      const linkProxy = {
        ...link,
        replaceWith(newNode, replacer) {
          link.replaceWith(newNode, replacer);
          currentNode = newNode;
        }
      };
      for (let i = 0; i < visitors.length; i += 1) {
        if (skipping[i] === skipSymbol) {
          const visitFn = visitFnGetter(visitors[i], nodeTypeGetter(currentNode), true);
          if (typeof visitFn === 'function') {
            const result = visitFn.call(visitors[i], currentNode, key, parent, path, ancestors, linkProxy);

            // check if the visitor is async
            if (typeof (result === null || result === void 0 ? void 0 : result.then) === 'function') {
              throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"]('Async visitor not supported in sync mode', {
                visitor: visitors[i],
                visitFn
              });
            }
            if (result === breakSymbol) {
              skipping[i] = breakSymbol;
            } else if (result !== undefined && result !== skipVisitingNodeSymbol) {
              return result;
            }
          }
        } else if (skipping[i] === currentNode) {
          skipping[i] = skipSymbol;
        }
      }
      return undefined;
    }
  };
};
const mergeAllAsync = (visitors, {
  visitFnGetter = getVisitFn,
  nodeTypeGetter = getNodeType,
  breakSymbol = BREAK,
  deleteNodeSymbol = null,
  skipVisitingNodeSymbol = false,
  exposeEdits = false
} = {}) => {
  const skipSymbol = Symbol('skip');
  const skipping = new Array(visitors.length).fill(skipSymbol);
  return {
    async enter(node, key, parent, path, ancestors, link) {
      let currentNode = node;
      let hasChanged = false;
      const linkProxy = {
        ...link,
        replaceWith(newNode, replacer) {
          link.replaceWith(newNode, replacer);
          currentNode = newNode;
        }
      };
      for (let i = 0; i < visitors.length; i += 1) {
        if (skipping[i] === skipSymbol) {
          const visitFn = visitFnGetter(visitors[i], nodeTypeGetter(currentNode), false);
          if (typeof visitFn === 'function') {
            // eslint-disable-next-line no-await-in-loop
            const result = await visitFn.call(visitors[i], currentNode, key, parent, path, ancestors, linkProxy);
            if (result === skipVisitingNodeSymbol) {
              skipping[i] = currentNode;
            } else if (result === breakSymbol) {
              skipping[i] = breakSymbol;
            } else if (result === deleteNodeSymbol) {
              return result;
            } else if (result !== undefined) {
              if (exposeEdits) {
                currentNode = result;
                hasChanged = true;
              } else {
                return result;
              }
            }
          }
        }
      }
      return hasChanged ? currentNode : undefined;
    },
    async leave(node, key, parent, path, ancestors, link) {
      let currentNode = node;
      const linkProxy = {
        ...link,
        replaceWith(newNode, replacer) {
          link.replaceWith(newNode, replacer);
          currentNode = newNode;
        }
      };
      for (let i = 0; i < visitors.length; i += 1) {
        if (skipping[i] === skipSymbol) {
          const visitFn = visitFnGetter(visitors[i], nodeTypeGetter(currentNode), true);
          if (typeof visitFn === 'function') {
            // eslint-disable-next-line no-await-in-loop
            const result = await visitFn.call(visitors[i], currentNode, key, parent, path, ancestors, linkProxy);
            if (result === breakSymbol) {
              skipping[i] = breakSymbol;
            } else if (result !== undefined && result !== skipVisitingNodeSymbol) {
              return result;
            }
          }
        } else if (skipping[i] === currentNode) {
          skipping[i] = skipSymbol;
        }
      }
      return undefined;
    }
  };
};
mergeAll[Symbol.for('nodejs.util.promisify.custom')] = mergeAllAsync;

/* eslint-disable no-continue, no-param-reassign */
/**
 * visit() will walk through an AST using a preorder depth first traversal, calling
 * the visitor's enter function at each node in the traversal, and calling the
 * leave function after visiting that node and all of its child nodes.
 *
 * By returning different values from the enter and leave functions, the
 * behavior of the visitor can be altered, including skipping over a sub-tree of
 * the AST (by returning false), editing the AST by returning a value or null
 * to remove the value, or to stop the whole traversal by returning BREAK.
 *
 * When using visit() to edit an AST, the original AST will not be modified, and
 * a new version of the AST with the changes applied will be returned from the
 * visit function.
 *
 *     const editedAST = visit(ast, {
 *       enter(node, key, parent, path, ancestors) {
 *         // @return
 *         //   undefined: no action
 *         //   false: skip visiting this node
 *         //   BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       },
 *       leave(node, key, parent, path, ancestors) {
 *         // @return
 *         //   undefined: no action
 *         //   false: no action
 *         //   BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       }
 *     });
 *
 * Alternatively to providing enter() and leave() functions, a visitor can
 * instead provide functions named the same as the kinds of AST nodes, or
 * enter/leave visitors at a named key, leading to four permutations of
 * visitor API:
 *
 * 1) Named visitors triggered when entering a node a specific kind.
 *
 *     visit(ast, {
 *       Kind(node) {
 *         // enter the "Kind" node
 *       }
 *     })
 *
 * 2) Named visitors that trigger upon entering and leaving a node of
 *    a specific kind.
 *
 *     visit(ast, {
 *       Kind: {
 *         enter(node) {
 *           // enter the "Kind" node
 *         }
 *         leave(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 *
 * 3) Generic visitors that trigger upon entering and leaving any node.
 *
 *     visit(ast, {
 *       enter(node) {
 *         // enter any node
 *       },
 *       leave(node) {
 *         // leave any node
 *       }
 *     })
 *
 * 4) Parallel visitors for entering and leaving nodes of a specific kind.
 *
 *     visit(ast, {
 *       enter: {
 *         Kind(node) {
 *           // enter the "Kind" node
 *         }
 *       },
 *       leave: {
 *         Kind(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 *
 *  @sig visit :: (Node, Visitor, Options)
 *  @sig      Options = { keyMap: Object, state: Object }
 */
const visit = (
// @ts-ignore
root,
// @ts-ignore
visitor, {
  keyMap = null,
  state = {},
  breakSymbol = BREAK,
  deleteNodeSymbol = null,
  skipVisitingNodeSymbol = false,
  visitFnGetter = getVisitFn,
  nodeTypeGetter = getNodeType,
  nodePredicate = isNode,
  nodeCloneFn = cloneNode,
  detectCycles = true
} = {}) => {
  const visitorKeys = keyMap || {};
  let stack;
  let inArray = Array.isArray(root);
  let keys = [root];
  let index = -1;
  let parent;
  let edits = [];
  let node = root;
  const path = [];
  // @ts-ignore
  const ancestors = [];
  do {
    index += 1;
    const isLeaving = index === keys.length;
    let key;
    const isEdited = isLeaving && edits.length !== 0;
    if (isLeaving) {
      key = ancestors.length === 0 ? undefined : path.pop();
      node = parent;
      // @ts-ignore
      parent = ancestors.pop();
      if (isEdited) {
        if (inArray) {
          // @ts-ignore; creating clone
          node = node.slice();
          let editOffset = 0;
          for (const [editKey, editValue] of edits) {
            const arrayKey = editKey - editOffset;
            if (editValue === deleteNodeSymbol) {
              node.splice(arrayKey, 1);
              editOffset += 1;
            } else {
              node[arrayKey] = editValue;
            }
          }
        } else {
          // creating clone
          node = nodeCloneFn(node);
          for (const [editKey, editValue] of edits) {
            node[editKey] = editValue;
          }
        }
      }
      index = stack.index;
      keys = stack.keys;
      // @ts-ignore
      edits = stack.edits;
      // @ts-ignore
      inArray = stack.inArray;
      // @ts-ignore
      stack = stack.prev;
    } else if (parent !== deleteNodeSymbol && parent !== undefined) {
      key = inArray ? index : keys[index];
      node = parent[key];
      if (node === deleteNodeSymbol || node === undefined) {
        continue;
      }
      path.push(key);
    }
    let result;
    if (!Array.isArray(node)) {
      var _result;
      if (!nodePredicate(node)) {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"](`Invalid AST Node:  ${String(node)}`, {
          node
        });
      }

      // cycle detected; skipping over a sub-tree to avoid recursion
      if (detectCycles && ancestors.includes(node)) {
        path.pop();
        continue;
      }
      // call appropriate visitor function if available
      const visitFn = visitFnGetter(visitor, nodeTypeGetter(node), isLeaving);
      if (visitFn) {
        // assign state
        for (const [stateKey, stateValue] of Object.entries(state)) {
          visitor[stateKey] = stateValue;
        }
        const link = {
          // eslint-disable-next-line @typescript-eslint/no-loop-func
          replaceWith(newNode, replacer) {
            if (typeof replacer === 'function') {
              replacer(newNode, node, key, parent, path, ancestors);
            } else if (parent) {
              parent[key] = newNode;
            }
            if (!isLeaving) {
              node = newNode;
            }
          }
        };

        // retrieve result
        result = visitFn.call(visitor, node, key, parent, path, ancestors, link);
      }

      // check if the visitor is async
      if (typeof ((_result = result) === null || _result === void 0 ? void 0 : _result.then) === 'function') {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"]('Async visitor not supported in sync mode', {
          visitor,
          visitFn
        });
      }
      if (result === breakSymbol) {
        break;
      }
      if (result === skipVisitingNodeSymbol) {
        if (!isLeaving) {
          path.pop();
          continue;
        }
      } else if (result !== undefined) {
        edits.push([key, result]);
        if (!isLeaving) {
          if (nodePredicate(result)) {
            node = result;
          } else {
            path.pop();
            continue;
          }
        }
      }
    }
    if (result === undefined && isEdited) {
      edits.push([key, node]);
    }
    if (!isLeaving) {
      var _visitorKeys$nodeType;
      stack = {
        inArray,
        index,
        keys,
        edits,
        prev: stack
      };
      inArray = Array.isArray(node);
      // @ts-ignore
      keys = inArray ? node : (_visitorKeys$nodeType = visitorKeys[nodeTypeGetter(node)]) !== null && _visitorKeys$nodeType !== void 0 ? _visitorKeys$nodeType : [];
      index = -1;
      edits = [];
      if (parent !== deleteNodeSymbol && parent !== undefined) {
        ancestors.push(parent);
      }
      parent = node;
    }
  } while (stack !== undefined);
  if (edits.length !== 0) {
    return edits[edits.length - 1][1]; // @TODO(vladimir.gorej@gmail.com): can be replaced by Array.prototype.at in future
  }
  return root;
};

/**
 * Asynchronous version of visit.
 */
// @ts-ignore
visit[Symbol.for('nodejs.util.promisify.custom')] = async (
// @ts-ignore
root,
// @ts-ignore
visitor, {
  keyMap = null,
  state = {},
  breakSymbol = BREAK,
  deleteNodeSymbol = null,
  skipVisitingNodeSymbol = false,
  visitFnGetter = getVisitFn,
  nodeTypeGetter = getNodeType,
  nodePredicate = isNode,
  nodeCloneFn = cloneNode,
  detectCycles = true
} = {}) => {
  const visitorKeys = keyMap || {};
  let stack;
  let inArray = Array.isArray(root);
  let keys = [root];
  let index = -1;
  let parent;
  let edits = [];
  let node = root;
  const path = [];
  // @ts-ignore
  const ancestors = [];
  do {
    index += 1;
    const isLeaving = index === keys.length;
    let key;
    const isEdited = isLeaving && edits.length !== 0;
    if (isLeaving) {
      key = ancestors.length === 0 ? undefined : path.pop();
      node = parent;
      // @ts-ignore
      parent = ancestors.pop();
      if (isEdited) {
        if (inArray) {
          // @ts-ignore; creating clone
          node = node.slice();
          let editOffset = 0;
          for (const [editKey, editValue] of edits) {
            const arrayKey = editKey - editOffset;
            if (editValue === deleteNodeSymbol) {
              node.splice(arrayKey, 1);
              editOffset += 1;
            } else {
              node[arrayKey] = editValue;
            }
          }
        } else {
          // creating clone
          node = nodeCloneFn(node);
          for (const [editKey, editValue] of edits) {
            node[editKey] = editValue;
          }
        }
      }
      index = stack.index;
      keys = stack.keys;
      // @ts-ignore
      edits = stack.edits;
      // @ts-ignore
      inArray = stack.inArray;
      // @ts-ignore
      stack = stack.prev;
    } else if (parent !== deleteNodeSymbol && parent !== undefined) {
      key = inArray ? index : keys[index];
      node = parent[key];
      if (node === deleteNodeSymbol || node === undefined) {
        continue;
      }
      path.push(key);
    }
    let result;
    if (!Array.isArray(node)) {
      if (!nodePredicate(node)) {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"](`Invalid AST Node: ${String(node)}`, {
          node
        });
      }

      // cycle detected; skipping over a sub-tree to avoid recursion
      if (detectCycles && ancestors.includes(node)) {
        path.pop();
        continue;
      }
      const visitFn = visitFnGetter(visitor, nodeTypeGetter(node), isLeaving);
      if (visitFn) {
        // assign state
        for (const [stateKey, stateValue] of Object.entries(state)) {
          visitor[stateKey] = stateValue;
        }
        const link = {
          // eslint-disable-next-line @typescript-eslint/no-loop-func
          replaceWith(newNode, replacer) {
            if (typeof replacer === 'function') {
              replacer(newNode, node, key, parent, path, ancestors);
            } else if (parent) {
              parent[key] = newNode;
            }
            if (!isLeaving) {
              node = newNode;
            }
          }
        };

        // retrieve result
        result = await visitFn.call(visitor, node, key, parent, path, ancestors, link); // eslint-disable-line no-await-in-loop
      }
      if (result === breakSymbol) {
        break;
      }
      if (result === skipVisitingNodeSymbol) {
        if (!isLeaving) {
          path.pop();
          continue;
        }
      } else if (result !== undefined) {
        edits.push([key, result]);
        if (!isLeaving) {
          if (nodePredicate(result)) {
            node = result;
          } else {
            path.pop();
            continue;
          }
        }
      }
    }
    if (result === undefined && isEdited) {
      edits.push([key, node]);
    }
    if (!isLeaving) {
      var _visitorKeys$nodeType2;
      stack = {
        inArray,
        index,
        keys,
        edits,
        prev: stack
      };
      inArray = Array.isArray(node);
      // @ts-ignore
      keys = inArray ? node : (_visitorKeys$nodeType2 = visitorKeys[nodeTypeGetter(node)]) !== null && _visitorKeys$nodeType2 !== void 0 ? _visitorKeys$nodeType2 : [];
      index = -1;
      edits = [];
      if (parent !== deleteNodeSymbol && parent !== undefined) {
        ancestors.push(parent);
      }
      parent = node;
    }
  } while (stack !== undefined);
  if (edits.length !== 0) {
    return edits[edits.length - 1][1]; // @TODO(vladimir.gorej@gmail.com): can be replaced by Array.prototype.at in future
  }
  return root;
};

/* eslint-enable */

/***/ }),

/***/ 11835:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19500);

class CloneError extends _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"] {
  value;
  constructor(message, structuredOptions) {
    super(message, structuredOptions);
    if (typeof structuredOptions !== 'undefined') {
      this.value = structuredOptions.value;
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CloneError);

/***/ }),

/***/ 79077:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _CloneError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11835);

class DeepCloneError extends _CloneError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DeepCloneError);

/***/ }),

/***/ 52343:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _CloneError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11835);

class ShallowCloneError extends _CloneError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ShallowCloneError);

/***/ }),

/***/ 87024:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cloneDeep: () => (/* binding */ cloneDeep),
/* harmony export */   cloneShallow: () => (/* binding */ cloneShallow)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var _predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33501);
/* harmony import */ var _errors_DeepCloneError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(79077);
/* harmony import */ var _errors_ShallowCloneError_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(52343);




const cloneDeep = (value, options = {}) => {
  const {
    visited = new WeakMap()
  } = options;
  const passThroughOptions = {
    ...options,
    visited
  };

  // detect cycle and return memoized value
  if (visited.has(value)) {
    return visited.get(value);
  }
  if (value instanceof minim__WEBPACK_IMPORTED_MODULE_0__.KeyValuePair) {
    const {
      key,
      value: val
    } = value;
    const keyCopy = (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isElement)(key) ? cloneDeep(key, passThroughOptions) : key;
    const valueCopy = (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isElement)(val) ? cloneDeep(val, passThroughOptions) : val;
    const copy = new minim__WEBPACK_IMPORTED_MODULE_0__.KeyValuePair(keyCopy, valueCopy);
    visited.set(value, copy);
    return copy;
  }
  if (value instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ObjectSlice) {
    const mapper = element => cloneDeep(element, passThroughOptions);
    const items = [...value].map(mapper);
    const copy = new minim__WEBPACK_IMPORTED_MODULE_0__.ObjectSlice(items);
    visited.set(value, copy);
    return copy;
  }
  if (value instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ArraySlice) {
    const mapper = element => cloneDeep(element, passThroughOptions);
    const items = [...value].map(mapper);
    const copy = new minim__WEBPACK_IMPORTED_MODULE_0__.ArraySlice(items);
    visited.set(value, copy);
    return copy;
  }
  if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isElement)(value)) {
    const copy = cloneShallow(value); // eslint-disable-line @typescript-eslint/no-use-before-define

    visited.set(value, copy);
    if (value.content) {
      if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isElement)(value.content)) {
        copy.content = cloneDeep(value.content, passThroughOptions);
      } else if (value.content instanceof minim__WEBPACK_IMPORTED_MODULE_0__.KeyValuePair) {
        copy.content = cloneDeep(value.content, passThroughOptions);
      } else if (Array.isArray(value.content)) {
        const mapper = element => cloneDeep(element, passThroughOptions);
        copy.content = value.content.map(mapper);
      } else {
        copy.content = value.content;
      }
    } else {
      copy.content = value.content;
    }
    return copy;
  }
  throw new _errors_DeepCloneError_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]("Value provided to cloneDeep function couldn't be cloned", {
    value
  });
};
cloneDeep.safe = value => {
  try {
    return cloneDeep(value);
  } catch {
    return value;
  }
};
const cloneShallowKeyValuePair = keyValuePair => {
  const {
    key,
    value
  } = keyValuePair;
  return new minim__WEBPACK_IMPORTED_MODULE_0__.KeyValuePair(key, value);
};
const cloneShallowArraySlice = arraySlice => {
  const items = [...arraySlice];
  return new minim__WEBPACK_IMPORTED_MODULE_0__.ArraySlice(items);
};
const cloneShallowObjectSlice = objectSlice => {
  const items = [...objectSlice];
  return new minim__WEBPACK_IMPORTED_MODULE_0__.ObjectSlice(items);
};

/* eslint-disable no-underscore-dangle */
const cloneShallowElement = element => {
  // @ts-ignore
  const copy = new element.constructor();
  copy.element = element.element;
  if (element.meta.length > 0) {
    copy._meta = cloneDeep(element.meta);
  }
  if (element.attributes.length > 0) {
    copy._attributes = cloneDeep(element.attributes);
  }
  if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isElement)(element.content)) {
    const content = element.content;
    copy.content = cloneShallowElement(content);
  } else if (Array.isArray(element.content)) {
    copy.content = [...element.content];
  } else if (element.content instanceof minim__WEBPACK_IMPORTED_MODULE_0__.KeyValuePair) {
    copy.content = cloneShallowKeyValuePair(element.content);
  } else {
    copy.content = element.content;
  }
  return copy;
};
/* eslint-enable */

const cloneShallow = value => {
  if (value instanceof minim__WEBPACK_IMPORTED_MODULE_0__.KeyValuePair) {
    return cloneShallowKeyValuePair(value);
  }
  if (value instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ObjectSlice) {
    return cloneShallowObjectSlice(value);
  }
  if (value instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ArraySlice) {
    return cloneShallowArraySlice(value);
  }
  if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isElement)(value)) {
    return cloneShallowElement(value);
  }
  throw new _errors_ShallowCloneError_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]("Value provided to cloneShallow function couldn't be cloned", {
    value
  });
};
cloneShallow.safe = value => {
  try {
    return cloneShallow(value);
  } catch {
    return value;
  }
};

/***/ }),

/***/ 82063:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);

class Annotation extends minim__WEBPACK_IMPORTED_MODULE_0__.StringElement {
  // classes: warning | error

  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'annotation';
  }
  get code() {
    return this.attributes.get('code');
  }
  set code(value) {
    this.attributes.set('code', value);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Annotation);

/***/ }),

/***/ 97659:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);

class Comment extends minim__WEBPACK_IMPORTED_MODULE_0__.StringElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'comment';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Comment);

/***/ }),

/***/ 76330:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(51520);


class ParseResult extends minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'parseResult';
  }
  get api() {
    return this.children.filter(item => item.classes.contains('api')).first;
  }
  get results() {
    return this.children.filter(item => item.classes.contains('result'));
  }
  get result() {
    return this.results.first;
  }
  get annotations() {
    return this.children.filter(item => item.element === 'annotation');
  }
  get warnings() {
    return this.children.filter(item => item.element === 'annotation' && item.classes.contains('warning'));
  }
  get errors() {
    return this.children.filter(item => item.element === 'annotation' && item.classes.contains('error'));
  }
  get isEmpty() {
    return this.children.reject(item => item.element === 'annotation').isEmpty;
  }
  replaceResult(replacement) {
    const {
      result
    } = this;
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"])(result)) {
      return false;
    }

    // @ts-ignore
    const searchIndex = this.content.findIndex(e => e === result);
    if (searchIndex === -1) {
      return false;
    }
    this.content[searchIndex] = replacement;
    return true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParseResult);

/***/ }),

/***/ 21275:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);

class SourceMap extends minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'sourceMap';
  }
  get positionStart() {
    return this.children.filter(item => item.classes.contains('position')).get(0);
  }
  get positionEnd() {
    return this.children.filter(item => item.classes.contains('position')).get(1);
  }
  set position(position) {
    if (typeof position === 'undefined') {
      return;
    }
    const start = new minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement([position.start.row, position.start.column, position.start.char]);
    const end = new minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement([position.end.row, position.end.column, position.end.char]);
    start.classes.push('position');
    end.classes.push('position');
    this.push(start).push(end);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SourceMap);

/***/ }),

/***/ 23725:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19500);

class ElementIdentityError extends _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"] {
  value;
  constructor(message, structuredOptions) {
    super(message, structuredOptions);
    if (typeof structuredOptions !== 'undefined') {
      this.value = structuredOptions.value;
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ElementIdentityError);

/***/ }),

/***/ 42209:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IdentityManager: () => (/* binding */ IdentityManager),
/* harmony export */   defaultIdentityManager: () => (/* binding */ defaultIdentityManager)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var short_unique_id__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8068);
/* harmony import */ var _errors_ElementIdentityError_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(23725);
/* harmony import */ var _predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33501);




class IdentityManager {
  uuid;
  identityMap;
  constructor({
    length = 6
  } = {}) {
    this.uuid = new short_unique_id__WEBPACK_IMPORTED_MODULE_1__({
      length
    });
    this.identityMap = new WeakMap();
  }
  identify(element) {
    if (!(0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isElement)(element)) {
      throw new _errors_ElementIdentityError_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]('Cannot not identify the element. `element` is neither structurally compatible nor a subclass of an Element class.', {
        value: element
      });
    }

    // use already assigned identity
    if (element.meta.hasKey('id') && (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(element.meta.get('id')) && !element.meta.get('id').equals('')) {
      return element.id;
    }

    // assign identity in immutable way
    if (this.identityMap.has(element)) {
      return this.identityMap.get(element);
    }

    // return element identity
    const id = new minim__WEBPACK_IMPORTED_MODULE_0__.StringElement(this.generateId());
    this.identityMap.set(element, id);
    return id;
  }
  forget(element) {
    if (this.identityMap.has(element)) {
      this.identityMap.delete(element);
      return true;
    }
    return false;
  }
  generateId() {
    return this.uuid.randomUUID();
  }
}
const defaultIdentityManager = new IdentityManager();

/***/ }),

/***/ 57478:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99784);

class MediaTypes extends Array {
  unknownMediaType = 'application/octet-stream';

  // eslint-disable-next-line class-methods-use-this
  filterByFormat() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"]('filterByFormat method in MediaTypes class is not yet implemented.');
  }

  // eslint-disable-next-line class-methods-use-this
  findBy() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"]('findBy method in MediaTypes class is not yet implemented.');
  }

  // eslint-disable-next-line class-methods-use-this
  latest() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"]('latest method in MediaTypes class is not yet implemented.');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTypes);

/***/ }),

/***/ 15461:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ deepmerge),
/* harmony export */   defaultOptions: () => (/* binding */ defaultOptions),
/* harmony export */   emptyElement: () => (/* binding */ emptyElement)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var _predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33501);
/* harmony import */ var _clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87024);
/* harmony import */ var _transformers_serializers_value_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9999);




/* eslint-disable @typescript-eslint/no-use-before-define */
const emptyElement = element => {
  const meta = element.meta.length > 0 ? (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(element.meta) : undefined;
  const attributes = element.attributes.length > 0 ? (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(element.attributes) : undefined;

  // @ts-ignore
  return new element.constructor(undefined, meta, attributes);
};
const cloneUnlessOtherwiseSpecified = (element, options) => options.clone && options.isMergeableElement(element) ? deepmerge(emptyElement(element), element, options) : element;
const getMergeFunction = (keyElement, options) => {
  if (typeof options.customMerge !== 'function') {
    return deepmerge;
  }
  const customMerge = options.customMerge(keyElement, options);
  return typeof customMerge === 'function' ? customMerge : deepmerge;
};
const getMetaMergeFunction = options => {
  if (typeof options.customMetaMerge !== 'function') {
    return targetMeta => (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(targetMeta);
  }
  return options.customMetaMerge;
};
const getAttributesMergeFunction = options => {
  if (typeof options.customAttributesMerge !== 'function') {
    return targetAttributes => (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(targetAttributes);
  }
  return options.customAttributesMerge;
};
const mergeArrayElement = (targetElement, sourceElement, options) => targetElement.concat(sourceElement)['fantasy-land/map'](item => cloneUnlessOtherwiseSpecified(item, options));
const mergeObjectElement = (targetElement, sourceElement, options) => {
  const destination = (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(targetElement) ? emptyElement(targetElement) : emptyElement(sourceElement);
  if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(targetElement)) {
    targetElement.forEach((value, key, member) => {
      const clonedMember = (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneShallow)(member);
      clonedMember.value = cloneUnlessOtherwiseSpecified(value, options);
      destination.content.push(clonedMember);
    });
  }
  sourceElement.forEach((value, key, member) => {
    const keyValue = (0,_transformers_serializers_value_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"])(key);
    let clonedMember;
    if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(targetElement) && targetElement.hasKey(keyValue) && options.isMergeableElement(value)) {
      const targetValue = targetElement.get(keyValue);
      clonedMember = (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneShallow)(member);
      clonedMember.value = getMergeFunction(key, options)(targetValue, value);
    } else {
      clonedMember = (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneShallow)(member);
      clonedMember.value = cloneUnlessOtherwiseSpecified(value, options);
    }
    destination.remove(keyValue);
    destination.content.push(clonedMember);
  });
  return destination;
};
const defaultOptions = {
  clone: true,
  isMergeableElement: element => (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(element) || (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isArrayElement)(element),
  arrayElementMerge: mergeArrayElement,
  objectElementMerge: mergeObjectElement,
  customMerge: undefined,
  customMetaMerge: undefined,
  customAttributesMerge: undefined
};
function deepmerge(targetElement, sourceElement, options) {
  var _mergedOptions$isMerg, _mergedOptions$arrayE, _mergedOptions$object;
  const mergedOptions = {
    ...defaultOptions,
    ...options
  };
  mergedOptions.isMergeableElement = (_mergedOptions$isMerg = mergedOptions.isMergeableElement) !== null && _mergedOptions$isMerg !== void 0 ? _mergedOptions$isMerg : defaultOptions.isMergeableElement;
  mergedOptions.arrayElementMerge = (_mergedOptions$arrayE = mergedOptions.arrayElementMerge) !== null && _mergedOptions$arrayE !== void 0 ? _mergedOptions$arrayE : defaultOptions.arrayElementMerge;
  mergedOptions.objectElementMerge = (_mergedOptions$object = mergedOptions.objectElementMerge) !== null && _mergedOptions$object !== void 0 ? _mergedOptions$object : defaultOptions.objectElementMerge;
  const sourceIsArrayElement = (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isArrayElement)(sourceElement);
  const targetIsArrayElement = (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isArrayElement)(targetElement);
  const sourceAndTargetTypesMatch = sourceIsArrayElement === targetIsArrayElement;
  if (!sourceAndTargetTypesMatch) {
    return cloneUnlessOtherwiseSpecified(sourceElement, mergedOptions);
  }

  // merging two elements
  const mergedElement = sourceIsArrayElement && typeof mergedOptions.arrayElementMerge === 'function' ? mergedOptions.arrayElementMerge(targetElement, sourceElement, mergedOptions) : mergedOptions.objectElementMerge(targetElement, sourceElement, mergedOptions);

  // merging meta & attributes
  mergedElement.meta = getMetaMergeFunction(mergedOptions)(targetElement.meta, sourceElement.meta);
  mergedElement.attributes = getAttributesMergeFunction(mergedOptions)(targetElement.attributes, sourceElement.attributes);
  return mergedElement;
}
deepmerge.all = (list, options) => {
  if (!Array.isArray(list)) {
    throw new TypeError('First argument of deepmerge should be an array.');
  }
  if (list.length === 0) {
    return new minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement();
  }
  return list.reduce((target, source) => {
    return deepmerge(target, source, options);
  }, emptyElement(list[0]));
};
/* eslint-enable @typescript-eslint/no-use-before-define */

/***/ }),

/***/ 1667:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Namespace: () => (/* binding */ Namespace),
/* harmony export */   createNamespace: () => (/* binding */ createNamespace),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24955);
/* harmony import */ var _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82063);
/* harmony import */ var _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(97659);
/* harmony import */ var _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(76330);
/* harmony import */ var _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(21275);






class Namespace extends minim__WEBPACK_IMPORTED_MODULE_0__.Namespace {
  constructor() {
    super();
    this.register('annotation', _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]);
    this.register('comment', _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]);
    this.register('parseResult', _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]);
    this.register('sourceMap', _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]);
  }
}
const namespace = new Namespace();
const createNamespace = namespacePlugin => {
  const namespaceInstance = new Namespace();
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(namespacePlugin)) {
    namespaceInstance.use(namespacePlugin);
  }
  return namespaceInstance;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (namespace);

/***/ }),

/***/ 67906:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   isElementType: () => (/* binding */ isElementType)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);

const hasMethod = (name, element) => {
  return typeof element === 'object' && element !== null && name in element && typeof element[name] === 'function';
};
const hasBasicElementProps = element => typeof element === 'object' && element != null && '_storedElement' in element && typeof element._storedElement === 'string' &&
// eslint-disable-line no-underscore-dangle
'_content' in element;
const primitiveEq = (val, element) => {
  if (typeof element === 'object' && element !== null && 'primitive' in element) {
    return typeof element.primitive === 'function' && element.primitive() === val;
  }
  return false;
};
const hasClass = (cls, element) => {
  return typeof element === 'object' && element !== null && 'classes' in element && (Array.isArray(element.classes) || element.classes instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement) && element.classes.includes(cls);
};
const isElementType = (name, element) => typeof element === 'object' && element !== null && 'element' in element && element.element === name;
const createPredicate = predicateCreator => {
  return predicateCreator({
    hasMethod,
    hasBasicElementProps,
    primitiveEq,
    isElementType,
    hasClass
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createPredicate);

/***/ }),

/***/ 33501:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasElementSourceMap: () => (/* binding */ hasElementSourceMap),
/* harmony export */   includesClasses: () => (/* binding */ includesClasses),
/* harmony export */   includesSymbols: () => (/* binding */ includesSymbols),
/* harmony export */   isAnnotationElement: () => (/* binding */ isAnnotationElement),
/* harmony export */   isArrayElement: () => (/* binding */ isArrayElement),
/* harmony export */   isBooleanElement: () => (/* binding */ isBooleanElement),
/* harmony export */   isCommentElement: () => (/* binding */ isCommentElement),
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isLinkElement: () => (/* binding */ isLinkElement),
/* harmony export */   isMemberElement: () => (/* binding */ isMemberElement),
/* harmony export */   isNullElement: () => (/* binding */ isNullElement),
/* harmony export */   isNumberElement: () => (/* binding */ isNumberElement),
/* harmony export */   isObjectElement: () => (/* binding */ isObjectElement),
/* harmony export */   isParseResultElement: () => (/* binding */ isParseResultElement),
/* harmony export */   isPrimitiveElement: () => (/* binding */ isPrimitiveElement),
/* harmony export */   isRefElement: () => (/* binding */ isRefElement),
/* harmony export */   isSourceMapElement: () => (/* binding */ isSourceMapElement),
/* harmony export */   isStringElement: () => (/* binding */ isStringElement)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(56679);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(7410);
/* harmony import */ var _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82063);
/* harmony import */ var _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97659);
/* harmony import */ var _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(76330);
/* harmony import */ var _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(21275);
/* harmony import */ var _helpers_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(67906);








const isElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.Element || hasBasicElementProps(element) && primitiveEq(undefined, element);
});
const isStringElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.StringElement || hasBasicElementProps(element) && primitiveEq('string', element);
});
const isNumberElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement || hasBasicElementProps(element) && primitiveEq('number', element);
});
const isNullElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.NullElement || hasBasicElementProps(element) && primitiveEq('null', element);
});
const isBooleanElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement || hasBasicElementProps(element) && primitiveEq('boolean', element);
});
const isObjectElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq,
  hasMethod
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement || hasBasicElementProps(element) && primitiveEq('object', element) && hasMethod('keys', element) && hasMethod('values', element) && hasMethod('items', element);
});
const isArrayElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq,
  hasMethod
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement && !(element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement) || hasBasicElementProps(element) && primitiveEq('array', element) && hasMethod('push', element) && hasMethod('unshift', element) && hasMethod('map', element) && hasMethod('reduce', element);
});
const isMemberElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.MemberElement || hasBasicElementProps(element) && isElementType('member', element) && primitiveEq(undefined, element);
});
const isLinkElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement || hasBasicElementProps(element) && isElementType('link', element) && primitiveEq(undefined, element);
});
const isRefElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.RefElement || hasBasicElementProps(element) && isElementType('ref', element) && primitiveEq(undefined, element);
});
const isAnnotationElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('annotation', element) && primitiveEq('array', element);
});
const isCommentElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__["default"] || hasBasicElementProps(element) && isElementType('comment', element) && primitiveEq('string', element);
});
const isParseResultElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__["default"] || hasBasicElementProps(element) && isElementType('parseResult', element) && primitiveEq('array', element);
});
const isSourceMapElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__["default"] || hasBasicElementProps(element) && isElementType('sourceMap', element) && primitiveEq('array', element);
});
const isPrimitiveElement = element => {
  return (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('object', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('array', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('boolean', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('number', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('string', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('null', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('member', element);
};
const hasElementSourceMap = element => {
  return isSourceMapElement(element.meta.get('sourceMap'));
};
const includesSymbols = (symbols, element) => {
  if (symbols.length === 0) {
    return true;
  }
  const elementSymbols = element.attributes.get('symbols');
  if (!isArrayElement(elementSymbols)) {
    return false;
  }
  return (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__["default"])(elementSymbols.toValue()), symbols);
};
const includesClasses = (classes, element) => {
  if (classes.length === 0) {
    return true;
  }
  return (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__["default"])(element.classes.toValue()), classes);
};

/***/ }),

/***/ 90897:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRefractor: () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _plugins_dispatcher_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15922);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(46571);
/* harmony import */ var _clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87024);
/* harmony import */ var _predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33501);
/* harmony import */ var _toolbox_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(55132);





const refract = (value, {
  Type,
  plugins = []
}) => {
  /**
   * This is where values gets refracted into generic ApiDOM.
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const element = new Type(value);
  if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__.isElement)(value)) {
    if (value.meta.length > 0) {
      element.meta = (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(value.meta);
    }
    if (value.attributes.length > 0) {
      element.attributes = (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(value.attributes);
    }
  }

  /**
   * Run plugins only when necessary.
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_plugins_dispatcher_index_mjs__WEBPACK_IMPORTED_MODULE_2__.dispatchPluginsSync)(element, plugins, {
    toolboxCreator: _toolbox_mjs__WEBPACK_IMPORTED_MODULE_3__["default"],
    visitorOptions: {
      nodeTypeGetter: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_4__.getNodeType
    }
  });
};
const createRefractor = Type => (value, options = {}) => refract(value, {
  ...options,
  Type
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 15922:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dispatchPluginsAsync: () => (/* binding */ dispatchPluginsAsync),
/* harmony export */   dispatchPluginsSync: () => (/* binding */ dispatchPluginsSync)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24454);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(46850);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(23283);
/* harmony import */ var _toolbox_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(55132);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46571);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(68618);




const defaultDispatchPluginsOptions = {
  toolboxCreator: _toolbox_mjs__WEBPACK_IMPORTED_MODULE_0__["default"],
  visitorOptions: {
    nodeTypeGetter: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.getNodeType,
    exposeEdits: true
  }
};
const dispatchPluginsSync = (element, plugins, options = {}) => {
  if (plugins.length === 0) return element;
  const mergedOptions = (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(defaultDispatchPluginsOptions, options);
  const {
    toolboxCreator,
    visitorOptions
  } = mergedOptions;
  const toolbox = toolboxCreator();
  const pluginsSpecs = plugins.map(plugin => plugin(toolbox));
  const mergedPluginsVisitor = (0,_traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_3__.mergeAll)(pluginsSpecs.map((0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])({}, 'visitor')), {
    ...visitorOptions
  });
  pluginsSpecs.forEach((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(['pre'], []));
  const newElement = (0,_traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.visit)(element, mergedPluginsVisitor, visitorOptions);
  pluginsSpecs.forEach((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(['post'], []));
  return newElement;
};
const dispatchPluginsAsync = async (element, plugins, options = {}) => {
  if (plugins.length === 0) return element;
  const mergedOptions = (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(defaultDispatchPluginsOptions, options);
  const {
    toolboxCreator,
    visitorOptions
  } = mergedOptions;
  const toolbox = toolboxCreator();
  const pluginsSpecs = plugins.map(plugin => plugin(toolbox));
  const mergeAllVisitorsAsync = _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_3__.mergeAll[Symbol.for('nodejs.util.promisify.custom')];
  const visitAsync = _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.visit[Symbol.for('nodejs.util.promisify.custom')];
  const mergedPluginsVisitor = mergeAllVisitorsAsync(pluginsSpecs.map((0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])({}, 'visitor')), {
    ...visitorOptions
  });
  await Promise.allSettled(pluginsSpecs.map((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(['pre'], [])));
  const newElement = await visitAsync(element, mergedPluginsVisitor, visitorOptions);
  await Promise.allSettled(pluginsSpecs.map((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(['post'], [])));
  return newElement;
};
dispatchPluginsSync[Symbol.for('nodejs.util.promisify.custom')] = dispatchPluginsAsync;

/***/ }),

/***/ 44824:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AnnotationElement: () => (/* reexport safe */ _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   ArrayElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement),
/* harmony export */   BooleanElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement),
/* harmony export */   CommentElement: () => (/* reexport safe */ _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   LinkElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement),
/* harmony export */   NullElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.NullElement),
/* harmony export */   NumberElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement),
/* harmony export */   ObjectElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement),
/* harmony export */   ParseResultElement: () => (/* reexport safe */ _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   RefElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.RefElement),
/* harmony export */   SourceMapElement: () => (/* reexport safe */ _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   StringElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.StringElement)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82063);
/* harmony import */ var _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(97659);
/* harmony import */ var _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(76330);
/* harmony import */ var _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(21275);
/* harmony import */ var _index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(90897);






minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement);
minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement);
minim__WEBPACK_IMPORTED_MODULE_0__.StringElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.StringElement);
minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement);
minim__WEBPACK_IMPORTED_MODULE_0__.NullElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.NullElement);
minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement);
minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement);
minim__WEBPACK_IMPORTED_MODULE_0__.RefElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.RefElement);
_elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]);
_elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]);
_elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]);
_elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]);


/***/ }),

/***/ 55132:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33501);
/* harmony import */ var _namespace_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1667);


const createToolbox = () => {
  const predicates = {
    ..._predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__
  };
  return {
    predicates,
    namespace: _namespace_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createToolbox);

/***/ }),

/***/ 44787:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(51520);
/* harmony import */ var _predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33501);


const computeEdges = (element, edges = new WeakMap()) => {
  if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__.isMemberElement)(element)) {
    // @ts-ignore
    edges.set(element.key, element);
    // @ts-ignore
    computeEdges(element.key, edges);
    // @ts-ignore
    edges.set(element.value, element);
    // @ts-ignore
    computeEdges(element.value, edges);
  } else {
    element.children.forEach(childElement => {
      edges.set(childElement, element);
      computeEdges(childElement, edges);
    });
  }
  return edges;
};
const transcludeChildOfMemberElement = (search, replace, edges) => {
  const memberElement = edges.get(search);
  if (!(0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__.isMemberElement)(memberElement)) {
    return;
  }
  if (memberElement.key === search) {
    memberElement.key = replace;
    edges.delete(search);
    edges.set(replace, memberElement);
  }
  if (memberElement.value === search) {
    memberElement.value = replace;
    edges.delete(search);
    edges.set(replace, memberElement);
  }
};
const transcludeChildOfObjectElement = (search, replace, edges) => {
  const objectElement = edges.get(search);
  if (!(0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__.isObjectElement)(objectElement)) {
    return;
  }
  objectElement.content = objectElement.map((value, key, member) => {
    if (member === search) {
      edges.delete(search);
      edges.set(replace, objectElement);
      return replace;
    }
    return member;
  });
};
const transcludeChildOfArrayElement = (search, replace, edges) => {
  const arrayElement = edges.get(search);
  if (!(0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__.isArrayElement)(arrayElement)) {
    return;
  }
  arrayElement.content = arrayElement.map(element => {
    if (element === search) {
      edges.delete(search);
      edges.set(replace, arrayElement);
      return replace;
    }
    return element;
  });
};

/**
 * This is a mutating stamp. If you don't want your Element to be mutated,
 * clone in before passing it to initializer of this stamp.
 */

class Transcluder {
  element;
  edges;
  constructor({
    element
  }) {
    this.element = element;
  }
  transclude(search, replace) {
    var _this$edges;
    // shortcut 1. - replacing entire ApiDOM tree
    if (search === this.element) return replace;
    // shortcut 2. - replacing nothing
    if (search === replace) return this.element;
    this.edges = (_this$edges = this.edges) !== null && _this$edges !== void 0 ? _this$edges : computeEdges(this.element);
    const parent = this.edges.get(search);
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"])(parent)) {
      return undefined;
    }

    /**
     * This predicate must be first because ObjectElement extends ArrayElement.
     * isArrayElement returns true for ObjectElements.
     * (classical problems with polymorphism)
     */
    if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__.isObjectElement)(parent)) {
      // @ts-ignore
      transcludeChildOfObjectElement(search, replace, this.edges);
    } else if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__.isArrayElement)(parent)) {
      transcludeChildOfArrayElement(search, replace, this.edges);
    } else if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__.isMemberElement)(parent)) {
      transcludeChildOfMemberElement(search, replace, this.edges);
    }
    return this.element;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Transcluder);

/***/ }),

/***/ 65342:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   transclude: () => (/* binding */ transclude)
/* harmony export */ });
/* harmony import */ var _Transcluder_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44787);

/**
 * This is a mutating function. If you don't want your Element to be mutated,
 * clone in before passing it to this function.
 */
const transclude = (search, replace, element) => {
  const transcluder = new _Transcluder_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]({
    element
  });
  return transcluder.transclude(search, replace);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_Transcluder_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]);

/***/ }),

/***/ 32121:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(73236);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1679);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24955);
/* harmony import */ var _namespace_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1667);



/**
 * Transforms data to an Element from a particular namespace.
 *
 * The name of the function was originally `from`,
 * but it was renamed to `fromFn` to avoid issues with Parcel.js:
 *
 * - https://github.com/parcel-bundler/parcel/issues/9473
 * - https://github.com/swagger-api/swagger-ui/issues/9466#issuecomment-1881053410
 */
const fromFn = (data, namespace = _namespace_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]) => {
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"])(data)) {
    // JSON serialized refract
    try {
      return namespace.fromRefract(JSON.parse(data));
    } catch {
      // noop
    }
  }
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__["default"])(data) && (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])('element', data)) {
    // refract javascript structure
    return namespace.fromRefract(data);
  }
  return namespace.toElement(data);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (fromFn);

/***/ }),

/***/ 42615:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
class EphemeralArray {
  type = 'EphemeralArray';
  content = [];
  reference = undefined;
  constructor(content) {
    this.content = content;
    this.reference = [];
  }
  toReference() {
    return this.reference;
  }
  toArray() {
    this.reference.push(...this.content);
    return this.reference;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EphemeralArray);

/***/ }),

/***/ 89373:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
class EphemeralObject {
  type = 'EphemeralObject';
  content = [];
  reference = undefined;
  constructor(content) {
    this.content = content;
    this.reference = {};
  }
  toReference() {
    return this.reference;
  }
  toObject() {
    return Object.assign(this.reference, Object.fromEntries(this.content));
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EphemeralObject);

/***/ }),

/***/ 9999:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _visitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(17013);
/* harmony import */ var _ast_ephemeral_array_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42615);
/* harmony import */ var _ast_ephemeral_object_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(89373);
/* harmony import */ var _predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33501);




/* eslint-disable class-methods-use-this */
class Visitor {
  ObjectElement = {
    enter: element => {
      if (this.references.has(element)) {
        return this.references.get(element).toReference();
      }
      const ephemeral = new _ast_ephemeral_object_mjs__WEBPACK_IMPORTED_MODULE_0__["default"](element.content);
      this.references.set(element, ephemeral);
      return ephemeral;
    }
  };
  EphemeralObject = {
    leave: ephemeral => {
      return ephemeral.toObject();
    }
  };
  MemberElement = {
    enter: element => {
      return [element.key, element.value];
    }
  };
  ArrayElement = {
    enter: element => {
      if (this.references.has(element)) {
        return this.references.get(element).toReference();
      }
      const ephemeral = new _ast_ephemeral_array_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](element.content);
      this.references.set(element, ephemeral);
      return ephemeral;
    }
  };
  EphemeralArray = {
    leave: ephemeral => {
      return ephemeral.toArray();
    }
  };
  references = new WeakMap();
  BooleanElement(element) {
    return element.toValue();
  }
  NumberElement(element) {
    return element.toValue();
  }
  StringElement(element) {
    return element.toValue();
  }
  NullElement() {
    return null;
  }
  RefElement(element, ...rest) {
    var _ancestors;
    const ancestors = rest[3];
    if (((_ancestors = ancestors[ancestors.length - 1]) === null || _ancestors === void 0 ? void 0 : _ancestors.type) === 'EphemeralObject') {
      return Symbol.for('delete-node');
    }
    return String(element.toValue());
  }
  LinkElement(element) {
    if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(element.href)) {
      return element.href.toValue();
    }
    return '';
  }
}
const serializer = element => {
  if (!(0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isElement)(element)) return element;

  // shortcut optimization for certain element types
  if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(element) || (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isNumberElement)(element) || (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isBooleanElement)(element) || (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_2__.isNullElement)(element)) {
    return element.toValue();
  }
  return (0,_visitor_mjs__WEBPACK_IMPORTED_MODULE_3__.visit)(element, new Visitor());
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (serializer);

/***/ }),

/***/ 17013:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   visit: () => (/* binding */ visit)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11892);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46571);


const nodeTypeGetter = node => {
  if (typeof (node === null || node === void 0 ? void 0 : node.type) === 'string') {
    return node.type;
  }
  return (0,_traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_0__.getNodeType)(node);
};
const keyMapDefault = {
  EphemeralObject: ['content'],
  EphemeralArray: ['content'],
  ..._traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_0__.keyMapDefault
};

// eslint-disable-next-line import/prefer-default-export
const visit = (root,
// @ts-ignore
visitor, {
  keyMap = keyMapDefault,
  ...rest
} = {}) => {
  return (0,_traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_0__.visit)(root, visitor, {
    keyMap,
    // @ts-ignore
    nodeTypeGetter,
    nodePredicate: ramda__WEBPACK_IMPORTED_MODULE_1__["default"],
    detectCycles: false,
    deleteNodeSymbol: Symbol.for('delete-node'),
    skipVisitingNodeSymbol: Symbol.for('skip-visiting-node'),
    ...rest
  });
};

// @ts-ignore
visit[Symbol.for('nodejs.util.promisify.custom')] = async (root, {
  keyMap = keyMapDefault,
  ...rest
} = {}) => {
  // @ts-ignore
  return _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_0__.visit[Symbol.for('nodejs.util.promisify.custom')](root, visitor, {
    keyMap,
    nodeTypeGetter,
    nodePredicate: ramda__WEBPACK_IMPORTED_MODULE_1__["default"],
    detectCycles: false,
    deleteNodeSymbol: Symbol.for('delete-node'),
    skipVisitingNodeSymbol: Symbol.for('skip-visiting-node'),
    ...rest
  });
};

/***/ }),

/***/ 557:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var _visitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46571);

 // finds all elements matching the predicate
const filter = (predicate, element) => {
  const visitor = new _visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.PredicateVisitor({
    predicate
  });
  (0,_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.visit)(element, visitor);
  return new minim__WEBPACK_IMPORTED_MODULE_0__.ArraySlice(visitor.result);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (filter);

/***/ }),

/***/ 82570:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(52220);
/* harmony import */ var _visitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46571);
/* harmony import */ var _visitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(68618);

 // find first element that satisfies the provided predicate
const find = (predicate, element) => {
  const visitor = new _visitor_mjs__WEBPACK_IMPORTED_MODULE_0__.PredicateVisitor({
    predicate,
    returnOnTrue: _visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.BREAK
  });
  (0,_visitor_mjs__WEBPACK_IMPORTED_MODULE_0__.visit)(element, visitor);
  return (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(undefined, [0], visitor.result);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (find);

/***/ }),

/***/ 46571:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BREAK: () => (/* reexport safe */ _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_0__.BREAK),
/* harmony export */   PredicateVisitor: () => (/* binding */ PredicateVisitor),
/* harmony export */   cloneNode: () => (/* binding */ cloneNode),
/* harmony export */   getNodeType: () => (/* binding */ getNodeType),
/* harmony export */   isNode: () => (/* binding */ isNode),
/* harmony export */   keyMapDefault: () => (/* binding */ keyMapDefault),
/* harmony export */   mergeAllVisitors: () => (/* reexport safe */ _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_0__.mergeAll),
/* harmony export */   visit: () => (/* binding */ visit)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11182);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3182);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1679);
/* harmony import */ var _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68618);
/* harmony import */ var _predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33501);
/* harmony import */ var _clone_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87024);







// getNodeType :: Node -> String
const getNodeType = element => {
  /*
   * We're translating every possible higher element type to primitive minim type here.
   * We're using polymorphism to recognize any higher element type as ObjectElement or ArrayElement.
   * Using polymorphism allows us to assume any namespace.
   *
   * There is a problem with naming visitor methods described here: https://github.com/babel/babel/discussions/12874
   */
  return (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isObjectElement)(element) ? 'ObjectElement' : (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isArrayElement)(element) ? 'ArrayElement' : (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isMemberElement)(element) ? 'MemberElement' : (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isStringElement)(element) ? 'StringElement' : (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isBooleanElement)(element) ? 'BooleanElement' : (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isNumberElement)(element) ? 'NumberElement' : (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isNullElement)(element) ? 'NullElement' : (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isLinkElement)(element) ? 'LinkElement' : (0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isRefElement)(element) ? 'RefElement' : undefined;
};

// cloneNode :: a -> a
const cloneNode = node => {
  if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_1__.isElement)(node)) {
    return (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_2__.cloneShallow)(node);
  }
  return (0,_swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_0__.cloneNode)(node);
};

// isNode :: Node -> Boolean
const isNode = (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(getNodeType, ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"]);
const keyMapDefault = {
  ObjectElement: ['content'],
  ArrayElement: ['content'],
  MemberElement: ['key', 'value'],
  StringElement: [],
  BooleanElement: [],
  NumberElement: [],
  NullElement: [],
  RefElement: [],
  LinkElement: [],
  Annotation: [],
  Comment: [],
  ParseResultElement: ['content'],
  SourceMap: ['content']
};
class PredicateVisitor {
  result;
  predicate;
  returnOnTrue;
  returnOnFalse;
  constructor({
    predicate = ramda__WEBPACK_IMPORTED_MODULE_5__["default"],
    returnOnTrue,
    returnOnFalse
  } = {}) {
    this.result = [];
    this.predicate = predicate;
    this.returnOnTrue = returnOnTrue;
    this.returnOnFalse = returnOnFalse;
  }
  enter(element) {
    if (this.predicate(element)) {
      this.result.push(element);
      return this.returnOnTrue;
    }
    return this.returnOnFalse;
  }
}
const visit = (root,
// @ts-ignore
visitor, {
  keyMap = keyMapDefault,
  ...rest
} = {}) => {
  // @ts-ignore
  return (0,_swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_0__.visit)(root, visitor, {
    // @ts-ignore
    keyMap,
    // @ts-ignore
    nodeTypeGetter: getNodeType,
    nodePredicate: isNode,
    nodeCloneFn: cloneNode,
    ...rest
  });
};

// @ts-ignore
visit[Symbol.for('nodejs.util.promisify.custom')] = async (root,
// @ts-ignore
visitor, {
  keyMap = keyMapDefault,
  ...rest
} = {}) => {
  // @ts-ignore
  return _swagger_api_apidom_ast__WEBPACK_IMPORTED_MODULE_0__.visit[Symbol.for('nodejs.util.promisify.custom')](root, visitor, {
    // @ts-ignore
    keyMap,
    // @ts-ignore
    nodeTypeGetter: getNodeType,
    nodePredicate: isNode,
    nodeCloneFn: cloneNode,
    ...rest
  });
};

/***/ }),

/***/ 490:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dereference: () => (/* binding */ dereference)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37012);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5548);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(73236);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(72246);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24445);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24955);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1679);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(82129);



/**
 * This dereference algorithm is used exclusively for dereferencing specification objects.
 * It doesn't handle circular references of external references and works on objects only (not arrays).
 */
// eslint-disable-next-line import/prefer-default-export
const dereference = (object, root) => {
  const rootObject = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(object, root);
  return (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(val => {
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__["default"])(val) && (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])('$ref', val) && (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"], '$ref', val)) {
      const $ref = (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])(['$ref'], val);
      // @ts-ignore
      const pointer = (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__["default"])('#/', $ref);
      return (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])(pointer.split('/'), rootObject);
    }
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__["default"])(val)) {
      return dereference(val, rootObject);
    }
    return val;
  }, object);
};

/***/ }),

/***/ 36486:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _babel_runtime_corejs3_core_js_aggregate_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(48675);

class ApiDOMAggregateError extends _babel_runtime_corejs3_core_js_aggregate_error__WEBPACK_IMPORTED_MODULE_0__ {
  constructor(errors, message, options) {
    super(errors, message, options);
    this.name = this.constructor.name;
    if (typeof message === 'string') {
      this.message = message;
    }
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(message).stack;
    }

    /**
     * This needs to stay here until our minimum supported version of Node.js is >= 16.9.0.
     * Node.js >= 16.9.0 supports error causes natively.
     */
    if (options != null && typeof options === 'object' && Object.hasOwn(options, 'cause') && !('cause' in this)) {
      const {
        cause
      } = options;
      this.cause = cause;
      if (cause instanceof Error && 'stack' in cause) {
        this.stack = `${this.stack}\nCAUSE: ${cause.stack}`;
      }
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ApiDOMAggregateError);

/***/ }),

/***/ 98219:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ApiDOMAggregateError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36486);

class ApiDOMError extends Error {
  static [Symbol.hasInstance](instance) {
    // we want to ApiDOMAggregateError to act as if ApiDOMError was its superclass
    return super[Symbol.hasInstance](instance) || Function.prototype[Symbol.hasInstance].call(_ApiDOMAggregateError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"], instance);
  }
  constructor(message, options) {
    super(message, options);
    this.name = this.constructor.name;
    if (typeof message === 'string') {
      this.message = message;
    }
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(message).stack;
    }

    /**
     * This needs to stay here until our minimum supported version of Node.js is >= 16.9.0.
     * Node.js is >= 16.9.0 supports error causes natively.
     */
    if (options != null && typeof options === 'object' && Object.hasOwn(options, 'cause') && !('cause' in this)) {
      const {
        cause
      } = options;
      this.cause = cause;
      if (cause instanceof Error && 'stack' in cause) {
        this.stack = `${this.stack}\nCAUSE: ${cause.stack}`;
      }
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ApiDOMError);

/***/ }),

/***/ 19500:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ApiDOMError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98219);

class ApiDOMStructuredError extends _ApiDOMError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(message, structuredOptions) {
    super(message, structuredOptions);
    if (structuredOptions != null && typeof structuredOptions === 'object') {
      const {
        cause,
        ...causelessOptions
      } = structuredOptions;
      Object.assign(this, causelessOptions);
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ApiDOMStructuredError);

/***/ }),

/***/ 99784:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _UnsupportedOperationError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9475);

class NotImplementedError extends _UnsupportedOperationError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotImplementedError);

/***/ }),

/***/ 9475:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ApiDOMError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98219);

class UnsupportedOperationError extends _ApiDOMError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UnsupportedOperationError);

/***/ }),

/***/ 60672:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _escape_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39312);
/* harmony import */ var _errors_CompilationJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45517);

 // compile :: String[] -> String
const compile = tokens => {
  try {
    if (tokens.length === 0) {
      return '';
    }
    return `/${tokens.map(_escape_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]).join('/')}`;
  } catch (error) {
    throw new _errors_CompilationJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]('JSON Pointer compilation of tokens encountered an error.', {
      tokens,
      cause: error
    });
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (compile);

/***/ }),

/***/ 45517:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _JsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20466);

class CompilationJsonPointerError extends _JsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  tokens;
  constructor(message, structuredOptions) {
    super(message, structuredOptions);
    if (typeof structuredOptions !== 'undefined') {
      this.tokens = [...structuredOptions.tokens];
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CompilationJsonPointerError);

/***/ }),

/***/ 64884:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _JsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20466);

class EvaluationJsonPointerError extends _JsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  pointer;
  tokens;
  failedToken;
  failedTokenPosition;
  element;
  constructor(message, structuredOptions) {
    super(message, structuredOptions);
    if (typeof structuredOptions !== 'undefined') {
      this.pointer = structuredOptions.pointer;
      if (Array.isArray(structuredOptions.tokens)) {
        this.tokens = [...structuredOptions.tokens];
      }
      this.failedToken = structuredOptions.failedToken;
      this.failedTokenPosition = structuredOptions.failedTokenPosition;
      this.element = structuredOptions.element;
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EvaluationJsonPointerError);

/***/ }),

/***/ 60489:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _JsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20466);

class InvalidJsonPointerError extends _JsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  pointer;
  constructor(message, structuredOptions) {
    super(message, structuredOptions);
    if (typeof structuredOptions !== 'undefined') {
      this.pointer = structuredOptions.pointer;
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InvalidJsonPointerError);

/***/ }),

/***/ 20466:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19500);

class JsonPointerError extends _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JsonPointerError);

/***/ }),

/***/ 39312:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11182);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28276);


// escape :: String -> String
const escape = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])((0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(/~/g, '~0'), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(/\//g, '~1'), encodeURIComponent);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (escape);

/***/ }),

/***/ 18316:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(54166);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33501);
/* harmony import */ var _parse_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(85270);
/* harmony import */ var _errors_EvaluationJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64884);



 // evaluates JSON Pointer against ApiDOM fragment
const evaluate = (pointer, element) => {
  let tokens;
  try {
    tokens = (0,_parse_mjs__WEBPACK_IMPORTED_MODULE_0__["default"])(pointer);
  } catch (error) {
    throw new _errors_EvaluationJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](`JSON Pointer evaluation failed while parsing the pointer "${pointer}".`, {
      pointer,
      element: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.cloneDeep)(element),
      cause: error
    });
  }
  return tokens.reduce((acc, token, tokenPosition) => {
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isObjectElement)(acc)) {
      // @ts-ignore
      if (!acc.hasKey(token)) {
        throw new _errors_EvaluationJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](`JSON Pointer evaluation failed while evaluating token "${token}" against an ObjectElement`, {
          pointer,
          tokens,
          failedToken: token,
          failedTokenPosition: tokenPosition,
          element: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.cloneDeep)(acc)
        });
      }
      // @ts-ignore
      return acc.get(token);
    }
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isArrayElement)(acc)) {
      if (!(token in acc.content) || !(0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(Number(token))) {
        throw new _errors_EvaluationJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](`JSON Pointer evaluation failed while evaluating token "${token}" against an ArrayElement`, {
          pointer,
          tokens,
          failedToken: token,
          failedTokenPosition: tokenPosition,
          element: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.cloneDeep)(acc)
        });
      }
      // @ts-ignore
      return acc.get(Number(token));
    }
    throw new _errors_EvaluationJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](`JSON Pointer evaluation failed while evaluating token "${token}" against an unexpected Element`, {
      pointer,
      tokens,
      failedToken: token,
      failedTokenPosition: tokenPosition,
      element: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.cloneDeep)(acc)
    });
  }, element);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (evaluate);

/***/ }),

/***/ 85270:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   uriToPointer: () => (/* binding */ uriToPointer)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29663);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(11182);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(30516);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(82598);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(84596);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13380);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(82129);
/* harmony import */ var _unescape_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(91453);
/* harmony import */ var _errors_InvalidJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60489);



 // parse :: String -> String[]
const parse = pointer => {
  if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_0__["default"])(pointer)) {
    return [];
  }
  if (!(0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])('/', pointer)) {
    throw new _errors_InvalidJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_2__["default"](`Invalid JSON Pointer "${pointer}". JSON Pointers must begin with "/"`, {
      pointer
    });
  }
  try {
    const tokens = (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])((0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])('/'), (0,ramda__WEBPACK_IMPORTED_MODULE_5__["default"])(_unescape_mjs__WEBPACK_IMPORTED_MODULE_6__["default"]))(pointer);
    return (0,ramda__WEBPACK_IMPORTED_MODULE_7__["default"])(tokens);
  } catch (error) {
    throw new _errors_InvalidJsonPointerError_mjs__WEBPACK_IMPORTED_MODULE_2__["default"](`JSON Pointer parsing of "${pointer}" encountered an error.`, {
      pointer,
      cause: error
    });
  }
};

/**
 * Returns the hash (URL fragment), of the given path.
 * If there is no hash, then the root hash ("#") is returned.
 */
const getHash = uri => {
  const hashIndex = uri.indexOf('#');
  if (hashIndex !== -1) {
    return uri.substring(hashIndex);
  }
  return '#';
};

// uriToPointer :: String -> String
const uriToPointer = uri => {
  const hash = getHash(uri);
  return (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_8__["default"])('#', hash);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parse);

/***/ }),

/***/ 91453:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11182);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(28276);


/**
 * decodeURIComponent can throw URIError in certain cases like 'c%d'.
 * safeDecodeURIComponent is a safe variant of decodeURIComponent that never trows.
 *
 * {@link https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Errors/Malformed_URI|More info about URIError}
 */
const safeDecodeURIComponent = encodedURIComponent => {
  try {
    return decodeURIComponent(encodedURIComponent);
  } catch {
    return encodedURIComponent;
  }
};

// unescape :: String -> String
const unescape = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])((0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(/~1/g, '/'), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(/~0/g, '~'), safeDecodeURIComponent);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (unescape);

/***/ }),

/***/ 19565:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);


/**
 * In Draft 4, $ref behaves a little differently. When an object contains a $ref property,
 * the object is considered a reference, not a schema. Therefore, any other properties you put in that object will
 * not be treated as JSON Schema keywords and will be ignored by the validator.
 * $ref can only be used where a schema is expected.
 *
 * URI: https://json-schema.org/understanding-json-schema/structuring.html?highlight=ref#id18
 */

class JSONReference extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'JSONReference';
    this.classes.push('json-reference');
  }
  get $ref() {
    return this.get('$ref');
  }
  set $ref($ref) {
    this.set('$ref', $ref);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONReference);

/***/ }),

/***/ 17659:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class JSONSchema extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'JSONSchemaDraft4';
  }

  /**
   * Core vocabulary
   *
   * URI: https://tools.ietf.org/html/draft-wright-json-schema-00
   */

  get idProp() {
    return this.get('id');
  }
  set idProp(idProp) {
    this.set('id', idProp);
  }
  get $schema() {
    return this.get('$schema');
  }
  set $schema($schema) {
    this.set('$schema', $schema);
  }

  /**
   * Validation vocabulary
   *
   * URI: https://tools.ietf.org/html/draft-wright-json-schema-validation-00
   */

  /**
   *  Validation keywords for numeric instances (number and integer)
   */

  get multipleOf() {
    return this.get('multipleOf');
  }
  set multipleOf(multipleOf) {
    this.set('multipleOf', multipleOf);
  }
  get maximum() {
    return this.get('maximum');
  }
  set maximum(maximum) {
    this.set('maximum', maximum);
  }
  get exclusiveMaximum() {
    return this.get('exclusiveMaximum');
  }
  set exclusiveMaximum(exclusiveMaximum) {
    this.set('exclusiveMaximum', exclusiveMaximum);
  }
  get minimum() {
    return this.get('minimum');
  }
  set minimum(minimum) {
    this.set('minimum', minimum);
  }
  get exclusiveMinimum() {
    return this.get('exclusiveMinimum');
  }
  set exclusiveMinimum(exclusiveMinimum) {
    this.set('exclusiveMinimum', exclusiveMinimum);
  }

  /**
   * Validation keywords for strings
   */

  get maxLength() {
    return this.get('maxLength');
  }
  set maxLength(maxLength) {
    this.set('maxLength', maxLength);
  }
  get minLength() {
    return this.get('minLength');
  }
  set minLength(minLength) {
    this.set('minLength', minLength);
  }
  get pattern() {
    return this.get('pattern');
  }
  set pattern(pattern) {
    this.set('pattern', pattern);
  }

  /**
   * Validation keywords for arrays
   */

  get additionalItems() {
    return this.get('additionalItems');
  }
  set additionalItems(additionalItems) {
    this.set('additionalItems', additionalItems);
  }
  get items() {
    return this.get('items');
  }
  set items(items) {
    this.set('items', items);
  }
  get maxItems() {
    return this.get('maxItems');
  }
  set maxItems(maxItems) {
    this.set('maxItems', maxItems);
  }
  get minItems() {
    return this.get('minItems');
  }
  set minItems(minItems) {
    this.set('minItems', minItems);
  }
  get uniqueItems() {
    return this.get('uniqueItems');
  }
  set uniqueItems(uniqueItems) {
    this.set('uniqueItems', uniqueItems);
  }

  /**
   * Validation keywords for objects
   */

  get maxProperties() {
    return this.get('maxProperties');
  }
  set maxProperties(maxProperties) {
    this.set('maxProperties', maxProperties);
  }
  get minProperties() {
    return this.get('minProperties');
  }
  set minProperties(minProperties) {
    this.set('minProperties', minProperties);
  }
  get required() {
    return this.get('required');
  }
  set required(required) {
    this.set('required', required);
  }
  get properties() {
    return this.get('properties');
  }
  set properties(properties) {
    this.set('properties', properties);
  }
  get additionalProperties() {
    return this.get('additionalProperties');
  }
  set additionalProperties(additionalProperties) {
    this.set('additionalProperties', additionalProperties);
  }
  get patternProperties() {
    return this.get('patternProperties');
  }
  set patternProperties(patternProperties) {
    this.set('patternProperties', patternProperties);
  }
  get dependencies() {
    return this.get('dependencies');
  }
  set dependencies(dependencies) {
    this.set('dependencies', dependencies);
  }

  /**
   *  Validation keywords for any instance type
   */

  get enum() {
    return this.get('enum');
  }
  set enum(enumValue) {
    this.set('enum', enumValue);
  }
  get type() {
    return this.get('type');
  }
  set type(type) {
    this.set('type', type);
  }
  get allOf() {
    return this.get('allOf');
  }
  set allOf(allOf) {
    this.set('allOf', allOf);
  }
  get anyOf() {
    return this.get('anyOf');
  }
  set anyOf(anyOf) {
    this.set('anyOf', anyOf);
  }
  get oneOf() {
    return this.get('oneOf');
  }
  set oneOf(oneOf) {
    this.set('oneOf', oneOf);
  }
  get not() {
    return this.get('not');
  }
  set not(not) {
    this.set('not', not);
  }
  get definitions() {
    return this.get('definitions');
  }
  set definitions(definitions) {
    this.set('definitions', definitions);
  }

  /**
   * Metadata keywords
   *
   * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-validation-00#section-6
   */

  get title() {
    return this.get('title');
  }
  set title(title) {
    this.set('title', title);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get default() {
    return this.get('default');
  }
  set default(defaultValue) {
    this.set('default', defaultValue);
  }

  /**
   * Semantic validation with "format"
   *
   * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-validation-00#section-7
   */

  get format() {
    return this.get('format');
  }
  set format(format) {
    this.set('format', format);
  }

  /**
   * JSON Hyper-Schema
   *
   * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-hyperschema-00
   */

  get base() {
    return this.get('base');
  }
  set base(base) {
    this.set('base', base);
  }
  get links() {
    return this.get('links');
  }
  set links(links) {
    this.set('links', links);
  }
  get media() {
    return this.get('media');
  }
  set media(media) {
    this.set('media', media);
  }
  get readOnly() {
    return this.get('readOnly');
  }
  set readOnly(readOnly) {
    this.set('readOnly', readOnly);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONSchema);

/***/ }),

/***/ 82346:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

/**
 * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-hyperschema-00#section-5
 */

class LinkDescription extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'linkDescription';
  }
  get href() {
    return this.get('href');
  }
  set href(href) {
    this.set('href', href);
  }
  get rel() {
    return this.get('rel');
  }
  set rel(rel) {
    this.set('rel', rel);
  }
  get title() {
    return this.get('title');
  }
  set title(title) {
    this.set('title', title);
  }
  get targetSchema() {
    return this.get('targetSchema');
  }
  set targetSchema(targetSchema) {
    this.set('targetSchema', targetSchema);
  }
  get mediaType() {
    return this.get('mediaType');
  }
  set mediaType(mediaType) {
    this.set('mediaType', mediaType);
  }
  get method() {
    return this.get('method');
  }
  set method(method) {
    this.set('method', method);
  }
  get encType() {
    return this.get('encType');
  }
  set encType(encType) {
    this.set('encType', encType);
  }
  get schema() {
    return this.get('schema');
  }
  set schema(schema) {
    this.set('schema', schema);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkDescription);

/***/ }),

/***/ 1944:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);


/**
 * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-hyperschema-00#section-4.3
 */

class Media extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'media';
  }
  get binaryEncoding() {
    return this.get('binaryEncoding');
  }
  set binaryEncoding(binaryEncoding) {
    this.set('binaryEncoding', binaryEncoding);
  }
  get type() {
    return this.get('type');
  }
  set type(type) {
    this.set('type', type);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Media);

/***/ }),

/***/ 71195:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17659);
/* harmony import */ var _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19565);
/* harmony import */ var _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1944);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82346);




const jsonSchemaDraft4 = {
  namespace: options => {
    const {
      base
    } = options;
    base.register('jSONSchemaDraft4', _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]);
    base.register('jSONReference', _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]);
    base.register('media', _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]);
    base.register('linkDescription', _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]);
    return base;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (jsonSchemaDraft4);

/***/ }),

/***/ 71708:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isJSONReferenceElement: () => (/* binding */ isJSONReferenceElement),
/* harmony export */   isJSONSchemaElement: () => (/* binding */ isJSONSchemaElement),
/* harmony export */   isLinkDescriptionElement: () => (/* binding */ isLinkDescriptionElement),
/* harmony export */   isMediaElement: () => (/* binding */ isMediaElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67906);
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17659);
/* harmony import */ var _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19565);
/* harmony import */ var _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1944);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(82346);





const isJSONSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__["default"] || hasBasicElementProps(element) && isElementType('JSONSchemaDraft4', element) && primitiveEq('object', element);
});
const isJSONReferenceElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('JSONReference', element) && primitiveEq('object', element);
});
const isMediaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__["default"] || hasBasicElementProps(element) && isElementType('media', element) && primitiveEq('object', element);
});
const isLinkDescriptionElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_4__["default"] || hasBasicElementProps(element) && isElementType('linkDescription', element) && primitiveEq('object', element);
});

/***/ }),

/***/ 64217:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRefractor: () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(490);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(46571);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15922);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24445);
/* harmony import */ var _specification_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73278);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(5139);
/* harmony import */ var _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(3652);





const refract = (value, {
  specPath = ['visitors', 'document', 'objects', 'JSONSchema', '$visitor'],
  plugins = [],
  specificationObj = _specification_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]
} = {}) => {
  const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.refract)(value);
  const resolvedSpec = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.dereference)(specificationObj);

  /**
   * This is where generic ApiDOM becomes semantic (namespace applied).
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const RootVisitorClass = (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(specPath, resolvedSpec);
  const rootVisitor = new RootVisitorClass({
    specObj: resolvedSpec
  });
  (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.visit)(element, rootVisitor);

  /**
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.dispatchPluginsSync)(rootVisitor.element, plugins, {
    toolboxCreator: _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
    visitorOptions: {
      keyMap: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__.keyMap,
      nodeTypeGetter: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__.getNodeType
    }
  });
};
const createRefractor = specPath => (value, options = {}) => refract(value, {
  specPath,
  ...options
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 99705:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isJSONReferenceLikeElement: () => (/* binding */ isJSONReferenceLikeElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33501);

// eslint-disable-next-line import/prefer-default-export
const isJSONReferenceLikeElement = element => {
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isObjectElement)(element) && element.hasKey('$ref');
};

/***/ }),

/***/ 81600:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JSONReferenceElement: () => (/* reexport safe */ _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   JSONSchemaElement: () => (/* reexport safe */ _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   LinkDescriptionElement: () => (/* reexport safe */ _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   MediaElement: () => (/* reexport safe */ _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17659);
/* harmony import */ var _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19565);
/* harmony import */ var _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1944);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(82346);
/* harmony import */ var _index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64217);




 // register refractors specific to element types
_elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'JSONSchema', '$visitor']);
_elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_2__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'JSONReference', '$visitor']);
_elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Media', '$visitor']);
_elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_4__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'LinkDescription', '$visitor']);


/***/ }),

/***/ 73278:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _visitors_FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13107);
/* harmony import */ var _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24124);
/* harmony import */ var _visitors_json_schema_ItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56386);
/* harmony import */ var _visitors_json_schema_RequiredVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(14911);
/* harmony import */ var _visitors_json_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(51467);
/* harmony import */ var _visitors_json_schema_PatternPropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(47757);
/* harmony import */ var _visitors_json_schema_DependenciesVisitor_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(34859);
/* harmony import */ var _visitors_json_schema_EnumVisitor_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52759);
/* harmony import */ var _visitors_json_schema_TypeVisitor_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(15278);
/* harmony import */ var _visitors_json_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(78412);
/* harmony import */ var _visitors_json_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(17589);
/* harmony import */ var _visitors_json_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(49679);
/* harmony import */ var _visitors_json_schema_DefinitionsVisitor_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(58616);
/* harmony import */ var _visitors_json_schema_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(67215);
/* harmony import */ var _visitors_json_schema_json_reference_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(76543);
/* harmony import */ var _visitors_json_schema_json_reference_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(42572);
/* harmony import */ var _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(79125);
/* harmony import */ var _visitors_json_schema_media_index_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(47817);
/* harmony import */ var _visitors_json_schema_link_description_index_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(21212);



















/**
 * Specification object allows us to have complete control over visitors
 * when traversing the ApiDOM.
 * Specification also allows us to create amended refractors from
 * existing ones by manipulating it.
 *
 * Note: Specification object allows to use absolute internal JSON pointers.
 */
const specification = {
  visitors: {
    value: _visitors_FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"],
    JSONSchemaOrJSONReferenceVisitor: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
    document: {
      objects: {
        JSONSchema: {
          $visitor: _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"],
          fixedFields: {
            // core vocabulary
            id: {
              $ref: '#/visitors/value'
            },
            $schema: {
              $ref: '#/visitors/value'
            },
            // validation vocabulary
            // validation keywords for numeric instances (number and integer)
            multipleOf: {
              $ref: '#/visitors/value'
            },
            maximum: {
              $ref: '#/visitors/value'
            },
            exclusiveMaximum: {
              $ref: '#/visitors/value'
            },
            minimum: {
              $ref: '#/visitors/value'
            },
            exclusiveMinimum: {
              $ref: '#/visitors/value'
            },
            // validation keywords for strings
            maxLength: {
              $ref: '#/visitors/value'
            },
            minLength: {
              $ref: '#/visitors/value'
            },
            pattern: {
              $ref: '#/visitors/value'
            },
            // validation keywords for arrays
            additionalItems: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
            items: _visitors_json_schema_ItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"],
            maxItems: {
              $ref: '#/visitors/value'
            },
            minItems: {
              $ref: '#/visitors/value'
            },
            uniqueItems: {
              $ref: '#/visitors/value'
            },
            // validation keywords for objects
            maxProperties: {
              $ref: '#/visitors/value'
            },
            minProperties: {
              $ref: '#/visitors/value'
            },
            required: _visitors_json_schema_RequiredVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__["default"],
            properties: _visitors_json_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"],
            additionalProperties: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
            patternProperties: _visitors_json_schema_PatternPropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
            dependencies: _visitors_json_schema_DependenciesVisitor_mjs__WEBPACK_IMPORTED_MODULE_7__["default"],
            // validation keywords for any instance type
            enum: _visitors_json_schema_EnumVisitor_mjs__WEBPACK_IMPORTED_MODULE_8__["default"],
            type: _visitors_json_schema_TypeVisitor_mjs__WEBPACK_IMPORTED_MODULE_9__["default"],
            allOf: _visitors_json_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_10__["default"],
            anyOf: _visitors_json_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_11__["default"],
            oneOf: _visitors_json_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__["default"],
            not: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
            definitions: _visitors_json_schema_DefinitionsVisitor_mjs__WEBPACK_IMPORTED_MODULE_13__["default"],
            // metadata keywords
            title: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            default: {
              $ref: '#/visitors/value'
            },
            // semantic validation with "format"
            format: {
              $ref: '#/visitors/value'
            },
            // JSON Hyper-Schema
            base: {
              $ref: '#/visitors/value'
            },
            links: _visitors_json_schema_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_14__["default"],
            media: {
              $ref: '#/visitors/document/objects/Media'
            },
            readOnly: {
              $ref: '#/visitors/value'
            }
          }
        },
        JSONReference: {
          $visitor: _visitors_json_schema_json_reference_index_mjs__WEBPACK_IMPORTED_MODULE_15__["default"],
          fixedFields: {
            $ref: _visitors_json_schema_json_reference_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_16__["default"]
          }
        },
        Media: {
          $visitor: _visitors_json_schema_media_index_mjs__WEBPACK_IMPORTED_MODULE_17__["default"],
          fixedFields: {
            binaryEncoding: {
              $ref: '#/visitors/value'
            },
            type: {
              $ref: '#/visitors/value'
            }
          }
        },
        LinkDescription: {
          $visitor: _visitors_json_schema_link_description_index_mjs__WEBPACK_IMPORTED_MODULE_18__["default"],
          fixedFields: {
            href: {
              $ref: '#/visitors/value'
            },
            rel: {
              $ref: '#/visitors/value'
            },
            title: {
              $ref: '#/visitors/value'
            },
            targetSchema: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
            mediaType: {
              $ref: '#/visitors/value'
            },
            method: {
              $ref: '#/visitors/value'
            },
            encType: {
              $ref: '#/visitors/value'
            },
            schema: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]
          }
        }
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (specification);

/***/ }),

/***/ 3652:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1667);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33501);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(71708);
/* harmony import */ var _namespace_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71195);



const createToolbox = () => {
  const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.createNamespace)(_namespace_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]);
  const predicates = {
    ..._predicates_mjs__WEBPACK_IMPORTED_MODULE_2__,
    isStringElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement
  };
  return {
    predicates,
    namespace
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createToolbox);

/***/ }),

/***/ 13107:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(68618);
/* harmony import */ var _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20401);


/**
 * This visitor is responsible for falling back to current traversed element
 * Given JSONSchemaVisitor expects ObjectElement to be traversed. If
 * different Element is provided FallBackVisitor is responsible to assigning
 * this Element as current element.
 */
class FallbackVisitor extends _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  enter(element) {
    this.element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FallbackVisitor);

/***/ }),

/***/ 94330:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18499);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24445);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67924);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34610);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(46571);
/* harmony import */ var _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20401);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13107);





/**
 * This is a base Type for every visitor that does
 * internal look-ups to retrieve other child visitors.
 */
class SpecificationVisitor extends _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  specObj;
  passingOptionsNames = ['specObj'];
  constructor({
    specObj,
    ...rest
  }) {
    super({
      ...rest
    });
    this.specObj = specObj;
  }
  retrievePassingOptions() {
    return (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(this.passingOptionsNames, this);
  }
  retrieveFixedFields(specPath) {
    const fixedFields = (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['visitors', ...specPath, 'fixedFields'], this.specObj);
    if (typeof fixedFields === 'object' && fixedFields !== null) {
      return Object.keys(fixedFields);
    }
    return [];
  }
  retrieveVisitor(specPath) {
    if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"], ['visitors', ...specPath], this.specObj)) {
      return (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['visitors', ...specPath], this.specObj);
    }
    return (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['visitors', ...specPath, '$visitor'], this.specObj);
  }
  retrieveVisitorInstance(specPath, options = {}) {
    const passingOpts = this.retrievePassingOptions();
    const VisitorClz = this.retrieveVisitor(specPath);
    const visitorOpts = {
      ...passingOpts,
      ...options
    };
    return new VisitorClz(visitorOpts);
  }
  toRefractedElement(specPath, element, options = {}) {
    /**
     * This is `Visitor shortcut`: mechanism for short circuiting the traversal and replacing
     * it by basic node cloning.
     *
     * Visiting the element is equivalent to cloning it  if the prototype of a visitor
     * is the same as the prototype of FallbackVisitor. If that's the case, we can avoid
     * bootstrapping the traversal cycle for fields that don't require any special visiting.
     */
    const visitor = this.retrieveVisitorInstance(specPath, options);
    if (visitor instanceof _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"] && (visitor === null || visitor === void 0 ? void 0 : visitor.constructor) === _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]) {
      return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.cloneDeep)(element);
    }
    (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__.visit)(element, visitor, options);
    return visitor.element;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SpecificationVisitor);

/***/ }),

/***/ 20401:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(15461);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33501);

class Visitor {
  element;
  constructor(options) {
    Object.assign(this, options);
  }

  // eslint-disable-next-line class-methods-use-this
  copyMetaAndAttributes(from, to) {
    if (from.meta.length > 0 || to.meta.length > 0) {
      // eslint-disable-next-line no-param-reassign
      to.meta = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(to.meta, from.meta);
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.hasElementSourceMap)(from)) {
        // avoid deep merging of source maps
        to.meta.set('sourceMap', from.meta.get('sourceMap'));
      }
    }
    if (from.attributes.length > 0 || from.meta.length > 0) {
      // eslint-disable-next-line no-param-reassign
      to.attributes = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(to.attributes, from.attributes);
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Visitor);

/***/ }),

/***/ 77081:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8564);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26183);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21504);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(89360);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94330);




class AlternatingVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  alternator;
  constructor({
    alternator,
    ...rest
  }) {
    super({
      ...rest
    });
    this.alternator = alternator;
  }
  enter(element) {
    const functions = this.alternator.map(({
      predicate,
      specPath
    }) => (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(predicate, (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(specPath), ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"]));
    const specPath = (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(functions)(element);
    this.element = this.toRefractedElement(specPath, element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AlternatingVisitor);

/***/ }),

/***/ 6211:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9999);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94330);


class FixedFieldsVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  specPath;
  ignoredFields;
  constructor({
    specPath,
    ignoredFields,
    ...rest
  }) {
    super({
      ...rest
    });
    this.specPath = specPath;
    this.ignoredFields = ignoredFields || [];
  }
  ObjectElement(objectElement) {
    const specPath = this.specPath(objectElement);
    const fields = this.retrieveFixedFields(specPath);

    // @ts-ignore
    objectElement.forEach((value, key, memberElement) => {
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isStringElement)(key) && fields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key)) && !this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key))) {
        const fixedFieldElement = this.toRefractedElement([...specPath, 'fixedFields', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key)], value);
        const newMemberElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.MemberElement((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.cloneDeep)(key), fixedFieldElement);
        this.copyMetaAndAttributes(memberElement, newMemberElement);
        newMemberElement.classes.push('fixed-field');
        this.element.content.push(newMemberElement);
      } else if (!this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key))) {
        this.element.content.push((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.cloneDeep)(memberElement));
      }
    });
    this.copyMetaAndAttributes(objectElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FixedFieldsVisitor);

/***/ }),

/***/ 59130:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46455);
/* harmony import */ var _PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(18734);


class MapVisitor extends _PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.fieldPatternPredicate = ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"];
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MapVisitor);

/***/ }),

/***/ 18734:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3182);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9999);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94330);



class PatternedFieldsVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  specPath;
  ignoredFields;
  fieldPatternPredicate = ramda__WEBPACK_IMPORTED_MODULE_1__["default"];
  constructor({
    specPath,
    ignoredFields,
    fieldPatternPredicate,
    ...rest
  }) {
    super({
      ...rest
    });
    this.specPath = specPath;
    this.ignoredFields = ignoredFields || [];
    if (typeof fieldPatternPredicate === 'function') {
      this.fieldPatternPredicate = fieldPatternPredicate;
    }
  }
  ObjectElement(objectElement) {
    // @ts-ignore
    objectElement.forEach((value, key, memberElement) => {
      if (!this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key)) && this.fieldPatternPredicate((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key))) {
        const specPath = this.specPath(value);
        const patternedFieldElement = this.toRefractedElement(specPath, value);
        const newMemberElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.MemberElement((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.cloneDeep)(key), patternedFieldElement);
        this.copyMetaAndAttributes(memberElement, newMemberElement);
        newMemberElement.classes.push('patterned-field');
        this.element.content.push(newMemberElement);
      } else if (!this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key))) {
        this.element.content.push((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.cloneDeep)(memberElement));
      }
    });
    this.copyMetaAndAttributes(objectElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternedFieldsVisitor);

/***/ }),

/***/ 78412:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(68618);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13107);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94330);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87297);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99705);






class AllOfVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-allOf');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(item) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AllOfVisitor);

/***/ }),

/***/ 17589:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(68618);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13107);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94330);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87297);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99705);






class AnyOfVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-anyOf');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(item) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AnyOfVisitor);

/***/ }),

/***/ 58616:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44824);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13107);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59130);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87297);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99705);






class DefinitionsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ObjectElement();
    this.element.classes.push('json-schema-definitions');
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(element) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DefinitionsVisitor);

/***/ }),

/***/ 34859:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44824);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59130);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13107);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87297);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99705);






class DependenciesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ObjectElement();
    this.element.classes.push('json-schema-dependencies');
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(element) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DependenciesVisitor);

/***/ }),

/***/ 52759:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13107);

class EnumVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  ArrayElement(arrayElement) {
    const result = this.enter(arrayElement);
    this.element.classes.push('json-schema-enum');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EnumVisitor);

/***/ }),

/***/ 56386:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(44824);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94330);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13107);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87297);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(99705);






class ItemsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  ObjectElement(objectElement) {
    const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isJSONReferenceLikeElement)(objectElement) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
    this.element = this.toRefractedElement(specPath, objectElement);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
  ArrayElement(arrayElement) {
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.ArrayElement();
    this.element.classes.push('json-schema-items');
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isJSONReferenceLikeElement)(item) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ItemsVisitor);

/***/ }),

/***/ 79125:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11892);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99705);
/* harmony import */ var _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77081);



class SchemaOrReferenceVisitor extends _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.alternator = [{
      predicate: _predicates_mjs__WEBPACK_IMPORTED_MODULE_1__.isJSONReferenceLikeElement,
      specPath: ['document', 'objects', 'JSONReference']
    }, {
      predicate: ramda__WEBPACK_IMPORTED_MODULE_2__["default"],
      specPath: ['document', 'objects', 'JSONSchema']
    }];
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaOrReferenceVisitor);

/***/ }),

/***/ 67215:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13107);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94330);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87297);





class LinksVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-links');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const linkDescriptionElement = this.toRefractedElement(['document', 'objects', 'LinkDescription'], item);
      this.element.push(linkDescriptionElement);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinksVisitor);

/***/ }),

/***/ 49679:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(68618);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13107);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(94330);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87297);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99705);






class OneOfVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-oneOf');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(item) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OneOfVisitor);

/***/ }),

/***/ 87297:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
class ParentSchemaAwareVisitor {
  parent;
  constructor({
    parent
  }) {
    this.parent = parent;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParentSchemaAwareVisitor);

/***/ }),

/***/ 47757:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44824);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13107);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59130);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87297);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99705);






class PatternPropertiesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ObjectElement();
    this.element.classes.push('json-schema-patternProperties');
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(element) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternPropertiesVisitor);

/***/ }),

/***/ 51467:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(44824);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13107);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(59130);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87297);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99705);






class PropertiesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ObjectElement();
    this.element.classes.push('json-schema-properties');
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(element) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PropertiesVisitor);

/***/ }),

/***/ 14911:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13107);

class RequiredVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  ArrayElement(arrayElement) {
    const result = this.enter(arrayElement);
    this.element.classes.push('json-schema-required');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequiredVisitor);

/***/ }),

/***/ 15278:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13107);

class TypeVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = this.enter(stringElement);
    this.element.classes.push('json-schema-type');
    return result;
  }
  ArrayElement(arrayElement) {
    const result = this.enter(arrayElement);
    this.element.classes.push('json-schema-type');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TypeVisitor);

/***/ }),

/***/ 24124:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6211);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13107);
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(17659);





class JSONSchemaVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'JSONSchema']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONSchemaVisitor);

/***/ }),

/***/ 42572:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13107);

class $RefVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = this.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($RefVisitor);

/***/ }),

/***/ 76543:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33501);
/* harmony import */ var _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19565);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6211);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13107);






class JSONReferenceVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'JSONReference']);
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // mark this JSONReferenceElement with reference metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(this.element.$ref)) {
      this.element.classes.push('reference-element');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONReferenceVisitor);

/***/ }),

/***/ 21212:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82346);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6211);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13107);





class LinkDescriptionVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'LinkDescription']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkDescriptionVisitor);

/***/ }),

/***/ 47817:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1944);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6211);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13107);





class MediaVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Media']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaVisitor);

/***/ }),

/***/ 5139:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getNodeType: () => (/* binding */ getNodeType),
/* harmony export */   keyMap: () => (/* binding */ keyMap)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46571);


// getNodeType :: Node -> String
const getNodeType = element => {
  if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isElement)(element)) {
    return undefined;
  }
  return `${element.element.charAt(0).toUpperCase() + element.element.slice(1)}Element`;
};
const keyMap = {
  JSONSchemaDraft4Element: ['content'],
  JSONReferenceElement: ['content'],
  MediaElement: ['content'],
  LinkDescriptionElement: ['content'],
  ..._swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.keyMapDefault
};

/***/ }),

/***/ 8725:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Callback extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'callback';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Callback);

/***/ }),

/***/ 27912:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Components extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'components';
  }
  get schemas() {
    return this.get('schemas');
  }
  set schemas(schemas) {
    this.set('schemas', schemas);
  }
  get responses() {
    return this.get('responses');
  }
  set responses(responses) {
    this.set('responses', responses);
  }
  get parameters() {
    return this.get('parameters');
  }
  set parameters(parameters) {
    this.set('parameters', parameters);
  }
  get examples() {
    return this.get('examples');
  }
  set examples(examples) {
    this.set('examples', examples);
  }
  get requestBodies() {
    return this.get('requestBodies');
  }
  set requestBodies(requestBodies) {
    this.set('requestBodies', requestBodies);
  }
  get headers() {
    return this.get('headers');
  }
  set headers(headers) {
    this.set('headers', headers);
  }
  get securitySchemes() {
    return this.get('securitySchemes');
  }
  set securitySchemes(securitySchemes) {
    this.set('securitySchemes', securitySchemes);
  }
  get links() {
    return this.get('links');
  }
  set links(links) {
    this.set('links', links);
  }
  get callbacks() {
    return this.get('callbacks');
  }
  set callbacks(callbacks) {
    this.set('callbacks', callbacks);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Components);

/***/ }),

/***/ 43172:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Contact extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'contact';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get url() {
    return this.get('url');
  }
  set url(url) {
    this.set('url', url);
  }
  get email() {
    return this.get('email');
  }
  set email(email) {
    this.set('email', email);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Contact);

/***/ }),

/***/ 8652:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Discriminator extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'discriminator';
  }
  get propertyName() {
    return this.get('propertyName');
  }
  set propertyName(propertyName) {
    this.set('propertyName', propertyName);
  }
  get mapping() {
    return this.get('mapping');
  }
  set mapping(mapping) {
    this.set('mapping', mapping);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Discriminator);

/***/ }),

/***/ 91915:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Encoding extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'encoding';
  }
  get contentType() {
    return this.get('contentType');
  }
  set contentType(contentType) {
    this.set('contentType', contentType);
  }
  get headers() {
    return this.get('headers');
  }
  set headers(headers) {
    this.set('headers', headers);
  }
  get style() {
    return this.get('style');
  }
  set style(style) {
    this.set('style', style);
  }
  get explode() {
    return this.get('explode');
  }
  set explode(explode) {
    this.set('explode', explode);
  }
  get allowedReserved() {
    return this.get('allowedReserved');
  }
  set allowedReserved(allowedReserved) {
    this.set('allowedReserved', allowedReserved);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Encoding);

/***/ }),

/***/ 3758:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Example extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'example';
  }
  get summary() {
    return this.get('summary');
  }
  set summary(summary) {
    this.set('summary', summary);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get value() {
    return this.get('value');
  }
  set value(value) {
    this.set('value', value);
  }
  get externalValue() {
    return this.get('externalValue');
  }
  set externalValue(externalValue) {
    this.set('externalValue', externalValue);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Example);

/***/ }),

/***/ 49837:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ExternalDocumentation extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'externalDocumentation';
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get url() {
    return this.get('url');
  }
  set url(url) {
    this.set('url', url);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExternalDocumentation);

/***/ }),

/***/ 19403:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Header extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'header';
  }
  get required() {
    if (this.hasKey('required')) {
      return this.get('required');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set required(required) {
    this.set('required', required);
  }
  get deprecated() {
    if (this.hasKey('deprecated')) {
      return this.get('deprecated');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set deprecated(deprecated) {
    this.set('deprecated', deprecated);
  }
  get allowEmptyValue() {
    return this.get('allowEmptyValue');
  }
  set allowEmptyValue(allowEmptyValue) {
    this.set('allowEmptyValue', allowEmptyValue);
  }
  get style() {
    return this.get('style');
  }
  set style(style) {
    this.set('style', style);
  }
  get explode() {
    return this.get('explode');
  }
  set explode(explode) {
    this.set('explode', explode);
  }
  get allowReserved() {
    return this.get('allowReserved');
  }
  set allowReserved(allowReserved) {
    this.set('allowReserved', allowReserved);
  }
  get schema() {
    return this.get('schema');
  }
  set schema(schema) {
    this.set('schema', schema);
  }
  get example() {
    return this.get('example');
  }
  set example(example) {
    this.set('example', example);
  }
  get examples() {
    return this.get('examples');
  }
  set examples(examples) {
    this.set('examples', examples);
  }
  get contentProp() {
    return this.get('content');
  }
  set contentProp(content) {
    this.set('content', content);
  }
}
Object.defineProperty(Header.prototype, 'description', {
  get() {
    return this.get('description');
  },
  set(description) {
    this.set('description', description);
  },
  enumerable: true
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ 14036:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Info extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'info';
    this.classes.push('info');
  }
  get title() {
    return this.get('title');
  }
  set title(title) {
    this.set('title', title);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get termsOfService() {
    return this.get('termsOfService');
  }
  set termsOfService(tos) {
    this.set('termsOfService', tos);
  }
  get contact() {
    return this.get('contact');
  }
  set contact(contactElement) {
    this.set('contact', contactElement);
  }
  get license() {
    return this.get('license');
  }
  set license(licenseElement) {
    this.set('license', licenseElement);
  }
  get version() {
    return this.get('version');
  }
  set version(version) {
    this.set('version', version);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Info);

/***/ }),

/***/ 98149:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class License extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'license';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get url() {
    return this.get('url');
  }
  set url(url) {
    this.set('url', url);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (License);

/***/ }),

/***/ 71020:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33501);

class Link extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'link';
  }
  get operationRef() {
    return this.get('operationRef');
  }
  set operationRef(operationRef) {
    this.set('operationRef', operationRef);
  }
  get operationId() {
    return this.get('operationId');
  }
  set operationId(operationId) {
    this.set('operationId', operationId);
  }
  get operation() {
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isStringElement)(this.operationRef)) {
      var _this$operationRef;
      return (_this$operationRef = this.operationRef) === null || _this$operationRef === void 0 ? void 0 : _this$operationRef.meta.get('operation');
    }
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.isStringElement)(this.operationId)) {
      var _this$operationId;
      return (_this$operationId = this.operationId) === null || _this$operationId === void 0 ? void 0 : _this$operationId.meta.get('operation');
    }
    return undefined;
  }
  set operation(operation) {
    this.set('operation', operation);
  }
  get parameters() {
    return this.get('parameters');
  }
  set parameters(parameters) {
    this.set('parameters', parameters);
  }
  get requestBody() {
    return this.get('requestBody');
  }
  set requestBody(requestBody) {
    this.set('requestBody', requestBody);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get server() {
    return this.get('server');
  }
  set server(server) {
    this.set('server', server);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ 22452:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class MediaType extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'mediaType';
  }
  get schema() {
    return this.get('schema');
  }
  set schema(schema) {
    this.set('schema', schema);
  }
  get example() {
    return this.get('example');
  }
  set example(example) {
    this.set('example', example);
  }
  get examples() {
    return this.get('examples');
  }
  set examples(examples) {
    this.set('examples', examples);
  }
  get encoding() {
    return this.get('encoding');
  }
  set encoding(encoding) {
    this.set('encoding', encoding);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaType);

/***/ }),

/***/ 10409:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class OAuthFlow extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'oAuthFlow';
  }
  get authorizationUrl() {
    return this.get('authorizationUrl');
  }
  set authorizationUrl(authorizationUrl) {
    this.set('authorizationUrl', authorizationUrl);
  }
  get tokenUrl() {
    return this.get('tokenUrl');
  }
  set tokenUrl(tokenUrl) {
    this.set('tokenUrl', tokenUrl);
  }
  get refreshUrl() {
    return this.get('refreshUrl');
  }
  set refreshUrl(refreshUrl) {
    this.set('refreshUrl', refreshUrl);
  }
  get scopes() {
    return this.get('scopes');
  }
  set scopes(scopes) {
    this.set('scopes', scopes);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlow);

/***/ }),

/***/ 53608:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class OAuthFlows extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'oAuthFlows';
  }
  get implicit() {
    return this.get('implicit');
  }
  set implicit(implicit) {
    this.set('implicit', implicit);
  }
  get password() {
    return this.get('password');
  }
  set password(password) {
    this.set('password', password);
  }
  get clientCredentials() {
    return this.get('clientCredentials');
  }
  set clientCredentials(clientCredentials) {
    this.set('clientCredentials', clientCredentials);
  }
  get authorizationCode() {
    return this.get('authorizationCode');
  }
  set authorizationCode(authorizationCode) {
    this.set('authorizationCode', authorizationCode);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlows);

/***/ }),

/***/ 54764:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

// eslint-disable-next-line @typescript-eslint/naming-convention
class OpenApi3_0 extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'openApi3_0';
    this.classes.push('api');
  }
  get openapi() {
    return this.get('openapi');
  }
  set openapi(openapi) {
    this.set('openapi', openapi);
  }
  get info() {
    return this.get('info');
  }
  set info(info) {
    this.set('info', info);
  }
  get servers() {
    return this.get('servers');
  }
  set servers(servers) {
    this.set('servers', servers);
  }
  get paths() {
    return this.get('paths');
  }
  set paths(paths) {
    this.set('paths', paths);
  }
  get components() {
    return this.get('components');
  }
  set components(components) {
    this.set('components', components);
  }
  get security() {
    return this.get('security');
  }
  set security(security) {
    this.set('security', security);
  }
  get tags() {
    return this.get('tags');
  }
  set tags(tags) {
    this.set('tags', tags);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenApi3_0);

/***/ }),

/***/ 71640:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Openapi extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.StringElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'openapi';
    this.classes.push('spec-version');
    this.classes.push('version');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Openapi);

/***/ }),

/***/ 5431:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Operation extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'operation';
  }
  get tags() {
    return this.get('tags');
  }
  set tags(tags) {
    this.set('tags', tags);
  }
  get summary() {
    return this.get('summary');
  }
  set summary(description) {
    this.set('summary', description);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  get operationId() {
    return this.get('operationId');
  }
  set operationId(operationId) {
    this.set('operationId', operationId);
  }
  get parameters() {
    return this.get('parameters');
  }
  set parameters(parameters) {
    this.set('parameters', parameters);
  }
  get requestBody() {
    return this.get('requestBody');
  }
  set requestBody(requestBody) {
    this.set('requestBody', requestBody);
  }
  get responses() {
    return this.get('responses');
  }
  set responses(responses) {
    this.set('responses', responses);
  }
  get callbacks() {
    return this.get('callbacks');
  }
  set callbacks(callbacks) {
    this.set('callbacks', callbacks);
  }
  get deprecated() {
    if (this.hasKey('deprecated')) {
      return this.get('deprecated');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set deprecated(deprecated) {
    this.set('deprecated', deprecated);
  }
  get security() {
    return this.get('security');
  }
  set security(security) {
    this.set('security', security);
  }
  get servers() {
    return this.get('severs');
  }
  set servers(servers) {
    this.set('servers', servers);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Operation);

/***/ }),

/***/ 37357:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Parameter extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'parameter';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get in() {
    return this.get('in');
  }
  set in(val) {
    this.set('in', val);
  }
  get required() {
    if (this.hasKey('required')) {
      return this.get('required');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set required(required) {
    this.set('required', required);
  }
  get deprecated() {
    if (this.hasKey('deprecated')) {
      return this.get('deprecated');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set deprecated(deprecated) {
    this.set('deprecated', deprecated);
  }
  get allowEmptyValue() {
    return this.get('allowEmptyValue');
  }
  set allowEmptyValue(allowEmptyValue) {
    this.set('allowEmptyValue', allowEmptyValue);
  }
  get style() {
    return this.get('style');
  }
  set style(style) {
    this.set('style', style);
  }
  get explode() {
    return this.get('explode');
  }
  set explode(explode) {
    this.set('explode', explode);
  }
  get allowReserved() {
    return this.get('allowReserved');
  }
  set allowReserved(allowReserved) {
    this.set('allowReserved', allowReserved);
  }
  get schema() {
    return this.get('schema');
  }
  set schema(schema) {
    this.set('schema', schema);
  }
  get example() {
    return this.get('example');
  }
  set example(example) {
    this.set('example', example);
  }
  get examples() {
    return this.get('examples');
  }
  set examples(examples) {
    this.set('examples', examples);
  }
  get contentProp() {
    return this.get('content');
  }
  set contentProp(content) {
    this.set('content', content);
  }
}
Object.defineProperty(Parameter.prototype, 'description', {
  get() {
    return this.get('description');
  },
  set(description) {
    this.set('description', description);
  },
  enumerable: true
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Parameter);

/***/ }),

/***/ 41740:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class PathItem extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'pathItem';
  }
  get $ref() {
    return this.get('$ref');
  }
  set $ref($ref) {
    this.set('$ref', $ref);
  }
  get summary() {
    return this.get('summary');
  }
  set summary(summary) {
    this.set('summary', summary);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get GET() {
    return this.get('get');
  }
  set GET(operation) {
    this.set('GET', operation);
  }
  get PUT() {
    return this.get('put');
  }
  set PUT(operation) {
    this.set('PUT', operation);
  }
  get POST() {
    return this.get('post');
  }
  set POST(operation) {
    this.set('POST', operation);
  }
  get DELETE() {
    return this.get('delete');
  }
  set DELETE(operation) {
    this.set('DELETE', operation);
  }
  get OPTIONS() {
    return this.get('options');
  }
  set OPTIONS(operation) {
    this.set('OPTIONS', operation);
  }
  get HEAD() {
    return this.get('head');
  }
  set HEAD(operation) {
    this.set('HEAD', operation);
  }
  get PATCH() {
    return this.get('patch');
  }
  set PATCH(operation) {
    this.set('PATCH', operation);
  }
  get TRACE() {
    return this.get('trace');
  }
  set TRACE(operation) {
    this.set('TRACE', operation);
  }
  get servers() {
    return this.get('servers');
  }
  set servers(servers) {
    this.set('servers', servers);
  }
  get parameters() {
    return this.get('parameters');
  }
  set parameters(parameters) {
    this.set('parameters', parameters);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathItem);

/***/ }),

/***/ 12832:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Paths extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'paths';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Paths);

/***/ }),

/***/ 27695:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Reference extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'reference';
    this.classes.push('openapi-reference');
  }
  get $ref() {
    return this.get('$ref');
  }
  set $ref($ref) {
    this.set('$ref', $ref);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Reference);

/***/ }),

/***/ 88767:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class RequestBody extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'requestBody';
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get contentProp() {
    return this.get('content');
  }
  set contentProp(content) {
    this.set('content', content);
  }
  get required() {
    if (this.hasKey('required')) {
      return this.get('required');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set required(required) {
    this.set('required', required);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBody);

/***/ }),

/***/ 18485:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Response extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'response';
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get headers() {
    return this.get('headers');
  }
  set headers(headers) {
    this.set('headers', headers);
  }
  get contentProp() {
    return this.get('content');
  }
  set contentProp(contentProp) {
    this.set('content', contentProp);
  }
  get links() {
    return this.get('links');
  }
  set links(links) {
    this.set('links', links);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Response);

/***/ }),

/***/ 62604:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Responses extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'responses';
  }
  get default() {
    return this.get('default');
  }
  set default(defaultValue) {
    this.set('default', defaultValue);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Responses);

/***/ }),

/***/ 19117:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9475);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81600);


/* eslint-disable class-methods-use-this */
class Schema extends _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__.JSONSchemaElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'schema';
    this.classes.push('json-schema-draft-4');
  }

  /**
   * Core vocabulary
   *
   * URI: https://tools.ietf.org/html/draft-wright-json-schema-00
   */
  get idProp() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('idProp getter in Schema class is not not supported.');
  }
  set idProp(idProps) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('idProp setter in Schema class is not not supported.');
  }
  get $schema() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('$schema getter in Schema class is not not supported.');
  }
  set $schema($schema) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('$schema setter in Schema class is not not supported.');
  }

  /**
   * Validation keywords for arrays
   */

  get additionalItems() {
    return this.get('additionalItems');
  }
  set additionalItems(additionalItems) {
    this.set('additionalItems', additionalItems);
  }
  get items() {
    return this.get('items');
  }
  set items(items) {
    this.set('items', items);
  }

  /**
   * Validation keywords for objects
   */

  get additionalProperties() {
    return this.get('additionalProperties');
  }
  set additionalProperties(additionalProperties) {
    this.set('additionalProperties', additionalProperties);
  }
  get patternProperties() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('patternProperties getter in Schema class is not not supported.');
  }
  set patternProperties(patternProperties) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('patternProperties setter in Schema class is not not supported.');
  }
  get dependencies() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('dependencies getter in Schema class is not not supported.');
  }
  set dependencies(dependencies) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('dependencies setter in Schema class is not not supported.');
  }

  /**
   *  Validation keywords for any instance type
   */

  get type() {
    return this.get('type');
  }
  set type(type) {
    this.set('type', type);
  }
  get not() {
    return this.get('not');
  }
  set not(not) {
    this.set('not', not);
  }
  get definitions() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('definitions getter in Schema class is not not supported.');
  }
  set definitions(definitions) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('definitions setter in Schema class is not not supported.');
  }

  /**
   * JSON Hyper-Schema
   *
   * URI: https://datatracker.ietf.org/doc/html/draft-wright-json-schema-hyperschema-00
   */

  get base() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('base getter in Schema class is not not supported.');
  }
  set base(base) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('base setter in Schema class is not not supported.');
  }
  get links() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('links getter in Schema class is not not supported.');
  }
  set links(links) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('links setter in Schema class is not not supported.');
  }
  get media() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('media getter in Schema class is not not supported.');
  }
  set media(media) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('media setter in Schema class is not not supported.');
  }

  /**
   * OpenAPI vocabulary
   */

  get nullable() {
    return this.get('nullable');
  }
  set nullable(nullable) {
    this.set('nullable', nullable);
  }
  get discriminator() {
    return this.get('discriminator');
  }
  set discriminator(discriminator) {
    this.set('discriminator', discriminator);
  }
  get writeOnly() {
    return this.get('writeOnly');
  }
  set writeOnly(writeOnly) {
    this.set('writeOnly', writeOnly);
  }
  get xml() {
    return this.get('xml');
  }
  set xml(xml) {
    this.set('xml', xml);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
  get example() {
    return this.get('example');
  }
  set example(example) {
    this.set('example', example);
  }
  get deprecated() {
    return this.get('deprecated');
  }
  set deprecated(deprecated) {
    this.set('deprecated', deprecated);
  }
}
/* eslint-disable class-methods-use-this */

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Schema);

/***/ }),

/***/ 94063:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class SecurityRequirement extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'securityRequirement';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecurityRequirement);

/***/ }),

/***/ 89779:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class SecurityScheme extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'securityScheme';
  }
  get type() {
    return this.get('type');
  }
  set type(type) {
    this.set('type', type);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get in() {
    return this.get('in');
  }
  set in(inVal) {
    this.set('in', inVal);
  }
  get scheme() {
    return this.get('scheme');
  }
  set scheme(scheme) {
    this.set('scheme', scheme);
  }
  get bearerFormat() {
    return this.get('bearerFormat');
  }
  set bearerFormat(bearerFormat) {
    this.set('bearerFormat', bearerFormat);
  }
  get flows() {
    return this.get('flows');
  }
  set flows(flows) {
    this.set('flows', flows);
  }
  get openIdConnectUrl() {
    return this.get('openIdConnectUrl');
  }
  set openIdConnectUrl(openIdConnectUrl) {
    this.set('openIdConnectUrl', openIdConnectUrl);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecurityScheme);

/***/ }),

/***/ 2829:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Server extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'server';
  }
  get url() {
    return this.get('url');
  }
  set url(url) {
    this.set('url', url);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get variables() {
    return this.get('variables');
  }
  set variables(variables) {
    this.set('variables', variables);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Server);

/***/ }),

/***/ 44213:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ServerVariable extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'serverVariable';
  }
  get enum() {
    return this.get('enum');
  }
  set enum(value) {
    this.set('enum', value);
  }
  get default() {
    return this.get('default');
  }
  set default(value) {
    this.set('default', value);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServerVariable);

/***/ }),

/***/ 79700:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Tag extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'tag';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tag);

/***/ }),

/***/ 70935:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Xml extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'xml';
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get namespace() {
    return this.get('namespace');
  }
  set namespace(namespace) {
    this.set('namespace', namespace);
  }
  get prefix() {
    return this.get('prefix');
  }
  set prefix(prefix) {
    this.set('prefix', prefix);
  }
  get attribute() {
    return this.get('attribute');
  }
  set attribute(attribute) {
    this.set('attribute', attribute);
  }
  get wrapped() {
    return this.get('wrapped');
  }
  set wrapped(wrapped) {
    this.set('wrapped', wrapped);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Xml);

/***/ }),

/***/ 53320:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ComponentsCallbacks extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-callbacks';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsCallbacks.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsCallbacks);

/***/ }),

/***/ 38065:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ComponentsExamples extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-examples';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsExamples.primaryClass);
    this.classes.push('examples');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsExamples);

/***/ }),

/***/ 98798:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ComponentsHeaders extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-headers';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsHeaders.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsHeaders);

/***/ }),

/***/ 82247:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ComponentsLinks extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-links';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsLinks.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsLinks);

/***/ }),

/***/ 66488:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ComponentsParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-parameters';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsParameters.primaryClass);
    this.classes.push('parameters');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsParameters);

/***/ }),

/***/ 16947:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ComponentsRequestBodies extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-request-bodies';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsRequestBodies.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsRequestBodies);

/***/ }),

/***/ 23128:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ComponentsResponses extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-responses';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsResponses.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsResponses);

/***/ }),

/***/ 6144:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ComponentsSchemas extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-schemas';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsSchemas.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsSchemas);

/***/ }),

/***/ 16830:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ComponentsSecuritySchemes extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-security-schemes';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsSecuritySchemes.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsSecuritySchemes);

/***/ }),

/***/ 87718:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class DiscriminatorMapping extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'discriminator-mapping';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(DiscriminatorMapping.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscriminatorMapping);

/***/ }),

/***/ 41499:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class EncodingHeaders extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'encoding-headers';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(EncodingHeaders.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EncodingHeaders);

/***/ }),

/***/ 10486:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class HeaderContent extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'header-content';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(HeaderContent.primaryClass);
    this.classes.push('content');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderContent);

/***/ }),

/***/ 90082:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class HeaderExamples extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'header-examples';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(HeaderExamples.primaryClass);
    this.classes.push('examples');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderExamples);

/***/ }),

/***/ 62732:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class LinkParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'link-parameters';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(LinkParameters.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkParameters);

/***/ }),

/***/ 88123:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class MediaTypeEncoding extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'media-type-encoding';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(MediaTypeEncoding.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTypeEncoding);

/***/ }),

/***/ 6189:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class MediaTypeExamples extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'media-type-examples';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(MediaTypeExamples.primaryClass);
    this.classes.push('examples');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTypeExamples);

/***/ }),

/***/ 48766:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class OAuthFlowScopes extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'oauth-flow-scopes';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OAuthFlowScopes.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlowScopes);

/***/ }),

/***/ 60025:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class OperationCallbacks extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'operation-callbacks';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationCallbacks.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationCallbacks);

/***/ }),

/***/ 58335:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class OperationParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'operation-parameters';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationParameters.primaryClass);
    this.classes.push('parameters');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationParameters);

/***/ }),

/***/ 20673:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class OperationSecurity extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'operation-security';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationSecurity.primaryClass);
    this.classes.push('security');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationSecurity);

/***/ }),

/***/ 84253:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class OperationServers extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'operation-servers';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationServers.primaryClass);
    this.classes.push('servers');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationServers);

/***/ }),

/***/ 4236:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class OperationTags extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'operation-tags';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationTags.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationTags);

/***/ }),

/***/ 41540:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ParameterContent extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'parameter-content';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ParameterContent.primaryClass);
    this.classes.push('content');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParameterContent);

/***/ }),

/***/ 48792:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ParameterExamples extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'parameter-examples';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ParameterExamples.primaryClass);
    this.classes.push('examples');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParameterExamples);

/***/ }),

/***/ 49932:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class PathItemParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'path-item-parameters';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(PathItemParameters.primaryClass);
    this.classes.push('parameters');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathItemParameters);

/***/ }),

/***/ 60748:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class PathItemServers extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'path-item-servers';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(PathItemServers.primaryClass);
    this.classes.push('servers');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathItemServers);

/***/ }),

/***/ 80978:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class RequestBodyContent extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'request-body-content';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(RequestBodyContent.primaryClass);
    this.classes.push('content');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBodyContent);

/***/ }),

/***/ 98540:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ResponseContent extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'response-content';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ResponseContent.primaryClass);
    this.classes.push('content');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResponseContent);

/***/ }),

/***/ 20065:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ResponseHeaders extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'response-headers';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ResponseHeaders.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResponseHeaders);

/***/ }),

/***/ 45648:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ResponseLinks extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'response-links';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ResponseLinks.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResponseLinks);

/***/ }),

/***/ 42894:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Security extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'security';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(Security.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Security);

/***/ }),

/***/ 99324:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class ServerVariables extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'server-variables';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ServerVariables.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServerVariables);

/***/ }),

/***/ 87204:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Servers extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'servers';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(Servers.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Servers);

/***/ }),

/***/ 92579:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(44824);

class Tags extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'tags';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(Tags.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Tags);

/***/ }),

/***/ 31015:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8725);
/* harmony import */ var _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27912);
/* harmony import */ var _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(43172);
/* harmony import */ var _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8652);
/* harmony import */ var _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(91915);
/* harmony import */ var _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3758);
/* harmony import */ var _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49837);
/* harmony import */ var _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(19403);
/* harmony import */ var _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(14036);
/* harmony import */ var _elements_License_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(98149);
/* harmony import */ var _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71020);
/* harmony import */ var _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(22452);
/* harmony import */ var _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(10409);
/* harmony import */ var _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(53608);
/* harmony import */ var _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(71640);
/* harmony import */ var _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(54764);
/* harmony import */ var _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(5431);
/* harmony import */ var _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(37357);
/* harmony import */ var _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(41740);
/* harmony import */ var _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(12832);
/* harmony import */ var _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(27695);
/* harmony import */ var _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(88767);
/* harmony import */ var _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(18485);
/* harmony import */ var _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(62604);
/* harmony import */ var _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(19117);
/* harmony import */ var _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(94063);
/* harmony import */ var _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(89779);
/* harmony import */ var _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(2829);
/* harmony import */ var _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(44213);
/* harmony import */ var _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(79700);
/* harmony import */ var _elements_Xml_mjs__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(70935);






























 // eslint-disable-next-line @typescript-eslint/naming-convention
const openApi3_0 = {
  namespace: options => {
    const {
      base
    } = options;
    base.register('callback', _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]);
    base.register('components', _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]);
    base.register('contact', _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]);
    base.register('discriminator', _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]);
    base.register('encoding', _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]);
    base.register('example', _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]);
    base.register('externalDocumentation', _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_6__["default"]);
    base.register('header', _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_7__["default"]);
    base.register('info', _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]);
    base.register('license', _elements_License_mjs__WEBPACK_IMPORTED_MODULE_9__["default"]);
    base.register('link', _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_10__["default"]);
    base.register('mediaType', _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_11__["default"]);
    base.register('oAuthFlow', _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_12__["default"]);
    base.register('oAuthFlows', _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_13__["default"]);
    base.register('openapi', _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_14__["default"]);
    base.register('openApi3_0', _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_15__["default"]);
    base.register('operation', _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_16__["default"]);
    base.register('parameter', _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_17__["default"]);
    base.register('pathItem', _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_18__["default"]);
    base.register('paths', _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_19__["default"]);
    base.register('reference', _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_20__["default"]);
    base.register('requestBody', _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_21__["default"]);
    base.register('response', _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_22__["default"]);
    base.register('responses', _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_23__["default"]);
    base.register('schema', _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_24__["default"]);
    base.register('securityRequirement', _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_25__["default"]);
    base.register('securityScheme', _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_26__["default"]);
    base.register('server', _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_27__["default"]);
    base.register('serverVariable', _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_28__["default"]);
    base.register('tag', _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_29__["default"]);
    base.register('xml', _elements_Xml_mjs__WEBPACK_IMPORTED_MODULE_30__["default"]);
    return base;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi3_0);

/***/ }),

/***/ 85536:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isBooleanJsonSchemaElement: () => (/* binding */ isBooleanJsonSchemaElement),
/* harmony export */   isCallbackElement: () => (/* binding */ isCallbackElement),
/* harmony export */   isComponentsElement: () => (/* binding */ isComponentsElement),
/* harmony export */   isContactElement: () => (/* binding */ isContactElement),
/* harmony export */   isExampleElement: () => (/* binding */ isExampleElement),
/* harmony export */   isExternalDocumentationElement: () => (/* binding */ isExternalDocumentationElement),
/* harmony export */   isHeaderElement: () => (/* binding */ isHeaderElement),
/* harmony export */   isInfoElement: () => (/* binding */ isInfoElement),
/* harmony export */   isLicenseElement: () => (/* binding */ isLicenseElement),
/* harmony export */   isLinkElement: () => (/* binding */ isLinkElement),
/* harmony export */   isMediaTypeElement: () => (/* binding */ isMediaTypeElement),
/* harmony export */   isOpenApi3_0Element: () => (/* binding */ isOpenApi3_0Element),
/* harmony export */   isOpenapiElement: () => (/* binding */ isOpenapiElement),
/* harmony export */   isOperationElement: () => (/* binding */ isOperationElement),
/* harmony export */   isParameterElement: () => (/* binding */ isParameterElement),
/* harmony export */   isPathItemElement: () => (/* binding */ isPathItemElement),
/* harmony export */   isPathsElement: () => (/* binding */ isPathsElement),
/* harmony export */   isReferenceElement: () => (/* binding */ isReferenceElement),
/* harmony export */   isRequestBodyElement: () => (/* binding */ isRequestBodyElement),
/* harmony export */   isResponseElement: () => (/* binding */ isResponseElement),
/* harmony export */   isResponsesElement: () => (/* binding */ isResponsesElement),
/* harmony export */   isSchemaElement: () => (/* binding */ isSchemaElement),
/* harmony export */   isSecurityRequirementElement: () => (/* binding */ isSecurityRequirementElement),
/* harmony export */   isSecuritySchemeElement: () => (/* binding */ isSecuritySchemeElement),
/* harmony export */   isServerElement: () => (/* binding */ isServerElement),
/* harmony export */   isServerVariableElement: () => (/* binding */ isServerVariableElement),
/* harmony export */   isServersElement: () => (/* binding */ isServersElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(67906);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(33501);
/* harmony import */ var _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8725);
/* harmony import */ var _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27912);
/* harmony import */ var _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(43172);
/* harmony import */ var _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3758);
/* harmony import */ var _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(49837);
/* harmony import */ var _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(19403);
/* harmony import */ var _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(14036);
/* harmony import */ var _elements_License_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(98149);
/* harmony import */ var _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(71020);
/* harmony import */ var _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(71640);
/* harmony import */ var _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(54764);
/* harmony import */ var _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(5431);
/* harmony import */ var _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(37357);
/* harmony import */ var _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(41740);
/* harmony import */ var _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(12832);
/* harmony import */ var _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(27695);
/* harmony import */ var _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(88767);
/* harmony import */ var _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(18485);
/* harmony import */ var _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(62604);
/* harmony import */ var _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(19117);
/* harmony import */ var _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(94063);
/* harmony import */ var _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(89779);
/* harmony import */ var _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(2829);
/* harmony import */ var _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(44213);
/* harmony import */ var _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(22452);
/* harmony import */ var _elements_nces_Servers_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(87204);

























 // NCE types

const isCallbackElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_1__["default"] || hasBasicElementProps(element) && isElementType('callback', element) && primitiveEq('object', element);
});
const isComponentsElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('components', element) && primitiveEq('object', element);
});
const isContactElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__["default"] || hasBasicElementProps(element) && isElementType('contact', element) && primitiveEq('object', element);
});
const isExampleElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_4__["default"] || hasBasicElementProps(element) && isElementType('example', element) && primitiveEq('object', element);
});
const isExternalDocumentationElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_5__["default"] || hasBasicElementProps(element) && isElementType('externalDocumentation', element) && primitiveEq('object', element);
});
const isHeaderElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_6__["default"] || hasBasicElementProps(element) && isElementType('header', element) && primitiveEq('object', element);
});
const isInfoElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_7__["default"] || hasBasicElementProps(element) && isElementType('info', element) && primitiveEq('object', element);
});
const isLicenseElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_License_mjs__WEBPACK_IMPORTED_MODULE_8__["default"] || hasBasicElementProps(element) && isElementType('license', element) && primitiveEq('object', element);
});
const isLinkElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_9__["default"] || hasBasicElementProps(element) && isElementType('link', element) && primitiveEq('object', element);
});
const isOpenapiElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_10__["default"] || hasBasicElementProps(element) && isElementType('openapi', element) && primitiveEq('string', element);
});

// eslint-disable-next-line @typescript-eslint/naming-convention
const isOpenApi3_0Element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq,
  hasClass
}) => {
  return element => element instanceof _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_11__["default"] || hasBasicElementProps(element) && isElementType('openApi3_0', element) && primitiveEq('object', element) && hasClass('api', element);
});
const isOperationElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_12__["default"] || hasBasicElementProps(element) && isElementType('operation', element) && primitiveEq('object', element);
});
const isParameterElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_13__["default"] || hasBasicElementProps(element) && isElementType('parameter', element) && primitiveEq('object', element);
});
const isPathItemElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_14__["default"] || hasBasicElementProps(element) && isElementType('pathItem', element) && primitiveEq('object', element);
});
const isPathsElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_15__["default"] || hasBasicElementProps(element) && isElementType('paths', element) && primitiveEq('object', element);
});
const isReferenceElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_16__["default"] || hasBasicElementProps(element) && isElementType('reference', element) && primitiveEq('object', element);
});
const isRequestBodyElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_17__["default"] || hasBasicElementProps(element) && isElementType('requestBody', element) && primitiveEq('object', element);
});
const isResponseElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_18__["default"] || hasBasicElementProps(element) && isElementType('response', element) && primitiveEq('object', element);
});
const isResponsesElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_19__["default"] || hasBasicElementProps(element) && isElementType('responses', element) && primitiveEq('object', element);
});
const isSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_20__["default"] || hasBasicElementProps(element) && isElementType('schema', element) && primitiveEq('object', element);
});
const isBooleanJsonSchemaElement = element => {
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_21__.isBooleanElement)(element) && element.classes.includes('boolean-json-schema');
};
const isSecurityRequirementElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_22__["default"] || hasBasicElementProps(element) && isElementType('securityRequirement', element) && primitiveEq('object', element);
});
const isSecuritySchemeElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_23__["default"] || hasBasicElementProps(element) && isElementType('securityScheme', element) && primitiveEq('object', element);
});
const isServerElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_24__["default"] || hasBasicElementProps(element) && isElementType('server', element) && primitiveEq('object', element);
});
const isServerVariableElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_25__["default"] || hasBasicElementProps(element) && isElementType('serverVariable', element) && primitiveEq('object', element);
});
const isMediaTypeElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_26__["default"] || hasBasicElementProps(element) && isElementType('mediaType', element) && primitiveEq('object', element);
});
const isServersElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq,
  hasClass
}) => {
  return element => element instanceof _elements_nces_Servers_mjs__WEBPACK_IMPORTED_MODULE_27__["default"] || hasBasicElementProps(element) && isElementType('array', element) && primitiveEq('array', element) && hasClass('servers', element);
});

/***/ }),

/***/ 58773:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRefractor: () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(490);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(46571);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(15922);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24445);
/* harmony import */ var _specification_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(55498);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(43039);
/* harmony import */ var _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(44544);





const refract = (value, {
  specPath = ['visitors', 'document', 'objects', 'OpenApi', '$visitor'],
  plugins = []
} = {}) => {
  const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.refract)(value);
  const resolvedSpec = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.dereference)(_specification_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]);

  /**
   * This is where generic ApiDOM becomes semantic (namespace applied).
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const RootVisitorClass = (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(specPath, resolvedSpec);
  const rootVisitor = new RootVisitorClass({
    specObj: resolvedSpec
  });
  (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.visit)(element, rootVisitor);

  /**
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.dispatchPluginsSync)(rootVisitor.element, plugins, {
    toolboxCreator: _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
    visitorOptions: {
      keyMap: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__.keyMap,
      nodeTypeGetter: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__.getNodeType
    }
  });
};
const createRefractor = specPath => (value, options = {}) => refract(value, {
  specPath,
  ...options
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 85013:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isOpenApiExtension: () => (/* binding */ isOpenApiExtension),
/* harmony export */   isReferenceLikeElement: () => (/* binding */ isReferenceLikeElement),
/* harmony export */   isServerLikeElement: () => (/* binding */ isServerLikeElement),
/* harmony export */   isTagLikeElement: () => (/* binding */ isTagLikeElement)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29663);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9999);


const isReferenceLikeElement = element => {
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isObjectElement)(element) && element.hasKey('$ref');
};
const isServerLikeElement = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isObjectElement;
const isTagLikeElement = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isObjectElement;
const isOpenApiExtension = element => {
  // @ts-ignore
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isStringElement)(element.key) && (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])('x-', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(element.key));
};

/***/ }),

/***/ 88284:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CallbackElement: () => (/* reexport safe */ _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   ComponentsElement: () => (/* reexport safe */ _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   ContactElement: () => (/* reexport safe */ _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   DiscriminatorElement: () => (/* reexport safe */ _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   EncodingElement: () => (/* reexport safe */ _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   ExampleElement: () => (/* reexport safe */ _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   ExternalDocumentationElement: () => (/* reexport safe */ _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   HeaderElement: () => (/* reexport safe */ _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   InfoElement: () => (/* reexport safe */ _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   LicenseElement: () => (/* reexport safe */ _elements_License_mjs__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   LinkElement: () => (/* reexport safe */ _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   MediaTypeElement: () => (/* reexport safe */ _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   OAuthFlowElement: () => (/* reexport safe */ _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   OAuthFlowsElement: () => (/* reexport safe */ _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   OpenApi3_0Element: () => (/* reexport safe */ _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   OpenapiElement: () => (/* reexport safe */ _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   OperationElement: () => (/* reexport safe */ _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   ParameterElement: () => (/* reexport safe */ _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   PathItemElement: () => (/* reexport safe */ _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   PathsElement: () => (/* reexport safe */ _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   ReferenceElement: () => (/* reexport safe */ _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   RequestBodyElement: () => (/* reexport safe */ _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   ResponseElement: () => (/* reexport safe */ _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   ResponsesElement: () => (/* reexport safe */ _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   SchemaElement: () => (/* reexport safe */ _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_25__["default"]),
/* harmony export */   SecurityRequirementElement: () => (/* reexport safe */ _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   SecuritySchemeElement: () => (/* reexport safe */ _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_27__["default"]),
/* harmony export */   ServerElement: () => (/* reexport safe */ _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_28__["default"]),
/* harmony export */   ServerVariableElement: () => (/* reexport safe */ _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_29__["default"]),
/* harmony export */   TagElement: () => (/* reexport safe */ _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_30__["default"]),
/* harmony export */   XmlElement: () => (/* reexport safe */ _elements_Xml_mjs__WEBPACK_IMPORTED_MODULE_31__["default"])
/* harmony export */ });
/* harmony import */ var _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(8725);
/* harmony import */ var _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27912);
/* harmony import */ var _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(43172);
/* harmony import */ var _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(8652);
/* harmony import */ var _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(91915);
/* harmony import */ var _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3758);
/* harmony import */ var _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(49837);
/* harmony import */ var _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(19403);
/* harmony import */ var _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(14036);
/* harmony import */ var _elements_License_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(98149);
/* harmony import */ var _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(71020);
/* harmony import */ var _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(22452);
/* harmony import */ var _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(10409);
/* harmony import */ var _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(53608);
/* harmony import */ var _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(71640);
/* harmony import */ var _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(54764);
/* harmony import */ var _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(5431);
/* harmony import */ var _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(37357);
/* harmony import */ var _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(41740);
/* harmony import */ var _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(12832);
/* harmony import */ var _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(27695);
/* harmony import */ var _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(88767);
/* harmony import */ var _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(18485);
/* harmony import */ var _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(62604);
/* harmony import */ var _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(19117);
/* harmony import */ var _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(94063);
/* harmony import */ var _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(89779);
/* harmony import */ var _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(2829);
/* harmony import */ var _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(44213);
/* harmony import */ var _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(79700);
/* harmony import */ var _elements_Xml_mjs__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(70935);
/* harmony import */ var _index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58773);































 // register refractors specific to element types
_elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Callback', '$visitor']);
_elements_Components_mjs__WEBPACK_IMPORTED_MODULE_2__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Components', '$visitor']);
_elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Contact', '$visitor']);
_elements_Example_mjs__WEBPACK_IMPORTED_MODULE_4__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Example', '$visitor']);
_elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_5__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Discriminator', '$visitor']);
_elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_6__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Encoding', '$visitor']);
_elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_7__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'ExternalDocumentation', '$visitor']);
_elements_Header_mjs__WEBPACK_IMPORTED_MODULE_8__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Header', '$visitor']);
_elements_Info_mjs__WEBPACK_IMPORTED_MODULE_9__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Info', '$visitor']);
_elements_License_mjs__WEBPACK_IMPORTED_MODULE_10__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'License', '$visitor']);
_elements_Link_mjs__WEBPACK_IMPORTED_MODULE_11__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Link', '$visitor']);
_elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_12__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'MediaType', '$visitor']);
_elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_13__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'OAuthFlow', '$visitor']);
_elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_14__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'OAuthFlows', '$visitor']);
_elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_15__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'OpenApi', 'fixedFields', 'openapi']);
_elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_16__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'OpenApi', '$visitor']);
_elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_17__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Operation', '$visitor']);
_elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_18__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Parameter', '$visitor']);
_elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_19__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'PathItem', '$visitor']);
_elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_20__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Paths', '$visitor']);
_elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_21__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Reference', '$visitor']);
_elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_22__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'RequestBody', '$visitor']);
_elements_Response_mjs__WEBPACK_IMPORTED_MODULE_23__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Response', '$visitor']);
_elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_24__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Responses', '$visitor']);
_elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_25__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Schema', '$visitor']);
_elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_26__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'SecurityRequirement', '$visitor']);
_elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_27__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'SecurityScheme', '$visitor']);
_elements_Server_mjs__WEBPACK_IMPORTED_MODULE_28__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Server', '$visitor']);
_elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_29__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'ServerVariable', '$visitor']);
_elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_30__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Tag', '$visitor']);
_elements_Xml_mjs__WEBPACK_IMPORTED_MODULE_31__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'XML', '$visitor']);


/***/ }),

/***/ 55498:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(73278);
/* harmony import */ var _visitors_open_api_3_0_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60696);
/* harmony import */ var _visitors_open_api_3_0_OpenapiVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34270);
/* harmony import */ var _visitors_SpecificationExtensionVisitor_mjs__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__(19191);
/* harmony import */ var _visitors_open_api_3_0_info_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(11461);
/* harmony import */ var _visitors_open_api_3_0_info_VersionVisitor_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(93701);
/* harmony import */ var _visitors_open_api_3_0_contact_index_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(27253);
/* harmony import */ var _visitors_open_api_3_0_license_index_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(16172);
/* harmony import */ var _visitors_open_api_3_0_link_index_mjs__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(20525);
/* harmony import */ var _visitors_open_api_3_0_link_OperationRefVisitor_mjs__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(7149);
/* harmony import */ var _visitors_open_api_3_0_link_OperationIdVisitor_mjs__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(38125);
/* harmony import */ var _visitors_open_api_3_0_link_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(58415);
/* harmony import */ var _visitors_open_api_3_0_server_index_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(83604);
/* harmony import */ var _visitors_open_api_3_0_server_UrlVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(79047);
/* harmony import */ var _visitors_open_api_3_0_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(28298);
/* harmony import */ var _visitors_open_api_3_0_server_variable_index_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(80411);
/* harmony import */ var _visitors_open_api_3_0_server_VariablesVisitor_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(76627);
/* harmony import */ var _visitors_FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4287);
/* harmony import */ var _visitors_open_api_3_0_media_type_index_mjs__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(99036);
/* harmony import */ var _visitors_open_api_3_0_media_type_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(55533);
/* harmony import */ var _visitors_open_api_3_0_media_type_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(58109);
/* harmony import */ var _visitors_open_api_3_0_media_type_EncodingVisitor_mjs__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(7799);
/* harmony import */ var _visitors_open_api_3_0_security_requirement_index_mjs__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__(22913);
/* harmony import */ var _visitors_open_api_3_0_SecurityVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(81472);
/* harmony import */ var _visitors_open_api_3_0_components_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(55945);
/* harmony import */ var _visitors_open_api_3_0_tag_index_mjs__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(24581);
/* harmony import */ var _visitors_open_api_3_0_reference_index_mjs__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(48318);
/* harmony import */ var _visitors_open_api_3_0_reference_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(83229);
/* harmony import */ var _visitors_open_api_3_0_parameter_index_mjs__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(74388);
/* harmony import */ var _visitors_open_api_3_0_parameter_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(83973);
/* harmony import */ var _visitors_open_api_3_0_header_index_mjs__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(52730);
/* harmony import */ var _visitors_open_api_3_0_header_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(48135);
/* harmony import */ var _visitors_open_api_3_0_header_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(43947);
/* harmony import */ var _visitors_open_api_3_0_header_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(97901);
/* harmony import */ var _visitors_open_api_3_0_schema_index_mjs__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(91316);
/* harmony import */ var _visitors_open_api_3_0_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(47396);
/* harmony import */ var _visitors_open_api_3_0_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(86349);
/* harmony import */ var _visitors_open_api_3_0_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(54119);
/* harmony import */ var _visitors_open_api_3_0_schema_ItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(91082);
/* harmony import */ var _visitors_open_api_3_0_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(27843);
/* harmony import */ var _visitors_open_api_3_0_schema_TypeVisitor_mjs__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(84790);
/* harmony import */ var _visitors_open_api_3_0_schema_SchemaOrReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(27217);
/* harmony import */ var _visitors_open_api_3_0_distriminator_index_mjs__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(56016);
/* harmony import */ var _visitors_open_api_3_0_distriminator_MappingVisitor_mjs__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(85048);
/* harmony import */ var _visitors_open_api_3_0_xml_index_mjs__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(48966);
/* harmony import */ var _visitors_open_api_3_0_parameter_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(18117);
/* harmony import */ var _visitors_open_api_3_0_parameter_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(25047);
/* harmony import */ var _visitors_open_api_3_0_components_SchemasVisitor_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(57481);
/* harmony import */ var _visitors_open_api_3_0_components_ResponsesVisitor_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(47253);
/* harmony import */ var _visitors_open_api_3_0_components_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(54043);
/* harmony import */ var _visitors_open_api_3_0_components_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(21860);
/* harmony import */ var _visitors_open_api_3_0_components_RequestBodiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(65496);
/* harmony import */ var _visitors_open_api_3_0_components_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(15123);
/* harmony import */ var _visitors_open_api_3_0_components_SecuritySchemesVisitor_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(38939);
/* harmony import */ var _visitors_open_api_3_0_components_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(4672);
/* harmony import */ var _visitors_open_api_3_0_components_CallbacksVisitor_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(38257);
/* harmony import */ var _visitors_open_api_3_0_example_index_mjs__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(15055);
/* harmony import */ var _visitors_open_api_3_0_example_ExternalValueVisitor_mjs__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(18087);
/* harmony import */ var _visitors_open_api_3_0_external_documentation_index_mjs__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(73905);
/* harmony import */ var _visitors_open_api_3_0_encoding_index_mjs__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(58666);
/* harmony import */ var _visitors_open_api_3_0_encoding_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(30758);
/* harmony import */ var _visitors_open_api_3_0_paths_index_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(8305);
/* harmony import */ var _visitors_open_api_3_0_request_body_index_mjs__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(34181);
/* harmony import */ var _visitors_open_api_3_0_request_body_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(78316);
/* harmony import */ var _visitors_open_api_3_0_callback_index_mjs__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(8140);
/* harmony import */ var _visitors_open_api_3_0_response_index_mjs__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(90716);
/* harmony import */ var _visitors_open_api_3_0_response_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(24016);
/* harmony import */ var _visitors_open_api_3_0_response_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(3231);
/* harmony import */ var _visitors_open_api_3_0_response_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(98895);
/* harmony import */ var _visitors_open_api_3_0_responses_index_mjs__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(36829);
/* harmony import */ var _visitors_open_api_3_0_responses_DefaultVisitor_mjs__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(12564);
/* harmony import */ var _visitors_open_api_3_0_operation_index_mjs__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(96278);
/* harmony import */ var _visitors_open_api_3_0_operation_TagsVisitor_mjs__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(24933);
/* harmony import */ var _visitors_open_api_3_0_operation_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(45416);
/* harmony import */ var _visitors_open_api_3_0_operation_RequestBodyVisitor_mjs__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(65525);
/* harmony import */ var _visitors_open_api_3_0_operation_CallbacksVisitor_mjs__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(55980);
/* harmony import */ var _visitors_open_api_3_0_operation_SecurityVisitor_mjs__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(70678);
/* harmony import */ var _visitors_open_api_3_0_operation_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(65188);
/* harmony import */ var _visitors_open_api_3_0_path_item_index_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(80322);
/* harmony import */ var _visitors_open_api_3_0_path_item_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(98745);
/* harmony import */ var _visitors_open_api_3_0_path_item_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(83088);
/* harmony import */ var _visitors_open_api_3_0_path_item_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(21508);
/* harmony import */ var _visitors_open_api_3_0_security_scheme_index_mjs__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(4603);
/* harmony import */ var _visitors_open_api_3_0_oauth_flows_index_mjs__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(85580);
/* harmony import */ var _visitors_open_api_3_0_oauth_flow_index_mjs__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(1463);
/* harmony import */ var _visitors_open_api_3_0_oauth_flow_ScopesVisitor_mjs__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(33416);
/* harmony import */ var _visitors_open_api_3_0_TagsVisitor_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(92523);























































































/**
 * Specification object allows us to have complete control over visitors
 * when traversing the ApiDOM.
 * Specification also allows us to create amended refractors from
 * existing ones by manipulating it.
 *
 * Note: Specification object allows to use absolute internal JSON pointers.
 */
const {
  fixedFields: jsonSchemaFixedFields
} = _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.JSONSchema;
const specification = {
  visitors: {
    value: _visitors_FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
    document: {
      objects: {
        OpenApi: {
          $visitor: _visitors_open_api_3_0_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"],
          fixedFields: {
            openapi: _visitors_open_api_3_0_OpenapiVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"],
            info: {
              $ref: '#/visitors/document/objects/Info'
            },
            servers: _visitors_open_api_3_0_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__["default"],
            paths: {
              $ref: '#/visitors/document/objects/Paths'
            },
            components: {
              $ref: '#/visitors/document/objects/Components'
            },
            security: _visitors_open_api_3_0_SecurityVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"],
            tags: _visitors_open_api_3_0_TagsVisitor_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            }
          }
        },
        Info: {
          $visitor: _visitors_open_api_3_0_info_index_mjs__WEBPACK_IMPORTED_MODULE_7__["default"],
          fixedFields: {
            title: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            termsOfService: {
              $ref: '#/visitors/value'
            },
            contact: {
              $ref: '#/visitors/document/objects/Contact'
            },
            license: {
              $ref: '#/visitors/document/objects/License'
            },
            version: _visitors_open_api_3_0_info_VersionVisitor_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]
          }
        },
        Contact: {
          $visitor: _visitors_open_api_3_0_contact_index_mjs__WEBPACK_IMPORTED_MODULE_9__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            url: {
              $ref: '#/visitors/value'
            },
            email: {
              $ref: '#/visitors/value'
            }
          }
        },
        License: {
          $visitor: _visitors_open_api_3_0_license_index_mjs__WEBPACK_IMPORTED_MODULE_10__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            url: {
              $ref: '#/visitors/value'
            }
          }
        },
        Server: {
          $visitor: _visitors_open_api_3_0_server_index_mjs__WEBPACK_IMPORTED_MODULE_11__["default"],
          fixedFields: {
            url: _visitors_open_api_3_0_server_UrlVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__["default"],
            description: {
              $ref: '#/visitors/value'
            },
            variables: _visitors_open_api_3_0_server_VariablesVisitor_mjs__WEBPACK_IMPORTED_MODULE_13__["default"]
          }
        },
        ServerVariable: {
          $visitor: _visitors_open_api_3_0_server_variable_index_mjs__WEBPACK_IMPORTED_MODULE_14__["default"],
          fixedFields: {
            enum: {
              $ref: '#/visitors/value'
            },
            default: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            }
          }
        },
        Components: {
          $visitor: _visitors_open_api_3_0_components_index_mjs__WEBPACK_IMPORTED_MODULE_15__["default"],
          fixedFields: {
            schemas: _visitors_open_api_3_0_components_SchemasVisitor_mjs__WEBPACK_IMPORTED_MODULE_16__["default"],
            responses: _visitors_open_api_3_0_components_ResponsesVisitor_mjs__WEBPACK_IMPORTED_MODULE_17__["default"],
            parameters: _visitors_open_api_3_0_components_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_18__["default"],
            examples: _visitors_open_api_3_0_components_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_19__["default"],
            requestBodies: _visitors_open_api_3_0_components_RequestBodiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_20__["default"],
            headers: _visitors_open_api_3_0_components_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_21__["default"],
            securitySchemes: _visitors_open_api_3_0_components_SecuritySchemesVisitor_mjs__WEBPACK_IMPORTED_MODULE_22__["default"],
            links: _visitors_open_api_3_0_components_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_23__["default"],
            callbacks: _visitors_open_api_3_0_components_CallbacksVisitor_mjs__WEBPACK_IMPORTED_MODULE_24__["default"]
          }
        },
        Paths: {
          $visitor: _visitors_open_api_3_0_paths_index_mjs__WEBPACK_IMPORTED_MODULE_25__["default"]
        },
        PathItem: {
          $visitor: _visitors_open_api_3_0_path_item_index_mjs__WEBPACK_IMPORTED_MODULE_26__["default"],
          fixedFields: {
            $ref: _visitors_open_api_3_0_path_item_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_27__["default"],
            summary: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            get: {
              $ref: '#/visitors/document/objects/Operation'
            },
            put: {
              $ref: '#/visitors/document/objects/Operation'
            },
            post: {
              $ref: '#/visitors/document/objects/Operation'
            },
            delete: {
              $ref: '#/visitors/document/objects/Operation'
            },
            options: {
              $ref: '#/visitors/document/objects/Operation'
            },
            head: {
              $ref: '#/visitors/document/objects/Operation'
            },
            patch: {
              $ref: '#/visitors/document/objects/Operation'
            },
            trace: {
              $ref: '#/visitors/document/objects/Operation'
            },
            servers: _visitors_open_api_3_0_path_item_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_28__["default"],
            parameters: _visitors_open_api_3_0_path_item_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_29__["default"]
          }
        },
        Operation: {
          $visitor: _visitors_open_api_3_0_operation_index_mjs__WEBPACK_IMPORTED_MODULE_30__["default"],
          fixedFields: {
            tags: _visitors_open_api_3_0_operation_TagsVisitor_mjs__WEBPACK_IMPORTED_MODULE_31__["default"],
            summary: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            },
            operationId: {
              $ref: '#/visitors/value'
            },
            parameters: _visitors_open_api_3_0_operation_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_32__["default"],
            requestBody: _visitors_open_api_3_0_operation_RequestBodyVisitor_mjs__WEBPACK_IMPORTED_MODULE_33__["default"],
            responses: {
              $ref: '#/visitors/document/objects/Responses'
            },
            callbacks: _visitors_open_api_3_0_operation_CallbacksVisitor_mjs__WEBPACK_IMPORTED_MODULE_34__["default"],
            deprecated: {
              $ref: '#/visitors/value'
            },
            security: _visitors_open_api_3_0_operation_SecurityVisitor_mjs__WEBPACK_IMPORTED_MODULE_35__["default"],
            servers: _visitors_open_api_3_0_operation_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_36__["default"]
          }
        },
        ExternalDocumentation: {
          $visitor: _visitors_open_api_3_0_external_documentation_index_mjs__WEBPACK_IMPORTED_MODULE_37__["default"],
          fixedFields: {
            description: {
              $ref: '#/visitors/value'
            },
            url: {
              $ref: '#/visitors/value'
            }
          }
        },
        Parameter: {
          $visitor: _visitors_open_api_3_0_parameter_index_mjs__WEBPACK_IMPORTED_MODULE_38__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            in: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            required: {
              $ref: '#/visitors/value'
            },
            deprecated: {
              $ref: '#/visitors/value'
            },
            allowEmptyValue: {
              $ref: '#/visitors/value'
            },
            style: {
              $ref: '#/visitors/value'
            },
            explode: {
              $ref: '#/visitors/value'
            },
            allowReserved: {
              $ref: '#/visitors/value'
            },
            schema: _visitors_open_api_3_0_parameter_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_39__["default"],
            example: {
              $ref: '#/visitors/value'
            },
            examples: _visitors_open_api_3_0_parameter_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_40__["default"],
            content: _visitors_open_api_3_0_parameter_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_41__["default"]
          }
        },
        RequestBody: {
          $visitor: _visitors_open_api_3_0_request_body_index_mjs__WEBPACK_IMPORTED_MODULE_42__["default"],
          fixedFields: {
            description: {
              $ref: '#/visitors/value'
            },
            content: _visitors_open_api_3_0_request_body_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_43__["default"],
            required: {
              $ref: '#/visitors/value'
            }
          }
        },
        MediaType: {
          $visitor: _visitors_open_api_3_0_media_type_index_mjs__WEBPACK_IMPORTED_MODULE_44__["default"],
          fixedFields: {
            schema: _visitors_open_api_3_0_media_type_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_45__["default"],
            example: {
              $ref: '#/visitors/value'
            },
            examples: _visitors_open_api_3_0_media_type_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_46__["default"],
            encoding: _visitors_open_api_3_0_media_type_EncodingVisitor_mjs__WEBPACK_IMPORTED_MODULE_47__["default"]
          }
        },
        Encoding: {
          $visitor: _visitors_open_api_3_0_encoding_index_mjs__WEBPACK_IMPORTED_MODULE_48__["default"],
          fixedFields: {
            contentType: {
              $ref: '#/visitors/value'
            },
            headers: _visitors_open_api_3_0_encoding_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_49__["default"],
            style: {
              $ref: '#/visitors/value'
            },
            explode: {
              $ref: '#/visitors/value'
            },
            allowReserved: {
              $ref: '#/visitors/value'
            }
          }
        },
        Responses: {
          $visitor: _visitors_open_api_3_0_responses_index_mjs__WEBPACK_IMPORTED_MODULE_50__["default"],
          fixedFields: {
            default: _visitors_open_api_3_0_responses_DefaultVisitor_mjs__WEBPACK_IMPORTED_MODULE_51__["default"]
          }
        },
        Response: {
          $visitor: _visitors_open_api_3_0_response_index_mjs__WEBPACK_IMPORTED_MODULE_52__["default"],
          fixedFields: {
            description: {
              $ref: '#/visitors/value'
            },
            headers: _visitors_open_api_3_0_response_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_53__["default"],
            content: _visitors_open_api_3_0_response_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_54__["default"],
            links: _visitors_open_api_3_0_response_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_55__["default"]
          }
        },
        Callback: {
          $visitor: _visitors_open_api_3_0_callback_index_mjs__WEBPACK_IMPORTED_MODULE_56__["default"]
        },
        Example: {
          $visitor: _visitors_open_api_3_0_example_index_mjs__WEBPACK_IMPORTED_MODULE_57__["default"],
          fixedFields: {
            summary: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            value: {
              $ref: '#/visitors/value'
            },
            externalValue: _visitors_open_api_3_0_example_ExternalValueVisitor_mjs__WEBPACK_IMPORTED_MODULE_58__["default"]
          }
        },
        Link: {
          $visitor: _visitors_open_api_3_0_link_index_mjs__WEBPACK_IMPORTED_MODULE_59__["default"],
          fixedFields: {
            operationRef: _visitors_open_api_3_0_link_OperationRefVisitor_mjs__WEBPACK_IMPORTED_MODULE_60__["default"],
            operationId: _visitors_open_api_3_0_link_OperationIdVisitor_mjs__WEBPACK_IMPORTED_MODULE_61__["default"],
            parameters: _visitors_open_api_3_0_link_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_62__["default"],
            requestBody: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            server: {
              $ref: '#/visitors/document/objects/Server'
            }
          }
        },
        Header: {
          $visitor: _visitors_open_api_3_0_header_index_mjs__WEBPACK_IMPORTED_MODULE_63__["default"],
          fixedFields: {
            description: {
              $ref: '#/visitors/value'
            },
            required: {
              $ref: '#/visitors/value'
            },
            deprecated: {
              $ref: '#/visitors/value'
            },
            allowEmptyValue: {
              $ref: '#/visitors/value'
            },
            style: {
              $ref: '#/visitors/value'
            },
            explode: {
              $ref: '#/visitors/value'
            },
            allowReserved: {
              $ref: '#/visitors/value'
            },
            schema: _visitors_open_api_3_0_header_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_64__["default"],
            example: {
              $ref: '#/visitors/value'
            },
            examples: _visitors_open_api_3_0_header_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_65__["default"],
            content: _visitors_open_api_3_0_header_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_66__["default"]
          }
        },
        Tag: {
          $visitor: _visitors_open_api_3_0_tag_index_mjs__WEBPACK_IMPORTED_MODULE_67__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            }
          }
        },
        Reference: {
          $visitor: _visitors_open_api_3_0_reference_index_mjs__WEBPACK_IMPORTED_MODULE_68__["default"],
          fixedFields: {
            $ref: _visitors_open_api_3_0_reference_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_69__["default"]
          }
        },
        JSONSchema: {
          $ref: '#/visitors/document/objects/Schema'
        },
        JSONReference: {
          $ref: '#/visitors/document/objects/Reference'
        },
        Schema: {
          $visitor: _visitors_open_api_3_0_schema_index_mjs__WEBPACK_IMPORTED_MODULE_70__["default"],
          fixedFields: {
            // the following properties are taken directly from the JSON Schema definition and follow the same specifications
            title: jsonSchemaFixedFields.title,
            multipleOf: jsonSchemaFixedFields.multipleOf,
            maximum: jsonSchemaFixedFields.maximum,
            exclusiveMaximum: jsonSchemaFixedFields.exclusiveMaximum,
            minimum: jsonSchemaFixedFields.minimum,
            exclusiveMinimum: jsonSchemaFixedFields.exclusiveMinimum,
            maxLength: jsonSchemaFixedFields.maxLength,
            minLength: jsonSchemaFixedFields.minLength,
            pattern: jsonSchemaFixedFields.pattern,
            maxItems: jsonSchemaFixedFields.maxItems,
            minItems: jsonSchemaFixedFields.minItems,
            uniqueItems: jsonSchemaFixedFields.uniqueItems,
            maxProperties: jsonSchemaFixedFields.maxProperties,
            minProperties: jsonSchemaFixedFields.minProperties,
            required: jsonSchemaFixedFields.required,
            enum: jsonSchemaFixedFields.enum,
            // the following properties are taken from the JSON Schema definition but their definitions were adjusted to the OpenAPI Specification
            type: _visitors_open_api_3_0_schema_TypeVisitor_mjs__WEBPACK_IMPORTED_MODULE_71__["default"],
            allOf: _visitors_open_api_3_0_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_72__["default"],
            anyOf: _visitors_open_api_3_0_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_73__["default"],
            oneOf: _visitors_open_api_3_0_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_74__["default"],
            not: _visitors_open_api_3_0_schema_SchemaOrReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_75__["default"],
            items: _visitors_open_api_3_0_schema_ItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_76__["default"],
            properties: _visitors_open_api_3_0_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_77__["default"],
            additionalProperties: _visitors_open_api_3_0_schema_SchemaOrReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_75__["default"],
            description: jsonSchemaFixedFields.description,
            format: jsonSchemaFixedFields.format,
            default: jsonSchemaFixedFields.default,
            // OpenAPI vocabulary
            nullable: {
              $ref: '#/visitors/value'
            },
            discriminator: {
              $ref: '#/visitors/document/objects/Discriminator'
            },
            writeOnly: {
              $ref: '#/visitors/value'
            },
            xml: {
              $ref: '#/visitors/document/objects/XML'
            },
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            },
            example: {
              $ref: '#/visitors/value'
            },
            deprecated: {
              $ref: '#/visitors/value'
            }
          }
        },
        Discriminator: {
          $visitor: _visitors_open_api_3_0_distriminator_index_mjs__WEBPACK_IMPORTED_MODULE_78__["default"],
          fixedFields: {
            propertyName: {
              $ref: '#/visitors/value'
            },
            mapping: _visitors_open_api_3_0_distriminator_MappingVisitor_mjs__WEBPACK_IMPORTED_MODULE_79__["default"]
          }
        },
        XML: {
          $visitor: _visitors_open_api_3_0_xml_index_mjs__WEBPACK_IMPORTED_MODULE_80__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            namespace: {
              $ref: '#/visitors/value'
            },
            prefix: {
              $ref: '#/visitors/value'
            },
            attribute: {
              $ref: '#/visitors/value'
            },
            wrapped: {
              $ref: '#/visitors/value'
            }
          }
        },
        SecurityScheme: {
          $visitor: _visitors_open_api_3_0_security_scheme_index_mjs__WEBPACK_IMPORTED_MODULE_81__["default"],
          fixedFields: {
            type: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            name: {
              $ref: '#/visitors/value'
            },
            in: {
              $ref: '#/visitors/value'
            },
            scheme: {
              $ref: '#/visitors/value'
            },
            bearerFormat: {
              $ref: '#/visitors/value'
            },
            flows: {
              $ref: '#/visitors/document/objects/OAuthFlows'
            },
            openIdConnectUrl: {
              $ref: '#/visitors/value'
            }
          }
        },
        OAuthFlows: {
          $visitor: _visitors_open_api_3_0_oauth_flows_index_mjs__WEBPACK_IMPORTED_MODULE_82__["default"],
          fixedFields: {
            implicit: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            password: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            clientCredentials: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            authorizationCode: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            }
          }
        },
        OAuthFlow: {
          $visitor: _visitors_open_api_3_0_oauth_flow_index_mjs__WEBPACK_IMPORTED_MODULE_83__["default"],
          fixedFields: {
            authorizationUrl: {
              $ref: '#/visitors/value'
            },
            tokenUrl: {
              $ref: '#/visitors/value'
            },
            refreshUrl: {
              $ref: '#/visitors/value'
            },
            scopes: _visitors_open_api_3_0_oauth_flow_ScopesVisitor_mjs__WEBPACK_IMPORTED_MODULE_84__["default"]
          }
        },
        SecurityRequirement: {
          $visitor: _visitors_open_api_3_0_security_requirement_index_mjs__WEBPACK_IMPORTED_MODULE_85__["default"]
        }
      },
      extension: {
        $visitor: _visitors_SpecificationExtensionVisitor_mjs__WEBPACK_IMPORTED_MODULE_86__["default"]
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (specification);

/***/ }),

/***/ 44544:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1667);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33501);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(85536);
/* harmony import */ var _namespace_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31015);



const createToolbox = () => {
  const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.createNamespace)(_namespace_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]);
  const predicates = {
    ..._predicates_mjs__WEBPACK_IMPORTED_MODULE_2__,
    isElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isElement,
    isStringElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement,
    isArrayElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isArrayElement,
    isObjectElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isObjectElement,
    isMemberElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isMemberElement,
    includesClasses: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.includesClasses,
    hasElementSourceMap: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.hasElementSourceMap
  };
  return {
    predicates,
    namespace
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createToolbox);

/***/ }),

/***/ 4287:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(68618);
/* harmony import */ var _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71109);


/**
 * This visitor is responsible for falling back to current traversed element
 * Given OpenApi3_0Visitor expects ObjectElement to be traversed. If
 * different Element is provided FallBackVisitor is responsible to assigning
 * this Element as current element.
 */
class FallbackVisitor extends _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  enter(element) {
    this.element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FallbackVisitor);

/***/ }),

/***/ 19191:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(68618);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91966);


class SpecificationExtensionVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  MemberElement(memberElement) {
    this.element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(memberElement);
    this.element.classes.push('specification-extension');
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SpecificationExtensionVisitor);

/***/ }),

/***/ 91966:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18499);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24445);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67924);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34610);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(46571);
/* harmony import */ var _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71109);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4287);





/**
 * This is a base Type for every visitor that does
 * internal look-ups to retrieve other child visitors.
 */
class SpecificationVisitor extends _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  specObj;
  passingOptionsNames = ['specObj', 'openApiGenericElement', 'openApiSemanticElement'];
  openApiGenericElement;
  openApiSemanticElement;
  constructor({
    specObj,
    passingOptionsNames,
    openApiGenericElement,
    openApiSemanticElement,
    ...rest
  }) {
    super({
      ...rest
    });
    this.specObj = specObj;
    this.openApiGenericElement = openApiGenericElement;
    this.openApiSemanticElement = openApiSemanticElement;
    if (Array.isArray(passingOptionsNames)) {
      this.passingOptionsNames = passingOptionsNames;
    }
  }
  retrievePassingOptions() {
    return (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(this.passingOptionsNames, this);
  }
  retrieveFixedFields(specPath) {
    const fixedFields = (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['visitors', ...specPath, 'fixedFields'], this.specObj);
    if (typeof fixedFields === 'object' && fixedFields !== null) {
      return Object.keys(fixedFields);
    }
    return [];
  }
  retrieveVisitor(specPath) {
    if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"], ['visitors', ...specPath], this.specObj)) {
      return (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['visitors', ...specPath], this.specObj);
    }
    return (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['visitors', ...specPath, '$visitor'], this.specObj);
  }
  retrieveVisitorInstance(specPath, options = {}) {
    const passingOpts = this.retrievePassingOptions();
    const VisitorClz = this.retrieveVisitor(specPath);
    const visitorOpts = {
      ...passingOpts,
      ...options
    };
    return new VisitorClz(visitorOpts);
  }
  toRefractedElement(specPath, element, options = {}) {
    /**
     * This is `Visitor shortcut`: mechanism for short-circuiting the traversal and replacing
     * it by basic node cloning.
     *
     * Visiting the element is equivalent to cloning it  if the prototype of a visitor
     * is the same as the prototype of FallbackVisitor. If that's the case, we can avoid
     * bootstrapping the traversal cycle for fields that don't require any special visiting.
     */
    const visitor = this.retrieveVisitorInstance(specPath, options);
    if (visitor instanceof _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"] && (visitor === null || visitor === void 0 ? void 0 : visitor.constructor) === _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]) {
      return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.cloneDeep)(element);
    }
    (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__.visit)(element, visitor, options);
    return visitor.element;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SpecificationVisitor);

/***/ }),

/***/ 71109:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(15461);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33501);

class Visitor {
  element;
  constructor(options = {}) {
    Object.assign(this, options);
  }

  /* eslint-disable class-methods-use-this, no-param-reassign */
  copyMetaAndAttributes(from, to) {
    if (from.meta.length > 0 || to.meta.length > 0) {
      to.meta = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(to.meta, from.meta);
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.hasElementSourceMap)(from)) {
        // avoid deep merging of source maps
        to.meta.set('sourceMap', from.meta.get('sourceMap'));
      }
    }
    if (from.attributes.length > 0 || from.meta.length > 0) {
      to.attributes = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(to.attributes, from.attributes); // eslint-disable-line no-param-reassign
    }
  }
  /* eslint-enable class-methods-use-this, no-param-reassign */
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Visitor);

/***/ }),

/***/ 38525:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8564);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26183);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21504);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(89360);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91966);




class AlternatingVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  alternator;
  constructor({
    alternator,
    ...rest
  }) {
    super({
      ...rest
    });
    this.alternator = alternator || [];
  }
  enter(element) {
    const functions = this.alternator.map(({
      predicate,
      specPath
    }) => (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(predicate, (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(specPath), ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"]));
    const specPath = (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(functions)(element);
    this.element = this.toRefractedElement(specPath, element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AlternatingVisitor);

/***/ }),

/***/ 83671:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9999);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(68618);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91966);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85013);



class FixedFieldsVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  specPath;
  ignoredFields;
  canSupportSpecificationExtensions = true;
  specificationExtensionPredicate = _predicates_mjs__WEBPACK_IMPORTED_MODULE_1__.isOpenApiExtension;
  constructor({
    specPath,
    ignoredFields,
    canSupportSpecificationExtensions,
    specificationExtensionPredicate,
    ...rest
  }) {
    super({
      ...rest
    });
    this.specPath = specPath;
    this.ignoredFields = ignoredFields || [];
    if (typeof canSupportSpecificationExtensions === 'boolean') {
      this.canSupportSpecificationExtensions = canSupportSpecificationExtensions;
    }
    if (typeof specificationExtensionPredicate === 'function') {
      this.specificationExtensionPredicate = specificationExtensionPredicate;
    }
  }
  ObjectElement(objectElement) {
    const specPath = this.specPath(objectElement);
    const fields = this.retrieveFixedFields(specPath);

    // @ts-ignore
    objectElement.forEach((value, key, memberElement) => {
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(key) && fields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"])(key)) && !this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"])(key))) {
        const fixedFieldElement = this.toRefractedElement([...specPath, 'fixedFields', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"])(key)], value);
        const newMemberElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.MemberElement((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.cloneDeep)(key), fixedFieldElement);
        this.copyMetaAndAttributes(memberElement, newMemberElement);
        newMemberElement.classes.push('fixed-field');
        this.element.content.push(newMemberElement);
      } else if (this.canSupportSpecificationExtensions && this.specificationExtensionPredicate(memberElement)) {
        const extensionElement = this.toRefractedElement(['document', 'extension'], memberElement);
        this.element.content.push(extensionElement);
      } else if (!this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"])(key))) {
        this.element.content.push((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.cloneDeep)(memberElement));
      }
    });
    this.copyMetaAndAttributes(objectElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FixedFieldsVisitor);

/***/ }),

/***/ 93774:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46455);
/* harmony import */ var _PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10810);


class MapVisitor extends _PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.fieldPatternPredicate = ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"];
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MapVisitor);

/***/ }),

/***/ 57046:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62113);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(68618);
/* harmony import */ var _FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10810);





class MixedFieldsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  specPathFixedFields;
  specPathPatternedFields;
  constructor({
    specPathFixedFields,
    specPathPatternedFields,
    ...rest
  }) {
    super({
      ...rest
    });
    this.specPathFixedFields = specPathFixedFields;
    this.specPathPatternedFields = specPathPatternedFields;
  }
  ObjectElement(objectElement) {
    const {
      specPath,
      ignoredFields
    } = this;
    try {
      this.specPath = this.specPathFixedFields;
      const fixedFields = this.retrieveFixedFields(this.specPath(objectElement));
      // let FixedFieldsVisitor only process fixed fields and leave rest to PatternedFieldsVisitor
      // @ts-ignore
      this.ignoredFields = [...ignoredFields, ...(0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(objectElement.keys(), fixedFields)];
      _FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);
      this.specPath = this.specPathPatternedFields;
      this.ignoredFields = fixedFields;
      _PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"].prototype.ObjectElement.call(this, objectElement);
    } catch (e) {
      this.specPath = specPath;
      throw e;
    }
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MixedFieldsVisitor);

/***/ }),

/***/ 10810:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3182);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9999);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(68618);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91966);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(85013);




class PatternedFieldsVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  specPath;
  ignoredFields;
  fieldPatternPredicate = ramda__WEBPACK_IMPORTED_MODULE_1__["default"];
  canSupportSpecificationExtensions = false;
  specificationExtensionPredicate = _predicates_mjs__WEBPACK_IMPORTED_MODULE_2__.isOpenApiExtension;
  constructor({
    specPath,
    ignoredFields,
    fieldPatternPredicate,
    canSupportSpecificationExtensions,
    specificationExtensionPredicate,
    ...rest
  }) {
    super({
      ...rest
    });
    this.specPath = specPath;
    this.ignoredFields = ignoredFields || [];
    if (typeof fieldPatternPredicate === 'function') {
      this.fieldPatternPredicate = fieldPatternPredicate;
    }
    if (typeof canSupportSpecificationExtensions === 'boolean') {
      this.canSupportSpecificationExtensions = canSupportSpecificationExtensions;
    }
    if (typeof specificationExtensionPredicate === 'function') {
      this.specificationExtensionPredicate = specificationExtensionPredicate;
    }
  }
  ObjectElement(objectElement) {
    // @ts-ignore
    objectElement.forEach((value, key, memberElement) => {
      if (this.canSupportSpecificationExtensions && this.specificationExtensionPredicate(memberElement)) {
        const extensionElement = this.toRefractedElement(['document', 'extension'], memberElement);
        this.element.content.push(extensionElement);
      } else if (!this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"])(key)) && this.fieldPatternPredicate((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"])(key))) {
        const specPath = this.specPath(value);
        const patternedFieldElement = this.toRefractedElement(specPath, value);
        const newMemberElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.MemberElement((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.cloneDeep)(key), patternedFieldElement);
        this.copyMetaAndAttributes(memberElement, newMemberElement);
        newMemberElement.classes.push('patterned-field');
        this.element.content.push(newMemberElement);
      } else if (!this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"])(key))) {
        this.element.content.push((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.cloneDeep)(memberElement));
      }
    });
    this.copyMetaAndAttributes(objectElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternedFieldsVisitor);

/***/ }),

/***/ 81299:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(44824);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class ContentVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ObjectElement();
    this.element.classes.push('content');
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'MediaType']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContentVisitor);

/***/ }),

/***/ 59817:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(44824);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class ExamplesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ObjectElement();
    this.element.classes.push('examples');
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Example'];
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'example');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExamplesVisitor);

/***/ }),

/***/ 34270:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9999);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91966);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71640);





class OpenapiVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  StringElement(stringElement) {
    const openapiElement = new _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__["default"])(stringElement));
    this.copyMetaAndAttributes(stringElement, openapiElement);
    this.element = openapiElement;
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenapiVisitor);

/***/ }),

/***/ 14474:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(44824);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(68618);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91966);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class ParametersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ArrayElement();
    this.element.classes.push('parameters');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(item) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Parameter'];
      const element = this.toRefractedElement(specPath, item);
      if ((0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement)(element)) {
        element.setMetaProperty('referenced-element', 'parameter');
      }
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParametersVisitor);

/***/ }),

/***/ 81472:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(68618);
/* harmony import */ var _elements_nces_Security_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42894);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91966);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class SecurityVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_Security_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isObjectElement)(item)) {
        const element = this.toRefractedElement(['document', 'objects', 'SecurityRequirement'], item);
        this.element.push(element);
      } else {
        this.element.push((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.cloneDeep)(item));
      }
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecurityVisitor);

/***/ }),

/***/ 28298:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _elements_nces_Servers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87204);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91966);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);






class ServersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_Servers_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isServerLikeElement)(item) ? ['document', 'objects', 'Server'] : ['value'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServersVisitor);

/***/ }),

/***/ 92523:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _elements_nces_Tags_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(92579);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91966);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);






class TagsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_Tags_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isTagLikeElement)(item) ? ['document', 'objects', 'Tag'] : ['value'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TagsVisitor);

/***/ }),

/***/ 8140:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9999);
/* harmony import */ var _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8725);
/* harmony import */ var _generics_PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10810);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(93774);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85536);








class CallbackVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'PathItem']);
    this.canSupportSpecificationExtensions = true;
    this.fieldPatternPredicate = value => /{(?<expression>[^}]{1,2083})}/.test(String(value)); // 2,083 characters is the maximum length of a URL in Chrome
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every PathItemElement with Callback Object expression metadata
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_6__.isPathItemElement)
    // @ts-ignore
    .forEach((pathItemElement, key) => {
      pathItemElement.setMetaProperty('runtime-expression', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__["default"])(key));
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CallbackVisitor);

/***/ }),

/***/ 38257:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _elements_nces_ComponentsCallbacks_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53320);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class CallbacksVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsCallbacks_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Callback'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'callback');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CallbacksVisitor);

/***/ }),

/***/ 21860:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _elements_nces_ComponentsExamples_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(38065);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class ExamplesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsExamples_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Example'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every ReferenceElement with metadata about their referencing type
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'example');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExamplesVisitor);

/***/ }),

/***/ 15123:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9999);
/* harmony import */ var _elements_nces_ComponentsHeaders_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(98798);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);







class HeadersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsHeaders_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Header'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every ReferenceElement with metadata about their referencing type
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'header');
    });

    // decorate every HeaderElement with metadata about their name
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isHeaderElement).forEach((value, key) => {
      value.setMetaProperty('header-name', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__["default"])(key));
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeadersVisitor);

/***/ }),

/***/ 4672:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _elements_nces_ComponentsLinks_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(82247);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class LinksVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsLinks_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Link'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'link');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinksVisitor);

/***/ }),

/***/ 54043:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _elements_nces_ComponentsParameters_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66488);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class ParametersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsParameters_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Parameter'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every ReferenceElement with metadata about their referencing type
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'parameter');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParametersVisitor);

/***/ }),

/***/ 65496:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _elements_nces_ComponentsRequestBodies_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16947);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class RequestBodiesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsRequestBodies_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'RequestBody'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'requestBody');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBodiesVisitor);

/***/ }),

/***/ 47253:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9999);
/* harmony import */ var _elements_nces_ComponentsResponses_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(23128);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);







class ResponsesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsResponses_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Response'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every ReferenceElement with metadata about their referencing type
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'response');
    });

    // decorate every ResponseElement with metadata about their status code
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isResponseElement).forEach((value, key) => {
      value.setMetaProperty('http-status-code', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__["default"])(key));
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResponsesVisitor);

/***/ }),

/***/ 57481:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _elements_nces_ComponentsSchemas_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6144);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class SchemasVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsSchemas_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Schema'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every ReferenceElement with metadata about their referencing type
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'schema');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemasVisitor);

/***/ }),

/***/ 38939:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _elements_nces_ComponentsSecuritySchemes_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16830);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class SecuritySchemesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsSecuritySchemes_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'SecurityScheme'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'securityScheme');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecuritySchemesVisitor);

/***/ }),

/***/ 55945:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27912);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class ComponentsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Components']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsVisitor);

/***/ }),

/***/ 27253:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(43172);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class ContactVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Contact']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContactVisitor);

/***/ }),

/***/ 85048:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _elements_nces_DiscriminatorMapping_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(87718);





class MappingVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_DiscriminatorMapping_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['value']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MappingVisitor);

/***/ }),

/***/ 56016:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(8652);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class DiscriminatorVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Discriminator']);
    this.canSupportSpecificationExtensions = false;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscriminatorVisitor);

/***/ }),

/***/ 30758:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9999);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);
/* harmony import */ var _elements_nces_EncodingHeaders_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(41499);







class HeadersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_EncodingHeaders_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Header'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every ReferenceElement with metadata about their referencing type
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'header');
    });

    // decorate every HeaderElement with metadata about their name
    this.element.forEach((value, key) => {
      if (!(0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isHeaderElement)(value)) return;
      const headerName = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__["default"])(key);
      value.setMetaProperty('headerName', headerName);
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeadersVisitor);

/***/ }),

/***/ 58666:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9999);
/* harmony import */ var _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(91915);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85536);







class EncodingVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Encoding']);
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every Header with media type metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isObjectElement)(this.element.headers)) {
      this.element.headers.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_6__.isHeaderElement)
      // @ts-ignore
      .forEach((headerElement, key) => {
        headerElement.setMetaProperty('header-name', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__["default"])(key));
      });
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EncodingVisitor);

/***/ }),

/***/ 18087:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4287);

class ExternalValueVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExternalValueVisitor);

/***/ }),

/***/ 15055:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33501);
/* harmony import */ var _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(3758);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);






class ExampleVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Example']);
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // mark this ExampleElement with reference metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(this.element.externalValue)) {
      this.element.classes.push('reference-element');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExampleVisitor);

/***/ }),

/***/ 73905:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(49837);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class ExternalDocumentationVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'ExternalDocumentation']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExternalDocumentationVisitor);

/***/ }),

/***/ 97901:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81299);
/* harmony import */ var _elements_nces_HeaderContent_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10486);


class ContentVisitor extends _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_HeaderContent_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContentVisitor);

/***/ }),

/***/ 43947:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59817);
/* harmony import */ var _elements_nces_HeaderExamples_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(90082);


class ExamplesVisitor extends _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_HeaderExamples_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExamplesVisitor);

/***/ }),

/***/ 48135:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11892);
/* harmony import */ var _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38525);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class SchemaVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.alternator = [{
      predicate: _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__.isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: ramda__WEBPACK_IMPORTED_MODULE_4__["default"],
      specPath: ['document', 'objects', 'Schema']
    }];
  }
  ObjectElement(objectElement) {
    const result = _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.enter.call(this, objectElement);
    if ((0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement)(this.element)) {
      this.element.setMetaProperty('referenced-element', 'schema');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaVisitor);

/***/ }),

/***/ 52730:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19403);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class HeaderVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Header']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderVisitor);

/***/ }),

/***/ 60696:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(54764);




 // eslint-disable-next-line @typescript-eslint/naming-convention
// eslint-disable-next-line @typescript-eslint/naming-convention
class OpenApi3_0Visitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'OpenApi']);
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    return _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenApi3_0Visitor);

/***/ }),

/***/ 93701:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4287);

class VersionVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('api-version');
    this.element.classes.push('version');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (VersionVisitor);

/***/ }),

/***/ 11461:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(14036);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class InfoVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Info']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (InfoVisitor);

/***/ }),

/***/ 16172:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_License_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(98149);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class LicenseVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_License_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'License']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LicenseVisitor);

/***/ }),

/***/ 38125:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4287);

class OperationIdVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationIdVisitor);

/***/ }),

/***/ 7149:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4287);

class OperationRefVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationRefVisitor);

/***/ }),

/***/ 58415:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _elements_nces_LinkParameters_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62732);





class ParametersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_LinkParameters_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['value']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParametersVisitor);

/***/ }),

/***/ 20525:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33501);
/* harmony import */ var _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71020);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);






class LinkVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Link']);
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // mark this LinkElement with reference metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(this.element.operationId) || (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(this.element.operationRef)) {
      this.element.classes.push('reference-element');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkVisitor);

/***/ }),

/***/ 7799:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_nces_MediaTypeEncoding_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(88123);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class EncodingVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_MediaTypeEncoding_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Encoding']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EncodingVisitor);

/***/ }),

/***/ 58109:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59817);
/* harmony import */ var _elements_nces_MediaTypeExamples_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6189);


class ExamplesVisitor extends _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_MediaTypeExamples_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExamplesVisitor);

/***/ }),

/***/ 55533:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11892);
/* harmony import */ var _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38525);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class SchemaVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.alternator = [{
      predicate: _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__.isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: ramda__WEBPACK_IMPORTED_MODULE_4__["default"],
      specPath: ['document', 'objects', 'Schema']
    }];
  }
  ObjectElement(objectElement) {
    const result = _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.enter.call(this, objectElement);
    if ((0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement)(this.element)) {
      this.element.setMetaProperty('referenced-element', 'schema');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaVisitor);

/***/ }),

/***/ 99036:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22452);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class MediaTypeVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'MediaType']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTypeVisitor);

/***/ }),

/***/ 33416:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _elements_nces_OAuthFlowScopes_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(48766);





class ScopesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_OAuthFlowScopes_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['value']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ScopesVisitor);

/***/ }),

/***/ 1463:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(10409);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class OAuthFlowVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'OAuthFlow']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlowVisitor);

/***/ }),

/***/ 85580:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53608);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class OAuthFlowsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'OAuthFlows']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlowsVisitor);

/***/ }),

/***/ 55980:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);
/* harmony import */ var _elements_nces_OperationCallbacks_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60025);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);






class CallbacksVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  specPath;
  constructor(options) {
    super(options);
    this.element = new _elements_nces_OperationCallbacks_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Callback'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'callback');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CallbacksVisitor);

/***/ }),

/***/ 45416:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_nces_OperationParameters_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58335);
/* harmony import */ var _ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14474);


class ParametersVisitor extends _ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_OperationParameters_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParametersVisitor);

/***/ }),

/***/ 65525:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(11892);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85536);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(85013);
/* harmony import */ var _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(38525);




class RequestBodyVisitor extends _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.alternator = [{
      predicate: _predicates_mjs__WEBPACK_IMPORTED_MODULE_1__.isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: ramda__WEBPACK_IMPORTED_MODULE_2__["default"],
      specPath: ['document', 'objects', 'RequestBody']
    }];
  }
  ObjectElement(objectElement) {
    const result = _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].prototype.enter.call(this, objectElement);
    if ((0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_3__.isReferenceElement)(this.element)) {
      this.element.setMetaProperty('referenced-element', 'requestBody');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBodyVisitor);

/***/ }),

/***/ 70678:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68618);
/* harmony import */ var _elements_nces_OperationSecurity_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20673);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91966);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class SecurityVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_OperationSecurity_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isObjectElement)(item) ? ['document', 'objects', 'SecurityRequirement'] : ['value'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecurityVisitor);

/***/ }),

/***/ 65188:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_nces_OperationServers_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84253);
/* harmony import */ var _ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28298);


class ServersVisitor extends _ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_OperationServers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServersVisitor);

/***/ }),

/***/ 24933:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(68618);
/* harmony import */ var _elements_nces_OperationTags_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4236);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4287);



class TagsVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_OperationTags_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
  ArrayElement(arrayElement) {
    this.element = this.element.concat((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.cloneDeep)(arrayElement));
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TagsVisitor);

/***/ }),

/***/ 96278:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(5431);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);





class OperationVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Operation']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationVisitor);

/***/ }),

/***/ 25047:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81299);
/* harmony import */ var _elements_nces_ParameterContent_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41540);


class ContentVisitor extends _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ParameterContent_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContentVisitor);

/***/ }),

/***/ 18117:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59817);
/* harmony import */ var _elements_nces_ParameterExamples_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48792);


class ExamplesVisitor extends _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ParameterExamples_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExamplesVisitor);

/***/ }),

/***/ 83973:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11892);
/* harmony import */ var _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38525);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);






class SchemaVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.alternator = [{
      predicate: _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__.isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: ramda__WEBPACK_IMPORTED_MODULE_4__["default"],
      specPath: ['document', 'objects', 'Schema']
    }];
  }
  ObjectElement(objectElement) {
    const result = _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.enter.call(this, objectElement);
    if ((0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement)(this.element)) {
      this.element.setMetaProperty('referenced-element', 'schema');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaVisitor);

/***/ }),

/***/ 74388:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9999);
/* harmony import */ var _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(37357);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85536);







class ParameterVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Parameter']);
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every MediaTypeElement with media type metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isObjectElement)(this.element.contentProp)) {
      this.element.contentProp.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_6__.isMediaTypeElement)
      // @ts-ignore
      .forEach((mediaTypeElement, key) => {
        mediaTypeElement.setMetaProperty('media-type', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__["default"])(key));
      });
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParameterVisitor);

/***/ }),

/***/ 98745:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4287);

class $RefVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($RefVisitor);

/***/ }),

/***/ 21508:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_nces_PathItemParameters_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(49932);
/* harmony import */ var _ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14474);


class ParametersVisitor extends _ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_PathItemParameters_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParametersVisitor);

/***/ }),

/***/ 83088:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_nces_PathItemServers_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(60748);
/* harmony import */ var _ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28298);


class ServersVisitor extends _ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_PathItemServers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServersVisitor);

/***/ }),

/***/ 80322:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(87024);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9999);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(33501);
/* harmony import */ var _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(41740);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);







class PathItemVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'PathItem']);
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate Operation elements with HTTP method
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isOperationElement)
    // @ts-ignore
    .forEach((operationElement, httpMethodElementCI) => {
      const httpMethodElementCS = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.cloneDeep)(httpMethodElementCI);
      httpMethodElementCS.content = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__["default"])(httpMethodElementCS).toUpperCase();
      operationElement.setMetaProperty('http-method', httpMethodElementCS);
    });

    // mark this PathItemElement with reference metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__.isStringElement)(this.element.$ref)) {
      this.element.classes.push('reference-element');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathItemVisitor);

/***/ }),

/***/ 8305:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11892);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(87024);
/* harmony import */ var _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12832);
/* harmony import */ var _generics_PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10810);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85536);







class PathsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'PathItem']);
    this.canSupportSpecificationExtensions = true;
    this.fieldPatternPredicate = ramda__WEBPACK_IMPORTED_MODULE_5__["default"];
  }
  ObjectElement(objectElement) {
    const result = _generics_PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every PathItemElement with path metadata
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_6__.isPathItemElement)
    // @ts-ignore
    .forEach((pathItemElement, key) => {
      key.classes.push('openapi-path-template');
      key.classes.push('path-template');
      pathItemElement.setMetaProperty('path', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__.cloneDeep)(key));
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathsVisitor);

/***/ }),

/***/ 83229:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4287);

class $RefVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($RefVisitor);

/***/ }),

/***/ 48318:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33501);
/* harmony import */ var _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27695);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);






class ReferenceVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Reference']);
    this.canSupportSpecificationExtensions = false;
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // mark this ReferenceElement with reference metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(this.element.$ref)) {
      this.element.classes.push('reference-element');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReferenceVisitor);

/***/ }),

/***/ 78316:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_nces_RequestBodyContent_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80978);
/* harmony import */ var _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81299);


class ContentVisitor extends _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_RequestBodyContent_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContentVisitor);

/***/ }),

/***/ 34181:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(33501);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9999);
/* harmony import */ var _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(88767);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83671);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(85536);







class RequestBodyVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'RequestBody']);
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every MediaTypeElement with media type metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isObjectElement)(this.element.contentProp)) {
      this.element.contentProp.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_6__.isMediaTypeElement)
      // @ts-ignore
      .forEach((mediaTypeElement, key) => {
        mediaTypeElement.setMetaProperty('media-type', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__["default"])(key));
      });
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBodyVisitor);

/***/ }),

/***/ 3231:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_nces_ResponseContent_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98540);
/* harmony import */ var _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81299);


class ContentVisitor extends _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ResponseContent_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContentVisitor);

/***/ }),

/***/ 24016:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9999);
/* harmony import */ var _elements_nces_ResponseHeaders_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(20065);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(93774);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4287);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85013);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(85536);







class HeadersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ResponseHeaders_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objec