(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["SwaggerClient"] = factory();
	else
		root["SwaggerClient"] = factory();
})(window, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 14:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18499);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24445);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(67924);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34610);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(43319);
/* harmony import */ var _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(95573);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(62287);





/**
 * This is a base Type for every visitor that does
 * internal look-ups to retrieve other child visitors.
 * @public
 */
/**
 * @public
 */
class SpecificationVisitor extends _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  specObj;
  passingOptionsNames = ['specObj', 'parent'];
  constructor({
    specObj,
    ...rest
  }) {
    super({
      ...rest
    });
    this.specObj = specObj;
  }
  retrievePassingOptions() {
    return (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(this.passingOptionsNames, this);
  }
  retrieveFixedFields(specPath) {
    const fixedFields = (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['visitors', ...specPath, 'fixedFields'], this.specObj);
    if (typeof fixedFields === 'object' && fixedFields !== null) {
      return Object.keys(fixedFields);
    }
    return [];
  }
  retrieveVisitor(specPath) {
    if ((0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"], ['visitors', ...specPath], this.specObj)) {
      return (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['visitors', ...specPath], this.specObj);
    }
    return (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['visitors', ...specPath, '$visitor'], this.specObj);
  }
  retrieveVisitorInstance(specPath, options = {}) {
    const passingOpts = this.retrievePassingOptions();
    const VisitorClz = this.retrieveVisitor(specPath);
    const visitorOpts = {
      ...passingOpts,
      ...options
    };
    return new VisitorClz(visitorOpts);
  }
  toRefractedElement(specPath, element, options = {}) {
    /**
     * This is `Visitor shortcut`: mechanism for short-circuiting the traversal and replacing
     * it by basic node cloning.
     *
     * Visiting the element is equivalent to cloning it  if the prototype of a visitor
     * is the same as the prototype of FallbackVisitor. If that's the case, we can avoid
     * bootstrapping the traversal cycle for fields that don't require any special visiting.
     */
    const visitor = this.retrieveVisitorInstance(specPath, options);
    if (visitor instanceof _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"] && (visitor === null || visitor === void 0 ? void 0 : visitor.constructor) === _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]) {
      return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.cloneDeep)(element);
    }
    (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__.visit)(element, visitor, options);
    return visitor.element;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SpecificationVisitor);

/***/ }),

/***/ 210:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class Encoding extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.EncodingElement {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Encoding);

/***/ }),

/***/ 291:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(28276);
/* harmony import */ var _isRegExp_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(66127);
/* harmony import */ var _escapeRegExp_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(49408);



var checkArguments = function checkArguments(searchValue, replaceValue, str) {
  if (str == null || searchValue == null || replaceValue == null) {
    throw TypeError('Input values must not be `null` or `undefined`');
  }
};
var checkValue = function checkValue(value, valueName) {
  if (typeof value !== 'string') {
    if (!(value instanceof String)) {
      throw TypeError("`".concat(valueName, "` must be a string"));
    }
  }
};
var checkSearchValue = function checkSearchValue(searchValue) {
  if (typeof searchValue !== 'string' && !(searchValue instanceof String) && !(searchValue instanceof RegExp)) {
    throw TypeError('`searchValue` must be a string or an regexp');
  }
};
var replaceAll = function replaceAll(searchValue, replaceValue, str) {
  checkArguments(searchValue, replaceValue, str);
  checkValue(str, 'str');
  checkValue(replaceValue, 'replaceValue');
  checkSearchValue(searchValue);
  var regexp = new RegExp((0,_isRegExp_js__WEBPACK_IMPORTED_MODULE_0__["default"])(searchValue) ? searchValue : (0,_escapeRegExp_js__WEBPACK_IMPORTED_MODULE_1__["default"])(searchValue), 'g');
  return (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(regexp, replaceValue, str);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (replaceAll);

/***/ }),

/***/ 371:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11892);
/* harmony import */ var _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84193);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39633);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9748);






/**
 * @public
 */
/**
 * @public
 */
class SchemaVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.alternator = [{
      predicate: _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__.isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: ramda__WEBPACK_IMPORTED_MODULE_4__["default"],
      specPath: ['document', 'objects', 'Schema']
    }];
  }
  ObjectElement(objectElement) {
    const result = _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.enter.call(this, objectElement);
    if ((0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement)(this.element)) {
      this.element.setMetaProperty('referenced-element', 'schema');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaVisitor);

/***/ }),

/***/ 498:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class Security extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'security';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(Security.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Security);

/***/ }),

/***/ 526:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3579);
/* harmony import */ var _internal_reduced_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30259);



/**
 * Returns a value wrapped to indicate that it is the final value of the reduce
 * and transduce functions. The returned value should be considered a black
 * box: the internal structure is not guaranteed to be stable.
 *
 * This optimization is available to the below functions:
 * - [`reduce`](#reduce)
 * - [`reduceWhile`](#reduceWhile)
 * - [`reduceBy`](#reduceBy)
 * - [`reduceRight`](#reduceRight)
 * - [`transduce`](#transduce)
 *
 * @func
 * @memberOf R
 * @since v0.15.0
 * @category List
 * @sig a -> *
 * @param {*} x The final value of the reduce.
 * @return {*} The wrapped value.
 * @see R.reduce, R.reduceWhile, R.reduceBy, R.reduceRight, R.transduce
 * @example
 *
 *     R.reduce(
 *       (acc, item) => item > 3 ? R.reduced(acc) : acc.concat(item),
 *       [],
 *       [1, 2, 3, 4, 5]) // [1, 2, 3]
 */
var reduced = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_internal_reduced_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (reduced);

/***/ }),

/***/ 545:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class Example extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.ExampleElement {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Example);

/***/ }),

/***/ 636:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35731);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(97618);
/* harmony import */ var _helpers_fetch_polyfill_node_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29641);
/* harmony import */ var _helpers_abortcontroller_polyfill_node_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34399);
/* harmony import */ var _http_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(51670);




class HTTPResolverSwaggerClient extends _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_3__["default"] {
  swaggerHTTPClient = _http_index_js__WEBPACK_IMPORTED_MODULE_2__["default"];
  swaggerHTTPClientConfig;
  constructor({
    swaggerHTTPClient = _http_index_js__WEBPACK_IMPORTED_MODULE_2__["default"],
    swaggerHTTPClientConfig = {},
    ...rest
  } = {}) {
    super({
      ...rest,
      name: 'http-swagger-client'
    });
    this.swaggerHTTPClient = swaggerHTTPClient;
    this.swaggerHTTPClientConfig = swaggerHTTPClientConfig;
  }
  getHttpClient() {
    return this.swaggerHTTPClient;
  }
  async read(file) {
    const client = this.getHttpClient();
    const controller = new AbortController();
    const {
      signal
    } = controller;
    const timeoutID = setTimeout(() => {
      controller.abort();
    }, this.timeout);
    const credentials = this.getHttpClient().withCredentials || this.withCredentials ? 'include' : 'same-origin';
    const redirect = this.redirects === 0 ? 'error' : 'follow';
    const follow = this.redirects > 0 ? this.redirects : undefined;
    try {
      const response = await client({
        url: file.uri,
        signal,
        userFetch: async (resource, options) => {
          let res = await fetch(resource, options);
          try {
            // undici supports mutations
            res.headers.delete('Content-Type');
          } catch {
            // Fetch API has guards which prevent mutations
            res = new Response(res.body, {
              ...res,
              headers: new Headers(res.headers)
            });
            res.headers.delete('Content-Type');
          }
          return res;
        },
        credentials,
        redirect,
        follow,
        ...this.swaggerHTTPClientConfig
      });
      return response.text.arrayBuffer();
    } catch (error) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_4__["default"](`Error downloading "${file.uri}"`, {
        cause: error
      });
    } finally {
      clearTimeout(timeoutID);
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HTTPResolverSwaggerClient);

/***/ }),

/***/ 659:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(51873);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var nativeObjectToString = objectProto.toString;

/** Built-in value references. */
var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

/**
 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the raw `toStringTag`.
 */
function getRawTag(value) {
  var isOwn = hasOwnProperty.call(value, symToStringTag),
      tag = value[symToStringTag];

  try {
    value[symToStringTag] = undefined;
    var unmasked = true;
  } catch (e) {}

  var result = nativeObjectToString.call(value);
  if (unmasked) {
    if (isOwn) {
      value[symToStringTag] = tag;
    } else {
      delete value[symToStringTag];
    }
  }
  return result;
}

module.exports = getRawTag;


/***/ }),

/***/ 694:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// TODO: remove from `core-js@4`
__webpack_require__(91599);

var parent = __webpack_require__(37257);
__webpack_require__(12560);

module.exports = parent;


/***/ }),

/***/ 730:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   clearCache: () => (/* reexport safe */ _generic_index_js__WEBPACK_IMPORTED_MODULE_1__.clearCache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(40278);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12757);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50918);
/* harmony import */ var _generic_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52398);




const openApi30Strategy = {
  name: 'openapi-3-0',
  match(spec) {
    return (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__.isOpenAPI30)(spec);
  },
  normalize(spec) {
    const {
      spec: normalized
    } = (0,_normalize_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      spec
    });
    return normalized;
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi30Strategy);

/***/ }),

/***/ 844:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseLicenseVisitor: () => (/* binding */ BaseLicenseVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_License_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50406);


/**
 * @public
 */
const BaseLicenseVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.License.$visitor;
/**
 * @public
 */
class LicenseVisitor extends BaseLicenseVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_License_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LicenseVisitor);

/***/ }),

/***/ 954:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2173);


/**
 * Removes the sub-list of `list` starting at index `start` and containing
 * `count` elements. _Note that this is not destructive_: it returns a copy of
 * the list with the changes.
 * <small>No lists have been harmed in the application of this function.</small>
 *
 * @func
 * @memberOf R
 * @since v0.2.2
 * @category List
 * @sig Number -> Number -> [a] -> [a]
 * @param {Number} start The position to start removing elements
 * @param {Number} count The number of elements to remove
 * @param {Array} list The list to remove from
 * @return {Array} A new Array with `count` elements from `start` removed.
 * @see R.without
 * @example
 *
 *      R.remove(2, 3, [1,2,3,4,5,6,7,8]); //=> [1,2,6,7,8]
 */
var remove = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function remove(start, count, list) {
  var result = Array.prototype.slice.call(list, 0);
  result.splice(start, count);
  return result;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (remove);

/***/ }),

/***/ 1185:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11892);
/* harmony import */ var _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84193);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(39633);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9748);






/**
 * @public
 */
/**
 * @public
 */
class SchemaVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.alternator = [{
      predicate: _predicates_mjs__WEBPACK_IMPORTED_MODULE_3__.isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: ramda__WEBPACK_IMPORTED_MODULE_4__["default"],
      specPath: ['document', 'objects', 'Schema']
    }];
  }
  ObjectElement(objectElement) {
    const result = _generics_AlternatingVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.enter.call(this, objectElement);
    if ((0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement)(this.element)) {
      this.element.setMetaProperty('referenced-element', 'schema');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaVisitor);

/***/ }),

/***/ 1322:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3579);


/**
 * Gives a single-word string description of the (native) type of a value,
 * returning such answers as 'Object', 'Number', 'Array', or 'Null'. Does not
 * attempt to distinguish user Object types any further, reporting them all as
 * 'Object'.
 *
 * @func
 * @memberOf R
 * @since v0.8.0
 * @category Type
 * @sig * -> String
 * @param {*} val The value to test
 * @return {String}
 * @example
 *
 *      R.type({}); //=> "Object"
 *      R.type(1); //=> "Number"
 *      R.type(false); //=> "Boolean"
 *      R.type('s'); //=> "String"
 *      R.type(null); //=> "Null"
 *      R.type([]); //=> "Array"
 *      R.type(/[A-z]/); //=> "RegExp"
 *      R.type(() => {}); //=> "Function"
 *      R.type(async () => {}); //=> "AsyncFunction"
 *      R.type(undefined); //=> "Undefined"
 *      R.type(BigInt(123)); //=> "BigInt"
 */
var type = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function type(val) {
  return val === null ? 'Null' : val === undefined ? 'Undefined' : Object.prototype.toString.call(val).slice(8, -1);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (type);

/***/ }),

/***/ 1413:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_6__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(57270);
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(76708);


/**
 * @public
 */
class JSONSchemaVisitor extends _swagger_api_apidom_ns_json_schema_draft_6__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }

  // eslint-disable-next-line class-methods-use-this
  get defaultDialectIdentifier() {
    return 'http://json-schema.org/draft-07/schema#';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONSchemaVisitor);

/***/ }),

/***/ 1650:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(23557);
/* harmony import */ var _util_url_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(96664);
/* harmony import */ var _File_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(38396);
/* harmony import */ var _util_plugins_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17955);
/* harmony import */ var _errors_ParseError_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(58155);
/* harmony import */ var _errors_UnmatchedResolverError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(12207);
/* harmony import */ var _resolve_util_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(84494);







/**
 * Parses the given file's contents, using the configured parser plugins.
 */
const parseFile = async (file, options) => {
  const optsBoundParsers = options.parse.parsers.map(parser => {
    const clonedParser = Object.create(parser);
    return Object.assign(clonedParser, options.parse.parserOpts);
  });
  const parsers = await _util_plugins_mjs__WEBPACK_IMPORTED_MODULE_0__.filter('canParse', [file, options], optsBoundParsers);

  // we couldn't find any parser for this File
  if ((0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(parsers)) {
    throw new _errors_UnmatchedResolverError_mjs__WEBPACK_IMPORTED_MODULE_2__["default"](file.uri);
  }
  try {
    const {
      plugin,
      result
    } = await _util_plugins_mjs__WEBPACK_IMPORTED_MODULE_0__.run('parse', [file, options], parsers);

    // empty files handling
    if (!plugin.allowEmpty && result.isEmpty) {
      return Promise.reject(new _errors_ParseError_mjs__WEBPACK_IMPORTED_MODULE_3__["default"](`Error while parsing file "${file.uri}". File is empty.`));
    }
    return result;
  } catch (error) {
    throw new _errors_ParseError_mjs__WEBPACK_IMPORTED_MODULE_3__["default"](`Error while parsing file "${file.uri}"`, {
      cause: error
    });
  }
};

/**
 * Parses a file into ApiDOM.
 */
const parse = async (uri, options) => {
  /**
   * If the path is a filesystem path, then convert it to a URL.
   *
   * NOTE: According to the JSON Reference spec, these should already be URLs,
   * but, in practice, many people use local filesystem paths instead.
   * So we're being generous here and doing the conversion automatically.
   * This is not intended to be a 100% bulletproof solution.
   * If it doesn't work for your use-case, then use a URL instead.
   */
  const file = new _File_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]({
    uri: _util_url_mjs__WEBPACK_IMPORTED_MODULE_5__.sanitize(_util_url_mjs__WEBPACK_IMPORTED_MODULE_5__.stripHash(uri)),
    mediaType: options.parse.mediaType
  });
  const data = await (0,_resolve_util_mjs__WEBPACK_IMPORTED_MODULE_6__.readFile)(file, options);
  return parseFile(new _File_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]({
    ...file,
    data
  }), options);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parse);

/***/ }),

/***/ 1679:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25845);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11182);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1322);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85883);


/**
 * Checks if input value is `String`.
 *
 * @func isString
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.4.0|v0.4.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotString|isNotString}
 * @example
 *
 * RA.isString('abc'); //=> true
 * RA.isString(1); //=> false
 */
var isString = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(1, (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(ramda__WEBPACK_IMPORTED_MODULE_2__["default"], (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])('String')));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isString);

/***/ }),

/***/ 1704:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SpecMap: () => (/* binding */ SpecMap),
/* harmony export */   "default": () => (/* binding */ mapSpec),
/* harmony export */   plugins: () => (/* binding */ plugins)
/* harmony export */ });
/* harmony import */ var _lib_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10692);
/* harmony import */ var _lib_refs_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(65084);
/* harmony import */ var _lib_all_of_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(48301);
/* harmony import */ var _lib_parameters_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34438);
/* harmony import */ var _lib_properties_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(67783);
/* harmony import */ var _lib_context_tree_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(21664);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(3832);







const PLUGIN_DISPATCH_LIMIT = 100;
const noop = () => {};
class SpecMap {
  static getPluginName(plugin) {
    return plugin.pluginName;
  }
  static getPatchesOfType(patches, fn) {
    return patches.filter(fn);
  }
  constructor(opts) {
    Object.assign(this, {
      spec: '',
      debugLevel: 'info',
      plugins: [],
      pluginHistory: {},
      errors: [],
      mutations: [],
      promisedPatches: [],
      state: {},
      patches: [],
      context: {},
      contextTree: new _lib_context_tree_js__WEBPACK_IMPORTED_MODULE_6__["default"](),
      showDebug: false,
      allPatches: [],
      // only populated if showDebug is true
      pluginProp: 'specMap',
      libMethods: Object.assign(Object.create(this), _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"], {
        getInstance: () => this
      }),
      allowMetaPatches: false
    }, opts);

    // Lib methods bound
    this.get = this._get.bind(this); // eslint-disable-line no-underscore-dangle
    this.getContext = this._getContext.bind(this); // eslint-disable-line no-underscore-dangle
    this.hasRun = this._hasRun.bind(this); // eslint-disable-line no-underscore-dangle

    this.wrappedPlugins = this.plugins.map(this.wrapPlugin.bind(this)).filter(_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isFunction);

    // Initial patch(s)
    this.patches.push(_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].add([], this.spec));
    this.patches.push(_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].context([], this.context));
    this.updatePatches(this.patches);
  }
  debug(level, ...args) {
    if (this.debugLevel === level) {
      console.log(...args); // eslint-disable-line no-console
    }
  }
  verbose(header, ...args) {
    if (this.debugLevel === 'verbose') {
      console.log(`[${header}]   `, ...args); // eslint-disable-line no-console
    }
  }
  wrapPlugin(plugin, name) {
    const {
      pathDiscriminator
    } = this;
    let ctx = null;
    let fn;
    if (plugin[this.pluginProp]) {
      ctx = plugin;
      fn = plugin[this.pluginProp];
    } else if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isFunction(plugin)) {
      fn = plugin;
    } else if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isObject(plugin)) {
      fn = createKeyBasedPlugin(plugin);
    }
    return Object.assign(fn.bind(ctx), {
      pluginName: plugin.name || name,
      isGenerator: _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isGenerator(fn)
    });

    // Expected plugin interface: {key: string, plugin: fn*}
    // This traverses depth-first and immediately applies yielded patches.
    // This strategy should work well for most plugins (including the built-ins).
    // We might consider making this (traversing & application) configurable later.
    function createKeyBasedPlugin(pluginObj) {
      const isSubPath = (path, tested) => {
        if (!Array.isArray(path)) {
          return true;
        }
        return path.every((val, i) => val === tested[i]);
      };
      return function* generator(patches, specmap) {
        const refCache = {};

        // eslint-disable-next-line no-restricted-syntax
        for (const [i, patch] of patches.filter(_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isAdditiveMutation).entries()) {
          if (i < _constants_js__WEBPACK_IMPORTED_MODULE_5__.TRAVERSE_LIMIT) {
            yield* traverse(patch.value, patch.path, patch);
          } else {
            return;
          }
        }
        function* traverse(obj, path, patch) {
          if (!_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isObject(obj)) {
            if (pluginObj.key === path[path.length - 1]) {
              yield pluginObj.plugin(obj, pluginObj.key, path, specmap);
            }
          } else {
            const parentIndex = path.length - 1;
            const parent = path[parentIndex];
            const indexOfFirstProperties = path.indexOf('properties');
            const isRootProperties = parent === 'properties' && parentIndex === indexOfFirstProperties;
            const traversed = specmap.allowMetaPatches && refCache[obj.$$ref];

            // eslint-disable-next-line no-restricted-syntax
            for (const key of Object.keys(obj)) {
              const val = obj[key];
              const updatedPath = path.concat(key);
              const isObj = _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isObject(val);
              const objRef = obj.$$ref;
              if (!traversed) {
                if (isObj) {
                  // Only store the ref if it exists
                  if (specmap.allowMetaPatches && objRef && isSubPath(pathDiscriminator, updatedPath)) {
                    refCache[objRef] = true;
                  }
                  yield* traverse(val, updatedPath, patch);
                }
              }
              if (!isRootProperties && key === pluginObj.key) {
                const isWithinPathDiscriminator = isSubPath(pathDiscriminator, path);
                if (!pathDiscriminator || isWithinPathDiscriminator) {
                  yield pluginObj.plugin(val, key, updatedPath, specmap, patch);
                }
              }
            }
          }
        }
      };
    }
  }
  nextPlugin() {
    return this.wrappedPlugins.find(plugin => {
      const mutations = this.getMutationsForPlugin(plugin);
      return mutations.length > 0;
    });
  }
  nextPromisedPatch() {
    if (this.promisedPatches.length > 0) {
      return Promise.race(this.promisedPatches.map(patch => patch.value));
    }
    return undefined;
  }
  getPluginHistory(plugin) {
    const name = this.constructor.getPluginName(plugin);
    return this.pluginHistory[name] || [];
  }
  getPluginRunCount(plugin) {
    return this.getPluginHistory(plugin).length;
  }
  getPluginHistoryTip(plugin) {
    const history = this.getPluginHistory(plugin);
    const val = history && history[history.length - 1];
    return val || {};
  }
  getPluginMutationIndex(plugin) {
    const mi = this.getPluginHistoryTip(plugin).mutationIndex;
    return typeof mi !== 'number' ? -1 : mi;
  }
  updatePluginHistory(plugin, val) {
    const name = this.constructor.getPluginName(plugin);
    this.pluginHistory[name] = this.pluginHistory[name] || [];
    this.pluginHistory[name].push(val);
  }
  updatePatches(patches) {
    _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].normalizeArray(patches).forEach(patch => {
      if (patch instanceof Error) {
        this.errors.push(patch);
        return;
      }
      try {
        if (!_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isObject(patch)) {
          this.debug('updatePatches', 'Got a non-object patch', patch);
          return;
        }
        if (this.showDebug) {
          this.allPatches.push(patch);
        }
        if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isPromise(patch.value)) {
          this.promisedPatches.push(patch);
          this.promisedPatchThen(patch);
          return;
        }
        if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isContextPatch(patch)) {
          this.setContext(patch.path, patch.value);
          return;
        }
        if (_lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].isMutation(patch)) {
          this.updateMutations(patch);
        }
      } catch (e) {
        console.error(e); // eslint-disable-line no-console
        this.errors.push(e);
      }
    });
  }
  updateMutations(patch) {
    if (typeof patch.value === 'object' && !Array.isArray(patch.value) && this.allowMetaPatches) {
      patch.value = {
        ...patch.value
      };
    }
    const result = _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].applyPatch(this.state, patch, {
      allowMetaPatches: this.allowMetaPatches
    });
    if (result) {
      this.mutations.push(patch);
      this.state = result;
    }
  }
  removePromisedPatch(patch) {
    const index = this.promisedPatches.indexOf(patch);
    if (index < 0) {
      this.debug("Tried to remove a promisedPatch that isn't there!");
      return;
    }
    this.promisedPatches.splice(index, 1);
  }
  promisedPatchThen(patch) {
    patch.value = patch.value.then(val => {
      const promisedPatch = {
        ...patch,
        value: val
      };
      this.removePromisedPatch(patch);
      this.updatePatches(promisedPatch);
    }).catch(e => {
      this.removePromisedPatch(patch);
      this.updatePatches(e);
    });
    return patch.value;
  }
  getMutations(from, to) {
    from = from || 0;
    if (typeof to !== 'number') {
      to = this.mutations.length;
    }
    return this.mutations.slice(from, to);
  }
  getCurrentMutations() {
    return this.getMutationsForPlugin(this.getCurrentPlugin());
  }
  getMutationsForPlugin(plugin) {
    const tip = this.getPluginMutationIndex(plugin);
    return this.getMutations(tip + 1);
  }
  getCurrentPlugin() {
    return this.currentPlugin;
  }
  getLib() {
    return this.libMethods;
  }

  // eslint-disable-next-line no-underscore-dangle
  _get(path) {
    return _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].getIn(this.state, path);
  }

  // eslint-disable-next-line no-underscore-dangle
  _getContext(path) {
    return this.contextTree.get(path);
  }
  setContext(path, value) {
    return this.contextTree.set(path, value);
  }

  // eslint-disable-next-line no-underscore-dangle
  _hasRun(count) {
    const times = this.getPluginRunCount(this.getCurrentPlugin());
    return times > (count || 0);
  }
  dispatch() {
    const that = this;
    const plugin = this.nextPlugin();
    if (!plugin) {
      const nextPromise = this.nextPromisedPatch();
      if (nextPromise) {
        return nextPromise.then(() => this.dispatch()).catch(() => this.dispatch());
      }

      // We're done!
      const result = {
        spec: this.state,
        errors: this.errors
      };
      if (this.showDebug) {
        result.patches = this.allPatches;
      }
      return Promise.resolve(result);
    }

    // Makes sure plugin isn't running an endless loop
    that.pluginCount = that.pluginCount || new WeakMap();
    that.pluginCount.set(plugin, (that.pluginCount.get(plugin) || 0) + 1);
    if (that.pluginCount[plugin] > PLUGIN_DISPATCH_LIMIT) {
      return Promise.resolve({
        spec: that.state,
        errors: that.errors.concat(new Error(`We've reached a hard limit of ${PLUGIN_DISPATCH_LIMIT} plugin runs`))
      });
    }

    // A different plugin runs, wait for all promises to resolve, then retry
    if (plugin !== this.currentPlugin && this.promisedPatches.length) {
      const promises = this.promisedPatches.map(p => p.value);

      // Waits for all to settle instead of Promise.all which stops on rejection
      return Promise.all(promises.map(promise => promise.then(noop, noop))).then(() => this.dispatch());
    }

    // Ok, run the plugin
    return executePlugin();
    function executePlugin() {
      that.currentPlugin = plugin;
      const mutations = that.getCurrentMutations();
      const lastMutationIndex = that.mutations.length - 1;
      try {
        if (plugin.isGenerator) {
          // eslint-disable-next-line no-restricted-syntax
          for (const yieldedPatches of plugin(mutations, that.getLib())) {
            updatePatches(yieldedPatches);
          }
        } else {
          const newPatches = plugin(mutations, that.getLib());
          updatePatches(newPatches);
        }
      } catch (e) {
        console.error(e); // eslint-disable-line no-console
        updatePatches([Object.assign(Object.create(e), {
          plugin
        })]);
      } finally {
        that.updatePluginHistory(plugin, {
          mutationIndex: lastMutationIndex
        });
      }
      return that.dispatch();
    }
    function updatePatches(patches) {
      if (patches) {
        patches = _lib_index_js__WEBPACK_IMPORTED_MODULE_0__["default"].fullyNormalizeArray(patches);
        that.updatePatches(patches, plugin);
      }
    }
  }
}
function mapSpec(opts) {
  return new SpecMap(opts).dispatch();
}
const plugins = {
  refs: _lib_refs_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  allOf: _lib_all_of_js__WEBPACK_IMPORTED_MODULE_2__["default"],
  parameters: _lib_parameters_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  properties: _lib_properties_js__WEBPACK_IMPORTED_MODULE_4__["default"]
};


/***/ }),

/***/ 1824:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BundleError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41412);

/**
 * @public
 */
class UnmatchedBundleStrategyError extends _BundleError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UnmatchedBundleStrategyError);

/***/ }),

/***/ 1843:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class RequestBody extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'requestBody';
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get contentProp() {
    return this.get('content');
  }
  set contentProp(content) {
    this.set('content', content);
  }
  get required() {
    if (this.hasKey('required')) {
      return this.get('required');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set required(required) {
    this.set('required', required);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBody);

/***/ }),

/***/ 1882:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(72552),
    isObject = __webpack_require__(23805);

/** `Object#toString` result references. */
var asyncTag = '[object AsyncFunction]',
    funcTag = '[object Function]',
    genTag = '[object GeneratorFunction]',
    proxyTag = '[object Proxy]';

/**
 * Checks if `value` is classified as a `Function` object.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
 * @example
 *
 * _.isFunction(_);
 * // => true
 *
 * _.isFunction(/abc/);
 * // => false
 */
function isFunction(value) {
  if (!isObject(value)) {
    return false;
  }
  // The use of `Object#toString` avoids issues with the `typeof` operator
  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  var tag = baseGetTag(value);
  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}

module.exports = isFunction;


/***/ }),

/***/ 1907:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var NATIVE_BIND = __webpack_require__(41505);

var FunctionPrototype = Function.prototype;
var call = FunctionPrototype.call;
var uncurryThisWithBind = NATIVE_BIND && FunctionPrototype.bind.bind(call, call);

module.exports = NATIVE_BIND ? uncurryThisWithBind : function (fn) {
  return function () {
    return call.apply(fn, arguments);
  };
};


/***/ }),

/***/ 1908:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AnnotationElement: () => (/* reexport safe */ _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   ArrayElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement),
/* harmony export */   BooleanElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement),
/* harmony export */   CommentElement: () => (/* reexport safe */ _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   LinkElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement),
/* harmony export */   NullElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.NullElement),
/* harmony export */   NumberElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement),
/* harmony export */   ObjectElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement),
/* harmony export */   ParseResultElement: () => (/* reexport safe */ _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   RefElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.RefElement),
/* harmony export */   SourceMapElement: () => (/* reexport safe */ _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   StringElement: () => (/* reexport safe */ minim__WEBPACK_IMPORTED_MODULE_0__.StringElement)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5443);
/* harmony import */ var _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6127);
/* harmony import */ var _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59110);
/* harmony import */ var _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(36863);
/* harmony import */ var _index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5869);






minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement);
minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement);
minim__WEBPACK_IMPORTED_MODULE_0__.StringElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.StringElement);
minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement);
minim__WEBPACK_IMPORTED_MODULE_0__.NullElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.NullElement);
minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement);
minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement);
minim__WEBPACK_IMPORTED_MODULE_0__.RefElement.refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(minim__WEBPACK_IMPORTED_MODULE_0__.RefElement);
_elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]);
_elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]);
_elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]);
_elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(_elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]);


/***/ }),

/***/ 2086:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7386);
/* harmony import */ var _visitors_open_api_3_0_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(46204);
/* harmony import */ var _visitors_open_api_3_0_OpenapiVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35538);
/* harmony import */ var _visitors_SpecificationExtensionVisitor_mjs__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__(10835);
/* harmony import */ var _visitors_open_api_3_0_info_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(98145);
/* harmony import */ var _visitors_open_api_3_0_info_VersionVisitor_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(62633);
/* harmony import */ var _visitors_open_api_3_0_contact_index_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(23441);
/* harmony import */ var _visitors_open_api_3_0_license_index_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(26344);
/* harmony import */ var _visitors_open_api_3_0_link_index_mjs__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(22753);
/* harmony import */ var _visitors_open_api_3_0_link_OperationRefVisitor_mjs__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(14441);
/* harmony import */ var _visitors_open_api_3_0_link_OperationIdVisitor_mjs__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(49753);
/* harmony import */ var _visitors_open_api_3_0_link_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(6915);
/* harmony import */ var _visitors_open_api_3_0_server_index_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(33680);
/* harmony import */ var _visitors_open_api_3_0_server_UrlVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(75739);
/* harmony import */ var _visitors_open_api_3_0_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(17198);
/* harmony import */ var _visitors_open_api_3_0_server_variable_index_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(26303);
/* harmony import */ var _visitors_open_api_3_0_server_VariablesVisitor_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(83759);
/* harmony import */ var _visitors_FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5051);
/* harmony import */ var _visitors_open_api_3_0_media_type_index_mjs__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(98896);
/* harmony import */ var _visitors_open_api_3_0_media_type_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(98273);
/* harmony import */ var _visitors_open_api_3_0_media_type_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(10033);
/* harmony import */ var _visitors_open_api_3_0_media_type_EncodingVisitor_mjs__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(41531);
/* harmony import */ var _visitors_open_api_3_0_security_requirement_index_mjs__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__(56861);
/* harmony import */ var _visitors_open_api_3_0_SecurityVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(25708);
/* harmony import */ var _visitors_open_api_3_0_components_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(69301);
/* harmony import */ var _visitors_open_api_3_0_tag_index_mjs__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(6817);
/* harmony import */ var _visitors_open_api_3_0_reference_index_mjs__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(35706);
/* harmony import */ var _visitors_open_api_3_0_reference_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(3985);
/* harmony import */ var _visitors_open_api_3_0_parameter_index_mjs__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(21936);
/* harmony import */ var _visitors_open_api_3_0_parameter_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(1185);
/* harmony import */ var _visitors_open_api_3_0_header_index_mjs__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(4982);
/* harmony import */ var _visitors_open_api_3_0_header_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(371);
/* harmony import */ var _visitors_open_api_3_0_header_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(21111);
/* harmony import */ var _visitors_open_api_3_0_header_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(23425);
/* harmony import */ var _visitors_open_api_3_0_schema_index_mjs__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(21672);
/* harmony import */ var _visitors_open_api_3_0_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(58144);
/* harmony import */ var _visitors_open_api_3_0_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(97889);
/* harmony import */ var _visitors_open_api_3_0_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(82475);
/* harmony import */ var _visitors_open_api_3_0_schema_ItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(58238);
/* harmony import */ var _visitors_open_api_3_0_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(3223);
/* harmony import */ var _visitors_open_api_3_0_schema_TypeVisitor_mjs__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(4922);
/* harmony import */ var _visitors_open_api_3_0_schema_SchemaOrReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(69957);
/* harmony import */ var _visitors_open_api_3_0_distriminator_index_mjs__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(18556);
/* harmony import */ var _visitors_open_api_3_0_distriminator_MappingVisitor_mjs__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(4196);
/* harmony import */ var _visitors_open_api_3_0_xml_index_mjs__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(74130);
/* harmony import */ var _visitors_open_api_3_0_parameter_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(95313);
/* harmony import */ var _visitors_open_api_3_0_parameter_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(90283);
/* harmony import */ var _visitors_open_api_3_0_components_SchemasVisitor_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(71789);
/* harmony import */ var _visitors_open_api_3_0_components_ResponsesVisitor_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(12569);
/* harmony import */ var _visitors_open_api_3_0_components_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(8839);
/* harmony import */ var _visitors_open_api_3_0_components_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(67632);
/* harmony import */ var _visitors_open_api_3_0_components_RequestBodiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(33908);
/* harmony import */ var _visitors_open_api_3_0_components_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(92655);
/* harmony import */ var _visitors_open_api_3_0_components_SecuritySchemesVisitor_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(84335);
/* harmony import */ var _visitors_open_api_3_0_components_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(76324);
/* harmony import */ var _visitors_open_api_3_0_components_CallbacksVisitor_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(72629);
/* harmony import */ var _visitors_open_api_3_0_example_index_mjs__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(74379);
/* harmony import */ var _visitors_open_api_3_0_example_ExternalValueVisitor_mjs__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(7363);
/* harmony import */ var _visitors_open_api_3_0_external_documentation_index_mjs__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(52805);
/* harmony import */ var _visitors_open_api_3_0_encoding_index_mjs__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(12302);
/* harmony import */ var _visitors_open_api_3_0_encoding_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(42538);
/* harmony import */ var _visitors_open_api_3_0_paths_index_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(6549);
/* harmony import */ var _visitors_open_api_3_0_request_body_index_mjs__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(63905);
/* harmony import */ var _visitors_open_api_3_0_request_body_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(46896);
/* harmony import */ var _visitors_open_api_3_0_callback_index_mjs__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(37840);
/* harmony import */ var _visitors_open_api_3_0_response_index_mjs__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(77968);
/* harmony import */ var _visitors_open_api_3_0_response_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(91396);
/* harmony import */ var _visitors_open_api_3_0_response_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(81387);
/* harmony import */ var _visitors_open_api_3_0_response_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(13163);
/* harmony import */ var _visitors_open_api_3_0_responses_index_mjs__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(45241);
/* harmony import */ var _visitors_open_api_3_0_responses_DefaultVisitor_mjs__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(74600);
/* harmony import */ var _visitors_open_api_3_0_operation_index_mjs__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(69802);
/* harmony import */ var _visitors_open_api_3_0_operation_TagsVisitor_mjs__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(91033);
/* harmony import */ var _visitors_open_api_3_0_operation_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(89084);
/* harmony import */ var _visitors_open_api_3_0_operation_RequestBodyVisitor_mjs__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(95921);
/* harmony import */ var _visitors_open_api_3_0_operation_CallbacksVisitor_mjs__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(55912);
/* harmony import */ var _visitors_open_api_3_0_operation_SecurityVisitor_mjs__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(75314);
/* harmony import */ var _visitors_open_api_3_0_operation_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(35912);
/* harmony import */ var _visitors_open_api_3_0_path_item_index_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(20502);
/* harmony import */ var _visitors_open_api_3_0_path_item_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(21365);
/* harmony import */ var _visitors_open_api_3_0_path_item_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(13124);
/* harmony import */ var _visitors_open_api_3_0_path_item_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(84104);
/* harmony import */ var _visitors_open_api_3_0_security_scheme_index_mjs__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(20207);
/* harmony import */ var _visitors_open_api_3_0_oauth_flows_index_mjs__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(44056);
/* harmony import */ var _visitors_open_api_3_0_oauth_flow_index_mjs__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(72011);
/* harmony import */ var _visitors_open_api_3_0_oauth_flow_ScopesVisitor_mjs__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(67180);
/* harmony import */ var _visitors_open_api_3_0_TagsVisitor_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(88367);























































































/**
 * Specification object allows us to have complete control over visitors
 * when traversing the ApiDOM.
 * Specification also allows us to create amended refractors from
 * existing ones by manipulating it.
 *
 * Note: Specification object allows to use absolute internal JSON pointers.
 */
const {
  fixedFields: jsonSchemaFixedFields
} = _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.JSONSchema;

/**
 * @public
 */
const specification = {
  visitors: {
    value: _visitors_FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
    document: {
      objects: {
        OpenApi: {
          $visitor: _visitors_open_api_3_0_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"],
          fixedFields: {
            openapi: _visitors_open_api_3_0_OpenapiVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"],
            info: {
              $ref: '#/visitors/document/objects/Info'
            },
            servers: _visitors_open_api_3_0_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__["default"],
            paths: {
              $ref: '#/visitors/document/objects/Paths'
            },
            components: {
              $ref: '#/visitors/document/objects/Components'
            },
            security: _visitors_open_api_3_0_SecurityVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"],
            tags: _visitors_open_api_3_0_TagsVisitor_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            }
          }
        },
        Info: {
          $visitor: _visitors_open_api_3_0_info_index_mjs__WEBPACK_IMPORTED_MODULE_7__["default"],
          fixedFields: {
            title: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            termsOfService: {
              $ref: '#/visitors/value'
            },
            contact: {
              $ref: '#/visitors/document/objects/Contact'
            },
            license: {
              $ref: '#/visitors/document/objects/License'
            },
            version: _visitors_open_api_3_0_info_VersionVisitor_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]
          }
        },
        Contact: {
          $visitor: _visitors_open_api_3_0_contact_index_mjs__WEBPACK_IMPORTED_MODULE_9__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            url: {
              $ref: '#/visitors/value'
            },
            email: {
              $ref: '#/visitors/value'
            }
          }
        },
        License: {
          $visitor: _visitors_open_api_3_0_license_index_mjs__WEBPACK_IMPORTED_MODULE_10__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            url: {
              $ref: '#/visitors/value'
            }
          }
        },
        Server: {
          $visitor: _visitors_open_api_3_0_server_index_mjs__WEBPACK_IMPORTED_MODULE_11__["default"],
          fixedFields: {
            url: _visitors_open_api_3_0_server_UrlVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__["default"],
            description: {
              $ref: '#/visitors/value'
            },
            variables: _visitors_open_api_3_0_server_VariablesVisitor_mjs__WEBPACK_IMPORTED_MODULE_13__["default"]
          }
        },
        ServerVariable: {
          $visitor: _visitors_open_api_3_0_server_variable_index_mjs__WEBPACK_IMPORTED_MODULE_14__["default"],
          fixedFields: {
            enum: {
              $ref: '#/visitors/value'
            },
            default: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            }
          }
        },
        Components: {
          $visitor: _visitors_open_api_3_0_components_index_mjs__WEBPACK_IMPORTED_MODULE_15__["default"],
          fixedFields: {
            schemas: _visitors_open_api_3_0_components_SchemasVisitor_mjs__WEBPACK_IMPORTED_MODULE_16__["default"],
            responses: _visitors_open_api_3_0_components_ResponsesVisitor_mjs__WEBPACK_IMPORTED_MODULE_17__["default"],
            parameters: _visitors_open_api_3_0_components_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_18__["default"],
            examples: _visitors_open_api_3_0_components_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_19__["default"],
            requestBodies: _visitors_open_api_3_0_components_RequestBodiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_20__["default"],
            headers: _visitors_open_api_3_0_components_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_21__["default"],
            securitySchemes: _visitors_open_api_3_0_components_SecuritySchemesVisitor_mjs__WEBPACK_IMPORTED_MODULE_22__["default"],
            links: _visitors_open_api_3_0_components_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_23__["default"],
            callbacks: _visitors_open_api_3_0_components_CallbacksVisitor_mjs__WEBPACK_IMPORTED_MODULE_24__["default"]
          }
        },
        Paths: {
          $visitor: _visitors_open_api_3_0_paths_index_mjs__WEBPACK_IMPORTED_MODULE_25__["default"]
        },
        PathItem: {
          $visitor: _visitors_open_api_3_0_path_item_index_mjs__WEBPACK_IMPORTED_MODULE_26__["default"],
          fixedFields: {
            $ref: _visitors_open_api_3_0_path_item_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_27__["default"],
            summary: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            get: {
              $ref: '#/visitors/document/objects/Operation'
            },
            put: {
              $ref: '#/visitors/document/objects/Operation'
            },
            post: {
              $ref: '#/visitors/document/objects/Operation'
            },
            delete: {
              $ref: '#/visitors/document/objects/Operation'
            },
            options: {
              $ref: '#/visitors/document/objects/Operation'
            },
            head: {
              $ref: '#/visitors/document/objects/Operation'
            },
            patch: {
              $ref: '#/visitors/document/objects/Operation'
            },
            trace: {
              $ref: '#/visitors/document/objects/Operation'
            },
            servers: _visitors_open_api_3_0_path_item_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_28__["default"],
            parameters: _visitors_open_api_3_0_path_item_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_29__["default"]
          }
        },
        Operation: {
          $visitor: _visitors_open_api_3_0_operation_index_mjs__WEBPACK_IMPORTED_MODULE_30__["default"],
          fixedFields: {
            tags: _visitors_open_api_3_0_operation_TagsVisitor_mjs__WEBPACK_IMPORTED_MODULE_31__["default"],
            summary: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            },
            operationId: {
              $ref: '#/visitors/value'
            },
            parameters: _visitors_open_api_3_0_operation_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_32__["default"],
            requestBody: _visitors_open_api_3_0_operation_RequestBodyVisitor_mjs__WEBPACK_IMPORTED_MODULE_33__["default"],
            responses: {
              $ref: '#/visitors/document/objects/Responses'
            },
            callbacks: _visitors_open_api_3_0_operation_CallbacksVisitor_mjs__WEBPACK_IMPORTED_MODULE_34__["default"],
            deprecated: {
              $ref: '#/visitors/value'
            },
            security: _visitors_open_api_3_0_operation_SecurityVisitor_mjs__WEBPACK_IMPORTED_MODULE_35__["default"],
            servers: _visitors_open_api_3_0_operation_ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_36__["default"]
          }
        },
        ExternalDocumentation: {
          $visitor: _visitors_open_api_3_0_external_documentation_index_mjs__WEBPACK_IMPORTED_MODULE_37__["default"],
          fixedFields: {
            description: {
              $ref: '#/visitors/value'
            },
            url: {
              $ref: '#/visitors/value'
            }
          }
        },
        Parameter: {
          $visitor: _visitors_open_api_3_0_parameter_index_mjs__WEBPACK_IMPORTED_MODULE_38__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            in: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            required: {
              $ref: '#/visitors/value'
            },
            deprecated: {
              $ref: '#/visitors/value'
            },
            allowEmptyValue: {
              $ref: '#/visitors/value'
            },
            style: {
              $ref: '#/visitors/value'
            },
            explode: {
              $ref: '#/visitors/value'
            },
            allowReserved: {
              $ref: '#/visitors/value'
            },
            schema: _visitors_open_api_3_0_parameter_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_39__["default"],
            example: {
              $ref: '#/visitors/value'
            },
            examples: _visitors_open_api_3_0_parameter_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_40__["default"],
            content: _visitors_open_api_3_0_parameter_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_41__["default"]
          }
        },
        RequestBody: {
          $visitor: _visitors_open_api_3_0_request_body_index_mjs__WEBPACK_IMPORTED_MODULE_42__["default"],
          fixedFields: {
            description: {
              $ref: '#/visitors/value'
            },
            content: _visitors_open_api_3_0_request_body_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_43__["default"],
            required: {
              $ref: '#/visitors/value'
            }
          }
        },
        MediaType: {
          $visitor: _visitors_open_api_3_0_media_type_index_mjs__WEBPACK_IMPORTED_MODULE_44__["default"],
          fixedFields: {
            schema: _visitors_open_api_3_0_media_type_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_45__["default"],
            example: {
              $ref: '#/visitors/value'
            },
            examples: _visitors_open_api_3_0_media_type_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_46__["default"],
            encoding: _visitors_open_api_3_0_media_type_EncodingVisitor_mjs__WEBPACK_IMPORTED_MODULE_47__["default"]
          }
        },
        Encoding: {
          $visitor: _visitors_open_api_3_0_encoding_index_mjs__WEBPACK_IMPORTED_MODULE_48__["default"],
          fixedFields: {
            contentType: {
              $ref: '#/visitors/value'
            },
            headers: _visitors_open_api_3_0_encoding_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_49__["default"],
            style: {
              $ref: '#/visitors/value'
            },
            explode: {
              $ref: '#/visitors/value'
            },
            allowReserved: {
              $ref: '#/visitors/value'
            }
          }
        },
        Responses: {
          $visitor: _visitors_open_api_3_0_responses_index_mjs__WEBPACK_IMPORTED_MODULE_50__["default"],
          fixedFields: {
            default: _visitors_open_api_3_0_responses_DefaultVisitor_mjs__WEBPACK_IMPORTED_MODULE_51__["default"]
          }
        },
        Response: {
          $visitor: _visitors_open_api_3_0_response_index_mjs__WEBPACK_IMPORTED_MODULE_52__["default"],
          fixedFields: {
            description: {
              $ref: '#/visitors/value'
            },
            headers: _visitors_open_api_3_0_response_HeadersVisitor_mjs__WEBPACK_IMPORTED_MODULE_53__["default"],
            content: _visitors_open_api_3_0_response_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_54__["default"],
            links: _visitors_open_api_3_0_response_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_55__["default"]
          }
        },
        Callback: {
          $visitor: _visitors_open_api_3_0_callback_index_mjs__WEBPACK_IMPORTED_MODULE_56__["default"]
        },
        Example: {
          $visitor: _visitors_open_api_3_0_example_index_mjs__WEBPACK_IMPORTED_MODULE_57__["default"],
          fixedFields: {
            summary: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            value: {
              $ref: '#/visitors/value'
            },
            externalValue: _visitors_open_api_3_0_example_ExternalValueVisitor_mjs__WEBPACK_IMPORTED_MODULE_58__["default"]
          }
        },
        Link: {
          $visitor: _visitors_open_api_3_0_link_index_mjs__WEBPACK_IMPORTED_MODULE_59__["default"],
          fixedFields: {
            operationRef: _visitors_open_api_3_0_link_OperationRefVisitor_mjs__WEBPACK_IMPORTED_MODULE_60__["default"],
            operationId: _visitors_open_api_3_0_link_OperationIdVisitor_mjs__WEBPACK_IMPORTED_MODULE_61__["default"],
            parameters: _visitors_open_api_3_0_link_ParametersVisitor_mjs__WEBPACK_IMPORTED_MODULE_62__["default"],
            requestBody: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            server: {
              $ref: '#/visitors/document/objects/Server'
            }
          }
        },
        Header: {
          $visitor: _visitors_open_api_3_0_header_index_mjs__WEBPACK_IMPORTED_MODULE_63__["default"],
          fixedFields: {
            description: {
              $ref: '#/visitors/value'
            },
            required: {
              $ref: '#/visitors/value'
            },
            deprecated: {
              $ref: '#/visitors/value'
            },
            allowEmptyValue: {
              $ref: '#/visitors/value'
            },
            style: {
              $ref: '#/visitors/value'
            },
            explode: {
              $ref: '#/visitors/value'
            },
            allowReserved: {
              $ref: '#/visitors/value'
            },
            schema: _visitors_open_api_3_0_header_SchemaVisitor_mjs__WEBPACK_IMPORTED_MODULE_64__["default"],
            example: {
              $ref: '#/visitors/value'
            },
            examples: _visitors_open_api_3_0_header_ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_65__["default"],
            content: _visitors_open_api_3_0_header_ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_66__["default"]
          }
        },
        Tag: {
          $visitor: _visitors_open_api_3_0_tag_index_mjs__WEBPACK_IMPORTED_MODULE_67__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            }
          }
        },
        Reference: {
          $visitor: _visitors_open_api_3_0_reference_index_mjs__WEBPACK_IMPORTED_MODULE_68__["default"],
          fixedFields: {
            $ref: _visitors_open_api_3_0_reference_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_69__["default"]
          }
        },
        JSONSchema: {
          $ref: '#/visitors/document/objects/Schema'
        },
        JSONReference: {
          $ref: '#/visitors/document/objects/Reference'
        },
        Schema: {
          $visitor: _visitors_open_api_3_0_schema_index_mjs__WEBPACK_IMPORTED_MODULE_70__["default"],
          fixedFields: {
            // the following properties are taken directly from the JSON Schema definition and follow the same specifications
            title: jsonSchemaFixedFields.title,
            multipleOf: jsonSchemaFixedFields.multipleOf,
            maximum: jsonSchemaFixedFields.maximum,
            exclusiveMaximum: jsonSchemaFixedFields.exclusiveMaximum,
            minimum: jsonSchemaFixedFields.minimum,
            exclusiveMinimum: jsonSchemaFixedFields.exclusiveMinimum,
            maxLength: jsonSchemaFixedFields.maxLength,
            minLength: jsonSchemaFixedFields.minLength,
            pattern: jsonSchemaFixedFields.pattern,
            maxItems: jsonSchemaFixedFields.maxItems,
            minItems: jsonSchemaFixedFields.minItems,
            uniqueItems: jsonSchemaFixedFields.uniqueItems,
            maxProperties: jsonSchemaFixedFields.maxProperties,
            minProperties: jsonSchemaFixedFields.minProperties,
            required: jsonSchemaFixedFields.required,
            enum: jsonSchemaFixedFields.enum,
            // the following properties are taken from the JSON Schema definition but their definitions were adjusted to the OpenAPI Specification
            type: _visitors_open_api_3_0_schema_TypeVisitor_mjs__WEBPACK_IMPORTED_MODULE_71__["default"],
            allOf: _visitors_open_api_3_0_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_72__["default"],
            anyOf: _visitors_open_api_3_0_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_73__["default"],
            oneOf: _visitors_open_api_3_0_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_74__["default"],
            not: _visitors_open_api_3_0_schema_SchemaOrReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_75__["default"],
            items: _visitors_open_api_3_0_schema_ItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_76__["default"],
            properties: _visitors_open_api_3_0_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_77__["default"],
            additionalProperties: _visitors_open_api_3_0_schema_SchemaOrReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_75__["default"],
            description: jsonSchemaFixedFields.description,
            format: jsonSchemaFixedFields.format,
            default: jsonSchemaFixedFields.default,
            // OpenAPI vocabulary
            nullable: {
              $ref: '#/visitors/value'
            },
            discriminator: {
              $ref: '#/visitors/document/objects/Discriminator'
            },
            writeOnly: {
              $ref: '#/visitors/value'
            },
            xml: {
              $ref: '#/visitors/document/objects/XML'
            },
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            },
            example: {
              $ref: '#/visitors/value'
            },
            deprecated: {
              $ref: '#/visitors/value'
            }
          }
        },
        Discriminator: {
          $visitor: _visitors_open_api_3_0_distriminator_index_mjs__WEBPACK_IMPORTED_MODULE_78__["default"],
          fixedFields: {
            propertyName: {
              $ref: '#/visitors/value'
            },
            mapping: _visitors_open_api_3_0_distriminator_MappingVisitor_mjs__WEBPACK_IMPORTED_MODULE_79__["default"]
          }
        },
        XML: {
          $visitor: _visitors_open_api_3_0_xml_index_mjs__WEBPACK_IMPORTED_MODULE_80__["default"],
          fixedFields: {
            name: {
              $ref: '#/visitors/value'
            },
            namespace: {
              $ref: '#/visitors/value'
            },
            prefix: {
              $ref: '#/visitors/value'
            },
            attribute: {
              $ref: '#/visitors/value'
            },
            wrapped: {
              $ref: '#/visitors/value'
            }
          }
        },
        SecurityScheme: {
          $visitor: _visitors_open_api_3_0_security_scheme_index_mjs__WEBPACK_IMPORTED_MODULE_81__["default"],
          fixedFields: {
            type: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            name: {
              $ref: '#/visitors/value'
            },
            in: {
              $ref: '#/visitors/value'
            },
            scheme: {
              $ref: '#/visitors/value'
            },
            bearerFormat: {
              $ref: '#/visitors/value'
            },
            flows: {
              $ref: '#/visitors/document/objects/OAuthFlows'
            },
            openIdConnectUrl: {
              $ref: '#/visitors/value'
            }
          }
        },
        OAuthFlows: {
          $visitor: _visitors_open_api_3_0_oauth_flows_index_mjs__WEBPACK_IMPORTED_MODULE_82__["default"],
          fixedFields: {
            implicit: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            password: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            clientCredentials: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            authorizationCode: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            }
          }
        },
        OAuthFlow: {
          $visitor: _visitors_open_api_3_0_oauth_flow_index_mjs__WEBPACK_IMPORTED_MODULE_83__["default"],
          fixedFields: {
            authorizationUrl: {
              $ref: '#/visitors/value'
            },
            tokenUrl: {
              $ref: '#/visitors/value'
            },
            refreshUrl: {
              $ref: '#/visitors/value'
            },
            scopes: _visitors_open_api_3_0_oauth_flow_ScopesVisitor_mjs__WEBPACK_IMPORTED_MODULE_84__["default"]
          }
        },
        SecurityRequirement: {
          $visitor: _visitors_open_api_3_0_security_requirement_index_mjs__WEBPACK_IMPORTED_MODULE_85__["default"]
        }
      },
      extension: {
        $visitor: _visitors_SpecificationExtensionVisitor_mjs__WEBPACK_IMPORTED_MODULE_86__["default"]
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (specification);

/***/ }),

/***/ 2156:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62287);

/**
 * @public
 */
class $vocabularyVisitor extends _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_0__["default"] {
  ObjectElement(objectElement) {
    const result = super.enter(objectElement);
    this.element.classes.push('json-schema-$vocabulary');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($vocabularyVisitor);

/***/ }),

/***/ 2173:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curry3)
/* harmony export */ });
/* harmony import */ var _curry1_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3579);
/* harmony import */ var _curry2_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(92254);
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82808);




/**
 * Optimized internal three-arity curry function.
 *
 * @private
 * @category Function
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curry3(fn) {
  return function f3(a, b, c) {
    switch (arguments.length) {
      case 0:
        return f3;
      case 1:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(a) ? f3 : (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (_b, _c) {
          return fn(a, _b, _c);
        });
      case 2:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(b) ? f3 : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(a) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (_a, _c) {
          return fn(_a, b, _c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(b) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (_b, _c) {
          return fn(a, _b, _c);
        }) : (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__["default"])(function (_c) {
          return fn(a, b, _c);
        });
      default:
        return (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(b) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(c) ? f3 : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(b) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (_a, _b) {
          return fn(_a, _b, c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(a) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(c) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (_a, _c) {
          return fn(_a, b, _c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(b) && (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(c) ? (0,_curry2_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (_b, _c) {
          return fn(a, _b, _c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(a) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__["default"])(function (_a) {
          return fn(_a, b, c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(b) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__["default"])(function (_b) {
          return fn(a, _b, c);
        }) : (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(c) ? (0,_curry1_js__WEBPACK_IMPORTED_MODULE_2__["default"])(function (_c) {
          return fn(a, b, _c);
        }) : fn(a, b, c);
    }
  };
}

/***/ }),

/***/ 2211:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Grammar: () => (/* reexport safe */ _grammar_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   base64Encoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_base64_node_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   base64urlEncoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_base64url_node_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   cookieNameLenientPercentEncoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_cookie_name_lenient_percent_mjs__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   cookieNameLenientValidator: () => (/* reexport safe */ _set_cookie_serialize_validators_cookie_name_lenient_mjs__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   cookieNameStrictPercentEncoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_cookie_name_strict_percent_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   cookieNameStrictValidator: () => (/* reexport safe */ _set_cookie_serialize_validators_cookie_name_strict_mjs__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   cookieValueLenientBase64Encoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_cookie_value_lenient_base64_mjs__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   cookieValueLenientBase64urlEncoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_cookie_value_lenient_base64url_mjs__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   cookieValueLenientPercentEncoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_cookie_value_lenient_percent_mjs__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   cookieValueLenientValidator: () => (/* reexport safe */ _set_cookie_serialize_validators_cookie_value_lenient_mjs__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   cookieValueStrictBase64Encoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_cookie_value_strict_base64_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   cookieValueStrictBase64urlEncoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_cookie_value_strict_base64url_mjs__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   cookieValueStrictPercentEncoder: () => (/* reexport safe */ _set_cookie_serialize_encoders_cookie_value_strict_percent_mjs__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   cookieValueStrictValidator: () => (/* reexport safe */ _set_cookie_serialize_validators_cookie_value_strict_mjs__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   identity: () => (/* reexport safe */ _utils_mjs__WEBPACK_IMPORTED_MODULE_17__.identity),
/* harmony export */   noop: () => (/* reexport safe */ _utils_mjs__WEBPACK_IMPORTED_MODULE_17__.noop),
/* harmony export */   parseCookie: () => (/* reexport safe */ _cookie_parse_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   serializeCookie: () => (/* reexport safe */ _cookie_serialize_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"])
/* harmony export */ });
/* harmony import */ var _grammar_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(96552);
/* harmony import */ var _cookie_parse_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(32910);
/* harmony import */ var _cookie_serialize_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(90465);
/* harmony import */ var _set_cookie_serialize_encoders_base64_node_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4745);
/* harmony import */ var _set_cookie_serialize_encoders_base64url_node_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(11808);
/* harmony import */ var _set_cookie_serialize_encoders_cookie_name_strict_percent_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(69818);
/* harmony import */ var _set_cookie_serialize_encoders_cookie_name_lenient_percent_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(55930);
/* harmony import */ var _set_cookie_serialize_encoders_cookie_value_strict_percent_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(24350);
/* harmony import */ var _set_cookie_serialize_encoders_cookie_value_strict_base64_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(59514);
/* harmony import */ var _set_cookie_serialize_encoders_cookie_value_strict_base64url_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(89993);
/* harmony import */ var _set_cookie_serialize_encoders_cookie_value_lenient_percent_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(57702);
/* harmony import */ var _set_cookie_serialize_encoders_cookie_value_lenient_base64_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(78466);
/* harmony import */ var _set_cookie_serialize_encoders_cookie_value_lenient_base64url_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(50897);
/* harmony import */ var _set_cookie_serialize_validators_cookie_name_strict_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(68712);
/* harmony import */ var _set_cookie_serialize_validators_cookie_name_lenient_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(80904);
/* harmony import */ var _set_cookie_serialize_validators_cookie_value_strict_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(27120);
/* harmony import */ var _set_cookie_serialize_validators_cookie_value_lenient_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(99504);
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(91176);



/**
 * Encoders
 */










/**
 * Validators
 */




/**
 * Utils
 */


/***/ }),

/***/ 2404:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseIsEqual = __webpack_require__(60270);

/**
 * Performs a deep comparison between two values to determine if they are
 * equivalent.
 *
 * **Note:** This method supports comparing arrays, array buffers, booleans,
 * date objects, error objects, maps, numbers, `Object` objects, regexes,
 * sets, strings, symbols, and typed arrays. `Object` objects are compared
 * by their own, not inherited, enumerable properties. Functions and DOM
 * nodes are compared by strict equality, i.e. `===`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to compare.
 * @param {*} other The other value to compare.
 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
 * @example
 *
 * var object = { 'a': 1 };
 * var other = { 'a': 1 };
 *
 * _.isEqual(object, other);
 * // => true
 *
 * object === other;
 * // => false
 */
function isEqual(value, other) {
  return baseIsEqual(value, other);
}

module.exports = isEqual;


/***/ }),

/***/ 2532:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);

// eslint-disable-next-line es/no-object-defineproperty -- safe
var defineProperty = Object.defineProperty;

module.exports = function (key, value) {
  try {
    defineProperty(globalThis, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    globalThis[key] = value;
  } return value;
};


/***/ }),

/***/ 2875:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var internalObjectKeys = __webpack_require__(23045);
var enumBugKeys = __webpack_require__(80376);

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es/no-object-keys -- safe
module.exports = Object.keys || function keys(O) {
  return internalObjectKeys(O, enumBugKeys);
};


/***/ }),

/***/ 2966:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseOperationVisitor: () => (/* binding */ BaseOperationVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48800);


/**
 * @public
 */
const BaseOperationVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.Operation.$visitor;
/**
 * @public
 */
class OperationVisitor extends BaseOperationVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationVisitor);

/***/ }),

/***/ 2981:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseTagVisitor: () => (/* binding */ BaseTagVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(50531);


/**
 * @public
 */
const BaseTagVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.Tag.$visitor;
/**
 * @public
 */
class TagVisitor extends BaseTagVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TagVisitor);

/***/ }),

/***/ 3110:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const isNull = __webpack_require__(5187);
const isString = __webpack_require__(85015);
const isNumber = __webpack_require__(98023);
const isBoolean = __webpack_require__(53812);
const isObject = __webpack_require__(23805);

const JSONSerialiser = __webpack_require__(85105);
const elements = __webpack_require__(86804);

/**
 * @class
 *
 * A refract element implementation with an extensible namespace, able to
 * load other namespaces into it.
 *
 * The namespace allows you to register your own classes to be instantiated
 * when a particular refract element is encountered, and allows you to specify
 * which elements get instantiated for existing Javascript objects.
 */
class Namespace {
  constructor(options) {
    this.elementMap = {};
    this.elementDetection = [];
    this.Element = elements.Element;
    this.KeyValuePair = elements.KeyValuePair;

    if (!options || !options.noDefault) {
      this.useDefault();
    }

    // These provide the defaults for new elements.
    this._attributeElementKeys = [];
    this._attributeElementArrayKeys = [];
  }

  /**
   * Use a namespace plugin or load a generic plugin.
   *
   * @param plugin
   */
  use(plugin) {
    if (plugin.namespace) {
      plugin.namespace({ base: this });
    }
    if (plugin.load) {
      plugin.load({ base: this });
    }
    return this;
  }

  /*
   * Use the default namespace. This preloads all the default elements
   * into this registry instance.
   */
  useDefault() {
    // Set up classes for default elements
    this
      .register('null', elements.NullElement)
      .register('string', elements.StringElement)
      .register('number', elements.NumberElement)
      .register('boolean', elements.BooleanElement)
      .register('array', elements.ArrayElement)
      .register('object', elements.ObjectElement)
      .register('member', elements.MemberElement)
      .register('ref', elements.RefElement)
      .register('link', elements.LinkElement);

    // Add instance detection functions to convert existing objects into
    // the corresponding refract elements.
    this
      .detect(isNull, elements.NullElement, false)
      .detect(isString, elements.StringElement, false)
      .detect(isNumber, elements.NumberElement, false)
      .detect(isBoolean, elements.BooleanElement, false)
      .detect(Array.isArray, elements.ArrayElement, false)
      .detect(isObject, elements.ObjectElement, false);

    return this;
  }

  /**
   * Register a new element class for an element.
   *
   * @param {string} name
   * @param elementClass
   */
  register(name, ElementClass) {
    this._elements = undefined;
    this.elementMap[name] = ElementClass;
    return this;
  }

  /**
   * Unregister a previously registered class for an element.
   *
   * @param {string} name
   */
  unregister(name) {
    this._elements = undefined;
    delete this.elementMap[name];
    return this;
  }

  /*
   * Add a new detection function to determine which element
   * class to use when converting existing js instances into
   * refract element.
   */
  detect(test, ElementClass, givenPrepend) {
    const prepend = givenPrepend === undefined ? true : givenPrepend;

    if (prepend) {
      this.elementDetection.unshift([test, ElementClass]);
    } else {
      this.elementDetection.push([test, ElementClass]);
    }

    return this;
  }

  /*
   * Convert an existing Javascript object into refract element instances, which
   * can be further processed or serialized into refract.
   * If the item passed in is already refracted, then it is returned
   * unmodified.
   */
  toElement(value) {
    if (value instanceof this.Element) { return value; }

    let element;

    for (let i = 0; i < this.elementDetection.length; i += 1) {
      const test = this.elementDetection[i][0];
      const ElementClass = this.elementDetection[i][1];

      if (test(value)) {
        element = new ElementClass(value);
        break;
      }
    }

    return element;
  }

  /*
   * Get an element class given an element name.
   */
  getElementClass(element) {
    const ElementClass = this.elementMap[element];

    if (ElementClass === undefined) {
      // Fall back to the base element. We may not know what
      // to do with the `content`, but downstream software
      // may know.
      return this.Element;
    }

    return ElementClass;
  }

  /*
   * Convert a refract document into refract element instances.
   */
  fromRefract(doc) {
    return this.serialiser.deserialise(doc);
  }

  /*
   * Convert an element to a Refracted JSON object.
   */
  toRefract(element) {
    return this.serialiser.serialise(element);
  }

  /*
   * Get an object that contains all registered element classes, where
   * the key is the PascalCased element name and the value is the class.
   */
  get elements() {
    if (this._elements === undefined) {
      this._elements = {
        Element: this.Element,
      };

      Object.keys(this.elementMap).forEach((name) => {
        // Currently, all registered element types use a camelCaseName.
        // Converting to PascalCase is as simple as upper-casing the first
        // letter.
        const pascal = name[0].toUpperCase() + name.substr(1);
        this._elements[pascal] = this.elementMap[name];
      });
    }

    return this._elements;
  }

  /**
   * Convinience method for getting a JSON Serialiser configured with the
   * current namespace
   *
   * @type JSONSerialiser
   * @readonly
   *
   * @memberof Namespace.prototype
   */
  get serialiser() {
    return new JSONSerialiser(this);
  }
}

JSONSerialiser.prototype.Namespace = Namespace;

module.exports = Namespace;


/***/ }),

/***/ 3117:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8564);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26183);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(21504);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(89360);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(60020);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);




/**
 * @public
 */
/**
 * @public
 */
/**
 * @public
 */
class AlternatingVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  alternator;
  constructor({
    alternator,
    ...rest
  }) {
    super({
      ...rest
    });
    this.alternator = alternator;
  }
  enter(element) {
    const functions = this.alternator.map(({
      predicate,
      specPath
    }) => (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(predicate, (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(specPath), ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"]));
    const specPath = (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_4__["default"])(functions)(element);
    this.element = this.toRefractedElement(specPath, element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AlternatingVisitor);

/***/ }),

/***/ 3121:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toIntegerOrInfinity = __webpack_require__(65482);

var min = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
module.exports = function (argument) {
  var len = toIntegerOrInfinity(argument);
  return len > 0 ? min(len, 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};


/***/ }),

/***/ 3182:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * A function that always returns `false`. Any passed in parameters are ignored.
 *
 * @func
 * @memberOf R
 * @since v0.9.0
 * @category Function
 * @sig * -> Boolean
 * @param {*}
 * @return {Boolean}
 * @see R.T
 * @example
 *
 *      R.F(); //=> false
 */
var F = function () {
  return false;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (F);

/***/ }),

/***/ 3223:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JSONSchemaPropertiesVisitor: () => (/* binding */ JSONSchemaPropertiesVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7386);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9748);


/**
 * @public
 */
const JSONSchemaPropertiesVisitor = _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.JSONSchema.fixedFields.properties;

/**
 * @public
 */
class PropertiesVisitor extends JSONSchemaPropertiesVisitor {
  ObjectElement(objectElement) {
    const result = JSONSchemaPropertiesVisitor.prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_1__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'schema');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PropertiesVisitor);

/***/ }),

/***/ 3296:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62287);

/**
 * @public
 */
class $RefVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = this.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($RefVisitor);

/***/ }),

/***/ 3406:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _parse_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39790);

/**
 * Test if a string is a server URL template.
 *
 * @param {string} serverURLTemplate
 * @param {Object} [options={}] - An object.
 * @param {boolean} [options.strict=true] - A boolean indicating presence of at least one `Server Variable` AST node.
 * @returns {boolean}
 */
const test = (serverURLTemplate, {
  strict = false
} = {}) => {
  try {
    const parseResult = (0,_parse_index_mjs__WEBPACK_IMPORTED_MODULE_0__["default"])(serverURLTemplate);
    if (!parseResult.result.success) return false;
    const parts = [];
    parseResult.ast.translate(parts);
    const hasServerVariable = parts.some(([type]) => type === 'server-variable');
    if (!strict && !hasServerVariable) {
      try {
        new URL(serverURLTemplate, 'https://vladimirgorej.com');
        return true;
      } catch {
        return false;
      }
    }
    return strict ? hasServerVariable : true;
  } catch {
    return false;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (test);

/***/ }),

/***/ 3436:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class Server extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.ServerElement {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Server);

/***/ }),

/***/ 3474:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FileWithData: () => (/* binding */ FileWithData),
/* harmony export */   isArrayOfFile: () => (/* binding */ isArrayOfFile),
/* harmony export */   isFile: () => (/* binding */ isFile)
/* harmony export */ });
function isFile(obj, navigatorObj) {
  if (!navigatorObj && typeof navigator !== 'undefined') {
    // eslint-disable-next-line no-undef
    navigatorObj = navigator;
  }
  if (navigatorObj && navigatorObj.product === 'ReactNative') {
    if (obj && typeof obj === 'object' && typeof obj.uri === 'string') {
      return true;
    }
    return false;
  }
  if (typeof File !== 'undefined' && obj instanceof File) {
    return true;
  }
  if (typeof Blob !== 'undefined' && obj instanceof Blob) {
    return true;
  }
  if (ArrayBuffer.isView(obj)) {
    return true;
  }
  return obj !== null && typeof obj === 'object' && typeof obj.pipe === 'function';
}
function isArrayOfFile(obj, navigatorObj) {
  return Array.isArray(obj) && obj.some(v => isFile(v, navigatorObj));
}

/**
 * Specialized sub-class of File class, that only
 * accepts string data and retain this data in `data`
 * public property throughout the lifecycle of its instances.
 *
 * This sub-class is exclusively used only when Encoding Object
 * is defined within the Media Type Object (OpenAPI 3.x.y).
 */
class FileWithData extends File {
  constructor(data, name = '', options = {}) {
    super([data], name, options);
    this.data = data;
  }
  valueOf() {
    return this.data;
  }
  toString() {
    return this.valueOf();
  }
}

/***/ }),

/***/ 3510:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dereference: () => (/* binding */ dereference)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37012);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5548);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(73236);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(72246);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(24445);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24955);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1679);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(82129);



/**
 * This dereference algorithm is used exclusively for dereferencing specification objects.
 * It doesn't handle circular references of external references and works on objects only (not arrays).
 * @public
 */
// eslint-disable-next-line import/prefer-default-export
const dereference = (object, root) => {
  const rootObject = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(object, root);
  return (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(val => {
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__["default"])(val) && (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])('$ref', val) && (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"], '$ref', val)) {
      const $ref = (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])(['$ref'], val);
      // @ts-ignore
      const pointer = (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__["default"])('#/', $ref);
      return (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])(pointer.split('/'), rootObject);
    }
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_2__["default"])(val)) {
      return dereference(val, rootObject);
    }
    return val;
  }, object);
};

/***/ }),

/***/ 3579:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curry1)
/* harmony export */ });
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82808);


/**
 * Optimized internal one-arity curry function.
 *
 * @private
 * @category Function
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curry1(fn) {
  return function f1(a) {
    if (arguments.length === 0 || (0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(a)) {
      return f1;
    } else {
      return fn.apply(this, arguments);
    }
  };
}

/***/ }),

/***/ 3650:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var overArg = __webpack_require__(74335);

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeKeys = overArg(Object.keys, Object);

module.exports = nativeKeys;


/***/ }),

/***/ 3656:
/***/ ((module, exports, __webpack_require__) => {

/* module decorator */ module = __webpack_require__.nmd(module);
var root = __webpack_require__(9325),
    stubFalse = __webpack_require__(89935);

/** Detect free variable `exports`. */
var freeExports =  true && exports && !exports.nodeType && exports;

/** Detect free variable `module`. */
var freeModule = freeExports && "object" == 'object' && module && !module.nodeType && module;

/** Detect the popular CommonJS extension `module.exports`. */
var moduleExports = freeModule && freeModule.exports === freeExports;

/** Built-in value references. */
var Buffer = moduleExports ? root.Buffer : undefined;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

/**
 * Checks if `value` is a buffer.
 *
 * @static
 * @memberOf _
 * @since 4.3.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
 * @example
 *
 * _.isBuffer(new Buffer(2));
 * // => true
 *
 * _.isBuffer(new Uint8Array(2));
 * // => false
 */
var isBuffer = nativeIsBuffer || stubFalse;

module.exports = isBuffer;


/***/ }),

/***/ 3832:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ACCEPT_HEADER_VALUE_FOR_DOCUMENTS: () => (/* binding */ ACCEPT_HEADER_VALUE_FOR_DOCUMENTS),
/* harmony export */   DEFAULT_BASE_URL: () => (/* binding */ DEFAULT_BASE_URL),
/* harmony export */   DEFAULT_OPENAPI_3_SERVER: () => (/* binding */ DEFAULT_OPENAPI_3_SERVER),
/* harmony export */   TRAVERSE_LIMIT: () => (/* binding */ TRAVERSE_LIMIT)
/* harmony export */ });
const ACCEPT_HEADER_VALUE_FOR_DOCUMENTS = 'application/json, application/yaml';
const DEFAULT_BASE_URL = 'https://swagger.io';
const DEFAULT_OPENAPI_3_SERVER = Object.freeze({
  url: '/'
});
const TRAVERSE_LIMIT = 3000;

/***/ }),

/***/ 3985:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5051);

/**
 * @public
 */
class $RefVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($RefVisitor);

/***/ }),

/***/ 4005:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class ComponentsExamples extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-examples';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsExamples.primaryClass);
    this.classes.push('examples');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsExamples);

/***/ }),

/***/ 4196:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48018);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _elements_nces_DiscriminatorMapping_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35570);





/**
 * @public
 */
/**
 * @public
 */
class MappingVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_DiscriminatorMapping_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['value']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MappingVisitor);

/***/ }),

/***/ 4366:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   dispatchPluginsAsync: () => (/* binding */ dispatchPluginsAsync),
/* harmony export */   dispatchPluginsSync: () => (/* binding */ dispatchPluginsSync)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(24454);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(46850);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(23283);
/* harmony import */ var _toolbox_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(88920);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43319);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60020);




/**
 * @public
 */
/**
 * @public
 */
/**
 * @public
 */
const defaultDispatchPluginsOptions = {
  toolboxCreator: _toolbox_mjs__WEBPACK_IMPORTED_MODULE_0__["default"],
  visitorOptions: {
    nodeTypeGetter: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.getNodeType,
    exposeEdits: true
  }
};

/**
 * @public
 */
const dispatchPluginsSync = (element, plugins, options = {}) => {
  if (plugins.length === 0) return element;
  const mergedOptions = (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(defaultDispatchPluginsOptions, options);
  const {
    toolboxCreator,
    visitorOptions
  } = mergedOptions;
  const toolbox = toolboxCreator();
  const pluginsSpecs = plugins.map(plugin => plugin(toolbox));
  const mergedPluginsVisitor = (0,_traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_3__.mergeAll)(pluginsSpecs.map((0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])({}, 'visitor')), {
    ...visitorOptions
  });
  pluginsSpecs.forEach((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(['pre'], []));
  const newElement = (0,_traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.visit)(element, mergedPluginsVisitor, visitorOptions);
  pluginsSpecs.forEach((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(['post'], []));
  return newElement;
};
const dispatchPluginsAsync = async (element, plugins, options = {}) => {
  if (plugins.length === 0) return element;
  const mergedOptions = (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(defaultDispatchPluginsOptions, options);
  const {
    toolboxCreator,
    visitorOptions
  } = mergedOptions;
  const toolbox = toolboxCreator();
  const pluginsSpecs = plugins.map(plugin => plugin(toolbox));
  const mergeAllVisitorsAsync = _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_3__.mergeAll[Symbol.for('nodejs.util.promisify.custom')];
  const visitAsync = _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.visit[Symbol.for('nodejs.util.promisify.custom')];
  const mergedPluginsVisitor = mergeAllVisitorsAsync(pluginsSpecs.map((0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])({}, 'visitor')), {
    ...visitorOptions
  });
  await Promise.allSettled(pluginsSpecs.map((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(['pre'], [])));
  const newElement = await visitAsync(element, mergedPluginsVisitor, visitorOptions);
  await Promise.allSettled(pluginsSpecs.map((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_5__["default"])(['post'], [])));
  return newElement;
};
dispatchPluginsSync[Symbol.for('nodejs.util.promisify.custom')] = dispatchPluginsAsync;

/***/ }),

/***/ 4509:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(12651);

/**
 * Checks if a map value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf MapCache
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function mapCacheHas(key) {
  return getMapData(this, key).has(key);
}

module.exports = mapCacheHas;


/***/ }),

/***/ 4569:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   makeResolveSubtree: () => (/* binding */ makeResolveSubtree)
/* harmony export */ });
/* harmony import */ var _resolver_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92272);
/* harmony import */ var _resolver_strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52398);
/* harmony import */ var _resolver_strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19096);
/* harmony import */ var _resolver_strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(730);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(50918);
// The subtree resolver is a higher-level interface that allows you to
// get the same result that you would from `Swagger.resolve`, but focuses on
// a subtree of your object.
//
// It makes several assumptions that allow you to think less about what resolve,
// specmap, and normalizeSwagger are doing: if this is not suitable for you,
// you can emulate `resolveSubtree`'s behavior by talking to the traditional
// resolver directly.
//
// By providing a top-level `obj` and a `path` to resolve within, the subtree
// at `path` will be resolved and normalized in the context of your top-level
// `obj`. You'll get the resolved subtree you're interest in as a return value
// (or, you can use `returnEntireTree` to get everything back).
//
// This is useful for cases where resolving your entire object is unnecessary
// and/or non-performant; we use this interface for lazily resolving operations
// and models in Swagger-UI, which allows us to handle larger OpenAPI descriptions.
//
// It's likely that Swagger-Client will rely entirely on lazy resolving in
// future versions.
//
// TODO: move the remarks above into project documentation





const resolveSubtree = async (obj, path, options = {}) => {
  const {
    returnEntireTree,
    baseDoc,
    requestInterceptor,
    responseInterceptor,
    parameterMacro,
    modelPropertyMacro,
    useCircularStructures,
    strategies
  } = options;
  const resolveOptions = {
    spec: obj,
    pathDiscriminator: path,
    baseDoc,
    requestInterceptor,
    responseInterceptor,
    parameterMacro,
    modelPropertyMacro,
    useCircularStructures,
    strategies
  };
  const strategy = strategies.find(strg => strg.match(obj));
  const normalized = strategy.normalize(obj);
  const result = await (0,_resolver_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    spec: normalized,
    ...resolveOptions,
    allowMetaPatches: true,
    skipNormalization: !(0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_4__.isOpenAPI31)(obj)
  });
  if (!returnEntireTree && Array.isArray(path) && path.length) {
    result.spec = path.reduce((acc, pathSegment) => acc?.[pathSegment], result.spec) || null;
  }
  return result;
};
const makeResolveSubtree = defaultOptions => async (obj, path, options = {}) => {
  const mergedOptions = {
    ...defaultOptions,
    ...options
  };
  return resolveSubtree(obj, path, mergedOptions);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (makeResolveSubtree({
  strategies: [_resolver_strategies_openapi_3_0_index_js__WEBPACK_IMPORTED_MODULE_3__["default"], _resolver_strategies_openapi_2_index_js__WEBPACK_IMPORTED_MODULE_2__["default"], _resolver_strategies_generic_index_js__WEBPACK_IMPORTED_MODULE_1__["default"]]
}));

/***/ }),

/***/ 4640:
/***/ ((module) => {

"use strict";

var $String = String;

module.exports = function (argument) {
  try {
    return $String(argument);
  } catch (error) {
    return 'Object';
  }
};


/***/ }),

/***/ 4664:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var arrayFilter = __webpack_require__(79770),
    stubArray = __webpack_require__(63345);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Built-in value references. */
var propertyIsEnumerable = objectProto.propertyIsEnumerable;

/* Built-in method references for those with the same name as other `lodash` methods. */
var nativeGetSymbols = Object.getOwnPropertySymbols;

/**
 * Creates an array of the own enumerable symbols of `object`.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Array} Returns the array of symbols.
 */
var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  if (object == null) {
    return [];
  }
  object = Object(object);
  return arrayFilter(nativeGetSymbols(object), function(symbol) {
    return propertyIsEnumerable.call(object, symbol);
  });
};

module.exports = getSymbols;


/***/ }),

/***/ 4745:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const base64Encoder = input => {
  const bytes = new TextEncoder().encode(input);
  const binaryString = bytes.reduce((acc, byte) => acc + String.fromCharCode(byte), '');
  return btoa(binaryString);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (base64Encoder);

/***/ }),

/***/ 4901:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(72552),
    isLength = __webpack_require__(30294),
    isObjectLike = __webpack_require__(40346);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]',
    arrayTag = '[object Array]',
    boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    funcTag = '[object Function]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    objectTag = '[object Object]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    weakMapTag = '[object WeakMap]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]',
    float32Tag = '[object Float32Array]',
    float64Tag = '[object Float64Array]',
    int8Tag = '[object Int8Array]',
    int16Tag = '[object Int16Array]',
    int32Tag = '[object Int32Array]',
    uint8Tag = '[object Uint8Array]',
    uint8ClampedTag = '[object Uint8ClampedArray]',
    uint16Tag = '[object Uint16Array]',
    uint32Tag = '[object Uint32Array]';

/** Used to identify `toStringTag` values of typed arrays. */
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
typedArrayTags[errorTag] = typedArrayTags[funcTag] =
typedArrayTags[mapTag] = typedArrayTags[numberTag] =
typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
typedArrayTags[setTag] = typedArrayTags[stringTag] =
typedArrayTags[weakMapTag] = false;

/**
 * The base implementation of `_.isTypedArray` without Node.js optimizations.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
 */
function baseIsTypedArray(value) {
  return isObjectLike(value) &&
    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
}

module.exports = baseIsTypedArray;


/***/ }),

/***/ 4922:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JSONSchemaTypeVisitor: () => (/* binding */ JSONSchemaTypeVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7386);

/**
 * @public
 */
const JSONSchemaTypeVisitor = _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.JSONSchema.fixedFields.type;

/**
 * @public
 */
class TypeVisitor extends JSONSchemaTypeVisitor {
  ArrayElement(arrayElement) {
    const result = this.enter(arrayElement);
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TypeVisitor);

/***/ }),

/***/ 4982:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(94831);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);





/**
 * @public
 */
/**
 * @public
 */
class HeaderVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Header']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderVisitor);

/***/ }),

/***/ 5009:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ancestorLineageToJSONPointer: () => (/* binding */ ancestorLineageToJSONPointer),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(77259);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77551);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(48310);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9748);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45259);
/* harmony import */ var _namespace_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(90374);





/**
 * @public
 */
/**
 * @public
 */
/**
 * @public
 */
/**
 * Translates visitor ancestor lineage to a JSON Pointer tokens.
 * Ancestor lineage is constructed of following visitor method arguments:
 *
 *  - ancestors
 *  - parent
 *  - element
 * @public
 */
const ancestorLineageToJSONPointer = elementPath => {
  const jsonPointerTokens = elementPath.reduce((path, element, index) => {
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isMemberElement)(element)) {
      const token = String((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__["default"])(element.key));
      path.push(token);
    } else if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isArrayElement)(elementPath[index - 2])) {
      const token = String(elementPath[index - 2].content.indexOf(element));
      path.push(token);
    }
    return path;
  }, []);
  return (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_2__["default"])(jsonPointerTokens);
};

/**
 * @public
 */
const createToolbox = () => {
  const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.createNamespace)(_namespace_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]);
  const predicates = {
    ..._predicates_mjs__WEBPACK_IMPORTED_MODULE_5__,
    isElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isElement,
    isStringElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isStringElement,
    isArrayElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isArrayElement,
    isObjectElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isObjectElement,
    isMemberElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isMemberElement,
    isServersElement: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_6__.isServersElement,
    includesClasses: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.includesClasses,
    hasElementSourceMap: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.hasElementSourceMap
  };
  return {
    predicates,
    ancestorLineageToJSONPointer,
    namespace
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createToolbox);

/***/ }),

/***/ 5020:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _xuniqWith)
/* harmony export */ });
/* harmony import */ var _includesWith_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88496);
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21878);


var XUniqWith = /*#__PURE__*/function () {
  function XUniqWith(pred, xf) {
    this.xf = xf;
    this.pred = pred;
    this.items = [];
  }
  XUniqWith.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__["default"].init;
  XUniqWith.prototype['@@transducer/result'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__["default"].result;
  XUniqWith.prototype['@@transducer/step'] = function (result, input) {
    if ((0,_includesWith_js__WEBPACK_IMPORTED_MODULE_1__["default"])(this.pred, input, this.items)) {
      return result;
    } else {
      this.items.push(input);
      return this.xf['@@transducer/step'](result, input);
    }
  };
  return XUniqWith;
}();
function _xuniqWith(pred) {
  return function (xf) {
    return new XUniqWith(pred, xf);
  };
}

/***/ }),

/***/ 5051:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60020);
/* harmony import */ var _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(59145);


/**
 * This visitor is responsible for falling back to current traversed element
 * Given OpenApi3_0Visitor expects ObjectElement to be traversed. If
 * different Element is provided FallBackVisitor is responsible to assigning
 * this Element as current element.
 */
/**
 * @public
 */
class FallbackVisitor extends _Visitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  enter(element) {
    this.element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FallbackVisitor);

/***/ }),

/***/ 5052:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseMediaTypeVisitor: () => (/* binding */ BaseMediaTypeVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44515);


/**
 * @public
 */
const BaseMediaTypeVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.MediaType.$visitor;
/**
 * @public
 */
class MediaTypeVisitor extends BaseMediaTypeVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MediaTypeVisitor);

/***/ }),

/***/ 5187:
/***/ ((module) => {

/**
 * Checks if `value` is `null`.
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is `null`, else `false`.
 * @example
 *
 * _.isNull(null);
 * // => true
 *
 * _.isNull(void 0);
 * // => false
 */
function isNull(value) {
  return value === null;
}

module.exports = isNull;


/***/ }),

/***/ 5408:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class Callback extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.CallbackElement {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Callback);

/***/ }),

/***/ 5443:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);


/**
 * @public
 */
class Annotation extends minim__WEBPACK_IMPORTED_MODULE_0__.StringElement {
  // classes: warning | error

  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'annotation';
  }
  get code() {
    return this.attributes.get('code');
  }
  set code(value) {
    this.attributes.set('code', value);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Annotation);

/***/ }),

/***/ 5473:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82974);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37012);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(43022);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(77259);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95532);
/* harmony import */ var _normalize_header_examples_NormalizeStorage_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68429);



const removeSpaces = operationId => {
  return operationId.replace(/\s/g, '');
};
const replaceSpecialCharsWithUnderscore = operationId => {
  return operationId.replace(/\W/gi, '_');
};
const createNormalizedOperationId = (path, method) => {
  const normalizedMethod = replaceSpecialCharsWithUnderscore(removeSpaces(method.toLowerCase()));
  const normalizedPath = replaceSpecialCharsWithUnderscore(removeSpaces(path));
  return `${normalizedMethod}${normalizedPath}`;
};
const normalizeOperationId = (operationId, path, method) => {
  const withoutSpaces = removeSpaces(operationId);
  if (withoutSpaces.length > 0) {
    return replaceSpecialCharsWithUnderscore(withoutSpaces);
  }
  return createNormalizedOperationId(path, method);
};

/**
 * Normalization of Operation.operationId field.
 *
 * This normalization is not guided by OpenAPI 3.1 specification.
 *
 * Existing Operation.operationId fields are normalized into snake case form.
 *
 * Operation Objects, that do not define operationId field, are left untouched.
 *
 * Original operationId is stored in meta and as new `__originalOperationId` field.
 *
 * This plugin also guarantees the uniqueness of all defined Operation.operationId fields,
 * and make sure Link.operationId fields are pointing to correct and normalized Operation.operationId fields.
 *
 * NOTE: this plugin is idempotent
 * @public
 */

/* eslint-disable no-param-reassign */
/**
 * @public
 */
const plugin = ({
  storageField = 'x-normalized',
  operationIdNormalizer = normalizeOperationId
} = {}) => toolbox => {
  const {
    predicates,
    ancestorLineageToJSONPointer,
    namespace
  } = toolbox;
  const pathTemplates = [];
  const normalizedOperations = [];
  const links = [];
  let storage;
  return {
    visitor: {
      OpenApi3_1Element: {
        enter(element) {
          storage = new _normalize_header_examples_NormalizeStorage_mjs__WEBPACK_IMPORTED_MODULE_0__["default"](element, storageField, 'operation-ids');
        },
        leave() {
          // group normalized operations by normalized operationId
          const normalizedOperationGroups = (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(operationElement => {
            return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(operationElement.operationId);
          }, normalizedOperations);

          // append incremental numerical suffixes to identical operationIds
          Object.entries(normalizedOperationGroups).forEach(([normalizedOperationId, operationElements]) => {
            if (!Array.isArray(operationElements)) return;
            if (operationElements.length <= 1) return;
            operationElements.forEach((operationElement, index) => {
              const indexedNormalizedOperationId = `${normalizedOperationId}${index + 1}`;
              // @ts-ignore
              operationElement.operationId = new namespace.elements.String(indexedNormalizedOperationId);
            });
          });

          // rectify possibly broken Link.operationId fields
          links.forEach(linkElement => {
            if (typeof linkElement.operationId === 'undefined') return;
            const linkOperationId = String((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(linkElement.operationId));
            const operationElement = normalizedOperations.find(normalizedOperationElement => {
              const originalOperationId = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(normalizedOperationElement.meta.get('originalOperationId'));
              return originalOperationId === linkOperationId;
            });

            // Link Object doesn't need to be rectified
            if (typeof operationElement === 'undefined') return;
            linkElement.operationId = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.cloneDeep.safe(operationElement.operationId);
            linkElement.meta.set('originalOperationId', linkOperationId);
            linkElement.set('__originalOperationId', linkOperationId);
          });

          // cleanup the references
          normalizedOperations.length = 0;
          links.length = 0;
          storage = undefined;
        }
      },
      PathItemElement: {
        enter(pathItemElement) {
          // `path` meta may not be always available, e.g. in Callback Object or Components Object
          const pathTemplate = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])('path', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(pathItemElement.meta.get('path')));
          pathTemplates.push(pathTemplate);
        },
        leave() {
          pathTemplates.pop();
        }
      },
      OperationElement: {
        enter(operationElement, key, parent, path, ancestors) {
          // operationId field is undefined, needs no normalization
          if (typeof operationElement.operationId === 'undefined') return;
          const operationJSONPointer = ancestorLineageToJSONPointer([...ancestors, parent, operationElement]);

          // skip visiting this Operation Object if it's already normalized
          if (storage.includes(operationJSONPointer)) {
            return;
          }

          // cast operationId to string type
          const originalOperationId = String((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(operationElement.operationId));
          // perform operationId normalization
          const pathTemplate = (0,ramda__WEBPACK_IMPORTED_MODULE_5__["default"])(pathTemplates);
          // `http-method` meta may not be always available, e.g. in Callback Object or Components Object
          const method = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])('method', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(operationElement.meta.get('http-method')));
          const normalizedOperationId = operationIdNormalizer(originalOperationId, pathTemplate, method);

          // normalization is not necessary
          if (originalOperationId === normalizedOperationId) return;

          // @ts-ignore
          operationElement.operationId = new namespace.elements.String(normalizedOperationId);
          operationElement.set('__originalOperationId', originalOperationId);
          operationElement.meta.set('originalOperationId', originalOperationId);
          normalizedOperations.push(operationElement);
          storage.append(operationJSONPointer);
        }
      },
      LinkElement: {
        leave(linkElement) {
          // make sure this Link elements doesn't come from base namespace
          if (!predicates.isLinkElement(linkElement)) return;
          // ignore Link Objects with undefined operationId
          if (typeof linkElement.operationId === 'undefined') return;
          links.push(linkElement);
        }
      }
    }
  };
};
/* eslint-enable */

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugin);

/***/ }),

/***/ 5548:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_arrayReduce_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13430);
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(82506);




/**
 * An Object-specific version of [`map`](#map). The function is applied to three
 * arguments: *(value, key, obj)*. If only the value is significant, use
 * [`map`](#map) instead.
 *
 * @func
 * @memberOf R
 * @since v0.9.0
 * @category Object
 * @sig ((*, String, Object) -> *) -> Object -> Object
 * @param {Function} fn
 * @param {Object} obj
 * @return {Object}
 * @see R.map
 * @example
 *
 *      const xyz = { x: 1, y: 2, z: 3 };
 *      const prependKeyAndDouble = (num, key, obj) => key + (num * 2);
 *
 *      R.mapObjIndexed(prependKeyAndDouble, xyz); //=> { x: 'x2', y: 'y4', z: 'z6' }
 */
var mapObjIndexed = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function mapObjIndexed(fn, obj) {
  return (0,_internal_arrayReduce_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (acc, key) {
    acc[key] = fn(obj[key], key, obj);
    return acc;
  }, {}, (0,_keys_js__WEBPACK_IMPORTED_MODULE_2__["default"])(obj));
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mapObjIndexed);

/***/ }),

/***/ 5564:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Tests whether or not an object is an array.
 *
 * @private
 * @param {*} val The object to test.
 * @return {Boolean} `true` if `val` is an array, `false` otherwise.
 * @example
 *
 *      _isArray([]); //=> true
 *      _isArray(null); //=> false
 *      _isArray({}); //=> false
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Array.isArray || function _isArray(val) {
  return val != null && val.length >= 0 && Object.prototype.toString.call(val) === '[object Array]';
});

/***/ }),

/***/ 5765:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class OperationSecurity extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'operation-security';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationSecurity.primaryClass);
    this.classes.push('security');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationSecurity);

/***/ }),

/***/ 5861:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var DataView = __webpack_require__(55580),
    Map = __webpack_require__(68223),
    Promise = __webpack_require__(32804),
    Set = __webpack_require__(76545),
    WeakMap = __webpack_require__(28303),
    baseGetTag = __webpack_require__(72552),
    toSource = __webpack_require__(47473);

/** `Object#toString` result references. */
var mapTag = '[object Map]',
    objectTag = '[object Object]',
    promiseTag = '[object Promise]',
    setTag = '[object Set]',
    weakMapTag = '[object WeakMap]';

var dataViewTag = '[object DataView]';

/** Used to detect maps, sets, and weakmaps. */
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map),
    promiseCtorString = toSource(Promise),
    setCtorString = toSource(Set),
    weakMapCtorString = toSource(WeakMap);

/**
 * Gets the `toStringTag` of `value`.
 *
 * @private
 * @param {*} value The value to query.
 * @returns {string} Returns the `toStringTag`.
 */
var getTag = baseGetTag;

// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map && getTag(new Map) != mapTag) ||
    (Promise && getTag(Promise.resolve()) != promiseTag) ||
    (Set && getTag(new Set) != setTag) ||
    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  getTag = function(value) {
    var result = baseGetTag(value),
        Ctor = result == objectTag ? value.constructor : undefined,
        ctorString = Ctor ? toSource(Ctor) : '';

    if (ctorString) {
      switch (ctorString) {
        case dataViewCtorString: return dataViewTag;
        case mapCtorString: return mapTag;
        case promiseCtorString: return promiseTag;
        case setCtorString: return setTag;
        case weakMapCtorString: return weakMapTag;
      }
    }
    return result;
  };
}

module.exports = getTag;


/***/ }),

/***/ 5869:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRefractor: () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _plugins_dispatcher_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4366);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43319);
/* harmony import */ var _clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(95532);
/* harmony import */ var _predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27121);
/* harmony import */ var _toolbox_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(88920);





const refract = (value, {
  Type,
  plugins = []
}) => {
  /**
   * This is where values gets refracted into generic ApiDOM.
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const element = new Type(value);
  if ((0,_predicates_index_mjs__WEBPACK_IMPORTED_MODULE_0__.isElement)(value)) {
    if (value.meta.length > 0) {
      element.meta = (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(value.meta);
    }
    if (value.attributes.length > 0) {
      element.attributes = (0,_clone_index_mjs__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(value.attributes);
    }
  }

  /**
   * Run plugins only when necessary.
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_plugins_dispatcher_index_mjs__WEBPACK_IMPORTED_MODULE_2__.dispatchPluginsSync)(element, plugins, {
    toolboxCreator: _toolbox_mjs__WEBPACK_IMPORTED_MODULE_3__["default"],
    visitorOptions: {
      nodeTypeGetter: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_4__.getNodeType
    }
  });
};
const createRefractor = Type => (value, options = {}) => refract(value, {
  ...options,
  Type
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 5920:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2173);
/* harmony import */ var _internal_xReduce_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(78475);
/* harmony import */ var _internal_xwrap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47141);




/**
 * Returns a single item by iterating through the list, successively calling
 * the iterator function and passing it an accumulator value and the current
 * value from the array, and then passing the result to the next call.
 *
 * The iterator function receives two values: *(acc, value)*. It may use
 * [`R.reduced`](#reduced) to shortcut the iteration.
 *
 * The arguments' order of [`reduceRight`](#reduceRight)'s iterator function
 * is *(value, acc)*.
 *
 * Note: `R.reduce` does not skip deleted or unassigned indices (sparse
 * arrays), unlike the native `Array.prototype.reduce` method. For more details
 * on this behavior, see:
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/reduce#Description
 *
 * Be cautious of mutating and returning the accumulator. If you reuse it across
 * invocations, it will continue to accumulate onto the same value. The general
 * recommendation is to always return a new value. If you can't do so for
 * performance reasons, then be sure to reinitialize the accumulator on each
 * invocation.
 *
 * Dispatches to the `reduce` method of the third argument, if present. When
 * doing so, it is up to the user to handle the [`R.reduced`](#reduced)
 * shortcuting, as this is not implemented by `reduce`.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig ((a, b) -> a) -> a -> [b] -> a
 * @param {Function} fn The iterator function. Receives two values, the accumulator and the
 *        current element from the array.
 * @param {*} acc The accumulator value.
 * @param {Array} list The list to iterate over.
 * @return {*} The final, accumulated value.
 * @see R.reduced, R.addIndex, R.reduceRight
 * @example
 *
 *      R.reduce(R.subtract, 0, [1, 2, 3, 4]) // => ((((0 - 1) - 2) - 3) - 4) = -10
 *      //          -               -10
 *      //         / \              / \
 *      //        -   4           -6   4
 *      //       / \              / \
 *      //      -   3   ==>     -3   3
 *      //     / \              / \
 *      //    -   2           -1   2
 *      //   / \              / \
 *      //  0   1            0   1
 *
 * @symb R.reduce(f, a, [b, c, d]) = f(f(f(a, b), c), d)
 */
var reduce = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function (xf, acc, list) {
  return (0,_internal_xReduce_js__WEBPACK_IMPORTED_MODULE_1__["default"])(typeof xf === 'function' ? (0,_internal_xwrap_js__WEBPACK_IMPORTED_MODULE_2__["default"])(xf) : xf, acc, list);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (reduce);

/***/ }),

/***/ 5987:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _internal_isInteger_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(64279);
/* harmony import */ var _internal_nth_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56359);




/**
 * Returns a function that when supplied an object returns the indicated
 * property of that object, if it exists.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @typedefn Idx = String | Int | Symbol
 * @sig Idx -> {s: a} -> a | Undefined
 * @param {String|Number} p The property name or array index
 * @param {Object} obj The object to query
 * @return {*} The value at `obj.p`.
 * @see R.path, R.props, R.pluck, R.project, R.nth
 * @example
 *
 *      R.prop('x', {x: 100}); //=> 100
 *      R.prop('x', {}); //=> undefined
 *      R.prop(0, [100]); //=> 100
 *      R.compose(R.inc, R.prop('x'))({ x: 3 }) //=> 4
 */

var prop = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function prop(p, obj) {
  if (obj == null) {
    return;
  }
  return (0,_internal_isInteger_js__WEBPACK_IMPORTED_MODULE_1__["default"])(p) ? (0,_internal_nth_js__WEBPACK_IMPORTED_MODULE_2__["default"])(p, obj) : obj[p];
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (prop);

/***/ }),

/***/ 6048:
/***/ ((module) => {

/** Error message constants. */
var FUNC_ERROR_TEXT = 'Expected a function';

/**
 * Creates a function that negates the result of the predicate `func`. The
 * `func` predicate is invoked with the `this` binding and arguments of the
 * created function.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category Function
 * @param {Function} predicate The predicate to negate.
 * @returns {Function} Returns the new negated function.
 * @example
 *
 * function isEven(n) {
 *   return n % 2 == 0;
 * }
 *
 * _.filter([1, 2, 3, 4, 5, 6], _.negate(isEven));
 * // => [1, 3, 5]
 */
function negate(predicate) {
  if (typeof predicate != 'function') {
    throw new TypeError(FUNC_ERROR_TEXT);
  }
  return function() {
    var args = arguments;
    switch (args.length) {
      case 0: return !predicate.call(this);
      case 1: return !predicate.call(this, args[0]);
      case 2: return !predicate.call(this, args[0], args[1]);
      case 3: return !predicate.call(this, args[0], args[1], args[2]);
    }
    return !predicate.apply(this, args);
  };
}

module.exports = negate;


/***/ }),

/***/ 6127:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);


/**
 * @public
 */
class Comment extends minim__WEBPACK_IMPORTED_MODULE_0__.StringElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'comment';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Comment);

/***/ }),

/***/ 6135:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62287);

/**
 * @public
 */
class ExamplesVisitor extends _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__["default"] {
  ArrayElement(arrayElement) {
    const result = this.enter(arrayElement);
    this.element.classes.push('json-schema-examples');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExamplesVisitor);

/***/ }),

/***/ 6163:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   merge: () => (/* binding */ merge)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19210);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24445);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40932);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(24454);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(17992);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13380);
/* harmony import */ var _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(96664);



/**
 * Algorithm for deep merging options.
 */

const baseURILens = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])((0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['resolve', 'baseURI']), (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(['resolve', 'baseURI']));
const baseURIDefault = baseURI => (0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_3__["default"])(baseURI) ? (0,_util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.cwd)() : baseURI;

/**
 * @public
 */
// eslint-disable-next-line import/prefer-default-export
const merge = (lObj, rObj) => {
  const withoutDefaults = (0,ramda__WEBPACK_IMPORTED_MODULE_5__["default"])(lObj, rObj);
  // @ts-ignore
  return (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])(baseURILens, baseURIDefault, withoutDefaults);
};

/***/ }),

/***/ 6233:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(6048);
const Element = __webpack_require__(10316);
const ArraySlice = __webpack_require__(92340);

/**
 * @class
 *
 * @param {Element[]} content
 * @param meta
 * @param attributes
 */
class ArrayElement extends Element {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'array';
  }

  primitive() {
    return 'array';
  }

  /**
   * @returns {Element}
   */
  get(index) {
    return this.content[index];
  }

  /**
   * Helper for returning the value of an item
   * This works for both ArrayElement and ObjectElement instances
   */
  getValue(indexOrKey) {
    const item = this.get(indexOrKey);

    if (item) {
      return item.toValue();
    }

    return undefined;
  }

  /**
   * @returns {Element}
   */
  getIndex(index) {
    return this.content[index];
  }

  set(index, value) {
    this.content[index] = this.refract(value);
    return this;
  }

  remove(index) {
    const removed = this.content.splice(index, 1);

    if (removed.length) {
      return removed[0];
    }

    return null;
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   */
  map(callback, thisArg) {
    return this.content.map(callback, thisArg);
  }

  /**
   * Maps and then flattens the results.
   * @param callback - Function to execute for each element.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {array}
   */
  flatMap(callback, thisArg) {
    return this
      .map(callback, thisArg)
      .reduce((a, b) => a.concat(b), []);
  }

  /**
   * Returns an array containing the truthy results of calling the given transformation with each element of this sequence
   * @param transform - A closure that accepts an element of this array as its argument and returns an optional value.
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArrayElement.prototype
   * @returns An array of the non-undefined results of calling transform with each element of the array
   */
  compactMap(transform, thisArg) {
    const results = [];

    this.forEach((element) => {
      const result = transform.bind(thisArg)(element);

      if (result) {
        results.push(result);
      }
    });

    return results;
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   */
  filter(callback, thisArg) {
    return new ArraySlice(this.content.filter(callback, thisArg));
  }

  /**
   * @param callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @returns {ArraySlice}
   */
  reject(callback, thisArg) {
    return this.filter(negate(callback), thisArg);
  }

  /**
   * This is a reduce function specifically for Minim arrays and objects. It
   * allows for returning normal values or Minim instances, so it converts any
   * primitives on each step.
   */
  reduce(callback, initialValue) {
    let startIndex;
    let memo;

    // Allows for defining a starting value of the reduce
    if (initialValue !== undefined) {
      startIndex = 0;
      memo = this.refract(initialValue);
    } else {
      startIndex = 1;
      // Object Element content items are member elements. Because of this,
      // the memo should start out as the member value rather than the
      // actual member itself.
      memo = this.primitive() === 'object' ? this.first.value : this.first;
    }

    // Sending each function call to the registry allows for passing Minim
    // instances through the function return. This means you can return
    // primitive values or return Minim instances and reduce will still work.
    for (let i = startIndex; i < this.length; i += 1) {
      const item = this.content[i];

      if (this.primitive() === 'object') {
        memo = this.refract(callback(memo, item.value, item.key, item, this));
      } else {
        memo = this.refract(callback(memo, item, i, this));
      }
    }

    return memo;
  }

  /**
   * @callback forEachCallback
   * @param {Element} currentValue
   * @param {NumberElement} index
   */

  /**
   * @param {forEachCallback} callback - Function to execute for each element
   * @param thisArg - Value to use as this (i.e the reference Object) when executing callback
   * @memberof ArrayElement.prototype
   */
  forEach(callback, thisArg) {
    this.content.forEach((item, index) => {
      callback.bind(thisArg)(item, this.refract(index));
    });
  }

  /**
   * @returns {Element}
   */
  shift() {
    return this.content.shift();
  }

  /**
   * @param value
   */
  unshift(value) {
    this.content.unshift(this.refract(value));
  }

  /**
   * @param value
   */
  push(value) {
    this.content.push(this.refract(value));
    return this;
  }

  /**
   * @param value
   */
  add(value) {
    this.push(value);
  }

  /**
   * Recusively search all descendents using a condition function.
   * @returns {Element[]}
   */
  findElements(condition, givenOptions) {
    const options = givenOptions || {};
    const recursive = !!options.recursive;
    const results = options.results === undefined ? [] : options.results;

    // The forEach method for Object Elements returns value, key, and member.
    // This passes those along to the condition function below.
    this.forEach((item, keyOrIndex, member) => {
      // We use duck-typing here to support any registered class that
      // may contain other elements.
      if (recursive && (item.findElements !== undefined)) {
        item.findElements(condition, {
          results,
          recursive,
        });
      }

      if (condition(item, keyOrIndex, member)) {
        results.push(item);
      }
    });

    return results;
  }

  /**
   * Recusively search all descendents using a condition function.
   * @param condition
   * @returns {ArraySlice}
   */
  find(condition) {
    return new ArraySlice(this.findElements(condition, { recursive: true }));
  }

  /**
   * @param {string} element
   * @returns {ArraySlice}
   */
  findByElement(element) {
    return this.find(item => item.element === element);
  }

  /**
   * @param {string} className
   * @returns {ArraySlice}
   * @memberof ArrayElement.prototype
   */
  findByClass(className) {
    return this.find(item => item.classes.includes(className));
  }

  /**
   * Search the tree recursively and find the element with the matching ID
   * @param {string} id
   * @returns {Element}
   * @memberof ArrayElement.prototype
   */
  getById(id) {
    return this.find(item => item.id.toValue() === id).first;
  }

  /**
   * Looks for matching children using deep equality
   * @param value
   * @returns {boolean}
   */
  includes(value) {
    return this.content.some(element => element.equals(value));
  }

  /**
   * Looks for matching children using deep equality
   * @param value
   * @returns {boolean}
   * @see includes
   * @deprecated method was replaced by includes
   */
  contains(value) {
    return this.includes(value);
  }

  // Fantasy Land

  /**
   * @returns {ArrayElement} An empty array element
   */
  empty() {
    return new this.constructor([]);
  }

  ['fantasy-land/empty']() {
    return this.empty();
  }

  /**
   * @param {ArrayElement} other
   * @returns {ArrayElement}
   */
  concat(other) {
    return new this.constructor(this.content.concat(other.content));
  }

  ['fantasy-land/concat'](other) {
    return this.concat(other);
  }

  ['fantasy-land/map'](transform) {
    return new this.constructor(this.map(transform));
  }

  ['fantasy-land/chain'](transform) {
    return this
      .map(element => transform(element), this)
      .reduce((a, b) => a.concat(b), this.empty());
  }

  ['fantasy-land/filter'](callback) {
    return new this.constructor(this.content.filter(callback));
  }

  ['fantasy-land/reduce'](transform, initialValue) {
    return this.content.reduce(transform, initialValue);
  }

  /**
   * Returns the length of the collection
   * @type number
   */
  get length() {
    return this.content.length;
  }

  /**
   * Returns whether the collection is empty
   * @type boolean
   */
  get isEmpty() {
    return this.content.length === 0;
  }

  /**
   * Return the first item in the collection
   * @type Element
   */
  get first() {
    return this.getIndex(0);
  }

  /**
   * Return the second item in the collection
   * @type Element
   */
  get second() {
    return this.getIndex(1);
  }

  /**
   * Return the last item in the collection
   * @type Element
   */
  get last() {
    return this.getIndex(this.length - 1);
  }
}

/**
 * @returns {ArrayElement} An empty array element
 */
ArrayElement.empty = function empty() {
  return new this();
};

ArrayElement['fantasy-land/empty'] = ArrayElement.empty;

if (typeof Symbol !== 'undefined') {
  ArrayElement.prototype[Symbol.iterator] = function symbol() {
    return this.content[Symbol.iterator]();
  };
}

module.exports = ArrayElement;


/***/ }),

/***/ 6294:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   compare: () => (/* binding */ compare),
/* harmony export */   generate: () => (/* binding */ generate),
/* harmony export */   observe: () => (/* binding */ observe),
/* harmony export */   unobserve: () => (/* binding */ unobserve)
/* harmony export */ });
/* harmony import */ var _helpers_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27607);
/* harmony import */ var _core_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61405);
/*!
 * https://github.com/Starcounter-Jack/JSON-Patch
 * (c) 2017-2021 Joachim Wester
 * MIT license
 */


var beforeDict = new WeakMap();
var Mirror = /** @class */ (function () {
    function Mirror(obj) {
        this.observers = new Map();
        this.obj = obj;
    }
    return Mirror;
}());
var ObserverInfo = /** @class */ (function () {
    function ObserverInfo(callback, observer) {
        this.callback = callback;
        this.observer = observer;
    }
    return ObserverInfo;
}());
function getMirror(obj) {
    return beforeDict.get(obj);
}
function getObserverFromMirror(mirror, callback) {
    return mirror.observers.get(callback);
}
function removeObserverFromMirror(mirror, observer) {
    mirror.observers.delete(observer.callback);
}
/**
 * Detach an observer from an object
 */
function unobserve(root, observer) {
    observer.unobserve();
}
/**
 * Observes changes made to an object, which can then be retrieved using generate
 */
function observe(obj, callback) {
    var patches = [];
    var observer;
    var mirror = getMirror(obj);
    if (!mirror) {
        mirror = new Mirror(obj);
        beforeDict.set(obj, mirror);
    }
    else {
        var observerInfo = getObserverFromMirror(mirror, callback);
        observer = observerInfo && observerInfo.observer;
    }
    if (observer) {
        return observer;
    }
    observer = {};
    mirror.value = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__._deepClone)(obj);
    if (callback) {
        observer.callback = callback;
        observer.next = null;
        var dirtyCheck = function () {
            generate(observer);
        };
        var fastCheck = function () {
            clearTimeout(observer.next);
            observer.next = setTimeout(dirtyCheck);
        };
        if (typeof window !== 'undefined') { //not Node
            window.addEventListener('mouseup', fastCheck);
            window.addEventListener('keyup', fastCheck);
            window.addEventListener('mousedown', fastCheck);
            window.addEventListener('keydown', fastCheck);
            window.addEventListener('change', fastCheck);
        }
    }
    observer.patches = patches;
    observer.object = obj;
    observer.unobserve = function () {
        generate(observer);
        clearTimeout(observer.next);
        removeObserverFromMirror(mirror, observer);
        if (typeof window !== 'undefined') {
            window.removeEventListener('mouseup', fastCheck);
            window.removeEventListener('keyup', fastCheck);
            window.removeEventListener('mousedown', fastCheck);
            window.removeEventListener('keydown', fastCheck);
            window.removeEventListener('change', fastCheck);
        }
    };
    mirror.observers.set(callback, new ObserverInfo(callback, observer));
    return observer;
}
/**
 * Generate an array of patches from an observer
 */
function generate(observer, invertible) {
    if (invertible === void 0) { invertible = false; }
    var mirror = beforeDict.get(observer.object);
    _generate(mirror.value, observer.object, observer.patches, "", invertible);
    if (observer.patches.length) {
        (0,_core_mjs__WEBPACK_IMPORTED_MODULE_1__.applyPatch)(mirror.value, observer.patches);
    }
    var temp = observer.patches;
    if (temp.length > 0) {
        observer.patches = [];
        if (observer.callback) {
            observer.callback(temp);
        }
    }
    return temp;
}
// Dirty check if obj is different from mirror, generate patches and update mirror
function _generate(mirror, obj, patches, path, invertible) {
    if (obj === mirror) {
        return;
    }
    if (typeof obj.toJSON === "function") {
        obj = obj.toJSON();
    }
    var newKeys = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__._objectKeys)(obj);
    var oldKeys = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__._objectKeys)(mirror);
    var changed = false;
    var deleted = false;
    //if ever "move" operation is implemented here, make sure this test runs OK: "should not generate the same patch twice (move)"
    for (var t = oldKeys.length - 1; t >= 0; t--) {
        var key = oldKeys[t];
        var oldVal = mirror[key];
        if ((0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__.hasOwnProperty)(obj, key) && !(obj[key] === undefined && oldVal !== undefined && Array.isArray(obj) === false)) {
            var newVal = obj[key];
            if (typeof oldVal == "object" && oldVal != null && typeof newVal == "object" && newVal != null && Array.isArray(oldVal) === Array.isArray(newVal)) {
                _generate(oldVal, newVal, patches, path + "/" + (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__.escapePathComponent)(key), invertible);
            }
            else {
                if (oldVal !== newVal) {
                    changed = true;
                    if (invertible) {
                        patches.push({ op: "test", path: path + "/" + (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__.escapePathComponent)(key), value: (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__._deepClone)(oldVal) });
                    }
                    patches.push({ op: "replace", path: path + "/" + (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__.escapePathComponent)(key), value: (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__._deepClone)(newVal) });
                }
            }
        }
        else if (Array.isArray(mirror) === Array.isArray(obj)) {
            if (invertible) {
                patches.push({ op: "test", path: path + "/" + (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__.escapePathComponent)(key), value: (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__._deepClone)(oldVal) });
            }
            patches.push({ op: "remove", path: path + "/" + (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__.escapePathComponent)(key) });
            deleted = true; // property has been deleted
        }
        else {
            if (invertible) {
                patches.push({ op: "test", path: path, value: mirror });
            }
            patches.push({ op: "replace", path: path, value: obj });
            changed = true;
        }
    }
    if (!deleted && newKeys.length == oldKeys.length) {
        return;
    }
    for (var t = 0; t < newKeys.length; t++) {
        var key = newKeys[t];
        if (!(0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__.hasOwnProperty)(mirror, key) && obj[key] !== undefined) {
            patches.push({ op: "add", path: path + "/" + (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__.escapePathComponent)(key), value: (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_0__._deepClone)(obj[key]) });
        }
    }
}
/**
 * Create an array of patches from the differences in two objects
 */
function compare(tree1, tree2, invertible) {
    if (invertible === void 0) { invertible = false; }
    var patches = [];
    _generate(tree1, tree2, patches, '', invertible);
    return patches;
}


/***/ }),

/***/ 6308:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);

/**
 * @public
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
class OpenApi3_1 extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'openApi3_1';
    this.classes.push('api');
  }
  get openapi() {
    return this.get('openapi');
  }
  set openapi(openapi) {
    this.set('openapi', openapi);
  }
  get info() {
    return this.get('info');
  }
  set info(info) {
    this.set('info', info);
  }
  get jsonSchemaDialect() {
    return this.get('jsonSchemaDialect');
  }
  set jsonSchemaDialect(jsonSchemaDialect) {
    this.set('jsonSchemaDialect', jsonSchemaDialect);
  }
  get servers() {
    return this.get('servers');
  }
  set servers(servers) {
    this.set('servers', servers);
  }
  get paths() {
    return this.get('paths');
  }
  set paths(paths) {
    this.set('paths', paths);
  }
  get components() {
    return this.get('components');
  }
  set components(components) {
    this.set('components', components);
  }
  get security() {
    return this.get('security');
  }
  set security(security) {
    this.set('security', security);
  }
  get tags() {
    return this.get('tags');
  }
  set tags(tags) {
    this.set('tags', tags);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
  get webhooks() {
    return this.get('webhooks');
  }
  set webhooks(webhooks) {
    this.set('webhooks', webhooks);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenApi3_1);

/***/ }),

/***/ 6367:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25845);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(11182);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1322);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(85883);


/**
 * Checks if value is a `Number` primitive or object.
 *
 * @func isNumber
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.6.0|v0.6.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotNumber|isNotNumber}
 * @example
 *
 * RA.isNumber(5); // => true
 * RA.isNumber(Number.MAX_VALUE); // => true
 * RA.isNumber(-Infinity); // => true
 * RA.isNumber(NaN); // => true
 * RA.isNumber('5'); // => false
 */
var isNumber = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(1, (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(ramda__WEBPACK_IMPORTED_MODULE_2__["default"], (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])('Number')));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNumber);

/***/ }),

/***/ 6499:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);

var id = 0;
var postfix = Math.random();
var toString = uncurryThis(1.0.toString);

module.exports = function (key) {
  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString(++id + postfix, 36);
};


/***/ }),

/***/ 6549:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(11892);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(95532);
/* harmony import */ var _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77116);
/* harmony import */ var _generics_PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(87110);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9748);







/**
 * @public
 */
/**
 * @public
 */
class PathsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'PathItem']);
    this.canSupportSpecificationExtensions = true;
    this.fieldPatternPredicate = ramda__WEBPACK_IMPORTED_MODULE_5__["default"];
  }
  ObjectElement(objectElement) {
    const result = _generics_PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every PathItemElement with path metadata
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_6__.isPathItemElement)
    // @ts-ignore
    .forEach((pathItemElement, key) => {
      key.classes.push('openapi-path-template');
      key.classes.push('path-template');
      pathItemElement.setMetaProperty('path', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__.cloneDeep)(key));
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathsVisitor);

/***/ }),

/***/ 6557:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1908);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48018);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39633);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9748);






/**
 * @public
 */
/**
 * @public
 */
class ExamplesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ObjectElement();
    this.element.classes.push('examples');
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Example'];
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'example');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExamplesVisitor);

/***/ }),

/***/ 6720:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25690);
/* harmony import */ var _isNull_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(41259);



/**
 * Checks if input value is complement of `null`.
 *
 * @func isNotNull
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.1.0|v0.1.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNull|isNull}
 * @example
 *
 * RA.isNotNull(1); //=> true
 * RA.isNotNull(undefined); //=> true
 * RA.isNotNull(null); //=> false
 */
var isNotNull = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(_isNull_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNotNull);

/***/ }),

/***/ 6817:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(83832);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);





/**
 * @public
 */
/**
 * @public
 */
class TagVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Tag']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TagVisitor);

/***/ }),

/***/ 6915:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48018);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _elements_nces_LinkParameters_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(64808);





/**
 * @public
 */
/**
 * @public
 */
class ParametersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_LinkParameters_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['value']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParametersVisitor);

/***/ }),

/***/ 6993:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Mixin: () => (/* binding */ Mixin),
/* harmony export */   decorate: () => (/* binding */ decorate),
/* harmony export */   hasMixin: () => (/* binding */ hasMixin),
/* harmony export */   mix: () => (/* binding */ mix),
/* harmony export */   settings: () => (/* binding */ settings)
/* harmony export */ });
/**
 * Utility function that works like `Object.apply`, but copies getters and setters properly as well.  Additionally gives
 * the option to exclude properties by name.
 */
const copyProps = (dest, src, exclude = []) => {
    const props = Object.getOwnPropertyDescriptors(src);
    for (let prop of exclude)
        delete props[prop];
    Object.defineProperties(dest, props);
};
/**
 * Returns the full chain of prototypes up until Object.prototype given a starting object.  The order of prototypes will
 * be closest to farthest in the chain.
 */
const protoChain = (obj, currentChain = [obj]) => {
    const proto = Object.getPrototypeOf(obj);
    if (proto === null)
        return currentChain;
    return protoChain(proto, [...currentChain, proto]);
};
/**
 * Identifies the nearest ancestor common to all the given objects in their prototype chains.  For most unrelated
 * objects, this function should return Object.prototype.
 */
const nearestCommonProto = (...objs) => {
    if (objs.length === 0)
        return undefined;
    let commonProto = undefined;
    const protoChains = objs.map(obj => protoChain(obj));
    while (protoChains.every(protoChain => protoChain.length > 0)) {
        const protos = protoChains.map(protoChain => protoChain.pop());
        const potentialCommonProto = protos[0];
        if (protos.every(proto => proto === potentialCommonProto))
            commonProto = potentialCommonProto;
        else
            break;
    }
    return commonProto;
};
/**
 * Creates a new prototype object that is a mixture of the given prototypes.  The mixing is achieved by first
 * identifying the nearest common ancestor and using it as the prototype for a new object.  Then all properties/methods
 * downstream of this prototype (ONLY downstream) are copied into the new object.
 *
 * The resulting prototype is more performant than softMixProtos(...), as well as ES5 compatible.  However, it's not as
 * flexible as updates to the source prototypes aren't captured by the mixed result.  See softMixProtos for why you may
 * want to use that instead.
 */
const hardMixProtos = (ingredients, constructor, exclude = []) => {
    var _a;
    const base = (_a = nearestCommonProto(...ingredients)) !== null && _a !== void 0 ? _a : Object.prototype;
    const mixedProto = Object.create(base);
    // Keeps track of prototypes we've already visited to avoid copying the same properties multiple times.  We init the
    // list with the proto chain below the nearest common ancestor because we don't want any of those methods mixed in
    // when they will already be accessible via prototype access.
    const visitedProtos = protoChain(base);
    for (let prototype of ingredients) {
        let protos = protoChain(prototype);
        // Apply the prototype chain in reverse order so that old methods don't override newer ones.
        for (let i = protos.length - 1; i >= 0; i--) {
            let newProto = protos[i];
            if (visitedProtos.indexOf(newProto) === -1) {
                copyProps(mixedProto, newProto, ['constructor', ...exclude]);
                visitedProtos.push(newProto);
            }
        }
    }
    mixedProto.constructor = constructor;
    return mixedProto;
};
const unique = (arr) => arr.filter((e, i) => arr.indexOf(e) == i);

/**
 * Finds the ingredient with the given prop, searching in reverse order and breadth-first if searching ingredient
 * prototypes is required.
 */
const getIngredientWithProp = (prop, ingredients) => {
    const protoChains = ingredients.map(ingredient => protoChain(ingredient));
    // since we search breadth-first, we need to keep track of our depth in the prototype chains
    let protoDepth = 0;
    // not all prototype chains are the same depth, so this remains true as long as at least one of the ingredients'
    // prototype chains has an object at this depth
    let protosAreLeftToSearch = true;
    while (protosAreLeftToSearch) {
        // with the start of each horizontal slice, we assume this is the one that's deeper than any of the proto chains
        protosAreLeftToSearch = false;
        // scan through the ingredients right to left
        for (let i = ingredients.length - 1; i >= 0; i--) {
            const searchTarget = protoChains[i][protoDepth];
            if (searchTarget !== undefined && searchTarget !== null) {
                // if we find something, this is proof that this horizontal slice potentially more objects to search
                protosAreLeftToSearch = true;
                // eureka, we found it
                if (Object.getOwnPropertyDescriptor(searchTarget, prop) != undefined) {
                    return protoChains[i][0];
                }
            }
        }
        protoDepth++;
    }
    return undefined;
};
/**
 * "Mixes" ingredients by wrapping them in a Proxy.  The optional prototype argument allows the mixed object to sit
 * downstream of an existing prototype chain.  Note that "properties" cannot be added, deleted, or modified.
 */
const proxyMix = (ingredients, prototype = Object.prototype) => new Proxy({}, {
    getPrototypeOf() {
        return prototype;
    },
    setPrototypeOf() {
        throw Error('Cannot set prototype of Proxies created by ts-mixer');
    },
    getOwnPropertyDescriptor(_, prop) {
        return Object.getOwnPropertyDescriptor(getIngredientWithProp(prop, ingredients) || {}, prop);
    },
    defineProperty() {
        throw new Error('Cannot define new properties on Proxies created by ts-mixer');
    },
    has(_, prop) {
        return getIngredientWithProp(prop, ingredients) !== undefined || prototype[prop] !== undefined;
    },
    get(_, prop) {
        return (getIngredientWithProp(prop, ingredients) || prototype)[prop];
    },
    set(_, prop, val) {
        const ingredientWithProp = getIngredientWithProp(prop, ingredients);
        if (ingredientWithProp === undefined)
            throw new Error('Cannot set new properties on Proxies created by ts-mixer');
        ingredientWithProp[prop] = val;
        return true;
    },
    deleteProperty() {
        throw new Error('Cannot delete properties on Proxies created by ts-mixer');
    },
    ownKeys() {
        return ingredients
            .map(Object.getOwnPropertyNames)
            .reduce((prev, curr) => curr.concat(prev.filter(key => curr.indexOf(key) < 0)));
    },
});
/**
 * Creates a new proxy-prototype object that is a "soft" mixture of the given prototypes.  The mixing is achieved by
 * proxying all property access to the ingredients.  This is not ES5 compatible and less performant.  However, any
 * changes made to the source prototypes will be reflected in the proxy-prototype, which may be desirable.
 */
const softMixProtos = (ingredients, constructor) => proxyMix([...ingredients, { constructor }]);

const settings = {
    initFunction: null,
    staticsStrategy: 'copy',
    prototypeStrategy: 'copy',
    decoratorInheritance: 'deep',
};

// Keeps track of constituent classes for every mixin class created by ts-mixer.
const mixins = new WeakMap();
const getMixinsForClass = (clazz) => mixins.get(clazz);
const registerMixins = (mixedClass, constituents) => mixins.set(mixedClass, constituents);
const hasMixin = (instance, mixin) => {
    if (instance instanceof mixin)
        return true;
    const constructor = instance.constructor;
    const visited = new Set();
    let frontier = new Set();
    frontier.add(constructor);
    while (frontier.size > 0) {
        // check if the frontier has the mixin we're looking for.  if not, we can say we visited every item in the frontier
        if (frontier.has(mixin))
            return true;
        frontier.forEach((item) => visited.add(item));
        // build a new frontier based on the associated mixin classes and prototype chains of each frontier item
        const newFrontier = new Set();
        frontier.forEach((item) => {
            var _a;
            const itemConstituents = (_a = mixins.get(item)) !== null && _a !== void 0 ? _a : protoChain(item.prototype)
                .map((proto) => proto.constructor)
                .filter((item) => item !== null);
            if (itemConstituents)
                itemConstituents.forEach((constituent) => {
                    if (!visited.has(constituent) && !frontier.has(constituent))
                        newFrontier.add(constituent);
                });
        });
        // we have a new frontier, now search again
        frontier = newFrontier;
    }
    // if we get here, we couldn't find the mixin anywhere in the prototype chain or associated mixin classes
    return false;
};

const mergeObjectsOfDecorators = (o1, o2) => {
    var _a, _b;
    const allKeys = unique([...Object.getOwnPropertyNames(o1), ...Object.getOwnPropertyNames(o2)]);
    const mergedObject = {};
    for (let key of allKeys)
        mergedObject[key] = unique([...((_a = o1 === null || o1 === void 0 ? void 0 : o1[key]) !== null && _a !== void 0 ? _a : []), ...((_b = o2 === null || o2 === void 0 ? void 0 : o2[key]) !== null && _b !== void 0 ? _b : [])]);
    return mergedObject;
};
const mergePropertyAndMethodDecorators = (d1, d2) => {
    var _a, _b, _c, _d;
    return ({
        property: mergeObjectsOfDecorators((_a = d1 === null || d1 === void 0 ? void 0 : d1.property) !== null && _a !== void 0 ? _a : {}, (_b = d2 === null || d2 === void 0 ? void 0 : d2.property) !== null && _b !== void 0 ? _b : {}),
        method: mergeObjectsOfDecorators((_c = d1 === null || d1 === void 0 ? void 0 : d1.method) !== null && _c !== void 0 ? _c : {}, (_d = d2 === null || d2 === void 0 ? void 0 : d2.method) !== null && _d !== void 0 ? _d : {}),
    });
};
const mergeDecorators = (d1, d2) => {
    var _a, _b, _c, _d, _e, _f;
    return ({
        class: unique([...(_a = d1 === null || d1 === void 0 ? void 0 : d1.class) !== null && _a !== void 0 ? _a : [], ...(_b = d2 === null || d2 === void 0 ? void 0 : d2.class) !== null && _b !== void 0 ? _b : []]),
        static: mergePropertyAndMethodDecorators((_c = d1 === null || d1 === void 0 ? void 0 : d1.static) !== null && _c !== void 0 ? _c : {}, (_d = d2 === null || d2 === void 0 ? void 0 : d2.static) !== null && _d !== void 0 ? _d : {}),
        instance: mergePropertyAndMethodDecorators((_e = d1 === null || d1 === void 0 ? void 0 : d1.instance) !== null && _e !== void 0 ? _e : {}, (_f = d2 === null || d2 === void 0 ? void 0 : d2.instance) !== null && _f !== void 0 ? _f : {}),
    });
};
const decorators = new Map();
const findAllConstituentClasses = (...classes) => {
    var _a;
    const allClasses = new Set();
    const frontier = new Set([...classes]);
    while (frontier.size > 0) {
        for (let clazz of frontier) {
            const protoChainClasses = protoChain(clazz.prototype).map(proto => proto.constructor);
            const mixinClasses = (_a = getMixinsForClass(clazz)) !== null && _a !== void 0 ? _a : [];
            const potentiallyNewClasses = [...protoChainClasses, ...mixinClasses];
            const newClasses = potentiallyNewClasses.filter(c => !allClasses.has(c));
            for (let newClass of newClasses)
                frontier.add(newClass);
            allClasses.add(clazz);
            frontier.delete(clazz);
        }
    }
    return [...allClasses];
};
const deepDecoratorSearch = (...classes) => {
    const decoratorsForClassChain = findAllConstituentClasses(...classes)
        .map(clazz => decorators.get(clazz))
        .filter(decorators => !!decorators);
    if (decoratorsForClassChain.length == 0)
        return {};
    if (decoratorsForClassChain.length == 1)
        return decoratorsForClassChain[0];
    return decoratorsForClassChain.reduce((d1, d2) => mergeDecorators(d1, d2));
};
const directDecoratorSearch = (...classes) => {
    const classDecorators = classes.map(clazz => getDecoratorsForClass(clazz));
    if (classDecorators.length === 0)
        return {};
    if (classDecorators.length === 1)
        return classDecorators[0];
    return classDecorators.reduce((d1, d2) => mergeDecorators(d1, d2));
};
const getDecoratorsForClass = (clazz) => {
    let decoratorsForClass = decorators.get(clazz);
    if (!decoratorsForClass) {
        decoratorsForClass = {};
        decorators.set(clazz, decoratorsForClass);
    }
    return decoratorsForClass;
};
const decorateClass = (decorator) => ((clazz) => {
    const decoratorsForClass = getDecoratorsForClass(clazz);
    let classDecorators = decoratorsForClass.class;
    if (!classDecorators) {
        classDecorators = [];
        decoratorsForClass.class = classDecorators;
    }
    classDecorators.push(decorator);
    return decorator(clazz);
});
const decorateMember = (decorator) => ((object, key, ...otherArgs) => {
    var _a, _b, _c;
    const decoratorTargetType = typeof object === 'function' ? 'static' : 'instance';
    const decoratorType = typeof object[key] === 'function' ? 'method' : 'property';
    const clazz = decoratorTargetType === 'static' ? object : object.constructor;
    const decoratorsForClass = getDecoratorsForClass(clazz);
    const decoratorsForTargetType = (_a = decoratorsForClass === null || decoratorsForClass === void 0 ? void 0 : decoratorsForClass[decoratorTargetType]) !== null && _a !== void 0 ? _a : {};
    decoratorsForClass[decoratorTargetType] = decoratorsForTargetType;
    let decoratorsForType = (_b = decoratorsForTargetType === null || decoratorsForTargetType === void 0 ? void 0 : decoratorsForTargetType[decoratorType]) !== null && _b !== void 0 ? _b : {};
    decoratorsForTargetType[decoratorType] = decoratorsForType;
    let decoratorsForKey = (_c = decoratorsForType === null || decoratorsForType === void 0 ? void 0 : decoratorsForType[key]) !== null && _c !== void 0 ? _c : [];
    decoratorsForType[key] = decoratorsForKey;
    // @ts-ignore: array is type `A[] | B[]` and item is type `A | B`, so technically a type error, but it's fine
    decoratorsForKey.push(decorator);
    // @ts-ignore
    return decorator(object, key, ...otherArgs);
});
const decorate = (decorator) => ((...args) => {
    if (args.length === 1)
        return decorateClass(decorator)(args[0]);
    return decorateMember(decorator)(...args);
});

function Mixin(...constructors) {
    var _a, _b, _c;
    const prototypes = constructors.map(constructor => constructor.prototype);
    // Here we gather up the init functions of the ingredient prototypes, combine them into one init function, and
    // attach it to the mixed class prototype.  The reason we do this is because we want the init functions to mix
    // similarly to constructors -- not methods, which simply override each other.
    const initFunctionName = settings.initFunction;
    if (initFunctionName !== null) {
        const initFunctions = prototypes
            .map(proto => proto[initFunctionName])
            .filter(func => typeof func === 'function');
        const combinedInitFunction = function (...args) {
            for (let initFunction of initFunctions)
                initFunction.apply(this, args);
        };
        const extraProto = { [initFunctionName]: combinedInitFunction };
        prototypes.push(extraProto);
    }
    function MixedClass(...args) {
        for (const constructor of constructors)
            // @ts-ignore: potentially abstract class
            copyProps(this, new constructor(...args));
        if (initFunctionName !== null && typeof this[initFunctionName] === 'function')
            this[initFunctionName].apply(this, args);
    }
    MixedClass.prototype = settings.prototypeStrategy === 'copy'
        ? hardMixProtos(prototypes, MixedClass)
        : softMixProtos(prototypes, MixedClass);
    Object.setPrototypeOf(MixedClass, settings.staticsStrategy === 'copy'
        ? hardMixProtos(constructors, null, ['prototype'])
        : proxyMix(constructors, Function.prototype));
    let DecoratedMixedClass = MixedClass;
    if (settings.decoratorInheritance !== 'none') {
        const classDecorators = settings.decoratorInheritance === 'deep'
            ? deepDecoratorSearch(...constructors)
            : directDecoratorSearch(...constructors);
        for (let decorator of (_a = classDecorators === null || classDecorators === void 0 ? void 0 : classDecorators.class) !== null && _a !== void 0 ? _a : []) {
            const result = decorator(DecoratedMixedClass);
            if (result) {
                DecoratedMixedClass = result;
            }
        }
        applyPropAndMethodDecorators((_b = classDecorators === null || classDecorators === void 0 ? void 0 : classDecorators.static) !== null && _b !== void 0 ? _b : {}, DecoratedMixedClass);
        applyPropAndMethodDecorators((_c = classDecorators === null || classDecorators === void 0 ? void 0 : classDecorators.instance) !== null && _c !== void 0 ? _c : {}, DecoratedMixedClass.prototype);
    }
    registerMixins(DecoratedMixedClass, constructors);
    return DecoratedMixedClass;
}
const applyPropAndMethodDecorators = (propAndMethodDecorators, target) => {
    const propDecorators = propAndMethodDecorators.property;
    const methodDecorators = propAndMethodDecorators.method;
    if (propDecorators)
        for (let key in propDecorators)
            for (let decorator of propDecorators[key])
                decorator(target, key);
    if (methodDecorators)
        for (let key in methodDecorators)
            for (let decorator of methodDecorators[key])
                decorator(target, key, Object.getOwnPropertyDescriptor(target, key));
};
/**
 * A decorator version of the `Mixin` function.  You'll want to use this instead of `Mixin` for mixing generic classes.
 */
const mix = (...ingredients) => decoratedClass => {
    // @ts-ignore
    const mixedClass = Mixin(...ingredients.concat([decoratedClass]));
    Object.defineProperty(mixedClass, 'name', {
        value: decoratedClass.name,
        writable: false,
    });
    return mixedClass;
};




/***/ }),

/***/ 7057:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var charAt = (__webpack_require__(11470).charAt);
var toString = __webpack_require__(90160);
var InternalStateModule = __webpack_require__(64932);
var defineIterator = __webpack_require__(60183);
var createIterResultObject = __webpack_require__(59550);

var STRING_ITERATOR = 'String Iterator';
var setInternalState = InternalStateModule.set;
var getInternalState = InternalStateModule.getterFor(STRING_ITERATOR);

// `String.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
defineIterator(String, 'String', function (iterated) {
  setInternalState(this, {
    type: STRING_ITERATOR,
    string: toString(iterated),
    index: 0
  });
// `%StringIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
}, function next() {
  var state = getInternalState(this);
  var string = state.string;
  var index = state.index;
  var point;
  if (index >= string.length) return createIterResultObject(undefined, true);
  point = charAt(string, index);
  state.index += point.length;
  return createIterResultObject(point, false);
});


/***/ }),

/***/ 7363:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5051);

/**
 * @public
 */
class ExternalValueVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExternalValueVisitor);

/***/ }),

/***/ 7376:
/***/ ((module) => {

"use strict";

module.exports = true;


/***/ }),

/***/ 7386:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _visitors_FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(62287);
/* harmony import */ var _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95648);
/* harmony import */ var _visitors_json_schema_ItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(46630);
/* harmony import */ var _visitors_json_schema_RequiredVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59219);
/* harmony import */ var _visitors_json_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(39599);
/* harmony import */ var _visitors_json_schema_PatternPropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49769);
/* harmony import */ var _visitors_json_schema_DependenciesVisitor_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(27231);
/* harmony import */ var _visitors_json_schema_EnumVisitor_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(87467);
/* harmony import */ var _visitors_json_schema_TypeVisitor_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(93090);
/* harmony import */ var _visitors_json_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(60920);
/* harmony import */ var _visitors_json_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(19001);
/* harmony import */ var _visitors_json_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(46787);
/* harmony import */ var _visitors_json_schema_DefinitionsVisitor_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(81228);
/* harmony import */ var _visitors_json_schema_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(40283);
/* harmony import */ var _visitors_json_schema_json_reference_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(12923);
/* harmony import */ var _visitors_json_schema_json_reference_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(3296);
/* harmony import */ var _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(79945);
/* harmony import */ var _visitors_json_schema_media_index_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(97789);
/* harmony import */ var _visitors_json_schema_link_description_index_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(67904);



















/**
 * Specification object allows us to have complete control over visitors
 * when traversing the ApiDOM.
 * Specification also allows us to create amended refractors from
 * existing ones by manipulating it.
 *
 * Note: Specification object allows to use absolute internal JSON pointers.
 * @public
 */
const specification = {
  visitors: {
    value: _visitors_FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"],
    JSONSchemaOrJSONReferenceVisitor: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
    document: {
      objects: {
        JSONSchema: {
          $visitor: _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"],
          fixedFields: {
            // core vocabulary
            id: {
              $ref: '#/visitors/value'
            },
            $schema: {
              $ref: '#/visitors/value'
            },
            // validation vocabulary
            // validation keywords for numeric instances (number and integer)
            multipleOf: {
              $ref: '#/visitors/value'
            },
            maximum: {
              $ref: '#/visitors/value'
            },
            exclusiveMaximum: {
              $ref: '#/visitors/value'
            },
            minimum: {
              $ref: '#/visitors/value'
            },
            exclusiveMinimum: {
              $ref: '#/visitors/value'
            },
            // validation keywords for strings
            maxLength: {
              $ref: '#/visitors/value'
            },
            minLength: {
              $ref: '#/visitors/value'
            },
            pattern: {
              $ref: '#/visitors/value'
            },
            // validation keywords for arrays
            additionalItems: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
            items: _visitors_json_schema_ItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"],
            maxItems: {
              $ref: '#/visitors/value'
            },
            minItems: {
              $ref: '#/visitors/value'
            },
            uniqueItems: {
              $ref: '#/visitors/value'
            },
            // validation keywords for objects
            maxProperties: {
              $ref: '#/visitors/value'
            },
            minProperties: {
              $ref: '#/visitors/value'
            },
            required: _visitors_json_schema_RequiredVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__["default"],
            properties: _visitors_json_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"],
            additionalProperties: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
            patternProperties: _visitors_json_schema_PatternPropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
            dependencies: _visitors_json_schema_DependenciesVisitor_mjs__WEBPACK_IMPORTED_MODULE_7__["default"],
            // validation keywords for any instance type
            enum: _visitors_json_schema_EnumVisitor_mjs__WEBPACK_IMPORTED_MODULE_8__["default"],
            type: _visitors_json_schema_TypeVisitor_mjs__WEBPACK_IMPORTED_MODULE_9__["default"],
            allOf: _visitors_json_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_10__["default"],
            anyOf: _visitors_json_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_11__["default"],
            oneOf: _visitors_json_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__["default"],
            not: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
            definitions: _visitors_json_schema_DefinitionsVisitor_mjs__WEBPACK_IMPORTED_MODULE_13__["default"],
            // metadata keywords
            title: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            },
            default: {
              $ref: '#/visitors/value'
            },
            // semantic validation with "format"
            format: {
              $ref: '#/visitors/value'
            },
            // JSON Hyper-Schema
            base: {
              $ref: '#/visitors/value'
            },
            links: _visitors_json_schema_LinksVisitor_mjs__WEBPACK_IMPORTED_MODULE_14__["default"],
            media: {
              $ref: '#/visitors/document/objects/Media'
            },
            readOnly: {
              $ref: '#/visitors/value'
            }
          }
        },
        JSONReference: {
          $visitor: _visitors_json_schema_json_reference_index_mjs__WEBPACK_IMPORTED_MODULE_15__["default"],
          fixedFields: {
            $ref: _visitors_json_schema_json_reference_$RefVisitor_mjs__WEBPACK_IMPORTED_MODULE_16__["default"]
          }
        },
        Media: {
          $visitor: _visitors_json_schema_media_index_mjs__WEBPACK_IMPORTED_MODULE_17__["default"],
          fixedFields: {
            binaryEncoding: {
              $ref: '#/visitors/value'
            },
            type: {
              $ref: '#/visitors/value'
            }
          }
        },
        LinkDescription: {
          $visitor: _visitors_json_schema_link_description_index_mjs__WEBPACK_IMPORTED_MODULE_18__["default"],
          fixedFields: {
            href: {
              $ref: '#/visitors/value'
            },
            rel: {
              $ref: '#/visitors/value'
            },
            title: {
              $ref: '#/visitors/value'
            },
            targetSchema: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
            mediaType: {
              $ref: '#/visitors/value'
            },
            method: {
              $ref: '#/visitors/value'
            },
            encType: {
              $ref: '#/visitors/value'
            },
            schema: _visitors_json_schema_JSONSchemaOrJSONReferenceVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]
          }
        }
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (specification);

/***/ }),

/***/ 7410:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97293);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91487);


/**
 * Returns true if the specified value is equal, in R.equals terms,
 * to at least one element of the given list or false otherwise.
 * Given list can be a string.
 *
 * Like {@link http://ramdajs.com/docs/#includes|R.includes} but with argument order reversed.
 *
 * @func included
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/3.0.0|v3.0.0}
 * @category List
 * @sig [a] -> a -> Boolean
 * @param {Array|String} list The list to consider
 * @param {*} a The item to compare against
 * @return {boolean} Returns Boolean `true` if an equivalent item is in the list or `false` otherwise
 * @see {@link http://ramdajs.com/docs/#includes|R.includes}
 * @example
 *
 * RA.included([1, 2, 3], 3); //=> true
 * RA.included([1, 2, 3], 4); //=> false
 * RA.included([{ name: 'Fred' }], { name: 'Fred' }); //=> true
 * RA.included([[42]], [42]); //=> true
 */
var included = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(ramda__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (included);

/***/ }),

/***/ 7463:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(98828);
var isCallable = __webpack_require__(62250);

var replacement = /#|\.prototype\./;

var isForced = function (feature, detection) {
  var value = data[normalize(feature)];
  return value === POLYFILL ? true
    : value === NATIVE ? false
    : isCallable(detection) ? fails(detection)
    : !!detection;
};

var normalize = isForced.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced.data = {};
var NATIVE = isForced.NATIVE = 'N';
var POLYFILL = isForced.POLYFILL = 'P';

module.exports = isForced;


/***/ }),

/***/ 7479:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseOAuthFlowVisitor: () => (/* binding */ BaseOAuthFlowVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98534);


/**
 * @public
 */
const BaseOAuthFlowVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.OAuthFlow.$visitor;
/**
 * @public
 */
class OAuthFlowVisitor extends BaseOAuthFlowVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlowVisitor);

/***/ }),

/***/ 7573:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   absolutifyPointer: () => (/* binding */ absolutifyPointer),
/* harmony export */   generateAbsoluteRefPatches: () => (/* binding */ generateAbsoluteRefPatches),
/* harmony export */   isFreelyNamed: () => (/* binding */ isFreelyNamed)
/* harmony export */ });
/* harmony import */ var neotraverse_legacy__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(70909);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(96664);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3832);




// This will match if the direct parent's key exactly matches an item.
const freelyNamedKeyParents = ['properties'];

// This will match if the grandparent's key exactly matches an item.
// NOTE that this is for finding non-free paths!
const nonFreelyNamedKeyGrandparents = ['properties'];

// This will match if the joined parent path exactly matches an item.
//
// This is mostly useful for filtering out root-level reusable item names,
// for example `["definitions", "$ref"]`
const freelyNamedPaths = [
// Swagger 2.0
'definitions', 'parameters', 'responses', 'securityDefinitions',
// OpenAPI 3.0
'components/schemas', 'components/responses', 'components/parameters', 'components/securitySchemes'];

// This will match if any of these items are substrings of the joined
// parent path.
//
// Warning! These are powerful. Beware of edge cases.
const freelyNamedAncestors = ['schema/example', 'items/example'];
function isFreelyNamed(parentPath) {
  const parentKey = parentPath[parentPath.length - 1];
  const grandparentKey = parentPath[parentPath.length - 2];
  const parentStr = parentPath.join('/');
  return (
    // eslint-disable-next-line max-len
    freelyNamedKeyParents.indexOf(parentKey) > -1 && nonFreelyNamedKeyGrandparents.indexOf(grandparentKey) === -1 || freelyNamedPaths.indexOf(parentStr) > -1 || freelyNamedAncestors.some(el => parentStr.indexOf(el) > -1)
  );
}
function generateAbsoluteRefPatches(obj, basePath, {
  specmap,
  getBaseUrlForNodePath = path => specmap.getContext([...basePath, ...path]).baseDoc,
  targetKeys = ['$ref', '$$ref']
} = {}) {
  const patches = [];
  (0,neotraverse_legacy__WEBPACK_IMPORTED_MODULE_0__["default"])(obj).forEach(function callback() {
    if (targetKeys.includes(this.key) && typeof this.node === 'string') {
      const nodePath = this.path; // this node's path, relative to `obj`
      const fullPath = basePath.concat(this.path);
      const absolutifiedRefValue = absolutifyPointer(this.node, getBaseUrlForNodePath(nodePath));
      patches.push(specmap.replace(fullPath, absolutifiedRefValue));
    }
  });
  return patches;
}
function absolutifyPointer(pointer, baseUrl) {
  const [urlPart, fragmentPart] = pointer.split('#');
  const safeBaseUrl = baseUrl ?? '';
  const safeUrlPart = urlPart ?? '';
  let newRefUrlPart;
  if (!_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__.isHttpUrl(safeBaseUrl)) {
    const absoluteBaseUrl = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__.resolve(_constants_js__WEBPACK_IMPORTED_MODULE_1__.DEFAULT_BASE_URL, safeBaseUrl);
    const absoluteRefUrlPart = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__.resolve(absoluteBaseUrl, safeUrlPart);
    const rawRefUrlPart = absoluteRefUrlPart.replace(_constants_js__WEBPACK_IMPORTED_MODULE_1__.DEFAULT_BASE_URL, '');
    newRefUrlPart = safeUrlPart.startsWith('/') ? rawRefUrlPart : rawRefUrlPart.substring(1);
  } else {
    newRefUrlPart = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__.resolve(safeBaseUrl, safeUrlPart);
  }
  return fragmentPart ? `${newRefUrlPart}#${fragmentPart}` : newRefUrlPart;
}

/***/ }),

/***/ 7699:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _DereferenceError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36892);

/**
 * @public
 */
class MaximumDereferenceDepthError extends _DereferenceError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MaximumDereferenceDepthError);

/***/ }),

/***/ 7882:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43319);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(86349);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(77259);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(1908);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(16401);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(39633);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(51295);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(45259);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(8302);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(62708);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(61906);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(96664);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(7699);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(38396);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(19950);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(35484);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(70948);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(72149);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(83915);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(12201);
/* harmony import */ var _utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(17381);
/* harmony import */ var _specmap_lib_refs_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(65084);
/* harmony import */ var _errors_SchemaRefError_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(36202);
/* eslint-disable camelcase */












const {
  wrapError
} = _specmap_lib_refs_js__WEBPACK_IMPORTED_MODULE_0__["default"];
const visitAsync = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.visit[Symbol.for('nodejs.util.promisify.custom')];

// initialize element identity manager
const identityManager = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.IdentityManager();

// custom mutation replacer
const mutationReplacer = (newElement, oldElement, key, parent) => {
  if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isMemberElement)(parent)) {
    parent.value = newElement; // eslint-disable-line no-param-reassign
  } else if (Array.isArray(parent)) {
    parent[key] = newElement; // eslint-disable-line no-param-reassign
  }
};
class OpenAPI3_1SwaggerClientDereferenceVisitor extends _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__["default"] {
  useCircularStructures;
  allowMetaPatches;
  basePath;
  constructor({
    allowMetaPatches = true,
    useCircularStructures = false,
    basePath = null,
    ...rest
  }) {
    super(rest);
    this.allowMetaPatches = allowMetaPatches;
    this.useCircularStructures = useCircularStructures;
    this.basePath = basePath;
  }
  async ReferenceElement(referencingElement, key, parent, path, ancestors, link) {
    try {
      // skip current referencing element as it's already been access
      if (this.indirections.includes(referencingElement)) {
        return false;
      }
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);
      const retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref));
      const isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
      const isExternalReference = !isInternalReference;

      // ignore resolving internal Reference Objects
      if (!this.options.resolve.internal && isInternalReference) {
        return false;
      }
      // ignore resolving external Reference Objects
      if (!this.options.resolve.external && isExternalReference) {
        return false;
      }
      const reference = await this.toReference((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref));
      const $refBaseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref));
      this.indirections.push(referencingElement);
      const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);

      // possibly non-semantic fragment
      let referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__["default"])(jsonPointer, reference.value.result);
      referencedElement.id = identityManager.identify(referencedElement);

      // applying semantics to a fragment
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isPrimitiveElement)(referencedElement)) {
        const referencedElementType = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.meta.get('referenced-element'));
        const cacheKey = `${referencedElementType}-${(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(identityManager.identify(referencedElement))}`;
        if (this.refractCache.has(cacheKey)) {
          referencedElement = this.refractCache.get(cacheKey);
        } else if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_9__.isReferenceLikeElement)(referencedElement)) {
          // handling indirect references
          referencedElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.ReferenceElement.refract(referencedElement);
          referencedElement.setMetaProperty('referenced-element', referencedElementType);
          this.refractCache.set(cacheKey, referencedElement);
        } else {
          // handling direct references
          const ElementClass = this.namespace.getElementClass(referencedElementType);
          referencedElement = ElementClass.refract(referencedElement);
          this.refractCache.set(cacheKey, referencedElement);
        }
      }

      // detect direct or indirect reference
      if (referencingElement === referencedElement) {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Recursive Reference Object detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // detect second deep dive into the same fragment and avoid it
      if (ancestorsLineage.includes(referencedElement)) {
        reference.refSet.circular = true;
        if (this.options.dereference.circular === 'error') {
          throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Circular reference detected');
        } else if (this.options.dereference.circular === 'replace') {
          const refElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_13__.RefElement(referencedElement.id, {
            type: 'reference',
            uri: reference.uri,
            $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
            baseURI: $refBaseURI,
            referencingElement
          });
          const replacer = this.options.dereference.strategyOpts['openapi-3-1']?.circularReplacer ?? this.options.dereference.circularReplacer;
          const replacement = replacer(refElement);
          link.replaceWith(refElement, mutationReplacer);
          return !parent ? replacement : false;
        }
      }

      /**
       * Dive deep into the fragment.
       *
       * Cases to consider:
       *  1. We're crossing document boundary
       *  2. Fragment is from non-root document
       *  3. Fragment is a Reference Object. We need to follow it to get the eventual value
       *  4. We are dereferencing the fragment lazily/eagerly depending on circular mode
       */
      const isNonRootDocument = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(reference.refSet.rootRef.uri) !== reference.uri;
      const shouldDetectCircular = ['error', 'replace'].includes(this.options.dereference.circular);
      if ((isExternalReference || isNonRootDocument || (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isReferenceElement)(referencedElement) || shouldDetectCircular) && !ancestorsLineage.includesCycle(referencedElement)) {
        // append referencing reference to ancestors lineage
        directAncestors.add(referencingElement);
        const visitor = new OpenAPI3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          refractCache: this.refractCache,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, referencingElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, visitor, {
          keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.keyMap,
          nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.getNodeType
        });

        // remove referencing reference from ancestors lineage
        directAncestors.delete(referencingElement);
      }
      this.indirections.pop();
      const mergedElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneShallow)(referencedElement);

      // annotate fragment with info about original Reference element
      mergedElement.setMetaProperty('ref-fields', {
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
        description: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.description),
        summary: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.summary)
      });
      // annotate fragment with info about origin
      mergedElement.setMetaProperty('ref-origin', reference.uri);
      // annotate fragment with info about referencing element
      mergedElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(identityManager.identify(referencingElement)));

      // override description and summary (outer has higher priority then inner)
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isObjectElement)(referencedElement)) {
        if (referencingElement.hasKey('description') && 'description' in referencedElement) {
          mergedElement.remove('description');
          mergedElement.set('description', referencingElement.get('description'));
        }
        if (referencingElement.hasKey('summary') && 'summary' in referencedElement) {
          mergedElement.remove('summary');
          mergedElement.set('summary', referencingElement.get('summary'));
        }
      }

      // apply meta patches
      if (this.allowMetaPatches && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isObjectElement)(mergedElement)) {
        // apply meta patch only when not already applied
        if (!mergedElement.hasKey('$$ref')) {
          const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
          mergedElement.set('$$ref', baseURI);
        }
      }

      /**
       * Transclude referencing element with merged referenced element.
       */
      link.replaceWith(mergedElement, mutationReplacer);

      /**
       * We're at the root of the tree, so we're just replacing the entire tree.
       */
      return !parent ? mergedElement : false;
    } catch (error) {
      const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__["default"])(error);
      const wrappedError = wrapError(rootCause, {
        baseDoc: this.reference.uri,
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
        pointer: (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref)),
        fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, referencingElement]), '$ref']
      });
      this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
      return undefined;
    }
  }
  async PathItemElement(pathItemElement, key, parent, path, ancestors, link) {
    try {
      // ignore PathItemElement without $ref field
      if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(pathItemElement.$ref)) {
        return undefined;
      }

      // skip current referencing element as it's already been access
      if (this.indirections.includes(pathItemElement)) {
        return false;
      }

      // skip already identified cycled Path Item Objects
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.includesClasses)(['cycle'], pathItemElement.$ref)) {
        return false;
      }
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);
      const retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref));
      const isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
      const isExternalReference = !isInternalReference;

      // ignore resolving internal Path Item Elements
      if (!this.options.resolve.internal && isInternalReference) {
        return undefined;
      }
      // ignore resolving external Path Item Elements
      if (!this.options.resolve.external && isExternalReference) {
        return undefined;
      }
      const reference = await this.toReference((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref));
      const $refBaseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref));
      this.indirections.push(pathItemElement);
      const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);

      // possibly non-semantic referenced element
      let referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__["default"])(jsonPointer, reference.value.result);
      referencedElement.id = identityManager.identify(referencedElement);

      // applying semantics to a referenced element
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isPrimitiveElement)(referencedElement)) {
        const cacheKey = `path-item-${(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(identityManager.identify(referencedElement))}`;
        if (this.refractCache.has(cacheKey)) {
          referencedElement = this.refractCache.get(cacheKey);
        } else {
          referencedElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.PathItemElement.refract(referencedElement);
          this.refractCache.set(cacheKey, referencedElement);
        }
      }

      // detect direct or indirect reference
      if (pathItemElement === referencedElement) {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Recursive Path Item Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // detect second deep dive into the same fragment and avoid it
      if (ancestorsLineage.includes(referencedElement)) {
        reference.refSet.circular = true;
        if (this.options.dereference.circular === 'error') {
          throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Circular reference detected');
        } else if (this.options.dereference.circular === 'replace') {
          const refElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_13__.RefElement(referencedElement.id, {
            type: 'path-item',
            uri: reference.uri,
            $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref),
            baseURI: $refBaseURI,
            referencingElement: pathItemElement
          });
          const replacer = this.options.dereference.strategyOpts['openapi-3-1']?.circularReplacer ?? this.options.dereference.circularReplacer;
          const replacement = replacer(refElement);
          link.replaceWith(refElement, mutationReplacer);
          return !parent ? replacement : false;
        }
      }

      /**
       * Dive deep into the fragment.
       *
       * Cases to consider:
       *  1. We're crossing document boundary
       *  2. Fragment is from non-root document
       *  3. Fragment is a Path Item Object with $ref field. We need to follow it to get the eventual value
       *  4. We are dereferencing the fragment lazily/eagerly depending on circular mode
       */
      const isNonRootDocument = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(reference.refSet.rootRef.uri) !== reference.uri;
      const shouldDetectCircular = ['error', 'replace'].includes(this.options.dereference.circular);
      if ((isExternalReference || isNonRootDocument || (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isPathItemElement)(referencedElement) && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(referencedElement.$ref) || shouldDetectCircular) && !ancestorsLineage.includesCycle(referencedElement)) {
        // append referencing schema to ancestors lineage
        directAncestors.add(pathItemElement);

        // dive deep into the referenced element
        const visitor = new OpenAPI3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          ancestors: ancestorsLineage,
          allowMetaPatches: this.allowMetaPatches,
          useCircularStructures: this.useCircularStructures,
          basePath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, pathItemElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, visitor, {
          keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.keyMap,
          nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(pathItemElement);
      }
      this.indirections.pop();

      /**
       * Creating a new version of Path Item by merging fields from referenced Path Item with referencing one.
       */
      if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isPathItemElement)(referencedElement)) {
        const mergedElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.PathItemElement([...referencedElement.content], (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement.meta), (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement.attributes));
        // existing keywords from referencing PathItemElement overrides ones from referenced element
        pathItemElement.forEach((value, keyElement, item) => {
          mergedElement.remove((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(keyElement));
          mergedElement.content.push(item);
        });
        mergedElement.remove('$ref');

        // annotate referenced element with info about original referencing element
        mergedElement.setMetaProperty('ref-fields', {
          $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref)
        });
        // annotate referenced element with info about origin
        mergedElement.setMetaProperty('ref-origin', reference.uri);
        // annotate fragment with info about referencing element
        mergedElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(identityManager.identify(pathItemElement)));

        // apply meta patches
        if (this.allowMetaPatches) {
          // apply meta patch only when not already applied
          if (typeof mergedElement.get('$$ref') === 'undefined') {
            const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
            mergedElement.set('$$ref', baseURI);
          }
        }
        referencedElement = mergedElement;
      }

      /**
       * Transclude referencing element with merged referenced element.
       */
      link.replaceWith(referencedElement, mutationReplacer);

      /**
       * We're at the root of the tree, so we're just replacing the entire tree.
       */
      return !parent ? referencedElement : undefined;
    } catch (error) {
      const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__["default"])(error);
      const wrappedError = wrapError(rootCause, {
        baseDoc: this.reference.uri,
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref),
        pointer: (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(pathItemElement.$ref)),
        fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, pathItemElement]), '$ref']
      });
      this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
      return undefined;
    }
  }
  async SchemaElement(referencingElement, key, parent, path, ancestors, link) {
    try {
      // skip current referencing schema as $ref keyword was not defined
      if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(referencingElement.$ref)) {
        // skip traversing this schema but traverse all it's child schemas
        return undefined;
      }

      // skip current referencing element as it's already been access
      if (this.indirections.includes(referencingElement)) {
        return false;
      }
      const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);

      // compute baseURI using rules around $id and $ref keywords
      let reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize(this.reference.uri));
      let {
        uri: retrievalURI
      } = reference;
      const $refBaseURI = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.resolveSchema$refField)(retrievalURI, referencingElement);
      const $refBaseURIStrippedHash = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash($refBaseURI);
      const file = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_20__["default"]({
        uri: $refBaseURIStrippedHash
      });
      const isUnknownURI = !this.options.resolve.resolvers.some(r => r.canRead(file));
      const isURL = !isUnknownURI;
      let isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === $refBaseURI;
      let isExternalReference = !isInternalReference;
      this.indirections.push(referencingElement);

      // determining reference, proper evaluation and selection mechanism
      let referencedElement;
      try {
        if (isUnknownURI || isURL) {
          // we're dealing with canonical URI or URL with possible fragment
          retrievalURI = this.toBaseURI($refBaseURI);
          const selector = $refBaseURI;
          const referenceAsSchema = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(reference.value.result);
          referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_21__.evaluate)(selector, referenceAsSchema);
          referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(referencedElement);
          referencedElement.id = identityManager.identify(referencedElement);

          // ignore resolving internal Schema Objects
          if (!this.options.resolve.internal && isInternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          // ignore resolving external Schema Objects
          if (!this.options.resolve.external && isExternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
        } else {
          // we're assuming here that we're dealing with JSON Pointer here
          retrievalURI = this.toBaseURI($refBaseURI);
          isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
          isExternalReference = !isInternalReference;

          // ignore resolving internal Schema Objects
          if (!this.options.resolve.internal && isInternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          // ignore resolving external Schema Objects
          if (!this.options.resolve.external && isExternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize($refBaseURI));
          const selector = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);
          const referenceAsSchema = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(reference.value.result);
          referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__["default"])(selector, referenceAsSchema);
          referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(referencedElement);
          referencedElement.id = identityManager.identify(referencedElement);
        }
      } catch (error) {
        /**
         * No SchemaElement($id=URL) was not found, so we're going to try to resolve
         * the URL and assume the returned response is a JSON Schema.
         */
        if (isURL && error instanceof _swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_uri__WEBPACK_IMPORTED_MODULE_22__["default"]) {
          if ((0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__.isAnchor)((0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__.uriToAnchor)($refBaseURI))) {
            // we're dealing with JSON Schema $anchor here
            isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
            isExternalReference = !isInternalReference;

            // ignore resolving internal Schema Objects
            if (!this.options.resolve.internal && isInternalReference) {
              // skip traversing this schema element but traverse all it's child elements
              return undefined;
            }
            // ignore resolving external Schema Objects
            if (!this.options.resolve.external && isExternalReference) {
              // skip traversing this schema element but traverse all it's child elements
              return undefined;
            }
            reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize($refBaseURI));
            const selector = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__.uriToAnchor)($refBaseURI);
            const referenceAsSchema = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(reference.value.result);
            referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1_selectors_$anchor__WEBPACK_IMPORTED_MODULE_23__.evaluate)(selector, referenceAsSchema);
            referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(referencedElement);
            referencedElement.id = identityManager.identify(referencedElement);
          } else {
            // we're assuming here that we're dealing with JSON Pointer here
            retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])($refBaseURI));
            isInternalReference = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(this.reference.uri) === retrievalURI;
            isExternalReference = !isInternalReference;

            // ignore resolving internal Schema Objects
            if (!this.options.resolve.internal && isInternalReference) {
              // skip traversing this schema element but traverse all it's child elements
              return undefined;
            }
            // ignore resolving external Schema Objects
            if (!this.options.resolve.external && isExternalReference) {
              // skip traversing this schema element but traverse all it's child elements
              return undefined;
            }
            reference = await this.toReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.unsanitize($refBaseURI));
            const selector = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_7__.uriToPointer)($refBaseURI);
            const referenceAsSchema = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(reference.value.result);
            referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_8__["default"])(selector, referenceAsSchema);
            referencedElement = (0,_swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.maybeRefractToSchemaElement)(referencedElement);
            referencedElement.id = identityManager.identify(referencedElement);
          }
        } else {
          throw error;
        }
      }

      // detect direct or indirect reference
      if (referencingElement === referencedElement) {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Recursive Schema Object reference detected');
      }

      // detect maximum depth of dereferencing
      if (this.indirections.length > this.options.dereference.maxDepth) {
        throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_12__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
      }

      // detect second deep dive into the same fragment and avoid it
      if (ancestorsLineage.includes(referencedElement)) {
        reference.refSet.circular = true;
        if (this.options.dereference.circular === 'error') {
          throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_11__["default"]('Circular reference detected');
        } else if (this.options.dereference.circular === 'replace') {
          const refElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_13__.RefElement(referencedElement.id, {
            type: 'json-schema',
            uri: reference.uri,
            $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
            baseURI: _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI),
            referencingElement
          });
          const replacer = this.options.dereference.strategyOpts['openapi-3-1']?.circularReplacer ?? this.options.dereference.circularReplacer;
          const replacement = replacer(refElement);
          link.replaceWith(replacement, mutationReplacer);
          return !parent ? replacement : false;
        }
      }

      /**
       * Dive deep into the fragment.
       *
       * Cases to consider:
       *  1. We're crossing document boundary
       *  2. Fragment is from non-root document
       *  3. Fragment is a Schema Object with $ref field. We need to follow it to get the eventual value
       *  4. We are dereferencing the fragment lazily/eagerly depending on circular mode
       */
      const isNonRootDocument = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.stripHash(reference.refSet.rootRef.uri) !== reference.uri;
      const shouldDetectCircular = ['error', 'replace'].includes(this.options.dereference.circular);
      if ((isExternalReference || isNonRootDocument || (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isSchemaElement)(referencedElement) && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(referencedElement.$ref) || shouldDetectCircular) && !ancestorsLineage.includesCycle(referencedElement)) {
        // append referencing schema to ancestors lineage
        directAncestors.add(referencingElement);

        // dive deep into the fragment
        const mergeVisitor = new OpenAPI3_1SwaggerClientDereferenceVisitor({
          reference,
          namespace: this.namespace,
          indirections: [...this.indirections],
          options: this.options,
          useCircularStructures: this.useCircularStructures,
          allowMetaPatches: this.allowMetaPatches,
          ancestors: ancestorsLineage,
          basePath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, referencingElement]), '$ref']
        });
        referencedElement = await visitAsync(referencedElement, mergeVisitor, {
          keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.keyMap,
          nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_16__.getNodeType
        });

        // remove referencing schema from ancestors lineage
        directAncestors.delete(referencingElement);
      }
      this.indirections.pop();
      if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isBooleanJsonSchemaElement)(referencedElement)) {
        const booleanJsonSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement);
        // annotate referenced element with info about original referencing element
        booleanJsonSchemaElement.setMetaProperty('ref-fields', {
          $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref)
        });
        // annotate referenced element with info about origin
        booleanJsonSchemaElement.setMetaProperty('ref-origin', reference.uri);
        // annotate fragment with info about referencing element
        booleanJsonSchemaElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(identityManager.identify(referencingElement)));
        link.replaceWith(booleanJsonSchemaElement, mutationReplacer);
        return !parent ? booleanJsonSchemaElement : false;
      }

      /**
       * Creating a new version of Schema Object by merging fields from referenced Schema Object with referencing one.
       */
      if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.isSchemaElement)(referencedElement)) {
        // Schema Object - merge keywords from referenced schema with referencing schema
        const mergedElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_10__.SchemaElement([...referencedElement.content], (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement.meta), (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(referencedElement.attributes));
        // existing keywords from referencing schema overrides ones from referenced schema
        referencingElement.forEach((value, keyElement, item) => {
          mergedElement.remove((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(keyElement));
          mergedElement.content.push(item);
        });
        mergedElement.remove('$ref');
        // annotate referenced element with info about original referencing element
        mergedElement.setMetaProperty('ref-fields', {
          $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref)
        });
        // annotate fragment with info about origin
        mergedElement.setMetaProperty('ref-origin', reference.uri);
        // annotate fragment with info about referencing element
        mergedElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.cloneDeep)(identityManager.identify(referencingElement)));

        // allowMetaPatches option processing
        if (this.allowMetaPatches) {
          // apply meta patch only when not already applied
          if (typeof mergedElement.get('$$ref') === 'undefined') {
            const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__.resolve(retrievalURI, $refBaseURI);
            mergedElement.set('$$ref', baseURI);
          }
        }
        referencedElement = mergedElement;
      }

      /**
       * Transclude referencing element with merged referenced element.
       */
      link.replaceWith(referencedElement, mutationReplacer);

      /**
       * We're at the root of the tree, so we're just replacing the entire tree.
       */
      return !parent ? referencedElement : undefined;
    } catch (error) {
      const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__["default"])(error);
      const wrappedError = new _errors_SchemaRefError_js__WEBPACK_IMPORTED_MODULE_24__["default"](`Could not resolve reference: ${rootCause.message}`, {
        baseDoc: this.reference.uri,
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(referencingElement.$ref),
        fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, referencingElement]), '$ref'],
        cause: rootCause
      });
      this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
      return undefined;
    }
  }

  // eslint-disable-next-line class-methods-use-this
  async LinkElement() {
    /**
     * OpenApi3_1DereferenceVisitor is doing lookup of Operation Objects
     * and assigns them to Link Object metadata. This is not needed in
     * swagger-client context, so we're disabling it here.
     */
    return undefined;
  }
  async ExampleElement(exampleElement, key, parent, path, ancestors, link) {
    try {
      return await super.ExampleElement(exampleElement, key, parent, path, ancestors, link);
    } catch (error) {
      const rootCause = (0,_utils_get_root_cause_js__WEBPACK_IMPORTED_MODULE_18__["default"])(error);
      const wrappedError = wrapError(rootCause, {
        baseDoc: this.reference.uri,
        externalValue: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__["default"])(exampleElement.externalValue),
        fullPath: this.basePath ?? [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_15__["default"])([...ancestors, parent, exampleElement]), 'externalValue']
      });
      this.options.dereference.dereferenceOpts?.errors?.push?.(wrappedError);
      return undefined;
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenAPI3_1SwaggerClientDereferenceVisitor);
/* eslint-enable camelcase */

/***/ }),

/***/ 8068:
/***/ ((module) => {

"use strict";

var ShortUniqueId = (() => {
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getOwnPropSymbols = Object.getOwnPropertySymbols;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __propIsEnum = Object.prototype.propertyIsEnumerable;
  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __spreadValues = (a, b) => {
    for (var prop in b || (b = {}))
      if (__hasOwnProp.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    if (__getOwnPropSymbols)
      for (var prop of __getOwnPropSymbols(b)) {
        if (__propIsEnum.call(b, prop))
          __defNormalProp(a, prop, b[prop]);
      }
    return a;
  };
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
  var __publicField = (obj, key, value) => {
    __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
    return value;
  };

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    DEFAULT_OPTIONS: () => DEFAULT_OPTIONS,
    DEFAULT_UUID_LENGTH: () => DEFAULT_UUID_LENGTH,
    default: () => ShortUniqueId
  });

  // package.json
  var version = "5.2.0";

  // src/index.ts
  var DEFAULT_UUID_LENGTH = 6;
  var DEFAULT_OPTIONS = {
    dictionary: "alphanum",
    shuffle: true,
    debug: false,
    length: DEFAULT_UUID_LENGTH,
    counter: 0
  };
  var _ShortUniqueId = class _ShortUniqueId {
    constructor(argOptions = {}) {
      __publicField(this, "counter");
      __publicField(this, "debug");
      __publicField(this, "dict");
      __publicField(this, "version");
      __publicField(this, "dictIndex", 0);
      __publicField(this, "dictRange", []);
      __publicField(this, "lowerBound", 0);
      __publicField(this, "upperBound", 0);
      __publicField(this, "dictLength", 0);
      __publicField(this, "uuidLength");
      __publicField(this, "_digit_first_ascii", 48);
      __publicField(this, "_digit_last_ascii", 58);
      __publicField(this, "_alpha_lower_first_ascii", 97);
      __publicField(this, "_alpha_lower_last_ascii", 123);
      __publicField(this, "_hex_last_ascii", 103);
      __publicField(this, "_alpha_upper_first_ascii", 65);
      __publicField(this, "_alpha_upper_last_ascii", 91);
      __publicField(this, "_number_dict_ranges", {
        digits: [this._digit_first_ascii, this._digit_last_ascii]
      });
      __publicField(this, "_alpha_dict_ranges", {
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii],
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      });
      __publicField(this, "_alpha_lower_dict_ranges", {
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii]
      });
      __publicField(this, "_alpha_upper_dict_ranges", {
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      });
      __publicField(this, "_alphanum_dict_ranges", {
        digits: [this._digit_first_ascii, this._digit_last_ascii],
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii],
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      });
      __publicField(this, "_alphanum_lower_dict_ranges", {
        digits: [this._digit_first_ascii, this._digit_last_ascii],
        lowerCase: [this._alpha_lower_first_ascii, this._alpha_lower_last_ascii]
      });
      __publicField(this, "_alphanum_upper_dict_ranges", {
        digits: [this._digit_first_ascii, this._digit_last_ascii],
        upperCase: [this._alpha_upper_first_ascii, this._alpha_upper_last_ascii]
      });
      __publicField(this, "_hex_dict_ranges", {
        decDigits: [this._digit_first_ascii, this._digit_last_ascii],
        alphaDigits: [this._alpha_lower_first_ascii, this._hex_last_ascii]
      });
      __publicField(this, "_dict_ranges", {
        _number_dict_ranges: this._number_dict_ranges,
        _alpha_dict_ranges: this._alpha_dict_ranges,
        _alpha_lower_dict_ranges: this._alpha_lower_dict_ranges,
        _alpha_upper_dict_ranges: this._alpha_upper_dict_ranges,
        _alphanum_dict_ranges: this._alphanum_dict_ranges,
        _alphanum_lower_dict_ranges: this._alphanum_lower_dict_ranges,
        _alphanum_upper_dict_ranges: this._alphanum_upper_dict_ranges,
        _hex_dict_ranges: this._hex_dict_ranges
      });
      /* tslint:disable consistent-return */
      __publicField(this, "log", (...args) => {
        const finalArgs = [...args];
        finalArgs[0] = `[short-unique-id] ${args[0]}`;
        if (this.debug === true) {
          if (typeof console !== "undefined" && console !== null) {
            return console.log(...finalArgs);
          }
        }
      });
      /* tslint:enable consistent-return */
      __publicField(this, "_normalizeDictionary", (dictionary, shuffle) => {
        let finalDict;
        if (dictionary && Array.isArray(dictionary) && dictionary.length > 1) {
          finalDict = dictionary;
        } else {
          finalDict = [];
          let i;
          this.dictIndex = i = 0;
          const rangesName = `_${dictionary}_dict_ranges`;
          const ranges = this._dict_ranges[rangesName];
          Object.keys(ranges).forEach((rangeType) => {
            const rangeTypeKey = rangeType;
            this.dictRange = ranges[rangeTypeKey];
            this.lowerBound = this.dictRange[0];
            this.upperBound = this.dictRange[1];
            for (this.dictIndex = i = this.lowerBound; this.lowerBound <= this.upperBound ? i < this.upperBound : i > this.upperBound; this.dictIndex = this.lowerBound <= this.upperBound ? i += 1 : i -= 1) {
              finalDict.push(String.fromCharCode(this.dictIndex));
            }
          });
        }
        if (shuffle) {
          const PROBABILITY = 0.5;
          finalDict = finalDict.sort(() => Math.random() - PROBABILITY);
        }
        return finalDict;
      });
      /** Change the dictionary after initialization. */
      __publicField(this, "setDictionary", (dictionary, shuffle) => {
        this.dict = this._normalizeDictionary(dictionary, shuffle);
        this.dictLength = this.dict.length;
        this.setCounter(0);
      });
      __publicField(this, "seq", () => {
        return this.sequentialUUID();
      });
      /**
       * Generates UUID based on internal counter that's incremented after each ID generation.
       * @alias `const uid = new ShortUniqueId(); uid.seq();`
       */
      __publicField(this, "sequentialUUID", () => {
        let counterDiv;
        let counterRem;
        let id = "";
        counterDiv = this.counter;
        do {
          counterRem = counterDiv % this.dictLength;
          counterDiv = Math.trunc(counterDiv / this.dictLength);
          id += this.dict[counterRem];
        } while (counterDiv !== 0);
        this.counter += 1;
        return id;
      });
      __publicField(this, "rnd", (uuidLength = this.uuidLength || DEFAULT_UUID_LENGTH) => {
        return this.randomUUID(uuidLength);
      });
      /**
       * Generates UUID by creating each part randomly.
       * @alias `const uid = new ShortUniqueId(); uid.rnd(uuidLength: number);`
       */
      __publicField(this, "randomUUID", (uuidLength = this.uuidLength || DEFAULT_UUID_LENGTH) => {
        let id;
        let randomPartIdx;
        let j;
        if (uuidLength === null || typeof uuidLength === "undefined" || uuidLength < 1) {
          throw new Error("Invalid UUID Length Provided");
        }
        const isPositive = uuidLength >= 0;
        id = "";
        for (j = 0; j < uuidLength; j += 1) {
          randomPartIdx = parseInt(
            (Math.random() * this.dictLength).toFixed(0),
            10
          ) % this.dictLength;
          id += this.dict[randomPartIdx];
        }
        return id;
      });
      __publicField(this, "fmt", (format, date) => {
        return this.formattedUUID(format, date);
      });
      /**
       * Generates custom UUID with the provided format string.
       * @alias `const uid = new ShortUniqueId(); uid.fmt(format: string);`
       */
      __publicField(this, "formattedUUID", (format, date) => {
        const fnMap = {
          "$r": this.randomUUID,
          "$s": this.sequentialUUID,
          "$t": this.stamp
        };
        const result = format.replace(
          /\$[rs]\d{0,}|\$t0|\$t[1-9]\d{1,}/g,
          (m) => {
            const fn = m.slice(0, 2);
            const len = parseInt(m.slice(2), 10);
            if (fn === "$s") {
              return fnMap[fn]().padStart(len, "0");
            }
            if (fn === "$t" && date) {
              return fnMap[fn](len, date);
            }
            return fnMap[fn](len);
          }
        );
        return result;
      });
      /**
       * Calculates total number of possible UUIDs.
       *
       * Given that:
       *
       * - `H` is the total number of possible UUIDs
       * - `n` is the number of unique characters in the dictionary
       * - `l` is the UUID length
       *
       * Then `H` is defined as `n` to the power of `l`:
       *
       * <div style="background: white; padding: 5px; border-radius: 5px; overflow: hidden;">
       *  <img src="data:image/png;base64,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" />
       * </div>
       *
       * This function returns `H`.
       */
      __publicField(this, "availableUUIDs", (uuidLength = this.uuidLength) => {
        return parseFloat(
          Math.pow([...new Set(this.dict)].length, uuidLength).toFixed(0)
        );
      });
      /**
       * Calculates approximate number of hashes before first collision.
       *
       * Given that:
       *
       * - `H` is the total number of possible UUIDs, or in terms of this library,
       * the result of running `availableUUIDs()`
       * - the expected number of values we have to choose before finding the
       * first collision can be expressed as the quantity `Q(H)`
       *
       * Then `Q(H)` can be approximated as the square root of the product of half
       * of pi times `H`:
       *
       * <div style="background: white; padding: 5px; border-radius: 5px; overflow: hidden;">
       *  <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAM0AAABNCAYAAAAFDOCxAAAP5klEQVR4Ae2dBdD0SBGGX/xwdyjc3eHgkMLdpaCAw71wOeDQQwp3KdwKd3fncLfD3d0d9vlr+mdu/tmkJ8nut5uvuyq1m2Qy0hlpeXsiBQUHVsOBk0n6vKRDZ3ishmOR667nwC0l/WHBhYfM8Nj1LzcYsBoOPF/Sm1aTdeQaHJgnB74h6b7zbFq0KjgwPQdOKum/kvafPuvIMTgwTw5cV9LfJB1tns2LVgUHpufAEyV9cPpsI8fgwHw58ClJh8y3edGy4MC0HDimpH9KuvK02UZuwYH5cuBykv4t6XjzbWK0LDgwLQdwZn5u2iwjt+DAvDnwHklPnXcTo3XBgek4cGRJf5R0Q2eWR5F0Wkmndx4ncOYbyYIDW8OBCyWn5ql6asxgeYykP6f0OEI9x38knb0n77gdHNgqDtxD0nd6anxESW+W9DtJr5f07HT8OPvPtS8tBsirimv3kcSACwoOzIYDr12IWS/uac2DJL1B0omydGeR9NLsnL9vl4T5Oig4MGsO/FTSbTtaeA5JH5B01CLNQZIIJTBiNfq4ncRvcGCuHDhz0ku6dI4DJAHmLOmTkk6XXTynpLdm5/E3ODBLDtxK0q8lsUq00Gkkfbt44DaSnltci9PgwOw4QNAZukorHSzpecVDz5QE6DMoODBrDhB0du/GFrIqfVfSTYrn3ifpycW1OA0OzIoDFnR20cZWXTHpQaconjtsoeO8qLgWp8GBWXHgepL+UrGK9TUSszL+mJKwwkU8TsmVOJ8VB9A/3t/YorNJwsP/uMpzODoxKhypci8uJQ4cYxEee78d5gYixh12uA7bWjxBZw9rrDxef6AzhBKU9IV072LljW0+P+ECCnEBSTQKsF2rmTFv+7EkvXsJ8/J06/iPJecJ6yhoRmXw/gg6Qz/x0nGTOPezRYQnIM+SXpkGzcPLG9t2fsq0GuCpBTsE4I7YCfBB4I2essAJnbyxUQy2N/Z4kfMsr5A69aMl1Y5H5IkXDjIAhIgOtbRcY4DsVzwDnAMMVZCPA5eX9K8FnxkIXjp18s3cZckDrD5Y1ch7DLHBB+Lfsvd//yLzy/T0L/r8EYpnqqfgf0j8K0n3WvxHlCoJ6wdxFOyoeLXyZsc5g+4tHffLW3ibby6JxgJBZ3kHKUs+t6gwGdj5TRezGkA/5GTS84IfKwln3NUrqyQvnxcGA4P6OQDvP9OfbEdSnF/SgYv3/uC0GvL+f5P6D/3okkWtwMDdLC0Ov039hV11WPHoX1cq0ldPMSHSgWAKHbCLmLGBQ9ApL9uVMN1DEaTj9+Vby4oVCpQsTPA6wbDSkP51tQyLa/gNvhlbEBVcqZ8yWW66T4WJnn7J+y9Xl3qrJERH0qN7uekqaRb/qKRjO5+yeApMhn0IVZj9DGe+ZbLzpAbRqKuWNyvnBC8Rt076O1bul5cYlF/ZAONEWa9NO7egs+tvWsWK+iDu8e45Llzcq52eKUvvbhtiyz+S3NkaLffZVODdarVJ1zAi0ABWmyF01/Q8s4dnA4drZUzwlom8jbiJohtU5wAdkPdYOifrqXfuKuIV9eR91gwPZc3AvpEek3gNYFqmF3Idog8dstXDS2Ys1RT44X1y/v8FlO0x0G9ELMpAHPTQk1L6n3sVuYVhg8mCiSOHrHvK2k1pMJh8awsaTF+kv3iR0y9L6WuO132ayzaiiCUUMBTGcM/0PB2uNqoR9VCuHrBP6b4LWC9+mcrAQOEhs/u/wpM4S4NXGvF0KiLqkEkJM32NN55yaoYYz3OrSEPQ2QtXkfGEecIv+ht9GoOQh36U0rs2CGHmIPO/F/ENnoIszZ1THuTDh31Kuma675Ety2c5H6PPtDovH5iW6BPXKtJwDYscJvnfZ7z5U4pyZBC10JSDuKXcMi2TFyv3rcsbG3beqs/wPui7HMCDOgndAOgCicfMHmxHaoXmgUVWOLBvVqGhm2OjK5G/V5+5TlYfrz5jdcXESFnoREMJMe/LKR8scjjuWP6/mK4xQT3KYTihfHxlmM43gaxznXUTKtNRB+uPXn3mdum9oM+cpCPfPbesM9JJWry7Zb7EVdigqVnQ0GXoREOJzRjI36vPMMOTvkWfsbqxUvIsfp2h9JLU0TGulI4xVs13pTJ+IOkGHYXwLHkx6DaB8HMhJpdt2oS65XX4SOKvV595eUrv0mcscxgxVN6msnRmOhrO0JJgMEYGEAVDCFOwrYZfL3YqsV1Nyl9zarbqM9SP+v41oRaG1Be4EfI0g6OLWA2/l/j23uTnoq1G50tKLHAVLI+bQEyOHp/XTtYVfYaVnP7I9z/LvlE7x/lJ+qf1VRz4i/kxXt2XuOM+lUT0olBWhJIs7uI55Q3n+XlT3uSPvoENveuwpZb0rfqMVQnrEIaEIXSphKvzPAvvECVMaUWcYEW2SQK+4pXeFELUxOizyQQMh3fPgQuhq69wjyA6S9+rzwB9scReC0ONWabkk1etk9rmC16rV1nG3VM96UA10a9Mf+2sXUNl708n0a7M23POBhGt6O0zLJzJj09WTGJUWCnRgZgwpiZ0pCFkk99Fhjy8xmfAItIXmXjylXtZFdhJh/QufQYvuQ2aMfoMe16RD/CYGoAPLBD3W2Hk1khi0Hnea0Ea4p+xsuwXsZX2zI3OPUI/YhYG81duxdTFIyYtVv4pDu8EQj+hv9SknlpdzT+DkaaXzLdCAd4KlZliaWBmJA+U7xrhLOU+IL9WYqZAT+L5Es28LC/kWNKj3A0lgqvQa8YS1ibQtiik6HQYFy44IFNW27EELw9doMt/MjAj8H7oXi3E/s7gGKc4bu8oONdnutApeVbmn1nWf/O0e2RlOhcH4sEQYvXgeTo2CnCNmN1Ig4m1lVCGrY6ECPRRjjfzMHlZfnQujCNjCFnZAIPWBvvls+E4Oz2EcxQg4Vgyfxx16Nt3uVYWIutDazc26Bp9xHhM3+mjHG9GSEEvobBaARfvTb1vApDKOOvIA8j1MsJvQ5ohqFjTZ7AgeQCkOd5sqD5DOzAC9O1PvKy9XAdqTpsxLQMuRR9gS9ZLp729aA8rNPD1o3dllHZt+URPmr7bvCvaY+/b1UGyTC3obGysS5blSv4+MrURa60nbDrHm/X6Z6gxjkbr9MSflMRMyGwNZL50SmKWZYMEXkIfapmZkhl3iK+BYDXK+FhZuSXniBCkB3E9xpfAzI5eM4R4WSjyXeIoxgJEQOpKZ8aYUiMcrXSAO9VuNlzD9J5Pkq1GGQaLd+JqqNbkSekn8JR+4yHwkKR36TOWITgbHkJcyAmH27MWQWaXWMy6WKNKczGyOc+BQ/Ls6P79BkXe6oEMbvZzr2jH17io1xh9BkUXU3zZZqtX3y+GD0zWnpnuRmmAUWcca8yUKM1sGG6AQwaXh8fL6nXjxcAz+d78V627vjABsCfAJhOrobk+vFG4OJfhvUufscYD70Z2pzCTsRElyu1BMRqwkTWzN6BLCsLR5XWIMigxAbaQWd0oyxM9d/zM70THG0rnSu0bqnwT/VnuHtlVF8ROZn5WFNpqBzM78COU2zFE3jaADVmBhOF9d5RNHBRWyU0m208N/nmcwWfMeN0qru6JuMSUiPLLaGWVKYO8gIPge8D8CwARmb2FCJmmMezh6yWsTtaBGMh9xECx9ATGDSVEVfLxKJK1MtBRUDBbiecAGhKWgNPN0+bWMniHxiOvxZTBhfm9uWO1Vm5keiYq2oaU4JkQcJQbL4ZEEu8xg+KJ/mqyctHJjVDkn55s9GxKUaKYbRaz9LVfzKxUsNyKtExLQ9ilxsCO1iiWUcSVMmwVXxOiBulhlqVHJ8FeP2R2RCzDLDtGJyrbtSnnrILGI+9qbEFnrRuorKPNbKBBf2F7XGsXv+iJH6pE7NJ/uP61Ij1mZ3TYZusgnR/9BbQzChWWH5R99AN0F4CDNcIC5GEoMTvL8rB8GaDMgIiK+YFJnCW3jBbEu40Yl6e1/1yvIa6trGW/4MGYJOZIiIJmBke89hD6AZ1yFUSfo+94LKO18lnRwfjZO7dfRC/6S2kRQ9JBgrB0+S/ph5jia/Xacw2dpmZNwjfjdXiRB3L7WBl9aSUnuIHpnZkKvWauZJuNMIl5CICmd4B58iMNHRcLF1ZO6oF6gLEI6+dQmI+37LWlwxuPYprP9Cje6EHAxT2E4xFrWKs+5Ml7qjQvaJgEpipz3fkgfjIxgLXq22sBEZXwiinDvxHRscTlvkEwhYhOrIJso+Qx/Kybb83lmYkZnYfGAS4EBYCu0eecywsjwhP9wwOky59bx3+WbqAzQ6NL11HHKcog6tLkfwwPXWRBZ4BupyBEILYGq2EUyd/iu3D8giTZasoZbQxn5Wn1EGPVABu2SXB3ezEA91zx4fbAlv6aSZ332LdnA1LELyY0irytZ0NGJlO+kEbd3rGl/N1bbUQrZE4bMPhcemMP9j59+D/AWwDw5aLe4VOs/wyTOo5RT+jB+ms3bYl0TNu3oHRqlyUhrr6mvDjw/DgJgYKU0mXiNVQHotoyPOPAKqz/MRqN/4A4HPSZMYQfCFNxi2g3pryuZ7HAoBy3+JC68tuGewbhQV/pIoLOhjp5y3yBDtmk2zVYgQxZuk2P3SnbuPJzZvcSebDyQosCmAgQAzBR7ibKHcfLZn2cq3TeIaEMNV7aSkOeXe89D1nZv5bRbr8G8ncniZVuN4hkJY/z6FZiXmqE+N0Kt6nlk19jZyCwcF0SBtAhBhbWvbHbaOVlx//gwCgO4FA0EWjZt3lAU+BtXyflhgDwbkHBgY3iwA/TwFkWdkHQGWiPdZKBLrHMjsEPrrPOUdYu4gA7ELHa4Jsq4/4t6Mzz+ZSpWGbuCOrEZvdBwYGN44Ahz+mkpbJvQWcMnnWRhZx494JYV72inODAXg4ckOk1ZWQoaN+xIdZ7C3L8QSzDL4NzeY7ocgcLIsk2cADgLLoDKw3bcOUECBcn5DoI/w14M6JWg4IDG88BCw8/LKupBZ1hll41gWgGabJug8Oq2xX5z5gD7APBSoNPxCArAFZdu02O5AuoEja0WPZpRxAaY5EnI6sYjwcH9uUAwFkGDYfB8Qk6Y6P5VRLWOnxAywYMZaPfDAkbX2W9I+/ggPjcvA0aE5EIOuuCuYxlGw5MtvPqi6vCf+SJ9R9bn3g+ONDEASxVKOEMHGD7FnR2YFMubYlZQYjPIramdiAeEqhG3FVQcGAjOQBchUFDuAdhG/xfFYD1oGxlsxVu2e+mfwdnI19mVGo9HLBP7dF5QT8Tt78KQhTEwLBskJTXvRtErqKukWdwoJMD18g6Mns4jPnAV1dB6CdYw7zHfl2Zxb3gwE5ygG2O8lk+cF87+Tai7K3hAOHnNnDYLy4oOBAc6OEAXxVg0LD9bJh5e5gVt4MDcMC+A/TOYEdwIDjg4wCx+Kw0B/uSR6rgQHCAmH02GCGGP6jCgf8BynL2Ji/GeXEAAAAASUVORK5CYII=" />
       * </div>
       *
       * This function returns `Q(H)`.
       * 
       * (see [Poisson distribution](https://en.wikipedia.org/wiki/Poisson_distribution))
       */
      __publicField(this, "approxMaxBeforeCollision", (rounds = this.availableUUIDs(this.uuidLength)) => {
        return parseFloat(
          Math.sqrt(Math.PI / 2 * rounds).toFixed(20)
        );
      });
      /**
       * Calculates probability of generating duplicate UUIDs (a collision) in a
       * given number of UUID generation rounds.
       *
       * Given that:
       *
       * - `r` is the maximum number of times that `randomUUID()` will be called,
       * or better said the number of _rounds_
       * - `H` is the total number of possible UUIDs, or in terms of this library,
       * the result of running `availableUUIDs()`
       *
       * Then the probability of collision `p(r; H)` can be approximated as the result
       * of dividing the square root of the product of half of pi times `r` by `H`:
       *
       * <div style="background: white; padding: 5px; border-radius: 5px; overflow: hidden;">
       *  <img src="data:image/png;base64,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" />
       * </div>
       *
       * This function returns `p(r; H)`.
       * 
       * (see [Poisson distribution](https://en.wikipedia.org/wiki/Poisson_distribution))
       *
       * (Useful if you are wondering _"If I use this lib and expect to perform at most
       * `r` rounds of UUID generations, what is the probability that I will hit a duplicate UUID?"_.)
       */
      __publicField(this, "collisionProbability", (rounds = this.availableUUIDs(this.uuidLength), uuidLength = this.uuidLength) => {
        return parseFloat(
          (this.approxMaxBeforeCollision(rounds) / this.availableUUIDs(uuidLength)).toFixed(20)
        );
      });
      /**
       * Calculate a "uniqueness" score (from 0 to 1) of UUIDs based on size of
       * dictionary and chosen UUID length.
       *
       * Given that:
       *
       * - `H` is the total number of possible UUIDs, or in terms of this library,
       * the result of running `availableUUIDs()`
       * - `Q(H)` is the approximate number of hashes before first collision,
       * or in terms of this library, the result of running `approxMaxBeforeCollision()`
       *
       * Then `uniqueness` can be expressed as the additive inverse of the probability of
       * generating a "word" I had previously generated (a duplicate) at any given iteration
       * up to the the total number of possible UUIDs expressed as the quotiend of `Q(H)` and `H`:
       *
       * <div style="background: white; padding: 5px; border-radius: 5px; overflow: hidden;">
       *  <img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIcAAABDCAYAAAC2nhaoAAAJK0lEQVR4Ae2dB+w9RRHHvyCgYgUVxViCBQIRFRQEFVEERVGKggYwJiAkxCgqECkRJQqiCQjSYsEYCyrFggRDSywUpSN/ihXQINUCCigK4vvEmWS5XJm99/+/37t3O8nl3tudLTc7tzM7M7snFZgVBVaSdLikrWfVYEM7x0vaqCGvJAco8BhJW0raV9IRkg6V9B5JawfKNqGcKOljTZkzTH+apEslvXKGbS5EU8+T9FlJv5Z0jKQ3S3qZpNdJ+rikuySdIekFmU/7YUnfC5Z5iqRf2XWFpPT6paTfS9oqqeuxkq6zPqe4/L7G8LdP8Pm5nqTfSHpWJb38raHAKpL2l3SPzRRPrcEh6en21v3FGKYB7VHJm0q6U9IzH5Xa/udxkp4vCRHwiF0flLSWpNVrisIgMPZnEvyDbPCfUINP0n6T2fHHkhB3BRoosOZED7hI0t8kvb4BJ01mkP8sCQZZJ82o+b2yMdMBNXmRpBNssP8YQZZ0pOHTN0RjG6xqs8pubUhjznuOpOsl3SeJNzwK6A680V2iYg8TRXVve6StZdbO1yLIki4x/O8H8feR9CdJTwzijwbtyZJuNGK+K/OpX2zl/ivphS1l0RGObslvy3rGRM+hfphwzzZEy2OA/234Hwrgg0KZv0uCSQoYBZCzvF0Q/ts9qEJ5xBDl399QHqWR/I0b8ruSd7by1BFRgLdN8FGio/AtSZdFkceAx5sC0XnTIoSvowkrGur4Yl3mRBn8wuSNvGMKhS9X33BlFH0DXScK77XneEm0wCLjPckGjYHF9tAXbjGiNukd5PeZlbw/LE/pY1Tf+EVHf7ze6p1VDu2w3B49YK+AGFzr96QGYuVfVsdpNXW4TsJysg/k6hswfK6+kfbrbkmnpwlj/M2g3myDirLYFzAeOYMx/VdhR8t/ezUj+H+XpP6I2Htrgp+jb3h3fjZReqPLZS+zcHdMxj6omMT7wnZJPXUK6cGW39eH4foGff1r4Lrf2sP+kqNv+POfMnERPCxpNU8Y4/0TyaC+cQoCYGJ3JqsTTT64fX0x2F6o/8vBPv7c8L8bxK+iHWXl25bl1TIL9x+5CtF5S/Bh9AV8H9SDnQRRVQWUSPKxpeQCJnK3b+Ds64LUvoGjsA8cZv19RZ/Ci1LmJ0aE26d4IEQFA8/1gYZ6cM6Rj88jFzDIef2sJLoA56Djv7QLuSH/QKsDB+NoAUcThLx2Cgp83eq4tcXs7DMUDrRcYHlNH/G+RuDThp9r30jrPsTq2DxNHNtvlp0QHhtCH3hRsmTctaUCFytrtOA0Zbm+8ZUmhEq6+1P66htU90mjy6gNYT59YvrOBXSLC4yI32nQNbzOzxkebvccSPUNLJddgEPvQWsLl35fONbqiIixvm3MfTneDFf2mAVSwP3O6gBfA6uNqqcS/YJZ5ypJTTESXh8DBe5rPCF4f7eVo2yEsd6U4G8YbKMODTH4z4Cbv67sQqWdZQRlKnV4tkV4uRhY14J+PH+nSYjfQ5Iut4AfT2+6v8XaaBM9dWVPsnIY6iJACCOM1Ne+4W0QNjiNUdDrGfydNxJicrkdAjHw3MqTYRgC9ra3CpkeXZoSQMRymeCbHPAlctSfcrExR5N/J9I2RjPiWaJtRuocNM6rzPl2tYXXsQKpAlPtDwyPoJ1c4E08t6MQAwNTYvJ2fYiZgLZfXeMxBh/xt9kkEg3R5SLybBNhGLHq7C5t3djAGKxEhCVUYtZAxyBo+HcWYU5MxPtscJDBvPl1UVwMXBfgQses3bacfblFb50/Gdy6i5UISqoD4o60OlzSyIvoKl4fd5gMkUl8bBbAqZicI5pzVsVzhIxyCVPsZUYtjFAMAnK4znGGIktkehdQB282+sc8wzmTgKQf5nSQ6OvdTQFjmkuVt5x6hoz7W5tN0mcgSv1HkjZJE1t+Y3Rj2TuvQAwts8Y2kQ5+1aKqb7LlnAeQjJE5UFj/kCiqyHpWOtAkCq81ZZbV0DwC1tUro3oKQSOp29Z9BGNkDhiDWZM3C18MvxETuf6Hb9r+k3ljDgKK7jXltlffxswc7kOBKfz6aA8qovjih0H5nCfg+dg01RvGzBwMKkvE2ybbD4mU2qE3FaUtbFtjl2V1iiayir7DnimVElkVgDxm5sgmVkcBFHwMaawAlxLYKnFhn6VrtdOFOaoUme4/sRfs3l9KQDQ27QXO6ldhjixyjQu5MMe4xjvraQtzZJFrXMiFOcY13llPu7yYAxc2fgo260x79dm0w7KU5Vu54jTo3AC+vJgDZxZb7iIbdLpwzsti7/8jsyPsH+XKogGBR62wvJijtZGSOUwKFOYY5rjNpNeFOWZC5mE2UphjmOM2k17jC8Aj+amZtFYaGQwFCFQlEATm+MZgel06usIowK5uIp8JVuUwD49j4H7DJCKaZSRbCt+wwnpQKp5bCnBcEedxshW/6SIsfl7D3uaRsNCUs8GIdOdwufT60uToqVMr9GSrArvuTq7gejlezshpP/NIi9KnCgXY2sCxk8zKHpNLuCG71d422X9LnCmByw5sZWBmJv7Dj4xg5uY8U6zMBA5NFaTjDZX7fFHgTBPVbHuIAPGnLtIj+AVnoBRAwceFwGAza0TAj7M8LoJccIZLARyGMAYXu+O7AL3C8d/ZhVzyh00BziNnsP8z0R/YAtIFbMsEH/0k3RLZVa7kD5ACftY6O+MjgG0J5pjmiKpIOwVniSlAxDk76BjsqL7hm6qKvrHEg7eim2dDE4zBFdE32Kzt+EXfWNGjs8T1c+g8gx3VNzgwBnz0jeyjEZb4WUvzmRRwfeOBlrM10jM3XKQUfSOT0ENDR9/gjFBmAs4YbXJLpOmOX/SNoY12Zn/TE48jDkuObnJ9g4DoAgtMgY/YYPN9lscHnjO1bxR9I0CwIaO4P+WnwYfwox/K0Y9Bgg0VDX2DrRaIiegBOK6Mfn6oD136HaMAG4Ncf4h83yX1pxR9I0bjwWLxSXCYg/PJ646srD4Y348Fv9g3qpRZwP8c4chgc1hKBPxrC0XfiFBrwDh8S94/THx48DlK/EaQUENGQxF1EzgzB19cIK0JCBNMv9DEBwRhrgILRAE+icFXqLmqG8I5fH5Z5Vn5ymQVz/+Dz0G5q1bKzOzv/wAvzKhnhyEMfQAAAABJRU5ErkJggg==" />
       * </div>
       *
       * (Useful if you need a value to rate the "quality" of the combination of given dictionary
       * and UUID length. The closer to 1, higher the uniqueness and thus better the quality.)
       */
      __publicField(this, "uniqueness", (rounds = this.availableUUIDs(this.uuidLength)) => {
        const score = parseFloat(
          (1 - this.approxMaxBeforeCollision(rounds) / rounds).toFixed(20)
        );
        return score > 1 ? 1 : score < 0 ? 0 : score;
      });
      /**
       * Return the version of this module.
       */
      __publicField(this, "getVersion", () => {
        return this.version;
      });
      /**
       * Generates a UUID with a timestamp that can be extracted using `uid.parseStamp(stampString);`.
       * 
       * ```js
       *  const uidWithTimestamp = uid.stamp(32);
       *  console.log(uidWithTimestamp);
       *  // GDa608f973aRCHLXQYPTbKDbjDeVsSb3
       * 
       *  console.log(uid.parseStamp(uidWithTimestamp));
       *  // 2021-05-03T06:24:58.000Z
       *  ```
       */
      __publicField(this, "stamp", (finalLength, date) => {
        const hexStamp = Math.floor(+(date || /* @__PURE__ */ new Date()) / 1e3).toString(16);
        if (typeof finalLength === "number" && finalLength === 0) {
          return hexStamp;
        }
        if (typeof finalLength !== "number" || finalLength < 10) {
          throw new Error(
            [
              "Param finalLength must be a number greater than or equal to 10,",
              "or 0 if you want the raw hexadecimal timestamp"
            ].join("\n")
          );
        }
        const idLength = finalLength - 9;
        const rndIdx = Math.round(Math.random() * (idLength > 15 ? 15 : idLength));
        const id = this.randomUUID(idLength);
        return `${id.substring(0, rndIdx)}${hexStamp}${id.substring(rndIdx)}${rndIdx.toString(16)}`;
      });
      /**
       * Extracts the date embeded in a UUID generated using the `uid.stamp(finalLength);` method.
       * 
       * ```js
       *  const uidWithTimestamp = uid.stamp(32);
       *  console.log(uidWithTimestamp);
       *  // GDa608f973aRCHLXQYPTbKDbjDeVsSb3
       * 
       *  console.log(uid.parseStamp(uidWithTimestamp));
       *  // 2021-05-03T06:24:58.000Z
       *  ```
       */
      __publicField(this, "parseStamp", (suid, format) => {
        if (format && !/t0|t[1-9]\d{1,}/.test(format)) {
          throw new Error("Cannot extract date from a formated UUID with no timestamp in the format");
        }
        const stamp = format ? format.replace(
          /\$[rs]\d{0,}|\$t0|\$t[1-9]\d{1,}/g,
          (m) => {
            const fnMap = {
              "$r": (len2) => [...Array(len2)].map(() => "r").join(""),
              "$s": (len2) => [...Array(len2)].map(() => "s").join(""),
              "$t": (len2) => [...Array(len2)].map(() => "t").join("")
            };
            const fn = m.slice(0, 2);
            const len = parseInt(m.slice(2), 10);
            return fnMap[fn](len);
          }
        ).replace(
          /^(.*?)(t{8,})(.*)$/g,
          (_m, p1, p2) => {
            return suid.substring(p1.length, p1.length + p2.length);
          }
        ) : suid;
        if (stamp.length === 8) {
          return new Date(parseInt(stamp, 16) * 1e3);
        }
        if (stamp.length < 10) {
          throw new Error("Stamp length invalid");
        }
        const rndIdx = parseInt(stamp.substring(stamp.length - 1), 16);
        return new Date(parseInt(stamp.substring(rndIdx, rndIdx + 8), 16) * 1e3);
      });
      /**
       * Set the counter to a specific value.
       */
      __publicField(this, "setCounter", (counter) => {
        this.counter = counter;
      });
      /**
       * Validate given UID contains only characters from the instanced dictionary or optionally provided dictionary.
       */
      __publicField(this, "validate", (uid, dictionary) => {
        const finalDictionary = dictionary ? this._normalizeDictionary(dictionary) : this.dict;
        return uid.split("").every((c) => finalDictionary.includes(c));
      });
      const options = __spreadValues(__spreadValues({}, DEFAULT_OPTIONS), argOptions);
      this.counter = 0;
      this.debug = false;
      this.dict = [];
      this.version = version;
      const {
        dictionary,
        shuffle,
        length,
        counter
      } = options;
      this.uuidLength = length;
      this.setDictionary(dictionary, shuffle);
      this.setCounter(counter);
      this.debug = options.debug;
      this.log(this.dict);
      this.log(
        `Generator instantiated with Dictionary Size ${this.dictLength} and counter set to ${this.counter}`
      );
      this.log = this.log.bind(this);
      this.setDictionary = this.setDictionary.bind(this);
      this.setCounter = this.setCounter.bind(this);
      this.seq = this.seq.bind(this);
      this.sequentialUUID = this.sequentialUUID.bind(this);
      this.rnd = this.rnd.bind(this);
      this.randomUUID = this.randomUUID.bind(this);
      this.fmt = this.fmt.bind(this);
      this.formattedUUID = this.formattedUUID.bind(this);
      this.availableUUIDs = this.availableUUIDs.bind(this);
      this.approxMaxBeforeCollision = this.approxMaxBeforeCollision.bind(this);
      this.collisionProbability = this.collisionProbability.bind(this);
      this.uniqueness = this.uniqueness.bind(this);
      this.getVersion = this.getVersion.bind(this);
      this.stamp = this.stamp.bind(this);
      this.parseStamp = this.parseStamp.bind(this);
      return this;
    }
  };
  /** @hidden */
  __publicField(_ShortUniqueId, "default", _ShortUniqueId);
  var ShortUniqueId = _ShortUniqueId;
  return __toCommonJS(src_exports);
})();
//# sourceMappingURL=short-unique-id.js.map
 true&&(module.exports=ShortUniqueId.default),'undefined'!=typeof window&&(ShortUniqueId=ShortUniqueId.default);

/***/ }),

/***/ 8302:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getNodeType: () => (/* binding */ getNodeType),
/* harmony export */   keyMap: () => (/* binding */ keyMap)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43319);


/**
 * @public
 */
const getNodeType = element => {
  if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isElement)(element)) {
    return undefined;
  }
  return `${element.element.charAt(0).toUpperCase() + element.element.slice(1)}Element`;
};

/**
 * There are unfortunately two `LinkElement` types. One is from base namespace
 * and the other one if from this namespace. `LinkElement` from base namespace
 * is used extremely rarely so it's almost always safe during traversing
 * to assume that `LinkElement` is element from this namespace.
 *
 * To be 100% sure that currently visiting `LinkElement` is from this namespace
 * use `isLinkElement` predicate from this namespace to assert for it.
 * @public
 */

const keyMap = {
  CallbackElement: ['content'],
  ComponentsElement: ['content'],
  ContactElement: ['content'],
  DiscriminatorElement: ['content'],
  Encoding: ['content'],
  Example: ['content'],
  ExternalDocumentationElement: ['content'],
  HeaderElement: ['content'],
  InfoElement: ['content'],
  LicenseElement: ['content'],
  MediaTypeElement: ['content'],
  OAuthFlowElement: ['content'],
  OAuthFlowsElement: ['content'],
  OpenApi3_1Element: ['content'],
  OperationElement: ['content'],
  ParameterElement: ['content'],
  PathItemElement: ['content'],
  PathsElement: ['content'],
  ReferenceElement: ['content'],
  RequestBodyElement: ['content'],
  ResponseElement: ['content'],
  ResponsesElement: ['content'],
  SchemaElement: ['content'],
  SecurityRequirementElement: ['content'],
  SecuritySchemeElement: ['content'],
  ServerElement: ['content'],
  ServerVariableElement: ['content'],
  TagElement: ['content'],
  ..._swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.keyMapDefault
};

/***/ }),

/***/ 8331:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class OperationParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ArrayElement {
  static primaryClass = 'operation-parameters';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OperationParameters.primaryClass);
    this.classes.push('parameters');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationParameters);

/***/ }),

/***/ 8564:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2173);
/* harmony import */ var _curryN_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25845);



/**
 * Creates a function that will process either the `onTrue` or the `onFalse`
 * function depending upon the result of the `condition` predicate.
 *
 * Note that `ifElse` takes its arity from the longest of the three functions passed to it.
 *
 * @func
 * @memberOf R
 * @since v0.8.0
 * @category Logic
 * @sig (*... -> Boolean) -> (*... -> *) -> (*... -> *) -> (*... -> *)
 * @param {Function} condition A predicate function
 * @param {Function} onTrue A function to invoke when the `condition` evaluates to a truthy value.
 * @param {Function} onFalse A function to invoke when the `condition` evaluates to a falsy value.
 * @return {Function} A new function that will process either the `onTrue` or the `onFalse`
 *                    function depending upon the result of the `condition` predicate.
 * @see R.unless, R.when, R.cond
 * @example
 *
 *      const incCount = R.ifElse(
 *        R.has('count'),
 *        R.over(R.lensProp('count'), R.inc),
 *        R.assoc('count', 1)
 *      );
 *      incCount({ count: 1 }); //=> { count: 2 }
 *      incCount({});           //=> { count: 1 }
 */
var ifElse = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function ifElse(condition, onTrue, onFalse) {
  return (0,_curryN_js__WEBPACK_IMPORTED_MODULE_1__["default"])(Math.max(condition.length, onTrue.length, onFalse.length), function _ifElse() {
    return condition.apply(this, arguments) ? onTrue.apply(this, arguments) : onFalse.apply(this, arguments);
  });
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ifElse);

/***/ }),

/***/ 8609:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10625);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66536);
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81145);



/**
 * Checks if input value is not an empty `Array`.
 *
 * @func isNonEmptyArray
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.4.0|v2.4.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isEmptyArray|isEmptyArray}
 * @example
 *
 * RA.isNonEmptyArray([42]); // => true
 * RA.isNonEmptyArray([]); // => false
 * RA.isNonEmptyArray({}); // => false
 * RA.isNonEmptyArray(null); // => false
 * RA.isNonEmptyArray(undefined); // => false
 * RA.isNonEmptyArray(42); // => false
 * RA.isNonEmptyArray('42'); // => false
 */
var isNonEmptyArray = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(_isArray_js__WEBPACK_IMPORTED_MODULE_1__["default"], ramda__WEBPACK_IMPORTED_MODULE_2__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNonEmptyArray);

/***/ }),

/***/ 8839:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _elements_nces_ComponentsParameters_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18684);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48018);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39633);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9748);






/**
 * @public
 */
/**
 * @public
 */
class ParametersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsParameters_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Parameter'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every ReferenceElement with metadata about their referencing type
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'parameter');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParametersVisitor);

/***/ }),

/***/ 9101:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25789);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88172);


/**
 * @public
 */
const jsonSchema202012 = {
  namespace: options => {
    const {
      base
    } = options;
    base.register('jSONSchema202012', _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]);
    base.register('linkDescription', _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]);
    return base;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (jsonSchema202012);

/***/ }),

/***/ 9170:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BundleError: () => (/* reexport safe */ _errors_BundleError_mjs__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   BundleStrategy: () => (/* reexport safe */ _bundle_strategies_BundleStrategy_mjs__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   DereferenceAncestorLineage: () => (/* reexport safe */ _dereference_util_mjs__WEBPACK_IMPORTED_MODULE_6__.AncestorLineage),
/* harmony export */   DereferenceError: () => (/* reexport safe */ _errors_DereferenceError_mjs__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   DereferenceStrategy: () => (/* reexport safe */ _dereference_strategies_DereferenceStrategy_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   EvaluationElementIdError: () => (/* reexport safe */ _errors_EvaluationElementIdError_mjs__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   EvaluationJsonSchema$anchorError: () => (/* reexport safe */ _errors_EvaluationJsonSchema$anchorError_mjs__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   EvaluationJsonSchemaUriError: () => (/* reexport safe */ _errors_EvaluationJsonSchemaUriError_mjs__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   File: () => (/* reexport safe */ _File_mjs__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   HTTPResolver: () => (/* reexport safe */ _resolve_resolvers_HTTPResolver_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   InvalidJsonSchema$anchorError: () => (/* reexport safe */ _errors_InvalidJsonSchema$anchorError_mjs__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   JsonSchema$anchorError: () => (/* reexport safe */ _errors_JsonSchema$anchorError_mjs__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   JsonSchemaURIError: () => (/* reexport safe */ _errors_JsonSchemaUriError_mjs__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   MaximumBundleDepthError: () => (/* reexport safe */ _errors_MaximumBundleDepthError_mjs__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   MaximumDereferenceDepthError: () => (/* reexport safe */ _errors_MaximumDereferenceDepthError_mjs__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   MaximumResolveDepthError: () => (/* reexport safe */ _errors_MaximumResolveDepthError_mjs__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   ParseError: () => (/* reexport safe */ _errors_ParseError_mjs__WEBPACK_IMPORTED_MODULE_25__["default"]),
/* harmony export */   Parser: () => (/* reexport safe */ _parse_parsers_Parser_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   ParserError: () => (/* reexport safe */ _errors_ParserError_mjs__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   PluginError: () => (/* reexport safe */ _errors_PluginError_mjs__WEBPACK_IMPORTED_MODULE_27__["default"]),
/* harmony export */   Reference: () => (/* reexport safe */ _Reference_mjs__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   ReferenceSet: () => (/* reexport safe */ _ReferenceSet_mjs__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   ResolveError: () => (/* reexport safe */ _errors_ResolveError_mjs__WEBPACK_IMPORTED_MODULE_28__["default"]),
/* harmony export */   ResolveStrategy: () => (/* reexport safe */ _resolve_strategies_ResolveStrategy_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   Resolver: () => (/* reexport safe */ _resolve_resolvers_Resolver_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   ResolverError: () => (/* reexport safe */ _errors_ResolverError_mjs__WEBPACK_IMPORTED_MODULE_29__["default"]),
/* harmony export */   UnmatchedBundleStrategyError: () => (/* reexport safe */ _errors_UnmatchedBundleStrategyError_mjs__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   UnmatchedDereferenceStrategyError: () => (/* reexport safe */ _errors_UnmatchedDereferenceStrategyError_mjs__WEBPACK_IMPORTED_MODULE_30__["default"]),
/* harmony export */   UnmatchedResolveStrategyError: () => (/* reexport safe */ _errors_UnmatchedResolveStrategyError_mjs__WEBPACK_IMPORTED_MODULE_31__["default"]),
/* harmony export */   UnmatchedResolverError: () => (/* reexport safe */ _errors_UnmatchedResolverError_mjs__WEBPACK_IMPORTED_MODULE_32__["default"]),
/* harmony export */   bundle: () => (/* binding */ bundle),
/* harmony export */   dereference: () => (/* binding */ dereference),
/* harmony export */   dereferenceApiDOM: () => (/* binding */ dereferenceApiDOM),
/* harmony export */   mergeOptions: () => (/* reexport safe */ _options_util_mjs__WEBPACK_IMPORTED_MODULE_9__.merge),
/* harmony export */   options: () => (/* reexport safe */ _options_index_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   parse: () => (/* binding */ parse),
/* harmony export */   readFile: () => (/* binding */ readFile),
/* harmony export */   resolve: () => (/* binding */ resolve),
/* harmony export */   resolveApiDOM: () => (/* binding */ resolveApiDOM),
/* harmony export */   url: () => (/* reexport module object */ _util_url_mjs__WEBPACK_IMPORTED_MODULE_0__)
/* harmony export */ });
/* harmony import */ var _File_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(38396);
/* harmony import */ var _ReferenceSet_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(56479);
/* harmony import */ var _util_url_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(96664);
/* harmony import */ var _options_index_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(91613);
/* harmony import */ var _options_util_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(6163);
/* harmony import */ var _parse_index_mjs__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(1650);
/* harmony import */ var _resolve_index_mjs__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(84891);
/* harmony import */ var _resolve_util_mjs__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(84494);
/* harmony import */ var _dereference_index_mjs__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(44071);
/* harmony import */ var _bundle_index_mjs__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(43119);
/* harmony import */ var _parse_parsers_Parser_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71676);
/* harmony import */ var _resolve_resolvers_Resolver_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26947);
/* harmony import */ var _resolve_resolvers_HTTPResolver_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(35731);
/* harmony import */ var _resolve_strategies_ResolveStrategy_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(58424);
/* harmony import */ var _dereference_strategies_DereferenceStrategy_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(96392);
/* harmony import */ var _dereference_util_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(34306);
/* harmony import */ var _bundle_strategies_BundleStrategy_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(12738);
/* harmony import */ var _Reference_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(83561);
/* harmony import */ var _errors_BundleError_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(41412);
/* harmony import */ var _errors_MaximumBundleDepthError_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(43011);
/* harmony import */ var _errors_UnmatchedBundleStrategyError_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(1824);
/* harmony import */ var _errors_DereferenceError_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(36892);
/* harmony import */ var _errors_EvaluationElementIdError_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(99923);
/* harmony import */ var _errors_EvaluationJsonSchema$anchorError_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(38708);
/* harmony import */ var _errors_EvaluationJsonSchemaUriError_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(83915);
/* harmony import */ var _errors_InvalidJsonSchema$anchorError_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(77559);
/* harmony import */ var _errors_JsonSchema$anchorError_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(11290);
/* harmony import */ var _errors_JsonSchemaUriError_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(82885);
/* harmony import */ var _errors_MaximumDereferenceDepthError_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(7699);
/* harmony import */ var _errors_MaximumResolveDepthError_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(99139);
/* harmony import */ var _errors_ParseError_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(58155);
/* harmony import */ var _errors_ParserError_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(20835);
/* harmony import */ var _errors_PluginError_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(18223);
/* harmony import */ var _errors_ResolveError_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(35416);
/* harmony import */ var _errors_ResolverError_mjs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(97618);
/* harmony import */ var _errors_UnmatchedDereferenceStrategyError_mjs__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(78706);
/* harmony import */ var _errors_UnmatchedResolveStrategyError_mjs__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(24638);
/* harmony import */ var _errors_UnmatchedResolverError_mjs__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(12207);











































/**
 * @public
 */
const readFile = async (uri, options = {}) => {
  const mergedOptions = (0,_options_util_mjs__WEBPACK_IMPORTED_MODULE_9__.merge)(_options_index_mjs__WEBPACK_IMPORTED_MODULE_8__["default"], options);
  const file = new _File_mjs__WEBPACK_IMPORTED_MODULE_10__["default"]({
    uri: _util_url_mjs__WEBPACK_IMPORTED_MODULE_0__.sanitize(uri)
  });
  return (0,_resolve_util_mjs__WEBPACK_IMPORTED_MODULE_33__.readFile)(file, mergedOptions);
};

/**
 * @public
 */
const parse = async (uri, options = {}) => {
  const mergedOptions = (0,_options_util_mjs__WEBPACK_IMPORTED_MODULE_9__.merge)(_options_index_mjs__WEBPACK_IMPORTED_MODULE_8__["default"], options);
  return (0,_parse_index_mjs__WEBPACK_IMPORTED_MODULE_34__["default"])(uri, mergedOptions);
};

/**
 * @public
 */
const resolve = async (uri, options = {}) => {
  const mergedOptions = (0,_options_util_mjs__WEBPACK_IMPORTED_MODULE_9__.merge)(_options_index_mjs__WEBPACK_IMPORTED_MODULE_8__["default"], options);
  return (0,_resolve_index_mjs__WEBPACK_IMPORTED_MODULE_35__["default"])(uri, mergedOptions);
};

/**
 * @public
 */
const resolveApiDOM = async (element, options = {}) => {
  const mergedOptions = (0,_options_util_mjs__WEBPACK_IMPORTED_MODULE_9__.merge)(_options_index_mjs__WEBPACK_IMPORTED_MODULE_8__["default"], options);
  return (0,_resolve_index_mjs__WEBPACK_IMPORTED_MODULE_35__.resolveApiDOM)(element, mergedOptions);
};

/**
 * @public
 */
const dereference = async (uri, options = {}) => {
  const mergedOptions = (0,_options_util_mjs__WEBPACK_IMPORTED_MODULE_9__.merge)(_options_index_mjs__WEBPACK_IMPORTED_MODULE_8__["default"], options);
  return (0,_dereference_index_mjs__WEBPACK_IMPORTED_MODULE_36__["default"])(uri, mergedOptions);
};

/**
 * @public
 */
const dereferenceApiDOM = async (element, options = {}) => {
  const mergedOptions = (0,_options_util_mjs__WEBPACK_IMPORTED_MODULE_9__.merge)(_options_index_mjs__WEBPACK_IMPORTED_MODULE_8__["default"], options);
  return (0,_dereference_index_mjs__WEBPACK_IMPORTED_MODULE_36__.dereferenceApiDOM)(element, mergedOptions);
};

/**
 * @public
 */
const bundle = async (uri, options = {}) => {
  const mergedOptions = (0,_options_util_mjs__WEBPACK_IMPORTED_MODULE_9__.merge)(_options_index_mjs__WEBPACK_IMPORTED_MODULE_8__["default"], options);
  return (0,_bundle_index_mjs__WEBPACK_IMPORTED_MODULE_37__["default"])(uri, mergedOptions);
};

/***/ }),

/***/ 9325:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var freeGlobal = __webpack_require__(34840);

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

module.exports = root;


/***/ }),

/***/ 9489:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BasePathsVisitor: () => (/* binding */ BasePathsVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42815);


/**
 * @public
 */
const BasePathsVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.Paths.$visitor;
/**
 * @public
 */
class PathsVisitor extends BasePathsVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathsVisitor);

/***/ }),

/***/ 9748:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isBooleanJsonSchemaElement: () => (/* binding */ isBooleanJsonSchemaElement),
/* harmony export */   isCallbackElement: () => (/* binding */ isCallbackElement),
/* harmony export */   isComponentsElement: () => (/* binding */ isComponentsElement),
/* harmony export */   isContactElement: () => (/* binding */ isContactElement),
/* harmony export */   isExampleElement: () => (/* binding */ isExampleElement),
/* harmony export */   isExternalDocumentationElement: () => (/* binding */ isExternalDocumentationElement),
/* harmony export */   isHeaderElement: () => (/* binding */ isHeaderElement),
/* harmony export */   isInfoElement: () => (/* binding */ isInfoElement),
/* harmony export */   isLicenseElement: () => (/* binding */ isLicenseElement),
/* harmony export */   isLinkElement: () => (/* binding */ isLinkElement),
/* harmony export */   isMediaTypeElement: () => (/* binding */ isMediaTypeElement),
/* harmony export */   isOpenApi3_0Element: () => (/* binding */ isOpenApi3_0Element),
/* harmony export */   isOpenapiElement: () => (/* binding */ isOpenapiElement),
/* harmony export */   isOperationElement: () => (/* binding */ isOperationElement),
/* harmony export */   isParameterElement: () => (/* binding */ isParameterElement),
/* harmony export */   isPathItemElement: () => (/* binding */ isPathItemElement),
/* harmony export */   isPathsElement: () => (/* binding */ isPathsElement),
/* harmony export */   isReferenceElement: () => (/* binding */ isReferenceElement),
/* harmony export */   isRequestBodyElement: () => (/* binding */ isRequestBodyElement),
/* harmony export */   isResponseElement: () => (/* binding */ isResponseElement),
/* harmony export */   isResponsesElement: () => (/* binding */ isResponsesElement),
/* harmony export */   isSchemaElement: () => (/* binding */ isSchemaElement),
/* harmony export */   isSecurityRequirementElement: () => (/* binding */ isSecurityRequirementElement),
/* harmony export */   isSecuritySchemeElement: () => (/* binding */ isSecuritySchemeElement),
/* harmony export */   isServerElement: () => (/* binding */ isServerElement),
/* harmony export */   isServerVariableElement: () => (/* binding */ isServerVariableElement),
/* harmony export */   isServersElement: () => (/* binding */ isServersElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46902);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(27121);
/* harmony import */ var _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(29825);
/* harmony import */ var _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(54492);
/* harmony import */ var _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42856);
/* harmony import */ var _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(68562);
/* harmony import */ var _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86729);
/* harmony import */ var _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(94831);
/* harmony import */ var _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(52824);
/* harmony import */ var _elements_License_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(77785);
/* harmony import */ var _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(96184);
/* harmony import */ var _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(29364);
/* harmony import */ var _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(42280);
/* harmony import */ var _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(16307);
/* harmony import */ var _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(71521);
/* harmony import */ var _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(65304);
/* harmony import */ var _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(77116);
/* harmony import */ var _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(86371);
/* harmony import */ var _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(1843);
/* harmony import */ var _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(37985);
/* harmony import */ var _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(35600);
/* harmony import */ var _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(53369);
/* harmony import */ var _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(86739);
/* harmony import */ var _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(18191);
/* harmony import */ var _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(74849);
/* harmony import */ var _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(70369);
/* harmony import */ var _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(41392);
/* harmony import */ var _elements_nces_Servers_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(59360);

























 // NCE types

/**
 * @public
 */
const isCallbackElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_1__["default"] || hasBasicElementProps(element) && isElementType('callback', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isComponentsElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('components', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isContactElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__["default"] || hasBasicElementProps(element) && isElementType('contact', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isExampleElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_4__["default"] || hasBasicElementProps(element) && isElementType('example', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isExternalDocumentationElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_5__["default"] || hasBasicElementProps(element) && isElementType('externalDocumentation', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isHeaderElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_6__["default"] || hasBasicElementProps(element) && isElementType('header', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isInfoElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_7__["default"] || hasBasicElementProps(element) && isElementType('info', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isLicenseElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_License_mjs__WEBPACK_IMPORTED_MODULE_8__["default"] || hasBasicElementProps(element) && isElementType('license', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isLinkElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_9__["default"] || hasBasicElementProps(element) && isElementType('link', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isOpenapiElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_10__["default"] || hasBasicElementProps(element) && isElementType('openapi', element) && primitiveEq('string', element);
});

/**
 * @public
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
const isOpenApi3_0Element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq,
  hasClass
}) => {
  return element => element instanceof _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_11__["default"] || hasBasicElementProps(element) && isElementType('openApi3_0', element) && primitiveEq('object', element) && hasClass('api', element);
});

/**
 * @public
 */
const isOperationElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_12__["default"] || hasBasicElementProps(element) && isElementType('operation', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isParameterElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_13__["default"] || hasBasicElementProps(element) && isElementType('parameter', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isPathItemElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_14__["default"] || hasBasicElementProps(element) && isElementType('pathItem', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isPathsElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_15__["default"] || hasBasicElementProps(element) && isElementType('paths', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isReferenceElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_16__["default"] || hasBasicElementProps(element) && isElementType('reference', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isRequestBodyElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_17__["default"] || hasBasicElementProps(element) && isElementType('requestBody', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isResponseElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_18__["default"] || hasBasicElementProps(element) && isElementType('response', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isResponsesElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_19__["default"] || hasBasicElementProps(element) && isElementType('responses', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_20__["default"] || hasBasicElementProps(element) && isElementType('schema', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isBooleanJsonSchemaElement = element => {
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_21__.isBooleanElement)(element) && element.classes.includes('boolean-json-schema');
};

/**
 * @public
 */
const isSecurityRequirementElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_22__["default"] || hasBasicElementProps(element) && isElementType('securityRequirement', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isSecuritySchemeElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_23__["default"] || hasBasicElementProps(element) && isElementType('securityScheme', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isServerElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_24__["default"] || hasBasicElementProps(element) && isElementType('server', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isServerVariableElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_25__["default"] || hasBasicElementProps(element) && isElementType('serverVariable', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isMediaTypeElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_26__["default"] || hasBasicElementProps(element) && isElementType('mediaType', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isServersElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq,
  hasClass
}) => {
  return element => element instanceof _elements_nces_Servers_mjs__WEBPACK_IMPORTED_MODULE_27__["default"] || hasBasicElementProps(element) && isElementType('array', element) && primitiveEq('array', element) && hasClass('servers', element);
});

/***/ }),

/***/ 9816:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ResolveStrategy_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58424);
/* harmony import */ var _ReferenceSet_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56479);
/* harmony import */ var _options_util_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6163);
/* harmony import */ var _errors_UnmatchedDereferenceStrategyError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(78706);




/**
 * @public
 */
/**
 * @public
 */
class OpenAPI3_1ResolveStrategy extends _ResolveStrategy_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super({
      ...(options !== null && options !== void 0 ? options : {}),
      name: 'openapi-3-1'
    });
  }
  canResolve(file, options) {
    const dereferenceStrategy = options.dereference.strategies.find(strategy => strategy.name === 'openapi-3-1');
    if (dereferenceStrategy === undefined) {
      return false;
    }
    return dereferenceStrategy.canDereference(file, options);
  }
  async resolve(file, options) {
    const dereferenceStrategy = options.dereference.strategies.find(strategy => strategy.name === 'openapi-3-1');
    if (dereferenceStrategy === undefined) {
      throw new _errors_UnmatchedDereferenceStrategyError_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]('"openapi-3-1" dereference strategy is not available.');
    }
    const refSet = new _ReferenceSet_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]();
    const mergedOptions = (0,_options_util_mjs__WEBPACK_IMPORTED_MODULE_3__.merge)(options, {
      resolve: {
        internal: false
      },
      dereference: {
        refSet
      }
    });
    await dereferenceStrategy.dereference(file, mergedOptions);
    return refSet;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenAPI3_1ResolveStrategy);

/***/ }),

/***/ 10033:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6557);
/* harmony import */ var _elements_nces_MediaTypeExamples_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(45065);


/**
 * @public
 */
class ExamplesVisitor extends _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_MediaTypeExamples_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExamplesVisitor);

/***/ }),

/***/ 10043:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var isPossiblePrototype = __webpack_require__(54018);

var $String = String;
var $TypeError = TypeError;

module.exports = function (argument) {
  if (isPossiblePrototype(argument)) return argument;
  throw new $TypeError("Can't set " + $String(argument) + ' as a prototype');
};


/***/ }),

/***/ 10067:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3579);
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5564);
/* harmony import */ var _isString_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(18228);




/**
 * Tests whether or not an object is similar to an array.
 *
 * @private
 * @category Type
 * @category List
 * @sig * -> Boolean
 * @param {*} x The object to test.
 * @return {Boolean} `true` if `x` has a numeric length property and extreme indices defined; `false` otherwise.
 * @example
 *
 *      _isArrayLike([]); //=> true
 *      _isArrayLike(true); //=> false
 *      _isArrayLike({}); //=> false
 *      _isArrayLike({length: 10}); //=> false
 *      _isArrayLike({0: 'zero', 9: 'nine', length: 10}); //=> true
 *      _isArrayLike({nodeType: 1, length: 1}) // => false
 */
var _isArrayLike = /*#__PURE__*/(0,_curry1_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function isArrayLike(x) {
  if ((0,_isArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(x)) {
    return true;
  }
  if (!x) {
    return false;
  }
  if (typeof x !== 'object') {
    return false;
  }
  if ((0,_isString_js__WEBPACK_IMPORTED_MODULE_2__["default"])(x)) {
    return false;
  }
  if (x.length === 0) {
    return true;
  }
  if (x.length > 0) {
    return x.hasOwnProperty(0) && x.hasOwnProperty(x.length - 1);
  }
  return false;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_isArrayLike);

/***/ }),

/***/ 10300:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var call = __webpack_require__(13930);
var aCallable = __webpack_require__(82159);
var anObject = __webpack_require__(36624);
var tryToString = __webpack_require__(4640);
var getIteratorMethod = __webpack_require__(73448);

var $TypeError = TypeError;

module.exports = function (argument, usingIterator) {
  var iteratorMethod = arguments.length < 2 ? getIteratorMethod(argument) : usingIterator;
  if (aCallable(iteratorMethod)) return anObject(call(iteratorMethod, argument));
  throw new $TypeError(tryToString(argument) + ' is not iterable');
};


/***/ }),

/***/ 10316:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const isEqual = __webpack_require__(2404);
const KeyValuePair = __webpack_require__(55973);
const ArraySlice = __webpack_require__(92340);

/**
 * @class
 *
 * @param content
 * @param meta
 * @param attributes
 *
 * @property {string} element
 */
class Element {
  constructor(content, meta, attributes) {
    // Lazy load this.meta and this.attributes because it's a Minim element
    // Otherwise, we get into circuluar calls
    if (meta) {
      this.meta = meta;
    }

    if (attributes) {
      this.attributes = attributes;
    }

    this.content = content;
  }

  /**
   * Freezes the element to prevent any mutation.
   * A frozen element will add `parent` property to every child element
   * to allow traversing up the element tree.
   */
  freeze() {
    if (Object.isFrozen(this)) {
      return;
    }

    if (this._meta) {
      this.meta.parent = this;
      this.meta.freeze();
    }

    if (this._attributes) {
      this.attributes.parent = this;
      this.attributes.freeze();
    }

    this.children.forEach((element) => {
      element.parent = this;
      element.freeze();
    }, this);

    if (this.content && Array.isArray(this.content)) {
      Object.freeze(this.content);
    }

    Object.freeze(this);
  }

  primitive() {

  }

  /**
   * Creates a deep clone of the instance
   */
  clone() {
    const copy = new this.constructor();

    copy.element = this.element;

    if (this.meta.length) {
      copy._meta = this.meta.clone();
    }

    if (this.attributes.length) {
      copy._attributes = this.attributes.clone();
    }

    if (this.content) {
      if (this.content.clone) {
        copy.content = this.content.clone();
      } else if (Array.isArray(this.content)) {
        copy.content = this.content.map(element => element.clone());
      } else {
        copy.content = this.content;
      }
    } else {
      copy.content = this.content;
    }

    return copy;
  }

  /**
   */
  toValue() {
    if (this.content instanceof Element) {
      return this.content.toValue();
    }

    if (this.content instanceof KeyValuePair) {
      return {
        key: this.content.key.toValue(),
        value: this.content.value ? this.content.value.toValue() : undefined,
      };
    }

    if (this.content && this.content.map) {
      return this.content.map(element => element.toValue(), this);
    }

    return this.content;
  }

  /**
   * Creates a reference pointing at the Element
   * @returns {RefElement}
   * @memberof Element.prototype
   */
  toRef(path) {
    if (this.id.toValue() === '') {
      throw Error('Cannot create reference to an element that does not contain an ID');
    }

    const ref = new this.RefElement(this.id.toValue());

    if (path) {
      ref.path = path;
    }

    return ref;
  }

  /**
   * Finds the given elements in the element tree.
   * When providing multiple element names, you must first freeze the element.
   *
   * @param names {...elementNames}
   * @returns {ArraySlice}
   */
  findRecursive(...elementNames) {
    if (arguments.length > 1 && !this.isFrozen) {
      throw new Error('Cannot find recursive with multiple element names without first freezing the element. Call `element.freeze()`');
    }

    const elementName = elementNames.pop();
    let elements = new ArraySlice();

    const append = (array, element) => {
      array.push(element);
      return array;
    };

    // Checks the given element and appends element/sub-elements
    // that match element name to given array
    const checkElement = (array, element) => {
      if (element.element === elementName) {
        array.push(element);
      }

      const items = element.findRecursive(elementName);
      if (items) {
        items.reduce(append, array);
      }

      if (element.content instanceof KeyValuePair) {
        if (element.content.key) {
          checkElement(array, element.content.key);
        }

        if (element.content.value) {
          checkElement(array, element.content.value);
        }
      }

      return array;
    };

    if (this.content) {
      // Direct Element
      if (this.content.element) {
        checkElement(elements, this.content);
      }

      // Element Array
      if (Array.isArray(this.content)) {
        this.content.reduce(checkElement, elements);
      }
    }

    if (!elementNames.isEmpty) {
      elements = elements.filter((element) => {
        let parentElements = element.parents.map(e => e.element);

        // eslint-disable-next-line no-restricted-syntax
        for (const namesIndex in elementNames) {
          const name = elementNames[namesIndex];
          const index = parentElements.indexOf(name);

          if (index !== -1) {
            parentElements = parentElements.splice(0, index);
          } else {
            return false;
          }
        }

        return true;
      });
    }

    return elements;
  }

  set(content) {
    this.content = content;
    return this;
  }

  equals(value) {
    return isEqual(this.toValue(), value);
  }

  getMetaProperty(name, value) {
    if (!this.meta.hasKey(name)) {
      if (this.isFrozen) {
        const element = this.refract(value);
        element.freeze();
        return element;
      }

      this.meta.set(name, value);
    }

    return this.meta.get(name);
  }

  setMetaProperty(name, value) {
    this.meta.set(name, value);
  }

  /**
   * @type String
   */
  get element() {
    // Returns 'element' so we don't have undefined as element
    return this._storedElement || 'element';
  }

  set element(element) {
    this._storedElement = element;
  }

  get content() {
    return this._content;
  }

  set content(value) {
    if (value instanceof Element) {
      this._content = value;
    } else if (value instanceof ArraySlice) {
      this.content = value.elements;
    } else if (
      typeof value == 'string'
      || typeof value == 'number'
      || typeof value == 'boolean'
      || value === 'null'
      || value == undefined
    ) {
      // Primitive Values
      this._content = value;
    } else if (value instanceof KeyValuePair) {
      this._content = value;
    } else if (Array.isArray(value)) {
      this._content = value.map(this.refract);
    } else if (typeof value === 'object') {
      this._content = Object.keys(value).map(key => new this.MemberElement(key, value[key]));
    } else {
      throw new Error('Cannot set content to given value');
    }
  }

  /**
   * @type ObjectElement
   */
  get meta() {
    if (!this._meta) {
      if (this.isFrozen) {
        const meta = new this.ObjectElement();
        meta.freeze();
        return meta;
      }

      this._meta = new this.ObjectElement();
    }

    return this._meta;
  }

  set meta(value) {
    if (value instanceof this.ObjectElement) {
      this._meta = value;
    } else {
      this.meta.set(value || {});
    }
  }

  /**
   * The attributes property defines attributes about the given instance
   * of the element, as specified by the element property.
   *
   * @type ObjectElement
   */
  get attributes() {
    if (!this._attributes) {
      if (this.isFrozen) {
        const meta = new this.ObjectElement();
        meta.freeze();
        return meta;
      }

      this._attributes = new this.ObjectElement();
    }

    return this._attributes;
  }

  set attributes(value) {
    if (value instanceof this.ObjectElement) {
      this._attributes = value;
    } else {
      this.attributes.set(value || {});
    }
  }

  /**
   * Unique Identifier, MUST be unique throughout an entire element tree.
   * @type StringElement
   */
  get id() {
    return this.getMetaProperty('id', '');
  }

  set id(element) {
    this.setMetaProperty('id', element);
  }

  /**
   * @type ArrayElement
   */
  get classes() {
    return this.getMetaProperty('classes', []);
  }

  set classes(element) {
    this.setMetaProperty('classes', element);
  }

  /**
   * Human-readable title of element
   * @type StringElement
   */
  get title() {
    return this.getMetaProperty('title', '');
  }

  set title(element) {
    this.setMetaProperty('title', element);
  }

  /**
   * Human-readable description of element
   * @type StringElement
   */
  get description() {
    return this.getMetaProperty('description', '');
  }

  set description(element) {
    this.setMetaProperty('description', element);
  }

  /**
   * @type ArrayElement
   */
  get links() {
    return this.getMetaProperty('links', []);
  }

  set links(element) {
    this.setMetaProperty('links', element);
  }

  /**
   * Returns whether the element is frozen.
   * @type boolean
   * @see freeze
   */
  get isFrozen() {
    return Object.isFrozen(this);
  }

  /**
   * Returns all of the parent elements.
   * @type ArraySlice
   */
  get parents() {
    let { parent } = this;
    const parents = new ArraySlice();

    while (parent) {
      parents.push(parent);

      // eslint-disable-next-line prefer-destructuring
      parent = parent.parent;
    }

    return parents;
  }

  /**
   * Returns all of the children elements found within the element.
   * @type ArraySlice
   * @see recursiveChildren
   */
  get children() {
    if (Array.isArray(this.content)) {
      return new ArraySlice(this.content);
    }

    if (this.content instanceof KeyValuePair) {
      const children = new ArraySlice([this.content.key]);

      if (this.content.value) {
        children.push(this.content.value);
      }

      return children;
    }

    if (this.content instanceof Element) {
      return new ArraySlice([this.content]);
    }

    return new ArraySlice();
  }

  /**
  * Returns all of the children elements found within the element recursively.
  * @type ArraySlice
  * @see children
  */
  get recursiveChildren() {
    const children = new ArraySlice();

    this.children.forEach((element) => {
      children.push(element);

      element.recursiveChildren.forEach((child) => {
        children.push(child);
      });
    });

    return children;
  }
}

module.exports = Element;


/***/ }),

/***/ 10392:
/***/ ((module) => {

/**
 * Gets the value at `key` of `object`.
 *
 * @private
 * @param {Object} [object] The object to query.
 * @param {string} key The key of the property to get.
 * @returns {*} Returns the property value.
 */
function getValue(object, key) {
  return object == null ? undefined : object[key];
}

module.exports = getValue;


/***/ }),

/***/ 10426:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apg_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16646);
/* harmony import */ var _path_templating_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(56167);
/* harmony import */ var _callbacks_slash_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(31696);
/* harmony import */ var _callbacks_path_template_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33659);
/* harmony import */ var _callbacks_path_literal_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(88430);
/* harmony import */ var _callbacks_template_expression_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(82966);
/* harmony import */ var _callbacks_template_expression_param_name_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(21926);







const grammar = new _path_templating_mjs__WEBPACK_IMPORTED_MODULE_6__["default"]();
const parse = pathTemplate => {
  const parser = new apg_lite__WEBPACK_IMPORTED_MODULE_0__.Parser();
  parser.ast = new apg_lite__WEBPACK_IMPORTED_MODULE_0__.Ast();
  parser.ast.callbacks['path-template'] = _callbacks_path_template_mjs__WEBPACK_IMPORTED_MODULE_2__["default"];
  parser.ast.callbacks['slash'] = _callbacks_slash_mjs__WEBPACK_IMPORTED_MODULE_1__["default"];
  parser.ast.callbacks['path-literal'] = _callbacks_path_literal_mjs__WEBPACK_IMPORTED_MODULE_3__["default"];
  parser.ast.callbacks['template-expression'] = _callbacks_template_expression_mjs__WEBPACK_IMPORTED_MODULE_4__["default"];
  parser.ast.callbacks['template-expression-param-name'] = _callbacks_template_expression_param_name_mjs__WEBPACK_IMPORTED_MODULE_5__["default"];
  const result = parser.parse(grammar, 'path-template', pathTemplate);
  return {
    result,
    ast: parser.ast
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parse);

/***/ }),

/***/ 10565:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _toString)
/* harmony export */ });
/* harmony import */ var _includes_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83112);
/* harmony import */ var _map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(88267);
/* harmony import */ var _quote_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(79017);
/* harmony import */ var _toISOString_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86894);
/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(82506);
/* harmony import */ var _reject_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(56173);






function _toString(x, seen) {
  var recur = function recur(y) {
    var xs = seen.concat([x]);
    return (0,_includes_js__WEBPACK_IMPORTED_MODULE_0__["default"])(y, xs) ? '<Circular>' : _toString(y, xs);
  };

  //  mapPairs :: (Object, [String]) -> [String]
  var mapPairs = function (obj, keys) {
    return (0,_map_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (k) {
      return (0,_quote_js__WEBPACK_IMPORTED_MODULE_2__["default"])(k) + ': ' + recur(obj[k]);
    }, keys.slice().sort());
  };
  switch (Object.prototype.toString.call(x)) {
    case '[object Arguments]':
      return '(function() { return arguments; }(' + (0,_map_js__WEBPACK_IMPORTED_MODULE_1__["default"])(recur, x).join(', ') + '))';
    case '[object Array]':
      return '[' + (0,_map_js__WEBPACK_IMPORTED_MODULE_1__["default"])(recur, x).concat(mapPairs(x, (0,_reject_js__WEBPACK_IMPORTED_MODULE_3__["default"])(function (k) {
        return /^\d+$/.test(k);
      }, (0,_keys_js__WEBPACK_IMPORTED_MODULE_4__["default"])(x)))).join(', ') + ']';
    case '[object Boolean]':
      return typeof x === 'object' ? 'new Boolean(' + recur(x.valueOf()) + ')' : x.toString();
    case '[object Date]':
      return 'new Date(' + (isNaN(x.valueOf()) ? recur(NaN) : (0,_quote_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_toISOString_js__WEBPACK_IMPORTED_MODULE_5__["default"])(x))) + ')';
    case '[object Map]':
      return 'new Map(' + recur(Array.from(x)) + ')';
    case '[object Null]':
      return 'null';
    case '[object Number]':
      return typeof x === 'object' ? 'new Number(' + recur(x.valueOf()) + ')' : 1 / x === -Infinity ? '-0' : x.toString(10);
    case '[object Set]':
      return 'new Set(' + recur(Array.from(x).sort()) + ')';
    case '[object String]':
      return typeof x === 'object' ? 'new String(' + recur(x.valueOf()) + ')' : (0,_quote_js__WEBPACK_IMPORTED_MODULE_2__["default"])(x);
    case '[object Undefined]':
      return 'undefined';
    default:
      if (typeof x.toString === 'function') {
        var repr = x.toString();
        if (repr !== '[object Object]') {
          return repr;
        }
      }
      return '{' + mapPairs(x, (0,_keys_js__WEBPACK_IMPORTED_MODULE_4__["default"])(x)).join(', ') + '}';
  }
}

/***/ }),

/***/ 10583:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apg_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16646);
/* harmony import */ var _path_templating_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(56167);
/* harmony import */ var _parse_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10426);



/**
 * Implementation of https://datatracker.ietf.org/doc/html/rfc3986#section-6.2.2.2
 */
const significantTypes = ['slash', 'path-literal', 'template-expression'];
const grammar = new _path_templating_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]();
const parser = new apg_lite__WEBPACK_IMPORTED_MODULE_0__.Parser();
const percentEndingNormalizer = pathTemplate => {
  const parseResult = (0,_parse_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(pathTemplate);
  if (!parseResult.result.success) return pathTemplate;
  const parts = [];
  parseResult.ast.translate(parts);
  return parts.reduce((pathTemplateNormalized, [type, value]) => {
    let normalizedValue = value;
    if (type === 'path-literal') {
      normalizedValue = value.replace(/%[0-9a-fA-F]{2}/g, match => {
        try {
          const char = decodeURIComponent(match);
          const {
            success
          } = parser.parse(grammar, 'unreserved', char);
          return success ? char : match;
        } catch {
          return match;
        }
      });
    }
    if (significantTypes.includes(type)) {
      return `${pathTemplateNormalized}${normalizedValue}`;
    }
    return pathTemplateNormalized;
  }, '');
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (percentEndingNormalizer);

/***/ }),

/***/ 10625:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _internal_isFunction_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33893);
/* harmony import */ var _and_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(91021);
/* harmony import */ var _lift_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63519);





/**
 * A function which calls the two provided functions and returns the `&&`
 * of the results.
 * It returns the result of the first function if it is false-y and the result
 * of the second function otherwise. Note that this is short-circuited,
 * meaning that the second function will not be invoked if the first returns a
 * false-y value.
 *
 * In addition to functions, `R.both` also accepts any fantasy-land compatible
 * applicative functor.
 *
 * @func
 * @memberOf R
 * @since v0.12.0
 * @category Logic
 * @sig (*... -> Boolean) -> (*... -> Boolean) -> (*... -> Boolean)
 * @param {Function} f A predicate
 * @param {Function} g Another predicate
 * @return {Function} a function that applies its arguments to `f` and `g` and `&&`s their outputs together.
 * @see R.either, R.allPass, R.and
 * @example
 *
 *      const gt10 = R.gt(R.__, 10)
 *      const lt20 = R.lt(R.__, 20)
 *      const f = R.both(gt10, lt20);
 *      f(15); //=> true
 *      f(30); //=> false
 *
 *      R.both(Maybe.Just(false), Maybe.Just(55)); // => Maybe.Just(false)
 *      R.both([false, false, 'a'], [11]); //=> [false, false, 11]
 */
var both = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function both(f, g) {
  return (0,_internal_isFunction_js__WEBPACK_IMPORTED_MODULE_1__["default"])(f) ? function _both() {
    return f.apply(this, arguments) && g.apply(this, arguments);
  } : (0,_lift_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_and_js__WEBPACK_IMPORTED_MODULE_3__["default"])(f, g);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (both);

/***/ }),

/***/ 10692:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var fast_json_patch__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16111);
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14744);
/* harmony import */ var deepmerge__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deepmerge__WEBPACK_IMPORTED_MODULE_1__);


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  add,
  replace,
  remove,
  merge,
  mergeDeep,
  context,
  getIn,
  applyPatch,
  parentPathMatch,
  flatten,
  fullyNormalizeArray,
  normalizeArray,
  isPromise,
  forEachNew,
  forEachNewPrimitive,
  isJsonPatch,
  isContextPatch,
  isPatch,
  isMutation,
  isAdditiveMutation,
  isGenerator,
  isFunction,
  isObject,
  isError
});
function applyPatch(obj, patch, opts) {
  opts = opts || {};
  patch = {
    ...patch,
    path: patch.path && normalizeJSONPath(patch.path)
  };
  if (patch.op === 'merge') {
    const newValue = getInByJsonPath(obj, patch.path);
    Object.assign(newValue, patch.value);
    fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, [replace(patch.path, newValue)]);
  } else if (patch.op === 'mergeDeep') {
    const currentValue = getInByJsonPath(obj, patch.path);
    const newValue = deepmerge__WEBPACK_IMPORTED_MODULE_1___default()(currentValue, patch.value);
    obj = fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, [replace(patch.path, newValue)]).newDocument;
  } else if (patch.op === 'add' && patch.path === '' && isObject(patch.value)) {
    // { op: 'add', path: '', value: { a: 1, b: 2 }}
    // has no effect: json patch refuses to do anything.
    // so let's break that patch down into a set of patches,
    // one for each key in the intended root value.

    const patches = Object.keys(patch.value).reduce((arr, key) => {
      arr.push({
        op: 'add',
        path: `/${normalizeJSONPath(key)}`,
        value: patch.value[key]
      });
      return arr;
    }, []);
    fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, patches);
  } else if (patch.op === 'replace' && patch.path === '') {
    let {
      value
    } = patch;
    if (opts.allowMetaPatches && patch.meta && isAdditiveMutation(patch) && (Array.isArray(patch.value) || isObject(patch.value))) {
      value = {
        ...value,
        ...patch.meta
      };
    }
    obj = value;
  } else {
    fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, [patch]);

    // Attach metadata to the resulting value.
    if (opts.allowMetaPatches && patch.meta && isAdditiveMutation(patch) && (Array.isArray(patch.value) || isObject(patch.value))) {
      const currentValue = getInByJsonPath(obj, patch.path);
      const newValue = {
        ...currentValue,
        ...patch.meta
      };
      fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.applyPatch(obj, [replace(patch.path, newValue)]);
    }
  }
  return obj;
}
function normalizeJSONPath(path) {
  if (Array.isArray(path)) {
    if (path.length < 1) {
      return '';
    }
    return `/${path.map(item =>
    // eslint-disable-line prefer-template
    (item + '').replace(/~/g, '~0').replace(/\//g, '~1') // eslint-disable-line prefer-template
    ).join('/')}`;
  }
  return path;
}

// =========================
// JSON-Patch Wrappers
// =========================

function add(path, value) {
  return {
    op: 'add',
    path,
    value
  };
}

// function _get(path) {
//   return { op: '_get', path };
// }

function replace(path, value, meta) {
  return {
    op: 'replace',
    path,
    value,
    meta
  };
}
function remove(path) {
  return {
    op: 'remove',
    path
  };
}

// Custom wrappers
function merge(path, value) {
  return {
    type: 'mutation',
    op: 'merge',
    path,
    value
  };
}

// Custom wrappers
function mergeDeep(path, value) {
  return {
    type: 'mutation',
    op: 'mergeDeep',
    path,
    value
  };
}
function context(path, value) {
  return {
    type: 'context',
    path,
    value
  };
}

// =========================
// Iterators
// =========================

function forEachNew(mutations, fn) {
  try {
    return forEachNewPatch(mutations, forEach, fn);
  } catch (e) {
    return e;
  }
}
function forEachNewPrimitive(mutations, fn) {
  try {
    return forEachNewPatch(mutations, forEachPrimitive, fn);
  } catch (e) {
    return e;
  }
}
function forEachNewPatch(mutations, fn, callback) {
  const res = mutations.filter(isAdditiveMutation).map(mutation => fn(mutation.value, callback, mutation.path)) || [];
  const flat = flatten(res);
  const clean = cleanArray(flat);
  return clean;
}
function forEachPrimitive(obj, fn, basePath) {
  basePath = basePath || [];
  if (Array.isArray(obj)) {
    return obj.map((val, key) => forEachPrimitive(val, fn, basePath.concat(key)));
  }
  if (isObject(obj)) {
    return Object.keys(obj).map(key => forEachPrimitive(obj[key], fn, basePath.concat(key)));
  }
  return fn(obj, basePath[basePath.length - 1], basePath);
}
function forEach(obj, fn, basePath) {
  basePath = basePath || [];
  let results = [];
  if (basePath.length > 0) {
    const newResults = fn(obj, basePath[basePath.length - 1], basePath);
    if (newResults) {
      results = results.concat(newResults);
    }
  }
  if (Array.isArray(obj)) {
    const arrayResults = obj.map((val, key) => forEach(val, fn, basePath.concat(key)));
    if (arrayResults) {
      results = results.concat(arrayResults);
    }
  } else if (isObject(obj)) {
    const moreResults = Object.keys(obj).map(key => forEach(obj[key], fn, basePath.concat(key)));
    if (moreResults) {
      results = results.concat(moreResults);
    }
  }
  results = flatten(results);
  return results;
}

// =========================
// Paths
// =========================

function parentPathMatch(path, arr) {
  if (!Array.isArray(arr)) {
    return false;
  }
  for (let i = 0, len = arr.length; i < len; i += 1) {
    if (arr[i] !== path[i]) {
      return false;
    }
  }
  return true;
}
function getIn(obj, path) {
  return path.reduce((val, token) => {
    if (typeof token !== 'undefined' && val) {
      return val[token];
    }
    return val;
  }, obj);
}

// =========================
// Array
// =========================

function fullyNormalizeArray(arr) {
  return cleanArray(flatten(normalizeArray(arr)));
}
function normalizeArray(arr) {
  return Array.isArray(arr) ? arr : [arr];
}
function flatten(arr) {
  return [].concat(...arr.map(val => Array.isArray(val) ? flatten(val) : val));
}
function cleanArray(arr) {
  return arr.filter(elm => typeof elm !== 'undefined');
}

// =========================
// Is-Thing.
// =========================

function isObject(val) {
  return val && typeof val === 'object';
}
function isPromise(val) {
  return isObject(val) && isFunction(val.then);
}
function isFunction(val) {
  return val && typeof val === 'function';
}
function isError(patch) {
  return patch instanceof Error;
}
function isJsonPatch(patch) {
  if (isPatch(patch)) {
    const {
      op
    } = patch;
    return op === 'add' || op === 'remove' || op === 'replace';
  }
  return false;
}
function isGenerator(thing) {
  return Object.prototype.toString.call(thing) === '[object GeneratorFunction]';
}
function isMutation(patch) {
  return isJsonPatch(patch) || isPatch(patch) && patch.type === 'mutation';
}
function isAdditiveMutation(patch) {
  return isMutation(patch) && (patch.op === 'add' || patch.op === 'replace' || patch.op === 'merge' || patch.op === 'mergeDeep');
}
function isContextPatch(patch) {
  return isPatch(patch) && patch.type === 'context';
}
function isPatch(patch) {
  return patch && typeof patch === 'object';
}
function getInByJsonPath(obj, jsonPath) {
  try {
    return fast_json_patch__WEBPACK_IMPORTED_MODULE_0__.getValueByPointer(obj, jsonPath);
  } catch (e) {
    console.error(e); // eslint-disable-line no-console
    return {};
  }
}

/***/ }),

/***/ 10796:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_complement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(10889);
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _all_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(56679);




/**
 * Returns `true` if no elements of the list match the predicate, `false`
 * otherwise.
 *
 * Dispatches to the `all` method of the second argument, if present.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * @func
 * @memberOf R
 * @since v0.12.0
 * @category List
 * @sig (a -> Boolean) -> [a] -> Boolean
 * @param {Function} fn The predicate function.
 * @param {Array} list The array to consider.
 * @return {Boolean} `true` if the predicate is not satisfied by every element, `false` otherwise.
 * @see R.all, R.any
 * @example
 *
 *      const isEven = n => n % 2 === 0;
 *      const isOdd = n => n % 2 !== 0;
 *
 *      R.none(isEven, [1, 3, 5, 7, 9, 11]); //=> true
 *      R.none(isOdd, [1, 3, 5, 7, 8, 11]); //=> false
 */
var none = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function none(fn, input) {
  return (0,_all_js__WEBPACK_IMPORTED_MODULE_1__["default"])((0,_internal_complement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(fn), input);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (none);

/***/ }),

/***/ 10835:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(60020);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(36114);


/**
 * @public
 */
class SpecificationExtensionVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  MemberElement(memberElement) {
    this.element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(memberElement);
    this.element.classes.push('specification-extension');
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SpecificationExtensionVisitor);

/***/ }),

/***/ 10866:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const negate = __webpack_require__(6048);
const ArraySlice = __webpack_require__(92340);

/**
 */
class ObjectSlice extends ArraySlice {
  map(callback, thisArg) {
    return this.elements.map(member => callback.bind(thisArg)(member.value, member.key, member));
  }

  filter(callback, thisArg) {
    return new ObjectSlice(this.elements.filter(member => callback.bind(thisArg)(member.value, member.key, member)));
  }

  reject(callback, thisArg) {
    return this.filter(negate(callback.bind(thisArg)));
  }

  forEach(callback, thisArg) {
    return this.elements.forEach((member, index) => { callback.bind(thisArg)(member.value, member.key, member, index); });
  }

  /**
   * @returns {array}
   */
  keys() {
    return this.map((value, key) => key.toValue());
  }

  /**
   * @returns {array}
   */
  values() {
    return this.map(value => value.toValue());
  }
}

module.exports = ObjectSlice;


/***/ }),

/***/ 10889:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _complement)
/* harmony export */ });
function _complement(f) {
  return function () {
    return !f.apply(this, arguments);
  };
}

/***/ }),

/***/ 11042:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var getBuiltIn = __webpack_require__(63201);
var uncurryThis = __webpack_require__(1907);
var getOwnPropertyNamesModule = __webpack_require__(24443);
var getOwnPropertySymbolsModule = __webpack_require__(87170);
var anObject = __webpack_require__(36624);

var concat = uncurryThis([].concat);

// all object keys, includes non-enumerable and symbols
module.exports = getBuiltIn('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule.f(anObject(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? concat(keys, getOwnPropertySymbols(it)) : keys;
};


/***/ }),

/***/ 11091:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);
var apply = __webpack_require__(76024);
var uncurryThis = __webpack_require__(92361);
var isCallable = __webpack_require__(62250);
var getOwnPropertyDescriptor = (__webpack_require__(13846).f);
var isForced = __webpack_require__(7463);
var path = __webpack_require__(92046);
var bind = __webpack_require__(28311);
var createNonEnumerableProperty = __webpack_require__(61626);
var hasOwn = __webpack_require__(49724);
// add debugging info
__webpack_require__(36128);

var wrapConstructor = function (NativeConstructor) {
  var Wrapper = function (a, b, c) {
    if (this instanceof Wrapper) {
      switch (arguments.length) {
        case 0: return new NativeConstructor();
        case 1: return new NativeConstructor(a);
        case 2: return new NativeConstructor(a, b);
      } return new NativeConstructor(a, b, c);
    } return apply(NativeConstructor, this, arguments);
  };
  Wrapper.prototype = NativeConstructor.prototype;
  return Wrapper;
};

/*
  options.target         - name of the target object
  options.global         - target is the global object
  options.stat           - export as static methods of target
  options.proto          - export as prototype methods of target
  options.real           - real prototype method for the `pure` version
  options.forced         - export even if the native feature is available
  options.bind           - bind methods to the target, required for the `pure` version
  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
  options.sham           - add a flag to not completely full polyfills
  options.enumerable     - export as enumerable property
  options.dontCallGetSet - prevent calling a getter on target
  options.name           - the .name of the function if it does not match the key
*/
module.exports = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var PROTO = options.proto;

  var nativeSource = GLOBAL ? globalThis : STATIC ? globalThis[TARGET] : globalThis[TARGET] && globalThis[TARGET].prototype;

  var target = GLOBAL ? path : path[TARGET] || createNonEnumerableProperty(path, TARGET, {})[TARGET];
  var targetPrototype = target.prototype;

  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

  for (key in source) {
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contains in native
    USE_NATIVE = !FORCED && nativeSource && hasOwn(nativeSource, key);

    targetProperty = target[key];

    if (USE_NATIVE) if (options.dontCallGetSet) {
      descriptor = getOwnPropertyDescriptor(nativeSource, key);
      nativeProperty = descriptor && descriptor.value;
    } else nativeProperty = nativeSource[key];

    // export native or implementation
    sourceProperty = (USE_NATIVE && nativeProperty) ? nativeProperty : source[key];

    if (!FORCED && !PROTO && typeof targetProperty == typeof sourceProperty) continue;

    // bind methods to global for calling from export context
    if (options.bind && USE_NATIVE) resultProperty = bind(sourceProperty, globalThis);
    // wrap global constructors for prevent changes in this version
    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty);
    // make static versions for prototype methods
    else if (PROTO && isCallable(sourceProperty)) resultProperty = uncurryThis(sourceProperty);
    // default case
    else resultProperty = sourceProperty;

    // add a flag to not completely full polyfills
    if (options.sham || (sourceProperty && sourceProperty.sham) || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty(resultProperty, 'sham', true);
    }

    createNonEnumerableProperty(target, key, resultProperty);

    if (PROTO) {
      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
      if (!hasOwn(path, VIRTUAL_PROTOTYPE)) {
        createNonEnumerableProperty(path, VIRTUAL_PROTOTYPE, {});
      }
      // export virtual prototype methods
      createNonEnumerableProperty(path[VIRTUAL_PROTOTYPE], key, sourceProperty);
      // export real prototype methods
      if (options.real && targetPrototype && (FORCED || !targetPrototype[key])) {
        createNonEnumerableProperty(targetPrototype, key, sourceProperty);
      }
    }
  }
};


/***/ }),

/***/ 11182:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ pipe)
/* harmony export */ });
/* harmony import */ var _internal_arity_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27660);
/* harmony import */ var _internal_pipe_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75393);
/* harmony import */ var _reduce_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5920);
/* harmony import */ var _tail_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(84596);





/**
 * Performs left-to-right function composition. The first argument may have
 * any arity; the remaining arguments must be unary.
 *
 * In some libraries this function is named `sequence`.
 *
 * **Note:** The result of pipe is not automatically curried.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Function
 * @sig (((a, b, ..., n) -> o), (o -> p), ..., (x -> y), (y -> z)) -> ((a, b, ..., n) -> z)
 * @param {...Function} functions
 * @return {Function}
 * @see R.compose
 * @example
 *
 *      const f = R.pipe(Math.pow, R.negate, R.inc);
 *
 *      f(3, 4); // -(3^4) + 1
 * @symb R.pipe(f, g, h)(a, b) = h(g(f(a, b)))
 * @symb R.pipe(f, g, h)(a)(b) = h(g(f(a)))(b)
 */
function pipe() {
  if (arguments.length === 0) {
    throw new Error('pipe requires at least one argument');
  }
  return (0,_internal_arity_js__WEBPACK_IMPORTED_MODULE_0__["default"])(arguments[0].length, (0,_reduce_js__WEBPACK_IMPORTED_MODULE_1__["default"])(_internal_pipe_js__WEBPACK_IMPORTED_MODULE_2__["default"], arguments[0], (0,_tail_js__WEBPACK_IMPORTED_MODULE_3__["default"])(arguments)));
}

/***/ }),

/***/ 11290:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16401);


/**
 * @public
 */
class JsonSchema$anchorError extends _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JsonSchema$anchorError);

/***/ }),

/***/ 11470:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);
var toIntegerOrInfinity = __webpack_require__(65482);
var toString = __webpack_require__(90160);
var requireObjectCoercible = __webpack_require__(74239);

var charAt = uncurryThis(''.charAt);
var charCodeAt = uncurryThis(''.charCodeAt);
var stringSlice = uncurryThis(''.slice);

var createMethod = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = toString(requireObjectCoercible($this));
    var position = toIntegerOrInfinity(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = charCodeAt(S, position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING
          ? charAt(S, position)
          : first
        : CONVERT_TO_STRING
          ? stringSlice(S, position, position + 2)
          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

module.exports = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod(true)
};


/***/ }),

/***/ 11546:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77551);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27121);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(23438);
/* harmony import */ var _namespace_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(84857);



const createToolbox = () => {
  const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.createNamespace)(_namespace_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]);
  const predicates = {
    ..._predicates_mjs__WEBPACK_IMPORTED_MODULE_2__,
    isStringElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement
  };
  return {
    predicates,
    namespace
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createToolbox);

/***/ }),

/***/ 11808:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91176);
/* harmony import */ var _base64_browser_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4745);


const base64urlEncoder = input => {
  return (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.toBase64url)((0,_base64_browser_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(input));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (base64urlEncoder);

/***/ }),

/***/ 11892:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * A function that always returns `true`. Any passed in parameters are ignored.
 *
 * @func
 * @memberOf R
 * @since v0.9.0
 * @category Function
 * @sig * -> Boolean
 * @param {*}
 * @return {Boolean}
 * @see R.F
 * @example
 *
 *      R.T(); //=> true
 */
var T = function () {
  return true;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (T);

/***/ }),

/***/ 11900:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isTypedArray)
/* harmony export */ });
/**
 * Tests whether or not an object is a typed array.
 *
 * @private
 * @param {*} val The object to test.
 * @return {Boolean} `true` if `val` is a typed array, `false` otherwise.
 * @example
 *
 *      _isTypedArray(new Uint8Array([])); //=> true
 *      _isTypedArray(new Float32Array([])); //=> true
 *      _isTypedArray([]); //=> false
 *      _isTypedArray(null); //=> false
 *      _isTypedArray({}); //=> false
 */
function _isTypedArray(val) {
  var type = Object.prototype.toString.call(val);
  return type === '[object Uint8ClampedArray]' || type === '[object Int8Array]' || type === '[object Uint8Array]' || type === '[object Int16Array]' || type === '[object Uint16Array]' || type === '[object Int32Array]' || type === '[object Uint32Array]' || type === '[object Float32Array]' || type === '[object Float64Array]' || type === '[object BigInt64Array]' || type === '[object BigUint64Array]';
}

/***/ }),

/***/ 11925:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseContactVisitor: () => (/* binding */ BaseContactVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14963);


/**
 * @public
 */
const BaseContactVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.Contact.$visitor;
/**
 * @public
 */
class ContactVisitor extends BaseContactVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContactVisitor);

/***/ }),

/***/ 12201:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(77259);

const trimParseResult = elementPath => elementPath.slice(2);

/**
 * Transforms ApiDOM traversal meta information into
 * SwaggerClient compatible path.
 *
 * SwaggerClient path is a list of JSON Pointer tokens.
 */
const toPath = elementPath => {
  const elementPathSanitized = trimParseResult(elementPath);
  return elementPathSanitized.reduce((path, element, index) => {
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isMemberElement)(element)) {
      const token = String((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__["default"])(element.key));
      path.push(token);
    } else if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isArrayElement)(elementPathSanitized[index - 2])) {
      const token = elementPathSanitized[index - 2].content.indexOf(element);
      path.push(token);
    }
    return path;
  }, []);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toPath);

/***/ }),

/***/ 12207:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ResolverError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97618);

/**
 * @public
 */
class UnmatchedResolverError extends _ResolverError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UnmatchedResolverError);

/***/ }),

/***/ 12236:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JSONReferenceElement: () => (/* reexport safe */ _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   JSONSchemaElement: () => (/* reexport safe */ _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   LinkDescriptionElement: () => (/* reexport safe */ _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   MediaElement: () => (/* reexport safe */ _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__["default"])
/* harmony export */ });
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(40215);
/* harmony import */ var _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(76145);
/* harmony import */ var _elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(66852);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(85830);
/* harmony import */ var _index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37221);




 // register refractors specific to element types
_elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'JSONSchema', '$visitor']);
_elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_2__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'JSONReference', '$visitor']);
_elements_Media_mjs__WEBPACK_IMPORTED_MODULE_3__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'Media', '$visitor']);
_elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_4__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'LinkDescription', '$visitor']);


/***/ }),

/***/ 12242:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(10316);

/**
 * @class BooleanElement
 *
 * @param {boolean} content
 * @param meta
 * @param attributes
 */
module.exports = class BooleanElement extends Element {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'boolean';
  }

  primitive() {
    return 'boolean';
  }
};


/***/ }),

/***/ 12302:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(77259);
/* harmony import */ var _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(73287);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9748);







/**
 * @public
 */
/**
 * @public
 */
class EncodingVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Encoding']);
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every Header with media type metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isObjectElement)(this.element.headers)) {
      this.element.headers.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_6__.isHeaderElement)
      // @ts-ignore
      .forEach((headerElement, key) => {
        headerElement.setMetaProperty('header-name', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__["default"])(key));
      });
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EncodingVisitor);

/***/ }),

/***/ 12315:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(10625);
/* harmony import */ var _isNumber_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6367);



// eslint-disable-next-line no-restricted-globals
var isFinitePonyfill = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(_isNumber_js__WEBPACK_IMPORTED_MODULE_1__["default"], isFinite);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isFinitePonyfill);

/***/ }),

/***/ 12357:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class OAuthFlow extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'oAuthFlow';
  }
  get authorizationUrl() {
    return this.get('authorizationUrl');
  }
  set authorizationUrl(authorizationUrl) {
    this.set('authorizationUrl', authorizationUrl);
  }
  get tokenUrl() {
    return this.get('tokenUrl');
  }
  set tokenUrl(tokenUrl) {
    this.set('tokenUrl', tokenUrl);
  }
  get refreshUrl() {
    return this.get('refreshUrl');
  }
  set refreshUrl(refreshUrl) {
    this.set('refreshUrl', refreshUrl);
  }
  get scopes() {
    return this.get('scopes');
  }
  set scopes(scopes) {
    this.set('scopes', scopes);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlow);

/***/ }),

/***/ 12358:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(79619);
/* harmony import */ var _internal_dropLastWhile_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27007);
/* harmony import */ var _internal_xdropLastWhile_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(31451);





/**
 * Returns a new list excluding all the tailing elements of a given list which
 * satisfy the supplied predicate function. It passes each value from the right
 * to the supplied predicate function, skipping elements until the predicate
 * function returns a `falsy` value. The predicate function is applied to one argument:
 * *(value)*.
 *
 * Acts as a transducer if a transformer is given in list position.
 *
 * @func
 * @memberOf R
 * @since v0.16.0
 * @category List
 * @sig (a -> Boolean) -> [a] -> [a]
 * @sig (a -> Boolean) -> String -> String
 * @param {Function} predicate The function to be called on each element
 * @param {Array} xs The collection to iterate over.
 * @return {Array} A new array without any trailing elements that return `falsy` values from the `predicate`.
 * @see R.takeLastWhile, R.addIndex, R.drop, R.dropWhile
 * @example
 *
 *      const lteThree = x => x <= 3;
 *
 *      R.dropLastWhile(lteThree, [1, 2, 3, 4, 3, 2, 1]); //=> [1, 2, 3, 4]
 *
 *      R.dropLastWhile(x => x !== 'd' , 'Ramda'); //=> 'Ramd'
 */
var dropLastWhile = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])( /*#__PURE__*/(0,_internal_dispatchable_js__WEBPACK_IMPORTED_MODULE_1__["default"])([], _internal_xdropLastWhile_js__WEBPACK_IMPORTED_MODULE_2__["default"], _internal_dropLastWhile_js__WEBPACK_IMPORTED_MODULE_3__["default"]));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dropLastWhile);

/***/ }),

/***/ 12560:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

__webpack_require__(99363);
var DOMIterables = __webpack_require__(19287);
var globalThis = __webpack_require__(45951);
var setToStringTag = __webpack_require__(14840);
var Iterators = __webpack_require__(93742);

for (var COLLECTION_NAME in DOMIterables) {
  setToStringTag(globalThis[COLLECTION_NAME], COLLECTION_NAME);
  Iterators[COLLECTION_NAME] = Iterators.Array;
}


/***/ }),

/***/ 12569:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(77259);
/* harmony import */ var _elements_nces_ComponentsResponses_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(48532);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48018);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39633);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9748);







/**
 * @public
 */
/**
 * @public
 */
class ResponsesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsResponses_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Response'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every ReferenceElement with metadata about their referencing type
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'response');
    });

    // decorate every ResponseElement with metadata about their status code
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isResponseElement).forEach((value, key) => {
      value.setMetaProperty('http-status-code', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__["default"])(key));
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ResponsesVisitor);

/***/ }),

/***/ 12635:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseServerVariableVisitor: () => (/* binding */ BaseServerVariableVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(74768);


/**
 * @public
 */
const BaseServerVariableVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.ServerVariable.$visitor;
/**
 * @public
 */
class ServerVariableVisitor extends BaseServerVariableVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServerVariableVisitor);

/***/ }),

/***/ 12651:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isKeyable = __webpack_require__(74218);

/**
 * Gets the data for `map`.
 *
 * @private
 * @param {Object} map The map to query.
 * @param {string} key The reference key.
 * @returns {*} Returns the map data.
 */
function getMapData(map, key) {
  var data = map.__data__;
  return isKeyable(key)
    ? data[typeof key == 'string' ? 'string' : 'hash']
    : data.map;
}

module.exports = getMapData;


/***/ }),

/***/ 12670:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46455);
/* harmony import */ var _PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20586);


/**
 * @public
 */
/**
 * @public
 */
class MapVisitor extends _PatternedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.fieldPatternPredicate = ramda_adjunct__WEBPACK_IMPORTED_MODULE_1__["default"];
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MapVisitor);

/***/ }),

/***/ 12738:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @public
 */

/**
 * @public
 */
class BundleStrategy {
  name;
  constructor({
    name
  }) {
    this.name = name;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BundleStrategy);

/***/ }),

/***/ 12749:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(81042);

/** Used for built-in method references. */
var objectProto = Object.prototype;

/** Used to check objects for own properties. */
var hasOwnProperty = objectProto.hasOwnProperty;

/**
 * Checks if a hash value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Hash
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function hashHas(key) {
  var data = this.__data__;
  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
}

module.exports = hashHas;


/***/ }),

/***/ 12757:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ normalize)
/* harmony export */ });
/* harmony import */ var _helpers_op_id_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37896);

function normalize(parsedSpec) {
  const {
    spec
  } = parsedSpec;
  const {
    paths
  } = spec;
  const map = {};
  if (!paths || spec.$$normalized) {
    return parsedSpec;
  }

  // eslint-disable-next-line no-restricted-syntax, guard-for-in
  for (const pathName in paths) {
    const path = paths[pathName];
    if (path == null || !['object', 'function'].includes(typeof path)) {
      continue; // eslint-disable-line no-continue
    }
    const pathParameters = path.parameters;

    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const method in path) {
      const operation = path[method];
      if (operation == null || !['object', 'function'].includes(typeof operation)) {
        continue; // eslint-disable-line no-continue
      }
      const oid = (0,_helpers_op_id_js__WEBPACK_IMPORTED_MODULE_0__["default"])(operation, pathName, method);
      if (oid) {
        if (map[oid]) {
          map[oid].push(operation);
        } else {
          map[oid] = [operation];
        }
        const opList = map[oid];
        if (opList.length > 1) {
          opList.forEach((o, i) => {
            // eslint-disable-next-line no-underscore-dangle
            o.__originalOperationId = o.__originalOperationId || o.operationId;
            o.operationId = `${oid}${i + 1}`;
          });
        } else if (typeof operation.operationId !== 'undefined') {
          // Ensure we always add the normalized operation ID if one already exists
          // ( potentially different, given that we normalize our IDs)
          // ... _back_ to the spec. Otherwise, they might not line up
          const obj = opList[0];
          // eslint-disable-next-line no-underscore-dangle
          obj.__originalOperationId = obj.__originalOperationId || operation.operationId;
          obj.operationId = oid;
        }
      }
      if (method !== 'parameters') {
        // Add inherited consumes, produces, parameters, securities
        const inheritsList = [];
        const toBeInherit = {};

        // Global-levels
        // eslint-disable-next-line no-restricted-syntax
        for (const key in spec) {
          if (key === 'produces' || key === 'consumes' || key === 'security') {
            toBeInherit[key] = spec[key];
            inheritsList.push(toBeInherit);
          }
        }

        // Path-levels
        if (pathParameters) {
          toBeInherit.parameters = pathParameters;
          inheritsList.push(toBeInherit);
        }
        if (inheritsList.length) {
          // eslint-disable-next-line no-restricted-syntax
          for (const inherits of inheritsList) {
            // eslint-disable-next-line no-restricted-syntax
            for (const inheritName in inherits) {
              if (!operation[inheritName]) {
                operation[inheritName] = inherits[inheritName];
              } else if (inheritName === 'parameters') {
                // eslint-disable-next-line no-restricted-syntax
                for (const param of inherits[inheritName]) {
                  const exists = operation[inheritName].some(opParam => opParam.name && opParam.name === param.name || opParam.$ref && opParam.$ref === param.$ref || opParam.$$ref && opParam.$$ref === param.$$ref || opParam === param);
                  if (!exists) {
                    operation[inheritName].push(param);
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  spec.$$normalized = true;
  return parsedSpec;
}

/***/ }),

/***/ 12787:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20382);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1908);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(92405);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(71676);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20835);



class YAMLParser extends _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_1__["default"] {
  constructor(options = {}) {
    super({
      name: 'yaml-1-2-swagger-client',
      mediaTypes: ['text/yaml', 'application/yaml'],
      ...options
    });
  }
  async canParse(file) {
    const hasSupportedFileExtension = this.fileExtensions.length === 0 ? true : this.fileExtensions.includes(file.extension);
    const hasSupportedMediaType = this.mediaTypes.includes(file.mediaType);
    if (!hasSupportedFileExtension) return false;
    if (hasSupportedMediaType) return true;
    if (!hasSupportedMediaType) {
      try {
        js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(file.toString(), {
          schema: js_yaml__WEBPACK_IMPORTED_MODULE_0__.JSON_SCHEMA
        });
        return true;
      } catch (error) {
        return false;
      }
    }
    return false;
  }
  async parse(file) {
    if (this.sourceMap) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"]("yaml-1-2-swagger-client parser plugin doesn't support sourceMaps option");
    }
    const parseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ParseResultElement();
    const source = file.toString();
    try {
      const pojo = js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(source, {
        schema: js_yaml__WEBPACK_IMPORTED_MODULE_0__.JSON_SCHEMA
      });
      if (this.allowEmpty && typeof pojo === 'undefined') {
        return parseResultElement;
      }
      const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__["default"])(pojo);
      element.classes.push('result');
      parseResultElement.push(element);
      return parseResultElement;
    } catch (error) {
      throw new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_2__["default"](`Error parsing "${file.uri}"`, {
        cause: error
      });
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (YAMLParser);

/***/ }),

/***/ 12923:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27121);
/* harmony import */ var _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(76145);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(57319);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(62287);






/**
 * @public
 */
/**
 * @public
 */
class JSONReferenceVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_JSONReference_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'JSONReference']);
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // mark this JSONReferenceElement with reference metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(this.element.$ref)) {
      this.element.classes.push('reference-element');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONReferenceVisitor);

/***/ }),

/***/ 13124:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_nces_PathItemServers_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80552);
/* harmony import */ var _ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(17198);


/**
 * @public
 */
class ServersVisitor extends _ServersVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_PathItemServers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServersVisitor);

/***/ }),

/***/ 13163:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _elements_nces_ResponseLinks_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(72180);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48018);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39633);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9748);






/**
 * @public
 */
/**
 * @public
 */
class LinksVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ResponseLinks_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Link'];
  }
  ObjectElement(objectElement) {
    const result = _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      referenceElement.setMetaProperty('referenced-element', 'link');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinksVisitor);

/***/ }),

/***/ 13332:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48018);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39633);
/* harmony import */ var _elements_nces_ComponentsPathItems_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19982);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45259);




/**
 * @public
 */
/**
 * @public
 */
class PathItemsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"], _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_ComponentsPathItems_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'PathItem'];
  }
  ObjectElement(objectElement) {
    const result = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      // @ts-ignore
      referenceElement.setMetaProperty('referenced-element', 'pathItem');
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathItemsVisitor);

/***/ }),

/***/ 13380:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(37911);


/**
 * Checks if input value is an empty `String`.
 *
 * @func isEmptyString
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.4.0|v2.4.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotEmptyString|isNotEmptyString}
 * @example
 *
 * RA.isEmptyString(''); // => true
 * RA.isEmptyString('42'); // => false
 * RA.isEmptyString(new String('42')); // => false
 * RA.isEmptyString(new String('')); // => false
 * RA.isEmptyString([42]); // => false
 * RA.isEmptyString({}); // => false
 * RA.isEmptyString(null); // => false
 * RA.isEmptyString(undefined); // => false
 * RA.isEmptyString(42); // => false
 */
var isEmptyString = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])('');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isEmptyString);

/***/ }),

/***/ 13430:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _arrayReduce)
/* harmony export */ });
function _arrayReduce(reducer, acc, list) {
  var index = 0;
  var length = list.length;
  while (index < length) {
    acc = reducer(acc, list[index]);
    index += 1;
  }
  return acc;
}

/***/ }),

/***/ 13433:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1908);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(60020);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15413);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62287);




/**
 * @public
 */

/**
 * @public
 */
class OneOfVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_1__["default"], _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_2__["default"], _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-oneOf');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const element = this.toRefractedElement(['document', 'objects', 'JSONSchema'], item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OneOfVisitor);

/***/ }),

/***/ 13471:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _arrayReduce_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(13430);
/* harmony import */ var _createReduce_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(76659);


function _iterableReduce(reducer, acc, iter) {
  var step = iter.next();
  while (!step.done) {
    acc = reducer(acc, step.value);
    step = iter.next();
  }
  return acc;
}
function _methodReduce(reducer, acc, obj, methodName) {
  return obj[methodName](reducer, acc);
}
var _reduce = /*#__PURE__*/(0,_createReduce_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_arrayReduce_js__WEBPACK_IMPORTED_MODULE_1__["default"], _methodReduce, _iterableReduce);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_reduce);

/***/ }),

/***/ 13526:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1413);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(57319);
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42361);



/**
 * @public
 */
class JSONSchemaVisitor extends _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }

  // eslint-disable-next-line class-methods-use-this
  get defaultDialectIdentifier() {
    return 'https://json-schema.org/draft/2019-09/schema';
  }
  ObjectElement(objectElement) {
    this.handleDialectIdentifier(objectElement);
    this.handleSchemaIdentifier(objectElement);

    // for further processing consider this Schema Element as parent for all embedded Schema Elements
    this.parent = this.element;
    const result = _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_2__["default"].prototype.ObjectElement.call(this, objectElement);

    // mark this SchemaElement with reference metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement)(this.element.$ref)) {
      this.element.classes.push('reference-element');
      this.element.setMetaProperty('referenced-element', 'schema');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONSchemaVisitor);

/***/ }),

/***/ 13663:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2086);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22072);
/* harmony import */ var _visitors_open_api_3_1_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(16440);
/* harmony import */ var _visitors_open_api_3_1_info_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(89637);
/* harmony import */ var _visitors_open_api_3_1_contact_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11925);
/* harmony import */ var _visitors_open_api_3_1_license_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(844);
/* harmony import */ var _visitors_open_api_3_1_link_index_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(98701);
/* harmony import */ var _visitors_open_api_3_1_JsonSchemaDialectVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(52799);
/* harmony import */ var _visitors_open_api_3_1_server_index_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(46292);
/* harmony import */ var _visitors_open_api_3_1_server_variable_index_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(12635);
/* harmony import */ var _visitors_open_api_3_1_media_type_index_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(5052);
/* harmony import */ var _visitors_open_api_3_1_security_requirement_index_mjs__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(66849);
/* harmony import */ var _visitors_open_api_3_1_components_index_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(61961);
/* harmony import */ var _visitors_open_api_3_1_tag_index_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(2981);
/* harmony import */ var _visitors_open_api_3_1_reference_index_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(38654);
/* harmony import */ var _visitors_open_api_3_1_parameter_index_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(81076);
/* harmony import */ var _visitors_open_api_3_1_header_index_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(15418);
/* harmony import */ var _visitors_open_api_3_1_schema_index_mjs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(54004);
/* harmony import */ var _visitors_open_api_3_1_schema_$defsVisitor_mjs__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(92042);
/* harmony import */ var _visitors_open_api_3_1_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(32196);
/* harmony import */ var _visitors_open_api_3_1_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(87501);
/* harmony import */ var _visitors_open_api_3_1_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(38919);
/* harmony import */ var _visitors_open_api_3_1_schema_DependentSchemasVisitor_mjs__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(31439);
/* harmony import */ var _visitors_open_api_3_1_schema_PrefixItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(16710);
/* harmony import */ var _visitors_open_api_3_1_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(99299);
/* harmony import */ var _visitors_open_api_3_1_schema_PatternPropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(14629);
/* harmony import */ var _visitors_open_api_3_1_distriminator_index_mjs__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(40816);
/* harmony import */ var _visitors_open_api_3_1_xml_index_mjs__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(43718);
/* harmony import */ var _visitors_open_api_3_1_components_SchemasVisitor_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(21513);
/* harmony import */ var _visitors_open_api_3_1_components_PathItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(13332);
/* harmony import */ var _visitors_open_api_3_1_example_index_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(99727);
/* harmony import */ var _visitors_open_api_3_1_external_documentation_index_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(31857);
/* harmony import */ var _visitors_open_api_3_1_encoding_index_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(42474);
/* harmony import */ var _visitors_open_api_3_1_paths_index_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(9489);
/* harmony import */ var _visitors_open_api_3_1_request_body_index_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(30053);
/* harmony import */ var _visitors_open_api_3_1_callback_index_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(91948);
/* harmony import */ var _visitors_open_api_3_1_response_index_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(90876);
/* harmony import */ var _visitors_open_api_3_1_responses_index_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(43517);
/* harmony import */ var _visitors_open_api_3_1_operation_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(2966);
/* harmony import */ var _visitors_open_api_3_1_path_item_index_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(70658);
/* harmony import */ var _visitors_open_api_3_1_security_scheme_index_mjs__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(53179);
/* harmony import */ var _visitors_open_api_3_1_oauth_flows_index_mjs__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(19468);
/* harmony import */ var _visitors_open_api_3_1_oauth_flow_index_mjs__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(7479);
/* harmony import */ var _visitors_open_api_3_1_WebhooksVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26500);












































const {
  JSONSchema: JSONSchemaVisitor,
  LinkDescription: LinkDescriptionVisitor
} = _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects;

/**
 * Specification object allows us to have complete control over visitors
 * when traversing the ApiDOM.
 * Specification also allows us to create amended refractors from
 * existing ones by manipulating it.
 *
 * Note: Specification object allows to use absolute internal JSON pointers.
 * @public
 */
const specification = {
  visitors: {
    value: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.value,
    document: {
      objects: {
        OpenApi: {
          $visitor: _visitors_open_api_3_1_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"],
          fixedFields: {
            openapi: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.OpenApi.fixedFields.openapi,
            info: {
              $ref: '#/visitors/document/objects/Info'
            },
            jsonSchemaDialect: _visitors_open_api_3_1_JsonSchemaDialectVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"],
            servers: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.OpenApi.fixedFields.servers,
            paths: {
              $ref: '#/visitors/document/objects/Paths'
            },
            webhooks: _visitors_open_api_3_1_WebhooksVisitor_mjs__WEBPACK_IMPORTED_MODULE_4__["default"],
            components: {
              $ref: '#/visitors/document/objects/Components'
            },
            security: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.OpenApi.fixedFields.security,
            tags: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.OpenApi.fixedFields.tags,
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            }
          }
        },
        Info: {
          $visitor: _visitors_open_api_3_1_info_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"],
          fixedFields: {
            title: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Info.fixedFields.title,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Info.fixedFields.description,
            summary: {
              $ref: '#/visitors/value'
            },
            termsOfService: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Info.fixedFields.termsOfService,
            contact: {
              $ref: '#/visitors/document/objects/Contact'
            },
            license: {
              $ref: '#/visitors/document/objects/License'
            },
            version: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Info.fixedFields.version
          }
        },
        Contact: {
          $visitor: _visitors_open_api_3_1_contact_index_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
          fixedFields: {
            name: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Contact.fixedFields.name,
            url: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Contact.fixedFields.url,
            email: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Contact.fixedFields.email
          }
        },
        License: {
          $visitor: _visitors_open_api_3_1_license_index_mjs__WEBPACK_IMPORTED_MODULE_7__["default"],
          fixedFields: {
            name: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.License.fixedFields.name,
            identifier: {
              $ref: '#/visitors/value'
            },
            url: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.License.fixedFields.url
          }
        },
        Server: {
          $visitor: _visitors_open_api_3_1_server_index_mjs__WEBPACK_IMPORTED_MODULE_8__["default"],
          fixedFields: {
            url: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Server.fixedFields.url,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Server.fixedFields.description,
            variables: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Server.fixedFields.variables
          }
        },
        ServerVariable: {
          $visitor: _visitors_open_api_3_1_server_variable_index_mjs__WEBPACK_IMPORTED_MODULE_9__["default"],
          fixedFields: {
            enum: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.ServerVariable.fixedFields.enum,
            default: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.ServerVariable.fixedFields.default,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.ServerVariable.fixedFields.description
          }
        },
        Components: {
          $visitor: _visitors_open_api_3_1_components_index_mjs__WEBPACK_IMPORTED_MODULE_10__["default"],
          fixedFields: {
            schemas: _visitors_open_api_3_1_components_SchemasVisitor_mjs__WEBPACK_IMPORTED_MODULE_11__["default"],
            responses: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Components.fixedFields.responses,
            parameters: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Components.fixedFields.parameters,
            examples: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Components.fixedFields.examples,
            requestBodies: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Components.fixedFields.requestBodies,
            headers: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Components.fixedFields.headers,
            securitySchemes: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Components.fixedFields.securitySchemes,
            links: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Components.fixedFields.links,
            callbacks: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Components.fixedFields.callbacks,
            pathItems: _visitors_open_api_3_1_components_PathItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_12__["default"]
          }
        },
        Paths: {
          $visitor: _visitors_open_api_3_1_paths_index_mjs__WEBPACK_IMPORTED_MODULE_13__["default"]
        },
        PathItem: {
          $visitor: _visitors_open_api_3_1_path_item_index_mjs__WEBPACK_IMPORTED_MODULE_14__["default"],
          fixedFields: {
            $ref: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.PathItem.fixedFields.$ref,
            summary: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.PathItem.fixedFields.summary,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.PathItem.fixedFields.description,
            get: {
              $ref: '#/visitors/document/objects/Operation'
            },
            put: {
              $ref: '#/visitors/document/objects/Operation'
            },
            post: {
              $ref: '#/visitors/document/objects/Operation'
            },
            delete: {
              $ref: '#/visitors/document/objects/Operation'
            },
            options: {
              $ref: '#/visitors/document/objects/Operation'
            },
            head: {
              $ref: '#/visitors/document/objects/Operation'
            },
            patch: {
              $ref: '#/visitors/document/objects/Operation'
            },
            trace: {
              $ref: '#/visitors/document/objects/Operation'
            },
            servers: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.PathItem.fixedFields.servers,
            parameters: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.PathItem.fixedFields.parameters
          }
        },
        Operation: {
          $visitor: _visitors_open_api_3_1_operation_index_mjs__WEBPACK_IMPORTED_MODULE_15__["default"],
          fixedFields: {
            tags: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.tags,
            summary: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.summary,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.description,
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            },
            operationId: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.operationId,
            parameters: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.parameters,
            requestBody: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.requestBody,
            responses: {
              $ref: '#/visitors/document/objects/Responses'
            },
            callbacks: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.callbacks,
            deprecated: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.deprecated,
            security: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.security,
            servers: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Operation.fixedFields.servers
          }
        },
        ExternalDocumentation: {
          $visitor: _visitors_open_api_3_1_external_documentation_index_mjs__WEBPACK_IMPORTED_MODULE_16__["default"],
          fixedFields: {
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.ExternalDocumentation.fixedFields.description,
            url: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.ExternalDocumentation.fixedFields.url
          }
        },
        Parameter: {
          $visitor: _visitors_open_api_3_1_parameter_index_mjs__WEBPACK_IMPORTED_MODULE_17__["default"],
          fixedFields: {
            name: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.name,
            in: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.in,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.description,
            required: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.required,
            deprecated: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.deprecated,
            allowEmptyValue: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.allowEmptyValue,
            style: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.style,
            explode: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.explode,
            allowReserved: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.allowReserved,
            schema: {
              $ref: '#/visitors/document/objects/Schema'
            },
            example: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.example,
            examples: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.examples,
            content: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Parameter.fixedFields.content
          }
        },
        RequestBody: {
          $visitor: _visitors_open_api_3_1_request_body_index_mjs__WEBPACK_IMPORTED_MODULE_18__["default"],
          fixedFields: {
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.RequestBody.fixedFields.description,
            content: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.RequestBody.fixedFields.content,
            required: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.RequestBody.fixedFields.required
          }
        },
        MediaType: {
          $visitor: _visitors_open_api_3_1_media_type_index_mjs__WEBPACK_IMPORTED_MODULE_19__["default"],
          fixedFields: {
            schema: {
              $ref: '#/visitors/document/objects/Schema'
            },
            example: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.MediaType.fixedFields.example,
            examples: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.MediaType.fixedFields.examples,
            encoding: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.MediaType.fixedFields.encoding
          }
        },
        Encoding: {
          $visitor: _visitors_open_api_3_1_encoding_index_mjs__WEBPACK_IMPORTED_MODULE_20__["default"],
          fixedFields: {
            contentType: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Encoding.fixedFields.contentType,
            headers: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Encoding.fixedFields.headers,
            style: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Encoding.fixedFields.style,
            explode: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Encoding.fixedFields.explode,
            allowReserved: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Encoding.fixedFields.allowReserved
          }
        },
        Responses: {
          $visitor: _visitors_open_api_3_1_responses_index_mjs__WEBPACK_IMPORTED_MODULE_21__["default"],
          fixedFields: {
            default: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Responses.fixedFields.default
          }
        },
        Response: {
          $visitor: _visitors_open_api_3_1_response_index_mjs__WEBPACK_IMPORTED_MODULE_22__["default"],
          fixedFields: {
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Response.fixedFields.description,
            headers: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Response.fixedFields.headers,
            content: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Response.fixedFields.content,
            links: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Response.fixedFields.links
          }
        },
        Callback: {
          $visitor: _visitors_open_api_3_1_callback_index_mjs__WEBPACK_IMPORTED_MODULE_23__["default"]
        },
        Example: {
          $visitor: _visitors_open_api_3_1_example_index_mjs__WEBPACK_IMPORTED_MODULE_24__["default"],
          fixedFields: {
            summary: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Example.fixedFields.summary,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Example.fixedFields.description,
            value: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Example.fixedFields.value,
            externalValue: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Example.fixedFields.externalValue
          }
        },
        Link: {
          $visitor: _visitors_open_api_3_1_link_index_mjs__WEBPACK_IMPORTED_MODULE_25__["default"],
          fixedFields: {
            operationRef: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Link.fixedFields.operationRef,
            operationId: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Link.fixedFields.operationId,
            parameters: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Link.fixedFields.parameters,
            requestBody: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Link.fixedFields.requestBody,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Link.fixedFields.description,
            server: {
              $ref: '#/visitors/document/objects/Server'
            }
          }
        },
        Header: {
          $visitor: _visitors_open_api_3_1_header_index_mjs__WEBPACK_IMPORTED_MODULE_26__["default"],
          fixedFields: {
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.description,
            required: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.required,
            deprecated: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.deprecated,
            allowEmptyValue: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.allowEmptyValue,
            style: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.style,
            explode: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.explode,
            allowReserved: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.allowReserved,
            schema: {
              $ref: '#/visitors/document/objects/Schema'
            },
            example: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.example,
            examples: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.examples,
            content: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Header.fixedFields.content
          }
        },
        Tag: {
          $visitor: _visitors_open_api_3_1_tag_index_mjs__WEBPACK_IMPORTED_MODULE_27__["default"],
          fixedFields: {
            name: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Tag.fixedFields.name,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Tag.fixedFields.description,
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            }
          }
        },
        Reference: {
          $visitor: _visitors_open_api_3_1_reference_index_mjs__WEBPACK_IMPORTED_MODULE_28__["default"],
          fixedFields: {
            $ref: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Reference.fixedFields.$ref,
            summary: {
              $ref: '#/visitors/value'
            },
            description: {
              $ref: '#/visitors/value'
            }
          }
        },
        JSONSchema: {
          $ref: '#/visitors/document/objects/Schema'
        },
        LinkDescription: {
          ...LinkDescriptionVisitor
        },
        Schema: {
          $visitor: _visitors_open_api_3_1_schema_index_mjs__WEBPACK_IMPORTED_MODULE_29__["default"],
          fixedFields: {
            ...JSONSchemaVisitor.fixedFields,
            // core vocabulary
            $defs: _visitors_open_api_3_1_schema_$defsVisitor_mjs__WEBPACK_IMPORTED_MODULE_30__["default"],
            // applicator vocabulary
            allOf: _visitors_open_api_3_1_schema_AllOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_31__["default"],
            anyOf: _visitors_open_api_3_1_schema_AnyOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_32__["default"],
            oneOf: _visitors_open_api_3_1_schema_OneOfVisitor_mjs__WEBPACK_IMPORTED_MODULE_33__["default"],
            not: {
              $ref: '#/visitors/document/objects/Schema'
            },
            if: {
              $ref: '#/visitors/document/objects/Schema'
            },
            then: {
              $ref: '#/visitors/document/objects/Schema'
            },
            else: {
              $ref: '#/visitors/document/objects/Schema'
            },
            dependentSchemas: _visitors_open_api_3_1_schema_DependentSchemasVisitor_mjs__WEBPACK_IMPORTED_MODULE_34__["default"],
            prefixItems: _visitors_open_api_3_1_schema_PrefixItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_35__["default"],
            items: {
              $ref: '#/visitors/document/objects/Schema'
            },
            contains: {
              $ref: '#/visitors/document/objects/Schema'
            },
            properties: _visitors_open_api_3_1_schema_PropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_36__["default"],
            patternProperties: _visitors_open_api_3_1_schema_PatternPropertiesVisitor_mjs__WEBPACK_IMPORTED_MODULE_37__["default"],
            additionalProperties: {
              $ref: '#/visitors/document/objects/Schema'
            },
            propertyNames: {
              $ref: '#/visitors/document/objects/Schema'
            },
            // unevaluated Locations vocabulary
            unevaluatedItems: {
              $ref: '#/visitors/document/objects/Schema'
            },
            unevaluatedProperties: {
              $ref: '#/visitors/document/objects/Schema'
            },
            // validation vocabulary
            // contents of String-Encoded Data vocabulary
            contentSchema: {
              $ref: '#/visitors/document/objects/Schema'
            },
            // OAS base vocabulary
            discriminator: {
              $ref: '#/visitors/document/objects/Discriminator'
            },
            xml: {
              $ref: '#/visitors/document/objects/XML'
            },
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            },
            example: {
              $ref: '#/visitors/value'
            }
          }
        },
        Discriminator: {
          $visitor: _visitors_open_api_3_1_distriminator_index_mjs__WEBPACK_IMPORTED_MODULE_38__["default"],
          fixedFields: {
            propertyName: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Discriminator.fixedFields.propertyName,
            mapping: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.Discriminator.fixedFields.mapping
          }
        },
        XML: {
          $visitor: _visitors_open_api_3_1_xml_index_mjs__WEBPACK_IMPORTED_MODULE_39__["default"],
          fixedFields: {
            name: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.XML.fixedFields.name,
            namespace: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.XML.fixedFields.namespace,
            prefix: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.XML.fixedFields.prefix,
            attribute: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.XML.fixedFields.attribute,
            wrapped: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.XML.fixedFields.wrapped
          }
        },
        SecurityScheme: {
          $visitor: _visitors_open_api_3_1_security_scheme_index_mjs__WEBPACK_IMPORTED_MODULE_40__["default"],
          fixedFields: {
            type: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.SecurityScheme.fixedFields.type,
            description: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.SecurityScheme.fixedFields.description,
            name: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.SecurityScheme.fixedFields.name,
            in: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.SecurityScheme.fixedFields.in,
            scheme: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.SecurityScheme.fixedFields.scheme,
            bearerFormat: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.SecurityScheme.fixedFields.bearerFormat,
            flows: {
              $ref: '#/visitors/document/objects/OAuthFlows'
            },
            openIdConnectUrl: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.SecurityScheme.fixedFields.openIdConnectUrl
          }
        },
        OAuthFlows: {
          $visitor: _visitors_open_api_3_1_oauth_flows_index_mjs__WEBPACK_IMPORTED_MODULE_41__["default"],
          fixedFields: {
            implicit: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            password: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            clientCredentials: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            authorizationCode: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            }
          }
        },
        OAuthFlow: {
          $visitor: _visitors_open_api_3_1_oauth_flow_index_mjs__WEBPACK_IMPORTED_MODULE_42__["default"],
          fixedFields: {
            authorizationUrl: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.OAuthFlow.fixedFields.authorizationUrl,
            tokenUrl: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.OAuthFlow.fixedFields.tokenUrl,
            refreshUrl: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.OAuthFlow.fixedFields.refreshUrl,
            scopes: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.objects.OAuthFlow.fixedFields.scopes
          }
        },
        SecurityRequirement: {
          $visitor: _visitors_open_api_3_1_security_requirement_index_mjs__WEBPACK_IMPORTED_MODULE_43__["default"]
        }
      },
      extension: {
        $visitor: _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].visitors.document.extension.$visitor
      }
    }
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (specification);

/***/ }),

/***/ 13764:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43319);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77551);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(56479);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(83561);
/* harmony import */ var _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27596);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(90374);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(8302);
/* harmony import */ var _visitors_root_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41512);
/* eslint-disable camelcase */





const visitAsync = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.visit[Symbol.for('nodejs.util.promisify.custom')];
class OpenAPI3_1SwaggerClientDereferenceStrategy extends _swagger_api_apidom_reference_dereference_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__["default"] {
  allowMetaPatches;
  parameterMacro;
  modelPropertyMacro;
  mode;
  ancestors;
  constructor({
    allowMetaPatches = false,
    parameterMacro = null,
    modelPropertyMacro = null,
    mode = 'non-strict',
    ancestors = [],
    ...rest
  } = {}) {
    super({
      ...rest
    });
    this.name = 'openapi-3-1-swagger-client';
    this.allowMetaPatches = allowMetaPatches;
    this.parameterMacro = parameterMacro;
    this.modelPropertyMacro = modelPropertyMacro;
    this.mode = mode;
    this.ancestors = [...ancestors];
  }
  async dereference(file, options) {
    const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.createNamespace)(_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_4__["default"]);
    const immutableRefSet = options.dereference.refSet ?? new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_5__["default"]();
    const mutableRefsSet = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_5__["default"]();
    let refSet = immutableRefSet;
    let reference;
    if (!immutableRefSet.has(file.uri)) {
      reference = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__["default"]({
        uri: file.uri,
        value: file.parseResult
      });
      immutableRefSet.add(reference);
    } else {
      // pre-computed refSet was provided as configuration option
      reference = immutableRefSet.find(ref => ref.uri === file.uri);
    }

    /**
     * Clone refSet due the dereferencing process being mutable.
     * We don't want to mutate the original refSet and the references.
     */
    if (options.dereference.immutable) {
      immutableRefSet.refs.map(ref => new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__["default"]({
        ...ref,
        value: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__.cloneDeep)(ref.value)
      })).forEach(ref => mutableRefsSet.add(ref));
      reference = mutableRefsSet.find(ref => ref.uri === file.uri);
      refSet = mutableRefsSet;
    }
    const rootVisitor = new _visitors_root_js__WEBPACK_IMPORTED_MODULE_0__["default"]({
      reference,
      namespace,
      options,
      allowMetaPatches: this.allowMetaPatches,
      ancestors: this.ancestors,
      modelPropertyMacro: this.modelPropertyMacro,
      mode: this.mode,
      parameterMacro: this.parameterMacro
    });
    const dereferencedElement = await visitAsync(refSet.rootRef.value, rootVisitor, {
      keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__.keyMap,
      nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_8__.getNodeType
    });

    /**
     * If immutable option is set, replay refs from the refSet.
     */
    if (options.dereference.immutable) {
      mutableRefsSet.refs.filter(ref => ref.uri.startsWith('immutable://')).map(ref => new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_6__["default"]({
        ...ref,
        uri: ref.uri.replace(/^immutable:\/\//, '')
      })).forEach(ref => immutableRefSet.add(ref));
    }

    /**
     * Release all memory if this refSet was not provided as an configuration option.
     * If provided as configuration option, then provider is responsible for cleanup.
     */
    if (options.dereference.refSet === null) {
      immutableRefSet.clean();
    }
    mutableRefsSet.clean();
    return dereferencedElement;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenAPI3_1SwaggerClientDereferenceStrategy);
/* eslint-enable camelcase */

/***/ }),

/***/ 13846:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var DESCRIPTORS = __webpack_require__(39447);
var call = __webpack_require__(13930);
var propertyIsEnumerableModule = __webpack_require__(22574);
var createPropertyDescriptor = __webpack_require__(75817);
var toIndexedObject = __webpack_require__(27374);
var toPropertyKey = __webpack_require__(70470);
var hasOwn = __webpack_require__(49724);
var IE8_DOM_DEFINE = __webpack_require__(73648);

// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
exports.f = DESCRIPTORS ? $getOwnPropertyDescriptor : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject(O);
  P = toPropertyKey(P);
  if (IE8_DOM_DEFINE) try {
    return $getOwnPropertyDescriptor(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn(O, P)) return createPropertyDescriptor(!call(propertyIsEnumerableModule.f, O, P), O[P]);
};


/***/ }),

/***/ 13930:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var NATIVE_BIND = __webpack_require__(41505);

var call = Function.prototype.call;

module.exports = NATIVE_BIND ? call.bind(call) : function () {
  return call.apply(call, arguments);
};


/***/ }),

/***/ 14248:
/***/ ((module) => {

/**
 * A specialized version of `_.some` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} predicate The function invoked per iteration.
 * @returns {boolean} Returns `true` if any element passes the predicate check,
 *  else `false`.
 */
function arraySome(array, predicate) {
  var index = -1,
      length = array == null ? 0 : array.length;

  while (++index < length) {
    if (predicate(array[index], index, array)) {
      return true;
    }
  }
  return false;
}

module.exports = arraySome;


/***/ }),

/***/ 14441:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5051);

/**
 * @public
 */
class OperationRefVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OperationRefVisitor);

/***/ }),

/***/ 14528:
/***/ ((module) => {

/**
 * Appends the elements of `values` to `array`.
 *
 * @private
 * @param {Array} array The array to modify.
 * @param {Array} values The values to append.
 * @returns {Array} Returns `array`.
 */
function arrayPush(array, values) {
  var index = -1,
      length = values.length,
      offset = array.length;

  while (++index < length) {
    array[offset + index] = values[index];
  }
  return array;
}

module.exports = arrayPush;


/***/ }),

/***/ 14540:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const Element = __webpack_require__(10316);

/**
 * @class RefElement
 *
 * @param content
 * @param meta
 * @param attributes
 *
 * @extends Element
 */
module.exports = class RefElement extends Element {
  constructor(content, meta, attributes) {
    super(content || [], meta, attributes);
    this.element = 'ref';

    if (!this.path) {
      this.path = 'element';
    }
  }

  /**
   * Path of referenced element to transclude instead of element itself.
   * @type StringElement
   * @default element
   */
  get path() {
    return this.attributes.get('path');
  }

  set path(newValue) {
    this.attributes.set('path', newValue);
  }
};


/***/ }),

/***/ 14615:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OpenAPIMediaTypes: () => (/* binding */ OpenAPIMediaTypes),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43022);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42114);



/**
 * @public
 */

/**
 * @public
 */
class OpenAPIMediaTypes extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"] {
  filterByFormat(format = 'generic') {
    const effectiveFormat = format === 'generic' ? 'openapi;version' : format;
    return this.filter(mediaType => mediaType.includes(effectiveFormat));
  }
  findBy(version = '3.1.0', format = 'generic') {
    const search = format === 'generic' ? `vnd.oai.openapi;version=${version}` : `vnd.oai.openapi+${format};version=${version}`;
    const found = this.find(mediaType => mediaType.includes(search));
    return found || this.unknownMediaType;
  }
  latest(format = 'generic') {
    return (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(this.filterByFormat(format));
  }
}

/**
 * @public
 */
const mediaTypes = new OpenAPIMediaTypes('application/vnd.oai.openapi;version=3.1.0', 'application/vnd.oai.openapi+json;version=3.1.0', 'application/vnd.oai.openapi+yaml;version=3.1.0');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mediaTypes);

/***/ }),

/***/ 14629:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92351);

/**
 * @public
 */
class PatternPropertiesVisitor extends _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.passingOptionsNames.push('parent');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternPropertiesVisitor);

/***/ }),

/***/ 14744:
/***/ ((module) => {

"use strict";


var isMergeableObject = function isMergeableObject(value) {
	return isNonNullObject(value)
		&& !isSpecial(value)
};

function isNonNullObject(value) {
	return !!value && typeof value === 'object'
}

function isSpecial(value) {
	var stringValue = Object.prototype.toString.call(value);

	return stringValue === '[object RegExp]'
		|| stringValue === '[object Date]'
		|| isReactElement(value)
}

// see https://github.com/facebook/react/blob/b5ac963fb791d1298e7f396236383bc955f916c1/src/isomorphic/classic/element/ReactElement.js#L21-L25
var canUseSymbol = typeof Symbol === 'function' && Symbol.for;
var REACT_ELEMENT_TYPE = canUseSymbol ? Symbol.for('react.element') : 0xeac7;

function isReactElement(value) {
	return value.$$typeof === REACT_ELEMENT_TYPE
}

function emptyTarget(val) {
	return Array.isArray(val) ? [] : {}
}

function cloneUnlessOtherwiseSpecified(value, options) {
	return (options.clone !== false && options.isMergeableObject(value))
		? deepmerge(emptyTarget(value), value, options)
		: value
}

function defaultArrayMerge(target, source, options) {
	return target.concat(source).map(function(element) {
		return cloneUnlessOtherwiseSpecified(element, options)
	})
}

function getMergeFunction(key, options) {
	if (!options.customMerge) {
		return deepmerge
	}
	var customMerge = options.customMerge(key);
	return typeof customMerge === 'function' ? customMerge : deepmerge
}

function getEnumerableOwnPropertySymbols(target) {
	return Object.getOwnPropertySymbols
		? Object.getOwnPropertySymbols(target).filter(function(symbol) {
			return Object.propertyIsEnumerable.call(target, symbol)
		})
		: []
}

function getKeys(target) {
	return Object.keys(target).concat(getEnumerableOwnPropertySymbols(target))
}

function propertyIsOnObject(object, property) {
	try {
		return property in object
	} catch(_) {
		return false
	}
}

// Protects from prototype poisoning and unexpected merging up the prototype chain.
function propertyIsUnsafe(target, key) {
	return propertyIsOnObject(target, key) // Properties are safe to merge if they don't exist in the target yet,
		&& !(Object.hasOwnProperty.call(target, key) // unsafe if they exist up the prototype chain,
			&& Object.propertyIsEnumerable.call(target, key)) // and also unsafe if they're nonenumerable.
}

function mergeObject(target, source, options) {
	var destination = {};
	if (options.isMergeableObject(target)) {
		getKeys(target).forEach(function(key) {
			destination[key] = cloneUnlessOtherwiseSpecified(target[key], options);
		});
	}
	getKeys(source).forEach(function(key) {
		if (propertyIsUnsafe(target, key)) {
			return
		}

		if (propertyIsOnObject(target, key) && options.isMergeableObject(source[key])) {
			destination[key] = getMergeFunction(key, options)(target[key], source[key], options);
		} else {
			destination[key] = cloneUnlessOtherwiseSpecified(source[key], options);
		}
	});
	return destination
}

function deepmerge(target, source, options) {
	options = options || {};
	options.arrayMerge = options.arrayMerge || defaultArrayMerge;
	options.isMergeableObject = options.isMergeableObject || isMergeableObject;
	// cloneUnlessOtherwiseSpecified is added to `options` so that custom arrayMerge()
	// implementations can use it. The caller may not replace it.
	options.cloneUnlessOtherwiseSpecified = cloneUnlessOtherwiseSpecified;

	var sourceIsArray = Array.isArray(source);
	var targetIsArray = Array.isArray(target);
	var sourceAndTargetTypesMatch = sourceIsArray === targetIsArray;

	if (!sourceAndTargetTypesMatch) {
		return cloneUnlessOtherwiseSpecified(source, options)
	} else if (sourceIsArray) {
		return options.arrayMerge(target, source, options)
	} else {
		return mergeObject(target, source, options)
	}
}

deepmerge.all = function deepmergeAll(array, options) {
	if (!Array.isArray(array)) {
		throw new Error('first argument should be an array')
	}

	return array.reduce(function(prev, next) {
		return deepmerge(prev, next, options)
	}, {})
};

var deepmerge_1 = deepmerge;

module.exports = deepmerge_1;


/***/ }),

/***/ 14840:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var TO_STRING_TAG_SUPPORT = __webpack_require__(52623);
var defineProperty = (__webpack_require__(74284).f);
var createNonEnumerableProperty = __webpack_require__(61626);
var hasOwn = __webpack_require__(49724);
var toString = __webpack_require__(54878);
var wellKnownSymbol = __webpack_require__(76264);

var TO_STRING_TAG = wellKnownSymbol('toStringTag');

module.exports = function (it, TAG, STATIC, SET_METHOD) {
  var target = STATIC ? it : it && it.prototype;
  if (target) {
    if (!hasOwn(target, TO_STRING_TAG)) {
      defineProperty(target, TO_STRING_TAG, { configurable: true, value: TAG });
    }
    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
      createNonEnumerableProperty(target, 'toString', toString);
    }
  }
};


/***/ }),

/***/ 14963:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class Contact extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.ContactElement {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Contact);

/***/ }),

/***/ 15086:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JSONSchemaElement: () => (/* reexport safe */ _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   LinkDescriptionElement: () => (/* reexport safe */ _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__["default"])
/* harmony export */ });
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25789);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88172);
/* harmony import */ var _index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18359);


 // register refractors specific to element types
_elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'JSONSchema', '$visitor']);
_elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'LinkDescription', '$visitor']);


/***/ }),

/***/ 15413:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @public
 */

/**
 * @public
 */
class ParentSchemaAwareVisitor {
  parent;
  constructor({
    parent
  }) {
    this.parent = parent;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParentSchemaAwareVisitor);

/***/ }),

/***/ 15418:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseHeaderVisitor: () => (/* binding */ BaseHeaderVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(83674);


/**
 * @public
 */
const BaseHeaderVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.Header.$visitor;
/**
 * @public
 */
class HeaderVisitor extends BaseHeaderVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderVisitor);

/***/ }),

/***/ 15593:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var _visitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43319);


/**
 * Finds all elements matching the predicate.
 * @public
 */
const filter = (predicate, element) => {
  const visitor = new _visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.PredicateVisitor({
    predicate
  });
  (0,_visitor_mjs__WEBPACK_IMPORTED_MODULE_1__.visit)(element, visitor);
  return new minim__WEBPACK_IMPORTED_MODULE_0__.ArraySlice(visitor.result);
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (filter);

/***/ }),

/***/ 15890:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class ComponentsHeaders extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-headers';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsHeaders.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsHeaders);

/***/ }),

/***/ 15972:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var hasOwn = __webpack_require__(49724);
var isCallable = __webpack_require__(62250);
var toObject = __webpack_require__(39298);
var sharedKey = __webpack_require__(92522);
var CORRECT_PROTOTYPE_GETTER = __webpack_require__(57382);

var IE_PROTO = sharedKey('IE_PROTO');
var $Object = Object;
var ObjectPrototype = $Object.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es/no-object-getprototypeof -- safe
module.exports = CORRECT_PROTOTYPE_GETTER ? $Object.getPrototypeOf : function (O) {
  var object = toObject(O);
  if (hasOwn(object, IE_PROTO)) return object[IE_PROTO];
  var constructor = object.constructor;
  if (isCallable(constructor) && object instanceof constructor) {
    return constructor.prototype;
  } return object instanceof $Object ? ObjectPrototype : null;
};


/***/ }),

/***/ 16111:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JsonPatchError: () => (/* reexport safe */ _module_helpers_mjs__WEBPACK_IMPORTED_MODULE_2__.PatchError),
/* harmony export */   _areEquals: () => (/* reexport safe */ _module_core_mjs__WEBPACK_IMPORTED_MODULE_0__._areEquals),
/* harmony export */   applyOperation: () => (/* reexport safe */ _module_core_mjs__WEBPACK_IMPORTED_MODULE_0__.applyOperation),
/* harmony export */   applyPatch: () => (/* reexport safe */ _module_core_mjs__WEBPACK_IMPORTED_MODULE_0__.applyPatch),
/* harmony export */   applyReducer: () => (/* reexport safe */ _module_core_mjs__WEBPACK_IMPORTED_MODULE_0__.applyReducer),
/* harmony export */   compare: () => (/* reexport safe */ _module_duplex_mjs__WEBPACK_IMPORTED_MODULE_1__.compare),
/* harmony export */   deepClone: () => (/* reexport safe */ _module_helpers_mjs__WEBPACK_IMPORTED_MODULE_2__._deepClone),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   escapePathComponent: () => (/* reexport safe */ _module_helpers_mjs__WEBPACK_IMPORTED_MODULE_2__.escapePathComponent),
/* harmony export */   generate: () => (/* reexport safe */ _module_duplex_mjs__WEBPACK_IMPORTED_MODULE_1__.generate),
/* harmony export */   getValueByPointer: () => (/* reexport safe */ _module_core_mjs__WEBPACK_IMPORTED_MODULE_0__.getValueByPointer),
/* harmony export */   observe: () => (/* reexport safe */ _module_duplex_mjs__WEBPACK_IMPORTED_MODULE_1__.observe),
/* harmony export */   unescapePathComponent: () => (/* reexport safe */ _module_helpers_mjs__WEBPACK_IMPORTED_MODULE_2__.unescapePathComponent),
/* harmony export */   unobserve: () => (/* reexport safe */ _module_duplex_mjs__WEBPACK_IMPORTED_MODULE_1__.unobserve),
/* harmony export */   validate: () => (/* reexport safe */ _module_core_mjs__WEBPACK_IMPORTED_MODULE_0__.validate),
/* harmony export */   validator: () => (/* reexport safe */ _module_core_mjs__WEBPACK_IMPORTED_MODULE_0__.validator)
/* harmony export */ });
/* harmony import */ var _module_core_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61405);
/* harmony import */ var _module_duplex_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6294);
/* harmony import */ var _module_helpers_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27607);





/**
 * Default export for backwards compat
 */





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Object.assign({}, _module_core_mjs__WEBPACK_IMPORTED_MODULE_0__, _module_duplex_mjs__WEBPACK_IMPORTED_MODULE_1__, {
    JsonPatchError: _module_helpers_mjs__WEBPACK_IMPORTED_MODULE_2__.PatchError,
    deepClone: _module_helpers_mjs__WEBPACK_IMPORTED_MODULE_2__._deepClone,
    escapePathComponent: _module_helpers_mjs__WEBPACK_IMPORTED_MODULE_2__.escapePathComponent,
    unescapePathComponent: _module_helpers_mjs__WEBPACK_IMPORTED_MODULE_2__.unescapePathComponent
}));

/***/ }),

/***/ 16254:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   encodeServerVariable: () => (/* binding */ encodeServerVariable)
/* harmony export */ });
/* harmony import */ var _parse_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(39790);

const isEncoded = serverVariableValue => {
  try {
    return typeof serverVariableValue === 'string' && decodeURIComponent(serverVariableValue) !== serverVariableValue;
  } catch {
    return false;
  }
};
const encodeServerVariable = serverVariableValue => {
  if (isEncoded(serverVariableValue)) {
    return serverVariableValue;
  }
  return encodeURIComponent(serverVariableValue).replace(/%5B/g, '[').replace(/%5D/g, ']');
};
const significantTypes = ['literals', 'server-variable-name'];
const substitute = (serverURLTemplate, serverVariables, options = {}) => {
  const defaultOptions = {
    encoder: encodeServerVariable
  };
  const mergedOptions = {
    ...defaultOptions,
    ...options
  };
  const parseResult = (0,_parse_index_mjs__WEBPACK_IMPORTED_MODULE_0__["default"])(serverURLTemplate);
  if (!parseResult.result.success) return serverURLTemplate;
  const parts = [];
  parseResult.ast.translate(parts);
  const substitutedParts = parts.filter(([type]) => significantTypes.includes(type)).map(([type, value]) => {
    if (type === 'server-variable-name') {
      return Object.hasOwn(serverVariables, value) ? mergedOptions.encoder(serverVariables[value], value) : `{${value}}`;
    }
    return value;
  });
  return substitutedParts.join('');
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (substitute);

/***/ }),

/***/ 16307:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);

/**
 * @public
 */
class Operation extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'operation';
  }
  get tags() {
    return this.get('tags');
  }
  set tags(tags) {
    this.set('tags', tags);
  }
  get summary() {
    return this.get('summary');
  }
  set summary(description) {
    this.set('summary', description);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  set externalDocs(externalDocs) {
    this.set('externalDocs', externalDocs);
  }
  get externalDocs() {
    return this.get('externalDocs');
  }
  get operationId() {
    return this.get('operationId');
  }
  set operationId(operationId) {
    this.set('operationId', operationId);
  }
  get parameters() {
    return this.get('parameters');
  }
  set parameters(parameters) {
    this.set('parameters', parameters);
  }
  get requestBody() {
    return this.get('requestBody');
  }
  set requestBody(requestBody) {
    this.set('requestBody', requestBody);
  }
  get responses() {
    return this.get('responses');
  }
  set responses(responses) {
    this.set('responses', responses);
  }
  get callbacks() {
    return this.get('callbacks');
  }
  set callbacks(callbacks) {
    this.set('callbacks', callbacks);
  }
  get deprecated() {
    if (this.hasKey('deprecated')) {
      return this.get('deprecated');
    }
    return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.BooleanElement(false);
  }
  set deprecated(deprecated) {
    this.set('deprecated', deprecated);
  }
  get security() {
    return this.get('security');
  }
  set security(security) {
    this.set('security', security);
  }
  get servers() {
    return this.get('severs');
  }
  set servers(servers) {
    this.set('servers', servers);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Operation);

/***/ }),

/***/ 16401:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ApiDOMAggregateError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(41592);

/**
 * @public
 */
class ApiDOMError extends Error {
  static [Symbol.hasInstance](instance) {
    // we want to ApiDOMAggregateError to act as if ApiDOMError was its superclass
    return super[Symbol.hasInstance](instance) || Function.prototype[Symbol.hasInstance].call(_ApiDOMAggregateError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"], instance);
  }
  constructor(message, options) {
    super(message, options);
    this.name = this.constructor.name;
    if (typeof message === 'string') {
      this.message = message;
    }
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(message).stack;
    }

    /**
     * This needs to stay here until our minimum supported version of Node.js is >= 16.9.0.
     * Node.js is >= 16.9.0 supports error causes natively.
     */
    if (options != null && typeof options === 'object' && Object.hasOwn(options, 'cause') && !('cause' in this)) {
      const {
        cause
      } = options;
      this.cause = cause;
      if (cause instanceof Error && 'stack' in cause) {
        this.stack = `${this.stack}\nCAUSE: ${cause.stack}`;
      }
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ApiDOMError);

/***/ }),

/***/ 16440:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _elements_OpenApi3_1_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6308);




/**
 * @public
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
/**
 * @public
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
class OpenApi3_1Visitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"], _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_OpenApi3_1_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'OpenApi']);
    this.canSupportSpecificationExtensions = true;
    this.openApiSemanticElement = this.element;
  }
  ObjectElement(objectElement) {
    this.openApiGenericElement = objectElement;
    return _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenApi3_1Visitor);

/***/ }),

/***/ 16566:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1908);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(60020);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15413);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62287);




/**
 * @public
 */

/**
 * @public
 */
class AllOfVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_1__["default"], _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_2__["default"], _swagger_api_apidom_ns_json_schema_draft_7__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-allOf');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const element = this.toRefractedElement(['document', 'objects', 'JSONSchema'], item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AllOfVisitor);

/***/ }),

/***/ 16646:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Ast: () => (/* binding */ Ast),
/* harmony export */   Parser: () => (/* binding */ Parser),
/* harmony export */   Stats: () => (/* binding */ Stats),
/* harmony export */   Trace: () => (/* binding */ Trace),
/* harmony export */   identifiers: () => (/* binding */ identifiers),
/* harmony export */   utilities: () => (/* binding */ utilities)
/* harmony export */ });
/*  *************************************************************************************
 *   copyright: Copyright (c) 2023 Lowell D. Thomas, all rights reserved
 *     license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
 *
 *    Redistribution and use in source and binary forms, with or without
 *    modification, are permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this
 *       list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice,
 *       this list of conditions and the following disclaimer in the documentation
 *       and/or other materials provided with the distribution.
 *
 *    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 *    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *    DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 *    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *   ********************************************************************************* */


const Parser = function fnparser() {
  const id = identifiers;
  const utils = utilities;
  const p = this;
  const thisFileName = 'parser.js: Parser(): ';
  const systemData = function systemData() {
    this.state = id.ACTIVE;
    this.phraseLength = 0;
    this.refresh = () => {
      this.state = id.ACTIVE;
      this.phraseLength = 0;
    };
  };
  p.ast = undefined;
  p.stats = undefined;
  p.trace = undefined;
  p.callbacks = [];
  let lookAhead = 0;
  let treeDepth = 0;
  let maxTreeDepth = 0;
  let nodeHits = 0;
  let maxMatched = 0;
  let rules = undefined;
  let udts = undefined;
  let opcodes = undefined;
  let chars = undefined;
  let sysData = new systemData();
  let ruleCallbacks = undefined;
  let udtCallbacks = undefined;
  let userData = undefined;
  const clear = () => {
    lookAhead = 0;
    treeDepth = 0;
    maxTreeDepth = 0;
    nodeHits = 0;
    maxMatched = 0;
    rules = undefined;
    udts = undefined;
    opcodes = undefined;
    chars = undefined;
    sysData.refresh();
    ruleCallbacks = undefined;
    udtCallbacks = undefined;
    userData = undefined;
  };

  const initializeCallbacks = () => {
    const functionName = `${thisFileName}initializeCallbacks(): `;
    let i;
    ruleCallbacks = [];
    udtCallbacks = [];
    for (i = 0; i < rules.length; i += 1) {
      ruleCallbacks[i] = undefined;
    }
    for (i = 0; i < udts.length; i += 1) {
      udtCallbacks[i] = undefined;
    }
    let func;
    const list = [];
    for (i = 0; i < rules.length; i += 1) {
      list.push(rules[i].lower);
    }
    for (i = 0; i < udts.length; i += 1) {
      list.push(udts[i].lower);
    }
    for (const index in p.callbacks) {
      if (p.callbacks.hasOwnProperty(index)) {
        i = list.indexOf(index.toLowerCase());
        if (i < 0) {
          throw new Error(`${functionName}syntax callback '${index}' not a rule or udt name`);
        }
        func = p.callbacks[index] ? p.callbacks[index] : undefined;
        if (typeof func === 'function' || func === undefined) {
          if (i < rules.length) {
            ruleCallbacks[i] = func;
          } else {
            udtCallbacks[i - rules.length] = func;
          }
        } else {
          throw new Error(`${functionName}syntax callback[${index}] must be function reference or falsy)`);
        }
      }
    }
  };

  p.parse = (grammar, startName, inputString, callbackData) => {
    const functionName = `${thisFileName}parse(): `;
    clear();
    chars = utils.stringToChars(inputString);
    rules = grammar.rules;
    udts = grammar.udts;
    const lower = startName.toLowerCase();
    let startIndex = undefined;
    for (const i in rules) {
      if (rules.hasOwnProperty(i)) {
        if (lower === rules[i].lower) {
          startIndex = rules[i].index;
          break;
        }
      }
    }
    if (startIndex === undefined) {
      throw new Error(`${functionName}start rule name '${startRule}' not recognized`);
    }
    initializeCallbacks();
    if (p.trace) {
      p.trace.init(rules, udts, chars);
    }
    if (p.stats) {
      p.stats.init(rules, udts);
    }
    if (p.ast) {
      p.ast.init(rules, udts, chars);
    }
    userData = callbackData;
    /* create a dummy opcode for the start rule */
    opcodes = [
      {
        type: id.RNM,
        index: startIndex,
      },
    ];
    /* execute the start rule */
    opExecute(0, 0);
    opcodes = undefined;
    /* test and return the sysData */
    let success = false;
    switch (sysData.state) {
      case id.ACTIVE:
        throw new Error(`${functionName}final state should never be 'ACTIVE'`);
      case id.NOMATCH:
        success = false;
        break;
      case id.EMPTY:
      case id.MATCH:
        if (sysData.phraseLength === chars.length) {
          success = true;
        } else {
          success = false;
        }
        break;
      default:
        throw new Error('unrecognized state');
    }
    return {
      success,
      state: sysData.state,
      stateName: id.idName(sysData.state),
      length: chars.length,
      matched: sysData.phraseLength,
      maxMatched,
      maxTreeDepth,
      nodeHits,
    };
  };
  // The `ALT` operator.<br>
  // Executes its child nodes, from left to right, until it finds a match.
  // Fails if *all* of its child nodes fail.
  const opALT = (opIndex, phraseIndex) => {
    const op = opcodes[opIndex];
    for (let i = 0; i < op.children.length; i += 1) {
      opExecute(op.children[i], phraseIndex);
      if (sysData.state !== id.NOMATCH) {
        break;
      }
    }
  };
  // The `CAT` operator.<br>
  // Executes all of its child nodes, from left to right,
  // concatenating the matched phrases.
  // Fails if *any* child nodes fail.
  const opCAT = (opIndex, phraseIndex) => {
    let success;
    let astLength;
    let catCharIndex;
    let catPhrase;
    const op = opcodes[opIndex];
    if (p.ast) {
      astLength = p.ast.getLength();
    }
    success = true;
    catCharIndex = phraseIndex;
    catPhrase = 0;
    for (let i = 0; i < op.children.length; i += 1) {
      opExecute(op.children[i], catCharIndex);
      if (sysData.state === id.NOMATCH) {
        success = false;
        break;
      } else {
        catCharIndex += sysData.phraseLength;
        catPhrase += sysData.phraseLength;
      }
    }
    if (success) {
      sysData.state = catPhrase === 0 ? id.EMPTY : id.MATCH;
      sysData.phraseLength = catPhrase;
    } else {
      sysData.state = id.NOMATCH;
      sysData.phraseLength = 0;
      if (p.ast) {
        p.ast.setLength(astLength);
      }
    }
  };
  // The `REP` operator.<br>
  // Repeatedly executes its single child node,
  // concatenating each of the matched phrases found.
  // The number of repetitions executed and its final sysData depends
  // on its `min` & `max` repetition values.
  const opREP = (opIndex, phraseIndex) => {
    let astLength;
    let repCharIndex;
    let repPhrase;
    let repCount;
    const op = opcodes[opIndex];
    if (op.max === 0) {
      // this is an empty-string acceptor
      // deprecated: use the TLS empty string operator, "", instead
      sysData.state = id.EMPTY;
      sysData.phraseLength = 0;
      return;
    }
    repCharIndex = phraseIndex;
    repPhrase = 0;
    repCount = 0;
    if (p.ast) {
      astLength = p.ast.getLength();
    }
    while (1) {
      if (repCharIndex >= chars.length) {
        /* exit on end of input string */
        break;
      }
      opExecute(opIndex + 1, repCharIndex);
      if (sysData.state === id.NOMATCH) {
        /* always end if the child node fails */
        break;
      }
      if (sysData.state === id.EMPTY) {
        /* REP always succeeds when the child node returns an empty phrase */
        /* this may not seem obvious, but that's the way it works out */
        break;
      }
      repCount += 1;
      repPhrase += sysData.phraseLength;
      repCharIndex += sysData.phraseLength;
      if (repCount === op.max) {
        /* end on maxed out reps */
        break;
      }
    }
    /* evaluate the match count according to the min, max values */
    if (sysData.state === id.EMPTY) {
      sysData.state = repPhrase === 0 ? id.EMPTY : id.MATCH;
      sysData.phraseLength = repPhrase;
    } else if (repCount >= op.min) {
      sysData.state = repPhrase === 0 ? id.EMPTY : id.MATCH;
      sysData.phraseLength = repPhrase;
    } else {
      sysData.state = id.NOMATCH;
      sysData.phraseLength = 0;
      if (p.ast) {
        p.ast.setLength(astLength);
      }
    }
  };
  // Validate the callback function's returned sysData values.
  // It's the user's responsibility to get them right
  // but `RNM` fails if not.
  const validateRnmCallbackResult = (rule, sysData, charsLeft, down) => {
    if (sysData.phraseLength > charsLeft) {
      let str = `${thisFileName}opRNM(${rule.name}): callback function error: `;
      str += `sysData.phraseLength: ${sysData.phraseLength}`;
      str += ` must be <= remaining chars: ${charsLeft}`;
      throw new Error(str);
    }
    switch (sysData.state) {
      case id.ACTIVE:
        if (!down) {
          throw new Error(
            `${thisFileName}opRNM(${rule.name}): callback function return error. ACTIVE state not allowed.`
          );
        }
        break;
      case id.EMPTY:
        sysData.phraseLength = 0;
        break;
      case id.MATCH:
        if (sysData.phraseLength === 0) {
          sysData.state = id.EMPTY;
        }
        break;
      case id.NOMATCH:
        sysData.phraseLength = 0;
        break;
      default:
        throw new Error(
          `${thisFileName}opRNM(${rule.name}): callback function return error. Unrecognized return state: ${sysData.state}`
        );
    }
  };
  // The `RNM` operator.<br>
  // This operator will acts as a root node for a parse tree branch below and
  // returns the matched phrase to its parent.
  // However, its larger responsibility is handling user-defined callback functions and `AST` nodes.
  // Note that the `AST` is a separate object, but `RNM` calls its functions to create its nodes.
  const opRNM = (opIndex, phraseIndex) => {
    let astLength;
    let astDefined;
    let savedOpcodes;
    const op = opcodes[opIndex];
    const rule = rules[op.index];
    const callback = ruleCallbacks[rule.index];
    /* ignore AST in look ahead (AND or NOT operator above) */
    if (!lookAhead) {
      astDefined = p.ast && p.ast.ruleDefined(op.index);
      if (astDefined) {
        astLength = p.ast.getLength();
        p.ast.down(op.index, rules[op.index].name);
      }
    }
    if (callback) {
      /* call user's callback going down the parse tree*/
      const charsLeft = chars.length - phraseIndex;
      callback(sysData, chars, phraseIndex, userData);
      validateRnmCallbackResult(rule, sysData, charsLeft, true);
      if (sysData.state === id.ACTIVE) {
        savedOpcodes = opcodes;
        opcodes = rule.opcodes;
        opExecute(0, phraseIndex);
        opcodes = savedOpcodes;
        /* call user's callback going up the parse tree*/
        callback(sysData, chars, phraseIndex, userData);
        validateRnmCallbackResult(rule, sysData, charsLeft, false);
      } /* implied else clause: just accept the callback sysData - RNM acting as UDT */
    } else {
      /* no callback - just execute the rule */
      savedOpcodes = opcodes;
      opcodes = rule.opcodes;
      opExecute(0, phraseIndex, sysData);
      opcodes = savedOpcodes;
    }
    if (!lookAhead) {
      /* end AST */
      if (astDefined) {
        if (sysData.state === id.NOMATCH) {
          p.ast.setLength(astLength);
        } else {
          p.ast.up(op.index, rule.name, phraseIndex, sysData.phraseLength);
        }
      }
    }
  };
  // The `TRG` operator.<br>
  // Succeeds if the single first character of the phrase is
  // within the `min - max` range.
  const opTRG = (opIndex, phraseIndex) => {
    const op = opcodes[opIndex];
    sysData.state = id.NOMATCH;
    if (phraseIndex < chars.length) {
      if (op.min <= chars[phraseIndex] && chars[phraseIndex] <= op.max) {
        sysData.state = id.MATCH;
        sysData.phraseLength = 1;
      }
    }
  };
  // The `TBS` operator.<br>
  // Matches its pre-defined phrase against the input string.
  // All characters must match exactly.
  // Case-sensitive literal strings (`'string'` & `%s"string"`) are translated to `TBS`
  // operators by `apg`.
  // Phrase length of zero is not allowed.
  // Empty phrases can only be defined with `TLS` operators.
  const opTBS = (opIndex, phraseIndex) => {
    const op = opcodes[opIndex];
    const len = op.string.length;
    sysData.state = id.NOMATCH;
    if (phraseIndex + len <= chars.length) {
      for (let i = 0; i < len; i += 1) {
        if (chars[phraseIndex + i] !== op.string[i]) {
          return;
        }
      }
      sysData.state = id.MATCH;
      sysData.phraseLength = len;
    } /* implied else NOMATCH */
  };
  // The `TLS` operator.<br>
  // Matches its pre-defined phrase against the input string.
  // A case-insensitive match is attempted for ASCII alphbetical characters.
  // `TLS` is the only operator that explicitly allows empty phrases.
  // `apg` will fail for empty `TBS`, case-sensitive strings (`''`) or
  // zero repetitions (`0*0RuleName` or `0RuleName`).
  const opTLS = (opIndex, phraseIndex) => {
    let code;
    const op = opcodes[opIndex];
    sysData.state = id.NOMATCH;
    const len = op.string.length;
    if (len === 0) {
      /* EMPTY match allowed for TLS */
      sysData.state = id.EMPTY;
      return;
    }
    if (phraseIndex + len <= chars.length) {
      for (let i = 0; i < len; i += 1) {
        code = chars[phraseIndex + i];
        if (code >= 65 && code <= 90) {
          code += 32;
        }
        if (code !== op.string[i]) {
          return;
        }
      }
      sysData.state = id.MATCH;
      sysData.phraseLength = len;
    } /* implied else NOMATCH */
  };
  // Validate the callback function's returned sysData values.
  // It's the user's responsibility to get it right but `UDT` fails if not.
  const validateUdtCallbackResult = (udt, sysData, charsLeft) => {
    if (sysData.phraseLength > charsLeft) {
      let str = `${thisFileName}opUDT(${udt.name}): callback function error: `;
      str += `sysData.phraseLength: ${sysData.phraseLength}`;
      str += ` must be <= remaining chars: ${charsLeft}`;
      throw new Error(str);
    }
    switch (sysData.state) {
      case id.ACTIVE:
        throw new Error(`${thisFileName}opUDT(${udt.name}) ACTIVE state return not allowed.`);
      case id.EMPTY:
        if (udt.empty) {
          sysData.phraseLength = 0;
        } else {
          throw new Error(`${thisFileName}opUDT(${udt.name}) may not return EMPTY.`);
        }
        break;
      case id.MATCH:
        if (sysData.phraseLength === 0) {
          if (udt.empty) {
            sysData.state = id.EMPTY;
          } else {
            throw new Error(`${thisFileName}opUDT(${udt.name}) may not return EMPTY.`);
          }
        }
        break;
      case id.NOMATCH:
        sysData.phraseLength = 0;
        break;
      default:
        throw new Error(
          `${thisFileName}opUDT(${udt.name}): callback function return error. Unrecognized return state: ${sysData.state}`
        );
    }
  };
  // The `UDT` operator.<br>
  // Simply calls the user's callback function, but operates like `RNM` with regard to the `AST`
  // and back referencing.
  // There is some ambiguity here. `UDT`s act as terminals for phrase recognition but as named rules
  // for `AST` nodes and back referencing.
  // See [`ast.js`](./ast.html) for usage.
  const opUDT = (opIndex, phraseIndex) => {
    let astLength;
    let astIndex;
    let astDefined;
    const op = opcodes[opIndex];
    const udt = udts[op.index];
    sysData.UdtIndex = udt.index;
    /* ignore AST in look ahead */
    if (!lookAhead) {
      astDefined = p.ast && p.ast.udtDefined(op.index);
      if (astDefined) {
        astIndex = rules.length + op.index;
        astLength = p.ast.getLength();
        p.ast.down(astIndex, udt.name);
      }
    }
    /* call the UDT */
    const charsLeft = chars.length - phraseIndex;
    udtCallbacks[op.index](sysData, chars, phraseIndex, userData);
    validateUdtCallbackResult(udt, sysData, charsLeft);
    if (!lookAhead) {
      /* end AST */
      if (astDefined) {
        if (sysData.state === id.NOMATCH) {
          p.ast.setLength(astLength);
        } else {
          p.ast.up(astIndex, udt.name, phraseIndex, sysData.phraseLength);
        }
      }
    }
  };
  // The `AND` operator.<br>
  // This is the positive `look ahead` operator.
  // Executes its single child node, returning the EMPTY state
  // if it succeedsand NOMATCH if it fails.
  // *Always* backtracks on any matched phrase and returns EMPTY on success.
  const opAND = (opIndex, phraseIndex) => {
    lookAhead += 1;
    opExecute(opIndex + 1, phraseIndex);
    lookAhead -= 1;
    sysData.phraseLength = 0;
    switch (sysData.state) {
      case id.EMPTY:
        sysData.state = id.EMPTY;
        break;
      case id.MATCH:
        sysData.state = id.EMPTY;
        break;
      case id.NOMATCH:
        sysData.state = id.NOMATCH;
        break;
      default:
        throw new Error(`opAND: invalid state ${sysData.state}`);
    }
  };
  // The `NOT` operator.<br>
  // This is the negative `look ahead` operator.
  // Executes its single child node, returning the EMPTY state
  // if it *fails* and NOMATCH if it succeeds.
  // *Always* backtracks on any matched phrase and returns EMPTY
  // on success (failure of its child node).
  const opNOT = (opIndex, phraseIndex) => {
    lookAhead += 1;
    opExecute(opIndex + 1, phraseIndex);
    lookAhead -= 1;
    sysData.phraseLength = 0;
    switch (sysData.state) {
      case id.EMPTY:
      case id.MATCH:
        sysData.state = id.NOMATCH;
        break;
      case id.NOMATCH:
        sysData.state = id.EMPTY;
        break;
      default:
        throw new Error(`opNOT: invalid state ${sysData.state}`);
    }
  };

  const opExecute = (opIndex, phraseIndex) => {
    const functionName = `${thisFileName}opExecute(): `;
    const op = opcodes[opIndex];
    nodeHits += 1;
    if (treeDepth > maxTreeDepth) {
      maxTreeDepth = treeDepth;
    }
    treeDepth += 1;
    sysData.refresh();
    if (p.trace) {
      p.trace.down(op, phraseIndex);
    }
    switch (op.type) {
      case id.ALT:
        opALT(opIndex, phraseIndex);
        break;
      case id.CAT:
        opCAT(opIndex, phraseIndex);
        break;
      case id.REP:
        opREP(opIndex, phraseIndex);
        break;
      case id.RNM:
        opRNM(opIndex, phraseIndex);
        break;
      case id.TRG:
        opTRG(opIndex, phraseIndex);
        break;
      case id.TBS:
        opTBS(opIndex, phraseIndex);
        break;
      case id.TLS:
        opTLS(opIndex, phraseIndex);
        break;
      case id.UDT:
        opUDT(opIndex, phraseIndex);
        break;
      case id.AND:
        opAND(opIndex, phraseIndex);
        break;
      case id.NOT:
        opNOT(opIndex, phraseIndex);
        break;
      default:
        throw new Error(`${functionName}unrecognized operator`);
    }
    if (!lookAhead) {
      if (phraseIndex + sysData.phraseLength > maxMatched) {
        maxMatched = phraseIndex + sysData.phraseLength;
      }
    }
    if (p.stats) {
      p.stats.collect(op, sysData);
    }
    if (p.trace) {
      p.trace.up(op, sysData.state, phraseIndex, sysData.phraseLength);
    }
    treeDepth -= 1;
  };
};

const Ast = function fnast() {
  const thisFileName = 'parser.js: Ast()): ';
  const id = identifiers;
  const utils = utilities;
  const a = this;
  let rules = undefined;
  let udts = undefined;
  let chars = undefined;
  let nodeCount = 0;
  const nodeCallbacks = [];
  const stack = [];
  const records = [];
  a.callbacks = [];
  /* called by the parser to initialize the AST with the rules, UDTs and the input characters */
  a.init = (rulesIn, udtsIn, charsIn) => {
    stack.length = 0;
    records.length = 0;
    nodeCount = 0;
    rules = rulesIn;
    udts = udtsIn;
    chars = charsIn;
    let i;
    const list = [];
    for (i = 0; i < rules.length; i += 1) {
      list.push(rules[i].lower);
    }
    for (i = 0; i < udts.length; i += 1) {
      list.push(udts[i].lower);
    }
    nodeCount = rules.length + udts.length;
    for (i = 0; i < nodeCount; i += 1) {
      nodeCallbacks[i] = undefined;
    }
    for (const index in a.callbacks) {
      if (a.callbacks.hasOwnProperty(index)) {
        const lower = index.toLowerCase();
        i = list.indexOf(lower);
        if (i < 0) {
          throw new Error(`${thisFileName}init: node '${index}' not a rule or udt name`);
        }
        nodeCallbacks[i] = a.callbacks[index];
      }
    }
  };
  /* AST node rule callbacks - called by the parser's `RNM` operator */
  a.ruleDefined = (index) => !!nodeCallbacks[index];
  /* AST node UDT callbacks - called by the parser's `UDT` operator */
  a.udtDefined = (index) => !!nodeCallbacks[rules.length + index];
  /* called by the parser's `RNM` & `UDT` operators
     builds a record for the downward traversal of the node */
  a.down = (callbackIndex, name) => {
    const thisIndex = records.length;
    stack.push(thisIndex);
    records.push({
      name,
      thisIndex,
      thatIndex: undefined,
      state: id.SEM_PRE,
      callbackIndex,
      phraseIndex: undefined,
      phraseLength: undefined,
      stack: stack.length,
    });
    return thisIndex;
  };
  /* called by the parser's `RNM` & `UDT` operators */
  /* builds a record for the upward traversal of the node */
  a.up = (callbackIndex, name, phraseIndex, phraseLength) => {
    const thisIndex = records.length;
    const thatIndex = stack.pop();
    records.push({
      name,
      thisIndex,
      thatIndex,
      state: id.SEM_POST,
      callbackIndex,
      phraseIndex,
      phraseLength,
      stack: stack.length,
    });
    records[thatIndex].thatIndex = thisIndex;
    records[thatIndex].phraseIndex = phraseIndex;
    records[thatIndex].phraseLength = phraseLength;
    return thisIndex;
  };
  // Called by the user to translate the AST.
  // Translate means to associate or apply some semantic action to the
  // phrases that were syntactically matched to the AST nodes according
  // to the defining grammar.
  // ```
  // data - optional user-defined data
  //        passed to the callback functions by the translator
  // ```
  a.translate = (data) => {
    let ret;
    let callback;
    let record;
    for (let i = 0; i < records.length; i += 1) {
      record = records[i];
      callback = nodeCallbacks[record.callbackIndex];
      if (callback) {
        if (record.state === id.SEM_PRE) {
          callback(id.SEM_PRE, chars, record.phraseIndex, record.phraseLength, data);
        } else if (callback) {
          callback(id.SEM_POST, chars, record.phraseIndex, record.phraseLength, data);
        }
      }
    }
  };
  /* called by the parser to reset the length of the records array */
  /* necessary on backtracking */
  a.setLength = (length) => {
    records.length = length;
    if (length > 0) {
      stack.length = records[length - 1].stack;
    } else {
      stack.length = 0;
    }
  };
  /* called by the parser to get the length of the records array */
  a.getLength = () => records.length;
  /* helper for XML display */
  function indent(n) {
    let ret = '';
    while (n-- > 0) {
      ret += ' ';
    }
    return ret;
  }
  // Generate an `XML` version of the AST.
  // Useful if you want to use a special or favorite XML parser to translate the
  // AST. Node data are JavaScript strings.
  a.toXml = () => {
    let xml = '';
    let depth = 0;
    xml += '<?xml version="1.0" encoding="utf-8"?>\n';
    xml += `<root nodes="${records.length / 2}" characters="${chars.length}">\n`;
    xml += `<!-- input string -->\n`;
    xml += indent(depth + 2);
    xml += utils.charsToString(chars);
    xml += '\n';
    records.forEach((rec) => {
      if (rec.state === id.SEM_PRE) {
        depth += 1;
        xml += indent(depth);
        xml += `<node name="${rec.name}" index="${rec.phraseIndex}" length="${rec.phraseLength}">\n`;
        xml += indent(depth + 2);
        xml += utils.charsToString(chars, rec.phraseIndex, rec.phraseLength);
        xml += '\n';
      } else {
        xml += indent(depth);
        xml += `</node><!-- name="${rec.name}" -->\n`;
        depth -= 1;
      }
    });

    xml += '</root>\n';
    return xml;
  };
};

const Trace = function fntrace() {
  const id = identifiers;
  const utils = utilities;
  const thisFile = 'parser.js: Trace(): ';
  let chars = undefined;
  let rules = undefined;
  let udts = undefined;
  let out = '';
  let treeDepth = 0;
  const MAX_PHRASE = 100;
  const t = this;
  const indent = (n) => {
    let ret = '';
    let count = 0;
    if (n >= 0) {
      while (n--) {
        count += 1;
        if (count === 5) {
          ret += '|';
          count = 0;
        } else {
          ret += '.';
        }
      }
    }
    return ret;
  };
  t.init = (r, u, c) => {
    rules = r;
    udts = u;
    chars = c;
  };
  const opName = (op) => {
    let name;
    switch (op.type) {
      case id.ALT:
        name = 'ALT';
        break;
      case id.CAT:
        name = 'CAT';
        break;
      case id.REP:
        if (op.max === Infinity) {
          name = `REP(${op.min},inf)`;
        } else {
          name = `REP(${op.min},${op.max})`;
        }
        break;
      case id.RNM:
        name = `RNM(${rules[op.index].name})`;
        break;
      case id.TRG:
        name = `TRG(${op.min},${op.max})`;
        break;
      case id.TBS:
        if (op.string.length > 6) {
          name = `TBS(${utils.charsToString(op.string, 0, 3)}...)`;
        } else {
          name = `TBS(${utils.charsToString(op.string, 0, 6)})`;
        }
        break;
      case id.TLS:
        if (op.string.length > 6) {
          name = `TLS(${utils.charsToString(op.string, 0, 3)}...)`;
        } else {
          name = `TLS(${utils.charsToString(op.string, 0, 6)})`;
        }
        break;
      case id.UDT:
        name = `UDT(${udts[op.index].name})`;
        break;
      case id.AND:
        name = 'AND';
        break;
      case id.NOT:
        name = 'NOT';
        break;
      default:
        throw new Error(`${thisFile}Trace: opName: unrecognized opcode`);
    }
    return name;
  };
  t.down = (op, offset) => {
    const lead = indent(treeDepth);
    const len = Math.min(MAX_PHRASE, chars.length - offset);
    let phrase = utils.charsToString(chars, offset, len);
    if (len < chars.length - offset) {
      phrase += '...';
    }
    phrase = `${lead}|-|[${opName(op)}]${phrase}\n`;
    out += phrase;
    treeDepth += 1;
  };
  t.up = (op, state, offset, phraseLength) => {
    const thisFunc = `${thisFile}trace.up: `;
    treeDepth -= 1;
    const lead = indent(treeDepth);
    let len;
    let phrase;
    let st;
    switch (state) {
      case id.EMPTY:
        st = '|E|';
        phrase = `''`;
        break;
      case id.MATCH:
        st = '|M|';
        len = Math.min(MAX_PHRASE, phraseLength);
        if (len < phraseLength) {
          phrase = `'${utils.charsToString(chars, offset, len)}...'`;
        } else {
          phrase = `'${utils.charsToString(chars, offset, len)}'`;
        }
        break;
      case id.NOMATCH:
        st = '|N|';
        phrase = '';
        break;
      default:
        throw new Error(`${thisFunc} unrecognized state`);
    }
    phrase = `${lead}${st}[${opName(op)}]${phrase}\n`;
    out += phrase;
  };
  t.displayTrace = () => out;
};

const Stats = function fnstats() {
  const id = identifiers;
  const thisFileName = 'parser.js: Stats(): ';
  let rules;
  let udts;
  let totals;
  const stats = [];
  const ruleStats = [];
  const udtStats = [];
  /* called by parser to initialize the stats */
  this.init = (r, u) => {
    rules = r;
    udts = u;
    clear();
  };
  /* This function is the main interaction with the parser. */
  /* The parser calls it after each node has been traversed. */
  this.collect = (op, sys) => {
    incStat(totals, sys.state, sys.phraseLength);
    incStat(stats[op.type], sys.state, sys.phraseLength);
    if (op.type === id.RNM) {
      incStat(ruleStats[op.index], sys.state, sys.phraseLength);
    }
    if (op.type === id.UDT) {
      incStat(udtStats[op.index], sys.state, sys.phraseLength);
    }
  };
  this.displayStats = () => {
    let out = '';
    const totals = {
      match: 0,
      empty: 0,
      nomatch: 0,
      total: 0,
    };
    const displayRow = (op, m, e, n, t) => {
      totals.match += m;
      totals.empty += e;
      totals.nomatch += n;
      totals.total += t;
      const mm = normalize(m);
      const ee = normalize(e);
      const nn = normalize(n);
      const tt = normalize(t);
      return `${op} | ${mm} | ${ee} | ${nn} | ${tt} |\n`;
    };
    out += '          OPERATOR STATS\n';
    out += '      |   MATCH |   EMPTY | NOMATCH |   TOTAL |\n';
    out += displayRow('  ALT', stats[id.ALT].match, stats[id.ALT].empty, stats[id.ALT].nomatch, stats[id.ALT].total);
    out += displayRow('  CAT', stats[id.CAT].match, stats[id.CAT].empty, stats[id.CAT].nomatch, stats[id.CAT].total);
    out += displayRow('  REP', stats[id.REP].match, stats[id.REP].empty, stats[id.REP].nomatch, stats[id.REP].total);
    out += displayRow('  RNM', stats[id.RNM].match, stats[id.RNM].empty, stats[id.RNM].nomatch, stats[id.RNM].total);
    out += displayRow('  TRG', stats[id.TRG].match, stats[id.TRG].empty, stats[id.TRG].nomatch, stats[id.TRG].total);
    out += displayRow('  TBS', stats[id.TBS].match, stats[id.TBS].empty, stats[id.TBS].nomatch, stats[id.TBS].total);
    out += displayRow('  TLS', stats[id.TLS].match, stats[id.TLS].empty, stats[id.TLS].nomatch, stats[id.TLS].total);
    out += displayRow('  UDT', stats[id.UDT].match, stats[id.UDT].empty, stats[id.UDT].nomatch, stats[id.UDT].total);
    out += displayRow('  AND', stats[id.AND].match, stats[id.AND].empty, stats[id.AND].nomatch, stats[id.AND].total);
    out += displayRow('  NOT', stats[id.NOT].match, stats[id.NOT].empty, stats[id.NOT].nomatch, stats[id.NOT].total);
    out += displayRow('TOTAL', totals.match, totals.empty, totals.nomatch, totals.total);
    return out;
  };
  /*
  Display rule/udt
  */
  this.displayHits = (type) => {
    let out = '';
    const displayRow = (m, e, n, t, name) => {
      totals.match += m;
      totals.empty += e;
      totals.nomatch += n;
      totals.total += t;
      const mm = normalize(m);
      const ee = normalize(e);
      const nn = normalize(n);
      const tt = normalize(t);
      return `| ${mm} | ${ee} | ${nn} | ${tt} | ${name}\n`;
    };
    if (typeof type === 'string' && type.toLowerCase()[0] === 'a') {
      ruleStats.sort(sortAlpha);
      udtStats.sort(sortAlpha);
      out += '    RULES/UDTS ALPHABETICALLY\n';
    } else if (typeof type === 'string' && type.toLowerCase()[0] === 'i') {
      ruleStats.sort(sortIndex);
      udtStats.sort(sortIndex);
      out += '    RULES/UDTS BY INDEX\n';
    } else {
      ruleStats.sort(sortHits);
      udtStats.sort(sortHits);
      out += '    RULES/UDTS BY HIT COUNT\n';
    }
    out += '|   MATCH |   EMPTY | NOMATCH |   TOTAL | NAME\n';
    for (let i = 0; i < ruleStats.length; i += 1) {
      let r = ruleStats[i];
      if (r.total) {
        out += displayRow(r.match, r.empty, r.nomatch, r.total, r.name);
      }
    }
    for (let i = 0; i < udtStats.length; i += 1) {
      let r = udtStats[i];
      if (r.total) {
        out += displayRow(r.match, r.empty, r.nomatch, r.total, r.name);
      }
    }
    return out;
  };
  const normalize = (n) => {
    if (n < 10) {
      return `      ${n}`;
    }
    if (n < 100) {
      return `     ${n}`;
    }
    if (n < 1000) {
      return `    ${n}`;
    }
    if (n < 10000) {
      return `   ${n}`;
    }
    if (n < 100000) {
      return `  ${n}`;
    }
    if (n < 1000000) {
      return ` ${n}`;
    }
    return `${n}`;
  };
  const sortAlpha = (lhs, rhs) => {
    if (lhs.lower < rhs.lower) {
      return -1;
    }
    if (lhs.lower > rhs.lower) {
      return 1;
    }
    return 0;
  };
  const sortHits = (lhs, rhs) => {
    if (lhs.total < rhs.total) {
      return 1;
    }
    if (lhs.total > rhs.total) {
      return -1;
    }
    return sortAlpha(lhs, rhs);
  };
  const sortIndex = (lhs, rhs) => {
    if (lhs.index < rhs.index) {
      return -1;
    }
    if (lhs.index > rhs.index) {
      return 1;
    }
    return 0;
  };
  const EmptyStat = function fnempty() {
    this.empty = 0;
    this.match = 0;
    this.nomatch = 0;
    this.total = 0;
  };
  /* Zero out all stats */
  const clear = () => {
    stats.length = 0;
    totals = new EmptyStat();
    stats[id.ALT] = new EmptyStat();
    stats[id.CAT] = new EmptyStat();
    stats[id.REP] = new EmptyStat();
    stats[id.RNM] = new EmptyStat();
    stats[id.TRG] = new EmptyStat();
    stats[id.TBS] = new EmptyStat();
    stats[id.TLS] = new EmptyStat();
    stats[id.UDT] = new EmptyStat();
    stats[id.AND] = new EmptyStat();
    stats[id.NOT] = new EmptyStat();
    ruleStats.length = 0;
    for (let i = 0; i < rules.length; i += 1) {
      ruleStats.push({
        empty: 0,
        match: 0,
        nomatch: 0,
        total: 0,
        name: rules[i].name,
        lower: rules[i].lower,
        index: rules[i].index,
      });
    }
    if (udts.length > 0) {
      udtStats.length = 0;
      for (let i = 0; i < udts.length; i += 1) {
        udtStats.push({
          empty: 0,
          match: 0,
          nomatch: 0,
          total: 0,
          name: udts[i].name,
          lower: udts[i].lower,
          index: udts[i].index,
        });
      }
    }
  };
  /* increment the designated operator hit count by one */
  const incStat = (stat, state) => {
    stat.total += 1;
    switch (state) {
      case id.EMPTY:
        stat.empty += 1;
        break;
      case id.MATCH:
        stat.match += 1;
        break;
      case id.NOMATCH:
        stat.nomatch += 1;
        break;
      default:
        throw new Error(`${thisFileName}collect(): incStat(): unrecognized state: ${state}`);
    }
  };
};

const utilities = {
  // utility functions
  stringToChars: (string) => [...string].map((cp) => cp.codePointAt(0)),
  charsToString: (chars, beg, len) => {
    let subChars = chars;
    while (1) {
      if (beg === undefined || beg < 0) {
        break;
      }
      if (len === undefined) {
        subChars = chars.slice(beg);
        break;
      }
      if (len <= 0) {
        // always an empty string
        return '';
      }
      subChars = chars.slice(beg, beg + len);
      break;
    }
    return String.fromCodePoint(...subChars);
  },
};

const identifiers = {
  // Identifies the operator type.
  // NB: These must match the values in apg-js 4.3.0, apg-lib/identifiers.
  /* the original ABNF operators */
  ALT: 1 /* alternation */,
  CAT: 2 /* concatenation */,
  REP: 3 /* repetition */,
  RNM: 4 /* rule name */,
  TRG: 5 /* terminal range */,
  TBS: 6 /* terminal binary string, case sensitive */,
  TLS: 7 /* terminal literal string, case insensitive */,
  /* the super set, SABNF operators */
  UDT: 11 /* user-defined terminal */,
  AND: 12 /* positive look ahead */,
  NOT: 13 /* negative look ahead */,
  // Used by the parser and the user's `RNM` and `UDT` callback functions.
  // Identifies the parser state as it traverses the parse tree nodes.
  // - *ACTIVE* - indicates the downward direction through the parse tree node.
  // - *MATCH* - indicates the upward direction and a phrase, of length \> 0, has been successfully matched
  // - *EMPTY* - indicates the upward direction and a phrase, of length = 0, has been successfully matched
  // - *NOMATCH* - indicates the upward direction and the parser failed to match any phrase at all
  ACTIVE: 100,
  MATCH: 101,
  EMPTY: 102,
  NOMATCH: 103,
  // Used by [`AST` translator](./ast.html) (semantic analysis) and the user's callback functions
  // to indicate the direction of flow through the `AST` nodes.
  // - *SEM_PRE* - indicates the downward (pre-branch) direction through the `AST` node.
  // - *SEM_POST* - indicates the upward (post-branch) direction through the `AST` node.
  SEM_PRE: 200,
  SEM_POST: 201,
  // Ignored. Retained for backwords compatibility.
  SEM_OK: 300,
  idName: (s) => {
    switch (s) {
      case identifiers.ALT:
        return 'ALT';
      case identifiers.CAT:
        return 'CAT';
      case identifiers.REP:
        return 'REP';
      case identifiers.RNM:
        return 'RNM';
      case identifiers.TRG:
        return 'TRG';
      case identifiers.TBS:
        return 'TBS';
      case identifiers.TLS:
        return 'TLS';
      case identifiers.UDT:
        return 'UDT';
      case identifiers.AND:
        return 'AND';
      case identifiers.NOT:
        return 'NOT';
      case identifiers.ACTIVE:
        return 'ACTIVE';
      case identifiers.EMPTY:
        return 'EMPTY';
      case identifiers.MATCH:
        return 'MATCH';
      case identifiers.NOMATCH:
        return 'NOMATCH';
      case identifiers.SEM_PRE:
        return 'SEM_PRE';
      case identifiers.SEM_POST:
        return 'SEM_POST';
      case identifiers.SEM_OK:
        return 'SEM_OK';
      default:
        return 'UNRECOGNIZED STATE';
    }
  },
};


/***/ }),

/***/ 16710:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22488);

/**
 * @public
 */
class PrefixItemsVisitor extends _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.passingOptionsNames.push('parent');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PrefixItemsVisitor);

/***/ }),

/***/ 16750:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1908);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(60020);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36114);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39633);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9748);






/**
 * @public
 */
/**
 * @public
 */
class ParametersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.ArrayElement();
    this.element.classes.push('parameters');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(item) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Parameter'];
      const element = this.toRefractedElement(specPath, item);
      if ((0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement)(element)) {
        element.setMetaProperty('referenced-element', 'parameter');
      }
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParametersVisitor);

/***/ }),

/***/ 16762:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JSONSchemaElement: () => (/* reexport safe */ _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   LinkDescriptionElement: () => (/* reexport safe */ _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__["default"])
/* harmony export */ });
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(81497);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40552);
/* harmony import */ var _index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(81251);


 // register refractors specific to element types
_elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'JSONSchema', '$visitor']);
_elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__["default"].refract = (0,_index_mjs__WEBPACK_IMPORTED_MODULE_1__.createRefractor)(['visitors', 'document', 'objects', 'LinkDescription', '$visitor']);


/***/ }),

/***/ 16910:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _invoker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(57898);


/**
 * Returns a string made by inserting the `separator` between each element and
 * concatenating all the elements into a single string.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category List
 * @sig String -> [a] -> String
 * @param {Number|String} separator The string used to separate the elements.
 * @param {Array} xs The elements to join into a string.
 * @return {String} str The string made by concatenating `xs` with `separator`.
 * @see R.split
 * @example
 *
 *      const spacer = R.join(' ');
 *      spacer(['a', 2, 3.4]);   //=> 'a 2 3.4'
 *      R.join('|', [1, 2, 3]);    //=> '1|2|3'
 */
var join = /*#__PURE__*/(0,_invoker_js__WEBPACK_IMPORTED_MODULE_0__["default"])(1, 'join');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (join);

/***/ }),

/***/ 16946:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);
var fails = __webpack_require__(98828);
var classof = __webpack_require__(45807);

var $Object = Object;
var split = uncurryThis(''.split);

// fallback for non-array-like ES3 and non-enumerable old V8 strings
module.exports = fails(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !$Object('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof(it) === 'String' ? split(it, '') : $Object(it);
} : $Object;


/***/ }),

/***/ 17162:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _dissoc)
/* harmony export */ });
/* harmony import */ var _isInteger_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64279);
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5564);
/* harmony import */ var _remove_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(954);




/**
 * Returns a new object that does not contain a `prop` property.
 *
 * @private
 * @param {String|Number} prop The name of the property to dissociate
 * @param {Object|Array} obj The object to clone
 * @return {Object} A new object equivalent to the original but without the specified property
 */
function _dissoc(prop, obj) {
  if (obj == null) {
    return obj;
  }
  if ((0,_isInteger_js__WEBPACK_IMPORTED_MODULE_0__["default"])(prop) && (0,_isArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(obj)) {
    return (0,_remove_js__WEBPACK_IMPORTED_MODULE_2__["default"])(prop, 1, obj);
  }
  var result = {};
  for (var p in obj) {
    result[p] = obj[p];
  }
  delete result[prop];
  return result;
}

/***/ }),

/***/ 17198:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(60020);
/* harmony import */ var _elements_nces_Servers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(59360);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36114);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39633);






/**
 * @public
 */
/**
 * @public
 */
class ServersVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_Servers_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_4__.isServerLikeElement)(item) ? ['document', 'objects', 'Server'] : ['value'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServersVisitor);

/***/ }),

/***/ 17381:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Retrieves the root cause of ApiDOM error hierarchy.
 * ApiDOM error hierarchies are modeled similar to Java.
 * Every error can have cause attribute which references
 * cause of this error.
 */
const getRootCause = error => {
  if (error.cause == null) return error;
  let {
    cause
  } = error;
  while (cause.cause != null) {
    cause = cause.cause;
  }
  return cause;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (getRootCause);

/***/ }),

/***/ 17523:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29825);
/* harmony import */ var _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(54492);
/* harmony import */ var _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(42856);
/* harmony import */ var _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(92872);
/* harmony import */ var _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(73287);
/* harmony import */ var _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(68562);
/* harmony import */ var _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86729);
/* harmony import */ var _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(94831);
/* harmony import */ var _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(52824);
/* harmony import */ var _elements_License_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(77785);
/* harmony import */ var _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(96184);
/* harmony import */ var _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(41392);
/* harmony import */ var _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(12357);
/* harmony import */ var _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(38908);
/* harmony import */ var _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(29364);
/* harmony import */ var _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(42280);
/* harmony import */ var _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(16307);
/* harmony import */ var _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(71521);
/* harmony import */ var _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(65304);
/* harmony import */ var _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(77116);
/* harmony import */ var _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(86371);
/* harmony import */ var _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(1843);
/* harmony import */ var _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(37985);
/* harmony import */ var _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(35600);
/* harmony import */ var _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(53369);
/* harmony import */ var _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(86739);
/* harmony import */ var _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(18191);
/* harmony import */ var _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(74849);
/* harmony import */ var _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(70369);
/* harmony import */ var _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(83832);
/* harmony import */ var _elements_Xml_mjs__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(68091);































/**
 * @public
 */
// eslint-disable-next-line @typescript-eslint/naming-convention
const openApi3_0 = {
  namespace: options => {
    const {
      base
    } = options;
    base.register('callback', _elements_Callback_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]);
    base.register('components', _elements_Components_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]);
    base.register('contact', _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]);
    base.register('discriminator', _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]);
    base.register('encoding', _elements_Encoding_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]);
    base.register('example', _elements_Example_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]);
    base.register('externalDocumentation', _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_6__["default"]);
    base.register('header', _elements_Header_mjs__WEBPACK_IMPORTED_MODULE_7__["default"]);
    base.register('info', _elements_Info_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]);
    base.register('license', _elements_License_mjs__WEBPACK_IMPORTED_MODULE_9__["default"]);
    base.register('link', _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_10__["default"]);
    base.register('mediaType', _elements_MediaType_mjs__WEBPACK_IMPORTED_MODULE_11__["default"]);
    base.register('oAuthFlow', _elements_OAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_12__["default"]);
    base.register('oAuthFlows', _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_13__["default"]);
    base.register('openapi', _elements_Openapi_mjs__WEBPACK_IMPORTED_MODULE_14__["default"]);
    base.register('openApi3_0', _elements_OpenApi3_0_mjs__WEBPACK_IMPORTED_MODULE_15__["default"]);
    base.register('operation', _elements_Operation_mjs__WEBPACK_IMPORTED_MODULE_16__["default"]);
    base.register('parameter', _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_17__["default"]);
    base.register('pathItem', _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_18__["default"]);
    base.register('paths', _elements_Paths_mjs__WEBPACK_IMPORTED_MODULE_19__["default"]);
    base.register('reference', _elements_Reference_mjs__WEBPACK_IMPORTED_MODULE_20__["default"]);
    base.register('requestBody', _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_21__["default"]);
    base.register('response', _elements_Response_mjs__WEBPACK_IMPORTED_MODULE_22__["default"]);
    base.register('responses', _elements_Responses_mjs__WEBPACK_IMPORTED_MODULE_23__["default"]);
    base.register('schema', _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_24__["default"]);
    base.register('securityRequirement', _elements_SecurityRequirement_mjs__WEBPACK_IMPORTED_MODULE_25__["default"]);
    base.register('securityScheme', _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_26__["default"]);
    base.register('server', _elements_Server_mjs__WEBPACK_IMPORTED_MODULE_27__["default"]);
    base.register('serverVariable', _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_28__["default"]);
    base.register('tag', _elements_Tag_mjs__WEBPACK_IMPORTED_MODULE_29__["default"]);
    base.register('xml', _elements_Xml_mjs__WEBPACK_IMPORTED_MODULE_30__["default"]);
    return base;
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi3_0);

/***/ }),

/***/ 17670:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getMapData = __webpack_require__(12651);

/**
 * Removes `key` and its value from the map.
 *
 * @private
 * @name delete
 * @memberOf MapCache
 * @param {string} key The key of the value to remove.
 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
 */
function mapCacheDelete(key) {
  var result = getMapData(this, key)['delete'](key);
  this.size -= result ? 1 : 0;
  return result;
}

module.exports = mapCacheDelete;


/***/ }),

/***/ 17673:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _CloneError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(94327);

/**
 * @public
 */
class DeepCloneError extends _CloneError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DeepCloneError);

/***/ }),

/***/ 17955:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   filter: () => (/* binding */ filter),
/* harmony export */   run: () => (/* binding */ run)
/* harmony export */ });
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(23283);
/* harmony import */ var _errors_PluginError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18223);


/**
 * Filters the given plugins, returning only the ones return `true` for the given method.
 */
const filter = async (method, parameters, plugins) => {
  const pluginResults = await Promise.all(plugins.map((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_0__["default"])([method], parameters)));
  return plugins.filter((plugin, index) => pluginResults[index]);
};

/**
 * Runs the specified method of the given plugins, in order,
 * until one of them returns a successful result.
 * Each method can return a synchronous value or a Promise.
 * If the promise resolves successfully then the result
 * is immediately returned and no further plugins are called.
 * If the promise rejects then the next plugin is called.
 * If ALL plugins fail, then the last error is thrown.
 */
const run = async (method, parameters, plugins) => {
  let lastError;
  for (const plugin of plugins) {
    try {
      const result = await plugin[method].call(plugin, ...parameters); // eslint-disable-line no-await-in-loop
      return {
        plugin,
        result
      };
    } catch (error) {
      lastError = new _errors_PluginError_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]('Error while running plugin', {
        cause: error,
        plugin
      });
    }
  }
  return Promise.reject(lastError);
};

/***/ }),

/***/ 17992:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2173);


// `Identity` is a functor that holds a single value, where `map` simply
// transforms the held value with the provided function.
var Identity = function (x) {
  return {
    value: x,
    map: function (f) {
      return Identity(f(x));
    }
  };
};

/**
 * Returns the result of "setting" the portion of the given data structure
 * focused by the given lens to the result of applying the given function to
 * the focused value.
 *
 * @func
 * @memberOf R
 * @since v0.16.0
 * @category Object
 * @typedefn Lens s a = Functor f => (a -> f a) -> s -> f s
 * @sig Lens s a -> (a -> a) -> s -> s
 * @param {Lens} lens
 * @param {*} v
 * @param {*} x
 * @return {*}
 * @see R.view, R.set, R.lens, R.lensIndex, R.lensProp, R.lensPath
 * @example
 *
 *      const headLens = R.lensIndex(0);
 *
 *      R.over(headLens, R.toUpper, ['foo', 'bar', 'baz']); //=> ['FOO', 'bar', 'baz']
 */
var over = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function over(lens, f, x) {
  // The value returned by the getter function is first transformed with `f`,
  // then set as the value of an `Identity`. This is then mapped over with the
  // setter function of the lens.
  return lens(function (y) {
    return Identity(f(y));
  })(x).value;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (over);

/***/ }),

/***/ 18088:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class RequestBody extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.RequestBodyElement {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBody);

/***/ }),

/***/ 18191:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);

/**
 * @public
 */
class SecurityScheme extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'securityScheme';
  }
  get type() {
    return this.get('type');
  }
  set type(type) {
    this.set('type', type);
  }
  get description() {
    return this.get('description');
  }
  set description(description) {
    this.set('description', description);
  }
  get name() {
    return this.get('name');
  }
  set name(name) {
    this.set('name', name);
  }
  get in() {
    return this.get('in');
  }
  set in(inVal) {
    this.set('in', inVal);
  }
  get scheme() {
    return this.get('scheme');
  }
  set scheme(scheme) {
    this.set('scheme', scheme);
  }
  get bearerFormat() {
    return this.get('bearerFormat');
  }
  set bearerFormat(bearerFormat) {
    this.set('bearerFormat', bearerFormat);
  }
  get flows() {
    return this.get('flows');
  }
  set flows(flows) {
    this.set('flows', flows);
  }
  get openIdConnectUrl() {
    return this.get('openIdConnectUrl');
  }
  set openIdConnectUrl(openIdConnectUrl) {
    this.set('openIdConnectUrl', openIdConnectUrl);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecurityScheme);

/***/ }),

/***/ 18223:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16401);


/**
 * @public
 */
class PluginError extends _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_0__["default"] {
  plugin;
  constructor(message, options) {
    super(message, {
      cause: options.cause
    });
    this.plugin = options.plugin;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PluginError);

/***/ }),

/***/ 18228:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isString)
/* harmony export */ });
function _isString(x) {
  return Object.prototype.toString.call(x) === '[object String]';
}

/***/ }),

/***/ 18359:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRefractor: () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24445);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3510);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43319);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4366);
/* harmony import */ var _specification_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(22072);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(93629);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(93519);
/* harmony import */ var _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(57550);





/**
 * @public
 */
const refract = (value, {
  specPath = ['visitors', 'document', 'objects', 'JSONSchema', '$visitor'],
  plugins = [],
  specificationObj = _specification_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]
} = {}) => {
  const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.refract)(value);
  const resolvedSpec = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.dereference)(specificationObj);

  /**
   * This is where generic ApiDOM becomes semantic (namespace applied).
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const RootVisitorClass = (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(specPath, resolvedSpec);
  const rootVisitor = new RootVisitorClass({
    specObj: resolvedSpec
  });
  (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.visit)(element, rootVisitor);

  /**
   * Run plugins only when necessary.
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.dispatchPluginsSync)(rootVisitor.element, plugins, {
    toolboxCreator: _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
    visitorOptions: {
      keyMap: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__.keyMap,
      nodeTypeGetter: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_8__.getNodeType
    }
  });
};

/**
 * @public
 */
const createRefractor = specPath => (value, options = {}) => refract(value, {
  specPath,
  ...options
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 18499:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);


/**
 * Returns a partial copy of an object containing only the keys specified. If
 * the key does not exist, the property is ignored.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Object
 * @sig [k] -> {k: v} -> {k: v}
 * @param {Array} names an array of String property names to copy onto a new object
 * @param {Object} obj The object to copy from
 * @return {Object} A new object with only properties from `names` on it.
 * @see R.omit, R.props
 * @example
 *
 *      R.pick(['a', 'd'], {a: 1, b: 2, c: 3, d: 4}); //=> {a: 1, d: 4}
 *      R.pick(['a', 'e', 'f'], {a: 1, b: 2, c: 3, d: 4}); //=> {a: 1}
 */
var pick = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function pick(names, obj) {
  var result = {};
  var idx = 0;
  while (idx < names.length) {
    if (names[idx] in obj) {
      result[names[idx]] = obj[names[idx]];
    }
    idx += 1;
  }
  return result;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (pick);

/***/ }),

/***/ 18556:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(92872);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);





/**
 * @public
 */
/**
 * @public
 */
class DiscriminatorVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Discriminator_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Discriminator']);
    this.canSupportSpecificationExtensions = false;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DiscriminatorVisitor);

/***/ }),

/***/ 18684:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class ComponentsParameters extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-parameters';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsParameters.primaryClass);
    this.classes.push('parameters');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsParameters);

/***/ }),

/***/ 18754:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class HeaderContent extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'header-content';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(HeaderContent.primaryClass);
    this.classes.push('content');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HeaderContent);

/***/ }),

/***/ 19001:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1908);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(60020);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62287);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15413);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(41413);






/**
 * @public
 */
/**
 * @public
 */
class AnyOfVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-anyOf');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const specPath = (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(item) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
      const element = this.toRefractedElement(specPath, item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AnyOfVisitor);

/***/ }),

/***/ 19034:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _curryN)
/* harmony export */ });
/* harmony import */ var _arity_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27660);
/* harmony import */ var _isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(82808);



/**
 * Internal curryN function.
 *
 * @private
 * @category Function
 * @param {Number} length The arity of the curried function.
 * @param {Array} received An array of arguments received thus far.
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */
function _curryN(length, received, fn) {
  return function () {
    var combined = [];
    var argsIdx = 0;
    var left = length;
    var combinedIdx = 0;
    var hasPlaceholder = false;
    while (combinedIdx < received.length || argsIdx < arguments.length) {
      var result;
      if (combinedIdx < received.length && (!(0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(received[combinedIdx]) || argsIdx >= arguments.length)) {
        result = received[combinedIdx];
      } else {
        result = arguments[argsIdx];
        argsIdx += 1;
      }
      combined[combinedIdx] = result;
      if (!(0,_isPlaceholder_js__WEBPACK_IMPORTED_MODULE_0__["default"])(result)) {
        left -= 1;
      } else {
        hasPlaceholder = true;
      }
      combinedIdx += 1;
    }
    return !hasPlaceholder && left <= 0 ? fn.apply(this, combined) : (0,_arity_js__WEBPACK_IMPORTED_MODULE_1__["default"])(Math.max(0, left), _curryN(length, combined, fn));
  };
}

/***/ }),

/***/ 19096:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   clearCache: () => (/* reexport safe */ _generic_index_js__WEBPACK_IMPORTED_MODULE_1__.clearCache),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _resolve_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(70240);
/* harmony import */ var _normalize_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(12757);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(50918);
/* harmony import */ var _generic_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(52398);




const openApi2Strategy = {
  name: 'openapi-2',
  match(spec) {
    return (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_2__.isOpenAPI2)(spec);
  },
  normalize(spec) {
    const {
      spec: normalized
    } = (0,_normalize_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
      spec
    });
    return normalized;
  },
  async resolve(options) {
    return (0,_resolve_js__WEBPACK_IMPORTED_MODULE_0__["default"])(options);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (openApi2Strategy);

/***/ }),

/***/ 19210:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(82598);



/**
 * Returns a lens for the given getter and setter functions. The getter "gets"
 * the value of the focus; the setter "sets" the value of the focus. The setter
 * should not mutate the data structure.
 *
 * @func
 * @memberOf R
 * @since v0.8.0
 * @category Object
 * @typedefn Lens s a = Functor f => (a -> f a) -> s -> f s
 * @sig (s -> a) -> ((a, s) -> s) -> Lens s a
 * @param {Function} getter
 * @param {Function} setter
 * @return {Lens}
 * @see R.view, R.set, R.over, R.lensIndex, R.lensProp
 * @example
 *
 *      const xLens = R.lens(R.prop('x'), R.assoc('x'));
 *
 *      R.view(xLens, {x: 1, y: 2});            //=> 1
 *      R.set(xLens, 4, {x: 1, y: 2});          //=> {x: 4, y: 2}
 *      R.over(xLens, R.negate, {x: 1, y: 2});  //=> {x: -1, y: 2}
 */
var lens = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function lens(getter, setter) {
  return function (toFunctorFn) {
    return function (target) {
      return (0,_map_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (focus) {
        return setter(focus, target);
      }, toFunctorFn(getter(target)));
    };
  };
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (lens);

/***/ }),

/***/ 19219:
/***/ ((module) => {

/**
 * Checks if a `cache` value for `key` exists.
 *
 * @private
 * @param {Object} cache The cache to query.
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function cacheHas(cache, key) {
  return cache.has(key);
}

module.exports = cacheHas;


/***/ }),

/***/ 19287:
/***/ ((module) => {

"use strict";

// iterable DOM collections
// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
module.exports = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};


/***/ }),

/***/ 19358:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var getBuiltIn = __webpack_require__(63201);
var hasOwn = __webpack_require__(49724);
var createNonEnumerableProperty = __webpack_require__(61626);
var isPrototypeOf = __webpack_require__(88280);
var setPrototypeOf = __webpack_require__(79192);
var copyConstructorProperties = __webpack_require__(19595);
var proxyAccessor = __webpack_require__(54829);
var inheritIfRequired = __webpack_require__(34084);
var normalizeStringArgument = __webpack_require__(32096);
var installErrorCause = __webpack_require__(39259);
var installErrorStack = __webpack_require__(85884);
var DESCRIPTORS = __webpack_require__(39447);
var IS_PURE = __webpack_require__(7376);

module.exports = function (FULL_NAME, wrapper, FORCED, IS_AGGREGATE_ERROR) {
  var STACK_TRACE_LIMIT = 'stackTraceLimit';
  var OPTIONS_POSITION = IS_AGGREGATE_ERROR ? 2 : 1;
  var path = FULL_NAME.split('.');
  var ERROR_NAME = path[path.length - 1];
  var OriginalError = getBuiltIn.apply(null, path);

  if (!OriginalError) return;

  var OriginalErrorPrototype = OriginalError.prototype;

  // V8 9.3- bug https://bugs.chromium.org/p/v8/issues/detail?id=12006
  if (!IS_PURE && hasOwn(OriginalErrorPrototype, 'cause')) delete OriginalErrorPrototype.cause;

  if (!FORCED) return OriginalError;

  var BaseError = getBuiltIn('Error');

  var WrappedError = wrapper(function (a, b) {
    var message = normalizeStringArgument(IS_AGGREGATE_ERROR ? b : a, undefined);
    var result = IS_AGGREGATE_ERROR ? new OriginalError(a) : new OriginalError();
    if (message !== undefined) createNonEnumerableProperty(result, 'message', message);
    installErrorStack(result, WrappedError, result.stack, 2);
    if (this && isPrototypeOf(OriginalErrorPrototype, this)) inheritIfRequired(result, this, WrappedError);
    if (arguments.length > OPTIONS_POSITION) installErrorCause(result, arguments[OPTIONS_POSITION]);
    return result;
  });

  WrappedError.prototype = OriginalErrorPrototype;

  if (ERROR_NAME !== 'Error') {
    if (setPrototypeOf) setPrototypeOf(WrappedError, BaseError);
    else copyConstructorProperties(WrappedError, BaseError, { name: true });
  } else if (DESCRIPTORS && STACK_TRACE_LIMIT in OriginalError) {
    proxyAccessor(WrappedError, OriginalError, STACK_TRACE_LIMIT);
    proxyAccessor(WrappedError, OriginalError, 'prepareStackTrace');
  }

  copyConstructorProperties(WrappedError, OriginalError);

  if (!IS_PURE) try {
    // Safari 13- bug: WebAssembly errors does not have a proper `.name`
    if (OriginalErrorPrototype.name !== ERROR_NAME) {
      createNonEnumerableProperty(OriginalErrorPrototype, 'name', ERROR_NAME);
    }
    OriginalErrorPrototype.constructor = WrappedError;
  } catch (error) { /* empty */ }

  return WrappedError;
};


/***/ }),

/***/ 19436:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77551);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(27121);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9748);
/* harmony import */ var _namespace_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(17523);



/**
 * @public
 */
/**
 * @public
 */
/**
 * @public
 */
const createToolbox = () => {
  const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.createNamespace)(_namespace_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]);
  const predicates = {
    ..._predicates_mjs__WEBPACK_IMPORTED_MODULE_2__,
    isElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isElement,
    isStringElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isStringElement,
    isArrayElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isArrayElement,
    isObjectElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isObjectElement,
    isMemberElement: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.isMemberElement,
    includesClasses: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.includesClasses,
    hasElementSourceMap: _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.hasElementSourceMap
  };
  return {
    predicates,
    namespace
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createToolbox);

/***/ }),

/***/ 19468:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseOAuthFlowsVisitor: () => (/* binding */ BaseOAuthFlowsVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(80389);


/**
 * @public
 */
const BaseOAuthFlowsVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.OAuthFlows.$visitor;
/**
 * @public
 */
class OAuthFlowsVisitor extends BaseOAuthFlowsVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_OAuthFlows_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlowsVisitor);

/***/ }),

/***/ 19595:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var hasOwn = __webpack_require__(49724);
var ownKeys = __webpack_require__(11042);
var getOwnPropertyDescriptorModule = __webpack_require__(13846);
var definePropertyModule = __webpack_require__(74284);

module.exports = function (target, source, exceptions) {
  var keys = ownKeys(source);
  var defineProperty = definePropertyModule.f;
  var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    if (!hasOwn(target, key) && !(exceptions && hasOwn(exceptions, key))) {
      defineProperty(target, key, getOwnPropertyDescriptor(source, key));
    }
  }
};


/***/ }),

/***/ 19846:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

/* eslint-disable es/no-symbol -- required for testing */
var V8_VERSION = __webpack_require__(20798);
var fails = __webpack_require__(98828);
var globalThis = __webpack_require__(45951);

var $String = globalThis.String;

// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
module.exports = !!Object.getOwnPropertySymbols && !fails(function () {
  var symbol = Symbol('symbol detection');
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  // nb: Do not call `String` directly to avoid this being optimized out to `symbol+''` which will,
  // of course, fail.
  return !$String(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION && V8_VERSION < 41;
});


/***/ }),

/***/ 19950:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   mutationReplacer: () => (/* binding */ mutationReplacer)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(95201);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(10796);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(51520);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43319);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86349);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(77259);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(1908);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(50286);
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(16401);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(62708);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(61906);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(39633);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(51295);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(45259);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(8302);
/* harmony import */ var _selectors_$anchor_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(70948);
/* harmony import */ var _selectors_uri_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(72149);
/* harmony import */ var _errors_MaximumDereferenceDepthError_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(7699);
/* harmony import */ var _errors_MaximumResolveDepthError_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99139);
/* harmony import */ var _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(96664);
/* harmony import */ var _parse_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(1650);
/* harmony import */ var _Reference_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(83561);
/* harmony import */ var _File_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(38396);
/* harmony import */ var _util_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(35484);
/* harmony import */ var _util_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34306);
/* harmony import */ var _errors_EvaluationJsonSchemaUriError_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(83915);

















// @ts-ignore
const visitAsync = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.visit[Symbol.for('nodejs.util.promisify.custom')];

// initialize element identity manager
const identityManager = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.IdentityManager();

/**
 * Custom mutation replacer.
 * @public
 */
const mutationReplacer = (newElement, oldElement, key, parent) => {
  if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isMemberElement)(parent)) {
    parent.value = newElement; // eslint-disable-line no-param-reassign
  } else if (Array.isArray(parent)) {
    parent[key] = newElement; // eslint-disable-line no-param-reassign
  }
};

/**
 * @public
 */

/**
 * @public
 */
class OpenAPI3_1DereferenceVisitor {
  indirections;
  namespace;
  reference;
  options;
  ancestors;
  refractCache;
  constructor({
    reference,
    namespace,
    options,
    indirections = [],
    ancestors = new _util_mjs__WEBPACK_IMPORTED_MODULE_3__.AncestorLineage(),
    refractCache = new Map()
  }) {
    this.indirections = indirections;
    this.namespace = namespace;
    this.reference = reference;
    this.options = options;
    this.ancestors = new _util_mjs__WEBPACK_IMPORTED_MODULE_3__.AncestorLineage(...ancestors);
    this.refractCache = refractCache;
  }
  toBaseURI(uri) {
    return _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.resolve(this.reference.uri, _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.sanitize(_util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(uri)));
  }
  async toReference(uri) {
    // detect maximum depth of resolution
    if (this.reference.depth >= this.options.resolve.maxDepth) {
      throw new _errors_MaximumResolveDepthError_mjs__WEBPACK_IMPORTED_MODULE_5__["default"](`Maximum resolution depth of ${this.options.resolve.maxDepth} has been exceeded by file "${this.reference.uri}"`);
    }
    const baseURI = this.toBaseURI(uri);
    const {
      refSet
    } = this.reference;

    // we've already processed this Reference in past
    if (refSet.has(baseURI)) {
      return refSet.find((0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])(baseURI, 'uri'));
    }
    const parseResult = await (0,_parse_index_mjs__WEBPACK_IMPORTED_MODULE_7__["default"])(_util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.unsanitize(baseURI), {
      ...this.options,
      parse: {
        ...this.options.parse,
        mediaType: 'text/plain'
      }
    });

    // register new mutable reference with a refSet
    const mutableReference = new _Reference_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]({
      uri: baseURI,
      value: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(parseResult),
      depth: this.reference.depth + 1
    });
    refSet.add(mutableReference);
    if (this.options.dereference.immutable) {
      // register new immutable reference with a refSet
      const immutableReference = new _Reference_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]({
        uri: `immutable://${baseURI}`,
        value: parseResult,
        depth: this.reference.depth + 1
      });
      refSet.add(immutableReference);
    }
    return mutableReference;
  }
  toAncestorLineage(ancestors) {
    /**
     * Compute full ancestors lineage.
     * Ancestors are flatten to unwrap all Element instances.
     */
    const directAncestors = new Set(ancestors.filter(_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isElement));
    const ancestorsLineage = new _util_mjs__WEBPACK_IMPORTED_MODULE_3__.AncestorLineage(...this.ancestors, directAncestors);
    return [ancestorsLineage, directAncestors];
  }
  async ReferenceElement(referencingElement, key, parent, path, ancestors, link) {
    // skip current referencing element as it's already been access
    if (this.indirections.includes(referencingElement)) {
      return false;
    }
    const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);
    const retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref));
    const isInternalReference = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(this.reference.uri) === retrievalURI;
    const isExternalReference = !isInternalReference;

    // ignore resolving internal Reference Objects
    if (!this.options.resolve.internal && isInternalReference) {
      // skip traversing this reference element and all it's child elements
      return false;
    }
    // ignore resolving external Reference Objects
    if (!this.options.resolve.external && isExternalReference) {
      // skip traversing this reference element and all it's child elements
      return false;
    }
    const reference = await this.toReference((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref));
    const $refBaseURI = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.resolve(retrievalURI, (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref));
    this.indirections.push(referencingElement);
    const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_11__.uriToPointer)($refBaseURI);

    // possibly non-semantic fragment
    let referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_12__["default"])(jsonPointer, reference.value.result);
    referencedElement.id = identityManager.identify(referencedElement);

    // applying semantics to a fragment
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isPrimitiveElement)(referencedElement)) {
      const referencedElementType = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.meta.get('referenced-element'));
      const cacheKey = `${referencedElementType}-${(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(identityManager.identify(referencedElement))}`;
      if (this.refractCache.has(cacheKey)) {
        referencedElement = this.refractCache.get(cacheKey);
      } else if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_13__.isReferenceLikeElement)(referencedElement)) {
        // handling indirect references
        referencedElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.ReferenceElement.refract(referencedElement);
        referencedElement.setMetaProperty('referenced-element', referencedElementType);
        this.refractCache.set(cacheKey, referencedElement);
      } else {
        // handling direct references
        const ElementClass = this.namespace.getElementClass(referencedElementType);
        referencedElement = ElementClass.refract(referencedElement);
        this.refractCache.set(cacheKey, referencedElement);
      }
    }

    // detect direct or indirect reference
    if (referencingElement === referencedElement) {
      throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__["default"]('Recursive Reference Object detected');
    }

    // detect maximum depth of dereferencing
    if (this.indirections.length > this.options.dereference.maxDepth) {
      throw new _errors_MaximumDereferenceDepthError_mjs__WEBPACK_IMPORTED_MODULE_16__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
    }

    // detect second deep dive into the same fragment and avoid it
    if (ancestorsLineage.includes(referencedElement)) {
      reference.refSet.circular = true;
      if (this.options.dereference.circular === 'error') {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__["default"]('Circular reference detected');
      } else if (this.options.dereference.circular === 'replace') {
        var _this$options$derefer, _this$options$derefer2;
        const refElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.RefElement(referencedElement.id, {
          type: 'reference',
          uri: reference.uri,
          $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref)
        });
        const replacer = (_this$options$derefer = (_this$options$derefer2 = this.options.dereference.strategyOpts['openapi-3-1']) === null || _this$options$derefer2 === void 0 ? void 0 : _this$options$derefer2.circularReplacer) !== null && _this$options$derefer !== void 0 ? _this$options$derefer : this.options.dereference.circularReplacer;
        const replacement = replacer(refElement);
        link.replaceWith(replacement, mutationReplacer);
        return !parent ? replacement : false;
      }
    }

    /**
     * Dive deep into the fragment.
     *
     * Cases to consider:
     *  1. We're crossing document boundary
     *  2. Fragment is from non-root document
     *  3. Fragment is a Reference Object. We need to follow it to get the eventual value
     *  4. We are dereferencing the fragment lazily/eagerly depending on circular mode
     */
    const isNonRootDocument = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(reference.refSet.rootRef.uri) !== reference.uri;
    const shouldDetectCircular = ['error', 'replace'].includes(this.options.dereference.circular);
    if ((isExternalReference || isNonRootDocument || (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__.isReferenceElement)(referencedElement) || shouldDetectCircular) && !ancestorsLineage.includesCycle(referencedElement)) {
      // append referencing reference to ancestors lineage
      directAncestors.add(referencingElement);
      const visitor = new OpenAPI3_1DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        refractCache: this.refractCache,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.keyMap,
        nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.getNodeType
      });

      // remove referencing reference from ancestors lineage
      directAncestors.delete(referencingElement);
    }
    this.indirections.pop();

    /**
     * Creating a new version of referenced element to avoid modifying the original one.
     */
    const mergedElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneShallow)(referencedElement);
    // assign unique id to merged element
    mergedElement.setMetaProperty('id', identityManager.generateId());
    // annotate fragment with info about original Reference element
    mergedElement.setMetaProperty('ref-fields', {
      $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref),
      // @ts-ignore
      description: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.description),
      // @ts-ignore
      summary: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.summary)
    });
    // annotate fragment with info about origin
    mergedElement.setMetaProperty('ref-origin', reference.uri);
    // annotate fragment with info about referencing element
    mergedElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(identityManager.identify(referencingElement)));

    // override description and summary (outer has higher priority then inner)
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(referencedElement) && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isObjectElement)(mergedElement)) {
      if (referencingElement.hasKey('description') && 'description' in referencedElement) {
        mergedElement.remove('description');
        mergedElement.set('description', referencingElement.get('description'));
      }
      if (referencingElement.hasKey('summary') && 'summary' in referencedElement) {
        mergedElement.remove('summary');
        mergedElement.set('summary', referencingElement.get('summary'));
      }
    }

    /**
     * Transclude referencing element with merged referenced element.
     */
    link.replaceWith(mergedElement, mutationReplacer);

    /**
     * We're at the root of the tree, so we're just replacing the entire tree.
     */
    return !parent ? mergedElement : false;
  }
  async PathItemElement(referencingElement, key, parent, path, ancestors, link) {
    // ignore PathItemElement without $ref field
    if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(referencingElement.$ref)) {
      return undefined;
    }

    // skip current referencing element as it's already been access
    if (this.indirections.includes(referencingElement)) {
      return false;
    }
    const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);
    const retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref));
    const isInternalReference = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(this.reference.uri) === retrievalURI;
    const isExternalReference = !isInternalReference;

    // ignore resolving external Path Item Objects
    if (!this.options.resolve.internal && isInternalReference) {
      // skip traversing this Path Item element but traverse all it's child elements
      return undefined;
    }
    // ignore resolving external Path Item Objects
    if (!this.options.resolve.external && isExternalReference) {
      // skip traversing this Path Item element but traverse all it's child elements
      return undefined;
    }
    const reference = await this.toReference((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref));
    const $refBaseURI = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.resolve(retrievalURI, (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref));
    this.indirections.push(referencingElement);
    const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_11__.uriToPointer)($refBaseURI);

    // possibly non-semantic referenced element
    let referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_12__["default"])(jsonPointer, reference.value.result);
    referencedElement.id = identityManager.identify(referencedElement);

    /**
     * Applying semantics to a referenced element if semantics are missing.
     */
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isPrimitiveElement)(referencedElement)) {
      const cacheKey = `path-item-${(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(identityManager.identify(referencedElement))}`;
      if (this.refractCache.has(cacheKey)) {
        referencedElement = this.refractCache.get(cacheKey);
      } else {
        referencedElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.PathItemElement.refract(referencedElement);
        this.refractCache.set(cacheKey, referencedElement);
      }
    }

    // detect direct or indirect reference
    if (referencingElement === referencedElement) {
      throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__["default"]('Recursive Path Item Object reference detected');
    }

    // detect maximum depth of dereferencing
    if (this.indirections.length > this.options.dereference.maxDepth) {
      throw new _errors_MaximumDereferenceDepthError_mjs__WEBPACK_IMPORTED_MODULE_16__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
    }

    // detect second deep dive into the same fragment and avoid it
    if (ancestorsLineage.includes(referencedElement)) {
      reference.refSet.circular = true;
      if (this.options.dereference.circular === 'error') {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__["default"]('Circular reference detected');
      } else if (this.options.dereference.circular === 'replace') {
        var _this$options$derefer3, _this$options$derefer4;
        const refElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.RefElement(referencedElement.id, {
          type: 'path-item',
          uri: reference.uri,
          $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref)
        });
        const replacer = (_this$options$derefer3 = (_this$options$derefer4 = this.options.dereference.strategyOpts['openapi-3-1']) === null || _this$options$derefer4 === void 0 ? void 0 : _this$options$derefer4.circularReplacer) !== null && _this$options$derefer3 !== void 0 ? _this$options$derefer3 : this.options.dereference.circularReplacer;
        const replacement = replacer(refElement);
        link.replaceWith(replacement, mutationReplacer);
        return !parent ? replacement : false;
      }
    }

    /**
     * Dive deep into the fragment.
     *
     * Cases to consider:
     *  1. We're crossing document boundary
     *  2. Fragment is from non-root document
     *  3. Fragment is a Path Item Object with $ref field. We need to follow it to get the eventual value
     *  4. We are dereferencing the fragment lazily/eagerly depending on circular mode
     */
    const isNonRootDocument = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(reference.refSet.rootRef.uri) !== reference.uri;
    const shouldDetectCircular = ['error', 'replace'].includes(this.options.dereference.circular);
    if ((isExternalReference || isNonRootDocument || (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__.isPathItemElement)(referencedElement) && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(referencedElement.$ref) || shouldDetectCircular) && !ancestorsLineage.includesCycle(referencedElement)) {
      // append referencing reference to ancestors lineage
      directAncestors.add(referencingElement);
      const visitor = new OpenAPI3_1DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        refractCache: this.refractCache,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.keyMap,
        nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.getNodeType
      });

      // remove referencing reference from ancestors lineage
      directAncestors.delete(referencingElement);
    }
    this.indirections.pop();

    /**
     * Creating a new version of Path Item by merging fields from referenced Path Item with referencing one.
     */
    if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__.isPathItemElement)(referencedElement)) {
      const mergedElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.PathItemElement([...referencedElement.content], (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(referencedElement.meta), (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(referencedElement.attributes));
      // assign unique id to merged element
      mergedElement.setMetaProperty('id', identityManager.generateId());
      // existing keywords from referencing PathItemElement overrides ones from referenced element
      referencingElement.forEach((value, keyElement, item) => {
        mergedElement.remove((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(keyElement));
        mergedElement.content.push(item);
      });
      mergedElement.remove('$ref');

      // annotate referenced element with info about original referencing element
      mergedElement.setMetaProperty('ref-fields', {
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref)
      });
      // annotate referenced element with info about origin
      mergedElement.setMetaProperty('ref-origin', reference.uri);
      // annotate fragment with info about referencing element
      mergedElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(identityManager.identify(referencingElement)));
      referencedElement = mergedElement;
    }

    /**
     * Transclude referencing element with merged referenced element.
     */
    link.replaceWith(referencedElement, mutationReplacer);

    /**
     * We're at the root of the tree, so we're just replacing the entire tree.
     */
    return !parent ? referencedElement : undefined;
  }
  async LinkElement(linkElement, key, parent, path, ancestors, link) {
    // ignore LinkElement without operationRef or operationId field
    if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(linkElement.operationRef) && !(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(linkElement.operationId)) {
      return undefined;
    }

    // operationRef and operationId fields are mutually exclusive
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(linkElement.operationRef) && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(linkElement.operationId)) {
      throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__["default"]('LinkElement operationRef and operationId fields are mutually exclusive.');
    }
    let operationElement;
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(linkElement.operationRef)) {
      var _linkElementCopy$oper;
      // possibly non-semantic referenced element
      const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_11__.uriToPointer)((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(linkElement.operationRef));
      const retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(linkElement.operationRef));
      const isInternalReference = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(this.reference.uri) === retrievalURI;
      const isExternalReference = !isInternalReference;

      // ignore resolving internal Operation Object reference
      if (!this.options.resolve.internal && isInternalReference) {
        // skip traversing this Link element but traverse all it's child elements
        return undefined;
      }
      // ignore resolving external Operation Object reference
      if (!this.options.resolve.external && isExternalReference) {
        // skip traversing this Link element but traverse all it's child elements
        return undefined;
      }
      const reference = await this.toReference((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(linkElement.operationRef));
      operationElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_12__["default"])(jsonPointer, reference.value.result);
      // applying semantics to a referenced element
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isPrimitiveElement)(operationElement)) {
        const cacheKey = `operation-${(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(identityManager.identify(operationElement))}`;
        if (this.refractCache.has(cacheKey)) {
          operationElement = this.refractCache.get(cacheKey);
        } else {
          operationElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.OperationElement.refract(operationElement);
          this.refractCache.set(cacheKey, operationElement);
        }
      }
      // create shallow clone to be able to annotate with metadata
      operationElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneShallow)(operationElement);
      // annotate operation element with info about origin
      operationElement.setMetaProperty('ref-origin', reference.uri);
      const linkElementCopy = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneShallow)(linkElement);
      (_linkElementCopy$oper = linkElementCopy.operationRef) === null || _linkElementCopy$oper === void 0 || _linkElementCopy$oper.meta.set('operation', operationElement);

      /**
       * Transclude Link Object containing Operation Object in its meta.
       */
      link.replaceWith(linkElementCopy, mutationReplacer);

      /**
       * We're at the root of the tree, so we're just replacing the entire tree.
       */
      return !parent ? linkElementCopy : undefined;
    }
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(linkElement.operationId)) {
      var _linkElementCopy$oper2;
      const operationId = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(linkElement.operationId);
      const reference = await this.toReference(_util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.unsanitize(this.reference.uri));
      operationElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_20__["default"])(e => (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__.isOperationElement)(e) && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isElement)(e.operationId) && e.operationId.equals(operationId), reference.value.result);
      // OperationElement not found by its operationId
      if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_21__["default"])(operationElement)) {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__["default"](`OperationElement(operationId=${operationId}) not found.`);
      }
      const linkElementCopy = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneShallow)(linkElement);
      (_linkElementCopy$oper2 = linkElementCopy.operationId) === null || _linkElementCopy$oper2 === void 0 || _linkElementCopy$oper2.meta.set('operation', operationElement);

      /**
       * Transclude Link Object containing Operation Object in its meta.
       */
      link.replaceWith(linkElementCopy, mutationReplacer);

      /**
       * We're at the root of the tree, so we're just replacing the entire tree.
       */
      return !parent ? linkElementCopy : undefined;
    }
    return undefined;
  }
  async ExampleElement(exampleElement, key, parent, path, ancestors, link) {
    // ignore ExampleElement without externalValue field
    if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(exampleElement.externalValue)) {
      return undefined;
    }

    // value and externalValue fields are mutually exclusive
    if (exampleElement.hasKey('value') && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(exampleElement.externalValue)) {
      throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__["default"]('ExampleElement value and externalValue fields are mutually exclusive.');
    }
    const retrievalURI = this.toBaseURI((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(exampleElement.externalValue));
    const isInternalReference = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(this.reference.uri) === retrievalURI;
    const isExternalReference = !isInternalReference;

    // ignore resolving internal Example Objects
    if (!this.options.resolve.internal && isInternalReference) {
      // skip traversing this Example element but traverse all it's child elements
      return undefined;
    }
    // ignore resolving external Example Objects
    if (!this.options.resolve.external && isExternalReference) {
      // skip traversing this Example element but traverse all it's child elements
      return undefined;
    }
    const reference = await this.toReference((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(exampleElement.externalValue));

    // shallow clone of the referenced element
    const valueElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneShallow)(reference.value.result);
    // annotate operation element with info about origin
    valueElement.setMetaProperty('ref-origin', reference.uri);
    const exampleElementCopy = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneShallow)(exampleElement);
    exampleElementCopy.value = valueElement;

    /**
     * Transclude Example Object containing external value.
     */
    link.replaceWith(exampleElementCopy, mutationReplacer);

    /**
     * We're at the root of the tree, so we're just replacing the entire tree.
     */
    return !parent ? exampleElementCopy : undefined;
  }
  async SchemaElement(referencingElement, key, parent, path, ancestors, link) {
    // skip current referencing schema as $ref keyword was not defined
    if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(referencingElement.$ref)) {
      return undefined;
    }

    // skip current referencing element as it's already been access
    if (this.indirections.includes(referencingElement)) {
      return false;
    }
    const [ancestorsLineage, directAncestors] = this.toAncestorLineage([...ancestors, parent]);

    // compute baseURI using rules around $id and $ref keywords
    let reference = await this.toReference(_util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.unsanitize(this.reference.uri));
    let {
      uri: retrievalURI
    } = reference;
    const $refBaseURI = (0,_util_mjs__WEBPACK_IMPORTED_MODULE_22__.resolveSchema$refField)(retrievalURI, referencingElement);
    const $refBaseURIStrippedHash = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash($refBaseURI);
    const file = new _File_mjs__WEBPACK_IMPORTED_MODULE_23__["default"]({
      uri: $refBaseURIStrippedHash
    });
    const isUnknownURI = (0,ramda__WEBPACK_IMPORTED_MODULE_24__["default"])(r => r.canRead(file), this.options.resolve.resolvers);
    const isURL = !isUnknownURI;
    let isInternalReference = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(this.reference.uri) === $refBaseURI;
    let isExternalReference = !isInternalReference;
    this.indirections.push(referencingElement);

    // determining reference, proper evaluation and selection mechanism
    let referencedElement;
    try {
      if (isUnknownURI || isURL) {
        // we're dealing with canonical URI or URL with possible fragment
        retrievalURI = this.toBaseURI($refBaseURI);
        const selector = $refBaseURI;
        const referenceAsSchema = (0,_util_mjs__WEBPACK_IMPORTED_MODULE_22__.maybeRefractToSchemaElement)(reference.value.result);
        referencedElement = (0,_selectors_uri_mjs__WEBPACK_IMPORTED_MODULE_25__.evaluate)(selector, referenceAsSchema);
        referencedElement = (0,_util_mjs__WEBPACK_IMPORTED_MODULE_22__.maybeRefractToSchemaElement)(referencedElement);
        referencedElement.id = identityManager.identify(referencedElement);

        // ignore resolving internal Schema Objects
        if (!this.options.resolve.internal && isInternalReference) {
          // skip traversing this schema element but traverse all it's child elements
          return undefined;
        }
        // ignore resolving external Schema Objects
        if (!this.options.resolve.external && isExternalReference) {
          // skip traversing this schema element but traverse all it's child elements
          return undefined;
        }
      } else {
        // we're assuming here that we're dealing with JSON Pointer here
        retrievalURI = this.toBaseURI($refBaseURI);
        isInternalReference = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(this.reference.uri) === retrievalURI;
        isExternalReference = !isInternalReference;

        // ignore resolving internal Schema Objects
        if (!this.options.resolve.internal && isInternalReference) {
          // skip traversing this schema element but traverse all it's child elements
          return undefined;
        }
        // ignore resolving external Schema Objects
        if (!this.options.resolve.external && isExternalReference) {
          // skip traversing this schema element but traverse all it's child elements
          return undefined;
        }
        reference = await this.toReference(_util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.unsanitize($refBaseURI));
        const selector = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_11__.uriToPointer)($refBaseURI);
        const referenceAsSchema = (0,_util_mjs__WEBPACK_IMPORTED_MODULE_22__.maybeRefractToSchemaElement)(reference.value.result);
        referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_12__["default"])(selector, referenceAsSchema);
        referencedElement = (0,_util_mjs__WEBPACK_IMPORTED_MODULE_22__.maybeRefractToSchemaElement)(referencedElement);
        referencedElement.id = identityManager.identify(referencedElement);
      }
    } catch (error) {
      /**
       * No SchemaElement($id=URL) was not found, so we're going to try to resolve
       * the URL and assume the returned response is a JSON Schema.
       */
      if (isURL && error instanceof _errors_EvaluationJsonSchemaUriError_mjs__WEBPACK_IMPORTED_MODULE_26__["default"]) {
        if ((0,_selectors_$anchor_mjs__WEBPACK_IMPORTED_MODULE_27__.isAnchor)((0,_selectors_$anchor_mjs__WEBPACK_IMPORTED_MODULE_27__.uriToAnchor)($refBaseURI))) {
          // we're dealing with JSON Schema $anchor here
          isInternalReference = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(this.reference.uri) === retrievalURI;
          isExternalReference = !isInternalReference;

          // ignore resolving internal Schema Objects
          if (!this.options.resolve.internal && isInternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          // ignore resolving external Schema Objects
          if (!this.options.resolve.external && isExternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          reference = await this.toReference(_util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.unsanitize($refBaseURI));
          const selector = (0,_selectors_$anchor_mjs__WEBPACK_IMPORTED_MODULE_27__.uriToAnchor)($refBaseURI);
          const referenceAsSchema = (0,_util_mjs__WEBPACK_IMPORTED_MODULE_22__.maybeRefractToSchemaElement)(reference.value.result);
          referencedElement = (0,_selectors_$anchor_mjs__WEBPACK_IMPORTED_MODULE_27__.evaluate)(selector, referenceAsSchema);
          referencedElement = (0,_util_mjs__WEBPACK_IMPORTED_MODULE_22__.maybeRefractToSchemaElement)(referencedElement);
          referencedElement.id = identityManager.identify(referencedElement);
        } else {
          // we're assuming here that we're dealing with JSON Pointer here
          retrievalURI = this.toBaseURI($refBaseURI);
          isInternalReference = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(this.reference.uri) === retrievalURI;
          isExternalReference = !isInternalReference;

          // ignore resolving internal Schema Objects
          if (!this.options.resolve.internal && isInternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          // ignore resolving external Schema Objects
          if (!this.options.resolve.external && isExternalReference) {
            // skip traversing this schema element but traverse all it's child elements
            return undefined;
          }
          reference = await this.toReference(_util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.unsanitize($refBaseURI));
          const selector = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_11__.uriToPointer)($refBaseURI);
          const referenceAsSchema = (0,_util_mjs__WEBPACK_IMPORTED_MODULE_22__.maybeRefractToSchemaElement)(reference.value.result);
          referencedElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_12__["default"])(selector, referenceAsSchema);
          referencedElement = (0,_util_mjs__WEBPACK_IMPORTED_MODULE_22__.maybeRefractToSchemaElement)(referencedElement);
          referencedElement.id = identityManager.identify(referencedElement);
        }
      } else {
        throw error;
      }
    }

    // detect direct or indirect reference
    if (referencingElement === referencedElement) {
      throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__["default"]('Recursive Schema Object reference detected');
    }

    // detect maximum depth of dereferencing
    if (this.indirections.length > this.options.dereference.maxDepth) {
      throw new _errors_MaximumDereferenceDepthError_mjs__WEBPACK_IMPORTED_MODULE_16__["default"](`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);
    }

    // detect second deep dive into the same fragment and avoid it
    if (ancestorsLineage.includes(referencedElement)) {
      reference.refSet.circular = true;
      if (this.options.dereference.circular === 'error') {
        throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_15__["default"]('Circular reference detected');
      } else if (this.options.dereference.circular === 'replace') {
        var _this$options$derefer5, _this$options$derefer6;
        const refElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_17__.RefElement(referencedElement.id, {
          type: 'json-schema',
          uri: reference.uri,
          $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref)
        });
        const replacer = (_this$options$derefer5 = (_this$options$derefer6 = this.options.dereference.strategyOpts['openapi-3-1']) === null || _this$options$derefer6 === void 0 ? void 0 : _this$options$derefer6.circularReplacer) !== null && _this$options$derefer5 !== void 0 ? _this$options$derefer5 : this.options.dereference.circularReplacer;
        const replacement = replacer(refElement);
        link.replaceWith(replacement, mutationReplacer);
        return !parent ? replacement : false;
      }
    }

    /**
     * Dive deep into the fragment.
     *
     * Cases to consider:
     *  1. We're crossing document boundary
     *  2. Fragment is from non-root document
     *  3. Fragment is a Schema Object with $ref field. We need to follow it to get the eventual value
     *  4. We are dereferencing the fragment lazily/eagerly depending on circular mode
     */
    const isNonRootDocument = _util_url_mjs__WEBPACK_IMPORTED_MODULE_4__.stripHash(reference.refSet.rootRef.uri) !== reference.uri;
    const shouldDetectCircular = ['error', 'replace'].includes(this.options.dereference.circular);
    if ((isExternalReference || isNonRootDocument || (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__.isSchemaElement)(referencedElement) && (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.isStringElement)(referencedElement.$ref) || shouldDetectCircular) && !ancestorsLineage.includesCycle(referencedElement)) {
      // append referencing reference to ancestors lineage
      directAncestors.add(referencingElement);
      const visitor = new OpenAPI3_1DereferenceVisitor({
        reference,
        namespace: this.namespace,
        indirections: [...this.indirections],
        options: this.options,
        refractCache: this.refractCache,
        ancestors: ancestorsLineage
      });
      referencedElement = await visitAsync(referencedElement, visitor, {
        keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.keyMap,
        nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__.getNodeType
      });

      // remove referencing reference from ancestors lineage
      directAncestors.delete(referencingElement);
    }
    this.indirections.pop();

    // Boolean JSON Schemas
    if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__.isBooleanJsonSchemaElement)(referencedElement)) {
      const booleanJsonSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(referencedElement);
      // assign unique id to merged element
      booleanJsonSchemaElement.setMetaProperty('id', identityManager.generateId());
      // annotate referenced element with info about original referencing element
      booleanJsonSchemaElement.setMetaProperty('ref-fields', {
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref)
      });
      // annotate referenced element with info about origin
      booleanJsonSchemaElement.setMetaProperty('ref-origin', reference.uri);
      // annotate fragment with info about referencing element
      booleanJsonSchemaElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(identityManager.identify(referencingElement)));
      link.replaceWith(booleanJsonSchemaElement, mutationReplacer);
      return !parent ? booleanJsonSchemaElement : false;
    }

    /**
     * Creating a new version of Schema Object by merging fields from referenced Schema Object with referencing one.
     */
    if ((0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__.isSchemaElement)(referencedElement)) {
      const mergedElement = new _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_14__.SchemaElement([...referencedElement.content], (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(referencedElement.meta), (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(referencedElement.attributes));
      // assign unique id to merged element
      mergedElement.setMetaProperty('id', identityManager.generateId());
      // existing keywords from referencing schema overrides ones from referenced schema
      referencingElement.forEach((value, keyElement, item) => {
        mergedElement.remove((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(keyElement));
        mergedElement.content.push(item);
      });
      mergedElement.remove('$ref');
      // annotate referenced element with info about original referencing element
      mergedElement.setMetaProperty('ref-fields', {
        $ref: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__["default"])(referencingElement.$ref)
      });
      // annotate fragment with info about origin
      mergedElement.setMetaProperty('ref-origin', reference.uri);
      // annotate fragment with info about referencing element
      mergedElement.setMetaProperty('ref-referencing-element-id', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(identityManager.identify(referencingElement)));
      referencedElement = mergedElement;
    }
    /**
     * Transclude referencing element with merged referenced element.
     */
    link.replaceWith(referencedElement, mutationReplacer);

    /**
     * We're at the root of the tree, so we're just replacing the entire tree.
     */
    return !parent ? referencedElement : undefined;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenAPI3_1DereferenceVisitor);

/***/ }),

/***/ 19982:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class ComponentsPathItems extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'components-path-items';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(ComponentsPathItems.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ComponentsPathItems);

/***/ }),

/***/ 20071:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apg_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16646);

const serverUrlTemplate = (state, chars, phraseIndex, phraseLength, data) => {
  if (state === apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_PRE) {
    if (Array.isArray(data) === false) {
      throw new Error("parser's user data must be an array");
    }
    data.push(['server-url-template', apg_lite__WEBPACK_IMPORTED_MODULE_0__.utilities.charsToString(chars, phraseIndex, phraseLength)]);
  }
  return apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_OK;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (serverUrlTemplate);

/***/ }),

/***/ 20207:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(18191);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);





/**
 * @public
 */
/**
 * @public
 */
class SecuritySchemeVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_SecurityScheme_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'SecurityScheme']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecuritySchemeVisitor);

/***/ }),

/***/ 20317:
/***/ ((module) => {

/**
 * Converts `map` to its key-value pairs.
 *
 * @private
 * @param {Object} map The map to convert.
 * @returns {Array} Returns the key-value pairs.
 */
function mapToArray(map) {
  var index = -1,
      result = Array(map.size);

  map.forEach(function(value, key) {
    result[++index] = [key, value];
  });
  return result;
}

module.exports = mapToArray;


/***/ }),

/***/ 20378:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isJSONSchemaElement: () => (/* binding */ isJSONSchemaElement),
/* harmony export */   isLinkDescriptionElement: () => (/* binding */ isLinkDescriptionElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46902);
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25789);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(88172);



/**
 * @public
 */
const isJSONSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__["default"] || hasBasicElementProps(element) && isElementType('JSONSchema202012', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isLinkDescriptionElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('linkDescription', element) && primitiveEq('object', element);
});

/***/ }),

/***/ 20382:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CORE_SCHEMA: () => (/* binding */ CORE_SCHEMA),
/* harmony export */   DEFAULT_SCHEMA: () => (/* binding */ DEFAULT_SCHEMA),
/* harmony export */   FAILSAFE_SCHEMA: () => (/* binding */ FAILSAFE_SCHEMA),
/* harmony export */   JSON_SCHEMA: () => (/* binding */ JSON_SCHEMA),
/* harmony export */   Schema: () => (/* binding */ Schema),
/* harmony export */   Type: () => (/* binding */ Type),
/* harmony export */   YAMLException: () => (/* binding */ YAMLException),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   dump: () => (/* binding */ dump),
/* harmony export */   load: () => (/* binding */ load),
/* harmony export */   loadAll: () => (/* binding */ loadAll),
/* harmony export */   safeDump: () => (/* binding */ safeDump),
/* harmony export */   safeLoad: () => (/* binding */ safeLoad),
/* harmony export */   safeLoadAll: () => (/* binding */ safeLoadAll),
/* harmony export */   types: () => (/* binding */ types)
/* harmony export */ });

/*! js-yaml 4.1.0 https://github.com/nodeca/js-yaml @license MIT */
function isNothing(subject) {
  return (typeof subject === 'undefined') || (subject === null);
}


function isObject(subject) {
  return (typeof subject === 'object') && (subject !== null);
}


function toArray(sequence) {
  if (Array.isArray(sequence)) return sequence;
  else if (isNothing(sequence)) return [];

  return [ sequence ];
}


function extend(target, source) {
  var index, length, key, sourceKeys;

  if (source) {
    sourceKeys = Object.keys(source);

    for (index = 0, length = sourceKeys.length; index < length; index += 1) {
      key = sourceKeys[index];
      target[key] = source[key];
    }
  }

  return target;
}


function repeat(string, count) {
  var result = '', cycle;

  for (cycle = 0; cycle < count; cycle += 1) {
    result += string;
  }

  return result;
}


function isNegativeZero(number) {
  return (number === 0) && (Number.NEGATIVE_INFINITY === 1 / number);
}


var isNothing_1      = isNothing;
var isObject_1       = isObject;
var toArray_1        = toArray;
var repeat_1         = repeat;
var isNegativeZero_1 = isNegativeZero;
var extend_1         = extend;

var common = {
	isNothing: isNothing_1,
	isObject: isObject_1,
	toArray: toArray_1,
	repeat: repeat_1,
	isNegativeZero: isNegativeZero_1,
	extend: extend_1
};

// YAML error class. http://stackoverflow.com/questions/8458984


function formatError(exception, compact) {
  var where = '', message = exception.reason || '(unknown reason)';

  if (!exception.mark) return message;

  if (exception.mark.name) {
    where += 'in "' + exception.mark.name + '" ';
  }

  where += '(' + (exception.mark.line + 1) + ':' + (exception.mark.column + 1) + ')';

  if (!compact && exception.mark.snippet) {
    where += '\n\n' + exception.mark.snippet;
  }

  return message + ' ' + where;
}


function YAMLException$1(reason, mark) {
  // Super constructor
  Error.call(this);

  this.name = 'YAMLException';
  this.reason = reason;
  this.mark = mark;
  this.message = formatError(this, false);

  // Include stack trace in error object
  if (Error.captureStackTrace) {
    // Chrome and NodeJS
    Error.captureStackTrace(this, this.constructor);
  } else {
    // FF, IE 10+ and Safari 6+. Fallback for others
    this.stack = (new Error()).stack || '';
  }
}


// Inherit from Error
YAMLException$1.prototype = Object.create(Error.prototype);
YAMLException$1.prototype.constructor = YAMLException$1;


YAMLException$1.prototype.toString = function toString(compact) {
  return this.name + ': ' + formatError(this, compact);
};


var exception = YAMLException$1;

// get snippet for a single line, respecting maxLength
function getLine(buffer, lineStart, lineEnd, position, maxLineLength) {
  var head = '';
  var tail = '';
  var maxHalfLength = Math.floor(maxLineLength / 2) - 1;

  if (position - lineStart > maxHalfLength) {
    head = ' ... ';
    lineStart = position - maxHalfLength + head.length;
  }

  if (lineEnd - position > maxHalfLength) {
    tail = ' ...';
    lineEnd = position + maxHalfLength - tail.length;
  }

  return {
    str: head + buffer.slice(lineStart, lineEnd).replace(/\t/g, '→') + tail,
    pos: position - lineStart + head.length // relative position
  };
}


function padStart(string, max) {
  return common.repeat(' ', max - string.length) + string;
}


function makeSnippet(mark, options) {
  options = Object.create(options || null);

  if (!mark.buffer) return null;

  if (!options.maxLength) options.maxLength = 79;
  if (typeof options.indent      !== 'number') options.indent      = 1;
  if (typeof options.linesBefore !== 'number') options.linesBefore = 3;
  if (typeof options.linesAfter  !== 'number') options.linesAfter  = 2;

  var re = /\r?\n|\r|\0/g;
  var lineStarts = [ 0 ];
  var lineEnds = [];
  var match;
  var foundLineNo = -1;

  while ((match = re.exec(mark.buffer))) {
    lineEnds.push(match.index);
    lineStarts.push(match.index + match[0].length);

    if (mark.position <= match.index && foundLineNo < 0) {
      foundLineNo = lineStarts.length - 2;
    }
  }

  if (foundLineNo < 0) foundLineNo = lineStarts.length - 1;

  var result = '', i, line;
  var lineNoLength = Math.min(mark.line + options.linesAfter, lineEnds.length).toString().length;
  var maxLineLength = options.maxLength - (options.indent + lineNoLength + 3);

  for (i = 1; i <= options.linesBefore; i++) {
    if (foundLineNo - i < 0) break;
    line = getLine(
      mark.buffer,
      lineStarts[foundLineNo - i],
      lineEnds[foundLineNo - i],
      mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo - i]),
      maxLineLength
    );
    result = common.repeat(' ', options.indent) + padStart((mark.line - i + 1).toString(), lineNoLength) +
      ' | ' + line.str + '\n' + result;
  }

  line = getLine(mark.buffer, lineStarts[foundLineNo], lineEnds[foundLineNo], mark.position, maxLineLength);
  result += common.repeat(' ', options.indent) + padStart((mark.line + 1).toString(), lineNoLength) +
    ' | ' + line.str + '\n';
  result += common.repeat('-', options.indent + lineNoLength + 3 + line.pos) + '^' + '\n';

  for (i = 1; i <= options.linesAfter; i++) {
    if (foundLineNo + i >= lineEnds.length) break;
    line = getLine(
      mark.buffer,
      lineStarts[foundLineNo + i],
      lineEnds[foundLineNo + i],
      mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo + i]),
      maxLineLength
    );
    result += common.repeat(' ', options.indent) + padStart((mark.line + i + 1).toString(), lineNoLength) +
      ' | ' + line.str + '\n';
  }

  return result.replace(/\n$/, '');
}


var snippet = makeSnippet;

var TYPE_CONSTRUCTOR_OPTIONS = [
  'kind',
  'multi',
  'resolve',
  'construct',
  'instanceOf',
  'predicate',
  'represent',
  'representName',
  'defaultStyle',
  'styleAliases'
];

var YAML_NODE_KINDS = [
  'scalar',
  'sequence',
  'mapping'
];

function compileStyleAliases(map) {
  var result = {};

  if (map !== null) {
    Object.keys(map).forEach(function (style) {
      map[style].forEach(function (alias) {
        result[String(alias)] = style;
      });
    });
  }

  return result;
}

function Type$1(tag, options) {
  options = options || {};

  Object.keys(options).forEach(function (name) {
    if (TYPE_CONSTRUCTOR_OPTIONS.indexOf(name) === -1) {
      throw new exception('Unknown option "' + name + '" is met in definition of "' + tag + '" YAML type.');
    }
  });

  // TODO: Add tag format check.
  this.options       = options; // keep original options in case user wants to extend this type later
  this.tag           = tag;
  this.kind          = options['kind']          || null;
  this.resolve       = options['resolve']       || function () { return true; };
  this.construct     = options['construct']     || function (data) { return data; };
  this.instanceOf    = options['instanceOf']    || null;
  this.predicate     = options['predicate']     || null;
  this.represent     = options['represent']     || null;
  this.representName = options['representName'] || null;
  this.defaultStyle  = options['defaultStyle']  || null;
  this.multi         = options['multi']         || false;
  this.styleAliases  = compileStyleAliases(options['styleAliases'] || null);

  if (YAML_NODE_KINDS.indexOf(this.kind) === -1) {
    throw new exception('Unknown kind "' + this.kind + '" is specified for "' + tag + '" YAML type.');
  }
}

var type = Type$1;

/*eslint-disable max-len*/





function compileList(schema, name) {
  var result = [];

  schema[name].forEach(function (currentType) {
    var newIndex = result.length;

    result.forEach(function (previousType, previousIndex) {
      if (previousType.tag === currentType.tag &&
          previousType.kind === currentType.kind &&
          previousType.multi === currentType.multi) {

        newIndex = previousIndex;
      }
    });

    result[newIndex] = currentType;
  });

  return result;
}


function compileMap(/* lists... */) {
  var result = {
        scalar: {},
        sequence: {},
        mapping: {},
        fallback: {},
        multi: {
          scalar: [],
          sequence: [],
          mapping: [],
          fallback: []
        }
      }, index, length;

  function collectType(type) {
    if (type.multi) {
      result.multi[type.kind].push(type);
      result.multi['fallback'].push(type);
    } else {
      result[type.kind][type.tag] = result['fallback'][type.tag] = type;
    }
  }

  for (index = 0, length = arguments.length; index < length; index += 1) {
    arguments[index].forEach(collectType);
  }
  return result;
}


function Schema$1(definition) {
  return this.extend(definition);
}


Schema$1.prototype.extend = function extend(definition) {
  var implicit = [];
  var explicit = [];

  if (definition instanceof type) {
    // Schema.extend(type)
    explicit.push(definition);

  } else if (Array.isArray(definition)) {
    // Schema.extend([ type1, type2, ... ])
    explicit = explicit.concat(definition);

  } else if (definition && (Array.isArray(definition.implicit) || Array.isArray(definition.explicit))) {
    // Schema.extend({ explicit: [ type1, type2, ... ], implicit: [ type1, type2, ... ] })
    if (definition.implicit) implicit = implicit.concat(definition.implicit);
    if (definition.explicit) explicit = explicit.concat(definition.explicit);

  } else {
    throw new exception('Schema.extend argument should be a Type, [ Type ], ' +
      'or a schema definition ({ implicit: [...], explicit: [...] })');
  }

  implicit.forEach(function (type$1) {
    if (!(type$1 instanceof type)) {
      throw new exception('Specified list of YAML types (or a single Type object) contains a non-Type object.');
    }

    if (type$1.loadKind && type$1.loadKind !== 'scalar') {
      throw new exception('There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.');
    }

    if (type$1.multi) {
      throw new exception('There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.');
    }
  });

  explicit.forEach(function (type$1) {
    if (!(type$1 instanceof type)) {
      throw new exception('Specified list of YAML types (or a single Type object) contains a non-Type object.');
    }
  });

  var result = Object.create(Schema$1.prototype);

  result.implicit = (this.implicit || []).concat(implicit);
  result.explicit = (this.explicit || []).concat(explicit);

  result.compiledImplicit = compileList(result, 'implicit');
  result.compiledExplicit = compileList(result, 'explicit');
  result.compiledTypeMap  = compileMap(result.compiledImplicit, result.compiledExplicit);

  return result;
};


var schema = Schema$1;

var str = new type('tag:yaml.org,2002:str', {
  kind: 'scalar',
  construct: function (data) { return data !== null ? data : ''; }
});

var seq = new type('tag:yaml.org,2002:seq', {
  kind: 'sequence',
  construct: function (data) { return data !== null ? data : []; }
});

var map = new type('tag:yaml.org,2002:map', {
  kind: 'mapping',
  construct: function (data) { return data !== null ? data : {}; }
});

var failsafe = new schema({
  explicit: [
    str,
    seq,
    map
  ]
});

function resolveYamlNull(data) {
  if (data === null) return true;

  var max = data.length;

  return (max === 1 && data === '~') ||
         (max === 4 && (data === 'null' || data === 'Null' || data === 'NULL'));
}

function constructYamlNull() {
  return null;
}

function isNull(object) {
  return object === null;
}

var _null = new type('tag:yaml.org,2002:null', {
  kind: 'scalar',
  resolve: resolveYamlNull,
  construct: constructYamlNull,
  predicate: isNull,
  represent: {
    canonical: function () { return '~';    },
    lowercase: function () { return 'null'; },
    uppercase: function () { return 'NULL'; },
    camelcase: function () { return 'Null'; },
    empty:     function () { return '';     }
  },
  defaultStyle: 'lowercase'
});

function resolveYamlBoolean(data) {
  if (data === null) return false;

  var max = data.length;

  return (max === 4 && (data === 'true' || data === 'True' || data === 'TRUE')) ||
         (max === 5 && (data === 'false' || data === 'False' || data === 'FALSE'));
}

function constructYamlBoolean(data) {
  return data === 'true' ||
         data === 'True' ||
         data === 'TRUE';
}

function isBoolean(object) {
  return Object.prototype.toString.call(object) === '[object Boolean]';
}

var bool = new type('tag:yaml.org,2002:bool', {
  kind: 'scalar',
  resolve: resolveYamlBoolean,
  construct: constructYamlBoolean,
  predicate: isBoolean,
  represent: {
    lowercase: function (object) { return object ? 'true' : 'false'; },
    uppercase: function (object) { return object ? 'TRUE' : 'FALSE'; },
    camelcase: function (object) { return object ? 'True' : 'False'; }
  },
  defaultStyle: 'lowercase'
});

function isHexCode(c) {
  return ((0x30/* 0 */ <= c) && (c <= 0x39/* 9 */)) ||
         ((0x41/* A */ <= c) && (c <= 0x46/* F */)) ||
         ((0x61/* a */ <= c) && (c <= 0x66/* f */));
}

function isOctCode(c) {
  return ((0x30/* 0 */ <= c) && (c <= 0x37/* 7 */));
}

function isDecCode(c) {
  return ((0x30/* 0 */ <= c) && (c <= 0x39/* 9 */));
}

function resolveYamlInteger(data) {
  if (data === null) return false;

  var max = data.length,
      index = 0,
      hasDigits = false,
      ch;

  if (!max) return false;

  ch = data[index];

  // sign
  if (ch === '-' || ch === '+') {
    ch = data[++index];
  }

  if (ch === '0') {
    // 0
    if (index + 1 === max) return true;
    ch = data[++index];

    // base 2, base 8, base 16

    if (ch === 'b') {
      // base 2
      index++;

      for (; index < max; index++) {
        ch = data[index];
        if (ch === '_') continue;
        if (ch !== '0' && ch !== '1') return false;
        hasDigits = true;
      }
      return hasDigits && ch !== '_';
    }


    if (ch === 'x') {
      // base 16
      index++;

      for (; index < max; index++) {
        ch = data[index];
        if (ch === '_') continue;
        if (!isHexCode(data.charCodeAt(index))) return false;
        hasDigits = true;
      }
      return hasDigits && ch !== '_';
    }


    if (ch === 'o') {
      // base 8
      index++;

      for (; index < max; index++) {
        ch = data[index];
        if (ch === '_') continue;
        if (!isOctCode(data.charCodeAt(index))) return false;
        hasDigits = true;
      }
      return hasDigits && ch !== '_';
    }
  }

  // base 10 (except 0)

  // value should not start with `_`;
  if (ch === '_') return false;

  for (; index < max; index++) {
    ch = data[index];
    if (ch === '_') continue;
    if (!isDecCode(data.charCodeAt(index))) {
      return false;
    }
    hasDigits = true;
  }

  // Should have digits and should not end with `_`
  if (!hasDigits || ch === '_') return false;

  return true;
}

function constructYamlInteger(data) {
  var value = data, sign = 1, ch;

  if (value.indexOf('_') !== -1) {
    value = value.replace(/_/g, '');
  }

  ch = value[0];

  if (ch === '-' || ch === '+') {
    if (ch === '-') sign = -1;
    value = value.slice(1);
    ch = value[0];
  }

  if (value === '0') return 0;

  if (ch === '0') {
    if (value[1] === 'b') return sign * parseInt(value.slice(2), 2);
    if (value[1] === 'x') return sign * parseInt(value.slice(2), 16);
    if (value[1] === 'o') return sign * parseInt(value.slice(2), 8);
  }

  return sign * parseInt(value, 10);
}

function isInteger(object) {
  return (Object.prototype.toString.call(object)) === '[object Number]' &&
         (object % 1 === 0 && !common.isNegativeZero(object));
}

var int = new type('tag:yaml.org,2002:int', {
  kind: 'scalar',
  resolve: resolveYamlInteger,
  construct: constructYamlInteger,
  predicate: isInteger,
  represent: {
    binary:      function (obj) { return obj >= 0 ? '0b' + obj.toString(2) : '-0b' + obj.toString(2).slice(1); },
    octal:       function (obj) { return obj >= 0 ? '0o'  + obj.toString(8) : '-0o'  + obj.toString(8).slice(1); },
    decimal:     function (obj) { return obj.toString(10); },
    /* eslint-disable max-len */
    hexadecimal: function (obj) { return obj >= 0 ? '0x' + obj.toString(16).toUpperCase() :  '-0x' + obj.toString(16).toUpperCase().slice(1); }
  },
  defaultStyle: 'decimal',
  styleAliases: {
    binary:      [ 2,  'bin' ],
    octal:       [ 8,  'oct' ],
    decimal:     [ 10, 'dec' ],
    hexadecimal: [ 16, 'hex' ]
  }
});

var YAML_FLOAT_PATTERN = new RegExp(
  // 2.5e4, 2.5 and integers
  '^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?' +
  // .2e4, .2
  // special case, seems not from spec
  '|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?' +
  // .inf
  '|[-+]?\\.(?:inf|Inf|INF)' +
  // .nan
  '|\\.(?:nan|NaN|NAN))$');

function resolveYamlFloat(data) {
  if (data === null) return false;

  if (!YAML_FLOAT_PATTERN.test(data) ||
      // Quick hack to not allow integers end with `_`
      // Probably should update regexp & check speed
      data[data.length - 1] === '_') {
    return false;
  }

  return true;
}

function constructYamlFloat(data) {
  var value, sign;

  value  = data.replace(/_/g, '').toLowerCase();
  sign   = value[0] === '-' ? -1 : 1;

  if ('+-'.indexOf(value[0]) >= 0) {
    value = value.slice(1);
  }

  if (value === '.inf') {
    return (sign === 1) ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;

  } else if (value === '.nan') {
    return NaN;
  }
  return sign * parseFloat(value, 10);
}


var SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;

function representYamlFloat(object, style) {
  var res;

  if (isNaN(object)) {
    switch (style) {
      case 'lowercase': return '.nan';
      case 'uppercase': return '.NAN';
      case 'camelcase': return '.NaN';
    }
  } else if (Number.POSITIVE_INFINITY === object) {
    switch (style) {
      case 'lowercase': return '.inf';
      case 'uppercase': return '.INF';
      case 'camelcase': return '.Inf';
    }
  } else if (Number.NEGATIVE_INFINITY === object) {
    switch (style) {
      case 'lowercase': return '-.inf';
      case 'uppercase': return '-.INF';
      case 'camelcase': return '-.Inf';
    }
  } else if (common.isNegativeZero(object)) {
    return '-0.0';
  }

  res = object.toString(10);

  // JS stringifier can build scientific format without dots: 5e-100,
  // while YAML requres dot: 5.e-100. Fix it with simple hack

  return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace('e', '.e') : res;
}

function isFloat(object) {
  return (Object.prototype.toString.call(object) === '[object Number]') &&
         (object % 1 !== 0 || common.isNegativeZero(object));
}

var float = new type('tag:yaml.org,2002:float', {
  kind: 'scalar',
  resolve: resolveYamlFloat,
  construct: constructYamlFloat,
  predicate: isFloat,
  represent: representYamlFloat,
  defaultStyle: 'lowercase'
});

var json = failsafe.extend({
  implicit: [
    _null,
    bool,
    int,
    float
  ]
});

var core = json;

var YAML_DATE_REGEXP = new RegExp(
  '^([0-9][0-9][0-9][0-9])'          + // [1] year
  '-([0-9][0-9])'                    + // [2] month
  '-([0-9][0-9])$');                   // [3] day

var YAML_TIMESTAMP_REGEXP = new RegExp(
  '^([0-9][0-9][0-9][0-9])'          + // [1] year
  '-([0-9][0-9]?)'                   + // [2] month
  '-([0-9][0-9]?)'                   + // [3] day
  '(?:[Tt]|[ \\t]+)'                 + // ...
  '([0-9][0-9]?)'                    + // [4] hour
  ':([0-9][0-9])'                    + // [5] minute
  ':([0-9][0-9])'                    + // [6] second
  '(?:\\.([0-9]*))?'                 + // [7] fraction
  '(?:[ \\t]*(Z|([-+])([0-9][0-9]?)' + // [8] tz [9] tz_sign [10] tz_hour
  '(?::([0-9][0-9]))?))?$');           // [11] tz_minute

function resolveYamlTimestamp(data) {
  if (data === null) return false;
  if (YAML_DATE_REGEXP.exec(data) !== null) return true;
  if (YAML_TIMESTAMP_REGEXP.exec(data) !== null) return true;
  return false;
}

function constructYamlTimestamp(data) {
  var match, year, month, day, hour, minute, second, fraction = 0,
      delta = null, tz_hour, tz_minute, date;

  match = YAML_DATE_REGEXP.exec(data);
  if (match === null) match = YAML_TIMESTAMP_REGEXP.exec(data);

  if (match === null) throw new Error('Date resolve error');

  // match: [1] year [2] month [3] day

  year = +(match[1]);
  month = +(match[2]) - 1; // JS month starts with 0
  day = +(match[3]);

  if (!match[4]) { // no hour
    return new Date(Date.UTC(year, month, day));
  }

  // match: [4] hour [5] minute [6] second [7] fraction

  hour = +(match[4]);
  minute = +(match[5]);
  second = +(match[6]);

  if (match[7]) {
    fraction = match[7].slice(0, 3);
    while (fraction.length < 3) { // milli-seconds
      fraction += '0';
    }
    fraction = +fraction;
  }

  // match: [8] tz [9] tz_sign [10] tz_hour [11] tz_minute

  if (match[9]) {
    tz_hour = +(match[10]);
    tz_minute = +(match[11] || 0);
    delta = (tz_hour * 60 + tz_minute) * 60000; // delta in mili-seconds
    if (match[9] === '-') delta = -delta;
  }

  date = new Date(Date.UTC(year, month, day, hour, minute, second, fraction));

  if (delta) date.setTime(date.getTime() - delta);

  return date;
}

function representYamlTimestamp(object /*, style*/) {
  return object.toISOString();
}

var timestamp = new type('tag:yaml.org,2002:timestamp', {
  kind: 'scalar',
  resolve: resolveYamlTimestamp,
  construct: constructYamlTimestamp,
  instanceOf: Date,
  represent: representYamlTimestamp
});

function resolveYamlMerge(data) {
  return data === '<<' || data === null;
}

var merge = new type('tag:yaml.org,2002:merge', {
  kind: 'scalar',
  resolve: resolveYamlMerge
});

/*eslint-disable no-bitwise*/





// [ 64, 65, 66 ] -> [ padding, CR, LF ]
var BASE64_MAP = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r';


function resolveYamlBinary(data) {
  if (data === null) return false;

  var code, idx, bitlen = 0, max = data.length, map = BASE64_MAP;

  // Convert one by one.
  for (idx = 0; idx < max; idx++) {
    code = map.indexOf(data.charAt(idx));

    // Skip CR/LF
    if (code > 64) continue;

    // Fail on illegal characters
    if (code < 0) return false;

    bitlen += 6;
  }

  // If there are any bits left, source was corrupted
  return (bitlen % 8) === 0;
}

function constructYamlBinary(data) {
  var idx, tailbits,
      input = data.replace(/[\r\n=]/g, ''), // remove CR/LF & padding to simplify scan
      max = input.length,
      map = BASE64_MAP,
      bits = 0,
      result = [];

  // Collect by 6*4 bits (3 bytes)

  for (idx = 0; idx < max; idx++) {
    if ((idx % 4 === 0) && idx) {
      result.push((bits >> 16) & 0xFF);
      result.push((bits >> 8) & 0xFF);
      result.push(bits & 0xFF);
    }

    bits = (bits << 6) | map.indexOf(input.charAt(idx));
  }

  // Dump tail

  tailbits = (max % 4) * 6;

  if (tailbits === 0) {
    result.push((bits >> 16) & 0xFF);
    result.push((bits >> 8) & 0xFF);
    result.push(bits & 0xFF);
  } else if (tailbits === 18) {
    result.push((bits >> 10) & 0xFF);
    result.push((bits >> 2) & 0xFF);
  } else if (tailbits === 12) {
    result.push((bits >> 4) & 0xFF);
  }

  return new Uint8Array(result);
}

function representYamlBinary(object /*, style*/) {
  var result = '', bits = 0, idx, tail,
      max = object.length,
      map = BASE64_MAP;

  // Convert every three bytes to 4 ASCII characters.

  for (idx = 0; idx < max; idx++) {
    if ((idx % 3 === 0) && idx) {
      result += map[(bits >> 18) & 0x3F];
      result += map[(bits >> 12) & 0x3F];
      result += map[(bits >> 6) & 0x3F];
      result += map[bits & 0x3F];
    }

    bits = (bits << 8) + object[idx];
  }

  // Dump tail

  tail = max % 3;

  if (tail === 0) {
    result += map[(bits >> 18) & 0x3F];
    result += map[(bits >> 12) & 0x3F];
    result += map[(bits >> 6) & 0x3F];
    result += map[bits & 0x3F];
  } else if (tail === 2) {
    result += map[(bits >> 10) & 0x3F];
    result += map[(bits >> 4) & 0x3F];
    result += map[(bits << 2) & 0x3F];
    result += map[64];
  } else if (tail === 1) {
    result += map[(bits >> 2) & 0x3F];
    result += map[(bits << 4) & 0x3F];
    result += map[64];
    result += map[64];
  }

  return result;
}

function isBinary(obj) {
  return Object.prototype.toString.call(obj) ===  '[object Uint8Array]';
}

var binary = new type('tag:yaml.org,2002:binary', {
  kind: 'scalar',
  resolve: resolveYamlBinary,
  construct: constructYamlBinary,
  predicate: isBinary,
  represent: representYamlBinary
});

var _hasOwnProperty$3 = Object.prototype.hasOwnProperty;
var _toString$2       = Object.prototype.toString;

function resolveYamlOmap(data) {
  if (data === null) return true;

  var objectKeys = [], index, length, pair, pairKey, pairHasKey,
      object = data;

  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];
    pairHasKey = false;

    if (_toString$2.call(pair) !== '[object Object]') return false;

    for (pairKey in pair) {
      if (_hasOwnProperty$3.call(pair, pairKey)) {
        if (!pairHasKey) pairHasKey = true;
        else return false;
      }
    }

    if (!pairHasKey) return false;

    if (objectKeys.indexOf(pairKey) === -1) objectKeys.push(pairKey);
    else return false;
  }

  return true;
}

function constructYamlOmap(data) {
  return data !== null ? data : [];
}

var omap = new type('tag:yaml.org,2002:omap', {
  kind: 'sequence',
  resolve: resolveYamlOmap,
  construct: constructYamlOmap
});

var _toString$1 = Object.prototype.toString;

function resolveYamlPairs(data) {
  if (data === null) return true;

  var index, length, pair, keys, result,
      object = data;

  result = new Array(object.length);

  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];

    if (_toString$1.call(pair) !== '[object Object]') return false;

    keys = Object.keys(pair);

    if (keys.length !== 1) return false;

    result[index] = [ keys[0], pair[keys[0]] ];
  }

  return true;
}

function constructYamlPairs(data) {
  if (data === null) return [];

  var index, length, pair, keys, result,
      object = data;

  result = new Array(object.length);

  for (index = 0, length = object.length; index < length; index += 1) {
    pair = object[index];

    keys = Object.keys(pair);

    result[index] = [ keys[0], pair[keys[0]] ];
  }

  return result;
}

var pairs = new type('tag:yaml.org,2002:pairs', {
  kind: 'sequence',
  resolve: resolveYamlPairs,
  construct: constructYamlPairs
});

var _hasOwnProperty$2 = Object.prototype.hasOwnProperty;

function resolveYamlSet(data) {
  if (data === null) return true;

  var key, object = data;

  for (key in object) {
    if (_hasOwnProperty$2.call(object, key)) {
      if (object[key] !== null) return false;
    }
  }

  return true;
}

function constructYamlSet(data) {
  return data !== null ? data : {};
}

var set = new type('tag:yaml.org,2002:set', {
  kind: 'mapping',
  resolve: resolveYamlSet,
  construct: constructYamlSet
});

var _default = core.extend({
  implicit: [
    timestamp,
    merge
  ],
  explicit: [
    binary,
    omap,
    pairs,
    set
  ]
});

/*eslint-disable max-len,no-use-before-define*/







var _hasOwnProperty$1 = Object.prototype.hasOwnProperty;


var CONTEXT_FLOW_IN   = 1;
var CONTEXT_FLOW_OUT  = 2;
var CONTEXT_BLOCK_IN  = 3;
var CONTEXT_BLOCK_OUT = 4;


var CHOMPING_CLIP  = 1;
var CHOMPING_STRIP = 2;
var CHOMPING_KEEP  = 3;


var PATTERN_NON_PRINTABLE         = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
var PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
var PATTERN_FLOW_INDICATORS       = /[,\[\]\{\}]/;
var PATTERN_TAG_HANDLE            = /^(?:!|!!|![a-z\-]+!)$/i;
var PATTERN_TAG_URI               = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;


function _class(obj) { return Object.prototype.toString.call(obj); }

function is_EOL(c) {
  return (c === 0x0A/* LF */) || (c === 0x0D/* CR */);
}

function is_WHITE_SPACE(c) {
  return (c === 0x09/* Tab */) || (c === 0x20/* Space */);
}

function is_WS_OR_EOL(c) {
  return (c === 0x09/* Tab */) ||
         (c === 0x20/* Space */) ||
         (c === 0x0A/* LF */) ||
         (c === 0x0D/* CR */);
}

function is_FLOW_INDICATOR(c) {
  return c === 0x2C/* , */ ||
         c === 0x5B/* [ */ ||
         c === 0x5D/* ] */ ||
         c === 0x7B/* { */ ||
         c === 0x7D/* } */;
}

function fromHexCode(c) {
  var lc;

  if ((0x30/* 0 */ <= c) && (c <= 0x39/* 9 */)) {
    return c - 0x30;
  }

  /*eslint-disable no-bitwise*/
  lc = c | 0x20;

  if ((0x61/* a */ <= lc) && (lc <= 0x66/* f */)) {
    return lc - 0x61 + 10;
  }

  return -1;
}

function escapedHexLen(c) {
  if (c === 0x78/* x */) { return 2; }
  if (c === 0x75/* u */) { return 4; }
  if (c === 0x55/* U */) { return 8; }
  return 0;
}

function fromDecimalCode(c) {
  if ((0x30/* 0 */ <= c) && (c <= 0x39/* 9 */)) {
    return c - 0x30;
  }

  return -1;
}

function simpleEscapeSequence(c) {
  /* eslint-disable indent */
  return (c === 0x30/* 0 */) ? '\x00' :
        (c === 0x61/* a */) ? '\x07' :
        (c === 0x62/* b */) ? '\x08' :
        (c === 0x74/* t */) ? '\x09' :
        (c === 0x09/* Tab */) ? '\x09' :
        (c === 0x6E/* n */) ? '\x0A' :
        (c === 0x76/* v */) ? '\x0B' :
        (c === 0x66/* f */) ? '\x0C' :
        (c === 0x72/* r */) ? '\x0D' :
        (c === 0x65/* e */) ? '\x1B' :
        (c === 0x20/* Space */) ? ' ' :
        (c === 0x22/* " */) ? '\x22' :
        (c === 0x2F/* / */) ? '/' :
        (c === 0x5C/* \ */) ? '\x5C' :
        (c === 0x4E/* N */) ? '\x85' :
        (c === 0x5F/* _ */) ? '\xA0' :
        (c === 0x4C/* L */) ? '\u2028' :
        (c === 0x50/* P */) ? '\u2029' : '';
}

function charFromCodepoint(c) {
  if (c <= 0xFFFF) {
    return String.fromCharCode(c);
  }
  // Encode UTF-16 surrogate pair
  // https://en.wikipedia.org/wiki/UTF-16#Code_points_U.2B010000_to_U.2B10FFFF
  return String.fromCharCode(
    ((c - 0x010000) >> 10) + 0xD800,
    ((c - 0x010000) & 0x03FF) + 0xDC00
  );
}

var simpleEscapeCheck = new Array(256); // integer, for fast access
var simpleEscapeMap = new Array(256);
for (var i = 0; i < 256; i++) {
  simpleEscapeCheck[i] = simpleEscapeSequence(i) ? 1 : 0;
  simpleEscapeMap[i] = simpleEscapeSequence(i);
}


function State$1(input, options) {
  this.input = input;

  this.filename  = options['filename']  || null;
  this.schema    = options['schema']    || _default;
  this.onWarning = options['onWarning'] || null;
  // (Hidden) Remove? makes the loader to expect YAML 1.1 documents
  // if such documents have no explicit %YAML directive
  this.legacy    = options['legacy']    || false;

  this.json      = options['json']      || false;
  this.listener  = options['listener']  || null;

  this.implicitTypes = this.schema.compiledImplicit;
  this.typeMap       = this.schema.compiledTypeMap;

  this.length     = input.length;
  this.position   = 0;
  this.line       = 0;
  this.lineStart  = 0;
  this.lineIndent = 0;

  // position of first leading tab in the current line,
  // used to make sure there are no tabs in the indentation
  this.firstTabInLine = -1;

  this.documents = [];

  /*
  this.version;
  this.checkLineBreaks;
  this.tagMap;
  this.anchorMap;
  this.tag;
  this.anchor;
  this.kind;
  this.result;*/

}


function generateError(state, message) {
  var mark = {
    name:     state.filename,
    buffer:   state.input.slice(0, -1), // omit trailing \0
    position: state.position,
    line:     state.line,
    column:   state.position - state.lineStart
  };

  mark.snippet = snippet(mark);

  return new exception(message, mark);
}

function throwError(state, message) {
  throw generateError(state, message);
}

function throwWarning(state, message) {
  if (state.onWarning) {
    state.onWarning.call(null, generateError(state, message));
  }
}


var directiveHandlers = {

  YAML: function handleYamlDirective(state, name, args) {

    var match, major, minor;

    if (state.version !== null) {
      throwError(state, 'duplication of %YAML directive');
    }

    if (args.length !== 1) {
      throwError(state, 'YAML directive accepts exactly one argument');
    }

    match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);

    if (match === null) {
      throwError(state, 'ill-formed argument of the YAML directive');
    }

    major = parseInt(match[1], 10);
    minor = parseInt(match[2], 10);

    if (major !== 1) {
      throwError(state, 'unacceptable YAML version of the document');
    }

    state.version = args[0];
    state.checkLineBreaks = (minor < 2);

    if (minor !== 1 && minor !== 2) {
      throwWarning(state, 'unsupported YAML version of the document');
    }
  },

  TAG: function handleTagDirective(state, name, args) {

    var handle, prefix;

    if (args.length !== 2) {
      throwError(state, 'TAG directive accepts exactly two arguments');
    }

    handle = args[0];
    prefix = args[1];

    if (!PATTERN_TAG_HANDLE.test(handle)) {
      throwError(state, 'ill-formed tag handle (first argument) of the TAG directive');
    }

    if (_hasOwnProperty$1.call(state.tagMap, handle)) {
      throwError(state, 'there is a previously declared suffix for "' + handle + '" tag handle');
    }

    if (!PATTERN_TAG_URI.test(prefix)) {
      throwError(state, 'ill-formed tag prefix (second argument) of the TAG directive');
    }

    try {
      prefix = decodeURIComponent(prefix);
    } catch (err) {
      throwError(state, 'tag prefix is malformed: ' + prefix);
    }

    state.tagMap[handle] = prefix;
  }
};


function captureSegment(state, start, end, checkJson) {
  var _position, _length, _character, _result;

  if (start < end) {
    _result = state.input.slice(start, end);

    if (checkJson) {
      for (_position = 0, _length = _result.length; _position < _length; _position += 1) {
        _character = _result.charCodeAt(_position);
        if (!(_character === 0x09 ||
              (0x20 <= _character && _character <= 0x10FFFF))) {
          throwError(state, 'expected valid JSON character');
        }
      }
    } else if (PATTERN_NON_PRINTABLE.test(_result)) {
      throwError(state, 'the stream contains non-printable characters');
    }

    state.result += _result;
  }
}

function mergeMappings(state, destination, source, overridableKeys) {
  var sourceKeys, key, index, quantity;

  if (!common.isObject(source)) {
    throwError(state, 'cannot merge mappings; the provided source object is unacceptable');
  }

  sourceKeys = Object.keys(source);

  for (index = 0, quantity = sourceKeys.length; index < quantity; index += 1) {
    key = sourceKeys[index];

    if (!_hasOwnProperty$1.call(destination, key)) {
      destination[key] = source[key];
      overridableKeys[key] = true;
    }
  }
}

function storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode,
  startLine, startLineStart, startPos) {

  var index, quantity;

  // The output is a plain object here, so keys can only be strings.
  // We need to convert keyNode to a string, but doing so can hang the process
  // (deeply nested arrays that explode exponentially using aliases).
  if (Array.isArray(keyNode)) {
    keyNode = Array.prototype.slice.call(keyNode);

    for (index = 0, quantity = keyNode.length; index < quantity; index += 1) {
      if (Array.isArray(keyNode[index])) {
        throwError(state, 'nested arrays are not supported inside keys');
      }

      if (typeof keyNode === 'object' && _class(keyNode[index]) === '[object Object]') {
        keyNode[index] = '[object Object]';
      }
    }
  }

  // Avoid code execution in load() via toString property
  // (still use its own toString for arrays, timestamps,
  // and whatever user schema extensions happen to have @@toStringTag)
  if (typeof keyNode === 'object' && _class(keyNode) === '[object Object]') {
    keyNode = '[object Object]';
  }


  keyNode = String(keyNode);

  if (_result === null) {
    _result = {};
  }

  if (keyTag === 'tag:yaml.org,2002:merge') {
    if (Array.isArray(valueNode)) {
      for (index = 0, quantity = valueNode.length; index < quantity; index += 1) {
        mergeMappings(state, _result, valueNode[index], overridableKeys);
      }
    } else {
      mergeMappings(state, _result, valueNode, overridableKeys);
    }
  } else {
    if (!state.json &&
        !_hasOwnProperty$1.call(overridableKeys, keyNode) &&
        _hasOwnProperty$1.call(_result, keyNode)) {
      state.line = startLine || state.line;
      state.lineStart = startLineStart || state.lineStart;
      state.position = startPos || state.position;
      throwError(state, 'duplicated mapping key');
    }

    // used for this specific key only because Object.defineProperty is slow
    if (keyNode === '__proto__') {
      Object.defineProperty(_result, keyNode, {
        configurable: true,
        enumerable: true,
        writable: true,
        value: valueNode
      });
    } else {
      _result[keyNode] = valueNode;
    }
    delete overridableKeys[keyNode];
  }

  return _result;
}

function readLineBreak(state) {
  var ch;

  ch = state.input.charCodeAt(state.position);

  if (ch === 0x0A/* LF */) {
    state.position++;
  } else if (ch === 0x0D/* CR */) {
    state.position++;
    if (state.input.charCodeAt(state.position) === 0x0A/* LF */) {
      state.position++;
    }
  } else {
    throwError(state, 'a line break is expected');
  }

  state.line += 1;
  state.lineStart = state.position;
  state.firstTabInLine = -1;
}

function skipSeparationSpace(state, allowComments, checkIndent) {
  var lineBreaks = 0,
      ch = state.input.charCodeAt(state.position);

  while (ch !== 0) {
    while (is_WHITE_SPACE(ch)) {
      if (ch === 0x09/* Tab */ && state.firstTabInLine === -1) {
        state.firstTabInLine = state.position;
      }
      ch = state.input.charCodeAt(++state.position);
    }

    if (allowComments && ch === 0x23/* # */) {
      do {
        ch = state.input.charCodeAt(++state.position);
      } while (ch !== 0x0A/* LF */ && ch !== 0x0D/* CR */ && ch !== 0);
    }

    if (is_EOL(ch)) {
      readLineBreak(state);

      ch = state.input.charCodeAt(state.position);
      lineBreaks++;
      state.lineIndent = 0;

      while (ch === 0x20/* Space */) {
        state.lineIndent++;
        ch = state.input.charCodeAt(++state.position);
      }
    } else {
      break;
    }
  }

  if (checkIndent !== -1 && lineBreaks !== 0 && state.lineIndent < checkIndent) {
    throwWarning(state, 'deficient indentation');
  }

  return lineBreaks;
}

function testDocumentSeparator(state) {
  var _position = state.position,
      ch;

  ch = state.input.charCodeAt(_position);

  // Condition state.position === state.lineStart is tested
  // in parent on each call, for efficiency. No needs to test here again.
  if ((ch === 0x2D/* - */ || ch === 0x2E/* . */) &&
      ch === state.input.charCodeAt(_position + 1) &&
      ch === state.input.charCodeAt(_position + 2)) {

    _position += 3;

    ch = state.input.charCodeAt(_position);

    if (ch === 0 || is_WS_OR_EOL(ch)) {
      return true;
    }
  }

  return false;
}

function writeFoldedLines(state, count) {
  if (count === 1) {
    state.result += ' ';
  } else if (count > 1) {
    state.result += common.repeat('\n', count - 1);
  }
}


function readPlainScalar(state, nodeIndent, withinFlowCollection) {
  var preceding,
      following,
      captureStart,
      captureEnd,
      hasPendingContent,
      _line,
      _lineStart,
      _lineIndent,
      _kind = state.kind,
      _result = state.result,
      ch;

  ch = state.input.charCodeAt(state.position);

  if (is_WS_OR_EOL(ch)      ||
      is_FLOW_INDICATOR(ch) ||
      ch === 0x23/* # */    ||
      ch === 0x26/* & */    ||
      ch === 0x2A/* * */    ||
      ch === 0x21/* ! */    ||
      ch === 0x7C/* | */    ||
      ch === 0x3E/* > */    ||
      ch === 0x27/* ' */    ||
      ch === 0x22/* " */    ||
      ch === 0x25/* % */    ||
      ch === 0x40/* @ */    ||
      ch === 0x60/* ` */) {
    return false;
  }

  if (ch === 0x3F/* ? */ || ch === 0x2D/* - */) {
    following = state.input.charCodeAt(state.position + 1);

    if (is_WS_OR_EOL(following) ||
        withinFlowCollection && is_FLOW_INDICATOR(following)) {
      return false;
    }
  }

  state.kind = 'scalar';
  state.result = '';
  captureStart = captureEnd = state.position;
  hasPendingContent = false;

  while (ch !== 0) {
    if (ch === 0x3A/* : */) {
      following = state.input.charCodeAt(state.position + 1);

      if (is_WS_OR_EOL(following) ||
          withinFlowCollection && is_FLOW_INDICATOR(following)) {
        break;
      }

    } else if (ch === 0x23/* # */) {
      preceding = state.input.charCodeAt(state.position - 1);

      if (is_WS_OR_EOL(preceding)) {
        break;
      }

    } else if ((state.position === state.lineStart && testDocumentSeparator(state)) ||
               withinFlowCollection && is_FLOW_INDICATOR(ch)) {
      break;

    } else if (is_EOL(ch)) {
      _line = state.line;
      _lineStart = state.lineStart;
      _lineIndent = state.lineIndent;
      skipSeparationSpace(state, false, -1);

      if (state.lineIndent >= nodeIndent) {
        hasPendingContent = true;
        ch = state.input.charCodeAt(state.position);
        continue;
      } else {
        state.position = captureEnd;
        state.line = _line;
        state.lineStart = _lineStart;
        state.lineIndent = _lineIndent;
        break;
      }
    }

    if (hasPendingContent) {
      captureSegment(state, captureStart, captureEnd, false);
      writeFoldedLines(state, state.line - _line);
      captureStart = captureEnd = state.position;
      hasPendingContent = false;
    }

    if (!is_WHITE_SPACE(ch)) {
      captureEnd = state.position + 1;
    }

    ch = state.input.charCodeAt(++state.position);
  }

  captureSegment(state, captureStart, captureEnd, false);

  if (state.result) {
    return true;
  }

  state.kind = _kind;
  state.result = _result;
  return false;
}

function readSingleQuotedScalar(state, nodeIndent) {
  var ch,
      captureStart, captureEnd;

  ch = state.input.charCodeAt(state.position);

  if (ch !== 0x27/* ' */) {
    return false;
  }

  state.kind = 'scalar';
  state.result = '';
  state.position++;
  captureStart = captureEnd = state.position;

  while ((ch = state.input.charCodeAt(state.position)) !== 0) {
    if (ch === 0x27/* ' */) {
      captureSegment(state, captureStart, state.position, true);
      ch = state.input.charCodeAt(++state.position);

      if (ch === 0x27/* ' */) {
        captureStart = state.position;
        state.position++;
        captureEnd = state.position;
      } else {
        return true;
      }

    } else if (is_EOL(ch)) {
      captureSegment(state, captureStart, captureEnd, true);
      writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
      captureStart = captureEnd = state.position;

    } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
      throwError(state, 'unexpected end of the document within a single quoted scalar');

    } else {
      state.position++;
      captureEnd = state.position;
    }
  }

  throwError(state, 'unexpected end of the stream within a single quoted scalar');
}

function readDoubleQuotedScalar(state, nodeIndent) {
  var captureStart,
      captureEnd,
      hexLength,
      hexResult,
      tmp,
      ch;

  ch = state.input.charCodeAt(state.position);

  if (ch !== 0x22/* " */) {
    return false;
  }

  state.kind = 'scalar';
  state.result = '';
  state.position++;
  captureStart = captureEnd = state.position;

  while ((ch = state.input.charCodeAt(state.position)) !== 0) {
    if (ch === 0x22/* " */) {
      captureSegment(state, captureStart, state.position, true);
      state.position++;
      return true;

    } else if (ch === 0x5C/* \ */) {
      captureSegment(state, captureStart, state.position, true);
      ch = state.input.charCodeAt(++state.position);

      if (is_EOL(ch)) {
        skipSeparationSpace(state, false, nodeIndent);

        // TODO: rework to inline fn with no type cast?
      } else if (ch < 256 && simpleEscapeCheck[ch]) {
        state.result += simpleEscapeMap[ch];
        state.position++;

      } else if ((tmp = escapedHexLen(ch)) > 0) {
        hexLength = tmp;
        hexResult = 0;

        for (; hexLength > 0; hexLength--) {
          ch = state.input.charCodeAt(++state.position);

          if ((tmp = fromHexCode(ch)) >= 0) {
            hexResult = (hexResult << 4) + tmp;

          } else {
            throwError(state, 'expected hexadecimal character');
          }
        }

        state.result += charFromCodepoint(hexResult);

        state.position++;

      } else {
        throwError(state, 'unknown escape sequence');
      }

      captureStart = captureEnd = state.position;

    } else if (is_EOL(ch)) {
      captureSegment(state, captureStart, captureEnd, true);
      writeFoldedLines(state, skipSeparationSpace(state, false, nodeIndent));
      captureStart = captureEnd = state.position;

    } else if (state.position === state.lineStart && testDocumentSeparator(state)) {
      throwError(state, 'unexpected end of the document within a double quoted scalar');

    } else {
      state.position++;
      captureEnd = state.position;
    }
  }

  throwError(state, 'unexpected end of the stream within a double quoted scalar');
}

function readFlowCollection(state, nodeIndent) {
  var readNext = true,
      _line,
      _lineStart,
      _pos,
      _tag     = state.tag,
      _result,
      _anchor  = state.anchor,
      following,
      terminator,
      isPair,
      isExplicitPair,
      isMapping,
      overridableKeys = Object.create(null),
      keyNode,
      keyTag,
      valueNode,
      ch;

  ch = state.input.charCodeAt(state.position);

  if (ch === 0x5B/* [ */) {
    terminator = 0x5D;/* ] */
    isMapping = false;
    _result = [];
  } else if (ch === 0x7B/* { */) {
    terminator = 0x7D;/* } */
    isMapping = true;
    _result = {};
  } else {
    return false;
  }

  if (state.anchor !== null) {
    state.anchorMap[state.anchor] = _result;
  }

  ch = state.input.charCodeAt(++state.position);

  while (ch !== 0) {
    skipSeparationSpace(state, true, nodeIndent);

    ch = state.input.charCodeAt(state.position);

    if (ch === terminator) {
      state.position++;
      state.tag = _tag;
      state.anchor = _anchor;
      state.kind = isMapping ? 'mapping' : 'sequence';
      state.result = _result;
      return true;
    } else if (!readNext) {
      throwError(state, 'missed comma between flow collection entries');
    } else if (ch === 0x2C/* , */) {
      // "flow collection entries can never be completely empty", as per YAML 1.2, section 7.4
      throwError(state, "expected the node content, but found ','");
    }

    keyTag = keyNode = valueNode = null;
    isPair = isExplicitPair = false;

    if (ch === 0x3F/* ? */) {
      following = state.input.charCodeAt(state.position + 1);

      if (is_WS_OR_EOL(following)) {
        isPair = isExplicitPair = true;
        state.position++;
        skipSeparationSpace(state, true, nodeIndent);
      }
    }

    _line = state.line; // Save the current line.
    _lineStart = state.lineStart;
    _pos = state.position;
    composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
    keyTag = state.tag;
    keyNode = state.result;
    skipSeparationSpace(state, true, nodeIndent);

    ch = state.input.charCodeAt(state.position);

    if ((isExplicitPair || state.line === _line) && ch === 0x3A/* : */) {
      isPair = true;
      ch = state.input.charCodeAt(++state.position);
      skipSeparationSpace(state, true, nodeIndent);
      composeNode(state, nodeIndent, CONTEXT_FLOW_IN, false, true);
      valueNode = state.result;
    }

    if (isMapping) {
      storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos);
    } else if (isPair) {
      _result.push(storeMappingPair(state, null, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos));
    } else {
      _result.push(keyNode);
    }

    skipSeparationSpace(state, true, nodeIndent);

    ch = state.input.charCodeAt(state.position);

    if (ch === 0x2C/* , */) {
      readNext = true;
      ch = state.input.charCodeAt(++state.position);
    } else {
      readNext = false;
    }
  }

  throwError(state, 'unexpected end of the stream within a flow collection');
}

function readBlockScalar(state, nodeIndent) {
  var captureStart,
      folding,
      chomping       = CHOMPING_CLIP,
      didReadContent = false,
      detectedIndent = false,
      textIndent     = nodeIndent,
      emptyLines     = 0,
      atMoreIndented = false,
      tmp,
      ch;

  ch = state.input.charCodeAt(state.position);

  if (ch === 0x7C/* | */) {
    folding = false;
  } else if (ch === 0x3E/* > */) {
    folding = true;
  } else {
    return false;
  }

  state.kind = 'scalar';
  state.result = '';

  while (ch !== 0) {
    ch = state.input.charCodeAt(++state.position);

    if (ch === 0x2B/* + */ || ch === 0x2D/* - */) {
      if (CHOMPING_CLIP === chomping) {
        chomping = (ch === 0x2B/* + */) ? CHOMPING_KEEP : CHOMPING_STRIP;
      } else {
        throwError(state, 'repeat of a chomping mode identifier');
      }

    } else if ((tmp = fromDecimalCode(ch)) >= 0) {
      if (tmp === 0) {
        throwError(state, 'bad explicit indentation width of a block scalar; it cannot be less than one');
      } else if (!detectedIndent) {
        textIndent = nodeIndent + tmp - 1;
        detectedIndent = true;
      } else {
        throwError(state, 'repeat of an indentation width identifier');
      }

    } else {
      break;
    }
  }

  if (is_WHITE_SPACE(ch)) {
    do { ch = state.input.charCodeAt(++state.position); }
    while (is_WHITE_SPACE(ch));

    if (ch === 0x23/* # */) {
      do { ch = state.input.charCodeAt(++state.position); }
      while (!is_EOL(ch) && (ch !== 0));
    }
  }

  while (ch !== 0) {
    readLineBreak(state);
    state.lineIndent = 0;

    ch = state.input.charCodeAt(state.position);

    while ((!detectedIndent || state.lineIndent < textIndent) &&
           (ch === 0x20/* Space */)) {
      state.lineIndent++;
      ch = state.input.charCodeAt(++state.position);
    }

    if (!detectedIndent && state.lineIndent > textIndent) {
      textIndent = state.lineIndent;
    }

    if (is_EOL(ch)) {
      emptyLines++;
      continue;
    }

    // End of the scalar.
    if (state.lineIndent < textIndent) {

      // Perform the chomping.
      if (chomping === CHOMPING_KEEP) {
        state.result += common.repeat('\n', didReadContent ? 1 + emptyLines : emptyLines);
      } else if (chomping === CHOMPING_CLIP) {
        if (didReadContent) { // i.e. only if the scalar is not empty.
          state.result += '\n';
        }
      }

      // Break this `while` cycle and go to the funciton's epilogue.
      break;
    }

    // Folded style: use fancy rules to handle line breaks.
    if (folding) {

      // Lines starting with white space characters (more-indented lines) are not folded.
      if (is_WHITE_SPACE(ch)) {
        atMoreIndented = true;
        // except for the first content line (cf. Example 8.1)
        state.result += common.repeat('\n', didReadContent ? 1 + emptyLines : emptyLines);

      // End of more-indented block.
      } else if (atMoreIndented) {
        atMoreIndented = false;
        state.result += common.repeat('\n', emptyLines + 1);

      // Just one line break - perceive as the same line.
      } else if (emptyLines === 0) {
        if (didReadContent) { // i.e. only if we have already read some scalar content.
          state.result += ' ';
        }

      // Several line breaks - perceive as different lines.
      } else {
        state.result += common.repeat('\n', emptyLines);
      }

    // Literal style: just add exact number of line breaks between content lines.
    } else {
      // Keep all line breaks except the header line break.
      state.result += common.repeat('\n', didReadContent ? 1 + emptyLines : emptyLines);
    }

    didReadContent = true;
    detectedIndent = true;
    emptyLines = 0;
    captureStart = state.position;

    while (!is_EOL(ch) && (ch !== 0)) {
      ch = state.input.charCodeAt(++state.position);
    }

    captureSegment(state, captureStart, state.position, false);
  }

  return true;
}

function readBlockSequence(state, nodeIndent) {
  var _line,
      _tag      = state.tag,
      _anchor   = state.anchor,
      _result   = [],
      following,
      detected  = false,
      ch;

  // there is a leading tab before this token, so it can't be a block sequence/mapping;
  // it can still be flow sequence/mapping or a scalar
  if (state.firstTabInLine !== -1) return false;

  if (state.anchor !== null) {
    state.anchorMap[state.anchor] = _result;
  }

  ch = state.input.charCodeAt(state.position);

  while (ch !== 0) {
    if (state.firstTabInLine !== -1) {
      state.position = state.firstTabInLine;
      throwError(state, 'tab characters must not be used in indentation');
    }

    if (ch !== 0x2D/* - */) {
      break;
    }

    following = state.input.charCodeAt(state.position + 1);

    if (!is_WS_OR_EOL(following)) {
      break;
    }

    detected = true;
    state.position++;

    if (skipSeparationSpace(state, true, -1)) {
      if (state.lineIndent <= nodeIndent) {
        _result.push(null);
        ch = state.input.charCodeAt(state.position);
        continue;
      }
    }

    _line = state.line;
    composeNode(state, nodeIndent, CONTEXT_BLOCK_IN, false, true);
    _result.push(state.result);
    skipSeparationSpace(state, true, -1);

    ch = state.input.charCodeAt(state.position);

    if ((state.line === _line || state.lineIndent > nodeIndent) && (ch !== 0)) {
      throwError(state, 'bad indentation of a sequence entry');
    } else if (state.lineIndent < nodeIndent) {
      break;
    }
  }

  if (detected) {
    state.tag = _tag;
    state.anchor = _anchor;
    state.kind = 'sequence';
    state.result = _result;
    return true;
  }
  return false;
}

function readBlockMapping(state, nodeIndent, flowIndent) {
  var following,
      allowCompact,
      _line,
      _keyLine,
      _keyLineStart,
      _keyPos,
      _tag          = state.tag,
      _anchor       = state.anchor,
      _result       = {},
      overridableKeys = Object.create(null),
      keyTag        = null,
      keyNode       = null,
      valueNode     = null,
      atExplicitKey = false,
      detected      = false,
      ch;

  // there is a leading tab before this token, so it can't be a block sequence/mapping;
  // it can still be flow sequence/mapping or a scalar
  if (state.firstTabInLine !== -1) return false;

  if (state.anchor !== null) {
    state.anchorMap[state.anchor] = _result;
  }

  ch = state.input.charCodeAt(state.position);

  while (ch !== 0) {
    if (!atExplicitKey && state.firstTabInLine !== -1) {
      state.position = state.firstTabInLine;
      throwError(state, 'tab characters must not be used in indentation');
    }

    following = state.input.charCodeAt(state.position + 1);
    _line = state.line; // Save the current line.

    //
    // Explicit notation case. There are two separate blocks:
    // first for the key (denoted by "?") and second for the value (denoted by ":")
    //
    if ((ch === 0x3F/* ? */ || ch === 0x3A/* : */) && is_WS_OR_EOL(following)) {

      if (ch === 0x3F/* ? */) {
        if (atExplicitKey) {
          storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
          keyTag = keyNode = valueNode = null;
        }

        detected = true;
        atExplicitKey = true;
        allowCompact = true;

      } else if (atExplicitKey) {
        // i.e. 0x3A/* : */ === character after the explicit key.
        atExplicitKey = false;
        allowCompact = true;

      } else {
        throwError(state, 'incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line');
      }

      state.position += 1;
      ch = following;

    //
    // Implicit notation case. Flow-style node as the key first, then ":", and the value.
    //
    } else {
      _keyLine = state.line;
      _keyLineStart = state.lineStart;
      _keyPos = state.position;

      if (!composeNode(state, flowIndent, CONTEXT_FLOW_OUT, false, true)) {
        // Neither implicit nor explicit notation.
        // Reading is done. Go to the epilogue.
        break;
      }

      if (state.line === _line) {
        ch = state.input.charCodeAt(state.position);

        while (is_WHITE_SPACE(ch)) {
          ch = state.input.charCodeAt(++state.position);
        }

        if (ch === 0x3A/* : */) {
          ch = state.input.charCodeAt(++state.position);

          if (!is_WS_OR_EOL(ch)) {
            throwError(state, 'a whitespace character is expected after the key-value separator within a block mapping');
          }

          if (atExplicitKey) {
            storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
            keyTag = keyNode = valueNode = null;
          }

          detected = true;
          atExplicitKey = false;
          allowCompact = false;
          keyTag = state.tag;
          keyNode = state.result;

        } else if (detected) {
          throwError(state, 'can not read an implicit mapping pair; a colon is missed');

        } else {
          state.tag = _tag;
          state.anchor = _anchor;
          return true; // Keep the result of `composeNode`.
        }

      } else if (detected) {
        throwError(state, 'can not read a block mapping entry; a multiline key may not be an implicit key');

      } else {
        state.tag = _tag;
        state.anchor = _anchor;
        return true; // Keep the result of `composeNode`.
      }
    }

    //
    // Common reading code for both explicit and implicit notations.
    //
    if (state.line === _line || state.lineIndent > nodeIndent) {
      if (atExplicitKey) {
        _keyLine = state.line;
        _keyLineStart = state.lineStart;
        _keyPos = state.position;
      }

      if (composeNode(state, nodeIndent, CONTEXT_BLOCK_OUT, true, allowCompact)) {
        if (atExplicitKey) {
          keyNode = state.result;
        } else {
          valueNode = state.result;
        }
      }

      if (!atExplicitKey) {
        storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, valueNode, _keyLine, _keyLineStart, _keyPos);
        keyTag = keyNode = valueNode = null;
      }

      skipSeparationSpace(state, true, -1);
      ch = state.input.charCodeAt(state.position);
    }

    if ((state.line === _line || state.lineIndent > nodeIndent) && (ch !== 0)) {
      throwError(state, 'bad indentation of a mapping entry');
    } else if (state.lineIndent < nodeIndent) {
      break;
    }
  }

  //
  // Epilogue.
  //

  // Special case: last mapping's node contains only the key in explicit notation.
  if (atExplicitKey) {
    storeMappingPair(state, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
  }

  // Expose the resulting mapping.
  if (detected) {
    state.tag = _tag;
    state.anchor = _anchor;
    state.kind = 'mapping';
    state.result = _result;
  }

  return detected;
}

function readTagProperty(state) {
  var _position,
      isVerbatim = false,
      isNamed    = false,
      tagHandle,
      tagName,
      ch;

  ch = state.input.charCodeAt(state.position);

  if (ch !== 0x21/* ! */) return false;

  if (state.tag !== null) {
    throwError(state, 'duplication of a tag property');
  }

  ch = state.input.charCodeAt(++state.position);

  if (ch === 0x3C/* < */) {
    isVerbatim = true;
    ch = state.input.charCodeAt(++state.position);

  } else if (ch === 0x21/* ! */) {
    isNamed = true;
    tagHandle = '!!';
    ch = state.input.charCodeAt(++state.position);

  } else {
    tagHandle = '!';
  }

  _position = state.position;

  if (isVerbatim) {
    do { ch = state.input.charCodeAt(++state.position); }
    while (ch !== 0 && ch !== 0x3E/* > */);

    if (state.position < state.length) {
      tagName = state.input.slice(_position, state.position);
      ch = state.input.charCodeAt(++state.position);
    } else {
      throwError(state, 'unexpected end of the stream within a verbatim tag');
    }
  } else {
    while (ch !== 0 && !is_WS_OR_EOL(ch)) {

      if (ch === 0x21/* ! */) {
        if (!isNamed) {
          tagHandle = state.input.slice(_position - 1, state.position + 1);

          if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
            throwError(state, 'named tag handle cannot contain such characters');
          }

          isNamed = true;
          _position = state.position + 1;
        } else {
          throwError(state, 'tag suffix cannot contain exclamation marks');
        }
      }

      ch = state.input.charCodeAt(++state.position);
    }

    tagName = state.input.slice(_position, state.position);

    if (PATTERN_FLOW_INDICATORS.test(tagName)) {
      throwError(state, 'tag suffix cannot contain flow indicator characters');
    }
  }

  if (tagName && !PATTERN_TAG_URI.test(tagName)) {
    throwError(state, 'tag name cannot contain such characters: ' + tagName);
  }

  try {
    tagName = decodeURIComponent(tagName);
  } catch (err) {
    throwError(state, 'tag name is malformed: ' + tagName);
  }

  if (isVerbatim) {
    state.tag = tagName;

  } else if (_hasOwnProperty$1.call(state.tagMap, tagHandle)) {
    state.tag = state.tagMap[tagHandle] + tagName;

  } else if (tagHandle === '!') {
    state.tag = '!' + tagName;

  } else if (tagHandle === '!!') {
    state.tag = 'tag:yaml.org,2002:' + tagName;

  } else {
    throwError(state, 'undeclared tag handle "' + tagHandle + '"');
  }

  return true;
}

function readAnchorProperty(state) {
  var _position,
      ch;

  ch = state.input.charCodeAt(state.position);

  if (ch !== 0x26/* & */) return false;

  if (state.anchor !== null) {
    throwError(state, 'duplication of an anchor property');
  }

  ch = state.input.charCodeAt(++state.position);
  _position = state.position;

  while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
    ch = state.input.charCodeAt(++state.position);
  }

  if (state.position === _position) {
    throwError(state, 'name of an anchor node must contain at least one character');
  }

  state.anchor = state.input.slice(_position, state.position);
  return true;
}

function readAlias(state) {
  var _position, alias,
      ch;

  ch = state.input.charCodeAt(state.position);

  if (ch !== 0x2A/* * */) return false;

  ch = state.input.charCodeAt(++state.position);
  _position = state.position;

  while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
    ch = state.input.charCodeAt(++state.position);
  }

  if (state.position === _position) {
    throwError(state, 'name of an alias node must contain at least one character');
  }

  alias = state.input.slice(_position, state.position);

  if (!_hasOwnProperty$1.call(state.anchorMap, alias)) {
    throwError(state, 'unidentified alias "' + alias + '"');
  }

  state.result = state.anchorMap[alias];
  skipSeparationSpace(state, true, -1);
  return true;
}

function composeNode(state, parentIndent, nodeContext, allowToSeek, allowCompact) {
  var allowBlockStyles,
      allowBlockScalars,
      allowBlockCollections,
      indentStatus = 1, // 1: this>parent, 0: this=parent, -1: this<parent
      atNewLine  = false,
      hasContent = false,
      typeIndex,
      typeQuantity,
      typeList,
      type,
      flowIndent,
      blockIndent;

  if (state.listener !== null) {
    state.listener('open', state);
  }

  state.tag    = null;
  state.anchor = null;
  state.kind   = null;
  state.result = null;

  allowBlockStyles = allowBlockScalars = allowBlockCollections =
    CONTEXT_BLOCK_OUT === nodeContext ||
    CONTEXT_BLOCK_IN  === nodeContext;

  if (allowToSeek) {
    if (skipSeparationSpace(state, true, -1)) {
      atNewLine = true;

      if (state.lineIndent > parentIndent) {
        indentStatus = 1;
      } else if (state.lineIndent === parentIndent) {
        indentStatus = 0;
      } else if (state.lineIndent < parentIndent) {
        indentStatus = -1;
      }
    }
  }

  if (indentStatus === 1) {
    while (readTagProperty(state) || readAnchorProperty(state)) {
      if (skipSeparationSpace(state, true, -1)) {
        atNewLine = true;
        allowBlockCollections = allowBlockStyles;

        if (state.lineIndent > parentIndent) {
          indentStatus = 1;
        } else if (state.lineIndent === parentIndent) {
          indentStatus = 0;
        } else if (state.lineIndent < parentIndent) {
          indentStatus = -1;
        }
      } else {
        allowBlockCollections = false;
      }
    }
  }

  if (allowBlockCollections) {
    allowBlockCollections = atNewLine || allowCompact;
  }

  if (indentStatus === 1 || CONTEXT_BLOCK_OUT === nodeContext) {
    if (CONTEXT_FLOW_IN === nodeContext || CONTEXT_FLOW_OUT === nodeContext) {
      flowIndent = parentIndent;
    } else {
      flowIndent = parentIndent + 1;
    }

    blockIndent = state.position - state.lineStart;

    if (indentStatus === 1) {
      if (allowBlockCollections &&
          (readBlockSequence(state, blockIndent) ||
           readBlockMapping(state, blockIndent, flowIndent)) ||
          readFlowCollection(state, flowIndent)) {
        hasContent = true;
      } else {
        if ((allowBlockScalars && readBlockScalar(state, flowIndent)) ||
            readSingleQuotedScalar(state, flowIndent) ||
            readDoubleQuotedScalar(state, flowIndent)) {
          hasContent = true;

        } else if (readAlias(state)) {
          hasContent = true;

          if (state.tag !== null || state.anchor !== null) {
            throwError(state, 'alias node should not have any properties');
          }

        } else if (readPlainScalar(state, flowIndent, CONTEXT_FLOW_IN === nodeContext)) {
          hasContent = true;

          if (state.tag === null) {
            state.tag = '?';
          }
        }

        if (state.anchor !== null) {
          state.anchorMap[state.anchor] = state.result;
        }
      }
    } else if (indentStatus === 0) {
      // Special case: block sequences are allowed to have same indentation level as the parent.
      // http://www.yaml.org/spec/1.2/spec.html#id2799784
      hasContent = allowBlockCollections && readBlockSequence(state, blockIndent);
    }
  }

  if (state.tag === null) {
    if (state.anchor !== null) {
      state.anchorMap[state.anchor] = state.result;
    }

  } else if (state.tag === '?') {
    // Implicit resolving is not allowed for non-scalar types, and '?'
    // non-specific tag is only automatically assigned to plain scalars.
    //
    // We only need to check kind conformity in case user explicitly assigns '?'
    // tag, for example like this: "!<?> [0]"
    //
    if (state.result !== null && state.kind !== 'scalar') {
      throwError(state, 'unacceptable node kind for !<?> tag; it should be "scalar", not "' + state.kind + '"');
    }

    for (typeIndex = 0, typeQuantity = state.implicitTypes.length; typeIndex < typeQuantity; typeIndex += 1) {
      type = state.implicitTypes[typeIndex];

      if (type.resolve(state.result)) { // `state.result` updated in resolver if matched
        state.result = type.construct(state.result);
        state.tag = type.tag;
        if (state.anchor !== null) {
          state.anchorMap[state.anchor] = state.result;
        }
        break;
      }
    }
  } else if (state.tag !== '!') {
    if (_hasOwnProperty$1.call(state.typeMap[state.kind || 'fallback'], state.tag)) {
      type = state.typeMap[state.kind || 'fallback'][state.tag];
    } else {
      // looking for multi type
      type = null;
      typeList = state.typeMap.multi[state.kind || 'fallback'];

      for (typeIndex = 0, typeQuantity = typeList.length; typeIndex < typeQuantity; typeIndex += 1) {
        if (state.tag.slice(0, typeList[typeIndex].tag.length) === typeList[typeIndex].tag) {
          type = typeList[typeIndex];
          break;
        }
      }
    }

    if (!type) {
      throwError(state, 'unknown tag !<' + state.tag + '>');
    }

    if (state.result !== null && type.kind !== state.kind) {
      throwError(state, 'unacceptable node kind for !<' + state.tag + '> tag; it should be "' + type.kind + '", not "' + state.kind + '"');
    }

    if (!type.resolve(state.result, state.tag)) { // `state.result` updated in resolver if matched
      throwError(state, 'cannot resolve a node with !<' + state.tag + '> explicit tag');
    } else {
      state.result = type.construct(state.result, state.tag);
      if (state.anchor !== null) {
        state.anchorMap[state.anchor] = state.result;
      }
    }
  }

  if (state.listener !== null) {
    state.listener('close', state);
  }
  return state.tag !== null ||  state.anchor !== null || hasContent;
}

function readDocument(state) {
  var documentStart = state.position,
      _position,
      directiveName,
      directiveArgs,
      hasDirectives = false,
      ch;

  state.version = null;
  state.checkLineBreaks = state.legacy;
  state.tagMap = Object.create(null);
  state.anchorMap = Object.create(null);

  while ((ch = state.input.charCodeAt(state.position)) !== 0) {
    skipSeparationSpace(state, true, -1);

    ch = state.input.charCodeAt(state.position);

    if (state.lineIndent > 0 || ch !== 0x25/* % */) {
      break;
    }

    hasDirectives = true;
    ch = state.input.charCodeAt(++state.position);
    _position = state.position;

    while (ch !== 0 && !is_WS_OR_EOL(ch)) {
      ch = state.input.charCodeAt(++state.position);
    }

    directiveName = state.input.slice(_position, state.position);
    directiveArgs = [];

    if (directiveName.length < 1) {
      throwError(state, 'directive name must not be less than one character in length');
    }

    while (ch !== 0) {
      while (is_WHITE_SPACE(ch)) {
        ch = state.input.charCodeAt(++state.position);
      }

      if (ch === 0x23/* # */) {
        do { ch = state.input.charCodeAt(++state.position); }
        while (ch !== 0 && !is_EOL(ch));
        break;
      }

      if (is_EOL(ch)) break;

      _position = state.position;

      while (ch !== 0 && !is_WS_OR_EOL(ch)) {
        ch = state.input.charCodeAt(++state.position);
      }

      directiveArgs.push(state.input.slice(_position, state.position));
    }

    if (ch !== 0) readLineBreak(state);

    if (_hasOwnProperty$1.call(directiveHandlers, directiveName)) {
      directiveHandlers[directiveName](state, directiveName, directiveArgs);
    } else {
      throwWarning(state, 'unknown document directive "' + directiveName + '"');
    }
  }

  skipSeparationSpace(state, true, -1);

  if (state.lineIndent === 0 &&
      state.input.charCodeAt(state.position)     === 0x2D/* - */ &&
      state.input.charCodeAt(state.position + 1) === 0x2D/* - */ &&
      state.input.charCodeAt(state.position + 2) === 0x2D/* - */) {
    state.position += 3;
    skipSeparationSpace(state, true, -1);

  } else if (hasDirectives) {
    throwError(state, 'directives end mark is expected');
  }

  composeNode(state, state.lineIndent - 1, CONTEXT_BLOCK_OUT, false, true);
  skipSeparationSpace(state, true, -1);

  if (state.checkLineBreaks &&
      PATTERN_NON_ASCII_LINE_BREAKS.test(state.input.slice(documentStart, state.position))) {
    throwWarning(state, 'non-ASCII line breaks are interpreted as content');
  }

  state.documents.push(state.result);

  if (state.position === state.lineStart && testDocumentSeparator(state)) {

    if (state.input.charCodeAt(state.position) === 0x2E/* . */) {
      state.position += 3;
      skipSeparationSpace(state, true, -1);
    }
    return;
  }

  if (state.position < (state.length - 1)) {
    throwError(state, 'end of the stream or a document separator is expected');
  } else {
    return;
  }
}


function loadDocuments(input, options) {
  input = String(input);
  options = options || {};

  if (input.length !== 0) {

    // Add tailing `\n` if not exists
    if (input.charCodeAt(input.length - 1) !== 0x0A/* LF */ &&
        input.charCodeAt(input.length - 1) !== 0x0D/* CR */) {
      input += '\n';
    }

    // Strip BOM
    if (input.charCodeAt(0) === 0xFEFF) {
      input = input.slice(1);
    }
  }

  var state = new State$1(input, options);

  var nullpos = input.indexOf('\0');

  if (nullpos !== -1) {
    state.position = nullpos;
    throwError(state, 'null byte is not allowed in input');
  }

  // Use 0 as string terminator. That significantly simplifies bounds check.
  state.input += '\0';

  while (state.input.charCodeAt(state.position) === 0x20/* Space */) {
    state.lineIndent += 1;
    state.position += 1;
  }

  while (state.position < (state.length - 1)) {
    readDocument(state);
  }

  return state.documents;
}


function loadAll$1(input, iterator, options) {
  if (iterator !== null && typeof iterator === 'object' && typeof options === 'undefined') {
    options = iterator;
    iterator = null;
  }

  var documents = loadDocuments(input, options);

  if (typeof iterator !== 'function') {
    return documents;
  }

  for (var index = 0, length = documents.length; index < length; index += 1) {
    iterator(documents[index]);
  }
}


function load$1(input, options) {
  var documents = loadDocuments(input, options);

  if (documents.length === 0) {
    /*eslint-disable no-undefined*/
    return undefined;
  } else if (documents.length === 1) {
    return documents[0];
  }
  throw new exception('expected a single document in the stream, but found more');
}


var loadAll_1 = loadAll$1;
var load_1    = load$1;

var loader = {
	loadAll: loadAll_1,
	load: load_1
};

/*eslint-disable no-use-before-define*/





var _toString       = Object.prototype.toString;
var _hasOwnProperty = Object.prototype.hasOwnProperty;

var CHAR_BOM                  = 0xFEFF;
var CHAR_TAB                  = 0x09; /* Tab */
var CHAR_LINE_FEED            = 0x0A; /* LF */
var CHAR_CARRIAGE_RETURN      = 0x0D; /* CR */
var CHAR_SPACE                = 0x20; /* Space */
var CHAR_EXCLAMATION          = 0x21; /* ! */
var CHAR_DOUBLE_QUOTE         = 0x22; /* " */
var CHAR_SHARP                = 0x23; /* # */
var CHAR_PERCENT              = 0x25; /* % */
var CHAR_AMPERSAND            = 0x26; /* & */
var CHAR_SINGLE_QUOTE         = 0x27; /* ' */
var CHAR_ASTERISK             = 0x2A; /* * */
var CHAR_COMMA                = 0x2C; /* , */
var CHAR_MINUS                = 0x2D; /* - */
var CHAR_COLON                = 0x3A; /* : */
var CHAR_EQUALS               = 0x3D; /* = */
var CHAR_GREATER_THAN         = 0x3E; /* > */
var CHAR_QUESTION             = 0x3F; /* ? */
var CHAR_COMMERCIAL_AT        = 0x40; /* @ */
var CHAR_LEFT_SQUARE_BRACKET  = 0x5B; /* [ */
var CHAR_RIGHT_SQUARE_BRACKET = 0x5D; /* ] */
var CHAR_GRAVE_ACCENT         = 0x60; /* ` */
var CHAR_LEFT_CURLY_BRACKET   = 0x7B; /* { */
var CHAR_VERTICAL_LINE        = 0x7C; /* | */
var CHAR_RIGHT_CURLY_BRACKET  = 0x7D; /* } */

var ESCAPE_SEQUENCES = {};

ESCAPE_SEQUENCES[0x00]   = '\\0';
ESCAPE_SEQUENCES[0x07]   = '\\a';
ESCAPE_SEQUENCES[0x08]   = '\\b';
ESCAPE_SEQUENCES[0x09]   = '\\t';
ESCAPE_SEQUENCES[0x0A]   = '\\n';
ESCAPE_SEQUENCES[0x0B]   = '\\v';
ESCAPE_SEQUENCES[0x0C]   = '\\f';
ESCAPE_SEQUENCES[0x0D]   = '\\r';
ESCAPE_SEQUENCES[0x1B]   = '\\e';
ESCAPE_SEQUENCES[0x22]   = '\\"';
ESCAPE_SEQUENCES[0x5C]   = '\\\\';
ESCAPE_SEQUENCES[0x85]   = '\\N';
ESCAPE_SEQUENCES[0xA0]   = '\\_';
ESCAPE_SEQUENCES[0x2028] = '\\L';
ESCAPE_SEQUENCES[0x2029] = '\\P';

var DEPRECATED_BOOLEANS_SYNTAX = [
  'y', 'Y', 'yes', 'Yes', 'YES', 'on', 'On', 'ON',
  'n', 'N', 'no', 'No', 'NO', 'off', 'Off', 'OFF'
];

var DEPRECATED_BASE60_SYNTAX = /^[-+]?[0-9_]+(?::[0-9_]+)+(?:\.[0-9_]*)?$/;

function compileStyleMap(schema, map) {
  var result, keys, index, length, tag, style, type;

  if (map === null) return {};

  result = {};
  keys = Object.keys(map);

  for (index = 0, length = keys.length; index < length; index += 1) {
    tag = keys[index];
    style = String(map[tag]);

    if (tag.slice(0, 2) === '!!') {
      tag = 'tag:yaml.org,2002:' + tag.slice(2);
    }
    type = schema.compiledTypeMap['fallback'][tag];

    if (type && _hasOwnProperty.call(type.styleAliases, style)) {
      style = type.styleAliases[style];
    }

    result[tag] = style;
  }

  return result;
}

function encodeHex(character) {
  var string, handle, length;

  string = character.toString(16).toUpperCase();

  if (character <= 0xFF) {
    handle = 'x';
    length = 2;
  } else if (character <= 0xFFFF) {
    handle = 'u';
    length = 4;
  } else if (character <= 0xFFFFFFFF) {
    handle = 'U';
    length = 8;
  } else {
    throw new exception('code point within a string may not be greater than 0xFFFFFFFF');
  }

  return '\\' + handle + common.repeat('0', length - string.length) + string;
}


var QUOTING_TYPE_SINGLE = 1,
    QUOTING_TYPE_DOUBLE = 2;

function State(options) {
  this.schema        = options['schema'] || _default;
  this.indent        = Math.max(1, (options['indent'] || 2));
  this.noArrayIndent = options['noArrayIndent'] || false;
  this.skipInvalid   = options['skipInvalid'] || false;
  this.flowLevel     = (common.isNothing(options['flowLevel']) ? -1 : options['flowLevel']);
  this.styleMap      = compileStyleMap(this.schema, options['styles'] || null);
  this.sortKeys      = options['sortKeys'] || false;
  this.lineWidth     = options['lineWidth'] || 80;
  this.noRefs        = options['noRefs'] || false;
  this.noCompatMode  = options['noCompatMode'] || false;
  this.condenseFlow  = options['condenseFlow'] || false;
  this.quotingType   = options['quotingType'] === '"' ? QUOTING_TYPE_DOUBLE : QUOTING_TYPE_SINGLE;
  this.forceQuotes   = options['forceQuotes'] || false;
  this.replacer      = typeof options['replacer'] === 'function' ? options['replacer'] : null;

  this.implicitTypes = this.schema.compiledImplicit;
  this.explicitTypes = this.schema.compiledExplicit;

  this.tag = null;
  this.result = '';

  this.duplicates = [];
  this.usedDuplicates = null;
}

// Indents every line in a string. Empty lines (\n only) are not indented.
function indentString(string, spaces) {
  var ind = common.repeat(' ', spaces),
      position = 0,
      next = -1,
      result = '',
      line,
      length = string.length;

  while (position < length) {
    next = string.indexOf('\n', position);
    if (next === -1) {
      line = string.slice(position);
      position = length;
    } else {
      line = string.slice(position, next + 1);
      position = next + 1;
    }

    if (line.length && line !== '\n') result += ind;

    result += line;
  }

  return result;
}

function generateNextLine(state, level) {
  return '\n' + common.repeat(' ', state.indent * level);
}

function testImplicitResolving(state, str) {
  var index, length, type;

  for (index = 0, length = state.implicitTypes.length; index < length; index += 1) {
    type = state.implicitTypes[index];

    if (type.resolve(str)) {
      return true;
    }
  }

  return false;
}

// [33] s-white ::= s-space | s-tab
function isWhitespace(c) {
  return c === CHAR_SPACE || c === CHAR_TAB;
}

// Returns true if the character can be printed without escaping.
// From YAML 1.2: "any allowed characters known to be non-printable
// should also be escaped. [However,] This isn’t mandatory"
// Derived from nb-char - \t - #x85 - #xA0 - #x2028 - #x2029.
function isPrintable(c) {
  return  (0x00020 <= c && c <= 0x00007E)
      || ((0x000A1 <= c && c <= 0x00D7FF) && c !== 0x2028 && c !== 0x2029)
      || ((0x0E000 <= c && c <= 0x00FFFD) && c !== CHAR_BOM)
      ||  (0x10000 <= c && c <= 0x10FFFF);
}

// [34] ns-char ::= nb-char - s-white
// [27] nb-char ::= c-printable - b-char - c-byte-order-mark
// [26] b-char  ::= b-line-feed | b-carriage-return
// Including s-white (for some reason, examples doesn't match specs in this aspect)
// ns-char ::= c-printable - b-line-feed - b-carriage-return - c-byte-order-mark
function isNsCharOrWhitespace(c) {
  return isPrintable(c)
    && c !== CHAR_BOM
    // - b-char
    && c !== CHAR_CARRIAGE_RETURN
    && c !== CHAR_LINE_FEED;
}

// [127]  ns-plain-safe(c) ::= c = flow-out  ⇒ ns-plain-safe-out
//                             c = flow-in   ⇒ ns-plain-safe-in
//                             c = block-key ⇒ ns-plain-safe-out
//                             c = flow-key  ⇒ ns-plain-safe-in
// [128] ns-plain-safe-out ::= ns-char
// [129]  ns-plain-safe-in ::= ns-char - c-flow-indicator
// [130]  ns-plain-char(c) ::=  ( ns-plain-safe(c) - “:” - “#” )
//                            | ( /* An ns-char preceding */ “#” )
//                            | ( “:” /* Followed by an ns-plain-safe(c) */ )
function isPlainSafe(c, prev, inblock) {
  var cIsNsCharOrWhitespace = isNsCharOrWhitespace(c);
  var cIsNsChar = cIsNsCharOrWhitespace && !isWhitespace(c);
  return (
    // ns-plain-safe
    inblock ? // c = flow-in
      cIsNsCharOrWhitespace
      : cIsNsCharOrWhitespace
        // - c-flow-indicator
        && c !== CHAR_COMMA
        && c !== CHAR_LEFT_SQUARE_BRACKET
        && c !== CHAR_RIGHT_SQUARE_BRACKET
        && c !== CHAR_LEFT_CURLY_BRACKET
        && c !== CHAR_RIGHT_CURLY_BRACKET
  )
    // ns-plain-char
    && c !== CHAR_SHARP // false on '#'
    && !(prev === CHAR_COLON && !cIsNsChar) // false on ': '
    || (isNsCharOrWhitespace(prev) && !isWhitespace(prev) && c === CHAR_SHARP) // change to true on '[^ ]#'
    || (prev === CHAR_COLON && cIsNsChar); // change to true on ':[^ ]'
}

// Simplified test for values allowed as the first character in plain style.
function isPlainSafeFirst(c) {
  // Uses a subset of ns-char - c-indicator
  // where ns-char = nb-char - s-white.
  // No support of ( ( “?” | “:” | “-” ) /* Followed by an ns-plain-safe(c)) */ ) part
  return isPrintable(c) && c !== CHAR_BOM
    && !isWhitespace(c) // - s-white
    // - (c-indicator ::=
    // “-” | “?” | “:” | “,” | “[” | “]” | “{” | “}”
    && c !== CHAR_MINUS
    && c !== CHAR_QUESTION
    && c !== CHAR_COLON
    && c !== CHAR_COMMA
    && c !== CHAR_LEFT_SQUARE_BRACKET
    && c !== CHAR_RIGHT_SQUARE_BRACKET
    && c !== CHAR_LEFT_CURLY_BRACKET
    && c !== CHAR_RIGHT_CURLY_BRACKET
    // | “#” | “&” | “*” | “!” | “|” | “=” | “>” | “'” | “"”
    && c !== CHAR_SHARP
    && c !== CHAR_AMPERSAND
    && c !== CHAR_ASTERISK
    && c !== CHAR_EXCLAMATION
    && c !== CHAR_VERTICAL_LINE
    && c !== CHAR_EQUALS
    && c !== CHAR_GREATER_THAN
    && c !== CHAR_SINGLE_QUOTE
    && c !== CHAR_DOUBLE_QUOTE
    // | “%” | “@” | “`”)
    && c !== CHAR_PERCENT
    && c !== CHAR_COMMERCIAL_AT
    && c !== CHAR_GRAVE_ACCENT;
}

// Simplified test for values allowed as the last character in plain style.
function isPlainSafeLast(c) {
  // just not whitespace or colon, it will be checked to be plain character later
  return !isWhitespace(c) && c !== CHAR_COLON;
}

// Same as 'string'.codePointAt(pos), but works in older browsers.
function codePointAt(string, pos) {
  var first = string.charCodeAt(pos), second;
  if (first >= 0xD800 && first <= 0xDBFF && pos + 1 < string.length) {
    second = string.charCodeAt(pos + 1);
    if (second >= 0xDC00 && second <= 0xDFFF) {
      // https://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
      return (first - 0xD800) * 0x400 + second - 0xDC00 + 0x10000;
    }
  }
  return first;
}

// Determines whether block indentation indicator is required.
function needIndentIndicator(string) {
  var leadingSpaceRe = /^\n* /;
  return leadingSpaceRe.test(string);
}

var STYLE_PLAIN   = 1,
    STYLE_SINGLE  = 2,
    STYLE_LITERAL = 3,
    STYLE_FOLDED  = 4,
    STYLE_DOUBLE  = 5;

// Determines which scalar styles are possible and returns the preferred style.
// lineWidth = -1 => no limit.
// Pre-conditions: str.length > 0.
// Post-conditions:
//    STYLE_PLAIN or STYLE_SINGLE => no \n are in the string.
//    STYLE_LITERAL => no lines are suitable for folding (or lineWidth is -1).
//    STYLE_FOLDED => a line > lineWidth and can be folded (and lineWidth != -1).
function chooseScalarStyle(string, singleLineOnly, indentPerLevel, lineWidth,
  testAmbiguousType, quotingType, forceQuotes, inblock) {

  var i;
  var char = 0;
  var prevChar = null;
  var hasLineBreak = false;
  var hasFoldableLine = false; // only checked if shouldTrackWidth
  var shouldTrackWidth = lineWidth !== -1;
  var previousLineBreak = -1; // count the first line correctly
  var plain = isPlainSafeFirst(codePointAt(string, 0))
          && isPlainSafeLast(codePointAt(string, string.length - 1));

  if (singleLineOnly || forceQuotes) {
    // Case: no block styles.
    // Check for disallowed characters to rule out plain and single.
    for (i = 0; i < string.length; char >= 0x10000 ? i += 2 : i++) {
      char = codePointAt(string, i);
      if (!isPrintable(char)) {
        return STYLE_DOUBLE;
      }
      plain = plain && isPlainSafe(char, prevChar, inblock);
      prevChar = char;
    }
  } else {
    // Case: block styles permitted.
    for (i = 0; i < string.length; char >= 0x10000 ? i += 2 : i++) {
      char = codePointAt(string, i);
      if (char === CHAR_LINE_FEED) {
        hasLineBreak = true;
        // Check if any line can be folded.
        if (shouldTrackWidth) {
          hasFoldableLine = hasFoldableLine ||
            // Foldable line = too long, and not more-indented.
            (i - previousLineBreak - 1 > lineWidth &&
             string[previousLineBreak + 1] !== ' ');
          previousLineBreak = i;
        }
      } else if (!isPrintable(char)) {
        return STYLE_DOUBLE;
      }
      plain = plain && isPlainSafe(char, prevChar, inblock);
      prevChar = char;
    }
    // in case the end is missing a \n
    hasFoldableLine = hasFoldableLine || (shouldTrackWidth &&
      (i - previousLineBreak - 1 > lineWidth &&
       string[previousLineBreak + 1] !== ' '));
  }
  // Although every style can represent \n without escaping, prefer block styles
  // for multiline, since they're more readable and they don't add empty lines.
  // Also prefer folding a super-long line.
  if (!hasLineBreak && !hasFoldableLine) {
    // Strings interpretable as another type have to be quoted;
    // e.g. the string 'true' vs. the boolean true.
    if (plain && !forceQuotes && !testAmbiguousType(string)) {
      return STYLE_PLAIN;
    }
    return quotingType === QUOTING_TYPE_DOUBLE ? STYLE_DOUBLE : STYLE_SINGLE;
  }
  // Edge case: block indentation indicator can only have one digit.
  if (indentPerLevel > 9 && needIndentIndicator(string)) {
    return STYLE_DOUBLE;
  }
  // At this point we know block styles are valid.
  // Prefer literal style unless we want to fold.
  if (!forceQuotes) {
    return hasFoldableLine ? STYLE_FOLDED : STYLE_LITERAL;
  }
  return quotingType === QUOTING_TYPE_DOUBLE ? STYLE_DOUBLE : STYLE_SINGLE;
}

// Note: line breaking/folding is implemented for only the folded style.
// NB. We drop the last trailing newline (if any) of a returned block scalar
//  since the dumper adds its own newline. This always works:
//    • No ending newline => unaffected; already using strip "-" chomping.
//    • Ending newline    => removed then restored.
//  Importantly, this keeps the "+" chomp indicator from gaining an extra line.
function writeScalar(state, string, level, iskey, inblock) {
  state.dump = (function () {
    if (string.length === 0) {
      return state.quotingType === QUOTING_TYPE_DOUBLE ? '""' : "''";
    }
    if (!state.noCompatMode) {
      if (DEPRECATED_BOOLEANS_SYNTAX.indexOf(string) !== -1 || DEPRECATED_BASE60_SYNTAX.test(string)) {
        return state.quotingType === QUOTING_TYPE_DOUBLE ? ('"' + string + '"') : ("'" + string + "'");
      }
    }

    var indent = state.indent * Math.max(1, level); // no 0-indent scalars
    // As indentation gets deeper, let the width decrease monotonically
    // to the lower bound min(state.lineWidth, 40).
    // Note that this implies
    //  state.lineWidth ≤ 40 + state.indent: width is fixed at the lower bound.
    //  state.lineWidth > 40 + state.indent: width decreases until the lower bound.
    // This behaves better than a constant minimum width which disallows narrower options,
    // or an indent threshold which causes the width to suddenly increase.
    var lineWidth = state.lineWidth === -1
      ? -1 : Math.max(Math.min(state.lineWidth, 40), state.lineWidth - indent);

    // Without knowing if keys are implicit/explicit, assume implicit for safety.
    var singleLineOnly = iskey
      // No block styles in flow mode.
      || (state.flowLevel > -1 && level >= state.flowLevel);
    function testAmbiguity(string) {
      return testImplicitResolving(state, string);
    }

    switch (chooseScalarStyle(string, singleLineOnly, state.indent, lineWidth,
      testAmbiguity, state.quotingType, state.forceQuotes && !iskey, inblock)) {

      case STYLE_PLAIN:
        return string;
      case STYLE_SINGLE:
        return "'" + string.replace(/'/g, "''") + "'";
      case STYLE_LITERAL:
        return '|' + blockHeader(string, state.indent)
          + dropEndingNewline(indentString(string, indent));
      case STYLE_FOLDED:
        return '>' + blockHeader(string, state.indent)
          + dropEndingNewline(indentString(foldString(string, lineWidth), indent));
      case STYLE_DOUBLE:
        return '"' + escapeString(string) + '"';
      default:
        throw new exception('impossible error: invalid scalar style');
    }
  }());
}

// Pre-conditions: string is valid for a block scalar, 1 <= indentPerLevel <= 9.
function blockHeader(string, indentPerLevel) {
  var indentIndicator = needIndentIndicator(string) ? String(indentPerLevel) : '';

  // note the special case: the string '\n' counts as a "trailing" empty line.
  var clip =          string[string.length - 1] === '\n';
  var keep = clip && (string[string.length - 2] === '\n' || string === '\n');
  var chomp = keep ? '+' : (clip ? '' : '-');

  return indentIndicator + chomp + '\n';
}

// (See the note for writeScalar.)
function dropEndingNewline(string) {
  return string[string.length - 1] === '\n' ? string.slice(0, -1) : string;
}

// Note: a long line without a suitable break point will exceed the width limit.
// Pre-conditions: every char in str isPrintable, str.length > 0, width > 0.
function foldString(string, width) {
  // In folded style, $k$ consecutive newlines output as $k+1$ newlines—
  // unless they're before or after a more-indented line, or at the very
  // beginning or end, in which case $k$ maps to $k$.
  // Therefore, parse each chunk as newline(s) followed by a content line.
  var lineRe = /(\n+)([^\n]*)/g;

  // first line (possibly an empty line)
  var result = (function () {
    var nextLF = string.indexOf('\n');
    nextLF = nextLF !== -1 ? nextLF : string.length;
    lineRe.lastIndex = nextLF;
    return foldLine(string.slice(0, nextLF), width);
  }());
  // If we haven't reached the first content line yet, don't add an extra \n.
  var prevMoreIndented = string[0] === '\n' || string[0] === ' ';
  var moreIndented;

  // rest of the lines
  var match;
  while ((match = lineRe.exec(string))) {
    var prefix = match[1], line = match[2];
    moreIndented = (line[0] === ' ');
    result += prefix
      + (!prevMoreIndented && !moreIndented && line !== ''
        ? '\n' : '')
      + foldLine(line, width);
    prevMoreIndented = moreIndented;
  }

  return result;
}

// Greedy line breaking.
// Picks the longest line under the limit each time,
// otherwise settles for the shortest line over the limit.
// NB. More-indented lines *cannot* be folded, as that would add an extra \n.
function foldLine(line, width) {
  if (line === '' || line[0] === ' ') return line;

  // Since a more-indented line adds a \n, breaks can't be followed by a space.
  var breakRe = / [^ ]/g; // note: the match index will always be <= length-2.
  var match;
  // start is an inclusive index. end, curr, and next are exclusive.
  var start = 0, end, curr = 0, next = 0;
  var result = '';

  // Invariants: 0 <= start <= length-1.
  //   0 <= curr <= next <= max(0, length-2). curr - start <= width.
  // Inside the loop:
  //   A match implies length >= 2, so curr and next are <= length-2.
  while ((match = breakRe.exec(line))) {
    next = match.index;
    // maintain invariant: curr - start <= width
    if (next - start > width) {
      end = (curr > start) ? curr : next; // derive end <= length-2
      result += '\n' + line.slice(start, end);
      // skip the space that was output as \n
      start = end + 1;                    // derive start <= length-1
    }
    curr = next;
  }

  // By the invariants, start <= length-1, so there is something left over.
  // It is either the whole string or a part starting from non-whitespace.
  result += '\n';
  // Insert a break if the remainder is too long and there is a break available.
  if (line.length - start > width && curr > start) {
    result += line.slice(start, curr) + '\n' + line.slice(curr + 1);
  } else {
    result += line.slice(start);
  }

  return result.slice(1); // drop extra \n joiner
}

// Escapes a double-quoted string.
function escapeString(string) {
  var result = '';
  var char = 0;
  var escapeSeq;

  for (var i = 0; i < string.length; char >= 0x10000 ? i += 2 : i++) {
    char = codePointAt(string, i);
    escapeSeq = ESCAPE_SEQUENCES[char];

    if (!escapeSeq && isPrintable(char)) {
      result += string[i];
      if (char >= 0x10000) result += string[i + 1];
    } else {
      result += escapeSeq || encodeHex(char);
    }
  }

  return result;
}

function writeFlowSequence(state, level, object) {
  var _result = '',
      _tag    = state.tag,
      index,
      length,
      value;

  for (index = 0, length = object.length; index < length; index += 1) {
    value = object[index];

    if (state.replacer) {
      value = state.replacer.call(object, String(index), value);
    }

    // Write only valid elements, put null instead of invalid elements.
    if (writeNode(state, level, value, false, false) ||
        (typeof value === 'undefined' &&
         writeNode(state, level, null, false, false))) {

      if (_result !== '') _result += ',' + (!state.condenseFlow ? ' ' : '');
      _result += state.dump;
    }
  }

  state.tag = _tag;
  state.dump = '[' + _result + ']';
}

function writeBlockSequence(state, level, object, compact) {
  var _result = '',
      _tag    = state.tag,
      index,
      length,
      value;

  for (index = 0, length = object.length; index < length; index += 1) {
    value = object[index];

    if (state.replacer) {
      value = state.replacer.call(object, String(index), value);
    }

    // Write only valid elements, put null instead of invalid elements.
    if (writeNode(state, level + 1, value, true, true, false, true) ||
        (typeof value === 'undefined' &&
         writeNode(state, level + 1, null, true, true, false, true))) {

      if (!compact || _result !== '') {
        _result += generateNextLine(state, level);
      }

      if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
        _result += '-';
      } else {
        _result += '- ';
      }

      _result += state.dump;
    }
  }

  state.tag = _tag;
  state.dump = _result || '[]'; // Empty sequence if no valid values.
}

function writeFlowMapping(state, level, object) {
  var _result       = '',
      _tag          = state.tag,
      objectKeyList = Object.keys(object),
      index,
      length,
      objectKey,
      objectValue,
      pairBuffer;

  for (index = 0, length = objectKeyList.length; index < length; index += 1) {

    pairBuffer = '';
    if (_result !== '') pairBuffer += ', ';

    if (state.condenseFlow) pairBuffer += '"';

    objectKey = objectKeyList[index];
    objectValue = object[objectKey];

    if (state.replacer) {
      objectValue = state.replacer.call(object, objectKey, objectValue);
    }

    if (!writeNode(state, level, objectKey, false, false)) {
      continue; // Skip this pair because of invalid key;
    }

    if (state.dump.length > 1024) pairBuffer += '? ';

    pairBuffer += state.dump + (state.condenseFlow ? '"' : '') + ':' + (state.condenseFlow ? '' : ' ');

    if (!writeNode(state, level, objectValue, false, false)) {
      continue; // Skip this pair because of invalid value.
    }

    pairBuffer += state.dump;

    // Both key and value are valid.
    _result += pairBuffer;
  }

  state.tag = _tag;
  state.dump = '{' + _result + '}';
}

function writeBlockMapping(state, level, object, compact) {
  var _result       = '',
      _tag          = state.tag,
      objectKeyList = Object.keys(object),
      index,
      length,
      objectKey,
      objectValue,
      explicitPair,
      pairBuffer;

  // Allow sorting keys so that the output file is deterministic
  if (state.sortKeys === true) {
    // Default sorting
    objectKeyList.sort();
  } else if (typeof state.sortKeys === 'function') {
    // Custom sort function
    objectKeyList.sort(state.sortKeys);
  } else if (state.sortKeys) {
    // Something is wrong
    throw new exception('sortKeys must be a boolean or a function');
  }

  for (index = 0, length = objectKeyList.length; index < length; index += 1) {
    pairBuffer = '';

    if (!compact || _result !== '') {
      pairBuffer += generateNextLine(state, level);
    }

    objectKey = objectKeyList[index];
    objectValue = object[objectKey];

    if (state.replacer) {
      objectValue = state.replacer.call(object, objectKey, objectValue);
    }

    if (!writeNode(state, level + 1, objectKey, true, true, true)) {
      continue; // Skip this pair because of invalid key.
    }

    explicitPair = (state.tag !== null && state.tag !== '?') ||
                   (state.dump && state.dump.length > 1024);

    if (explicitPair) {
      if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
        pairBuffer += '?';
      } else {
        pairBuffer += '? ';
      }
    }

    pairBuffer += state.dump;

    if (explicitPair) {
      pairBuffer += generateNextLine(state, level);
    }

    if (!writeNode(state, level + 1, objectValue, true, explicitPair)) {
      continue; // Skip this pair because of invalid value.
    }

    if (state.dump && CHAR_LINE_FEED === state.dump.charCodeAt(0)) {
      pairBuffer += ':';
    } else {
      pairBuffer += ': ';
    }

    pairBuffer += state.dump;

    // Both key and value are valid.
    _result += pairBuffer;
  }

  state.tag = _tag;
  state.dump = _result || '{}'; // Empty mapping if no valid pairs.
}

function detectType(state, object, explicit) {
  var _result, typeList, index, length, type, style;

  typeList = explicit ? state.explicitTypes : state.implicitTypes;

  for (index = 0, length = typeList.length; index < length; index += 1) {
    type = typeList[index];

    if ((type.instanceOf  || type.predicate) &&
        (!type.instanceOf || ((typeof object === 'object') && (object instanceof type.instanceOf))) &&
        (!type.predicate  || type.predicate(object))) {

      if (explicit) {
        if (type.multi && type.representName) {
          state.tag = type.representName(object);
        } else {
          state.tag = type.tag;
        }
      } else {
        state.tag = '?';
      }

      if (type.represent) {
        style = state.styleMap[type.tag] || type.defaultStyle;

        if (_toString.call(type.represent) === '[object Function]') {
          _result = type.represent(object, style);
        } else if (_hasOwnProperty.call(type.represent, style)) {
          _result = type.represent[style](object, style);
        } else {
          throw new exception('!<' + type.tag + '> tag resolver accepts not "' + style + '" style');
        }

        state.dump = _result;
      }

      return true;
    }
  }

  return false;
}

// Serializes `object` and writes it to global `result`.
// Returns true on success, or false on invalid object.
//
function writeNode(state, level, object, block, compact, iskey, isblockseq) {
  state.tag = null;
  state.dump = object;

  if (!detectType(state, object, false)) {
    detectType(state, object, true);
  }

  var type = _toString.call(state.dump);
  var inblock = block;
  var tagStr;

  if (block) {
    block = (state.flowLevel < 0 || state.flowLevel > level);
  }

  var objectOrArray = type === '[object Object]' || type === '[object Array]',
      duplicateIndex,
      duplicate;

  if (objectOrArray) {
    duplicateIndex = state.duplicates.indexOf(object);
    duplicate = duplicateIndex !== -1;
  }

  if ((state.tag !== null && state.tag !== '?') || duplicate || (state.indent !== 2 && level > 0)) {
    compact = false;
  }

  if (duplicate && state.usedDuplicates[duplicateIndex]) {
    state.dump = '*ref_' + duplicateIndex;
  } else {
    if (objectOrArray && duplicate && !state.usedDuplicates[duplicateIndex]) {
      state.usedDuplicates[duplicateIndex] = true;
    }
    if (type === '[object Object]') {
      if (block && (Object.keys(state.dump).length !== 0)) {
        writeBlockMapping(state, level, state.dump, compact);
        if (duplicate) {
          state.dump = '&ref_' + duplicateIndex + state.dump;
        }
      } else {
        writeFlowMapping(state, level, state.dump);
        if (duplicate) {
          state.dump = '&ref_' + duplicateIndex + ' ' + state.dump;
        }
      }
    } else if (type === '[object Array]') {
      if (block && (state.dump.length !== 0)) {
        if (state.noArrayIndent && !isblockseq && level > 0) {
          writeBlockSequence(state, level - 1, state.dump, compact);
        } else {
          writeBlockSequence(state, level, state.dump, compact);
        }
        if (duplicate) {
          state.dump = '&ref_' + duplicateIndex + state.dump;
        }
      } else {
        writeFlowSequence(state, level, state.dump);
        if (duplicate) {
          state.dump = '&ref_' + duplicateIndex + ' ' + state.dump;
        }
      }
    } else if (type === '[object String]') {
      if (state.tag !== '?') {
        writeScalar(state, state.dump, level, iskey, inblock);
      }
    } else if (type === '[object Undefined]') {
      return false;
    } else {
      if (state.skipInvalid) return false;
      throw new exception('unacceptable kind of an object to dump ' + type);
    }

    if (state.tag !== null && state.tag !== '?') {
      // Need to encode all characters except those allowed by the spec:
      //
      // [35] ns-dec-digit    ::=  [#x30-#x39] /* 0-9 */
      // [36] ns-hex-digit    ::=  ns-dec-digit
      //                         | [#x41-#x46] /* A-F */ | [#x61-#x66] /* a-f */
      // [37] ns-ascii-letter ::=  [#x41-#x5A] /* A-Z */ | [#x61-#x7A] /* a-z */
      // [38] ns-word-char    ::=  ns-dec-digit | ns-ascii-letter | “-”
      // [39] ns-uri-char     ::=  “%” ns-hex-digit ns-hex-digit | ns-word-char | “#”
      //                         | “;” | “/” | “?” | “:” | “@” | “&” | “=” | “+” | “$” | “,”
      //                         | “_” | “.” | “!” | “~” | “*” | “'” | “(” | “)” | “[” | “]”
      //
      // Also need to encode '!' because it has special meaning (end of tag prefix).
      //
      tagStr = encodeURI(
        state.tag[0] === '!' ? state.tag.slice(1) : state.tag
      ).replace(/!/g, '%21');

      if (state.tag[0] === '!') {
        tagStr = '!' + tagStr;
      } else if (tagStr.slice(0, 18) === 'tag:yaml.org,2002:') {
        tagStr = '!!' + tagStr.slice(18);
      } else {
        tagStr = '!<' + tagStr + '>';
      }

      state.dump = tagStr + ' ' + state.dump;
    }
  }

  return true;
}

function getDuplicateReferences(object, state) {
  var objects = [],
      duplicatesIndexes = [],
      index,
      length;

  inspectNode(object, objects, duplicatesIndexes);

  for (index = 0, length = duplicatesIndexes.length; index < length; index += 1) {
    state.duplicates.push(objects[duplicatesIndexes[index]]);
  }
  state.usedDuplicates = new Array(length);
}

function inspectNode(object, objects, duplicatesIndexes) {
  var objectKeyList,
      index,
      length;

  if (object !== null && typeof object === 'object') {
    index = objects.indexOf(object);
    if (index !== -1) {
      if (duplicatesIndexes.indexOf(index) === -1) {
        duplicatesIndexes.push(index);
      }
    } else {
      objects.push(object);

      if (Array.isArray(object)) {
        for (index = 0, length = object.length; index < length; index += 1) {
          inspectNode(object[index], objects, duplicatesIndexes);
        }
      } else {
        objectKeyList = Object.keys(object);

        for (index = 0, length = objectKeyList.length; index < length; index += 1) {
          inspectNode(object[objectKeyList[index]], objects, duplicatesIndexes);
        }
      }
    }
  }
}

function dump$1(input, options) {
  options = options || {};

  var state = new State(options);

  if (!state.noRefs) getDuplicateReferences(input, state);

  var value = input;

  if (state.replacer) {
    value = state.replacer.call({ '': value }, '', value);
  }

  if (writeNode(state, 0, value, true, true)) return state.dump + '\n';

  return '';
}

var dump_1 = dump$1;

var dumper = {
	dump: dump_1
};

function renamed(from, to) {
  return function () {
    throw new Error('Function yaml.' + from + ' is removed in js-yaml 4. ' +
      'Use yaml.' + to + ' instead, which is now safe by default.');
  };
}


var Type                = type;
var Schema              = schema;
var FAILSAFE_SCHEMA     = failsafe;
var JSON_SCHEMA         = json;
var CORE_SCHEMA         = core;
var DEFAULT_SCHEMA      = _default;
var load                = loader.load;
var loadAll             = loader.loadAll;
var dump                = dumper.dump;
var YAMLException       = exception;

// Re-export all types in case user wants to create custom schema
var types = {
  binary:    binary,
  float:     float,
  map:       map,
  null:      _null,
  pairs:     pairs,
  set:       set,
  timestamp: timestamp,
  bool:      bool,
  int:       int,
  merge:     merge,
  omap:      omap,
  seq:       seq,
  str:       str
};

// Removed functions from JS-YAML 3.0.x
var safeLoad            = renamed('safeLoad', 'load');
var safeLoadAll         = renamed('safeLoadAll', 'loadAll');
var safeDump            = renamed('safeDump', 'dump');

var jsYaml = {
	Type: Type,
	Schema: Schema,
	FAILSAFE_SCHEMA: FAILSAFE_SCHEMA,
	JSON_SCHEMA: JSON_SCHEMA,
	CORE_SCHEMA: CORE_SCHEMA,
	DEFAULT_SCHEMA: DEFAULT_SCHEMA,
	load: load,
	loadAll: loadAll,
	dump: dump,
	YAMLException: YAMLException,
	types: types,
	safeLoad: safeLoad,
	safeLoadAll: safeLoadAll,
	safeDump: safeDump
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (jsYaml);



/***/ }),

/***/ 20464:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isNumber)
/* harmony export */ });
function _isNumber(x) {
  return Object.prototype.toString.call(x) === '[object Number]';
}

/***/ }),

/***/ 20502:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(77259);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(27121);
/* harmony import */ var _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(65304);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9748);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);







/**
 * @public
 */
/**
 * @public
 */
class PathItemVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_PathItem_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'PathItem']);
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate Operation elements with HTTP method
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isOperationElement)
    // @ts-ignore
    .forEach((operationElement, httpMethodElementCI) => {
      const httpMethodElementCS = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.cloneDeep)(httpMethodElementCI);
      httpMethodElementCS.content = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__["default"])(httpMethodElementCS).toUpperCase();
      operationElement.setMetaProperty('http-method', httpMethodElementCS);
    });

    // mark this PathItemElement with reference metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__.isStringElement)(this.element.$ref)) {
      this.element.classes.push('reference-element');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PathItemVisitor);

/***/ }),

/***/ 20575:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toLength = __webpack_require__(3121);

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
module.exports = function (obj) {
  return toLength(obj.length);
};


/***/ }),

/***/ 20586:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3182);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(77259);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(60020);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);



/**
 * @public
 */
/**
 * @public
 */
class PatternedFieldsVisitor extends _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  specPath;
  ignoredFields;
  fieldPatternPredicate = ramda__WEBPACK_IMPORTED_MODULE_1__["default"];
  constructor({
    specPath,
    ignoredFields,
    fieldPatternPredicate,
    ...rest
  }) {
    super({
      ...rest
    });
    this.specPath = specPath;
    this.ignoredFields = ignoredFields || [];
    if (typeof fieldPatternPredicate === 'function') {
      this.fieldPatternPredicate = fieldPatternPredicate;
    }
  }
  ObjectElement(objectElement) {
    // @ts-ignore
    objectElement.forEach((value, key, memberElement) => {
      if (!this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key)) && this.fieldPatternPredicate((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key))) {
        const specPath = this.specPath(value);
        const patternedFieldElement = this.toRefractedElement(specPath, value);
        const newMemberElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__.MemberElement((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.cloneDeep)(key), patternedFieldElement);
        this.copyMetaAndAttributes(memberElement, newMemberElement);
        newMemberElement.classes.push('patterned-field');
        this.element.content.push(newMemberElement);
      } else if (!this.ignoredFields.includes((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__["default"])(key))) {
        this.element.content.push((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.cloneDeep)(memberElement));
      }
    });
    this.copyMetaAndAttributes(objectElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PatternedFieldsVisitor);

/***/ }),

/***/ 20798:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var globalThis = __webpack_require__(45951);
var userAgent = __webpack_require__(96794);

var process = globalThis.process;
var Deno = globalThis.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
  // but their correct versions are not interesting for us
  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}

// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
// so check `userAgent` even if `.v8` exists, but 0
if (!version && userAgent) {
  match = userAgent.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent.match(/Chrome\/(\d+)/);
    if (match) version = +match[1];
  }
}

module.exports = version;


/***/ }),

/***/ 20822:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _isObject)
/* harmony export */ });
function _isObject(x) {
  return Object.prototype.toString.call(x) === '[object Object]';
}

/***/ }),

/***/ 20835:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ParseError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58155);

/**
 * @public
 */
class ParserError extends _ParseError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParserError);

/***/ }),

/***/ 20850:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

module.exports = __webpack_require__(46076);


/***/ }),

/***/ 21111:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6557);
/* harmony import */ var _elements_nces_HeaderExamples_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(95398);


/**
 * @public
 */
class ExamplesVisitor extends _ExamplesVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_HeaderExamples_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExamplesVisitor);

/***/ }),

/***/ 21365:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5051);

/**
 * @public
 */
class $RefVisitor extends _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  StringElement(stringElement) {
    const result = super.enter(stringElement);
    this.element.classes.push('reference-value');
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ($RefVisitor);

/***/ }),

/***/ 21504:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(26183);


/**
 * A function that returns `undefined`.
 *
 * @func stubUndefined
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/1.0.0|v1.0.0}
 * @category Function
 * @sig ... -> undefined
 * @return {undefined}
 * @example
 *
 * RA.stubUndefined(); //=> undefined
 * RA.stubUndefined(1, 2, 3); //=> undefined
 */
var stubUndefined = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(void 0); // eslint-disable-line no-void

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (stubUndefined);

/***/ }),

/***/ 21513:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48018);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(91132);




/**
 * @public
 */

/**
 * @public
 */
class SchemasVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"], _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Schema']);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemasVisitor);

/***/ }),

/***/ 21549:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var hashClear = __webpack_require__(22032),
    hashDelete = __webpack_require__(63862),
    hashGet = __webpack_require__(66721),
    hashHas = __webpack_require__(12749),
    hashSet = __webpack_require__(35749);

/**
 * Creates a hash object.
 *
 * @private
 * @constructor
 * @param {Array} [entries] The key-value pairs to cache.
 */
function Hash(entries) {
  var index = -1,
      length = entries == null ? 0 : entries.length;

  this.clear();
  while (++index < length) {
    var entry = entries[index];
    this.set(entry[0], entry[1]);
  }
}

// Add methods to `Hash`.
Hash.prototype.clear = hashClear;
Hash.prototype['delete'] = hashDelete;
Hash.prototype.get = hashGet;
Hash.prototype.has = hashHas;
Hash.prototype.set = hashSet;

module.exports = Hash;


/***/ }),

/***/ 21664:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ContextTree)
/* harmony export */ });
class ContextTree {
  constructor(value) {
    this.root = createNode(value || {});
  }
  set(path, value) {
    const parent = this.getParent(path, true);
    if (!parent) {
      updateNode(this.root, value, null);
      return;
    }
    const key = path[path.length - 1];
    const {
      children
    } = parent;
    if (children[key]) {
      updateNode(children[key], value, parent);
      return;
    }
    children[key] = createNode(value, parent);
  }

  // Get the "best" node (node or nearest parent) and return its value.
  get(path) {
    path = path || [];
    if (path.length < 1) {
      return this.root.value;
    }
    let branch = this.root;
    let child;
    let token;
    for (let i = 0; i < path.length; i += 1) {
      token = path[i];
      child = branch.children;
      if (!child[token]) {
        break;
      }
      branch = child[token];
    }
    return branch && branch.protoValue;
  }
  getParent(path, ensureExists) {
    if (!path || path.length < 1) {
      return null;
    }
    if (path.length < 2) {
      return this.root;
    }
    return path.slice(0, -1).reduce((branch, token) => {
      if (!branch) {
        return branch;
      }
      const {
        children
      } = branch;
      if (!children[token] && ensureExists) {
        children[token] = createNode(null, branch);
      }
      return children[token];
    }, this.root);
  }
}

// =========================
// Utilities
// =========================

function createNode(value, parent) {
  return updateNode({
    children: {}
  }, value, parent);
}
function updateNode(node, value, parent) {
  node.value = value || {};
  node.protoValue = parent ? {
    ...parent.protoValue,
    ...node.value
  } : node.value;
  Object.keys(node.children).forEach(prop => {
    const child = node.children[prop];
    node.children[prop] = updateNode(child, child.value, node);
  });
  return node;
}

/***/ }),

/***/ 21672:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(53369);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);





/**
 * @public
 */
/**
 * @public
 */
class SchemaVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Schema_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Schema']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaVisitor);

/***/ }),

/***/ 21878:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  init: function () {
    return this.xf['@@transducer/init']();
  },
  result: function (result) {
    return this.xf['@@transducer/result'](result);
  }
});

/***/ }),

/***/ 21926:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apg_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16646);

const templateExpressionParamName = (state, chars, phraseIndex, phraseLength, data) => {
  if (state === apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_PRE) {
    data.push(['template-expression-param-name', apg_lite__WEBPACK_IMPORTED_MODULE_0__.utilities.charsToString(chars, phraseIndex, phraseLength)]);
  } else if (state === apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_POST) {
    /* not used in this example */
  }
  return apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_OK;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (templateExpressionParamName);

/***/ }),

/***/ 21936:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(77259);
/* harmony import */ var _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71521);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9748);







/**
 * @public
 */
/**
 * @public
 */
class ParameterVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Parameter_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Parameter']);
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every MediaTypeElement with media type metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isObjectElement)(this.element.contentProp)) {
      this.element.contentProp.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_6__.isMediaTypeElement)
      // @ts-ignore
      .forEach((mediaTypeElement, key) => {
        mediaTypeElement.setMetaProperty('media-type', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_7__["default"])(key));
      });
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ParameterVisitor);

/***/ }),

/***/ 21953:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class Link extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.LinkElement {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Link);

/***/ }),

/***/ 21986:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var Symbol = __webpack_require__(51873),
    Uint8Array = __webpack_require__(37828),
    eq = __webpack_require__(75288),
    equalArrays = __webpack_require__(25911),
    mapToArray = __webpack_require__(20317),
    setToArray = __webpack_require__(84247);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/** `Object#toString` result references. */
var boolTag = '[object Boolean]',
    dateTag = '[object Date]',
    errorTag = '[object Error]',
    mapTag = '[object Map]',
    numberTag = '[object Number]',
    regexpTag = '[object RegExp]',
    setTag = '[object Set]',
    stringTag = '[object String]',
    symbolTag = '[object Symbol]';

var arrayBufferTag = '[object ArrayBuffer]',
    dataViewTag = '[object DataView]';

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol ? Symbol.prototype : undefined,
    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

/**
 * A specialized version of `baseIsEqualDeep` for comparing objects of
 * the same `toStringTag`.
 *
 * **Note:** This function only supports comparing values with tags of
 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
 *
 * @private
 * @param {Object} object The object to compare.
 * @param {Object} other The other object to compare.
 * @param {string} tag The `toStringTag` of the objects to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `object` and `other` objects.
 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
 */
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  switch (tag) {
    case dataViewTag:
      if ((object.byteLength != other.byteLength) ||
          (object.byteOffset != other.byteOffset)) {
        return false;
      }
      object = object.buffer;
      other = other.buffer;

    case arrayBufferTag:
      if ((object.byteLength != other.byteLength) ||
          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
        return false;
      }
      return true;

    case boolTag:
    case dateTag:
    case numberTag:
      // Coerce booleans to `1` or `0` and dates to milliseconds.
      // Invalid dates are coerced to `NaN`.
      return eq(+object, +other);

    case errorTag:
      return object.name == other.name && object.message == other.message;

    case regexpTag:
    case stringTag:
      // Coerce regexes to strings and treat strings, primitives and objects,
      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
      // for more details.
      return object == (other + '');

    case mapTag:
      var convert = mapToArray;

    case setTag:
      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
      convert || (convert = setToArray);

      if (object.size != other.size && !isPartial) {
        return false;
      }
      // Assume cyclic values are equal.
      var stacked = stack.get(object);
      if (stacked) {
        return stacked == other;
      }
      bitmask |= COMPARE_UNORDERED_FLAG;

      // Recursively compare objects (susceptible to call stack limits).
      stack.set(object, other);
      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
      stack['delete'](object);
      return result;

    case symbolTag:
      if (symbolValueOf) {
        return symbolValueOf.call(object) == symbolValueOf.call(other);
      }
  }
  return false;
}

module.exports = equalByTag;


/***/ }),

/***/ 22006:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _xall)
/* harmony export */ });
/* harmony import */ var _reduced_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(30259);
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21878);


var XAll = /*#__PURE__*/function () {
  function XAll(f, xf) {
    this.xf = xf;
    this.f = f;
    this.all = true;
  }
  XAll.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__["default"].init;
  XAll.prototype['@@transducer/result'] = function (result) {
    if (this.all) {
      result = this.xf['@@transducer/step'](result, true);
    }
    return this.xf['@@transducer/result'](result);
  };
  XAll.prototype['@@transducer/step'] = function (result, input) {
    if (!this.f(input)) {
      this.all = false;
      result = (0,_reduced_js__WEBPACK_IMPORTED_MODULE_1__["default"])(this.xf['@@transducer/step'](result, false));
    }
    return result;
  };
  return XAll;
}();
function _xall(f) {
  return function (xf) {
    return new XAll(f, xf);
  };
}

/***/ }),

/***/ 22032:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var nativeCreate = __webpack_require__(81042);

/**
 * Removes all key-value entries from the hash.
 *
 * @private
 * @name clear
 * @memberOf Hash
 */
function hashClear() {
  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  this.size = 0;
}

module.exports = hashClear;


/***/ }),

/***/ 22072:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11182);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40932);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29234);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(78180);
/* harmony import */ var _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(63058);
/* harmony import */ var _visitors_json_schema_PrefixItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(22488);
/* harmony import */ var _visitors_json_schema_link_description_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(71142);





const specification = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(
// JSON Schema object modifications
(0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', '$visitor'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$recursiveAnchor']), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$dynamicAnchor'], _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_4__["default"].visitors.value), (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$recursiveRef']), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', '$dynamicRef'], _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_4__["default"].visitors.value), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'not'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'if'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'then'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'else'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'prefixItems'], _visitors_json_schema_PrefixItemsVisitor_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'items'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'contains'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'additionalProperties'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'additionalItems']), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'propertyNames'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'unevaluatedItems'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'unevaluatedProperties'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'JSONSchema', 'fixedFields', 'contentSchema'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]),
// Link Description object modifications
(0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'LinkDescription', '$visitor'], _visitors_json_schema_link_description_index_mjs__WEBPACK_IMPORTED_MODULE_6__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'LinkDescription', 'fixedFields', 'targetSchema'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'LinkDescription', 'fixedFields', 'hrefSchema'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'LinkDescription', 'fixedFields', 'headerSchema'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]), (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(['visitors', 'document', 'objects', 'LinkDescription', 'fixedFields', 'submissionSchema'], _visitors_json_schema_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]))(_swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_4__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (specification);

/***/ }),

/***/ 22308:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class Reference extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.ReferenceElement {}
Object.defineProperty(Reference.prototype, 'description', {
  get() {
    return this.get('description');
  },
  set(description) {
    this.set('description', description);
  },
  enumerable: true
});
Object.defineProperty(Reference.prototype, 'summary', {
  get() {
    return this.get('summary');
  },
  set(description) {
    this.set('summary', description);
  },
  enumerable: true
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Reference);

/***/ }),

/***/ 22338:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3579);
/* harmony import */ var _internal_toString_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10565);



/**
 * Returns the string representation of the given value. `eval`'ing the output
 * should result in a value equivalent to the input value. Many of the built-in
 * `toString` methods do not satisfy this requirement.
 *
 * If the given value is an `[object Object]` with a `toString` method other
 * than `Object.prototype.toString`, this method is invoked with no arguments
 * to produce the return value. This means user-defined constructor functions
 * can provide a suitable `toString` method. For example:
 *
 *     function Point(x, y) {
 *       this.x = x;
 *       this.y = y;
 *     }
 *
 *     Point.prototype.toString = function() {
 *       return 'new Point(' + this.x + ', ' + this.y + ')';
 *     };
 *
 *     R.toString(new Point(1, 2)); //=> 'new Point(1, 2)'
 *
 * @func
 * @memberOf R
 * @since v0.14.0
 * @category String
 * @sig * -> String
 * @param {*} val
 * @return {String}
 * @example
 *
 *      R.toString(42); //=> '42'
 *      R.toString('abc'); //=> '"abc"'
 *      R.toString([1, 2, 3]); //=> '[1, 2, 3]'
 *      R.toString({foo: 1, bar: 2, baz: 3}); //=> '{"bar": 2, "baz": 3, "foo": 1}'
 *      R.toString(new Date('2001-02-03T04:05:06Z')); //=> 'new Date("2001-02-03T04:05:06.000Z")'
 */
var toString = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function toString(val) {
  return (0,_internal_toString_js__WEBPACK_IMPORTED_MODULE_1__["default"])(val, []);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toString);

/***/ }),

/***/ 22409:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3579);


/**
 * A function that returns the `!` of its argument. It will return `true` when
 * passed false-y value, and `false` when passed a truth-y one.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Logic
 * @sig * -> Boolean
 * @param {*} a any value
 * @return {Boolean} the logical inverse of passed argument.
 * @see R.complement
 * @example
 *
 *      R.not(true); //=> false
 *      R.not(false); //=> true
 *      R.not(0); //=> true
 *      R.not(1); //=> false
 */
var not = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function not(a) {
  return !a;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (not);

/***/ }),

/***/ 22488:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1908);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(60020);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15413);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62287);




/**
 * @public
 */

/**
 * @public
 */
class PrefixItemsVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_1__["default"], _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_2__["default"], _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ArrayElement();
    this.element.classes.push('json-schema-prefixItems');
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      const element = this.toRefractedElement(['document', 'objects', 'JSONSchema'], item);
      this.element.push(element);
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PrefixItemsVisitor);

/***/ }),

/***/ 22519:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95233);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(45259);
/* harmony import */ var _utils_to_path_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12201);



class AllOfVisitor {
  options;
  SchemaElement = {
    leave(schemaElement, key, parent, path, ancestors) {
      // do nothing
      if (typeof schemaElement.allOf === 'undefined') return undefined;

      // collect error and return if allOf keyword is not an array
      if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isArrayElement)(schemaElement.allOf)) {
        const error = new TypeError('allOf must be an array');
        error.fullPath = [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_1__["default"])([...ancestors, parent, schemaElement]), 'allOf'];
        this.options.dereference.dereferenceOpts?.errors?.push?.(error);
        return undefined;
      }

      // remove allOf keyword if empty
      if (schemaElement.allOf.isEmpty) {
        schemaElement.remove('allOf');
        return undefined;
      }

      // collect errors if allOf keyword contains anything else than Schema Object
      const includesSchemaElementOnly = schemaElement.allOf.content.every(_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__.isSchemaElement);
      if (!includesSchemaElementOnly) {
        const error = new TypeError('Elements in allOf must be objects');
        error.fullPath = [...(0,_utils_to_path_js__WEBPACK_IMPORTED_MODULE_1__["default"])([...ancestors, parent, schemaElement]), 'allOf'];
        this.options.dereference.dereferenceOpts?.errors?.push?.(error);
        return undefined;
      }
      while (schemaElement.hasKey('allOf')) {
        const {
          allOf
        } = schemaElement;
        schemaElement.remove('allOf');
        const allOfMerged = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_3__["default"].all([...allOf.content, schemaElement]);

        /**
         * If there was not an original $$ref value, make sure to remove
         * any $$ref value that may exist from the result of `allOf` merges.
         */
        if (!schemaElement.hasKey('$$ref')) {
          allOfMerged.remove('$$ref');
        }

        /**
         * If there was an example keyword in the original schema,
         * keep it instead of merging with example from other schema.
         */
        if (schemaElement.hasKey('example')) {
          const member = allOfMerged.getMember('example');
          if (member) {
            member.value = schemaElement.get('example');
          }
        }

        /**
         * If there was an examples keyword in the original schema,
         * keep it instead of merging with examples from other schema.
         */
        if (schemaElement.hasKey('examples')) {
          const member = allOfMerged.getMember('examples');
          if (member) {
            member.value = schemaElement.get('examples');
          }
        }
        schemaElement.content = allOfMerged.content;
      }
      return undefined;
    }
  };
  constructor({
    options
  }) {
    this.options = options;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AllOfVisitor);

/***/ }),

/***/ 22574:
/***/ ((__unused_webpack_module, exports) => {

"use strict";

var $propertyIsEnumerable = {}.propertyIsEnumerable;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor && !$propertyIsEnumerable.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
exports.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable;


/***/ }),

/***/ 22753:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(27121);
/* harmony import */ var _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(96184);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);






/**
 * @public
 */
/**
 * @public
 */
class LinkVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Link_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Link']);
    this.canSupportSpecificationExtensions = true;
  }
  ObjectElement(objectElement) {
    const result = _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // mark this LinkElement with reference metadata
    if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(this.element.operationId) || (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.isStringElement)(this.element.operationRef)) {
      this.element.classes.push('reference-element');
    }
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LinkVisitor);

/***/ }),

/***/ 22874:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ApiDOMError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16401);

/**
 * @public
 */
class ApiDOMStructuredError extends _ApiDOMError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(message, structuredOptions) {
    super(message, structuredOptions);
    if (structuredOptions != null && typeof structuredOptions === 'object') {
      const {
        cause,
        ...causelessOptions
      } = structuredOptions;
      Object.assign(this, causelessOptions);
    }
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ApiDOMStructuredError);

/***/ }),

/***/ 23045:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(1907);
var hasOwn = __webpack_require__(49724);
var toIndexedObject = __webpack_require__(27374);
var indexOf = (__webpack_require__(74436).indexOf);
var hiddenKeys = __webpack_require__(38530);

var push = uncurryThis([].push);

module.exports = function (object, names) {
  var O = toIndexedObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !hasOwn(hiddenKeys, key) && hasOwn(O, key) && push(result, key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (hasOwn(O, key = names[i++])) {
    ~indexOf(result, key) || push(result, key);
  }
  return result;
};


/***/ }),

/***/ 23283:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25845);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(24445);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(96196);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(29461);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86476);
/* harmony import */ var _isNotFunction_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(43305);
/* harmony import */ var _isEmptyArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(64812);




/**
 * Invokes the method at path of object with given arguments.
 *
 * @func invokeArgs
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.27.0|v2.27.0}
 * @category Object
 * @sig Array -> Array -> Object -> *
 * @param {Array.<string|number>} path The path of the method to invoke
 * @param {Array} args The arguments to invoke the method with
 * @param {Object} obj The object to query
 * @return {*}
 * @example
 *
 * RA.invokeArgs(['abs'], [-1], Math); //=> 1
 * RA.invokeArgs(['path', 'to', 'non-existent', 'method'], [-1], Math); //=> undefined
 */

var invokeArgs = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(3, function (mpath, args, obj) {
  var method = (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(mpath, obj);
  var context = (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])((0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(mpath), obj);
  if ((0,_isNotFunction_js__WEBPACK_IMPORTED_MODULE_3__["default"])(method)) return undefined;
  if ((0,_isEmptyArray_js__WEBPACK_IMPORTED_MODULE_4__["default"])(mpath)) return undefined;
  var boundMethod = (0,ramda__WEBPACK_IMPORTED_MODULE_5__["default"])(method, context);
  return (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])(boundMethod, args);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (invokeArgs);

/***/ }),

/***/ 23425:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(42079);
/* harmony import */ var _elements_nces_HeaderContent_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18754);


/**
 * @public
 */
class ContentVisitor extends _ContentVisitor_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_HeaderContent_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContentVisitor);

/***/ }),

/***/ 23438:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isJSONSchemaElement: () => (/* binding */ isJSONSchemaElement),
/* harmony export */   isLinkDescriptionElement: () => (/* binding */ isLinkDescriptionElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46902);
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(42361);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(73224);



/**
 * @public
 */
const isJSONSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_1__["default"] || hasBasicElementProps(element) && isElementType('JSONSchema201909', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isLinkDescriptionElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('linkDescription', element) && primitiveEq('object', element);
});

/***/ }),

/***/ 23441:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(42856);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);





/**
 * @public
 */
/**
 * @public
 */
class ContactVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_Contact_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'Contact']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ContactVisitor);

/***/ }),

/***/ 23557:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3579);
/* harmony import */ var _empty_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(34421);
/* harmony import */ var _equals_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37911);




/**
 * Returns `true` if the given value is its type's empty value; `false`
 * otherwise.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Logic
 * @sig a -> Boolean
 * @param {*} x
 * @return {Boolean}
 * @see R.empty, R.isNotEmpty
 * @example
 *
 *      R.isEmpty([1, 2, 3]);           //=> false
 *      R.isEmpty([]);                  //=> true
 *      R.isEmpty('');                  //=> true
 *      R.isEmpty(null);                //=> false
 *      R.isEmpty({});                  //=> true
 *      R.isEmpty({length: 0});         //=> false
 *      R.isEmpty(Uint8Array.from('')); //=> true
 */
var isEmpty = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function isEmpty(x) {
  return x != null && (0,_equals_js__WEBPACK_IMPORTED_MODULE_1__["default"])(x, (0,_empty_js__WEBPACK_IMPORTED_MODULE_2__["default"])(x));
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isEmpty);

/***/ }),

/***/ 23805:
/***/ ((module) => {

/**
 * Checks if `value` is the
 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
 *
 * @static
 * @memberOf _
 * @since 0.1.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
 * @example
 *
 * _.isObject({});
 * // => true
 *
 * _.isObject([1, 2, 3]);
 * // => true
 *
 * _.isObject(_.noop);
 * // => true
 *
 * _.isObject(null);
 * // => false
 */
function isObject(value) {
  var type = typeof value;
  return value != null && (type == 'object' || type == 'function');
}

module.exports = isObject;


/***/ }),

/***/ 23859:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apg_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16646);

const serverVariableName = (state, chars, phraseIndex, phraseLength, data) => {
  if (state === apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_PRE) {
    if (Array.isArray(data) === false) {
      throw new Error("parser's user data must be an array");
    }
    data.push(['server-variable-name', apg_lite__WEBPACK_IMPORTED_MODULE_0__.utilities.charsToString(chars, phraseIndex, phraseLength)]);
  }
  return apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_OK;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (serverVariableName);

/***/ }),

/***/ 23888:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var fails = __webpack_require__(98828);
var createPropertyDescriptor = __webpack_require__(75817);

module.exports = !fails(function () {
  var error = new Error('a');
  if (!('stack' in error)) return true;
  // eslint-disable-next-line es/no-object-defineproperty -- safe
  Object.defineProperty(error, 'stack', createPropertyDescriptor(1, 7));
  return error.stack !== 7;
});


/***/ }),

/***/ 24169:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   replaceAllInvoker: () => (/* binding */ replaceAllInvoker),
/* harmony export */   replaceAllPonyfill: () => (/* binding */ replaceAllPonyfill)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25845);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(57898);
/* harmony import */ var _isFunction_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34610);
/* harmony import */ var _internal_ponyfills_String_replaceAll_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(291);



var replaceAllPonyfill = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(3, _internal_ponyfills_String_replaceAll_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
var replaceAllInvoker = (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])(2, 'replaceAll');

/**
 * Replaces all substring matches in a string with a replacement.
 *
 * @func replaceAll
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/2.17.0|v2.17.0}
 * @category String
 * @sig String -> String -> String -> String
 * @param {string} searchValue The substring or a global RegExp to match
 * @param {string} replaceValue The string to replace the matches with
 * @param {string} str The String to do the search and replacement in
 * @return {string} A new string containing all the `searchValue` replaced with the `replaceValue`
 * @throws {TypeError} When invalid arguments provided
 * @see {@link http://ramdajs.com/docs/#replace|R.replace}, {@link https://github.com/tc39/proposal-string-replaceall|TC39 proposal}
 * @example
 *
 * RA.replaceAll('ac', 'ef', 'ac ab ac ab'); //=> 'ef ab ef ab'
 * RA.replaceAll('', '_', 'xxx'); //=> '_x_x_x_'
 * RA.replaceAll(/x/g, 'v', 'xxx'); //=> 'vvv'
 * RA.replaceAll(/x/, 'v', 'xxx'); //=> TypeError
 */
var replaceAll = (0,_isFunction_js__WEBPACK_IMPORTED_MODULE_3__["default"])(String.prototype.replaceAll) ? replaceAllInvoker : replaceAllPonyfill;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (replaceAll);

/***/ }),

/***/ 24350:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apg_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16646);
/* harmony import */ var _grammar_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(96552);
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(91176);
/* harmony import */ var _cookie_test_cookie_value_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(58571);




const parser = new apg_lite__WEBPACK_IMPORTED_MODULE_0__.Parser();
const grammar = new _grammar_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]();
const cookieValueStrictPercentEncoder = cookieValue => {
  const value = String(cookieValue);

  // return early if the value is already valid
  if ((0,_cookie_test_cookie_value_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(value)) return value;

  // detect if the value is quoted
  const isQuoted = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_3__.isQuoted)(value);

  // remove quotes if present for processing
  const valueToEncode = isQuoted ? (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_3__.unquote)(value) : value;
  let result = '';
  for (const char of valueToEncode) {
    result += parser.parse(grammar, 'cookie-octet', char).success ? char : (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_3__.percentEncodeChar)(char);
  }

  // return quoted if input was quoted, unquoted otherwise
  return isQuoted ? (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_3__.quote)(result) : result;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (cookieValueStrictPercentEncoder);

/***/ }),

/***/ 24443:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

var internalObjectKeys = __webpack_require__(23045);
var enumBugKeys = __webpack_require__(80376);

var hiddenKeys = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe
exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys);
};


/***/ }),

/***/ 24445:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _internal_path_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(38506);



/**
 * Retrieves the value at a given path. The nodes of the path can be arbitrary strings or non-negative integers.
 * For anything else, the value is unspecified. Integer paths are meant to index arrays, strings are meant for objects.
 *
 * @func
 * @memberOf R
 * @since v0.2.0
 * @category Object
 * @typedefn Idx = String | Int | Symbol
 * @sig [Idx] -> {a} -> a | Undefined
 * @sig Idx = String | NonNegativeInt
 * @param {Array} path The path to use.
 * @param {Object} obj The object or array to retrieve the nested property from.
 * @return {*} The data at `path`.
 * @see R.prop, R.nth, R.assocPath, R.dissocPath
 * @example
 *
 *      R.path(['a', 'b'], {a: {b: 2}}); //=> 2
 *      R.path(['a', 'b'], {c: {b: 2}}); //=> undefined
 *      R.path(['a', 'b', 0], {a: {b: [1, 2, 3]}}); //=> 1
 *      R.path(['a', 'b', -2], {a: {b: [1, 2, 3]}}); //=> 2
 *      R.path([2], {'2': 2}); //=> 2
 *      R.path([-2], {'-2': 'a'}); //=> undefined
 */

var path = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_internal_path_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (path);

/***/ }),

/***/ 24454:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _mergeDeepWithKey_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(70839);



/**
 * Creates a new object with the own properties of the first object merged with
 * the own properties of the second object. If a key exists in both objects:
 * - and both values are objects, the two values will be recursively merged
 * - otherwise the value from the second object will be used.
 *
 * @func
 * @memberOf R
 * @since v0.24.0
 * @category Object
 * @sig {a} -> {a} -> {a}
 * @param {Object} lObj
 * @param {Object} rObj
 * @return {Object}
 * @see R.merge, R.mergeDeepLeft, R.mergeDeepWith, R.mergeDeepWithKey
 * @example
 *
 *      R.mergeDeepRight({ name: 'fred', age: 10, contact: { email: 'moo@example.com' }},
 *                       { age: 40, contact: { email: 'baa@example.com' }});
 *      //=> { name: 'fred', age: 40, contact: { email: 'baa@example.com' }}
 */
var mergeDeepRight = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function mergeDeepRight(lObj, rObj) {
  return (0,_mergeDeepWithKey_js__WEBPACK_IMPORTED_MODULE_1__["default"])(function (k, lVal, rVal) {
    return rVal;
  }, lObj, rObj);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (mergeDeepRight);

/***/ }),

/***/ 24519:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _internal_has_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81069);
/* harmony import */ var _isNil_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(51647);




/**
 * Returns whether or not a path exists in an object. Only the object's
 * own properties are checked.
 *
 * @func
 * @memberOf R
 * @since v0.26.0
 * @category Object
 * @typedefn Idx = String | Int | Symbol
 * @sig [Idx] -> {a} -> Boolean
 * @param {Array} path The path to use.
 * @param {Object} obj The object to check the path in.
 * @return {Boolean} Whether the path exists.
 * @see R.has
 * @example
 *
 *      R.hasPath(['a', 'b'], {a: {b: 2}});         // => true
 *      R.hasPath(['a', 'b'], {a: {b: undefined}}); // => true
 *      R.hasPath(['a', 'b'], {a: {c: 2}});         // => false
 *      R.hasPath(['a', 'b'], {});                  // => false
 */
var hasPath = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function hasPath(_path, obj) {
  if (_path.length === 0 || (0,_isNil_js__WEBPACK_IMPORTED_MODULE_1__["default"])(obj)) {
    return false;
  }
  var val = obj;
  var idx = 0;
  while (idx < _path.length) {
    if (!(0,_isNil_js__WEBPACK_IMPORTED_MODULE_1__["default"])(val) && (0,_internal_has_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_path[idx], val)) {
      val = val[_path[idx]];
      idx += 1;
    } else {
      return false;
    }
  }
  return true;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (hasPath);

/***/ }),

/***/ 24638:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ResolveError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(35416);

/**
 * @public
 */
class UnmatchedResolveStrategyError extends _ResolveError_mjs__WEBPACK_IMPORTED_MODULE_0__["default"] {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UnmatchedResolveStrategyError);

/***/ }),

/***/ 24739:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(26025);

/**
 * Gets the list cache value for `key`.
 *
 * @private
 * @name get
 * @memberOf ListCache
 * @param {string} key The key of the value to get.
 * @returns {*} Returns the entry value.
 */
function listCacheGet(key) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  return index < 0 ? undefined : data[index][1];
}

module.exports = listCacheGet;


/***/ }),

/***/ 24823:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var bind = __webpack_require__(28311);
var call = __webpack_require__(13930);
var anObject = __webpack_require__(36624);
var tryToString = __webpack_require__(4640);
var isArrayIteratorMethod = __webpack_require__(37812);
var lengthOfArrayLike = __webpack_require__(20575);
var isPrototypeOf = __webpack_require__(88280);
var getIterator = __webpack_require__(10300);
var getIteratorMethod = __webpack_require__(73448);
var iteratorClose = __webpack_require__(40154);

var $TypeError = TypeError;

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

var ResultPrototype = Result.prototype;

module.exports = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_RECORD = !!(options && options.IS_RECORD);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = bind(unboundFunction, that);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) iteratorClose(iterator, 'normal', condition);
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      anObject(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    } return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_RECORD) {
    iterator = iterable.iterator;
  } else if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = getIteratorMethod(iterable);
    if (!iterFn) throw new $TypeError(tryToString(iterable) + ' is not iterable');
    // optimisation for array iterators
    if (isArrayIteratorMethod(iterFn)) {
      for (index = 0, length = lengthOfArrayLike(iterable); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && isPrototypeOf(ResultPrototype, result)) return result;
      } return new Result(false);
    }
    iterator = getIterator(iterable, iterFn);
  }

  next = IS_RECORD ? iterable.next : iterator.next;
  while (!(step = call(next, iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      iteratorClose(iterator, 'throw', error);
    }
    if (typeof result == 'object' && result && isPrototypeOf(ResultPrototype, result)) return result;
  } return new Result(false);
};


/***/ }),

/***/ 24955:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(11182);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1322);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(85883);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22338);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(37911);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(67924);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(10625);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(25845);
/* harmony import */ var _isNull_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(41259);
/* harmony import */ var _isObjLike_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(54442);
/* harmony import */ var _isFunction_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(34610);




var isObject = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(ramda__WEBPACK_IMPORTED_MODULE_1__["default"], (0,ramda__WEBPACK_IMPORTED_MODULE_2__["default"])('Object'));
var isObjectConstructor = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(ramda__WEBPACK_IMPORTED_MODULE_3__["default"], (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])((0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(Object)));
var hasObjectConstructor = (0,ramda__WEBPACK_IMPORTED_MODULE_5__["default"])((0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])(_isFunction_js__WEBPACK_IMPORTED_MODULE_7__["default"], isObjectConstructor), ['constructor']);

/* eslint-disable max-len */
/**
 * Check to see if an object is a plain object (created using `{}`, `new Object()` or `Object.create(null)`).
 *
 * @func isPlainObj
 * @aliases isPlainObject
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotPlainObj|isNotPlainObj}, {@link RA.isObjLike|isObjLike}, {@link RA.isObj|isObj}
 * @example
 *
 * class Bar {
 *   constructor() {
 *     this.prop = 'value';
 *   }
 * }
 *
 * RA.isPlainObj(new Bar()); //=> false
 * RA.isPlainObj({ prop: 'value' }); //=> true
 * RA.isPlainObj(['a', 'b', 'c']); //=> false
 * RA.isPlainObj(Object.create(null); //=> true
 * RA.isPlainObj(new Object()); //=> true
 */
/* eslint-enable max-len */
var isPlainObj = (0,ramda__WEBPACK_IMPORTED_MODULE_8__["default"])(1, function (val) {
  if (!(0,_isObjLike_js__WEBPACK_IMPORTED_MODULE_9__["default"])(val) || !isObject(val)) {
    return false;
  }
  var proto = Object.getPrototypeOf(val);
  if ((0,_isNull_js__WEBPACK_IMPORTED_MODULE_10__["default"])(proto)) {
    return true;
  }
  return hasObjectConstructor(proto);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isPlainObj);

/***/ }),

/***/ 24980:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _clone)
/* harmony export */ });
/* harmony import */ var _cloneRegExp_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40557);
/* harmony import */ var _type_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1322);



/**
 * Copies an object.
 *
 * @private
 * @param {*} value The value to be copied
 * @param {Boolean} deep Whether or not to perform deep cloning.
 * @return {*} The copied value.
 */
function _clone(value, deep, map) {
  map || (map = new _ObjectMap());

  // this avoids the slower switch with a quick if decision removing some milliseconds in each run.
  if (_isPrimitive(value)) {
    return value;
  }
  var copy = function copy(copiedValue) {
    // Check for circular and same references on the object graph and return its corresponding clone.
    var cachedCopy = map.get(value);
    if (cachedCopy) {
      return cachedCopy;
    }
    map.set(value, copiedValue);
    for (var key in value) {
      if (Object.prototype.hasOwnProperty.call(value, key)) {
        copiedValue[key] = deep ? _clone(value[key], true, map) : value[key];
      }
    }
    return copiedValue;
  };
  switch ((0,_type_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value)) {
    case 'Object':
      return copy(Object.create(Object.getPrototypeOf(value)));
    case 'Array':
      return copy(Array(value.length));
    case 'Date':
      return new Date(value.valueOf());
    case 'RegExp':
      return (0,_cloneRegExp_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value);
    case 'Int8Array':
    case 'Uint8Array':
    case 'Uint8ClampedArray':
    case 'Int16Array':
    case 'Uint16Array':
    case 'Int32Array':
    case 'Uint32Array':
    case 'Float32Array':
    case 'Float64Array':
    case 'BigInt64Array':
    case 'BigUint64Array':
      return value.slice();
    default:
      return value;
  }
}
function _isPrimitive(param) {
  var type = typeof param;
  return param == null || type != 'object' && type != 'function';
}
var _ObjectMap = /*#__PURE__*/function () {
  function _ObjectMap() {
    this.map = {};
    this.length = 0;
  }
  _ObjectMap.prototype.set = function (key, value) {
    var hashedKey = this.hash(key);
    var bucket = this.map[hashedKey];
    if (!bucket) {
      this.map[hashedKey] = bucket = [];
    }
    bucket.push([key, value]);
    this.length += 1;
  };
  _ObjectMap.prototype.hash = function (key) {
    var hashedKey = [];
    for (var value in key) {
      hashedKey.push(Object.prototype.toString.call(key[value]));
    }
    return hashedKey.join();
  };
  _ObjectMap.prototype.get = function (key) {
    /**
     * depending on the number of objects to be cloned is faster to just iterate over the items in the map just because the hash function is so costly,
     * on my tests this number is 180, anything above that using the hash function is faster.
     */
    if (this.length <= 180) {
      for (var p in this.map) {
        var bucket = this.map[p];
        for (var i = 0; i < bucket.length; i += 1) {
          var element = bucket[i];
          if (element[0] === key) {
            return element[1];
          }
        }
      }
      return;
    }
    var hashedKey = this.hash(key);
    var bucket = this.map[hashedKey];
    if (!bucket) {
      return;
    }
    for (var i = 0; i < bucket.length; i += 1) {
      var element = bucket[i];
      if (element[0] === key) {
        return element[1];
      }
    }
  };
  return _ObjectMap;
}();

/***/ }),

/***/ 25052:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRefractor: () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3510);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43319);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4366);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24445);
/* harmony import */ var _specification_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13663);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(8302);
/* harmony import */ var _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5009);





const refract = (value, {
  specPath = ['visitors', 'document', 'objects', 'OpenApi', '$visitor'],
  plugins = []
} = {}) => {
  const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.refract)(value);
  const resolvedSpec = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.dereference)(_specification_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]);

  /**
   * This is where generic ApiDOM becomes semantic (namespace applied).
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const RootVisitorClass = (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(specPath, resolvedSpec);
  const rootVisitor = new RootVisitorClass({
    specObj: resolvedSpec
  });
  (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.visit)(element, rootVisitor);

  /**
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.dispatchPluginsSync)(rootVisitor.element, plugins, {
    toolboxCreator: _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
    visitorOptions: {
      keyMap: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__.keyMap,
      nodeTypeGetter: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__.getNodeType
    }
  });
};
const createRefractor = specPath => (value, options = {}) => refract(value, {
  specPath,
  ...options
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 25594:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var getBuiltIn = __webpack_require__(63201);
var isCallable = __webpack_require__(62250);
var isPrototypeOf = __webpack_require__(88280);
var USE_SYMBOL_AS_UID = __webpack_require__(51175);

var $Object = Object;

module.exports = USE_SYMBOL_AS_UID ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn('Symbol');
  return isCallable($Symbol) && isPrototypeOf($Symbol.prototype, $Object(it));
};


/***/ }),

/***/ 25690:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lift_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(63519);
/* harmony import */ var _not_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(22409);



/**
 * Takes a function `f` and returns a function `g` such that if called with the same arguments
 * when `f` returns a "truthy" value, `g` returns `false` and when `f` returns a "falsy" value `g` returns `true`.
 *
 * `R.complement` may be applied to any functor
 *
 * @func
 * @memberOf R
 * @since v0.12.0
 * @category Logic
 * @sig (*... -> *) -> (*... -> Boolean)
 * @param {Function} f
 * @return {Function}
 * @see R.not
 * @example
 *
 *      const isNotNil = R.complement(R.isNil);
 *      R.isNil(null); //=> true
 *      isNotNil(null); //=> false
 *      R.isNil(7); //=> false
 *      isNotNil(7); //=> true
 */
var complement = /*#__PURE__*/(0,_lift_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_not_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (complement);

/***/ }),

/***/ 25708:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(60020);
/* harmony import */ var _elements_nces_Security_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(498);
/* harmony import */ var _SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(36114);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);





/**
 * @public
 */
/**
 * @public
 */
class SecurityVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_SpecificationVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_Security_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
  }
  ArrayElement(arrayElement) {
    arrayElement.forEach(item => {
      if ((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.isObjectElement)(item)) {
        const element = this.toRefractedElement(['document', 'objects', 'SecurityRequirement'], item);
        this.element.push(element);
      } else {
        this.element.push((0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.cloneDeep)(item));
      }
    });
    this.copyMetaAndAttributes(arrayElement, this.element);
    return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__.BREAK;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecurityVisitor);

/***/ }),

/***/ 25789:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33397);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52954);



/* eslint-disable class-methods-use-this */

/**
 * @public
 */
class JSONSchema extends _swagger_api_apidom_ns_json_schema_2019_09__WEBPACK_IMPORTED_MODULE_0__.JSONSchemaElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'JSONSchema202012';
  }

  /**
   * Core vocabulary
   *
   * URI: https://json-schema.org/draft/2020-12/vocab/core
   */

  get $dynamicAnchor() {
    return this.get('$dynamicAnchor');
  }
  set $dynamicAnchor($dynamicAnchor) {
    this.set('$dynamicAnchor', $dynamicAnchor);
  }
  get $recursiveAnchor() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('$recursiveAnchor keyword from Core vocabulary has been renamed to $dynamicAnchor.');
  }
  set $recursiveAnchor($recursiveAnchor) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('$recursiveAnchor keyword from Core vocabulary has been renamed to $dynamicAnchor.');
  }
  get $dynamicRef() {
    return this.get('$dynamicRef');
  }
  set $dynamicRef($dynamicRef) {
    this.set('$dynamicRef', $dynamicRef);
  }
  get $recursiveRef() {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('$recursiveRef keyword from Core vocabulary has been renamed to $dynamicRef.');
  }
  set $recursiveRef($recursiveRef) {
    throw new _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_1__["default"]('$recursiveRef keyword from Core vocabulary has been renamed to $dynamicRef.');
  }

  /**
   * Applicator vocabulary
   *
   * URI: https://json-schema.org/draft/2020-12/vocab/applicator
   */

  get prefixItems() {
    return this.get('prefixItems');
  }
  set prefixItems(prefixItems) {
    this.set('prefixItems', prefixItems);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (JSONSchema);

/***/ }),

/***/ 25845:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_arity_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(27660);
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3579);
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _internal_curryN_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(19034);





/**
 * Returns a curried equivalent of the provided function, with the specified
 * arity. The curried function has two unusual capabilities. First, its
 * arguments needn't be provided one at a time. If `g` is `R.curryN(3, f)`, the
 * following are equivalent:
 *
 *   - `g(1)(2)(3)`
 *   - `g(1)(2, 3)`
 *   - `g(1, 2)(3)`
 *   - `g(1, 2, 3)`
 *
 * Secondly, the special placeholder value [`R.__`](#__) may be used to specify
 * "gaps", allowing partial application of any combination of arguments,
 * regardless of their positions. If `g` is as above and `_` is [`R.__`](#__),
 * the following are equivalent:
 *
 *   - `g(1, 2, 3)`
 *   - `g(_, 2, 3)(1)`
 *   - `g(_, _, 3)(1)(2)`
 *   - `g(_, _, 3)(1, 2)`
 *   - `g(_, 2)(1)(3)`
 *   - `g(_, 2)(1, 3)`
 *   - `g(_, 2)(_, 3)(1)`
 *
 * @func
 * @memberOf R
 * @since v0.5.0
 * @category Function
 * @sig Number -> (* -> a) -> (* -> a)
 * @param {Number} length The arity for the returned function.
 * @param {Function} fn The function to curry.
 * @return {Function} A new, curried function.
 * @see R.curry
 * @example
 *
 *      const sumArgs = (...args) => R.sum(args);
 *
 *      const curriedAddFourNumbers = R.curryN(4, sumArgs);
 *      const f = curriedAddFourNumbers(1, 2);
 *      const g = f(3);
 *      g(4); //=> 10
 */
var curryN = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function curryN(length, fn) {
  if (length === 1) {
    return (0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_1__["default"])(fn);
  }
  return (0,_internal_arity_js__WEBPACK_IMPORTED_MODULE_2__["default"])(length, (0,_internal_curryN_js__WEBPACK_IMPORTED_MODULE_3__["default"])(length, [], fn));
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (curryN);

/***/ }),

/***/ 25911:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var SetCache = __webpack_require__(38859),
    arraySome = __webpack_require__(14248),
    cacheHas = __webpack_require__(19219);

/** Used to compose bitmasks for value comparisons. */
var COMPARE_PARTIAL_FLAG = 1,
    COMPARE_UNORDERED_FLAG = 2;

/**
 * A specialized version of `baseIsEqualDeep` for arrays with support for
 * partial deep comparisons.
 *
 * @private
 * @param {Array} array The array to compare.
 * @param {Array} other The other array to compare.
 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
 * @param {Function} customizer The function to customize comparisons.
 * @param {Function} equalFunc The function to determine equivalents of values.
 * @param {Object} stack Tracks traversed `array` and `other` objects.
 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
 */
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
      arrLength = array.length,
      othLength = other.length;

  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
    return false;
  }
  // Check that cyclic values are equal.
  var arrStacked = stack.get(array);
  var othStacked = stack.get(other);
  if (arrStacked && othStacked) {
    return arrStacked == other && othStacked == array;
  }
  var index = -1,
      result = true,
      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  stack.set(array, other);
  stack.set(other, array);

  // Ignore non-index properties.
  while (++index < arrLength) {
    var arrValue = array[index],
        othValue = other[index];

    if (customizer) {
      var compared = isPartial
        ? customizer(othValue, arrValue, index, other, array, stack)
        : customizer(arrValue, othValue, index, array, other, stack);
    }
    if (compared !== undefined) {
      if (compared) {
        continue;
      }
      result = false;
      break;
    }
    // Recursively compare arrays (susceptible to call stack limits).
    if (seen) {
      if (!arraySome(other, function(othValue, othIndex) {
            if (!cacheHas(seen, othIndex) &&
                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
              return seen.push(othIndex);
            }
          })) {
        result = false;
        break;
      }
    } else if (!(
          arrValue === othValue ||
            equalFunc(arrValue, othValue, bitmask, customizer, stack)
        )) {
      result = false;
      break;
    }
  }
  stack['delete'](array);
  stack['delete'](other);
  return result;
}

module.exports = equalArrays;


/***/ }),

/***/ 25979:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getNodeType: () => (/* binding */ getNodeType),
/* harmony export */   keyMap: () => (/* binding */ keyMap)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(27121);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43319);


/**
 * @public
 */
const getNodeType = element => {
  if (!(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.isElement)(element)) {
    return undefined;
  }
  return `${element.element.charAt(0).toUpperCase() + element.element.slice(1)}Element`;
};

/**
 * There are unfortunately two `LinkElement` types. One is from base namespace
 * and the other one if from this namespace. `LinkElement` from base namespace
 * is used extremely rarely, so it's almost always safe during traversing
 * to assume that `LinkElement` is element from this namespace.
 *
 * To be 100% sure that currently visiting `LinkElement` is from this namespace
 * use `isLinkElement` predicate from this namespace to assert for it.
 * @public
 */

const keyMap = {
  CallbackElement: ['content'],
  ComponentsElement: ['content'],
  ContactElement: ['content'],
  DiscriminatorElement: ['content'],
  Encoding: ['content'],
  Example: ['content'],
  ExternalDocumentationElement: ['content'],
  HeaderElement: ['content'],
  InfoElement: ['content'],
  LicenseElement: ['content'],
  MediaTypeElement: ['content'],
  OAuthFlowElement: ['content'],
  OAuthFlowsElement: ['content'],
  OpenApi3_0Element: ['content'],
  OperationElement: ['content'],
  ParameterElement: ['content'],
  PathItemElement: ['content'],
  PathsElement: ['content'],
  ReferenceElement: ['content'],
  RequestBodyElement: ['content'],
  ResponseElement: ['content'],
  ResponsesElement: ['content'],
  SchemaElement: ['content'],
  SecurityRequirementElement: ['content'],
  SecuritySchemeElement: ['content'],
  ServerElement: ['content'],
  ServerVariableElement: ['content'],
  TagElement: ['content'],
  ..._swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.keyMapDefault
};

/***/ }),

/***/ 26025:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var eq = __webpack_require__(75288);

/**
 * Gets the index at which the `key` is found in `array` of key-value pairs.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {*} key The key to search for.
 * @returns {number} Returns the index of the matched value, else `-1`.
 */
function assocIndexOf(array, key) {
  var length = array.length;
  while (length--) {
    if (eq(array[length][0], key)) {
      return length;
    }
  }
  return -1;
}

module.exports = assocIndexOf;


/***/ }),

/***/ 26183:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3579);


/**
 * Returns a function that always returns the given value. Note that for
 * non-primitives the value returned is a reference to the original value.
 *
 * This function is known as `const`, `constant`, or `K` (for K combinator) in
 * other languages and libraries.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category Function
 * @sig a -> (* -> a)
 * @param {*} val The value to wrap in a function
 * @return {Function} A Function :: * -> val.
 * @example
 *
 *      const t = R.always('Tee');
 *      t(); //=> 'Tee'
 */
var always = /*#__PURE__*/(0,_internal_curry1_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function always(val) {
  return function () {
    return val;
  };
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (always);

/***/ }),

/***/ 26303:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(70369);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);





/**
 * @public
 */
/**
 * @public
 */
class ServerVariableVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_ServerVariable_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'ServerVariable']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ServerVariableVisitor);

/***/ }),

/***/ 26344:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(26183);
/* harmony import */ var _elements_License_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(77785);
/* harmony import */ var _generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91563);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);





/**
 * @public
 */
/**
 * @public
 */
class LicenseVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_FixedFieldsVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_License_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = (0,ramda__WEBPACK_IMPORTED_MODULE_4__["default"])(['document', 'objects', 'License']);
    this.canSupportSpecificationExtensions = true;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LicenseVisitor);

/***/ }),

/***/ 26362:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class OAuthFlowScopes extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  static primaryClass = 'oauth-flow-scopes';
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.classes.push(OAuthFlowScopes.primaryClass);
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OAuthFlowScopes);

/***/ }),

/***/ 26500:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(77259);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(48018);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5051);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(39633);
/* harmony import */ var _elements_nces_Webhooks_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(93461);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(45259);





/**
 * @public
 */
/**
 * @public
 */
class WebhooksVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"], _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_2__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _elements_nces_Webhooks_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]();
    this.specPath = element => (0,_swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_4__.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'PathItem'];
  }
  ObjectElement(objectElement) {
    const result = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_1__["default"].prototype.ObjectElement.call(this, objectElement);

    // decorate every ReferenceElement with metadata about their referencing type
    // @ts-ignore
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isReferenceElement).forEach(referenceElement => {
      // @ts-ignore
      referenceElement.setMetaProperty('referenced-element', 'pathItem');
    });

    // decorate every PathItemElement with Webhook name metadata
    this.element.filter(_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isPathItemElement)
    // @ts-ignore
    .forEach((pathItemElement, key) => {
      // @ts-ignore
      pathItemElement.setMetaProperty('webhook-name', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_6__["default"])(key));
    });
    return result;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (WebhooksVisitor);

/***/ }),

/***/ 26947:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * @public
 */

/**
 * @public
 */
class Resolver {
  name;
  constructor({
    name
  }) {
    this.name = name;
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Resolver);

/***/ }),

/***/ 27007:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dropLastWhile)
/* harmony export */ });
/* harmony import */ var _slice_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97094);

function dropLastWhile(pred, xs) {
  var idx = xs.length - 1;
  while (idx >= 0 && pred(xs[idx])) {
    idx -= 1;
  }
  return (0,_slice_js__WEBPACK_IMPORTED_MODULE_0__["default"])(0, idx + 1, xs);
}

/***/ }),

/***/ 27120:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _cookie_test_cookie_value_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58571);

const cookieValueStrictValidator = cookieValue => {
  if (!(0,_cookie_test_cookie_value_mjs__WEBPACK_IMPORTED_MODULE_0__["default"])(cookieValue)) {
    throw new TypeError(`Invalid cookie value: ${cookieValue}`);
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (cookieValueStrictValidator);

/***/ }),

/***/ 27121:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasElementSourceMap: () => (/* binding */ hasElementSourceMap),
/* harmony export */   includesClasses: () => (/* binding */ includesClasses),
/* harmony export */   includesSymbols: () => (/* binding */ includesSymbols),
/* harmony export */   isAnnotationElement: () => (/* binding */ isAnnotationElement),
/* harmony export */   isArrayElement: () => (/* binding */ isArrayElement),
/* harmony export */   isBooleanElement: () => (/* binding */ isBooleanElement),
/* harmony export */   isCommentElement: () => (/* binding */ isCommentElement),
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isLinkElement: () => (/* binding */ isLinkElement),
/* harmony export */   isMemberElement: () => (/* binding */ isMemberElement),
/* harmony export */   isNullElement: () => (/* binding */ isNullElement),
/* harmony export */   isNumberElement: () => (/* binding */ isNumberElement),
/* harmony export */   isObjectElement: () => (/* binding */ isObjectElement),
/* harmony export */   isParseResultElement: () => (/* binding */ isParseResultElement),
/* harmony export */   isPrimitiveElement: () => (/* binding */ isPrimitiveElement),
/* harmony export */   isRefElement: () => (/* binding */ isRefElement),
/* harmony export */   isSourceMapElement: () => (/* binding */ isSourceMapElement),
/* harmony export */   isStringElement: () => (/* binding */ isStringElement)
/* harmony export */ });
/* harmony import */ var minim__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(34035);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(56679);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(7410);
/* harmony import */ var _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(5443);
/* harmony import */ var _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6127);
/* harmony import */ var _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(59110);
/* harmony import */ var _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(36863);
/* harmony import */ var _helpers_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46902);








/**
 * @public
 */
const isElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.Element || hasBasicElementProps(element) && primitiveEq(undefined, element);
});

/**
 * @public
 */
const isStringElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.StringElement || hasBasicElementProps(element) && primitiveEq('string', element);
});

/**
 * @public
 */
const isNumberElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.NumberElement || hasBasicElementProps(element) && primitiveEq('number', element);
});

/**
 * @public
 */
const isNullElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.NullElement || hasBasicElementProps(element) && primitiveEq('null', element);
});

/**
 * @public
 */
const isBooleanElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.BooleanElement || hasBasicElementProps(element) && primitiveEq('boolean', element);
});

/**
 * @public
 */
const isObjectElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq,
  hasMethod
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement || hasBasicElementProps(element) && primitiveEq('object', element) && hasMethod('keys', element) && hasMethod('values', element) && hasMethod('items', element);
});

/**
 * @public
 */
const isArrayElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  primitiveEq,
  hasMethod
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ArrayElement && !(element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.ObjectElement) || hasBasicElementProps(element) && primitiveEq('array', element) && hasMethod('push', element) && hasMethod('unshift', element) && hasMethod('map', element) && hasMethod('reduce', element);
});

/**
 * @public
 */
const isMemberElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.MemberElement || hasBasicElementProps(element) && isElementType('member', element) && primitiveEq(undefined, element);
});

/**
 * @public
 */
const isLinkElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.LinkElement || hasBasicElementProps(element) && isElementType('link', element) && primitiveEq(undefined, element);
});

/**
 * @public
 */
const isRefElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof minim__WEBPACK_IMPORTED_MODULE_0__.RefElement || hasBasicElementProps(element) && isElementType('ref', element) && primitiveEq(undefined, element);
});

/**
 * @public
 */
const isAnnotationElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Annotation_mjs__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('annotation', element) && primitiveEq('array', element);
});

/**
 * @public
 */
const isCommentElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_Comment_mjs__WEBPACK_IMPORTED_MODULE_3__["default"] || hasBasicElementProps(element) && isElementType('comment', element) && primitiveEq('string', element);
});

/**
 * @public
 */
const isParseResultElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_ParseResult_mjs__WEBPACK_IMPORTED_MODULE_4__["default"] || hasBasicElementProps(element) && isElementType('parseResult', element) && primitiveEq('array', element);
});

/**
 * @public
 */
const isSourceMapElement = (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_SourceMap_mjs__WEBPACK_IMPORTED_MODULE_5__["default"] || hasBasicElementProps(element) && isElementType('sourceMap', element) && primitiveEq('array', element);
});

/**
 * @public
 */

/**
 * @public
 */
const isPrimitiveElement = element => {
  return (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('object', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('array', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('boolean', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('number', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('string', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('null', element) || (0,_helpers_mjs__WEBPACK_IMPORTED_MODULE_1__.isElementType)('member', element);
};

/**
 * @public
 */
const hasElementSourceMap = element => {
  return isSourceMapElement(element.meta.get('sourceMap'));
};

/**
 * @public
 */
const includesSymbols = (symbols, element) => {
  if (symbols.length === 0) {
    return true;
  }
  const elementSymbols = element.attributes.get('symbols');
  if (!isArrayElement(elementSymbols)) {
    return false;
  }
  return (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__["default"])(elementSymbols.toValue()), symbols);
};

/**
 * @public
 */
const includesClasses = (classes, element) => {
  if (classes.length === 0) {
    return true;
  }
  return (0,ramda__WEBPACK_IMPORTED_MODULE_6__["default"])((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_7__["default"])(element.classes.toValue()), classes);
};

/***/ }),

/***/ 27231:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ts_mixer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6993);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1908);
/* harmony import */ var _generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12670);
/* harmony import */ var _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(62287);
/* harmony import */ var _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(15413);
/* harmony import */ var _predicates_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(41413);






/**
 * @public
 */
/**
 * @public
 */
class DependenciesVisitor extends (0,ts_mixer__WEBPACK_IMPORTED_MODULE_0__.Mixin)(_generics_MapVisitor_mjs__WEBPACK_IMPORTED_MODULE_1__["default"], _ParentSchemaAwareVisitor_mjs__WEBPACK_IMPORTED_MODULE_2__["default"], _FallbackVisitor_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]) {
  constructor(options) {
    super(options);
    this.element = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.ObjectElement();
    this.element.classes.push('json-schema-dependencies');
    this.specPath = element => (0,_predicates_mjs__WEBPACK_IMPORTED_MODULE_5__.isJSONReferenceLikeElement)(element) ? ['document', 'objects', 'JSONReference'] : ['document', 'objects', 'JSONSchema'];
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DependenciesVisitor);

/***/ }),

/***/ 27298:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeHeaders: () => (/* binding */ serializeHeaders),
/* harmony export */   serializeResponse: () => (/* binding */ serializeResponse),
/* harmony export */   shouldDownloadAsText: () => (/* binding */ shouldDownloadAsText)
/* harmony export */ });
/* harmony import */ var js_yaml__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20382);

const shouldDownloadAsText = (contentType = '') => /(json|xml|yaml|text)\b/.test(contentType);
function parseBody(body, contentType) {
  if (contentType && (contentType.indexOf('application/json') === 0 || contentType.indexOf('+json') > 0)) {
    return JSON.parse(body);
  }
  return js_yaml__WEBPACK_IMPORTED_MODULE_0__["default"].load(body);
}
function serializeHeaderValue(value) {
  const isMulti = value.includes(', ');
  return isMulti ? value.split(', ') : value;
}

// Serialize headers into a hash, where mutliple-headers result in an array.
//
// eg: Cookie: one
//     Cookie: two
//  =  { Cookie: [ "one", "two" ]
function serializeHeaders(headers = {}) {
  if (typeof headers.entries !== 'function') return {};
  return Array.from(headers.entries()).reduce((acc, [header, value]) => {
    acc[header] = serializeHeaderValue(value);
    return acc;
  }, {});
}

// Serialize the response, returns a promise with headers and the body part of the hash
function serializeResponse(oriRes, url, {
  loadSpec = false
} = {}) {
  const res = {
    ok: oriRes.ok,
    url: oriRes.url || url,
    status: oriRes.status,
    statusText: oriRes.statusText,
    headers: serializeHeaders(oriRes.headers)
  };
  const contentType = res.headers['content-type'];
  const useText = loadSpec || shouldDownloadAsText(contentType);
  const getBody = useText ? oriRes.text : oriRes.blob || oriRes.buffer;
  return getBody.call(oriRes).then(body => {
    res.text = body;
    res.data = body;
    if (useText) {
      try {
        const obj = parseBody(body, contentType);
        res.body = obj;
        res.obj = obj;
      } catch (e) {
        res.parseError = e;
      }
    }
    return res;
  });
}

/***/ }),

/***/ 27301:
/***/ ((module) => {

/**
 * The base implementation of `_.unary` without support for storing metadata.
 *
 * @private
 * @param {Function} func The function to cap arguments for.
 * @returns {Function} Returns the new capped function.
 */
function baseUnary(func) {
  return function(value) {
    return func(value);
  };
}

module.exports = baseUnary;


/***/ }),

/***/ 27374:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// toObject with fallback for non-array-like ES3 strings
var IndexedObject = __webpack_require__(16946);
var requireObjectCoercible = __webpack_require__(74239);

module.exports = function (it) {
  return IndexedObject(requireObjectCoercible(it));
};


/***/ }),

/***/ 27534:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var baseGetTag = __webpack_require__(72552),
    isObjectLike = __webpack_require__(40346);

/** `Object#toString` result references. */
var argsTag = '[object Arguments]';

/**
 * The base implementation of `_.isArguments`.
 *
 * @private
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
 */
function baseIsArguments(value) {
  return isObjectLike(value) && baseGetTag(value) == argsTag;
}

module.exports = baseIsArguments;


/***/ }),

/***/ 27562:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ resolveGenericStrategy)
/* harmony export */ });
/* harmony import */ var _specmap_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1704);
/* harmony import */ var _utils_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34242);
/* harmony import */ var _utils_options_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(40428);



async function resolveGenericStrategy(options) {
  const {
    spec,
    mode,
    allowMetaPatches = true,
    pathDiscriminator,
    modelPropertyMacro,
    parameterMacro,
    requestInterceptor,
    responseInterceptor,
    skipNormalization = false,
    useCircularStructures,
    strategies
  } = options;
  const retrievalURI = _utils_options_js__WEBPACK_IMPORTED_MODULE_2__.retrievalURI(options);
  const httpClient = _utils_options_js__WEBPACK_IMPORTED_MODULE_2__.httpClient(options);
  const strategy = strategies.find(strg => strg.match(spec));
  return doResolve(spec);
  async function doResolve(_spec) {
    if (retrievalURI) {
      _specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.refs.docCache[retrievalURI] = _spec;
    }

    // Build a json-fetcher ( ie: give it a URL and get json out )
    _specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.refs.fetchJSON = (0,_utils_index_js__WEBPACK_IMPORTED_MODULE_1__.makeFetchJSON)(httpClient, {
      requestInterceptor,
      responseInterceptor
    });
    const plugs = [_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.refs];
    if (typeof parameterMacro === 'function') {
      plugs.push(_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.parameters);
    }
    if (typeof modelPropertyMacro === 'function') {
      plugs.push(_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.properties);
    }
    if (mode !== 'strict') {
      plugs.push(_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__.plugins.allOf);
    }

    // mapSpec is where the hard work happens
    const result = await (0,_specmap_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
      spec: _spec,
      context: {
        baseDoc: retrievalURI
      },
      plugins: plugs,
      allowMetaPatches,
      // allows adding .meta patches, which include adding `$$ref`s to the spec
      pathDiscriminator,
      // for lazy resolution
      parameterMacro,
      modelPropertyMacro,
      useCircularStructures
    });
    if (!skipNormalization) {
      result.spec = strategy.normalize(result.spec);
    }
    return result;
  }
}

/***/ }),

/***/ 27596:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   OpenAPI3_1DereferenceVisitor: () => (/* reexport safe */ _visitor_mjs__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   maybeRefractToSchemaElement: () => (/* reexport safe */ _util_mjs__WEBPACK_IMPORTED_MODULE_12__.maybeRefractToSchemaElement),
/* harmony export */   resolveSchema$idField: () => (/* reexport safe */ _util_mjs__WEBPACK_IMPORTED_MODULE_12__.resolveSchema$idField),
/* harmony export */   resolveSchema$refField: () => (/* reexport safe */ _util_mjs__WEBPACK_IMPORTED_MODULE_12__.resolveSchema$refField)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(95201);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(43319);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(77551);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(14615);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(45259);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(90374);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(8302);
/* harmony import */ var _DereferenceStrategy_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(96392);
/* harmony import */ var _Reference_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(83561);
/* harmony import */ var _ReferenceSet_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(56479);
/* harmony import */ var _visitor_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(19950);
/* harmony import */ var _util_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(35484);







// @ts-ignore
const visitAsync = _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.visit[Symbol.for('nodejs.util.promisify.custom')];

/**
 * @public
 */

/**
 * @public
 */
class OpenAPI3_1DereferenceStrategy extends _DereferenceStrategy_mjs__WEBPACK_IMPORTED_MODULE_1__["default"] {
  constructor(options) {
    super({
      ...(options !== null && options !== void 0 ? options : {}),
      name: 'openapi-3-1'
    });
  }
  canDereference(file) {
    var _file$parseResult;
    // assert by media type
    if (file.mediaType !== 'text/plain') {
      return _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_2__["default"].includes(file.mediaType);
    }

    // assert by inspecting ApiDOM
    return (0,_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_3__.isOpenApi3_1Element)((_file$parseResult = file.parseResult) === null || _file$parseResult === void 0 ? void 0 : _file$parseResult.result);
  }
  async dereference(file, options) {
    var _options$dereference$;
    const namespace = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.createNamespace)(_swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_5__["default"]);
    const immutableRefSet = (_options$dereference$ = options.dereference.refSet) !== null && _options$dereference$ !== void 0 ? _options$dereference$ : new _ReferenceSet_mjs__WEBPACK_IMPORTED_MODULE_6__["default"]();
    const mutableRefSet = new _ReferenceSet_mjs__WEBPACK_IMPORTED_MODULE_6__["default"]();
    let refSet = immutableRefSet;
    let reference;
    if (!immutableRefSet.has(file.uri)) {
      reference = new _Reference_mjs__WEBPACK_IMPORTED_MODULE_7__["default"]({
        uri: file.uri,
        value: file.parseResult
      });
      immutableRefSet.add(reference);
    } else {
      // pre-computed refSet was provided as configuration option
      reference = immutableRefSet.find((0,ramda__WEBPACK_IMPORTED_MODULE_8__["default"])(file.uri, 'uri'));
    }

    /**
     * Clone refSet due the dereferencing process being mutable.
     * We don't want to mutate the original refSet and the references.
     */
    if (options.dereference.immutable) {
      immutableRefSet.refs.map(ref => new _Reference_mjs__WEBPACK_IMPORTED_MODULE_7__["default"]({
        ...ref,
        value: (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.cloneDeep)(ref.value)
      })).forEach(ref => mutableRefSet.add(ref));
      reference = mutableRefSet.find(ref => ref.uri === file.uri);
      refSet = mutableRefSet;
    }
    const visitor = new _visitor_mjs__WEBPACK_IMPORTED_MODULE_10__["default"]({
      reference: reference,
      namespace,
      options
    });
    const dereferencedElement = await visitAsync(refSet.rootRef.value, visitor, {
      keyMap: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__.keyMap,
      nodeTypeGetter: _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_11__.getNodeType
    });

    /**
     * If immutable option is set, replay refs from the refSet.
     */
    if (options.dereference.immutable) {
      mutableRefSet.refs.filter(ref => ref.uri.startsWith('immutable://')).map(ref => new _Reference_mjs__WEBPACK_IMPORTED_MODULE_7__["default"]({
        ...ref,
        uri: ref.uri.replace(/^immutable:\/\//, '')
      })).forEach(ref => immutableRefSet.add(ref));
    }

    /**
     * Release all memory if this refSet was not provided as an configuration option.
     * If provided as configuration option, then provider is responsible for cleanup.
     */
    if (options.dereference.refSet === null) {
      immutableRefSet.clean();
    }
    mutableRefSet.clean();
    return dereferencedElement;
  }
}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (OpenAPI3_1DereferenceStrategy);

/***/ }),

/***/ 27607:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PatchError: () => (/* binding */ PatchError),
/* harmony export */   _deepClone: () => (/* binding */ _deepClone),
/* harmony export */   _getPathRecursive: () => (/* binding */ _getPathRecursive),
/* harmony export */   _objectKeys: () => (/* binding */ _objectKeys),
/* harmony export */   escapePathComponent: () => (/* binding */ escapePathComponent),
/* harmony export */   getPath: () => (/* binding */ getPath),
/* harmony export */   hasOwnProperty: () => (/* binding */ hasOwnProperty),
/* harmony export */   hasUndefined: () => (/* binding */ hasUndefined),
/* harmony export */   isInteger: () => (/* binding */ isInteger),
/* harmony export */   unescapePathComponent: () => (/* binding */ unescapePathComponent)
/* harmony export */ });
/*!
 * https://github.com/Starcounter-Jack/JSON-Patch
 * (c) 2017-2022 Joachim Wester
 * MIT licensed
 */
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var _hasOwnProperty = Object.prototype.hasOwnProperty;
function hasOwnProperty(obj, key) {
    return _hasOwnProperty.call(obj, key);
}
function _objectKeys(obj) {
    if (Array.isArray(obj)) {
        var keys_1 = new Array(obj.length);
        for (var k = 0; k < keys_1.length; k++) {
            keys_1[k] = "" + k;
        }
        return keys_1;
    }
    if (Object.keys) {
        return Object.keys(obj);
    }
    var keys = [];
    for (var i in obj) {
        if (hasOwnProperty(obj, i)) {
            keys.push(i);
        }
    }
    return keys;
}
;
/**
* Deeply clone the object.
* https://jsperf.com/deep-copy-vs-json-stringify-json-parse/25 (recursiveDeepCopy)
* @param  {any} obj value to clone
* @return {any} cloned obj
*/
function _deepClone(obj) {
    switch (typeof obj) {
        case "object":
            return JSON.parse(JSON.stringify(obj)); //Faster than ES5 clone - http://jsperf.com/deep-cloning-of-objects/5
        case "undefined":
            return null; //this is how JSON.stringify behaves for array items
        default:
            return obj; //no need to clone primitives
    }
}
//3x faster than cached /^\d+$/.test(str)
function isInteger(str) {
    var i = 0;
    var len = str.length;
    var charCode;
    while (i < len) {
        charCode = str.charCodeAt(i);
        if (charCode >= 48 && charCode <= 57) {
            i++;
            continue;
        }
        return false;
    }
    return true;
}
/**
* Escapes a json pointer path
* @param path The raw pointer
* @return the Escaped path
*/
function escapePathComponent(path) {
    if (path.indexOf('/') === -1 && path.indexOf('~') === -1)
        return path;
    return path.replace(/~/g, '~0').replace(/\//g, '~1');
}
/**
 * Unescapes a json pointer path
 * @param path The escaped pointer
 * @return The unescaped path
 */
function unescapePathComponent(path) {
    return path.replace(/~1/g, '/').replace(/~0/g, '~');
}
function _getPathRecursive(root, obj) {
    var found;
    for (var key in root) {
        if (hasOwnProperty(root, key)) {
            if (root[key] === obj) {
                return escapePathComponent(key) + '/';
            }
            else if (typeof root[key] === 'object') {
                found = _getPathRecursive(root[key], obj);
                if (found != '') {
                    return escapePathComponent(key) + '/' + found;
                }
            }
        }
    }
    return '';
}
function getPath(root, obj) {
    if (root === obj) {
        return '/';
    }
    var path = _getPathRecursive(root, obj);
    if (path === '') {
        throw new Error("Object not found in root");
    }
    return "/" + path;
}
/**
* Recursively checks whether an object has any undefined values inside.
*/
function hasUndefined(obj) {
    if (obj === undefined) {
        return true;
    }
    if (obj) {
        if (Array.isArray(obj)) {
            for (var i_1 = 0, len = obj.length; i_1 < len; i_1++) {
                if (hasUndefined(obj[i_1])) {
                    return true;
                }
            }
        }
        else if (typeof obj === "object") {
            var objKeys = _objectKeys(obj);
            var objKeysLength = objKeys.length;
            for (var i = 0; i < objKeysLength; i++) {
                if (hasUndefined(obj[objKeys[i]])) {
                    return true;
                }
            }
        }
    }
    return false;
}
function patchErrorMessageFormatter(message, args) {
    var messageParts = [message];
    for (var key in args) {
        var value = typeof args[key] === 'object' ? JSON.stringify(args[key], null, 2) : args[key]; // pretty print
        if (typeof value !== 'undefined') {
            messageParts.push(key + ": " + value);
        }
    }
    return messageParts.join('\n');
}
var PatchError = /** @class */ (function (_super) {
    __extends(PatchError, _super);
    function PatchError(message, name, index, operation, tree) {
        var _newTarget = this.constructor;
        var _this = _super.call(this, patchErrorMessageFormatter(message, { name: name, index: index, operation: operation, tree: tree })) || this;
        _this.name = name;
        _this.index = index;
        _this.operation = operation;
        _this.tree = tree;
        Object.setPrototypeOf(_this, _newTarget.prototype); // restore prototype chain, see https://stackoverflow.com/a/48342359
        _this.message = patchErrorMessageFormatter(message, { name: name, index: index, operation: operation, tree: tree });
        return _this;
    }
    return PatchError;
}(Error));



/***/ }),

/***/ 27660:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _arity)
/* harmony export */ });
function _arity(n, fn) {
  /* eslint-disable no-unused-vars */
  switch (n) {
    case 0:
      return function () {
        return fn.apply(this, arguments);
      };
    case 1:
      return function (a0) {
        return fn.apply(this, arguments);
      };
    case 2:
      return function (a0, a1) {
        return fn.apply(this, arguments);
      };
    case 3:
      return function (a0, a1, a2) {
        return fn.apply(this, arguments);
      };
    case 4:
      return function (a0, a1, a2, a3) {
        return fn.apply(this, arguments);
      };
    case 5:
      return function (a0, a1, a2, a3, a4) {
        return fn.apply(this, arguments);
      };
    case 6:
      return function (a0, a1, a2, a3, a4, a5) {
        return fn.apply(this, arguments);
      };
    case 7:
      return function (a0, a1, a2, a3, a4, a5, a6) {
        return fn.apply(this, arguments);
      };
    case 8:
      return function (a0, a1, a2, a3, a4, a5, a6, a7) {
        return fn.apply(this, arguments);
      };
    case 9:
      return function (a0, a1, a2, a3, a4, a5, a6, a7, a8) {
        return fn.apply(this, arguments);
      };
    case 10:
      return function (a0, a1, a2, a3, a4, a5, a6, a7, a8, a9) {
        return fn.apply(this, arguments);
      };
    default:
      throw new Error('First argument to _arity must be a non-negative integer no greater than ten');
  }
}

/***/ }),

/***/ 27722:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(95532);
/* harmony import */ var _normalize_header_examples_NormalizeStorage_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68429);


/**
 * Override of Schema.example and Schema.examples field inside the Parameter Objects.
 *
 * Parameter Object has two fixed fields:
 *  - `example` of type `Any`
 *  - `examples` of type `Map[string, Example Object | Reference Object]`
 *
 * OpenAPI 3.1 specification excerpt that defines the override behavior:
 *
 * The example value SHALL override the example provided by the schema.
 * Furthermore, if referencing a schema that contains an example, the examples value SHALL override the example provided by the schema.
 *
 * NOTE: this plugin is idempotent
 * @public
 */
/**
 * @public
 */
const plugin = ({
  storageField = 'x-normalized'
} = {}) => toolbox => {
  const {
    predicates,
    ancestorLineageToJSONPointer
  } = toolbox;
  let storage;
  return {
    visitor: {
      OpenApi3_1Element: {
        enter(element) {
          storage = new _normalize_header_examples_NormalizeStorage_mjs__WEBPACK_IMPORTED_MODULE_0__["default"](element, storageField, 'parameter-examples');
        },
        leave() {
          storage = undefined;
        }
      },
      ParameterElement: {
        leave(parameterElement, key, parent, path, ancestors) {
          var _parameterElement$sch, _parameterElement$sch2;
          // skip visiting this Parameter Object
          if (ancestors.some(predicates.isComponentsElement)) {
            return;
          }

          // no Parameter.schema field present
          if (typeof parameterElement.schema === 'undefined' || !predicates.isSchemaElement(parameterElement.schema)) {
            return;
          }
          // Schema contains no example
          if (typeof ((_parameterElement$sch = parameterElement.schema) === null || _parameterElement$sch === void 0 ? void 0 : _parameterElement$sch.example) === 'undefined' && typeof ((_parameterElement$sch2 = parameterElement.schema) === null || _parameterElement$sch2 === void 0 ? void 0 : _parameterElement$sch2.examples) === 'undefined') {
            return;
          }
          const parameterJSONPointer = ancestorLineageToJSONPointer([...ancestors, parent, parameterElement]);

          // skip visiting this Parameter Object if it's already normalized
          if (storage.includes(parameterJSONPointer)) {
            return;
          }

          /**
           * Parameter.examples and Schema.examples have preferences over the older
           * and deprected `example` field.
           */
          if (typeof parameterElement.examples !== 'undefined' && predicates.isObjectElement(parameterElement.examples)) {
            // @ts-ignore
            const examples = parameterElement.examples.map(example => {
              return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep.safe(example.value);
            });
            if (typeof parameterElement.schema.examples !== 'undefined') {
              parameterElement.schema.set('examples', examples);
              storage.append(parameterJSONPointer);
            }
            if (typeof parameterElement.schema.example !== 'undefined') {
              parameterElement.schema.set('example', examples[0]);
              storage.append(parameterJSONPointer);
            }
            return;
          }

          /**
           * Handle deprecated `example` field.
           */
          if (typeof parameterElement.example !== 'undefined') {
            if (typeof parameterElement.schema.examples !== 'undefined') {
              parameterElement.schema.set('examples', [(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(parameterElement.example)]);
              storage.append(parameterJSONPointer);
            }
            if (typeof parameterElement.schema.example !== 'undefined') {
              parameterElement.schema.set('example', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(parameterElement.example));
              storage.append(parameterJSONPointer);
            }
          }
        }
      }
    }
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugin);

/***/ }),

/***/ 27986:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ serialize)
/* harmony export */ });
/*
  Serializer that serializes according to a media type instead of OpenAPI's
  `style` + `explode` constructs.
*/

function serialize(value, mediaType) {
  if (mediaType.includes('application/json')) {
    if (typeof value === 'string') {
      // Assume the user has a JSON string
      return value;
    }
    if (Array.isArray(value)) {
      value = value.map(v => {
        try {
          return JSON.parse(v);
        } catch (e) {
          return v;
        }
      });
    }
    return JSON.stringify(value);
  }
  return String(value);
}

/***/ }),

/***/ 28276:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2173);


/**
 * Replace a substring or regex match in a string with a replacement.
 *
 * The first two parameters correspond to the parameters of the
 * `String.prototype.replace()` function, so the second parameter can also be a
 * function.
 *
 * @func
 * @memberOf R
 * @since v0.7.0
 * @category String
 * @sig RegExp|String -> String -> String -> String
 * @param {RegExp|String} pattern A regular expression or a substring to match.
 * @param {String} replacement The string to replace the matches with.
 * @param {String} str The String to do the search and replacement in.
 * @return {String} The result.
 * @example
 *
 *      R.replace('foo', 'bar', 'foo foo foo'); //=> 'bar foo foo'
 *      R.replace(/foo/, 'bar', 'foo foo foo'); //=> 'bar foo foo'
 *
 *      // Use the "g" (global) flag to replace all occurrences:
 *      R.replace(/foo/g, 'bar', 'foo foo foo'); //=> 'bar bar bar'
 */
var replace = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function replace(regex, replacement, str) {
  return str.replace(regex, replacement);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (replace);

/***/ }),

/***/ 28303:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(56110),
    root = __webpack_require__(9325);

/* Built-in method references that are verified to be native. */
var WeakMap = getNative(root, 'WeakMap');

module.exports = WeakMap;


/***/ }),

/***/ 28311:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var uncurryThis = __webpack_require__(92361);
var aCallable = __webpack_require__(82159);
var NATIVE_BIND = __webpack_require__(41505);

var bind = uncurryThis(uncurryThis.bind);

// optional / simple context binding
module.exports = function (fn, that) {
  aCallable(fn);
  return that === undefined ? fn : NATIVE_BIND ? bind(fn, that) : function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ 28683:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Blob: () => (/* binding */ Blob),
/* harmony export */   File: () => (/* binding */ File),
/* harmony export */   FormData: () => (/* binding */ FormData),
/* harmony export */   Headers: () => (/* binding */ Headers),
/* harmony export */   Request: () => (/* binding */ Request),
/* harmony export */   Response: () => (/* binding */ Response),
/* harmony export */   fetch: () => (/* binding */ fetch)
/* harmony export */ });
// we're targeting browsers that already support fetch API
const {
  fetch,
  Response,
  Headers,
  Request,
  FormData,
  File,
  Blob
} = globalThis;


/***/ }),

/***/ 28686:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ eachOperation)
/* harmony export */ });
// iterate over each operation, and fire a callback with details
// `find=true` will stop iterating, when the cb returns truthy
function eachOperation(spec, cb, find) {
  if (!spec || typeof spec !== 'object' || !spec.paths || typeof spec.paths !== 'object') {
    return null;
  }
  const {
    paths
  } = spec;

  // Iterate over the spec, collecting operations
  // eslint-disable-next-line no-restricted-syntax, guard-for-in
  for (const pathName in paths) {
    // eslint-disable-next-line no-restricted-syntax, guard-for-in
    for (const method in paths[pathName]) {
      if (method.toUpperCase() === 'PARAMETERS') {
        continue; // eslint-disable-line no-continue
      }
      const operation = paths[pathName][method];
      if (!operation || typeof operation !== 'object') {
        continue; // eslint-disable-line no-continue
      }
      const operationObj = {
        spec,
        pathName,
        method: method.toUpperCase(),
        operation
      };
      const cbValue = cb(operationObj);
      if (find && cbValue) {
        return operationObj;
      }
    }
  }
  return undefined;
}

/***/ }),

/***/ 28707:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRefractor: () => (/* binding */ createRefractor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(24445);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(34035);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(3510);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(43319);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4366);
/* harmony import */ var _specification_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(78180);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(76969);
/* harmony import */ var _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(93519);
/* harmony import */ var _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(11546);





/**
 * @public
 */
const refract = (value, {
  specPath = ['visitors', 'document', 'objects', 'JSONSchema', '$visitor'],
  plugins = [],
  specificationObj = _specification_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]
} = {}) => {
  const element = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.refract)(value);
  const resolvedSpec = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_2__.dereference)(specificationObj);

  /**
   * This is where generic ApiDOM becomes semantic (namespace applied).
   * We don't allow consumers to hook into this translation.
   * Though we allow consumers to define their onw plugins on already transformed ApiDOM.
   */
  const RootVisitorClass = (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(specPath, resolvedSpec);
  const rootVisitor = new RootVisitorClass({
    specObj: resolvedSpec
  });
  (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_4__.visit)(element, rootVisitor);

  /**
   * Run plugins only when necessary.
   * Running plugins visitors means extra single traversal === performance hit.
   */
  return (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_5__.dispatchPluginsSync)(rootVisitor.element, plugins, {
    toolboxCreator: _toolbox_mjs__WEBPACK_IMPORTED_MODULE_6__["default"],
    visitorOptions: {
      keyMap: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_7__.keyMap,
      nodeTypeGetter: _traversal_visitor_mjs__WEBPACK_IMPORTED_MODULE_8__.getNodeType
    }
  });
};

/**
 * @public
 */
const createRefractor = specPath => (value, options = {}) => refract(value, {
  specPath,
  ...options
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (refract);

/***/ }),

/***/ 29234:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(92254);
/* harmony import */ var _internal_dissoc_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(17162);
/* harmony import */ var _internal_isInteger_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(64279);
/* harmony import */ var _internal_isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5564);
/* harmony import */ var _assoc_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(83847);






/**
 * Makes a shallow clone of an object. Note that this copies and flattens
 * prototype properties onto the new object as well. All non-primitive
 * properties are copied by reference.
 *
 * @private
 * @param {String|Integer} prop The prop operating
 * @param {Object|Array} obj The object to clone
 * @return {Object|Array} A new object equivalent to the original.
 */
function _shallowCloneObject(prop, obj) {
  if ((0,_internal_isInteger_js__WEBPACK_IMPORTED_MODULE_0__["default"])(prop) && (0,_internal_isArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(obj)) {
    return [].concat(obj);
  }
  var result = {};
  for (var p in obj) {
    result[p] = obj[p];
  }
  return result;
}

/**
 * Makes a shallow clone of an object, omitting the property at the given path.
 * Note that this copies and flattens prototype properties onto the new object
 * as well. All non-primitive properties are copied by reference.
 *
 * @func
 * @memberOf R
 * @since v0.11.0
 * @category Object
 * @typedefn Idx = String | Int | Symbol
 * @sig [Idx] -> {k: v} -> {k: v}
 * @param {Array} path The path to the value to omit
 * @param {Object} obj The object to clone
 * @return {Object} A new object without the property at path
 * @see R.assocPath
 * @example
 *
 *      R.dissocPath(['a', 'b', 'c'], {a: {b: {c: 42}}}); //=> {a: {b: {}}}
 */
var dissocPath = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_2__["default"])(function dissocPath(path, obj) {
  if (obj == null) {
    return obj;
  }
  switch (path.length) {
    case 0:
      return obj;
    case 1:
      return (0,_internal_dissoc_js__WEBPACK_IMPORTED_MODULE_3__["default"])(path[0], obj);
    default:
      var head = path[0];
      var tail = Array.prototype.slice.call(path, 1);
      if (obj[head] == null) {
        return _shallowCloneObject(head, obj);
      } else {
        return (0,_assoc_js__WEBPACK_IMPORTED_MODULE_4__["default"])(head, dissocPath(tail, obj[head]), obj);
      }
  }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dissocPath);

/***/ }),

/***/ 29364:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class Openapi extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.StringElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'openapi';
    this.classes.push('spec-version');
    this.classes.push('version');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Openapi);

/***/ }),

/***/ 29367:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var aCallable = __webpack_require__(82159);
var isNullOrUndefined = __webpack_require__(87136);

// `GetMethod` abstract operation
// https://tc39.es/ecma262/#sec-getmethod
module.exports = function (V, P) {
  var func = V[P];
  return isNullOrUndefined(func) ? undefined : aCallable(func);
};


/***/ }),

/***/ 29382:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   encodeFormOrQuery: () => (/* binding */ encodeFormOrQuery),
/* harmony export */   serializeRequest: () => (/* binding */ serializeRequest),
/* harmony export */   stringifyQuery: () => (/* binding */ stringifyQuery)
/* harmony export */ });
/* harmony import */ var _format_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46439);
/* harmony import */ var _file_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3474);


function buildFormData(reqForm) {
  /**
   * Build a new FormData instance, support array as field value
   * OAS2.0 - when collectionFormat is multi
   * OAS3.0 - when explode of Encoding Object is true
   *
   * This function explicitly handles Buffers (for backward compatibility)
   * if provided as a values to FormData. FormData can only handle USVString
   * or Blob.
   *
   * @param {Object} reqForm - ori req.form
   * @return {FormData} - new FormData instance
   */
  return Object.entries(reqForm).reduce((formData, [name, input]) => {
    // eslint-disable-next-line no-restricted-syntax
    for (const [key, value] of (0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(name, input, true)) {
      if (Array.isArray(value)) {
        // eslint-disable-next-line no-restricted-syntax
        for (const v of value) {
          if (ArrayBuffer.isView(v)) {
            const blob = new Blob([v]);
            formData.append(key, blob);
          } else {
            formData.append(key, v);
          }
        }
      } else if (ArrayBuffer.isView(value)) {
        const blob = new Blob([value]);
        formData.append(key, blob);
      } else {
        formData.append(key, value);
      }
    }
    return formData;
  }, new FormData());
}
const stringifyQuery = (queryObject, {
  encode = true
} = {}) => {
  const buildNestedParams = (params, key, value) => {
    if (Array.isArray(value)) {
      value.reduce((acc, v) => buildNestedParams(params, key, v), params);
    } else if (value instanceof Date) {
      params.append(key, value.toISOString());
    } else if (typeof value === 'object') {
      Object.entries(value).reduce((acc, [k, v]) => buildNestedParams(params, `${key}[${k}]`, v), params);
    } else {
      params.append(key, value);
    }
    return params;
  };
  const params = Object.entries(queryObject).reduce((acc, [key, value]) => buildNestedParams(acc, key, value), new URLSearchParams());
  const queryString = String(params);
  return encode ? queryString : decodeURIComponent(queryString);
};

// Encodes an object using appropriate serializer.
function encodeFormOrQuery(data) {
  /**
   * Encode parameter names and values
   * @param {Object} result - parameter names and values
   * @param {string} parameterName - Parameter name
   * @return {object} encoded parameter names and values
   */
  const encodedQueryObj = Object.keys(data).reduce((result, parameterName) => {
    // eslint-disable-next-line no-restricted-syntax
    for (const [key, value] of (0,_format_js__WEBPACK_IMPORTED_MODULE_0__["default"])(parameterName, data[parameterName])) {
      if (value instanceof _file_js__WEBPACK_IMPORTED_MODULE_1__.FileWithData) {
        result[key] = value.valueOf();
      } else {
        result[key] = value;
      }
    }
    return result;
  }, {});
  return stringifyQuery(encodedQueryObj, {
    encode: false
  });
}

// If the request has a `query` object, merge it into the request.url, and delete the object
// If file and/or multipart, also create FormData instance
function serializeRequest(req = {}) {
  const {
    url = '',
    query,
    form
  } = req;
  const joinSearch = (...strs) => {
    const search = strs.filter(a => a).join('&'); // Only truthy value
    return search ? `?${search}` : ''; // Only add '?' if there is a str
  };
  if (form) {
    const hasFile = Object.keys(form).some(key => {
      const {
        value
      } = form[key];
      return (0,_file_js__WEBPACK_IMPORTED_MODULE_1__.isFile)(value) || (0,_file_js__WEBPACK_IMPORTED_MODULE_1__.isArrayOfFile)(value);
    });
    const contentType = req.headers['content-type'] || req.headers['Content-Type'];
    if (hasFile || /multipart\/form-data/i.test(contentType)) {
      const formdata = buildFormData(req.form);
      req.formdata = formdata;
      req.body = formdata;
    } else {
      req.body = encodeFormOrQuery(form);
    }
    delete req.form;
  }
  if (query) {
    const [baseUrl, oriSearch] = url.split('?');
    let newStr = '';
    if (oriSearch) {
      const oriQuery = new URLSearchParams(oriSearch);
      const keysToRemove = Object.keys(query);
      keysToRemove.forEach(key => oriQuery.delete(key));
      newStr = String(oriQuery);
    }
    const finalStr = joinSearch(newStr, encodeFormOrQuery(query));
    req.url = baseUrl + finalStr;
    delete req.query;
  }
  return req;
}

/***/ }),

/***/ 29453:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25845);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(10625);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(60292);
/* harmony import */ var _isNotNull_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6720);
/* harmony import */ var _isFunction_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(34610);
/* harmony import */ var _internal_isOfTypeObject_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(34156);





/* eslint-disable max-len */
/**
 * Checks if input value is language type of `Object`.
 *
 * @func isObj
 * @aliases isObject
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.5.0|v0.5.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link RA.isNotObj|isNotObj}, {@link RA.isObjLike|isObjLike}, {@link RA.isPlainObj|isPlainObj}
 * @example
 *
 * RA.isObj({}); //=> true
 * RA.isObj([]); //=> true
 * RA.isObj(() => {}); //=> true
 * RA.isObj(null); //=> false
 * RA.isObj(undefined); //=> false
 */
/* eslint-enable max-len */
var isObj = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(1, (0,ramda__WEBPACK_IMPORTED_MODULE_1__["default"])(_isNotNull_js__WEBPACK_IMPORTED_MODULE_2__["default"], (0,ramda__WEBPACK_IMPORTED_MODULE_3__["default"])(_internal_isOfTypeObject_js__WEBPACK_IMPORTED_MODULE_4__["default"], _isFunction_js__WEBPACK_IMPORTED_MODULE_5__["default"])));
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isObj);

/***/ }),

/***/ 29461:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_arity_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(27660);
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);



/**
 * Creates a function that is bound to a context.
 * Note: `R.bind` does not provide the additional argument-binding capabilities of
 * [Function.prototype.bind](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/bind).
 *
 * @func
 * @memberOf R
 * @since v0.6.0
 * @category Function
 * @category Object
 * @sig (* -> *) -> {*} -> (* -> *)
 * @param {Function} fn The function to bind to context
 * @param {Object} thisObj The context to bind `fn` to
 * @return {Function} A function that will execute in the context of `thisObj`.
 * @see R.partial
 * @example
 *
 *      const log = R.bind(console.log, console);
 *      R.pipe(R.assoc('a', 2), R.tap(log), R.assoc('a', 3))({a: 1}); //=> {a: 3}
 *      // logs {a: 2}
 * @symb R.bind(f, o)(a, b) = f.call(o, a, b)
 */
var bind = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function bind(fn, thisObj) {
  return (0,_internal_arity_js__WEBPACK_IMPORTED_MODULE_1__["default"])(fn.length, function () {
    return fn.apply(thisObj, arguments);
  });
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (bind);

/***/ }),

/***/ 29641:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(28683);

if (typeof globalThis.fetch === 'undefined') {
  globalThis.fetch = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.fetch;
}
if (typeof globalThis.Headers === 'undefined') {
  globalThis.Headers = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.Headers;
}
if (typeof globalThis.Request === 'undefined') {
  globalThis.Request = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.Request;
}
if (typeof globalThis.Response === 'undefined') {
  globalThis.Response = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.Response;
}
if (typeof globalThis.FormData === 'undefined') {
  globalThis.FormData = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.FormData;
}
if (typeof globalThis.File === 'undefined') {
  globalThis.File = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.File;
}
if (typeof globalThis.Blob === 'undefined') {
  globalThis.Blob = _fetch_ponyfill_browser_js__WEBPACK_IMPORTED_MODULE_0__.Blob;
}

/***/ }),

/***/ 29646:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Grammar: () => (/* reexport safe */ _server_url_templating_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   encodeServerVariable: () => (/* reexport safe */ _substitute_mjs__WEBPACK_IMPORTED_MODULE_3__.encodeServerVariable),
/* harmony export */   parse: () => (/* reexport safe */ _parse_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   substitute: () => (/* reexport safe */ _substitute_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   test: () => (/* reexport safe */ _test_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _server_url_templating_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(77527);
/* harmony import */ var _test_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3406);
/* harmony import */ var _parse_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(39790);
/* harmony import */ var _substitute_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16254);





/***/ }),

/***/ 29663:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _equals_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(37911);
/* harmony import */ var _take_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(66973);




/**
 * Checks if a list starts with the provided sublist.
 *
 * Similarly, checks if a string starts with the provided substring.
 *
 * @func
 * @memberOf R
 * @since v0.24.0
 * @category List
 * @sig [a] -> [a] -> Boolean
 * @sig String -> String -> Boolean
 * @param {*} prefix
 * @param {*} list
 * @return {Boolean}
 * @see R.endsWith
 * @example
 *
 *      R.startsWith('a', 'abc')                //=> true
 *      R.startsWith('b', 'abc')                //=> false
 *      R.startsWith(['a'], ['a', 'b', 'c'])    //=> true
 *      R.startsWith(['b'], ['a', 'b', 'c'])    //=> false
 */
var startsWith = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function (prefix, list) {
  return (0,_equals_js__WEBPACK_IMPORTED_MODULE_1__["default"])((0,_take_js__WEBPACK_IMPORTED_MODULE_2__["default"])(prefix.length, list), prefix);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (startsWith);

/***/ }),

/***/ 29746:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class SecurityScheme extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.SecuritySchemeElement {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SecurityScheme);

/***/ }),

/***/ 29817:
/***/ ((module) => {

/**
 * Checks if a stack value for `key` exists.
 *
 * @private
 * @name has
 * @memberOf Stack
 * @param {string} key The key of the entry to check.
 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
 */
function stackHas(key) {
  return this.__data__.has(key);
}

module.exports = stackHas;


/***/ }),

/***/ 29825:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1908);


/**
 * @public
 */
class Callback extends _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_0__.ObjectElement {
  constructor(content, meta, attributes) {
    super(content, meta, attributes);
    this.element = 'callback';
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Callback);

/***/ }),

/***/ 30053:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseRequestBodyVisitor: () => (/* binding */ BaseRequestBodyVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(18088);


/**
 * @public
 */
const BaseRequestBodyVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.RequestBody.$visitor;
/**
 * @public
 */
class RequestBodyVisitor extends BaseRequestBodyVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_RequestBody_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RequestBodyVisitor);

/***/ }),

/***/ 30259:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _reduced)
/* harmony export */ });
function _reduced(x) {
  return x && x['@@transducer/reduced'] ? x : {
    '@@transducer/value': x,
    '@@transducer/reduced': true
  };
}

/***/ }),

/***/ 30294:
/***/ ((module) => {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/**
 * Checks if `value` is a valid array-like length.
 *
 * **Note:** This method is loosely based on
 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
 * @example
 *
 * _.isLength(3);
 * // => true
 *
 * _.isLength(Number.MIN_VALUE);
 * // => false
 *
 * _.isLength(Infinity);
 * // => false
 *
 * _.isLength('3');
 * // => false
 */
function isLength(value) {
  return typeof value == 'number' &&
    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
}

module.exports = isLength;


/***/ }),

/***/ 30361:
/***/ ((module) => {

/** Used as references for various `Number` constants. */
var MAX_SAFE_INTEGER = 9007199254740991;

/** Used to detect unsigned integer values. */
var reIsUint = /^(?:0|[1-9]\d*)$/;

/**
 * Checks if `value` is a valid array-like index.
 *
 * @private
 * @param {*} value The value to check.
 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
 */
function isIndex(value, length) {
  var type = typeof value;
  length = length == null ? MAX_SAFE_INTEGER : length;

  return !!length &&
    (type == 'number' ||
      (type != 'symbol' && reIsUint.test(value))) &&
        (value > -1 && value % 1 == 0 && value < length);
}

module.exports = isIndex;


/***/ }),

/***/ 30371:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _checkForMethod)
/* harmony export */ });
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5564);


/**
 * This checks whether a function has a [methodname] function. If it isn't an
 * array it will execute that function otherwise it will default to the ramda
 * implementation.
 *
 * @private
 * @param {Function} fn ramda implementation
 * @param {String} methodname property to check for a custom implementation
 * @return {Object} Whatever the return value of the method is.
 */
function _checkForMethod(methodname, fn) {
  return function () {
    var length = arguments.length;
    if (length === 0) {
      return fn();
    }
    var obj = arguments[length - 1];
    return (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(obj) || typeof obj[methodname] !== 'function' ? fn.apply(this, arguments) : obj[methodname].apply(obj, Array.prototype.slice.call(arguments, 0, length - 1));
  };
}

/***/ }),

/***/ 30377:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getNodeType: () => (/* reexport safe */ _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__.getNodeType),
/* harmony export */   keyMap: () => (/* binding */ keyMap)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(43319);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(93519);



/**
 * @public
 */
const keyMap = {
  JSONSchemaDraft6Element: ['content'],
  JSONReferenceElement: ['content'],
  MediaElement: ['content'],
  LinkDescriptionElement: ['content'],
  ..._swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.keyMapDefault
};

/***/ }),

/***/ 30516:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _invoker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(57898);


/**
 * Splits a string into an array of strings based on the given
 * separator.
 *
 * @func
 * @memberOf R
 * @since v0.1.0
 * @category String
 * @sig (String | RegExp) -> String -> [String]
 * @param {String|RegExp} sep The pattern.
 * @param {String} str The string to separate into an array.
 * @return {Array} The array of strings from `str` separated by `sep`.
 * @see R.join
 * @example
 *
 *      const pathComponents = R.split('/');
 *      R.tail(pathComponents('/usr/local/bin/node')); //=> ['usr', 'local', 'bin', 'node']
 *
 *      R.split('.', 'a.b.c.xyz.d'); //=> ['a', 'b', 'c', 'xyz', 'd']
 */
var split = /*#__PURE__*/(0,_invoker_js__WEBPACK_IMPORTED_MODULE_0__["default"])(1, 'split');
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (split);

/***/ }),

/***/ 30522:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _xArrayReduce)
/* harmony export */ });
function _xArrayReduce(xf, acc, list) {
  var idx = 0;
  var len = list.length;
  while (idx < len) {
    acc = xf['@@transducer/step'](acc, list[idx]);
    if (acc && acc['@@transducer/reduced']) {
      acc = acc['@@transducer/value'];
      break;
    }
    idx += 1;
  }
  return xf['@@transducer/result'](acc);
}

/***/ }),

/***/ 30658:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ idFromPathMethod)
/* harmony export */ });
/* harmony import */ var _replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(47891);

function idFromPathMethod(pathName, method, {
  v2OperationIdCompatibilityMode
} = {}) {
  if (v2OperationIdCompatibilityMode) {
    let res = `${method.toLowerCase()}_${pathName}`.replace(/[\s!@#$%^&*()_+=[{\]};:<>|./?,\\'""-]/g, '_');
    res = res || `${pathName.substring(1)}_${method}`;
    return res.replace(/((_){2,})/g, '_').replace(/^(_)*/g, '').replace(/([_])*$/g, '');
  }
  return `${method.toLowerCase()}${(0,_replace_special_chars_with_underscore_js__WEBPACK_IMPORTED_MODULE_0__["default"])(pathName)}`;
}

/***/ }),

/***/ 30779:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _xdropWhile)
/* harmony export */ });
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21878);

var XDropWhile = /*#__PURE__*/function () {
  function XDropWhile(f, xf) {
    this.xf = xf;
    this.f = f;
  }
  XDropWhile.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__["default"].init;
  XDropWhile.prototype['@@transducer/result'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__["default"].result;
  XDropWhile.prototype['@@transducer/step'] = function (result, input) {
    if (this.f) {
      if (this.f(input)) {
        return result;
      }
      this.f = null;
    }
    return this.xf['@@transducer/step'](result, input);
  };
  return XDropWhile;
}();
function _xdropWhile(f) {
  return function (xf) {
    return new XDropWhile(f, xf);
  };
}

/***/ }),

/***/ 31086:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isJSONReferenceElement: () => (/* reexport safe */ _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__.isJSONReferenceElement),
/* harmony export */   isJSONSchemaElement: () => (/* binding */ isJSONSchemaElement),
/* harmony export */   isLinkDescriptionElement: () => (/* binding */ isLinkDescriptionElement),
/* harmony export */   isMediaElement: () => (/* reexport safe */ _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__.isMediaElement)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(46902);
/* harmony import */ var _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(81497);
/* harmony import */ var _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40552);
/* harmony import */ var _swagger_api_apidom_ns_json_schema_draft_4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(95088);





/**
 * @public
 */
const isJSONSchemaElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_JSONSchema_mjs__WEBPACK_IMPORTED_MODULE_2__["default"] || hasBasicElementProps(element) && isElementType('JSONSchemaDraft6', element) && primitiveEq('object', element);
});

/**
 * @public
 */
const isLinkDescriptionElement = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__["default"])(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof _elements_LinkDescription_mjs__WEBPACK_IMPORTED_MODULE_3__["default"] || hasBasicElementProps(element) && isElementType('linkDescription', element) && primitiveEq('object', element);
});

/***/ }),

/***/ 31115:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _filter)
/* harmony export */ });
function _filter(fn, list) {
  var idx = 0;
  var len = list.length;
  var result = [];
  while (idx < len) {
    if (fn(list[idx])) {
      result[result.length] = list[idx];
    }
    idx += 1;
  }
  return result;
}

/***/ }),

/***/ 31175:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var assocIndexOf = __webpack_require__(26025);

/**
 * Sets the list cache `key` to `value`.
 *
 * @private
 * @name set
 * @memberOf ListCache
 * @param {string} key The key of the value to set.
 * @param {*} value The value to set.
 * @returns {Object} Returns the list cache instance.
 */
function listCacheSet(key, value) {
  var data = this.__data__,
      index = assocIndexOf(data, key);

  if (index < 0) {
    ++this.size;
    data.push([key, value]);
  } else {
    data[index][1] = value;
  }
  return this;
}

module.exports = listCacheSet;


/***/ }),

/***/ 31189:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apg_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16646);

const literals = (state, chars, phraseIndex, phraseLength, data) => {
  if (state === apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_PRE) {
    if (Array.isArray(data) === false) {
      throw new Error("parser's user data must be an array");
    }
    data.push(['literals', apg_lite__WEBPACK_IMPORTED_MODULE_0__.utilities.charsToString(chars, phraseIndex, phraseLength)]);
  }
  return apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_OK;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (literals);

/***/ }),

/***/ 31329:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
class EphemeralObject {
  type = 'EphemeralObject';
  content = [];
  reference = undefined;
  constructor(content) {
    this.content = content;
    this.reference = {};
  }
  toReference() {
    return this.reference;
  }
  toObject() {
    return Object.assign(this.reference, Object.fromEntries(this.content));
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EphemeralObject);

/***/ }),

/***/ 31380:
/***/ ((module) => {

/** Used to stand-in for `undefined` hash values. */
var HASH_UNDEFINED = '__lodash_hash_undefined__';

/**
 * Adds `value` to the array cache.
 *
 * @private
 * @name add
 * @memberOf SetCache
 * @alias push
 * @param {*} value The value to cache.
 * @returns {Object} Returns the cache instance.
 */
function setCacheAdd(value) {
  this.__data__.set(value, HASH_UNDEFINED);
  return this;
}

module.exports = setCacheAdd;


/***/ }),

/***/ 31407:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(83400);


/**
 * @public
 */
class Responses extends _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__.ResponsesElement {}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Responses);

/***/ }),

/***/ 31439:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52345);

/**
 * @public
 */
class DependentSchemasVisitor extends _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.passingOptionsNames.push('parent');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DependentSchemasVisitor);

/***/ }),

/***/ 31451:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ _xdropLastWhile)
/* harmony export */ });
/* harmony import */ var _xfBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(21878);
/* harmony import */ var _xReduce_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(78475);


var XDropLastWhile = /*#__PURE__*/function () {
  function XDropLastWhile(fn, xf) {
    this.f = fn;
    this.retained = [];
    this.xf = xf;
  }
  XDropLastWhile.prototype['@@transducer/init'] = _xfBase_js__WEBPACK_IMPORTED_MODULE_0__["default"].init;
  XDropLastWhile.prototype['@@transducer/result'] = function (result) {
    this.retained = null;
    return this.xf['@@transducer/result'](result);
  };
  XDropLastWhile.prototype['@@transducer/step'] = function (result, input) {
    return this.f(input) ? this.retain(result, input) : this.flush(result, input);
  };
  XDropLastWhile.prototype.flush = function (result, input) {
    result = (0,_xReduce_js__WEBPACK_IMPORTED_MODULE_1__["default"])(this.xf, result, this.retained);
    this.retained = [];
    return this.xf['@@transducer/step'](result, input);
  };
  XDropLastWhile.prototype.retain = function (result, input) {
    this.retained.push(input);
    return result;
  };
  return XDropLastWhile;
}();
function _xdropLastWhile(fn) {
  return function (xf) {
    return new XDropLastWhile(fn, xf);
  };
}

/***/ }),

/***/ 31696:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apg_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16646);

const slash = (state, chars, phraseIndex, phraseLength, data) => {
  if (state === apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_PRE) {
    data.push(['slash', apg_lite__WEBPACK_IMPORTED_MODULE_0__.utilities.charsToString(chars, phraseIndex, phraseLength)]);
  } else if (state === apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_POST) {
    /* not used in this example */
  }
  return apg_lite__WEBPACK_IMPORTED_MODULE_0__.identifiers.SEM_OK;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (slash);

/***/ }),

/***/ 31857:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BaseExternalDocumentationVisitor: () => (/* binding */ BaseExternalDocumentationVisitor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2086);
/* harmony import */ var _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(62278);


/**
 * @public
 */
const BaseExternalDocumentationVisitor = _swagger_api_apidom_ns_openapi_3_0__WEBPACK_IMPORTED_MODULE_0__["default"].visitors.document.objects.ExternalDocumentation.$visitor;
/**
 * @public
 */
class ExternalDocumentationVisitor extends BaseExternalDocumentationVisitor {
  constructor(options) {
    super(options);
    this.element = new _elements_ExternalDocumentation_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]();
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExternalDocumentationVisitor);

/***/ }),

/***/ 32096:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var toString = __webpack_require__(90160);

module.exports = function (argument, $default) {
  return argument === undefined ? arguments.length < 2 ? '' : $default : toString(argument);
};


/***/ }),

/***/ 32196:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16566);

/**
 * @public
 */
class AllOfVisitor extends _swagger_api_apidom_ns_json_schema_2020_12__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor(options) {
    super(options);
    this.passingOptionsNames.push('parent');
  }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AllOfVisitor);

/***/ }),

/***/ 32366:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2173);


/**
 * Tests the final argument by passing it to the given predicate function. If
 * the predicate is satisfied, the function will return the result of calling
 * the `whenTrueFn` function with the same argument. If the predicate is not
 * satisfied, the argument is returned as is.
 *
 * @func
 * @memberOf R
 * @since v0.18.0
 * @category Logic
 * @sig (a -> Boolean) -> (a -> b) -> a -> a | b
 * @param {Function} pred       A predicate function
 * @param {Function} whenTrueFn A function to invoke when the `condition`
 *                              evaluates to a truthy value.
 * @param {*}        x          An object to test with the `pred` function and
 *                              pass to `whenTrueFn` if necessary.
 * @return {*} Either `x` or the result of applying `x` to `whenTrueFn`.
 * @see R.ifElse, R.unless, R.cond
 * @example
 *
 *      // truncate :: String -> String
 *      const truncate = R.when(
 *        R.propSatisfies(R.gt(R.__, 10), 'length'),
 *        R.pipe(R.take(10), R.append('…'), R.join(''))
 *      );
 *      truncate('12345');         //=> '12345'
 *      truncate('0123456789ABC'); //=> '0123456789…'
 */
var when = /*#__PURE__*/(0,_internal_curry3_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function when(pred, whenTrueFn, x) {
  return pred(x) ? whenTrueFn(x) : x;
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (when);

/***/ }),

/***/ 32458:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(25690);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(51647);


/**
 * Checks if input value is complement of `null` or `undefined`.
 *
 * @func isNotNil
 * @memberOf RA
 * @since {@link https://char0n.github.io/ramda-adjunct/0.3.0|v0.3.0}
 * @category Type
 * @sig * -> Boolean
 * @param {*} val The value to test
 * @return {boolean}
 * @see {@link http://ramdajs.com/docs/#isNil|R.isNil}
 * @example
 *
 * RA.isNotNil(null); //=> false
 * RA.isNotNil(undefined); //=> false
 * RA.isNotNil(0); //=> true
 * RA.isNotNil([]); //=> true
 */
var isNotNil = (0,ramda__WEBPACK_IMPORTED_MODULE_0__["default"])(ramda__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isNotNil);

/***/ }),

/***/ 32729:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   baseUrl: () => (/* binding */ baseUrl),
/* harmony export */   buildRequest: () => (/* binding */ buildRequest),
/* harmony export */   execute: () => (/* binding */ execute),
/* harmony export */   self: () => (/* binding */ self)
/* harmony export */ });
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(73236);
/* harmony import */ var ramda__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(43628);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(24955);
/* harmony import */ var ramda_adjunct__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(46455);
/* harmony import */ var openapi_server_url_templating__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(29646);
/* harmony import */ var _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(22874);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(96664);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3832);
/* harmony import */ var _http_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(51670);
/* harmony import */ var _http_serializers_request_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(29382);
/* harmony import */ var _swagger2_parameter_builders_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(90520);
/* harmony import */ var _oas3_parameter_builders_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(42276);
/* harmony import */ var _oas3_build_request_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(53044);
/* harmony import */ var _swagger2_build_request_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(77768);
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(47555);
/* harmony import */ var _helpers_index_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(50324);
/* harmony import */ var _helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(50918);
/* harmony import */ var _helpers_cookie_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(48009);















const arrayOrEmpty = ar => Array.isArray(ar) ? ar : [];
const findObjectOrArraySchema = (schema, {
  recurse = true,
  depth = 1
} = {}) => {
  if (!(0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_9__["default"])(schema)) return undefined;

  // check if the schema is an object or array type
  if (schema.type === 'object' || schema.type === 'array' || Array.isArray(schema.type) && (schema.type.includes('object') || schema.type.includes('array'))) {
    return schema;
  }
  if (depth > _constants_js__WEBPACK_IMPORTED_MODULE_1__.TRAVERSE_LIMIT) return undefined;
  if (recurse) {
    // traverse oneOf keyword first
    const oneOfResult = Array.isArray(schema.oneOf) ? schema.oneOf.find(subschema => findObjectOrArraySchema(subschema, {
      recurse,
      depth: depth + 1
    })) : undefined;
    if (oneOfResult) return oneOfResult;

    // traverse anyOf keyword second
    const anyOfResult = Array.isArray(schema.anyOf) ? schema.anyOf.find(subschema => findObjectOrArraySchema(subschema, {
      recurse,
      depth: depth + 1
    })) : undefined;
    if (anyOfResult) return anyOfResult;
  }
  return undefined;
};
const parseJsonObjectOrArray = ({
  value,
  silentFail = false
}) => {
  try {
    const parsedValue = JSON.parse(value);
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_9__["default"])(parsedValue) || Array.isArray(parsedValue)) {
      return parsedValue;
    }
    if (!silentFail) {
      throw new Error('Expected JSON serialized object or array');
    }
  } catch {
    if (!silentFail) {
      throw new Error('Could not parse parameter value string as JSON Object or JSON Array');
    }
  }
  return value;
};

/**
 * `parseURIReference` function simulates the behavior of `node:url` parse function.
 * New WHATWG URL API is not capable of parsing relative references natively,
 * but can be adapter by utilizing the `base` parameter.
 */
const parseURIReference = uriReference => {
  try {
    return new URL(uriReference);
  } catch {
    const parsedURL = new URL(uriReference, _constants_js__WEBPACK_IMPORTED_MODULE_1__.DEFAULT_BASE_URL);
    const pathname = String(uriReference).startsWith('/') ? parsedURL.pathname : parsedURL.pathname.substring(1);
    return {
      hash: parsedURL.hash,
      host: '',
      hostname: '',
      href: '',
      origin: '',
      password: '',
      pathname,
      port: '',
      protocol: '',
      search: parsedURL.search,
      searchParams: parsedURL.searchParams
    };
  }
};
class OperationNotFoundError extends _swagger_api_apidom_error__WEBPACK_IMPORTED_MODULE_10__["default"] {}
const findParametersWithName = (name, parameters) => parameters.filter(p => p.name === name);

// removes parameters that have duplicate 'in' and 'name' properties
const deduplicateParameters = parameters => {
  const paramsMap = {};
  parameters.forEach(p => {
    if (!paramsMap[p.in]) {
      paramsMap[p.in] = {};
    }
    paramsMap[p.in][p.name] = p;
  });
  const dedupedParameters = [];
  Object.keys(paramsMap).forEach(i => {
    Object.keys(paramsMap[i]).forEach(p => {
      dedupedParameters.push(paramsMap[i][p]);
    });
  });
  return dedupedParameters;
};

// For stubbing in tests
const self = {
  buildRequest
};

// Execute request, with the given operationId and parameters
// pathName/method or operationId is optional
function execute({
  http: userHttp,
  fetch,
  // This is legacy
  spec,
  operationId,
  pathName,
  method,
  parameters,
  securities,
  ...extras
}) {
  // Provide default fetch implementation
  const http = userHttp || fetch || _http_index_js__WEBPACK_IMPORTED_MODULE_2__["default"]; // Default to _our_ http

  if (pathName && method && !operationId) {
    operationId = (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_11__["default"])(pathName, method);
  }
  const request = self.buildRequest({
    spec,
    operationId,
    parameters,
    securities,
    http,
    ...extras
  });
  if (request.body && ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_9__["default"])(request.body) || Array.isArray(request.body))) {
    request.body = JSON.stringify(request.body);
  }

  // Build request and execute it
  return http(request);
}

// Build a request, which can be handled by the `http.js` implementation.
function buildRequest(options) {
  const {
    spec,
    operationId,
    responseContentType,
    scheme,
    requestInterceptor,
    responseInterceptor,
    contextUrl,
    userFetch,
    server,
    serverVariables,
    http,
    signal,
    serverVariableEncoder
  } = options;
  let {
    parameters,
    parameterBuilders,
    baseURL
  } = options;
  const specIsOAS3 = (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_12__.isOpenAPI3)(spec);
  if (!parameterBuilders) {
    // user did not provide custom parameter builders
    if (specIsOAS3) {
      parameterBuilders = _oas3_parameter_builders_js__WEBPACK_IMPORTED_MODULE_5__;
    } else {
      parameterBuilders = _swagger2_parameter_builders_js__WEBPACK_IMPORTED_MODULE_4__["default"];
    }
  }

  // Set credentials with 'http.withCredentials' value
  const credentials = http && http.withCredentials ? 'include' : 'same-origin';

  // Base Template
  let req = {
    url: '',
    credentials,
    headers: {},
    cookies: {}
  };
  if (signal) {
    req.signal = signal;
  }
  if (requestInterceptor) {
    req.requestInterceptor = requestInterceptor;
  }
  if (responseInterceptor) {
    req.responseInterceptor = responseInterceptor;
  }
  if (userFetch) {
    req.userFetch = userFetch;
  }
  const operationRaw = (0,_helpers_index_js__WEBPACK_IMPORTED_MODULE_13__["default"])(spec, operationId);
  if (!operationRaw) {
    throw new OperationNotFoundError(`Operation ${operationId} not found`);
  }
  const {
    operation = {},
    method,
    pathName
  } = operationRaw;
  baseURL = baseURL ?? baseUrl({
    spec,
    scheme,
    contextUrl,
    server,
    serverVariables,
    pathName,
    method,
    serverVariableEncoder
  });
  req.url += baseURL;

  // Mostly for testing
  if (!operationId) {
    // Not removing req.cookies causes testing issues and would
    // change our interface, so we're always sure to remove it.
    // See the same statement lower down in this function for
    // more context.
    delete req.cookies;
    return req;
  }
  req.url += pathName; // Have not yet replaced the path parameters
  req.method = `${method}`.toUpperCase();
  parameters = parameters || {};
  const path = spec.paths[pathName] || {};
  if (responseContentType) {
    req.headers.accept = responseContentType;
  }
  const combinedParameters = deduplicateParameters([].concat(arrayOrEmpty(operation.parameters)) // operation parameters
  .concat(arrayOrEmpty(path.parameters))); // path parameters

  // REVIEW: OAS3: have any key names or parameter shapes changed?
  // Any new features that need to be plugged in here?

  // Add values to request
  combinedParameters.forEach(parameter => {
    const builder = parameterBuilders[parameter.in];
    let value;
    if (parameter.in === 'body' && parameter.schema && parameter.schema.properties) {
      value = parameters;
    }
    value = parameter && parameter.name && parameters[parameter.name];
    if (typeof value === 'undefined') {
      // check for `name-in` formatted key
      value = parameter && parameter.name && parameters[`${parameter.in}.${parameter.name}`];
    } else if (findParametersWithName(parameter.name, combinedParameters).length > 1) {
      // value came from `parameters[parameter.name]`
      // check to see if this is an ambiguous parameter
      // eslint-disable-next-line no-console
      console.warn(`Parameter '${parameter.name}' is ambiguous because the defined spec has more than one parameter with the name: '${parameter.name}' and the passed-in parameter values did not define an 'in' value.`);
    }
    if (value === null) {
      return;
    }
    if (typeof parameter.default !== 'undefined' && typeof value === 'undefined') {
      value = parameter.default;
    }
    if (typeof value === 'undefined' && parameter.required && !parameter.allowEmptyValue) {
      throw new Error(`Required parameter ${parameter.name} is not provided`);
    }
    if (specIsOAS3 && typeof value === 'string') {
      if ((0,ramda__WEBPACK_IMPORTED_MODULE_14__["default"])('type', parameter.schema) && typeof parameter.schema.type === 'string' && findObjectOrArraySchema(parameter.schema, {
        recurse: false
      })) {
        value = parseJsonObjectOrArray({
          value,
          silentFail: false
        });
      } else if ((0,ramda__WEBPACK_IMPORTED_MODULE_14__["default"])('type', parameter.schema) && Array.isArray(parameter.schema.type) && findObjectOrArraySchema(parameter.schema, {
        recurse: false
      })) {
        value = parseJsonObjectOrArray({
          value,
          silentFail: true
        });
      } else if (!(0,ramda__WEBPACK_IMPORTED_MODULE_14__["default"])('type', parameter.schema) && findObjectOrArraySchema(parameter.schema, {
        recurse: true
      })) {
        value = parseJsonObjectOrArray({
          value,
          silentFail: true
        });
      }
    }
    if (builder) {
      builder({
        req,
        parameter,
        value,
        operation,
        spec,
        baseURL
      });
    }
  });

  // Do version-specific tasks, then return those results.
  const versionSpecificOptions = {
    ...options,
    operation
  };
  if (specIsOAS3) {
    req = (0,_oas3_build_request_js__WEBPACK_IMPORTED_MODULE_6__["default"])(versionSpecificOptions, req);
  } else {
    // If not OAS3, then treat as Swagger2.
    req = (0,_swagger2_build_request_js__WEBPACK_IMPORTED_MODULE_7__["default"])(versionSpecificOptions, req);
  }

  // If the cookie convenience object exists in our request,
  // serialize its content and then delete the cookie object.
  if (req.cookies && Object.keys(req.cookies).length > 0) {
    const cookieString = (0,_helpers_cookie_js__WEBPACK_IMPORTED_MODULE_8__.serialize)(req.cookies);
    if ((0,ramda_adjunct__WEBPACK_IMPORTED_MODULE_15__["default"])(req.headers.Cookie)) {
      req.headers.Cookie += `; ${cookieString}`;
    } else {
      req.headers.Cookie = cookieString;
    }
  }
  if (req.cookies) {
    // even if no cookies were defined, we need to remove
    // the cookies key from our request, or many legacy
    // tests will break.
    delete req.cookies;
  }

  // Will add the query object into the URL, if it exists
  // ... will also create a FormData instance, if multipart/form-data (eg: a file)
  return (0,_http_serializers_request_index_js__WEBPACK_IMPORTED_MODULE_3__.serializeRequest)(req);
}
const stripNonAlpha = str => str ? str.replace(/\W/g, '') : null;

// be careful when modifying this! it is a publicly-exposed method.
function baseUrl(obj) {
  const specIsOAS3 = (0,_helpers_openapi_predicates_js__WEBPACK_IMPORTED_MODULE_12__.isOpenAPI3)(obj.spec);
  return specIsOAS3 ? oas3BaseUrl(obj) : swagger2BaseUrl(obj);
}
const isNonEmptyServerList = value => Array.isArray(value) && value.length > 0;
function oas3BaseUrl({
  spec,
  pathName,
  method,
  server,
  contextUrl,
  serverVariables = {},
  serverVariableEncoder
}) {
  let servers = [];
  let selectedServerUrl = '';
  let selectedServerObj;

  // compute the servers (this will be taken care of by ApiDOM refrator plugins in future
  const operationLevelServers = spec?.paths?.[pathName]?.[(method || '').toLowerCase()]?.servers;
  const pathItemLevelServers = spec?.paths?.[pathName]?.servers;
  const rootLevelServers = spec?.servers;
  servers = isNonEmptyServerList(operationLevelServers) // eslint-disable-line no-nested-ternary
  ? operationLevelServers : isNonEmptyServerList(pathItemLevelServers) // eslint-disable-line no-nested-ternary
  ? pathItemLevelServers : isNonEmptyServerList(rootLevelServers) ? rootLevelServers : [_constants_js__WEBPACK_IMPORTED_MODULE_1__.DEFAULT_OPENAPI_3_SERVER];

  // pick the first server that matches the server url
  if (server) {
    selectedServerObj = servers.find(srv => srv.url === server);
    if (selectedServerObj) selectedServerUrl = server;
  }

  // default to the first server if we don't have one by now
  if (!selectedServerUrl) {
    [selectedServerObj] = servers;
    selectedServerUrl = selectedServerObj.url;
  }
  if ((0,openapi_server_url_templating__WEBPACK_IMPORTED_MODULE_0__.test)(selectedServerUrl, {
    strict: true
  })) {
    const selectedServerVariables = Object.entries({
      ...selectedServerObj.variables
    }).reduce((acc, [serverVariableName, serverVariable]) => {
      acc[serverVariableName] = serverVariable.default;
      return acc;
    }, {});
    selectedServerUrl = (0,openapi_server_url_templating__WEBPACK_IMPORTED_MODULE_0__.substitute)(selectedServerUrl, {
      ...selectedServerVariables,
      ...serverVariables
    }, {
      encoder: typeof serverVariableEncoder === 'function' ? serverVariableEncoder : ramda__WEBPACK_IMPORTED_MODULE_16__["default"]
    });
  }
  return buildOas3UrlWithContext(selectedServerUrl, contextUrl);
}
function buildOas3UrlWithContext(ourUrl = '', contextUrl = '') {
  // relative server url should be resolved against contextUrl
  const parsedUrl = ourUrl && contextUrl ? parseURIReference(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_17__.resolve(contextUrl, ourUrl)) : parseURIReference(ourUrl);
  const parsedContextUrl = parseURIReference(contextUrl);
  const computedScheme = stripNonAlpha(parsedUrl.protocol) || stripNonAlpha(parsedContextUrl.protocol);
  const computedHost = parsedUrl.host || parsedContextUrl.host;
  const computedPath = parsedUrl.pathname;
  let res;
  if (computedScheme && computedHost) {
    res = `${computedScheme}://${computedHost + computedPath}`;

    // if last character is '/', trim it off
  } else {
    res = computedPath;
  }
  return res[res.length - 1] === '/' ? res.slice(0, -1) : res;
}

// Compose the baseUrl ( scheme + host + basePath )
function swagger2BaseUrl({
  spec,
  scheme,
  contextUrl = ''
}) {
  const parsedContextUrl = parseURIReference(contextUrl);
  const firstSchemeInSpec = Array.isArray(spec.schemes) ? spec.schemes[0] : null;
  const computedScheme = scheme || firstSchemeInSpec || stripNonAlpha(parsedContextUrl.protocol) || 'http';
  const computedHost = spec.host || parsedContextUrl.host || '';
  const computedPath = spec.basePath || '';
  let res;
  if (computedScheme && computedHost) {
    // we have what we need for an absolute URL
    res = `${computedScheme}://${computedHost + computedPath}`;
  } else {
    // if not, a relative URL will have to do
    res = computedPath;
  }

  // If last character is '/', trim it off
  return res[res.length - 1] === '/' ? res.slice(0, -1) : res;
}

/***/ }),

/***/ 32804:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var getNative = __webpack_require__(56110),
    root = __webpack_require__(9325);

/* Built-in method references that are verified to be native. */
var Promise = getNative(root, 'Promise');

module.exports = Promise;


/***/ }),

/***/ 32910:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var apg_lite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(16646);
/* harmony import */ var _grammar_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(96552);
/* harmony import */ var _callbacks_cookie_string_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99511);
/* harmony import */ var _callbacks_cookie_pair_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(36168);
/* harmony import */ var _callbacks_cookie_name_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(34389);
/* harmony import */ var _callbacks_cookie_value_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(80935);






const grammar = new _grammar_mjs__WEBPACK_IMPORTED_MODULE_5__["default"]();
const parse = (cookieString, {
  strict = true
} = {}) => {
  const parser = new apg_lite__WEBPACK_IMPORTED_MODULE_0__.Parser();
  parser.ast = new apg_lite__WEBPACK_IMPORTED_MODULE_0__.Ast();
  if (strict) {
    parser.ast.callbacks['cookie-string'] = _callbacks_cookie_string_mjs__WEBPACK_IMPORTED_MODULE_1__["default"];
    parser.ast.callbacks['cookie-pair'] = _callbacks_cookie_pair_mjs__WEBPACK_IMPORTED_MODULE_2__["default"];
    parser.ast.callbacks['cookie-name'] = _callbacks_cookie_name_mjs__WEBPACK_IMPORTED_MODULE_3__["default"];
    parser.ast.callbacks['cookie-value'] = _callbacks_cookie_value_mjs__WEBPACK_IMPORTED_MODULE_4__["default"];
  } else {
    parser.ast.callbacks['lenient-cookie-string'] = _callbacks_cookie_string_mjs__WEBPACK_IMPORTED_MODULE_1__["default"];
    parser.ast.callbacks['lenient-cookie-pair'] = _callbacks_cookie_pair_mjs__WEBPACK_IMPORTED_MODULE_2__["default"];
    parser.ast.callbacks['lenient-cookie-name'] = _callbacks_cookie_name_mjs__WEBPACK_IMPORTED_MODULE_3__["default"];
    parser.ast.callbacks['lenient-cookie-value'] = _callbacks_cookie_value_mjs__WEBPACK_IMPORTED_MODULE_4__["default"];
  }
  const startRule = strict ? 'cookie-string' : 'lenient-cookie-string';
  const result = parser.parse(grammar, startRule, cookieString);
  return {
    result,
    ast: parser.ast
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (parse);

/***/ }),

/***/ 33107:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(95532);
/* harmony import */ var _NormalizeStorage_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68429);


/**
 * Override of Schema.example and Schema.examples field inside the Header Objects.
 *
 * Header Object has two fixed fields:
 *  - `example` of type `Any`
 *  - `examples` of type `Map[string, Example Object | Reference Object]`
 *
 * OpenAPI 3.1 specification excerpt that defines the override behavior:
 *
 * The example value SHALL override the example provided by the schema.
 * Furthermore, if referencing a schema that contains an example, the examples value SHALL override the example provided by the schema.
 *
 * NOTE: this plugin is idempotent
 * @public
 */
/**
 * @public
 */
const plugin = ({
  storageField = 'x-normalized'
} = {}) => toolbox => {
  const {
    predicates,
    ancestorLineageToJSONPointer
  } = toolbox;
  let storage;
  return {
    visitor: {
      OpenApi3_1Element: {
        enter(element) {
          storage = new _NormalizeStorage_mjs__WEBPACK_IMPORTED_MODULE_0__["default"](element, storageField, 'header-examples');
        },
        leave() {
          storage = undefined;
        }
      },
      HeaderElement: {
        leave(headerElement, key, parent, path, ancestors) {
          var _headerElement$schema, _headerElement$schema2;
          // skip visiting this Header Object
          if (ancestors.some(predicates.isComponentsElement)) {
            return;
          }

          // no Header.schema field present
          if (typeof headerElement.schema === 'undefined' || !predicates.isSchemaElement(headerElement.schema)) {
            return;
          }
          // Schema contains no example
          if (typeof ((_headerElement$schema = headerElement.schema) === null || _headerElement$schema === void 0 ? void 0 : _headerElement$schema.example) === 'undefined' && typeof ((_headerElement$schema2 = headerElement.schema) === null || _headerElement$schema2 === void 0 ? void 0 : _headerElement$schema2.examples) === 'undefined') {
            return;
          }
          const headerJSONPointer = ancestorLineageToJSONPointer([...ancestors, parent, headerElement]);

          // skip visiting this Header Object if it's already normalized
          if (storage.includes(headerJSONPointer)) {
            return;
          }

          /**
           * Header.examples and Schema.examples have preferences over the older
           * and deprected `example` field.
           */
          if (typeof headerElement.examples !== 'undefined' && predicates.isObjectElement(headerElement.examples)) {
            // @ts-ignore
            const examples = headerElement.examples.map(example => {
              return _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep.safe(example.value);
            });
            if (typeof headerElement.schema.examples !== 'undefined') {
              headerElement.schema.set('examples', examples);
              storage.append(headerJSONPointer);
            }
            if (typeof headerElement.schema.example !== 'undefined') {
              headerElement.schema.set('example', examples[0]);
              storage.append(headerJSONPointer);
            }
            return;
          }

          /**
           * Handle deprecated `example` field.
           */
          if (typeof headerElement.example !== 'undefined') {
            if (typeof headerElement.schema.examples !== 'undefined') {
              headerElement.schema.set('examples', [(0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(headerElement.example)]);
              storage.append(headerJSONPointer);
            }
            if (typeof headerElement.schema.example !== 'undefined') {
              headerElement.schema.set('example', (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_1__.cloneDeep)(headerElement.example));
              storage.append(headerJSONPointer);
            }
          }
        }
      }
    }
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (plugin);

/***/ }),

/***/ 33218:
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _internal_cloneRegExp_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(40557);
/* harmony import */ var _internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(92254);
/* harmony import */ var _internal_isRegExp_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(74200);
/* harmony import */ var _toString_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(22338);





/**
 * Determines whether a given string matches a given regular expression.
 *
 * @func
 * @memberOf R
 * @since v0.12.0
 * @category String
 * @sig RegExp -> String -> Boolean
 * @param {RegExp} pattern
 * @param {String} str
 * @return {Boolean}
 * @see R.match
 * @example
 *
 *      R.test(/^x/, 'xyz'); //=> true
 *      R.test(/^y/, 'xyz'); //=> false
 */
var test = /*#__PURE__*/(0,_internal_curry2_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function test(pattern, str) {
  if (!(0,_internal_isRegExp_js__WEBPACK_IMPORTED_MODULE_1__["default"])(pattern)) {
    throw new TypeError('‘test’ requires a value of type RegExp as its first argument; received ' + (0,_toString_js__WEBPACK_IMPORTED_MODULE_2__["default"])(pattern));
  }
  return (0,_internal_cloneRegExp_js__WEBPACK_IMPORTED_MODULE_3__["default"])(pattern).test(str);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (test);

/***/ }),

/***/ 33272:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   circularReplacer: () => (/* binding */ circularReplacer),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(77259);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(1908);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(95532);
/* harmony import */ var _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(43290);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(48310);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(61906);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(87319);
/* harmony import */ var _swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(77218);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(51295);
/* harmony import */ var _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(14615);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(96664);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(83561);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(56479);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(9170);
/* harmony import */ var _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(91613);
/* harmony import */ var _swagger_api_apidom_reference_parse_parsers_binary__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(69052);
/* harmony import */ var _swagger_api_apidom_reference_resolve_strategies_openapi_3_1__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(9816);
/* harmony import */ var _constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(3832);
/* harmony import */ var _utils_options_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40428);
/* harmony import */ var _apidom_reference_resolve_resolvers_http_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(636);
/* harmony import */ var _apidom_reference_parse_parsers_json_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(92263);
/* harmony import */ var _apidom_reference_parse_parsers_yaml_1_2_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12787);
/* harmony import */ var _apidom_reference_parse_parsers_openapi_json_3_1_index_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(89742);
/* harmony import */ var _apidom_reference_parse_parsers_openapi_yaml_3_1_index_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(49575);
/* harmony import */ var _apidom_reference_dereference_strategies_openapi_3_1_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(13764);
/* eslint-disable camelcase */














const circularReplacer = refElement => {
  const $refBaseURI = (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_8__["default"])(refElement.meta.get('baseURI'));
  const referencingElement = refElement.meta.get('referencingElement');

  /**
   * Removing semantics from the absolutified referencing element by
   * using generic ObjectElement to represent the reference.
   */
  return new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.ObjectElement({
    $ref: $refBaseURI
  }, (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__.cloneDeep)(referencingElement.meta), (0,_swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_10__.cloneDeep)(referencingElement.attributes));
};
const resolveOpenAPI31Strategy = async options => {
  const {
    spec,
    timeout,
    redirects,
    requestInterceptor,
    responseInterceptor,
    pathDiscriminator = [],
    allowMetaPatches = false,
    useCircularStructures = false,
    skipNormalization = false,
    parameterMacro = null,
    modelPropertyMacro = null,
    mode = 'non-strict',
    strategies
  } = options;
  try {
    const {
      cache
    } = resolveOpenAPI31Strategy;
    const strategy = strategies.find(strg => strg.match(spec));

    // determining BaseURI
    const cwd = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__.isHttpUrl(_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__.cwd()) ? _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__.cwd() : _constants_js__WEBPACK_IMPORTED_MODULE_0__.DEFAULT_BASE_URL;
    const retrievalURI = _utils_options_js__WEBPACK_IMPORTED_MODULE_1__.retrievalURI(options);
    const baseURI = _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_11__.resolve(cwd, retrievalURI);

    // prepare spec for dereferencing
    let openApiElement;
    if (cache.has(spec)) {
      openApiElement = cache.get(spec);
    } else {
      openApiElement = _swagger_api_apidom_ns_openapi_3_1__WEBPACK_IMPORTED_MODULE_12__.OpenApi3_1Element.refract(spec);
      openApiElement.classes.push('result');
      cache.set(spec, openApiElement);
    }
    const openApiParseResultElement = new _swagger_api_apidom_core__WEBPACK_IMPORTED_MODULE_9__.ParseResultElement([openApiElement]);

    // prepare fragment for dereferencing
    const jsonPointer = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_13__["default"])(pathDiscriminator);
    const jsonPointerURI = jsonPointer === '' ? '' : `#${jsonPointer}`;
    const fragmentElement = (0,_swagger_api_apidom_json_pointer__WEBPACK_IMPORTED_MODULE_14__["default"])(jsonPointer, openApiElement);

    // prepare reference set for dereferencing
    const openApiElementReference = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_15__["default"]({
      uri: baseURI,
      value: openApiParseResultElement
    });
    const refSet = new _swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_16__["default"]({
      refs: [openApiElementReference]
    });
    if (jsonPointer !== '') refSet.rootRef = undefined; // reset root reference as we want fragment to become the root reference

    // prepare ancestors; needed for cases where fragment is not OpenAPI element
    const ancestors = [new Set([fragmentElement])];
    const errors = [];
    const dereferenced = await (0,_swagger_api_apidom_reference_configuration_empty__WEBPACK_IMPORTED_MODULE_17__.dereferenceApiDOM)(fragmentElement, {
      resolve: {
        /**
         * swagger-client only supports resolving HTTP(S) URLs or spec objects.
         * If runtime env is detected as non-browser one,
         * and baseURI was not provided as part of resolver options,
         * then below baseURI check will make sure that constant HTTPS URL is used as baseURI.
         */
        baseURI: `${baseURI}${jsonPointerURI}`,
        resolvers: [new _apidom_reference_resolve_resolvers_http_swagger_client_index_js__WEBPACK_IMPORTED_MODULE_2__["default"]({
          timeout: timeout || 10000,
          redirects: redirects || 10
        })],
        resolverOpts: {
          swaggerHTTPClientConfi