"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
var _interopRequireWildcard = require("@babel/runtime-corejs3/helpers/interopRequireWildcard").default;
exports.__esModule = true;
exports.cookie = cookie;
exports.header = header;
exports.path = path;
exports.query = query;
var _openapiPathTemplating = require("openapi-path-templating");
var _styleSerializer = _interopRequireWildcard(require("./style-serializer.js"));
var _contentSerializer = _interopRequireDefault(require("./content-serializer.js"));
var _cookie = require("../../helpers/cookie.js");
function path({
  req,
  value,
  parameter,
  baseURL
}) {
  const {
    name,
    style,
    explode,
    content
  } = parameter;
  if (value === undefined) return;
  const pathname = req.url.replace(baseURL, '');
  let resolvedPathname;
  if (content) {
    const effectiveMediaType = Object.keys(content)[0];
    resolvedPathname = (0, _openapiPathTemplating.resolve)(pathname, {
      [name]: value
    }, {
      encoder: val => (0, _styleSerializer.encodeCharacters)((0, _contentSerializer.default)(val, effectiveMediaType))
    });
  } else {
    resolvedPathname = (0, _openapiPathTemplating.resolve)(pathname, {
      [name]: value
    }, {
      encoder: val => (0, _styleSerializer.default)({
        key: parameter.name,
        value: val,
        style: style || 'simple',
        explode: explode != null ? explode : false,
        escape: 'reserved'
      })
    });
  }
  req.url = baseURL + resolvedPathname;
}
function query({
  req,
  value,
  parameter
}) {
  req.query = req.query || {};
  if (value !== undefined && parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    const serializedValue = (0, _contentSerializer.default)(value, effectiveMediaType);
    if (serializedValue) {
      req.query[parameter.name] = serializedValue;
    } else if (parameter.allowEmptyValue) {
      const paramName = parameter.name;
      req.query[paramName] = req.query[paramName] || {};
      req.query[paramName].allowEmptyValue = true;
    }
    return;
  }
  if (value === false) {
    value = 'false';
  }
  if (value === 0) {
    value = '0';
  }
  if (value) {
    const {
      style,
      explode,
      allowReserved
    } = parameter;
    req.query[parameter.name] = {
      value,
      serializationOption: {
        style,
        explode,
        allowReserved
      }
    };
  } else if (parameter.allowEmptyValue && value !== undefined) {
    const paramName = parameter.name;
    req.query[paramName] = req.query[paramName] || {};
    req.query[paramName].allowEmptyValue = true;
  }
}
const PARAMETER_HEADER_BLACKLIST = ['accept', 'authorization', 'content-type'];
function header({
  req,
  parameter,
  value
}) {
  req.headers = req.headers || {};
  if (PARAMETER_HEADER_BLACKLIST.indexOf(parameter.name.toLowerCase()) > -1) {
    return;
  }
  if (value !== undefined && parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    req.headers[parameter.name] = (0, _contentSerializer.default)(value, effectiveMediaType);
    return;
  }
  if (value !== undefined && !(Array.isArray(value) && value.length === 0)) {
    req.headers[parameter.name] = (0, _styleSerializer.default)({
      key: parameter.name,
      value,
      style: parameter.style || 'simple',
      explode: typeof parameter.explode === 'undefined' ? false : parameter.explode,
      escape: false
    });
  }
}
function cookie({
  req,
  parameter,
  value
}) {
  const {
    name: cookieName
  } = parameter;
  req.headers = req.headers || {};
  if (value !== undefined && parameter.content) {
    const effectiveMediaType = Object.keys(parameter.content)[0];
    const cookieValue = (0, _contentSerializer.default)(value, effectiveMediaType);
    req.headers.Cookie = (0, _cookie.serialize)({
      [cookieName]: cookieValue
    });
    return;
  }
  if (value !== undefined && !(Array.isArray(value) && value.length === 0)) {
    var _parameter$explode;
    const serializedValue = (0, _styleSerializer.default)({
      key: parameter.name,
      value,
      escape: false,
      style: parameter.style || 'form',
      explode: (_parameter$explode = parameter.explode) != null ? _parameter$explode : false
    });
    const cookieValue = Array.isArray(value) && parameter.explode ? `${cookieName}=${serializedValue}` : serializedValue;
    req.headers.Cookie = (0, _cookie.serialize)({
      [cookieName]: cookieValue
    });
  }
}