import * as fs from 'fs';
import { DefaultConfig, SwaggerThemeName, VersionSwagger } from './types';

export class SwaggerTheme {
  constructor(readonly version: VersionSwagger) {}

  getBuffer(name: SwaggerThemeName) {
    if (!this.version || !name) return '';

    return fs.readFileSync(
      __dirname + `/../themes/${this.version}/${name}.css`,
      'utf8'
    );
  }

  getDefaultConfig(theme: SwaggerThemeName): DefaultConfig {
    const buffer: string = this.getBuffer(theme);

    return {
      explorer: true,
      customCss: buffer
    }
  }
}