"use strict";

exports.__esModule = true;
exports.default = void 0;
var _apgLite = require("../../apg-lite.cjs");
var _grammar = _interopRequireDefault(require("../../grammar.cjs"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const parser = new _apgLite.Parser();
const grammar = new _grammar.default();
const testCookieValue = (cookieValue, {
  strict = true
} = {}) => {
  try {
    const startRule = strict ? 'cookie-value' : 'lenient-cookie-value';
    return parser.parse(grammar, startRule, cookieValue).success;
  } catch {
    return false;
  }
};
var _default = exports.default = testCookieValue;