"use strict";

exports.__esModule = true;
exports.default = void 0;
var _apgLite = require("../../../apg-lite.cjs");
var _grammar = _interopRequireDefault(require("../../../grammar.cjs"));
var _utils = require("../../../utils.cjs");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const parser = new _apgLite.Parser();
const grammar = new _grammar.default();
const cookieValueStrictEncoder = cookieValue => {
  const value = String(cookieValue);

  // detect if the value is quoted
  const isQuoted = value.length >= 2 && value.startsWith('"') && value.endsWith('"');

  // remove quotes if present for processing
  const valueToEncode = isQuoted ? value.slice(1, -1) : value;
  let result = '';
  for (const char of valueToEncode) {
    result += parser.parse(grammar, 'cookie-octet', char).success ? char : (0, _utils.percentEncodeChar)(char);
  }

  // return quoted if input was quoted, unquoted otherwise
  return isQuoted ? `"${result}"` : result;
};
var _default = exports.default = cookieValueStrictEncoder;