"use strict";

exports.__esModule = true;
exports.default = grammar;
// copyright: Copyright (c) 2024 Lowell D. Thomas, all rights reserved<br>
//   license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)<br>
//
// Generated by apg-js, Version 4.4.0 [apg-js](https://github.com/ldthomas/apg-js)
function grammar() {
  // ```
  // SUMMARY
  //      rules = 8
  //       udts = 0
  //    opcodes = 28
  //        ---   ABNF original opcodes
  //        ALT = 5
  //        CAT = 3
  //        REP = 3
  //        RNM = 6
  //        TLS = 5
  //        TBS = 1
  //        TRG = 5
  //        ---   SABNF superset opcodes
  //        UDT = 0
  //        AND = 0
  //        NOT = 0
  // characters = [0 - 1114111]
  // ```
  /* OBJECT IDENTIFIER (for internal parser use) */
  this.grammarObject = 'grammarObject';

  /* RULES */
  this.rules = [];
  this.rules[0] = {
    name: 'json-pointer',
    lower: 'json-pointer',
    index: 0,
    isBkr: false
  };
  this.rules[1] = {
    name: 'reference-token',
    lower: 'reference-token',
    index: 1,
    isBkr: false
  };
  this.rules[2] = {
    name: 'unescaped',
    lower: 'unescaped',
    index: 2,
    isBkr: false
  };
  this.rules[3] = {
    name: 'escaped',
    lower: 'escaped',
    index: 3,
    isBkr: false
  };
  this.rules[4] = {
    name: 'array-location',
    lower: 'array-location',
    index: 4,
    isBkr: false
  };
  this.rules[5] = {
    name: 'array-index',
    lower: 'array-index',
    index: 5,
    isBkr: false
  };
  this.rules[6] = {
    name: 'array-dash',
    lower: 'array-dash',
    index: 6,
    isBkr: false
  };
  this.rules[7] = {
    name: 'slash',
    lower: 'slash',
    index: 7,
    isBkr: false
  };

  /* UDTS */
  this.udts = [];

  /* OPCODES */
  /* json-pointer */
  this.rules[0].opcodes = [];
  this.rules[0].opcodes[0] = {
    type: 3,
    min: 0,
    max: Infinity
  }; // REP
  this.rules[0].opcodes[1] = {
    type: 2,
    children: [2, 3]
  }; // CAT
  this.rules[0].opcodes[2] = {
    type: 4,
    index: 7
  }; // RNM(slash)
  this.rules[0].opcodes[3] = {
    type: 4,
    index: 1
  }; // RNM(reference-token)

  /* reference-token */
  this.rules[1].opcodes = [];
  this.rules[1].opcodes[0] = {
    type: 3,
    min: 0,
    max: Infinity
  }; // REP
  this.rules[1].opcodes[1] = {
    type: 1,
    children: [2, 3]
  }; // ALT
  this.rules[1].opcodes[2] = {
    type: 4,
    index: 2
  }; // RNM(unescaped)
  this.rules[1].opcodes[3] = {
    type: 4,
    index: 3
  }; // RNM(escaped)

  /* unescaped */
  this.rules[2].opcodes = [];
  this.rules[2].opcodes[0] = {
    type: 1,
    children: [1, 2, 3]
  }; // ALT
  this.rules[2].opcodes[1] = {
    type: 5,
    min: 0,
    max: 46
  }; // TRG
  this.rules[2].opcodes[2] = {
    type: 5,
    min: 48,
    max: 125
  }; // TRG
  this.rules[2].opcodes[3] = {
    type: 5,
    min: 127,
    max: 1114111
  }; // TRG

  /* escaped */
  this.rules[3].opcodes = [];
  this.rules[3].opcodes[0] = {
    type: 2,
    children: [1, 2]
  }; // CAT
  this.rules[3].opcodes[1] = {
    type: 7,
    string: [126]
  }; // TLS
  this.rules[3].opcodes[2] = {
    type: 1,
    children: [3, 4]
  }; // ALT
  this.rules[3].opcodes[3] = {
    type: 7,
    string: [48]
  }; // TLS
  this.rules[3].opcodes[4] = {
    type: 7,
    string: [49]
  }; // TLS

  /* array-location */
  this.rules[4].opcodes = [];
  this.rules[4].opcodes[0] = {
    type: 1,
    children: [1, 2]
  }; // ALT
  this.rules[4].opcodes[1] = {
    type: 4,
    index: 5
  }; // RNM(array-index)
  this.rules[4].opcodes[2] = {
    type: 4,
    index: 6
  }; // RNM(array-dash)

  /* array-index */
  this.rules[5].opcodes = [];
  this.rules[5].opcodes[0] = {
    type: 1,
    children: [1, 2]
  }; // ALT
  this.rules[5].opcodes[1] = {
    type: 6,
    string: [48]
  }; // TBS
  this.rules[5].opcodes[2] = {
    type: 2,
    children: [3, 4]
  }; // CAT
  this.rules[5].opcodes[3] = {
    type: 5,
    min: 49,
    max: 57
  }; // TRG
  this.rules[5].opcodes[4] = {
    type: 3,
    min: 0,
    max: Infinity
  }; // REP
  this.rules[5].opcodes[5] = {
    type: 5,
    min: 48,
    max: 57
  }; // TRG

  /* array-dash */
  this.rules[6].opcodes = [];
  this.rules[6].opcodes[0] = {
    type: 7,
    string: [45]
  }; // TLS

  /* slash */
  this.rules[7].opcodes = [];
  this.rules[7].opcodes[0] = {
    type: 7,
    string: [47]
  }; // TLS

  // The `toString()` function will display the original grammar file(s) that produced these opcodes.
  this.toString = function toString() {
    let str = "";
    str += "; JavaScript Object Notation (JSON) Pointer ABNF syntax\n";
    str += "; https://datatracker.ietf.org/doc/html/rfc6901\n";
    str += "json-pointer    = *( slash reference-token ) ; MODIFICATION: surrogate text rule used\n";
    str += "reference-token = *( unescaped / escaped )\n";
    str += "unescaped       = %x00-2E / %x30-7D / %x7F-10FFFF\n";
    str += "                ; %x2F ('/') and %x7E ('~') are excluded from 'unescaped'\n";
    str += "escaped         = \"~\" ( \"0\" / \"1\" )\n";
    str += "                ; representing '~' and '/', respectively\n";
    str += "\n";
    str += "; https://datatracker.ietf.org/doc/html/rfc6901#section-4\n";
    str += "array-location  = array-index / array-dash\n";
    str += "array-index     = %x30 / ( %x31-39 *(%x30-39) )\n";
    str += "                ; \"0\", or digits without a leading \"0\"\n";
    str += "array-dash      = \"-\"\n";
    str += "\n";
    str += "; Surrogate named rules\n";
    str += "slash           = \"/\"\n";
    return str;
  };
}