'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _react = require('react');

var _sweetalert = require('sweetalert');

var _sweetalert2 = _interopRequireDefault(_sweetalert);

var _lodashPick = require('lodash.pick');

var _lodashPick2 = _interopRequireDefault(_lodashPick);

var _mousetrap = require('mousetrap');

var _mousetrap2 = _interopRequireDefault(_mousetrap);

var _warning = require('warning');

var _warning2 = _interopRequireDefault(_warning);

var _utilsOutsideTargetHandlerFactory = require('./utils/outsideTargetHandlerFactory');

var _utilsOutsideTargetHandlerFactory2 = _interopRequireDefault(_utilsOutsideTargetHandlerFactory);

var ALLOWS_KEYS = ['title', 'text', 'type', 'customClass', 'showCancelButton', 'showConfirmButton', 'confirmButtonText', 'confirmButtonColor', 'cancelButtonText', 'imageUrl', 'imageSize', 'html', 'animation', 'inputType', 'inputPlaceholder', 'showLoaderOnConfirm'];

var REMOVED_KEYS = ['timer', 'closeOnConfirm', 'closeOnCancel', 'allowOutsideClick', 'allowEscapeKey'];

var OVERWRITE_PROPS = {
  closeOnConfirm: false,
  closeOnCancel: false,
  allowOutsideClick: false,
  allowEscapeKey: false
};

// reference: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input
var ALLOWS_INPUT_TYPES = ['button', 'checkbox', 'color', 'date', 'datetime', 'datetime-local', 'email', 'file', 'hidden', 'image', 'month', 'number', 'password', 'radio', 'range', 'reset', 'search', 'submit', 'tel', 'text', 'time', 'url', 'week'];

var SweetAlert = (function (_Component) {
  _inherits(SweetAlert, _Component);

  _createClass(SweetAlert, null, [{
    key: 'propTypes',
    value: {
      // sweetalert option
      title: _react.PropTypes.string.isRequired,
      text: _react.PropTypes.string,
      type: _react.PropTypes.oneOf(['warning', 'error', 'success', 'info', 'input']),
      customClass: _react.PropTypes.string,
      showCancelButton: _react.PropTypes.bool,
      showConfirmButton: _react.PropTypes.bool,
      confirmButtonText: _react.PropTypes.string,
      confirmButtonColor: _react.PropTypes.string,
      cancelButtonText: _react.PropTypes.string,
      imageUrl: _react.PropTypes.string,
      imageSize: function imageSize(props, propName) {
        if (!/^[1-9]\d*x[1-9]\d*/.test(props[propName])) {
          return new Error('imageSize should have the format like this: "80x80"');
        }
      },
      html: _react.PropTypes.bool,
      animation: _react.PropTypes.bool,
      inputType: _react.PropTypes.oneOf(ALLOWS_INPUT_TYPES),
      inputPlaceholder: _react.PropTypes.string,
      inputValue: _react.PropTypes.string,
      showLoaderOnConfirm: _react.PropTypes.bool,

      // custom option
      show: _react.PropTypes.bool,
      onConfirm: _react.PropTypes.func,
      onCancel: _react.PropTypes.func,
      onClose: _react.PropTypes.func,
      onEscapeKey: _react.PropTypes.func,
      onOutsideClick: _react.PropTypes.func
    },
    enumerable: true
  }, {
    key: 'defaultProps',
    value: {
      // sweetalert option
      title: null,
      text: null,
      type: null,
      customClass: null,
      showCancelButton: false,
      showConfirmButton: true,
      confirmButtonText: 'OK',
      confirmButtonColor: '#AEDEF4',
      cancelButtonText: 'Cancel',
      imageUrl: null,
      imageSize: '80x80',
      html: false,
      animation: true,
      inputType: 'text',
      inputPlaceholder: null,
      inputValue: null,
      showLoaderOnConfirm: false,

      // custom option
      show: false
    },
    enumerable: true
  }]);

  function SweetAlert(props, context) {
    _classCallCheck(this, SweetAlert);

    _Component.call(this, props, context);
    this._show = false;
  }

  SweetAlert.prototype.componentDidMount = function componentDidMount() {
    this.setupWithProps(this.props);

    if (this.props.onOutsideClick) {
      this.registerOutsideClickHandler(this.props.onOutsideClick);
    }
  };

  SweetAlert.prototype.componentWillReceiveProps = function componentWillReceiveProps(props) {
    this.setupWithProps(props);

    var oldOutsideClickHandler = this.props.onOutsideClick;
    var newOutsideClickHandler = props.onOutsideClick;

    if (oldOutsideClickHandler !== newOutsideClickHandler) {
      if (oldOutsideClickHandler && newOutsideClickHandler) {
        this.unregisterOutsideClickHandler();
        this.registerOutsideClickHandler(newOutsideClickHandler);
      } else if (oldOutsideClickHandler && !newOutsideClickHandler) {
        this.unregisterOutsideClickHandler();
      } else if (!oldOutsideClickHandler && newOutsideClickHandler) {
        this.registerOutsideClickHandler(newOutsideClickHandler);
      }
    }
  };

  SweetAlert.prototype.componentWillUnmount = function componentWillUnmount() {
    this.disableOutsideClick();
    this._outsideClickHandler = false;
  };

  SweetAlert.prototype.setupWithProps = function setupWithProps(props) {
    var _this = this;

    this.warningRemoved(props);
    var show = props.show;
    var onConfirm = props.onConfirm;
    var onCancel = props.onCancel;
    var onClose = props.onClose;
    var onEscapeKey = props.onEscapeKey;

    if (show) {
      _sweetalert2['default'](_extends({}, _lodashPick2['default'](props, ALLOWS_KEYS), OVERWRITE_PROPS), function (isConfirm) {
        return _this.handleClick(isConfirm, onConfirm, onCancel);
      });
      this._show = true;
      this.bindEscapeKey(onEscapeKey);
    } else {
      this.handleClose(onClose, onEscapeKey);
    }
  };

  SweetAlert.prototype.warningRemoved = function warningRemoved(props) {
    REMOVED_KEYS.forEach(function (key) {
      _warning2['default'](props[key] === undefined, '%s has been removed from sweetalert-react, pass `show` props and use event hook instead.', '`' + key + '`');
    });
  };

  SweetAlert.prototype.registerOutsideClickHandler = function registerOutsideClickHandler(handler) {
    this._outsideClickHandler = _utilsOutsideTargetHandlerFactory2['default'](document.getElementsByClassName('sweet-alert')[0], handler);
    this.enableOutsideClick();
  };

  SweetAlert.prototype.unregisterOutsideClickHandler = function unregisterOutsideClickHandler() {
    this.disableOutsideClick();
    this._outsideClickHandler = null;
  };

  SweetAlert.prototype.enableOutsideClick = function enableOutsideClick() {
    var fn = this._outsideClickHandler;
    document.addEventListener('mousedown', fn);
    document.addEventListener('touchstart', fn);
  };

  SweetAlert.prototype.disableOutsideClick = function disableOutsideClick() {
    var fn = this._outsideClickHandler;
    document.removeEventListener('mousedown', fn);
    document.removeEventListener('touchstart', fn);
  };

  SweetAlert.prototype.bindEscapeKey = function bindEscapeKey(onEscapeKey) {
    onEscapeKey && _mousetrap2['default'].bind('esc', onEscapeKey);
  };

  SweetAlert.prototype.unbindEscapeKey = function unbindEscapeKey(onEscapeKey) {
    onEscapeKey && _mousetrap2['default'].unbind('esc', onEscapeKey);
  };

  SweetAlert.prototype.handleClick = function handleClick(isConfirm, onConfirm, onCancel) {
    if (isConfirm) {
      onConfirm && onConfirm(isConfirm);
    } else {
      onCancel && onCancel();
    }
  };

  SweetAlert.prototype.handleClose = function handleClose(onClose, onEscapeKey) {
    if (this._show) {
      _sweetalert2['default'].close();
      this.unbindEscapeKey(onEscapeKey);
      onClose && onClose();
      this._show = false;
    }
  };

  SweetAlert.prototype.render = function render() {
    return null;
  };

  return SweetAlert;
})(_react.Component);

exports['default'] = SweetAlert;
module.exports = exports['default'];