'use strict';

exports.__esModule = true;
exports['default'] = outsideTargetHandlerFactory;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _isDOMEquals = require('./isDOMEquals');

var _isDOMEquals2 = _interopRequireDefault(_isDOMEquals);

function outsideTargetHandlerFactory(targetNode, eventHandler) {
  return function (evt) {
    evt.stopPropagation();
    var current = evt.target;
    var found = false;
    while (current.parentNode) {
      found = _isDOMEquals2['default'](current, targetNode);
      if (found) return;
      current = current.parentNode;
    }
    eventHandler(evt);
  };
}

module.exports = exports['default'];