import { EventEmitter, TemplateRef } from '@angular/core';
import { ViewDimensions } from '../common/view-dimensions.helper';
import { ColorHelper } from '../common/color.helper';
import { BaseChartComponent } from '../common/base-chart.component';
export declare class PolarChartComponent extends BaseChartComponent {
    legend: boolean;
    legendTitle: string;
    xAxis: boolean;
    yAxis: boolean;
    showXAxisLabel: boolean;
    showYAxisLabel: boolean;
    xAxisLabel: string;
    yAxisLabel: string;
    autoScale: boolean;
    showGridLines: boolean;
    curve: any;
    activeEntries: any[];
    schemeType: string;
    rangeFillOpacity: number;
    xAxisTickFormatting: (o: any) => any;
    yAxisTickFormatting: (o: any) => any;
    roundDomains: boolean;
    tooltipDisabled: boolean;
    showSeriesOnHover: boolean;
    gradient: boolean;
    yAxisMinScale: number;
    labelTrim: boolean;
    labelTrimSize: number;
    activate: EventEmitter<any>;
    deactivate: EventEmitter<any>;
    tooltipTemplate: TemplateRef<any>;
    dims: ViewDimensions;
    yAxisDims: ViewDimensions;
    labelOffset: number;
    xDomain: any;
    yDomain: any;
    seriesDomain: any;
    yScale: any;
    xScale: any;
    yAxisScale: any;
    colors: ColorHelper;
    scaleType: string;
    transform: string;
    transformPlot: string;
    transformYAxis: string;
    transformXAxis: string;
    series: any;
    margin: number[];
    xAxisHeight: number;
    yAxisWidth: number;
    filteredDomain: any;
    legendOptions: any;
    thetaTicks: any[];
    radiusTicks: number[];
    outerRadius: number;
    update(): void;
    setDims(): void;
    setScales(): void;
    setTicks(): void;
    getXValues(): any[];
    getXDomain(values?: any[]): any[];
    getYValues(): any[];
    getYDomain(domain?: any[]): any[];
    getSeriesDomain(): any[];
    getXScale(domain: any, width: any): any;
    getYScale(domain: any, height: any): any;
    getScaleType(values: any): string;
    onClick(data: any, series?: any): void;
    setColors(): void;
    getLegendOptions(): {
        scaleType: string;
        colors: ColorHelper;
        domain: any;
        title: string;
    } | {
        scaleType: string;
        colors: any;
        domain: any;
        title: any;
    };
    updateYAxisWidth({width}: {
        width: any;
    }): void;
    updateXAxisHeight({height}: {
        height: any;
    }): void;
    onActivate(item: any): void;
    onDeactivate(item: any): void;
    deactivateAll(): void;
    trackBy(index: any, item: any): any;
}
