# Guidelines

We would love for you to contribute to our project and help make it ever better! 
As a contributor, here are the guidelines we would like you to follow.

### Found an Issue?
If you find a bug in the source code or a mistake in the documentation, you can help us 
by submitting an issue to our GitHub Repository. Including an issue reproduction 
(via CodePen, JsBin, Plunkr, etc.) is the absolute best way to help the team quickly diagnose the 
problem. Screenshots are also helpful.

You can help the team even more and submit a Pull Request with a fix.

### Want a Feature?
You can request a new feature by submitting an issue to our GitHub Repository. 
If you would like to implement a new feature, please submit an issue with a proposal for your work first, 
to be sure that we can use it. Please consider what kind of change it is:

- For a Major Feature, first open an issue and outline your proposal so that it can be discussed. 
This will also allow us to better coordinate our efforts, prevent duplication of work, and help you 
to craft the change so that it is successfully accepted into the project.
- Small Features can be crafted and directly submitted as a Pull Request.

### Issue Etiquette
Before you submit an issue, search the archive, maybe your question was already answered.

If your issue appears to be a bug, and hasn't been reported, open a new issue. Help us 
to maximize the effort we can spend fixing issues and adding new features by not reporting 
duplicate issues. Providing the following information will increase the chances of your issue being dealt with quickly:

- Overview of the Issue - if an error is being thrown a non-minified stack trace helps
- Angular and angular2-data-table Versions - which versions of Angular and angular2-data-table are affected
- Motivation for or Use Case - explain what are you trying to do and why the current behavior is a bug for you
- Browsers and Operating System - is this a problem with all browsers?
- Reproduce the Error - provide a live example (using CodePen, JsBin, Plunker, etc.) or a unambiguous set of steps
- Screenshots - Due to the visual nature of angular2-data-table, screenshots can help the team triage issues far more quickly than a text description.
- Related Issues - has a similar issue been reported before?
- Suggest a Fix - if you can't fix the bug yourself, perhaps you can point to what might be causing the problem (line of code or commit)


