"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var core_1 = require("@angular/core");
var DataTableFooterComponent = (function () {
    function DataTableFooterComponent() {
        this.selectedCount = 0;
        this.page = new core_1.EventEmitter();
    }
    Object.defineProperty(DataTableFooterComponent.prototype, "isVisible", {
        get: function () {
            return (this.rowCount / this.pageSize) > 1;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(DataTableFooterComponent.prototype, "curPage", {
        get: function () {
            return this.offset + 1;
        },
        enumerable: true,
        configurable: true
    });
    return DataTableFooterComponent;
}());
DataTableFooterComponent.decorators = [
    { type: core_1.Component, args: [{
                selector: 'datatable-footer',
                template: "\n    <div\n      [ngClass]=\"{'selected-count': selectedMessage}\"\n      [style.height.px]=\"footerHeight\">\n      <div class=\"page-count\">\n        <span *ngIf=\"selectedMessage\">\n          {{selectedCount.toLocaleString()}} {{selectedMessage}} / \n        </span>\n\n        {{rowCount.toLocaleString()}} {{totalMessage}}\n      </div>\n      <datatable-pager\n        [pagerLeftArrowIcon]=\"pagerLeftArrowIcon\"\n        [pagerRightArrowIcon]=\"pagerRightArrowIcon\"\n        [pagerPreviousIcon]=\"pagerPreviousIcon\"\n        [pagerNextIcon]=\"pagerNextIcon\"\n        [page]=\"curPage\"\n        [size]=\"pageSize\"\n        [count]=\"rowCount\"\n        [hidden]=\"!isVisible\"\n        (change)=\"page.emit($event)\">\n      </datatable-pager>\n    </div>\n  ",
                host: {
                    class: 'datatable-footer'
                },
                changeDetection: core_1.ChangeDetectionStrategy.OnPush
            },] },
];
/** @nocollapse */
DataTableFooterComponent.ctorParameters = function () { return []; };
DataTableFooterComponent.propDecorators = {
    'footerHeight': [{ type: core_1.Input },],
    'rowCount': [{ type: core_1.Input },],
    'pageSize': [{ type: core_1.Input },],
    'offset': [{ type: core_1.Input },],
    'pagerLeftArrowIcon': [{ type: core_1.Input },],
    'pagerRightArrowIcon': [{ type: core_1.Input },],
    'pagerPreviousIcon': [{ type: core_1.Input },],
    'pagerNextIcon': [{ type: core_1.Input },],
    'totalMessage': [{ type: core_1.Input },],
    'selectedCount': [{ type: core_1.Input },],
    'selectedMessage': [{ type: core_1.Input },],
    'page': [{ type: core_1.Output },],
};
exports.DataTableFooterComponent = DataTableFooterComponent;
//# sourceMappingURL=footer.component.js.map