export function isObject(o) {
    return (typeof o === 'object' &&
        o !== null &&
        o.constructor &&
        Object.prototype.toString.call(o).slice(8, -1) === 'Object');
}
export function isShowEl(val, obj, el) {
    return ((coerceBooleanProperty(val) === true && obj && !obj.el) ||
        !(typeof obj !== 'boolean' &&
            obj.el !== (el === null || el === void 0 ? void 0 : el.nativeElement) &&
            (typeof obj.el === 'string' || typeof obj.el === 'object')));
}
export function extend(target, src) {
    const noExtend = ['__proto__', 'constructor', 'prototype'];
    Object.keys(src)
        .filter((key) => noExtend.indexOf(key) < 0)
        .forEach((key) => {
        if (typeof target[key] === 'undefined') {
            target[key] = src[key];
            return;
        }
        if (target[key] && !src[key]) {
            return;
        }
        if (isObject(src[key]) && isObject(target[key]) && Object.keys(src[key]).length > 0) {
            if (src[key].__swiper__)
                target[key] = src[key];
            else
                extend(target[key], src[key]);
        }
        else {
            target[key] = src[key];
        }
    });
}
export function coerceBooleanProperty(value) {
    return value != null && `${value}` !== 'false';
}
export const ignoreNgOnChanges = ['pagination', 'navigation', 'scrollbar', 'virtual'];
export function setProperty(val, obj = {}) {
    if (isObject(val)) {
        return val;
    }
    if (coerceBooleanProperty(val) === true) {
        return obj;
    }
    return false;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9zcmMvYW5ndWxhci9zcmMvdXRpbHMvdXRpbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsTUFBTSxVQUFVLFFBQVEsQ0FBQyxDQUFDO0lBQ3hCLE9BQU8sQ0FDTCxPQUFPLENBQUMsS0FBSyxRQUFRO1FBQ3JCLENBQUMsS0FBSyxJQUFJO1FBQ1YsQ0FBQyxDQUFDLFdBQVc7UUFDYixNQUFNLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxLQUFLLFFBQVEsQ0FDNUQsQ0FBQztBQUNKLENBQUM7QUFFRCxNQUFNLFVBQVUsUUFBUSxDQUFDLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRTtJQUNuQyxPQUFPLENBQ0wsQ0FBQyxxQkFBcUIsQ0FBQyxHQUFHLENBQUMsS0FBSyxJQUFJLElBQUksR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQztRQUN2RCxDQUFDLENBQ0MsT0FBTyxHQUFHLEtBQUssU0FBUztZQUN4QixHQUFHLENBQUMsRUFBRSxNQUFLLEVBQUUsYUFBRixFQUFFLHVCQUFGLEVBQUUsQ0FBRSxhQUFhLENBQUE7WUFDNUIsQ0FBQyxPQUFPLEdBQUcsQ0FBQyxFQUFFLEtBQUssUUFBUSxJQUFJLE9BQU8sR0FBRyxDQUFDLEVBQUUsS0FBSyxRQUFRLENBQUMsQ0FDM0QsQ0FDRixDQUFDO0FBQ0osQ0FBQztBQUVELE1BQU0sVUFBVSxNQUFNLENBQUMsTUFBTSxFQUFFLEdBQUc7SUFDaEMsTUFBTSxRQUFRLEdBQUcsQ0FBQyxXQUFXLEVBQUUsYUFBYSxFQUFFLFdBQVcsQ0FBQyxDQUFDO0lBQzNELE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDO1NBQ2IsTUFBTSxDQUFDLENBQUMsR0FBRyxFQUFFLEVBQUUsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztTQUMxQyxPQUFPLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRTtRQUNmLElBQUksT0FBTyxNQUFNLENBQUMsR0FBRyxDQUFDLEtBQUssV0FBVyxFQUFFO1lBQ3RDLE1BQU0sQ0FBQyxHQUFHLENBQUMsR0FBRyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDdkIsT0FBTztTQUNSO1FBQ0QsSUFBSSxNQUFNLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLEVBQUU7WUFDNUIsT0FBTztTQUNSO1FBQ0QsSUFBSSxRQUFRLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDLElBQUksUUFBUSxDQUFDLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLE1BQU0sQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtZQUNuRixJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxVQUFVO2dCQUFFLE1BQU0sQ0FBQyxHQUFHLENBQUMsR0FBRyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7O2dCQUMzQyxNQUFNLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1NBQ3BDO2FBQU07WUFDTCxNQUFNLENBQUMsR0FBRyxDQUFDLEdBQUcsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1NBQ3hCO0lBQ0gsQ0FBQyxDQUFDLENBQUM7QUFDUCxDQUFDO0FBRUQsTUFBTSxVQUFVLHFCQUFxQixDQUFDLEtBQVU7SUFDOUMsT0FBTyxLQUFLLElBQUksSUFBSSxJQUFJLEdBQUcsS0FBSyxFQUFFLEtBQUssT0FBTyxDQUFDO0FBQ2pELENBQUM7QUFFRCxNQUFNLENBQUMsTUFBTSxpQkFBaUIsR0FBRyxDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsV0FBVyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0FBRXRGLE1BQU0sVUFBVSxXQUFXLENBQUMsR0FBUSxFQUFFLEdBQUcsR0FBRyxFQUFFO0lBQzVDLElBQUksUUFBUSxDQUFDLEdBQUcsQ0FBQyxFQUFFO1FBQ2pCLE9BQU8sR0FBRyxDQUFDO0tBQ1o7SUFFRCxJQUFJLHFCQUFxQixDQUFDLEdBQUcsQ0FBQyxLQUFLLElBQUksRUFBRTtRQUN2QyxPQUFPLEdBQUcsQ0FBQztLQUNaO0lBRUQsT0FBTyxLQUFLLENBQUM7QUFDZixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGZ1bmN0aW9uIGlzT2JqZWN0KG8pIHtcbiAgcmV0dXJuIChcbiAgICB0eXBlb2YgbyA9PT0gJ29iamVjdCcgJiZcbiAgICBvICE9PSBudWxsICYmXG4gICAgby5jb25zdHJ1Y3RvciAmJlxuICAgIE9iamVjdC5wcm90b3R5cGUudG9TdHJpbmcuY2FsbChvKS5zbGljZSg4LCAtMSkgPT09ICdPYmplY3QnXG4gICk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1Nob3dFbCh2YWwsIG9iaiwgZWwpIHtcbiAgcmV0dXJuIChcbiAgICAoY29lcmNlQm9vbGVhblByb3BlcnR5KHZhbCkgPT09IHRydWUgJiYgb2JqICYmICFvYmouZWwpIHx8XG4gICAgIShcbiAgICAgIHR5cGVvZiBvYmogIT09ICdib29sZWFuJyAmJlxuICAgICAgb2JqLmVsICE9PSBlbD8ubmF0aXZlRWxlbWVudCAmJlxuICAgICAgKHR5cGVvZiBvYmouZWwgPT09ICdzdHJpbmcnIHx8IHR5cGVvZiBvYmouZWwgPT09ICdvYmplY3QnKVxuICAgIClcbiAgKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGV4dGVuZCh0YXJnZXQsIHNyYykge1xuICBjb25zdCBub0V4dGVuZCA9IFsnX19wcm90b19fJywgJ2NvbnN0cnVjdG9yJywgJ3Byb3RvdHlwZSddO1xuICBPYmplY3Qua2V5cyhzcmMpXG4gICAgLmZpbHRlcigoa2V5KSA9PiBub0V4dGVuZC5pbmRleE9mKGtleSkgPCAwKVxuICAgIC5mb3JFYWNoKChrZXkpID0+IHtcbiAgICAgIGlmICh0eXBlb2YgdGFyZ2V0W2tleV0gPT09ICd1bmRlZmluZWQnKSB7XG4gICAgICAgIHRhcmdldFtrZXldID0gc3JjW2tleV07XG4gICAgICAgIHJldHVybjtcbiAgICAgIH1cbiAgICAgIGlmICh0YXJnZXRba2V5XSAmJiAhc3JjW2tleV0pIHtcbiAgICAgICAgcmV0dXJuO1xuICAgICAgfVxuICAgICAgaWYgKGlzT2JqZWN0KHNyY1trZXldKSAmJiBpc09iamVjdCh0YXJnZXRba2V5XSkgJiYgT2JqZWN0LmtleXMoc3JjW2tleV0pLmxlbmd0aCA+IDApIHtcbiAgICAgICAgaWYgKHNyY1trZXldLl9fc3dpcGVyX18pIHRhcmdldFtrZXldID0gc3JjW2tleV07XG4gICAgICAgIGVsc2UgZXh0ZW5kKHRhcmdldFtrZXldLCBzcmNba2V5XSk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0YXJnZXRba2V5XSA9IHNyY1trZXldO1xuICAgICAgfVxuICAgIH0pO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY29lcmNlQm9vbGVhblByb3BlcnR5KHZhbHVlOiBhbnkpOiBib29sZWFuIHtcbiAgcmV0dXJuIHZhbHVlICE9IG51bGwgJiYgYCR7dmFsdWV9YCAhPT0gJ2ZhbHNlJztcbn1cblxuZXhwb3J0IGNvbnN0IGlnbm9yZU5nT25DaGFuZ2VzID0gWydwYWdpbmF0aW9uJywgJ25hdmlnYXRpb24nLCAnc2Nyb2xsYmFyJywgJ3ZpcnR1YWwnXTtcblxuZXhwb3J0IGZ1bmN0aW9uIHNldFByb3BlcnR5KHZhbDogYW55LCBvYmogPSB7fSk6IHt9IHwgZmFsc2Uge1xuICBpZiAoaXNPYmplY3QodmFsKSkge1xuICAgIHJldHVybiB2YWw7XG4gIH1cblxuICBpZiAoY29lcmNlQm9vbGVhblByb3BlcnR5KHZhbCkgPT09IHRydWUpIHtcbiAgICByZXR1cm4gb2JqO1xuICB9XG5cbiAgcmV0dXJuIGZhbHNlO1xufVxuIl19