import { ClientRequest } from 'http';
export interface Timings {
    start: number;
    socket?: number;
    lookup?: number;
    connect?: number;
    secureConnect?: number;
    upload?: number;
    response?: number;
    end?: number;
    error?: number;
    phases: {
        wait?: number;
        dns?: number;
        tcp?: number;
        tls?: number;
        request?: number;
        firstByte?: number;
        download?: number;
        total?: number;
    };
}
declare module 'http' {
    interface ClientRequest {
        timings?: Timings;
    }
    interface IncomingMessage {
        timings?: Timings;
    }
}
declare const timer: (request: ClientRequest) => Timings;
export default timer;
