import * as React from 'react';

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};

  var target = _objectWithoutPropertiesLoose(source, excluded);

  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

var _excluded$t_ = ["size", "color", "stroke"];

function Icon2fa(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-2fa",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 16h-4l3.47 -4.66a2 2 0 1 0 -3.47 -1.54"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 16v-8h4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 12,
    x2: 13,
    y2: 12
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 16v-6a2 2 0 0 1 4 0v6"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 13,
    x2: 21,
    y2: 13
  }));
}

var _excluded$tZ = ["size", "color", "stroke"];

function Icon3dCubeSphere(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-3d-cube-sphere",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 17.6l-2 -1.1v-2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 10v-2.5l2 -1.1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 4.1l2 -1.1l2 1.1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 6.4l2 1.1v2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 14v2.5l-2 1.12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 19.9l-2 1.1l-2 -1.1"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 14,
    y2: 10.9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 8.6,
    x2: 20,
    y2: 7.5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 14.5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 18.5,
    x2: 12,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-2 -1.12"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 8.6,
    x2: 4,
    y2: 7.5
  }));
}

var _excluded$tY = ["size", "color", "stroke"];

function Icon3dRotate(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-3d-rotate",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 15.5l4 -2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 13l4 2.5v4.5l4 -2.5v-4.5l-4 -2.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 13v4.5l4 2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 4a7 7 0 0 1 7 7v4l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 12l-3 3"
  }));
}

var _excluded$tX = ["size", "color", "stroke"];

function IconABOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-a-b-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 16v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 8h3a2 2 0 1 1 0 4h-3m3 0a2 2 0 0 1 .83 3.82m-3.83 -3.82v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$tW = ["size", "color", "stroke"];

function IconAB(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-a-b",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 16v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 6,
    x2: 12,
    y2: 18
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 16v-8h3a2 2 0 0 1 0 4h-3m3 0a2 2 0 0 1 0 4h-3"
  }));
}

var _excluded$tV = ["size", "color", "stroke"];

function IconAbacus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-abacus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 3v18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 21v-18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 7h14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 15h14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 13v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 13v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 13v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 5v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 5v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 5v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 21h18"
  }));
}

var _excluded$tU = ["size", "color", "stroke"];

function IconAccessPointOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-access-point-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.828 9.172a4 4 0 0 1 1.172 2.828"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.657 6.343a8 8 0 0 1 1.635 8.952"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.168 14.828a4 4 0 0 1 0 -5.656"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.337 17.657a8 8 0 0 1 0 -11.314"
  }));
}

var _excluded$tT = ["size", "color", "stroke"];

function IconAccessPoint(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-access-point",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.828 9.172a4 4 0 0 1 0 5.656"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.657 6.343a8 8 0 0 1 0 11.314"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.168 14.828a4 4 0 0 1 0 -5.656"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.337 17.657a8 8 0 0 1 0 -11.314"
  }));
}

var _excluded$tS = ["size", "color", "stroke"];

function IconAccessibleOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-accessible-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 16.5l2 -3l2 3m-2 -3v-1.5m2.627 -1.376l.373 -.124m-6 0l2.231 .744"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 8a0.5 .5 0 1 0 -.5 -.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$tR = ["size", "color", "stroke"];

function IconAccessible(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-accessible",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 16.5l2 -3l2 3m-2 -3v-2l3 -1m-6 0l3 1"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 7.5,
    r: 0.5,
    fill: "currentColor"
  }));
}

var _excluded$tQ = ["size", "color", "stroke"];

function IconActivityHeartbeat(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-activity-heartbeat",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12h4.5l1.5 -6l4 12l2 -9l1.5 3h4.5"
  }));
}

var _excluded$tP = ["size", "color", "stroke"];

function IconActivity(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-activity",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12h4l3 8l4 -16l3 8h4"
  }));
}

var _excluded$tO = ["size", "color", "stroke"];

function IconAd2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ad-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.933 5h-6.933v16h13v-8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 17h-5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 13h5v-4h-5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 5v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 6l2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 9h2"
  }));
}

var _excluded$tN = ["size", "color", "stroke"];

function IconAd(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ad",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 5,
    width: 18,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 15v-4a2 2 0 0 1 4 0v4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 13,
    x2: 11,
    y2: 13
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 9v6h-1.5a1.5 1.5 0 1 1 1.5 -1.5"
  }));
}

var _excluded$tM = ["size", "color", "stroke"];

function IconAddressBook(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-address-book",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 6v12a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 16h6"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 13,
    cy: 11,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16h3"
  }));
}

var _excluded$tL = ["size", "color", "stroke"];

function IconAdjustmentsAlt(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-adjustments-alt",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 8,
    width: 4,
    height: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 4,
    x2: 6,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 12,
    x2: 6,
    y2: 20
  }), /*#__PURE__*/React.createElement("rect", {
    x: 10,
    y: 14,
    width: 4,
    height: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 18,
    x2: 12,
    y2: 20
  }), /*#__PURE__*/React.createElement("rect", {
    x: 16,
    y: 5,
    width: 4,
    height: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 4,
    x2: 18,
    y2: 5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 9,
    x2: 18,
    y2: 20
  }));
}

var _excluded$tK = ["size", "color", "stroke"];

function IconAdjustmentsHorizontal(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-adjustments-horizontal",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14,
    cy: 6,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 6,
    x2: 12,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 6,
    x2: 20,
    y2: 6
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 8,
    cy: 12,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 6,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 12,
    x2: 20,
    y2: 12
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 18,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 18,
    x2: 15,
    y2: 18
  }), /*#__PURE__*/React.createElement("line", {
    x1: 19,
    y1: 18,
    x2: 20,
    y2: 18
  }));
}

var _excluded$tJ = ["size", "color", "stroke"];

function IconAdjustmentsOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-adjustments-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 6,
    cy: 10,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 6v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12v8"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 16,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 18v2"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18,
    cy: 7,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 4v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 9v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 18v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$tI = ["size", "color", "stroke"];

function IconAdjustments(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-adjustments",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 6,
    cy: 10,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 4,
    x2: 6,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 12,
    x2: 6,
    y2: 20
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 16,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 18,
    x2: 12,
    y2: 20
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18,
    cy: 7,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 4,
    x2: 18,
    y2: 5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 9,
    x2: 18,
    y2: 20
  }));
}

var _excluded$tH = ["size", "color", "stroke"];

function IconAerialLift(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-aerial-lift",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 5l16 -2m-8 1v10m-5.106 -6h10.306c2.45 3 2.45 9 -.2 12h-10.106c-2.544 -3 -2.544 -9 0 -12zm-1.894 6h14"
  }));
}

var _excluded$tG = ["size", "color", "stroke"];

function IconAffiliate(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-affiliate",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.931 6.936l1.275 4.249m5.607 5.609l4.251 1.275"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.683 12.317l5.759 -5.759"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5.5,
    cy: 5.5,
    r: 1.5
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18.5,
    cy: 5.5,
    r: 1.5
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18.5,
    cy: 18.5,
    r: 1.5
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 8.5,
    cy: 15.5,
    r: 4.5
  }));
}

var _excluded$tF = ["size", "color", "stroke"];

function IconAlarmOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-alarm-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.587 7.566a7 7 0 1 0 9.833 9.864m1.35 -2.645a7 7 0 0 0 -8.536 -8.56"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v1h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.261 5.265l-1.011 .735"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 4l2.75 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$tE = ["size", "color", "stroke"];

function IconAlarm(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-alarm",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 13,
    r: 7
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "12 10 12 13 14 13"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 4,
    x2: 4.25,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 4,
    x2: 19.75,
    y2: 6
  }));
}

var _excluded$tD = ["size", "color", "stroke"];

function IconAlbum(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-album",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 4v7l2 -2l2 2v-7"
  }));
}

var _excluded$tC = ["size", "color", "stroke"];

function IconAlertCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-alert-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12.01,
    y2: 16
  }));
}

var _excluded$tB = ["size", "color", "stroke"];

function IconAlertOctagon(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-alert-octagon",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.7 3h6.6c.3 0 .5 .1 .7 .3l4.7 4.7c.2 .2 .3 .4 .3 .7v6.6c0 .3 -.1 .5 -.3 .7l-4.7 4.7c-.2 .2 -.4 .3 -.7 .3h-6.6c-.3 0 -.5 -.1 -.7 -.3l-4.7 -4.7c-.2 -.2 -.3 -.4 -.3 -.7v-6.6c0 -.3 .1 -.5 .3 -.7l4.7 -4.7c.2 -.2 .4 -.3 .7 -.3z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12.01,
    y2: 16
  }));
}

var _excluded$tA = ["size", "color", "stroke"];

function IconAlertTriangle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-alert-triangle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9v2m0 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75"
  }));
}

var _excluded$tz = ["size", "color", "stroke"];

function IconAlien(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-alien",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 17a2.5 2.5 0 0 0 2 0"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3c-4.664 0 -7.396 2.331 -7.862 5.595a11.816 11.816 0 0 0 2 8.592a10.777 10.777 0 0 0 3.199 3.064c1.666 1 3.664 1 5.33 0a10.777 10.777 0 0 0 3.199 -3.064a11.89 11.89 0 0 0 2 -8.592c-.466 -3.265 -3.198 -5.595 -7.862 -5.595z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 11,
    x2: 10,
    y2: 13
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 11,
    x2: 14,
    y2: 13
  }));
}

var _excluded$ty = ["size", "color", "stroke"];

function IconAlignCenter(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ty);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-align-center",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 6,
    x2: 20,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 16,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 18,
    x2: 18,
    y2: 18
  }));
}

var _excluded$tx = ["size", "color", "stroke"];

function IconAlignJustified(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tx);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-align-justified",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 6,
    x2: 20,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 20,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 18,
    x2: 16,
    y2: 18
  }));
}

var _excluded$tw = ["size", "color", "stroke"];

function IconAlignLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-align-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 6,
    x2: 20,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 14,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 18,
    x2: 18,
    y2: 18
  }));
}

var _excluded$tv = ["size", "color", "stroke"];

function IconAlignRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-align-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 6,
    x2: 20,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 12,
    x2: 20,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 18,
    x2: 20,
    y2: 18
  }));
}

var _excluded$tu = ["size", "color", "stroke"];

function IconAmbulance(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tu);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ambulance",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 17h-2v-11a1 1 0 0 1 1 -1h9v12m-4 0h6m4 0h2v-6h-8m0 -5h5l3 5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 10h4m-2 -2v4"
  }));
}

var _excluded$tt = ["size", "color", "stroke"];

function IconAnchorOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tt);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-anchor-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 13a8 8 0 0 0 14.138 5.13m1.44 -2.56a7.99 7.99 0 0 0 .422 -2.57"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 13h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 13h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.866 8.873a3.001 3.001 0 1 0 -3.737 -3.747"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$ts = ["size", "color", "stroke"];

function IconAnchor(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ts);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-anchor",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9v12m-8 -8a8 8 0 0 0 16 0m1 0h-2m-14 0h-2"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 6,
    r: 3
  }));
}

var _excluded$tr = ["size", "color", "stroke"];

function IconAngle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-angle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 19h-18l9 -15"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.615 15.171h.015"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.515 11.771h.015"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.715 8.671h.015"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.415 5.971h.015"
  }));
}

var _excluded$tq = ["size", "color", "stroke"];

function IconAntennaBars1(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-antenna-bars-1",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 18,
    x2: 6,
    y2: 18.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 18,
    x2: 10,
    y2: 18.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 18,
    x2: 14,
    y2: 18.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 18,
    x2: 18,
    y2: 18.01
  }));
}

var _excluded$tp = ["size", "color", "stroke"];

function IconAntennaBars2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tp);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-antenna-bars-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 18,
    x2: 6,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 18,
    x2: 10,
    y2: 18.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 18,
    x2: 14,
    y2: 18.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 18,
    x2: 18,
    y2: 18.01
  }));
}

var _excluded$to = ["size", "color", "stroke"];

function IconAntennaBars3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$to);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-antenna-bars-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 18,
    x2: 6,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 18,
    x2: 10,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 18,
    x2: 14,
    y2: 18.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 18,
    x2: 18,
    y2: 18.01
  }));
}

var _excluded$tn = ["size", "color", "stroke"];

function IconAntennaBars4(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tn);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-antenna-bars-4",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 18,
    x2: 6,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 18,
    x2: 10,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 18,
    x2: 14,
    y2: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 18,
    x2: 18,
    y2: 18.01
  }));
}

var _excluded$tm = ["size", "color", "stroke"];

function IconAntennaBars5(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tm);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-antenna-bars-5",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 18,
    x2: 6,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 18,
    x2: 10,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 18,
    x2: 14,
    y2: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 18,
    x2: 18,
    y2: 6
  }));
}

var _excluded$tl = ["size", "color", "stroke"];

function IconAntennaBarsOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tl);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-antenna-bars-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 18v-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 18v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 18v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 10v-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 14v-8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$tk = ["size", "color", "stroke"];

function IconAntenna(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-antenna",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4.5v7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 5v16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 5.5v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 8h-16"
  }));
}

var _excluded$tj = ["size", "color", "stroke"];

function IconAperture(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-aperture",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3.6,
    y1: 15,
    x2: 14.15,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3.6,
    y1: 15,
    x2: 14.15,
    y2: 15,
    transform: "rotate(72 12 12)"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3.6,
    y1: 15,
    x2: 14.15,
    y2: 15,
    transform: "rotate(144 12 12)"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3.6,
    y1: 15,
    x2: 14.15,
    y2: 15,
    transform: "rotate(216 12 12)"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3.6,
    y1: 15,
    x2: 14.15,
    y2: 15,
    transform: "rotate(288 12 12)"
  }));
}

var _excluded$ti = ["size", "color", "stroke"];

function IconApiAppOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ti);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-api-app-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 15h-6.5a2.5 2.5 0 1 1 0 -5h.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 15v3.5a2.5 2.5 0 1 1 -5 0v-.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 9h5.5a2.5 2.5 0 1 1 0 5h-.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12v-3m.042 -3.957a2.5 2.5 0 0 1 4.958 .457v.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$th = ["size", "color", "stroke"];

function IconApiApp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$th);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-api-app",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 15h-6.5a2.5 2.5 0 1 1 0 -5h.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 12v6.5a2.5 2.5 0 1 1 -5 0v-.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9h6.5a2.5 2.5 0 1 1 0 5h-.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12v-6.5a2.5 2.5 0 0 1 5 0v.5"
  }));
}

var _excluded$tg = ["size", "color", "stroke"];

function IconApiOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tg);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-api-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 13h5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 16v-4m0 -4h3a2 2 0 0 1 2 2v1c0 .554 -.225 1.055 -.589 1.417m-3.411 .583h-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 8v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 16v-5.5a2.5 2.5 0 0 0 -5 0v5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$tf = ["size", "color", "stroke"];

function IconApi(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-api",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 13h5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 16v-8h3a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2h-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 8v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 16v-5.5a2.5 2.5 0 0 0 -5 0v5.5"
  }));
}

var _excluded$te = ["size", "color", "stroke"];

function IconAppWindow(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$te);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-app-window",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 5,
    width: 18,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 8h.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 8h.01"
  }));
}

var _excluded$td = ["size", "color", "stroke"];

function IconApple(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$td);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-apple",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 14,
    r: 7
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 11v-6a2 2 0 0 1 2 -2h2v1a2 2 0 0 1 -2 2h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 10.5c1.333 .667 2.667 .667 4 0"
  }));
}

var _excluded$tc = ["size", "color", "stroke"];

function IconAppsOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-apps-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4h1a1 1 0 0 1 1 1v1m-.29 3.704a0.997 .997 0 0 1 -.71 .296h-4a1 1 0 0 1 -1 -1v-4c0 -.276 .111 -.525 .292 -.706"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 14h1a1 1 0 0 1 1 1v1m-.29 3.704a0.997 .997 0 0 1 -.71 .296h-4a1 1 0 0 1 -1 -1v-4c0 -.276 .111 -.525 .292 -.706"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 14,
    width: 6,
    height: 6,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 7h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 4v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$tb = ["size", "color", "stroke"];

function IconApps(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$tb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-apps",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 6,
    height: 6,
    rx: 1
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 14,
    width: 6,
    height: 6,
    rx: 1
  }), /*#__PURE__*/React.createElement("rect", {
    x: 14,
    y: 14,
    width: 6,
    height: 6,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 7,
    x2: 20,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 4,
    x2: 17,
    y2: 10
  }));
}

var _excluded$ta = ["size", "color", "stroke"];

function IconArchiveOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ta);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-archive-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4h11a2 2 0 1 1 0 4h-7m-4 0h-3a2 2 0 0 1 -.826 -3.822"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 1.824 -1.18m.176 -3.82v-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 12h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$t9 = ["size", "color", "stroke"];

function IconArchive(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-archive",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 4,
    width: 18,
    height: 4,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-10"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 12,
    x2: 14,
    y2: 12
  }));
}

var _excluded$t8 = ["size", "color", "stroke"];

function IconArmchair2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-armchair-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 10v-4a3 3 0 0 1 3 -3h8a3 3 0 0 1 3 3v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 15v-2a3 3 0 1 1 3 3v3h-14v-3a3 3 0 1 1 3 -3v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 12h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 19v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 19v2"
  }));
}

var _excluded$t7 = ["size", "color", "stroke"];

function IconArmchair(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-armchair",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 11a2 2 0 0 1 2 2v2h10v-2a2 2 0 1 1 4 0v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-4a2 2 0 0 1 2 -2z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 11v-5a3 3 0 0 1 3 -3h8a3 3 0 0 1 3 3v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 19v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 19v2"
  }));
}

var _excluded$t6 = ["size", "color", "stroke"];

function IconArrowAutofitContent(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-autofit-content",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 4l-3 3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 4l3 3l-3 3"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 14,
    width: 16,
    height: 6,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 7h-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 7h-7"
  }));
}

var _excluded$t5 = ["size", "color", "stroke"];

function IconArrowAutofitDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-autofit-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 4v17"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 18l3 3l3 -3"
  }));
}

var _excluded$t4 = ["size", "color", "stroke"];

function IconArrowAutofitHeight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-autofit-height",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 14v7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 3v7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 18l3 3l3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 6l3 -3l3 3"
  }));
}

var _excluded$t3 = ["size", "color", "stroke"];

function IconArrowAutofitLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-autofit-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 18h-17"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 15l-3 3l3 3"
  }));
}

var _excluded$t2 = ["size", "color", "stroke"];

function IconArrowAutofitRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-autofit-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 12v-6a2 2 0 0 0 -2 -2h-12a2 2 0 0 0 -2 2v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 18h17"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l3 3l-3 3"
  }));
}

var _excluded$t1 = ["size", "color", "stroke"];

function IconArrowAutofitUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-autofit-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 4h-6a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 20v-17"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 6l3 -3l3 3"
  }));
}

var _excluded$t0 = ["size", "color", "stroke"];

function IconArrowAutofitWidth(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$t0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-autofit-width",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 18h-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 18h-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 15l-3 3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l3 3l-3 3"
  }));
}

var _excluded$s$ = ["size", "color", "stroke"];

function IconArrowBackUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-back-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 13l-4 -4l4 -4m-4 4h11a4 4 0 0 1 0 8h-1"
  }));
}

var _excluded$s_ = ["size", "color", "stroke"];

function IconArrowBack(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-back",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 11l-4 4l4 4m-4 -4h11a4 4 0 0 0 0 -8h-1"
  }));
}

var _excluded$sZ = ["size", "color", "stroke"];

function IconArrowBarDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bar-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 12,
    y2: 10
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 16,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 8,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 20,
    y2: 4
  }));
}

var _excluded$sY = ["size", "color", "stroke"];

function IconArrowBarLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bar-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 14,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 8,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 8,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 20
  }));
}

var _excluded$sX = ["size", "color", "stroke"];

function IconArrowBarRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bar-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 10,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 16,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 16,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 4,
    y2: 20
  }));
}

var _excluded$sW = ["size", "color", "stroke"];

function IconArrowBarToDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bar-to-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 20,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 14,
    x2: 12,
    y2: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 14,
    x2: 16,
    y2: 10
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 14,
    x2: 8,
    y2: 10
  }));
}

var _excluded$sV = ["size", "color", "stroke"];

function IconArrowBarToLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bar-to-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 12,
    x2: 20,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 12,
    x2: 14,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 12,
    x2: 14,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 4,
    y2: 20
  }));
}

var _excluded$sU = ["size", "color", "stroke"];

function IconArrowBarToRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bar-to-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 12,
    x2: 4,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 12,
    x2: 10,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 12,
    x2: 10,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 20
  }));
}

var _excluded$sT = ["size", "color", "stroke"];

function IconArrowBarToUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bar-to-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 10,
    x2: 12,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 10,
    x2: 16,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 10,
    x2: 8,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 20,
    y2: 4
  }));
}

var _excluded$sS = ["size", "color", "stroke"];

function IconArrowBarUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bar-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 16,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 8,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 20,
    y2: 20
  }));
}

var _excluded$sR = ["size", "color", "stroke"];

function IconArrowBearLeft2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bear-left-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 3h-5v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 3l7.536 7.536a5 5 0 0 1 1.464 3.534v6.93"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 5l-4.5 4.5"
  }));
}

var _excluded$sQ = ["size", "color", "stroke"];

function IconArrowBearLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bear-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 3h-5v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 3l7.536 7.536a5 5 0 0 1 1.464 3.534v6.93"
  }));
}

var _excluded$sP = ["size", "color", "stroke"];

function IconArrowBearRight2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bear-right-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 3h5v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 5l4.5 4.5"
  }));
}

var _excluded$sO = ["size", "color", "stroke"];

function IconArrowBearRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bear-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3h5v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93"
  }));
}

var _excluded$sN = ["size", "color", "stroke"];

function IconArrowBigDownLine(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-down-line",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 12h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-6h6v6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 3h-6"
  }));
}

var _excluded$sM = ["size", "color", "stroke"];

function IconArrowBigDownLines(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-down-lines",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 12h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-3h6v3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 3h-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 6h-6"
  }));
}

var _excluded$sL = ["size", "color", "stroke"];

function IconArrowBigDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 4v8h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-8a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1z"
  }));
}

var _excluded$sK = ["size", "color", "stroke"];

function IconArrowBigLeftLine(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-left-line",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 15v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h6v6h-6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 15v-6"
  }));
}

var _excluded$sJ = ["size", "color", "stroke"];

function IconArrowBigLeftLines(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-left-lines",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 15v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h3v6h-3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 15v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15v-6"
  }));
}

var _excluded$sI = ["size", "color", "stroke"];

function IconArrowBigLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 15h-8v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h8a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1z"
  }));
}

var _excluded$sH = ["size", "color", "stroke"];

function IconArrowBigRightLine(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-right-line",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-6v-6h6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 9v6"
  }));
}

var _excluded$sG = ["size", "color", "stroke"];

function IconArrowBigRightLines(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-right-lines",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-3v-6h3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 9v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 9v6"
  }));
}

var _excluded$sF = ["size", "color", "stroke"];

function IconArrowBigRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 9h8v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-8a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1z"
  }));
}

var _excluded$sE = ["size", "color", "stroke"];

function IconArrowBigTop(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-top",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 20v-8h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v8a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z"
  }));
}

var _excluded$sD = ["size", "color", "stroke"];

function IconArrowBigUpLine(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-up-line",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v6h-6v-6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 21h6"
  }));
}

var _excluded$sC = ["size", "color", "stroke"];

function IconArrowBigUpLines(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-big-up-lines",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v3h-6v-3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 21h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18h6"
  }));
}

var _excluded$sB = ["size", "color", "stroke"];

function IconArrowBottomBar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bottom-bar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18l3 3l3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 3h6"
  }));
}

var _excluded$sA = ["size", "color", "stroke"];

function IconArrowBottomCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bottom-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7v14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18l3 3l3 -3"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 5,
    r: 2
  }));
}

var _excluded$sz = ["size", "color", "stroke"];

function IconArrowBottomSquare(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bottom-square",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7v14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18l3 3l3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 3v4h-4v-4z"
  }));
}

var _excluded$sy = ["size", "color", "stroke"];

function IconArrowBottomTail(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sy);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-bottom-tail",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6v15"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18l3 3l3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 3l3 3l3 -3"
  }));
}

var _excluded$sx = ["size", "color", "stroke"];

function IconArrowCurveLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sx);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-curve-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 7l-4 -4l-4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 3v4.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v2.394"
  }));
}

var _excluded$sw = ["size", "color", "stroke"];

function IconArrowCurveRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-curve-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 7l4 -4l4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 3v4.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v2.394"
  }));
}

var _excluded$sv = ["size", "color", "stroke"];

function IconArrowDownCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-down-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 12,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 12,
    x2: 12,
    y2: 16
  }));
}

var _excluded$su = ["size", "color", "stroke"];

function IconArrowDownLeftCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$su);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-down-left-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 9,
    x2: 9,
    y2: 15
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "15 15 9 15 9 9"
  }));
}

var _excluded$st = ["size", "color", "stroke"];

function IconArrowDownLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$st);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-down-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 7,
    x2: 7,
    y2: 17
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "16 17 7 17 7 8"
  }));
}

var _excluded$ss = ["size", "color", "stroke"];

function IconArrowDownRightCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ss);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-down-right-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 15,
    x2: 9,
    y2: 15
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "15 9 15 15 9 9"
  }));
}

var _excluded$sr = ["size", "color", "stroke"];

function IconArrowDownRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-down-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 7,
    x2: 17,
    y2: 17
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "17 8 17 17 8 17"
  }));
}

var _excluded$sq = ["size", "color", "stroke"];

function IconArrowDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 5,
    x2: 12,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 13,
    x2: 12,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 13,
    x2: 12,
    y2: 19
  }));
}

var _excluded$sp = ["size", "color", "stroke"];

function IconArrowFork(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sp);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-fork",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 3h5v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 3h-5v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l7.536 7.536a5 5 0 0 1 1.464 3.534v.93"
  }));
}

var _excluded$so = ["size", "color", "stroke"];

function IconArrowForwardUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$so);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-forward-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 13l4 -4l-4 -4m4 4h-11a4 4 0 0 0 0 8h1"
  }));
}

var _excluded$sn = ["size", "color", "stroke"];

function IconArrowForward(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sn);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-forward",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 11l4 4l-4 4m4 -4h-11a4 4 0 0 1 0 -8h1"
  }));
}

var _excluded$sm = ["size", "color", "stroke"];

function IconArrowLeftBar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sm);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-left-bar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 12h-18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 9l-3 3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 9v6"
  }));
}

var _excluded$sl = ["size", "color", "stroke"];

function IconArrowLeftCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sl);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-left-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 12h-14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 9l-3 3l3 3"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 19,
    cy: 12,
    r: 2
  }));
}

var _excluded$sk = ["size", "color", "stroke"];

function IconArrowLeftRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-left-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 13l4 -4l-4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 13l-4 -4l4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 14a5 5 0 0 1 5 -5h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 19v-5a5 5 0 0 0 -5 -5h-4"
  }));
}

var _excluded$sj = ["size", "color", "stroke"];

function IconArrowLeftSquare(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-left-square",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 12h-14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 9l-3 3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 14h-4v-4h4z"
  }));
}

var _excluded$si = ["size", "color", "stroke"];

function IconArrowLeftTail(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$si);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-left-tail",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 12h-15"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 9l-3 3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 9l-3 3l3 3"
  }));
}

var _excluded$sh = ["size", "color", "stroke"];

function IconArrowLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sh);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 19,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 11,
    y2: 18
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 11,
    y2: 6
  }));
}

var _excluded$sg = ["size", "color", "stroke"];

function IconArrowLoopLeft2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sg);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-loop-left-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 21v-6m0 -6v-1a4 4 0 1 1 4 4h-13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16l-4 -4l4 -4"
  }));
}

var _excluded$sf = ["size", "color", "stroke"];

function IconArrowLoopLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-loop-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 21v-13a4 4 0 1 1 4 4h-13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16l-4 -4l4 -4"
  }));
}

var _excluded$se = ["size", "color", "stroke"];

function IconArrowLoopRight2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$se);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-loop-right-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 21v-6m0 -6v-1a4 4 0 1 0 -4 4h13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 16l4 -4l-4 -4"
  }));
}

var _excluded$sd = ["size", "color", "stroke"];

function IconArrowLoopRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sd);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-loop-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 21v-13a4 4 0 1 0 -4 4h13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 16l4 -4l-4 -4"
  }));
}

var _excluded$sc = ["size", "color", "stroke"];

function IconArrowMerge(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-merge",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 7l4 -4l4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v5.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v1.394"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v5.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v1.394"
  }));
}

var _excluded$sb = ["size", "color", "stroke"];

function IconArrowNarrowDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-narrow-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 5,
    x2: 12,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 15,
    x2: 12,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 15,
    x2: 12,
    y2: 19
  }));
}

var _excluded$sa = ["size", "color", "stroke"];

function IconArrowNarrowLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$sa);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-narrow-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 19,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 9,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 9,
    y2: 8
  }));
}

var _excluded$s9 = ["size", "color", "stroke"];

function IconArrowNarrowRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-narrow-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 19,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 16,
    x2: 19,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 8,
    x2: 19,
    y2: 12
  }));
}

var _excluded$s8 = ["size", "color", "stroke"];

function IconArrowNarrowUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-narrow-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 5,
    x2: 12,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 9,
    x2: 12,
    y2: 5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 9,
    x2: 12,
    y2: 5
  }));
}

var _excluded$s7 = ["size", "color", "stroke"];

function IconArrowRampLeft2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-ramp-left-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 3v8.707"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 14l-4 -4l4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 21c0 -6.075 -4.925 -11 -11 -11h-3"
  }));
}

var _excluded$s6 = ["size", "color", "stroke"];

function IconArrowRampLeft3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-ramp-left-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 3v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16l-4 -4l4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 21v-6a3 3 0 0 0 -3 -3h-11"
  }));
}

var _excluded$s5 = ["size", "color", "stroke"];

function IconArrowRampLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-ramp-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 3,
    x2: 17,
    y2: 11.707
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 7l4 -4l4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 14l-4 -4l4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 21a11 11 0 0 0 -11 -11h-3"
  }));
}

var _excluded$s4 = ["size", "color", "stroke"];

function IconArrowRampRight2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-ramp-right-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 3v8.707"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 14l4 -4l-4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 21c0 -6.075 4.925 -11 11 -11h3"
  }));
}

var _excluded$s3 = ["size", "color", "stroke"];

function IconArrowRampRight3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-ramp-right-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 3v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 16l4 -4l-4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 21v-6a3 3 0 0 1 3 -3h11"
  }));
}

var _excluded$s2 = ["size", "color", "stroke"];

function IconArrowRampRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-ramp-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 3,
    x2: 7,
    y2: 11.707
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7l-4 -4l-4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 14l4 -4l-4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 21a11 11 0 0 1 11 -11h3"
  }));
}

var _excluded$s1 = ["size", "color", "stroke"];

function IconArrowRightBar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-right-bar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12h18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 9v6"
  }));
}

var _excluded$s0 = ["size", "color", "stroke"];

function IconArrowRightCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$s0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-right-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5,
    cy: 12,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 12h14"
  }));
}

var _excluded$r$ = ["size", "color", "stroke"];

function IconArrowRightSquare(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-right-square",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 12,
    x2: 21,
    y2: 12
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 10h4v4h-4z"
  }));
}

var _excluded$r_ = ["size", "color", "stroke"];

function IconArrowRightTail(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-right-tail",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 15l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 12,
    x2: 21,
    y2: 12
  }));
}

var _excluded$rZ = ["size", "color", "stroke"];

function IconArrowRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 19,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 18,
    x2: 19,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 6,
    x2: 19,
    y2: 12
  }));
}

var _excluded$rY = ["size", "color", "stroke"];

function IconArrowRotaryFirstLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-rotary-first-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    transform: "matrix(-1 0 0 1 32 0)",
    cx: 16,
    cy: 7,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 10v10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.5 9.5l-8.5 8.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 18h-5v-5"
  }));
}

var _excluded$rX = ["size", "color", "stroke"];

function IconArrowRotaryFirstRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-rotary-first-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 8,
    cy: 7,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 10v10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.5 9.5l8.5 8.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 18h5v-5"
  }));
}

var _excluded$rW = ["size", "color", "stroke"];

function IconArrowRotaryLastLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-rotary-last-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    transform: "matrix(-1 0 0 1 30 0)",
    cx: 15,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 15v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.5 9.5l-6.5 -6.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 3h-5v5"
  }));
}

var _excluded$rV = ["size", "color", "stroke"];

function IconArrowRotaryLastRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-rotary-last-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 9,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 15v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.5 9.5l6.5 -6.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 3h5v5"
  }));
}

var _excluded$rU = ["size", "color", "stroke"];

function IconArrowRotaryLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-rotary-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    transform: "matrix(-1 0 0 1 32 0)",
    cx: 16,
    cy: 7,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 10v10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 7h-10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 11l-4 -4l4 -4"
  }));
}

var _excluded$rT = ["size", "color", "stroke"];

function IconArrowRotaryRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-rotary-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 8,
    cy: 7,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 10v10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 11l4 -4l-4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7h10"
  }));
}

var _excluded$rS = ["size", "color", "stroke"];

function IconArrowRotaryStraight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-rotary-straight",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 13,
    cy: 13,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 16v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 3v7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 7l4 -4l4 4"
  }));
}

var _excluded$rR = ["size", "color", "stroke"];

function IconArrowSharpTurnLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-sharp-turn-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 18v-11.31a0.7 .7 0 0 0 -1.195 -.495l-9.805 9.805"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 16h-5v-5"
  }));
}

var _excluded$rQ = ["size", "color", "stroke"];

function IconArrowSharpTurnRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-sharp-turn-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 18v-11.31a0.7 .7 0 0 1 1.195 -.495l9.805 9.805"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 16h5v-5"
  }));
}

var _excluded$rP = ["size", "color", "stroke"];

function IconArrowTopBar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-top-bar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 21,
    x2: 12,
    y2: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 6l-3 -3l-3 3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 21,
    x2: 15,
    y2: 21
  }));
}

var _excluded$rO = ["size", "color", "stroke"];

function IconArrowTopCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-top-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 17,
    x2: 12,
    y2: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 6l-3 -3l-3 3"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 19,
    r: 2
  }));
}

var _excluded$rN = ["size", "color", "stroke"];

function IconArrowTopSquare(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-top-square",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 17,
    x2: 12,
    y2: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 6l-3 -3l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 21v-4h4v4z"
  }));
}

var _excluded$rM = ["size", "color", "stroke"];

function IconArrowTopTail(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-top-tail",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 18,
    x2: 12,
    y2: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 6l-3 -3l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 21l-3 -3l-3 3"
  }));
}

var _excluded$rL = ["size", "color", "stroke"];

function IconArrowUpCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-up-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 8,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 12,
    x2: 12,
    y2: 8
  }));
}

var _excluded$rK = ["size", "color", "stroke"];

function IconArrowUpLeftCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-up-left-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 9,
    x2: 15,
    y2: 15
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "15 9 9 9 9 15"
  }));
}

var _excluded$rJ = ["size", "color", "stroke"];

function IconArrowUpLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-up-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 7,
    x2: 17,
    y2: 17
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "16 7 7 7 7 16"
  }));
}

var _excluded$rI = ["size", "color", "stroke"];

function IconArrowUpRightCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-up-right-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 9,
    x2: 9,
    y2: 15
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "15 15 15 9 9 9"
  }));
}

var _excluded$rH = ["size", "color", "stroke"];

function IconArrowUpRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-up-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 7,
    x2: 7,
    y2: 17
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 7 17 7 17 16"
  }));
}

var _excluded$rG = ["size", "color", "stroke"];

function IconArrowUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 5,
    x2: 12,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 11,
    x2: 12,
    y2: 5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 11,
    x2: 12,
    y2: 5
  }));
}

var _excluded$rF = ["size", "color", "stroke"];

function IconArrowWaveLeftDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-wave-left-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 13.998h-4v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 11.998c-.887 1.284 -2.48 2.033 -4 2c-1.52 .033 -3.113 -.716 -4 -2s-2.48 -2.033 -4 -2c-1.52 -.033 -3 1 -4 2l-2 2"
  }));
}

var _excluded$rE = ["size", "color", "stroke"];

function IconArrowWaveLeftUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-wave-left-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 9.996h-4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 11.996c-.887 -1.285 -2.48 -2.033 -4 -2c-1.52 -.033 -3.113 .715 -4 2c-.887 1.284 -2.48 2.033 -4 2c-1.52 .033 -3 -1 -4 -2l-2 -2"
  }));
}

var _excluded$rD = ["size", "color", "stroke"];

function IconArrowWaveRightDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-wave-right-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 13.998h4v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 11.998c.887 1.284 2.48 2.033 4 2c1.52 .033 3.113 -.716 4 -2s2.48 -2.033 4 -2c1.52 -.033 3 1 4 2l2 2"
  }));
}

var _excluded$rC = ["size", "color", "stroke"];

function IconArrowWaveRightUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrow-wave-right-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 10h4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12c.887 -1.284 2.48 -2.033 4 -2c1.52 -.033 3.113 .716 4 2s2.48 2.033 4 2c1.52 .033 3 -1 4 -2l2 -2"
  }));
}

var _excluded$rB = ["size", "color", "stroke"];

function IconArrowsCross(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-cross",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4h4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 9l5 -5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20l5 -5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20h4v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 4l16 16"
  }));
}

var _excluded$rA = ["size", "color", "stroke"];

function IconArrowsDiagonal2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-diagonal-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "16 20 20 20 20 16"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 14,
    x2: 20,
    y2: 20
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 4 4 4 4 8"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 10,
    y2: 10
  }));
}

var _excluded$rz = ["size", "color", "stroke"];

function IconArrowsDiagonalMinimize2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-diagonal-minimize-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 10h-4v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4l-6 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 14h4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 14l-6 6"
  }));
}

var _excluded$ry = ["size", "color", "stroke"];

function IconArrowsDiagonalMinimize(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ry);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-diagonal-minimize",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 10h4v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 4l6 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 14h-4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 14l6 6"
  }));
}

var _excluded$rx = ["size", "color", "stroke"];

function IconArrowsDiagonal(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rx);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-diagonal",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "16 4 20 4 20 8"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 10,
    x2: 20,
    y2: 4
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 20 4 20 4 16"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 10,
    y2: 14
  }));
}

var _excluded$rw = ["size", "color", "stroke"];

function IconArrowsDoubleNeSw(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-double-ne-sw",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 14l11 -11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 3h4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 17v4h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 10l-11 11"
  }));
}

var _excluded$rv = ["size", "color", "stroke"];

function IconArrowsDoubleNwSe(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-double-nw-se",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 21l-11 -11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 14v-4h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 14h4v-4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 3,
    x2: 21,
    y2: 14
  }));
}

var _excluded$ru = ["size", "color", "stroke"];

function IconArrowsDoubleSeNw(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ru);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-double-se-nw",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 10,
    x2: 14,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 17v4h-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 3h-4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 14l-11 -11"
  }));
}

var _excluded$rt = ["size", "color", "stroke"];

function IconArrowsDoubleSwNe(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rt);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-double-sw-ne",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 3l-11 11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 10v4h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 10h4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 21l11 -11"
  }));
}

var _excluded$rs = ["size", "color", "stroke"];

function IconArrowsDownUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rs);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-down-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 3,
    x2: 17,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 18l-3 3l-3 -3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 21,
    x2: 7,
    y2: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 6l-3 -3l-3 3"
  }));
}

var _excluded$rr = ["size", "color", "stroke"];

function IconArrowsDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 21,
    x2: 7,
    y2: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 18l-3 3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 18l3 3l3 -3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 21,
    x2: 17,
    y2: 3
  }));
}

var _excluded$rq = ["size", "color", "stroke"];

function IconArrowsHorizontal(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-horizontal",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 8 3 12 7 16"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "17 8 21 12 17 16"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 12,
    x2: 21,
    y2: 12
  }));
}

var _excluded$rp = ["size", "color", "stroke"];

function IconArrowsJoin2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rp);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-join-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 7h1.948c1.913 0 3.705 .933 4.802 2.5a5.861 5.861 0 0 0 4.802 2.5h6.448"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 17h1.95a5.854 5.854 0 0 0 4.798 -2.5a5.854 5.854 0 0 1 4.798 -2.5h5.454"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l3 -3l-3 -3"
  }));
}

var _excluded$ro = ["size", "color", "stroke"];

function IconArrowsJoin(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ro);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-join",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 7h5l3.5 5h9.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 17h5l3.495 -5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l3 -3l-3 -3"
  }));
}

var _excluded$rn = ["size", "color", "stroke"];

function IconArrowsLeftDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rn);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-left-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 3l-4 4l4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 7h11a3 3 0 0 1 3 3v11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 17l4 4l4 -4"
  }));
}

var _excluded$rm = ["size", "color", "stroke"];

function IconArrowsLeftRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rm);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-left-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 17,
    x2: 3,
    y2: 17
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 10l-3 -3l3 -3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 7,
    x2: 21,
    y2: 7
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 20l3 -3l-3 -3"
  }));
}

var _excluded$rl = ["size", "color", "stroke"];

function IconArrowsLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rl);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 7,
    x2: 21,
    y2: 7
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 20l-3 -3l3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 4l-3 3l3 3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 17,
    x2: 21,
    y2: 17
  }));
}

var _excluded$rk = ["size", "color", "stroke"];

function IconArrowsMaximize(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-maximize",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "16 4 20 4 20 8"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 10,
    x2: 20,
    y2: 4
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 20 4 20 4 16"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 10,
    y2: 14
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "16 20 20 20 20 16"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 14,
    x2: 20,
    y2: 20
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 4 4 4 4 8"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 10,
    y2: 10
  }));
}

var _excluded$rj = ["size", "color", "stroke"];

function IconArrowsMinimize(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-minimize",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "5 9 9 9 9 5"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 9,
    y2: 9
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "5 15 9 15 9 19"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 9,
    y2: 15
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "19 9 15 9 15 5"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 9,
    x2: 21,
    y2: 3
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "19 15 15 15 15 19"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 15,
    x2: 21,
    y2: 21
  }));
}

var _excluded$ri = ["size", "color", "stroke"];

function IconArrowsRandom(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ri);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-random",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 21.004h-4v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 21.004l5 -5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.5 9.504l-3.5 -2l2 -3.504"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 7.504l6.83 -1.87"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16.004l4 -1l1 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 15.004l-3.5 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 5.004l-.5 4l-4 -.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.5 9.004l-4.5 -5.5"
  }));
}

var _excluded$rh = ["size", "color", "stroke"];

function IconArrowsRightDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rh);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-right-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 17l4 4l4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 21v-11a3 3 0 0 1 3 -3h11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 11l4 -4l-4 -4"
  }));
}

var _excluded$rg = ["size", "color", "stroke"];

function IconArrowsRightLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rg);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-right-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 7,
    x2: 3,
    y2: 7
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 10l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 20l-3 -3l3 -3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 17,
    x2: 21,
    y2: 17
  }));
}

var _excluded$rf = ["size", "color", "stroke"];

function IconArrowsRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 17,
    x2: 3,
    y2: 17
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 4l3 3l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 20l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 7,
    x2: 3,
    y2: 7
  }));
}

var _excluded$re = ["size", "color", "stroke"];

function IconArrowsShuffle2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$re);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-shuffle-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 4l3 3l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 20l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 7h3a5 5 0 0 1 5 5a5 5 0 0 0 5 5h5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 17h3a5 5 0 0 0 5 -5a5 5 0 0 1 5 -5h5"
  }));
}

var _excluded$rd = ["size", "color", "stroke"];

function IconArrowsShuffle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rd);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-shuffle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 4l3 3l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 20l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 7h3a5 5 0 0 1 5 5a5 5 0 0 0 5 5h5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 7h-5a4.978 4.978 0 0 0 -2.998 .998m-4.002 8.003a4.984 4.984 0 0 1 -3 .999h-3"
  }));
}

var _excluded$rc = ["size", "color", "stroke"];

function IconArrowsSort(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-sort",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 9l4 -4l4 4m-4 -4v14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 15l-4 4l-4 -4m4 4v-14"
  }));
}

var _excluded$rb = ["size", "color", "stroke"];

function IconArrowsSplit2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$rb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-split-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 17h-5.397a5 5 0 0 1 -4.096 -2.133l-.514 -.734a5 5 0 0 0 -4.096 -2.133h-3.897"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 7h-5.395a5 5 0 0 0 -4.098 2.135l-.51 .73a5 5 0 0 1 -4.097 2.135h-3.9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 10l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 20l3 -3l-3 -3"
  }));
}

var _excluded$ra = ["size", "color", "stroke"];

function IconArrowsSplit(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ra);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-split",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 17h-8l-3.5 -5h-6.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 7h-8l-3.495 5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 10l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 20l3 -3l-3 -3"
  }));
}

var _excluded$r9 = ["size", "color", "stroke"];

function IconArrowsUpDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-up-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 3,
    x2: 7,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 6l-3 -3l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 18l-3 3l-3 -3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 21,
    x2: 17,
    y2: 3
  }));
}

var _excluded$r8 = ["size", "color", "stroke"];

function IconArrowsUpLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-up-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 7l-4 -4l-4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 3v11a3 3 0 0 1 -3 3h-11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 13l-4 4l4 4"
  }));
}

var _excluded$r7 = ["size", "color", "stroke"];

function IconArrowsUpRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-up-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 21l4 -4l-4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 17h-11a3 3 0 0 1 -3 -3v-11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7l-4 -4l-4 4"
  }));
}

var _excluded$r6 = ["size", "color", "stroke"];

function IconArrowsUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 3,
    x2: 17,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6l3 -3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 6l-3 -3l-3 3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 3,
    x2: 7,
    y2: 21
  }));
}

var _excluded$r5 = ["size", "color", "stroke"];

function IconArrowsVertical(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-arrows-vertical",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 7 12 3 16 7"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 17 12 21 16 17"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 3,
    x2: 12,
    y2: 21
  }));
}

var _excluded$r4 = ["size", "color", "stroke"];

function IconArtboardOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-artboard-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 8h3a1 1 0 0 1 1 1v3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.716 15.698a0.997 .997 0 0 1 -.716 .302h-6a1 1 0 0 1 -1 -1v-6c0 -.273 .11 -.52 .287 -.7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 8h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 16h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 3v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 3v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 8h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 16h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 20v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$r3 = ["size", "color", "stroke"];

function IconArtboard(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-artboard",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 8,
    y: 8,
    width: 8,
    height: 8,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 8,
    x2: 4,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 16,
    x2: 4,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 3,
    x2: 8,
    y2: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 3,
    x2: 16,
    y2: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 8,
    x2: 21,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 16,
    x2: 21,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 8,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 20,
    x2: 16,
    y2: 21
  }));
}

var _excluded$r2 = ["size", "color", "stroke"];

function IconAspectRatioOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-aspect-ratio-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h10a2 2 0 0 1 2 2v10m-2 2h-14a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 12v-3h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 12v1m-2 2h-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$r1 = ["size", "color", "stroke"];

function IconAspectRatio(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-aspect-ratio",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 5,
    width: 18,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 12v-3h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 12v3h-3"
  }));
}

var _excluded$r0 = ["size", "color", "stroke"];

function IconAsteriskSimple(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$r0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-asterisk-simple",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v-9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-9 -2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l9 -2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l6 8.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-6 8.5"
  }));
}

var _excluded$q$ = ["size", "color", "stroke"];

function IconAsterisk(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-asterisk",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l8 -4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-8 -4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l8 4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-8 4.5"
  }));
}

var _excluded$q_ = ["size", "color", "stroke"];

function IconAtOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-at-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.174 9.17a4 4 0 0 0 5.646 5.668m1.18 -2.838a4 4 0 0 0 -4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.695 15.697a2.5 2.5 0 0 0 1.305 -2.197v-1.5a9 9 0 0 0 -13.055 -8.047m-2.322 1.683a9 9 0 0 0 9.877 14.644"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qZ = ["size", "color", "stroke"];

function IconAt(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-at",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 12v1.5a2.5 2.5 0 0 0 5 0v-1.5a9 9 0 1 0 -5.5 8.28"
  }));
}

var _excluded$qY = ["size", "color", "stroke"];

function IconAtom2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-atom-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 21,
    x2: 12,
    y2: 21.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 9,
    x2: 3,
    y2: 9.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 9,
    x2: 21,
    y2: 9.01
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 20.1a9 9 0 0 1 -5 -7.1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20.1a9 9 0 0 0 5 -7.1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.2 5a9 9 0 0 1 11.4 0"
  }));
}

var _excluded$qX = ["size", "color", "stroke"];

function IconAtomOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-atom-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.172 9.172c-3.906 3.905 -5.805 8.337 -4.243 9.9c1.562 1.561 5.994 -.338 9.9 -4.244m1.884 -2.113c2.587 -3.277 3.642 -6.502 2.358 -7.786c-1.284 -1.284 -4.508 -.23 -7.784 2.357"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.929 4.929c-1.562 1.562 .337 5.994 4.243 9.9c3.905 3.905 8.337 5.804 9.9 4.242m-.072 -4.071c-.767 -1.794 -2.215 -3.872 -4.172 -5.828c-1.944 -1.945 -4.041 -3.402 -5.828 -4.172"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qW = ["size", "color", "stroke"];

function IconAtom(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-atom",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 2a4 10 0 0 0 -4 10a4 10 0 0 0 4 10a4 10 0 0 0 4 -10a4 10 0 0 0 -4 -10",
    transform: "rotate(45 12 12)"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 2a4 10 0 0 0 -4 10a4 10 0 0 0 4 10a4 10 0 0 0 4 -10a4 10 0 0 0 -4 -10",
    transform: "rotate(-45 12 12)"
  }));
}

var _excluded$qV = ["size", "color", "stroke"];

function IconAugmentedReality(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-augmented-reality",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8v-2a2 2 0 0 1 2 -2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16v2a2 2 0 0 0 2 2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4h2a2 2 0 0 1 2 2v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20h2a2 2 0 0 0 2 -2v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12.5l4 -2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 10l4 2.5v4.5l4 -2.5v-4.5l-4 -2.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 10v4.5l4 2.5"
  }));
}

var _excluded$qU = ["size", "color", "stroke"];

function IconAwardOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-award-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.72 12.704a6 6 0 0 0 -8.433 -8.418m-1.755 2.24a6 6 0 0 0 7.936 7.944"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.002 15.003l3.4 5.89l1.598 -3.233l.707 .046m1.108 -2.902l-1.617 -2.8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.802 12.003l-3.4 5.89l3.598 -.233l1.598 3.232l3.4 -5.889"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qT = ["size", "color", "stroke"];

function IconAward(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-award",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 9,
    r: 6
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "9 14.2 9 21 12 19 15 21 15 14.2",
    transform: "rotate(-30 12 9)"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "9 14.2 9 21 12 19 15 21 15 14.2",
    transform: "rotate(30 12 9)"
  }));
}

var _excluded$qS = ["size", "color", "stroke"];

function IconAxe(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-axe",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 9l7.383 7.418c.823 .82 .823 2.148 0 2.967a2.11 2.11 0 0 1 -2.976 0l-7.407 -7.385"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.66 15.66l-3.32 -3.32a1.25 1.25 0 0 1 .42 -2.044l3.24 -1.296l6 -6l3 3l-6 6l-1.296 3.24a1.25 1.25 0 0 1 -2.044 .42z"
  }));
}

var _excluded$qR = ["size", "color", "stroke"];

function IconAxisX(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-axis-x",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 13v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 9v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 5v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 20l3 -3l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 17h16"
  }));
}

var _excluded$qQ = ["size", "color", "stroke"];

function IconAxisY(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-axis-y",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 20h-.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 20h-.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 20h-.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 7l3 -3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 20v-16"
  }));
}

var _excluded$qP = ["size", "color", "stroke"];

function IconBabyCarriage(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-baby-carriage",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 8,
    cy: 19,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18,
    cy: 19,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2 5h2.5l1.632 4.897a6 6 0 0 0 5.693 4.103h2.675a5.5 5.5 0 0 0 0 -11h-.5v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 9h14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17l1 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 14l1 3"
  }));
}

var _excluded$qO = ["size", "color", "stroke"];

function IconBackhoe(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-backhoe",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 4,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 13,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 19,
    x2: 4,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 15,
    x2: 13,
    y2: 15
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 12v-5h2a3 3 0 0 1 3 3v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 15v-2a1 1 0 0 1 1 -1h7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21.12 9.88l-3.12 -4.88l-5 5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21.12 9.88a3 3 0 0 1 -2.12 5.12a3 3 0 0 1 -2.12 -.88l4.24 -4.24z"
  }));
}

var _excluded$qN = ["size", "color", "stroke"];

function IconBackpack(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-backpack",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7h2a6 6 0 0 1 6 6v6a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-6a6 6 0 0 1 6 -6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 7v-1a2 2 0 1 1 4 0v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 15h4"
  }));
}

var _excluded$qM = ["size", "color", "stroke"];

function IconBackspace(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-backspace",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 6a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-11l-5 -5a1.5 1.5 0 0 1 0 -2l5 -5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 10l4 4m0 -4l-4 4"
  }));
}

var _excluded$qL = ["size", "color", "stroke"];

function IconBadgeOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-badge-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 7v10l5 3l5 -3m0 -4v-9l-5 3l-2.496 -1.497"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qK = ["size", "color", "stroke"];

function IconBadge(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-badge",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v-13l-5 3l-5 -3v13l5 3z"
  }));
}

var _excluded$qJ = ["size", "color", "stroke"];

function IconBadgesOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-badges-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.505 14.497l-2.505 1.503l-5 -3v4l5 3l5 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.873 9.876l3.127 -1.876v-4l-5 3l-2.492 -1.495m-2.508 1.495v1l2.492 1.495"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qI = ["size", "color", "stroke"];

function IconBadges(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-badges",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v-4l-5 3l-5 -3v4l5 3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 8v-4l-5 3l-5 -3v4l5 3z"
  }));
}

var _excluded$qH = ["size", "color", "stroke"];

function IconBallAmericanFootball(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ball-american-football",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 9,
    x2: 9,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 12,
    x2: 12,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 10,
    x2: 14,
    y2: 12
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 21a5 5 0 0 0 -5 -5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 3c-7.18 0 -13 5.82 -13 13a5 5 0 0 0 5 5c7.18 0 13 -5.82 13 -13a5 5 0 0 0 -5 -5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 3a5 5 0 0 0 5 5"
  }));
}

var _excluded$qG = ["size", "color", "stroke"];

function IconBallBaseball(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ball-baseball",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.636 18.364a9 9 0 1 0 12.728 -12.728a9 9 0 0 0 -12.728 12.728z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.495 3.02a9 9 0 0 1 -9.475 9.475"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.98 11.505a9 9 0 0 0 -9.475 9.475"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 9l2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 13l2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7l2 1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 11l1 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 11l1 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 16l2 1"
  }));
}

var _excluded$qF = ["size", "color", "stroke"];

function IconBallBasketball(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ball-basketball",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5.65,
    y1: 5.65,
    x2: 18.35,
    y2: 18.35
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5.65,
    y1: 18.35,
    x2: 18.35,
    y2: 5.65
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3a9 9 0 0 0 9 9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12a9 9 0 0 1 9 9"
  }));
}

var _excluded$qE = ["size", "color", "stroke"];

function IconBallBowling(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ball-bowling",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 11,
    y1: 9,
    x2: 11,
    y2: 9.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 8,
    x2: 15,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 12,
    x2: 14,
    y2: 12.01
  }));
}

var _excluded$qD = ["size", "color", "stroke"];

function IconBallFootballOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ball-football-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.041 16.046a9 9 0 0 0 -12.084 -12.09m-2.323 1.683a9 9 0 0 0 12.726 12.73"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7l4.755 3.455l-.566 1.743l-.98 3.014l-.209 .788h-6l-1.755 -5.545l1.86 -1.351l2.313 -1.681z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7v-4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 16,
    x2: 17.5,
    y2: 19
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.755 10.455l3.745 -1.455"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.061 16.045l-2.561 2.955"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.245 10.455l-3.745 -1.455"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }));
}

var _excluded$qC = ["size", "color", "stroke"];

function IconBallFootball(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ball-football",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7l4.76 3.45l-1.76 5.55h-6l-1.76 -5.55z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7v-4m3 13l2.5 3m-.74 -8.55l3.74 -1.45m-11.44 7.05l-2.56 2.95m.74 -8.55l-3.74 -1.45"
  }));
}

var _excluded$qB = ["size", "color", "stroke"];

function IconBallTennis(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ball-tennis",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 5.3a9 9 0 0 1 0 13.4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 5.3a9 9 0 0 0 0 13.4"
  }));
}

var _excluded$qA = ["size", "color", "stroke"];

function IconBallVolleyball(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ball-volleyball",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12a8 8 0 0 0 8 4m-12.5 -2.5a12 12 0 0 0 8.5 6.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12a8 8 0 0 0 8 4m-12.5 -2.5a12 12 0 0 0 8.5 6.5",
    transform: "rotate(120 12 12)"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12a8 8 0 0 0 8 4m-12.5 -2.5a12 12 0 0 0 8.5 6.5",
    transform: "rotate(240 12 12)"
  }));
}

var _excluded$qz = ["size", "color", "stroke"];

function IconBallonOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ballon-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 8a2 2 0 0 0 -2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.762 3.753a6 6 0 0 1 10.238 4.247c0 1.847 -.37 3.564 -1.007 4.993m-1.59 2.42c-.967 1.001 -2.14 1.587 -3.403 1.587c-3.314 0 -6 -4.03 -6 -9c0 -.593 .086 -1.166 .246 -1.707"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 17v1a2 2 0 0 1 -2 2h-3a2 2 0 0 0 -2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qy = ["size", "color", "stroke"];

function IconBallon(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qy);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ballon",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 8a2 2 0 0 0 -2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 8a6 6 0 1 1 12 0c0 4.97 -2.686 9 -6 9s-6 -4.03 -6 -9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 17v1a2 2 0 0 1 -2 2h-3a2 2 0 0 0 -2 2"
  }));
}

var _excluded$qx = ["size", "color", "stroke"];

function IconBallpenOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qx);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ballpen-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 6l7 7l-2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 10l-4.172 4.172a2.828 2.828 0 1 0 4 4l4.172 -4.172"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 12l4.414 -4.414a2 2 0 0 0 0 -2.829l-1.171 -1.171a2 2 0 0 0 -2.829 0l-4.414 4.414"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20l1.768 -1.768"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qw = ["size", "color", "stroke"];

function IconBallpen(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ballpen",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 6l7 7l-4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.828 18.172a2.828 2.828 0 0 0 4 0l10.586 -10.586a2 2 0 0 0 0 -2.829l-1.171 -1.171a2 2 0 0 0 -2.829 0l-10.586 10.586a2.828 2.828 0 0 0 0 4z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20l1.768 -1.768"
  }));
}

var _excluded$qv = ["size", "color", "stroke"];

function IconBan(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ban",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5.7,
    y1: 5.7,
    x2: 18.3,
    y2: 18.3
  }));
}

var _excluded$qu = ["size", "color", "stroke"];

function IconBandage(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qu);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bandage",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 12,
    x2: 14,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 12,
    x2: 10,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 10,
    x2: 12,
    y2: 10.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 14,
    x2: 12,
    y2: 14.01
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.5 12.5l8 -8a4.94 4.94 0 0 1 7 7l-8 8a4.94 4.94 0 0 1 -7 -7"
  }));
}

var _excluded$qt = ["size", "color", "stroke"];

function IconBarbellOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qt);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-barbell-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2 12h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 8h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.298 6.288a0.997 .997 0 0 0 -.298 .712v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 15v2a1 1 0 0 0 1 1h1c.275 0 .523 -.11 .704 -.29m.296 -3.71v-7a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 8h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M22 12h-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qs = ["size", "color", "stroke"];

function IconBarbell(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qs);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-barbell",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2 12h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 8h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 7v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-10a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 7v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-10a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 8h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M22 12h-1"
  }));
}

var _excluded$qr = ["size", "color", "stroke"];

function IconBarcodeOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-barcode-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 7v-1c0 -.552 .224 -1.052 .586 -1.414"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 17v1a2 2 0 0 0 2 2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4h2a2 2 0 0 1 2 2v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20h2c.551 0 1.05 -.223 1.412 -.584"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 11h1v2h-1z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 11v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 11v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 11v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qq = ["size", "color", "stroke"];

function IconBarcode(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-barcode",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 7v-1a2 2 0 0 1 2 -2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 17v1a2 2 0 0 0 2 2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4h2a2 2 0 0 1 2 2v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20h2a2 2 0 0 0 2 -2v-1"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 5,
    y: 11,
    width: 1,
    height: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 11,
    x2: 10,
    y2: 13
  }), /*#__PURE__*/React.createElement("rect", {
    x: 14,
    y: 11,
    width: 1,
    height: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 19,
    y1: 11,
    x2: 19,
    y2: 13
  }));
}

var _excluded$qp = ["size", "color", "stroke"];

function IconBarrelOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qp);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-barrel-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4h8.722a2 2 0 0 1 1.841 1.22c.958 2.26 1.437 4.52 1.437 6.78a16.35 16.35 0 0 1 -.407 3.609m-.964 3.013l-.066 .158a2 2 0 0 1 -1.841 1.22h-9.444a2 2 0 0 1 -1.841 -1.22c-.958 -2.26 -1.437 -4.52 -1.437 -6.78c0 -2.21 .458 -4.42 1.374 -6.63"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 4c.585 2.337 .913 4.674 .985 7.01m-.114 3.86a33.415 33.415 0 0 1 -.871 5.13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 4a34.42 34.42 0 0 0 -.366 1.632m-.506 3.501a32.126 32.126 0 0 0 -.128 2.867c0 2.667 .333 5.333 1 8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.5 16h11.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.5 8h-7.5m-4 0h-3.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qo = ["size", "color", "stroke"];

function IconBarrel(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qo);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-barrel",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.278 4h9.444a2 2 0 0 1 1.841 1.22c.958 2.26 1.437 4.52 1.437 6.78c0 2.26 -.479 4.52 -1.437 6.78a2 2 0 0 1 -1.841 1.22h-9.444a2 2 0 0 1 -1.841 -1.22c-.958 -2.26 -1.437 -4.52 -1.437 -6.78c0 -2.26 .479 -4.52 1.437 -6.78a2 2 0 0 1 1.841 -1.22z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 4c.667 2.667 1 5.333 1 8s-.333 5.333 -1 8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 4c-.667 2.667 -1 5.333 -1 8s.333 5.333 1 8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.5 16h15"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.5 8h-15"
  }));
}

var _excluded$qn = ["size", "color", "stroke"];

function IconBarrierBlockOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qn);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-barrier-block-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7h8a1 1 0 0 1 1 1v7c0 .27 -.107 .516 -.282 .696"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 16h-11a1 1 0 0 1 -1 -1v-7a1 1 0 0 1 1 -1h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 16v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.5 16l4.244 -4.244"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.745 9.755l2.755 -2.755"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.5 16l1.249 -1.249"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.741 12.759l3.259 -3.259"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 13.5l4.752 -4.752"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 20h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 20h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 7v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qm = ["size", "color", "stroke"];

function IconBarrierBlock(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qm);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-barrier-block",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 7,
    width: 16,
    height: 9,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 16v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.5 16l9 -9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.5 16l6.5 -6.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 13.5l6.5 -6.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 16v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 20h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 20h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 7v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 7v-2"
  }));
}

var _excluded$ql = ["size", "color", "stroke"];

function IconBaseline(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ql);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-baseline",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20h16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16v-8a4 4 0 1 1 8 0v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 10h8"
  }));
}

var _excluded$qk = ["size", "color", "stroke"];

function IconBasketOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-basket-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 10l1.359 -1.63"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.176 6.188l1.824 -2.188l5 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18.77 18.757c-.358 .768 -1.027 1.262 -1.77 1.243h-10c-.966 .024 -1.807 -.817 -2 -2l-2 -8h7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 10h7l-1.397 5.587"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 15,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qj = ["size", "color", "stroke"];

function IconBasket(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-basket",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 10 12 4 17 10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 10l-2 8a2 2.5 0 0 1 -2 2h-10a2 2.5 0 0 1 -2 -2l-2 -8z"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 15,
    r: 2
  }));
}

var _excluded$qi = ["size", "color", "stroke"];

function IconBathOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qi);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bath-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 12h4a1 1 0 0 1 1 1v3c0 .311 -.036 .614 -.103 .904m-1.61 2.378a3.982 3.982 0 0 1 -2.287 .718h-10a4 4 0 0 1 -4 -4v-3a1 1 0 0 1 1 -1h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12v-6m1.178 -2.824c.252 -.113 .53 -.176 .822 -.176h3v2.25"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 21l1 -1.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 21l-1 -1.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$qh = ["size", "color", "stroke"];

function IconBath(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qh);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bath",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12h16a1 1 0 0 1 1 1v3a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4v-3a1 1 0 0 1 1 -1z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12v-7a2 2 0 0 1 2 -2h3v2.25"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 21l1 -1.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 21l-1 -1.5"
  }));
}

var _excluded$qg = ["size", "color", "stroke"];

function IconBattery1(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qg);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery-1",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 7h11a2 2 0 0 1 2 2v.5a0.5 .5 0 0 0 .5 .5a0.5 .5 0 0 1 .5 .5v3a0.5 .5 0 0 1 -.5 .5a0.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 10,
    x2: 7,
    y2: 14
  }));
}

var _excluded$qf = ["size", "color", "stroke"];

function IconBattery2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 7h11a2 2 0 0 1 2 2v.5a0.5 .5 0 0 0 .5 .5a0.5 .5 0 0 1 .5 .5v3a0.5 .5 0 0 1 -.5 .5a0.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 10,
    x2: 7,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 10,
    x2: 10,
    y2: 14
  }));
}

var _excluded$qe = ["size", "color", "stroke"];

function IconBattery3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qe);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 7h11a2 2 0 0 1 2 2v.5a0.5 .5 0 0 0 .5 .5a0.5 .5 0 0 1 .5 .5v3a0.5 .5 0 0 1 -.5 .5a0.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 10,
    x2: 7,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 10,
    x2: 10,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 10,
    x2: 13,
    y2: 14
  }));
}

var _excluded$qd = ["size", "color", "stroke"];

function IconBattery4(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qd);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery-4",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 7h11a2 2 0 0 1 2 2v.5a0.5 .5 0 0 0 .5 .5a0.5 .5 0 0 1 .5 .5v3a0.5 .5 0 0 1 -.5 .5a0.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 10,
    x2: 7,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 10,
    x2: 10,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 10,
    x2: 13,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 10,
    x2: 16,
    y2: 14
  }));
}

var _excluded$qc = ["size", "color", "stroke"];

function IconBatteryAutomotive(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery-automotive",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 6,
    width: 18,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 6v-2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 19,
    y1: 4,
    x2: 19,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6.5,
    y1: 13,
    x2: 9.5,
    y2: 13
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14.5,
    y1: 13,
    x2: 17.5,
    y2: 13
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 11.5,
    x2: 16,
    y2: 14.5
  }));
}

var _excluded$qb = ["size", "color", "stroke"];

function IconBatteryCharging2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery-charging-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 9a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a0.5 .5 0 0 0 .5 .5a0.5 .5 0 0 1 .5 .5v3a0.5 .5 0 0 1 -.5 .5a0.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 15h6v2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2v-2z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 22v-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 15v-2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 15v-2.5"
  }));
}

var _excluded$qa = ["size", "color", "stroke"];

function IconBatteryCharging(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$qa);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery-charging",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 7h1a2 2 0 0 1 2 2v.5a0.5 .5 0 0 0 .5 .5a0.5 .5 0 0 1 .5 .5v3a0.5 .5 0 0 1 -.5 .5a0.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 7h-2a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 8l-2 4h3l-2 4"
  }));
}

var _excluded$q9 = ["size", "color", "stroke"];

function IconBatteryEco(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery-eco",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 9a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a0.5 .5 0 0 0 .5 .5a0.5 .5 0 0 1 .5 .5v3a0.5 .5 0 0 1 -.5 .5a0.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 16.143c0 -2.84 2.09 -5.143 4.667 -5.143h2.333v.857c0 2.84 -2.09 5.143 -4.667 5.143h-2.333v-.857z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 20v-3"
  }));
}

var _excluded$q8 = ["size", "color", "stroke"];

function IconBatteryOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7h6a2 2 0 0 1 2 2v.5a0.5 .5 0 0 0 .5 .5a0.5 .5 0 0 1 .5 .5v3a0.5 .5 0 0 1 -.5 .5a0.5 .5 0 0 0 -.5 .5v.5m-2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2h1"
  }));
}

var _excluded$q7 = ["size", "color", "stroke"];

function IconBattery(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-battery",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 7h11a2 2 0 0 1 2 2v.5a0.5 .5 0 0 0 .5 .5a0.5 .5 0 0 1 .5 .5v3a0.5 .5 0 0 1 -.5 .5a0.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
  }));
}

var _excluded$q6 = ["size", "color", "stroke"];

function IconBeachOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-beach-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.071 15.102a7.502 7.502 0 0 0 -8.124 1.648"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.27 6.269l9.926 5.731a6 6 0 0 0 -10.32 -6.123"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.732 10c1.658 -2.87 2.225 -5.644 1.268 -6.196c-.957 -.552 -3.075 1.326 -4.732 4.196"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 9l-.739 1.279"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.794 12.82l-.794 1.376"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 19.25a2.4 2.4 0 0 1 1 -.25a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 1.135 -.858"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$q5 = ["size", "color", "stroke"];

function IconBeach(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-beach",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.553 16.75a7.5 7.5 0 0 0 -10.606 0"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 3.804a6 6 0 0 0 -8.196 2.196l10.392 6a6 6 0 0 0 -2.196 -8.196z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.732 10c1.658 -2.87 2.225 -5.644 1.268 -6.196c-.957 -.552 -3.075 1.326 -4.732 4.196"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 9l-3 5.196"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 19.25a2.4 2.4 0 0 1 1 -.25a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 1 .25"
  }));
}

var _excluded$q4 = ["size", "color", "stroke"];

function IconBedOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bed-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 7v11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 14h11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 14h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 18v-8a2 2 0 0 0 -2 -2h-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 11v3"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 10,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$q3 = ["size", "color", "stroke"];

function IconBed(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bed",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 7v11m0 -4h18m0 4v-8a2 2 0 0 0 -2 -2h-8v6"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 10,
    r: 1
  }));
}

var _excluded$q2 = ["size", "color", "stroke"];

function IconBeerOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-beer-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 7v1.111c0 1.242 .29 2.467 .845 3.578l.31 .622a8 8 0 0 1 .845 3.578v4.111h6v-4.111a8 8 0 0 1 .045 -.85m.953 -3.035l.157 -.315a7.999 7.999 0 0 0 .845 -3.578v-4.111h-9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 8h1m4 0h5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$q1 = ["size", "color", "stroke"];

function IconBeer(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-beer",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 20h6v-4.111a8 8 0 0 1 .845 -3.578l.31 -.622a8 8 0 0 0 .845 -3.578v-4.111h-10v4.111a8 8 0 0 0 .845 3.578l.31 .622a8 8 0 0 1 .845 3.578v4.111z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 8h10"
  }));
}

var _excluded$q0 = ["size", "color", "stroke"];

function IconBellMinus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$q0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bell-minus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17v1a3 3 0 0 0 6 0v-1"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 11,
    x2: 14,
    y2: 11
  }));
}

var _excluded$p$ = ["size", "color", "stroke"];

function IconBellOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bell-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17h-13a4 4 0 0 0 2 -3v-3a7 7 0 0 1 1.279 -3.716m2.072 -1.934c.209 -.127 .425 -.244 .649 -.35a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17v1a3 3 0 0 0 6 0v-1"
  }));
}

var _excluded$p_ = ["size", "color", "stroke"];

function IconBellPlus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bell-plus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17v1a3 3 0 0 0 6 0v-1"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 11,
    x2: 14,
    y2: 11
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 9,
    x2: 12,
    y2: 13
  }));
}

var _excluded$pZ = ["size", "color", "stroke"];

function IconBellRinging2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bell-ringing-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.364 4.636a2 2 0 0 1 0 2.828a7 7 0 0 1 -1.414 7.072l-2.122 2.12a4 4 0 0 0 -.707 3.536l-11.313 -11.312a4 4 0 0 0 3.535 -.707l2.121 -2.123a7 7 0 0 1 7.072 -1.414a2 2 0 0 1 2.828 0z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.343 12.414l-.707 .707a3 3 0 0 0 4.243 4.243l.707 -.707"
  }));
}

var _excluded$pY = ["size", "color", "stroke"];

function IconBellRinging(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bell-ringing",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 5a2 2 0 0 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17v1a3 3 0 0 0 6 0v-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 6.727a11.05 11.05 0 0 0 -2.794 -3.727"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 6.727a11.05 11.05 0 0 1 2.792 -3.727"
  }));
}

var _excluded$pX = ["size", "color", "stroke"];

function IconBellSchool(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bell-school",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 10,
    cy: 10,
    r: 6
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.5 15h.5a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-1a2 2 0 0 1 2 -2h.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 17a5.698 5.698 0 0 0 4.467 -7.932l-.467 -1.068"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 10v.01"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 20,
    cy: 8,
    r: 1
  }));
}

var _excluded$pW = ["size", "color", "stroke"];

function IconBellX(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bell-x",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17v1a3 3 0 0 0 6 0v-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.5 9.5l3 3m0 -3l-3 3"
  }));
}

var _excluded$pV = ["size", "color", "stroke"];

function IconBellZ(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bell-z",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17v1a3 3 0 0 0 6 0v-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 9h4l-4 4h4"
  }));
}

var _excluded$pU = ["size", "color", "stroke"];

function IconBell(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bell",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 5a2 2 0 0 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17v1a3 3 0 0 0 6 0v-1"
  }));
}

var _excluded$pT = ["size", "color", "stroke"];

function IconBible(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bible",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 4v16h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 16h-12a2 2 0 0 0 -2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 9h4"
  }));
}

var _excluded$pS = ["size", "color", "stroke"];

function IconBikeOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bike-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5,
    cy: 18,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.437 16.44a3 3 0 0 0 4.123 4.123m1.44 -2.563a3 3 0 0 0 -3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 19v-4l-3 -3l1.665 -1.332m2.215 -1.772l1.12 -.896l2 3h3"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 5,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$pR = ["size", "color", "stroke"];

function IconBike(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bike",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5,
    cy: 18,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 19,
    cy: 18,
    r: 3
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "12 19 12 15 9 12 14 8 16 11 19 11"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 5,
    r: 1
  }));
}

var _excluded$pQ = ["size", "color", "stroke"];

function IconBinary(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-binary",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 10v-5h-1m8 14v-5h-1"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 15,
    y: 5,
    width: 3,
    height: 5,
    rx: 0.5
  }), /*#__PURE__*/React.createElement("rect", {
    x: 10,
    y: 14,
    width: 3,
    height: 5,
    rx: 0.5
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 10h.01m-.01 9h.01"
  }));
}

var _excluded$pP = ["size", "color", "stroke"];

function IconBiohazardOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-biohazard-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.586 10.586a2 2 0 1 0 2.836 2.82"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.939 14c0 .173 .048 .351 .056 .533v.217a4.75 4.75 0 0 1 -4.533 4.745h-.217"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2.495 14.745a4.75 4.75 0 0 1 7.737 -3.693"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.745 19.495a4.75 4.75 0 0 1 -4.69 -5.503h-.06"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.533 10.538a4.75 4.75 0 0 1 6.957 3.987v.217"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.295 10.929a4.75 4.75 0 0 1 -2.988 -3.64m.66 -3.324a4.75 4.75 0 0 1 .5 -.66l.164 -.172"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.349 3.133a4.75 4.75 0 0 1 -.836 7.385"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$pO = ["size", "color", "stroke"];

function IconBiohazard(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-biohazard",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.939 14c0 .173 .048 .351 .056 .533l0 .217a4.75 4.75 0 0 1 -4.533 4.745l-.217 0m-4.75 -4.75a4.75 4.75 0 0 1 7.737 -3.693m6.513 8.443a4.75 4.75 0 0 1 -4.69 -5.503l-.06 0m1.764 -2.944a4.75 4.75 0 0 1 7.731 3.477l0 .217m-11.195 -3.813a4.75 4.75 0 0 1 -1.828 -7.624l.164 -.172m6.718 0a4.75 4.75 0 0 1 -1.665 7.798"
  }));
}

var _excluded$pN = ["size", "color", "stroke"];

function IconBlockquote(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-blockquote",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 15h15"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 19h-15"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 11h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 7h-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 9h1a1 1 0 1 1 -1 1v-2.5a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 9h1a1 1 0 1 1 -1 1v-2.5a2 2 0 0 1 2 -2"
  }));
}

var _excluded$pM = ["size", "color", "stroke"];

function IconBluetoothConnected(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bluetooth-connected",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 8 17 16 12 20 12 4 17 8 7 16"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 5,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 12,
    x2: 19,
    y2: 12
  }));
}

var _excluded$pL = ["size", "color", "stroke"];

function IconBluetoothOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bluetooth-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.438 16.45l-4.438 3.55v-8m0 -4v-4l5 4l-2.776 2.22m-2.222 1.779l-5 4"
  }));
}

var _excluded$pK = ["size", "color", "stroke"];

function IconBluetoothX(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bluetooth-x",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 8l10 8l-5 4v-16l1.003 .802m0 6.396l-6.003 4.802"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 6l4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 6l-4 4"
  }));
}

var _excluded$pJ = ["size", "color", "stroke"];

function IconBluetooth(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bluetooth",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 8 17 16 12 20 12 4 17 8 7 16"
  }));
}

var _excluded$pI = ["size", "color", "stroke"];

function IconBlur(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-blur",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 21a9.01 9.01 0 0 0 2.32 -.302a9.004 9.004 0 0 0 1.74 -16.733a9 9 0 1 0 -4.06 17.035z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v17"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12h9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 18h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 15h8"
  }));
}

var _excluded$pH = ["size", "color", "stroke"];

function IconBoldOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bold-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h4a3.5 3.5 0 0 1 2.222 6.204m-3.222 .796h-5v-5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.107 17.112a3.5 3.5 0 0 1 -3.107 1.888h-7v-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$pG = ["size", "color", "stroke"];

function IconBold(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bold",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 5h6a3.5 3.5 0 0 1 0 7h-6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 12h1a3.5 3.5 0 0 1 0 7h-7v-7"
  }));
}

var _excluded$pF = ["size", "color", "stroke"];

function IconBoltOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bolt-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.212 15.21l-4.212 5.79v-7h-6l3.79 -5.21m1.685 -2.32l2.525 -3.47v6m1 1h5l-2.104 2.893"
  }));
}

var _excluded$pE = ["size", "color", "stroke"];

function IconBolt(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bolt",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "13 3 13 10 19 10 11 21 11 14 5 14 13 3"
  }));
}

var _excluded$pD = ["size", "color", "stroke"];

function IconBoneOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bone-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.5 8.502l.38 -.38a3 3 0 1 1 5.12 -2.122a3 3 0 1 1 -2.12 5.122l-.372 .372m-2.008 2.008l-2.378 2.378a3 3 0 1 1 -5.117 2.297l-.005 -.177l-.176 -.005a3 3 0 1 1 2.298 -5.115l2.378 -2.378"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$pC = ["size", "color", "stroke"];

function IconBone(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bone",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 3a3 3 0 0 1 3 3a3 3 0 1 1 -2.12 5.122l-4.758 4.758a3 3 0 1 1 -5.117 2.297l-.005 -.177l-.176 -.005a3 3 0 1 1 2.298 -5.115l4.758 -4.758a3 3 0 0 1 2.12 -5.122z"
  }));
}

var _excluded$pB = ["size", "color", "stroke"];

function IconBook2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-book-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 4v16h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 16h-12a2 2 0 0 0 -2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 8h6"
  }));
}

var _excluded$pA = ["size", "color", "stroke"];

function IconBookDownload(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-book-download",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 16h-7a2 2 0 0 0 -2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 19l3 3l3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 22v-9"
  }));
}

var _excluded$pz = ["size", "color", "stroke"];

function IconBookOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-book-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 19a9 9 0 0 1 9 0a8.999 8.999 0 0 1 5.899 -1.096"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 6a8.995 8.995 0 0 1 2.114 -.884m3.8 -.21c1.07 .17 2.116 .534 3.086 1.094a9 9 0 0 1 9 0"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 6v13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6v2m0 4v7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 6v11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$py = ["size", "color", "stroke"];

function IconBookUpload(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$py);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-book-upload",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 16h-5a2 2 0 0 0 -2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 16l3 -3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 13v9"
  }));
}

var _excluded$px = ["size", "color", "stroke"];

function IconBook(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$px);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-book",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 19a9 9 0 0 1 9 0a9 9 0 0 1 9 0"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 6a9 9 0 0 1 9 0a9 9 0 0 1 9 0"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 6,
    x2: 3,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 6,
    x2: 12,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 6,
    x2: 21,
    y2: 19
  }));
}

var _excluded$pw = ["size", "color", "stroke"];

function IconBookmarkOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bookmark-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v3l-5 -3l-5 3v-13m1.178 -2.818c.252 -.113 .53 -.176 .822 -.176h6a2 2 0 0 1 2 2v7"
  }));
}

var _excluded$pv = ["size", "color", "stroke"];

function IconBookmark(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bookmark",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 4h6a2 2 0 0 1 2 2v14l-5 -3l-5 3v-14a2 2 0 0 1 2 -2"
  }));
}

var _excluded$pu = ["size", "color", "stroke"];

function IconBookmarksOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pu);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bookmarks-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7h2a2 2 0 0 1 2 2v2m0 4v6l-5 -3l-5 3v-12a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.265 4a2 2 0 0 1 1.735 -1h6a2 2 0 0 1 2 2v10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$pt = ["size", "color", "stroke"];

function IconBookmarks(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pt);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bookmarks",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 7a2 2 0 0 1 2 2v12l-5 -3l-5 3v-12a2 2 0 0 1 2 -2h6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.265 4a2 2 0 0 1 1.735 -1h6a2 2 0 0 1 2 2v12l-1 -.6"
  }));
}

var _excluded$ps = ["size", "color", "stroke"];

function IconBooksOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ps);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-books-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 9v10a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4a1 1 0 0 1 1 1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 13v6a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 8h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 16h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.254 10.244l-1.218 -4.424a1.02 1.02 0 0 1 .634 -1.219l.133 -.041l2.184 -.53c.562 -.135 1.133 .19 1.282 .732l3.236 11.75"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.585 19.589l-1.572 .38c-.562 .136 -1.133 -.19 -1.282 -.731l-.952 -3.458"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 9l4 -1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.207 15.199l.716 -.18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$pr = ["size", "color", "stroke"];

function IconBooks(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-books",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 5,
    y: 4,
    width: 4,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 4,
    width: 4,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 8h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 16h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.803 4.56l2.184 -.53c.562 -.135 1.133 .19 1.282 .732l3.695 13.418a1.02 1.02 0 0 1 -.634 1.219l-.133 .041l-2.184 .53c-.562 .135 -1.133 -.19 -1.282 -.732l-3.695 -13.418a1.02 1.02 0 0 1 .634 -1.219l.133 -.041z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 9l4 -1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 16l3.923 -.98"
  }));
}

var _excluded$pq = ["size", "color", "stroke"];

function IconBorderAll(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-all",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 20,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 20
  }));
}

var _excluded$pp = ["size", "color", "stroke"];

function IconBorderBottom(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pp);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-bottom",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 20,
    x2: 4,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 4,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 4,
    x2: 8,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 4,
    x2: 16,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 8,
    x2: 4,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 8,
    x2: 20,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 4,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 8,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 12,
    x2: 16,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 20,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 16,
    x2: 4,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 16,
    x2: 20,
    y2: 16.01
  }));
}

var _excluded$po = ["size", "color", "stroke"];

function IconBorderHorizontal(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$po);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-horizontal",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 20,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 4,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 4,
    x2: 8,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 4,
    x2: 16,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 8,
    x2: 4,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 8,
    x2: 20,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 16,
    x2: 4,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 16,
    x2: 20,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 4,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 8,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 12,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 20,
    x2: 16,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 20,
    x2: 20,
    y2: 20.01
  }));
}

var _excluded$pn = ["size", "color", "stroke"];

function IconBorderInner(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pn);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-inner",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 20,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 4,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 4,
    x2: 8,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 4,
    x2: 16,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 8,
    x2: 4,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 8,
    x2: 20,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 16,
    x2: 4,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 16,
    x2: 20,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 4,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 8,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 20,
    x2: 16,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 20,
    x2: 20,
    y2: 20.01
  }));
}

var _excluded$pm = ["size", "color", "stroke"];

function IconBorderLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pm);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 4,
    y2: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 4,
    x2: 8,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 4,
    x2: 16,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 8,
    x2: 20,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 8,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 12,
    x2: 16,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 20,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 16,
    x2: 20,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 8,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 12,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 20,
    x2: 16,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 20,
    x2: 20,
    y2: 20.01
  }));
}

var _excluded$pl = ["size", "color", "stroke"];

function IconBorderNone(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pl);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-none",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 4,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 4,
    x2: 8,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 4,
    x2: 16,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 8,
    x2: 4,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 8,
    x2: 20,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 4,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 8,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 12,
    x2: 16,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 20,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 16,
    x2: 4,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 16,
    x2: 20,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 4,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 8,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 12,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 20,
    x2: 16,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 20,
    x2: 20,
    y2: 20.01
  }));
}

var _excluded$pk = ["size", "color", "stroke"];

function IconBorderOuter(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-outer",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 8,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 12,
    x2: 16,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12,
    y2: 16.01
  }));
}

var _excluded$pj = ["size", "color", "stroke"];

function IconBorderRadius(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-radius",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v-4a4 4 0 0 1 4 -4h4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 4,
    x2: 16,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 8,
    x2: 20,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 20,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 16,
    x2: 4,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 16,
    x2: 20,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 4,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 8,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 12,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 20,
    x2: 16,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 20,
    x2: 20,
    y2: 20.01
  }));
}

var _excluded$pi = ["size", "color", "stroke"];

function IconBorderRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pi);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 4,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 4,
    x2: 8,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 4,
    x2: 16,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 8,
    x2: 4,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 4,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 8,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 12,
    x2: 16,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 16,
    x2: 4,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 4,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 8,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 12,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 20,
    x2: 16,
    y2: 20.01
  }));
}

var _excluded$ph = ["size", "color", "stroke"];

function IconBorderStyle2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ph);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-style-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 18v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 18v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 18v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 18v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 18v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 12h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 12h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6h16"
  }));
}

var _excluded$pg = ["size", "color", "stroke"];

function IconBorderStyle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pg);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-style",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20v-14a2 2 0 0 1 2 -2h14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 8v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20v.01"
  }));
}

var _excluded$pf = ["size", "color", "stroke"];

function IconBorderTop(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-top",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 20,
    y2: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 8,
    x2: 4,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 8,
    x2: 20,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 4,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 8,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 12,
    x2: 16,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 20,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 16,
    x2: 4,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 16,
    x2: 20,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 4,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 8,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 12,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 20,
    x2: 16,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 20,
    x2: 20,
    y2: 20.01
  }));
}

var _excluded$pe = ["size", "color", "stroke"];

function IconBorderVertical(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pe);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-border-vertical",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 4,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 4,
    x2: 8,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 4,
    x2: 16,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 4,
    x2: 20,
    y2: 4.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 8,
    x2: 4,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 8,
    x2: 20,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 4,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 8,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 12,
    x2: 16,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 20,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 16,
    x2: 4,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 16,
    x2: 20,
    y2: 16.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 4,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 8,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 20,
    x2: 16,
    y2: 20.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 20,
    x2: 20,
    y2: 20.01
  }));
}

var _excluded$pd = ["size", "color", "stroke"];

function IconBottle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pd);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bottle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 5h4v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 3.5c0 1.626 .507 3.212 1.45 4.537l.05 .07a8.093 8.093 0 0 1 1.5 4.694v6.199a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-6.2c0 -1.682 .524 -3.322 1.5 -4.693l.05 -.07a7.823 7.823 0 0 0 1.45 -4.537"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.003 14.803a2.4 2.4 0 0 0 .997 -.803a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 1 -.805"
  }));
}

var _excluded$pc = ["size", "color", "stroke"];

function IconBow(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bow",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 3h4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 3l-15 15"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 18h3v3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.5 20c1.576 -1.576 2.5 -4.095 2.5 -6.5c0 -4.81 -3.69 -8.5 -8.5 -8.5c-2.415 0 -4.922 .913 -6.5 2.5l12.5 12.5z"
  }));
}

var _excluded$pb = ["size", "color", "stroke"];

function IconBoxMargin(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-margin",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 8h8v8h-8z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 8v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8v.01"
  }));
}

var _excluded$pa = ["size", "color", "stroke"];

function IconBoxModel2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$pa);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-model-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 8h8v8h-8z"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }));
}

var _excluded$p9 = ["size", "color", "stroke"];

function IconBoxModel(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-model",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 8h8v8h-8z"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 16l3.3 3.3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 8l3.3 -3.3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 8l-3.3 -3.3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16l-3.3 3.3"
  }));
}

var _excluded$p8 = ["size", "color", "stroke"];

function IconBoxMultiple0(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-0",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 6a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }));
}

var _excluded$p7 = ["size", "color", "stroke"];

function IconBoxMultiple1(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-1",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 14v-8l-2 2"
  }));
}

var _excluded$p6 = ["size", "color", "stroke"];

function IconBoxMultiple2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 8a2 2 0 1 1 4 0c0 .591 -.417 1.318 -.816 1.858l-3.184 4.143l4 0"
  }));
}

var _excluded$p5 = ["size", "color", "stroke"];

function IconBoxMultiple3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 10a2 2 0 1 0 -2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12a2 2 0 1 0 2 -2"
  }));
}

var _excluded$p4 = ["size", "color", "stroke"];

function IconBoxMultiple4(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-4",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 14v-8l-4 6h5"
  }));
}

var _excluded$p3 = ["size", "color", "stroke"];

function IconBoxMultiple5(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-5",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 14h2a2 2 0 1 0 0 -4h-2v-4h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }));
}

var _excluded$p2 = ["size", "color", "stroke"];

function IconBoxMultiple6(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-6",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14,
    cy: 12,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 8a2 2 0 1 0 -4 0v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }));
}

var _excluded$p1 = ["size", "color", "stroke"];

function IconBoxMultiple7(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-7",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6h4l-2 8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }));
}

var _excluded$p0 = ["size", "color", "stroke"];

function IconBoxMultiple8(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$p0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-8",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14,
    cy: 8,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14,
    cy: 12,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }));
}

var _excluded$o$ = ["size", "color", "stroke"];

function IconBoxMultiple9(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple-9",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14,
    cy: 8,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12a2 2 0 1 0 4 0v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }));
}

var _excluded$o_ = ["size", "color", "stroke"];

function IconBoxMultiple(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-multiple",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 3,
    width: 14,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
  }));
}

var _excluded$oZ = ["size", "color", "stroke"];

function IconBoxOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.765 17.757l-5.765 3.243l-8 -4.5v-9l2.236 -1.258m2.57 -1.445l3.194 -1.797l8 4.5v8.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.561 10.559l5.439 -3.059"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-8 -4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$oY = ["size", "color", "stroke"];

function IconBoxPadding(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box-padding",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 8v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 8v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 8v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 16v.01"
  }));
}

var _excluded$oX = ["size", "color", "stroke"];

function IconBox(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-box",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "12 3 20 7.5 20 16.5 12 21 4 16.5 4 7.5 12 3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 20,
    y2: 7.5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 4,
    y2: 7.5
  }));
}

var _excluded$oW = ["size", "color", "stroke"];

function IconBracesOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-braces-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.176 5.177c-.113 .251 -.176 .53 -.176 .823v3c0 1.657 -.895 3 -2 3c1.105 0 2 1.343 2 3v3a2 2 0 0 0 2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 4a2 2 0 0 1 2 2v3c0 1.657 .895 3 2 3c-1.105 0 -2 1.343 -2 3m-.176 3.821a2 2 0 0 1 -1.824 1.179"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$oV = ["size", "color", "stroke"];

function IconBraces(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-braces",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 4a2 2 0 0 0 -2 2v3a2 3 0 0 1 -2 3a2 3 0 0 1 2 3v3a2 2 0 0 0 2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 4a2 2 0 0 1 2 2v3a2 3 0 0 0 2 3a2 3 0 0 0 -2 3v3a2 2 0 0 1 -2 2"
  }));
}

var _excluded$oU = ["size", "color", "stroke"];

function IconBracketsOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brackets-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 5v15h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4h3v11m0 4v1h-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$oT = ["size", "color", "stroke"];

function IconBrackets(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brackets",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4h-3v16h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4h3v16h-3"
  }));
}

var _excluded$oS = ["size", "color", "stroke"];

function IconBrandAdobe(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-adobe",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.893 4.514l7.977 13.994a0.993 .993 0 0 1 -.394 1.365a1.04 1.04 0 0 1 -.5 .127h-3.476l-4.5 -8l-2.5 4h1.5l2 4h-8.977c-.565 0 -1.023 -.45 -1.023 -1.003c0 -.171 .045 -.34 .13 -.49l7.977 -13.993a1.034 1.034 0 0 1 1.786 0z"
  }));
}

var _excluded$oR = ["size", "color", "stroke"];

function IconBrandAirbnb(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-airbnb",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 10c-2 0 -3 1 -3 3c0 1.5 1.494 3.535 3 5.5c1 1 1.5 1.5 2.5 2s2.5 1 4.5 -.5s1.5 -3.5 .5 -6s-2.333 -5.5 -5 -9.5c-.834 -1 -1.5 -1.5 -2.503 -1.5c-1 0 -1.623 .45 -2.497 1.5c-2.667 4 -4 7 -5 9.5s-1.5 4.5 .5 6s3.5 1 4.5 .5s1.5 -1 2.5 -2c1.506 -1.965 3 -4 3 -5.5c0 -2 -1 -3 -3 -3z"
  }));
}

var _excluded$oQ = ["size", "color", "stroke"];

function IconBrandAirtable(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-airtable",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 10v8l7 -3v-2.6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 6l9 3l9 -3l-9 -3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 12.3v8.7l7 -3v-8z"
  }));
}

var _excluded$oP = ["size", "color", "stroke"];

function IconBrandAndroid(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-android",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 10,
    x2: 4,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 10,
    x2: 20,
    y2: 16
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 9h10v8a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-8a5 5 0 0 1 10 0"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 3,
    x2: 9,
    y2: 5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 3,
    x2: 15,
    y2: 5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 18,
    x2: 9,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 18,
    x2: 15,
    y2: 21
  }));
}

var _excluded$oO = ["size", "color", "stroke"];

function IconBrandAngular(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-angular",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.428 17.245l6.076 3.471a1 1 0 0 0 .992 0l6.076 -3.471a1 1 0 0 0 .495 -.734l1.323 -9.704a1 1 0 0 0 -.658 -1.078l-7.4 -2.612a1 1 0 0 0 -.665 0l-7.399 2.613a1 1 0 0 0 -.658 1.078l1.323 9.704a1 1 0 0 0 .495 .734z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 15l3 -8l3 8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 13h4"
  }));
}

var _excluded$oN = ["size", "color", "stroke"];

function IconBrandAppleArcade(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-apple-arcade",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 5,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 12.5v4.75a0.734 .734 0 0 1 -.055 .325a0.704 .704 0 0 1 -.348 .366l-5.462 2.58a4.998 4.998 0 0 1 -4.27 0l-5.462 -2.58a0.705 .705 0 0 1 -.401 -.691l-.002 -4.75"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.431 12.216l5.634 -2.332a5.065 5.065 0 0 1 3.87 0l5.634 2.332a0.692 .692 0 0 1 .028 1.269l-5.462 2.543a5.064 5.064 0 0 1 -4.27 0l-5.462 -2.543a0.691 .691 0 0 1 .028 -1.27z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 7,
    x2: 12,
    y2: 13
  }));
}

var _excluded$oM = ["size", "color", "stroke"];

function IconBrandApple(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-apple",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 7c-3 0 -4 3 -4 5.5c0 3 2 7.5 4 7.5c1.088 -.046 1.679 -.5 3 -.5c1.312 0 1.5 .5 3 .5s4 -3 4 -5c-.028 -.01 -2.472 -.403 -2.5 -3c-.019 -2.17 2.416 -2.954 2.5 -3c-1.023 -1.492 -2.951 -1.963 -3.5 -2c-1.433 -.111 -2.83 1 -3.5 1c-.68 0 -1.9 -1 -3 -1z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 4a2 2 0 0 0 2 -2a2 2 0 0 0 -2 2"
  }));
}

var _excluded$oL = ["size", "color", "stroke"];

function IconBrandAppstore(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-appstore",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16l1.106 -1.99m1.4 -2.522l2.494 -4.488"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 14h5m2.9 0h2.1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 16l-2.51 -4.518m-1.487 -2.677l-1.003 -1.805"
  }));
}

var _excluded$oK = ["size", "color", "stroke"];

function IconBrandAsana(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-asana",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 7,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 16,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 16,
    r: 3
  }));
}

var _excluded$oJ = ["size", "color", "stroke"];

function IconBrandBehance(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-behance",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 18v-12h4.5a3 3 0 0 1 0 6a3 3 0 0 1 0 6h-4.5"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 12,
    x2: 7.5,
    y2: 12
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 13h7a3.5 3.5 0 0 0 -7 0v2a3.5 3.5 0 0 0 6.64 1"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 6,
    x2: 19,
    y2: 6
  }));
}

var _excluded$oI = ["size", "color", "stroke"];

function IconBrandBing(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-bing",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 3l4 1.5v12l6 -2.5l-2 -1l-1 -4l7 2.5v4.5l-10 5l-4 -2z"
  }));
}

var _excluded$oH = ["size", "color", "stroke"];

function IconBrandBitbucket(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-bitbucket",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3.648 4a0.64 .64 0 0 0 -.64 .744l3.14 14.528c.07 .417 .43 .724 .852 .728h10a0.644 .644 0 0 0 .642 -.539l3.35 -14.71a0.641 .641 0 0 0 -.64 -.744l-16.704 -.007z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 15h-4l-1 -6h6z"
  }));
}

var _excluded$oG = ["size", "color", "stroke"];

function IconBrandBooking(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-booking",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 18v-9.5a4.5 4.5 0 0 1 4.5 -4.5h7a4.5 4.5 0 0 1 4.5 4.5v7a4.5 4.5 0 0 1 -4.5 4.5h-9.5a2 2 0 0 1 -2 -2z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 12h3.5a2 2 0 1 1 0 4h-3.5v-7a1 1 0 0 1 1 -1h1.5a2 2 0 1 1 0 4h-1.5"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 16,
    x2: 16.01,
    y2: 16
  }));
}

var _excluded$oF = ["size", "color", "stroke"];

function IconBrandBootstrap(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-bootstrap",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2 12a2 2 0 0 0 2 -2v-4a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4a2 2 0 0 0 2 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2 12a2 2 0 0 1 2 2v4a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-4a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 16v-8h3.5a2 2 0 1 1 0 4h-3.5h4a2 2 0 1 1 0 4h-4z"
  }));
}

var _excluded$oE = ["size", "color", "stroke"];

function IconBrandChrome(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-chrome",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 9,
    x2: 20.4,
    y2: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 9,
    x2: 20.4,
    y2: 9,
    transform: "rotate(120 12 12)"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 9,
    x2: 20.4,
    y2: 9,
    transform: "rotate(240 12 12)"
  }));
}

var _excluded$oD = ["size", "color", "stroke"];

function IconBrandCodepen(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-codepen",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 15l9 6l9 -6l-9 -6l-9 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 9l9 6l9 -6l-9 -6l-9 6"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 9,
    x2: 3,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 9,
    x2: 21,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 3,
    x2: 12,
    y2: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 15,
    x2: 12,
    y2: 21
  }));
}

var _excluded$oC = ["size", "color", "stroke"];

function IconBrandCodesandbox(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-codesandbox",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 7.5v9l-4 2.25l-4 2.25l-4 -2.25l-4 -2.25v-9l4 -2.25l4 -2.25l4 2.25z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l4 -2.25l4 -2.25"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-4 -2.25l-4 -2.25"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 12l-4 2v4.75"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12l4 2l0 4.75"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 5.25l4 2.25l4 -2.25"
  }));
}

var _excluded$oB = ["size", "color", "stroke"];

function IconBrandCss3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-css3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4l-2 14.5l-6 2l-6 -2l-2 -14.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.5 8h7l-4.5 4h4l-.5 3.5l-2.5 .75l-2.5 -.75l-.1 -.5"
  }));
}

var _excluded$oA = ["size", "color", "stroke"];

function IconBrandCucumber(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-cucumber",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 10.99c-.01 5.52 -4.48 10 -10 10.01v-2.26l-.01 -.01c-4.28 -1.11 -6.86 -5.47 -5.76 -9.75a8.001 8.001 0 0 1 9.74 -5.76c3.53 .91 6.03 4.13 6.03 7.78v-.01z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.5 8l-.5 -1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.5 14l.5 1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12.5l-1 .5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 14l-.5 1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 8l.5 -1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 12.5l-1 -.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 10l-1 -.5"
  }));
}

var _excluded$oz = ["size", "color", "stroke"];

function IconBrandDebian(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-debian",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 17c-2.397 -.943 -4 -3.153 -4 -5.635c0 -2.19 1.039 -3.14 1.604 -3.595c2.646 -2.133 6.396 -.27 6.396 3.23c0 2.5 -2.905 2.121 -3.5 1.5c-.595 -.621 -1 -1.5 -.5 -2.5"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$oy = ["size", "color", "stroke"];

function IconBrandDeviantart(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oy);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-deviantart",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 3v4l-3.857 6h3.857v4h-6.429l-2.571 4h-3v-4l3.857 -6h-3.857v-4h6.429l2.571 -4z"
  }));
}

var _excluded$ox = ["size", "color", "stroke"];

function IconBrandDiscord(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ox);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-discord",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 9,
    cy: 12,
    r: 1
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 15,
    cy: 12,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.5 7.5c3.5 -1 5.5 -1 9 0"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 16.5c3.5 1 6.5 1 10 0"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.5 17c0 1 1.5 3 2 3c1.5 0 2.833 -1.667 3.5 -3c.667 -1.667 .5 -5.833 -1.5 -11.5c-1.457 -1.015 -3 -1.34 -4.5 -1.5l-1 2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.5 17c0 1 -1.356 3 -1.832 3c-1.429 0 -2.698 -1.667 -3.333 -3c-.635 -1.667 -.476 -5.833 1.428 -11.5c1.388 -1.015 2.782 -1.34 4.237 -1.5l1 2.5"
  }));
}

var _excluded$ow = ["size", "color", "stroke"];

function IconBrandDisqus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ow);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-disqus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.847 21c-2.259 0 -4.323 -.667 -5.919 -2h-3.928l1.708 -3.266c-.545 -1.174 -.759 -2.446 -.758 -3.734c0 -4.97 3.84 -9 8.898 -9c5.052 0 9.152 4.03 9.152 9c0 4.972 -4.098 9 -9.153 9z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.485 15h-1.485v-6h1.485c2.112 0 3.515 .823 3.515 2.981v.035c0 2.18 -1.403 2.984 -3.515 2.984z"
  }));
}

var _excluded$ov = ["size", "color", "stroke"];

function IconBrandDocker(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ov);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-docker",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M22 12.54c-1.804 -.345 -2.701 -1.08 -3.523 -2.94c-.487 .696 -1.102 1.568 -.92 2.4c.028 .238 -.32 1.002 -.557 1h-14c0 5.208 3.164 7 6.196 7c4.124 .022 7.828 -1.376 9.854 -5c1.146 -.101 2.296 -1.505 2.95 -2.46z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 10h3v3h-3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 10h3v3h-3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 10h3v3h-3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 7h3v3h-3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7h3v3h-3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 4h3v3h-3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.571 18c1.5 0 2.047 -.074 2.958 -.78"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 16,
    x2: 10,
    y2: 16.01
  }));
}

var _excluded$ou = ["size", "color", "stroke"];

function IconBrandDoctrine(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ou);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-doctrine",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 14,
    r: 7
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 14h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 11l3 3l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 3l6.9 6"
  }));
}

var _excluded$ot = ["size", "color", "stroke"];

function IconBrandDribbble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ot);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-dribbble",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 3.6c5 6 7 10.5 7.5 16.2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.4 19c3.5 -3.5 6 -6.5 14.5 -6.4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3.1 10.75c5 0 9.814 -.38 15.314 -5"
  }));
}

var _excluded$os = ["size", "color", "stroke"];

function IconBrandEdge(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$os);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-edge",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.978 11.372a9 9 0 1 0 -1.593 5.773"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.978 11.372c.21 2.993 -5.034 2.413 -6.913 1.486c1.392 -1.6 .402 -4.038 -2.274 -3.851c-1.745 .122 -2.927 1.157 -2.784 3.202c.28 3.99 4.444 6.205 10.36 4.79"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3.022 12.628c-.283 -4.043 8.717 -7.228 11.248 -2.688"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.628 20.978c-2.993 .21 -5.162 -4.725 -3.567 -9.748"
  }));
}

var _excluded$or = ["size", "color", "stroke"];

function IconBrandFacebook(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$or);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-facebook",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 10v4h3v7h4v-7h3l1 -4h-4v-2a1 1 0 0 1 1 -1h3v-4h-3a5 5 0 0 0 -5 5v2h-3"
  }));
}

var _excluded$oq = ["size", "color", "stroke"];

function IconBrandFigma(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-figma",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 15,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("rect", {
    x: 6,
    y: 3,
    width: 12,
    height: 6,
    rx: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 9a3 3 0 0 0 0 6h3m-3 0a3 3 0 1 0 3 3v-15"
  }));
}

var _excluded$op = ["size", "color", "stroke"];

function IconBrandFirebase(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$op);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-firebase",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.53 17.05l6.15 -11.72h-.02c.38 -.74 1.28 -1.02 2.01 -.63c.26 .14 .48 .36 .62 .62l1.06 2.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.47 6.45c.58 -.59 1.53 -.59 2.11 -.01c.22 .22 .36 .5 .41 .81l1.5 9.11c.1 .62 -.2 1.24 -.76 1.54l-6.07 2.9c-.46 .25 -1.01 .26 -1.46 0l-6.02 -2.92c-.55 -.31 -.85 -.92 -.75 -1.54l1.96 -12.04c.12 -.82 .89 -1.38 1.7 -1.25c.46 .07 .87 .36 1.09 .77l1.24 1.76"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.57 17.18l10.93 -10.68"
  }));
}

var _excluded$oo = ["size", "color", "stroke"];

function IconBrandFirefox(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oo);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-firefox",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.028 7.82a9 9 0 1 0 12.823 -3.4c-1.636 -1.02 -3.064 -1.02 -4.851 -1.02h-1.647"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.914 9.485c-1.756 -1.569 -.805 -5.38 .109 -6.17c.086 .896 .585 1.208 1.111 1.685c.88 -.275 1.313 -.282 1.867 0c.82 -.91 1.694 -2.354 2.628 -2.093c-1.082 1.741 -.07 3.733 1.371 4.173c-.17 .975 -1.484 1.913 -2.76 2.686c-1.296 .938 -.722 1.85 0 2.234c.949 .506 3.611 -.995 4.545 .354c-1.698 .102 -1.536 3.107 -3.983 2.727c2.523 .957 4.345 .462 5.458 -.34c1.965 -1.52 2.879 -3.542 2.879 -5.557c-.014 -1.398 .194 -2.695 -1.26 -4.75"
  }));
}

var _excluded$on = ["size", "color", "stroke"];

function IconBrandFlickr(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$on);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-flickr",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 12,
    r: 3
  }));
}

var _excluded$om = ["size", "color", "stroke"];

function IconBrandFoursquare(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$om);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-foursquare",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 3h10c.644 0 1.11 .696 .978 1.33l-1.984 9.859a1.014 1.014 0 0 1 -.994 .811h-2.254c-.308 0 -.6 .141 -.793 .382l-4.144 5.25c-.599 .752 -1.809 .331 -1.809 -.632v-16c0 -.564 .44 -1 1 -1z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 9,
    x2: 17,
    y2: 9
  }));
}

var _excluded$ol = ["size", "color", "stroke"];

function IconBrandFramer(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ol);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-framer",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 15h12l-12 -12h12v6h-12v6l6 6v-6"
  }));
}

var _excluded$ok = ["size", "color", "stroke"];

function IconBrandGit(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ok);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-git",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 16,
    cy: 12,
    r: 1
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 8,
    r: 1
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 16,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 15v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 11l-2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7l-1.9 -1.9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.5 20.4l-6.9 -6.9c-.781 -.781 -.781 -2.219 0 -3l6.9 -6.9c.781 -.781 2.219 -.781 3 0l6.9 6.9c.781 .781 .781 2.219 0 3l-6.9 6.9c-.781 .781 -2.219 .781 -3 0z"
  }));
}

var _excluded$oj = ["size", "color", "stroke"];

function IconBrandGithub(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-github",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 19c-4.3 1.4 -4.3 -2.5 -6 -3m12 5v-3.5c0 -1 .1 -1.4 -.5 -2c2.8 -.3 5.5 -1.4 5.5 -6a4.6 4.6 0 0 0 -1.3 -3.2a4.2 4.2 0 0 0 -.1 -3.2s-1.1 -.3 -3.5 1.3a12.3 12.3 0 0 0 -6.2 0c-2.4 -1.6 -3.5 -1.3 -3.5 -1.3a4.2 4.2 0 0 0 -.1 3.2a4.6 4.6 0 0 0 -1.3 3.2c0 4.6 2.7 5.7 5.5 6c-.6 .6 -.6 1.2 -.5 2v3.5"
  }));
}

var _excluded$oi = ["size", "color", "stroke"];

function IconBrandGitlab(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oi);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-gitlab",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 14l-9 7l-9 -7l3 -11l3 7h6l3 -7z"
  }));
}

var _excluded$oh = ["size", "color", "stroke"];

function IconBrandGmail(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oh);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-gmail",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20h3a1 1 0 0 0 1 -1v-14a1 1 0 0 0 -1 -1h-3v16z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 20h3v-16h-3a1 1 0 0 0 -1 1v14a1 1 0 0 0 1 1z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4l-4 4l-4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6.5l8 7.5l8 -7.5"
  }));
}

var _excluded$og = ["size", "color", "stroke"];

function IconBrandGoogleAnalytics(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$og);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-google-analytics",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 10,
    y: 9,
    width: 4,
    height: 12,
    rx: 1.105
  }), /*#__PURE__*/React.createElement("rect", {
    x: 17,
    y: 3,
    width: 4,
    height: 18,
    rx: 1.105
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5,
    cy: 19,
    r: 2
  }));
}

var _excluded$of = ["size", "color", "stroke"];

function IconBrandGoogleDrive(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$of);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-google-drive",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 10l-6 10l-3 -5l6 -10z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 15h12l-3 5h-12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 15l-6 -10h6l6 10z"
  }));
}

var _excluded$oe = ["size", "color", "stroke"];

function IconBrandGooglePlay(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oe);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-google-play",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 3.71v16.58a0.7 .7 0 0 0 1.05 .606l14.622 -8.42a0.55 .55 0 0 0 0 -.953l-14.622 -8.419a0.7 .7 0 0 0 -1.05 .607z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 9,
    x2: 4.5,
    y2: 20.5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4.5,
    y1: 3.5,
    x2: 15,
    y2: 15
  }));
}

var _excluded$od = ["size", "color", "stroke"];

function IconBrandGoogle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$od);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-google",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.788 5.108a9 9 0 1 0 3.212 6.892h-8"
  }));
}

var _excluded$oc = ["size", "color", "stroke"];

function IconBrandGravatar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-gravatar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.64 5.632a9 9 0 1 0 6.36 -2.632v7.714"
  }));
}

var _excluded$ob = ["size", "color", "stroke"];

function IconBrandHipchat(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ob);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-hipchat",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.802 17.292s.077 -.055 .2 -.149c1.843 -1.425 2.998 -3.49 2.998 -5.789c0 -4.286 -4.03 -7.764 -8.998 -7.764c-4.97 0 -9.002 3.478 -9.002 7.764c0 4.288 4.03 7.646 9 7.646c.424 0 1.12 -.028 2.088 -.084c1.262 .82 3.104 1.493 4.716 1.493c.499 0 .734 -.41 .414 -.828c-.486 -.596 -1.156 -1.551 -1.416 -2.29z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.5 13.5c2.5 2.5 6.5 2.5 9 0"
  }));
}

var _excluded$oa = ["size", "color", "stroke"];

function IconBrandHtml5(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$oa);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-html5",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4l-2 14.5l-6 2l-6 -2l-2 -14.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.5 8h-7l.5 4h6l-.5 3.5l-2.5 .75l-2.5 -.75l-.1 -.5"
  }));
}

var _excluded$o9 = ["size", "color", "stroke"];

function IconBrandInstagram(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-instagram",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 4
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16.5,
    y1: 7.5,
    x2: 16.5,
    y2: 7.501
  }));
}

var _excluded$o8 = ["size", "color", "stroke"];

function IconBrandJavascript(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-javascript",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4l-2 14.5l-6 2l-6 -2l-2 -14.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.5 8h3v8l-2 -1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.5 8h-2.5a0.5 .5 0 0 0 -.5 .5v3a0.5 .5 0 0 0 .5 .5h1.423a0.5 .5 0 0 1 .495 .57l-.418 2.93l-2 .5"
  }));
}

var _excluded$o7 = ["size", "color", "stroke"];

function IconBrandKickstarter(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-kickstarter",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 9l2.975 -4.65c.615 -.9 1.405 -1.35 2.377 -1.35c.79 0 1.474 .286 2.054 .858c.576 .574 .866 1.256 .866 2.054c0 .588 -.153 1.109 -.46 1.559l-2.812 4.029l3.465 4.912c.356 .46 .535 .998 .535 1.613a2.92 2.92 0 0 1 -.843 2.098c-.561 .584 -1.242 .877 -2.04 .877c-.876 0 -1.545 -.29 -2.005 -.87l-4.112 -5.697v3.067c0 .876 -.313 1.69 -.611 2.175c-.543 .883 -1.35 1.325 -2.389 1.325c-.944 0 -1.753 -.327 -2.271 -.974c-.486 -.6 -.729 -1.392 -.729 -2.38v-11.371c0 -.934 .247 -1.706 .74 -2.313c.512 -.641 1.347 -.962 2.26 -.962c.868 0 1.821 .321 2.4 .962c.323 .356 .515 .714 .6 1.08c.052 .224 0 .643 0 1.26v2.698z"
  }));
}

var _excluded$o6 = ["size", "color", "stroke"];

function IconBrandKotlin(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-kotlin",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20h-16v-16h16"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 20,
    y2: 4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12l8 -8"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 20,
    y2: 20
  }));
}

var _excluded$o5 = ["size", "color", "stroke"];

function IconBrandLastfm(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-lastfm",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 8c-.83 -1 -1.388 -1 -2 -1c-.612 0 -2 .271 -2 2s1.384 2.233 3 3c1.616 .767 2.125 1.812 2 3s-1 2 -3 2s-3 -1 -3.5 -2s-1.585 -4.78 -2.497 -5.997a5 5 0 1 0 -1.003 6.997"
  }));
}

var _excluded$o4 = ["size", "color", "stroke"];

function IconBrandLinkedin(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-linkedin",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 11,
    x2: 8,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 8,
    x2: 8,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 16,
    x2: 12,
    y2: 11
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 16v-3a2 2 0 0 0 -4 0"
  }));
}

var _excluded$o3 = ["size", "color", "stroke"];

function IconBrandLoom(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-loom",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.464 6.518a6.001 6.001 0 1 0 -3.023 7.965"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.482 17.464a6.001 6.001 0 1 0 -7.965 -3.023"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.54 17.482a6.001 6.001 0 1 0 3.024 -7.965"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.518 6.54a6.001 6.001 0 1 0 7.965 3.024"
  }));
}

var _excluded$o2 = ["size", "color", "stroke"];

function IconBrandMastercard(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-mastercard",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9.765a3 3 0 1 0 0 4.47"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 5,
    width: 18,
    height: 14,
    rx: 2
  }));
}

var _excluded$o1 = ["size", "color", "stroke"];

function IconBrandMedium(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-medium",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 9h1l3 3l3 -3h1"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 15,
    x2: 10,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 15,
    x2: 16,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 9,
    x2: 9,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 9,
    x2: 15,
    y2: 15
  }));
}

var _excluded$o0 = ["size", "color", "stroke"];

function IconBrandMercedes(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$o0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-mercedes",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l7 5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-7 5"
  }));
}

var _excluded$n$ = ["size", "color", "stroke"];

function IconBrandMessenger(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-messenger",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 20l1.3 -3.9a9 8 0 1 1 3.4 2.9l-4.7 1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 13l3 -2l2 2l3 -2"
  }));
}

var _excluded$n_ = ["size", "color", "stroke"];

function IconBrandMeta(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-meta",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 10.174c1.766 -2.784 3.315 -4.174 4.648 -4.174c2 0 3.263 2.213 4 5.217c.704 2.869 .5 6.783 -2 6.783c-1.114 0 -2.648 -1.565 -4.148 -3.652a27.627 27.627 0 0 1 -2.5 -4.174z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 10.174c-1.766 -2.784 -3.315 -4.174 -4.648 -4.174c-2 0 -3.263 2.213 -4 5.217c-.704 2.869 -.5 6.783 2 6.783c1.114 0 2.648 -1.565 4.148 -3.652c1 -1.391 1.833 -2.783 2.5 -4.174z"
  }));
}

var _excluded$nZ = ["size", "color", "stroke"];

function IconBrandNetbeans(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-netbeans",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 6.873a2 2 0 0 1 1 1.747v6.536a2 2 0 0 1 -1.029 1.748l-6 3.833a2 2 0 0 1 -1.942 0l-6 -3.833a2 2 0 0 1 -1.029 -1.747v-6.537a2 2 0 0 1 1.029 -1.748l6 -3.572a2.056 2.056 0 0 1 2 0l6 3.573h-.029z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.5 9.43a1 1 0 0 1 .5 .874v3.268a1 1 0 0 1 -.515 .874l-3 1.917a1 1 0 0 1 -.97 0l-3 -1.917a1 1 0 0 1 -.515 -.873v-3.269a1 1 0 0 1 .514 -.874l3 -1.786c.311 -.173 .69 -.173 1 0l3 1.787h-.014z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 21v-9l-7.5 -4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l7.5 -4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.5 16l-3.5 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 14l-3.5 2"
  }));
}

var _excluded$nY = ["size", "color", "stroke"];

function IconBrandNetflix(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-netflix",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 20v-16l7 16v-16"
  }));
}

var _excluded$nX = ["size", "color", "stroke"];

function IconBrandNextjs(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-nextjs",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 15v-6l7.745 10.65a9 9 0 1 1 2.255 -1.993"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 12v-3"
  }));
}

var _excluded$nW = ["size", "color", "stroke"];

function IconBrandNotion(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-notion",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 7h3l6 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 7v10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 17h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 7h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 7v10h-1l-7 -7"
  }));
}

var _excluded$nV = ["size", "color", "stroke"];

function IconBrandNuxt(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-nuxt",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.146 8.583l-1.3 -2.09a1.046 1.046 0 0 0 -1.786 .017l-5.91 9.908a1.046 1.046 0 0 0 .897 1.582h3.913"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.043 18c.743 0 1.201 -.843 .82 -1.505l-4.044 -7.013a0.936 .936 0 0 0 -1.638 0l-4.043 7.013c-.382 .662 .076 1.505 .819 1.505h8.086z"
  }));
}

var _excluded$nU = ["size", "color", "stroke"];

function IconBrandNytimes(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-nytimes",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.036 5.058a8.001 8.001 0 1 0 8.706 9.965"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 21v-11l-7.5 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.5 3a2.5 2.5 0 1 1 0 5l-11 -5a2.5 2.5 0 0 0 -.67 4.91"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 13h-.01"
  }));
}

var _excluded$nT = ["size", "color", "stroke"];

function IconBrandOpenSource(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-open-source",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3a9 9 0 0 1 3.618 17.243l-2.193 -5.602a3 3 0 1 0 -2.849 0l-2.193 5.603a9 9 0 0 1 3.617 -17.244z"
  }));
}

var _excluded$nS = ["size", "color", "stroke"];

function IconBrandOpera(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-opera",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("ellipse", {
    cx: 12,
    cy: 12,
    rx: 3,
    ry: 5
  }));
}

var _excluded$nR = ["size", "color", "stroke"];

function IconBrandPagekit(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-pagekit",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.077 20h-5.077v-16h11v14h-5.077"
  }));
}

var _excluded$nQ = ["size", "color", "stroke"];

function IconBrandPatreon(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-patreon",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3h3v18h-3z"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 15,
    cy: 9.5,
    r: 6.5
  }));
}

var _excluded$nP = ["size", "color", "stroke"];

function IconBrandPaypal(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-paypal",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 13l2.5 0c2.5 0 5 -2.5 5 -5c0 -3 -1.9 -5 -5 -5h-5.5c-.5 0 -1 .5 -1 1l-2 14c0 .5 .5 1 1 1h2.8l1.2 -5c.1 -.6 .4 -1 1 -1zm7.5 -5.8c1.7 1 2.5 2.8 2.5 4.8c0 2.5 -2.5 4.5 -5 4.5h-2.6l-.6 3.6a1 1 0 0 1 -1 .8l-2.7 0a0.5 .5 0 0 1 -.5 -.6l.2 -1.4"
  }));
}

var _excluded$nO = ["size", "color", "stroke"];

function IconBrandPhp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-php",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("ellipse", {
    cx: 12,
    cy: 12,
    rx: 10,
    ry: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.5 15l.395 -1.974l.605 -3.026h1.32a1 1 0 0 1 .986 1.164l-.167 1a1 1 0 0 1 -.986 .836h-1.653"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.5 15l.395 -1.974l.605 -3.026h1.32a1 1 0 0 1 .986 1.164l-.167 1a1 1 0 0 1 -.986 .836h-1.653"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7.5l-1 5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.6 10h2.4l-.5 3"
  }));
}

var _excluded$nN = ["size", "color", "stroke"];

function IconBrandPinterest(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-pinterest",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 20,
    x2: 12,
    y2: 11
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.7 14c.437 1.263 1.43 2 2.55 2c2.071 0 3.75 -1.554 3.75 -4a5 5 0 1 0 -9.7 1.7"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$nM = ["size", "color", "stroke"];

function IconBrandPocket(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-pocket",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 4h14a2 2 0 0 1 2 2v6a9 9 0 0 1 -18 0v-6a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 11 12 15 16 11"
  }));
}

var _excluded$nL = ["size", "color", "stroke"];

function IconBrandProducthunt(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-producthunt",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 16v-8h2.5a2.5 2.5 0 1 1 0 5h-2.5"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$nK = ["size", "color", "stroke"];

function IconBrandPython(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-python",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9h-7a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 15h7a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2h-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 9v-4a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v5a2 2 0 0 1 -2 2h-4a2 2 0 0 0 -2 2v5a2 2 0 0 0 2 2h4a2 2 0 0 0 2 -2v-4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 11,
    y1: 6,
    x2: 11,
    y2: 6.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 18,
    x2: 13,
    y2: 18.01
  }));
}

var _excluded$nJ = ["size", "color", "stroke"];

function IconBrandReactNative(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-react-native",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.357 9c-2.637 .68 -4.357 1.845 -4.357 3.175c0 2.107 4.405 3.825 9.85 3.825c.74 0 1.26 -.039 1.95 -.097"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.837 15.9c-.413 -.596 -.806 -1.133 -1.18 -1.8c-2.751 -4.9 -3.488 -9.77 -1.63 -10.873c1.15 -.697 3.047 .253 4.974 2.254"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.429 15.387c-.702 2.688 -.56 4.716 .56 5.395c1.783 1.08 5.387 -1.958 8.043 -6.804c.36 -.67 .683 -1.329 .968 -1.978"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 18.52c1.928 2 3.817 2.95 4.978 2.253c1.85 -1.102 1.121 -5.972 -1.633 -10.873c-.384 -.677 -.777 -1.204 -1.18 -1.8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.66 15c2.612 -.687 4.34 -1.85 4.34 -3.176c0 -2.11 -4.408 -3.824 -9.845 -3.824c-.747 0 -1.266 .029 -1.955 .087"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 12c.285 -.66 .607 -1.308 .968 -1.978c2.647 -4.844 6.253 -7.89 8.046 -6.801c1.11 .679 1.262 2.706 .56 5.393"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.26 12.015h-.01c-.01 .13 -.12 .24 -.26 .24a0.263 .263 0 0 1 -.25 -.26c0 -.14 .11 -.25 .24 -.25h-.01c.13 -.01 .25 .11 .25 .24"
  }));
}

var _excluded$nI = ["size", "color", "stroke"];

function IconBrandReddit(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-reddit",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 8c2.648 0 5.028 .826 6.675 2.14a2.5 2.5 0 0 1 2.326 4.36c0 3.59 -4.03 6.5 -9 6.5c-4.875 0 -8.845 -2.8 -9 -6.294l-1 -.206a2.5 2.5 0 0 1 2.326 -4.36c1.646 -1.313 4.026 -2.14 6.674 -2.14z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 8l1 -5l6 1"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 19,
    cy: 4,
    r: 1
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 9,
    cy: 13,
    r: 0.5,
    fill: "currentColor"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 15,
    cy: 13,
    r: 0.5,
    fill: "currentColor"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 17c.667 .333 1.333 .5 2 .5s1.333 -.167 2 -.5"
  }));
}

var _excluded$nH = ["size", "color", "stroke"];

function IconBrandSafari(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-safari",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 16 10 10 16 8 14 14 8 16"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$nG = ["size", "color", "stroke"];

function IconBrandSass(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-sass",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 10.523c2.46 -.826 4.002 -.826 4.002 -2.155c0 -1.366 -1.347 -1.366 -2.735 -1.366c-1.91 0 -3.352 .49 -4.537 1.748c-.848 .902 -1.027 2.449 -.153 3.307c.973 .956 3.206 1.789 2.884 3.493c-.233 1.235 -1.469 1.823 -2.617 1.202c-.782 -.424 -.454 -1.746 .626 -2.512s2.822 -.992 4.1 -.24c.98 .575 1.046 1.724 .434 2.193"
  }));
}

var _excluded$nF = ["size", "color", "stroke"];

function IconBrandSentry(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-sentry",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 18a1.93 1.93 0 0 0 .306 1.076a2 2 0 0 0 1.584 .924c.646 .033 -.537 0 .11 0h3a4.992 4.992 0 0 0 -3.66 -4.81c.558 -.973 1.24 -2.149 2.04 -3.531a8.997 8.997 0 0 1 5.62 8.341h4c.663 0 2.337 .005 3 0a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-1.84 3.176c4.482 2.05 7.6 6.571 7.6 11.824"
  }));
}

var _excluded$nE = ["size", "color", "stroke"];

function IconBrandShazam(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-shazam",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 12l2 -2a2.828 2.828 0 0 1 4 0a2.828 2.828 0 0 1 0 4l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 12l-2 2a2.828 2.828 0 1 1 -4 -4l3 -3"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$nD = ["size", "color", "stroke"];

function IconBrandSketch(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-sketch",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3.262 10.878l8 8.789c.4 .44 1.091 .44 1.491 0l8 -8.79c.313 -.344 .349 -.859 .087 -1.243l-3.537 -5.194a1 1 0 0 0 -.823 -.436h-8.926a1 1 0 0 0 -.823 .436l-3.54 5.192c-.263 .385 -.227 .901 .087 1.246z"
  }));
}

var _excluded$nC = ["size", "color", "stroke"];

function IconBrandSkype(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-skype",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3a9 9 0 0 1 8.603 11.65a4.5 4.5 0 0 1 -5.953 5.953a9 9 0 0 1 -11.253 -11.253a4.5 4.5 0 0 1 5.953 -5.954a8.987 8.987 0 0 1 2.65 -.396z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 14.5c.5 2 2.358 2.5 4 2.5c2.905 0 4 -1.187 4 -2.5c0 -1.503 -1.927 -2.5 -4 -2.5s-4 -.997 -4 -2.5c0 -1.313 1.095 -2.5 4 -2.5c1.642 0 3.5 .5 4 2.5"
  }));
}

var _excluded$nB = ["size", "color", "stroke"];

function IconBrandSlack(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-slack",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v-6a2 2 0 0 1 4 0v6m0 -2a2 2 0 1 1 2 2h-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12h6a2 2 0 0 1 0 4h-6m2 0a2 2 0 1 1 -2 2v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v6a2 2 0 0 1 -4 0v-6m0 2a2 2 0 1 1 -2 -2h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12h-6a2 2 0 0 1 0 -4h6m-2 0a2 2 0 1 1 2 -2v6"
  }));
}

var _excluded$nA = ["size", "color", "stroke"];

function IconBrandSnapchat(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-snapchat",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.882 7.842a4.882 4.882 0 0 0 -9.764 0c0 4.273 -.213 6.409 -4.118 8.118c2 .882 2 .882 3 3c3 0 4 2 6 2s3 -2 6 -2c1 -2.118 1 -2.118 3 -3c-3.906 -1.709 -4.118 -3.845 -4.118 -8.118zm-13.882 8.119c4 -2.118 4 -4.118 1 -7.118m17 7.118c-4 -2.118 -4 -4.118 -1 -7.118"
  }));
}

var _excluded$nz = ["size", "color", "stroke"];

function IconBrandSoundcloud(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-soundcloud",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 11h1c1.38 0 3 1.274 3 3c0 1.657 -1.5 3 -3 3l-6 0v-10c3 0 4.5 1.5 5 4z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 8,
    x2: 9,
    y2: 17
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 17,
    x2: 6,
    y2: 10
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 16,
    x2: 3,
    y2: 14
  }));
}

var _excluded$ny = ["size", "color", "stroke"];

function IconBrandSpotify(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ny);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-spotify",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 11.973c2.5 -1.473 5.5 -.973 7.5 .527"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 15c1.5 -1 4 -1 5 .5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 9c2 -1 6 -2 10 .5"
  }));
}

var _excluded$nx = ["size", "color", "stroke"];

function IconBrandStackoverflow(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nx);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-stackoverflow",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 17v1a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.322 12.582l7.956 .836"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.787 9.168l7.826 1.664"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.096 5.764l7.608 2.472"
  }));
}

var _excluded$nw = ["size", "color", "stroke"];

function IconBrandSteam(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-steam",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.5 5a4.5 4.5 0 1 1 -.653 8.953l-4.347 3.009l0 .038a3 3 0 0 1 -2.824 2.995l-.176 .005a3 3 0 0 1 -2.94 -2.402l-2.56 -1.098v-3.5l3.51 1.755a2.989 2.989 0 0 1 2.834 -.635l2.727 -3.818a4.5 4.5 0 0 1 4.429 -5.302z"
  }), /*#__PURE__*/React.createElement("circle", {
    fill: "currentColor",
    cx: 16.5,
    cy: 9.5,
    r: 1
  }));
}

var _excluded$nv = ["size", "color", "stroke"];

function IconBrandStripe(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-stripe",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.453 8.056c0 -.623 .518 -.979 1.442 -.979c1.69 0 3.41 .343 4.605 .923l.5 -4c-.948 -.449 -2.82 -1 -5.5 -1c-1.895 0 -3.373 .087 -4.5 1c-1.172 .956 -2 2.33 -2 4c0 3.03 1.958 4.906 5 6c1.961 .69 3 .743 3 1.5c0 .735 -.851 1.5 -2 1.5c-1.423 0 -3.963 -.609 -5.5 -1.5l-.5 4c1.321 .734 3.474 1.5 6 1.5c2.004 0 3.957 -.468 5.084 -1.36c1.263 -.979 1.916 -2.268 1.916 -4.14c0 -3.096 -1.915 -4.547 -5.003 -5.637c-1.646 -.605 -2.544 -1.07 -2.544 -1.807z"
  }));
}

var _excluded$nu = ["size", "color", "stroke"];

function IconBrandSublimeText(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nu);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-sublime-text",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 8l-14 4.5v-5.5l14 -4.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 17l-14 4.5v-5.5l14 -4.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 11.5l-14 -4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 12.5l14 4.5"
  }));
}

var _excluded$nt = ["size", "color", "stroke"];

function IconBrandSvelte(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nt);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-svelte",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 8l-5 3l.821 -.495c1.86 -1.15 4.412 -.49 5.574 1.352a3.91 3.91 0 0 1 -1.264 5.42l-5.053 3.126c-1.86 1.151 -4.312 .591 -5.474 -1.251a3.91 3.91 0 0 1 1.263 -5.42l.26 -.16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 17l5 -3l-.822 .496c-1.86 1.151 -4.411 .491 -5.574 -1.351a3.91 3.91 0 0 1 1.264 -5.42l5.054 -3.127c1.86 -1.15 4.311 -.59 5.474 1.252a3.91 3.91 0 0 1 -1.264 5.42l-.26 .16"
  }));
}

var _excluded$ns = ["size", "color", "stroke"];

function IconBrandTabler(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ns);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-tabler",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 9l3 3l-3 3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 15,
    x2: 16,
    y2: 15
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 4
  }));
}

var _excluded$nr = ["size", "color", "stroke"];

function IconBrandTailwind(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-tailwind",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.667 6c-2.49 0 -4.044 1.222 -4.667 3.667c.933 -1.223 2.023 -1.68 3.267 -1.375c.71 .174 1.217 .68 1.778 1.24c.916 .912 2 1.968 4.288 1.968c2.49 0 4.044 -1.222 4.667 -3.667c-.933 1.223 -2.023 1.68 -3.267 1.375c-.71 -.174 -1.217 -.68 -1.778 -1.24c-.916 -.912 -1.975 -1.968 -4.288 -1.968zm-4 6.5c-2.49 0 -4.044 1.222 -4.667 3.667c.933 -1.223 2.023 -1.68 3.267 -1.375c.71 .174 1.217 .68 1.778 1.24c.916 .912 1.975 1.968 4.288 1.968c2.49 0 4.044 -1.222 4.667 -3.667c-.933 1.223 -2.023 1.68 -3.267 1.375c-.71 -.174 -1.217 -.68 -1.778 -1.24c-.916 -.912 -1.975 -1.968 -4.288 -1.968z"
  }));
}

var _excluded$nq = ["size", "color", "stroke"];

function IconBrandTelegram(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-telegram",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 10l-4 4l6 6l4 -16l-18 7l4 2l2 6l3 -4"
  }));
}

var _excluded$np = ["size", "color", "stroke"];

function IconBrandTidal(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$np);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-tidal",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7l-2.5 2.5l2.5 2.5l2.5 -2.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 14l-2.5 2.5l2.5 2.5l2.5 -2.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 7l-2.5 2.5l2.5 2.5l2.5 -2.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 7l-2.5 2.5l2.5 2.5l2.5 -2.5z"
  }));
}

var _excluded$no = ["size", "color", "stroke"];

function IconBrandTiktok(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$no);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-tiktok",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12a4 4 0 1 0 4 4v-12a5 5 0 0 0 5 5"
  }));
}

var _excluded$nn = ["size", "color", "stroke"];

function IconBrandTinder(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nn);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-tinder",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18.918 8.174c2.56 4.982 .501 11.656 -5.38 12.626c-7.702 1.687 -12.84 -7.716 -7.054 -13.229c.309 -.305 1.161 -1.095 1.516 -1.349c0 .528 .27 3.475 1 3.167c3 0 4 -4.222 3.587 -7.389c2.7 1.411 4.987 3.376 6.331 6.174z"
  }));
}

var _excluded$nm = ["size", "color", "stroke"];

function IconBrandTripadvisor(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nm);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-tripadvisor",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 6.5,
    cy: 13.5,
    r: 1.5
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17.5,
    cy: 13.5,
    r: 1.5
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.5 9a4.5 4.5 0 1 0 3.5 1.671l1 -1.671h-4.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.5 9a4.5 4.5 0 1 1 -3.5 1.671l-1 -1.671h4.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.5 15.5l1.5 2l1.5 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 6.75c2 -.667 4 -.667 6 0"
  }));
}

var _excluded$nl = ["size", "color", "stroke"];

function IconBrandTumblr(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nl);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-tumblr",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 21h4v-4h-4v-6h4v-4h-4v-4h-4v1a3 3 0 0 1 -3 3h-1v4h4v6a4 4 0 0 0 4 4"
  }));
}

var _excluded$nk = ["size", "color", "stroke"];

function IconBrandTwitch(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-twitch",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 5v11a1 1 0 0 0 1 1h2v4l4 -4h5.584c.266 0 .52 -.105 .707 -.293l2.415 -2.414c.187 -.188 .293 -.442 .293 -.708v-8.585a1 1 0 0 0 -1 -1h-14a1 1 0 0 0 -1 1z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 8,
    x2: 16,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 8,
    x2: 12,
    y2: 12
  }));
}

var _excluded$nj = ["size", "color", "stroke"];

function IconBrandTwitter(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-twitter",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M22 4.01c-1 .49 -1.98 .689 -3 .99c-1.121 -1.265 -2.783 -1.335 -4.38 -.737s-2.643 2.06 -2.62 3.737v1c-3.245 .083 -6.135 -1.395 -8 -4c0 0 -4.182 7.433 4 11c-1.872 1.247 -3.739 2.088 -6 2c3.308 1.803 6.913 2.423 10.034 1.517c3.58 -1.04 6.522 -3.723 7.651 -7.742a13.84 13.84 0 0 0 .497 -3.753c-.002 -.249 1.51 -2.772 1.818 -4.013z"
  }));
}

var _excluded$ni = ["size", "color", "stroke"];

function IconBrandUber(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ni);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-uber",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 9,
    width: 6,
    height: 6,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12h6"
  }));
}

var _excluded$nh = ["size", "color", "stroke"];

function IconBrandUbuntu(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nh);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-ubuntu",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 5,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.723 7.41a7.992 7.992 0 0 0 -3.74 -2.162m-3.971 0a7.993 7.993 0 0 0 -3.789 2.216m-1.881 3.215a8 8 0 0 0 -.342 2.32c0 .738 .1 1.453 .287 2.132m1.96 3.428a7.993 7.993 0 0 0 3.759 2.19m3.998 -.003a7.993 7.993 0 0 0 3.747 -2.186m1.962 -3.43a8.008 8.008 0 0 0 .287 -2.131c0 -.764 -.107 -1.503 -.307 -2.203"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 19,
    cy: 17,
    r: 2
  }));
}

var _excluded$ng = ["size", "color", "stroke"];

function IconBrandUnsplash(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ng);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-unsplash",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 11h5v4h6v-4h5v9h-16zm5 -7h6v4h-6z"
  }));
}

var _excluded$nf = ["size", "color", "stroke"];

function IconBrandVercel(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-vercel",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 19h18l-9 -15z"
  }));
}

var _excluded$ne = ["size", "color", "stroke"];

function IconBrandVimeo(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ne);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-vimeo",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 8.5l1 1s1.5 -1.102 2 -.5c.509 .609 1.863 7.65 2.5 9c.556 1.184 1.978 2.89 4 1.5c2 -1.5 7.5 -5.5 8.5 -11.5c.444 -2.661 -1 -4 -2.5 -4c-2 0 -4.047 1.202 -4.5 4c2.05 -1.254 2.551 1.003 1.5 3c-1.052 2.005 -2 3 -2.5 3c-.49 0 -.924 -1.165 -1.5 -3.5c-.59 -2.42 -.5 -6.5 -3 -6.5s-5.5 4.5 -5.5 4.5z"
  }));
}

var _excluded$nd = ["size", "color", "stroke"];

function IconBrandVisualStudio(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nd);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-visual-studio",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8l2 -1l10 13l4 -2v-12l-4 -2l-10 13l-2 -1z"
  }));
}

var _excluded$nc = ["size", "color", "stroke"];

function IconBrandVk(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-vk",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 19h-4a8 8 0 0 1 -8 -8v-5h4v5a4 4 0 0 0 4 4h0v-9h4v4.5l.03 -.004a4.531 4.531 0 0 0 3.97 -4.496h4l-.342 1.711a6.858 6.858 0 0 1 -3.658 4.789h0a5.34 5.34 0 0 1 3.566 4.111l.434 2.389h0h-4a4.531 4.531 0 0 0 -3.97 -4.496v4.5z"
  }));
}

var _excluded$nb = ["size", "color", "stroke"];

function IconBrandVue(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$nb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-vue",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18.5 5l-6.5 10l-6.5 -10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 5l-3 4.5l-3 -4.5h-7l10 16l10 -16z"
  }));
}

var _excluded$na = ["size", "color", "stroke"];

function IconBrandWhatsapp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$na);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-whatsapp",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 21l1.65 -3.8a9 9 0 1 1 3.4 2.9l-5.05 .9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 10a0.5 .5 0 0 0 1 0v-1a0.5 .5 0 0 0 -1 0v1a5 5 0 0 0 5 5h1a0.5 .5 0 0 0 0 -1h-1a0.5 .5 0 0 0 0 1"
  }));
}

var _excluded$n9 = ["size", "color", "stroke"];

function IconBrandWindows(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-windows",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.8 20l-12 -1.5c-1 -.1 -1.8 -.9 -1.8 -1.9v-9.2c0 -1 .8 -1.8 1.8 -1.9l12 -1.5c1.2 -.1 2.2 .8 2.2 1.9v12.1c0 1.2 -1.1 2.1 -2.2 1.9z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 5,
    x2: 12,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 12,
    x2: 20,
    y2: 12
  }));
}

var _excluded$n8 = ["size", "color", "stroke"];

function IconBrandYahoo(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-yahoo",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 6,
    x2: 8,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 18,
    x2: 14,
    y2: 18
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.5 6l5.5 7v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 13l6 -5"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12.5,
    y1: 8,
    x2: 17.5,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 11,
    x2: 20,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 18,
    x2: 20,
    y2: 18.01
  }));
}

var _excluded$n7 = ["size", "color", "stroke"];

function IconBrandYcombinator(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-ycombinator",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 7.002l4 5.998l4 -6"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 17,
    x2: 12,
    y2: 13
  }));
}

var _excluded$n6 = ["size", "color", "stroke"];

function IconBrandYoutube(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brand-youtube",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 5,
    width: 18,
    height: 14,
    rx: 4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 9l5 3l-5 3z"
  }));
}

var _excluded$n5 = ["size", "color", "stroke"];

function IconBread(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bread",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 5a3 3 0 0 1 2 5.235v6.765a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-6.764a3 3 0 0 1 1.824 -5.231l.176 -.005h10z"
  }));
}

var _excluded$n4 = ["size", "color", "stroke"];

function IconBriefcase(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-briefcase",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 7,
    width: 18,
    height: 13,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 7v-2a2 2 0 0 1 2 -2h4a2 2 0 0 1 2 2v2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 13a20 20 0 0 0 18 0"
  }));
}

var _excluded$n3 = ["size", "color", "stroke"];

function IconBrightness2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brightness-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 6h3.5l2.5 -2.5l2.5 2.5h3.5v3.5l2.5 2.5l-2.5 2.5v3.5h-3.5l-2.5 2.5l-2.5 -2.5h-3.5v-3.5l-2.5 -2.5l2.5 -2.5z"
  }));
}

var _excluded$n2 = ["size", "color", "stroke"];

function IconBrightnessDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brightness-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 5,
    x2: 12,
    y2: 5.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 7,
    x2: 17,
    y2: 7.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 19,
    y1: 12,
    x2: 19,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 17,
    x2: 17,
    y2: 17.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 19,
    x2: 12,
    y2: 19.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 17,
    x2: 7,
    y2: 17.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 5,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 7,
    x2: 7,
    y2: 7.01
  }));
}

var _excluded$n1 = ["size", "color", "stroke"];

function IconBrightnessHalf(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brightness-half",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9a3 3 0 0 0 0 6v-6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 6h3.5l2.5 -2.5l2.5 2.5h3.5v3.5l2.5 2.5l-2.5 2.5v3.5h-3.5l-2.5 2.5l-2.5 -2.5h-3.5v-3.5l-2.5 -2.5l2.5 -2.5z"
  }));
}

var _excluded$n0 = ["size", "color", "stroke"];

function IconBrightnessUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$n0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brightness-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 5,
    x2: 12,
    y2: 3
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 7,
    x2: 18.4,
    y2: 5.6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 19,
    y1: 12,
    x2: 21,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 17,
    x2: 18.4,
    y2: 18.4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 19,
    x2: 12,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 17,
    x2: 5.6,
    y2: 18.4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 12,
    x2: 4,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 7,
    x2: 5.6,
    y2: 5.6
  }));
}

var _excluded$m$ = ["size", "color", "stroke"];

function IconBrightness(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brightness",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 3,
    x2: 12,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 9,
    x2: 16.65,
    y2: 4.35
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 14.3,
    x2: 19.37,
    y2: 6.93
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 19.6,
    x2: 20.85,
    y2: 10.75
  }));
}

var _excluded$m_ = ["size", "color", "stroke"];

function IconBrowserCheck(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-browser-check",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8h16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.5 14.5l1.5 1.5l3 -3"
  }));
}

var _excluded$mZ = ["size", "color", "stroke"];

function IconBrowserOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-browser-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4h11a1 1 0 0 1 1 1v11m-.288 3.702a0.997 .997 0 0 1 -.712 .298h-14a1 1 0 0 1 -1 -1v-14c0 -.276 .112 -.526 .293 -.707"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8h4m4 0h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$mY = ["size", "color", "stroke"];

function IconBrowserPlus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-browser-plus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8h16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 14h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v4"
  }));
}

var _excluded$mX = ["size", "color", "stroke"];

function IconBrowserX(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-browser-x",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8h16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 16l4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 16l-4 -4"
  }));
}

var _excluded$mW = ["size", "color", "stroke"];

function IconBrowser(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-browser",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 8,
    x2: 20,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 4,
    x2: 8,
    y2: 8
  }));
}

var _excluded$mV = ["size", "color", "stroke"];

function IconBrushOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brush-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 17a4 4 0 1 1 4 4h-4v-4z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 3a15.996 15.996 0 0 0 -9.309 4.704m-1.795 2.212a15.993 15.993 0 0 0 -1.696 3.284"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 3a15.996 15.996 0 0 1 -4.697 9.302m-2.195 1.786a15.993 15.993 0 0 1 -3.308 1.712"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$mU = ["size", "color", "stroke"];

function IconBrush(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-brush",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 21v-4a4 4 0 1 1 4 4h-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 3a16 16 0 0 0 -12.8 10.2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 3a16 16 0 0 1 -10.2 12.8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.6 9a9 9 0 0 1 4.4 4.4"
  }));
}

var _excluded$mT = ["size", "color", "stroke"];

function IconBucketOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bucket-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.184 17.173l-.184 .827c-.193 1.183 -1.034 2.024 -2 2h-6c-.966 .024 -1.807 -.817 -2 -2l-2 -9h4m4 0h6l-1.089 4.9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 9c0 -.596 .104 -1.167 .295 -1.697m1.705 -2.303a5 5 0 0 1 8 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$mS = ["size", "color", "stroke"];

function IconBucket(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bucket",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 9l-2 9a2 2.5 0 0 1 -2 2h-6a2 2.5 0 0 1 -2 -2l-2 -9z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 9a5 5 0 0 1 10 0"
  }));
}

var _excluded$mR = ["size", "color", "stroke"];

function IconBugOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bug-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.884 5.873a3 3 0 0 1 5.116 2.127v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 9h3a6 6 0 0 1 1 3v1m-.298 3.705a5.002 5.002 0 0 1 -9.702 -1.705v-3a6 6 0 0 1 1 -3h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 13h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 13h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 19l3.35 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 7l3.75 2.4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 7l-3.75 2.4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$mQ = ["size", "color", "stroke"];

function IconBug(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bug",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 9v-1a3 3 0 0 1 6 0v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 9h8a6 6 0 0 1 1 3v3a5 5 0 0 1 -10 0v-3a6 6 0 0 1 1 -3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 13,
    x2: 7,
    y2: 13
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 13,
    x2: 21,
    y2: 13
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 12,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 19,
    x2: 7.35,
    y2: 17
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 19,
    x2: 16.65,
    y2: 17
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 7,
    x2: 7.75,
    y2: 9.4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 7,
    x2: 16.25,
    y2: 9.4
  }));
}

var _excluded$mP = ["size", "color", "stroke"];

function IconBuildingArch(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-arch",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 21v-15a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v15"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 21v-8a3 3 0 0 1 6 0v8"
  }));
}

var _excluded$mO = ["size", "color", "stroke"];

function IconBuildingBank(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-bank",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 10,
    x2: 21,
    y2: 10
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "5 6 12 3 19 6"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 10,
    x2: 4,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 10,
    x2: 20,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 14,
    x2: 8,
    y2: 17
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 14,
    x2: 12,
    y2: 17
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 14,
    x2: 16,
    y2: 17
  }));
}

var _excluded$mN = ["size", "color", "stroke"];

function IconBuildingBridge2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-bridge-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 7h12a2 2 0 0 1 2 2v9a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-2a4 4 0 0 0 -8 0v2a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-9a2 2 0 0 1 2 -2"
  }));
}

var _excluded$mM = ["size", "color", "stroke"];

function IconBuildingBridge(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-bridge",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 5,
    x2: 6,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 5,
    x2: 18,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 2,
    y1: 15,
    x2: 22,
    y2: 15
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 8a7.5 7.5 0 0 0 3 -2a6.5 6.5 0 0 0 12 0a7.5 7.5 0 0 0 3 2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 10,
    x2: 12,
    y2: 15
  }));
}

var _excluded$mL = ["size", "color", "stroke"];

function IconBuildingCarousel(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-carousel",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 6
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5,
    cy: 8,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 4,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 19,
    cy: 8,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5,
    cy: 16,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 19,
    cy: 16,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 22l4 -10l4 10"
  }));
}

var _excluded$mK = ["size", "color", "stroke"];

function IconBuildingCastle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-castle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 19v-2a3 3 0 0 0 -6 0v2a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14h4v3h3v-3h4v3h3v-3h4v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 11,
    x2: 21,
    y2: 11
  }));
}

var _excluded$mJ = ["size", "color", "stroke"];

function IconBuildingChurch(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-church",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 21v-4a2 2 0 0 1 4 0v4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 5,
    x2: 14,
    y2: 5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 3,
    x2: 12,
    y2: 8
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 21v-7m-2 2l8 -8l8 8m-2 -2v7"
  }));
}

var _excluded$mI = ["size", "color", "stroke"];

function IconBuildingCommunity(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-community",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 9l5 5v7h-5v-4m0 4h-5v-7l5 -5m1 1v-6a1 1 0 0 1 1 -1h10a1 1 0 0 1 1 1v17h-8"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 7,
    x2: 13,
    y2: 7.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 7,
    x2: 17,
    y2: 7.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 11,
    x2: 17,
    y2: 11.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 15,
    x2: 17,
    y2: 15.01
  }));
}

var _excluded$mH = ["size", "color", "stroke"];

function IconBuildingCottage(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-cottage",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 21v-11l2.5 -4.5l5.5 -2.5l5.5 2.5l2.5 4.5v11"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 9,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 21v-5a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v5"
  }));
}

var _excluded$mG = ["size", "color", "stroke"];

function IconBuildingFactory2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-factory-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 21h18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 21v-12l5 4v-4l5 4h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 21v-8l-1.436 -9.574a0.5 .5 0 0 0 -.495 -.426h-1.145a0.5 .5 0 0 0 -.494 .418l-1.43 8.582"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 17h1"
  }));
}

var _excluded$mF = ["size", "color", "stroke"];

function IconBuildingFactory(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-factory",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 21c1.147 -4.02 1.983 -8.027 2 -12h6c.017 3.973 .853 7.98 2 12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.5 13h4.5c.025 2.612 .894 5.296 2 8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 22,
    y2: 21
  }));
}

var _excluded$mE = ["size", "color", "stroke"];

function IconBuildingFortress(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-fortress",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 21h1a1 1 0 0 0 1 -1v-1h0a3 3 0 0 1 6 0m3 2h1a1 1 0 0 0 1 -1v-15l-3 -2l-3 2v6h-4v-6l-3 -2l-3 2v15a1 1 0 0 0 1 1h2m8 -2v1a1 1 0 0 0 1 1h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 7h0v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 10h0v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 13h0v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 7h0v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 10h0v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 13h0v.01"
  }));
}

var _excluded$mD = ["size", "color", "stroke"];

function IconBuildingHospital(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-hospital",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 9,
    x2: 14,
    y2: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 7,
    x2: 12,
    y2: 11
  }));
}

var _excluded$mC = ["size", "color", "stroke"];

function IconBuildingLighthouse(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-lighthouse",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3l2 3l2 15h-8l2 -15z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 9,
    x2: 16,
    y2: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 11l2 -2l-2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 11l-2 -2l2 -2"
  }));
}

var _excluded$mB = ["size", "color", "stroke"];

function IconBuildingMonument(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-monument",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 18l2 -13l2 -2l2 2l2 13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 21v-3h14v3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }));
}

var _excluded$mA = ["size", "color", "stroke"];

function IconBuildingPavilon(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-pavilon",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 21h7v-3a2 2 0 0 1 4 0v3h7"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 21,
    x2: 6,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 21,
    x2: 18,
    y2: 12
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12h12a3 3 0 0 0 3 -3a9 8 0 0 1 -9 -6a9 8 0 0 1 -9 6a3 3 0 0 0 3 3"
  }));
}

var _excluded$mz = ["size", "color", "stroke"];

function IconBuildingSkyscraper(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-skyscraper",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 21v-14l8 -4v18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 21v-10l-6 -4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 9,
    x2: 9,
    y2: 9.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 12,
    x2: 9,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 15,
    x2: 9,
    y2: 15.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 18,
    x2: 9,
    y2: 18.01
  }));
}

var _excluded$my = ["size", "color", "stroke"];

function IconBuildingStore(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$my);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-store",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 7v1a3 3 0 0 0 6 0v-1m0 1a3 3 0 0 0 6 0v-1m0 1a3 3 0 0 0 6 0v-1h-18l2 -4h14l2 4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 21,
    x2: 5,
    y2: 10.85
  }), /*#__PURE__*/React.createElement("line", {
    x1: 19,
    y1: 21,
    x2: 19,
    y2: 10.85
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4"
  }));
}

var _excluded$mx = ["size", "color", "stroke"];

function IconBuildingWarehouse(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mx);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building-warehouse",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 21v-13l9 -4l9 4v13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 13h4v8h-10v-6h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 21v-9a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v3"
  }));
}

var _excluded$mw = ["size", "color", "stroke"];

function IconBuilding(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-building",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 8,
    x2: 10,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 12,
    x2: 10,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 16,
    x2: 10,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 8,
    x2: 15,
    y2: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 12,
    x2: 15,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 16,
    x2: 15,
    y2: 16
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 21v-16a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v16"
  }));
}

var _excluded$mv = ["size", "color", "stroke"];

function IconBulbOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bulb-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12h1m8 -9v1m8 8h1m-15.4 -6.4l.7 .7m12.1 -.7l-.7 .7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.089 7.083a5 5 0 0 1 5.826 5.84m-1.378 2.611a5.012 5.012 0 0 1 -.537 .466a3.5 3.5 0 0 0 -1 3a2 2 0 1 1 -4 0a3.5 3.5 0 0 0 -1 -3a5 5 0 0 1 -.528 -7.544"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.7 17h4.6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$mu = ["size", "color", "stroke"];

function IconBulb(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mu);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bulb",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12h1m8 -9v1m8 8h1m-15.4 -6.4l.7 .7m12.1 -.7l-.7 .7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 16a5 5 0 1 1 6 0a3.5 3.5 0 0 0 -1 3a2 2 0 0 1 -4 0a3.5 3.5 0 0 0 -1 -3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9.7,
    y1: 17,
    x2: 14.3,
    y2: 17
  }));
}

var _excluded$mt = ["size", "color", "stroke"];

function IconBulldozer(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mt);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bulldozer",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 4,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 13,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 13v6h3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 19,
    x2: 4,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 15,
    x2: 13,
    y2: 15
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 12v-5h2a3 3 0 0 1 3 3v5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 15v-2a1 1 0 0 1 1 -1h7"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 17,
    x2: 15,
    y2: 17
  }));
}

var _excluded$ms = ["size", "color", "stroke"];

function IconBus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ms);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-bus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 6,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 17h-2v-11a1 1 0 0 1 1 -1h14a5 7 0 0 1 5 7v5h-2m-4 0h-8"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "16 5 17.5 12 22 12"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 2,
    y1: 10,
    x2: 17,
    y2: 10
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 5,
    x2: 7,
    y2: 10
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 5,
    x2: 12,
    y2: 10
  }));
}

var _excluded$mr = ["size", "color", "stroke"];

function IconBusinessplan(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-businessplan",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("ellipse", {
    cx: 16,
    cy: 6,
    rx: 5,
    ry: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 6v4c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 10v4c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 14v4c0 1.657 2.239 3 5 3s5 -1.343 5 -3v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 9h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 15v1m0 -8v1"
  }));
}

var _excluded$mq = ["size", "color", "stroke"];

function IconButterfly(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-butterfly",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.995 18.176a3 3 0 1 1 -4.953 -2.449l-.025 .023a4.502 4.502 0 0 1 1.483 -8.75c1.414 0 2.675 .652 3.5 1.671a4.5 4.5 0 1 1 4.983 7.079a3 3 0 1 1 -4.983 2.25z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 19v-10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 3l3 2l3 -2"
  }));
}

var _excluded$mp = ["size", "color", "stroke"];

function IconCSharp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mp);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-c-sharp",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 9a3 3 0 0 0 -3 -3h-.5a3.5 3.5 0 0 0 -3.5 3.5v5a3.5 3.5 0 0 0 3.5 3.5h.5a3 3 0 0 0 3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 7l-1 10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 7l-1 10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 10h7.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 14h-7.5"
  }));
}

var _excluded$mo = ["size", "color", "stroke"];

function IconCakeOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mo);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cake-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 17v-5a3 3 0 0 0 -3 -3h-5m-4 0h-3a3 3 0 0 0 -3 3v8h17"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2.996 14.803c.312 .135 .654 .204 1.004 .197a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1m4 0a2.4 2.4 0 0 0 2 1c.35 .007 .692 -.062 1.004 -.197"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.172 6.188c.07 -.158 .163 -.31 .278 -.451l1.55 -1.737l1.465 1.638a2 2 0 0 1 -.65 3.19"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$mn = ["size", "color", "stroke"];

function IconCake(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mn);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cake",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 20h18v-8a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -3 3v8z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2.996 14.803c.312 .135 .654 .204 1.004 .197a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1c.35 .007 .692 -.062 1.004 -.197"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 4l1.465 1.638a2 2 0 1 1 -3.015 .099l1.55 -1.737z"
  }));
}

var _excluded$mm = ["size", "color", "stroke"];

function IconCalculatorOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mm);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-calculator-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.823 19.824a2 2 0 0 1 -1.823 1.176h-12a2 2 0 0 1 -2 -2v-14c0 -.295 .064 -.575 .178 -.827m2.822 -1.173h11a2 2 0 0 1 2 2v11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 10h-1a1 1 0 0 1 -1 -1v-1m3 -1h4a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 14v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 14v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 17v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 17v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 17v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$ml = ["size", "color", "stroke"];

function IconCalculator(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ml);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-calculator",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 3,
    width: 16,
    height: 18,
    rx: 2
  }), /*#__PURE__*/React.createElement("rect", {
    x: 8,
    y: 7,
    width: 8,
    height: 3,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 14,
    x2: 8,
    y2: 14.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 14,
    x2: 12,
    y2: 14.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 14,
    x2: 16,
    y2: 14.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 17,
    x2: 8,
    y2: 17.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 17,
    x2: 12,
    y2: 17.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 17,
    x2: 16,
    y2: 17.01
  }));
}

var _excluded$mk = ["size", "color", "stroke"];

function IconCalendarEvent(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-calendar-event",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 5,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 3,
    x2: 16,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 3,
    x2: 8,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 11,
    x2: 20,
    y2: 11
  }), /*#__PURE__*/React.createElement("rect", {
    x: 8,
    y: 15,
    width: 2,
    height: 2
  }));
}

var _excluded$mj = ["size", "color", "stroke"];

function IconCalendarMinus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-calendar-minus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 5,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 3,
    x2: 16,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 3,
    x2: 8,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 11,
    x2: 20,
    y2: 11
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 16,
    x2: 14,
    y2: 16
  }));
}

var _excluded$mi = ["size", "color", "stroke"];

function IconCalendarOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mi);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-calendar-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.823 19.824a2 2 0 0 1 -1.823 1.176h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 1.175 -1.823m3.825 -.177h9a2 2 0 0 1 2 2v9"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 3,
    x2: 16,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 3,
    x2: 8,
    y2: 4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 11h7m4 0h5"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 11,
    y1: 15,
    x2: 12,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 15,
    x2: 12,
    y2: 18
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }));
}

var _excluded$mh = ["size", "color", "stroke"];

function IconCalendarPlus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mh);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-calendar-plus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 5,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 3,
    x2: 16,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 3,
    x2: 8,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 11,
    x2: 20,
    y2: 11
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10,
    y1: 16,
    x2: 14,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 14,
    x2: 12,
    y2: 18
  }));
}

var _excluded$mg = ["size", "color", "stroke"];

function IconCalendarStats(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mg);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-calendar-stats",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.795 21h-6.795a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 14v4h4"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18,
    cy: 18,
    r: 4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 3v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 3v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 11h16"
  }));
}

var _excluded$mf = ["size", "color", "stroke"];

function IconCalendarTime(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-calendar-time",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.795 21h-6.795a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v4"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18,
    cy: 18,
    r: 4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 3v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 3v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 11h16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 16.496v1.504l1 1"
  }));
}

var _excluded$me = ["size", "color", "stroke"];

function IconCalendar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$me);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-calendar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 5,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 3,
    x2: 16,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 3,
    x2: 8,
    y2: 7
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 11,
    x2: 20,
    y2: 11
  }), /*#__PURE__*/React.createElement("line", {
    x1: 11,
    y1: 15,
    x2: 12,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 15,
    x2: 12,
    y2: 18
  }));
}

var _excluded$md = ["size", "color", "stroke"];

function IconCameraMinus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$md);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-camera-minus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 13,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h3m9 6v8a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 6,
    x2: 21,
    y2: 6
  }));
}

var _excluded$mc = ["size", "color", "stroke"];

function IconCameraOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-camera-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.29 4.296a1 1 0 0 1 .71 -.296h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v8m-1.179 2.824c-.25 .113 -.528 .176 -.821 .176h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1c.292 0 .568 -.062 .818 -.175"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.436 10.44a3 3 0 1 0 4.126 4.122"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }));
}

var _excluded$mb = ["size", "color", "stroke"];

function IconCameraPlus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$mb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-camera-plus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 13,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 7h2a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h2m9 7v7a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 6,
    x2: 21,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 3,
    x2: 18,
    y2: 9
  }));
}

var _excluded$ma = ["size", "color", "stroke"];

function IconCameraRotate(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ma);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-camera-rotate",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.245 15.904a3 3 0 0 0 3.755 -2.904m-2.25 -2.905a3 3 0 0 0 -3.75 2.905"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 13h2v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 13h-2v-2"
  }));
}

var _excluded$m9 = ["size", "color", "stroke"];

function IconCameraSelfie(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-camera-selfie",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.5 15a3.5 3.5 0 0 0 5 0"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 11,
    x2: 15.01,
    y2: 11
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 11,
    x2: 9.01,
    y2: 11
  }));
}

var _excluded$m8 = ["size", "color", "stroke"];

function IconCamera(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-camera",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 7h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v9a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 13,
    r: 3
  }));
}

var _excluded$m7 = ["size", "color", "stroke"];

function IconCandle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-candle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 21h6v-9a1 1 0 0 0 -1 -1h-4a1 1 0 0 0 -1 1v9z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3l1.465 1.638a2 2 0 1 1 -3.015 .099l1.55 -1.737z"
  }));
}

var _excluded$m6 = ["size", "color", "stroke"];

function IconCandyOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-candy-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.174 7.17l.119 -.12a2 2 0 0 1 2.828 0l2.829 2.83a2 2 0 0 1 0 2.828l-.124 .124m-1.996 1.996l-2.123 2.123a2 2 0 0 1 -2.828 0l-2.829 -2.831a2 2 0 0 1 0 -2.828l2.113 -2.112"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.243 9.172l3.086 -.772a1.5 1.5 0 0 0 .697 -2.516l-2.216 -2.217a1.5 1.5 0 0 0 -2.44 .47l-1.248 2.913"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.172 16.243l-.772 3.086a1.5 1.5 0 0 1 -2.516 .697l-2.217 -2.216a1.5 1.5 0 0 1 .47 -2.44l2.913 -1.248"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$m5 = ["size", "color", "stroke"];

function IconCandy(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-candy",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.05 11.293l4.243 -4.243a2 2 0 0 1 2.828 0l2.829 2.83a2 2 0 0 1 0 2.828l-4.243 4.243a2 2 0 0 1 -2.828 0l-2.829 -2.831a2 2 0 0 1 0 -2.828z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.243 9.172l3.086 -.772a1.5 1.5 0 0 0 .697 -2.516l-2.216 -2.217a1.5 1.5 0 0 0 -2.44 .47l-1.248 2.913"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.172 16.243l-.772 3.086a1.5 1.5 0 0 1 -2.516 .697l-2.217 -2.216a1.5 1.5 0 0 1 .47 -2.44l2.913 -1.248"
  }));
}

var _excluded$m4 = ["size", "color", "stroke"];

function IconCaptureOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-capture-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16v2a2 2 0 0 0 2 2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4h2a2 2 0 0 1 2 2v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20h2c.554 0 1.055 -.225 1.417 -.589"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.87 9.887a3 3 0 0 0 4.255 4.23m.58 -3.416a3.012 3.012 0 0 0 -1.4 -1.403"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8v-2c0 -.548 .22 -1.044 .577 -1.405"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$m3 = ["size", "color", "stroke"];

function IconCapture(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-capture",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8v-2a2 2 0 0 1 2 -2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16v2a2 2 0 0 0 2 2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4h2a2 2 0 0 1 2 2v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20h2a2 2 0 0 0 2 -2v-2"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 3
  }));
}

var _excluded$m2 = ["size", "color", "stroke"];

function IconCarCrane(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-car-crane",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 18h8m4 0h2v-6a5 5 0 0 0 -5 -5h-1l1.5 5h4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 18v-11h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 17v-5h9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v-6l18 -3v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 12v-4l-4 -2"
  }));
}

var _excluded$m1 = ["size", "color", "stroke"];

function IconCarCrash(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-car-crash",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 10,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 6l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-5m0 -6h8m-6 0v-5m2 0h-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 8v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 12h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.5 15.5l1.5 1.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.5 8.5l1.5 -1.5"
  }));
}

var _excluded$m0 = ["size", "color", "stroke"];

function IconCarOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$m0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-car-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.584 15.588a2 2 0 0 0 2.828 2.83"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 17h-2v-6l2 -5h1m4 0h4l4 5h1a2 2 0 0 1 2 2v4m-6 0h-6m-6 -6h8m4 0h3m-6 -3v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$l$ = ["size", "color", "stroke"];

function IconCar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-car",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 17h-2v-6l2 -5h9l4 5h1a2 2 0 0 1 2 2v4h-2m-4 0h-6m-6 -6h15m-6 0v-5"
  }));
}

var _excluded$l_ = ["size", "color", "stroke"];

function IconCaravan(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-caravan",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 11,
    cy: 17,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 17,
    x2: 13,
    y2: 17
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17h-5a1 1 0 0 1 -1 -1v-9a2 2 0 0 1 2 -2h10l4 4v8"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 6,
    y: 8,
    width: 6,
    height: 4,
    rx: 1
  }));
}

var _excluded$lZ = ["size", "color", "stroke"];

function IconCardboardsOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cardboards-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.96 16.953c.026 -.147 .04 -.298 .04 -.453v-8.5a2 2 0 0 0 -2 -2h-9m-4 0h-1a2 2 0 0 0 -2 2v8.5a2.5 2.5 0 0 0 2.5 2.5h1.06a3 3 0 0 0 2.34 -1.13l1.54 -1.92a2 2 0 0 1 3.12 0l1.54 1.92a3 3 0 0 0 2.34 1.13h1.06c.155 0 .307 -.014 .454 -.041"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 8,
    cy: 12,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.714 12.7a1 1 0 0 0 -1.417 -1.411l1.417 1.41z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$lY = ["size", "color", "stroke"];

function IconCardboards(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cardboards",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 8v8.5a2.5 2.5 0 0 0 2.5 2.5h1.06a3 3 0 0 0 2.34 -1.13l1.54 -1.92a2 2 0 0 1 3.12 0l1.54 1.92a3 3 0 0 0 2.34 1.13h1.06a2.5 2.5 0 0 0 2.5 -2.5v-8.5a2 2 0 0 0 -2 -2h-14a2 2 0 0 0 -2 2z"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 8,
    cy: 12,
    r: 1
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 16,
    cy: 12,
    r: 1
  }));
}

var _excluded$lX = ["size", "color", "stroke"];

function IconCaretDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-caret-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l-6 -6l-6 6h12",
    transform: "rotate(180 12 12)"
  }));
}

var _excluded$lW = ["size", "color", "stroke"];

function IconCaretLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-caret-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l-6 -6l-6 6h12",
    transform: "rotate(270 12 12)"
  }));
}

var _excluded$lV = ["size", "color", "stroke"];

function IconCaretRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-caret-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l-6 -6l-6 6h12",
    transform: "rotate(90 12 12)"
  }));
}

var _excluded$lU = ["size", "color", "stroke"];

function IconCaretUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-caret-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 15l-6 -6l-6 6h12"
  }));
}

var _excluded$lT = ["size", "color", "stroke"];

function IconCashBanknoteOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cash-banknote-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.88 9.878a3 3 0 1 0 4.242 4.243m.58 -3.425a3.012 3.012 0 0 0 -1.412 -1.405"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 6h9a2 2 0 0 1 2 2v8c0 .294 -.064 .574 -.178 .825m-2.822 1.175h-13a2 2 0 0 1 -2 -2v-8a2 2 0 0 1 2 -2h1"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 12,
    x2: 18.01,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 12,
    x2: 6.01,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }));
}

var _excluded$lS = ["size", "color", "stroke"];

function IconCashBanknote(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cash-banknote",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 6,
    width: 18,
    height: 12,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 12,
    x2: 18.01,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 12,
    x2: 6.01,
    y2: 12
  }));
}

var _excluded$lR = ["size", "color", "stroke"];

function IconCashOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cash-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 9h6a2 2 0 0 1 2 2v6m-2 2h-10a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.582 12.59a2 2 0 0 0 2.83 2.826"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 9v-2a2 2 0 0 0 -2 -2h-6m-4 0a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$lQ = ["size", "color", "stroke"];

function IconCash(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cash",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 7,
    y: 9,
    width: 14,
    height: 10,
    rx: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14,
    cy: 14,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 9v-2a2 2 0 0 0 -2 -2h-10a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h2"
  }));
}

var _excluded$lP = ["size", "color", "stroke"];

function IconCastOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cast-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 19h.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 19a4 4 0 0 0 -4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 19a8 8 0 0 0 -8 -8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 19h3a3 3 0 0 0 .875 -.13m1.997 -2.002a3 3 0 0 0 .128 -.868v-8a3 3 0 0 0 -3 -3h-9m-3.865 .136a3 3 0 0 0 -1.935 1.864"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$lO = ["size", "color", "stroke"];

function IconCast(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cast",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 19,
    x2: 3.01,
    y2: 19
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 19a4 4 0 0 0 -4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 19a8 8 0 0 0 -8 -8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 19h3a3 3 0 0 0 3 -3v-8a3 3 0 0 0 -3 -3h-12a3 3 0 0 0 -2.8 2"
  }));
}

var _excluded$lN = ["size", "color", "stroke"];

function IconCeOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ce-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 4a7.99 7.99 0 0 0 -2.581 .426"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.867 5.864a8 8 0 0 0 5.133 14.136"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4a8.001 8.001 0 0 0 -7.29 4.7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12a8 8 0 0 0 8 8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 12h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$lM = ["size", "color", "stroke"];

function IconCe(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-ce",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 4a8 8 0 1 0 0 16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4a8 8 0 1 0 0 16"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 20,
    y2: 12
  }));
}

var _excluded$lL = ["size", "color", "stroke"];

function IconCellSignal1(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cell-signal-1",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20h-15.269a0.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a0.731 .731 0 0 1 1.249 .517v15.269z"
  }));
}

var _excluded$lK = ["size", "color", "stroke"];

function IconCellSignal2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cell-signal-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20h-15.269a0.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a0.731 .731 0 0 1 1.249 .517v15.269z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 20v-5"
  }));
}

var _excluded$lJ = ["size", "color", "stroke"];

function IconCellSignal3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cell-signal-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20h-15.269a0.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a0.731 .731 0 0 1 1.249 .517v15.269z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20v-9"
  }));
}

var _excluded$lI = ["size", "color", "stroke"];

function IconCellSignal4(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cell-signal-4",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20h-15.269a0.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a0.731 .731 0 0 1 1.249 .517v15.269z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 7v13"
  }));
}

var _excluded$lH = ["size", "color", "stroke"];

function IconCellSignal5(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cell-signal-5",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20h-15.269a0.731 .731 0 0 1 -.517 -1.249l14.537 -14.537a0.731 .731 0 0 1 1.249 .517v15.269z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 7v13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20v-9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 20v-5"
  }));
}

var _excluded$lG = ["size", "color", "stroke"];

function IconCellSignalOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cell-signal-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20h-15.269a0.731 .731 0 0 1 -.517 -1.249l7.265 -7.264m2 -2.001l5.272 -5.272a0.731 .731 0 0 1 1.249 .517v11.269"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$lF = ["size", "color", "stroke"];

function IconCell(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cell",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4l-4 2v5l4 2l4 -2v-5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 11l4 2l4 -2v-5l-4 -2l-4 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 13v5l4 2l4 -2v-5"
  }));
}

var _excluded$lE = ["size", "color", "stroke"];

function IconCertificate2Off(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-certificate-2-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12a3 3 0 1 0 3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 18v4l2 -1l2 1v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 19h-2a2 2 0 0 1 -2 -2v-11m1.18 -2.825c.25 -.112 .529 -.175 .82 -.175h8a2 2 0 0 1 2 2v9m-.175 3.82a2 2 0 0 1 -1.825 1.18h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$lD = ["size", "color", "stroke"];

function IconCertificate2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-certificate-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 15,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 7h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 18v4l2 -1l2 1v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 19h-2a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-2"
  }));
}

var _excluded$lC = ["size", "color", "stroke"];

function IconCertificateOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-certificate-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.876 12.881a3 3 0 0 0 4.243 4.243m.588 -3.42a3.012 3.012 0 0 0 -1.437 -1.423"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 17.5v4.5l2 -1.5l2 1.5v-4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 19h-5a2 2 0 0 1 -2 -2v-10c0 -1.1 .9 -2 2 -2m4 0h10a2 2 0 0 1 2 2v10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 9h3m4 0h5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 15h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$lB = ["size", "color", "stroke"];

function IconCertificate(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-certificate",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 15,
    cy: 15,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 17.5v4.5l2 -1.5l2 1.5v-4.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 19h-5a2 2 0 0 1 -2 -2v-10c0 -1.1 .9 -2 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -1 1.73"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 9,
    x2: 18,
    y2: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 12,
    x2: 9,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 15,
    x2: 8,
    y2: 15
  }));
}

var _excluded$lA = ["size", "color", "stroke"];

function IconChargingPile(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-charging-pile",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 7,
    x2: 17,
    y2: 8
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 11h1a2 2 0 0 1 2 2v3a1.5 1.5 0 0 0 3 0v-7l-3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20v-14a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 11.5l-1.5 2.5h3l-1.5 2.5"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 20,
    x2: 15,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 8,
    x2: 14,
    y2: 8
  }));
}

var _excluded$lz = ["size", "color", "stroke"];

function IconChartArcs3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-arcs-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 12a5 5 0 1 0 5 -5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.29 18.957a9 9 0 1 0 5.71 -15.957"
  }));
}

var _excluded$ly = ["size", "color", "stroke"];

function IconChartArcs(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ly);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-arcs",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.924 11.132a5 5 0 1 0 -4.056 5.792"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12a9 9 0 1 0 9 -9"
  }));
}

var _excluded$lx = ["size", "color", "stroke"];

function IconChartAreaLine(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lx);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-area-line",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "4 19 8 13 12 15 16 10 20 14 20 19 4 19"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "4 12 7 8 11 10 16 4 20 8"
  }));
}

var _excluded$lw = ["size", "color", "stroke"];

function IconChartArea(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-area",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 19,
    x2: 20,
    y2: 19
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "4 15 8 9 12 11 16 6 20 10 20 15 4 15"
  }));
}

var _excluded$lv = ["size", "color", "stroke"];

function IconChartArrowsVertical(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-arrows-vertical",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 21v-14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 15l3 -3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 10l3 -3l3 3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 21,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 21,
    x2: 12,
    y2: 12
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 6l3 -3l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 21v-18"
  }));
}

var _excluded$lu = ["size", "color", "stroke"];

function IconChartArrows(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lu);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-arrows",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 18,
    x2: 17,
    y2: 18
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 9l3 3l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 15l3 3l-3 3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 3,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 12,
    x2: 12,
    y2: 12
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 3l3 3l-3 3"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 6,
    x2: 21,
    y2: 6
  }));
}

var _excluded$lt = ["size", "color", "stroke"];

function IconChartBar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lt);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-bar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 12,
    width: 6,
    height: 8,
    rx: 1
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 8,
    width: 6,
    height: 12,
    rx: 1
  }), /*#__PURE__*/React.createElement("rect", {
    x: 15,
    y: 4,
    width: 6,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 20,
    x2: 18,
    y2: 20
  }));
}

var _excluded$ls = ["size", "color", "stroke"];

function IconChartBubble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ls);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-bubble",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 6,
    cy: 16,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 16,
    cy: 19,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14.5,
    cy: 7.5,
    r: 4.5
  }));
}

var _excluded$lr = ["size", "color", "stroke"];

function IconChartCandle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-candle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 6,
    width: 4,
    height: 5,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 4,
    x2: 6,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 11,
    x2: 6,
    y2: 20
  }), /*#__PURE__*/React.createElement("rect", {
    x: 10,
    y: 14,
    width: 4,
    height: 5,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 4,
    x2: 12,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 19,
    x2: 12,
    y2: 20
  }), /*#__PURE__*/React.createElement("rect", {
    x: 16,
    y: 5,
    width: 4,
    height: 6,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 4,
    x2: 18,
    y2: 5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 11,
    x2: 18,
    y2: 20
  }));
}

var _excluded$lq = ["size", "color", "stroke"];

function IconChartCircles(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-circles",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 9.5,
    cy: 9.5,
    r: 5.5
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14.5,
    cy: 14.5,
    r: 5.5
  }));
}

var _excluded$lp = ["size", "color", "stroke"];

function IconChartDonut2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lp);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-donut-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v5m4 4h5"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 4
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$lo = ["size", "color", "stroke"];

function IconChartDonut3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lo);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-donut-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v5m4 4h5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.929 14.582l-3.429 2.918"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 4
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$ln = ["size", "color", "stroke"];

function IconChartDonut4(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ln);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-donut-4",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.848 14.667l-3.348 2.833"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v5m4 4h5"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.219 15.328l2.781 4.172"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 4
  }));
}

var _excluded$lm = ["size", "color", "stroke"];

function IconChartDonut(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lm);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-donut",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 3.2a9 9 0 1 0 10.8 10.8a1 1 0 0 0 -1 -1h-3.8a4.1 4.1 0 1 1 -5 -5v-4a0.9 .9 0 0 0 -1 -.8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 3.5a9 9 0 0 1 5.5 5.5h-4.5a9 9 0 0 0 -1 -1v-4.5"
  }));
}

var _excluded$ll = ["size", "color", "stroke"];

function IconChartDots2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ll);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-dots-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3v18h18"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 9,
    cy: 15,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 13,
    cy: 5,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18,
    cy: 12,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 3l-6 1.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.113 6.65l2.771 3.695"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 12.5l-5 2"
  }));
}

var _excluded$lk = ["size", "color", "stroke"];

function IconChartDots3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-dots-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 5,
    cy: 7,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 16,
    cy: 15,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 18,
    cy: 6,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 6,
    cy: 18,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17l5 -1.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.5 8.5l7.81 5.37"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 7l8 -1"
  }));
}

var _excluded$lj = ["size", "color", "stroke"];

function IconChartDots(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-dots",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3v18h18"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 9,
    cy: 9,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 19,
    cy: 7,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14,
    cy: 15,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 10.16,
    y1: 10.62,
    x2: 12.5,
    y2: 13.5
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.088 13.328l2.837 -4.586"
  }));
}

var _excluded$li = ["size", "color", "stroke"];

function IconChartInfographic(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$li);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-infographic",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 7,
    r: 4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 3v4h4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 17,
    x2: 9,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 14,
    x2: 17,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 13,
    x2: 13,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 12,
    x2: 21,
    y2: 21
  }));
}

var _excluded$lh = ["size", "color", "stroke"];

function IconChartLine(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lh);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-line",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 19,
    x2: 20,
    y2: 19
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "4 15 8 9 12 11 16 6 20 10"
  }));
}

var _excluded$lg = ["size", "color", "stroke"];

function IconChartPie2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lg);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-pie-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v9h9"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$lf = ["size", "color", "stroke"];

function IconChartPie3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-pie-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-6.5 5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v9h9"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$le = ["size", "color", "stroke"];

function IconChartPie4(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$le);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-pie-4",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l-6.5 5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v9h9"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l5 7.5"
  }));
}

var _excluded$ld = ["size", "color", "stroke"];

function IconChartPie(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ld);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-pie",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 3.2a9 9 0 1 0 10.8 10.8a1 1 0 0 0 -1 -1h-6.8a2 2 0 0 1 -2 -2v-7a0.9 .9 0 0 0 -1 -.8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 3.5a9 9 0 0 1 5.5 5.5h-4.5a1 1 0 0 1 -1 -1v-4.5"
  }));
}

var _excluded$lc = ["size", "color", "stroke"];

function IconChartRadar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chart-radar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3l9.5 7l-3.5 11h-12l-3.5 -11z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7.5l5.5 4l-2.5 5.5h-6.5l-2 -5.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2.5 10l9.5 3l9.5 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v10l6 8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 21l6 -8"
  }));
}

var _excluded$lb = ["size", "color", "stroke"];

function IconCheck(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$lb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-check",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 12l5 5l10 -10"
  }));
}

var _excluded$la = ["size", "color", "stroke"];

function IconCheckbox(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$la);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-checkbox",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "9 11 12 14 20 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 12v6a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h9"
  }));
}

var _excluded$l9 = ["size", "color", "stroke"];

function IconChecklist(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-checklist",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.615 20h-2.615a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 19l2 2l4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 8h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12h2"
  }));
}

var _excluded$l8 = ["size", "color", "stroke"];

function IconChecks(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-checks",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 12l5 5l10 -10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2 12l5 5m5 -5l5 -5"
  }));
}

var _excluded$l7 = ["size", "color", "stroke"];

function IconCheckupList(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-checkup-list",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 3,
    width: 6,
    height: 4,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 14h.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 17h.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 16l1 1l3 -3"
  }));
}

var _excluded$l6 = ["size", "color", "stroke"];

function IconCheese(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cheese",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.519 20.008l16.481 -.008v-3.5a2 2 0 1 1 0 -4v-3.5h-16.722"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 9l-9.385 -4.992c-2.512 .12 -4.758 1.42 -6.327 3.425c-1.423 1.82 -2.288 4.221 -2.288 6.854c0 2.117 .56 4.085 1.519 5.721"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 13v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 13v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 16v.01"
  }));
}

var _excluded$l5 = ["size", "color", "stroke"];

function IconChevronDownLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevron-down-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 8v8h8"
  }));
}

var _excluded$l4 = ["size", "color", "stroke"];

function IconChevronDownRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevron-down-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 8v8h-8"
  }));
}

var _excluded$l3 = ["size", "color", "stroke"];

function IconChevronDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevron-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "6 9 12 15 18 9"
  }));
}

var _excluded$l2 = ["size", "color", "stroke"];

function IconChevronLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevron-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "15 6 9 12 15 18"
  }));
}

var _excluded$l1 = ["size", "color", "stroke"];

function IconChevronRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevron-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "9 6 15 12 9 18"
  }));
}

var _excluded$l0 = ["size", "color", "stroke"];

function IconChevronUpLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$l0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevron-up-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16v-8h8"
  }));
}

var _excluded$k$ = ["size", "color", "stroke"];

function IconChevronUpRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevron-up-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 8h8v8"
  }));
}

var _excluded$k_ = ["size", "color", "stroke"];

function IconChevronUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevron-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "6 15 12 9 18 15"
  }));
}

var _excluded$kZ = ["size", "color", "stroke"];

function IconChevronsDownLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevrons-down-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 5v8h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 9v8h8"
  }));
}

var _excluded$kY = ["size", "color", "stroke"];

function IconChevronsDownRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevrons-down-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 5v8h-8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 9v8h-8"
  }));
}

var _excluded$kX = ["size", "color", "stroke"];

function IconChevronsDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevrons-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 7 12 12 17 7"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 13 12 18 17 13"
  }));
}

var _excluded$kW = ["size", "color", "stroke"];

function IconChevronsLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevrons-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "11 7 6 12 11 17"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "17 7 12 12 17 17"
  }));
}

var _excluded$kV = ["size", "color", "stroke"];

function IconChevronsRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevrons-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 7 12 12 7 17"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "13 7 18 12 13 17"
  }));
}

var _excluded$kU = ["size", "color", "stroke"];

function IconChevronsUpLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevrons-up-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 15v-8h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 19v-8h8"
  }));
}

var _excluded$kT = ["size", "color", "stroke"];

function IconChevronsUpRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevrons-up-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 7h8v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 11h8v8"
  }));
}

var _excluded$kS = ["size", "color", "stroke"];

function IconChevronsUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-chevrons-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 11 12 6 17 11"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 17 12 12 17 17"
  }));
}

var _excluded$kR = ["size", "color", "stroke"];

function IconChristmasTree(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-christmas-tree",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3l4 4l-2 1l4 4l-3 1l4 4h-14l4 -4l-3 -1l4 -4l-2 -1z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 17v3a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-3"
  }));
}

var _excluded$kQ = ["size", "color", "stroke"];

function IconCircle0(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-0",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 8a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kP = ["size", "color", "stroke"];

function IconCircle1(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-1",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 16v-8l-2 2"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kO = ["size", "color", "stroke"];

function IconCircle2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 10a2 2 0 1 1 4 0c0 .591 -.417 1.318 -.816 1.858l-3.184 4.143l4 0"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kN = ["size", "color", "stroke"];

function IconCircle3(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-3",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12a2 2 0 1 0 -2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 14a2 2 0 1 0 2 -2"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kM = ["size", "color", "stroke"];

function IconCircle4(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-4",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 16v-8l-4 6h5"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kL = ["size", "color", "stroke"];

function IconCircle5(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-5",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 16h2a2 2 0 1 0 0 -4h-2v-4h4"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kK = ["size", "color", "stroke"];

function IconCircle6(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-6",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 14,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 10a2 2 0 1 0 -4 0v4"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kJ = ["size", "color", "stroke"];

function IconCircle7(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-7",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 8h4l-2 8"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kI = ["size", "color", "stroke"];

function IconCircle8(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-8",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 10,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 14,
    r: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kH = ["size", "color", "stroke"];

function IconCircle9(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-9",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 10,
    r: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 14a2 2 0 1 0 4 0v-4"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kG = ["size", "color", "stroke"];

function IconCircleCheck(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-check",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12l2 2l4 -4"
  }));
}

var _excluded$kF = ["size", "color", "stroke"];

function IconCircleDashed(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-dashed",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.56 3.69a9 9 0 0 0 -2.92 1.95"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3.69 8.56a9 9 0 0 0 -.69 3.44"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3.69 15.44a9 9 0 0 0 1.95 2.92"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.56 20.31a9 9 0 0 0 3.44 .69"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.44 20.31a9 9 0 0 0 2.92 -1.95"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.31 15.44a9 9 0 0 0 .69 -3.44"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.31 8.56a9 9 0 0 0 -1.95 -2.92"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.44 3.69a9 9 0 0 0 -3.44 -.69"
  }));
}

var _excluded$kE = ["size", "color", "stroke"];

function IconCircleDot(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-dot",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 1
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kD = ["size", "color", "stroke"];

function IconCircleDotted(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-dotted",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7.5,
    y1: 4.21,
    x2: 7.5,
    y2: 4.22
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4.21,
    y1: 7.5,
    x2: 4.21,
    y2: 7.51
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 12,
    x2: 3,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4.21,
    y1: 16.5,
    x2: 4.21,
    y2: 16.51
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7.5,
    y1: 19.79,
    x2: 7.5,
    y2: 19.8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 21,
    x2: 12,
    y2: 21.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16.5,
    y1: 19.79,
    x2: 16.5,
    y2: 19.8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 19.79,
    y1: 16.5,
    x2: 19.79,
    y2: 16.51
  }), /*#__PURE__*/React.createElement("line", {
    x1: 21,
    y1: 12,
    x2: 21,
    y2: 12.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 19.79,
    y1: 7.5,
    x2: 19.79,
    y2: 7.51
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16.5,
    y1: 4.21,
    x2: 16.5,
    y2: 4.22
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 3,
    x2: 12,
    y2: 3.01
  }));
}

var _excluded$kC = ["size", "color", "stroke"];

function IconCircleHalf2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-half-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 14l7 -7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 19l8.5 -8.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9l4.5 -4.5"
  }));
}

var _excluded$kB = ["size", "color", "stroke"];

function IconCircleHalfVertical(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-half-vertical",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12h18"
  }));
}

var _excluded$kA = ["size", "color", "stroke"];

function IconCircleHalf(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-half",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v18"
  }));
}

var _excluded$kz = ["size", "color", "stroke"];

function IconCircleMinus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-minus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 12,
    x2: 15,
    y2: 12
  }));
}

var _excluded$ky = ["size", "color", "stroke"];

function IconCircleOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ky);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$kx = ["size", "color", "stroke"];

function IconCirclePlus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kx);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-plus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 12,
    x2: 15,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 9,
    x2: 12,
    y2: 15
  }));
}

var _excluded$kw = ["size", "color", "stroke"];

function IconCircleRectangleOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-rectangle-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 10h3v3m-3 1h-7v-4h3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$kv = ["size", "color", "stroke"];

function IconCircleRectangle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-rectangle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 10h10v4h-10z"
  }));
}

var _excluded$ku = ["size", "color", "stroke"];

function IconCircleSquare(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ku);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-square",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 9.5,
    cy: 9.5,
    r: 6.5
  }), /*#__PURE__*/React.createElement("rect", {
    x: 10,
    y: 10,
    width: 11,
    height: 11,
    rx: 2
  }));
}

var _excluded$kt = ["size", "color", "stroke"];

function IconCircleTriangle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kt);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-triangle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20l7 -12h-14z"
  }));
}

var _excluded$ks = ["size", "color", "stroke"];

function IconCircleX(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ks);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle-x",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 10l4 4m0 -4l-4 4"
  }));
}

var _excluded$kr = ["size", "color", "stroke"];

function IconCircle(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circle",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }));
}

var _excluded$kq = ["size", "color", "stroke"];

function IconCircles(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-circles",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 7,
    r: 4
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 6.5,
    cy: 17,
    r: 4
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17.5,
    cy: 17,
    r: 4
  }));
}

var _excluded$kp = ["size", "color", "stroke"];

function IconClearAll(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kp);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clear-all",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 6h12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12h12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 18h12"
  }));
}

var _excluded$ko = ["size", "color", "stroke"];

function IconClearFormatting(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ko);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clear-formatting",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 15l4 4m0 -4l-4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 6v-1h11v1"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 19,
    x2: 11,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 5,
    x2: 9,
    y2: 19
  }));
}

var _excluded$kn = ["size", "color", "stroke"];

function IconClick(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kn);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-click",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 12,
    x2: 6,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 3,
    x2: 12,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7.8,
    y1: 7.8,
    x2: 5.6,
    y2: 5.6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16.2,
    y1: 7.8,
    x2: 18.4,
    y2: 5.6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7.8,
    y1: 16.2,
    x2: 5.6,
    y2: 18.4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12l9 3l-4 2l-2 4l-3 -9"
  }));
}

var _excluded$km = ["size", "color", "stroke"];

function IconClipboardCheck(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$km);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clipboard-check",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 3,
    width: 6,
    height: 4,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 14l2 2l4 -4"
  }));
}

var _excluded$kl = ["size", "color", "stroke"];

function IconClipboardList(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kl);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clipboard-list",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 3,
    width: 6,
    height: 4,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 12,
    x2: 9.01,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 12,
    x2: 15,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 16,
    x2: 9.01,
    y2: 16
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 16,
    x2: 15,
    y2: 16
  }));
}

var _excluded$kk = ["size", "color", "stroke"];

function IconClipboardOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clipboard-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.575 5.597a1.994 1.994 0 0 0 -.575 1.403v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2m0 -4v-8a2 2 0 0 0 -2 -2h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5a2 2 0 0 1 2 -2h2a2 2 0 1 1 0 4h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$kj = ["size", "color", "stroke"];

function IconClipboardPlus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clipboard-plus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 3,
    width: 6,
    height: 4,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 14h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v4"
  }));
}

var _excluded$ki = ["size", "color", "stroke"];

function IconClipboardText(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ki);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clipboard-text",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 3,
    width: 6,
    height: 4,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 16h6"
  }));
}

var _excluded$kh = ["size", "color", "stroke"];

function IconClipboardX(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kh);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clipboard-x",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 3,
    width: 6,
    height: 4,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 12l4 4m0 -4l-4 4"
  }));
}

var _excluded$kg = ["size", "color", "stroke"];

function IconClipboard(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kg);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clipboard",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 9,
    y: 3,
    width: 6,
    height: 4,
    rx: 2
  }));
}

var _excluded$kf = ["size", "color", "stroke"];

function IconClock2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clock-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7v5l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 12h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 19v1"
  }));
}

var _excluded$ke = ["size", "color", "stroke"];

function IconClockOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ke);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clock-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$kd = ["size", "color", "stroke"];

function IconClock(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kd);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clock",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "12 7 12 12 15 15"
  }));
}

var _excluded$kc = ["size", "color", "stroke"];

function IconCloudDownload(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud-download",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 18a3.5 3.5 0 0 0 0 -7h-1a5 4.5 0 0 0 -11 -2a4.6 4.4 0 0 0 -2.1 8.4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 13,
    x2: 12,
    y2: 22
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "9 19 12 22 15 19"
  }));
}

var _excluded$kb = ["size", "color", "stroke"];

function IconCloudFog(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$kb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud-fog",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 16a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-12"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 20,
    x2: 19,
    y2: 20
  }));
}

var _excluded$ka = ["size", "color", "stroke"];

function IconCloudLockOpen(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ka);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud-lock-open",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 18a3.5 3.5 0 0 0 0 -7h-1c.397 -1.768 -.285 -3.593 -1.788 -4.787c-1.503 -1.193 -3.6 -1.575 -5.5 -1s-3.315 2.019 -3.712 3.787c-2.199 -.088 -4.155 1.326 -4.666 3.373c-.512 2.047 .564 4.154 2.566 5.027"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 8,
    y: 15,
    width: 8,
    height: 5,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 15v-2a2 2 0 0 1 3.736 -.994"
  }));
}

var _excluded$k9 = ["size", "color", "stroke"];

function IconCloudLock(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud-lock",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 18a3.5 3.5 0 0 0 0 -7h-1c.397 -1.768 -.285 -3.593 -1.788 -4.787c-1.503 -1.193 -3.6 -1.575 -5.5 -1s-3.315 2.019 -3.712 3.787c-2.199 -.088 -4.155 1.326 -4.666 3.373c-.512 2.047 .564 4.154 2.566 5.027"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 8,
    y: 15,
    width: 8,
    height: 5,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 15v-2a2 2 0 1 1 4 0v2"
  }));
}

var _excluded$k8 = ["size", "color", "stroke"];

function IconCloudOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 18h-11c-2.598 0 -4.705 -2.015 -4.705 -4.5s2.107 -4.5 4.705 -4.5c.112 -.5 .305 -.973 .568 -1.408m2.094 -1.948c.329 -.174 .68 -.319 1.05 -.43c1.9 -.576 3.997 -.194 5.5 1c1.503 1.192 2.185 3.017 1.788 4.786h1a3.5 3.5 0 0 1 2.212 6.212"
  }));
}

var _excluded$k7 = ["size", "color", "stroke"];

function IconCloudRain(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud-rain",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 13v2m0 3v2m4 -5v2m0 3v2"
  }));
}

var _excluded$k6 = ["size", "color", "stroke"];

function IconCloudSnow(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud-snow",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 15v.01m0 3v.01m0 3v.01m4 -4v.01m0 3v.01"
  }));
}

var _excluded$k5 = ["size", "color", "stroke"];

function IconCloudStorm(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud-storm",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-1"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "13 14 11 18 14 18 12 22"
  }));
}

var _excluded$k4 = ["size", "color", "stroke"];

function IconCloudUpload(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud-upload",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-1"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "9 15 12 12 15 15"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 12,
    x2: 12,
    y2: 21
  }));
}

var _excluded$k3 = ["size", "color", "stroke"];

function IconCloud(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cloud",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 18a4.6 4.4 0 0 1 0 -9a5 4.5 0 0 1 11 2h1a3.5 3.5 0 0 1 0 7h-12"
  }));
}

var _excluded$k2 = ["size", "color", "stroke"];

function IconClubs(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-clubs",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3a4 4 0 0 1 3.164 6.447a4 4 0 1 1 -1.164 6.198v1.355l1 4h-6l1 -4l.001 -1.355a4 4 0 1 1 -1.164 -6.199a4 4 0 0 1 3.163 -6.446z"
  }));
}

var _excluded$k1 = ["size", "color", "stroke"];

function IconCodeMinus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-code-minus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2"
  }));
}

var _excluded$k0 = ["size", "color", "stroke"];

function IconCodeOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$k0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-code-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 8l-4 4l4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 8l4 4l-2.5 2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 4l-1.201 4.805m-.802 3.207l-1.997 7.988"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$j$ = ["size", "color", "stroke"];

function IconCodePlus(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-code-plus",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 19a2 2 0 0 1 -2 -2v-4l-1 -1l1 -1v-4a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 19a2 2 0 0 0 2 -2v-4l1 -1l-1 -1v-4a2 2 0 0 0 -2 -2"
  }));
}

var _excluded$j_ = ["size", "color", "stroke"];

function IconCode(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-code",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "7 8 3 12 7 16"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "17 8 21 12 17 16"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14,
    y1: 4,
    x2: 10,
    y2: 20
  }));
}

var _excluded$jZ = ["size", "color", "stroke"];

function IconCoffeeOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-coffee-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 14c.83 .642 2.077 1.017 3.5 1c1.423 .017 2.67 -.358 3.5 -1c.73 -.565 1.783 -.923 2.994 -.99"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 3c-.194 .14 -.364 .305 -.506 .49"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 10h3v3m-.257 3.743a6.003 6.003 0 0 1 -5.743 4.257h-2a6 6 0 0 1 -6 -6v-5h7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.116 16.124a3 3 0 0 0 -3.118 -4.953"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jY = ["size", "color", "stroke"];

function IconCoffee(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-coffee",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 14c.83 .642 2.077 1.017 3.5 1c1.423 .017 2.67 -.358 3.5 -1c.83 -.642 2.077 -1.017 3.5 -1c1.423 -.017 2.67 .358 3.5 1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3a2.4 2.4 0 0 0 -1 2a2.4 2.4 0 0 0 1 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 10h14v5a6 6 0 0 1 -6 6h-2a6 6 0 0 1 -6 -6v-5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.746 16.726a3 3 0 1 0 .252 -5.555"
  }));
}

var _excluded$jX = ["size", "color", "stroke"];

function IconCoinOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-coin-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.8 9a2 2 0 0 0 -1.8 -1h-1m-2.82 1.171a2 2 0 0 0 1.82 2.829h1m2.824 2.822a2 2 0 0 1 -1.824 1.178h-2a2 2 0 0 1 -1.8 -1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6v2m0 8v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jW = ["size", "color", "stroke"];

function IconCoin(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-coin",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.8 9a2 2 0 0 0 -1.8 -1h-2a2 2 0 0 0 0 4h2a2 2 0 0 1 0 4h-2a2 2 0 0 1 -1.8 -1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6v2m0 8v2"
  }));
}

var _excluded$jV = ["size", "color", "stroke"];

function IconColorPickerOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-color-picker-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7l6 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.001 7.999l3.699 -3.699a1 1 0 0 1 1.4 0l2.6 2.6a1 1 0 0 1 0 1.4l-3.702 3.702m-1.998 1.998l-6 6h-4v-4l6.002 -6.002"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jU = ["size", "color", "stroke"];

function IconColorPicker(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-color-picker",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7l6 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16l11.7 -11.7a1 1 0 0 1 1.4 0l2.6 2.6a1 1 0 0 1 0 1.4l-11.7 11.7h-4v-4z"
  }));
}

var _excluded$jT = ["size", "color", "stroke"];

function IconColorSwatchOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-color-swatch-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 13v4a4 4 0 0 0 6.832 2.825m1.168 -2.825v-12a2 2 0 0 0 -2 -2h-4a2 2 0 0 0 -2 2v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 7.35l-2 -2a2 2 0 0 0 -2.11 -.461m-2.13 1.874l-1.416 1.415a2 2 0 0 0 0 2.828l9 9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.3 13h-2.3a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jS = ["size", "color", "stroke"];

function IconColorSwatch(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-color-swatch",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 3h-4a2 2 0 0 0 -2 2v12a4 4 0 0 0 8 0v-12a2 2 0 0 0 -2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 7.35l-2 -2a2 2 0 0 0 -2.828 0l-2.828 2.828a2 2 0 0 0 0 2.828l9 9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.3 13h-2.3a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h12"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 17,
    x2: 17,
    y2: 17.01
  }));
}

var _excluded$jR = ["size", "color", "stroke"];

function IconColumnInsertLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-column-insert-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 4h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 5,
    y1: 12,
    x2: 9,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 10,
    x2: 7,
    y2: 14
  }));
}

var _excluded$jQ = ["size", "color", "stroke"];

function IconColumnInsertRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-column-insert-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 4h4a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 12,
    x2: 19,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 10,
    x2: 17,
    y2: 14
  }));
}

var _excluded$jP = ["size", "color", "stroke"];

function IconColumnsOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-columns-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 10h5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 14h5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 18h5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.5 6h5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.5 10h5.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 14h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.5 18h3.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jO = ["size", "color", "stroke"];

function IconColumns(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-columns",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 6,
    x2: 9.5,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 10,
    x2: 9.5,
    y2: 10
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 14,
    x2: 9.5,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 18,
    x2: 9.5,
    y2: 18
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14.5,
    y1: 6,
    x2: 20,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14.5,
    y1: 10,
    x2: 20,
    y2: 10
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14.5,
    y1: 14,
    x2: 20,
    y2: 14
  }), /*#__PURE__*/React.createElement("line", {
    x1: 14.5,
    y1: 18,
    x2: 20,
    y2: 18
  }));
}

var _excluded$jN = ["size", "color", "stroke"];

function IconComet(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-comet",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15.5 18.5l-3 1.5l.5 -3.5l-2 -2l3 -.5l1.5 -3l1.5 3l3 .5l-2 2l.5 3.5z"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 4,
    x2: 11,
    y2: 11
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 4,
    x2: 12.5,
    y2: 7.5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 4,
    y1: 9,
    x2: 7.5,
    y2: 12.5
  }));
}

var _excluded$jM = ["size", "color", "stroke"];

function IconCommand(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-command",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 9a2 2 0 1 1 2 -2v10a2 2 0 1 1 -2 -2h10a2 2 0 1 1 -2 2v-10a2 2 0 1 1 2 2h-10"
  }));
}

var _excluded$jL = ["size", "color", "stroke"];

function IconCompassOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-compass-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.999 9l3.001 -1l-1.002 3.005m-.998 2.995l-6 2l2 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 19v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 12h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jK = ["size", "color", "stroke"];

function IconCompass(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-compass",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "8 16 10 10 16 8 14 14 8 16"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 3,
    x2: 12,
    y2: 5
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 19,
    x2: 12,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 12,
    x2: 5,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 19,
    y1: 12,
    x2: 21,
    y2: 12
  }));
}

var _excluded$jJ = ["size", "color", "stroke"];

function IconComponentsOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-components-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12l3 3l3 -3l-3 -3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18.5 14.5l2.5 -2.5l-3 -3l-2.5 2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.499 8.501l2.501 -2.501l-3 -3l-2.5 2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18l3 3l3 -3l-3 -3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jI = ["size", "color", "stroke"];

function IconComponents(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-components",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 12l3 3l3 -3l-3 -3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 12l3 3l3 -3l-3 -3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 6l3 3l3 -3l-3 -3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18l3 3l3 -3l-3 -3z"
  }));
}

var _excluded$jH = ["size", "color", "stroke"];

function IconCone2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cone-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("ellipse", {
    cx: 12,
    cy: 7,
    rx: 7,
    ry: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 7v.5l-7 12.5l-7 -12.5v-.5"
  }));
}

var _excluded$jG = ["size", "color", "stroke"];

function IconCone(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cone",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("ellipse", {
    transform: "matrix(1 0 0 -1 0 34)",
    cx: 12,
    cy: 17,
    rx: 7,
    ry: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 17v-.5l-7 -12.5l-7 12.5v.5"
  }));
}

var _excluded$jF = ["size", "color", "stroke"];

function IconConfetti(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-confetti",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 5h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 4v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.5 4l-.5 2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 5h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 4v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 9l-1 1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 13l2 -.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 19h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 18v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 16.518l-6.518 -6.518l-4.39 9.58a1.003 1.003 0 0 0 1.329 1.329l9.579 -4.39z"
  }));
}

var _excluded$jE = ["size", "color", "stroke"];

function IconContainerOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-container-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 8v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.297 4.289a0.997 .997 0 0 1 .703 -.289h6a1 1 0 0 1 1 1v7m0 4v3a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1v-11"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jD = ["size", "color", "stroke"];

function IconContainer(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-container",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 8v.01"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 8,
    y: 4,
    width: 8,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 4v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8v.01"
  }));
}

var _excluded$jC = ["size", "color", "stroke"];

function IconContrast2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-contrast-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 18h2a6 6 0 0 0 6 -6a6 6 0 0 1 6 -6h2"
  }));
}

var _excluded$jB = ["size", "color", "stroke"];

function IconContrast(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-contrast",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 17a5 5 0 0 0 0 -10v10"
  }));
}

var _excluded$jA = ["size", "color", "stroke"];

function IconCookieOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cookie-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 13v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 17v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18.192 18.187a3 3 0 0 1 -.976 .652c-1.048 .263 -1.787 .483 -2.216 .661c-.475 .197 -1.092 .538 -1.852 1.024a3 3 0 0 1 -2.296 0c-.802 -.503 -1.419 -.844 -1.852 -1.024c-.471 -.195 -1.21 -.415 -2.216 -.66a3 3 0 0 1 -1.623 -1.624c-.265 -1.052 -.485 -1.79 -.661 -2.216c-.198 -.479 -.54 -1.096 -1.024 -1.852a3 3 0 0 1 0 -2.296c.48 -.744 .82 -1.361 1.024 -1.852c.171 -.413 .391 -1.152 .66 -2.216a3 3 0 0 1 .649 -.971m2.821 -1.174c.14 -.049 .263 -.095 .37 -.139c.458 -.19 1.075 -.531 1.852 -1.024a3 3 0 0 1 2.296 0l2.667 1.104a4 4 0 0 0 4.656 6.14l.053 .132a3 3 0 0 1 0 2.296c-.497 .786 -.838 1.404 -1.024 1.852a6.579 6.579 0 0 0 -.135 .36"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jz = ["size", "color", "stroke"];

function IconCookie(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cookie",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 13v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 17v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 14v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 8v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.148 3.476l2.667 1.104a4 4 0 0 0 4.656 6.14l.053 .132a3 3 0 0 1 0 2.296c-.497 .786 -.838 1.404 -1.024 1.852c-.189 .456 -.409 1.194 -.66 2.216a3 3 0 0 1 -1.624 1.623c-1.048 .263 -1.787 .483 -2.216 .661c-.475 .197 -1.092 .538 -1.852 1.024a3 3 0 0 1 -2.296 0c-.802 -.503 -1.419 -.844 -1.852 -1.024c-.471 -.195 -1.21 -.415 -2.216 -.66a3 3 0 0 1 -1.623 -1.624c-.265 -1.052 -.485 -1.79 -.661 -2.216c-.198 -.479 -.54 -1.096 -1.024 -1.852a3 3 0 0 1 0 -2.296c.48 -.744 .82 -1.361 1.024 -1.852c.171 -.413 .391 -1.152 .66 -2.216a3 3 0 0 1 1.624 -1.623c1.032 -.256 1.77 -.476 2.216 -.661c.458 -.19 1.075 -.531 1.852 -1.024a3 3 0 0 1 2.296 0z"
  }));
}

var _excluded$jy = ["size", "color", "stroke"];

function IconCopyOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jy);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-copy-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.414 19.415a1.994 1.994 0 0 1 -1.414 .585h-8a2 2 0 0 1 -2 -2v-8c0 -.554 .225 -1.055 .589 -1.417m3.411 -.583h6a2 2 0 0 1 2 2v6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 8v-2a2 2 0 0 0 -2 -2h-6m-3.418 .59c-.36 .36 -.582 .86 -.582 1.41v8a2 2 0 0 0 2 2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jx = ["size", "color", "stroke"];

function IconCopy(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jx);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-copy",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 8,
    y: 8,
    width: 12,
    height: 12,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 8v-2a2 2 0 0 0 -2 -2h-8a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h2"
  }));
}

var _excluded$jw = ["size", "color", "stroke"];

function IconCopyleftOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-copyleft-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13.303 9.3a3.01 3.01 0 0 1 1.405 1.406m-.586 3.413a3.016 3.016 0 0 1 -4.122 .131"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jv = ["size", "color", "stroke"];

function IconCopyleft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-copyleft",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 9.75a3.016 3.016 0 0 1 4.163 .173a2.993 2.993 0 0 1 0 4.154a3.016 3.016 0 0 1 -4.163 .173"
  }));
}

var _excluded$ju = ["size", "color", "stroke"];

function IconCopyrightOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ju);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-copyright-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 9.75a3.016 3.016 0 0 0 -.711 -.466m-3.41 .596a2.993 2.993 0 0 0 -.042 4.197a3.016 3.016 0 0 0 4.163 .173"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$jt = ["size", "color", "stroke"];

function IconCopyright(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jt);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-copyright",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 9.75a3.016 3.016 0 0 0 -4.163 .173a2.993 2.993 0 0 0 0 4.154a3.016 3.016 0 0 0 4.163 .173"
  }));
}

var _excluded$js = ["size", "color", "stroke"];

function IconCornerDownLeftDouble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$js);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-down-left-double",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 5v6a3 3 0 0 1 -3 3h-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 10l-4 4l4 4m-5 -8l-4 4l4 4"
  }));
}

var _excluded$jr = ["size", "color", "stroke"];

function IconCornerDownLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jr);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-down-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 6v6a3 3 0 0 1 -3 3h-10l4 -4m0 8l-4 -4"
  }));
}

var _excluded$jq = ["size", "color", "stroke"];

function IconCornerDownRightDouble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-down-right-double",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 5v6a3 3 0 0 0 3 3h7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 10l4 4l-4 4m5 -8l4 4l-4 4"
  }));
}

var _excluded$jp = ["size", "color", "stroke"];

function IconCornerDownRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jp);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-down-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 6v6a3 3 0 0 0 3 3h10l-4 -4m0 8l4 -4"
  }));
}

var _excluded$jo = ["size", "color", "stroke"];

function IconCornerLeftDownDouble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jo);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-left-down-double",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 4h-6a3 3 0 0 0 -3 3v7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 10l-4 4l-4 -4m8 5l-4 4l-4 -4"
  }));
}

var _excluded$jn = ["size", "color", "stroke"];

function IconCornerLeftDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jn);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-left-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 6h-6a3 3 0 0 0 -3 3v10l-4 -4m8 0l-4 4"
  }));
}

var _excluded$jm = ["size", "color", "stroke"];

function IconCornerLeftUpDouble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jm);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-left-up-double",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 19h-6a3 3 0 0 1 -3 -3v-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 13l-4 -4l-4 4m8 -5l-4 -4l-4 4"
  }));
}

var _excluded$jl = ["size", "color", "stroke"];

function IconCornerLeftUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jl);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-left-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 18h-6a3 3 0 0 1 -3 -3v-10l-4 4m8 0l-4 -4"
  }));
}

var _excluded$jk = ["size", "color", "stroke"];

function IconCornerRightDownDouble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jk);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-right-down-double",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 4h6a3 3 0 0 1 3 3v7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 10l4 4l4 -4m-8 5l4 4l4 -4"
  }));
}

var _excluded$jj = ["size", "color", "stroke"];

function IconCornerRightDown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jj);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-right-down",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 6h6a3 3 0 0 1 3 3v10l-4 -4m8 0l-4 4"
  }));
}

var _excluded$ji = ["size", "color", "stroke"];

function IconCornerRightUpDouble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ji);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-right-up-double",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 19h6a3 3 0 0 0 3 -3v-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 13l4 -4l4 4m-8 -5l4 -4l4 4"
  }));
}

var _excluded$jh = ["size", "color", "stroke"];

function IconCornerRightUp(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jh);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-right-up",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 18h6a3 3 0 0 0 3 -3v-10l-4 4m8 0l-4 -4"
  }));
}

var _excluded$jg = ["size", "color", "stroke"];

function IconCornerUpLeftDouble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jg);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-up-left-double",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 18v-6a3 3 0 0 0 -3 -3h-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 13l-4 -4l4 -4m-5 8l-4 -4l4 -4"
  }));
}

var _excluded$jf = ["size", "color", "stroke"];

function IconCornerUpLeft(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jf);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-up-left",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 18v-6a3 3 0 0 0 -3 -3h-10l4 -4m0 8l-4 -4"
  }));
}

var _excluded$je = ["size", "color", "stroke"];

function IconCornerUpRightDouble(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$je);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-up-right-double",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 18v-6a3 3 0 0 1 3 -3h7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 13l4 -4l-4 -4m5 8l4 -4l-4 -4"
  }));
}

var _excluded$jd = ["size", "color", "stroke"];

function IconCornerUpRight(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jd);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-corner-up-right",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 18v-6a3 3 0 0 1 3 -3h10l-4 -4m0 8l4 -4"
  }));
}

var _excluded$jc = ["size", "color", "stroke"];

function IconCpu2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jc);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cpu-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 5,
    y: 5,
    width: 14,
    height: 14,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 10v-2h2m6 6v2h-2m-4 0h-2v-2m8 -4v-2h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 10h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 14h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 3v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 3v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 10h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 14h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 21v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 21v-2"
  }));
}

var _excluded$jb = ["size", "color", "stroke"];

function IconCpuOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$jb);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cpu-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h9a1 1 0 0 1 1 1v9m-.292 3.706a0.997 .997 0 0 1 -.708 .294h-12a1 1 0 0 1 -1 -1v-12c0 -.272 .108 -.518 .284 -.698"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 9h2v2m0 4h-6v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 10h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 14h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 3v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 3v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 10h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 14h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 21v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 21v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$ja = ["size", "color", "stroke"];

function IconCpu(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ja);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cpu",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 5,
    y: 5,
    width: 14,
    height: 14,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 9h6v6h-6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 10h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 14h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 3v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 3v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 10h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 14h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 21v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 21v-2"
  }));
}

var _excluded$j9 = ["size", "color", "stroke"];

function IconCraneOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-crane-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 21h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 21v-12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5v-2l-1.001 1.001"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.005 5.995l-3.005 3.005h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 9h8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 3l10 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 9v4a2 2 0 0 1 2 2m-2 2a2 2 0 0 1 -2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$j8 = ["size", "color", "stroke"];

function IconCrane(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-crane",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 21h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 21v-18l-6 6h18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 3l10 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 9v4a2 2 0 1 1 -2 2"
  }));
}

var _excluded$j7 = ["size", "color", "stroke"];

function IconCreativeCommonsOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-creative-commons-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5.638 5.634a9 9 0 1 0 12.723 12.733m1.686 -2.332a9 9 0 0 0 -12.093 -12.077"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.5 10.5a2.187 2.187 0 0 0 -2.914 .116a1.928 1.928 0 0 0 0 2.768a2.188 2.188 0 0 0 2.914 .116"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.5 10.5a2.194 2.194 0 0 0 -2.309 -.302"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$j6 = ["size", "color", "stroke"];

function IconCreativeCommons(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-creative-commons",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 9
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.5 10.5c-.847 -.71 -2.132 -.658 -2.914 .116a1.928 1.928 0 0 0 0 2.768c.782 .774 2.067 .825 2.914 .116"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.5 10.5c-.847 -.71 -2.132 -.658 -2.914 .116a1.928 1.928 0 0 0 0 2.768c.782 .774 2.067 .825 2.914 .116"
  }));
}

var _excluded$j5 = ["size", "color", "stroke"];

function IconCreditCardOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-credit-card-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5h9a3 3 0 0 1 3 3v8a3 3 0 0 1 -.128 .87"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18.87 18.872a3 3 0 0 1 -.87 .128h-12a3 3 0 0 1 -3 -3v-8c0 -1.352 .894 -2.495 2.124 -2.87"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 11,
    x2: 11,
    y2: 11
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 11,
    x2: 21,
    y2: 11
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 15,
    x2: 7.01,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 11,
    y1: 15,
    x2: 13,
    y2: 15
  }));
}

var _excluded$j4 = ["size", "color", "stroke"];

function IconCreditCard(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-credit-card",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 5,
    width: 18,
    height: 14,
    rx: 3
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 10,
    x2: 21,
    y2: 10
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 15,
    x2: 7.01,
    y2: 15
  }), /*#__PURE__*/React.createElement("line", {
    x1: 11,
    y1: 15,
    x2: 13,
    y2: 15
  }));
}

var _excluded$j3 = ["size", "color", "stroke"];

function IconCricket(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cricket",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.105 18.79l-1.006 .992a4.159 4.159 0 0 1 -6.038 -5.715l.157 -.166l8.282 -8.401l1.5 1.5l3.45 -3.391a2.08 2.08 0 0 1 3.057 2.815l-.116 .126l-3.391 3.45l1.5 1.5l-3.668 3.617"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10.5 7.5l6 6"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 14,
    cy: 18,
    r: 3
  }));
}

var _excluded$j2 = ["size", "color", "stroke"];

function IconCrop(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-crop",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 5v10a1 1 0 0 0 1 1h10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 8h10a1 1 0 0 1 1 1v10"
  }));
}

var _excluded$j1 = ["size", "color", "stroke"];

function IconCrossOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cross-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 12h3v-4h-5v-5h-4v3m-2 2h-3v4h5v9h4v-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$j0 = ["size", "color", "stroke"];

function IconCross(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$j0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cross",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 21h4v-9h5v-4h-5v-5h-4v5h-5v4h5z"
  }));
}

var _excluded$i$ = ["size", "color", "stroke"];

function IconCrosshair(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-crosshair",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 8v-2a2 2 0 0 1 2 -2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 16v2a2 2 0 0 0 2 2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4h2a2 2 0 0 1 2 2v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 20h2a2 2 0 0 0 2 -2v-2"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 12,
    x2: 15,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 9,
    x2: 12,
    y2: 15
  }));
}

var _excluded$i_ = ["size", "color", "stroke"];

function IconCrownOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-crown-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 18h-13l-1.865 -9.327a0.25 .25 0 0 1 .4 -.244l4.465 3.571l1.6 -2.4m1.596 -2.394l.804 -1.206l4 6l4.464 -3.571a0.25 .25 0 0 1 .401 .244l-1.363 6.818"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }));
}

var _excluded$iZ = ["size", "color", "stroke"];

function IconCrown(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-crown",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6l4 6l5 -4l-2 10h-14l-2 -10l5 4z"
  }));
}

var _excluded$iY = ["size", "color", "stroke"];

function IconCrutchesOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-crutches-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.178 4.174a2 2 0 0 1 1.822 -1.174h4a2 2 0 1 1 0 4h-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 21h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 21v-4.092a3 3 0 0 1 .504 -1.664l.992 -1.488a3 3 0 0 0 .097 -.155m.407 -3.601v-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 21v-4.092a3 3 0 0 0 -.504 -1.664l-.992 -1.488a3 3 0 0 1 -.504 -1.664v-2.092"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 11h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$iX = ["size", "color", "stroke"];

function IconCrutches(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-crutches",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 8,
    y: 3,
    width: 8,
    height: 4,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 21h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 21v-4.092a3 3 0 0 1 .504 -1.664l.992 -1.488a3 3 0 0 0 .504 -1.664v-5.092"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 21v-4.092a3 3 0 0 0 -.504 -1.664l-.992 -1.488a3 3 0 0 1 -.504 -1.664v-5.092"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 11h4"
  }));
}

var _excluded$iW = ["size", "color", "stroke"];

function IconCupOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cup-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 8h-3v3h6m4 0h4v-3h-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.5 11l-.323 2.154m-.525 3.497l-.652 4.349h-8l-1.5 -10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 8v-1c0 -.296 .064 -.577 .18 -.83m2.82 -1.17h7a2 2 0 0 1 2 2v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 5v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$iV = ["size", "color", "stroke"];

function IconCup(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cup",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 11h14v-3h-14z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.5 11l-1.5 10h-8l-1.5 -10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 8v-1a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 5v-2"
  }));
}

var _excluded$iU = ["size", "color", "stroke"];

function IconCurling(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-curling",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 9,
    width: 16,
    height: 10,
    rx: 4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 14h16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 5h6a2 2 0 0 1 2 2v2"
  }));
}

var _excluded$iT = ["size", "color", "stroke"];

function IconCurlyLoop(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-curly-loop",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 8c-4 0 -7 2 -7 5a3 3 0 0 0 6 0c0 -3 -2.5 -5 -8 -5s-8 2 -8 5a3 3 0 0 0 6 0c0 -3 -3 -5 -7 -5"
  }));
}

var _excluded$iS = ["size", "color", "stroke"];

function IconCurrencyBahraini(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-bahraini",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 10v1a4 4 0 0 0 4 4h2a2 2 0 0 0 2 -2v-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 19.01v-.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 15.01v-.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 15h2.004a2 2 0 0 0 1.649 -3.131l-2.653 -3.869"
  }));
}

var _excluded$iR = ["size", "color", "stroke"];

function IconCurrencyBaht(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-baht",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 6h5a3 3 0 0 1 3 3v.143a2.857 2.857 0 0 1 -2.857 2.857h-5.143"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 12h5a3 3 0 0 1 3 3v.143a2.857 2.857 0 0 1 -2.857 2.857h-5.143"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 6v12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 4v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 18v2"
  }));
}

var _excluded$iQ = ["size", "color", "stroke"];

function IconCurrencyBitcoin(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-bitcoin",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 6h8a3 3 0 0 1 0 6a3 3 0 0 1 0 6h-8"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 6,
    x2: 8,
    y2: 18
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 12,
    x2: 14,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 3,
    x2: 9,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 3,
    x2: 13,
    y2: 6
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 18,
    x2: 9,
    y2: 21
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13,
    y1: 18,
    x2: 13,
    y2: 21
  }));
}

var _excluded$iP = ["size", "color", "stroke"];

function IconCurrencyCent(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-cent",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.007 7.54a5.965 5.965 0 0 0 -4.008 -1.54a5.996 5.996 0 0 0 -5.992 6c0 3.314 2.682 6 5.992 6a5.965 5.965 0 0 0 4.004 -1.536"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6v-2"
  }));
}

var _excluded$iO = ["size", "color", "stroke"];

function IconCurrencyDinar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-dinar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 20.01v-.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 13l2.386 -.9a1 1 0 0 0 -.095 -1.902l-1.514 -.404a1 1 0 0 1 -.102 -1.9l2.325 -.894"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 14v1a3 3 0 0 0 3 3h4.161a3 3 0 0 0 2.983 -3.32l-1.144 -10.68"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 17l1 1h2.004a2 2 0 0 0 1.649 -3.131l-2.653 -3.869"
  }));
}

var _excluded$iN = ["size", "color", "stroke"];

function IconCurrencyDirham(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-dirham",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.5 19h-3.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8.599 16.479a1.5 1.5 0 1 0 -1.099 2.521"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 4v9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 13h1.888a1.5 1.5 0 0 0 1.296 -2.256l-2.184 -3.744"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 13.01v-.01"
  }));
}

var _excluded$iM = ["size", "color", "stroke"];

function IconCurrencyDogecoin(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-dogecoin",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 6v12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 18h6a6 6 0 1 0 0 -12h-6"
  }));
}

var _excluded$iL = ["size", "color", "stroke"];

function IconCurrencyDollarAustralian(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-dollar-australian",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 18l3.279 -11.476a0.75 .75 0 0 1 1.442 0l3.279 11.476"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 20v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 6v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.5 14h5"
  }));
}

var _excluded$iK = ["size", "color", "stroke"];

function IconCurrencyDollarCanadian(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-dollar-canadian",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 18h-1a6 6 0 1 1 0 -12h1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 20v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 6v-2"
  }));
}

var _excluded$iJ = ["size", "color", "stroke"];

function IconCurrencyDollarSingapore(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-dollar-singapore",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 6h-4a3 3 0 1 0 0 6h1a3 3 0 0 1 0 6h-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 20v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 6v-2"
  }));
}

var _excluded$iI = ["size", "color", "stroke"];

function IconCurrencyDollar(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-dollar",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16.7 8a3 3 0 0 0 -2.7 -2h-4a3 3 0 0 0 0 6h4a3 3 0 0 1 0 6h-4a3 3 0 0 1 -2.7 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v3m0 12v3"
  }));
}

var _excluded$iH = ["size", "color", "stroke"];

function IconCurrencyEthereum(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-ethereum",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12l6 -9l6 9l-6 9z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12l6 -3l6 3l-6 2z"
  }));
}

var _excluded$iG = ["size", "color", "stroke"];

function IconCurrencyEuro(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-euro",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17.2 7a6 7 0 1 0 0 10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 10h-8m0 4h8"
  }));
}

var _excluded$iF = ["size", "color", "stroke"];

function IconCurrencyForint(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-forint",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 4h-4a3 3 0 0 0 -3 3v12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 11h-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 4v13a2 2 0 0 0 2 2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 9h-5"
  }));
}

var _excluded$iE = ["size", "color", "stroke"];

function IconCurrencyFrank(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-frank",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 5h-6a2 2 0 0 0 -2 2v12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 15h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 11h7"
  }));
}

var _excluded$iD = ["size", "color", "stroke"];

function IconCurrencyKroneCzech(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-krone-czech",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 6v12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 12c3.5 0 6 -3 6 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 12c3.5 0 6 3 6 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 6l-2 2l-2 -2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 12h-2a3 3 0 0 0 0 6h2"
  }));
}

var _excluded$iC = ["size", "color", "stroke"];

function IconCurrencyKroneDanish(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-krone-danish",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 6v12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 12c3.5 0 6 -3 6 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 12c3.5 0 6 3 6 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 10v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 10a4 4 0 0 0 -4 4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 18.01v-.01"
  }));
}

var _excluded$iB = ["size", "color", "stroke"];

function IconCurrencyKroneSwedish(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-krone-swedish",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 6v12"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 12c3.5 0 6 -3 6 -6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 12c3.5 0 6 3 6 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 10v8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 10a4 4 0 0 0 -4 4"
  }));
}

var _excluded$iA = ["size", "color", "stroke"];

function IconCurrencyLeu(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-leu",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 18h-7a3 3 0 0 1 -3 -3v-10"
  }));
}

var _excluded$iz = ["size", "color", "stroke"];

function IconCurrencyLira(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-lira",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 5v15a7 7 0 0 0 7 -7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 15l8 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 7l-8 4"
  }));
}

var _excluded$iy = ["size", "color", "stroke"];

function IconCurrencyLitecoin(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iy);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-litecoin",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 19h-8.194a2 2 0 0 1 -1.98 -2.283l1.674 -11.717"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 9l-9 4"
  }));
}

var _excluded$ix = ["size", "color", "stroke"];

function IconCurrencyNaira(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ix);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-naira",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 18v-10.948a1.05 1.05 0 0 1 1.968 -.51l6.064 10.916a1.05 1.05 0 0 0 1.968 -.51v-10.948"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 10h14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 14h14"
  }));
}

var _excluded$iw = ["size", "color", "stroke"];

function IconCurrencyPound(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iw);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-pound",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 18.5a6 6 0 0 1 -5 0a6 6 0 0 0 -5 .5a3 3 0 0 0 2 -2.5v-7.5a4 4 0 0 1 7.45 -2m-2.55 6h-7"
  }));
}

var _excluded$iv = ["size", "color", "stroke"];

function IconCurrencyReal(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iv);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-real",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 6h-4a3 3 0 0 0 0 6h1a3 3 0 0 1 0 6h-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 18v-12h3a3 3 0 1 1 0 6h-3c5.5 0 5 4 6 6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 6v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 20v-2"
  }));
}

var _excluded$iu = ["size", "color", "stroke"];

function IconCurrencyRenminbi(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iu);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-renminbi",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 9v8a2 2 0 1 0 4 0"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 9h-14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 5h-14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 9v4c0 2.5 -.667 4 -2 6"
  }));
}

var _excluded$it = ["size", "color", "stroke"];

function IconCurrencyRipple(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$it);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-ripple",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 7,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 17,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 12h3l2 -2.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 14.5l-2 -2.5"
  }));
}

var _excluded$is = ["size", "color", "stroke"];

function IconCurrencyRiyal(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$is);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-riyal",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 9v2a2 2 0 1 1 -4 0v-1v1a2 2 0 1 1 -4 0v-1v4a2 2 0 1 1 -4 0v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 12.01v-.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M22 10v1a5 5 0 0 1 -5 5"
  }));
}

var _excluded$ir = ["size", "color", "stroke"];

function IconCurrencyRubel(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ir);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-rubel",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 19v-14h6a3 3 0 0 1 0 6h-8"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 15h-8"
  }));
}

var _excluded$iq = ["size", "color", "stroke"];

function IconCurrencyRupee(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$iq);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-rupee",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 5h-11h3a4 4 0 0 1 0 8h-3l6 6"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 9,
    x2: 18,
    y2: 9
  }));
}

var _excluded$ip = ["size", "color", "stroke"];

function IconCurrencyShekel(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ip);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-shekel",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 18v-12h4a4 4 0 0 1 4 4v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 6v12h-4a4 4 0 0 1 -4 -4v-4"
  }));
}

var _excluded$io = ["size", "color", "stroke"];

function IconCurrencyTaka(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$io);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-taka",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 16.5,
    cy: 15.5,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 7a2 2 0 1 1 4 0v9a3 3 0 0 0 6 0v-.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 11h6"
  }));
}

var _excluded$in = ["size", "color", "stroke"];

function IconCurrencyTugrik(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$in);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-tugrik",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 6h10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 6v13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 17l8 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 10l-8 3"
  }));
}

var _excluded$im = ["size", "color", "stroke"];

function IconCurrencyWon(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$im);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-won",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6l3.245 11.358a0.85 .85 0 0 0 1.624 .035l3.131 -9.393l3.131 9.393a0.85 .85 0 0 0 1.624 -.035l3.245 -11.358"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 10h-18"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 14h-18"
  }));
}

var _excluded$il = ["size", "color", "stroke"];

function IconCurrencyYen(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$il);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-yen",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 19v-7l-5 -7m10 0l-5 7"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 17,
    x2: 16,
    y2: 17
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 13,
    x2: 16,
    y2: 13
  }));
}

var _excluded$ik = ["size", "color", "stroke"];

function IconCurrencyZloty(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ik);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency-zloty",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 18h-7l7 -7h-7"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 18v-13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 14.5l6 -3.5"
  }));
}

var _excluded$ij = ["size", "color", "stroke"];

function IconCurrency(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ij);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-currency",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 7
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 4l3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 4l-3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 20l3 -3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 20l-3 -3"
  }));
}

var _excluded$ii = ["size", "color", "stroke"];

function IconCurrentLocationOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ii);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-current-location-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14.685 10.661c-.3 -.6 -.795 -1.086 -1.402 -1.374m-3.397 .584a3 3 0 1 0 4.24 4.245"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.357 6.33a8 8 0 1 0 11.301 11.326m1.642 -2.378a8 8 0 0 0 -10.597 -10.569"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 2v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 20v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 12h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M2 12h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$ih = ["size", "color", "stroke"];

function IconCurrentLocation(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ih);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-current-location",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 12,
    r: 8
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 2,
    x2: 12,
    y2: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 20,
    x2: 12,
    y2: 22
  }), /*#__PURE__*/React.createElement("line", {
    x1: 20,
    y1: 12,
    x2: 22,
    y2: 12
  }), /*#__PURE__*/React.createElement("line", {
    x1: 2,
    y1: 12,
    x2: 4,
    y2: 12
  }));
}

var _excluded$ig = ["size", "color", "stroke"];

function IconCursorOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ig);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cursor-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 4a3 3 0 0 1 3 3v1m0 9a3 3 0 0 1 -3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 4a3 3 0 0 0 -3 3v1m0 4v5a3 3 0 0 0 3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$if = ["size", "color", "stroke"];

function IconCursorText(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$if);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cursor-text",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 12h4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 4a3 3 0 0 1 3 3v10a3 3 0 0 1 -3 3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 4a3 3 0 0 0 -3 3v10a3 3 0 0 0 3 3"
  }));
}

var _excluded$ie = ["size", "color", "stroke"];

function IconCut(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ie);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-cut",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7,
    cy: 17,
    r: 3
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 17,
    r: 3
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9.15,
    y1: 14.85,
    x2: 18,
    y2: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 6,
    y1: 4,
    x2: 14.85,
    y2: 14.85
  }));
}

var _excluded$id = ["size", "color", "stroke"];

function IconDashboard(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$id);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-dashboard",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 13,
    r: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 13.45,
    y1: 11.55,
    x2: 15.5,
    y2: 9.5
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.4 20a9 9 0 1 1 11.2 0z"
  }));
}

var _excluded$ic = ["size", "color", "stroke"];

function IconDatabaseExport(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ic);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-database-export",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("ellipse", {
    cx: 12,
    cy: 6,
    rx: 8,
    ry: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6v6c0 1.657 3.582 3 8 3a19.84 19.84 0 0 0 3.302 -.267m4.698 -2.733v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v6c0 1.599 3.335 2.905 7.538 2.995m8.462 -6.995v-2m-6 7h7m-3 -3l3 3l-3 3"
  }));
}

var _excluded$ib = ["size", "color", "stroke"];

function IconDatabaseImport(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ib);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-database-import",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("ellipse", {
    cx: 12,
    cy: 6,
    rx: 8,
    ry: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6v8m5.009 .783c.924 .14 1.933 .217 2.991 .217c4.418 0 8 -1.343 8 -3v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.252 20.987c.246 .009 .496 .013 .748 .013c4.418 0 8 -1.343 8 -3v-6m-18 7h7m-3 -3l3 3l-3 3"
  }));
}

var _excluded$ia = ["size", "color", "stroke"];

function IconDatabaseOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$ia);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-database-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12.983 8.978c3.955 -.182 7.017 -1.446 7.017 -2.978c0 -1.657 -3.582 -3 -8 -3c-1.661 0 -3.204 .19 -4.483 .515m-2.783 1.228c-.471 .382 -.734 .808 -.734 1.257c0 1.22 1.944 2.271 4.734 2.74"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6v6c0 1.657 3.582 3 8 3c.986 0 1.93 -.067 2.802 -.19m3.187 -.82c1.251 -.53 2.011 -1.228 2.011 -1.99v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v6c0 1.657 3.582 3 8 3c3.217 0 5.991 -.712 7.261 -1.74m.739 -3.26v-4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }));
}

var _excluded$i9 = ["size", "color", "stroke"];

function IconDatabase(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i9);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-database",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("ellipse", {
    cx: 12,
    cy: 6,
    rx: 8,
    ry: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 6v6a8 3 0 0 0 16 0v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 12v6a8 3 0 0 0 16 0v-6"
  }));
}

var _excluded$i8 = ["size", "color", "stroke"];

function IconDentalOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i8);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-dental-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19.277 15.281c.463 -1.75 .723 -3.844 .723 -6.281c0 -3.74 -1.908 -4.994 -4 -5c-1.423 -.004 -2.92 .911 -4 1.5c-1.074 -.586 -2.583 -1.5 -4 -1.5m-2.843 1.153c-.707 .784 -1.157 2.017 -1.157 3.847c0 4.899 1.056 8.41 2.671 10.537c.573 .756 1.97 .521 2.567 -.236c.398 -.505 .819 -1.439 1.262 -2.801c.292 -.771 .892 -1.504 1.5 -1.5c.602 .004 1.21 .737 1.5 1.5c.443 1.362 .864 2.295 1.262 2.8c.597 .759 1.994 .993 2.567 .237c.305 -.402 .59 -.853 .852 -1.353"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 5.5l3 1.5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$i7 = ["size", "color", "stroke"];

function IconDental(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i7);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-dental",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 5.5c-1.074 -.586 -2.583 -1.5 -4 -1.5c-2.1 -.001 -4 1.247 -4 5c0 4.899 1.056 8.41 2.671 10.537c.573 .756 1.97 .521 2.567 -.236c.398 -.505 .819 -1.439 1.262 -2.801c.292 -.771 .892 -1.504 1.5 -1.5c.602 .004 1.21 .737 1.5 1.5c.443 1.362 .864 2.295 1.262 2.8c.597 .759 1.994 .993 2.567 .237c1.615 -2.127 2.671 -5.637 2.671 -10.537c0 -3.74 -1.908 -4.994 -4 -5c-1.423 -.004 -2.92 .911 -4 1.5z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 5.5l3 1.5"
  }));
}

var _excluded$i6 = ["size", "color", "stroke"];

function IconDetails(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i6);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-details",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 3v16"
  }));
}

var _excluded$i5 = ["size", "color", "stroke"];

function IconDeviceAnalytics(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i5);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-analytics",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 4,
    width: 18,
    height: 12,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 20,
    x2: 17,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 16,
    x2: 9,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 16,
    x2: 15,
    y2: 20
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 12l3 -3l2 2l3 -3"
  }));
}

var _excluded$i4 = ["size", "color", "stroke"];

function IconDeviceAudioTape(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i4);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-audio-tape",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 5,
    width: 18,
    height: 14,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 17l4 -3h10l4 3"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 7.5,
    cy: 9.5,
    r: 0.5,
    fill: "currentColor"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 16.5,
    cy: 9.5,
    r: 0.5,
    fill: "currentColor"
  }));
}

var _excluded$i3 = ["size", "color", "stroke"];

function IconDeviceCctv(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i3);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-cctv",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 3,
    width: 18,
    height: 4,
    rx: 1
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 14,
    r: 4
  }), /*#__PURE__*/React.createElement("path", {
    d: "M19 7v7a7 7 0 0 1 -14 0v-7"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 14,
    x2: 12.01,
    y2: 14
  }));
}

var _excluded$i2 = ["size", "color", "stroke"];

function IconDeviceComputerCameraOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i2);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-computer-camera-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6.15 6.153a7 7 0 0 0 9.696 9.696m2 -2a7 7 0 0 0 -9.699 -9.695"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9.13 9.122a3 3 0 0 0 3.743 3.749m2 -2a3 3 0 0 0 -3.737 -3.736"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16l-2.091 3.486a1 1 0 0 0 .857 1.514h10.468a1 1 0 0 0 .857 -1.514l-2.091 -3.486"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }));
}

var _excluded$i1 = ["size", "color", "stroke"];

function IconDeviceComputerCamera(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i1);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-computer-camera",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 10,
    r: 7
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 10,
    r: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 16l-2.091 3.486a1 1 0 0 0 .857 1.514h10.468a1 1 0 0 0 .857 -1.514l-2.091 -3.486"
  }));
}

var _excluded$i0 = ["size", "color", "stroke"];

function IconDeviceDesktopAnalytics(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$i0);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-desktop-analytics",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 4,
    width: 18,
    height: 12,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 20h10"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 16v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 16v4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 12v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 12v-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 12v-1"
  }));
}

var _excluded$h$ = ["size", "color", "stroke"];

function IconDeviceDesktopOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$h$);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-desktop-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M8 4h12a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1m-4 0h-12a1 1 0 0 1 -1 -1v-10a1 1 0 0 1 1 -1"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 20,
    x2: 17,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 16,
    x2: 9,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 16,
    x2: 15,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 3,
    x2: 21,
    y2: 21
  }));
}

var _excluded$h_ = ["size", "color", "stroke"];

function IconDeviceDesktop(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$h_);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-desktop",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 4,
    width: 18,
    height: 12,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 20,
    x2: 17,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 16,
    x2: 9,
    y2: 20
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 16,
    x2: 15,
    y2: 20
  }));
}

var _excluded$hZ = ["size", "color", "stroke"];

function IconDeviceFloppy(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hZ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-floppy",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 14,
    r: 2
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "14 4 14 8 8 8 8 4"
  }));
}

var _excluded$hY = ["size", "color", "stroke"];

function IconDeviceGamepad(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hY);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-gamepad",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 2,
    y: 6,
    width: 20,
    height: 12,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 12h4m-2 -2v4"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 15,
    y1: 11,
    x2: 15,
    y2: 11.01
  }), /*#__PURE__*/React.createElement("line", {
    x1: 18,
    y1: 13,
    x2: 18,
    y2: 13.01
  }));
}

var _excluded$hX = ["size", "color", "stroke"];

function IconDeviceHeartMonitor(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hX);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-heart-monitor",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 4,
    y: 4,
    width: 16,
    height: 16,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 9h6l1 -2l2 4l1 -2h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4 14h16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 17v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v.01"
  }));
}

var _excluded$hW = ["size", "color", "stroke"];

function IconDeviceLaptopOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hW);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-laptop-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 19h16"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 6h8a1 1 0 0 1 1 1v8m-3 1h-10a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$hV = ["size", "color", "stroke"];

function IconDeviceLaptop(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hV);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-laptop",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 3,
    y1: 19,
    x2: 21,
    y2: 19
  }), /*#__PURE__*/React.createElement("rect", {
    x: 5,
    y: 6,
    width: 14,
    height: 10,
    rx: 1
  }));
}

var _excluded$hU = ["size", "color", "stroke"];

function IconDeviceMobileMessage(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hU);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-mobile-message",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 3h10v8h-3l-4 2v-2h-3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 16v4a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-14a1 1 0 0 1 1 -1h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 18v.01"
  }));
}

var _excluded$hT = ["size", "color", "stroke"];

function IconDeviceMobileOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hT);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-mobile-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7.174 3.178c.252 -.114 .531 -.178 .826 -.178h8a2 2 0 0 1 2 2v9m0 4v1a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-13"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 4h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 17v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$hS = ["size", "color", "stroke"];

function IconDeviceMobileRotated(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hS);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-mobile-rotated",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 6,
    width: 18,
    height: 12,
    rx: 2
  }), /*#__PURE__*/React.createElement("path", {
    d: "M20 11v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 12h-.01"
  }));
}

var _excluded$hR = ["size", "color", "stroke"];

function IconDeviceMobileVibration(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hR);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-mobile-vibration",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 3,
    width: 12,
    height: 18,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 8,
    y1: 4,
    x2: 10,
    y2: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 17,
    x2: 9,
    y2: 17.01
  }), /*#__PURE__*/React.createElement("path", {
    d: "M21 6l-2 3l2 3l-2 3l2 3"
  }));
}

var _excluded$hQ = ["size", "color", "stroke"];

function IconDeviceMobile(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hQ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-mobile",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 6,
    y: 3,
    width: 12,
    height: 18,
    rx: 2
  }), /*#__PURE__*/React.createElement("line", {
    x1: 11,
    y1: 4,
    x2: 13,
    y2: 4
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 17,
    x2: 12,
    y2: 17.01
  }));
}

var _excluded$hP = ["size", "color", "stroke"];

function IconDeviceNintendoOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hP);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-nintendo-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M4.713 4.718a3.995 3.995 0 0 0 -1.713 3.282v8a4 4 0 0 0 4 4h3v-10m0 -4v-2h-2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 10v-6h3a4 4 0 0 1 4 4v8c0 .308 -.035 .608 -.1 .896m-1.62 2.39a3.982 3.982 0 0 1 -2.28 .714h-3v-6"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 6.5,
    cy: 8.5,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$hO = ["size", "color", "stroke"];

function IconDeviceNintendo(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hO);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-nintendo",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 20v-16h-3a4 4 0 0 0 -4 4v8a4 4 0 0 0 4 4h3z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 20v-16h3a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-3z"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17.5,
    cy: 15.5,
    r: 1,
    fill: "currentColor"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 6.5,
    cy: 8.5,
    r: 1,
    fill: "currentColor"
  }));
}

var _excluded$hN = ["size", "color", "stroke"];

function IconDeviceSpeakerOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hN);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-speaker-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 3h10a2 2 0 0 1 2 2v10m0 4a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-14"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11.114 11.133a3.001 3.001 0 1 0 3.754 3.751"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 7v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$hM = ["size", "color", "stroke"];

function IconDeviceSpeaker(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hM);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-speaker",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 5,
    y: 3,
    width: 14,
    height: 18,
    rx: 2
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 14,
    r: 3
  }), /*#__PURE__*/React.createElement("line", {
    x1: 12,
    y1: 7,
    x2: 12,
    y2: 7.01
  }));
}

var _excluded$hL = ["size", "color", "stroke"];

function IconDeviceTabletOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hL);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-tablet-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M7 3h11a1 1 0 0 1 1 1v11m0 4v1a1 1 0 0 1 -1 1h-12a1 1 0 0 1 -1 -1v-15"
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 17,
    r: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$hK = ["size", "color", "stroke"];

function IconDeviceTablet(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hK);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-tablet",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 5,
    y: 3,
    width: 14,
    height: 18,
    rx: 1
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 12,
    cy: 17,
    r: 1
  }));
}

var _excluded$hJ = ["size", "color", "stroke"];

function IconDeviceTvOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hJ);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-tv-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M11 7h8a2 2 0 0 1 2 2v8m-1.178 2.824c-.25 .113 -.529 .176 -.822 .176h-14a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 3l-4 4l-4 -4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$hI = ["size", "color", "stroke"];

function IconDeviceTv(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hI);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-tv",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 3,
    y: 7,
    width: 18,
    height: 13,
    rx: 2
  }), /*#__PURE__*/React.createElement("polyline", {
    points: "16 3 12 7 8 3"
  }));
}

var _excluded$hH = ["size", "color", "stroke"];

function IconDeviceWatchOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hH);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-watch-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 6h5a3 3 0 0 1 3 3v5m-.882 3.125a2.99 2.99 0 0 1 -2.118 .875h-6a3 3 0 0 1 -3 -3v-6c0 -.828 .336 -1.578 .878 -2.121"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18v3h6v-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 5v-2h6v3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$hG = ["size", "color", "stroke"];

function IconDeviceWatchStats2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hG);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-watch-stats-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 6,
    y: 6,
    width: 12,
    height: 12,
    rx: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18v3h6v-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 6v-3h6v3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 10a2 2 0 1 0 2 2"
  }));
}

var _excluded$hF = ["size", "color", "stroke"];

function IconDeviceWatchStats(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hF);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-watch-stats",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 6,
    y: 6,
    width: 12,
    height: 12,
    rx: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18v3h6v-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 6v-3h6v3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 14v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 14v-1"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M15 14v-3"
  }));
}

var _excluded$hE = ["size", "color", "stroke"];

function IconDeviceWatch(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hE);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-device-watch",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 6,
    y: 6,
    width: 12,
    height: 12,
    rx: 3
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 18v3h6v-3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 6v-3h6v3"
  }));
}

var _excluded$hD = ["size", "color", "stroke"];

function IconDevices2(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hD);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-devices-2",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M10 15h-6a1 1 0 0 1 -1 -1v-8a1 1 0 0 1 1 -1h6"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 13,
    y: 4,
    width: 8,
    height: 16,
    rx: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 7,
    y1: 19,
    x2: 10,
    y2: 19
  }), /*#__PURE__*/React.createElement("line", {
    x1: 17,
    y1: 8,
    x2: 17,
    y2: 8.01
  }), /*#__PURE__*/React.createElement("circle", {
    cx: 17,
    cy: 16,
    r: 1
  }), /*#__PURE__*/React.createElement("line", {
    x1: 9,
    y1: 15,
    x2: 9,
    y2: 19
  }));
}

var _excluded$hC = ["size", "color", "stroke"];

function IconDevicesOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hC);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-devices-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 9a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v8m-1 3h-6a1 1 0 0 1 -1 -1v-6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 8v-3a1 1 0 0 0 -1 -1h-9m-4 0a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M16 9h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$hB = ["size", "color", "stroke"];

function IconDevicesPcOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hB);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-devices-pc-off",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M9 9v10h-6v-14h2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M13 9h9v7h-2m-4 0h-4v-4"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 19h5"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 17v2"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 13v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 16v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 3l18 18"
  }));
}

var _excluded$hA = ["size", "color", "stroke"];

function IconDevicesPc(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hA);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-devices-pc",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M3 5h6v14h-6z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M12 9h10v7h-10z"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M14 19h6"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M17 16v3"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 13v.01"
  }), /*#__PURE__*/React.createElement("path", {
    d: "M6 16v.01"
  }));
}

var _excluded$hz = ["size", "color", "stroke"];

function IconDevices(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hz);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://www.w3.org/2000/svg",
    className: "icon icon-tabler icon-tabler-devices",
    width: size,
    height: size,
    viewBox: "0 0 24 24",
    strokeWidth: stroke,
    stroke: color,
    fill: "none",
    strokeLinecap: "round",
    strokeLinejoin: "round"
  }, props), /*#__PURE__*/React.createElement("path", {
    stroke: "none",
    d: "M0 0h24v24H0z",
    fill: "none"
  }), /*#__PURE__*/React.createElement("rect", {
    x: 13,
    y: 8,
    width: 8,
    height: 12,
    rx: 1
  }), /*#__PURE__*/React.createElement("path", {
    d: "M18 8v-3a1 1 0 0 0 -1 -1h-13a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h9"
  }), /*#__PURE__*/React.createElement("line", {
    x1: 16,
    y1: 9,
    x2: 18,
    y2: 9
  }));
}

var _excluded$hy = ["size", "color", "stroke"];

function IconDialpadOff(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 24 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? "currentColor" : _ref$color,
      _ref$stroke = _ref.stroke,
      stroke = _ref$stroke === void 0 ? 2 : _ref$stroke,
      props = _objectWithoutProperties(_ref, _excluded$hy);

  return /*#__PURE__*/React.createElement("svg", _extends({
    xmlns: "http://ww